/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.net.SMTPAppender;
import org.apache.log4j.net.SocketAppender;
import org.apache.log4j.net.SyslogAppender;
import org.apache.turbine.services.logging.BaseLogger;
import org.apache.turbine.services.logging.LoggingConfig;
import org.apache.turbine.services.logging.jdbc.JDBCAppender;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public class Log4JavaLogger
extends BaseLogger {
    protected static Hashtable filesTable;
    protected static Appender consoleAppender;
    protected Category logger;
    protected Layout layout;

    public void init(LoggingConfig loggingConfig) {
        this.logger = Category.getInstance((String)loggingConfig.getName());
        this.logger.setAdditivity(false);
        this.logger.setPriority(Priority.DEBUG);
        this.layout = new PatternLayout("%d [%t] %-5p %c - %m%n");
        super.init(loggingConfig);
    }

    protected void configureFiles(LoggingConfig loggingConfig) {
        Vector files = loggingConfig.getFiles();
        Enumeration filesEnum = files.elements();
        while (filesEnum.hasMoreElements()) {
            String path = (String)filesEnum.nextElement();
            String pathTmp = ((ServletContext)loggingConfig.getServletContext()).getRealPath(path);
            if (pathTmp != null) {
                path = pathTmp;
            }
            Appender appender = null;
            appender = (Appender)filesTable.get(path);
            if (appender != null) continue;
            try {
                appender = new RollingFileAppender(this.layout, path, true);
                ((RollingFileAppender)appender).setMaxBackupIndex(loggingConfig.getBackupFiles());
                if (loggingConfig.getFileSize() > -1L) {
                    ((RollingFileAppender)appender).setMaximumFileSize(loggingConfig.getFileSize());
                }
                filesTable.put(path, appender);
            }
            catch (IOException e) {
                return;
            }
            this.logger.addAppender(appender);
        }
    }

    protected void configureConsole(LoggingConfig loggingConfig) {
        this.console = loggingConfig.getConsole();
        if (this.console && consoleAppender != null) {
            this.logger.addAppender(consoleAppender);
        }
    }

    protected void configureRemote(LoggingConfig loggingConfig) {
        String remoteHost = loggingConfig.getRemoteHost();
        int remotePort = loggingConfig.getRemotePort();
        if (remoteHost == null || remoteHost.trim().equals("") || remotePort <= 0) {
            return;
        }
        SocketAppender appender = new SocketAppender(remoteHost, remotePort);
        this.logger.addAppender((Appender)appender);
    }

    protected void configureSyslog(LoggingConfig loggingConfig) {
        String syslogHost = loggingConfig.getSyslogHost();
        if (syslogHost == null || syslogHost.trim().equals("")) {
            return;
        }
        SyslogAppender appender = new SyslogAppender(this.layout, syslogHost, this.logLevel);
        this.logger.addAppender((Appender)appender);
    }

    protected void configureEmail(LoggingConfig loggingConfig) {
        String smtpHost = TurbineResources.getString("mail.server");
        String emailFrom = loggingConfig.getEmailFrom();
        String emailTo = loggingConfig.getEmailTo();
        String emailSubject = loggingConfig.getEmailSubject();
        String bufferSize = loggingConfig.getEmailBufferSize();
        if (smtpHost == null || smtpHost.trim().equals("") || emailFrom == null || smtpHost.trim().equals("") || emailTo == null || emailTo.trim().equals("") || emailSubject == null || emailSubject.trim().equals("") || bufferSize == null || bufferSize.trim().equals("")) {
            return;
        }
        SMTPAppender appender = new SMTPAppender();
        appender.setSMTPHost(smtpHost);
        appender.setFrom(emailFrom);
        appender.setTo(emailTo);
        appender.setSubject(emailSubject);
        appender.setBufferSize(new Integer(bufferSize).intValue());
        appender.setLayout(this.layout);
        appender.activateOptions();
        this.logger.addAppender((Appender)appender);
    }

    protected void configureDatabase(LoggingConfig loggingConfig) {
        String dbLogger = loggingConfig.getDbLogger();
        String dbPool = loggingConfig.getDbPool();
        if (dbLogger == null || dbLogger.trim().equals("")) {
            return;
        }
        JDBCAppender appender = new JDBCAppender();
        appender.setOption("logger.class", dbLogger);
        appender.setLayout(this.layout);
        appender.activateOptions();
        this.logger.addAppender((Appender)appender);
    }

    public boolean checkLogger() {
        Enumeration enumeration = this.logger.getAllAppenders();
        return enumeration.hasMoreElements();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void shutdown() {
        Enumeration appenders = this.logger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            appender.close();
        }
    }

    public void debug(String message) {
        this.log(1, message, null, null);
    }

    public void debug(String message, Throwable t) {
        this.log(1, message, null, t);
    }

    public void debug(String message, RunData data) {
        this.log(1, message, data, null);
    }

    public void debug(String message, RunData data, Throwable t) {
        this.log(1, message, data, t);
    }

    public void info(String message) {
        this.log(2, message, null, null);
    }

    public void info(String message, Throwable t) {
        this.log(2, message, null, t);
    }

    public void info(String message, RunData data) {
        this.log(2, message, data, null);
    }

    public void info(String message, RunData data, Throwable t) {
        this.log(2, message, data, t);
    }

    public void warn(String message) {
        this.log(3, message, null, null);
    }

    public void warn(String message, Throwable t) {
        this.log(3, message, null, t);
    }

    public void warn(String message, RunData data) {
        this.log(3, message, data, null);
    }

    public void warn(String message, RunData data, Throwable t) {
        this.log(3, message, data, t);
    }

    public void error(String message) {
        this.log(4, message, null, null);
    }

    public void error(String message, Throwable e) {
        this.log(4, message, null, e);
    }

    public void error(Throwable e) {
        this.log(4, null, null, e);
    }

    public void error(String message, RunData data) {
        this.log(4, message, data, null);
    }

    public void error(String message, RunData data, Throwable e) {
        this.log(4, message, data, e);
    }

    private void log(int level, String message, RunData data, Throwable e) {
        if (level < this.logLevel) {
            return;
        }
        if (data != null) {
            message = message + this.runDataFilter.getString(data);
        }
        switch (level) {
            case 1: {
                this.logger.debug((Object)message, e);
                break;
            }
            case 2: {
                this.logger.info((Object)message, e);
                break;
            }
            case 3: {
                this.logger.warn((Object)message, e);
                break;
            }
            case 4: {
                this.logger.error((Object)message, e);
                break;
            }
            default: {
                this.logger.debug((Object)message, e);
            }
        }
    }

    static {
        consoleAppender = null;
        filesTable = new Hashtable();
        consoleAppender = new WriterAppender((Layout)new PatternLayout("%d [%t] %-5p %c - %m%n"), (OutputStream)System.out);
    }
}

