/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.logging;

import java.util.Iterator;
import java.util.Vector;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.logging.LoggingConfig;
import org.apache.turbine.services.resources.ResourceService;

public class PropertiesLoggingConfig
implements LoggingConfig {
    private String name = null;
    private Object context = null;
    private Vector files = null;
    private String syslogHost = null;
    private String syslogFacility = null;
    private String remoteHost = null;
    private int remotePort = -1;
    private String emailTo = null;
    private String emailSubject = null;
    private String emailFrom = null;
    private String emailBufferSize = null;
    private String dbLogger = null;
    private String dbPool = null;
    private String className = null;
    private String level = null;
    private String format = null;
    private boolean console = false;
    private long fileSize = -1L;
    private int backupFiles = 1;
    private ResourceService props = null;

    public void setInitResource(Object props) {
        this.props = (ResourceService)props;
    }

    public void init() throws InitializationException {
        if (this.props == null) {
            return;
        }
        ResourceService res = this.props.getResources(this.name);
        Iterator keys = res.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.equals("className")) {
                this.setClassName(res.getString(key));
                continue;
            }
            if (key.equals("level")) {
                this.setLevel(res.getString(key));
                continue;
            }
            if (key.equals("file.size")) {
                this.setFileSize(res.getLong(key));
                continue;
            }
            if (key.equals("file.backups")) {
                this.setBackupFiles(res.getInt(key));
                continue;
            }
            if (key.equals("format")) {
                this.setFormat(res.getString(key));
                continue;
            }
            if (key.indexOf("destination") <= -1) continue;
            if (key.indexOf("file") > -1) {
                this.files = res.getVector(key);
                continue;
            }
            if (key.indexOf("remote") > -1) {
                if (key.indexOf("host") > -1) {
                    this.setRemoteHost(res.getString(key));
                    continue;
                }
                if (key.indexOf("port") <= -1) continue;
                this.setRemotePort(res.getInt(key));
                continue;
            }
            if (key.indexOf("console") > -1) {
                this.setConsole(res.getBoolean(key));
                continue;
            }
            if (key.indexOf("syslogd") > -1) {
                if (key.indexOf("host") > -1) {
                    this.setSyslogHost(res.getString(key));
                    continue;
                }
                if (key.indexOf("facility") <= -1) continue;
                this.setSyslogFacility(res.getString(key));
                continue;
            }
            if (key.indexOf("email") > -1) {
                if (key.indexOf("from") > -1) {
                    this.setEmailFrom(res.getString(key));
                    continue;
                }
                if (key.indexOf("to") > -1) {
                    this.setEmailTo(res.getString(key));
                    continue;
                }
                if (key.indexOf("subject") > -1) {
                    this.setEmailSubject(res.getString(key));
                    continue;
                }
                if (key.indexOf("buffer.size") <= -1) continue;
                this.setEmailBufferSize(res.getString(key));
                continue;
            }
            if (key.indexOf("database") <= -1) continue;
            if (key.indexOf("logger") > -1) {
                this.setDbLogger(res.getString(key));
                continue;
            }
            if (key.indexOf("pool") <= -1) continue;
            this.setDbPool(res.getString(key));
        }
    }

    public Object getServletContext() {
        return this.context;
    }

    public void setServletContext(Object value) {
        this.context = value;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String value) {
        this.remoteHost = value;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int value) {
        this.remotePort = value;
    }

    public int getBackupFiles() {
        return this.backupFiles;
    }

    public void setBackupFiles(int value) {
        this.backupFiles = value;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long value) {
        this.fileSize = value;
    }

    public Vector getFiles() {
        return this.files;
    }

    public void setFiles(Vector value) {
        this.files = value;
    }

    public boolean getConsole() {
        return this.console;
    }

    public void setConsole(boolean value) {
        this.console = value;
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public void setSyslogHost(String syslogHost) {
        this.syslogHost = syslogHost;
    }

    public String getSyslogFacility() {
        return this.syslogFacility;
    }

    public void setSyslogFacility(String syslogFacility) {
        this.syslogFacility = syslogFacility;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    public String getEmailTo() {
        return this.emailTo;
    }

    public void setEmailTo(String emailTo) {
        this.emailTo = emailTo;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public String getEmailBufferSize() {
        return this.emailBufferSize;
    }

    public void setEmailBufferSize(String bufferSize) {
        this.emailBufferSize = bufferSize;
    }

    public void setDbLogger(String v) {
        this.dbLogger = v;
    }

    public String getDbLogger() {
        return this.dbLogger;
    }

    public void setDbPool(String v) {
        this.dbPool = v;
    }

    public String getDbPool() {
        return this.dbPool;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    protected PropertiesLoggingConfig() {
    }
}

