/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Iterator;
import java.util.Vector;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.Filter;
import org.chefproject.core.Message;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.ToolConfigurationEdit;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.PortalService;
import org.chefproject.service.generic.GenericAnnouncementService;
import org.chefproject.service.generic.GenericChatService;
import org.chefproject.service.generic.GenericDiscussionService;
import org.chefproject.service.generic.GenericMessageService;
import org.chefproject.util.EventObservingCourier;
import org.chefproject.util.Menu;
import org.chefproject.util.Reference;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;

public class SynopticMessageAction
extends VelocityPortletPaneledAction {
    private static final String PARAM_CHANNEL = "channel";
    private static final String PARAM_DAYS = "days";
    private static final String PARAM_ITEMS = "items";
    private static final String PARAM_LENGTH = "length";
    private static final String PARAM_SHOW_SUBJECT = "show-subject";
    private static final String PARAM_SERVICE = "message-service";
    private static final String FORM_CHANNEL = "channel";
    private static final String FORM_DAYS = "days";
    private static final String FORM_ITEMS = "items";
    private static final String FORM_LENGTH = "length";
    private static final String FORM_SHOW_SUBJECT = "show-subject";
    private static final String FORM_MESSAGE = "message";
    private static final String STATE_CHANNEL_REF = "channelId";
    private static final String STATE_ERROR = "error";
    private static final String STATE_SERVICE = "service";
    private static final String STATE_SERVICE_NAME = "service-name";
    private static final String STATE_UPDATE = "update";
    private static final String STATE_CHANNEL_PROBLEM = "channel-problem";
    private static final String STATE_DAYS = "days";
    private static final String STATE_ITEMS = "items";
    private static final String STATE_LENGTH = "length";
    private static final String STATE_SHOW_SUBJECT = "show-subject";
    private static final String STATE_SUBJECT_OPTION = "allow-option-of-showing-subject";
    private static final String CHANNEL_PERMISSION = "You do not have permission to view these messages.";

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        if (state.getAttribute(STATE_CHANNEL_REF) == null) {
            String channel;
            PortletConfig config = portlet.getPortletConfig();
            GenericMessageService service = (GenericMessageService)state.getAttribute(STATE_SERVICE);
            if (service == null) {
                String serviceName = config.getInitParameter(PARAM_SERVICE);
                state.setAttribute(STATE_SERVICE_NAME, (Object)serviceName);
                service = (GenericMessageService)((Object)TurbineServices.getInstance().getService(serviceName));
                state.setAttribute(STATE_SERVICE, (Object)service);
            }
            if ((channel = StringUtil.trimToNull(config.getInitParameter("channel"))) == null) {
                channel = service.channelReference(PortalService.getCurrentSiteId(), "main");
            }
            state.setAttribute(STATE_CHANNEL_REF, (Object)channel);
            if (state.getAttribute("days") == null) {
                try {
                    state.setAttribute("days", (Object)new Integer(config.getInitParameter("days")));
                }
                catch (Exception e) {
                    state.setAttribute("days", (Object)new Integer(10));
                }
            }
            if (state.getAttribute("items") == null) {
                try {
                    state.setAttribute("items", (Object)new Integer(config.getInitParameter("items")));
                }
                catch (Exception e) {
                    state.setAttribute("items", (Object)new Integer(3));
                }
            }
            if (state.getAttribute("length") == null) {
                try {
                    state.setAttribute("length", (Object)new Integer(config.getInitParameter("length")));
                }
                catch (Exception e) {
                    state.setAttribute("length", (Object)new Integer(50));
                }
            }
            if (state.getAttribute("show-subject") == null) {
                try {
                    state.setAttribute("show-subject", (Object)new Boolean(config.getInitParameter("show-subject")));
                }
                catch (Exception e) {
                    state.setAttribute("show-subject", (Object)new Boolean(false));
                }
            }
            if (state.getAttribute("obsever") == null) {
                String deliveryId = this.clientWindowId(state, portlet.getID());
                String elementId = VelocityPortletPaneledAction.mainPanelUpdateId(portlet.getID());
                Reference r = new Reference(channel);
                String pattern = service.messageReference(r.getContext(), r.getId(), "");
                state.setAttribute("obsever", (Object)new EventObservingCourier(deliveryId, elementId, pattern));
            }
        }
        this.updateObservationOfChannel(state, portlet.getID());
    }

    private void updateObservationOfChannel(SessionState state, String peid) {
        EventObservingCourier observer = (EventObservingCourier)state.getAttribute("obsever");
        GenericMessageService service = (GenericMessageService)state.getAttribute(STATE_SERVICE);
        String channel = (String)state.getAttribute(STATE_CHANNEL_REF);
        Reference r = new Reference(channel);
        String pattern = service.messageReference(r.getContext(), r.getId(), "");
        observer.setResourcePattern(pattern);
        String deliveryId = this.clientWindowId(state, peid);
        observer.setDeliveryId(deliveryId);
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        if ("options".equals(state.getAttribute("mode"))) {
            return this.buildOptionsPanelContext(portlet, context, rundata, state);
        }
        Menu bar = new Menu((Portlet)portlet, rundata, (String)state.getAttribute("action"));
        this.addOptionsMenu(bar, (JetspeedRunData)rundata);
        if (bar.getItems().hasNext()) {
            context.put("menu", bar);
        }
        context.put("action", state.getAttribute("action"));
        context.put("length", state.getAttribute("length"));
        context.put("showSubject", state.getAttribute("show-subject"));
        try {
            int days = (Integer)state.getAttribute("days");
            int items = (Integer)state.getAttribute("items");
            MessageChannel channel = ((GenericMessageService)state.getAttribute(STATE_SERVICE)).getChannel((String)state.getAttribute(STATE_CHANNEL_REF));
            context.put("messages", channel.getMessages(new SynopticMessageFilter(days, items), false));
        }
        catch (PermissionException e) {
            this.addAlert(state, CHANNEL_PERMISSION);
        }
        catch (IdUnusedException e) {
            // empty catch block
        }
        ((EventObservingCourier)state.getAttribute("obsever")).justDelivered();
        return (String)this.getContext(rundata).get("template") + "-List";
    }

    public String buildOptionsPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String serviceName = (String)state.getAttribute(STATE_SERVICE_NAME);
        String tool_title = "Recent Items";
        String tool_name = "Recent Items";
        String one_item = FORM_MESSAGE;
        String all_items = "messages";
        String channel_analog = "channel";
        Boolean allow_show_subject = new Boolean(true);
        Boolean allow_channel_choice = new Boolean(false);
        if (serviceName.equals(GenericChatService.SERVICE_NAME)) {
            tool_title = "Recent Chat";
            tool_name = "Chat";
            one_item = "chat message";
            all_items = "chat messages";
            channel_analog = "Chat Room";
            allow_show_subject = new Boolean(false);
            allow_channel_choice = new Boolean(true);
        } else if (serviceName.equals(GenericDiscussionService.SERVICE_NAME)) {
            tool_title = "Recent Discussions";
            tool_name = "Discussion";
            one_item = "reply";
            all_items = "Discussion replies";
        } else if (serviceName.equals(GenericAnnouncementService.SERVICE_NAME)) {
            tool_title = "Recent Announcements";
            tool_name = "Announcement";
            one_item = "announcement";
            all_items = "announcements";
        }
        context.put("tool_title", tool_title);
        context.put("tool_name", tool_name);
        context.put("one_item", one_item);
        context.put("all_items", all_items);
        context.put("allow_show_subject", allow_show_subject.toString());
        if (allow_show_subject.booleanValue()) {
            context.put("showSubject", ((Boolean)state.getAttribute("show-subject")).toString());
        }
        context.put("allow_channel_choice", allow_channel_choice.toString());
        if (allow_channel_choice.booleanValue()) {
            context.put("channel_analog", channel_analog);
            context.put("default_channel", "main");
            String siteID = PortalService.getCurrentSiteId();
            String defaultChannel = ((GenericMessageService)state.getAttribute(STATE_SERVICE)).channelReference(siteID, "main");
            String sitePrefix = defaultChannel.substring(0, defaultChannel.lastIndexOf("main"));
            String currentChannel = ((String)state.getAttribute(STATE_CHANNEL_REF)).substring(sitePrefix.length());
            context.put("channel", currentChannel);
            Iterator aChannel = ((GenericMessageService)state.getAttribute(STATE_SERVICE)).getChannels().iterator();
            Vector<String> channel_list = new Vector<String>();
            while (aChannel.hasNext()) {
                MessageChannel theChannel = (MessageChannel)aChannel.next();
                if (!theChannel.getContext().equals(siteID) || theChannel.getId().equals("main")) continue;
                channel_list.add(theChannel.getId());
            }
            context.put("channels", channel_list);
        }
        context.put("days", ((Integer)state.getAttribute("days")).toString());
        context.put("items", ((Integer)state.getAttribute("items")).toString());
        context.put("length", ((Integer)state.getAttribute("length")).toString());
        context.put("channel_form", "channel");
        context.put("days_form", "days");
        context.put("items_form", "items");
        context.put("length_form", "length");
        context.put("show_subject_form", "show-subject");
        context.put("action", state.getAttribute("action"));
        context.put("form-submit", "eventSubmit_doUpdate");
        context.put("form-cancel", "eventSubmit_doCancel");
        String template = (String)this.getContext(rundata).get("template");
        return template + "-customize";
    }

    public void doUpdate(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        String serviceName = (String)state.getAttribute(STATE_SERVICE_NAME);
        boolean allow_show_subject = true;
        boolean allow_channel_choice = false;
        if (serviceName.equals(GenericChatService.SERVICE_NAME)) {
            allow_show_subject = false;
            allow_channel_choice = true;
        }
        if (allow_show_subject) {
            String showSubject = data.getParameters().getString("show-subject");
            try {
                Boolean ss = new Boolean(showSubject);
                if (!ss.equals((Boolean)state.getAttribute("show-subject"))) {
                    state.setAttribute("show-subject", (Object)ss);
                    state.setAttribute(STATE_UPDATE, (Object)STATE_UPDATE);
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (allow_channel_choice) {
            String siteID = PortalService.getCurrentSiteId();
            String newChannel = data.getParameters().getString("channel");
            String currentChannel = ((String)state.getAttribute(STATE_CHANNEL_REF)).substring(siteID.length() + 1);
            if (newChannel != null && !newChannel.equals(currentChannel)) {
                String channel_ref = ((GenericMessageService)state.getAttribute(STATE_SERVICE)).channelReference(siteID, newChannel);
                state.setAttribute(STATE_CHANNEL_REF, (Object)channel_ref);
                if (Log.getLogger("chef").isDebugEnabled()) {
                    Log.debug("chef", (Object)((Object)this) + ".doUpdate(): newChannel: " + channel_ref);
                }
                this.updateObservationOfChannel(state, peid);
            }
        }
        String daysValue = data.getParameters().getString("days");
        try {
            Integer days = new Integer(daysValue);
            if (!days.equals((Integer)state.getAttribute("days"))) {
                state.setAttribute("days", (Object)days);
                state.setAttribute(STATE_UPDATE, (Object)STATE_UPDATE);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        String itemsValue = data.getParameters().getString("items");
        try {
            Integer items = new Integer(itemsValue);
            if (!items.equals((Integer)state.getAttribute("items"))) {
                state.setAttribute("items", (Object)items);
                state.setAttribute(STATE_UPDATE, (Object)STATE_UPDATE);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        String lengthValue = data.getParameters().getString("length");
        try {
            Integer length = new Integer(lengthValue);
            if (!length.equals((Integer)state.getAttribute("length"))) {
                state.setAttribute("length", (Object)length);
                state.setAttribute(STATE_UPDATE, (Object)STATE_UPDATE);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        ToolConfigurationEdit tool = (ToolConfigurationEdit)state.getAttribute("tool");
        tool.getPropertiesEdit().addProperty("channel", (String)state.getAttribute(STATE_CHANNEL_REF));
        tool.getPropertiesEdit().addProperty("days", ((Integer)state.getAttribute("days")).toString());
        tool.getPropertiesEdit().addProperty("items", ((Integer)state.getAttribute("items")).toString());
        tool.getPropertiesEdit().addProperty("length", ((Integer)state.getAttribute("length")).toString());
        tool.getPropertiesEdit().addProperty("show-subject", ((Boolean)state.getAttribute("show-subject")).toString());
        this.saveOptions();
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    public void doCancel(RunData data, Context context) {
        String peid = ((JetspeedRunData)data).getJs_peid();
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(peid);
        state.removeAttribute("mode");
        this.cancelOptions();
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    protected boolean requireResetToolLink() {
        return false;
    }

    static {
        PARAM_CHANNEL = "channel";
        PARAM_DAYS = "days";
        PARAM_ITEMS = "items";
        PARAM_LENGTH = "length";
        PARAM_SHOW_SUBJECT = "show-subject";
        PARAM_SERVICE = PARAM_SERVICE;
        FORM_CHANNEL = "channel";
        FORM_DAYS = "days";
        FORM_ITEMS = "items";
        FORM_LENGTH = "length";
        FORM_SHOW_SUBJECT = "show-subject";
        FORM_MESSAGE = FORM_MESSAGE;
        STATE_CHANNEL_REF = STATE_CHANNEL_REF;
        STATE_ERROR = STATE_ERROR;
        STATE_SERVICE = STATE_SERVICE;
        STATE_SERVICE_NAME = STATE_SERVICE_NAME;
        STATE_UPDATE = STATE_UPDATE;
        STATE_CHANNEL_PROBLEM = STATE_CHANNEL_PROBLEM;
        STATE_DAYS = "days";
        STATE_ITEMS = "items";
        STATE_LENGTH = "length";
        STATE_SHOW_SUBJECT = "show-subject";
        STATE_SUBJECT_OPTION = STATE_SUBJECT_OPTION;
        CHANNEL_PERMISSION = CHANNEL_PERMISSION;
    }

    private class SynopticMessageFilter
    implements Filter {
        private int m_days = 0;
        private int m_items = 0;
        private int m_itemsAccepted = 0;
        private Time m_cutoff = null;

        public SynopticMessageFilter(int days, int items) {
            this.m_days = days;
            this.m_items = items;
            this.m_cutoff = new Time(System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L);
        }

        public boolean accept(Object o) {
            if (this.m_itemsAccepted >= this.m_items) {
                return false;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            if (((Message)o).getHeader().getDate().before(this.m_cutoff)) {
                return false;
            }
            ++this.m_itemsAccepted;
            return true;
        }
    }
}

