/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.xerces.utils.Base64;
import org.chefproject.core.ContentCollection;
import org.chefproject.core.ContentCollectionEdit;
import org.chefproject.core.ContentResource;
import org.chefproject.core.ContentResourceEdit;
import org.chefproject.core.Edit;
import org.chefproject.core.Event;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.core.component.BaseResourcePropertiesEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.InconsistentException;
import org.chefproject.exception.OverQuotaException;
import org.chefproject.exception.PermissionException;
import org.chefproject.exception.TypeException;
import org.chefproject.service.ContentTypeImageService;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.IdService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericContentHostingService;
import org.chefproject.util.Cache;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.Different;
import org.chefproject.util.Reference;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Time;
import org.chefproject.util.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseContentService
extends TurbineBaseService
implements GenericContentHostingService,
CacheRefresher {
    protected static final String ATTACHMENTS_COLLECTION = "/attachment/";
    protected String m_accessPoint = null;
    protected String m_relativeAccessPoint = null;
    protected Storage m_storage = null;
    protected Cache m_cache = null;
    protected ContentTypeImageService m_contentTypeService = null;
    protected long m_siteQuota = 0L;

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        this.m_siteQuota = Long.parseLong(this.getProperties().getProperty("site-quota", "0"));
        Log.info("chef", this + ".init(ServletConfig): site-quota: " + this.m_siteQuota);
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        this.m_relativeAccessPoint = "/content";
        this.m_accessPoint = ServerConfigurationService.getAccessUrl() + this.m_relativeAccessPoint;
        Log.info("chef", this + ".init(RunData): access point: " + this.m_accessPoint);
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
        this.m_contentTypeService = (ContentTypeImageService)((Object)TurbineServices.getInstance().getService(ContentTypeImageService.SERVICE_NAME));
        if (this.m_contentTypeService == null) {
            throw new InitializationException("BaseContentService is missing service: " + ContentTypeImageService.SERVICE_NAME);
        }
        this.m_storage = this.newStorage();
        this.m_storage.open();
        this.m_cache = new Cache((CacheRefresher)this, this.getAccessPoint(true));
    }

    public void shutdown() {
        this.m_storage.close();
        this.m_storage = null;
        this.m_cache.clear();
        this.m_cache = null;
        this.m_contentTypeService = null;
        super.shutdown();
        Log.info("chef", this + ".shutdown()");
    }

    protected abstract Storage newStorage();

    protected String getAccessPoint(boolean relative) {
        return relative ? this.m_relativeAccessPoint : this.m_accessPoint;
    }

    protected boolean unlockCheck(String lock, String id) {
        String ref = null;
        if (id != null) {
            ref = this.getReference(id);
        }
        return SecurityService.unlock(lock, ref);
    }

    protected void unlock(String lock, String id) throws PermissionException {
        String ref = null;
        if (id != null) {
            ref = this.getReference(id);
        }
        if (!SecurityService.unlock(lock, ref)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), lock, ref);
        }
    }

    protected void addLiveCollectionProperties(ContentCollectionEdit c) {
        ResourcePropertiesEdit p = c.getPropertiesEdit();
        String current = UsageSessionService.getSessionUser().getId();
        p.addProperty("CHEF:creator", current);
        p.addProperty("CHEF:modifiedby", current);
        String now = new Time().toString();
        p.addProperty("DAV:creationdate", now);
        p.addProperty("DAV:getlastmodified", now);
        p.addProperty("CHEF:is-collection", "true");
    }

    protected void addLiveUpdateCollectionProperties(ContentCollectionEdit c) {
        ResourcePropertiesEdit p = c.getPropertiesEdit();
        String current = UsageSessionService.getSessionUser().getId();
        p.addProperty("CHEF:modifiedby", current);
        String now = new Time().toString();
        p.addProperty("DAV:getlastmodified", now);
    }

    protected void addLiveResourceProperties(ContentResourceEdit r) {
        ResourcePropertiesEdit p = r.getPropertiesEdit();
        String current = UsageSessionService.getSessionUser().getId();
        p.addProperty("CHEF:creator", current);
        p.addProperty("CHEF:modifiedby", current);
        String now = new Time().toString();
        p.addProperty("DAV:creationdate", now);
        p.addProperty("DAV:getlastmodified", now);
        p.addProperty("DAV:getcontentlength", Long.toString(r.getContentLength()));
        p.addProperty("DAV:getcontenttype", r.getContentType());
        p.addProperty("CHEF:is-collection", "false");
    }

    protected void addLiveUpdateResourceProperties(ContentResourceEdit r) {
        ResourcePropertiesEdit p = r.getPropertiesEdit();
        String current = UsageSessionService.getSessionUser().getId();
        p.addProperty("CHEF:modifiedby", current);
        String now = new Time().toString();
        p.addProperty("DAV:getlastmodified", now);
        p.addProperty("DAV:getcontentlength", Long.toString(r.getContentLength()));
        p.addProperty("DAV:getcontenttype", r.getContentType());
    }

    protected void addProperties(ResourcePropertiesEdit p, ResourceProperties props) {
        if (props == null) {
            return;
        }
        Iterator it = props.getPropertyNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (props.isLiveProperty(name)) continue;
            p.addProperty(name, props.getProperty(name));
        }
    }

    public boolean allowAddCollection(String id) {
        if (!id.endsWith("/")) {
            id = id + "/";
        }
        return this.unlockCheck("content.new", id);
    }

    public ContentCollection addCollection(String id, ResourceProperties properties) throws IdUsedException, IdInvalidException, PermissionException, InconsistentException {
        ContentCollectionEdit edit = this.addCollection(id);
        this.addProperties(edit.getPropertiesEdit(), properties);
        this.commitCollection(edit);
        return edit;
    }

    public ContentCollectionEdit addCollection(String id) throws IdUsedException, IdInvalidException, PermissionException, InconsistentException {
        String justName = this.isolateName(id);
        Validator.checkResourceId(justName);
        if (!id.endsWith("/")) {
            id = id + "/";
        }
        this.unlock("content.new", id);
        String container = this.isolateContainingId(id);
        ContentCollection containingCollection = this.m_storage.getCollection(container);
        if (containingCollection == null) {
            throw new InconsistentException(id);
        }
        BaseCollectionEdit edit = (BaseCollectionEdit)this.m_storage.putCollection(id);
        if (edit == null) {
            throw new IdUsedException(id);
        }
        this.addLiveCollectionProperties(edit);
        edit.setEvent("content.new");
        return edit;
    }

    public ContentCollection mergeCollection(Element element) throws PermissionException {
        BaseCollectionEdit collectionFromXml = new BaseCollectionEdit(element);
        String id = collectionFromXml.getId();
        this.unlock("content.new", id);
        BaseCollectionEdit collection = (BaseCollectionEdit)this.m_storage.putCollection(id);
        if (collection == null) {
            return null;
        }
        collection.set(collectionFromXml);
        collection.setEvent("content.new");
        this.commitCollection(collection);
        return collection;
    }

    public boolean allowGetCollection(String id) {
        return this.unlockCheck("content.read", id);
    }

    public void checkCollection(String id) throws IdUnusedException, TypeException, PermissionException {
        this.unlock("content.read", id);
        ContentCollection collection = this.findCollection(id);
        if (collection == null) {
            throw new IdUnusedException(id);
        }
    }

    public ContentCollection getCollection(String id) throws IdUnusedException, TypeException, PermissionException {
        this.unlock("content.read", id);
        ContentCollection collection = this.findCollection(id);
        if (collection == null) {
            throw new IdUnusedException(id);
        }
        EventTrackingService.post(EventTrackingService.newEvent("content.read", collection.getReference(), false));
        return collection;
    }

    protected ContentCollection findCollection(String id) throws TypeException {
        ContentCollection collection = null;
        String key = this.getReference(id);
        if (this.m_cache.containsKey(key)) {
            Object o = this.m_cache.get(key);
            if (o != null && !(o instanceof ContentCollection)) {
                throw new TypeException(id);
            }
            collection = (ContentCollection)o;
        } else {
            collection = this.m_storage.getCollection(id);
            this.m_cache.put(key, collection);
        }
        return collection;
    }

    public boolean allowUpdateCollection(String id) {
        return this.unlockCheck("content.revise", id);
    }

    public ContentCollectionEdit editCollection(String id) throws IdUnusedException, TypeException, PermissionException, InUseException {
        String ref = this.getReference(id);
        this.unlock("content.revise", id);
        if (this.m_cache.get(ref) == null && !this.m_storage.checkCollection(id)) {
            throw new IdUnusedException(id);
        }
        BaseCollectionEdit collection = (BaseCollectionEdit)this.m_storage.editCollection(id);
        if (collection == null) {
            throw new InUseException(id);
        }
        collection.setEvent("content.revise");
        return collection;
    }

    public boolean allowRemoveCollection(String id) {
        return this.unlockCheck("content.delete", id);
    }

    public void removeCollection(ContentCollectionEdit edit) throws TypeException, PermissionException, InconsistentException {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".removeCollection(): closed ContentCollectionEdit", (Throwable)e);
                return;
            }
        }
        this.unlock("content.delete", edit.getId());
        List members = edit.getMemberResources();
        if (!members.isEmpty()) {
            throw new InconsistentException(edit.getId());
        }
        this.m_storage.removeCollection(edit);
        EventTrackingService.post(EventTrackingService.newEvent("content.delete", edit.getReference(), true));
        ((BaseCollectionEdit)edit).closeEdit();
        ((BaseCollectionEdit)edit).setRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollection(String id) throws IdUnusedException, TypeException, PermissionException, InUseException {
        this.unlock("content.delete", id);
        ContentCollection thisCollection = this.findCollection(id);
        if (thisCollection == null) {
            throw new IdUnusedException(id);
        }
        ContentCollectionEdit edit = this.editCollection(id);
        try {
            try {
                ((BaseCollectionEdit)edit).clear();
                this.removeCollection(edit);
            }
            catch (InconsistentException e) {
                Log.warn("chef", this + ".removeCollection():", (Throwable)e);
                Object var6_5 = null;
                if (((BaseCollectionEdit)edit).isActiveEdit()) {
                    this.cancelCollection(edit);
                }
            }
            Object var6_4 = null;
            if (((BaseCollectionEdit)edit).isActiveEdit()) {
                this.cancelCollection(edit);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (((BaseCollectionEdit)edit).isActiveEdit()) {
                this.cancelCollection(edit);
            }
            throw throwable;
        }
    }

    public void commitCollection(ContentCollectionEdit edit) {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitCollection(): closed ContentCollectionEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateCollectionProperties(edit);
        this.m_storage.commitCollection(edit);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseCollectionEdit)edit).getEvent(), edit.getReference(), true));
        ((BaseCollectionEdit)edit).closeEdit();
    }

    public void cancelCollection(ContentCollectionEdit edit) {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelCollection(): closed ContentCollectionEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.cancelCollection(edit);
        ((BaseCollectionEdit)edit).closeEdit();
    }

    public boolean allowAddResource(String id) {
        if (id.endsWith("/")) {
            id = id.substring(0, id.length() - 1);
        }
        return this.unlockCheck("content.new", id);
    }

    public ContentResource addResource(String id, String type, byte[] content, ResourceProperties properties) throws PermissionException, IdUsedException, IdInvalidException, InconsistentException, OverQuotaException {
        ContentResourceEdit edit = this.addResource(id);
        edit.setContentType(type);
        edit.setContent(content);
        this.addProperties(edit.getPropertiesEdit(), properties);
        this.commitResource(edit);
        return edit;
    }

    public ContentResourceEdit addResource(String id) throws PermissionException, IdUsedException, IdInvalidException, InconsistentException {
        String justName = this.isolateName(id);
        Validator.checkResourceId(justName);
        if (id.endsWith("/")) {
            id = id.substring(0, id.length() - 1);
        }
        this.unlock("content.new", id);
        String container = this.isolateContainingId(id);
        ContentCollection containingCollection = this.m_storage.getCollection(container);
        if (containingCollection == null) {
            throw new InconsistentException(id);
        }
        BaseResourceEdit edit = (BaseResourceEdit)this.m_storage.putResource(id);
        if (edit == null) {
            throw new IdUsedException(id);
        }
        this.addLiveResourceProperties(edit);
        edit.setEvent("content.new");
        return edit;
    }

    public ContentResource mergeResource(Element element) throws PermissionException, OverQuotaException {
        BaseResourceEdit resourceFromXml = new BaseResourceEdit(element);
        String id = resourceFromXml.getId();
        this.unlock("content.new", id);
        BaseResourceEdit resource = (BaseResourceEdit)this.m_storage.putResource(id);
        if (resource == null) {
            return null;
        }
        resource.set(resourceFromXml);
        resource.setEvent("content.new");
        this.commitResource(resource);
        return resource;
    }

    public boolean allowAddAttachmentResource() {
        return this.unlockCheck("content.new", ATTACHMENTS_COLLECTION);
    }

    public ContentResource addAttachmentResource(String name, String type, byte[] content, ResourceProperties properties) throws IdInvalidException, InconsistentException, IdUsedException, PermissionException, OverQuotaException {
        Validator.checkResourceId(name);
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String collection = ATTACHMENTS_COLLECTION + IdService.getUniqueId() + "/";
        String id = collection + name;
        ContentCollectionEdit edit = this.addCollection(collection);
        edit.getPropertiesEdit().addProperty("DAV:displayname", name);
        this.commitCollection(edit);
        return this.addResource(id, type, content, properties);
    }

    public ContentResourceEdit addAttachmentResource(String name) throws IdInvalidException, InconsistentException, IdUsedException, PermissionException {
        Validator.checkResourceId(name);
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        String collection = ATTACHMENTS_COLLECTION + IdService.getUniqueId() + "/";
        String id = collection + name;
        ContentCollectionEdit edit = this.addCollection(collection);
        edit.getPropertiesEdit().addProperty("DAV:displayname", name);
        this.commitCollection(edit);
        return this.addResource(id);
    }

    public boolean allowUpdateResource(String id) {
        return this.unlockCheck("content.revise", id);
    }

    public ContentResource updateResource(String id, String type, byte[] content) throws PermissionException, IdUnusedException, TypeException, InUseException, OverQuotaException {
        ContentResourceEdit edit = this.editResource(id);
        edit.setContentType(type);
        edit.setContent(content);
        this.commitResource(edit);
        return edit;
    }

    public ContentResourceEdit editResource(String id) throws PermissionException, IdUnusedException, TypeException, InUseException {
        String ref = this.getReference(id);
        this.unlock("content.revise", id);
        if (this.m_cache.get(ref) == null && !this.m_storage.checkResource(id)) {
            throw new IdUnusedException(id);
        }
        BaseResourceEdit resource = (BaseResourceEdit)this.m_storage.editResource(id);
        if (resource == null) {
            throw new InUseException(id);
        }
        resource.setEvent("content.revise");
        return resource;
    }

    public boolean allowGetResource(String id) {
        return this.unlockCheck("content.read", id);
    }

    public void checkResource(String id) throws PermissionException, IdUnusedException, TypeException {
        this.unlock("content.read", id);
        ContentResource resource = this.findResource(id);
        if (resource == null) {
            throw new IdUnusedException(id);
        }
    }

    public ContentResource getResource(String id) throws PermissionException, IdUnusedException, TypeException {
        this.unlock("content.read", id);
        ContentResource resource = this.findResource(id);
        if (resource == null) {
            throw new IdUnusedException(id);
        }
        EventTrackingService.post(EventTrackingService.newEvent("content.read", resource.getReference(), false));
        return resource;
    }

    protected ContentResource findResource(String id) throws TypeException {
        ContentResource resource = null;
        String key = this.getReference(id);
        if (this.m_cache.containsKey(key)) {
            Object o = this.m_cache.get(key);
            if (o != null && !(o instanceof ContentResource)) {
                throw new TypeException(id);
            }
            resource = (ContentResource)o;
        } else {
            resource = this.m_storage.getResource(id);
            this.m_cache.put(key, resource);
        }
        return resource;
    }

    public boolean allowRemoveResource(String id) {
        return this.unlockCheck("content.delete", id);
    }

    public void removeResource(String id) throws PermissionException, IdUnusedException, TypeException, InUseException {
        BaseResourceEdit edit = (BaseResourceEdit)this.editResource(id);
        this.removeResource(edit);
    }

    public void removeResource(ContentResourceEdit edit) throws PermissionException {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".removeResource(): closed ContentResourceEdit", (Throwable)e);
                return;
            }
        }
        this.unlock("content.delete", edit.getId());
        this.m_storage.removeResource(edit);
        EventTrackingService.post(EventTrackingService.newEvent("content.delete", edit.getReference(), true));
        ((BaseResourceEdit)edit).closeEdit();
        ((BaseResourceEdit)edit).setRemoved();
    }

    public void commitResource(ContentResourceEdit edit) throws OverQuotaException {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitResource(): closed ContentResourceEdit", (Throwable)e);
                return;
            }
        }
        if (this.overQuota(edit)) {
            throw new OverQuotaException(edit.getReference());
        }
        this.commitResourceEdit(edit);
    }

    protected void commitResourceEdit(ContentResourceEdit edit) {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitResourceEdit(): closed ContentResourceEdit", (Throwable)e);
                return;
            }
        }
        this.addLiveUpdateResourceProperties(edit);
        this.m_storage.commitResource(edit);
        EventTrackingService.post(EventTrackingService.newEvent(((BaseResourceEdit)edit).getEvent(), edit.getReference(), true));
        ((BaseResourceEdit)edit).closeEdit();
    }

    public void cancelResource(ContentResourceEdit edit) {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelResource(): closed ContentResourceEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.cancelResource(edit);
        ((BaseResourceEdit)edit).closeEdit();
    }

    public boolean allowGetProperties(String id) {
        return this.unlockCheck("content.read", id);
    }

    public ResourceProperties getProperties(String id) throws PermissionException, IdUnusedException {
        this.unlock("content.read", id);
        boolean collectionHint = id.endsWith("/");
        Resource o = null;
        try {
            o = collectionHint ? this.findCollection(id) : this.findResource(id);
        }
        catch (TypeException ignore) {
            // empty catch block
        }
        if (o == null) {
            throw new IdUnusedException(id);
        }
        return o.getProperties();
    }

    public boolean allowAddProperty(String id) {
        return this.unlockCheck("content.revise", id);
    }

    public ResourceProperties addProperty(String id, String name, String value) throws PermissionException, IdUnusedException, TypeException, InUseException {
        this.unlock("content.revise", id);
        boolean collectionHint = id.endsWith("/");
        Edit o = null;
        o = collectionHint ? this.editCollection(id) : this.editResource(id);
        if (o == null) {
            throw new IdUnusedException(id);
        }
        ResourcePropertiesEdit props = o.getPropertiesEdit();
        if (props.isLiveProperty(name)) {
            throw new TypeException(name);
        }
        props.addProperty(name, value);
        if (o instanceof ContentResourceEdit) {
            this.commitResourceEdit((ContentResourceEdit)o);
        }
        if (o instanceof ContentCollectionEdit) {
            this.commitCollection((ContentCollectionEdit)o);
        }
        return props;
    }

    public boolean allowRemoveProperty(String id) {
        return this.unlockCheck("content.revise", id);
    }

    public ResourceProperties removeProperty(String id, String name) throws PermissionException, IdUnusedException, TypeException, InUseException {
        this.unlock("content.revise", id);
        boolean collectionHint = id.endsWith("/");
        Edit o = null;
        o = collectionHint ? this.editCollection(id) : this.editResource(id);
        if (o == null) {
            throw new IdUnusedException(id);
        }
        ResourcePropertiesEdit props = o.getPropertiesEdit();
        if (props.isLiveProperty(name)) {
            throw new TypeException(name);
        }
        props.removeProperty(name);
        if (o instanceof ContentResourceEdit) {
            this.commitResourceEdit((ContentResourceEdit)o);
        }
        if (o instanceof ContentCollectionEdit) {
            this.commitCollection((ContentCollectionEdit)o);
        }
        return props;
    }

    public String getUrl(String id) {
        return this.getAccessPoint(false) + Validator.escapeUrl(id);
    }

    public String getReference(String id) {
        return this.getAccessPoint(true) + id;
    }

    public String getContainingCollectionId(String id) {
        return this.isolateContainingId(id);
    }

    public int getDepth(String resourceId, String baseCollectionId) {
        if (resourceId.indexOf(baseCollectionId) == -1) {
            return -1;
        }
        int i = 1;
        String s = resourceId.substring(baseCollectionId.length());
        while (s.indexOf("/") != -1) {
            if (s.indexOf("/") != s.length() - 1) {
                ++i;
                s = s.substring(s.indexOf("/") + 1);
                continue;
            }
            s = "";
        }
        return i;
    }

    public boolean isRootCollection(String id) {
        if (id.equals("/")) {
            return true;
        }
        if (id.equals(this.getReference("/"))) {
            return true;
        }
        return id.equals(this.getUrl("/"));
    }

    public ResourcePropertiesEdit newResourceProperties() {
        return new BaseResourcePropertiesEdit();
    }

    protected String isolateContainingId(String id) {
        return id.substring(0, id.lastIndexOf(47, id.length() - 2) + 1);
    }

    protected String isolateName(String id) {
        if (id == null) {
            return null;
        }
        if (id.length() == 0) {
            return null;
        }
        boolean lastIsSeparator = id.charAt(id.length() - 1) == '/';
        return id.substring(id.lastIndexOf(47, id.length() - 2) + 1, lastIsSeparator ? id.length() - 1 : id.length());
    }

    protected String fixType(String id, String type) {
        if (!this.m_contentTypeService.isUnknownType(type)) {
            return type;
        }
        return this.m_contentTypeService.getContentType(Validator.getFileExtension(id));
    }

    protected boolean overQuota(ContentResourceEdit edit) {
        if (this.m_siteQuota == 0L) {
            return false;
        }
        long quota = this.m_siteQuota;
        if (!edit.getId().startsWith("/user/") && !edit.getId().startsWith("/group/")) {
            return false;
        }
        String[] parts = StringUtil.split(edit.getId(), "/");
        if (parts.length <= 2) {
            return false;
        }
        String id = "/" + parts[1] + "/" + parts[2] + "/";
        ContentCollection collection = null;
        try {
            collection = this.findCollection(id);
        }
        catch (TypeException ignore) {
            // empty catch block
        }
        if (collection == null) {
            return false;
        }
        try {
            long siteSpecific = collection.getProperties().getLongProperty("CHEF:collection-body-quota");
            if (siteSpecific == 0L) {
                return false;
            }
            quota = siteSpecific;
        }
        catch (Exception ignore) {
            // empty catch block
        }
        long size = ((BaseCollectionEdit)collection).getBodySizeK();
        ContentResource inThere = null;
        try {
            inThere = this.findResource(edit.getId());
        }
        catch (TypeException ignore) {
            // empty catch block
        }
        if (inThere != null) {
            size -= this.bytes2k(inThere.getContentLength());
        }
        return (size += this.bytes2k(edit.getContentLength())) >= quota;
    }

    protected long bytes2k(long bytes) {
        return (bytes - 1L) / 1024L + 1L;
    }

    public Object refresh(Object key, Object oldValue, Event event) {
        boolean collectionHint;
        Resource rv = null;
        Reference ref = new Reference((String)key);
        String id = ref.getId();
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".refresh(): key " + key + " id : " + ref.getId());
        }
        rv = (collectionHint = id.endsWith("/")) ? this.m_storage.getCollection(id) : this.m_storage.getResource(id);
        return rv;
    }

    static {
        ATTACHMENTS_COLLECTION = ATTACHMENTS_COLLECTION;
    }

    protected static interface Storage {
        public void open();

        public void close();

        public ContentCollection getCollection(String var1);

        public boolean checkCollection(String var1);

        public List getCollections(ContentCollection var1);

        public ContentCollectionEdit putCollection(String var1);

        public ContentCollectionEdit editCollection(String var1);

        public void commitCollection(ContentCollectionEdit var1);

        public void cancelCollection(ContentCollectionEdit var1);

        public void removeCollection(ContentCollectionEdit var1);

        public ContentResource getResource(String var1);

        public boolean checkResource(String var1);

        public List getResources(ContentCollection var1);

        public ContentResourceEdit putResource(String var1);

        public ContentResourceEdit editResource(String var1);

        public void commitResource(ContentResourceEdit var1);

        public void cancelResource(ContentResourceEdit var1);

        public void removeResource(ContentResourceEdit var1);

        public byte[] getResourceBody(ContentResource var1);
    }

    public class BaseResourceEdit
    implements ContentResourceEdit,
    SessionStateBindingListener {
        protected String m_id = null;
        protected String m_contentType = null;
        protected byte[] m_body = null;
        protected int m_contentLength = 0;
        protected ResourcePropertiesEdit m_properties = null;
        protected String m_event = null;
        protected boolean m_active = false;
        protected boolean m_isRemoved = false;
        protected boolean m_bodyUpdated = false;

        public BaseResourceEdit(String id) {
            this.m_id = id;
            this.m_properties = new BaseResourcePropertiesEdit();
        }

        public BaseResourceEdit(ContentResource other) {
            this.set(other);
        }

        protected void set(ContentResource other) {
            this.m_id = other.getId();
            this.m_contentType = other.getContentType();
            this.m_contentLength = other.getContentLength();
            byte[] content = ((BaseResourceEdit)other).m_body;
            if (content != null) {
                this.m_contentLength = content.length;
                this.m_body = content;
            }
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(other.getProperties());
        }

        public BaseResourceEdit(Element el) {
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_id = el.getAttribute("id");
            this.m_contentType = el.getAttribute("content-type");
            this.m_contentLength = Integer.parseInt(el.getAttribute("content-length"));
            String enc = el.getAttribute("body");
            if (enc != null && enc.length() > 0) {
                Base64 b = new Base64();
                byte[] decoded = Base64.decode((byte[])enc.getBytes());
                this.m_body = new byte[this.m_contentLength];
                System.arraycopy(decoded, 0, this.m_body, 0, this.m_contentLength);
            }
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("properties")) {
                    this.m_properties = new BaseResourcePropertiesEdit(element);
                }
                ++i;
            }
        }

        protected void finalize() {
            if (this.m_active) {
                BaseContentService.this.cancelResource(this);
            }
        }

        public String getUrl() {
            return BaseContentService.this.getAccessPoint(false) + this.m_id;
        }

        public String getReference() {
            return BaseContentService.this.getAccessPoint(true) + this.m_id;
        }

        public String getId() {
            return this.m_id;
        }

        public int getContentLength() {
            if (this.m_body != null) {
                return this.m_body.length;
            }
            return this.m_contentLength;
        }

        public String getContentType() {
            return this.m_contentType == null ? "" : this.m_contentType;
        }

        public byte[] getContent() {
            byte[] rv = this.m_body;
            if (rv == null && this.m_contentLength > 0) {
                this.m_body = rv = BaseContentService.this.m_storage.getResourceBody(this);
            }
            return rv;
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        protected void setRemoved() {
            this.m_isRemoved = true;
        }

        public void setContentLength(int length) {
            this.m_contentLength = length;
        }

        public void setContentType(String type) {
            this.m_contentType = type = BaseContentService.this.fixType(this.getId(), type);
        }

        public void setContent(byte[] content) {
            if (content == null) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".setContent(): null content", (Throwable)e);
                    return;
                }
            }
            if (Different.different(content, this.m_body)) {
                this.m_body = content;
                this.m_contentLength = this.m_body.length;
                this.m_bodyUpdated = true;
            }
        }

        public Element toXml(Document doc, Stack stack) {
            Element resource = doc.createElement("resource");
            if (stack.isEmpty()) {
                doc.appendChild(resource);
            } else {
                ((Element)stack.peek()).appendChild(resource);
            }
            stack.push(resource);
            resource.setAttribute("id", this.m_id);
            resource.setAttribute("content-type", this.m_contentType);
            int contentLength = this.m_contentLength;
            if (this.m_body != null) {
                contentLength = this.m_body.length;
            }
            resource.setAttribute("content-length", Integer.toString(contentLength));
            if (this.m_body != null) {
                Base64 b = new Base64();
                byte[] encoded = Base64.encode((byte[])this.m_body);
                String enc = new String(encoded);
                resource.setAttribute("body", enc);
            }
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return resource;
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseContentService.this.cancelResource(this);
            }
        }
    }

    public class BaseCollectionEdit
    implements ContentCollectionEdit,
    SessionStateBindingListener {
        protected String m_id = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected String m_event = null;
        protected boolean m_active = false;
        protected boolean m_isRemoved = false;

        public BaseCollectionEdit(String id) {
            this.m_id = id;
            this.m_properties = new BaseResourcePropertiesEdit();
        }

        public BaseCollectionEdit(ContentCollection other) {
            this.set(other);
        }

        public BaseCollectionEdit(Element el) {
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_id = el.getAttribute("id");
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("properties")) {
                    this.m_properties = new BaseResourcePropertiesEdit(element);
                }
                ++i;
            }
        }

        protected void set(ContentCollection other) {
            this.m_id = other.getId();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(other.getProperties());
        }

        protected void finalize() {
            if (this.m_active) {
                BaseContentService.this.cancelCollection(this);
            }
        }

        public String getUrl() {
            return BaseContentService.this.getAccessPoint(false) + this.m_id;
        }

        public String getReference() {
            return BaseContentService.this.getAccessPoint(true) + this.m_id;
        }

        public String getId() {
            return this.m_id;
        }

        public List getMembers() {
            List memberResources = this.getMemberResources();
            Vector<String> mbrs = new Vector<String>();
            int i = 0;
            while (i < memberResources.size()) {
                Resource res = (Resource)memberResources.get(i);
                if (res != null) {
                    mbrs.add(res.getId());
                }
                ++i;
            }
            if (mbrs.size() == 0) {
                return mbrs;
            }
            return mbrs;
        }

        public long getBodySizeK() {
            long size = 0L;
            List members = this.getMemberResources();
            Iterator it = members.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj == null) continue;
                if (obj instanceof ContentResource) {
                    size += BaseContentService.this.bytes2k(((ContentResource)obj).getContentLength());
                    continue;
                }
                size += ((BaseCollectionEdit)obj).getBodySizeK();
            }
            return size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getMemberResources() {
            List mbrs = new Vector();
            if (BaseContentService.this.m_cache.disabled()) {
                mbrs = BaseContentService.this.m_storage.getCollections(this);
                mbrs.addAll(BaseContentService.this.m_storage.getResources(this));
            } else if (BaseContentService.this.m_cache.isComplete(this.getReference())) {
                mbrs = BaseContentService.this.m_cache.getAll(this.getReference());
            } else {
                Cache cache = BaseContentService.this.m_cache;
                synchronized (cache) {
                    if (BaseContentService.this.m_cache.isComplete(this.getReference())) {
                        mbrs = BaseContentService.this.m_cache.getAll(this.getReference());
                    } else {
                        BaseContentService.this.m_cache.holdEvents();
                        mbrs = BaseContentService.this.m_storage.getCollections(this);
                        mbrs.addAll(BaseContentService.this.m_storage.getResources(this));
                        int i = 0;
                        while (i < mbrs.size()) {
                            Resource mbr = (Resource)mbrs.get(i);
                            BaseContentService.this.m_cache.put(mbr.getReference(), mbr);
                            ++i;
                        }
                        BaseContentService.this.m_cache.setComplete(this.getReference());
                        BaseContentService.this.m_cache.processEvents();
                    }
                }
            }
            if (mbrs.size() == 0) {
                return mbrs;
            }
            return mbrs;
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        protected void setRemoved() {
            this.m_isRemoved = true;
        }

        protected void clear() throws IdUnusedException, PermissionException, InconsistentException, TypeException, InUseException {
            List mbrs = this.getMemberResources();
            int i = 0;
            while (i < mbrs.size()) {
                Object mbr = mbrs.get(i);
                if (mbr != null) {
                    if (mbr instanceof ContentCollection) {
                        ((BaseCollectionEdit)mbr).clear();
                    }
                    if (mbr instanceof ContentCollection) {
                        BaseContentService.this.removeCollection(((ContentCollection)mbr).getId());
                    } else if (mbr instanceof ContentResource) {
                        BaseContentService.this.removeResource(((ContentResource)mbr).getId());
                    }
                }
                ++i;
            }
        }

        public Element toXml(Document doc, Stack stack) {
            Element collection = doc.createElement("collection");
            if (stack.isEmpty()) {
                doc.appendChild(collection);
            } else {
                ((Element)stack.peek()).appendChild(collection);
            }
            stack.push(collection);
            collection.setAttribute("id", this.m_id);
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return collection;
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseContentService.this.cancelCollection(this);
            }
        }
    }

    protected class ResourceStorageUser
    implements StorageUser {
        protected ResourceStorageUser() {
        }

        public Resource newContainer(String ref) {
            return null;
        }

        public Resource newContainer(Element element) {
            return null;
        }

        public Resource newContainer(Resource other) {
            return null;
        }

        public Resource newResource(Resource container, String id, Object[] others) {
            return new BaseResourceEdit(id);
        }

        public Resource newResource(Resource container, Element element) {
            return new BaseResourceEdit(element);
        }

        public Resource newResource(Resource container, Resource other) {
            return new BaseResourceEdit((ContentResource)other);
        }

        public Edit newContainerEdit(String ref) {
            return null;
        }

        public Edit newContainerEdit(Element element) {
            return null;
        }

        public Edit newContainerEdit(Resource other) {
            return null;
        }

        public Edit newResourceEdit(Resource container, String id, Object[] others) {
            BaseResourceEdit rv = new BaseResourceEdit(id);
            rv.activate();
            return rv;
        }

        public Edit newResourceEdit(Resource container, Element element) {
            BaseResourceEdit rv = new BaseResourceEdit(element);
            rv.activate();
            return rv;
        }

        public Edit newResourceEdit(Resource container, Resource other) {
            BaseResourceEdit rv = new BaseResourceEdit((ContentResource)other);
            rv.activate();
            return rv;
        }

        public Object[] storageFields(Resource r) {
            Object[] rv = new Object[]{StringUtil.referencePath(((ContentResource)r).getId())};
            return rv;
        }
    }

    protected class CollectionStorageUser
    implements StorageUser {
        protected CollectionStorageUser() {
        }

        public Resource newContainer(String ref) {
            return null;
        }

        public Resource newContainer(Element element) {
            return null;
        }

        public Resource newContainer(Resource other) {
            return null;
        }

        public Resource newResource(Resource container, String id, Object[] others) {
            return new BaseCollectionEdit(id);
        }

        public Resource newResource(Resource container, Element element) {
            return new BaseCollectionEdit(element);
        }

        public Resource newResource(Resource container, Resource other) {
            return new BaseCollectionEdit((ContentCollection)other);
        }

        public Edit newContainerEdit(String ref) {
            return null;
        }

        public Edit newContainerEdit(Element element) {
            return null;
        }

        public Edit newContainerEdit(Resource other) {
            return null;
        }

        public Edit newResourceEdit(Resource container, String id, Object[] others) {
            BaseCollectionEdit rv = new BaseCollectionEdit(id);
            rv.activate();
            return rv;
        }

        public Edit newResourceEdit(Resource container, Element element) {
            BaseCollectionEdit rv = new BaseCollectionEdit(element);
            rv.activate();
            return rv;
        }

        public Edit newResourceEdit(Resource container, Resource other) {
            BaseCollectionEdit rv = new BaseCollectionEdit((ContentCollection)other);
            rv.activate();
            return rv;
        }

        public Object[] storageFields(Resource r) {
            Object[] rv = new Object[]{StringUtil.referencePath(((ContentCollection)r).getId())};
            return rv;
        }
    }
}

