/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.util.Log;
import org.chefproject.service.component.BasePresenceService;
import org.chefproject.util.Sql;

public class ClusterPresenceService
extends BasePresenceService {
    protected BasePresenceService.Storage newStorage() {
        return new ClusterStorage();
    }

    protected class ClusterStorage
    implements BasePresenceService.Storage {
        protected ClusterStorage() {
        }

        public void setPresence(String sessionId, String locationId) {
            if (this.checkPresence(sessionId, locationId)) {
                return;
            }
            String statement = "insert into CHEF_PRESENCE (SESSION_ID,LOCATION_ID) values ( ?, ?)";
            Object[] fields = new Object[]{sessionId, locationId};
            boolean ok = Sql.dbWrite(statement, fields);
            if (!ok) {
                Log.warn("chef", this + ".setPresence(): dbWrite failed");
            }
        }

        public void removePresence(String sessionId, String locationId) {
            String statement = "delete from CHEF_PRESENCE where ( SESSION_ID = ? and LOCATION_ID = ?)";
            Object[] fields = new Object[]{sessionId};
            boolean ok = Sql.dbWrite(statement, fields, locationId);
            if (!ok) {
                Log.warn("chef", this + ".removePresence(): dbWrite failed");
            }
        }

        public boolean checkPresence(String sessionId, String locationId) {
            String statement = "select SESSION_ID from CHEF_PRESENCE where ( SESSION_ID = ? and LOCATION_ID = ?)";
            Object[] fields = new Object[]{sessionId, locationId};
            List sessions = Sql.dbRead(statement, fields, null);
            return !sessions.isEmpty();
        }

        public List getSessions(String locationId) {
            String statement = "select SESSION_ID from CHEF_PRESENCE where ( LOCATION_ID = ?)";
            Object[] fields = new Object[]{locationId};
            List sessions = Sql.dbRead(statement, fields, null);
            return sessions;
        }

        public List getLocations() {
            String statement = "select LOCATION_ID from CHEF_PRESENCE";
            List manyLocs = Sql.dbRead(statement);
            HashSet locs = new HashSet();
            locs.addAll(manyLocs);
            Vector rv = new Vector();
            rv.addAll(locs);
            return rv;
        }
    }
}

