C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_c_pw91lda.F 
C> The nwxcm_c_pw91lda functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_c_pw91lda functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& 0.1325688999052018\,{\it t_3}+1.0\\\\ 
C>   {\it t_5} &=& \sqrt{{\it t_2}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_5}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.02414199311453321\,{\it t_6}
C>    +0.10186556948\right)+0.22308199064\right)+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{10}} &=& 0.06901399211255826\,{\it t_3}+1.0\\\\ 
C>   {\it t_{11}} &=& \log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01321299881039884
C>    \,{\it t_6}+0.029729725188\right)+0.12236585478\right)
C>    +0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{12}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{13}} &=& \sqrt{{\it t_{12}}}\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_{13}}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{12}}}}\\\\ 
C>   {\it t_{16}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{13}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{14}}+0.10186556948\right)
C>    \,{\it t_{14}}+0.22308199064\right)\,{\it t_{14}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{17}} &=& 0.1325688999052018\,{\it t_{15}}+1.0\\\\ 
C>   {\it t_{18}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{13}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{14}}
C>    +0.029729725188\right)\,{\it t_{14}}+0.12236585478\right)\,{
C>    \it t_{14}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{19}} &=& 0.06901399211255826\,{\it t_{15}}+1.0\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(0.5848223622634648\,
C>    \left(1.923661050931536\,\left({\it t_8}\,{\it t_9}
C>    +1.0\right)^{{{4}\over{3}}}+1.923661050931536\,\left(1.0-{
C>    \it t_8}\,{\it t_9}\right)^{{{4}\over{3}}}
C>    -3.847322101863072\right)\,\left({{{\it t_8}^4\,
C>    \left(1.709920934161365\,\left(0.0621814\,{\it t_4}\,{\it t_7}
C>    -0.0310907\,\left(0.1274696188700087\,{\it t_3}+1.0\right)
C>    \,\log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.01530901310039024\,{\it t_6}
C>    +0.10465751434\right)+0.19269083139\right)+0.43896648423}}
C>    +1.0\right)\right)-0.0337738\,{\it t_{10}}\,{
C>    \it t_{11}}\right)}\over{{\it t_1}^4}}+0.0337738\,{\it t_{10}}
C>    \,{\it t_{11}}\right)-0.0621814\,{\it t_4}\,{\it t_7}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{18}}\,{\it t_{19}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{16}}\,{\it t_{17}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{13}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{14}}+0.10465751434\right)
C>    \,{\it t_{14}}+0.19269083139\right)\,{\it t_{14}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{15}}+1.0\right)\right)-0.0337738\,{\it t_{18}}\,{
C>    \it t_{19}}\right)\right)-0.0621814\,{\it t_{16}}\,{
C>    \it t_{17}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] JP Perdew, Y Wang, Phys.Rev.B 45, 13244 (1992)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevB.45.13244 "> 
C> 10.1103/PhysRevB.45.13244 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_pw91lda(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t6 = 7.016926042943222d-1*t3*t5+2.2308199064d-1
            t7 = 7.016926042943222d-1*t3*t6+4.7231125998d-1
            t8 = 1/t7
            t9 = 1.425125466450768d+0*t2*t8+1.0d+0
            t10 = log(t9)
            t11 = 1.0522000558389213d-1*t4+1.0d+0
            t12 = 1/t2**3
            t13 = 1/rhoa**6.666666666666667d-1
            fnc(iq) = fnc(iq)-1.243628d-1*rhoa*log(1.4251254664507676d+0
     1         *t2/(7.016926042943223d-1*t3*(7.016926042943223d-1*(2.150
     2         807071909054d-2*t3+1.0186556948d-1)*t3+2.2308199064d-1)+4
     3         .7231125998d-1)+1.0d+0)*(1.0522000558389215d-1*t4+1.0d+0)
     4         *wght
            Amat(iq,D1_RA) = 2.0d+0*rhoa*(1.090454542535705d-3*t10/rhoa*
     1         *1.3333333333333333d+0-6.21814d-2*t11*(1.1876045553756398
     2         d-1*t13*t3*t8-1.425125466450768d+0*t2*(7.016926042943222d
     3         -1*t3*(-5.847438369119352d-2*t12*t13*t5-1.257671179685424
     4         2d-3/rhoa**1.3333333333333336d+0)-5.847438369119352d-2*t1
     5         2*t13*t6)/t7**2)/t9)*wght-6.21814d-2*t10*t11*wght+Amat(iq
     6         ,D1_RA)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = 1/t2
            t4 = 1.325688999052018d-1*t3+1.0d+0
            t5 = t2**5.0d-1
            t6 = 1/t5
            t7 = 2.4141993114533214d-2*t6+1.0186556948d-1
            t8 = 7.876233178997433d-1*t6*t7+2.2308199064d-1
            t9 = 7.876233178997433d-1*t6*t8+4.7231125998d-1
            t10 = 1/t9
            t11 = 1.269642451250142d+0*t10*t5+1.0d+0
            t12 = log(t11)
            t13 = rhoa-rhob
            t14 = 1/t1
            t15 = 1.0d+0-t13*t14
            t16 = t13*t14+1.0d+0
            t17 = 1.923661050931536d+0*t16**1.3333333333333333d+0+1.9236
     1         61050931536d+0*t15**1.3333333333333333d+0-3.8473221018630
     2         72d+0
            t18 = 6.901399211255826d-2*t3+1.0d+0
            t19 = 1.3212998810398843d-2*t6+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t6+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t6+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t22*t5+1.0d+0
            t24 = log(t23)
            t25 = t13**4
            t26 = 1/t1**4
            t27 = 1.2746961887000874d-1*t3+1.0d+0
            t28 = 1.530901310039024d-2*t6+1.0465751434d-1
            t29 = 7.876233178997433d-1*t28*t6+1.9269083139d-1
            t30 = 7.876233178997433d-1*t29*t6+4.3896648423d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t31*t5+1.0d+0
            t33 = log(t32)
            t34 = 1.709920934161365d+0*(6.21814d-2*t12*t4-3.10907d-2*t27
     1         *t33)-3.37738d-2*t18*t24
            t35 = t25*t26*t34+3.37738d-2*t18*t24
            t36 = 5.848223622634648d-1*t17*t35-6.21814d-2*t12*t4
            t37 = 1/t1**1.3333333333333336d+0
            t38 = 1/t1**6.666666666666667d-1
            t39 = 1/t5**3
            t40 = 2.11607075208357d-1*t10*t38*t6-1.269642451250142d+0*t5
     1         *(7.876233178997433d-1*t6*(-1.3127055298329054d-1*t38*t39
     2         *t7-3.169132786263567d-3*t37)-1.3127055298329054d-1*t38*t
     3         39*t8)/t9**2
            t41 = 1/t11
            t42 = -6.21814d-2*t4*t40*t41
            t43 = 1/t1**1.3333333333333333d+0
            t44 = 2.747773264188438d-3*t12*t43
            t45 = 2.11607075208357d-1*t22*t38*t6-1.269642451250142d+0*t5
     1         *(7.876233178997433d-1*(-1.3127055298329054d-1*t19*t38*t3
     2         9-1.7344776604086162d-3*t37)*t6-1.3127055298329054d-1*t20
     3         *t38*t39)/t21**2
            t46 = 1/t23
            t47 = 3.37738d-2*t18*t45*t46
            t48 = -7.769549222703733d-4*t24*t43
            t49 = t25*t26*(1.709920934161365d+0*(-3.10907d-2*t27*(2.1160
     1         7075208357d-1*t31*t38*t6-1.269642451250142d+0*t5*(7.87623
     2         3178997433d-1*(-1.3127055298329054d-1*t28*t38*t39-2.00962
     3         26153166658d-3*t37)*t6-1.3127055298329054d-1*t29*t38*t39)
     4         /t30**2)/t32+1.3210398931339265d-3*t33*t43-2.747773264188
     5         438d-3*t12*t43+6.21814d-2*t4*t40*t41)-3.37738d-2*t18*t45*
     6         t46+7.769549222703733d-4*t24*t43)
            t50 = -4*t25*t34/t1**5
            t51 = t13**3
            t52 = 1/t1**2
            t53 = t13*t52
            t54 = -t14
            t55 = t15**3.333333333333333d-1
            t56 = -t13*t52
            t57 = t16**3.333333333333333d-1
            t58 = 1.0d+0*t36*wght
            fnc(iq) = 1.0d+0*t1*t36*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*(5.848223622634648d-1*t35*(2.5648
     1         81401242048d+0*(t56+t14)*t57+2.564881401242048d+0*(t54+t5
     2         3)*t55)+5.848223622634648d-1*t17*(4*t26*t34*t51+t50+t49+t
     3         48+t47)+t44+t42)*wght+t58+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*(5.848223622634648d-1*t35*(2.5648
     1         81401242048d+0*(t56+t54)*t57+2.564881401242048d+0*(t53+t1
     2         4)*t55)+5.848223622634648d-1*t17*(-4*t26*t34*t51+t50+t49+
     3         t48+t47)+t44+t42)*wght+t58+Amat(iq,D1_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = 1/rhoa**1.3333333333333333d+0
            t28 = 1/rhoa**1.3333333333333336d+0
            t29 = 1/t2**3
            t30 = 1/rhoa**6.666666666666667d-1
            t31 = 1/t16
            t32 = 2.11607075208357d-1*t15*t3*t30-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t12*t29
     2         *t30-3.169132786263567d-3*t28)-1.3127055298329054d-1*t13*
     3         t29*t30)/t14**2
            t33 = 1/t23
            t34 = 2.11607075208357d-1*t22*t3*t30-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t19*t29
     2         *t30-1.7344776604086162d-3*t28)-1.3127055298329054d-1*t20
     3         *t29*t30)/t21**2
            fnc(iq) = 1.0d+0*rhoa*t26*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*(5.848223622634643d-1*(1.0d+0*(
     1         1.709920934161365d+0*(1.3210398931339265d-3*t27*t9-3.1090
     2         7d-2*t11*(2.11607075208357d-1*t3*t30*t7-1.269642451250142
     3         d+0*t2*(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t
     4         29*t30*t4-2.0096226153166658d-3*t28)-1.3127055298329054d-
     5         1*t29*t30*t5)/t6**2)/t8+6.21814d-2*t18*t31*t32-2.74777326
     6         4188438d-3*t17*t27)-3.37738d-2*t25*t33*t34+7.769549222703
     7         733d-4*t24*t27)+3.37738d-2*t25*t33*t34-7.769549222703733d
     8         -4*t24*t27)-6.21814d-2*t18*t31*t32+2.747773264188438d-3*t
     9         17*t27)*wght+1.0d+0*t26*wght+Amat(iq,D1_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = 1/rhob**1.3333333333333333d+0
            t28 = 1/rhob**1.3333333333333336d+0
            t29 = 1/t2**3
            t30 = 1/rhob**6.666666666666667d-1
            t31 = 1/t16
            t32 = 2.11607075208357d-1*t15*t3*t30-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t12*t29
     2         *t30-3.169132786263567d-3*t28)-1.3127055298329054d-1*t13*
     3         t29*t30)/t14**2
            t33 = 1/t23
            t34 = 2.11607075208357d-1*t22*t3*t30-1.269642451250142d+0*t2
     1         *(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t19*t29
     2         *t30-1.7344776604086162d-3*t28)-1.3127055298329054d-1*t20
     3         *t29*t30)/t21**2
            fnc(iq) = 1.0d+0*rhob*t26*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*(5.848223622634643d-1*(1.0d+0*(
     1         1.709920934161365d+0*(1.3210398931339265d-3*t27*t9-3.1090
     2         7d-2*t11*(2.11607075208357d-1*t3*t30*t7-1.269642451250142
     3         d+0*t2*(7.876233178997433d-1*t3*(-1.3127055298329054d-1*t
     4         29*t30*t4-2.0096226153166658d-3*t28)-1.3127055298329054d-
     5         1*t29*t30*t5)/t6**2)/t8+6.21814d-2*t18*t31*t32-2.74777326
     6         4188438d-3*t17*t27)-3.37738d-2*t25*t33*t34+7.769549222703
     7         733d-4*t24*t27)+3.37738d-2*t25*t33*t34-7.769549222703733d
     8         -4*t24*t27)-6.21814d-2*t18*t31*t32+2.747773264188438d-3*t
     9         17*t27)*wght+1.0d+0*t26*wght+Amat(iq,D1_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_pw91lda functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& 0.1325688999052018\,{\it t_3}+1.0\\\\ 
C>   {\it t_5} &=& \sqrt{{\it t_2}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_5}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.02414199311453321\,{\it t_6}
C>    +0.10186556948\right)+0.22308199064\right)+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{10}} &=& 0.06901399211255826\,{\it t_3}+1.0\\\\ 
C>   {\it t_{11}} &=& \log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01321299881039884
C>    \,{\it t_6}+0.029729725188\right)+0.12236585478\right)
C>    +0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{12}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{13}} &=& \sqrt{{\it t_{12}}}\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_{13}}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{12}}}}\\\\ 
C>   {\it t_{16}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{13}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{14}}+0.10186556948\right)
C>    \,{\it t_{14}}+0.22308199064\right)\,{\it t_{14}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{17}} &=& 0.1325688999052018\,{\it t_{15}}+1.0\\\\ 
C>   {\it t_{18}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{13}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{14}}
C>    +0.029729725188\right)\,{\it t_{14}}+0.12236585478\right)\,{
C>    \it t_{14}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{19}} &=& 0.06901399211255826\,{\it t_{15}}+1.0\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(0.5848223622634648\,
C>    \left(1.923661050931536\,\left({\it t_8}\,{\it t_9}
C>    +1.0\right)^{{{4}\over{3}}}+1.923661050931536\,\left(1.0-{
C>    \it t_8}\,{\it t_9}\right)^{{{4}\over{3}}}
C>    -3.847322101863072\right)\,\left({{{\it t_8}^4\,
C>    \left(1.709920934161365\,\left(0.0621814\,{\it t_4}\,{\it t_7}
C>    -0.0310907\,\left(0.1274696188700087\,{\it t_3}+1.0\right)
C>    \,\log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.01530901310039024\,{\it t_6}
C>    +0.10465751434\right)+0.19269083139\right)+0.43896648423}}
C>    +1.0\right)\right)-0.0337738\,{\it t_{10}}\,{
C>    \it t_{11}}\right)}\over{{\it t_1}^4}}+0.0337738\,{\it t_{10}}
C>    \,{\it t_{11}}\right)-0.0621814\,{\it t_4}\,{\it t_7}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{18}}\,{\it t_{19}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{16}}\,{\it t_{17}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{13}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{14}}+0.10465751434\right)
C>    \,{\it t_{14}}+0.19269083139\right)\,{\it t_{14}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{15}}+1.0\right)\right)-0.0337738\,{\it t_{18}}\,{
C>    \it t_{19}}\right)\right)-0.0621814\,{\it t_{16}}\,{
C>    \it t_{17}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] JP Perdew, Y Wang, Phys.Rev.B 45, 13244 (1992)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevB.45.13244 "> 
C> 10.1103/PhysRevB.45.13244 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_pw91lda_d2(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat,Amat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
c 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t6 = 7.016926042943222d-1*t3*t5+2.2308199064d-1
            t7 = 7.016926042943222d-1*t3*t6+4.7231125998d-1
            t8 = 1/t7
            t9 = 1.425125466450768d+0*t2*t8+1.0d+0
            t10 = log(t9)
            t11 = 1.0522000558389213d-1*t4+1.0d+0
            t12 = 1/rhoa**1.3333333333333333d+0
            t13 = 1/t9
            t14 = 1/t7**2
            t15 = 1/rhoa**1.3333333333333336d+0
            t16 = 1/t2**3
            t17 = 1/rhoa**6.666666666666667d-1
            t18 = -5.847438369119352d-2*t16*t17*t5-1.2576711796854242d-3
     1         *t15
            t19 = 7.016926042943222d-1*t18*t3-5.847438369119352d-2*t16*t
     1         17*t6
            t20 = 1.1876045553756398d-1*t17*t3*t8-1.425125466450768d+0*t
     1         14*t19*t2
            t21 = 1.090454542535705d-3*t10*t12-6.21814d-2*t11*t13*t20
            t22 = 2.0d+0*t21*wght
            t23 = -7.269696950238034d-4*t10/rhoa**2.333333333333333d+0
            t24 = log(1.425125466450768d+0*t2/(7.016926042943222d-1*t3*(
     1         7.016926042943222d-1*(1.1771443702974158d-2*t3+2.97297251
     2         88d-2)*t3+1.2236585478d-1)+3.497952466d-1)+1.0d+0)
            t25 = 5.477644184000001d-2*t4+1.0d+0
            t26 = 1/rhoa**2
            t27 = 2.18090908507141d-3*t12*t13*t20
            t28 = 6.21814d-2*t11*t20**2/t9**2
            t29 = 1/rhoa**1.6666666666666669d+0
            t30 = 1/t2**5
            t31 = -6.21814d-2*t11*t13*(-3.9586818512521327d-2*t29*t3*t8-
     1         9.896704628130328d-3*t15*t16*t8+2.850250932901536d+0*t19*
     2         *2*t2/t7**3-1.425125466450768d+0*t14*t2*(1.46185959227983
     3         75d-2*t15*t30*t6+1.949146123039784d-2*t16*t29*t6+7.016926
     4         042943222d-1*t3*(1.4618595922798375d-2*t15*t30*t5+1.94914
     5         6123039784d-2*t16*t29*t5+9.432533847640683d-4/rhoa**2.333
     6         3333333333334d+0)-1.1694876738238703d-1*t16*t17*t18)-2.37
     7         52091107512796d-1*t14*t17*t19*t3)
            fnc(iq) = fnc(iq)-1.243628d-1*rhoa*log(1.4251254664507676d+0
     1         *t2/(7.016926042943223d-1*t3*(7.016926042943223d-1*(2.150
     2         807071909054d-2*t3+1.0186556948d-1)*t3+2.2308199064d-1)+4
     3         .7231125998d-1)+1.0d+0)*(1.0522000558389215d-1*t4+1.0d+0)
     4         *wght
            Amat(iq,D1_RA) = 2.0d+0*rhoa*t21*wght-6.21814d-2*t10*t11*wgh
     1         t+Amat(iq,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*(t31+t28+t27+8.443450000000
     1         001d-3*t24*t25*t26+t23)*wght+t22+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*(t31+t28+t27-8.44345d-3*t24
     1         *t25*t26+t23)*wght+t22+Amat2(iq,D2_RA_RB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = 1/t2
            t4 = 1.325688999052018d-1*t3+1.0d+0
            t5 = t2**5.0d-1
            t6 = 1/t5
            t7 = 2.4141993114533214d-2*t6+1.0186556948d-1
            t8 = 7.876233178997433d-1*t6*t7+2.2308199064d-1
            t9 = 7.876233178997433d-1*t6*t8+4.7231125998d-1
            t10 = 1/t9
            t11 = 1.269642451250142d+0*t10*t5+1.0d+0
            t12 = log(t11)
            t13 = rhoa-rhob
            t14 = 1/t1
            t15 = 1.0d+0-t13*t14
            t16 = t13*t14+1.0d+0
            t17 = 1.923661050931536d+0*t16**1.3333333333333333d+0+1.9236
     1         61050931536d+0*t15**1.3333333333333333d+0-3.8473221018630
     2         72d+0
            t18 = 6.901399211255826d-2*t3+1.0d+0
            t19 = 1.3212998810398843d-2*t6+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t6+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t6+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t22*t5+1.0d+0
            t24 = log(t23)
            t25 = t13**4
            t26 = 1/t1**4
            t27 = 1.2746961887000874d-1*t3+1.0d+0
            t28 = 1.530901310039024d-2*t6+1.0465751434d-1
            t29 = 7.876233178997433d-1*t28*t6+1.9269083139d-1
            t30 = 7.876233178997433d-1*t29*t6+4.3896648423d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t31*t5+1.0d+0
            t33 = log(t32)
            t34 = 1.709920934161365d+0*(6.21814d-2*t12*t4-3.10907d-2*t27
     1         *t33)-3.37738d-2*t18*t24
            t35 = t25*t26*t34+3.37738d-2*t18*t24
            t36 = 5.848223622634648d-1*t17*t35-6.21814d-2*t12*t4
            t37 = 1/t1**1.3333333333333336d+0
            t38 = 1/t1**6.666666666666667d-1
            t39 = 1/t5**3
            t40 = -1.3127055298329054d-1*t38*t39*t7-3.169132786263567d-3
     1         *t37
            t41 = 7.876233178997433d-1*t40*t6-1.3127055298329054d-1*t38*
     1         t39*t8
            t42 = 1/t9**2
            t43 = 2.11607075208357d-1*t10*t38*t6-1.269642451250142d+0*t4
     1         1*t42*t5
            t44 = 1/t11
            t45 = -6.21814d-2*t4*t43*t44
            t46 = 1/t1**1.3333333333333333d+0
            t47 = 2.747773264188438d-3*t12*t46
            t48 = -1.3127055298329054d-1*t19*t38*t39-1.7344776604086162d
     1         -3*t37
            t49 = 7.876233178997433d-1*t48*t6-1.3127055298329054d-1*t20*
     1         t38*t39
            t50 = 1/t21**2
            t51 = 2.11607075208357d-1*t22*t38*t6-1.269642451250142d+0*t4
     1         9*t5*t50
            t52 = 1/t23
            t53 = 3.37738d-2*t18*t51*t52
            t54 = -7.769549222703733d-4*t24*t46
            t55 = -1.3127055298329054d-1*t28*t38*t39-2.0096226153166658d
     1         -3*t37
            t56 = 7.876233178997433d-1*t55*t6-1.3127055298329054d-1*t29*
     1         t38*t39
            t57 = 1/t30**2
            t58 = 2.11607075208357d-1*t31*t38*t6-1.269642451250142d+0*t5
     1         *t56*t57
            t59 = 1/t32
            t60 = 1.709920934161365d+0*(-3.10907d-2*t27*t58*t59+1.321039
     1         8931339265d-3*t33*t46-2.747773264188438d-3*t12*t46+6.2181
     2         4d-2*t4*t43*t44)-3.37738d-2*t18*t51*t52+7.769549222703733
     3         d-4*t24*t46
            t61 = t25*t26*t60
            t62 = 1/t1**5
            t63 = -4*t25*t34*t62
            t64 = t13**3
            t65 = 4*t26*t34*t64+t63+t61+t54+t53
            t66 = 1/t1**2
            t67 = t13*t66
            t68 = -t14
            t69 = t68+t67
            t70 = t15**3.333333333333333d-1
            t71 = -t13*t66
            t72 = t71+t14
            t73 = t16**3.333333333333333d-1
            t74 = 2.564881401242048d+0*t72*t73+2.564881401242048d+0*t69*
     1         t70
            t75 = 5.848223622634648d-1*t35*t74+5.848223622634648d-1*t17*
     1         t65+t47+t45
            t76 = 1.0d+0*t36*wght
            t77 = -4*t26*t34*t64+t63+t61+t54+t53
            t78 = t67+t14
            t79 = t71+t68
            t80 = 2.564881401242048d+0*t73*t79+2.564881401242048d+0*t70*
     1         t78
            t81 = 5.848223622634648d-1*t35*t80+5.848223622634648d-1*t17*
     1         t77+t47+t45
            t82 = t43**2
            t83 = 1/t11**2
            t84 = 6.21814d-2*t4*t82*t83
            t85 = 1/t1**2.3333333333333334d+0
            t86 = 1/t5**5
            t87 = 1/t1**1.6666666666666669d+0
            t88 = 2.539284902500284d+0*t41**2*t5/t9**3-1.269642451250142
     1         d+0*t42*t5*(7.876233178997433d-1*t6*(8.751370198886037d-2
     2         *t39*t7*t87+6.563527649164527d-2*t37*t7*t86+4.75369917939
     3         5351d-3*t85)+8.751370198886037d-2*t39*t8*t87+6.5635276491
     4         64527d-2*t37*t8*t86-2.625411059665811d-1*t38*t39*t40)-1.4
     5         107138347223802d-1*t10*t6*t87-4.23214150416714d-1*t38*t41
     6         *t42*t6-3.52678458680595d-2*t10*t37*t39
            t89 = -6.21814d-2*t4*t44*t88
            t90 = 5.495546528376876d-3*t43*t44*t46
            t91 = 1/t1**2.333333333333333d+0
            t92 = -3.663697685584584d-3*t12*t91
            t93 = t51**2
            t94 = 1/t23**2
            t95 = -3.37738d-2*t18*t93*t94
            t96 = -1.269642451250142d+0*t5*t50*(7.876233178997433d-1*t6*
     1         (8.751370198886037d-2*t19*t39*t87+6.563527649164527d-2*t1
     2         9*t37*t86+2.601716490612924d-3*t85)+8.751370198886037d-2*
     3         t20*t39*t87+6.563527649164527d-2*t20*t37*t86-2.6254110596
     4         65811d-1*t38*t39*t48)-1.4107138347223802d-1*t22*t6*t87-4.
     5         23214150416714d-1*t38*t49*t50*t6+2.539284902500284d+0*t49
     6         **2*t5/t21**3-3.52678458680595d-2*t22*t37*t39
            t97 = 3.37738d-2*t18*t52*t96
            t98 = -1.5539098445407465d-3*t46*t51*t52
            t99 = 1.0359398963604977d-3*t24*t91
            t100 = t25*t26*(-3.37738d-2*t18*t52*t96+3.37738d-2*t18*t93*t
     1         94+1.709920934161365d+0*(-1.7613865241785687d-3*t33*t91+3
     2         .663697685584584d-3*t12*t91+6.21814d-2*t4*t44*t88-3.10907
     3         d-2*t27*t59*(-1.269642451250142d+0*t5*t57*(7.876233178997
     4         433d-1*t6*(8.751370198886037d-2*t28*t39*t87+6.56352764916
     5         4527d-2*t28*t37*t86+3.0144339229749983d-3*t85)+8.75137019
     6         8886037d-2*t29*t39*t87+6.563527649164527d-2*t29*t37*t86-2
     7         .625411059665811d-1*t38*t39*t55)-1.4107138347223802d-1*t3
     8         1*t6*t87-4.23214150416714d-1*t38*t56*t57*t6+2.53928490250
     9         0284d+0*t5*t56**2/t30**3-3.52678458680595d-2*t31*t37*t39)
     :         -6.21814d-2*t4*t82*t83+2.642079786267853d-3*t46*t58*t59+3
     ;         .10907d-2*t27*t58**2/t32**2-5.495546528376876d-3*t43*t44*
     <         t46)-1.0359398963604977d-3*t24*t91+1.5539098445407465d-3*
     =         t46*t51*t52)
            t101 = -8*t25*t60*t62
            t102 = 20*t25*t34/t1**6
            t103 = t13**2
            t104 = 12*t103*t26*t34
            t105 = 1/t15**6.666666666666666d-1
            t106 = 1/t1**3
            t107 = -2*t106*t13
            t108 = 2*t66
            t109 = 1/t16**6.666666666666666d-1
            t110 = 2*t106*t13
            t111 = -2*t66
            fnc(iq) = 1.0d+0*t1*t36*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t75*wght+t76+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t81*wght+t76+Amat(iq,D1_RB)
            Amat2(iq,D2_RA_RA) = 1.0d+0*t1*(5.848223622634648d-1*t17*(t9
     1         9+t98+t97+t95-32*t34*t62*t64+8*t26*t60*t64+t104+t102+t101
     2         +t100)+t92+t90+t89+t84+1.1696447245269297d+0*t65*t74+5.84
     3         8223622634648d-1*t35*(2.564881401242048d+0*(t111+t110)*t7
     4         3+8.549604670806825d-1*t109*t72**2+2.564881401242048d+0*(
     5         t108+t107)*t70+8.549604670806825d-1*t105*t69**2))*wght+2.
     6         0d+0*t75*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t1*(5.848223622634648d-1*t17*(t9
     1         9+t98+t97+t95-12*t103*t26*t34+t102+t101+t100)+t92+t90+t89
     2         +t84+5.848223622634648d-1*t65*t80+5.848223622634648d-1*t3
     3         5*(8.549604670806825d-1*t109*t72*t79+8.549604670806825d-1
     4         *t105*t69*t78+5.129762802484096d+0*t106*t13*t73-5.1297628
     5         02484096d+0*t106*t13*t70)+5.848223622634648d-1*t74*t77)*w
     6         ght+1.0d+0*t81*wght+1.0d+0*t75*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*t1*(5.848223622634648d-1*t17*(t9
     1         9+t98+t97+t95+32*t34*t62*t64-8*t26*t60*t64+t104+t102+t101
     2         +t100)+t92+t90+t89+t84+1.1696447245269297d+0*t77*t80+5.84
     3         8223622634648d-1*t35*(8.549604670806825d-1*t109*t79**2+8.
     4         549604670806825d-1*t105*t78**2+2.564881401242048d+0*(t110
     5         +t108)*t73+2.564881401242048d+0*(t111+t107)*t70))*wght+2.
     6         0d+0*t81*wght+Amat2(iq,D2_RB_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = 1/rhoa**1.3333333333333333d+0
            t28 = 1/t8
            t29 = 1/t6**2
            t30 = 1/rhoa**1.3333333333333336d+0
            t31 = 1/t2**3
            t32 = 1/rhoa**6.666666666666667d-1
            t33 = -1.3127055298329054d-1*t31*t32*t4-2.0096226153166658d-
     1         3*t30
            t34 = 7.876233178997433d-1*t3*t33-1.3127055298329054d-1*t31*
     1         t32*t5
            t35 = 2.11607075208357d-1*t3*t32*t7-1.269642451250142d+0*t2*
     1         t29*t34
            t36 = 1/t16
            t37 = 1/t14**2
            t38 = -1.3127055298329054d-1*t12*t31*t32-3.169132786263567d-
     1         3*t30
            t39 = 7.876233178997433d-1*t3*t38-1.3127055298329054d-1*t13*
     1         t31*t32
            t40 = 2.11607075208357d-1*t15*t3*t32-1.269642451250142d+0*t2
     1         *t37*t39
            t41 = 1/t23
            t42 = 1/t21**2
            t43 = -1.3127055298329054d-1*t19*t31*t32-1.7344776604086162d
     1         -3*t30
            t44 = 7.876233178997433d-1*t3*t43-1.3127055298329054d-1*t20*
     1         t31*t32
            t45 = 2.11607075208357d-1*t22*t3*t32-1.269642451250142d+0*t2
     1         *t42*t44
            t46 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t27*t9+6.21814d-2*t18*t36*t40-3.10907
     2         d-2*t11*t28*t35-2.747773264188438d-3*t17*t27)-3.37738d-2*
     3         t25*t41*t45+7.769549222703733d-4*t24*t27)+3.37738d-2*t25*
     4         t41*t45-7.769549222703733d-4*t24*t27)-6.21814d-2*t18*t36*
     5         t40+2.747773264188438d-3*t17*t27
            t47 = 1/rhoa**2.333333333333333d+0
            t48 = 1/rhoa**2.3333333333333334d+0
            t49 = 1/rhoa**1.6666666666666669d+0
            t50 = 1/t2**5
            t51 = 1/t16**2
            t52 = t40**2
            t53 = -1.269642451250142d+0*t2*t37*(7.876233178997433d-1*t3*
     1         (6.563527649164527d-2*t12*t30*t50+8.751370198886037d-2*t1
     2         2*t31*t49+4.753699179395351d-3*t48)+6.563527649164527d-2*
     3         t13*t30*t50+8.751370198886037d-2*t13*t31*t49-2.6254110596
     4         65811d-1*t31*t32*t38)-1.4107138347223802d-1*t15*t3*t49+2.
     5         539284902500284d+0*t2*t39**2/t14**3-4.23214150416714d-1*t
     6         3*t32*t37*t39-3.52678458680595d-2*t15*t30*t31
            t54 = 1/t23**2
            t55 = t45**2
            t56 = -1.269642451250142d+0*t2*t42*(7.876233178997433d-1*t3*
     1         (6.563527649164527d-2*t19*t30*t50+8.751370198886037d-2*t1
     2         9*t31*t49+2.601716490612924d-3*t48)+6.563527649164527d-2*
     3         t20*t30*t50+8.751370198886037d-2*t20*t31*t49-2.6254110596
     4         65811d-1*t31*t32*t43)-1.4107138347223802d-1*t22*t3*t49+2.
     5         539284902500284d+0*t2*t44**2/t21**3-4.23214150416714d-1*t
     6         3*t32*t42*t44-3.52678458680595d-2*t22*t30*t31
            fnc(iq) = 1.0d+0*rhoa*t26*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t46*wght+1.0d+0*t26*wght+Amat(i
     1         q,D1_RA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*(5.848223622634643d-1*(1.0d
     1         +0*(1.709920934161365d+0*(-1.7613865241785687d-3*t47*t9+3
     2         .10907d-2*t11*t35**2/t8**2-3.10907d-2*t11*t28*(-1.4107138
     3         347223802d-1*t3*t49*t7-3.52678458680595d-2*t30*t31*t7+2.5
     4         39284902500284d+0*t2*t34**2/t6**3-1.269642451250142d+0*t2
     5         *t29*(7.876233178997433d-1*t3*(6.563527649164527d-2*t30*t
     6         4*t50+8.751370198886037d-2*t31*t4*t49+3.0144339229749983d
     7         -3*t48)+6.563527649164527d-2*t30*t5*t50+8.751370198886037
     8         d-2*t31*t49*t5-2.625411059665811d-1*t31*t32*t33)-4.232141
     9         50416714d-1*t29*t3*t32*t34)+6.21814d-2*t18*t36*t53-6.2181
     :         4d-2*t18*t51*t52+3.663697685584584d-3*t17*t47-5.495546528
     ;         376876d-3*t27*t36*t40+2.642079786267853d-3*t27*t28*t35)-3
     <         .37738d-2*t25*t41*t56+3.37738d-2*t25*t54*t55-1.0359398963
     =         604977d-3*t24*t47+1.5539098445407465d-3*t27*t41*t45)+3.37
     >         738d-2*t25*t41*t56-3.37738d-2*t25*t54*t55+1.0359398963604
     ?         977d-3*t24*t47-1.5539098445407465d-3*t27*t41*t45)-6.21814
     @         d-2*t18*t36*t53+6.21814d-2*t18*t51*t52-3.663697685584584d
     1         -3*t17*t47+5.495546528376876d-3*t27*t36*t40)*wght+2.0d+0*
     2         t46*wght+Amat2(iq,D2_RA_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = 1/rhob**1.3333333333333333d+0
            t28 = 1/t8
            t29 = 1/t6**2
            t30 = 1/rhob**1.3333333333333336d+0
            t31 = 1/t2**3
            t32 = 1/rhob**6.666666666666667d-1
            t33 = -1.3127055298329054d-1*t31*t32*t4-2.0096226153166658d-
     1         3*t30
            t34 = 7.876233178997433d-1*t3*t33-1.3127055298329054d-1*t31*
     1         t32*t5
            t35 = 2.11607075208357d-1*t3*t32*t7-1.269642451250142d+0*t2*
     1         t29*t34
            t36 = 1/t16
            t37 = 1/t14**2
            t38 = -1.3127055298329054d-1*t12*t31*t32-3.169132786263567d-
     1         3*t30
            t39 = 7.876233178997433d-1*t3*t38-1.3127055298329054d-1*t13*
     1         t31*t32
            t40 = 2.11607075208357d-1*t15*t3*t32-1.269642451250142d+0*t2
     1         *t37*t39
            t41 = 1/t23
            t42 = 1/t21**2
            t43 = -1.3127055298329054d-1*t19*t31*t32-1.7344776604086162d
     1         -3*t30
            t44 = 7.876233178997433d-1*t3*t43-1.3127055298329054d-1*t20*
     1         t31*t32
            t45 = 2.11607075208357d-1*t22*t3*t32-1.269642451250142d+0*t2
     1         *t42*t44
            t46 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t27*t9+6.21814d-2*t18*t36*t40-3.10907
     2         d-2*t11*t28*t35-2.747773264188438d-3*t17*t27)-3.37738d-2*
     3         t25*t41*t45+7.769549222703733d-4*t24*t27)+3.37738d-2*t25*
     4         t41*t45-7.769549222703733d-4*t24*t27)-6.21814d-2*t18*t36*
     5         t40+2.747773264188438d-3*t17*t27
            t47 = 1/rhob**2.333333333333333d+0
            t48 = 1/rhob**2.3333333333333334d+0
            t49 = 1/rhob**1.6666666666666669d+0
            t50 = 1/t2**5
            t51 = 1/t16**2
            t52 = t40**2
            t53 = -1.269642451250142d+0*t2*t37*(7.876233178997433d-1*t3*
     1         (6.563527649164527d-2*t12*t30*t50+8.751370198886037d-2*t1
     2         2*t31*t49+4.753699179395351d-3*t48)+6.563527649164527d-2*
     3         t13*t30*t50+8.751370198886037d-2*t13*t31*t49-2.6254110596
     4         65811d-1*t31*t32*t38)-1.4107138347223802d-1*t15*t3*t49+2.
     5         539284902500284d+0*t2*t39**2/t14**3-4.23214150416714d-1*t
     6         3*t32*t37*t39-3.52678458680595d-2*t15*t30*t31
            t54 = 1/t23**2
            t55 = t45**2
            t56 = -1.269642451250142d+0*t2*t42*(7.876233178997433d-1*t3*
     1         (6.563527649164527d-2*t19*t30*t50+8.751370198886037d-2*t1
     2         9*t31*t49+2.601716490612924d-3*t48)+6.563527649164527d-2*
     3         t20*t30*t50+8.751370198886037d-2*t20*t31*t49-2.6254110596
     4         65811d-1*t31*t32*t43)-1.4107138347223802d-1*t22*t3*t49+2.
     5         539284902500284d+0*t2*t44**2/t21**3-4.23214150416714d-1*t
     6         3*t32*t42*t44-3.52678458680595d-2*t22*t30*t31
            fnc(iq) = 1.0d+0*rhob*t26*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t46*wght+1.0d+0*t26*wght+Amat(i
     1         q,D1_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*(5.848223622634643d-1*(1.0d
     1         +0*(1.709920934161365d+0*(-1.7613865241785687d-3*t47*t9+3
     2         .10907d-2*t11*t35**2/t8**2-3.10907d-2*t11*t28*(-1.4107138
     3         347223802d-1*t3*t49*t7-3.52678458680595d-2*t30*t31*t7+2.5
     4         39284902500284d+0*t2*t34**2/t6**3-1.269642451250142d+0*t2
     5         *t29*(7.876233178997433d-1*t3*(6.563527649164527d-2*t30*t
     6         4*t50+8.751370198886037d-2*t31*t4*t49+3.0144339229749983d
     7         -3*t48)+6.563527649164527d-2*t30*t5*t50+8.751370198886037
     8         d-2*t31*t49*t5-2.625411059665811d-1*t31*t32*t33)-4.232141
     9         50416714d-1*t29*t3*t32*t34)+6.21814d-2*t18*t36*t53-6.2181
     :         4d-2*t18*t51*t52+3.663697685584584d-3*t17*t47-5.495546528
     ;         376876d-3*t27*t36*t40+2.642079786267853d-3*t27*t28*t35)-3
     <         .37738d-2*t25*t41*t56+3.37738d-2*t25*t54*t55-1.0359398963
     =         604977d-3*t24*t47+1.5539098445407465d-3*t27*t41*t45)+3.37
     >         738d-2*t25*t41*t56-3.37738d-2*t25*t54*t55+1.0359398963604
     ?         977d-3*t24*t47-1.5539098445407465d-3*t27*t41*t45)-6.21814
     @         d-2*t18*t36*t53+6.21814d-2*t18*t51*t52-3.663697685584584d
     1         -3*t17*t47+5.495546528376876d-3*t27*t36*t40)*wght+2.0d+0*
     2         t46*wght+Amat2(iq,D2_RB_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_c_pw91lda functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\beta+\rho_\alpha\\\\ 
C>   {\it t_2} &=& {\it t_1}^{0.3333333333333333}\\\\ 
C>   {\it t_3} &=& {{1}\over{{\it t_2}}}\\\\ 
C>   {\it t_4} &=& 0.1325688999052018\,{\it t_3}+1.0\\\\ 
C>   {\it t_5} &=& \sqrt{{\it t_2}}\\\\ 
C>   {\it t_6} &=& {{1}\over{{\it t_5}}}\\\\ 
C>   {\it t_7} &=& \log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.02414199311453321\,{\it t_6}
C>    +0.10186556948\right)+0.22308199064\right)+0.47231125998}}
C>    +1.0\right)\\\\ 
C>   {\it t_8} &=& \rho_\alpha-\rho_\beta\\\\ 
C>   {\it t_9} &=& {{1}\over{{\it t_1}}}\\\\ 
C>   {\it t_{10}} &=& 0.06901399211255826\,{\it t_3}+1.0\\\\ 
C>   {\it t_{11}} &=& \log \left({{1.269642451250142\,{
C>    \it t_5}}\over{0.7876233178997433\,{\it t_6}\,
C>    \left(0.7876233178997433\,{\it t_6}\,\left(0.01321299881039884
C>    \,{\it t_6}+0.029729725188\right)+0.12236585478\right)
C>    +0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{12}} &=& \rho_s^{0.3333333333333333}\\\\ 
C>   {\it t_{13}} &=& \sqrt{{\it t_{12}}}\\\\ 
C>   {\it t_{14}} &=& {{1}\over{{\it t_{13}}}}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{\it t_{12}}}}\\\\ 
C>   {\it t_{16}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{13}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.02414199311453321\,{\it t_{14}}+0.10186556948\right)
C>    \,{\it t_{14}}+0.22308199064\right)\,{\it t_{14}}
C>    +0.47231125998}}+1.0\right)\\\\ 
C>   {\it t_{17}} &=& 0.1325688999052018\,{\it t_{15}}+1.0\\\\ 
C>   {\it t_{18}} &=& \log \left({{1.269642451250142\,{
C>    \it t_{13}}}\over{0.7876233178997433\,\left(0.7876233178997433
C>    \,\left(0.01321299881039884\,{\it t_{14}}
C>    +0.029729725188\right)\,{\it t_{14}}+0.12236585478\right)\,{
C>    \it t_{14}}+0.3497952466}}+1.0\right)\\\\ 
C>   {\it t_{19}} &=& 0.06901399211255826\,{\it t_{15}}+1.0\\\\ 
C>   f &=& 1.0\,{\it t_1}\,\left(0.5848223622634648\,
C>    \left(1.923661050931536\,\left({\it t_8}\,{\it t_9}
C>    +1.0\right)^{{{4}\over{3}}}+1.923661050931536\,\left(1.0-{
C>    \it t_8}\,{\it t_9}\right)^{{{4}\over{3}}}
C>    -3.847322101863072\right)\,\left({{{\it t_8}^4\,
C>    \left(1.709920934161365\,\left(0.0621814\,{\it t_4}\,{\it t_7}
C>    -0.0310907\,\left(0.1274696188700087\,{\it t_3}+1.0\right)
C>    \,\log \left({{1.269642451250142\,{\it t_5}}
C>    \over{0.7876233178997433\,{\it t_6}\,\left(0.7876233178997433
C>    \,{\it t_6}\,\left(0.01530901310039024\,{\it t_6}
C>    +0.10465751434\right)+0.19269083139\right)+0.43896648423}}
C>    +1.0\right)\right)-0.0337738\,{\it t_{10}}\,{
C>    \it t_{11}}\right)}\over{{\it t_1}^4}}+0.0337738\,{\it t_{10}}
C>    \,{\it t_{11}}\right)-0.0621814\,{\it t_4}\,{\it t_7}\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& 1.0\,\left(0.5848223622634643\,\left(0.0337738\,{
C>    \it t_{18}}\,{\it t_{19}}+1.0\,\left(1.709920934161365\,
C>    \left(0.0621814\,{\it t_{16}}\,{\it t_{17}}-0.0310907
C>    \,\log \left({{1.269642451250142\,{\it t_{13}}}
C>    \over{0.7876233178997433\,\left(0.7876233178997433\,
C>    \left(0.01530901310039024\,{\it t_{14}}+0.10465751434\right)
C>    \,{\it t_{14}}+0.19269083139\right)\,{\it t_{14}}
C>    +0.43896648423}}+1.0\right)\,\left(0.1274696188700087\,{
C>    \it t_{15}}+1.0\right)\right)-0.0337738\,{\it t_{18}}\,{
C>    \it t_{19}}\right)\right)-0.0621814\,{\it t_{16}}\,{
C>    \it t_{17}}\right)\,\rho_s\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] JP Perdew, Y Wang, Phys.Rev.B 45, 13244 (1992)  , DOI: 
C> <a href="https://doi.org/10.1103/PhysRevB.45.13244 "> 
C> 10.1103/PhysRevB.45.13244 </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_c_pw91lda_d3(param,tol_rho,ipol,nq,wght, 
     +rho,fnc,Amat,Amat2,Amat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
c 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          if (rhoa.gt.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1/t1
            t5 = 2.1508070719090538d-2*t3+1.0186556948d-1
            t6 = 7.016926042943222d-1*t3*t5+2.2308199064d-1
            t7 = 7.016926042943222d-1*t3*t6+4.7231125998d-1
            t8 = 1/t7
            t9 = 1.425125466450768d+0*t2*t8+1.0d+0
            t10 = log(t9)
            t11 = 1.0522000558389213d-1*t4+1.0d+0
            t12 = 1/rhoa**1.3333333333333333d+0
            t13 = 1/t9
            t14 = 1/t7**2
            t15 = 1/rhoa**1.3333333333333336d+0
            t16 = 1/t2**3
            t17 = 1/rhoa**6.666666666666667d-1
            t18 = -5.847438369119352d-2*t16*t17*t5-1.2576711796854242d-3
     1         *t15
            t19 = 7.016926042943222d-1*t18*t3-5.847438369119352d-2*t16*t
     1         17*t6
            t20 = 1.1876045553756398d-1*t17*t3*t8-1.425125466450768d+0*t
     1         14*t19*t2
            t21 = 1.090454542535705d-3*t10*t12-6.21814d-2*t11*t13*t20
            t22 = 2.0d+0*t21*wght
            t23 = 1/rhoa**2.333333333333333d+0
            t24 = -7.269696950238034d-4*t10*t23
            t25 = 1.1771443702974158d-2*t3+2.9729725188d-2
            t26 = 7.016926042943222d-1*t25*t3+1.2236585478d-1
            t27 = 7.016926042943222d-1*t26*t3+3.497952466d-1
            t28 = 1/t27
            t29 = 1.425125466450768d+0*t2*t28+1.0d+0
            t30 = log(t29)
            t31 = 5.477644184000001d-2*t4+1.0d+0
            t32 = 1/rhoa**2
            t33 = 2.18090908507141d-3*t12*t13*t20
            t34 = 1/t9**2
            t35 = t20**2
            t36 = 6.21814d-2*t11*t34*t35
            t37 = 1/t7**3
            t38 = t19**2
            t39 = 1/rhoa**2.3333333333333334d+0
            t40 = 1/rhoa**1.6666666666666669d+0
            t41 = 1/t2**5
            t42 = 1.4618595922798375d-2*t15*t41*t5+1.949146123039784d-2*
     1         t16*t40*t5+9.432533847640683d-4*t39
            t43 = 1.4618595922798375d-2*t15*t41*t6+1.949146123039784d-2*
     1         t16*t40*t6+7.016926042943222d-1*t3*t42-1.1694876738238703
     2         d-1*t16*t17*t18
            t44 = -3.9586818512521327d-2*t3*t40*t8-9.896704628130328d-3*
     1         t15*t16*t8-1.425125466450768d+0*t14*t2*t43+2.850250932901
     2         536d+0*t2*t37*t38-2.3752091107512796d-1*t14*t17*t19*t3
            t45 = -6.21814d-2*t11*t13*t44
            t46 = t45+t36+t33+8.443450000000001d-3*t30*t31*t32+t24
            t47 = t45+t36+t33-8.44345d-3*t30*t31*t32+t24
            t48 = 8.48131310861104d-4*t10/rhoa**3.333333333333333d+0
            t49 = 1/rhoa**3
            t50 = -2.1809090850714105d-3*t13*t20*t23
            t51 = 3.37738d-2*(1.1876045553756398d-1*t17*t28*t3-1.4251254
     1         66450768d+0*t2*(7.016926042943222d-1*(-5.847438369119352d
     2         -2*t16*t17*t25-6.883279156869946d-4*t15)*t3-5.84743836911
     3         9352d-2*t16*t17*t26)/t27**2)*t31/t29-3.083347652359653d-4
     4         *t12*t30
            t52 = -3.2713636276071156d-3*t12*t34*t35
            t53 = 3.2713636276071156d-3*t12*t13*t44
            t54 = -1.243628d-1*t11*t20**3/t9**3
            t55 = 1.865442d-1*t11*t20*t34*t44
            t56 = 1/rhoa**2.666666666666667d+0
            t57 = 1/t2**7
            t58 = 1/rhoa**2.0d+0
            t59 = -6.21814d-2*t11*t13*(2.474176157032582d-3*t41*t58*t8+3
     1         .29890154271011d-2*t3*t56*t8+9.89670462813033d-3*t16*t39*
     2         t8-8.550752798704606d+0*t19**3*t2/t7**4-1.425125466450768
     3         d+0*t14*t2*(-6.091081634499322d-3*t57*t58*t6-1.6242884358
     4         664864d-2*t16*t56*t6-1.4618595922798375d-2*t39*t41*t6+7.0
     5         16926042943222d-1*t3*(-6.091081634499322d-3*t5*t57*t58-1.
     6         6242884358664864d-2*t16*t5*t56-1.4618595922798375d-2*t39*
     7         t41*t5-1.161599075681677d-3/rhoa**3.3333333333333337d+0)-
     8         1.7542315107358056d-1*t16*t17*t42+4.385578776839513d-2*t1
     9         5*t18*t41+5.847438369119352d-2*t16*t18*t40)+8.55075279870
     :         4606d+0*t19*t2*t37*t43-3.5628136661269194d-1*t14*t17*t3*t
     ;         43+1.1876045553756398d-1*t14*t19*t3*t40+7.125627332253839
     <         d-1*t17*t3*t37*t38+2.969011388439098d-2*t14*t15*t16*t19)
            fnc(iq) = fnc(iq)-1.243628d-1*rhoa*log(1.4251254664507676d+0
     1         *t2/(7.016926042943223d-1*t3*(7.016926042943223d-1*(2.150
     2         807071909054d-2*t3+1.0186556948d-1)*t3+2.2308199064d-1)+4
     3         .7231125998d-1)+1.0d+0)*(1.0522000558389215d-1*t4+1.0d+0)
     4         *wght
            Amat(iq,D1_RA) = 2.0d+0*rhoa*t21*wght-6.21814d-2*t10*t11*wgh
     1         t+Amat(iq,D1_RA)
            Amat2(iq,D2_RA_RA) = 2.0d+0*rhoa*t46*wght+t22+Amat2(iq,D2_RA
     1         _RA)
            Amat2(iq,D2_RA_RB) = 2.0d+0*rhoa*t47*wght+t22+Amat2(iq,D2_RA
     1         _RB)
            Amat3(iq,D3_RA_RA_RA) = 2.0d+0*rhoa*(t59+t55+t54+t53+t52+7.5
     1         00000000000002d-1*t32*t51+t50-2.533035d-2*t30*t31*t49+t48
     2         )*wght+3.0d+0*t46*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 2.0d+0*rhoa*(t59+t55+t54+t53+t52-2.4
     1         999999999999994d-1*t32*t51+t50+8.44345d-3*t30*t31*t49+t48
     2         )*wght+2.0d+0*t47*wght+1.0d+0*t46*wght+Amat3(iq,D3_RA_RA_
     3         RB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob+rhoa
            t2 = t1**3.333333333333333d-1
            t3 = 1/t2
            t4 = 1.325688999052018d-1*t3+1.0d+0
            t5 = t2**5.0d-1
            t6 = 1/t5
            t7 = 2.4141993114533214d-2*t6+1.0186556948d-1
            t8 = 7.876233178997433d-1*t6*t7+2.2308199064d-1
            t9 = 7.876233178997433d-1*t6*t8+4.7231125998d-1
            t10 = 1/t9
            t11 = 1.269642451250142d+0*t10*t5+1.0d+0
            t12 = log(t11)
            t13 = rhoa-rhob
            t14 = 1/t1
            t15 = 1.0d+0-t13*t14
            t16 = t13*t14+1.0d+0
            t17 = 1.923661050931536d+0*t16**1.3333333333333333d+0+1.9236
     1         61050931536d+0*t15**1.3333333333333333d+0-3.8473221018630
     2         72d+0
            t18 = 6.901399211255826d-2*t3+1.0d+0
            t19 = 1.3212998810398843d-2*t6+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t6+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t6+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t22*t5+1.0d+0
            t24 = log(t23)
            t25 = t13**4
            t26 = 1/t1**4
            t27 = 1.2746961887000874d-1*t3+1.0d+0
            t28 = 1.530901310039024d-2*t6+1.0465751434d-1
            t29 = 7.876233178997433d-1*t28*t6+1.9269083139d-1
            t30 = 7.876233178997433d-1*t29*t6+4.3896648423d-1
            t31 = 1/t30
            t32 = 1.269642451250142d+0*t31*t5+1.0d+0
            t33 = log(t32)
            t34 = 1.709920934161365d+0*(6.21814d-2*t12*t4-3.10907d-2*t27
     1         *t33)-3.37738d-2*t18*t24
            t35 = t25*t26*t34+3.37738d-2*t18*t24
            t36 = 5.848223622634648d-1*t17*t35-6.21814d-2*t12*t4
            t37 = 1/t1**1.3333333333333336d+0
            t38 = 1/t1**6.666666666666667d-1
            t39 = 1/t5**3
            t40 = -1.3127055298329054d-1*t38*t39*t7-3.169132786263567d-3
     1         *t37
            t41 = 7.876233178997433d-1*t40*t6-1.3127055298329054d-1*t38*
     1         t39*t8
            t42 = 1/t9**2
            t43 = 2.11607075208357d-1*t10*t38*t6-1.269642451250142d+0*t4
     1         1*t42*t5
            t44 = 1/t11
            t45 = -6.21814d-2*t4*t43*t44
            t46 = 1/t1**1.3333333333333333d+0
            t47 = 2.747773264188438d-3*t12*t46
            t48 = -1.3127055298329054d-1*t19*t38*t39-1.7344776604086162d
     1         -3*t37
            t49 = 7.876233178997433d-1*t48*t6-1.3127055298329054d-1*t20*
     1         t38*t39
            t50 = 1/t21**2
            t51 = 2.11607075208357d-1*t22*t38*t6-1.269642451250142d+0*t4
     1         9*t5*t50
            t52 = 1/t23
            t53 = 3.37738d-2*t18*t51*t52
            t54 = -7.769549222703733d-4*t24*t46
            t55 = -1.3127055298329054d-1*t28*t38*t39-2.0096226153166658d
     1         -3*t37
            t56 = 7.876233178997433d-1*t55*t6-1.3127055298329054d-1*t29*
     1         t38*t39
            t57 = 1/t30**2
            t58 = 2.11607075208357d-1*t31*t38*t6-1.269642451250142d+0*t5
     1         *t56*t57
            t59 = 1/t32
            t60 = 1.709920934161365d+0*(-3.10907d-2*t27*t58*t59+1.321039
     1         8931339265d-3*t33*t46-2.747773264188438d-3*t12*t46+6.2181
     2         4d-2*t4*t43*t44)-3.37738d-2*t18*t51*t52+7.769549222703733
     3         d-4*t24*t46
            t61 = t25*t26*t60
            t62 = 1/t1**5
            t63 = -4*t25*t34*t62
            t64 = t13**3
            t65 = 4*t26*t34*t64+t63+t61+t54+t53
            t66 = 1/t1**2
            t67 = t13*t66
            t68 = -t14
            t69 = t68+t67
            t70 = t15**3.333333333333333d-1
            t71 = -t13*t66
            t72 = t71+t14
            t73 = t16**3.333333333333333d-1
            t74 = 2.564881401242048d+0*t72*t73+2.564881401242048d+0*t69*
     1         t70
            t75 = 5.848223622634648d-1*t35*t74+5.848223622634648d-1*t17*
     1         t65+t47+t45
            t76 = 1.0d+0*t36*wght
            t77 = -4*t26*t34*t64+t63+t61+t54+t53
            t78 = t67+t14
            t79 = t71+t68
            t80 = 2.564881401242048d+0*t73*t79+2.564881401242048d+0*t70*
     1         t78
            t81 = 5.848223622634648d-1*t35*t80+5.848223622634648d-1*t17*
     1         t77+t47+t45
            t82 = t43**2
            t83 = 1/t11**2
            t84 = 6.21814d-2*t4*t82*t83
            t85 = t41**2
            t86 = 1/t9**3
            t87 = 1/t1**2.3333333333333334d+0
            t88 = 1/t5**5
            t89 = 1/t1**1.6666666666666669d+0
            t90 = 8.751370198886037d-2*t39*t7*t89+6.563527649164527d-2*t
     1         37*t7*t88+4.753699179395351d-3*t87
            t91 = 7.876233178997433d-1*t6*t90+8.751370198886037d-2*t39*t
     1         8*t89+6.563527649164527d-2*t37*t8*t88-2.625411059665811d-
     2         1*t38*t39*t40
            t92 = -1.269642451250142d+0*t42*t5*t91-1.4107138347223802d-1
     1         *t10*t6*t89+2.539284902500284d+0*t5*t85*t86-4.23214150416
     2         714d-1*t38*t41*t42*t6-3.52678458680595d-2*t10*t37*t39
            t93 = -6.21814d-2*t4*t44*t92
            t94 = 5.495546528376876d-3*t43*t44*t46
            t95 = 1/t1**2.333333333333333d+0
            t96 = -3.663697685584584d-3*t12*t95
            t97 = t51**2
            t98 = 1/t23**2
            t99 = -3.37738d-2*t18*t97*t98
            t100 = t49**2
            t101 = 1/t21**3
            t102 = 8.751370198886037d-2*t19*t39*t89+6.563527649164527d-2
     1         *t19*t37*t88+2.601716490612924d-3*t87
            t103 = 8.751370198886037d-2*t20*t39*t89+6.563527649164527d-2
     1         *t20*t37*t88+7.876233178997433d-1*t102*t6-2.6254110596658
     2         11d-1*t38*t39*t48
            t104 = -1.4107138347223802d-1*t22*t6*t89-4.23214150416714d-1
     1         *t38*t49*t50*t6-1.269642451250142d+0*t103*t5*t50+2.539284
     2         902500284d+0*t100*t101*t5-3.52678458680595d-2*t22*t37*t39
            t105 = 3.37738d-2*t104*t18*t52
            t106 = -1.5539098445407465d-3*t46*t51*t52
            t107 = 1.0359398963604977d-3*t24*t95
            t108 = t58**2
            t109 = 1/t32**2
            t110 = t56**2
            t111 = 1/t30**3
            t112 = 8.751370198886037d-2*t28*t39*t89+6.563527649164527d-2
     1         *t28*t37*t88+3.0144339229749983d-3*t87
            t113 = 8.751370198886037d-2*t29*t39*t89+6.563527649164527d-2
     1         *t29*t37*t88+7.876233178997433d-1*t112*t6-2.6254110596658
     2         11d-1*t38*t39*t55
            t114 = -1.4107138347223802d-1*t31*t6*t89-4.23214150416714d-1
     1         *t38*t56*t57*t6-1.269642451250142d+0*t113*t5*t57+2.539284
     2         902500284d+0*t110*t111*t5-3.52678458680595d-2*t31*t37*t39
            t115 = 3.37738d-2*t18*t97*t98+1.709920934161365d+0*(-1.76138
     1         65241785687d-3*t33*t95+3.663697685584584d-3*t12*t95+6.218
     2         14d-2*t4*t44*t92-6.21814d-2*t4*t82*t83+2.642079786267853d
     3         -3*t46*t58*t59-3.10907d-2*t114*t27*t59-5.495546528376876d
     4         -3*t43*t44*t46+3.10907d-2*t108*t109*t27)-1.03593989636049
     5         77d-3*t24*t95+1.5539098445407465d-3*t46*t51*t52-3.37738d-
     6         2*t104*t18*t52
            t116 = t115*t25*t26
            t117 = -8*t25*t60*t62
            t118 = 1/t1**6
            t119 = 20*t118*t25*t34
            t120 = t13**2
            t121 = 12*t120*t26*t34
            t122 = t99-32*t34*t62*t64+8*t26*t60*t64+t121+t119+t117+t116+
     1         t107+t106+t105
            t123 = t69**2
            t124 = 1/t15**6.666666666666666d-1
            t125 = 1/t1**3
            t126 = -2*t125*t13
            t127 = 2*t66
            t128 = t127+t126
            t129 = t72**2
            t130 = 1/t16**6.666666666666666d-1
            t131 = 2*t125*t13
            t132 = -2*t66
            t133 = t132+t131
            t134 = 2.564881401242048d+0*t133*t73+2.564881401242048d+0*t1
     1         28*t70+8.549604670806825d-1*t129*t130+8.549604670806825d-
     2         1*t123*t124
            t135 = t96+t94+t93+t84+1.1696447245269297d+0*t65*t74+5.84822
     1         3622634648d-1*t134*t35+5.848223622634648d-1*t122*t17
            t136 = t99-12*t120*t26*t34+t119+t117+t116+t107+t106+t105
            t137 = 8.549604670806825d-1*t130*t72*t79+8.549604670806825d-
     1         1*t124*t69*t78+5.129762802484096d+0*t125*t13*t73-5.129762
     2         802484096d+0*t125*t13*t70
            t138 = t96+t94+t93+t84+5.848223622634648d-1*t65*t80+5.848223
     1         622634648d-1*t74*t77+5.848223622634648d-1*t137*t35+5.8482
     2         23622634648d-1*t136*t17
            t139 = t99+32*t34*t62*t64-8*t26*t60*t64+t121+t119+t117+t116+
     1         t107+t106+t105
            t140 = t78**2
            t141 = t132+t126
            t142 = t79**2
            t143 = t131+t127
            t144 = 2.564881401242048d+0*t143*t73+2.564881401242048d+0*t1
     1         41*t70+8.549604670806825d-1*t130*t142+8.549604670806825d-
     2         1*t124*t140
            t145 = t96+t94+t93+t84+1.1696447245269297d+0*t77*t80+5.84822
     1         3622634648d-1*t144*t35+5.848223622634648d-1*t139*t17
            t146 = t43**3
            t147 = 1/t11**3
            t148 = -1.243628d-1*t146*t147*t4
            t149 = 1.865442d-1*t4*t43*t83*t92
            t150 = -8.243319792565315d-3*t46*t82*t83
            t151 = 1/t1**3.3333333333333337d+0
            t152 = 1/t1**2.0d+0
            t153 = 1/t5**7
            t154 = 1/t1**2.666666666666667d+0
            t155 = 7.617854707500852d+0*t41*t5*t86*t91-6.34821225625071d
     1         -1*t38*t42*t6*t91-1.269642451250142d+0*t42*t5*(-3.9381165
     2         894987163d-1*t38*t39*t90+2.625411059665811d-1*t39*t40*t89
     3         +7.876233178997433d-1*t6*(-1.3127055298329054d-1*t7*t87*t
     4         88-1.4585616998143394d-1*t154*t39*t7-5.469606374303773d-2
     5         *t152*t153*t7-1.1708185015918181d-2*t151)-1.3127055298329
     6         054d-1*t8*t87*t88+1.9690582947493582d-1*t37*t40*t88-1.458
     7         5616998143394d-1*t154*t39*t8-5.469606374303773d-2*t152*t1
     8         53*t8)-7.617854707500852d+0*t41**3*t5/t9**4+4.23214150416
     9         71406d-1*t41*t42*t6*t89+1.763392293402975d-2*t10*t152*t88
     :         +7.053569173611901d-2*t10*t39*t87+1.269642451250142d+0*t3
     ;         8*t6*t85*t86+2.3511897245373004d-1*t10*t154*t6+1.05803537
     <         60417849d-1*t37*t39*t41*t42
            t156 = -6.21814d-2*t155*t4*t44
            t157 = 8.243319792565315d-3*t44*t46*t92
            t158 = -1.0991093056753751d-2*t43*t44*t95
            t159 = 1/t1**3.333333333333333d+0
            t160 = 8.548627933030694d-3*t12*t159
            t161 = 1/t15**1.6666666666666669d+0
            t162 = 6*t13*t26
            t163 = -6*t125
            t164 = 1/t16**1.6666666666666669d+0
            t165 = -6*t13*t26
            t166 = 6*t125
            t167 = t51**3
            t168 = 1/t23**3
            t169 = 6.75476d-2*t167*t168*t18
            t170 = -1.013214d-1*t104*t18*t51*t98
            t171 = 2.33086476681112d-3*t46*t97*t98
            t172 = -1.269642451250142d+0*t5*t50*(2.625411059665811d-1*t3
     1         9*t48*t89+7.876233178997433d-1*t6*(-1.3127055298329054d-1
     2         *t19*t87*t88-1.4585616998143394d-1*t154*t19*t39-5.4696063
     3         74303773d-2*t152*t153*t19-6.407931356509611d-3*t151)-1.31
     4         27055298329054d-1*t20*t87*t88+1.9690582947493582d-1*t37*t
     5         48*t88-3.9381165894987163d-1*t102*t38*t39-1.4585616998143
     6         394d-1*t154*t20*t39-5.469606374303773d-2*t152*t153*t20)+4
     7         .2321415041671406d-1*t49*t50*t6*t89+1.763392293402975d-2*
     8         t152*t22*t88+7.053569173611901d-2*t22*t39*t87-6.348212256
     9         25071d-1*t103*t38*t50*t6+1.269642451250142d+0*t100*t101*t
     :         38*t6+2.3511897245373004d-1*t154*t22*t6+1.058035376041784
     ;         9d-1*t37*t39*t49*t50-7.617854707500852d+0*t49**3*t5/t21**
     <         4+7.617854707500852d+0*t101*t103*t49*t5
            t173 = 3.37738d-2*t172*t18*t52
            t174 = -2.33086476681112d-3*t104*t46*t52
            t175 = 3.107819689081493d-3*t51*t52*t95
            t176 = -2.4171930915078277d-3*t159*t24
            t177 = t25*t26*(-2.33086476681112d-3*t46*t97*t98+1.013214d-1
     1         *t104*t18*t51*t98+1.709920934161365d+0*(-5.28415957253570
     2         6d-3*t58*t59*t95+1.0991093056753751d-2*t43*t44*t95-1.8654
     3         42d-1*t4*t43*t83*t92-8.243319792565315d-3*t44*t46*t92-3.1
     4         0907d-2*t27*t59*(-1.269642451250142d+0*t5*t57*(2.62541105
     5         9665811d-1*t39*t55*t89+7.876233178997433d-1*t6*(-1.312705
     6         5298329054d-1*t28*t87*t88-1.4585616998143394d-1*t154*t28*
     7         t39-5.469606374303773d-2*t152*t153*t28-7.424439106586571d
     8         -3*t151)-1.3127055298329054d-1*t29*t87*t88+1.969058294749
     9         3582d-1*t37*t55*t88-3.9381165894987163d-1*t112*t38*t39-1.
     :         4585616998143394d-1*t154*t29*t39-5.469606374303773d-2*t15
     ;         2*t153*t29)+4.2321415041671406d-1*t56*t57*t6*t89+1.763392
     <         293402975d-2*t152*t31*t88+7.053569173611901d-2*t31*t39*t8
     =         7-6.34821225625071d-1*t113*t38*t57*t6+1.269642451250142d+
     >         0*t110*t111*t38*t6+2.3511897245373004d-1*t154*t31*t6+1.05
     ?         80353760417849d-1*t37*t39*t56*t57-7.617854707500852d+0*t5
     @         *t56**3/t30**4+7.617854707500852d+0*t111*t113*t5*t56)+8.2
     1         43319792565315d-3*t46*t82*t83+3.96311967940178d-3*t114*t4
     2         6*t59-6.21814d-2*t27*t58**3/t32**3+9.327209999999999d-2*t
     3         109*t114*t27*t58-3.96311967940178d-3*t108*t109*t46+6.2181
     4         4d-2*t155*t4*t44+1.243628d-1*t146*t147*t4+4.1099018897499
     5         934d-3*t159*t33-8.548627933030694d-3*t12*t159)-3.10781968
     6         9081493d-3*t51*t52*t95+2.33086476681112d-3*t104*t46*t52-3
     7         .37738d-2*t172*t18*t52+2.4171930915078277d-3*t159*t24-6.7
     8         5476d-2*t167*t168*t18)
            t178 = -12*t115*t25*t62
            t179 = 60*t118*t25*t60
            t180 = 36*t120*t26*t60
            t181 = -120*t25*t34/t1**7
            t182 = -144*t120*t34*t62
            t183 = 24*t13*t26*t34
            t184 = 2.0d+0*t138*wght
            t185 = -12*t120*t26*t60
            t186 = 48*t120*t34*t62
            t187 = -24*t13*t26*t34
            fnc(iq) = 1.0d+0*t1*t36*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*t1*t75*wght+t76+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = 1.0d+0*t1*t81*wght+t76+Amat(iq,D1_RB)
            Amat2(iq,D2_RA_RA) = 2.0d+0*t75*wght+1.0d+0*t1*t135*wght+Ama
     1         t2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = 1.0d+0*t81*wght+1.0d+0*t75*wght+1.0d+0*
     1         t1*t138*wght+Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = 2.0d+0*t81*wght+1.0d+0*t1*t145*wght+Ama
     1         t2(iq,D2_RB_RB)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*t1*(1.7544670867903944d+0*t12
     1         2*t74+5.848223622634648d-1*t35*(2.564881401242048d+0*(t16
     2         6+t165)*t73-5.69973644720455d-1*t164*t72**3+2.56488140124
     3         20473d+0*t130*t133*t72+2.564881401242048d+0*(t163+t162)*t
     4         70-5.69973644720455d-1*t161*t69**3+2.5648814012420473d+0*
     5         t124*t128*t69)+1.7544670867903944d+0*t134*t65+5.848223622
     6         634648d-1*t17*(-96*t60*t62*t64+240*t118*t34*t64+12*t115*t
     7         26*t64+t183+t182+t181+t180+t179+t178+t177+t176+t175+t174+
     8         t173+t171+t170+t169)+t160+t158+t157+t156+t150+t149+t148)*
     9         wght+3.0d+0*t135*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = 1.0d+0*t1*(5.848223622634648d-1*t122
     1         *t80+5.848223622634648d-1*t35*(-5.69973644720455d-1*t129*
     2         t164*t79+8.549604670806825d-1*t130*t133*t79-5.69973644720
     3         455d-1*t123*t161*t78+8.549604670806825d-1*t124*t128*t78+2
     4         .564881401242048d+0*(t165+2*t125)*t73+3.41984186832273d+0
     5         *t125*t13*t130*t72+2.564881401242048d+0*(t162-2*t125)*t70
     6         -3.41984186832273d+0*t124*t125*t13*t69)+5.848223622634648
     7         d-1*t134*t77+1.1696447245269297d+0*t136*t74+1.16964472452
     8         69297d+0*t137*t65+5.848223622634648d-1*t17*(-32*t60*t62*t
     9         64+80*t118*t34*t64+4*t115*t26*t64+t187+t186+t185+t181+t17
     :         9+t178+t177+t176+t175+t174+t173+t171+t170+t169)+t160+t158
     ;         +t157+t156+t150+t149+t148)*wght+1.0d+0*t135*wght+t184+Ama
     <         t3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = 1.0d+0*t1*(1.1696447245269297d+0*t13
     1         6*t80+5.848223622634648d-1*t35*(3.41984186832273d+0*t125*
     2         t13*t130*t79-3.41984186832273d+0*t124*t125*t13*t78-1.5389
     3         288407452287d+1*t13*t26*t73-5.129762802484096d+0*t125*t73
     4         -5.69973644720455d-1*t142*t164*t72+8.549604670806825d-1*t
     5         130*t143*t72+1.5389288407452287d+1*t13*t26*t70+5.12976280
     6         2484096d+0*t125*t70-5.69973644720455d-1*t140*t161*t69+8.5
     7         49604670806825d-1*t124*t141*t69)+1.1696447245269297d+0*t1
     8         37*t77+5.848223622634648d-1*t139*t74+5.848223622634648d-1
     9         *t144*t65+5.848223622634648d-1*t17*(32*t60*t62*t64-80*t11
     :         8*t34*t64-4*t115*t26*t64+t186+t185+t183+t181+t179+t178+t1
     ;         77+t176+t175+t174+t173+t171+t170+t169)+t160+t158+t157+t15
     <         6+t150+t149+t148)*wght+1.0d+0*t145*wght+t184+Amat3(iq,D3_
     =         RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*t1*(1.7544670867903944d+0*t13
     1         9*t80+5.848223622634648d-1*t35*(-5.69973644720455d-1*t164
     2         *t79**3+2.5648814012420473d+0*t130*t143*t79-5.69973644720
     3         455d-1*t161*t78**3+2.5648814012420473d+0*t124*t141*t78+2.
     4         564881401242048d+0*(t165+t163)*t73+2.564881401242048d+0*(
     5         t166+t162)*t70)+1.7544670867903944d+0*t144*t77+5.84822362
     6         2634648d-1*t17*(96*t60*t62*t64-240*t118*t34*t64-12*t115*t
     7         26*t64+t187+t182+t181+t180+t179+t178+t177+t176+t175+t174+
     8         t173+t171+t170+t169)+t160+t158+t157+t156+t150+t149+t148)*
     9         wght+3.0d+0*t145*wght+Amat3(iq,D3_RB_RB_RB)
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = rhoa**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = 1/rhoa**1.3333333333333333d+0
            t28 = 1/t8
            t29 = 1/t6**2
            t30 = 1/rhoa**1.3333333333333336d+0
            t31 = 1/t2**3
            t32 = 1/rhoa**6.666666666666667d-1
            t33 = -1.3127055298329054d-1*t31*t32*t4-2.0096226153166658d-
     1         3*t30
            t34 = 7.876233178997433d-1*t3*t33-1.3127055298329054d-1*t31*
     1         t32*t5
            t35 = 2.11607075208357d-1*t3*t32*t7-1.269642451250142d+0*t2*
     1         t29*t34
            t36 = 1/t16
            t37 = 1/t14**2
            t38 = -1.3127055298329054d-1*t12*t31*t32-3.169132786263567d-
     1         3*t30
            t39 = 7.876233178997433d-1*t3*t38-1.3127055298329054d-1*t13*
     1         t31*t32
            t40 = 2.11607075208357d-1*t15*t3*t32-1.269642451250142d+0*t2
     1         *t37*t39
            t41 = 1/t23
            t42 = 1/t21**2
            t43 = -1.3127055298329054d-1*t19*t31*t32-1.7344776604086162d
     1         -3*t30
            t44 = 7.876233178997433d-1*t3*t43-1.3127055298329054d-1*t20*
     1         t31*t32
            t45 = 2.11607075208357d-1*t22*t3*t32-1.269642451250142d+0*t2
     1         *t42*t44
            t46 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t27*t9+6.21814d-2*t18*t36*t40-3.10907
     2         d-2*t11*t28*t35-2.747773264188438d-3*t17*t27)-3.37738d-2*
     3         t25*t41*t45+7.769549222703733d-4*t24*t27)+3.37738d-2*t25*
     4         t41*t45-7.769549222703733d-4*t24*t27)-6.21814d-2*t18*t36*
     5         t40+2.747773264188438d-3*t17*t27
            t47 = 1/rhoa**2.333333333333333d+0
            t48 = 1/t8**2
            t49 = t35**2
            t50 = 1/t6**3
            t51 = t34**2
            t52 = 1/rhoa**2.3333333333333334d+0
            t53 = 1/rhoa**1.6666666666666669d+0
            t54 = 1/t2**5
            t55 = 6.563527649164527d-2*t30*t4*t54+8.751370198886037d-2*t
     1         31*t4*t53+3.0144339229749983d-3*t52
            t56 = 7.876233178997433d-1*t3*t55+6.563527649164527d-2*t30*t
     1         5*t54+8.751370198886037d-2*t31*t5*t53-2.625411059665811d-
     2         1*t31*t32*t33
            t57 = -1.4107138347223802d-1*t3*t53*t7-3.52678458680595d-2*t
     1         30*t31*t7-1.269642451250142d+0*t2*t29*t56+2.5392849025002
     2         84d+0*t2*t50*t51-4.23214150416714d-1*t29*t3*t32*t34
            t58 = 1/t16**2
            t59 = t40**2
            t60 = 1/t14**3
            t61 = t39**2
            t62 = 6.563527649164527d-2*t12*t30*t54+8.751370198886037d-2*
     1         t12*t31*t53+4.753699179395351d-3*t52
            t63 = 7.876233178997433d-1*t3*t62+6.563527649164527d-2*t13*t
     1         30*t54+8.751370198886037d-2*t13*t31*t53-2.625411059665811
     2         d-1*t31*t32*t38
            t64 = -1.269642451250142d+0*t2*t37*t63+2.539284902500284d+0*
     1         t2*t60*t61-1.4107138347223802d-1*t15*t3*t53-4.23214150416
     2         714d-1*t3*t32*t37*t39-3.52678458680595d-2*t15*t30*t31
            t65 = 1/t23**2
            t66 = t45**2
            t67 = 1/t21**3
            t68 = t44**2
            t69 = 6.563527649164527d-2*t19*t30*t54+8.751370198886037d-2*
     1         t19*t31*t53+2.601716490612924d-3*t52
            t70 = 7.876233178997433d-1*t3*t69+6.563527649164527d-2*t20*t
     1         30*t54+8.751370198886037d-2*t20*t31*t53-2.625411059665811
     2         d-1*t31*t32*t43
            t71 = -1.269642451250142d+0*t2*t42*t70+2.539284902500284d+0*
     1         t2*t67*t68-1.4107138347223802d-1*t22*t3*t53-4.23214150416
     2         714d-1*t3*t32*t42*t44-3.52678458680595d-2*t22*t30*t31
            t72 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-1
     1         .7613865241785687d-3*t47*t9+6.21814d-2*t18*t36*t64-6.2181
     2         4d-2*t18*t58*t59-3.10907d-2*t11*t28*t57+3.10907d-2*t11*t4
     3         8*t49+3.663697685584584d-3*t17*t47-5.495546528376876d-3*t
     4         27*t36*t40+2.642079786267853d-3*t27*t28*t35)-3.37738d-2*t
     5         25*t41*t71+3.37738d-2*t25*t65*t66-1.0359398963604977d-3*t
     6         24*t47+1.5539098445407465d-3*t27*t41*t45)+3.37738d-2*t25*
     7         t41*t71-3.37738d-2*t25*t65*t66+1.0359398963604977d-3*t24*
     8         t47-1.5539098445407465d-3*t27*t41*t45)-6.21814d-2*t18*t36
     9         *t64+6.21814d-2*t18*t58*t59-3.663697685584584d-3*t17*t47+
     :         5.495546528376876d-3*t27*t36*t40
            t73 = 1/rhoa**3.333333333333333d+0
            t74 = 1/rhoa**3.3333333333333337d+0
            t75 = 1/rhoa**2.666666666666667d+0
            t76 = 1/t2**7
            t77 = 1/rhoa**2.0d+0
            t78 = 1/t16**3
            t79 = t40**3
            t80 = -1.269642451250142d+0*t2*t37*(7.876233178997433d-1*t3*
     1         (-5.469606374303773d-2*t12*t76*t77-1.4585616998143394d-1*
     2         t12*t31*t75-1.1708185015918181d-2*t74-1.3127055298329054d
     3         -1*t12*t52*t54)-5.469606374303773d-2*t13*t76*t77-1.458561
     4         6998143394d-1*t13*t31*t75-3.9381165894987163d-1*t31*t32*t
     5         62-1.3127055298329054d-1*t13*t52*t54+1.9690582947493582d-
     6         1*t30*t38*t54+2.625411059665811d-1*t31*t38*t53)+1.7633922
     7         93402975d-2*t15*t54*t77+2.3511897245373004d-1*t15*t3*t75+
     8         7.617854707500852d+0*t2*t39*t60*t63-6.34821225625071d-1*t
     9         3*t32*t37*t63+1.269642451250142d+0*t3*t32*t60*t61+4.23214
     :         15041671406d-1*t3*t37*t39*t53+7.053569173611901d-2*t15*t3
     ;         1*t52-7.617854707500852d+0*t2*t39**3/t14**4+1.05803537604
     <         17849d-1*t30*t31*t37*t39
            t81 = 1/t23**3
            t82 = t45**3
            t83 = -1.269642451250142d+0*t2*t42*(7.876233178997433d-1*t3*
     1         (-5.469606374303773d-2*t19*t76*t77-1.4585616998143394d-1*
     2         t19*t31*t75-6.407931356509611d-3*t74-1.3127055298329054d-
     3         1*t19*t52*t54)-5.469606374303773d-2*t20*t76*t77-1.4585616
     4         998143394d-1*t20*t31*t75-3.9381165894987163d-1*t31*t32*t6
     5         9-1.3127055298329054d-1*t20*t52*t54+1.9690582947493582d-1
     6         *t30*t43*t54+2.625411059665811d-1*t31*t43*t53)+1.76339229
     7         3402975d-2*t22*t54*t77+2.3511897245373004d-1*t22*t3*t75+7
     8         .617854707500852d+0*t2*t44*t67*t70-6.34821225625071d-1*t3
     9         *t32*t42*t70+1.269642451250142d+0*t3*t32*t67*t68+4.232141
     :         5041671406d-1*t3*t42*t44*t53+7.053569173611901d-2*t22*t31
     ;         *t52-7.617854707500852d+0*t2*t44**3/t21**4+1.058035376041
     <         7849d-1*t30*t31*t42*t44
            fnc(iq) = 1.0d+0*rhoa*t26*wght+fnc(iq)
            Amat(iq,D1_RA) = 1.0d+0*rhoa*t46*wght+1.0d+0*t26*wght+Amat(i
     1         q,D1_RA)
            Amat2(iq,D2_RA_RA) = 1.0d+0*rhoa*t72*wght+2.0d+0*t46*wght+Am
     1         at2(iq,D2_RA_RA)
            Amat3(iq,D3_RA_RA_RA) = 1.0d+0*rhoa*(5.848223622634643d-1*(1
     1         .0d+0*(1.709920934161365d+0*(4.1099018897499934d-3*t73*t9
     2         +6.21814d-2*t18*t36*t80-6.21814d-2*t11*t35**3/t8**3+1.243
     3         628d-1*t18*t78*t79-3.10907d-2*t11*t28*(-1.269642451250142
     4         d+0*t2*t29*(7.876233178997433d-1*t3*(-5.469606374303773d-
     5         2*t4*t76*t77-1.4585616998143394d-1*t31*t4*t75-7.424439106
     6         586571d-3*t74-1.3127055298329054d-1*t4*t52*t54)-5.4696063
     7         74303773d-2*t5*t76*t77-1.4585616998143394d-1*t31*t5*t75-3
     8         .9381165894987163d-1*t31*t32*t55-1.3127055298329054d-1*t5
     9         *t52*t54+1.9690582947493582d-1*t30*t33*t54+2.625411059665
     :         811d-1*t31*t33*t53)+1.763392293402975d-2*t54*t7*t77+2.351
     ;         1897245373004d-1*t3*t7*t75+7.053569173611901d-2*t31*t52*t
     <         7-7.617854707500852d+0*t2*t34**3/t6**4+7.617854707500852d
     =         +0*t2*t34*t50*t56-6.34821225625071d-1*t29*t3*t32*t56+4.23
     >         21415041671406d-1*t29*t3*t34*t53+1.269642451250142d+0*t3*
     ?         t32*t50*t51+1.0580353760417849d-1*t29*t30*t31*t34)-8.5486
     @         27933030694d-3*t17*t73-1.865442d-1*t18*t40*t58*t64-8.2433
     1         19792565315d-3*t27*t36*t64+8.243319792565315d-3*t27*t58*t
     2         59+9.327209999999999d-2*t11*t35*t48*t57+3.96311967940178d
     3         -3*t27*t28*t57-3.96311967940178d-3*t27*t48*t49+1.09910930
     4         56753751d-2*t36*t40*t47-5.284159572535706d-3*t28*t35*t47)
     5         -3.37738d-2*t25*t41*t83-6.75476d-2*t25*t81*t82+2.41719309
     6         15078277d-3*t24*t73+1.013214d-1*t25*t45*t65*t71+2.3308647
     7         6681112d-3*t27*t41*t71-2.33086476681112d-3*t27*t65*t66-3.
     8         107819689081493d-3*t41*t45*t47)+3.37738d-2*t25*t41*t83+6.
     9         75476d-2*t25*t81*t82-2.4171930915078277d-3*t24*t73-1.0132
     :         14d-1*t25*t45*t65*t71-2.33086476681112d-3*t27*t41*t71+2.3
     ;         3086476681112d-3*t27*t65*t66+3.107819689081493d-3*t41*t45
     <         *t47)-6.21814d-2*t18*t36*t80-1.243628d-1*t18*t78*t79+8.54
     =         8627933030694d-3*t17*t73+1.865442d-1*t18*t40*t58*t64+8.24
     >         3319792565315d-3*t27*t36*t64-8.243319792565315d-3*t27*t58
     ?         *t59-1.0991093056753751d-2*t36*t40*t47)*wght+3.0d+0*t72*w
     @         ght+Amat3(iq,D3_RA_RA_RA)
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = rhob**3.333333333333333d-1
            t2 = t1**5.0d-1
            t3 = 1/t2
            t4 = 1.530901310039024d-2*t3+1.0465751434d-1
            t5 = 7.876233178997433d-1*t3*t4+1.9269083139d-1
            t6 = 7.876233178997433d-1*t3*t5+4.3896648423d-1
            t7 = 1/t6
            t8 = 1.269642451250142d+0*t2*t7+1.0d+0
            t9 = log(t8)
            t10 = 1/t1
            t11 = 1.2746961887000874d-1*t10+1.0d+0
            t12 = 2.4141993114533214d-2*t3+1.0186556948d-1
            t13 = 7.876233178997433d-1*t12*t3+2.2308199064d-1
            t14 = 7.876233178997433d-1*t13*t3+4.7231125998d-1
            t15 = 1/t14
            t16 = 1.269642451250142d+0*t15*t2+1.0d+0
            t17 = log(t16)
            t18 = 1.325688999052018d-1*t10+1.0d+0
            t19 = 1.3212998810398843d-2*t3+2.9729725188d-2
            t20 = 7.876233178997433d-1*t19*t3+1.2236585478d-1
            t21 = 7.876233178997433d-1*t20*t3+3.497952466d-1
            t22 = 1/t21
            t23 = 1.269642451250142d+0*t2*t22+1.0d+0
            t24 = log(t23)
            t25 = 6.901399211255826d-2*t10+1.0d+0
            t26 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(6.
     1         21814d-2*t17*t18-3.10907d-2*t11*t9)-3.37738d-2*t24*t25)+3
     2         .37738d-2*t24*t25)-6.21814d-2*t17*t18
            t27 = 1/rhob**1.3333333333333333d+0
            t28 = 1/t8
            t29 = 1/t6**2
            t30 = 1/rhob**1.3333333333333336d+0
            t31 = 1/t2**3
            t32 = 1/rhob**6.666666666666667d-1
            t33 = -1.3127055298329054d-1*t31*t32*t4-2.0096226153166658d-
     1         3*t30
            t34 = 7.876233178997433d-1*t3*t33-1.3127055298329054d-1*t31*
     1         t32*t5
            t35 = 2.11607075208357d-1*t3*t32*t7-1.269642451250142d+0*t2*
     1         t29*t34
            t36 = 1/t16
            t37 = 1/t14**2
            t38 = -1.3127055298329054d-1*t12*t31*t32-3.169132786263567d-
     1         3*t30
            t39 = 7.876233178997433d-1*t3*t38-1.3127055298329054d-1*t13*
     1         t31*t32
            t40 = 2.11607075208357d-1*t15*t3*t32-1.269642451250142d+0*t2
     1         *t37*t39
            t41 = 1/t23
            t42 = 1/t21**2
            t43 = -1.3127055298329054d-1*t19*t31*t32-1.7344776604086162d
     1         -3*t30
            t44 = 7.876233178997433d-1*t3*t43-1.3127055298329054d-1*t20*
     1         t31*t32
            t45 = 2.11607075208357d-1*t22*t3*t32-1.269642451250142d+0*t2
     1         *t42*t44
            t46 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(1.
     1         3210398931339265d-3*t27*t9+6.21814d-2*t18*t36*t40-3.10907
     2         d-2*t11*t28*t35-2.747773264188438d-3*t17*t27)-3.37738d-2*
     3         t25*t41*t45+7.769549222703733d-4*t24*t27)+3.37738d-2*t25*
     4         t41*t45-7.769549222703733d-4*t24*t27)-6.21814d-2*t18*t36*
     5         t40+2.747773264188438d-3*t17*t27
            t47 = 1/rhob**2.333333333333333d+0
            t48 = 1/t8**2
            t49 = t35**2
            t50 = 1/t6**3
            t51 = t34**2
            t52 = 1/rhob**2.3333333333333334d+0
            t53 = 1/rhob**1.6666666666666669d+0
            t54 = 1/t2**5
            t55 = 6.563527649164527d-2*t30*t4*t54+8.751370198886037d-2*t
     1         31*t4*t53+3.0144339229749983d-3*t52
            t56 = 7.876233178997433d-1*t3*t55+6.563527649164527d-2*t30*t
     1         5*t54+8.751370198886037d-2*t31*t5*t53-2.625411059665811d-
     2         1*t31*t32*t33
            t57 = -1.4107138347223802d-1*t3*t53*t7-3.52678458680595d-2*t
     1         30*t31*t7-1.269642451250142d+0*t2*t29*t56+2.5392849025002
     2         84d+0*t2*t50*t51-4.23214150416714d-1*t29*t3*t32*t34
            t58 = 1/t16**2
            t59 = t40**2
            t60 = 1/t14**3
            t61 = t39**2
            t62 = 6.563527649164527d-2*t12*t30*t54+8.751370198886037d-2*
     1         t12*t31*t53+4.753699179395351d-3*t52
            t63 = 7.876233178997433d-1*t3*t62+6.563527649164527d-2*t13*t
     1         30*t54+8.751370198886037d-2*t13*t31*t53-2.625411059665811
     2         d-1*t31*t32*t38
            t64 = -1.269642451250142d+0*t2*t37*t63+2.539284902500284d+0*
     1         t2*t60*t61-1.4107138347223802d-1*t15*t3*t53-4.23214150416
     2         714d-1*t3*t32*t37*t39-3.52678458680595d-2*t15*t30*t31
            t65 = 1/t23**2
            t66 = t45**2
            t67 = 1/t21**3
            t68 = t44**2
            t69 = 6.563527649164527d-2*t19*t30*t54+8.751370198886037d-2*
     1         t19*t31*t53+2.601716490612924d-3*t52
            t70 = 7.876233178997433d-1*t3*t69+6.563527649164527d-2*t20*t
     1         30*t54+8.751370198886037d-2*t20*t31*t53-2.625411059665811
     2         d-1*t31*t32*t43
            t71 = -1.269642451250142d+0*t2*t42*t70+2.539284902500284d+0*
     1         t2*t67*t68-1.4107138347223802d-1*t22*t3*t53-4.23214150416
     2         714d-1*t3*t32*t42*t44-3.52678458680595d-2*t22*t30*t31
            t72 = 5.848223622634643d-1*(1.0d+0*(1.709920934161365d+0*(-1
     1         .7613865241785687d-3*t47*t9+6.21814d-2*t18*t36*t64-6.2181
     2         4d-2*t18*t58*t59-3.10907d-2*t11*t28*t57+3.10907d-2*t11*t4
     3         8*t49+3.663697685584584d-3*t17*t47-5.495546528376876d-3*t
     4         27*t36*t40+2.642079786267853d-3*t27*t28*t35)-3.37738d-2*t
     5         25*t41*t71+3.37738d-2*t25*t65*t66-1.0359398963604977d-3*t
     6         24*t47+1.5539098445407465d-3*t27*t41*t45)+3.37738d-2*t25*
     7         t41*t71-3.37738d-2*t25*t65*t66+1.0359398963604977d-3*t24*
     8         t47-1.5539098445407465d-3*t27*t41*t45)-6.21814d-2*t18*t36
     9         *t64+6.21814d-2*t18*t58*t59-3.663697685584584d-3*t17*t47+
     :         5.495546528376876d-3*t27*t36*t40
            t73 = 1/rhob**3.333333333333333d+0
            t74 = 1/rhob**3.3333333333333337d+0
            t75 = 1/rhob**2.666666666666667d+0
            t76 = 1/t2**7
            t77 = 1/rhob**2.0d+0
            t78 = 1/t16**3
            t79 = t40**3
            t80 = -1.269642451250142d+0*t2*t37*(7.876233178997433d-1*t3*
     1         (-5.469606374303773d-2*t12*t76*t77-1.4585616998143394d-1*
     2         t12*t31*t75-1.1708185015918181d-2*t74-1.3127055298329054d
     3         -1*t12*t52*t54)-5.469606374303773d-2*t13*t76*t77-1.458561
     4         6998143394d-1*t13*t31*t75-3.9381165894987163d-1*t31*t32*t
     5         62-1.3127055298329054d-1*t13*t52*t54+1.9690582947493582d-
     6         1*t30*t38*t54+2.625411059665811d-1*t31*t38*t53)+1.7633922
     7         93402975d-2*t15*t54*t77+2.3511897245373004d-1*t15*t3*t75+
     8         7.617854707500852d+0*t2*t39*t60*t63-6.34821225625071d-1*t
     9         3*t32*t37*t63+1.269642451250142d+0*t3*t32*t60*t61+4.23214
     :         15041671406d-1*t3*t37*t39*t53+7.053569173611901d-2*t15*t3
     ;         1*t52-7.617854707500852d+0*t2*t39**3/t14**4+1.05803537604
     <         17849d-1*t30*t31*t37*t39
            t81 = 1/t23**3
            t82 = t45**3
            t83 = -1.269642451250142d+0*t2*t42*(7.876233178997433d-1*t3*
     1         (-5.469606374303773d-2*t19*t76*t77-1.4585616998143394d-1*
     2         t19*t31*t75-6.407931356509611d-3*t74-1.3127055298329054d-
     3         1*t19*t52*t54)-5.469606374303773d-2*t20*t76*t77-1.4585616
     4         998143394d-1*t20*t31*t75-3.9381165894987163d-1*t31*t32*t6
     5         9-1.3127055298329054d-1*t20*t52*t54+1.9690582947493582d-1
     6         *t30*t43*t54+2.625411059665811d-1*t31*t43*t53)+1.76339229
     7         3402975d-2*t22*t54*t77+2.3511897245373004d-1*t22*t3*t75+7
     8         .617854707500852d+0*t2*t44*t67*t70-6.34821225625071d-1*t3
     9         *t32*t42*t70+1.269642451250142d+0*t3*t32*t67*t68+4.232141
     :         5041671406d-1*t3*t42*t44*t53+7.053569173611901d-2*t22*t31
     ;         *t52-7.617854707500852d+0*t2*t44**3/t21**4+1.058035376041
     <         7849d-1*t30*t31*t42*t44
            fnc(iq) = 1.0d+0*rhob*t26*wght+fnc(iq)
            Amat(iq,D1_RB) = 1.0d+0*rhob*t46*wght+1.0d+0*t26*wght+Amat(i
     1         q,D1_RB)
            Amat2(iq,D2_RB_RB) = 1.0d+0*rhob*t72*wght+2.0d+0*t46*wght+Am
     1         at2(iq,D2_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = 1.0d+0*rhob*(5.848223622634643d-1*(1
     1         .0d+0*(1.709920934161365d+0*(4.1099018897499934d-3*t73*t9
     2         +6.21814d-2*t18*t36*t80-6.21814d-2*t11*t35**3/t8**3+1.243
     3         628d-1*t18*t78*t79-3.10907d-2*t11*t28*(-1.269642451250142
     4         d+0*t2*t29*(7.876233178997433d-1*t3*(-5.469606374303773d-
     5         2*t4*t76*t77-1.4585616998143394d-1*t31*t4*t75-7.424439106
     6         586571d-3*t74-1.3127055298329054d-1*t4*t52*t54)-5.4696063
     7         74303773d-2*t5*t76*t77-1.4585616998143394d-1*t31*t5*t75-3
     8         .9381165894987163d-1*t31*t32*t55-1.3127055298329054d-1*t5
     9         *t52*t54+1.9690582947493582d-1*t30*t33*t54+2.625411059665
     :         811d-1*t31*t33*t53)+1.763392293402975d-2*t54*t7*t77+2.351
     ;         1897245373004d-1*t3*t7*t75+7.053569173611901d-2*t31*t52*t
     <         7-7.617854707500852d+0*t2*t34**3/t6**4+7.617854707500852d
     =         +0*t2*t34*t50*t56-6.34821225625071d-1*t29*t3*t32*t56+4.23
     >         21415041671406d-1*t29*t3*t34*t53+1.269642451250142d+0*t3*
     ?         t32*t50*t51+1.0580353760417849d-1*t29*t30*t31*t34)-8.5486
     @         27933030694d-3*t17*t73-1.865442d-1*t18*t40*t58*t64-8.2433
     1         19792565315d-3*t27*t36*t64+8.243319792565315d-3*t27*t58*t
     2         59+9.327209999999999d-2*t11*t35*t48*t57+3.96311967940178d
     3         -3*t27*t28*t57-3.96311967940178d-3*t27*t48*t49+1.09910930
     4         56753751d-2*t36*t40*t47-5.284159572535706d-3*t28*t35*t47)
     5         -3.37738d-2*t25*t41*t83-6.75476d-2*t25*t81*t82+2.41719309
     6         15078277d-3*t24*t73+1.013214d-1*t25*t45*t65*t71+2.3308647
     7         6681112d-3*t27*t41*t71-2.33086476681112d-3*t27*t65*t66-3.
     8         107819689081493d-3*t41*t45*t47)+3.37738d-2*t25*t41*t83+6.
     9         75476d-2*t25*t81*t82-2.4171930915078277d-3*t24*t73-1.0132
     :         14d-1*t25*t45*t65*t71-2.33086476681112d-3*t27*t41*t71+2.3
     ;         3086476681112d-3*t27*t65*t66+3.107819689081493d-3*t41*t45
     <         *t47)-6.21814d-2*t18*t36*t80-1.243628d-1*t18*t78*t79+8.54
     =         8627933030694d-3*t17*t73+1.865442d-1*t18*t40*t58*t64+8.24
     >         3319792565315d-3*t27*t36*t64-8.243319792565315d-3*t27*t58
     ?         *t59-1.0991093056753751d-2*t36*t40*t47)*wght+3.0d+0*t72*w
     @         ght+Amat3(iq,D3_RB_RB_RB)
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
