/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi;

public class StatusException
extends Exception {
    protected int mStatusCode = -1;
    protected String mStatusMsg = null;

    public StatusException(int code, String msg) {
        super(code + " " + msg);
        this.mStatusCode = code;
        this.mStatusMsg = msg;
    }

    protected StatusException(String msg) {
        super(msg);
        this.mStatusMsg = msg;
    }

    public StatusException(int code, Exception rootCause) {
        super(code + " " + rootCause.toString(), rootCause);
        this.mStatusCode = code;
        this.mStatusMsg = rootCause.toString();
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getStatusMessage() {
        return this.mStatusMsg;
    }

    public String getImprovedMessage() {
        String ret = null;
        switch (this.mStatusCode) {
            case 404: {
                ret = "The requested resource was not found.";
                break;
            }
            case 405: {
                ret = "This operation is not allowed. This may be because you are attempting to create a folder using a name that is already in use.";
                break;
            }
            case 403: {
                ret = "This operation is forbidden. This may be because you do not have permission to perform this operation on on this resource.";
                break;
            }
            case 409: {
                ret = "A conflict has been detected. This may be because you are attempting to upload a file using a name that is already in use.";
            }
        }
        return ret;
    }
}

