/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.util;

import com.sourceforge.knecs.util.LoggerUtils;
import java.util.logging.Logger;

public class CMCSEncoder {
    private static final Logger mLogger = LoggerUtils.getLogger();

    public static String removeFormatting(String value) {
        if (value == null) {
            return "";
        }
        try {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                char c;
                char asc = c = value.charAt(i);
                if (c == '\\' || c == '\"') {
                    buf.append("\\");
                    buf.append(c);
                    continue;
                }
                if (c == '\n' || c == '\t' || asc < '!' || asc == '\u007f') {
                    buf.append(" ");
                    continue;
                }
                buf.append(c);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String encode(String url) {
        String ret = url;
        try {
            ret = url.replaceAll("\\?", "%3F");
            ret = ret.replaceAll("\\+", "%2B");
            ret = ret.replaceAll("'", "%27");
            ret = ret.replaceAll("\"", "%22");
            ret = ret.replaceAll("\\=", "%3D");
            ret = ret.replaceAll("&", "%26");
            ret = ret.replaceAll("#", "%23");
            ret = ret.replaceAll("\\<", "%3C");
            ret = ret.replaceAll("\\>", "%3E");
            ret = ret.replaceAll(";", "%3B");
            ret = ret.replaceAll("@", "%40");
            ret = ret.replaceAll("\\$", "%24");
            ret = ret.replaceAll(",", "%2C");
            ret = ret.replaceAll(" ", "%20");
        }
        catch (Exception e) {
            mLogger.fine("Failed encoding url " + url + ": " + e.toString());
            mLogger.fine(LoggerUtils.getStackTrace(e));
        }
        return ret;
    }

    public static String formatForXml(String text) {
        String ret = null;
        if (text != null) {
            ret = text.replaceAll("&", "&amp;");
            ret = ret.replaceAll("\\<", "&lt;");
            ret = ret.replaceAll("\\>", "&gt;");
        }
        return ret;
    }
}

