/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.turbine.om.DateKey;
import org.apache.turbine.om.ObjectKey;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.util.StringStackBuffer;
import org.apache.turbine.util.db.SqlExpression;
import org.apache.turbine.util.db.adapter.DB;
import org.apache.turbine.util.db.map.DatabaseMap;

public class Criteria
extends Hashtable {
    public static final String EQUAL = "=";
    public static final String NOT_EQUAL = "<>";
    public static final String ALT_NOT_EQUAL = "!=";
    public static final String GREATER_THAN = ">";
    public static final String LESS_THAN = "<";
    public static final String GREATER_EQUAL = ">=";
    public static final String LESS_EQUAL = "<=";
    public static final String LIKE = " LIKE ";
    public static final String CUSTOM = "CUSTOM";
    public static final String DISTINCT = "DISTINCT ";
    public static final String IN = " IN ";
    public static final String NOT_IN = " NOT IN ";
    public static final String ALL = "ALL ";
    public static final String JOIN = "JOIN";
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";
    private static final int DEFAULT_CAPACITY = 10;
    private boolean ignoreCase = false;
    private boolean singleRecord = false;
    private boolean cascade = false;
    private StringStackBuffer selectModifiers = new StringStackBuffer();
    private StringStackBuffer selectColumns = new StringStackBuffer();
    private StringStackBuffer orderByColumns = new StringStackBuffer();
    private Hashtable asColumns = new Hashtable(8);
    private ArrayList joinL = null;
    private ArrayList joinR = null;
    private String dbName;
    private int limit = -1;
    private int offset = 0;
    private HashMap aliases = null;

    public Criteria addAsColumn(String name, String clause) {
        this.asColumns.put(name, clause);
        return this;
    }

    public Hashtable getAsColumns() {
        return this.asColumns;
    }

    public void addAlias(String alias, String table) {
        if (this.aliases == null) {
            this.aliases = new HashMap(8);
        }
        this.aliases.put(alias, table);
    }

    public String getTableForAlias(String alias) {
        if (this.aliases == null) {
            return null;
        }
        return (String)this.aliases.get(alias);
    }

    public boolean containsKey(String table, String column) {
        return this.containsKey(table + "." + column);
    }

    public boolean getBoolean(String column) {
        return (Boolean)this.getCriterion(column).getValue();
    }

    public boolean getBoolean(String table, String column) {
        return this.getBoolean(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public boolean containsObjectColumn() throws Exception {
        return this.containsObjectColumn(this.dbName);
    }

    public boolean containsObjectColumn(String databaseMapName) throws Exception {
        DatabaseMap map = TurbineDB.getDatabaseMap(databaseMapName);
        StringStackBuffer tables = new StringStackBuffer();
        Enumeration e = super.elements();
        while (e.hasMoreElements()) {
            Criterion co = (Criterion)e.nextElement();
            String tableName = co.getTable();
            if (tables.contains(tableName)) continue;
            if (map.getTable(tableName).containsObjectColumn()) {
                return true;
            }
            tables.add(tableName);
        }
        return false;
    }

    public Criterion getCriterion(String column) {
        return (Criterion)super.get(column);
    }

    public Criterion getCriterion(String table, String column) {
        return this.getCriterion(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public Criterion getNewCriterion(String column, Object value, String comparison) {
        Criteria criteria = this;
        if (criteria == null) {
            throw null;
        }
        return criteria.new Criterion(column, value, comparison);
    }

    public Criterion getNewCriterion(String table, String column, Object value, String comparison) {
        Criteria criteria = this;
        if (criteria == null) {
            throw null;
        }
        return criteria.new Criterion(table, column, value, comparison);
    }

    public Criteria add(Criterion c) {
        StringBuffer sb = new StringBuffer(c.getTable().length() + c.getColumn().length() + 1);
        sb.append(c.getTable());
        sb.append('.');
        sb.append(c.getColumn());
        super.put(sb.toString(), c);
        return this;
    }

    public String getColumnName(String name) {
        return this.getCriterion(name).getColumn();
    }

    public String getComparison(String key) {
        return this.getCriterion(key).getComparison();
    }

    public String getComparison(String table, String column) {
        return this.getComparison(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public java.util.Date getDate(String name) {
        return (java.util.Date)this.getCriterion(name).getValue();
    }

    public java.util.Date getDate(String table, String column) {
        return this.getDate(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName == null ? TurbineDB.getDefaultDB() : dbName;
    }

    public double getDouble(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new Double((String)obj);
        }
        return (Double)obj;
    }

    public double getDouble(String table, String column) {
        return this.getDouble(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public float getFloat(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new Float((String)obj).floatValue();
        }
        return ((Float)obj).floatValue();
    }

    public float getFloat(String table, String column) {
        return this.getFloat(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public Integer getInteger(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new Integer((String)obj);
        }
        return (Integer)obj;
    }

    public Integer getInteger(String table, String column) {
        return this.getInteger(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public int getInt(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new Integer((String)obj);
        }
        return (Integer)obj;
    }

    public int getInt(String table, String column) {
        return this.getInt(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public BigDecimal getBigDecimal(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        return (BigDecimal)obj;
    }

    public BigDecimal getBigDecimal(String table, String column) {
        return this.getBigDecimal(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public long getLong(String name) {
        Object obj = this.getCriterion(name).getValue();
        if (obj instanceof String) {
            return new Long((String)obj);
        }
        return (Long)obj;
    }

    public long getLong(String table, String column) {
        return this.getLong(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public String getString(String name) {
        return (String)this.getCriterion(name).getValue();
    }

    public String getString(String table, String column) {
        return this.getString(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public String getTableName(String name) {
        return this.getCriterion(name).getTable();
    }

    public Vector getVector(String name) {
        return (Vector)this.getCriterion(name).getValue();
    }

    public Vector getVector(String table, String column) {
        return this.getVector(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public Object getValue(String name) {
        return this.getCriterion(name).getValue();
    }

    public Object getValue(String table, String column) {
        return this.getValue(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public ObjectKey getObjectKey(String name) {
        return (ObjectKey)this.getCriterion(name).getValue();
    }

    public ObjectKey getObjectKey(String table, String column) {
        return this.getObjectKey(new StringBuffer(table.length() + column.length() + 1).append(table).append('.').append(column).toString());
    }

    public Object get(Object key) {
        return this.getValue((String)key);
    }

    public Object put(Object key, Object value) {
        if (!(key instanceof String)) {
            throw new NullPointerException("Criteria: Key must be a String object.");
        }
        return this.add((String)key, value);
    }

    public synchronized void putAll(Map t) {
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object val = e.getValue();
            if (val instanceof Criterion) {
                super.put(e.getKey(), val);
                continue;
            }
            this.put(e.getKey(), val);
        }
        if (t instanceof Criteria) {
            Criteria c = (Criteria)t;
            this.joinL = c.joinL;
            this.joinR = c.joinR;
        }
    }

    public Criteria add(String key, Object value) {
        this.add(key, value, EQUAL);
        return this;
    }

    public Criteria add(String column, Object value, String comparison) {
        Criteria criteria = this;
        if (criteria == null) {
            throw null;
        }
        super.put(column, criteria.new Criterion(column, value, comparison));
        return this;
    }

    public Criteria add(String table, String column, Object value) {
        this.add(table, column, value, EQUAL);
        return this;
    }

    public Criteria add(String table, String column, Object value, String comparison) {
        StringBuffer sb = new StringBuffer(table.length() + column.length() + 1);
        sb.append(table);
        sb.append('.');
        sb.append(column);
        Criteria criteria = this;
        if (criteria == null) {
            throw null;
        }
        super.put(sb.toString(), criteria.new Criterion(table, column, value, comparison));
        return this;
    }

    public Criteria add(String column, boolean value) {
        this.add(column, new Boolean(value));
        return this;
    }

    public Criteria add(String column, boolean value, String comparison) {
        this.add(column, new Boolean(value), comparison);
        return this;
    }

    public Criteria add(String column, int value) {
        this.add(column, new Integer(value));
        return this;
    }

    public Criteria add(String column, int value, String comparison) {
        this.add(column, new Integer(value), comparison);
        return this;
    }

    public Criteria add(String column, long value) {
        this.add(column, new Long(value));
        return this;
    }

    public Criteria add(String column, long value, String comparison) {
        this.add(column, new Long(value), comparison);
        return this;
    }

    public Criteria add(String column, float value) {
        this.add(column, new Float(value));
        return this;
    }

    public Criteria add(String column, float value, String comparison) {
        this.add(column, new Float(value), comparison);
        return this;
    }

    public Criteria add(String column, double value) {
        this.add(column, new Double(value));
        return this;
    }

    public Criteria add(String column, double value, String comparison) {
        this.add(column, new Double(value), comparison);
        return this;
    }

    public Criteria addTime(String column, int year, int month, int date) {
        this.add(column, new GregorianCalendar(year, month, date));
        return this;
    }

    public Criteria addTime(String column, int year, int month, int date, String comparison) {
        this.add(column, new GregorianCalendar(year, month, date), comparison);
        return this;
    }

    public Criteria addDate(String column, int year, int month, int date) {
        this.add(column, new GregorianCalendar(year, month, date));
        return this;
    }

    public Criteria addDate(String column, int year, int month, int date, String comparison) {
        this.add(column, new GregorianCalendar(year, month, date), comparison);
        return this;
    }

    public Criteria addJoin(String left, String right) {
        if (this.joinL == null) {
            this.joinL = new ArrayList(3);
            this.joinR = new ArrayList(3);
        }
        this.joinL.add(left);
        this.joinR.add(right);
        return this;
    }

    public List getJoinL() {
        return this.joinL;
    }

    public List getJoinR() {
        return this.joinR;
    }

    public Criteria addIn(String column, Object[] values) {
        this.add(column, values, IN);
        return this;
    }

    public Criteria addIn(String column, int[] values) {
        this.add(column, values, IN);
        return this;
    }

    public Criteria addIn(String column, List values) {
        this.add(column, values, IN);
        return this;
    }

    public Criteria addNotIn(String column, Object[] values) {
        this.add(column, values, NOT_IN);
        return this;
    }

    public Criteria addNotIn(String column, int[] values) {
        this.add(column, values, NOT_IN);
        return this;
    }

    public Criteria addNotIn(String column, List values) {
        this.add(column, values, NOT_IN);
        return this;
    }

    public void setAll() {
        this.selectModifiers.add(ALL);
    }

    public void setDistinct() {
        this.selectModifiers.add(DISTINCT);
    }

    public Criteria setIgnoreCase(boolean b) {
        this.ignoreCase = b;
        return this;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Criteria setSingleRecord(boolean b) {
        this.singleRecord = b;
        return this;
    }

    public boolean isSingleRecord() {
        return this.singleRecord;
    }

    public Criteria setCascade(boolean b) {
        this.cascade = b;
        return this;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    public Criteria setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public Criteria setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public Criteria addSelectColumn(String name) {
        this.selectColumns.add(name);
        return this;
    }

    public StringStackBuffer getSelectColumns() {
        return this.selectColumns;
    }

    public StringStackBuffer getSelectModifiers() {
        return this.selectModifiers;
    }

    public Criteria addOrderByColumn(String name) {
        this.orderByColumns.add(name);
        return this;
    }

    public Criteria addAscendingOrderByColumn(String name) {
        this.orderByColumns.add(name + " " + ASC);
        return this;
    }

    public Criteria addDescendingOrderByColumn(String name) {
        this.orderByColumns.add(name + " " + DESC);
        return this;
    }

    public StringStackBuffer getOrderByColumns() {
        return this.orderByColumns;
    }

    public Object remove(String key) {
        Object foo = super.remove(key);
        if (foo instanceof Criterion) {
            return ((Criterion)foo).getValue();
        }
        return foo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Criteria:: ");
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            sb.append(key).append("<=>").append(super.get(key).toString()).append(":  ");
        }
        try {
            sb.append("\nCurrent Query SQL (may not be complete or applicable): ").append(BasePeer.createQueryString(this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public boolean equals(Object crit) {
        Criteria criteria;
        boolean isEquiv = false;
        if (crit == null || !(crit instanceof Criteria)) {
            isEquiv = false;
        } else if (this == crit) {
            isEquiv = true;
        } else if (this.size() == ((Criteria)crit).size() && this.offset == (criteria = (Criteria)crit).getOffset() && this.limit == criteria.getLimit() && this.ignoreCase == criteria.isIgnoreCase() && this.singleRecord == criteria.isSingleRecord() && this.cascade == criteria.isCascade() && this.dbName.equals(criteria.getDbName()) && this.selectModifiers.equals(criteria.getSelectModifiers()) && this.selectColumns.equals(criteria.getSelectColumns()) && this.orderByColumns.equals(criteria.getOrderByColumns())) {
            isEquiv = true;
            Enumeration e = criteria.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (this.containsKey(key)) {
                    Criterion b;
                    Criterion a = this.getCriterion(key);
                    if (a.equals(b = criteria.getCriterion(key))) continue;
                    isEquiv = false;
                    break;
                }
                isEquiv = false;
                break;
            }
        }
        return isEquiv;
    }

    public Criteria and(Criterion c) {
        Criterion oc = this.getCriterion(c.getTable() + "." + c.getColumn());
        if (oc == null) {
            this.add(c);
        } else {
            oc.and(c);
        }
        return this;
    }

    public Criteria and(String column, Object value) {
        this.and(column, value, EQUAL);
        return this;
    }

    public Criteria and(String column, Object value, String comparison) {
        Criterion oc = this.getCriterion(column);
        Criteria criteria = this;
        if (criteria == null) {
            throw null;
        }
        Criterion nc = criteria.new Criterion(column, value, comparison);
        if (oc == null) {
            super.put(column, nc);
        } else {
            oc.and(nc);
        }
        return this;
    }

    public Criteria and(String table, String column, Object value) {
        this.and(table, column, value, EQUAL);
        return this;
    }

    public Criteria and(String table, String column, Object value, String comparison) {
        StringBuffer sb = new StringBuffer(table.length() + column.length() + 1);
        sb.append(table);
        sb.append('.');
        sb.append(column);
        Criterion oc = this.getCriterion(table, column);
        Criteria criteria = this;
        if (criteria == null) {
            throw null;
        }
        Criterion nc = criteria.new Criterion(table, column, value, comparison);
        if (oc == null) {
            super.put(sb.toString(), nc);
        } else {
            oc.and(nc);
        }
        return this;
    }

    public Criteria and(String column, boolean value) {
        this.and(column, new Boolean(value));
        return this;
    }

    public Criteria and(String column, boolean value, String comparison) {
        this.and(column, new Boolean(value), comparison);
        return this;
    }

    public Criteria and(String column, int value) {
        this.and(column, new Integer(value));
        return this;
    }

    public Criteria and(String column, int value, String comparison) {
        this.and(column, new Integer(value), comparison);
        return this;
    }

    public Criteria and(String column, long value) {
        this.and(column, new Long(value));
        return this;
    }

    public Criteria and(String column, long value, String comparison) {
        this.and(column, new Long(value), comparison);
        return this;
    }

    public Criteria and(String column, float value) {
        this.and(column, new Float(value));
        return this;
    }

    public Criteria and(String column, float value, String comparison) {
        this.and(column, new Float(value), comparison);
        return this;
    }

    public Criteria and(String column, double value) {
        this.and(column, new Double(value));
        return this;
    }

    public Criteria and(String column, double value, String comparison) {
        this.and(column, new Double(value), comparison);
        return this;
    }

    public Criteria andDate(String column, int year, int month, int date) {
        this.and(column, new GregorianCalendar(year, month, date));
        return this;
    }

    public Criteria andDate(String column, int year, int month, int date, String comparison) {
        this.and(column, new GregorianCalendar(year, month, date), comparison);
        return this;
    }

    public Criteria andIn(String column, Object[] values) {
        this.and(column, values, IN);
        return this;
    }

    public Criteria andIn(String column, int[] values) {
        this.and(column, values, IN);
        return this;
    }

    public Criteria andIn(String column, Vector values) {
        this.and(column, values, IN);
        return this;
    }

    public Criteria andNotIn(String column, Object[] values) {
        this.and(column, values, NOT_IN);
        return this;
    }

    public Criteria andNotIn(String column, int[] values) {
        this.and(column, values, NOT_IN);
        return this;
    }

    public Criteria andNotIn(String column, Vector values) {
        this.and(column, values, NOT_IN);
        return this;
    }

    public Criteria or(Criterion c) {
        Criterion oc = this.getCriterion(c.getTable() + "." + c.getColumn());
        if (oc == null) {
            this.add(c);
        } else {
            oc.or(c);
        }
        return this;
    }

    public Criteria or(String column, Object value) {
        this.or(column, value, EQUAL);
        return this;
    }

    public Criteria or(String column, Object value, String comparison) {
        Criterion oc = this.getCriterion(column);
        Criteria criteria = this;
        if (criteria == null) {
            throw null;
        }
        Criterion nc = criteria.new Criterion(column, value, comparison);
        if (oc == null) {
            super.put(column, nc);
        } else {
            oc.or(nc);
        }
        return this;
    }

    public Criteria or(String table, String column, Object value) {
        this.or(table, column, value, EQUAL);
        return this;
    }

    public Criteria or(String table, String column, Object value, String comparison) {
        StringBuffer sb = new StringBuffer(table.length() + column.length() + 1);
        sb.append(table);
        sb.append('.');
        sb.append(column);
        Criterion oc = this.getCriterion(table, column);
        Criteria criteria = this;
        if (criteria == null) {
            throw null;
        }
        Criterion nc = criteria.new Criterion(table, column, value, comparison);
        if (oc == null) {
            super.put(sb.toString(), nc);
        } else {
            oc.or(nc);
        }
        return this;
    }

    public Criteria or(String column, boolean value) {
        this.or(column, new Boolean(value));
        return this;
    }

    public Criteria or(String column, boolean value, String comparison) {
        this.or(column, new Boolean(value), comparison);
        return this;
    }

    public Criteria or(String column, int value) {
        this.or(column, new Integer(value));
        return this;
    }

    public Criteria or(String column, int value, String comparison) {
        this.or(column, new Integer(value), comparison);
        return this;
    }

    public Criteria or(String column, long value) {
        this.or(column, new Long(value));
        return this;
    }

    public Criteria or(String column, long value, String comparison) {
        this.or(column, new Long(value), comparison);
        return this;
    }

    public Criteria or(String column, float value) {
        this.or(column, new Float(value));
        return this;
    }

    public Criteria or(String column, float value, String comparison) {
        this.or(column, new Float(value), comparison);
        return this;
    }

    public Criteria or(String column, double value) {
        this.or(column, new Double(value));
        return this;
    }

    public Criteria or(String column, double value, String comparison) {
        this.or(column, new Double(value), comparison);
        return this;
    }

    public Criteria orDate(String column, int year, int month, int date) {
        this.or(column, new GregorianCalendar(year, month, date));
        return this;
    }

    public Criteria orDate(String column, int year, int month, int date, String comparison) {
        this.or(column, new GregorianCalendar(year, month, date), comparison);
        return this;
    }

    public Criteria orIn(String column, Object[] values) {
        this.or(column, values, IN);
        return this;
    }

    public Criteria orIn(String column, int[] values) {
        this.or(column, values, IN);
        return this;
    }

    public Criteria orIn(String column, Vector values) {
        this.or(column, values, IN);
        return this;
    }

    public Criteria orNotIn(String column, Object[] values) {
        this.or(column, values, NOT_IN);
        return this;
    }

    public Criteria orNotIn(String column, int[] values) {
        this.or(column, values, NOT_IN);
        return this;
    }

    public Criteria orNotIn(String column, Vector values) {
        this.or(column, values, NOT_IN);
        return this;
    }

    public Criteria() {
        this(10);
    }

    public Criteria(int initialCapacity) {
        this(TurbineDB.getDefaultDB(), initialCapacity);
    }

    public Criteria(String dbName) {
        this(dbName, 10);
    }

    public Criteria(String dbName, int initialCapacity) {
        super(initialCapacity);
        this.dbName = dbName;
    }

    public final class Criterion {
        public static final String AND = " AND ";
        public static final String OR = " OR ";
        private Object value;
        private String comparison;
        private String table;
        private String column;
        private boolean ignoreStringCase = false;
        private DB db;
        private Criterion or;
        private Criterion and;

        public String getColumn() {
            return this.column;
        }

        public void setTable(String name) {
            this.table = name;
        }

        public String getTable() {
            return this.table;
        }

        public String getComparison() {
            return this.comparison;
        }

        public Object getValue() {
            return this.value;
        }

        public DB getDb() {
            return this.db;
        }

        public void setDB(DB v) {
            this.db = v;
            if (this.and != null) {
                this.and.setDB(v);
            }
            if (this.or != null) {
                this.or.setDB(v);
            }
        }

        public Criterion setIgnoreCase(boolean b) {
            this.ignoreStringCase = b;
            return this;
        }

        public boolean isIgnoreCase() {
            return this.ignoreStringCase;
        }

        public Criterion getAnd() {
            return this.and;
        }

        public Criterion and(Criterion criterion) {
            if (this.and == null) {
                this.and = criterion;
            } else {
                this.and.and(criterion);
            }
            return this;
        }

        public Criterion getOr() {
            return this.or;
        }

        public Criterion or(Criterion criterion) {
            if (this.or == null) {
                this.or = criterion;
            } else {
                this.or.or(criterion);
            }
            return this;
        }

        public void appendTo(StringBuffer sb) {
            if (this.column == null) {
                return;
            }
            sb.append('(');
            if (Criteria.CUSTOM == this.comparison) {
                if (this.value != null && !"".equals(this.value)) {
                    sb.append((String)this.value);
                }
            } else {
                String field = null;
                field = this.table == null ? this.column : new StringBuffer(this.table.length() + 1 + this.column.length()).append(this.table).append('.').append(this.column).toString();
                SqlExpression.build(field, this.value, this.comparison, this.ignoreStringCase, this.db, sb);
            }
            if (this.or != null) {
                sb.append(OR);
                this.or.appendTo(sb);
            }
            if (this.and != null) {
                sb.append(AND);
                this.and.appendTo(sb);
            }
            sb.append(')');
        }

        public void appendPsTo(StringBuffer sb, List params) {
            if (this.column == null || this.value == null) {
                return;
            }
            sb.append('(');
            if (Criteria.CUSTOM == this.comparison) {
                if (!"".equals(this.value)) {
                    sb.append((String)this.value);
                }
            } else {
                String field = null;
                field = this.table == null ? this.column : new StringBuffer(this.table.length() + 1 + this.column.length()).append(this.table).append('.').append(this.column).toString();
                if (this.comparison.equals(Criteria.IN) || this.comparison.equals(Criteria.NOT_IN)) {
                    sb.append(field).append(this.comparison);
                    StringStackBuffer inClause = new StringStackBuffer();
                    if (this.value instanceof Vector) {
                        this.value = ((Vector)this.value).toArray(new Object[0]);
                    }
                    int i = 0;
                    while (i < Array.getLength(this.value)) {
                        Object item = Array.get(this.value, i);
                        inClause.add(SqlExpression.processInValue(item, Criteria.this.ignoreCase, this.db));
                        ++i;
                    }
                    StringBuffer inString = new StringBuffer();
                    inString.append('(').append(inClause.toString(",")).append(')');
                    sb.append(inString.toString());
                } else {
                    if (Criteria.this.ignoreCase) {
                        sb.append(this.db.ignoreCase(field)).append(this.comparison).append(this.db.ignoreCase("?"));
                    } else {
                        sb.append(field).append(this.comparison).append(" ? ");
                    }
                    if (this.value instanceof java.util.Date) {
                        params.add(new Date(((java.util.Date)this.value).getTime()));
                    } else if (this.value instanceof DateKey) {
                        params.add(new Date(((DateKey)this.value).getDate().getTime()));
                    } else {
                        params.add(this.value.toString());
                    }
                }
            }
            if (this.or != null) {
                sb.append(OR);
                this.or.appendPsTo(sb, params);
            }
            if (this.and != null) {
                sb.append(AND);
                this.and.appendPsTo(sb, params);
            }
            sb.append(')');
        }

        public String toString() {
            if (this.column == null) {
                return "";
            }
            StringBuffer expr = new StringBuffer(25);
            this.appendTo(expr);
            return expr.toString();
        }

        public boolean equals(Object obj) {
            boolean isEquiv;
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof Criterion)) {
                return false;
            }
            Criterion crit = (Criterion)obj;
            boolean bl = isEquiv = (this.table == null && crit.getTable() == null || this.table != null && this.table.equals(crit.getTable())) && this.column.equals(crit.getColumn()) && this.comparison.equals(crit.getComparison());
            if (isEquiv) {
                Object b = crit.getValue();
                isEquiv = this.value instanceof Object[] && b instanceof Object[] ? (isEquiv &= Arrays.equals((Object[])this.value, (Object[])b)) : (this.value instanceof int[] && b instanceof int[] ? (isEquiv &= Arrays.equals((int[])this.value, (int[])b)) : (isEquiv &= this.value.equals(b)));
            }
            isEquiv &= this.and == null && crit.getAnd() == null || this.and != null && this.and.equals(crit.getAnd());
            return isEquiv &= this.or == null && crit.getOr() == null || this.or != null && this.or.equals(crit.getOr());
        }

        public String[] getAllTables() {
            StringStackBuffer tables = new StringStackBuffer();
            this.addCriterionTable(this, tables);
            return tables.toStringArray();
        }

        private void addCriterionTable(Criterion c, StringStackBuffer s) {
            if (c != null) {
                s.add(c.getTable());
                this.addCriterionTable(c.getAnd(), s);
                this.addCriterionTable(c.getOr(), s);
            }
        }

        public Criterion[] getAttachedCriterion() {
            ArrayList crits = new ArrayList();
            this.traverseCriterion(this, crits);
            Criterion[] crita = new Criterion[crits.size()];
            int i = 0;
            while (i < crits.size()) {
                crita[i] = (Criterion)crits.get(i);
                ++i;
            }
            return crita;
        }

        private void traverseCriterion(Criterion c, ArrayList a) {
            if (c != null) {
                a.add(c);
                this.traverseCriterion(c.getAnd(), a);
                this.traverseCriterion(c.getOr(), a);
            }
        }

        private Criterion(Object val, String comp) {
            this.value = val;
            this.comparison = comp;
        }

        Criterion(String table, String column, Object val, String comp) {
            this(val, comp);
            this.table = table == null ? "" : table;
            this.column = column == null ? "" : column;
        }

        Criterion(String tableColumn, Object val, String comp) {
            this(val, comp);
            int dot = tableColumn.indexOf(46);
            if (dot == -1) {
                this.table = "";
                this.column = tableColumn;
            } else {
                this.table = tableColumn.substring(0, dot);
                this.column = tableColumn.substring(dot + 1);
            }
        }

        Criterion(String table, String column, Object val) {
            this(table, column, val, Criteria.EQUAL);
        }

        Criterion(String tableColumn, Object val) {
            this(tableColumn, val, Criteria.EQUAL);
        }
    }
}

