/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.chefproject.core.Realm;
import org.chefproject.core.User;
import org.chefproject.service.RealmService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericSecurityService;
import org.chefproject.util.Reference;

public class ChefSecurity
extends TurbineBaseService
implements GenericSecurityService {
    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    protected User getUser() {
        return UsageSessionService.getSessionUser();
    }

    public boolean isSuperUser() {
        User user = this.getUser();
        if (user != null) {
            if ("admin".equalsIgnoreCase(user.getId())) {
                return true;
            }
            if ("postmaster".equalsIgnoreCase(user.getId())) {
                return true;
            }
            try {
                Realm adminRealm = RealmService.getRealm("/site/!admin");
                if (adminRealm.unlock(user, "site.upd", null)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean unlock(String lock, String resource) {
        boolean rv = this.doUnlock(lock, resource);
        if (Log.getLogger("chef").isDebugEnabled()) {
            User u = this.getUser();
            String uid = "";
            if (u != null) {
                uid = u.getId();
            }
            Log.debug("chef", this + ".unlock(): " + uid + " @ " + lock + " @ " + resource + " = " + rv);
        }
        return rv;
    }

    public List unlockUsers(String lock, String reference) {
        HashSet<User> userSet = new HashSet<User>();
        Vector<User> rv = new Vector<User>();
        if (reference == null) {
            Log.warn("chef", this + ".unlockUsers(): null resource: " + lock);
            return rv;
        }
        Reference ref = new Reference(reference);
        List realms = ref.getRealms();
        Vector<Realm> helperRealms = new Vector<Realm>();
        Iterator it = realms.iterator();
        while (it.hasNext()) {
            User user;
            Realm realm = (Realm)it.next();
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".unlockUsers(): checking realm: " + realm.getId() + " for lock: " + lock);
            }
            userSet.addAll(realm.collectLockUsers(lock, helperRealms));
            if (realm.getId().equals("~") && realm.unlock(user = UsageSessionService.getSessionUser(), lock, helperRealms)) {
                userSet.add(user);
            }
            helperRealms.add(0, realm);
        }
        rv.addAll(userSet);
        Collections.sort(rv);
        return rv;
    }

    protected boolean doUnlock(String lock, String resource) {
        if (this.isSuperUser()) {
            return true;
        }
        if (resource == null) {
            Log.warn("chef", this + ".unlock(): null resource: " + lock);
            return false;
        }
        Reference ref = new Reference(resource);
        List realms = ref.getRealms();
        Vector<Realm> helperRealms = new Vector<Realm>();
        Iterator it = realms.iterator();
        while (it.hasNext()) {
            Realm realm = (Realm)it.next();
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".doUnlock(): checking realm: " + realm.getId() + " for lock: " + lock);
            }
            if (realm.unlock(this.getUser(), lock, helperRealms)) {
                return true;
            }
            helperRealms.add(0, realm);
        }
        return false;
    }

    public void addKey(String userOrGroup, String lockOrRole, String resourceOrGroup, boolean allow) {
        Log.warn("chef", this + ".addKey() [NOT SUPPORTED]: user: " + userOrGroup + " lock: " + lockOrRole + " resource: " + resourceOrGroup + " allow: " + allow);
    }

    public void removeKey(String userOrGroup, String lockOrRole, String resourceOrGroup, boolean allow) {
        Log.warn("chef", this + ".removeKey()[NOT SUPPORTED]: user: " + userOrGroup + " lock: " + lockOrRole + " resource: " + resourceOrGroup + " allow: " + allow);
    }
}

