/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.jetspeed.services.statemanager.SessionStateBindingListener;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Event;
import org.chefproject.core.Filter;
import org.chefproject.core.Message;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.MessageChannelEdit;
import org.chefproject.core.MessageEdit;
import org.chefproject.core.MessageHeader;
import org.chefproject.core.MessageHeaderEdit;
import org.chefproject.core.Resource;
import org.chefproject.core.ResourceProperties;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.core.StorageUser;
import org.chefproject.core.User;
import org.chefproject.core.component.BaseResourcePropertiesEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.IdService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.service.generic.GenericMessageService;
import org.chefproject.util.Cache;
import org.chefproject.util.CacheRefresher;
import org.chefproject.util.Different;
import org.chefproject.util.Reference;
import org.chefproject.util.ReferenceVector;
import org.chefproject.util.Time;
import org.chefproject.util.Validator;
import org.chefproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseMessageService
extends TurbineBaseService
implements GenericMessageService,
StorageUser,
CacheRefresher {
    protected String m_accessPoint = null;
    protected Storage m_storage = null;
    protected Cache m_channelCache = null;
    protected Hashtable m_messageCaches = null;

    protected BaseMessageService service() {
        return this;
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.debug("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        this.m_accessPoint = ServerConfigurationService.getAccessUrl() + this.getReferenceRoot();
        Log.info("chef", this + ".init(RunData): access point: " + this.m_accessPoint);
    }

    public void init() throws InitializationException {
        super.init();
        Log.debug("chef", this + ".init()");
        this.m_storage = this.newStorage();
        this.m_storage.open();
        this.m_channelCache = new Cache((CacheRefresher)this, this.getAccessPoint(true) + "/" + "channel" + "/");
        this.m_messageCaches = new Hashtable();
    }

    public void shutdown() {
        this.m_channelCache.clear();
        this.m_channelCache = null;
        this.m_messageCaches.clear();
        this.m_messageCaches = null;
        this.m_storage.close();
        this.m_storage = null;
        Log.debug("chef", this + ".shutdown()");
        super.shutdown();
    }

    protected abstract Storage newStorage();

    protected abstract MessageHeaderEdit newMessageHeader(String var1);

    protected abstract MessageHeaderEdit newMessageHeader(Element var1);

    protected abstract MessageHeaderEdit newMessageHeader(MessageHeader var1);

    protected abstract String eventId(String var1);

    protected abstract String getReferenceRoot();

    protected String getAccessPoint(boolean relative) {
        return relative ? this.getReferenceRoot() : this.m_accessPoint;
    }

    public String channelReference(String context, String id) {
        return this.getAccessPoint(true) + "/" + "channel" + "/" + context + "/" + id;
    }

    public String messageReference(String context, String channelId, String id) {
        return this.getAccessPoint(true) + "/" + "msg" + "/" + context + "/" + channelId + "/" + id;
    }

    protected boolean unlockCheck(String lock, String resource) {
        return SecurityService.unlock(this.eventId(lock), resource);
    }

    protected boolean unlockCheck2(String lock1, String lock2, String resource) {
        return SecurityService.unlock(this.eventId(lock1), resource) || SecurityService.unlock(this.eventId(lock2), resource);
    }

    protected void unlock(String lock, String resource) throws PermissionException {
        if (!this.unlockCheck(lock, resource)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), this.eventId(lock), resource);
        }
    }

    protected void unlock2(String lock1, String lock2, String resource) throws PermissionException {
        if (!this.unlockCheck2(lock1, lock2, resource)) {
            throw new PermissionException(UsageSessionService.getSessionUser().getId(), this.eventId(lock1) + "/" + this.eventId(lock2), resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getChannels() {
        List channels = new Vector();
        if (this.m_channelCache.disabled()) {
            channels = this.m_storage.getChannels();
        } else if (this.m_channelCache.isComplete()) {
            channels = this.m_channelCache.getAll();
        } else {
            Cache cache = this.m_channelCache;
            synchronized (cache) {
                block9: {
                    if (!this.m_channelCache.isComplete()) break block9;
                    channels = this.m_channelCache.getAll();
                    List list = channels;
                    return list;
                }
                this.m_channelCache.holdEvents();
                channels = this.m_storage.getChannels();
                int i = 0;
                while (i < channels.size()) {
                    MessageChannel channel = (MessageChannel)channels.get(i);
                    this.m_channelCache.put(channel.getReference(), channel);
                    ++i;
                }
                this.m_channelCache.setComplete();
                this.m_channelCache.processEvents();
            }
        }
        return channels;
    }

    public boolean allowGetChannel(String ref) {
        return this.unlockCheck("read", ref);
    }

    public MessageChannel getChannel(String ref) throws IdUnusedException, PermissionException {
        MessageChannel c = this.findChannel(ref);
        if (c == null) {
            throw new IdUnusedException(ref);
        }
        this.unlock("read", ref);
        return c;
    }

    protected MessageChannel findChannel(String ref) {
        MessageChannel channel = null;
        if (this.m_channelCache.disabled()) {
            channel = this.m_storage.getChannel(ref);
        } else if (this.m_channelCache.containsKey(ref)) {
            channel = (MessageChannel)this.m_channelCache.get(ref);
        } else {
            channel = this.m_storage.getChannel(ref);
            this.m_channelCache.put(ref, channel);
        }
        return channel;
    }

    public boolean allowAddChannel(String ref) {
        return this.unlockCheck("new", ref);
    }

    public MessageChannelEdit addChannel(String ref) throws IdUsedException, IdInvalidException, PermissionException {
        Validator.checkResourceRef(ref);
        if (this.m_channelCache.get(ref) != null || this.m_storage.checkChannel(ref)) {
            throw new IdUsedException(ref);
        }
        this.unlock("new", ref);
        MessageChannelEdit channel = this.m_storage.putChannel(ref);
        ((BaseMessageChannelEdit)channel).setEvent("new");
        return channel;
    }

    public boolean allowEditChannel(String ref) {
        return this.unlockCheck2("revise.any", "revise.own", ref);
    }

    public MessageChannelEdit editChannel(String ref) throws IdUnusedException, PermissionException, InUseException {
        if (this.m_channelCache.get(ref) == null && !this.m_storage.checkChannel(ref)) {
            throw new IdUnusedException(ref);
        }
        this.unlock2("revise.any", "revise.own", ref);
        MessageChannelEdit edit = this.m_storage.editChannel(ref);
        if (edit == null) {
            throw new InUseException(ref);
        }
        ((BaseMessageChannelEdit)edit).setEvent("revise.any");
        return edit;
    }

    public void commitChannel(MessageChannelEdit edit) {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".commitEdit(): closed ChannelEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.commitChannel(edit);
        Event event = EventTrackingService.newEvent(this.eventId(((BaseMessageChannelEdit)edit).getEvent()), edit.getReference(), true);
        EventTrackingService.post(event);
        ((BaseMessageChannelEdit)edit).closeEdit();
    }

    public void cancelChannel(MessageChannelEdit edit) {
        if (!edit.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".cancelChannelEdit(): closed MessageChannelEdit", (Throwable)e);
                return;
            }
        }
        this.m_storage.cancelChannel(edit);
        ((BaseMessageChannelEdit)edit).closeEdit();
    }

    public boolean allowRemoveChannel(String ref) {
        return this.unlockCheck("delete.any", ref);
    }

    public void removeChannel(MessageChannelEdit channel) throws PermissionException {
        if (!channel.isActiveEdit()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                Log.warn("chef", this + ".removeChannel(): closed ChannelEdit", (Throwable)e);
                return;
            }
        }
        this.unlock("delete.any", channel.getReference());
        this.m_storage.removeChannel(channel);
        Event event = EventTrackingService.newEvent(this.eventId("delete.any"), channel.getReference(), true);
        EventTrackingService.post(event);
        ((BaseMessageChannelEdit)channel).setRemoved(event);
        ((BaseMessageChannelEdit)channel).closeEdit();
    }

    public Object refresh(Object key, Object oldValue, Event event) {
        Resource rv = null;
        Reference ref = new Reference((String)key);
        if ("msg".equals(ref.getSubType())) {
            MessageChannel channel;
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): key " + key + " channel id : " + ref.getContext() + "/" + ref.getContainer() + " message id : " + ref.getId());
            }
            if ((channel = this.findChannel(this.channelReference(ref.getContext(), ref.getContainer()))) != null) {
                rv = this.m_storage.getMessage(channel, ref.getId());
            }
        } else {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".refresh(): key " + key + " channel id : " + ref.getReference());
            }
            rv = this.m_storage.getChannel(ref.getReference());
        }
        return rv;
    }

    protected static interface Storage {
        public void open();

        public void close();

        public MessageChannel getChannel(String var1);

        public boolean checkChannel(String var1);

        public List getChannels();

        public MessageChannelEdit putChannel(String var1);

        public MessageChannelEdit editChannel(String var1);

        public void commitChannel(MessageChannelEdit var1);

        public void cancelChannel(MessageChannelEdit var1);

        public void removeChannel(MessageChannelEdit var1);

        public Message getMessage(MessageChannel var1, String var2);

        public MessageEdit editMessage(MessageChannel var1, String var2);

        public void commitMessage(MessageChannel var1, MessageEdit var2);

        public void cancelMessage(MessageChannel var1, MessageEdit var2);

        public boolean checkMessage(MessageChannel var1, String var2);

        public List getMessages(MessageChannel var1);

        public MessageEdit putMessage(MessageChannel var1, String var2);

        public void removeMessage(MessageChannel var1, MessageEdit var2);
    }

    public class BaseMessageHeaderEdit
    implements MessageHeaderEdit {
        protected String m_id = null;
        protected Time m_date = null;
        protected User m_from = null;
        protected ReferenceVector m_attachments = null;

        public BaseMessageHeaderEdit(String id) {
            this.m_id = id;
            this.m_date = new Time();
            this.m_from = UsageSessionService.getSessionUser();
            this.m_attachments = new ReferenceVector();
        }

        public BaseMessageHeaderEdit(MessageHeader other) {
            this.m_id = other.getId();
            this.m_date = new Time(other.getDate().getTime());
            this.m_from = other.getFrom();
            this.m_attachments = new ReferenceVector();
            this.replaceAttachments(other.getAttachments());
        }

        public BaseMessageHeaderEdit(Element el) {
            this.m_id = el.getAttribute("id");
            try {
                this.m_from = UserDirectoryService.getUser(el.getAttribute("from"));
            }
            catch (IdUnusedException e) {
                this.m_from = UserDirectoryService.getAnonymousUser();
            }
            this.m_date = new Time(el.getAttribute("date"));
            this.m_attachments = new ReferenceVector();
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("attachment")) {
                    this.m_attachments.add(new Reference(element.getAttribute("relative-url")));
                }
                ++i;
            }
        }

        public String getId() {
            return this.m_id;
        }

        public Time getDate() {
            return this.m_date;
        }

        public User getFrom() {
            return this.m_from;
        }

        public Element toXml(Document doc, Stack stack) {
            Element header = doc.createElement("header");
            ((Element)stack.peek()).appendChild(header);
            header.setAttribute("id", this.getId());
            header.setAttribute("from", this.getFrom().getId());
            header.setAttribute("date", this.getDate().toString());
            if (this.m_attachments != null && this.m_attachments.size() > 0) {
                int i = 0;
                while (i < this.m_attachments.size()) {
                    Reference attch = (Reference)this.m_attachments.elementAt(i);
                    Element attachment = doc.createElement("attachment");
                    header.appendChild(attachment);
                    attachment.setAttribute("relative-url", attch.getReference());
                    ++i;
                }
            }
            return header;
        }

        public void setDate(Time date) {
            if (!date.equals(this.m_date)) {
                this.m_date.setTime(date.getTime());
            }
        }

        public void setFrom(User user) {
            if (!user.equals(this.m_from)) {
                this.m_from = user;
            }
        }

        public ReferenceVector getAttachments() {
            return (ReferenceVector)this.m_attachments.clone();
        }

        public void addAttachment(Reference ref) {
            this.m_attachments.add(ref);
        }

        public void removeAttachment(Reference ref) {
            this.m_attachments.remove(ref);
        }

        public void replaceAttachments(ReferenceVector attachments) {
            this.m_attachments.clear();
            if (attachments != null) {
                Iterator it = attachments.iterator();
                while (it.hasNext()) {
                    this.m_attachments.add(it.next());
                }
            }
        }

        public void clearAttachments() {
            this.m_attachments.clear();
        }
    }

    public class BaseMessageEdit
    implements MessageEdit,
    SessionStateBindingListener {
        protected String m_event = null;
        protected boolean m_active = false;
        protected MessageHeaderEdit m_header = null;
        protected String m_body = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected MessageChannel m_channel = null;

        public BaseMessageEdit(MessageChannel channel, String id) {
            this.m_channel = channel;
            this.m_header = BaseMessageService.this.newMessageHeader(id);
            this.m_properties = new BaseResourcePropertiesEdit();
        }

        public BaseMessageEdit(MessageChannel channel, Message other) {
            this.m_channel = channel;
            this.setAll(other);
        }

        public BaseMessageEdit(MessageChannel channel, Element el) {
            this(channel, "");
            this.m_body = Xml.decodeAttribute(el, "body");
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    Element element = (Element)child;
                    if (element.getTagName().equals("header")) {
                        this.m_header = this$0.newMessageHeader(element);
                    } else if (element.getTagName().equals("body")) {
                        if (element.getChildNodes() != null && element.getChildNodes().item(0) != null) {
                            this.m_body = element.getChildNodes().item(0).getNodeValue();
                        }
                        if (this.m_body == null) {
                            this.m_body = "";
                        }
                    } else if (element.getTagName().equals("properties")) {
                        this.m_properties = new BaseResourcePropertiesEdit(element);
                    }
                }
                ++i;
            }
        }

        protected void setAll(Message other) {
            this.m_header = BaseMessageService.this.newMessageHeader(other.getHeader());
            this.m_body = other.getBody();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(other.getProperties());
        }

        protected void finalize() {
            if (this.m_active) {
                this.m_channel.cancelMessage(this);
            }
            this.m_channel = null;
        }

        public MessageHeader getHeader() {
            return this.m_header;
        }

        public String getId() {
            return this.m_header.getId();
        }

        public String getUrl() {
            return this.m_channel.getUrl() + this.getId();
        }

        public String getReference() {
            return BaseMessageService.this.messageReference(this.m_channel.getContext(), this.m_channel.getId(), this.getId());
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public String getBody() {
            return this.m_body == null ? "" : this.m_body;
        }

        public Element toXml(Document doc, Stack stack) {
            Element message = doc.createElement("message");
            if (stack.isEmpty()) {
                doc.appendChild(message);
            } else {
                ((Element)stack.peek()).appendChild(message);
            }
            stack.push(message);
            this.m_header.toXml(doc, stack);
            Xml.encodeAttribute(message, "body", this.getBody());
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return message;
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof Message)) {
                throw new ClassCastException();
            }
            if (obj == this) {
                return 0;
            }
            int compare = this.getHeader().getDate().compareTo(((Message)obj).getHeader().getDate());
            return compare;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Message)) {
                return false;
            }
            return ((Message)obj).getId().equals(this.getId());
        }

        public void setBody(String body) {
            if (Different.different(body, this.m_body)) {
                this.m_body = body;
            }
        }

        protected void set(Message other) {
            this.setAll(other);
        }

        public MessageHeaderEdit getHeaderEdit() {
            return this.m_header;
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                this.m_channel.cancelMessage(this);
            }
        }
    }

    public class BaseMessageChannelEdit
    extends Observable
    implements MessageChannelEdit,
    SessionStateBindingListener {
        protected String m_context = null;
        protected String m_id = null;
        protected ResourcePropertiesEdit m_properties = null;
        protected boolean m_isRemoved = false;
        protected String m_event = null;
        protected boolean m_active = false;

        public BaseMessageChannelEdit(String ref) {
            Reference r = new Reference(ref);
            this.m_context = r.getContext();
            this.m_id = r.getId();
            this.m_properties = new BaseResourcePropertiesEdit();
        }

        public BaseMessageChannelEdit(MessageChannel other) {
            this.m_context = other.getContext();
            this.m_id = other.getId();
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_properties.addAll(other.getProperties());
        }

        public BaseMessageChannelEdit(Element el) {
            this.m_properties = new BaseResourcePropertiesEdit();
            this.m_id = el.getAttribute("id");
            this.m_context = el.getAttribute("context");
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("properties")) {
                    this.m_properties = new BaseResourcePropertiesEdit(element);
                }
                ++i;
            }
        }

        protected void finalize() {
            this.deleteObservers();
            if (this.m_active) {
                BaseMessageService.this.cancelChannel(this);
            }
        }

        public void setRemoved(Event event) {
            this.m_isRemoved = true;
            this.notify(event);
            this.deleteObservers();
        }

        public String getContext() {
            return this.m_context;
        }

        public String getId() {
            return this.m_id;
        }

        public String getUrl() {
            return BaseMessageService.this.getAccessPoint(false) + "/" + this.getId() + "/";
        }

        public String getReference() {
            return BaseMessageService.this.channelReference(this.m_context, this.m_id);
        }

        public ResourceProperties getProperties() {
            return this.m_properties;
        }

        public boolean allowGetMessages() {
            return BaseMessageService.this.unlockCheck("read", this.getReference());
        }

        public List getMessages(Filter filter, boolean ascending) throws PermissionException {
            BaseMessageService.this.unlock("read", this.getReference());
            EventTrackingService.post(EventTrackingService.newEvent(BaseMessageService.this.eventId("read"), this.getReference(), false));
            return this.findFilterMessages(filter, ascending);
        }

        public Message getMessage(String messageId) throws IdUnusedException, PermissionException {
            BaseMessageService.this.unlock("read", this.getReference());
            Message m = this.findMessage(messageId);
            if (m == null) {
                throw new IdUnusedException(messageId);
            }
            EventTrackingService.post(EventTrackingService.newEvent(BaseMessageService.this.eventId("read"), m.getReference(), false));
            return m;
        }

        public boolean allowEditMessage(String messageId) {
            Message m = this.findMessage(messageId);
            if (m == null) {
                return false;
            }
            if (m.getHeader().getFrom().equals(UsageSessionService.getSessionUser())) {
                return BaseMessageService.this.unlockCheck2("revise.own", "revise.any", this.getReference());
            }
            return BaseMessageService.this.unlockCheck("revise.any", this.getReference());
        }

        public MessageEdit editMessage(String messageId) throws IdUnusedException, PermissionException, InUseException {
            Message m = this.findMessage(messageId);
            if (m == null) {
                throw new IdUnusedException(messageId);
            }
            String function = null;
            if (m.getHeader().getFrom().equals(UsageSessionService.getSessionUser())) {
                BaseMessageService.this.unlock2("revise.own", "revise.any", this.getReference());
                function = "revise.own";
            } else {
                BaseMessageService.this.unlock("revise.any", this.getReference());
                function = "revise.any";
            }
            MessageEdit msg = BaseMessageService.this.m_storage.editMessage(this, messageId);
            if (msg == null) {
                throw new InUseException(messageId);
            }
            ((BaseMessageEdit)msg).setEvent(function);
            return msg;
        }

        public void commitMessage(MessageEdit edit) {
            if (!edit.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".commitEdit(): closed MessageEdit", (Throwable)e);
                    return;
                }
            }
            BaseMessageService.this.m_storage.commitMessage(this, edit);
            Event event = EventTrackingService.newEvent(BaseMessageService.this.eventId(((BaseMessageEdit)edit).getEvent()), edit.getReference(), true);
            EventTrackingService.post(event);
            this.notify(event);
            ((BaseMessageEdit)edit).closeEdit();
        }

        public void cancelMessage(MessageEdit edit) {
            if (!edit.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".commitEdit(): closed MessageEdit", (Throwable)e);
                    return;
                }
            }
            BaseMessageService.this.m_storage.cancelMessage(this, edit);
            ((BaseMessageEdit)edit).closeEdit();
        }

        public boolean allowAddMessage() {
            return BaseMessageService.this.unlockCheck("new", this.getReference());
        }

        public MessageEdit addMessage() throws PermissionException {
            BaseMessageService.this.unlock("new", this.getReference());
            String id = IdService.getUniqueId();
            MessageEdit msg = BaseMessageService.this.m_storage.putMessage(this, id);
            ((BaseMessageEdit)msg).setEvent("new");
            return msg;
        }

        public MessageEdit mergeMessage(Element el) throws PermissionException, IdUsedException {
            BaseMessageService.this.unlock("new", this.getReference());
            Message msgFromXml = (Message)BaseMessageService.this.newResource((Resource)this, el);
            MessageEdit msg = BaseMessageService.this.m_storage.putMessage(this, msgFromXml.getId());
            if (msg == null) {
                throw new IdUsedException(msgFromXml.getId());
            }
            ((BaseMessageEdit)msg).set(msgFromXml);
            ((BaseMessageEdit)msg).setEvent("new");
            return msg;
        }

        public boolean allowRemoveMessage(Message message) {
            if (message.getHeader().getFrom().equals(UsageSessionService.getSessionUser())) {
                return BaseMessageService.this.unlockCheck2("delete.own", "delete.any", this.getReference());
            }
            return BaseMessageService.this.unlockCheck("delete.any", this.getReference());
        }

        public void removeMessage(MessageEdit message) throws PermissionException {
            if (!message.isActiveEdit()) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".removeMessage(): closed MessageEdit", (Throwable)e);
                    return;
                }
            }
            String function = null;
            if (message.getHeader().getFrom().equals(UsageSessionService.getSessionUser())) {
                BaseMessageService.this.unlock2("delete.own", "delete.any", this.getReference());
                function = "delete.own";
            } else {
                BaseMessageService.this.unlock("delete.any", this.getReference());
                function = "delete.any";
            }
            BaseMessageService.this.m_storage.removeMessage(this, message);
            Event event = EventTrackingService.newEvent(BaseMessageService.this.eventId(function), message.getReference(), true);
            EventTrackingService.post(event);
            this.notify(event);
            ((BaseMessageEdit)message).closeEdit();
        }

        public Element toXml(Document doc, Stack stack) {
            Element channel = doc.createElement("channel");
            if (stack.isEmpty()) {
                doc.appendChild(channel);
            } else {
                ((Element)stack.peek()).appendChild(channel);
            }
            stack.push(channel);
            channel.setAttribute("context", this.getContext());
            channel.setAttribute("id", this.getId());
            this.m_properties.toXml(doc, stack);
            stack.pop();
            return channel;
        }

        public void notify(Event event) {
            this.setChanged();
            this.notifyObservers(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Message findMessage(String messageId) {
            Message m = null;
            String key = BaseMessageService.this.messageReference(this.m_context, this.m_id, messageId);
            if (BaseMessageService.this.m_channelCache.disabled()) {
                m = BaseMessageService.this.m_storage.getMessage(this, messageId);
            } else {
                Cache msgCache = (Cache)BaseMessageService.this.m_messageCaches.get(this.getReference());
                if (msgCache == null) {
                    Hashtable hashtable = BaseMessageService.this.m_messageCaches;
                    synchronized (hashtable) {
                        msgCache = (Cache)BaseMessageService.this.m_messageCaches.get(this.getReference());
                        if (msgCache == null) {
                            msgCache = new Cache((CacheRefresher)BaseMessageService.this.service(), BaseMessageService.this.messageReference(this.m_context, this.m_id, ""));
                            BaseMessageService.this.m_messageCaches.put(this.getReference(), msgCache);
                        }
                    }
                }
                if (msgCache.containsKey(key)) {
                    m = (Message)msgCache.get(key);
                } else {
                    m = BaseMessageService.this.m_storage.getMessage(this, messageId);
                    msgCache.put(key, m);
                }
            }
            return m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List findMessages() {
            List msgs = new Vector();
            if (BaseMessageService.this.m_channelCache.disabled()) {
                msgs = BaseMessageService.this.m_storage.getMessages(this);
            } else {
                Object object;
                Cache msgCache = (Cache)BaseMessageService.this.m_messageCaches.get(this.getReference());
                if (msgCache == null) {
                    object = BaseMessageService.this.m_messageCaches;
                    synchronized (object) {
                        msgCache = (Cache)BaseMessageService.this.m_messageCaches.get(this.getReference());
                        if (msgCache == null) {
                            msgCache = new Cache((CacheRefresher)BaseMessageService.this.service(), BaseMessageService.this.messageReference(this.m_context, this.m_id, ""));
                            BaseMessageService.this.m_messageCaches.put(this.getReference(), msgCache);
                        }
                    }
                }
                if (msgCache.isComplete()) {
                    msgs = msgCache.getAll();
                } else {
                    object = msgCache;
                    synchronized (object) {
                        if (msgCache.isComplete()) {
                            msgs = msgCache.getAll();
                        } else {
                            msgCache.holdEvents();
                            msgs = BaseMessageService.this.m_storage.getMessages(this);
                            int i = 0;
                            while (i < msgs.size()) {
                                Message msg = (Message)msgs.get(i);
                                msgCache.put(msg.getReference(), msg);
                                ++i;
                            }
                            msgCache.setComplete();
                            msgCache.processEvents();
                        }
                    }
                }
            }
            return msgs;
        }

        protected List findFilterMessages(Filter filter, boolean ascending) {
            Vector<Message> msgs = this.findMessages();
            if (msgs.size() == 0) {
                return msgs;
            }
            Collections.sort(msgs);
            if (!ascending) {
                Collections.reverse(msgs);
            }
            if (filter != null) {
                Vector<Message> filtered = new Vector<Message>();
                int i = 0;
                while (i < msgs.size()) {
                    Message msg = (Message)msgs.get(i);
                    if (filter.accept(msg)) {
                        filtered.add(msg);
                    }
                    ++i;
                }
                if (filtered.size() == 0) {
                    return filtered;
                }
                msgs = filtered;
            }
            return msgs;
        }

        protected String getEvent() {
            return this.m_event;
        }

        protected void setEvent(String event) {
            this.m_event = event;
        }

        public ResourcePropertiesEdit getPropertiesEdit() {
            return this.m_properties;
        }

        protected void activate() {
            this.m_active = true;
        }

        public boolean isActiveEdit() {
            return this.m_active;
        }

        protected void closeEdit() {
            this.m_active = false;
        }

        public void valueBound(String sessionStateKey, String attributeName) {
        }

        public void valueUnbound(String sessionStateKey, String attributeName) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".valueUnbound()");
            }
            if (this.m_active) {
                BaseMessageService.this.cancelChannel(this);
            }
        }
    }
}

