/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security.peer;

import com.workingdogs.village.Record;
import java.util.Map;
import java.util.Vector;
import org.apache.turbine.om.BaseObject;
import org.apache.turbine.om.Persistent;
import org.apache.turbine.om.peer.BasePeer;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.TurbineRole;
import org.apache.turbine.om.security.User;
import org.apache.turbine.om.security.peer.UserGroupRolePeer;
import org.apache.turbine.om.security.peer.UserPeer;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.db.DBSecurityService;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.db.Criteria;
import org.apache.turbine.util.db.map.TurbineMapBuilder;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.RoleSet;

public class RolePeer
extends BasePeer {
    private static final TurbineMapBuilder mapBuilder = (TurbineMapBuilder)BasePeer.getMapBuilder();
    private static final String TABLE_NAME = mapBuilder.getTableRole();
    public static final String ROLE_ID = mapBuilder.getRole_RoleId();
    public static final String NAME = mapBuilder.getRole_Name();
    public static final String OBJECTDATA = mapBuilder.getRole_ObjectData();
    private static final String SEQUENCE_NAME = mapBuilder.getSequenceRole();

    public static RoleSet retrieveSet(Criteria criteria) throws Exception {
        Vector results = RolePeer.doSelect(criteria);
        RoleSet rs = new RoleSet();
        int i = 0;
        while (i < results.size()) {
            rs.add((Role)results.elementAt(i));
            ++i;
        }
        return rs;
    }

    public static RoleSet retrieveSet(User user, Group group) throws Exception {
        Criteria criteria = new Criteria();
        UserPeer up = ((DBSecurityService)TurbineSecurity.getService()).getUserPeerInstance();
        criteria.add(up.getFullColumnName("LOGIN_NAME"), user.getUserName());
        criteria.add(UserGroupRolePeer.GROUP_ID, ((Persistent)((Object)group)).getPrimaryKey());
        criteria.addJoin(up.getFullColumnName("USER_ID"), UserGroupRolePeer.USER_ID);
        criteria.addJoin(UserGroupRolePeer.ROLE_ID, ROLE_ID);
        return RolePeer.retrieveSet(criteria);
    }

    public static Vector doSelect(Criteria criteria) throws Exception {
        criteria.addSelectColumn(ROLE_ID).addSelectColumn(NAME).addSelectColumn(OBJECTDATA);
        if (criteria.getOrderByColumns() == null || criteria.getOrderByColumns().size() == 0) {
            criteria.addAscendingOrderByColumn(NAME);
        }
        Vector rows = BasePeer.doSelect(criteria);
        Vector<TurbineRole> results = new Vector<TurbineRole>();
        int i = 0;
        while (i < rows.size()) {
            TurbineRole obj = new TurbineRole();
            Record row = (Record)rows.elementAt(i);
            obj.setPrimaryKey(row.getValue(1).asInt());
            obj.setName(row.getValue(2).asString());
            byte[] objectData = row.getValue(3).asBytes();
            Map temp = (Map)ObjectUtils.deserialize(objectData);
            if (temp != null) {
                obj.setAttributes(temp);
            }
            results.addElement(obj);
            ++i;
        }
        return results;
    }

    public static Criteria buildCriteria(Role role) {
        Criteria criteria = new Criteria();
        if (!((BaseObject)((Object)role)).isNew()) {
            criteria.add(ROLE_ID, ((BaseObject)((Object)role)).getPrimaryKey());
        }
        criteria.add(NAME, role.getName());
        return criteria;
    }

    public static void doUpdate(Criteria criteria) throws Exception {
        Criteria selectCriteria = new Criteria(2);
        selectCriteria.put(ROLE_ID, criteria.remove(ROLE_ID));
        BasePeer.doUpdate(selectCriteria, criteria);
    }

    public static boolean checkExists(Role role) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(ROLE_ID);
        criteria.add(NAME, role.getName());
        Vector results = BasePeer.doSelect(criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple roles named '" + role.getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static String getTableName() {
        return TABLE_NAME;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(TABLE_NAME);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }
}

