/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.turbine.services.BaseInitableBroker;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.Service;
import org.apache.turbine.services.ServiceBroker;
import org.apache.turbine.util.StringUtils;
import org.apache.velocity.runtime.configuration.Configuration;

public abstract class BaseServiceBroker
extends BaseInitableBroker
implements ServiceBroker {
    protected Configuration mapping = new Configuration();
    protected Hashtable services = new Hashtable();

    public boolean isRegistered(String serviceName) {
        return this.services.get(serviceName) != null;
    }

    public void initService(String name, Object data) throws InitializationException {
        String className = (String)this.mapping.get(name);
        if (StringUtils.isEmpty(className)) {
            throw new InitializationException("ServiceBroker: initialization of unknown service " + name + " requested.");
        }
        this.initClass(className, data);
    }

    public void initServices(Object data) {
        try {
            this.initServices(data, false);
        }
        catch (InstantiationException notThrown) {
        }
        catch (InitializationException initializationException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    public void initServices(Object data, boolean report) throws InstantiationException, InitializationException {
        block5: {
            this.notice("Initializing all services using: " + data.getClass().getName());
            names = this.mapping.getKeys();
            if (!report) ** GOTO lbl16
            while (names.hasNext()) {
                this.doInitService(data, (String)names.next());
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                try {
                    this.doInitService(data, (String)names.next());
                    continue;
                }
                catch (InstantiationException e) {
                    this.error(e);
                    continue;
                }
                catch (InitializationException e) {
                    this.error(e);
                }
lbl16:
                // 4 sources

                ** while (names.hasNext())
            }
        }
        this.notice("Finished initializing all services!");
    }

    private void doInitService(Object data, String name) throws InstantiationException, InitializationException {
        this.notice("Start Initializing service (early): " + name);
        this.getServiceInstance(name);
        this.initClass(this.mapping.getString(name), data);
        this.notice("Finish Initializing service (early): " + name);
    }

    public void shutdownService(String name) {
        String className = (String)this.mapping.get(name);
        if (className != null) {
            this.shutdownClass(className);
        }
    }

    public void shutdownServices() {
        this.notice("Shutting down all services!");
        Iterator serviceNames = this.mapping.getKeys();
        String serviceName = null;
        ArrayList<String> reverseServicesList = new ArrayList<String>();
        while (serviceNames.hasNext()) {
            serviceName = (String)serviceNames.next();
            reverseServicesList.add(0, serviceName);
        }
        serviceNames = ((AbstractList)reverseServicesList).iterator();
        while (serviceNames.hasNext()) {
            serviceName = (String)serviceNames.next();
            this.notice("Shutting down service: " + serviceName);
            this.shutdownService(serviceName);
        }
    }

    public Service getService(String name) throws InstantiationException {
        try {
            Service service = this.getServiceInstance(name);
            if (!service.getInit()) {
                Class<?> clazz = service.getClass();
                synchronized (clazz) {
                    if (!service.getInit()) {
                        this.notice("Start Initializing service (late): " + name);
                        service.init();
                        this.notice("Finish Initializing service (late): " + name);
                    }
                }
            }
            if (!service.getInit()) {
                throw new InitializationException("init() failed to initialize service " + name);
            }
            return service;
        }
        catch (InitializationException e) {
            throw new InstantiationException("Service " + name + " failed to initialize", e);
        }
    }

    protected Service getServiceInstance(String name) throws InstantiationException {
        Service service = (Service)this.services.get(name);
        if (service == null) {
            String className = (String)this.mapping.get(name);
            if (className == null) {
                throw new InstantiationException("ServiceBroker: unknown service " + name + " requested");
            }
            try {
                service = (Service)this.getInitableInstance(className);
            }
            catch (ClassCastException e) {
                throw new InstantiationException("ServiceBroker: class " + className + " does not implement Service interface.", e);
            }
            catch (InstantiationException e) {
                throw new InstantiationException("Failed to instantiate service " + name, e);
            }
            service.setServiceBroker(this);
            service.setName(name);
            this.services.put(name, service);
        }
        return service;
    }

    public Properties getProperties(String name) {
        return new Properties();
    }

    public Configuration getConfiguration(String name) {
        return new Configuration();
    }

    protected BaseServiceBroker() {
    }
}

