/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Calendar;
import org.chefproject.core.CalendarEvent;
import org.chefproject.core.ContentCollection;
import org.chefproject.core.ContentResource;
import org.chefproject.core.Message;
import org.chefproject.core.MessageChannel;
import org.chefproject.core.MessageHeader;
import org.chefproject.core.Site;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.ArchiveService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.service.generic.GenericAnnouncementService;
import org.chefproject.service.generic.GenericCalendarService;
import org.chefproject.service.generic.GenericChatService;
import org.chefproject.service.generic.GenericContentHostingService;
import org.chefproject.service.generic.GenericDiscussionService;
import org.chefproject.service.generic.GenericMessageService;
import org.chefproject.service.generic.GenericSiteService;
import org.chefproject.service.generic.GenericUserDirectoryService;
import org.chefproject.util.Reference;
import org.chefproject.util.ReferenceVector;
import org.chefproject.util.Time;
import org.chefproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicArchiveService
extends TurbineBaseService
implements ArchiveService {
    protected String m_storagePath = null;

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        this.m_storagePath = data.getServletContext().getRealPath(this.getProperties().getProperty("path", "/"));
        Log.info("chef", this + ".init(RunData): storage path: " + this.m_storagePath);
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
    }

    public void shutdown() {
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public void archive(String site) {
        Log.debug("chef", this + ".archive(): site: " + site);
        Site theSite = null;
        try {
            theSite = SiteService.getSite(site);
        }
        catch (IdUnusedException e) {
            Log.warn("chef", this + ".archive(): site not found: " + site);
            return;
        }
        ReferenceVector allAttachments = new ReferenceVector();
        Time now = new Time();
        String channelId = "site-" + site;
        File dir = new File(this.m_storagePath + site + "-archive/");
        dir.mkdirs();
        Document doc = Xml.createDocument();
        Stack<Element> stack = new Stack<Element>();
        Element root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", site);
        root.setAttribute("date", now.toString());
        stack.push(root);
        this.archiveMessages(GenericChatService.SERVICE_NAME, channelId, doc, stack, allAttachments);
        stack.pop();
        Xml.writeDocument(doc, this.m_storagePath + site + "-archive/" + site + "-chat.xml");
        doc = Xml.createDocument();
        stack = new Stack();
        root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", site);
        root.setAttribute("date", now.toString());
        stack.push(root);
        this.archiveMessages(GenericAnnouncementService.SERVICE_NAME, channelId, doc, stack, allAttachments);
        stack.pop();
        Xml.writeDocument(doc, this.m_storagePath + site + "-archive/" + site + "-announcement.xml");
        doc = Xml.createDocument();
        stack = new Stack();
        root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", site);
        root.setAttribute("date", now.toString());
        stack.push(root);
        this.archiveMessages(GenericDiscussionService.SERVICE_NAME, channelId, doc, stack, allAttachments);
        stack.pop();
        Xml.writeDocument(doc, this.m_storagePath + site + "-archive/" + site + "-discussion.xml");
        doc = Xml.createDocument();
        stack = new Stack();
        root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", site);
        root.setAttribute("date", now.toString());
        stack.push(root);
        this.archiveCalendar(channelId, doc, stack, allAttachments);
        stack.pop();
        Xml.writeDocument(doc, this.m_storagePath + site + "-archive/" + site + "-calendar.xml");
        doc = Xml.createDocument();
        stack = new Stack();
        root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", site);
        root.setAttribute("date", now.toString());
        stack.push(root);
        this.archiveContent(site, doc, stack);
        stack.pop();
        Xml.writeDocument(doc, this.m_storagePath + site + "-archive/" + site + "-content.xml");
        if (allAttachments.size() > 0) {
            doc = Xml.createDocument();
            stack = new Stack();
            root = doc.createElement("archive");
            doc.appendChild(root);
            root.setAttribute("site", site);
            root.setAttribute("date", now.toString());
            stack.push(root);
            this.archiveAttachments(allAttachments, doc, stack);
            stack.pop();
            Xml.writeDocument(doc, this.m_storagePath + site + "-archive/" + site + "-attachment.xml");
        }
        doc = Xml.createDocument();
        stack = new Stack();
        root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", site);
        root.setAttribute("date", now.toString());
        stack.push(root);
        this.archiveSite(theSite, doc, stack);
        stack.pop();
        Xml.writeDocument(doc, this.m_storagePath + site + "-archive/" + site + "-site.xml");
        doc = Xml.createDocument();
        stack = new Stack();
        root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", site);
        root.setAttribute("date", now.toString());
        stack.push(root);
        stack.pop();
        Xml.writeDocument(doc, this.m_storagePath + site + "-archive/" + site + "-user.xml");
    }

    protected void archiveMessages(String serviceName, String channelId, Document doc, Stack stack, ReferenceVector allAttachments) {
        Element element = doc.createElement(serviceName);
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        try {
            GenericMessageService service = (GenericMessageService)((Object)TurbineServices.getInstance().getService(serviceName));
            MessageChannel channel = service.getChannel(channelId);
            channel.toXml(doc, stack);
            Iterator messages = channel.getMessages(null, true).iterator();
            while (messages.hasNext()) {
                Message msg = (Message)messages.next();
                MessageHeader header = msg.getHeader();
                ReferenceVector attachments = header.getAttachments();
                int i = 0;
                while (i < attachments.size()) {
                    Reference ref = (Reference)attachments.elementAt(i);
                    if (!allAttachments.contains(ref)) {
                        allAttachments.add(ref);
                    }
                    ++i;
                }
            }
        }
        catch (Exception any) {
            Log.warn("chef", this + ".archve: exception archiving messages for service: " + serviceName + " channel: " + channelId + ": ", (Throwable)any);
        }
        stack.pop();
    }

    protected void archiveCalendar(String calendarId, Document doc, Stack stack, ReferenceVector allAttachments) {
        Element element = doc.createElement(GenericCalendarService.SERVICE_NAME);
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        try {
            GenericCalendarService service = (GenericCalendarService)((Object)TurbineServices.getInstance().getService(GenericCalendarService.SERVICE_NAME));
            Calendar calendar = service.getCalendar(calendarId);
            calendar.toXml(doc, stack);
            Iterator events = calendar.getEvents(null, null).iterator();
            while (events.hasNext()) {
                CalendarEvent event = (CalendarEvent)events.next();
                ReferenceVector attachments = event.getAttachments();
                int i = 0;
                while (i < attachments.size()) {
                    Reference ref = (Reference)attachments.elementAt(i);
                    if (!allAttachments.contains(ref)) {
                        allAttachments.add(ref);
                    }
                    ++i;
                }
            }
        }
        catch (Exception any) {
            Log.warn("chef", this + ".archve: exception archiving calendar: " + calendarId + ": ", (Throwable)any);
        }
        stack.pop();
    }

    protected void archiveContent(String siteId, Document doc, Stack stack) {
        Element element = doc.createElement(GenericContentHostingService.SERVICE_NAME);
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        try {
            GenericContentHostingService service = (GenericContentHostingService)((Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME));
            ContentCollection collection = service.getCollection("/site/" + siteId + "/");
            this.archiveCollection(collection, doc, stack);
        }
        catch (Exception any) {
            Log.warn("chef", this + ".archve: exception archiving collection: " + siteId + ": ", (Throwable)any);
        }
        stack.pop();
    }

    protected void archiveSite(Site site, Document doc, Stack stack) {
        Element element = doc.createElement(GenericSiteService.SERVICE_NAME);
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        try {
            site.toXml(doc, stack);
        }
        catch (Exception any) {
            Log.warn("chef", this + ".archve: exception archiving site: " + site.getId() + ": ", (Throwable)any);
        }
        stack.pop();
    }

    protected void archiveCollection(ContentCollection collection, Document doc, Stack stack) {
        collection.toXml(doc, stack);
        List members = collection.getMemberResources();
        if (members == null || members.size() == 0) {
            return;
        }
        int i = 0;
        while (i < members.size()) {
            Object member = members.get(i);
            if (member instanceof ContentCollection) {
                this.archiveCollection((ContentCollection)member, doc, stack);
            } else if (member instanceof ContentResource) {
                ContentResource resource = (ContentResource)member;
                resource.getContent();
                resource.toXml(doc, stack);
            }
            ++i;
        }
    }

    protected void archiveAttachments(ReferenceVector attachments, Document doc, Stack stack) {
        Element element = doc.createElement("attachments");
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        GenericContentHostingService service = (GenericContentHostingService)((Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME));
        int i = 0;
        while (i < attachments.size()) {
            Reference ref = (Reference)attachments.elementAt(i);
            String id = ref.getId();
            if (id.startsWith("/attachment/")) {
                try {
                    ContentResource resource = service.getResource(id);
                    resource.getContent();
                    resource.toXml(doc, stack);
                }
                catch (Exception any) {
                    Log.warn("chef", this + ".archve: exception archiving attachment: " + id + ": ", (Throwable)any);
                }
            }
            ++i;
        }
        stack.pop();
    }

    public void merge(String fileName, String siteId, String mergeId) {
        File[] files = null;
        File file = new File(this.m_storagePath + fileName);
        if (file == null || !file.exists()) {
            Log.warn("chef", this + ".merge(): file found: " + fileName);
            return;
        }
        files = file.isDirectory() ? file.listFiles() : new File[]{file};
        if (mergeId == null || mergeId.length() == 0) {
            mergeId = new Time().toString();
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].getPath().indexOf("-site.xml") != -1) {
                this.processMerge(files[i].getPath(), siteId, mergeId);
                files[i] = null;
                break;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < files.length) {
            if (files[i2] != null) {
                this.processMerge(files[i2].getPath(), siteId, mergeId);
            }
            ++i2;
        }
    }

    protected void processMerge(String fileName, String siteId, String mergeId) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".merge(): processing file: " + fileName);
        }
        Site theSite = null;
        try {
            theSite = SiteService.getSite(siteId);
        }
        catch (IdUnusedException ignore) {
            // empty catch block
        }
        Document doc = Xml.readDocument(fileName);
        if (doc == null) {
            Log.warn("chef", this + ".processMerge(): problem reading doc: " + fileName);
            return;
        }
        String channelId = "site-" + siteId;
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("archive")) {
            Log.warn("chef", this + ".processMerge(): not an archive file: " + root.getTagName());
            return;
        }
        String fromSite = root.getAttribute("site");
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Element element = (Element)child;
                if (element.getTagName().equals(GenericSiteService.SERVICE_NAME)) {
                    this.mergeSite(siteId, fromSite, element);
                    try {
                        theSite = SiteService.getSite(siteId);
                    }
                    catch (IdUnusedException ignore) {
                        Log.warn("chef", this + ".processMerge(): site not found after mergeSite: " + siteId);
                    }
                } else {
                    if (theSite == null) {
                        Log.warn("chef", this + ".processMerge(): site not found: " + siteId);
                        return;
                    }
                    if (element.getTagName().equals(GenericChatService.SERVICE_NAME)) {
                        this.mergeMessages(channelId, mergeId, siteId, fromSite, GenericChatService.SERVICE_NAME, element);
                    } else if (element.getTagName().equals(GenericDiscussionService.SERVICE_NAME)) {
                        this.mergeMessages(channelId, mergeId, siteId, fromSite, GenericDiscussionService.SERVICE_NAME, element);
                    } else if (element.getTagName().equals(GenericAnnouncementService.SERVICE_NAME)) {
                        this.mergeMessages(channelId, mergeId, siteId, fromSite, GenericAnnouncementService.SERVICE_NAME, element);
                    } else if (element.getTagName().equals(GenericCalendarService.SERVICE_NAME)) {
                        this.mergeCalendar(channelId, mergeId, siteId, fromSite, element);
                    } else if (element.getTagName().equals(GenericContentHostingService.SERVICE_NAME)) {
                        this.mergeContent(siteId, fromSite, element);
                    } else if (element.getTagName().equals("attachments")) {
                        this.mergeAttachments(mergeId, element);
                    } else if (element.getTagName().equals(GenericUserDirectoryService.SERVICE_NAME)) {
                        this.mergeUsers(element);
                    }
                }
            }
            ++i;
        }
    }

    protected void mergeMessages(String channelId, String mergeId, String siteId, String fromSiteId, String serviceId, Element element) {
        try {
            GenericMessageService service = (GenericMessageService)((Object)TurbineServices.getInstance().getService(serviceId));
            MessageChannel channel = null;
            try {
                channel = service.getChannel(channelId);
            }
            catch (IdUnusedException e) {
                channel = service.addChannel(channelId);
            }
            NodeList children2 = element.getChildNodes();
            int length2 = children2.getLength();
            int i2 = 0;
            while (i2 < length2) {
                Element element2;
                Node child2 = children2.item(i2);
                if (child2.getNodeType() == 1 && (element2 = (Element)child2).getTagName().equals("channel")) {
                    NodeList children3 = element2.getChildNodes();
                    int length3 = children3.getLength();
                    int i3 = 0;
                    while (i3 < length3) {
                        Element element3;
                        Node child3 = children3.item(i3);
                        if (child3.getNodeType() == 1 && (element3 = (Element)child3).getTagName().equals("message")) {
                            NodeList children4 = element3.getChildNodes();
                            int length4 = children4.getLength();
                            int i4 = 0;
                            while (i4 < length4) {
                                Element element4;
                                Node child4 = children4.item(i4);
                                if (child4.getNodeType() == 1 && (element4 = (Element)child4).getTagName().equals("header")) {
                                    String oldId = element4.getAttribute("id");
                                    element4.setAttribute("id", mergeId + "-" + oldId);
                                    String oldReplyTo = element4.getAttribute("replyTo");
                                    if (oldReplyTo != null && oldReplyTo.length() > 0) {
                                        element4.setAttribute("replyTo", mergeId + "-" + oldReplyTo);
                                    }
                                    NodeList children5 = element4.getChildNodes();
                                    int length5 = children5.getLength();
                                    int i5 = 0;
                                    while (i5 < length5) {
                                        Element element5;
                                        Node child5 = children5.item(i5);
                                        if (child5.getNodeType() == 1 && (element5 = (Element)child5).getTagName().equals("attachment")) {
                                            String newUrl;
                                            String oldUrl = element5.getAttribute("relative-url");
                                            if (oldUrl.startsWith("/content/attachment/")) {
                                                newUrl = "/content/attachment/" + mergeId + "-" + oldUrl.substring(20);
                                                element5.setAttribute("relative-url", newUrl);
                                            } else if (oldUrl.startsWith("/content/site/" + fromSiteId + "/")) {
                                                newUrl = "/content/site/" + siteId + oldUrl.substring(15 + fromSiteId.length());
                                                element5.setAttribute("relative-url", newUrl);
                                            }
                                        }
                                        ++i5;
                                    }
                                }
                                ++i4;
                            }
                            channel.mergeMessage(element3);
                        }
                        ++i3;
                    }
                }
                ++i2;
            }
        }
        catch (Exception any) {
            Log.warn("chef", this + ".mergeMessages(): exception in handling " + serviceId + " : ", (Throwable)any);
        }
    }

    protected void mergeCalendar(String channelId, String mergeId, String siteId, String fromSiteId, Element element) {
        try {
            GenericCalendarService service = (GenericCalendarService)((Object)TurbineServices.getInstance().getService(GenericCalendarService.SERVICE_NAME));
            Calendar calendar = null;
            try {
                calendar = service.getCalendar(channelId);
            }
            catch (IdUnusedException e) {
                calendar = service.addCalendar(channelId);
            }
            NodeList children2 = element.getChildNodes();
            int length2 = children2.getLength();
            int i2 = 0;
            while (i2 < length2) {
                Element element2;
                Node child2 = children2.item(i2);
                if (child2.getNodeType() == 1 && (element2 = (Element)child2).getTagName().equals("calendar")) {
                    NodeList children3 = element2.getChildNodes();
                    int length3 = children3.getLength();
                    int i3 = 0;
                    while (i3 < length3) {
                        Element element3;
                        Node child3 = children3.item(i3);
                        if (child3.getNodeType() == 1 && (element3 = (Element)child3).getTagName().equals("event")) {
                            String oldId = element3.getAttribute("id");
                            element3.setAttribute("id", mergeId + "-" + oldId);
                            NodeList children5 = element3.getChildNodes();
                            int length5 = children5.getLength();
                            int i5 = 0;
                            while (i5 < length5) {
                                Element element5;
                                Node child5 = children5.item(i5);
                                if (child5.getNodeType() == 1 && (element5 = (Element)child5).getTagName().equals("attachment")) {
                                    String newUrl;
                                    String oldUrl = element5.getAttribute("relative-url");
                                    if (oldUrl.startsWith("/content/attachment/")) {
                                        newUrl = "/content/attachment/" + mergeId + "-" + oldUrl.substring(20);
                                        element5.setAttribute("relative-url", newUrl);
                                    } else if (oldUrl.startsWith("/content/site/" + fromSiteId + "/")) {
                                        newUrl = "/content/site/" + siteId + oldUrl.substring(15 + fromSiteId.length());
                                        element5.setAttribute("relative-url", newUrl);
                                    }
                                }
                                ++i5;
                            }
                            calendar.mergeEvent(element3);
                        }
                        ++i3;
                    }
                }
                ++i2;
            }
        }
        catch (Exception any) {
            Log.warn("chef", this + ".mergeCalendar(): exception: ", (Throwable)any);
        }
    }

    protected void mergeContent(String siteId, String fromSiteId, Element root) {
        try {
            GenericContentHostingService service = (GenericContentHostingService)((Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME));
            NodeList children = root.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    String newId;
                    String oldId;
                    Element element = (Element)child;
                    if (element.getTagName().equals("collection")) {
                        oldId = element.getAttribute("id");
                        if (oldId.startsWith("/site/" + fromSiteId)) {
                            newId = "/site/" + siteId + oldId.substring(7 + fromSiteId.length());
                            element.setAttribute("id", newId);
                        }
                        NodeList children2 = element.getChildNodes();
                        int length2 = children2.getLength();
                        int i2 = 0;
                        while (i2 < length2) {
                            Element element2;
                            Node child2 = children2.item(i2);
                            if (child2.getNodeType() == 1 && (element2 = (Element)child2).getTagName().equals("members")) {
                                NodeList children3 = element2.getChildNodes();
                                int length3 = children3.getLength();
                                int i3 = 0;
                                while (i3 < length3) {
                                    Element element3;
                                    Node child3 = children3.item(i3);
                                    if (child3.getNodeType() == 1 && (element3 = (Element)child3).getTagName().equals("member") && (oldId = element3.getAttribute("id")).startsWith("/site/" + fromSiteId)) {
                                        String newId2 = "/site/" + siteId + oldId.substring(7 + fromSiteId.length());
                                        element3.setAttribute("id", newId2);
                                    }
                                    ++i3;
                                }
                            }
                            ++i2;
                        }
                        service.mergeCollection(element);
                    } else if (element.getTagName().equals("resource")) {
                        oldId = element.getAttribute("id");
                        if (oldId.startsWith("/site/" + fromSiteId)) {
                            newId = "/site/" + siteId + oldId.substring(7 + fromSiteId.length());
                            element.setAttribute("id", newId);
                        }
                        service.mergeResource(element);
                    }
                }
                ++i;
            }
        }
        catch (Exception any) {
            Log.warn("chef", this + ".mergeContent(): exception: ", (Throwable)any);
        }
    }

    protected void mergeAttachments(String mergeId, Element root) {
        try {
            GenericContentHostingService service = (GenericContentHostingService)((Object)TurbineServices.getInstance().getService(GenericContentHostingService.SERVICE_NAME));
            NodeList children = root.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element = (Element)child).getTagName().equals("resource")) {
                    String oldId = element.getAttribute("id");
                    if (oldId.startsWith("/attachment/")) {
                        String newId = "/attachment/" + mergeId + "-" + oldId.substring(12);
                        element.setAttribute("id", newId);
                    }
                    service.mergeResource(element);
                }
                ++i;
            }
        }
        catch (Exception any) {
            Log.warn("chef", this + ".mergeAttachments(): exception: ", (Throwable)any);
        }
    }

    protected void mergeSite(String siteId, String fromSiteId, Element element) {
        try {
            Site site = null;
            try {
                site = SiteService.getSite(siteId);
            }
            catch (IdUnusedException e) {
                // empty catch block
            }
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element2;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element2 = (Element)child).getTagName().equals("site")) {
                    String oldId = element2.getAttribute("id");
                    element2.setAttribute("id", siteId);
                    if (site != null) {
                        NodeList children2 = element2.getChildNodes();
                        int length2 = children2.getLength();
                        int i2 = 0;
                        while (i2 < length2) {
                            Element element3;
                            Node child2 = children2.item(i2);
                            if (child2.getNodeType() != 1 || !(element3 = (Element)child2).getTagName().equals("roles")) {
                                // empty if block
                            }
                            ++i2;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception any) {
            Log.warn("chef", this + ".mergeSite(): exception: ", (Throwable)any);
        }
    }

    protected void mergeUsers(Element element) {
        try {
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                Element element2;
                Node child = children.item(i);
                if (child.getNodeType() == 1 && (element2 = (Element)child).getTagName().equals("user")) {
                    try {
                        UserDirectoryService.mergeUser(element2);
                    }
                    catch (IdUsedException e) {
                    }
                    catch (IdInvalidException e) {
                        Log.warn("chef", this + ".mergeUsers(): exception: " + e);
                    }
                    catch (PermissionException e) {
                        Log.warn("chef", this + ".mergeUsers(): exception: " + e);
                    }
                }
                ++i;
            }
        }
        catch (Exception any) {
            Log.warn("chef", this + ".mergeUsers(): exception: ", (Throwable)any);
        }
    }
}

