/*###############################################################################
# Linux Management Providers (LMP), Sensors provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SENSORCAPABILITIESACCESS_H_
#define OPENDRIM_SENSORCAPABILITIESACCESS_H_

#include "Sensors_Common.h"

#include "OpenDRIM_SensorCapabilities.h"
#include "assocOpenDRIM_SensorCapabilities.h"

int Sensors_OpenDRIM_SensorCapabilities_load(const CMPIBroker* broker, string& errorMessage);

int Sensors_OpenDRIM_SensorCapabilities_unload(string& errorMessage);

int Sensors_OpenDRIM_SensorCapabilities_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SensorCapabilities>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_SensorCapabilities_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SensorCapabilities& instance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_SensorCapabilities_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SensorCapabilities& newInstance, const OpenDRIM_SensorCapabilities& oldInstance, const char** properties, string& errorMessage);

int Sensors_OpenDRIM_SensorCapabilities_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SensorCapabilities& instance, string& errorMessage);

int Sensors_OpenDRIM_SensorCapabilities_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SensorCapabilities& instance, string& errorMessage);

int Sensors_OpenDRIM_SensorCapabilities_associatorCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_SensorCapabilities_associatorManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& Capabilities_associatedInstances, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_SensorCapabilities_referenceCapabilitiesToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Capabilities_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_SensorCapabilities>& OpenDRIM_SensorCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_SensorCapabilities_referenceManagedElementToCapabilities(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& Capabilities_instances, vector<OpenDRIM_SensorCapabilities>& OpenDRIM_SensorCapabilities_instances, const char** properties, string& errorMessage, const string& discriminant);

int Sensors_OpenDRIM_SensorCapabilities_populate(OpenDRIM_SensorCapabilities& instance, string& errorMessage);

#endif /*OPENDRIM_SENSORCAPABILITIESACCESS_H_*/
