package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEniMonitorData invokes the ecs.DescribeEniMonitorData API synchronously
// api document: https://help.aliyun.com/api/ecs/describeenimonitordata.html
func (client *Client) DescribeEniMonitorData(request *DescribeEniMonitorDataRequest) (response *DescribeEniMonitorDataResponse, err error) {
	response = CreateDescribeEniMonitorDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEniMonitorDataWithChan invokes the ecs.DescribeEniMonitorData API asynchronously
// api document: https://help.aliyun.com/api/ecs/describeenimonitordata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEniMonitorDataWithChan(request *DescribeEniMonitorDataRequest) (<-chan *DescribeEniMonitorDataResponse, <-chan error) {
	responseChan := make(chan *DescribeEniMonitorDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEniMonitorData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEniMonitorDataWithCallback invokes the ecs.DescribeEniMonitorData API asynchronously
// api document: https://help.aliyun.com/api/ecs/describeenimonitordata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEniMonitorDataWithCallback(request *DescribeEniMonitorDataRequest, callback func(response *DescribeEniMonitorDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEniMonitorDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeEniMonitorData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEniMonitorDataRequest is the request struct for api DescribeEniMonitorData
type DescribeEniMonitorDataRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StartTime            string           `position:"Query" name:"StartTime"`
	Period               requests.Integer `position:"Query" name:"Period"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	EniId                string           `position:"Query" name:"EniId"`
}

// DescribeEniMonitorDataResponse is the response struct for api DescribeEniMonitorData
type DescribeEniMonitorDataResponse struct {
	*responses.BaseResponse
	RequestId   string                              `json:"RequestId" xml:"RequestId"`
	TotalCount  int                                 `json:"TotalCount" xml:"TotalCount"`
	MonitorData MonitorDataInDescribeEniMonitorData `json:"MonitorData" xml:"MonitorData"`
}

// CreateDescribeEniMonitorDataRequest creates a request to invoke DescribeEniMonitorData API
func CreateDescribeEniMonitorDataRequest() (request *DescribeEniMonitorDataRequest) {
	request = &DescribeEniMonitorDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeEniMonitorData", "ecs", "openAPI")
	return
}

// CreateDescribeEniMonitorDataResponse creates a response to parse from DescribeEniMonitorData response
func CreateDescribeEniMonitorDataResponse() (response *DescribeEniMonitorDataResponse) {
	response = &DescribeEniMonitorDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
