/* Copyright 2017-2021 PaGMO development team

This file is part of the PaGMO library.

The PaGMO library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 3 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The PaGMO library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the PaGMO library.  If not,
see https://www.gnu.org/licenses/. */

#ifndef PAGMO_DETAIL_VISIBILITY_HPP
#define PAGMO_DETAIL_VISIBILITY_HPP

#include <pagmo/config.hpp>

// The visibility setup makes sense only for shared
// library builds.
#if defined(PAGMO_STATIC_BUILD)

#define PAGMO_DLL_PUBLIC
#define PAGMO_DLL_LOCAL
#define PAGMO_DLL_PUBLIC_INLINE_CLASS

#else

// Convenience macros for setting the visibility of entities
// when building/using the shared library. Mostly inspired by:
// https://gcc.gnu.org/wiki/Visibility
// We check first for Windows, where we assume every compiler
// knows dllexport/dllimport. On other platforms, we use the GCC-like
// syntax for GCC, clang and ICC. Otherwise, we leave the definitions
// empty.
#if defined(_WIN32) || defined(__CYGWIN__)

#if defined(pagmo_EXPORTS)

#define PAGMO_DLL_PUBLIC __declspec(dllexport)

#else

#define PAGMO_DLL_PUBLIC __declspec(dllimport)

#endif

#define PAGMO_DLL_LOCAL

#elif defined(__clang__) || defined(__GNUC__) || defined(__INTEL_COMPILER)

#define PAGMO_DLL_PUBLIC __attribute__((visibility("default")))
#define PAGMO_DLL_LOCAL __attribute__((visibility("hidden")))

#else

#define PAGMO_DLL_PUBLIC
#define PAGMO_DLL_LOCAL

#endif

// NOTE: it seems like on Windows using dllimport/dllexport on inline classes
// is generally not helpful (and potentially harmful), apart from special use cases:
// https://stackoverflow.com/questions/8876279/c-inline-functions-with-dllimport-dllexport
// https://stackoverflow.com/questions/24511376/how-to-dllexport-a-class-derived-from-stdruntime-error
// https://devblogs.microsoft.com/oldnewthing/20140109-00/?p=2123
// Setting the visibility attribute on GCC-like compilers for inline classes, however, seems to be ok.
// Thus, we use a specialised definition for marking "public"ly visible inline classes.
#if defined(_WIN32) || defined(__CYGWIN__)

#define PAGMO_DLL_PUBLIC_INLINE_CLASS

#else

#define PAGMO_DLL_PUBLIC_INLINE_CLASS PAGMO_DLL_PUBLIC

#endif

#endif

#endif
