/**
 * @file
 *
 * @author jeffrey.daily@gmail.com
 *
 * Copyright (c) 2015 Battelle Memorial Institute.
 *
 * This file was converted to C code from the raw file found at
 * ftp://ftp.cbi.pku.edu.cn/pub/software/blast/matrices/PAM270, the
 * Center for Bioinformatics, Peking University, China.
 */
#ifndef _PARASAIL_PAM270_H_
#define _PARASAIL_PAM270_H_

#include "parasail.h"
#include "pam_map.h"

#ifdef __cplusplus
extern "C" {
#endif

/* # */
/* # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93] */
/* # */
/* # PAM 270 substitution matrix, scale = ln(2)/4 = 0.173287 */
/* # */
/* # Expected score = -0.969, Entropy = 0.309 bits */
/* # */
/* # Lowest score = -10, Highest score = 23 */
/* # */

static const int parasail_pam270_[] = {
/*        A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   * */
/* A */   2, -2,  0,  0, -2,  0,  0,  2, -2, -1, -2, -1, -1, -4,  1,  1,  1, -7, -4,  0,  0,  0,  0,-10,
/* R */  -2,  8,  0, -1, -5,  2, -1, -3,  2, -2, -4,  4, -1, -5,  0,  0, -1,  3, -5, -3, -1,  0, -1,-10,
/* N */   0,  0,  2,  2, -4,  1,  2,  1,  2, -2, -3,  1, -2, -4,  0,  1,  1, -5, -3, -2,  2,  2,  0,-10,
/* D */   0, -1,  2,  5, -6,  2,  4,  1,  1, -3, -5,  0, -3, -7, -1,  0,  0, -8, -5, -3,  4,  3, -1,-10,
/* C */  -2, -5, -4, -6, 16, -7, -6, -4, -4, -3, -7, -7, -6, -5, -3,  0, -3,-10,  1, -2, -5, -7, -4,-10,
/* Q */   0,  2,  1,  2, -7,  5,  3, -1,  4, -2, -2,  1, -1, -6,  0, -1, -1, -6, -5, -2,  2,  4, -1,-10,
/* E */   0, -1,  2,  4, -6,  3,  5,  0,  1, -2, -4,  0, -3, -7, -1,  0,  0, -9, -5, -2,  3,  4, -1,-10,
/* G */   2, -3,  1,  1, -4, -1,  0,  6, -2, -3, -5, -2, -3, -6,  0,  1,  0, -9, -6, -2,  1,  0, -1,-10,
/* H */  -2,  2,  2,  1, -4,  4,  1, -2,  8, -3, -3,  0, -3, -2,  0, -1, -1, -3,  0, -3,  1,  2, -1,-10,
/* I */  -1, -2, -2, -3, -3, -2, -2, -3, -3,  5,  3, -2,  3,  1, -2, -2,  0, -6, -1,  5, -3, -2, -1,-10,
/* L */  -2, -4, -3, -5, -7, -2, -4, -5, -3,  3,  8, -3,  5,  2, -3, -3, -2, -2, -1,  2, -4, -3, -2,-10,
/* K */  -1,  4,  1,  0, -7,  1,  0, -2,  0, -2, -3,  6,  0, -6, -1,  0,  0, -4, -5, -3,  1,  0, -1,-10,
/* M */  -1, -1, -2, -3, -6, -1, -3, -3, -3,  3,  5,  0,  8,  0, -2, -2, -1, -5, -3,  2, -3, -2, -1,-10,
/* F */  -4, -5, -4, -7, -5, -6, -7, -6, -2,  1,  2, -6,  0, 12, -6, -4, -4,  1,  9, -1, -6, -6, -3,-10,
/* P */   1,  0,  0, -1, -3,  0, -1,  0,  0, -2, -3, -1, -2, -6,  7,  1,  0, -7, -6, -1, -1,  0, -1,-10,
/* S */   1,  0,  1,  0,  0, -1,  0,  1, -1, -2, -3,  0, -2, -4,  1,  2,  2, -3, -4, -1,  1,  0,  0,-10,
/* T */   1, -1,  1,  0, -3, -1,  0,  0, -1,  0, -2,  0, -1, -4,  0,  2,  3, -6, -3,  0,  0, -1,  0,-10,
/* W */  -7,  3, -5, -8,-10, -6, -9, -9, -3, -6, -2, -4, -5,  1, -7, -3, -6, 23,  0, -8, -7, -7, -5,-10,
/* Y */  -4, -5, -3, -5,  1, -5, -5, -6,  0, -1, -1, -5, -3,  9, -6, -4, -3,  0, 13, -3, -4, -5, -3,-10,
/* V */   0, -3, -2, -3, -2, -2, -2, -2, -3,  5,  2, -3,  2, -1, -1, -1,  0, -8, -3,  5, -2, -2, -1,-10,
/* B */   0, -1,  2,  4, -5,  2,  3,  1,  1, -3, -4,  1, -3, -6, -1,  1,  0, -7, -4, -2,  3,  3, -1,-10,
/* Z */   0,  0,  2,  3, -7,  4,  4,  0,  2, -2, -3,  0, -2, -6,  0,  0, -1, -7, -5, -2,  3,  4, -1,-10,
/* X */   0, -1,  0, -1, -4, -1, -1, -1, -1, -1, -2, -1, -1, -3, -1,  0,  0, -5, -3, -1, -1, -1, -1,-10,
/* * */ -10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,-10,  1
};

static const parasail_matrix_t parasail_pam270 = {
    "pam270",
    parasail_pam270_,
    parasail_pam_map,
    24,
    23,
    -10,
    NULL,
    PARASAIL_MATRIX_TYPE_SQUARE,
    24,
    "ARNDCQEGHILKMFPSTWYVBZX*",
    NULL
};

#ifdef __cplusplus
}
#endif

#endif /* _PARASAIL_PAM270_H_ */

