// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <SiloPluginInfo.h>
#include <avtSiloFileFormat.h>
#include <avtSTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtSiloOptions.h>

// ****************************************************************************
//  Method:  SiloCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a Silo database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
SiloCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_STMD;
}

// ****************************************************************************
//  Method: SiloCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a Silo database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A Silo database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
SiloCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    avtSTMDFileFormat **ffl = new avtSTMDFileFormat*[nList];
    for (int i = 0; i < nList; i++)
    {
        ffl[i] = new avtSiloFileFormat(list[i], readOptions);
    }
    avtSTMDFileFormatInterface *inter
           = new avtSTMDFileFormatInterface(ffl, nList);
    return new avtGenericDatabase(inter);
}

// ****************************************************************************
//  Method: SiloCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
SiloCommonPluginInfo::GetReadOptions() const
{
    return GetSiloReadOptions();
}

// ****************************************************************************
//  Method: SiloCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
SiloCommonPluginInfo::GetWriteOptions() const
{
    return GetSiloWriteOptions();
}

// ****************************************************************************
//  Method: SiloCommonPluginInfo::SetReadOptions
//
//  Purpose: Override default method so can provide a way of handling obsolete
//  options.
//
//  Programmer: Mark C. Miller
//  Creation:   Mon Mar 16 23:32:25 PDT 2009
//
//    Mark C. Miller, Wed Jul 21 16:11:52 PDT 2010
//    Resurrected after getting clobbered in r8950.
// ****************************************************************************
#include <string>
#include <DBOptionsAttributes.h>
#include <DebugStream.h>

using namespace SiloDBOptions;
using std::string;

void
SiloCommonPluginInfo::SetReadOptions(DBOptionsAttributes *opts)
{
    DBOptionsAttributes *defaultReadOptions = GetReadOptions();

    for (int i = 0; i < opts->GetNumberOfOptions(); i++)
    {
        string optname = opts->GetName(i);

        // We only care about handling obsolete options here
        if (!opts->IsObsolete(optname) && !defaultReadOptions->IsObsolete(optname))
            continue;

        if (optname == SILO_RDOPT_IGNORE_SEXTS2)
        {
            int enumval = -1;
            for (int j = 0; j < opts->GetNumberOfOptions(); j++)
            {
                if (opts->GetName(j) == SILO_RDOPT_IGNORE_SEXTS)
                {
                    enumval = opts->GetEnum(SILO_RDOPT_IGNORE_SEXTS);
                    break;
                }
            }
            if (enumval == -1 || enumval == 3) // Undef
            {
                debug1 << "Using old option \"" << SILO_RDOPT_IGNORE_SEXTS2
                       << "\" to set new option \"" << SILO_RDOPT_IGNORE_SEXTS;
                if (opts->GetBool(SILO_RDOPT_IGNORE_SEXTS2))
                {
                    debug1 << "\" to Always" << endl;
                    opts->SetEnum(SILO_RDOPT_IGNORE_SEXTS, 0); // Always
                }
                else
                {
                    debug1 << "\" to Never" << endl;
                    opts->SetEnum(SILO_RDOPT_IGNORE_SEXTS, 2); // Never
                }
                opts->SetEnumStrings(SILO_RDOPT_IGNORE_SEXTS, defaultReadOptions->GetEnumStrings(SILO_RDOPT_IGNORE_SEXTS));
            }
        }
        else if (optname == SILO_RDOPT_IGNORE_DEXTS2)
        {
            int enumval = -1;
            for (int j = 0; j < opts->GetNumberOfOptions(); j++)
            {
                if (opts->GetName(j) == SILO_RDOPT_IGNORE_DEXTS)
                {
                    enumval = opts->GetEnum(SILO_RDOPT_IGNORE_DEXTS);
                    break;
                }
            }
            if (enumval == -1 || enumval == 3) // Undef
            {
                debug1 << "Using old option \"" << SILO_RDOPT_IGNORE_DEXTS2
                       << "\" to set new option \"" << SILO_RDOPT_IGNORE_DEXTS;
                if (opts->GetBool(SILO_RDOPT_IGNORE_DEXTS2))
                {
                    debug1 << "\" to Always" << endl;
                    opts->SetEnum(SILO_RDOPT_IGNORE_DEXTS, 0); // Always
                }
                else
                {
                    debug1 << "\" to Never" << endl;
                    opts->SetEnum(SILO_RDOPT_IGNORE_DEXTS, 2); // Never
                }
                opts->SetEnumStrings(SILO_RDOPT_IGNORE_DEXTS, defaultReadOptions->GetEnumStrings(SILO_RDOPT_IGNORE_DEXTS));
            }
        }
    }

    delete defaultReadOptions;

    readOptions = opts;
}

