/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

public class BooleanArray {
    private static final int DEFAULT_SIZE = 512;
    private static final int INCREMENT_SIZE = 256;
    private int valueCount;
    private boolean[] array;

    public BooleanArray() {
        this(512);
    }

    public BooleanArray(int n) {
        this.array = new boolean[n];
        this.valueCount = 0;
    }

    public int size() {
        return this.valueCount;
    }

    public void clear() {
        this.valueCount = 0;
    }

    public void add(boolean bl) {
        if (this.valueCount == this.array.length) {
            boolean[] blArray = new boolean[this.array.length + 256];
            System.arraycopy(this.array, 0, blArray, 0, this.array.length);
            this.array = blArray;
        }
        this.array[this.valueCount++] = bl;
    }

    public void add(boolean[] blArray) {
        int n = this.valueCount + blArray.length;
        if (n >= this.array.length) {
            boolean[] blArray2 = new boolean[n];
            System.arraycopy(this.array, 0, blArray2, 0, this.array.length);
            this.array = blArray2;
        }
        System.arraycopy(blArray, 0, this.array, this.valueCount, blArray.length);
        this.valueCount = n;
    }

    public boolean get(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, boolean bl) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = bl;
    }

    public boolean remove(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        boolean bl = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.array.length - n - 1);
        --this.valueCount;
        return bl;
    }

    public boolean[] toArray() {
        boolean[] blArray = new boolean[this.valueCount];
        System.arraycopy(this.array, 0, blArray, 0, this.valueCount);
        return blArray;
    }

    public boolean[] toArray(boolean[] blArray) {
        boolean[] blArray2 = null;
        blArray2 = blArray.length >= this.valueCount ? blArray : new boolean[this.valueCount];
        System.arraycopy(this.array, 0, blArray2, 0, this.valueCount);
        return blArray2;
    }
}

