/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input;

import java.util.ArrayList;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLKeyDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLTimeControlledNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.renderer.common.input.TimeSensorManager;
import org.web3d.vrml.util.NodeArray;
import org.xj3d.core.eventmodel.InputDeviceManager;
import org.xj3d.core.eventmodel.KeyDeviceSensorManager;
import org.xj3d.core.eventmodel.LayerSensorManager;
import org.xj3d.core.eventmodel.PickingManager;
import org.xj3d.core.eventmodel.SensorManager;

public class DefaultSensorManager
implements SensorManager {
    private static final String ADD_SENSOR_UNKNOWN_TYPE = "An unknown sensor type has been added to the sensor manager: ";
    private static final String REMOVE_SENSOR_UNKNOWN_TYPE = "An unknown sensor type has been removed from the sensor manager: ";
    protected TimeSensorManager timeSensors;
    protected KeyDeviceSensorManager keySensors;
    protected PickingManager pickManager;
    protected LayerSensorManager[] layerManagers;
    protected int numLayerManagers;
    protected InputDeviceManager inputManager;
    protected ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    protected boolean navigationEnabled = true;
    protected float worldScale = 1.0f;
    protected float invWorldScale = 1.0f;
    protected int numPointingDeviceSensors;
    protected int[] renderOrder;
    protected int numRenderOrder = 0;

    public DefaultSensorManager() {
        this.timeSensors = new TimeSensorManager();
        this.layerManagers = new LayerSensorManager[6];
        this.renderOrder = new int[1];
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        this.timeSensors.setErrorReporter(errorReporter);
        if (this.inputManager != null) {
            this.inputManager.setErrorReporter(this.errorReporter);
        }
        if (this.keySensors != null) {
            this.keySensors.setErrorReporter(this.errorReporter);
        }
        if (this.pickManager != null) {
            this.pickManager.setErrorReporter(this.errorReporter);
        }
    }

    public void setRenderOrder(int[] nArray, int n) {
        if (this.renderOrder.length < n) {
            this.renderOrder = new int[n];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= this.numLayerManagers) continue;
            this.renderOrder[n2++] = nArray[i];
        }
        this.numRenderOrder = n2;
    }

    public void processUserInput(int n, long l) {
        int n2;
        this.timeSensors.clockTick(l);
        for (n2 = this.numRenderOrder - 1; n2 >= 0; --n2) {
            this.layerManagers[this.renderOrder[n2]].processUserInput(l);
        }
        if (this.inputManager != null) {
            this.inputManager.beginTrackerProcessing();
            for (int i = this.numRenderOrder - 1; i >= 0; --i) {
                this.inputManager.processTrackers(n2, (n2 = this.renderOrder[i]) == n, this.layerManagers[n2].getUserInputHandler(), this.layerManagers[n2].getIsPickable());
            }
            this.inputManager.endTrackerProcessing();
        }
        if (this.keySensors != null) {
            this.keySensors.processEvents();
        }
        if (this.pickManager != null) {
            this.pickManager.processPickSensors(l);
        }
    }

    public void addLayerSensorManager(LayerSensorManager layerSensorManager) {
        boolean bl = false;
        for (int i = 0; i < this.numLayerManagers && !bl; ++i) {
            if (this.layerManagers[i].getLayerId() != layerSensorManager.getLayerId()) continue;
            this.layerManagers[i] = layerSensorManager;
            bl = true;
        }
        if (!bl) {
            if (this.layerManagers.length == this.numLayerManagers) {
                LayerSensorManager[] layerSensorManagerArray = new LayerSensorManager[this.numLayerManagers + 4];
                System.arraycopy(this.layerManagers, 0, layerSensorManagerArray, 0, this.numLayerManagers);
                this.layerManagers = layerSensorManagerArray;
            }
            this.layerManagers[this.numLayerManagers++] = layerSensorManager;
        }
        layerSensorManager.setInputManager(this.inputManager);
        layerSensorManager.setErrorReporter(this.errorReporter);
    }

    public void removeLayerSensorManager(LayerSensorManager layerSensorManager) {
        for (int i = 0; i < this.numLayerManagers; ++i) {
            if (this.layerManagers[i].getLayerId() != layerSensorManager.getLayerId()) continue;
            System.arraycopy(this.layerManagers, i + 1, this.layerManagers, i, this.numLayerManagers - i - 1);
            --this.numLayerManagers;
            break;
        }
        layerSensorManager.setInputManager(null);
        layerSensorManager.setErrorReporter(null);
    }

    public void setInputManager(InputDeviceManager inputDeviceManager) {
        this.inputManager = inputDeviceManager;
        if (inputDeviceManager != null) {
            inputDeviceManager.setErrorReporter(this.errorReporter);
            this.inputManager.initialize();
        }
        for (int i = 0; i < this.numLayerManagers; ++i) {
            this.layerManagers[i].setInputManager(inputDeviceManager);
        }
    }

    public void setKeyDeviceSensorManager(KeyDeviceSensorManager keyDeviceSensorManager) {
        this.keySensors = keyDeviceSensorManager;
        if (keyDeviceSensorManager != null) {
            this.keySensors.setErrorReporter(this.errorReporter);
        }
    }

    public void setPickingManager(PickingManager pickingManager) {
        this.pickManager = pickingManager;
        if (pickingManager != null) {
            pickingManager.setErrorReporter(this.errorReporter);
        }
    }

    public void removeSensors(NodeArray nodeArray) {
        int n;
        int n2 = nodeArray.size();
        block12: for (n = 0; n < n2; ++n) {
            VRMLSensorNodeType vRMLSensorNodeType = (VRMLSensorNodeType)nodeArray.get(n);
            switch (vRMLSensorNodeType.getPrimaryType()) {
                case 13: 
                case 28: 
                case 36: {
                    --this.numPointingDeviceSensors;
                    continue block12;
                }
                case 26: {
                    this.keySensors.removeSensor((VRMLKeyDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                case 52: 
                case 53: {
                    ((VRMLTimeDependentNodeType)((Object)vRMLSensorNodeType)).setVRMLClock(null);
                    continue block12;
                }
                case 73: {
                    this.pickManager.removeSensor((VRMLPickingSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                case 78: {
                    this.inputManager.removeX3DNode((VRMLDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                case 14: 
                case 42: {
                    int[] nArray = vRMLSensorNodeType.getSecondaryType();
                    block13: for (int i = 0; i < nArray.length; ++i) {
                        switch (nArray[i]) {
                            case 26: {
                                this.keySensors.removeSensor((VRMLKeyDeviceSensorNodeType)vRMLSensorNodeType);
                                continue block13;
                            }
                            case 52: 
                            case 53: {
                                ((VRMLTimeDependentNodeType)((Object)vRMLSensorNodeType)).setVRMLClock(null);
                            }
                        }
                    }
                    continue block12;
                }
                default: {
                    this.errorReporter.warningReport(REMOVE_SENSOR_UNKNOWN_TYPE + vRMLSensorNodeType.getVRMLNodeName(), null);
                }
            }
        }
        for (n = 0; n < this.numLayerManagers; ++n) {
            this.layerManagers[n].removeSensors(nodeArray);
        }
    }

    public void addSensors(NodeArray nodeArray) {
        int n;
        int n2 = nodeArray.size();
        block12: for (n = 0; n < n2; ++n) {
            VRMLSensorNodeType vRMLSensorNodeType = (VRMLSensorNodeType)nodeArray.get(n);
            switch (vRMLSensorNodeType.getPrimaryType()) {
                case 13: 
                case 28: 
                case 36: {
                    ++this.numPointingDeviceSensors;
                    continue block12;
                }
                case 26: {
                    this.keySensors.addSensor((VRMLKeyDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                case 52: 
                case 53: {
                    ((VRMLTimeDependentNodeType)((Object)vRMLSensorNodeType)).setVRMLClock(this.timeSensors);
                    continue block12;
                }
                case 78: {
                    this.inputManager.addX3DNode((VRMLDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                case 14: 
                case 42: {
                    int[] nArray = vRMLSensorNodeType.getSecondaryType();
                    block13: for (int i = 0; i < nArray.length; ++i) {
                        switch (nArray[i]) {
                            case 26: {
                                this.keySensors.addSensor((VRMLKeyDeviceSensorNodeType)vRMLSensorNodeType);
                                continue block13;
                            }
                            case 52: 
                            case 53: {
                                ((VRMLTimeDependentNodeType)((Object)vRMLSensorNodeType)).setVRMLClock(this.timeSensors);
                            }
                        }
                    }
                    continue block12;
                }
                case 73: {
                    this.pickManager.addSensor((VRMLPickingSensorNodeType)vRMLSensorNodeType);
                    continue block12;
                }
                default: {
                    this.errorReporter.warningReport(ADD_SENSOR_UNKNOWN_TYPE + vRMLSensorNodeType.getVRMLNodeName(), null);
                }
            }
        }
        for (n = 0; n < this.numLayerManagers; ++n) {
            this.layerManagers[n].addSensors(nodeArray);
        }
    }

    public void addViewDependentNodes(NodeArray nodeArray) {
        for (int i = 0; i < this.numLayerManagers; ++i) {
            this.layerManagers[i].addViewDependentNodes(nodeArray);
        }
    }

    public void removeViewDependentNodes(NodeArray nodeArray) {
        for (int i = 0; i < this.numLayerManagers; ++i) {
            this.layerManagers[i].removeViewDependentNodes(nodeArray);
        }
    }

    public void loadScene(BasicScene basicScene) {
        Object object;
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(26);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            this.keySensors.addSensor((VRMLKeyDeviceSensorNodeType)arrayList.get(n));
        }
        arrayList = basicScene.getBySecondaryType(52);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = arrayList.get(n);
            ((VRMLTimeDependentNodeType)object).setVRMLClock(this.timeSensors);
        }
        arrayList = basicScene.getBySecondaryType(53);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = arrayList.get(n);
            ((VRMLTimeControlledNodeType)object).setVRMLClock(this.timeSensors);
        }
        arrayList = basicScene.getByPrimaryType(36);
        this.numPointingDeviceSensors += arrayList.size();
        arrayList = basicScene.getByPrimaryType(13);
        this.numPointingDeviceSensors += arrayList.size();
        arrayList = basicScene.getBySecondaryType(28);
        this.numPointingDeviceSensors += arrayList.size();
        arrayList = basicScene.getByPrimaryType(78);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            object = (VRMLDeviceSensorNodeType)arrayList.get(n);
            this.inputManager.addX3DNode((VRMLDeviceSensorNodeType)object);
        }
        if (this.pickManager != null) {
            this.pickManager.loadScene(basicScene);
        }
        for (n = 0; n < this.numLayerManagers; ++n) {
            this.layerManagers[n].loadScene(basicScene);
        }
    }

    public void unloadScene(BasicScene basicScene) {
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(26);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            this.keySensors.removeSensor((VRMLKeyDeviceSensorNodeType)arrayList.get(n));
        }
        if (this.pickManager != null) {
            this.pickManager.unloadScene(basicScene);
        }
        arrayList = basicScene.getByPrimaryType(78);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            VRMLDeviceSensorNodeType vRMLDeviceSensorNodeType = (VRMLDeviceSensorNodeType)arrayList.get(n);
            this.inputManager.removeX3DNode(vRMLDeviceSensorNodeType);
        }
        arrayList = basicScene.getByPrimaryType(36);
        this.numPointingDeviceSensors -= arrayList.size();
        arrayList = basicScene.getByPrimaryType(13);
        this.numPointingDeviceSensors -= arrayList.size();
        arrayList = basicScene.getBySecondaryType(28);
        this.numPointingDeviceSensors -= arrayList.size();
        for (n = 0; n < this.numLayerManagers; ++n) {
            if (this.layerManagers[n].getLayerId() != basicScene.getLayerId()) continue;
            this.layerManagers[n].unloadScene(basicScene);
        }
    }

    public void clear() {
        this.timeSensors.clear();
        this.keySensors.clear();
        this.inputManager.clear();
        this.numPointingDeviceSensors = 0;
    }

    public VRMLClock getVRMLClock() {
        return this.timeSensors;
    }

    public boolean getNavigationEnabled() {
        return this.navigationEnabled;
    }

    public void setNavigationEnabled(boolean bl) {
        this.navigationEnabled = bl;
    }
}

