# R code to dump the output from 'mgcv' cubic splines in many situations, for
# checking compatibility.
#
# Usage:
#   Rscript tools/get-R-crs-test-vectors.R > patsy/test_splines_crs_data.py

cat("# This file auto-generated by tools/get-R-crs-test-vectors.R\n")
cat(sprintf("# Using: %s and package 'mgcv' version %s\n",
            R.Version()$version.string,
            packageVersion("mgcv")))
cat("import numpy as np\n")

options(digits=20)
library(mgcv)
x <- (-1.5)^(0:19)

pyprint <- function(arr) {
  if (is.null(arr)) {
    cat("None\n")
  } else {
    cat("np.array([")
    for (val in arr) {
      cat(val)
      cat(", ")
    }
    cat("])")
    if (!is.null(dim(arr))) {
      cat(".reshape((")
      for (size in dim(arr)) {
        cat(sprintf("%s, ", size))
      }
      cat("), order=\"F\")")
    }
    cat("\n")
  }
}

num.tests <- 0
dump.crs <- function(spline.type, nb.knots, knots, absorb.cons) {
  cat("--BEGIN TEST CASE--\n")
  cat(sprintf("spline_type=%s\n", spline.type))
  cat(sprintf("nb_knots=%s\n", nb.knots))
  cat("knots=")
  pyprint(knots)
  cat(sprintf("absorb_cons=%s\n", absorb.cons))

  args <- list(object=s(x, bs=spline.type, k=nb.knots),
               data=data.frame(x=x), knots=NULL, absorb.cons=absorb.cons)
  if (!is.null(knots)) {
    args$knots <- data.frame(x=knots)
  }

  result <- do.call(smoothCon, args)

  cat("output=")
  pyprint(result[[1]]$X)
  cat("--END TEST CASE--\n")
  assign("num.tests", num.tests + 1, envir=.GlobalEnv)
}

cat("R_crs_test_x = ")
pyprint(x)
cat("R_crs_test_data = \"\"\"\n")

for (spline.type in c("cr", "cs", "cc")) {
  for (absorb.cons in c(FALSE, TRUE)) {
    for (nb.knots in c(4, 7, 10, 12)) {
      dump.crs(spline.type, nb.knots, NULL, absorb.cons)
    }

    for (knots in list(c(-2500., -150., 300., 1500.),
                       c(-400., -50., 10., 50., 100.),
                       c(-1000., -500., -250., 0., 250., 500., 1000.))) {
      dump.crs(spline.type, length(knots), knots, absorb.cons)
    }
  }
}

cat("\"\"\"\n")
cat(sprintf("R_crs_num_tests = %s\n", num.tests))
