# -*- mode: makefile; coding: utf-8 -*-
# Copyright © 2005 Ivan Dubrov <wfragg@gmail.com>
# Description: Builds and cleans packages which use an Eclipse PDE Build
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA.


ifndef _cdbs_bootstrap
_cdbs_scripts_path ?= /usr/lib/cdbs
_cdbs_rules_path ?= /usr/share/cdbs/1/rules
_cdbs_class_path ?= /usr/share/cdbs/1/class
endif

ifndef _cdbs_class_eclipse_pde
_cdbs_class_eclipse_pde := 1

include $(_cdbs_rules_path)/buildcore.mk$(_cdbs_makefile_suffix)

# Host Eclipse SDK for building
PDEBUILD_HOST ?= /usr/lib/eclipse

# Directory where local Eclipse SDK instance is created.
# Note: must be absolute
PDEBUILD_HOSTLOCAL ?= $(CURDIR)/debian/eclipse-local

# Directory that contains additional plugins to be used during the build
PDEBUILD_BASELOCATION ?= $(PDEBUILD_HOSTLOCAL)

# PDE Build release engineering directory, with build.properties and
# customTargets.xml
PDEBUILD_BUILDER ?= $(CURDIR)/releng

# Determine the most recent PDE Build scripts plugin version
ifndef PDE_VERSION
PDEBUILD_VERSION := $(shell ls $(PDEBUILD_HOST)/plugins/ | \
	grep "^org\.eclipse\.pde\.build_[[:digit:]]*\.[[:digit:]]*\.[[:digit:]]*$$" | \
	sed "s%org\.eclipse\.pde\.build_\(.*\)%\1%" | \
	sort  -t. -k1,1 -k2,2 -k3,3 -n -r | head -n 1)
endif

# PDE Build Ant script
PDEBUILD_BUILDFILE ?= $(PDEBUILD_HOSTLOCAL)/plugins/org.eclipse.pde.build_$(PDEBUILD_VERSION)/scripts/build.xml

# Eclipse temporary configuration store
PDEBUILD_CONFIG ?= debian/tmp/configure

# Eclipse temporary workspace
PDEBUILD_DATA ?= debian/tmp/workspace

# Directory where plugins are built. Should contain two subdirectories,
# plugins and features. Each of these contains plugins and features that
# are built.
PDEBUILD_BUILDDIR ?= $(CURDIR)

# Link names to enable when creating local Eclipse SDK instance. Each name is
# name of the file in the $(PDEBUILD_HOST)/links/ directory without the .link
# extension
PDEBUILD_LINKS ?=

# 
PDEBUILD_OPTS ?=

#
PDEBUILD_VMARGS ?=

# Check JAVA_HOME and Eclipe SDK

DEB_PHONY_RULES += eclipse-sanity-check
eclipse-sanity-check:
	@if ! test -r "$(JAVA_HOME)"; then \
		echo "You must specify a valid JAVA_HOME or JAVACMD!"; \
		exit 1; \
	fi
	@if ! test -r "$(PDEBUILD_HOST)/plugins/org.eclipse.pde.build_$(PDEBUILD_VERSION)"; then \
		echo "You must specify a valid Eclipse SDK directory!"; \
		exit 1; \
	fi

# Configure local Eclipse SDK instance

pre-build:: debian/stamp-pde-local

debian/stamp-pde-local:
	mkdir -p $(PDEBUILD_HOSTLOCAL)
	ln -s $(PDEBUILD_HOST)/configuration $(PDEBUILD_HOSTLOCAL)
	ln -s $(PDEBUILD_HOST)/eclipse.ini $(PDEBUILD_HOSTLOCAL)
	ln -s $(PDEBUILD_HOST)/features $(PDEBUILD_HOSTLOCAL)
	ln -s $(PDEBUILD_HOST)/plugins $(PDEBUILD_HOSTLOCAL)
	ln -s $(PDEBUILD_HOST)/startup.jar $(PDEBUILD_HOSTLOCAL)
	ln -s $(PDEBUILD_HOST)/eclipse $(PDEBUILD_HOSTLOCAL)
	
	mkdir $(PDEBUILD_HOSTLOCAL)/links
	for i in $(PDEBUILD_LINKS) ; do \
		ln -s $(PDEBUILD_HOST)/links/$$i.link $(PDEBUILD_HOSTLOCAL)/links ; \
	done ;
	touch $@

# Invoke PDE Build

common-build-arch common-build-indep:: debian/stamp-pde-build eclipse-sanity-check
debian/stamp-pde-build:
	${JAVA_HOME}/bin/java $(PDEBUILD_VMARGS) \
		-jar $(PDEBUILD_HOSTLOCAL)/startup.jar \
		-launcher $(PDEBUILD_HOSTLOCAL)/eclipse \
		-install $(PDEBUILD_HOSTLOCAL) \
		-consoleLog \
		-data $(PDEBUILD_DATA) \
		-configuration $(PDEBUILD_CONFIG) \
		-application org.eclipse.ant.core.antRunner \
		-buildfile $(PDEBUILD_BUILDFILE) \
		-Dbuilder=$(PDEBUILD_BUILDER) \
		-DbuildDirectory=$(PDEBUILD_BUILDDIR) \
		-DbaseLocation=$(PDEBUILD_BASELOCATION)
	touch $@

clean::
	rm -f debian/stamp-pde-build
	rm -rf $(PDEBUILD_HOSTLOCAL)
	-rm debian/stamp-pde-local

endif

