/*
 * Copyright (C) 2010-2011 Mathias Doenitz
 *
 * Based on peg-markdown (C) 2008-2010 John MacFarlane
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.pegdown.ast;

import org.parboiled.trees.GraphNode;

public interface Node extends GraphNode<Node> {

    /**
     * @return the index of the first character in the underlying buffer that is covered by this node 
     */
    int getStartIndex();

    /**
     * @return the index of the character after the last one in the underlying buffer that is covered by this node
     */
    int getEndIndex();
    
    void accept(Visitor visitor);
}
