/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL ES-CM 1.1 plugin
 *
 * Copyright © 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <pgm/pgm.h>
#include "pgmglesviewport.h"
#include "pgmglesimage.h"
#include "pgmglestext.h"

#ifndef HAVE_OPENGLES_PC_EMULATION
#include "pgmgleseglbackend.h"
#else
#include "pgmglesxbackend.h"
#endif /* HAVE_OPENGLES_PC_EMULATION */

GST_DEBUG_CATEGORY (pgm_gles_debug);
#define GST_CAT_DEFAULT pgm_gles_debug

/* Private functions */

static gboolean
pgm_gles_init (GTypeModule *module)
{
  GST_DEBUG_CATEGORY_INIT (pgm_gles_debug, "pgm_gles", 0,
                           "OpenGL ES-CM 1.1 plugin");

  pgm_gles_drawable_register (module);
  pgm_gles_image_register (module);
  pgm_gles_text_register (module);
  pgm_gles_viewport_register (module);
  pgm_gles_backend_register (module);

#ifndef HAVE_OPENGLES_PC_EMULATION
  pgm_gles_egl_backend_register (module);
#else
  pgm_gles_x_backend_register (module);
#endif /* HAVE_OPENGLES_PC_EMULATION */

  return TRUE;
}

/* Pigment plugin entry point */

PGM_PLUGIN_DEFINE
(
  (PgmPluginInitFunc) pgm_gles_init, NULL,
  (PgmPluginCreateFunc) pgm_gles_viewport_new,
  "opengles", VERSION,
  "An OpenGL ES-CM 1.1 viewport", "LGPL",
  "https://code.fluendo.com/pigment/trac",
  "Loïc Molinari <loic@fluendo.com>"
)
