/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment unit test for pgmimage.c
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <tests/check/common/pgmcheck.h>
#include <pgm/pgm.h>
#include "pgmplugintestsuite.h"
#include <gdk-pixbuf/gdk-pixbuf.h>

#define TEST_IMAGE_FILE "./test-image.png"

static gboolean pixbuf_loaded = FALSE;

static void
on_pixbuf_loaded (PgmImage *image, gpointer data)
{
  pixbuf_loaded = TRUE;
}

static void
generate_image_file (const gchar *name)
{
  GdkPixbuf *pixbuf = NULL;
  guchar *data = g_malloc (1024 * 1024 * 3);
  guint i = 0, rowstride = 1024*3;

  for (i=0; i<1024*1024*3; i+=3)
    {
      data[i] = (i / 256) % 0xff;
      data[i+1] = i % 0xff;
      data[i+2] = (3 * i + 23) % 0xff;
    }

  pixbuf = gdk_pixbuf_new_from_data (data, GDK_COLORSPACE_RGB, FALSE,
                                     8, 1024, 1024, rowstride, NULL, NULL);
  gdk_pixbuf_save (pixbuf, name, "png", NULL, NULL);

  g_object_unref (pixbuf);
  g_free (data);
}

static void
remove_image_file (const gchar *name)
{
  g_unlink (name);
}

static gpointer
thread_init (gpointer data)
{
  pgm_main ();
}

/* This checks that #162 is fixeed */
PGM_START_TEST (test_image_cloning_delete_master)
{
  PgmViewport *viewport = NULL;
  PgmCanvas *canvas = NULL;
  PgmError ret = PGM_ERROR_OK;
  PgmDrawable *master = NULL, *slave = NULL;
  GThread *pgm_thread  = NULL;

  ASSERT_PGM_SUCCESS (pgm_viewport_factory_make (PGM_TEST_PLUGIN, &viewport));
  ASSERT_PGM_SUCCESS (pgm_viewport_hide (viewport));

  canvas = pgm_canvas_new ();
  fail_unless (NULL != canvas, "canvas creation");
  ASSERT_PGM_SUCCESS (pgm_viewport_set_canvas (viewport, canvas));

  pgm_thread = g_thread_create ( thread_init, NULL, TRUE, NULL);
  fail_unless (NULL != pgm_thread, "thread creation");

  master = pgm_image_new ();
  slave = pgm_image_new ();
  fail_unless (master && slave, "images creation");
  pgm_canvas_add_many (canvas, PGM_DRAWABLE_MIDDLE, master, slave, NULL);

  ASSERT_PGM_SUCCESS (pgm_image_set_from_image ( PGM_IMAGE (slave),
                                                 PGM_IMAGE (master)));
  generate_image_file (TEST_IMAGE_FILE);
  ASSERT_PGM_SUCCESS (pgm_image_set_from_file ( PGM_IMAGE (master),
                                                TEST_IMAGE_FILE, 0));
  ASSERT_PGM_SUCCESS (pgm_canvas_remove (canvas, master));
  fail_if (pixbuf_loaded, "removed master from canvas too late");

  remove_image_file (TEST_IMAGE_FILE);
  pgm_main_quit ();
  g_thread_join (pgm_thread);

  gst_object_unref (viewport);
}
PGM_END_TEST

Suite *
pgm_image_suite (void)
{
  Suite *s = suite_create ("PgmImage");
  TCase *tc_chain = tcase_create ("pgmimage tests");

  PGM_USE_STANDARD_FIXTURES (tc_chain);

  suite_add_tcase (s, tc_chain);
  tcase_add_test (tc_chain, test_image_cloning_delete_master);

  return s;
}

