/********************************************************************************
 *   Copyright (C) 2008-2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#ifndef TYPES_H
#define TYPES_H

struct Author
{
  QString nsid;
  QString username;
  KUrl profileUrl;
  KUrl photosUrl;
};

struct Photo
{
  QString id;
  QString title;
  bool authorRetrieved;
  bool photoRetrieved;
  Author author;
  QString filename;
  KUrl url;
};

enum PhotoListType
{
  INTERESTINGNESS = 0,
  FAVORITES,
  PHOTOSET,
  TAG,
  LOCATION
};

enum ErrorType
{
  ERR_ANY = 0,
  ERR_MESSAGEBOX,
  ERR_APPLET
};

// so that we can pass it with Plasma::DataEngine::setData()
Q_DECLARE_METATYPE( Photo );

typedef QList<Photo> PhotoList;
typedef QMap<QString,QString> Params;

#endif // TYPES_H
