/***********************************************************************************
* Run Command: Simple plasmoid to run commands with support for runners.
* Copyright (C) 2008 - 2012 Michal Dutkiewicz aka Emdek <emdeck@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef RUNCOMMANDAPPLET_HEADER
#define RUNCOMMANDAPPLET_HEADER

#include <QtGui/QGraphicsProxyWidget>
#include <QtGui/QGraphicsSceneMouseEvent>

#include <KGlobalSettings>
#include <KHistoryComboBox>

#include <Plasma/Applet>
#include <Plasma/Dialog>
#include <Plasma/ComboBox>
#include <Plasma/QueryMatch>
#include <Plasma/RunnerManager>

#include "ui_results.h"

class RunCommandApplet : public Plasma::Applet
{
    Q_OBJECT

    public:
        RunCommandApplet(QObject *parent, const QVariantList &args);

        void init();
        bool eventFilter(QObject *object, QEvent *event);

    public slots:
        void configChanged();

    protected:
        void mousePressEvent(QGraphicsSceneMouseEvent *event);
        void mouseMoveEvent(QGraphicsSceneMouseEvent *event);

    protected slots:
        void constraintsEvent(Plasma::Constraints constraints = Plasma::ImmutableConstraint);
        void focusWidget();
        void clearWidth();
        void clearHistory();
        void resetColor();
        void queryChanged(const QString &query);
        void resultsChanged(const QList<Plasma::QueryMatch> &matches);
        void dialogResized();
        void moveListUp();
        void moveListDown();
        void getCommand();
        void runCommand(QString command);
        void runMatch(const Plasma::QueryMatch &match);
        void updateButtons();
        void updateTheme();
        void extendContextMenu(QMenu *menu);
        void completionModeChanged(KGlobalSettings::Completion mode);
        void setRunnersEnabled(bool enable);

    private:
        Plasma::Dialog *m_dialog;
        Plasma::RunnerManager *m_runnerManager;
        KHistoryComboBox *m_comboBox;
        int m_initialWidth;
        Ui::results m_resultsUi;
};

#endif
