
# NXP LPC: development platform for [PlatformIO](https://platformio.org)

The NXP LPC is a family of 32-bit microcontroller integrated circuits by NXP Semiconductors. The LPC chips are grouped into related series that are based around the same 32-bit ARM processor core, such as the Cortex-M4F, Cortex-M3, Cortex-M0+, or Cortex-M0. Internally, each microcontroller consists of the processor core, static RAM memory, flash memory, debugging interface, and various peripherals.

* [Home](https://platformio.org/platforms/nxplpc) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/platforms/nxplpc.html) (advanced usage, packages, boards, frameworks, etc.)

# Examples

* [mbed-blink](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-blink)
* [mbed-custom-target](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-custom-target)
* [mbed-dsp](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-dsp)
* [mbed-events](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-events)
* [mbed-rtos](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-rtos)
* [mbed-rtos-ethernet](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-rtos-ethernet)
* [mbed-serial](https://github.com/platformio/platform-nxplpc/tree/master/examples/mbed-serial)
* [zephyr-blink](https://github.com/platformio/platform-nxplpc/tree/master/examples/zephyr-blink)
* [zephyr-drivers-watchdog](https://github.com/platformio/platform-nxplpc/tree/master/examples/zephyr-drivers-watchdog)
* [zephyr-synchronization](https://github.com/platformio/platform-nxplpc/tree/master/examples/zephyr-synchronization)
