/*
 * Copyright (c) 2015     Cisco Systems, Inc.  All rights reserved.
 * Copyright (c) 2016-2020 Intel, Inc.  All rights reserved.
 * Copyright (c) 2022      Nanook Consulting.  All rights reserved.
 * $COPYRIGHT$
 *
 * Additional copyrights may follow
 *
 * $HEADER$
 */

#ifndef PMIX_PDL_PDLOPEN
#define PMIX_PDL_PDLOPEN

#include "src/include/pmix_config.h"

#include "src/mca/pdl/pdl.h"

extern pmix_pdl_base_module_t pmix_pdl_pdlopen_module;

/*
 * Dynamic library handles generated by this component.
 *
 * If we're debugging, keep a copy of the name of the file we've opened.
 */
struct pmix_pdl_handle_t {
    void *dlopen_handle;
#if PMIX_ENABLE_DEBUG
    void *filename;
#endif
};

typedef struct {
    pmix_pdl_base_component_t base;

    char *filename_suffixes_mca_storage;
    char **filename_suffixes;
} pmix_pdl_pdlopen_component_t;

extern pmix_pdl_pdlopen_component_t pmix_mca_pdl_pdlopen_component;

#endif /* PMIX_PDL_PDLOPEN */
