/*
 * Copyright (c) 2014 Advanced Micro Devices, Inc.
 *
 * Copyright (c) 2017 Michal Babej / Tampere University of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include "misc.h"
#include "vtables.h"
#include "vtables_macros.h"

DECLARE_VTABLE(float2, LOGE_TBL, 129) = {
    (float2)(0x0.000000p+0f, 0x0.000000p+0f),
    (float2)(0x1.fe0000p-8f, 0x1.535882p-23f),
    (float2)(0x1.fc0000p-7f, 0x1.5161f8p-20f),
    (float2)(0x1.7b8000p-6f, 0x1.1b07d4p-18f),
    (float2)(0x1.f82000p-6f, 0x1.361cf0p-19f),
    (float2)(0x1.39e000p-5f, 0x1.0f73fcp-18f),
    (float2)(0x1.774000p-5f, 0x1.63d8cap-19f),
    (float2)(0x1.b42000p-5f, 0x1.bae232p-18f),
    (float2)(0x1.f0a000p-5f, 0x1.86008ap-20f),
    (float2)(0x1.164000p-4f, 0x1.36eea2p-16f),
    (float2)(0x1.340000p-4f, 0x1.d7961ap-16f),
    (float2)(0x1.51a000p-4f, 0x1.073f06p-16f),
    (float2)(0x1.6f0000p-4f, 0x1.a515cap-17f),
    (float2)(0x1.8c2000p-4f, 0x1.45d630p-16f),
    (float2)(0x1.a92000p-4f, 0x1.b4e92ap-18f),
    (float2)(0x1.c5e000p-4f, 0x1.523d6ep-18f),
    (float2)(0x1.e26000p-4f, 0x1.076e2ap-16f),
    (float2)(0x1.fec000p-4f, 0x1.2263b6p-17f),
    (float2)(0x1.0d6000p-3f, 0x1.7e7cd0p-15f),
    (float2)(0x1.1b6000p-3f, 0x1.2ad52ep-15f),
    (float2)(0x1.294000p-3f, 0x1.52f81ep-15f),
    (float2)(0x1.370000p-3f, 0x1.fc201ep-15f),
    (float2)(0x1.44c000p-3f, 0x1.2b6ccap-15f),
    (float2)(0x1.526000p-3f, 0x1.cbc742p-16f),
    (float2)(0x1.5fe000p-3f, 0x1.3070a6p-15f),
    (float2)(0x1.6d6000p-3f, 0x1.fce33ap-20f),
    (float2)(0x1.7aa000p-3f, 0x1.890210p-15f),
    (float2)(0x1.87e000p-3f, 0x1.a06520p-15f),
    (float2)(0x1.952000p-3f, 0x1.6a73d0p-17f),
    (float2)(0x1.a22000p-3f, 0x1.bc1fe2p-15f),
    (float2)(0x1.af2000p-3f, 0x1.c94e80p-15f),
    (float2)(0x1.bc2000p-3f, 0x1.0ce85ap-16f),
    (float2)(0x1.c8e000p-3f, 0x1.f7c79ap-15f),
    (float2)(0x1.d5c000p-3f, 0x1.0b5a7cp-18f),
    (float2)(0x1.e26000p-3f, 0x1.076e2ap-15f),
    (float2)(0x1.ef0000p-3f, 0x1.5b97b8p-16f),
    (float2)(0x1.fb8000p-3f, 0x1.186d5ep-15f),
    (float2)(0x1.040000p-2f, 0x1.2ca5a6p-17f),
    (float2)(0x1.0a2000p-2f, 0x1.24e272p-14f),
    (float2)(0x1.104000p-2f, 0x1.8bf9aep-14f),
    (float2)(0x1.166000p-2f, 0x1.5cabaap-14f),
    (float2)(0x1.1c8000p-2f, 0x1.3182d2p-15f),
    (float2)(0x1.228000p-2f, 0x1.41fbcep-14f),
    (float2)(0x1.288000p-2f, 0x1.5a13dep-14f),
    (float2)(0x1.2e8000p-2f, 0x1.c575c2p-15f),
    (float2)(0x1.346000p-2f, 0x1.dd9a98p-14f),
    (float2)(0x1.3a6000p-2f, 0x1.3155a4p-16f),
    (float2)(0x1.404000p-2f, 0x1.843434p-17f),
    (float2)(0x1.460000p-2f, 0x1.8bc21cp-14f),
    (float2)(0x1.4be000p-2f, 0x1.7e55dcp-16f),
    (float2)(0x1.51a000p-2f, 0x1.5b0e5ap-15f),
    (float2)(0x1.576000p-2f, 0x1.dc5d14p-16f),
    (float2)(0x1.5d0000p-2f, 0x1.bdbf58p-14f),
    (float2)(0x1.62c000p-2f, 0x1.05e572p-15f),
    (float2)(0x1.686000p-2f, 0x1.903d36p-15f),
    (float2)(0x1.6e0000p-2f, 0x1.1d5456p-15f),
    (float2)(0x1.738000p-2f, 0x1.d7f6bap-14f),
    (float2)(0x1.792000p-2f, 0x1.4abfbap-15f),
    (float2)(0x1.7ea000p-2f, 0x1.f07704p-15f),
    (float2)(0x1.842000p-2f, 0x1.a3b43cp-15f),
    (float2)(0x1.89a000p-2f, 0x1.9c360ap-17f),
    (float2)(0x1.8f0000p-2f, 0x1.1e8736p-14f),
    (float2)(0x1.946000p-2f, 0x1.941c20p-14f),
    (float2)(0x1.99c000p-2f, 0x1.958116p-14f),
    (float2)(0x1.9f2000p-2f, 0x1.23ecbep-14f),
    (float2)(0x1.a48000p-2f, 0x1.024396p-16f),
    (float2)(0x1.a9c000p-2f, 0x1.d93534p-15f),
    (float2)(0x1.af0000p-2f, 0x1.293246p-14f),
    (float2)(0x1.b44000p-2f, 0x1.eef798p-15f),
    (float2)(0x1.b98000p-2f, 0x1.625a4cp-16f),
    (float2)(0x1.bea000p-2f, 0x1.4d9da6p-14f),
    (float2)(0x1.c3c000p-2f, 0x1.d7a7ccp-14f),
    (float2)(0x1.c8e000p-2f, 0x1.f7c79ap-14f),
    (float2)(0x1.ce0000p-2f, 0x1.af0b84p-14f),
    (float2)(0x1.d32000p-2f, 0x1.fcfc00p-15f),
    (float2)(0x1.d82000p-2f, 0x1.e7258ap-14f),
    (float2)(0x1.dd4000p-2f, 0x1.a81306p-16f),
    (float2)(0x1.e24000p-2f, 0x1.1034f8p-15f),
    (float2)(0x1.e74000p-2f, 0x1.09875ap-16f),
    (float2)(0x1.ec2000p-2f, 0x1.99d246p-14f),
    (float2)(0x1.f12000p-2f, 0x1.1ebf5ep-15f),
    (float2)(0x1.f60000p-2f, 0x1.23fa70p-14f),
    (float2)(0x1.fae000p-2f, 0x1.588f78p-14f),
    (float2)(0x1.ffc000p-2f, 0x1.2e0856p-14f),
    (float2)(0x1.024000p-1f, 0x1.52a5a4p-13f),
    (float2)(0x1.04a000p-1f, 0x1.df9da8p-13f),
    (float2)(0x1.072000p-1f, 0x1.f2e0e6p-16f),
    (float2)(0x1.098000p-1f, 0x1.bd3d5cp-15f),
    (float2)(0x1.0be000p-1f, 0x1.cb9094p-15f),
    (float2)(0x1.0e4000p-1f, 0x1.261746p-15f),
    (float2)(0x1.108000p-1f, 0x1.f39e2cp-13f),
    (float2)(0x1.12e000p-1f, 0x1.719592p-13f),
    (float2)(0x1.154000p-1f, 0x1.87a5e8p-14f),
    (float2)(0x1.178000p-1f, 0x1.eabbd8p-13f),
    (float2)(0x1.19e000p-1f, 0x1.cd68cep-14f),
    (float2)(0x1.1c2000p-1f, 0x1.b81f70p-13f),
    (float2)(0x1.1e8000p-1f, 0x1.7d79c0p-15f),
    (float2)(0x1.20c000p-1f, 0x1.b9a324p-14f),
    (float2)(0x1.230000p-1f, 0x1.30d7bep-13f),
    (float2)(0x1.254000p-1f, 0x1.5bce98p-13f),
    (float2)(0x1.278000p-1f, 0x1.5e1288p-13f),
    (float2)(0x1.29c000p-1f, 0x1.37fec2p-13f),
    (float2)(0x1.2c0000p-1f, 0x1.d3da88p-14f),
    (float2)(0x1.2e4000p-1f, 0x1.d0db90p-15f),
    (float2)(0x1.306000p-1f, 0x1.d7334ep-13f),
    (float2)(0x1.32a000p-1f, 0x1.133912p-13f),
    (float2)(0x1.34e000p-1f, 0x1.44ece6p-16f),
    (float2)(0x1.370000p-1f, 0x1.17b546p-13f),
    (float2)(0x1.392000p-1f, 0x1.e0d356p-13f),
    (float2)(0x1.3b6000p-1f, 0x1.0893fep-14f),
    (float2)(0x1.3d8000p-1f, 0x1.026a70p-13f),
    (float2)(0x1.3fa000p-1f, 0x1.5b84d0p-13f),
    (float2)(0x1.41c000p-1f, 0x1.8fe846p-13f),
    (float2)(0x1.43e000p-1f, 0x1.9fe2f8p-13f),
    (float2)(0x1.460000p-1f, 0x1.8bc21cp-13f),
    (float2)(0x1.482000p-1f, 0x1.53d1eap-13f),
    (float2)(0x1.4a4000p-1f, 0x1.f0bb60p-14f),
    (float2)(0x1.4c6000p-1f, 0x1.e6bf32p-15f),
    (float2)(0x1.4e6000p-1f, 0x1.d811b6p-13f),
    (float2)(0x1.508000p-1f, 0x1.13cc00p-13f),
    (float2)(0x1.52a000p-1f, 0x1.6932dep-16f),
    (float2)(0x1.54a000p-1f, 0x1.246798p-13f),
    (float2)(0x1.56a000p-1f, 0x1.f9d5b2p-13f),
    (float2)(0x1.58c000p-1f, 0x1.5b6b9ap-14f),
    (float2)(0x1.5ac000p-1f, 0x1.404c34p-13f),
    (float2)(0x1.5cc000p-1f, 0x1.b1dc6cp-13f),
    (float2)(0x1.5ee000p-1f, 0x1.54920ap-20f),
    (float2)(0x1.60e000p-1f, 0x1.97a23cp-16f),
    (float2)(0x1.62e000p-1f, 0x1.0bfbe8p-15f),
};

DECLARE_VTABLE(float, LOG_INV_TBL, 129) = {
    0x1.000000p+1f,
    0x1.fc07f0p+0f,
    0x1.f81f82p+0f,
    0x1.f4465ap+0f,
    0x1.f07c20p+0f,
    0x1.ecc07cp+0f,
    0x1.e9131ap+0f,
    0x1.e573acp+0f,
    0x1.e1e1e2p+0f,
    0x1.de5d6ep+0f,
    0x1.dae608p+0f,
    0x1.d77b66p+0f,
    0x1.d41d42p+0f,
    0x1.d0cb58p+0f,
    0x1.cd8568p+0f,
    0x1.ca4b30p+0f,
    0x1.c71c72p+0f,
    0x1.c3f8f0p+0f,
    0x1.c0e070p+0f,
    0x1.bdd2b8p+0f,
    0x1.bacf92p+0f,
    0x1.b7d6c4p+0f,
    0x1.b4e81cp+0f,
    0x1.b20364p+0f,
    0x1.af286cp+0f,
    0x1.ac5702p+0f,
    0x1.a98ef6p+0f,
    0x1.a6d01ap+0f,
    0x1.a41a42p+0f,
    0x1.a16d40p+0f,
    0x1.9ec8eap+0f,
    0x1.9c2d14p+0f,
    0x1.99999ap+0f,
    0x1.970e50p+0f,
    0x1.948b10p+0f,
    0x1.920fb4p+0f,
    0x1.8f9c18p+0f,
    0x1.8d3018p+0f,
    0x1.8acb90p+0f,
    0x1.886e60p+0f,
    0x1.861862p+0f,
    0x1.83c978p+0f,
    0x1.818182p+0f,
    0x1.7f4060p+0f,
    0x1.7d05f4p+0f,
    0x1.7ad220p+0f,
    0x1.78a4c8p+0f,
    0x1.767dcep+0f,
    0x1.745d18p+0f,
    0x1.724288p+0f,
    0x1.702e06p+0f,
    0x1.6e1f76p+0f,
    0x1.6c16c2p+0f,
    0x1.6a13cep+0f,
    0x1.681682p+0f,
    0x1.661ec6p+0f,
    0x1.642c86p+0f,
    0x1.623fa8p+0f,
    0x1.605816p+0f,
    0x1.5e75bcp+0f,
    0x1.5c9882p+0f,
    0x1.5ac056p+0f,
    0x1.58ed24p+0f,
    0x1.571ed4p+0f,
    0x1.555556p+0f,
    0x1.539094p+0f,
    0x1.51d07ep+0f,
    0x1.501502p+0f,
    0x1.4e5e0ap+0f,
    0x1.4cab88p+0f,
    0x1.4afd6ap+0f,
    0x1.49539ep+0f,
    0x1.47ae14p+0f,
    0x1.460cbcp+0f,
    0x1.446f86p+0f,
    0x1.42d662p+0f,
    0x1.414142p+0f,
    0x1.3fb014p+0f,
    0x1.3e22ccp+0f,
    0x1.3c995ap+0f,
    0x1.3b13b2p+0f,
    0x1.3991c2p+0f,
    0x1.381382p+0f,
    0x1.3698e0p+0f,
    0x1.3521d0p+0f,
    0x1.33ae46p+0f,
    0x1.323e34p+0f,
    0x1.30d190p+0f,
    0x1.2f684cp+0f,
    0x1.2e025cp+0f,
    0x1.2c9fb4p+0f,
    0x1.2b404ap+0f,
    0x1.29e412p+0f,
    0x1.288b02p+0f,
    0x1.27350cp+0f,
    0x1.25e228p+0f,
    0x1.24924ap+0f,
    0x1.234568p+0f,
    0x1.21fb78p+0f,
    0x1.20b470p+0f,
    0x1.1f7048p+0f,
    0x1.1e2ef4p+0f,
    0x1.1cf06ap+0f,
    0x1.1bb4a4p+0f,
    0x1.1a7b96p+0f,
    0x1.194538p+0f,
    0x1.181182p+0f,
    0x1.16e068p+0f,
    0x1.15b1e6p+0f,
    0x1.1485f0p+0f,
    0x1.135c82p+0f,
    0x1.12358ep+0f,
    0x1.111112p+0f,
    0x1.0fef02p+0f,
    0x1.0ecf56p+0f,
    0x1.0db20ap+0f,
    0x1.0c9714p+0f,
    0x1.0b7e6ep+0f,
    0x1.0a6810p+0f,
    0x1.0953f4p+0f,
    0x1.084210p+0f,
    0x1.073260p+0f,
    0x1.0624dep+0f,
    0x1.051980p+0f,
    0x1.041042p+0f,
    0x1.03091cp+0f,
    0x1.020408p+0f,
    0x1.010102p+0f,
    0x1.000000p+0f,
};

DECLARE_VTABLE(float2, LOG2_TBL, 129) = {
    (float2)(0x0.000000p+0f, 0x0.000000p+0f),
    (float2)(0x1.6f8000p-7f, 0x1.942dbap-17f),
    (float2)(0x1.6e0000p-6f, 0x1.e5a170p-16f),
    (float2)(0x1.118000p-5f, 0x1.347544p-15f),
    (float2)(0x1.6b8000p-5f, 0x1.69bac6p-16f),
    (float2)(0x1.c48000p-5f, 0x1.7eae42p-15f),
    (float2)(0x1.0e8000p-4f, 0x1.9c4fd0p-15f),
    (float2)(0x1.3a8000p-4f, 0x1.17ee92p-15f),
    (float2)(0x1.660000p-4f, 0x1.fb7d64p-15f),
    (float2)(0x1.918000p-4f, 0x1.42dc8cp-17f),
    (float2)(0x1.bc8000p-4f, 0x1.0902b6p-18f),
    (float2)(0x1.e70000p-4f, 0x1.7608bep-15f),
    (float2)(0x1.088000p-3f, 0x1.162336p-13f),
    (float2)(0x1.1d8000p-3f, 0x1.3465d4p-13f),
    (float2)(0x1.328000p-3f, 0x1.74f13cp-14f),
    (float2)(0x1.470000p-3f, 0x1.aa7e60p-13f),
    (float2)(0x1.5c0000p-3f, 0x1.a39fbcp-19f),
    (float2)(0x1.700000p-3f, 0x1.d0b53ap-13f),
    (float2)(0x1.848000p-3f, 0x1.0af40ap-13f),
    (float2)(0x1.988000p-3f, 0x1.b741dep-13f),
    (float2)(0x1.ac8000p-3f, 0x1.d78b6cp-13f),
    (float2)(0x1.c08000p-3f, 0x1.6db376p-13f),
    (float2)(0x1.d48000p-3f, 0x1.ee4c32p-15f),
    (float2)(0x1.e80000p-3f, 0x1.02f9d2p-13f),
    (float2)(0x1.fb8000p-3f, 0x1.05ae40p-13f),
    (float2)(0x1.078000p-2f, 0x1.0adbb0p-14f),
    (float2)(0x1.110000p-2f, 0x1.83ed68p-13f),
    (float2)(0x1.1a8000p-2f, 0x1.016ca4p-12f),
    (float2)(0x1.240000p-2f, 0x1.01eac2p-12f),
    (float2)(0x1.2d8000p-2f, 0x1.887e26p-13f),
    (float2)(0x1.370000p-2f, 0x1.24cea4p-14f),
    (float2)(0x1.400000p-2f, 0x1.918ec6p-12f),
    (float2)(0x1.498000p-2f, 0x1.3c25e6p-13f),
    (float2)(0x1.528000p-2f, 0x1.6f7f12p-12f),
    (float2)(0x1.5c0000p-2f, 0x1.a39fbcp-18f),
    (float2)(0x1.650000p-2f, 0x1.8fe466p-14f),
    (float2)(0x1.6e0000p-2f, 0x1.10e6cep-13f),
    (float2)(0x1.770000p-2f, 0x1.d2ba7ep-14f),
    (float2)(0x1.800000p-2f, 0x1.4ac62cp-15f),
    (float2)(0x1.888000p-2f, 0x1.a71cb8p-12f),
    (float2)(0x1.918000p-2f, 0x1.dd448ep-13f),
    (float2)(0x1.9a8000p-2f, 0x1.1c8f10p-21f),
    (float2)(0x1.a30000p-2f, 0x1.bb053ep-13f),
    (float2)(0x1.ab8000p-2f, 0x1.861e5ep-12f),
    (float2)(0x1.b40000p-2f, 0x1.fafdcep-12f),
    (float2)(0x1.bd0000p-2f, 0x1.e5d3cep-15f),
    (float2)(0x1.c58000p-2f, 0x1.2fad28p-14f),
    (float2)(0x1.ce0000p-2f, 0x1.492474p-15f),
    (float2)(0x1.d60000p-2f, 0x1.d4f80cp-12f),
    (float2)(0x1.de8000p-2f, 0x1.4ff510p-12f),
    (float2)(0x1.e70000p-2f, 0x1.3550f2p-13f),
    (float2)(0x1.ef0000p-2f, 0x1.b59ccap-12f),
    (float2)(0x1.f78000p-2f, 0x1.42b464p-13f),
    (float2)(0x1.ff8000p-2f, 0x1.5e66a0p-12f),
    (float2)(0x1.038000p-1f, 0x1.f6a2e4p-11f),
    (float2)(0x1.080000p-1f, 0x1.39e4fep-14f),
    (float2)(0x1.0c0000p-1f, 0x1.0500d6p-13f),
    (float2)(0x1.100000p-1f, 0x1.13b152p-13f),
    (float2)(0x1.140000p-1f, 0x1.93f542p-14f),
    (float2)(0x1.180000p-1f, 0x1.467b94p-16f),
    (float2)(0x1.1b8000p-1f, 0x1.cc47a4p-11f),
    (float2)(0x1.1f8000p-1f, 0x1.78f4c2p-11f),
    (float2)(0x1.238000p-1f, 0x1.107508p-11f),
    (float2)(0x1.278000p-1f, 0x1.2602c2p-12f),
    (float2)(0x1.2b8000p-1f, 0x1.a39fbcp-20f),
    (float2)(0x1.2f0000p-1f, 0x1.5a1d7ap-11f),
    (float2)(0x1.330000p-1f, 0x1.3e355ap-12f),
    (float2)(0x1.368000p-1f, 0x1.cffedap-11f),
    (float2)(0x1.3a8000p-1f, 0x1.d9fd50p-12f),
    (float2)(0x1.3e0000p-1f, 0x1.f64de6p-11f),
    (float2)(0x1.420000p-1f, 0x1.d83f4cp-12f),
    (float2)(0x1.458000p-1f, 0x1.cea628p-11f),
    (float2)(0x1.498000p-1f, 0x1.3c25e6p-12f),
    (float2)(0x1.4d0000p-1f, 0x1.5a96ccp-11f),
    (float2)(0x1.510000p-1f, 0x1.18708ap-17f),
    (float2)(0x1.548000p-1f, 0x1.374652p-12f),
    (float2)(0x1.580000p-1f, 0x1.2089a6p-11f),
    (float2)(0x1.5b8000p-1f, 0x1.93432cp-11f),
    (float2)(0x1.5f0000p-1f, 0x1.f3fd06p-11f),
    (float2)(0x1.630000p-1f, 0x1.0b8f54p-13f),
    (float2)(0x1.668000p-1f, 0x1.004722p-12f),
    (float2)(0x1.6a0000p-1f, 0x1.57cf2cp-12f),
    (float2)(0x1.6d8000p-1f, 0x1.8cb53ap-12f),
    (float2)(0x1.710000p-1f, 0x1.9f4d8ap-12f),
    (float2)(0x1.748000p-1f, 0x1.8feb26p-12f),
    (float2)(0x1.780000p-1f, 0x1.5edfeep-12f),
    (float2)(0x1.7b8000p-1f, 0x1.0c7c9ap-12f),
    (float2)(0x1.7f0000p-1f, 0x1.322182p-13f),
    (float2)(0x1.828000p-1f, 0x1.3ab7cep-18f),
    (float2)(0x1.858000p-1f, 0x1.a82c2cp-11f),
    (float2)(0x1.890000p-1f, 0x1.3dd2c0p-11f),
    (float2)(0x1.8c8000p-1f, 0x1.871da4p-12f),
    (float2)(0x1.900000p-1f, 0x1.cc2c00p-14f),
    (float2)(0x1.930000p-1f, 0x1.9fdb68p-11f),
    (float2)(0x1.968000p-1f, 0x1.ed6956p-12f),
    (float2)(0x1.9a0000p-1f, 0x1.f1a760p-14f),
    (float2)(0x1.9d0000p-1f, 0x1.767f54p-11f),
    (float2)(0x1.a08000p-1f, 0x1.3f6d26p-12f),
    (float2)(0x1.a38000p-1f, 0x1.b9fce2p-11f),
    (float2)(0x1.a70000p-1f, 0x1.8ae816p-12f),
    (float2)(0x1.aa0000p-1f, 0x1.c23d60p-11f),
    (float2)(0x1.ad8000p-1f, 0x1.60f388p-12f),
    (float2)(0x1.b08000p-1f, 0x1.9049aep-11f),
    (float2)(0x1.b40000p-1f, 0x1.8734a8p-13f),
    (float2)(0x1.b70000p-1f, 0x1.2523d4p-11f),
    (float2)(0x1.ba0000p-1f, 0x1.da6ce6p-11f),
    (float2)(0x1.bd8000p-1f, 0x1.038e62p-12f),
    (float2)(0x1.c08000p-1f, 0x1.1b511ep-11f),
    (float2)(0x1.c38000p-1f, 0x1.a728b8p-11f),
    (float2)(0x1.c70000p-1f, 0x1.2b5d22p-14f),
    (float2)(0x1.ca0000p-1f, 0x1.2c6e54p-12f),
    (float2)(0x1.cd0000p-1f, 0x1.f35064p-12f),
    (float2)(0x1.d00000p-1f, 0x1.4fdb48p-11f),
    (float2)(0x1.d30000p-1f, 0x1.98ec9ep-11f),
    (float2)(0x1.d60000p-1f, 0x1.d4f80cp-11f),
    (float2)(0x1.d98000p-1f, 0x1.0643d6p-17f),
    (float2)(0x1.dc8000p-1f, 0x1.33567ep-14f),
    (float2)(0x1.df8000p-1f, 0x1.e0410cp-14f),
    (float2)(0x1.e28000p-1f, 0x1.142e0ep-13f),
    (float2)(0x1.e58000p-1f, 0x1.063c88p-13f),
    (float2)(0x1.e88000p-1f, 0x1.8d66c4p-14f),
    (float2)(0x1.eb8000p-1f, 0x1.57e32ap-15f),
    (float2)(0x1.ee0000p-1f, 0x1.ed1c6cp-11f),
    (float2)(0x1.f10000p-1f, 0x1.b8a076p-11f),
    (float2)(0x1.f40000p-1f, 0x1.7822f2p-11f),
    (float2)(0x1.f70000p-1f, 0x1.2bbc3ap-11f),
    (float2)(0x1.fa0000p-1f, 0x1.a708bap-12f),
    (float2)(0x1.fd0000p-1f, 0x1.be4c7ep-13f),
    (float2)(0x1.000000p+0f, 0x0.000000p+0f)
};

DECLARE_VTABLE(uchar, PIBITS_TBL, ) = {
    224, 241, 27, 193, 12, 88, 33, 116, 53, 126, 196, 126, 237, 175,
    169, 75, 74, 41, 222, 231, 28, 244, 236, 197, 151, 175, 31,
    235, 158, 212, 181, 168, 127, 121, 154, 253, 24, 61, 221, 38,
    44, 159, 60, 251, 217, 180, 125, 180, 41, 104, 45, 70, 188,
    188, 63, 96, 22, 120, 255, 95, 226, 127, 236, 160, 228, 247,
    46, 126, 17, 114, 210, 231, 76, 13, 230, 88, 71, 230, 4, 249,
    125, 209, 154, 192, 113, 166, 19, 18, 237, 186, 212, 215, 8,
    162, 251, 156, 166, 196, 114, 172, 119, 248, 115, 72, 70, 39,
    168, 187, 36, 25, 128, 75, 55, 9, 233, 184, 145, 220, 134, 21,
    239, 122, 175, 142, 69, 249, 7, 65, 14, 241, 100, 86, 138, 109,
    3, 119, 211, 212, 71, 95, 157, 240, 167, 84, 16, 57, 185, 13,
    230, 139, 2, 0, 0, 0, 0, 0, 0, 0
};

// Tabulated values of sinh(i) and cosh(i) for i = 0,...,36.
DECLARE_VTABLE(float2, SINHCOSH_TBL, 37) = {
    (float2)(0x0.000000p+0f, 0x1.000000p+0f),
    (float2)(0x1.2cd9fcp+0f, 0x1.8b0756p+0f),
    (float2)(0x1.d03cf6p+1f, 0x1.e18fa0p+1f),
    (float2)(0x1.40926ep+3f, 0x1.422a4ap+3f),
    (float2)(0x1.b4a380p+4f, 0x1.b4ee86p+4f),
    (float2)(0x1.28d016p+6f, 0x1.28d6fcp+6f),
    (float2)(0x1.936d22p+7f, 0x1.936e68p+7f),
    (float2)(0x1.122876p+9f, 0x1.122894p+9f),
    (float2)(0x1.749ea6p+10f, 0x1.749eaap+10f),
    (float2)(0x1.fa7158p+11f, 0x1.fa7158p+11f),
    (float2)(0x1.5829dcp+13f, 0x1.5829dep+13f),
    (float2)(0x1.d3c448p+14f, 0x1.d3c448p+14f),
    (float2)(0x1.3de166p+16f, 0x1.3de166p+16f),
    (float2)(0x1.b00b5ap+17f, 0x1.b00b5ap+17f),
    (float2)(0x1.259ac4p+19f, 0x1.259ac4p+19f),
    (float2)(0x1.8f0ccap+20f, 0x1.8f0ccap+20f),
    (float2)(0x1.0f2ebep+22f, 0x1.0f2ebep+22f),
    (float2)(0x1.709348p+23f, 0x1.709348p+23f),
    (float2)(0x1.f4f220p+24f, 0x1.f4f220p+24f),
    (float2)(0x1.546d90p+26f, 0x1.546d90p+26f),
    (float2)(0x1.ceb088p+27f, 0x1.ceb088p+27f),
    (float2)(0x1.3a6e20p+29f, 0x1.3a6e20p+29f),
    (float2)(0x1.ab5adcp+30f, 0x1.ab5adcp+30f),
    (float2)(0x1.226af4p+32f, 0x1.226af4p+32f),
    (float2)(0x1.8ab7fcp+33f, 0x1.8ab7fcp+33f),
    (float2)(0x1.0c3d3ap+35f, 0x1.0c3d3ap+35f),
    (float2)(0x1.6c9326p+36f, 0x1.6c9326p+36f),
    (float2)(0x1.ef8230p+37f, 0x1.ef8230p+37f),
    (float2)(0x1.50bba4p+39f, 0x1.50bba4p+39f),
    (float2)(0x1.c9aae4p+40f, 0x1.c9aae4p+40f),
    (float2)(0x1.370470p+42f, 0x1.370470p+42f),
    (float2)(0x1.a6b766p+43f, 0x1.a6b766p+43f),
    (float2)(0x1.1f43fcp+45f, 0x1.1f43fcp+45f),
    (float2)(0x1.866f34p+46f, 0x1.866f34p+46f),
    (float2)(0x1.0953e2p+48f, 0x1.0953e2p+48f),
    (float2)(0x1.689e22p+49f, 0x1.689e22p+49f),
    (float2)(0x1.ea215ap+50f, 0x1.ea215ap+50f)
};

DECLARE_VTABLE(float2, CBRT_TBL, 129) = {
    (float2)(0x1.000000p+0f, 0x0.000000p+0f),
    (float2)(0x1.008000p+0f, 0x1.51cb0ap-11f),
    (float2)(0x1.014000p+0f, 0x1.39221ep-12f),
    (float2)(0x1.01c000p+0f, 0x1.e06908p-11f),
    (float2)(0x1.028000p+0f, 0x1.1d6978p-11f),
    (float2)(0x1.034000p+0f, 0x1.4ea1bep-13f),
    (float2)(0x1.03c000p+0f, 0x1.833b8ep-11f),
    (float2)(0x1.048000p+0f, 0x1.587002p-12f),
    (float2)(0x1.050000p+0f, 0x1.ceb290p-11f),
    (float2)(0x1.05c000p+0f, 0x1.d57f34p-12f),
    (float2)(0x1.068000p+0f, 0x1.cc53acp-21f),
    (float2)(0x1.070000p+0f, 0x1.0fe098p-11f),
    (float2)(0x1.07c000p+0f, 0x1.91b586p-15f),
    (float2)(0x1.084000p+0f, 0x1.1c362ep-11f),
    (float2)(0x1.090000p+0f, 0x1.94398ep-15f),
    (float2)(0x1.098000p+0f, 0x1.1055bcp-11f),
    (float2)(0x1.0a4000p+0f, 0x1.7e63cap-19f),
    (float2)(0x1.0ac000p+0f, 0x1.d99e1ap-12f),
    (float2)(0x1.0b4000p+0f, 0x1.d258dep-11f),
    (float2)(0x1.0c0000p+0f, 0x1.645962p-12f),
    (float2)(0x1.0c8000p+0f, 0x1.8c5b0ep-11f),
    (float2)(0x1.0d4000p+0f, 0x1.83d0c8p-13f),
    (float2)(0x1.0dc000p+0f, 0x1.300812p-11f),
    (float2)(0x1.0e4000p+0f, 0x1.f9a65ap-11f),
    (float2)(0x1.0f0000p+0f, 0x1.7bbcd8p-12f),
    (float2)(0x1.0f8000p+0f, 0x1.7cbf68p-11f),
    (float2)(0x1.104000p+0f, 0x1.b2c166p-14f),
    (float2)(0x1.10c000p+0f, 0x1.d56ea4p-12f),
    (float2)(0x1.114000p+0f, 0x1.99eb32p-11f),
    (float2)(0x1.120000p+0f, 0x1.1007a2p-13f),
    (float2)(0x1.128000p+0f, 0x1.d212aap-12f),
    (float2)(0x1.130000p+0f, 0x1.890f18p-11f),
    (float2)(0x1.13c000p+0f, 0x1.2104e2p-14f),
    (float2)(0x1.144000p+0f, 0x1.74961ep-12f),
    (float2)(0x1.14c000p+0f, 0x1.4b9b66p-11f),
    (float2)(0x1.154000p+0f, 0x1.d81e66p-11f),
    (float2)(0x1.160000p+0f, 0x1.7f825cp-13f),
    (float2)(0x1.168000p+0f, 0x1.c5dca2p-12f),
    (float2)(0x1.170000p+0f, 0x1.6153bap-11f),
    (float2)(0x1.178000p+0f, 0x1.db1cc2p-11f),
    (float2)(0x1.184000p+0f, 0x1.4154b0p-13f),
    (float2)(0x1.18c000p+0f, 0x1.821114p-12f),
    (float2)(0x1.194000p+0f, 0x1.2d4240p-11f),
    (float2)(0x1.19c000p+0f, 0x1.950d82p-11f),
    (float2)(0x1.1a4000p+0f, 0x1.f8755cp-11f),
    (float2)(0x1.1b0000p+0f, 0x1.5e12a4p-13f),
    (float2)(0x1.1b8000p+0f, 0x1.648c38p-12f),
    (float2)(0x1.1c0000p+0f, 0x1.08c43ep-11f),
    (float2)(0x1.1c8000p+0f, 0x1.5b0970p-11f),
    (float2)(0x1.1d0000p+0f, 0x1.a91fe8p-11f),
    (float2)(0x1.1d8000p+0f, 0x1.f311b6p-11f),
    (float2)(0x1.1e4000p+0f, 0x1.c74618p-14f),
    (float2)(0x1.1ec000p+0f, 0x1.eabb54p-13f),
    (float2)(0x1.1f4000p+0f, 0x1.70db14p-12f),
    (float2)(0x1.1fc000p+0f, 0x1.e45cbcp-12f),
    (float2)(0x1.204000p+0f, 0x1.27faa6p-11f),
    (float2)(0x1.20c000p+0f, 0x1.59db98p-11f),
    (float2)(0x1.214000p+0f, 0x1.87da46p-11f),
    (float2)(0x1.21c000p+0f, 0x1.b1ffa0p-11f),
    (float2)(0x1.224000p+0f, 0x1.d85478p-11f),
    (float2)(0x1.22c000p+0f, 0x1.fae17ep-11f),
    (float2)(0x1.238000p+0f, 0x1.9af40cp-15f),
    (float2)(0x1.240000p+0f, 0x1.a6319ep-14f),
    (float2)(0x1.248000p+0f, 0x1.30baa6p-13f),
    (float2)(0x1.250000p+0f, 0x1.7fc362p-13f),
    (float2)(0x1.258000p+0f, 0x1.c05362p-13f),
    (float2)(0x1.260000p+0f, 0x1.f28a98p-13f),
    (float2)(0x1.268000p+0f, 0x1.0b4442p-12f),
    (float2)(0x1.270000p+0f, 0x1.16361ap-12f),
    (float2)(0x1.278000p+0f, 0x1.1a2a2ap-12f),
    (float2)(0x1.280000p+0f, 0x1.172f8ep-12f),
    (float2)(0x1.288000p+0f, 0x1.0d5530p-12f),
    (float2)(0x1.290000p+0f, 0x1.f9538ep-13f),
    (float2)(0x1.298000p+0f, 0x1.ca77b0p-13f),
    (float2)(0x1.2a0000p+0f, 0x1.8e336ap-13f),
    (float2)(0x1.2a8000p+0f, 0x1.44a304p-13f),
    (float2)(0x1.2b0000p+0f, 0x1.dbc4c8p-14f),
    (float2)(0x1.2b8000p+0f, 0x1.141a2ap-14f),
    (float2)(0x1.2c0000p+0f, 0x1.93e44cp-17f),
    (float2)(0x1.2c4000p+0f, 0x1.e6e432p-11f),
    (float2)(0x1.2cc000p+0f, 0x1.c447c6p-11f),
    (float2)(0x1.2d4000p+0f, 0x1.9e80d8p-11f),
    (float2)(0x1.2dc000p+0f, 0x1.7595dcp-11f),
    (float2)(0x1.2e4000p+0f, 0x1.498d30p-11f),
    (float2)(0x1.2ec000p+0f, 0x1.1a6d1ep-11f),
    (float2)(0x1.2f4000p+0f, 0x1.d077bap-12f),
    (float2)(0x1.2fc000p+0f, 0x1.65ff1ep-12f),
    (float2)(0x1.304000p+0f, 0x1.eaf912p-13f),
    (float2)(0x1.30c000p+0f, 0x1.fbefb8p-14f),
    (float2)(0x1.314000p+0f, 0x1.44905ap-19f),
    (float2)(0x1.318000p+0f, 0x1.c017e6p-11f),
    (float2)(0x1.320000p+0f, 0x1.7bfdbep-11f),
    (float2)(0x1.328000p+0f, 0x1.34fbc6p-11f),
    (float2)(0x1.330000p+0f, 0x1.d62f48p-12f),
    (float2)(0x1.338000p+0f, 0x1.3cadc6p-12f),
    (float2)(0x1.340000p+0f, 0x1.3afc06p-13f),
    (float2)(0x1.344000p+0f, 0x1.fc556ep-11f),
    (float2)(0x1.34c000p+0f, 0x1.a71f84p-11f),
    (float2)(0x1.354000p+0f, 0x1.4f2290p-11f),
    (float2)(0x1.35c000p+0f, 0x1.e8c79cp-12f),
    (float2)(0x1.364000p+0f, 0x1.2dd0d8p-12f),
    (float2)(0x1.36c000p+0f, 0x1.b5ac2ep-14f),
    (float2)(0x1.370000p+0f, 0x1.d3d02ap-11f),
    (float2)(0x1.378000p+0f, 0x1.6e3d58p-11f),
    (float2)(0x1.380000p+0f, 0x1.060200p-11f),
    (float2)(0x1.388000p+0f, 0x1.364608p-12f),
    (float2)(0x1.390000p+0f, 0x1.6d29b6p-14f),
    (float2)(0x1.394000p+0f, 0x1.bd8d5ep-11f),
    (float2)(0x1.39c000p+0f, 0x1.4ae030p-11f),
    (float2)(0x1.3a4000p+0f, 0x1.ab44b2p-12f),
    (float2)(0x1.3ac000p+0f, 0x1.7761cep-13f),
    (float2)(0x1.3b0000p+0f, 0x1.e38710p-11f),
    (float2)(0x1.3b8000p+0f, 0x1.66b2b0p-11f),
    (float2)(0x1.3c0000p+0f, 0x1.cebf96p-12f),
    (float2)(0x1.3c8000p+0f, 0x1.964b20p-13f),
    (float2)(0x1.3cc000p+0f, 0x1.e15004p-11f),
    (float2)(0x1.3d4000p+0f, 0x1.5a9bcep-11f),
    (float2)(0x1.3dc000p+0f, 0x1.a2f4d8p-12f),
    (float2)(0x1.3e4000p+0f, 0x1.17c056p-13f),
    (float2)(0x1.3e8000p+0f, 0x1.b800f8p-11f),
    (float2)(0x1.3f0000p+0f, 0x1.27b132p-11f),
    (float2)(0x1.3f8000p+0f, 0x1.2a09b8p-12f),
    (float2)(0x1.400000p+0f, 0x0.000000p+0f),
    (float2)(0x1.404000p+0f, 0x1.68a69cp-11f),
    (float2)(0x1.40c000p+0f, 0x1.9df950p-12f),
    (float2)(0x1.414000p+0f, 0x1.983050p-14f),
    (float2)(0x1.418000p+0f, 0x1.94c6a4p-11f),
    (float2)(0x1.420000p+0f, 0x1.e88494p-12f),
    (float2)(0x1.428000p+0f, 0x1.45f31ap-13f)
};

DECLARE_VTABLE(float, EXP_TBL, 65) = {
    0x1.000000p+0f,
    0x1.02c9a4p+0f,
    0x1.059b0ep+0f,
    0x1.087452p+0f,
    0x1.0b5586p+0f,
    0x1.0e3ec4p+0f,
    0x1.11301ep+0f,
    0x1.1429aap+0f,
    0x1.172b84p+0f,
    0x1.1a35bep+0f,
    0x1.1d4874p+0f,
    0x1.2063b8p+0f,
    0x1.2387a6p+0f,
    0x1.26b456p+0f,
    0x1.29e9e0p+0f,
    0x1.2d285ap+0f,
    0x1.306fe0p+0f,
    0x1.33c08cp+0f,
    0x1.371a74p+0f,
    0x1.3a7db4p+0f,
    0x1.3dea64p+0f,
    0x1.4160a2p+0f,
    0x1.44e086p+0f,
    0x1.486a2cp+0f,
    0x1.4bfdaep+0f,
    0x1.4f9b28p+0f,
    0x1.5342b6p+0f,
    0x1.56f474p+0f,
    0x1.5ab07ep+0f,
    0x1.5e76f2p+0f,
    0x1.6247ecp+0f,
    0x1.662388p+0f,
    0x1.6a09e6p+0f,
    0x1.6dfb24p+0f,
    0x1.71f75ep+0f,
    0x1.75feb6p+0f,
    0x1.7a1148p+0f,
    0x1.7e2f34p+0f,
    0x1.82589ap+0f,
    0x1.868d9ap+0f,
    0x1.8ace54p+0f,
    0x1.8f1aeap+0f,
    0x1.93737cp+0f,
    0x1.97d82ap+0f,
    0x1.9c4918p+0f,
    0x1.a0c668p+0f,
    0x1.a5503cp+0f,
    0x1.a9e6b6p+0f,
    0x1.ae89fap+0f,
    0x1.b33a2cp+0f,
    0x1.b7f770p+0f,
    0x1.bcc1eap+0f,
    0x1.c199bep+0f,
    0x1.c67f12p+0f,
    0x1.cb720ep+0f,
    0x1.d072d4p+0f,
    0x1.d5818ep+0f,
    0x1.da9e60p+0f,
    0x1.dfc974p+0f,
    0x1.e502eep+0f,
    0x1.ea4afap+0f,
    0x1.efa1bep+0f,
    0x1.f50766p+0f,
    0x1.fa7c18p+0f,
    0x1.000000p+1f,
};

DECLARE_VTABLE(float2, EXP_TBL_EP, 65) = {
    (float2) (0x1.000000p+0f, 0x0.000000p+0f),
    (float2) (0x1.02c000p+0f, 0x1.347ceep-13f),
    (float2) (0x1.058000p+0f, 0x1.b0d314p-12f),
    (float2) (0x1.084000p+0f, 0x1.a28c3ap-11f),
    (float2) (0x1.0b4000p+0f, 0x1.586cf8p-12f),
    (float2) (0x1.0e0000p+0f, 0x1.f61968p-11f),
    (float2) (0x1.110000p+0f, 0x1.80e808p-11f),
    (float2) (0x1.140000p+0f, 0x1.4d5754p-11f),
    (float2) (0x1.170000p+0f, 0x1.5c1e3ep-11f),
    (float2) (0x1.1a0000p+0f, 0x1.adf5b6p-11f),
    (float2) (0x1.1d4000p+0f, 0x1.0e62d0p-13f),
    (float2) (0x1.204000p+0f, 0x1.1dc430p-11f),
    (float2) (0x1.238000p+0f, 0x1.e9b9d4p-14f),
    (float2) (0x1.268000p+0f, 0x1.a2b2f0p-11f),
    (float2) (0x1.29c000p+0f, 0x1.4efa8ep-11f),
    (float2) (0x1.2d0000p+0f, 0x1.42d372p-11f),
    (float2) (0x1.304000p+0f, 0x1.7f0518p-11f),
    (float2) (0x1.33c000p+0f, 0x1.164c82p-17f),
    (float2) (0x1.370000p+0f, 0x1.a7373ap-12f),
    (float2) (0x1.3a4000p+0f, 0x1.ed9a72p-11f),
    (float2) (0x1.3dc000p+0f, 0x1.532608p-11f),
    (float2) (0x1.414000p+0f, 0x1.0510fap-11f),
    (float2) (0x1.44c000p+0f, 0x1.043030p-11f),
    (float2) (0x1.484000p+0f, 0x1.515ae0p-11f),
    (float2) (0x1.4bc000p+0f, 0x1.ed6a9ap-11f),
    (float2) (0x1.4f8000p+0f, 0x1.b2769cp-12f),
    (float2) (0x1.534000p+0f, 0x1.5ab4eap-15f),
    (float2) (0x1.56c000p+0f, 0x1.a39b5ap-11f),
    (float2) (0x1.5a8000p+0f, 0x1.83eea4p-11f),
    (float2) (0x1.5e4000p+0f, 0x1.b78ad6p-11f),
    (float2) (0x1.624000p+0f, 0x1.fac0e8p-14f),
    (float2) (0x1.660000p+0f, 0x1.1c412ap-11f),
    (float2) (0x1.6a0000p+0f, 0x1.3cccfep-13f),
    (float2) (0x1.6dc000p+0f, 0x1.d91e32p-11f),
    (float2) (0x1.71c000p+0f, 0x1.baf476p-11f),
    (float2) (0x1.75c000p+0f, 0x1.f5ab20p-11f),
    (float2) (0x1.7a0000p+0f, 0x1.1473eap-12f),
    (float2) (0x1.7e0000p+0f, 0x1.799b66p-11f),
    (float2) (0x1.824000p+0f, 0x1.89994cp-12f),
    (float2) (0x1.868000p+0f, 0x1.b33688p-13f),
    (float2) (0x1.8ac000p+0f, 0x1.ca8454p-13f),
    (float2) (0x1.8f0000p+0f, 0x1.ae9914p-12f),
    (float2) (0x1.934000p+0f, 0x1.9bd866p-11f),
    (float2) (0x1.97c000p+0f, 0x1.829fdep-12f),
    (float2) (0x1.9c4000p+0f, 0x1.230546p-13f),
    (float2) (0x1.a0c000p+0f, 0x1.99ed76p-14f),
    (float2) (0x1.a54000p+0f, 0x1.03b23ep-12f),
    (float2) (0x1.a9c000p+0f, 0x1.35aabcp-11f),
    (float2) (0x1.ae8000p+0f, 0x1.3f32b4p-13f),
    (float2) (0x1.b30000p+0f, 0x1.d15c26p-11f),
    (float2) (0x1.b7c000p+0f, 0x1.bb797cp-11f),
    (float2) (0x1.bcc000p+0f, 0x1.e904bcp-16f),
    (float2) (0x1.c18000p+0f, 0x1.9bdd84p-12f),
    (float2) (0x1.c64000p+0f, 0x1.f8972ap-11f),
    (float2) (0x1.cb4000p+0f, 0x1.906e76p-11f),
    (float2) (0x1.d04000p+0f, 0x1.96a502p-11f),
    (float2) (0x1.d58000p+0f, 0x1.8dcfbap-16f),
    (float2) (0x1.da8000p+0f, 0x1.e603dap-12f),
    (float2) (0x1.dfc000p+0f, 0x1.2e66f6p-13f),
    (float2) (0x1.e50000p+0f, 0x1.773c58p-15f),
    (float2) (0x1.ea4000p+0f, 0x1.5f4548p-13f),
    (float2) (0x1.ef8000p+0f, 0x1.0df730p-11f),
    (float2) (0x1.f50000p+0f, 0x1.d96db8p-14f),
    (float2) (0x1.fa4000p+0f, 0x1.e0c0cep-11f),
    (float2) (0x1.000000p+1f, 0x0.000000p+0f),
};

VTABLE_FUNCTION4(PIBITS_TBL, pibits_tbl);

VTABLE_FUNCTION(float, LOG_INV_TBL, log_inv_tbl);
VTABLE_FUNCTION(float, EXP_TBL, exp_tbl);

VTABLE_FUNCTION2(v2float, LOGE_TBL, loge_tbl);
VTABLE_FUNCTION2(v2float, LOG2_TBL, log2_tbl);
VTABLE_FUNCTION2(v2float, SINHCOSH_TBL, sinhcosh_tbl);
VTABLE_FUNCTION2(v2float, CBRT_TBL, cbrt_tbl);
VTABLE_FUNCTION2(v2float, EXP_TBL_EP, exp_tbl_ep);
