//
// RawSocketImpl.cpp
//
// $Id: //poco/1.3/Net/src/RawSocketImpl.cpp#2 $
//
// Library: Net
// Package: Sockets
// Module:  RawSocketImpl
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Net/RawSocketImpl.h"
#include "Poco/Net/NetException.h"


using Poco::InvalidArgumentException;


namespace Poco {
namespace Net {


RawSocketImpl::RawSocketImpl()
{
	init(AF_INET);
}


RawSocketImpl::RawSocketImpl(IPAddress::Family family, int proto)
{
	if (family == IPAddress::IPv4)
		init2(AF_INET, proto);
#if defined(POCO_HAVE_IPv6)
	else if (family == IPAddress::IPv6)
		init2(AF_INET6, proto);
#endif
	else throw InvalidArgumentException("Invalid or unsupported address family passed to RawSocketImpl");

}

	
RawSocketImpl::RawSocketImpl(poco_socket_t sockfd): 
	SocketImpl(sockfd)
{
}


RawSocketImpl::~RawSocketImpl()
{
}


void RawSocketImpl::init(int af)
{
	init2(af, IPPROTO_RAW);
}


void RawSocketImpl::init2(int af, int proto)
{
	initSocket(af, SOCK_RAW, proto);
	setOption(IPPROTO_IP, IP_HDRINCL, 0);
}


} } // namespace Poco::Net
