/*
 * files.h
 *
 * Copyright (C) 2012 - 2017 James Booth <boothj5@gmail.com>
 *
 * This file is part of Profanity.
 *
 * Profanity is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Profanity is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Profanity.  If not, see <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give permission to
 * link the code of portions of this program with the OpenSSL library under
 * certain conditions as described in each individual source file, and
 * distribute linked combinations including the two.
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception, you
 * may extend this exception to your version of the file(s), but you are not
 * obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version. If you delete this exception statement from all
 * source files in the program, then also delete it here.
 *
 */

#ifndef CONFIG_FILES_H
#define CONFIG_FILES_H

#include <glib.h>

#define FILE_PROFRC "profrc"
#define FILE_ACCOUNTS "accounts"
#define FILE_TLSCERTS "tlscerts"
#define FILE_PLUGIN_SETTINGS "plugin_settings"
#define FILE_PLUGIN_THEMES "plugin_themes"
#define FILE_CAPSCACHE "capscache"

#define DIR_THEMES "themes"
#define DIR_ICONS "icons"
#define DIR_SCRIPTS "scripts"
#define DIR_CHATLOGS "chatlogs"
#define DIR_OTR "otr"
#define DIR_PGP "pgp"
#define DIR_PLUGINS "plugins"

void files_create_directories(void);

char* files_get_config_path(char *config_base);
char* files_get_data_path(char *data_base);

char* files_get_log_file(void);
char* files_get_inputrc_file(void);

#endif
