#include <iostream>
#include <sstream>
#include <fstream>
#include <string>
#include <map>
#include <vector>

using namespace std;

int parse_excluded_edges(string filename, map<string, int> &excluded_edges);
void tokenize(const string& str, vector<string>& tokens, const string& delimiters);
int rewrite_graph(const string in, map<string, int> exclude);
string chomp(string &str);


int main(const int argc, char *argv[]) {

	string usage = "USAGE: "+string(argv[0])+" -e <EXCLUSION FILE> GRAPH1 GRAPH2 ...";
	
	vector<string> graphs;
	map<string, int> exclude;
	for(int paras = 1; paras < argc; paras++) {
		string arg = string(argv[paras]);
		if( argc < 4 || arg == "-h" || arg == "--help") {
			cout << usage;
			return 0;
		} else if(arg == "-e") {
			parse_excluded_edges(string(argv[++paras]), exclude);
		} else {
			graphs.push_back(arg);
		}
	}

	for(vector<string>::iterator it = graphs.begin(); it != graphs.end(); it++) {
		rewrite_graph(*it, exclude);
	}
	
	for(map<string, int>::iterator it = exclude.begin(); it != exclude.end(); it++) {
		//cout << it->first << "\n";
	}
	
}

int rewrite_graph(const string in, map<string, int> exclude) {
	ifstream graph_file(in.c_str());
	if(!graph_file.is_open()) {
		cerr << "could not read input file "+in;
		return -1;
	}	
	
	int count = 0;
	string line;
	while (getline(graph_file, line)) {
		chomp(line);
		vector<string> fields;
		tokenize(line, fields, "\t");
		if(fields.size() > 1 && fields[0].substr(0, 1) != "#") {
			string a = fields[0];
			string b = fields[1];
			string c = b+" "+a;
			if(a.compare(b) < 0 ) {
				c = a+" "+b;
			}
			//cout << c << endl;
			if(exclude.count(c) == 1) {
				count++;
				continue;
			}
		}
		
		cout << line << endl;
	}

	graph_file.close();
	
	cerr << "# excluded " << count << " edges from the graph." << endl;
	return 0;
}

string chomp(string &str) {
	string::size_type pos = str.find_last_not_of("\n\r \t");
	if(pos != string::npos) {
  		str = str.substr(0, pos+1);
  	}
  	return str;
}
    
int parse_excluded_edges(string filename, map<string, int> &excluded_edges) {    
    ifstream data(filename.c_str());
    if(!data.is_open()) {
    	cerr << "could not open file"+filename;
    }

    string line;
    while(getline(data,line)) {
        
        chomp(line);
        vector<string> v;
        tokenize(line, v, "\t");
        
        if(v.size() < 2) {
        	continue;
        }
        string a = v[0];
        string b = v[1];
        string c = b + " " + a;

        if(a.compare(b) < 0) {
        	c = a + " " + b;
        }
        //cout << c << endl;
       	excluded_edges[c] = 1;
    }
    
    data.close();
    
    return 0;
}

// Split a string at a certain delim
void tokenize(const string& str, vector<string>& tokens, const string& delimiters = "\t") {
    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos = str.find_first_of(delimiters, lastPos);

    while (string::npos != pos || string::npos != lastPos) {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}

