"""
"""
import sys
import os
import unittest

# Add the directory containing 'grendel' to the sys.path
sys.path.append(os.path.join(os.path.dirname(__file__), os.pardir, os.pardir, os.pardir))

# Add the directory containing the 'grendel_tests' package to sys.path
sys.path.append(os.path.join(os.path.dirname(__file__), os.pardir, os.pardir))

from grendel import *
from grendel.external.combinatorics import *
from grendel_tests import allow_generators, long_generator, generator, long_test, profile, skip, expected_failure

class CombinatoricsTest(unittest.TestCase):

    def test_uballs_uboxes_4_4(self):
        self.assertSetEqual(
            set(unlabeled_balls_in_unlabeled_boxes(4, [4,4,4,4])),
                {
                    (4,0,0,0,),
                    (3,1,0,0,),
                    (2,2,0,0,),
                    (2,1,1,0,),
                    (1,1,1,1,),
                }
        )

    def test_uballs_lboxes_4_4(self):
        self.assertSetEqual(
            set(unlabeled_balls_in_labeled_boxes(4, [4,4,4,4])),
            {
                (4,0,0,0,),
                (0,4,0,0,),
                (0,0,4,0,),
                (0,0,0,4,),
                (3,1,0,0,),
                (3,0,1,0,),
                (3,0,0,1,),
                (1,3,0,0,),
                (1,0,3,0,),
                (1,0,0,3,),
                (0,3,1,0,),
                (0,3,0,1,),
                (0,1,3,0,),
                (0,1,0,3,),
                (0,0,3,1,),
                (0,0,1,3,),
                (2,2,0,0,),
                (2,0,2,0,),
                (2,0,0,2,),
                (0,2,2,0,),
                (0,2,0,2,),
                (0,0,2,2,),
                (2,1,1,0,),
                (2,1,0,1,),
                (2,0,1,1,),
                (1,2,1,0,),
                (1,2,0,1,),
                (1,1,2,0,),
                (1,1,0,2,),
                (1,0,2,1,),
                (1,0,1,2,),
                (0,2,1,1,),
                (0,1,2,1,),
                (0,1,1,2,),
                (1,1,1,1,),
            }
        )

    def test_lballs_uboxes_4_4(self):
        self.assertSetEqual(
            set(labeled_balls_in_unlabeled_boxes(4, [4,4,4,4])),
            {
                ((0, 1, 2, 3, ), (), (), (), ),
                ((0, 1, 2, ), (3, ), (), (), ),
                ((0, 1, 3, ), (2, ), (), (), ),
                ((0, 2, 3, ), (1, ), (), (), ),
                ((1, 2, 3, ), (0, ), (), (), ),
                ((0, 1, ), (2, 3, ), (), (), ),
                ((0, 2, ), (1, 3, ), (), (), ),
                ((0, 3, ), (1, 2, ), (), (), ),
                ((0, 1, ), (2, ), (3, ), (), ),
                ((0, 2, ), (1, ), (3, ), (), ),
                ((0, 3, ), (1, ), (2, ), (), ),
                ((1, 2, ), (0, ), (3, ), (), ),
                ((1, 3, ), (0, ), (2, ), (), ),
                ((2, 3, ), (0, ), (1, ), (), ),
                ((0, ), (1, ), (2, ), (3, ), ),
            }
        )

    def test_lballs_lboxes_4_4(self):
        self.assertSetEqual(
            set(labeled_balls_in_labeled_boxes(4, [4,4,4,4])),
            {
                ((0, 1, 2, 3, ), (), (), (), ),
                ((), (0, 1, 2, 3, ), (), (), ),
                ((), (), (0, 1, 2, 3, ), (), ),
                ((), (), (), (0, 1, 2, 3, ), ),
                ((0, 1, 2, ), (3, ), (), (), ),
                ((0, 1, 3, ), (2, ), (), (), ),
                ((0, 2, 3, ), (1, ), (), (), ),
                ((1, 2, 3, ), (0, ), (), (), ),
                ((0, 1, 2, ), (), (3, ), (), ),
                ((0, 1, 3, ), (), (2, ), (), ),
                ((0, 2, 3, ), (), (1, ), (), ),
                ((1, 2, 3, ), (), (0, ), (), ),
                ((0, 1, 2, ), (), (), (3, ), ),
                ((0, 1, 3, ), (), (), (2, ), ),
                ((0, 2, 3, ), (), (), (1, ), ),
                ((1, 2, 3, ), (), (), (0, ), ),
                ((0, ), (1, 2, 3, ), (), (), ),
                ((1, ), (0, 2, 3, ), (), (), ),
                ((2, ), (0, 1, 3, ), (), (), ),
                ((3, ), (0, 1, 2, ), (), (), ),
                ((0, ), (), (1, 2, 3, ), (), ),
                ((1, ), (), (0, 2, 3, ), (), ),
                ((2, ), (), (0, 1, 3, ), (), ),
                ((3, ), (), (0, 1, 2, ), (), ),
                ((0, ), (), (), (1, 2, 3, ), ),
                ((1, ), (), (), (0, 2, 3, ), ),
                ((2, ), (), (), (0, 1, 3, ), ),
                ((3, ), (), (), (0, 1, 2, ), ),
                ((), (0, 1, 2, ), (3, ), (), ),
                ((), (0, 1, 3, ), (2, ), (), ),
                ((), (0, 2, 3, ), (1, ), (), ),
                ((), (1, 2, 3, ), (0, ), (), ),
                ((), (0, 1, 2, ), (), (3, ), ),
                ((), (0, 1, 3, ), (), (2, ), ),
                ((), (0, 2, 3, ), (), (1, ), ),
                ((), (1, 2, 3, ), (), (0, ), ),
                ((), (0, ), (1, 2, 3, ), (), ),
                ((), (1, ), (0, 2, 3, ), (), ),
                ((), (2, ), (0, 1, 3, ), (), ),
                ((), (3, ), (0, 1, 2, ), (), ),
                ((), (0, ), (), (1, 2, 3, ), ),
                ((), (1, ), (), (0, 2, 3, ), ),
                ((), (2, ), (), (0, 1, 3, ), ),
                ((), (3, ), (), (0, 1, 2, ), ),
                ((), (), (0, 1, 2, ), (3, ), ),
                ((), (), (0, 1, 3, ), (2, ), ),
                ((), (), (0, 2, 3, ), (1, ), ),
                ((), (), (1, 2, 3, ), (0, ), ),
                ((), (), (0, ), (1, 2, 3, ), ),
                ((), (), (1, ), (0, 2, 3, ), ),
                ((), (), (2, ), (0, 1, 3, ), ),
                ((), (), (3, ), (0, 1, 2, ), ),
                ((0, 1, ), (2, 3, ), (), (), ),
                ((0, 2, ), (1, 3, ), (), (), ),
                ((0, 3, ), (1, 2, ), (), (), ),
                ((1, 2, ), (0, 3, ), (), (), ),
                ((1, 3, ), (0, 2, ), (), (), ),
                ((2, 3, ), (0, 1, ), (), (), ),
                ((0, 1, ), (), (2, 3, ), (), ),
                ((0, 2, ), (), (1, 3, ), (), ),
                ((0, 3, ), (), (1, 2, ), (), ),
                ((1, 2, ), (), (0, 3, ), (), ),
                ((1, 3, ), (), (0, 2, ), (), ),
                ((2, 3, ), (), (0, 1, ), (), ),
                ((0, 1, ), (), (), (2, 3, ), ),
                ((0, 2, ), (), (), (1, 3, ), ),
                ((0, 3, ), (), (), (1, 2, ), ),
                ((1, 2, ), (), (), (0, 3, ), ),
                ((1, 3, ), (), (), (0, 2, ), ),
                ((2, 3, ), (), (), (0, 1, ), ),
                ((), (0, 1, ), (2, 3, ), (), ),
                ((), (0, 2, ), (1, 3, ), (), ),
                ((), (0, 3, ), (1, 2, ), (), ),
                ((), (1, 2, ), (0, 3, ), (), ),
                ((), (1, 3, ), (0, 2, ), (), ),
                ((), (2, 3, ), (0, 1, ), (), ),
                ((), (0, 1, ), (), (2, 3, ), ),
                ((), (0, 2, ), (), (1, 3, ), ),
                ((), (0, 3, ), (), (1, 2, ), ),
                ((), (1, 2, ), (), (0, 3, ), ),
                ((), (1, 3, ), (), (0, 2, ), ),
                ((), (2, 3, ), (), (0, 1, ), ),
                ((), (), (0, 1, ), (2, 3, ), ),
                ((), (), (0, 2, ), (1, 3, ), ),
                ((), (), (0, 3, ), (1, 2, ), ),
                ((), (), (1, 2, ), (0, 3, ), ),
                ((), (), (1, 3, ), (0, 2, ), ),
                ((), (), (2, 3, ), (0, 1, ), ),
                ((0, 1, ), (2, ), (3, ), (), ),
                ((0, 1, ), (3, ), (2, ), (), ),
                ((0, 2, ), (1, ), (3, ), (), ),
                ((0, 2, ), (3, ), (1, ), (), ),
                ((0, 3, ), (1, ), (2, ), (), ),
                ((0, 3, ), (2, ), (1, ), (), ),
                ((1, 2, ), (0, ), (3, ), (), ),
                ((1, 2, ), (3, ), (0, ), (), ),
                ((1, 3, ), (0, ), (2, ), (), ),
                ((1, 3, ), (2, ), (0, ), (), ),
                ((2, 3, ), (0, ), (1, ), (), ),
                ((2, 3, ), (1, ), (0, ), (), ),
                ((0, 1, ), (2, ), (), (3, ), ),
                ((0, 1, ), (3, ), (), (2, ), ),
                ((0, 2, ), (1, ), (), (3, ), ),
                ((0, 2, ), (3, ), (), (1, ), ),
                ((0, 3, ), (1, ), (), (2, ), ),
                ((0, 3, ), (2, ), (), (1, ), ),
                ((1, 2, ), (0, ), (), (3, ), ),
                ((1, 2, ), (3, ), (), (0, ), ),
                ((1, 3, ), (0, ), (), (2, ), ),
                ((1, 3, ), (2, ), (), (0, ), ),
                ((2, 3, ), (0, ), (), (1, ), ),
                ((2, 3, ), (1, ), (), (0, ), ),
                ((0, 1, ), (), (2, ), (3, ), ),
                ((0, 1, ), (), (3, ), (2, ), ),
                ((0, 2, ), (), (1, ), (3, ), ),
                ((0, 2, ), (), (3, ), (1, ), ),
                ((0, 3, ), (), (1, ), (2, ), ),
                ((0, 3, ), (), (2, ), (1, ), ),
                ((1, 2, ), (), (0, ), (3, ), ),
                ((1, 2, ), (), (3, ), (0, ), ),
                ((1, 3, ), (), (0, ), (2, ), ),
                ((1, 3, ), (), (2, ), (0, ), ),
                ((2, 3, ), (), (0, ), (1, ), ),
                ((2, 3, ), (), (1, ), (0, ), ),
                ((0, ), (1, 2, ), (3, ), (), ),
                ((0, ), (1, 3, ), (2, ), (), ),
                ((0, ), (2, 3, ), (1, ), (), ),
                ((1, ), (0, 2, ), (3, ), (), ),
                ((1, ), (0, 3, ), (2, ), (), ),
                ((1, ), (2, 3, ), (0, ), (), ),
                ((2, ), (0, 1, ), (3, ), (), ),
                ((2, ), (0, 3, ), (1, ), (), ),
                ((2, ), (1, 3, ), (0, ), (), ),
                ((3, ), (0, 1, ), (2, ), (), ),
                ((3, ), (0, 2, ), (1, ), (), ),
                ((3, ), (1, 2, ), (0, ), (), ),
                ((0, ), (1, 2, ), (), (3, ), ),
                ((0, ), (1, 3, ), (), (2, ), ),
                ((0, ), (2, 3, ), (), (1, ), ),
                ((1, ), (0, 2, ), (), (3, ), ),
                ((1, ), (0, 3, ), (), (2, ), ),
                ((1, ), (2, 3, ), (), (0, ), ),
                ((2, ), (0, 1, ), (), (3, ), ),
                ((2, ), (0, 3, ), (), (1, ), ),
                ((2, ), (1, 3, ), (), (0, ), ),
                ((3, ), (0, 1, ), (), (2, ), ),
                ((3, ), (0, 2, ), (), (1, ), ),
                ((3, ), (1, 2, ), (), (0, ), ),
                ((0, ), (1, ), (2, 3, ), (), ),
                ((0, ), (2, ), (1, 3, ), (), ),
                ((0, ), (3, ), (1, 2, ), (), ),
                ((1, ), (0, ), (2, 3, ), (), ),
                ((1, ), (2, ), (0, 3, ), (), ),
                ((1, ), (3, ), (0, 2, ), (), ),
                ((2, ), (0, ), (1, 3, ), (), ),
                ((2, ), (1, ), (0, 3, ), (), ),
                ((2, ), (3, ), (0, 1, ), (), ),
                ((3, ), (0, ), (1, 2, ), (), ),
                ((3, ), (1, ), (0, 2, ), (), ),
                ((3, ), (2, ), (0, 1, ), (), ),
                ((0, ), (1, ), (), (2, 3, ), ),
                ((0, ), (2, ), (), (1, 3, ), ),
                ((0, ), (3, ), (), (1, 2, ), ),
                ((1, ), (0, ), (), (2, 3, ), ),
                ((1, ), (2, ), (), (0, 3, ), ),
                ((1, ), (3, ), (), (0, 2, ), ),
                ((2, ), (0, ), (), (1, 3, ), ),
                ((2, ), (1, ), (), (0, 3, ), ),
                ((2, ), (3, ), (), (0, 1, ), ),
                ((3, ), (0, ), (), (1, 2, ), ),
                ((3, ), (1, ), (), (0, 2, ), ),
                ((3, ), (2, ), (), (0, 1, ), ),
                ((0, ), (), (1, 2, ), (3, ), ),
                ((0, ), (), (1, 3, ), (2, ), ),
                ((0, ), (), (2, 3, ), (1, ), ),
                ((1, ), (), (0, 2, ), (3, ), ),
                ((1, ), (), (0, 3, ), (2, ), ),
                ((1, ), (), (2, 3, ), (0, ), ),
                ((2, ), (), (0, 1, ), (3, ), ),
                ((2, ), (), (0, 3, ), (1, ), ),
                ((2, ), (), (1, 3, ), (0, ), ),
                ((3, ), (), (0, 1, ), (2, ), ),
                ((3, ), (), (0, 2, ), (1, ), ),
                ((3, ), (), (1, 2, ), (0, ), ),
                ((0, ), (), (1, ), (2, 3, ), ),
                ((0, ), (), (2, ), (1, 3, ), ),
                ((0, ), (), (3, ), (1, 2, ), ),
                ((1, ), (), (0, ), (2, 3, ), ),
                ((1, ), (), (2, ), (0, 3, ), ),
                ((1, ), (), (3, ), (0, 2, ), ),
                ((2, ), (), (0, ), (1, 3, ), ),
                ((2, ), (), (1, ), (0, 3, ), ),
                ((2, ), (), (3, ), (0, 1, ), ),
                ((3, ), (), (0, ), (1, 2, ), ),
                ((3, ), (), (1, ), (0, 2, ), ),
                ((3, ), (), (2, ), (0, 1, ), ),
                ((), (0, 1, ), (2, ), (3, ), ),
                ((), (0, 1, ), (3, ), (2, ), ),
                ((), (0, 2, ), (1, ), (3, ), ),
                ((), (0, 2, ), (3, ), (1, ), ),
                ((), (0, 3, ), (1, ), (2, ), ),
                ((), (0, 3, ), (2, ), (1, ), ),
                ((), (1, 2, ), (0, ), (3, ), ),
                ((), (1, 2, ), (3, ), (0, ), ),
                ((), (1, 3, ), (0, ), (2, ), ),
                ((), (1, 3, ), (2, ), (0, ), ),
                ((), (2, 3, ), (0, ), (1, ), ),
                ((), (2, 3, ), (1, ), (0, ), ),
                ((), (0, ), (1, 2, ), (3, ), ),
                ((), (0, ), (1, 3, ), (2, ), ),
                ((), (0, ), (2, 3, ), (1, ), ),
                ((), (1, ), (0, 2, ), (3, ), ),
                ((), (1, ), (0, 3, ), (2, ), ),
                ((), (1, ), (2, 3, ), (0, ), ),
                ((), (2, ), (0, 1, ), (3, ), ),
                ((), (2, ), (0, 3, ), (1, ), ),
                ((), (2, ), (1, 3, ), (0, ), ),
                ((), (3, ), (0, 1, ), (2, ), ),
                ((), (3, ), (0, 2, ), (1, ), ),
                ((), (3, ), (1, 2, ), (0, ), ),
                ((), (0, ), (1, ), (2, 3, ), ),
                ((), (0, ), (2, ), (1, 3, ), ),
                ((), (0, ), (3, ), (1, 2, ), ),
                ((), (1, ), (0, ), (2, 3, ), ),
                ((), (1, ), (2, ), (0, 3, ), ),
                ((), (1, ), (3, ), (0, 2, ), ),
                ((), (2, ), (0, ), (1, 3, ), ),
                ((), (2, ), (1, ), (0, 3, ), ),
                ((), (2, ), (3, ), (0, 1, ), ),
                ((), (3, ), (0, ), (1, 2, ), ),
                ((), (3, ), (1, ), (0, 2, ), ),
                ((), (3, ), (2, ), (0, 1, ), ),
                ((0, ), (1, ), (2, ), (3, ), ),
                ((0, ), (1, ), (3, ), (2, ), ),
                ((0, ), (2, ), (1, ), (3, ), ),
                ((0, ), (2, ), (3, ), (1, ), ),
                ((0, ), (3, ), (1, ), (2, ), ),
                ((0, ), (3, ), (2, ), (1, ), ),
                ((1, ), (0, ), (2, ), (3, ), ),
                ((1, ), (0, ), (3, ), (2, ), ),
                ((1, ), (2, ), (0, ), (3, ), ),
                ((1, ), (2, ), (3, ), (0, ), ),
                ((1, ), (3, ), (0, ), (2, ), ),
                ((1, ), (3, ), (2, ), (0, ), ),
                ((2, ), (0, ), (1, ), (3, ), ),
                ((2, ), (0, ), (3, ), (1, ), ),
                ((2, ), (1, ), (0, ), (3, ), ),
                ((2, ), (1, ), (3, ), (0, ), ),
                ((2, ), (3, ), (0, ), (1, ), ),
                ((2, ), (3, ), (1, ), (0, ), ),
                ((3, ), (0, ), (1, ), (2, ), ),
                ((3, ), (0, ), (2, ), (1, ), ),
                ((3, ), (1, ), (0, ), (2, ), ),
                ((3, ), (1, ), (2, ), (0, ), ),
                ((3, ), (2, ), (0, ), (1, ), ),
                ((3, ), (2, ), (1, ), (0, ), ),
            }
        )

    def test_nothing(self):
        pass