---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet config'
canonical: "/puppet/latest/man/config.html"
---

# Man Page: puppet config

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-config** - Interact with Puppet\'s settings.

## SYNOPSIS
puppet config *action* \[\--section SECTION_NAME\]

## DESCRIPTION
This subcommand can inspect and modify settings from Puppet\'s
\'puppet.conf\' configuration file. For documentation about individual
settings, see https://puppet.com/docs/puppet/latest/configuration.html.

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument, although it may or may not be relevant to the
present action. For example, **server** and **run_mode** are valid
settings, so you can specify **\--server \<servername\>**, or
**\--run_mode \<runmode\>** as an argument.

See the configuration file documentation at
*https://puppet.com/docs/puppet/latest/configuration.html* for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with **\--genconfig**.

\--render-as FORMAT

:   The format in which to render output. The most common formats are
    **json**, **s** (string), **yaml**, and **console**, but other
    options such as **dot** are sometimes available.

\--verbose

:   Whether to log verbosely.

\--debug

:   Whether to log debug information.

\--section SECTION_NAME

:   The section of the puppet.conf configuration file to interact with.

    The three most commonly used sections are \'main\', \'server\', and
    \'agent\'. \'Main\' is the default, and is used by all Puppet
    applications. Other sections can override \'main\' values for
    specific applications \-\-- the \'server\' section affects Puppet
    Server, and the \'agent\' section affects puppet agent.

    Less commonly used is the \'user\' section, which affects puppet
    apply. Any other section will be treated as the name of a legacy
    environment (a deprecated feature), and can only include the
    \'manifest\' and \'modulepath\' settings.

## ACTIONS
**delete** - Delete a Puppet setting.

:   **SYNOPSIS**

    puppet config delete \[\--section SECTION_NAME\] *setting*

    **DESCRIPTION**

    Deletes a setting from the specified section. (The default is the
    section \'main\').

    **NOTES**

    By default, this action deletes the configuration setting from the
    \'main\' configuration domain. Use the \'\--section\' flags to
    delete settings from other configuration domains.

**print** - Examine Puppet\'s current settings.

:   **SYNOPSIS**

    puppet config print \[\--section SECTION_NAME\] all \| *setting*
    \[*setting* \...\]

    **DESCRIPTION**

    Prints the value of a single setting or a list of settings.

    This action is a replacement interface to the information available
    with **puppet \<subcommand\> \--configprint**.

    **NOTES**

    By default, this action reads the general configuration in the
    \'main\' section. Use the \'\--section\' and \'\--environment\'
    flags to examine other configuration domains.

**set** - Set Puppet\'s settings.

:   **SYNOPSIS**

    puppet config set \[\--section SECTION_NAME\] \[setting_name\]
    \[setting_value\]

    **DESCRIPTION**

    Updates values in the **puppet.conf** configuration file.

    **NOTES**

    By default, this action manipulates the configuration in the
    \'main\' section. Use the \'\--section\' flag to manipulate other
    configuration domains.

## EXAMPLES
**delete**

Delete the setting \'setting_name\' from the \'main\' configuration
domain:

\$ puppet config delete setting_name

Delete the setting \'setting_name\' from the \'server\' configuration
domain:

\$ puppet config delete setting_name \--section server

**print**

Get puppet\'s runfile directory:

\$ puppet config print rundir

Get a list of important directories from the server\'s config:

\$ puppet config print all \--section server \| grep -E \"(path\|dir)\"

**set**

Set puppet\'s runfile directory:

\$ puppet config set rundir /var/run/puppetlabs

Set the vardir for only the agent:

\$ puppet config set vardir /opt/puppetlabs/puppet/cache \--section
agent

## COPYRIGHT AND LICENSE
Copyright 2011 by Puppet Inc. Apache 2 license; see COPYING
