---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet filebucket'
canonical: "/puppet/latest/man/filebucket.html"
---

# Man Page: puppet filebucket

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-filebucket** - Store and retrieve files in a filebucket

## SYNOPSIS
A stand-alone Puppet filebucket client.

## USAGE
puppet filebucket *mode* \[-h\|\--help\] \[-V\|\--version\]
\[-d\|\--debug\] \[-v\|\--verbose\] \[-l\|\--local\] \[-r\|\--remote\]
\[-s\|\--server *server*\] \[-f\|\--fromdate *date*\] \[-t\|\--todate
*date*\] \[-b\|\--bucket *directory*\] *file* *file* \...

Puppet filebucket can operate in three modes, with only one mode per
call:

backup: Send one or more files to the specified file bucket. Each sent
file is printed with its resulting sha256 sum.

get: Return the text associated with an sha256 sum. The text is printed
to stdout, and only one file can be retrieved at a time.

restore: Given a file path and an sha256 sum, store the content
associated with the sum into the specified file path. You can specify an
entirely new path to this argument; you are not restricted to restoring
the content to its original location.

diff: Print a diff in unified format between two checksums in the
filebucket or between a checksum and its matching file.

list: List all files in the current local filebucket. Listing remote
filebuckets is not allowed.

## DESCRIPTION
This is a stand-alone filebucket client for sending files to a local or
central filebucket.

Note that \'filebucket\' defaults to using a network-based filebucket
available on the server named \'puppet\'. To use this, you\'ll have to
be running as a user with valid Puppet certificates. Alternatively, you
can use your local file bucket by specifying \'\--local\', or by
specifying \'\--bucket\' with a local path.

**Important**: When you enable and use the backup option, and by
extension the filebucket resource, you must ensure that sufficient disk
space is available for the file backups. Generally, you can provide the
disk space by using one of the following two options:

-   Use a **find** command and **crontab** entry to retain only the last
    X days of file backups. For example:



      find /opt/puppetlabs/server/data/puppetserver/bucket -type f -mtime +45 -atime +45 -print0 | xargs -0 rm

-   Restrict the directory to a maximum size after which the oldest
    items are removed.

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument. For example, \'ssldir\' is a valid setting, so you
can specify \'\--ssldir *directory*\' as an argument.

See the configuration file documentation at
https://puppet.com/docs/puppet/latest/configuration.html for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with \'\--genconfig\'.

\--bucket

:   Specify a local filebucket path. This overrides the default path set
    in \'\$clientbucketdir\'.

\--debug

:   Enable full debugging.

\--fromdate

:   (list only) Select bucket files from \'fromdate\'.

\--help

:   Print this help message.

\--local

:   Use the local filebucket. This uses the default configuration
    information and the bucket located at the \'\$clientbucketdir\'
    setting by default. If \'\--bucket\' is set, puppet uses that path
    instead.

\--remote

:   Use a remote filebucket. This uses the default configuration
    information and the bucket located at the \'\$bucketdir\' setting by
    default.

\--server_list

:   A list of comma separated servers; only the first entry is used for
    file storage. This setting takes precidence over **server**.

\--server

:   The server to use for file storage. This setting is only used if
    **server_list** is not set.

\--todate

:   (list only) Select bucket files until \'todate\'.

\--verbose

:   Print extra information.

\--version

:   Print version information.

## EXAMPLES

    ### Backup a file to the filebucket, then restore it to a temporary directory    $ puppet filebucket backup /etc/passwd
    /etc/passwd: 429b225650b912a2ee067b0a4cf1e949
    $ puppet filebucket restore /tmp/passwd 429b225650b912a2ee067b0a4cf1e949

    ### Diff between two files in the filebucket    $ puppet filebucket -l diff d43a6ecaa892a1962398ac9170ea9bf2 7ae322f5791217e031dc60188f4521ef
    1a2
    > again

    ### Diff between the file in the filebucket and a local file    $ puppet filebucket -l diff d43a6ecaa892a1962398ac9170ea9bf2 /tmp/testFile
    1a2
    > again

    ### Backup a file to the filebucket and observe that it keeps each backup separate    $ puppet filebucket -l list
    d43a6ecaa892a1962398ac9170ea9bf2 2015-05-11 09:27:56 /tmp/TestFile

    $ echo again >> /tmp/TestFile

    $ puppet filebucket -l backup /tmp/TestFile
    /tmp/TestFile: 7ae322f5791217e031dc60188f4521ef

    $ puppet filebucket -l list
    d43a6ecaa892a1962398ac9170ea9bf2 2015-05-11 09:27:56 /tmp/TestFile
    7ae322f5791217e031dc60188f4521ef 2015-05-11 09:52:15 /tmp/TestFile

    ### List files in a filebucket within date ranges    $ puppet filebucket -l -f 2015-01-01 -t 2015-01-11 list
    <Empty Output>

    $ puppet filebucket -l -f 2015-05-10 list
    d43a6ecaa892a1962398ac9170ea9bf2 2015-05-11 09:27:56 /tmp/TestFile
    7ae322f5791217e031dc60188f4521ef 2015-05-11 09:52:15 /tmp/TestFile

    $ puppet filebucket -l -f "2015-05-11 09:30:00" list
    7ae322f5791217e031dc60188f4521ef 2015-05-11 09:52:15 /tmp/TestFile

    $ puppet filebucket -l -t "2015-05-11 09:30:00" list
    d43a6ecaa892a1962398ac9170ea9bf2 2015-05-11 09:27:56 /tmp/TestFile

    ### Manage files in a specific local filebucket    $ puppet filebucket -b /tmp/TestBucket backup /tmp/TestFile2
    /tmp/TestFile2: d41d8cd98f00b204e9800998ecf8427e
    $ puppet filebucket -b /tmp/TestBucket list
    d41d8cd98f00b204e9800998ecf8427e 2015-05-11 09:33:22 /tmp/TestFile2

    ### From a Puppet Server, list files in the server bucketdir    $ puppet filebucket -b $(puppet config print bucketdir --section server) list
    d43a6ecaa892a1962398ac9170ea9bf2 2015-05-11 09:27:56 /tmp/TestFile
    7ae322f5791217e031dc60188f4521ef 2015-05-11 09:52:15 /tmp/TestFile

## AUTHOR
Luke Kanies

## COPYRIGHT
Copyright (c) 2011 Puppet Inc., LLC Licensed under the Apache 2.0
License
