#!/usr/bin/python
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: FindDialog.py 82 2004-07-11 13:01:44Z henning $

from Tkinter import *
from InputWidgets import TextComboEdit
import Pmw
import vcard

class FindDialog(Pmw.Dialog):
    def __init__(self, master, title='Find Contact', class_=None):
        Pmw.Dialog.__init__(self, master=master, title=title,
            buttons=('Ok','Cancel'), defaultbutton='Ok',
            activatecommand=self._onactivate)   
           
        lbl = Label(self.interior(), text="Search for:")
        lbl.grid(padx=2, pady=2)

        self.findstrvar = StringVar()
        self.edtSearch = Entry(self.interior(), textvariable = self.findstrvar)
        self.edtSearch.grid(sticky=W+E,padx=2, pady=2)

        lbl = Label(self.interior(), text="in Field:")
        lbl.grid(padx=2, pady=2)

        self.selField = selField = TextComboEdit(self.interior(), entry_state=DISABLED)
        selField.setlist(vcard.FIELDNAMES)
        selField.selectitem(0)
        selField.grid(sticky=W+E, padx=2, pady=2)

        
        lbl = Label(self.interior(), text="Search Options:")
        lbl.grid(padx=2, pady=2)
        
        self.regexvar = IntVar()
        selRegex = Checkbutton(self.interior(), text="Use Regular Expressions",
                variable = self.regexvar)
        selRegex.grid(sticky=W, padx=2, pady=2)
        
        self.ignorecasevar = IntVar()
        self.ignorecasevar.set(1)
        selIgnoreCase = Checkbutton(self.interior(), text="Case Insensitive Search",
                variable = self.ignorecasevar)
        selIgnoreCase.grid(sticky=W, padx=2, pady=2)

    def _onactivate(self):
        self.edtSearch.focus_set()

    def getvalue(self):
        return map(lambda x: x.get(), 
            (self.findstrvar,
            self.selField,
            self.regexvar,
            self.ignorecasevar))

if __name__ == "__main__":
    # Unit Test:
    tk = Tk()
    dlg = FindDialog(tk)
    print dlg.activate()
    tk.destroy()
