---
title: Installing on non-x86 platforms
---

pyOCD itself is pure Python and should run on any platform with a modern Python installation.
However, it has several dependencies with binary backends that cause trouble on non-x86 platforms or
alternative operating systems (i.e., not macOS, Linux, or Windows). The most common "non-standard"
system that users would like to run pyOCD on is the Raspberry Pi, as well as similar, Arm-based
single-board computers.


## cmsis-pack-manager

The main dependency that causes trouble is
[cmsis-pack-manager](https://github.com/pyocd/cmsis-pack-manager/). It has a backend written in
the Rust language to greatly improve performance. Unfortunately, wheels are not available for
non-x86 systems. And, worse, the Rust compiler runs out of memory and dies when attempting to build
on small platforms such as the Raspberry Pi. (Cross-compilation may be an option but has not been
sufficiently investigated.)

The good news is that cmsis-pack-manager is optional for pyOCD. Although it is listed as a required
dependency in `setup.py` (so the vast majority of users benefit from it), pyOCD can run without it
with minimal loss of functionality. The `pack` subcommand is disabled, which removes automatic
CMSIS-Pack download and management. But you can still use CMSIS-Packs manually with the `--pack`
option, as described in [Target support]({% link _docs/target_support.md %}).

To install pyOCD on such a system, you need to use the `pip install --no-deps` option. This will
install the core pyOCD package only, so all additional requirements must be manually installed.
You can either run `pip install` with an explicit list of the requirements from `setup.py`, or
copy those requirements to a requirements text file and run `pip install -r reqs.txt`. Of course,
be sure to exclude cmsis-pack-manager! (The requirements are not listed here lest they get out of
sync with `setup.py`.)

Once pyOCD is successfully installed, you will need to run it as a module using the `python`
executable as `python -mpyocd` rather than running the `pyocd` executable directly. This is because
the `pyocd` executable, which is auto-generated by the install process, verifies dependencies and
will error out due to the missing cmsis-pack-manager. But when run through `python`, dependencies
are not checked and pyOCD can handle the lack of cmsis-pack-manager gracefully.


## USB interfaces

The other dependencies that might be problematic are those for USB communications. pyOCD uses
three USB libraries:

- pyusb and libusb: CMSIS-DAPv1 on Linux, CMSIS-DAPv2 and STLink on all OSes
- hidapi: CMSIS-DAPv1 on macOS
- pywinusb: CMSIS-DAPv1 on Windows

Thankfully, libusb is provided by default on most Linux systems, including Raspberry Pi and similar
platforms. So on almost all platforms, USB is not a real problem.

If you are using an alternative OS, you may have trouble finding a functional USB library. In this
case, the options would be to port libusb and/or hidapi to your OS, or even to extend pyOCD with
support for another USB interface package.

