'''OpenGL extension APPLE.specular_vector

This module customises the behaviour of the 
OpenGL.raw.GL.APPLE.specular_vector to provide a more 
Python-friendly API

Overview (from the spec)
	
	An alternative specular lighting model is enabled by passing
	the LIGHT_MODEL_SPECULAR_VECTOR token as the <pname> parameter
	to LightModel, and TRUE as the <param> parameter.  The specular
	vector lighting model calculates the specular intensity as the
	dot product of the true reflection vector of the light source
	and the vector from the vertex to the viewpoint.  This yields
	results that are visually similar to but often more realistic
	than the existing lighting model.  
	
	Mathematically, the specular component s.n in the existing
	lighting model calculation is replaced with the following
	alternative calculation.
	
	Given three vectors, n, l, and p, where n is the unit normal
	vector at the vertex, l is the unit vector from the vertex to
	the light position, and p is the unit vector from the vertex
	to the viewpoint (or the vector {0,0,1} if
	LIGHT_MODEL_LOCAL_VIEWER is false), the specular component is
	given by
	
	  (2 * cross(n, cross(n, l)) + l) . p
	
	All other lighting model and material parameters (shininess,
	spotlight, attenuation, local viewer, and direction/positional
	sources) operate normally.  The specular vector lighting model
	affects both rgba and index modes.   

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/APPLE/specular_vector.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.APPLE.specular_vector import *
### END AUTOGENERATED SECTION
from OpenGL.GL import glget
glget.addGLGetConstant( GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE, (1,) ) # check size...