# UNICODE CHARACTER DATABASE
# This file was generated with the command:
#     generate_unicodedb.py --base=unicodedb_5_2_0 --output=unicodedb_11_0_0 --unidata_version=11.0.0

from rpython.rlib.rarithmetic import r_longlong


import unicodedb_5_2_0 as base_mod
version = '11.0.0'

#____________________________________________________________
# output from build_compression_tree

def trie_lookup(name):
    charnode = 0
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msb is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16
        stridx = parentstr & ((1 << 16) - 1)

        strlen = ord(_stringtable[stridx])
        substring = _stringtable[stridx+1:stridx+1+strlen]

        if codepoint != -1 and name == substring:
            return int(codepoint)
        if name.startswith(substring):
            name = name[strlen:]
            charnode = left
        else:
            charnode = right
    raise KeyError, name

def name_of_node(charnode):
    res = []
    prevnode = -1
    while 0 <= charnode < 0xffff: # 16bit number, 0xffff = None
        charnode *= 3
        leftright = _charnodes[charnode]
        parentstr = _charnodes[charnode + 1]
        codepoint = _charnodes[charnode + 2]

        if leftright < 0:
            # XXX assumes msg is sign
            left = 0x8000 | ((leftright & 0x7fffffff) >> 16)
        else:
            left = (leftright & 0x7fffffff) >> 16
        right = leftright & 0xffff

        if parentstr < 0:
            # XXX assumes msb is sign
            parent = 0x8000 | ((parentstr & 0x7fffffff) >> 16)
        else:
            parent = (parentstr & 0x7fffffff) >> 16

        if prevnode < 0 or prevnode == left:
            stridx = parentstr & ((1<<16)-1)
            strlen = ord(_stringtable[stridx])
            substring = _stringtable[stridx+1:stridx+1+strlen]
            res.append(substring)

        prevnode = charnode // 3
        charnode = parent

    res.reverse()
    return ''.join(res)


_stringtable = (
'\x01 '
'\x0f ALTERNATE FORM'
'\x0c ALTERNATING'
'\x05 AND '
'\n AND ARROW'
'\x1b AND LEFT SEMICIRCLE ARROWS'
'\x0c AND PICTURE'
'\x0b AND WRENCH'
'\r AND YEN SIGN'
'\x08 ANTENNA'
'\x07 ARROW '
') ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\n ARROWHEAD'
'\x08 AT DUSK'
'\x08 AT LEFT'
'\r BAT AND BALL'
'\x14 BEGIN LOGOGRAM MARK'
'\x06 BELOW'
'\x05 BENT'
'\x06 BLOCK'
'\x07 BUBBLE'
'\x07 BUTTON'
'\x17 CAKE WITH SWIRL DESIGN'
'\x10 CAPPED MOUNTAIN'
'\x04 CAR'
'\x08 CENTRED'
'\n CHARACTER'
'\x05 CHWV'
'\x07 CIRCLE'
'\x05 COAT'
'\n CONJOINED'
'\x0b DECORATION'
'\x14 DIRECTIONAL ISOLATE'
'\t DIVIDERS'
'\x07 DOUBLE'
'\x1d DOWN INDEX THUMB HOOK MIDDLE'
'\x02 E'
'\x06 EPOCH'
'\x05 FACE'
'\x06 FACE '
'\x08 FACING '
'\x06 FINAL'
'\x13 FLUTTERING IN WIND'
'\x12 FOR SIMALUNGUN SA'
'\x05 FUJI'
'\x05 GUNU'
'\t HITTING '
'\x05 HOOK'
'\x08 HUNDRED'
'\x05 ICON'
'\x10 IN BLACK SQUARE'
'\x0e IN SILHOUETTE'
'\x07 ISLAND'
'\x04 KEY'
'\x02 L'
'\x06 LARGE'
'\t LEERAEWA'
'\x07 LITTLE'
'\x0b LOCOMOTIVE'
'\x13 LOVE YOU HAND SIGN'
'\x07 MAELEE'
'\x07 MAEMBA'
'\x08 MAKSURA'
'\x05 MARK'
'\x05 MFON'
'\t MILLIONS'
'\n MODIFIER-'
'\t MOVEMENT'
'\x07 MUOMAE'
'\x02 N'
'\x03 NJ'
'\x12 NOT LITTER SYMBOL'
'\x07 OCLOCK'
'\x04 OF '
'\x0c OF ANTIMONY'
'\x0b OF FLOWERS'
'\x08 OF FOOD'
'\t OF PAPER'
'\r OF THE HORNS'
'\x08 OF YARN'
'\x05 OPEN'
'\x07 OPEN-O'
'\x04 ORE'
'\x04 OUT'
'\x0c OVER MIDDLE'
'\x0f OVER MOUNTAINS'
'\x11 OVER MUSH TIMES '
'\x16 OVER STAMPED ENVELOPE'
'\x11 OVER ZU PLUS SAR'
'\x02 P'
'\x03 PA'
'\x06 PLUS '
'\x0c PLUS KASKAL'
'\x12 PLUS PAP PLUS LU3'
'\x07 PLUS U'
'\x18 POINTING BACKHAND INDEX'
'\x04 POT'
'\x02 R'
'\x04 R S'
'\t RA OR RI'
'\x0c RING LITTLE'
'\x02 S'
'\x08 SATCHEL'
'\x07 SECANT'
'\n SEPARATOR'
'\x04 SET'
'\x06 SEVEN'
'\x05 SIDE'
'\x10 SMALL ROTATIONS'
'\t SPARKLER'
'\x06 SPLIT'
'\x12 SPREAD THUMB SIDE'
'\x05 STOP'
'\t STRAIGHT'
'\x07 SYMBOL'
'\x05 TABS'
'\x05 TENU'
'\t THOUSAND'
'\n THOUSANDS'
'\x06 THUMB'
'\x07 THUMB '
'\x0e THUMB FORWARD'
'\x12 THUMB INDEX THUMB'
'\x0b THUMB SIDE'
'\x0f THUMB STRAIGHT'
'\x08 TILTING'
'\x07 TIMES '
'\n TIMES KUR'
'\x0b TIMES TAK4'
'\x07 TO BAR'
'\x05 TONE'
'\x0f TOUCHING INDEX'
'\x05 TREE'
'\x02 U'
'\x04 U U'
'\x04 WEB'
'\x06 WITH '
'\t WITH BAR'
'\x11 WITH BULLET NOSE'
'\x10 WITH BUNNY EARS'
'\x19 WITH CANCELLATION STROKE'
'\x19 WITH CIRCLED ONE OVERLAY'
'\x12 WITH CROSSED-TAIL'
'\x16 WITH DECORATIVE COVER'
'\x0f WITH DIAERESIS'
'\t WITH DOT'
'\n WITH DOTS'
'\x15 WITH DOUBLE ORNAMENT'
'2 WITH EXCLAMATION MARK WITH LEFT RIGHT ARROW ABOVE'
'\n WITH FACE'
'\x0b WITH FLASH'
'\x0e WITH FLOURISH'
'\x17 WITH HALF-CIRCLE BELOW'
'& WITH INDEX AND MIDDLE FINGERS CROSSED'
'\r WITH INK PEN'
'\x0b WITH JACKS'
'\x12 WITH KAVYKA ABOVE'
'\n WITH LOW '
'\x14 WITH OBLIQUE STROKE'
'\x0e WITH ORNAMENT'
'\n WITH PAGE'
'\x12 WITH PALATAL HOOK'
'\x0b WITH PLATE'
'\n WITH RAIN'
'\n WITH RAYS'
'\n WITH RING'
'\x11 WITH SOUND WAVES'
'\x0b WITH STRAW'
'\x0c WITH STROKE'
'\x12 WITH VERTICAL BAR'
'\x19 WITH VERTICAL LINE BELOW'
'\x13 WITH VERTICAL TAIL'
'\x0b WITHIN DOT'
'\x0b WRIST FLEX'
'\x08 YUQ NAE'
'\x01-'
'\x02-2'
'\x02-A'
'\t-AMMONIAC'
'\x0b-COPPER ORE'
'\x08-EM DASH'
'\x08-HEADED '
'\t-LOW TONE'
'\x0c-MAIL SYMBOL'
'\t-MID TONE'
'\x0b-MOUTH FACE'
'\x07-MU-MO-'
'\x0f-NO-EVIL MONKEY'
'\x0b-OFF SYMBOL'
'\n-POINTING '
'\x0c-SHAPED SIGN'
'\x07-SHIFT-'
'\x07-THIRTY'
'\x010'
'\x050 BEE'
'\x040 BI'
'\x050 DOO'
'\x030 E'
'\x050 GBO'
'\x050 GEE'
'\x050 HAN'
'\x050 HEE'
'\x040 HO'
'\x050 JOO'
'\x040 JU'
'\t0 LONG LE'
'\x060 NGGI'
'\x060 NGGO'
'\x060 NYON'
'\x060 NYUN'
'\x040 PU'
'\x040 SA'
'\x030 W'
'\x040 YE'
'\x050-VAS'
'\x0600-102'
'\x04028B'
'\x0203'
'\x0208'
'\x011'
'\x031 A'
'\x041 BA'
'\x041 DO'
'\x051 FAN'
'\x041 GA'
'\x061 GBOO'
'\x041 HA'
'\x041 IN'
'\x041 KI'
'\n1 LONG MBE'
'\x061 NDEE'
'\x0e1 OVER LAK-081'
'\x041 PE'
'\x051 PEE'
'\x041 RA'
'\x041 SU'
'\x051 TEE'
'\x041 VU'
'\x051 WVI'
'\x031 X'
'\x041 YI'
'\x041 YO'
'\x051 YOO'
'\x031-2'
'\x051-VAS'
'\x0217'
'\x0218'
'\x012'
'\x022 '
'\x032 B'
'\x042 BU'
'\x052 HEN'
'\x052 HOO'
'\x042 KA'
'\x052 KPA'
'\x052 KPI'
'\x062 KPOO'
'\x042 L2'
'\n2 LONG MBO'
'\x052 MBA'
'\x052 MBE'
'\x062 MBOO'
'\x052 MBU'
'\x062 NGGU'
'\x052 NJA'
'\x052 NJU'
'\x052 POO'
'\x052 SEE'
'\x042 TI'
'\x082 TIMES '
'\t2 TIMES A'
'\x102 TIMES IGI GUNU'
'\n2 TIMES UD'
'\x042 VI'
'\x032 Y'
'\x042 YA'
'\x052-VAS'
'\x0320B'
'\x0222'
'\x0224'
'\x0726 EYYY'
'\x03272'
'\x013'
'\x053 BOO'
'\x033 D'
'\x043 EE'
'\x073 EIGHT'
'\x053 FOO'
'\x063 GBEE'
'\x063 HEEI'
'\x053 HIN'
'\x053 HON'
'\x033 I'
'\x043 JE'
'\x043 JO'
'\x043 KU'
'\x043 L3'
'\x043 LE'
'\x043 LO'
'\x0b3 LONG NGGO'
'\x053 NDI'
'\x063 NGGA'
'\x073 OMEGA'
'\x043 TA'
'\n3 TIMES ZA'
'\x053 VEE'
'\x053 WEI'
'\x043 YU'
'\x053-VAS'
'\x0230'
'\x0231'
'\x0331C'
'\x0532 JE'
'\x0236'
'\x0238'
'\x014'
'\x034 A'
'\x054 ABB'
'\x034 E'
'\x044 FI'
'\x054 GBI'
'\x064 KPEE'
'\x054 KPU'
'\x044 L4'
'\x054 LEE'
'\x054 LOO'
'\x054 MBO'
'\x054 MON'
'\x064 MUAN'
'\x054 NDO'
'\x064 NGEN'
'\x064 NJOO'
'\x064 NYIN'
'\x054 TOO'
'\x044 TU'
'\x054 VOO'
'\x044 WI'
'\x054 WOO'
'\x054 WUI'
'\x054-VAS'
'\x03408'
'\x0242'
'\x0248'
'\x0249'
'\x015'
'\x045 AN'
'\x045 BB'
'\x035 F'
'\x045 FA'
'\x045 FE'
'\x045 GI'
'\x045 IN'
'\x045 KE'
'\x055 KEE'
'\x045 LI'
'\t5 LONG JO'
'\x0b5 LONG MBOO'
'\x055 MBI'
'\x055 NDU'
'\x075 NGGEE'
'\x045 OO'
'\x045 TE'
'\x175 TIMES THREE DISH TENU'
'\x035 U'
'\x045 VA'
'\x045 VE'
'\x045 WA'
'\x045 WO'
'\x055-VAS'
'\x03533'
'\x03550'
'\x035B6'
'\x016'
'\x046 DI'
'\x046 FU'
'\x056 GBA'
'\x066 GUEI'
'\x036 H'
'\x046 HE'
'\x046 HI'
'\x046 HU'
'\x066 HUAN'
'\x056 KOO'
'\x046 L6'
'\x046 LA'
'\x0b6 LONG NGGE'
'\x0c6 LONG NGGOO'
'\x066 NGGE'
'\x076 NGGOO'
'\x046 PO'
'\x046 SE'
'\x056 SIA'
'\x056 SOO'
'\x056 WEE'
'\x046 WU'
'\x056-VAS'
'\x0262'
'\x0264'
'\x017'
'\x047 BE'
'\x047 DA'
'\x047 DD'
'\x047 EI'
'\x057 FUA'
'\x057 GBE'
'\x067 GUAN'
'\x057 HUN'
'\x037 J'
'\x057 JEE'
'\x047 LU'
'\x067 MBEE'
'\x067 MBUU'
'\x057 MIN'
'\x067 NDOO'
'\x057 NEN'
'\x077 NGGUA'
'\x067 NGON'
'\x077 NGUAN'
'\x057 NIN'
'\x037 O'
'\x047 VO'
'\x057-VAS'
'\x0270'
'\x0271'
'\x1479 OVER LAK-079 GUNU'
'\x018'
'\x048 BO'
'\x048 DU'
'\x048 EN'
'\x058 FEE'
'\x048 FO'
'\x058 GBU'
'\x048 GU'
'\x068 HOOU'
'\x048 JI'
'\x038 K'
'\x048 KO'
'\x058 KPE'
'\x058 KPO'
'\x058 MAN'
'\x068 MBEE'
'\x058 NAN'
'\x068 NYAN'
'\x068 NYEN'
'\x048 PI'
'\x048 WE'
'\x058-VAS'
'\x0280'
'\x0283'
'\x019'
'\x059 DEE'
'\x049 JA'
'\x059 KUA'
'\x059 MEN'
'\x069 MUEN'
'\x059 MUN'
'\x059 NDA'
'\x059 NDE'
'\x079 NGGAA'
'\x069 NJEE'
'\x059 NON'
'\x059 NUN'
'\x049 PA'
'\x049 SI'
'\x049 SO'
'\x049 TO'
'\x059 WVA'
'\x059 WVE'
'\x059 YEE'
'\x059-VAS'
'\x0290'
'\x0291'
'\x04914D'
'\x0292'
'\x03981'
'\x01A'
'\x02A '
'\x13A END LOGOGRAM MARK'
'\x06A MFON'
'\x0bA TENU GUNU'
'\x07A WITH '
'\x05A YUE'
'\x02A-'
'\x06A-KARA'
'\x02A4'
'\x07A6 TENU'
'\x02A7'
'\x03A7A'
'\x02AA'
'\x04AALI'
'\x03AAM'
'\x05AAMAE'
'\x05AARAE'
'\x06AASHAE'
'\x02AB'
'\x03AB2'
'\x03ABA'
'\nABATA TREE'
'\x12ABBREVIATION MARK '
'\x11ABBREVIATION SIGN'
'\x05ABIC '
'\x05ABOVE'
'\x03AC '
'\rACCOMMODATION'
'\x1cACE DIRECTION POSITION NOSE '
'\x07ACE OF '
'\x03ACK'
'\x04ACK '
'\x1fACK-TILTED SHADOWED WHITE ARROW'
'\x0bACKNOWLEDGE'
'\x16ACKSLANTED SOUTH ARROW'
'\x10ACTER TABULATION'
'\x05ACUTE'
'\x02AD'
'\x07AD NECK'
'\x18AD WITH THREE DOTS BELOW'
'\x04ADA '
'\x05ADULT'
'\x02AE'
'\x03AEA'
'\x03AEM'
'\x05AEMAE'
'\x05AEMLI'
'\x06AEMMAE'
'\x03AEN'
'\x08AEN NYAM'
'\x03AEP'
'\x05AEPEN'
'\x03AEQ'
'\x05AEREE'
'\x0bAESHAE NYAM'
'\x07AETMEUN'
'\x02AF'
'\x0eAFETY SCISSORS'
'\tAFFE FACE'
'\x06AFFIX '
'\x10AFFRICATION MARK'
'\x0cAFU LEERAEWA'
'\x03AG '
'\x04AGE '
'\x05AGGER'
'\x06AGOGUE'
'\x04AGON'
'\x0bAGONAL SIGN'
'\rAGRAPHUS MARK'
'\x02AH'
'\x16AH WITH TWO DOTS ABOVE'
'\x02AI'
'\x03AIN'
'\x04AIN '
'\tAINTBRUSH'
'\x04AIR '
'\x08AIRPLANE'
'\x1fAISED HAND WITH FINGERS SPLAYED'
'\rAISED KNUCKLE'
'\x0eAISED KNUCKLES'
'\x02AJ'
'\x02AK'
'\x03AK '
'\x06AK-668'
'\x0cAK4 PLUS SAG'
'\x0cAKAARAANSAYA'
'\x04AKER'
'\x06AKEUAE'
'\x08AKHA YAT'
'\x02AL'
'\x0bAL COMPUTER'
'\x07AL HORN'
'\x03ALE'
'\x05ALEPH'
'\x05ALETH'
'\x04ALF '
'\x0bALF-CIRCLE '
'\x05ALGAR'
'\x04ALIF'
'\x0fALIF LENGTHENER'
'\x04ALL '
'\x05ALLOT'
'\x03ALO'
'\x05ALPHA'
'\x08ALTERNAT'
'\nALTERNATE '
'\x13ALTERNATE LAKH MARK'
'\x0bALTERNATING'
'\x0cALTERNATING '
'\x06ALTIRE'
'\x02AM'
'\x12AM WITH DOUBLE BAR'
'\x04AMBA'
'\x07AME DIE'
'\tAME WITH '
'\x05AMEDH'
'\x03AMI'
'\x04AMMA'
'\rAMMA WITH DOT'
'\x06AMOND '
'\x06AMPIRE'
'\x0bAMUSED FACE'
'\x02AN'
'\x03AN '
'\rAN RUPEE SIGN'
'\x04AN X'
'\x03ANA'
'\x10ANABAZAR SQUARE '
'\x04ANAE'
'\x08ANAGARI '
'\x03AND'
'\x11AND BLACK SQUARES'
'\x0eAND COLD SWEAT'
'\x12AND LOW RIGHT RING'
'\x17AND WOMAN HOLDING HANDS'
'\x04ANDA'
'\nANDHI MARK'
'\nANDRABINDU'
'\x03ANG'
'\x05ANGE '
'\x05ANGEL'
'\x0cANGER BUBBLE'
'\tANGGEUAET'
'\x05ANGKA'
'\x07ANGKUOQ'
'\x05ANGLE'
'\x06ANGLED'
'\x07ANGLED '
'\x07ANGLONG'
'\x07ANGOLAT'
'\x04ANGU'
'\x04ANI '
'\x05ANNON'
'\x0fANS-SERIF ARROW'
'\tANTAYALAN'
'\x19ANTED NORTH ARROW WITH HO'
'\x0bANTIMONIATE'
'\x08ANTIMONY'
'\x08ANUSVARA'
'\x0eANUSVARA ABOVE'
'\x03AO '
'\x02AP'
'\x04APAQ'
'\x03APE'
'\x03APH'
'\x14APITAL H WITH STROKE'
'\x0eAPITAL LETTER '
'\rAPPED PRESENT'
'\x05APPLE'
'\x02AQ'
'\x02AR'
'\x0bAR A SIGN A'
'\x04ARAE'
'\x08ARCASITE'
'\x08ARCHAIC '
'\nARCHAIC II'
'\nARCHAIC YE'
'\x03ARD'
'\x15ARD SHELL FLOPPY DISK'
'\x07ARDSMAN'
'\x03ARE'
'\x03ARF'
'\nARFUL FACE'
'\x03ARK'
'\x03ARL'
'\x0bARM CIRCLE '
'\x18ARM CIRCLE HITTING WALL '
'\tARM CLOCK'
'\x0bARM SPIRAL '
'\x16ARMENIAN ETERNITY SIGN'
'\tAROSHTHI '
'\rARRED TRIDENT'
'\x08ARRIVING'
'\x05ARROW'
'\x12ARROW SHAFT WIDTH '
'\x0bARROW WITH '
'\nARROWHEAD '
'\x1cARROWHEAD IN A RECTANGLE BOX'
'\x03ARS'
'\x05ARTAR'
'\x17ARTY HORN AND PARTY HAT'
'\x04ARUM'
'\x04ARY '
'\x02AS'
'\x05ASAL '
'\x17ASCENDING MUSICAL NOTES'
'\x03ASH'
'\x17ASHTRA SIGN CANDRABINDU'
'\x05ASKAL'
'\nASPIRATION'
'\x03ASS'
'\x0bASS OF MILK'
'\x12ASTED SWEET POTATO'
'\x08ASTERISK'
'\x02AT'
'\nAT ON BONE'
'\x07AT SHOE'
'\x07AT SIGN'
'\x03ATA'
'\x08ATEBOARD'
'\x13ATED TELLER MACHINE'
'\x12ATERRESTRIAL ALIEN'
'\x07ATH OF '
'\x03ATI'
'\x08ATIKRAMA'
'\x05ATIN '
'\nATIN CROSS'
'\x12ATIN SMALL LETTER '
'\x14ATOLIAN HIEROGLYPH A'
'\tATTACHED '
'\x06ATURE '
'\x16ATURE OPEN ET ORNAMENT'
'\x02AU'
'\x0eAU LENGTH MARK'
'\x07AU MARK'
'\x03AUJ'
'\x03AUM'
'\x03AUS'
'\nAUTOMOBILE'
'\x02AV'
'\x08AVAGRAHA'
'\x04AVE '
'\x17AVOURING DELICIOUS FOOD'
'\x02AW'
'\x05AWAY '
'\x02AY'
'\x08AY-NIGHT'
'\x03AYD'
'\nAYER BEADS'
'\x04AYIN'
'\x03AYN'
'\x03AZU'
'\x01B'
'\x02B '
'\x0bB TIMES SHE'
'\x02BA'
'\x19BA ROTATED NINETY DEGREES'
'\nBA SATANGA'
'\x0cBACK OF HAND'
'\x0eBACKHAND INDEX'
'\x08BACKWARD'
'\x05BACUS'
'\x03BAD'
'\x03BAG'
'\x04BAGS'
'\x03BAH'
'\x06BAHAR2'
'\x03BAL'
'\x04BALD'
'\x04BALL'
'\rBALL AND HOOP'
'\rBALLPOINT PEN'
'\x03BAN'
'\x03BAR'
'\x18BAR WITH SHORT RIGHT LEG'
'\nBARB ARROW'
'\rBASAN LETTER '
'\x08BATAEAN '
'\x04BAYI'
'\x02BB'
'\x04BBIT'
'\x04BBON'
'\x10BBREVIATION SIGN'
'\x02BE'
'\x11BE WITH MERIDIANS'
'\x03BEE'
'\tBEER MUGS'
'\x03BEH'
'\tBEH WITH '
'\x0cBEHIND CLOUD'
'\x05BELOW'
'\x04BELT'
'\x04BENT'
'\x0fBENT OVER INDEX'
'\x08BER POLE'
'\x07BERGINE'
'\x03BET'
'\x06BETAN '
'\x04BETH'
'\x07BETWEEN'
'\x08BETWEEN '
'\x0cBETWEEN LIPS'
'\x13BETWEEN MIDDLE RING'
'\x14BETWEEN PALM FACINGS'
'\x06BGBIEE'
'\x03BHA'
'\x0eBHATTIPROLU AA'
'\tBIAL SIGN'
'\tBICYCLIST'
'\x0bBIDAKUON NG'
'\x08BIEE FON'
'\x07BIG YUS'
'\nBILE PHONE'
'\x08BILLIONS'
'\x05BINDU'
'\x0bBINDU BELOW'
'\x07BINING '
'\x08BINOVILE'
'\x0bBIRGA WITH '
'\x06BISCUS'
'\tBITE LIPS'
'\x16BKA- SHOG GI MGO RGYAN'
'\x06BLACK '
'\x0cBLACK CIRCLE'
'\x19BLACK CIRCLED WHITE ARROW'
'\nBLACK FLAG'
'\rBLACK OCTAGON'
'\x0eBLACK PENTAGON'
'\rBLACK SQUARES'
'\nBLACK STAR'
'\x03BLE'
'\x08BLE SIGN'
'\x10BLE WATER SYMBOL'
'\x18BLIC ADDRESS LOUDSPEAKER'
'\x06BLIMAT'
'\x06BLINK '
'\nBLOND HAIR'
'\x04BLOW'
'\x0cBLOWING FACE'
'\x05BLUE '
'\x0cBLUE DIAMOND'
'\x02BO'
'\x0fBOARD AND MOUSE'
'\x07BOARDER'
'\x04BOAT'
'\x10BOLD GREEK CROSS'
'\nBOLD SHAFT'
'\x11BOLD WHITE CIRCLE'
'\x06BOLD X'
'\x04BOOK'
'\x05BOOTS'
'\x08BOT FACE'
'\tBOTH BENT'
'\x06BOTTLE'
'\x15BOTTOM U-SHAPED ARROW'
'\rBOWING DEEPLY'
'\x03BOX'
'\x08BOX TRAY'
'\x02BR'
'\x03BRA'
'\x08BRA FACE'
'\x0cBRATION MODE'
'\x19BREVE WITH INVERTED BREVE'
'\x11BREW YOD TRIANGLE'
'\x11BRIGHTNESS SYMBOL'
'\x0fBROWS STRAIGHT '
'\x12BSERVER EYE SYMBOL'
'\x03BSP'
'\x05BSTER'
'\x02BU'
'\x03BUD'
'\x07BUFFALO'
'\x08BUILDING'
'\x07BULANCE'
'\x04BUNG'
'\x03BUR'
'\x06BURGER'
'\x03BUS'
'\x18BUSINESS SUIT LEVITATING'
'\x11BUT RELIEVED FACE'
'\x06BUTTON'
'\x0cBUTTON MOUSE'
'\x02BY'
'\x01C'
'\x02C '
'\x06C CLEF'
'\x06C SIGN'
'\x08C SIYAQ '
'\x02CA'
'\x0cCABBAGE-TREE'
'\x07CABINET'
'\x08CABLEWAY'
'\x03CAH'
'\x03CAI'
'\x04CAKE'
'\x05CAKES'
'\x05CAKRA'
'\x0cCALENDAR PAD'
'\x04CALL'
'\x06CAMERA'
'\x13CANCELLATION STROKE'
'\x06CANDRA'
'\x0cCANDRA ABOVE'
'\x0bCANDRABINDU'
'\x11CANDRABINDU ABOVE'
'\x04CANO'
'\x04CAP '
'\x0fCAPITAL LETTER '
'\x1cCAPITAL LETTER BOHAIRIC KHEI'
'\x12CAPITAL LETTER YOT'
'\x0fCAPITAL LETTERS'
'\x03CAR'
'\x05CARON'
'\x08CASSETTE'
'\x06CASTLE'
'\x08CAT FACE'
'\x0eCAT FACE WITH '
'\x19CAT FACE WITH CLOSED EYES'
'\x1aCAT FACE WITH SMILING EYES'
'\x05CCEPT'
'\x04CCHH'
'\x05CCOLI'
'\x02CE'
'\x03CE '
'\x0bCE OF PIZZA'
'\rCE OF WORSHIP'
'\x07CEILING'
'\x08CEILING '
'\x03CEL'
'\x06CENTRE'
'\x07CENTRE '
'\x07CENTRED'
'\x0eCEPTER OF JOVE'
'\x03CER'
'\x0eCERTAINTY SIGN'
'\x02CH'
'\x0bCH AND LAMP'
'\nCH BALLOON'
'\x10CH WITH UMBRELLA'
'\x03CHA'
'\x14CHARACTER INTRODUCER'
'\x0cCHARACTER-1B'
'\x05CHART'
'\x04CHAU'
'\x03CHE'
'\x05CHECK'
'\nCHECK MARK'
'\rCHECKER BOARD'
'\x05CHED '
'\x08CHEIKHAN'
'\x14CHEMICAL SYMBOL FOR '
'\x05CHEN '
'\x05CHERY'
'\x05CHEST'
'\x03CHI'
'\x05CHICK'
'\x07CHILLU '
'\x05CHIME'
'\x0bCHING CHICK'
'\x03CHO'
'\x05CHOOI'
'\x06CHRIVI'
'\rCHRONOUS IDLE'
'\x03CHU'
'\x04CIM '
'\x06CIRCLE'
'$CIRCLE CONTAINING BLACK SMALL CIRCLE'
'\x12CIRCLE NUKTA ABOVE'
'\x0fCIRCLE WITH DOT'
'\x08CIRCLED '
'\x1dCIRCLED SANS-SERIF DIGIT ZERO'
'\x13CIRCLED WHITE ARROW'
'\x0cCIRCLES AND '
'\x11CIRCLES WITH DOTS'
'\x0fCIRCUMFLEX AND '
'\rCITATION MARK'
'\x02CK'
'\x08CK CHART'
'\x07CK LIME'
'\x0cCK-O-LANTERN'
'\x05CKAGE'
'\x1dCKED FACE WITH EXPLODING HEAD'
'\x04CKEN'
'\nCKER BOARD'
'\x04CKET'
'\x0fCKET CALCULATOR'
'\x03CKS'
'\x05CKTIE'
'\x02CL'
'\x07CLEAVER'
'\x08CLIMBING'
'\x05CLONE'
'\x07CLOSE E'
'\x06CLOSED'
'\x0bCLOSED EYES'
'\x06CLOSET'
'\x07CLOTHES'
'\x05CLUBS'
'\x17CLUSTER-INITIAL LETTER '
'\x02CO'
'\x06CODILE'
'\x08COENG QA'
'\nCOLATE BAR'
'\nCOLD SWEAT'
'\x0bCOMBINATION'
'\x08COMBINED'
'\nCOMBINING '
'\x11COMBINING NUMBER '
'\x07COMING '
'\x05COMMA'
'\x1dCOMMA QUOTATION MARK ORNAMENT'
'\nCOMPONENT '
'\nCOMPONENT-'
'\x10COMPRESSED ARROW'
'\x08COMPUTER'
'\x10COND PLACE MEDAL'
'\x0bCOND SCREEN'
'\tCONJOINED'
'\nCONSONANT '
'\x10CONSONANT JOINER'
'\x0fCONSONANT SIGN '
'\x15CONSONANT SIGN COENG '
'\x16CONSONANT SIGN MEDIAL '
'\x18CONSONANT SIGN PASANGAN '
'\x07CONTACT'
'\x11CONTAINING BLACK '
'\x11CONTINUATION SIGN'
'\x12CONTINUING OVERLAP'
'\x04COON'
'\x06COPPER'
'\x12COPPER ANTIMONIATE'
'\x04CORE'
'\x04CORN'
'\tCORN FACE'
'$CORNER ARROWS CIRCLING ANTICLOCKWISE'
'\x05COVER'
'\x02CR'
'\x07CRACKER'
'\x06CRAYON'
'\x05CREAM'
'\x10CREAMING IN FEAR'
'\x0cCRESCENT BAR'
'\x14CRESCENT MOON SYMBOL'
'\tCRESCENTS'
'\x07CRIPT G'
'\x1aCRIPT LIGATURE ET ORNAMENT'
'\x05CROSS'
'\x06CROSS '
'\nCROSS MARK'
'\x15CROSSE STICK AND BALL'
'\x07CROSSED'
'\tCROSSED O'
'\x0cCROSSED-TAIL'
'\x15CRUCIFORM NUMBER FOUR'
'\x02CT'
'\x0bCTION MARK '
'\x0bCTION MARK-'
'\x06CTRIC '
'\x05CTURE'
'\x04CTUS'
'\rCULATED LORRY'
'\x06CUMBER'
'\x06CUMENT'
'\x12CUP WITHOUT HANDLE'
'\x06CUPPED'
'\x08CURLICUE'
'\x06CURLY '
'\nCURLY HAIR'
'\nCURLY LOOP'
'\x08CURSIVE '
'\x05CURVE'
'\x06CURVE '
'\x06CURVED'
'\x0bCURVED BEND'
'\x04CUSP'
'\x04CUTE'
'\nCY MESSAGE'
'\x04CYCL'
'\x01D'
'\x02D '
'\x08D BUBBLE'
'\x13D CIRCUMFLEX ACCENT'
'\x08D CROSS '
'\x0bD MIDDLE UP'
'\x16D PLUS GISH TIMES TAK4'
'\x06D SIGN'
'\x08D SYMBOL'
'\x11D TIMES DISH TENU'
'\x0cD TIMES ESH2'
'\x0eD-UP NEWSPAPER'
'\x02DA'
'\x07DA FACE'
'\nDA SATANGA'
'\nDA2 TIMES '
'\x03DAA'
'\x03DAD'
'\x03DAH'
'\x05DAIC '
'\x19DAL WITH THREE DOTS BELOW'
'\x06DALETH'
'\x0bDALETH-RESH'
'\x05DAMMA'
'\x08DAMMATAN'
'\x07DANCING'
'\x05DANDA'
'\x07DANESE '
'\x05DARA3'
'\x0bDASH SYMBOL'
'\x0cDASHED ARROW'
'\x05DBOAT'
'\x02DD'
'\x03DDA'
'\x04DDHI'
'\x05DDING'
'\x08DDY BEAR'
'\x02DE'
'\x18DE INVERTED BRIDGE BELOW'
'\x0bDE KIKAKUI '
'\nDE-HEADED '
'\nDECORATION'
'\nDED PERSON'
'\x03DEN'
'\tDENT AND '
'\x0bDENT EMBLEM'
'\x03DEO'
'\nDEOGRAPH A'
'\x16DEOGRAPHIC TALLY MARK '
'\tDEPARTURE'
'\x05DEPTH'
'\x03DER'
'\x03DES'
'\tDESCENDER'
'\x18DESCENDING MUSICAL NOTES'
'\x0bDESK PERSON'
'\x08DESTRIAN'
'\x06DGEHOG'
'\x04DGER'
'\x02DH'
'\x03DHA'
'\x05DHAM '
'\x03DHE'
'\x02DI'
'\tDIAERESIS'
'\x08DIAGONAL'
'\tDIAGONAL '
'\x0eDIAGONAL PATH '
'\x07DIAMOND'
'\x08DIAMONDS'
'\x04DIC '
'\rDIC MARK SIGN'
'\x06DIGIT '
'\x08DIM GUNU'
'\x0eDING CHARACTER'
'\x03DIO'
'\x0eDIO MICROPHONE'
'\x04DISC'
'\x04DISH'
'\x08DIT CARD'
'\x04DIUM'
'\x05DLING'
'\x03DNA'
'\x02DO'
'\x08DOCUMENT'
'\x03DOG'
'\x03DOI'
'\x0fDOING CARTWHEEL'
'\x0bDOLLAR SIGN'
'\x05DOLLS'
'\x03DON'
'\x03DOT'
'\x04DOT '
'\tDOT ABOVE'
'\x0eDOT ABOVE AND '
'\x08DOT REPH'
'\x10DOTTED CRESCENTS'
'\x06DOUBLE'
'\x07DOUBLE '
'\x0fDOUBLE ANUSVARA'
'\x1aDOUBLE BIRGA WITH ORNAMENT'
'$DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x10DOUBLE CRESCENTS'
'\x18DOUBLE HORIZONTAL STROKE'
'\x0bDOUBLE MARK'
'\x13DOUBLE MIDDLE TILDE'
'\x0fDOUBLE ORNAMENT'
'\x08DOUBLE R'
'\x0bDOUBLE RING'
'\x11DOUBLE RING ABOVE'
'\x0bDOUBLE SHAD'
'\x0fDOUBLE TRIANGLE'
'\x16DOUBLE-LINED HEAD MARK'
'\x04DOWN'
'\x05DOWN '
'\x1dDOWN MIDDLE THUMB INDEX CROSS'
'\x0cDOWN NEUTRAL'
'\x13DOWN POINTING INDEX'
'\x0fDOWN SEQUENTIAL'
'\tDOWN SIGN'
'\tDOWN STEP'
'\x16DOWN-POINTING TRIANGLE'
'\tDOWNWARDS'
'\nDOWNWARDS '
'\x0eDOWNWARDS AND '
'(DOWNWARDS AND UPWARDS OPEN CIRCLE ARROWS'
'\x0fDOWNWARDS ARROW'
'\x15DOWNWARDS ARROW ABOVE'
'\x0fDOWNWARDS TREND'
'\x06DPHONE'
'\x02DR'
'\x04DRAM'
'\tDRAM SIGN'
'\x05DRINK'
'\x07DU NJAA'
'\x0bDUATION CAP'
'\x03DUB'
'\x06DUCEUS'
'\x0cDUG TIMES NI'
'\x0eDUN3 GUNU GUNU'
'\x08DUSHENNA'
'\x08DVANTAGE'
'\x05DWICH'
'\tDY BEETLE'
'\x04DZHA'
'\x01E'
'\x02E '
'\x0eE BUTTON MOUSE'
'\x14E CONSONANT MODIFIER'
'\x07E GLASS'
'\x06E HOOK'
'\x11E LIGHT MOON ARTA'
'\x05E OF '
'\x08E OF POO'
'\x07E WITH '
'\x0cE WITH GRAVE'
'\x0bE WITH VEIL'
'\x02E-'
'\x02E2'
'\x0bE2 TIMES AN'
'\x03E80'
'\x02EA'
'\x04EAAE'
'\x03EAD'
'\x07EAD ORE'
'\x04EANS'
'\x0bEARS OF JOY'
'\x04EART'
'\x10EART-SHAPED EYES'
'\x05EARTH'
'\x05EAST '
'\x0eEAST POINTING '
'\x12EAST POINTING LEAF'
'\x16EAST-POINTING AIRPLANE'
'\x05EATH '
'\x0fEAVY CHECK MARK'
'\nECH BUBBLE'
'\x03ECK'
'\x06ECTION'
'\x0bECTION MARK'
'\x02ED'
'\x08ED BRICK'
'\x06ED CAP'
'\x07ED FACE'
'\x08ED FLAGS'
'\nED MIDDLE '
'\rED PAPERCLIPS'
'\x07ED RICE'
'\tED SYMBOL'
'\x0eED SYMBOL FOR '
'\nEDESTRIANS'
'\x05EDIC '
'\x0bEDICAL MASK'
'\x02EE'
'\x03EEE'
'\x04EEEE'
'\x03EEG'
'\x04EEJ '
'\x03EEM'
'\x04EEM '
'\x19EEM WITH THREE DOTS ABOVE'
'\x03EEN'
'\x03EEP'
'\x05EESHI'
'\x03EET'
'\x0bEEZING FACE'
'\x02EF'
'\tEFAIDRIN '
'\x06EFCASE'
'\x15EFT HORIZONTAL SECANT'
'\x1bEFT POINTING BACKHAND INDEX'
'\x14EFTWARDS ARROW WITH '
'\x02EH'
'\x08EH WITH '
'\x17EH WITH SMALL TEH ABOVE'
'\x02EI'
'\x05EIDON'
'\x05EIGHT'
'\x06EIGHT '
'\x07EIGHT K'
'\tEIGHT OF '
'\x15EIGHT SPOKED ASTERISK'
'\x06EIGHTH'
'\nEIGHTIETHS'
'\x06EIGHTY'
'\x03EIN'
'\x04EIPT'
'\x02EK'
'\x05EKEET'
'\x02EL'
'\x03ELD'
'\x19ELD HOCKEY STICK AND BALL'
'\x0cELECTED AREA'
'\x08ELEPHANT'
'\x0cELETION MARK'
'\x0bELLOW HEART'
'\x0bELTIC CROSS'
'\x04ELVE'
'\x02EM'
'\x07EM DASH'
'\x05EMBIC'
'\x0cEMELY HEAVY '
'\x08EMICOLON'
'\x05EMLJA'
'\x02EN'
'\x03EN '
'\x08EN NTEUM'
'\x06EN OF '
'\x0bEN STRAIGHT'
'\x0bEN THOUSAND'
'\x0bEN TWELFTHS'
'\x05ENCIL'
'\rENCY EXCHANGE'
'\x03END'
'\x04END '
'\x0eEND OF SECTION'
'\x10END OF TEXT MARK'
'\x05ENDAR'
'\x06ENIS F'
'\x05ENJET'
'\x0eENNA WITH BARS'
'\x06ENNANT'
'\x03ENS'
'\nENS SYMBOL'
'\x07ENSHUET'
',ENT ARROW POINTING DOWNWARDS THEN NORTH EAST'
'\x04ENTH'
'\nENTRY SIGN'
'\x04ENTY'
'\x12ENTY-TWO POINT TWO'
'\x08ENVELOPE'
'\x05EOPLE'
'\x08EOUT BOX'
'\x02EP'
'\x06EPACT '
'\x05EPAYA'
'\x03EPH'
'\x04EPHA'
'\x1cEPIGRAPHIC LETTER SIDEWAYS I'
'\x02EQ'
'\x08EQUENCE '
'\tEQUENTIAL'
'\x15EQUILATERAL ARROWHEAD'
'\x02ER'
'\x03ER '
'\x08ER BOARD'
'\x06ER MUG'
'\tER SYMBOL'
'\x03ERA'
'\x10ERCURY SUBLIMATE'
'\x08ERDIGRIS'
'\x04EREN'
'\rERIAL TRAMWAY'
'\x0fERICAN FOOTBALL'
'\x05ERIN2'
'\x05ERINE'
'\tERMOMETER'
'\x0eERN PENTATHLON'
'\x07ERNIN A'
'\x04ERSE'
'\x1aERSTRASS ELLIPTIC FUNCTION'
'\x03ERT'
'\x03ERU'
'\x02ES'
'\x03ES-'
'\x03ESC'
'\x0fESEL LOCOMOTIVE'
'\x03ESH'
'\rESH2 ASTERISK'
'\rESH2 PLUS LAL'
'\x03ESS'
'\x02ET'
'\x06ET KUT'
'\x05ET TU'
'\x03ETA'
'\x03ETE'
'\x0bETEI MAYEK '
'\x03ETH'
'\x04ETOS'
'\x06ETTER '
'\tETTI BALL'
'\x02EU'
'\x06EU MBU'
'\x04EUAE'
'\x05EUAEM'
'\x05EUAEN'
'\x06EUAENA'
'\x05EUAEQ'
'\x08EUFEUAET'
'\x03EUM'
'\x03EUN'
'\x0bEUNJOMNDEUQ'
'\x06EUNYAM'
'\x03EUQ'
'\x05EURAE'
'\x06EUREUT'
'\x04EURI'
'\tEURO SIGN'
'\rEUROPE-AFRICA'
'\x03EUT'
'\x03EUX'
'\nEVAL COMMA'
'\x04EVEN'
'\x08EVEN OF '
'\rEVEN TWELFTHS'
'\x13EVEN U VARIANT FORM'
'\x08EVENTEEN'
'\x06EVENTY'
'\x0cEVERING FACE'
'\x0eEVERSED OPEN E'
'\x0bEVERSED TSE'
'\x10EVERY OTHER TIME'
'\x02EW'
'\x06EWAYS '
'\x02EX'
'\x10EXCLAMATION MARK'
'\x19EXCLAMATION MARK ORNAMENT'
'\x0eEXCLAMATION OH'
'\x0bEXED BICEPS'
'\x06EXHALE'
'\x03EXT'
'\x06EXTRA-'
'\x02EY'
'\x03EYK'
'\nEZING FACE'
'\x01F'
'\x02F '
'\x10F WITH DOT BELOW'
'\rF WITH STROKE'
'\x02FA'
'\x04FACE'
'\nFACE WITH '
'\x07FACING '
'\tFACING UP'
'\x04FAIB'
'\x03FAJ'
'\x10FALLING DIAGONAL'
'\x03FAM'
'\x04FAST'
'\x05FATHA'
'\x0bFATHA WITH '
'\x08FATHATAN'
'\x07FATIGUE'
'\x02FE'
'\x04FEED'
'\x04FEEM'
'\x03FEH'
"'FEH WITH DOT BELOW AND THREE DOTS ABOVE"
'\x04FETH'
'\x08FETY PIN'
'\x04FEUQ'
'\x0eFFED FLATBREAD'
'\x0eFFICE BUILDING'
'\x02FI'
'\x05FIER '
'\x08FILE BOX'
'\x07FINAGH '
'\x05FINAL'
'\x06FINAL '
'\x0eFINAL ANUSVARA'
'\x14FINAL CONSONANT MARK'
'\x15FINAL CONSONANT SIGN '
'\rFINAL LETTER '
'\tFINAL NUN'
'\x08FINGER C'
'\x1bFINGER COVERING CLOSED LIPS'
'\x11FINGER-POST ARROW'
'\x0fFINGERS SPLAYED'
'\x04FIRE'
'\x0bFIRE ENGINE'
'\x04FIRI'
'\x04FISH'
'\x04FIST'
'\x04FIVE'
'\x05FIVE '
'\x13FIVE FINGERS SPREAD'
'\x14FIVE SPOKED ASTERISK'
'\x0cFLAG ON POST'
'\x05FLAME'
'\x03FLE'
'\x07FLEURON'
'\x11FLICK ALTERNATING'
'\x05FLOOR'
'\x06FLOOR '
'\x0bFLOORPLANE '
'\x10FLOORPLANE SPACE'
'\x13FLOORPLANE TWISTING'
'\x08FLOURISH'
'\x06FLOWER'
'\nFLUTTERING'
'\x04FO F'
'\x0cFOLDED HANDS'
'\x06FOLDER'
'\x03FOM'
'\x0fFOOTNOTE MARKER'
'\x08FOR STOP'
'\nFORMATION '
'\x06FORMEE'
'\x0cFORMING ARTS'
'\x06FORTIS'
'\x07FORWARD'
'\x0eFORWARD INDEX '
'\x0fFORWARD TILTING'
'\x0cFOUNTAIN PEN'
'\x04FOUR'
'\tFOUR BENT'
'\tFOUR DOTS'
'\nFOUR DOTS '
'\x0fFOUR DOTS WITH '
'\x0fFOUR ENCLOSURES'
'\x0cFOUR FINGERS'
'\x16FOUR FINGERS CONJOINED'
'\x1bFOUR FINGERS CONJOINED BENT'
'\x14FOUR RAISED KNUCKLES'
'\tFRACTION '
'\x11FRACTION ONE HALF'
'\x06FRAMES'
'\x0eFRANKS CASKET '
'\x07FRICAN '
'\x1cFROM BAR WITH HORIZONTAL BAR'
'\nFRONT WALL'
'\x05FROWN'
'\x08FROWNING'
'\rFROWNING FACE'
'\x02FT'
'\x03FT '
'\rFT ARROWHEAD '
'\x13FT-POINTING FLEURON'
'\x05FTEEN'
'\x03FTY'
'\x02FU'
'\x03FUE'
'\tFULL STOP'
'\x01G'
'\x06G FACE'
'\x08G TIMES '
'\x13G WITH CROSSED-TAIL'
'\x12G WITH TILDE ABOVE'
'\x02GA'
'\x03GAA'
'\nGAB TIMES '
'\x18GAF WITH INVERTED STROKE'
'\nGAGE CLAIM'
'\x03GAH'
'\x03GAI'
'\x05GALI '
'\x04GAME'
'\tGAN2 TENU'
'\nGAP FILLER'
'\x0bGAP FILLER-'
'\x05GAROO'
'\x07GATIVE '
'\x05GAZE-'
'\x02GB'
'\x05GBASA'
'\x06GBASAQ'
'\x05GBIEE'
'\x0cGBY FOOTBALL'
'\x02GC'
'\x06GDIAN '
'\x02GE'
'\x03GE '
'\x0bGE AT NIGHT'
'\x07GEMINAT'
' GEMINATION AND VOWEL LENGTH MARK'
'\x0fGEMINATION MARK'
'\x03GEN'
'\x07GENERAL'
'\x03GER'
'\x02GG'
'\x05GGER '
'\nGGING FACE'
'\x05GGLES'
'\x0fGGLY LINE BELOW'
'\x12GGLY VERTICAL LINE'
'\x02GH'
'\x03GHA'
'\x05GHAIN'
'\x06GHETTI'
'\x06GHEUAE'
'\x07GHEUGHE'
'\x05GHNUT'
'\x03GHT'
'\x1eGHT FOUR POINTED PINWHEEL STAR'
'\nGHT LIFTER'
'\x06GHTLY '
'\x02GI'
'\x13GIBBOUS MOON SYMBOL'
'\x06GICAL '
'\rGIFT ENVELOPE'
'\x05GIMEL'
'\x1fGIONAL INDICATOR SYMBOL LETTER '
'\x02GJ'
'\x07GLAGOLI'
'\x07GLASSES'
'\x03GLE'
'\x0cGLOTTAL STOP'
'\x02GN'
'\x03GN '
'\x0bGNANT WOMAN'
'\x02GO'
'\x06GOBLIN'
'\x05GOLAT'
'\x07GOLIAN '
'\x07GRADUAL'
'\x1cGRAPHIC CHARACTER INTRODUCER'
'\x06GRASP '
'\x05GRAVE'
'\x0bGREEK CROSS'
'\x02GU'
'\nGUA PI MAO'
'\x0cGUARDED AREA'
'\x03GUD'
'\x04GUIN'
'\x0eGUL JONGSEONG '
'\x05GULUS'
'\x0eGUNU TIMES ASH'
'\rGUNU TIMES HA'
'\x05GVANG'
'\x02GY'
'\x04GYAN'
'\x01H'
'\x0bH WITH HOOK'
'\x02HA'
'\tHA PLUS A'
'\x03HAA'
'\x03HAB'
'\x05HADDA'
'\x03HAH'
'\x0cHAH WITH DAL'
'\x03HAI'
'\tHAIKSUKI '
'\x04HAIN'
'\x12HAIS LUS NTOG NTOG'
'\x07HAJANI '
'\x06HAKING'
'\x0fHAKING PARALLEL'
'\x03HAL'
'\x04HALA'
'\x05HALA '
'\x07HALANTA'
'\x04HALF'
'\x05HALF '
'\x14HALF CIRCLE WITH DOT'
'\x08HALF GUR'
'\tHALF NOTE'
'\x05HALQA'
'\x06HAMEDH'
'\x05HAMZA'
'\x0bHAMZA ABOVE'
'\x03HAN'
'\x04HAND'
'\x13HAND COVERING MOUTH'
'\x0cHAND FORMAT '
'\tHAND SIGN'
' HAND WITH MIDDLE FINGER EXTENDED'
'\x1bHANDED INTERLACED PENTAGRAM'
'\nHANDS SIGN'
'\x0bHANG KHUDAM'
'\x04HAPH'
'\x03HAQ'
'\x03HAR'
'\x0bHAR2 TIMES '
'\x08HARBAHAY'
'\tHARD SIGN'
'\x06HARIOT'
'\x03HAT'
'\x03HAU'
'\x03HAV'
'\x0bHAWH HMONG '
'\x05HAYIN'
'\x02HD'
'\x02HE'
'\x03HEA'
'\tHEAD MARK'
'\x1bHEAD MARK WITH MOON AND SUN'
'\x0cHEAD-BANDAGE'
'\x07HEADING'
'\tHEADSCARF'
'\nHEADSTROKE'
'\x05HEART'
'\x11HEART-SHAPED EYES'
'\x06HEARTS'
'\x0bHEATED FACE'
'\x06HEAVY '
'\x10HEAVY BARB ARROW'
'\x0bHEAVY SHAFT'
'\x04HECK'
'\x05HECK '
'\x04HEEJ'
'\x06HEEKS '
'\x04HEEL'
'\x0bHEELED SHOE'
'\x04HEEM'
'\x04HEEN'
'\x03HEH'
'\x04HENG'
'\rHER CHRISTMAS'
'\nHERMOMETER'
'\x04HERO'
'\x04HERU'
'\x04HETH'
'\x05HEUAE'
'\x06HEUAEP'
'\x04HEYS'
'\x04HEYT'
'\x02HH'
'\x03HHA'
'\x02HI'
'\rHI TIMES ASH2'
'\x0cHIBITED SIGN'
'\rHIEROGLYPHIC '
'\x06HIEUKH'
'\x04HIGH'
'\x05HIGH '
'\x1fHIGH EXTRA-LOW CONTOUR TONE BAR'
'\x03HII'
'\x12HILOSOPHERS SULFUR'
'\x05HIMEL'
'\x03HIN'
'\x05HINGE'
'\x06HINGE '
'\x06HINGED'
'\tHINOCEROS'
'\x07HIOPIC '
'\x04HIP '
'\x0eHIRD-STAGE HLI'
'\x07HIRTEEN'
'\x05HIRTY'
'\x08HITTING '
'\x07HIUCHUS'
'\x06HIVETE'
'\x04HMI '
'\x15HOCKEY STICK AND PUCK'
'\x03HOI'
'\x03HOJ'
'\x05HOLUS'
'\x03HOM'
'\x04HOM '
'\x04HOOK'
'\x05HOOK '
'\x0fHOOKED INDEX UP'
'\x04HOOL'
'\x08HOP BELL'
'\x04HOPH'
'\x11HORIZONTAL SECANT'
'\x11HORIZONTAL STROKE'
'\x05HORSE'
'\x06HORT I'
'\x0eHORT RIGHT LEG'
'\x04HOST'
'\x05HOTEL'
'\x08HOULDER '
'\x08HOUSANDS'
'\x03HOX'
'\x04HREE'
'\x06HREE D'
'\tHREE DOTS'
'\nHREE DOTS '
'\x0cHREE FINGERS'
'\x08HREE OF '
'\x17HREE POINTED BLACK STAR'
'\rHREE TWELFTHS'
'\x14HREE-DOT NUKTA ABOVE'
'\x0eHREE-LEGGED TE'
'\x05HROOM'
'\x02HT'
'\x1eHT CENTRALIZATION STROKE BELOW'
'\x04HUB2'
'\x04HUET'
'\x04HUMB'
'\x05HUMP '
'\x07HUNDRED'
'\x12HUNDREDS UNIT MARK'
'\nHUNGARIAN '
'\x05HUTA '
'\x04HUVA'
'\x02HV'
'\tHWA WITH '
'\x04HWAH'
'\x02HY'
'\x06HYPHEN'
'\x01I'
'\x0eI AND SKI BOOT'
'\x06I GUNU'
'\x06I HOOK'
'\x07I NTEUM'
'\nI PLUS ZA7'
'\x06I SIGN'
'\x19I SYLLABLE ITERATION MARK'
'\x1dI TIMES ASH OVER HI TIMES ASH'
'\x0cI TIMES TAK4'
'\x07I WITH '
'\x02I-'
'\x05I-RES'
'\x02I2'
'\x03IAB'
'\rIAERESIS-RING'
'\x0bIAGE RETURN'
'\tIAL LINE '
'\x07IAMOND '
'\x18IAMOND CONTAINING BLACK '
'\x05IARDS'
'\x06IB YAM'
'\nIC LETTER '
'\x05ICAL '
'\x0cICE CONTROL '
'\tICE CREAM'
'\x08ICHAEAN '
'\x04ICK '
'\x05ICKET'
'\x0bICLOCKWISE '
'\x04ICON'
'\x07ICYCLES'
'\x02ID'
'\x03IDA'
'\x06IDDHAM'
'\x03IDE'
'\x03IDO'
'\x0bIDUOUS TREE'
'\x02IE'
'\nIED SHRIMP'
'\x03IEE'
'\x0bIEN MONSTER'
'\x03IES'
'\rIFI ROHINGYA '
'\x06IFTEEN'
'\x04IFTH'
'\x04IFTY'
'\x02IG'
'\x06IG YUS'
'\nIGATING RA'
'\x13IGATURE AYIN-DALETH'
'\nIGATURE OE'
'\x18IGATURE OPEN ET ORNAMENT'
'\x0cIGATURE SHRI'
'\x06IGGLES'
'\x04IGHT'
'\nIGHT ANGLE'
'\nIGHT RULER'
'\rIGHT TWELFTHS'
'\x13IGHT U VARIANT FORM'
'\x0fIGHT WITH STARS'
'\x17IGHT-SHADED WHITE ARROW'
'\x07IGHTEEN'
'\x10IGHTH NOTE STEM '
'\x03IGI'
'\x08IGI GUNU'
'\x05IGIT '
'\x06IGIT T'
'\x04IGN '
'\x15IGN INVERTED MCHU CAN'
'\tIGN NUKTA'
'\tIGN SAFHA'
'\nIGN SAMVAT'
'\tIGN TOMPI'
'\x12IGSAW PUZZLE PIECE'
'\x02IH'
'\x02II'
'\x03IKA'
'\x02IL'
'\x07IL DRUM'
'\tIL POLISH'
'\x05ILDE '
'\x13ILDING CONSTRUCTION'
'\nILE FOLDER'
'\x05ILED '
'\x04ILET'
'\x05ILVER'
'\x02IM'
'\x07IM GUNU'
'\nIMALUNGUN '
'\x04IMEL'
'\x05IMGBA'
'\x05IMMER'
'\x03IMN'
'\x03IMP'
'\x0bIMULTANEOUS'
'\x02IN'
'\x03IN '
'\x0cIN MIDDLE UP'
'\x18IN WITH THREE DOTS BELOW'
'\x05INAL '
'\tINAL NOTE'
'\tINARBORAS'
'\x10INDEPENDENT SHIN'
'\x1dINDEPENDENT VOWEL SIGN COENG '
'\x05INDEX'
'\x06INDEX '
'\nINDEX BENT'
'\x0cINDEX MIDDLE'
'\x12INDEX RING LITTLE '
'\x14INDEX RING LITTLE ON'
'\x1eINDEX THUMB CURVE THUMB INSIDE'
'\x10INDEX THUMB SIDE'
'\x08INDEX UP'
'\x04INDI'
'\x0eINDICTION SIGN'
'\x03INE'
'\x08INFINITY'
'\x03ING'
'\x04ING '
'\x08ING BELL'
'\x08ING BOWL'
'\x0eING HANDS SIGN'
'\x16ING HEAD IN SILHOUETTE'
'\tING HEART'
'\x0cING HITTING '
'\x06ING IN'
'\nING LITTLE'
'\x07ING OF '
'\x19ING ON THE FLOOR LAUGHING'
'\x07ING OUT'
'\x11ING POLE AND FISH'
'\x13ING SHIRT WITH SASH'
'\tING STONE'
'\x0eING TERMINATOR'
'\nING-SHIFT '
'\x04INGE'
'\x05INGED'
'\x10INGER-POST ARROW'
'\x06INGLE '
'\x06INHALE'
'\x08INITIAL '
'\x11INITIAL LETTER RA'
'\x05INNA '
'\x07INNABAR'
'\tINNYIIYHE'
'\x0eINOLOGICAL DOT'
'\x0eINSERTION SIGN'
'\x06INSIDE'
'\x0cINSIDE MOUTH'
'\x14INSIDE MOUTH RELAXED'
'\x14INTERROBANG ORNAMENT'
'\x04INU '
'\x0cINUSOID SIGN'
'\x08INVERTED'
'\x0eINVERTED BIRGA'
'\x14INVERTED BREVE BELOW'
'\x0fINVERTED LAZY S'
'\x11INVERTED MCHU CAN'
'\x04INY '
'\x03ION'
'\x08ION MARK'
'\x02IP'
'\x12IPLE MUSICAL NOTES'
'\x10IPPER-MOUTH FACE'
'\x18IPT LIGATURE ET ORNAMENT'
'\x02IQ'
'\x02IR'
'\x03IR2'
'\x05IRACY'
'\x05IRAMA'
'\x05IRCLE'
'\x10IRCLE FOR RECORD'
'\x06IRCLED'
'\rIRCLED INDEX '
'\x0bIRCLED TEXT'
'\x07IRCLES '
'\x14IRCLES HITTING WALL '
'\x07IRCLING'
'\x0eIRCULAR VIRAMA'
'\x05IRCUT'
'\x04IRON'
'\x08IRPLANE '
'\x06IRTEEN'
'\x04IRTY'
'\x03IRY'
'\x02IS'
'\x03ISA'
'\x03ISH'
'\rISH LIRA SIGN'
'\nISMUTH ORE'
'\x18ISOSCELES RIGHT TRIANGLE'
'\x13ISPUTED END OF AYAH'
'\x06ISSANT'
'\x0eISSION TICKETS'
'\x03IST'
'\x17ISTED RIGHTWARDS ARROWS'
'\x02IT'
'\nIT MBAAKET'
'\x03ITA'
'\x08ITA MFON'
'\x0eITALIC LETTER '
'\x04ITAR'
'\x0bITARY MEDAL'
'\x04ITE '
'\x0eITERATION MARK'
'\x16ITHI NUMBER SIGN ABOVE'
'\x03ITO'
'\x07ITTING '
'\x03IVE'
'\x04IVE '
'\x12IVE FINGERS SPREAD'
'\x17IVE FINGERS SPREAD OPEN'
'\x07IVE OF '
'\rIVE POINT ONE'
'\x13IVE SPOKED ASTERISK'
'\x0cIVE TWELFTHS'
'\x12IVE U VARIANT FORM'
'\x0bIVERY TRUCK'
'\x0cIVISION SIGN'
'\x02IW'
'\x03IWR'
'\x02IX'
'\x03IX '
'\x06IX OF '
'\x12IX SPOKED ASTERISK'
'\x0bIX TWELFTHS'
'\x11IX U VARIANT FORM'
'\x06IXTEEN'
'\x04IXTY'
'\x06IXTY P'
'\rIYA FRACTION '
'\x04IYAQ'
'\x05IYEOK'
'\x03IYO'
'\x08IZONTAL '
'\x01J'
'\x07J WITH '
'\x1aJ WITH DOT ABOVE AND TILDE'
'\x02JA'
'\x08JACK OF '
'\x03JAH'
'\x07JAIN OM'
'\x03JAM'
'\x07JARATI '
'\x03JAW'
'\x02JE'
'\x04JEEM'
'\x18JEEM WITH TWO DOTS ABOVE'
'\x05JERVI'
'\x03JHA'
'\x0bJIHVAMULIYA'
'\x04JIIM'
'\x1eJK COMPATIBILITY IDEOGRAPH-FA2'
'\x15JK UNIFIED IDEOGRAPH-'
'\x02JO'
'\x06JOINER'
'\x05JUDUL'
'\x01K'
'\x02K '
'\x0bK AND KNIFE'
'\tK GESTURE'
'\x0bK HAND SIGN'
'\x10K PERMITTED HERE'
'\x15K WITH OBLIQUE STROKE'
'\x02K-'
'\x05K-020'
'\x02KA'
'\nKA SATANGA'
'\x03KAD'
'\x03KAH'
'\x03KAK'
'\x04KAKO'
'\x04KALI'
'\x03KAM'
'\x04KAPH'
'\x03KAQ'
'\x05KARO '
'\x07KARO BA'
'\x05KAROR'
'\x06KASAR '
'\x06KASKAL'
'\x05KASRA'
'\x14KASRA WITH DOT BELOW'
'\x08KASRATAN'
'\tKATAKANA '
'\x03KAU'
'\x06KAVYKA'
'\rKAVYKA ABOVE '
'\x05KBALL'
'\x02KE'
'\x11KE BOTTLE AND CUP'
'\tKEN HEART'
'\x05KESH2'
'\x03KET'
'\x07KEUAERI'
'\x04KEUP'
'\x03KEY'
'\x08KEYBOARD'
'\x04KHAH'
'\x06KHINYA'
'\x05KHMU '
'\x02KI'
'\x06KILLER'
'\nKINDI MVOP'
'\tKING BOOT'
'\tKING FACE'
'\x04KINI'
'\x19KISIM5 TIMES U2 PLUS MASH'
'\x04KISS'
'\x04KMA '
'\x05KNIFE'
'\x05KNOBS'
'\x02KO'
'\x03KO '
'\x04KOKE'
'\x04KOKO'
'\x03KOM'
'\x07KPAK WA'
'\x04KPEN'
'\x0bKRAINIAN IE'
'\x0bKTAIL GLASS'
'\x05KTOP '
'\x03KU3'
'\x03KUE'
'\x13KULL AND CROSSBONES'
'\x03KUR'
'\x12KUSHU2 PLUS KASKAL'
'\x05KWAEN'
'\x06KY WAY'
'\tKYO TOWER'
'\x01L'
'\tL ME HAND'
'\x05L NET'
'\x0bL OF THREAD'
'\x07L WITH '
'\x10L WITH DESCENDER'
'\x1aL WITH DOUBLE MIDDLE TILDE'
'\x02LA'
'\x04LAAM'
'\x0bLABIAL SIGN'
'\x05LACK '
'\x18LACK CIRCLED WHITE ARROW'
'\nLACK JOKER'
'\x0bLACK SULFUR'
'\x0bLACKLETTER '
'\x11LAGOLITIC LETTER '
'\x03LAH'
'\x07LAK-050'
'\x04LAKH'
'\tLAKH MARK'
'\x03LAM'
'\x04LAM '
'\x04LAMA'
'\x06LAMEDH'
'\x07LAMITE '
'\tLAN SIGN '
'\x1aLANTED SOUTH ARROW WITH HO'
'\x03LAP'
'\x05LARGE'
'\x06LARGE '
'\x0cLARGE DOUBLE'
'\x1bLARGE EQUILATERAL ARROWHEAD'
'\x18LARGE TRIANGLE ARROWHEAD'
'\x0cLARGE TRIPLE'
'\x07LASHES '
'\x14LASHING SWEAT SYMBOL'
'\x03LAT'
'\x08LAT SIGN'
'\x06LATIN '
'\x15LATIN CAPITAL LETTER '
'\x08LATION X'
'\x03LAU'
'\x03LAW'
'\x08LAYALAM '
'\x04LBOX'
'\x0bLCE TSA CAN'
'\x02LD'
'\x03LD '
'\x06LD MAP'
'\x11LD PERMIC LETTER '
'\x0bLD SCRIPT X'
'\x08LD SWEAT'
'\tLD TAMIL '
'\x04LDER'
'\x02LE'
'\x19LE TENNIS PADDLE AND BALL'
'\x14LE WITH POPPING CORK'
'\x17LE WITH ROUNDED CORNERS'
'\x0cLEADING EYES'
'\x13LEADING MCHAN RTAGS'
'\x04LEAF'
'\x0bLEAF CLOVER'
'\x04LED '
'\x0bLEEP SYMBOL'
'\x05LEERI'
'\x03LEF'
'\x04LEFT'
'\x05LEFT '
'\nLEFT GUARD'
'\tLEFT HALF'
'\x0fLEFT HALF BELOW'
'\x0fLEFT HALF BLACK'
'\x0fLEFT HAND INDEX'
'\tLEFT HOOK'
'\x13LEFT POINTING INDEX'
'\x1fLEFT SEMICIRCLE WITH THREE DOTS'
'\nLEFT SERIF'
'\x13LEFT U-SHAPED ARROW'
',LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD'
'\x16LEFT-POINTING TRIANGLE'
'\x17LEFT-SHADED WHITE ARROW'
'\x14LEFT-TO-RIGHT SECANT'
'\tLEFTWARDS'
'\nLEFTWARDS '
'\x0eLEFTWARDS AND '
'\x0fLEFTWARDS ARROW'
'\x1fLEFTWARDS EQUILATERAL ARROWHEAD'
',LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW'
'*LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW'
'\x03LEI'
'\x0bLENGTH MARK'
'\x07LENGTH-'
'\x04LEPH'
'\x06LETTER'
'\x07LETTER '
'\x18LETTER CHA WITH TWO DOTS'
'\x0bLETTER LLLA'
'\x11LETTER MALAYALAM '
'\tLETTER MV'
'\x0eLETTER OVERLAP'
'\x08LETTER S'
'\x1aLETTER SMALL CAPITAL OMEGA'
'\x08LETTER Y'
'\nLETTER ZHA'
'\x07LETTERS'
'\x03LEU'
'\x0bLEU SATANGA'
'\x05LEVEN'
'\x0eLEVEN TWELFTHS'
'\x07LEYBALL'
'\x03LF '
'\rLF BLACK STAR'
'\x07LF FACE'
'\x04LFER'
'\x04LFIE'
'\x04LFUR'
'\x02LH'
'\x11LHOUETTE OF JAPAN'
'\x02LI'
'\x05LICE '
'\x0cLICKING LIPS'
'\x08LICOPTER'
'\x05LICUE'
'\x19LID QUILT SQUARE ORNAMENT'
'\x0bLIEVED FACE'
'\x04LIFI'
'\x10LIGHT BARB ARROW'
'\nLIGHT BULB'
'\x1bLIGHT CENTRALIZATION STROKE'
'\x1dLIGHT FOUR POINTED BLACK CUSP'
'\x07LIGHT X'
'\x0eLIGHTLY SMALL '
'\tLIGHTNING'
'\x0cLIMBS DIGITS'
'\x04LINE'
'\x05LINE '
'\x0bLINE FILLER'
'\x05LING '
'\x03LIP'
'\x04LIPS'
'\x0bLITH DIGIT '
'\x06LITTLE'
'\x07LITTLE '
'\tLITTLE UP'
'\x07LJUDIJE'
'\x02LL'
'\x0cLL MODIFIER-'
'\x03LLA'
'\tLLAR SIGN'
'\tLLEN LEAF'
'\x07LLEYBUS'
'\x06LLHORN'
'\x06LLIPOP'
'\x0eLLISION SYMBOL'
'\x03LLL'
'\x04LLLA'
'\x10LLOW PAN OF FOOD'
'\tLLY MARK '
'\x02LM'
'\x02LO'
'\x05LOAN '
'\x04LOCK'
'\rLOCK WITH KEY'
'\x03LON'
'\x04LONG'
'\nLONG FINAL'
'\x0fLONG HOOK BELOW'
'\tLONG TIP '
'\nLONG TSHEG'
'\x0eLONG-LEGGED DE'
'\x0fLOOK OF TRIUMPH'
'\x04LOOP'
'\x05LOOP '
'\x03LOS'
'\x06LOSED '
'\x0eLOTUS POSITION'
'\x04LOVO'
'\x03LOW'
'\x04LOW '
'(LOW DOUBLE COMMA QUOTATION MARK ORNAMENT'
'\x1fLOW EXTRA-HIGH CONTOUR TONE BAR'
'\nLOW KAVYKA'
'\x19LOW QUILT SQUARE ORNAMENT'
'\x1dLOW-REVERSED-9 QUOTATION MARK'
'\x05LOWER'
'\x10LOWER OVER UPPER'
'\x0cLOWERED FLAG'
'\x07LOZENGE'
'\x04LPHA'
'\x05LPHIN'
'\x02LT'
'\tLT SHAKER'
'\x0bLTED FLOWER'
'\tLTERNATE '
'\nLTERNATE U'
'\x05LTIRE'
'\x08LTRY LEG'
'\x02LU'
'\x03LU3'
'\x03LUB'
'\x07LUGGAGE'
'\x03LUM'
'\x05LURAL'
'\x05LWAY '
'\x02LX'
'\x01M'
'\x02M '
'\x06M FEED'
'\x0cM NSHUT NYAM'
'\x07M STONE'
'\x08M SYMBOL'
'\nM TIMES ME'
'\x07M WITH '
'\x0cM WITH TILDE'
'\x02MA'
'\x03MAA'
'\x07MAAYYAA'
'\x07MACHINE'
'\x0bMACING FACE'
'\x06MACRON'
'\x07MACRON '
'\x0bMACRON AND '
'\x10MACRON AND GRAVE'
'\x06MADDAH'
'\tMAEMGBIEE'
'\rMAILBOX WITH '
'\x05MAIZE'
'\x06MALGAM'
'\x04MALL'
'\x05MALL '
'\rMALL CAPITAL '
'\x0eMALL CAPITAL I'
'\x0cMALL LETTER '
'\x0cMALL SECTION'
'\x08MALL YUS'
'\x03MAN'
'\x08MANDARIN'
'\x03MAQ'
'\rMAR TIMES KUG'
'\x04MARK'
'\x05MARK '
'\tMARK CIM '
'\tMARK SHAD'
'\x0bMARWARI DDA'
'\x04MARY'
'\x04MASH'
'\x07MASSAGE'
'\x04MATO'
'\x03MAU'
'\x02MB'
'\x03MB '
'\x03MBA'
'\x03MBE'
'\x0bMBLER GLASS'
'\x16MBOL FOR MARKS CHAPTER'
'\x0bMBU LETTER '
'\x08MCHU CAN'
'\x02ME'
'\x08ME BADGE'
'\x04MED '
'\x0cMEDARY CAMEL'
'\x06MEDIUM'
'\x07MEDIUM '
'\x11MEDIUM BARB ARROW'
'\x0eMEDIUM DIAMOND'
'\x0cMEDIUM SHAFT'
'\rMEDIUM SQUARE'
'\x19MEDIUM TRIANGLE ARROWHEAD'
'\x04MEEM'
'\nMEEM ABOVE'
'\x1aMEEM WITH HAH WITH TATWEEL'
'\x04MEGA'
'\x04MEKH'
'\x05MELON'
'\x03MEM'
'\x08MEM-QOPH'
'\x11MEN HOLDING HANDS'
'\x07MENIAN '
'\x05MENOE'
'\x03MER'
'\x04MER '
'\tMER CLOCK'
'\x07MERICAS'
'\x04MFAA'
'\x0bMFON PIPAEM'
'\x0bMIC LETTER '
'\x04MID '
'\x08MID TONE'
'\x0eMID-LEVEL TONE'
'\x06MIDDLE'
'\x07MIDDLE '
'\x0bMIDDLE BENT'
'\x0bMIDDLE RING'
'\x12MIDDLE RING LITTLE'
'\x1cMIDDLE RING LITTLE CONJOINED'
'\x15MIDDLE RING LITTLE ON'
'\x0cMIDDLE TILDE'
'\tMIDDLE UP'
'\x04MIIM'
'\x04MIL '
'\x0bMILING EYES'
'\x11MILITARY AIRPLANE'
'\x08MILLIONS'
'\x04MILY'
'\rMINDER RIBBON'
'\x1eMINTON RACQUET AND SHUTTLECOCK'
'\nMINUS SIGN'
'\nMISMA SIGN'
'\x04MIZE'
'\x03MMA'
'\x02MO'
'\rMOBILE PHONES'
'\x1aMODIFIER FITZPATRICK TYPE-'
'"MODIFIER LETTER SHAN REDUPLICATION'
'\rMODIFIER MARK'
'\x03MON'
'\x04MONO'
'\x05MOON '
'\x0bMOON SELENA'
'\nMOTORCYCLE'
'\x08MOVEMENT'
'\x13MOVES AGAINST CHEEK'
'\x02MP'
'\rMPED ENVELOPE'
'\x11MPERSAND ORNAMENT'
'\x04MPET'
'\x06MPLING'
'\x05MSHAE'
'\x13MSHELL MOBILE PHONE'
'\x03MSP'
'\x18MTAVRULI CAPITAL LETTER '
'\x04MUAS'
'\x04MUCH'
'\x08MULTIPLE'
'\x11MUM LETTER PHASE-'
'\x04MUSH'
'\x08MY HOUSE'
'\x07MYSLITE'
'\x01N'
'\x02N '
'\nN NGGEUAET'
'\x11N PLUS KAK PLUS A'
'\x07N WITH '
'\x10N WITH LEFT HOOK'
'\x06N-NISF'
'\x16N-POTABLE WATER SYMBOL'
'\x02NA'
'\x0fNA DOUBLE HELIX'
'\tNA KHONNA'
'\x08NA METEK'
'\x03NAA'
'\x05NADA '
'\x04NAKE'
'\x04NAM2'
'\x03NAR'
'\x08NARROW O'
'\x0cNARROW SHAFT'
'\x05NASHI'
'\x03NAU'
'\x04NBOW'
'\x04NBSP'
'\x04NCER'
'\x03NCH'
'\tNCH FRIES'
'\x13NCTUS ELEVATUS MARK'
'\x02ND'
'\x0bND OF PIECE'
'\x15ND TELEPHONE RECEIVER'
'\x03ND-'
'\nNDA PA NJI'
'\tNDAILING '
'\x13NDRED POINTS SYMBOL'
'\x02NE'
'\x11NE EYEBROW RAISED'
'\x07NE FEED'
'\x13NE HUNDRED TWENTY P'
'\x04NED '
'\x08NED FOOD'
'\x05NEGAR'
'&NEGATIVE CIRCLED SANS-SERIF DIGIT ZERO'
'\x08NEIFORM '
'\x04NEMA'
'\x05NENOE'
'\x03NET'
'\x13NETWORKED COMPUTERS'
'\x07NEUTRAL'
'\x08NEUTRAL '
'\x03NEY'
'\x11NFORMATION SOURCE'
'\x02NG'
'\x0bNG LEFT LEG'
'\x14NG WITH CROSSED-TAIL'
'\x06NGBAT '
'\x03NGE'
'\x05NGENT'
'\x04NGER'
'\tNGER SHIP'
'\x05NGINE'
'\x04NGUE'
'\x05NGUE '
'\x02NI'
'\x03NIE'
'\tNIGHT OF '
'\x0bNIKOLSBURG '
'\x04NINE'
'\x08NINE OF '
'\rNINE TWELFTHS'
'\x13NINE U VARIANT FORM'
'\x08NINETEEN'
'\x06NINETY'
'\x05NING '
'\tNING MOOD'
'\rNING MOVEMENT'
'\x0bNITIAL IZHE'
'\x0cNJALA GONDI '
'\x04NJAM'
'\x03NJI'
'\x02NK'
'\x06NKING '
'\x06NKNOWN'
'\x02NN'
'\x03NNA'
'\x03NNI'
'\x06NNING '
'\x15NNIS RACQUET AND BALL'
'\x04NNNA'
'\x0fNO GOOD GESTURE'
'\x08NO THUMB'
'\x13NOGRAPHIC FULL STOP'
'\x04NOON'
'\x0fNOON WITH KASRA'
'\x0fNOON WITH KEHEH'
'\x06NORTH '
'\x0eNORTH ARABIAN '
'\x0cNORTHERN TSE'
'\x04NOSE'
'\x0cNOTCHED HOOK'
'\x0cNOTCHED TAIL'
'\x04NOTE'
'\x08NOTE PAD'
'\nNOTE WITH '
'\x06NOVILE'
'\x04NOWC'
'\x08NOWLEDGE'
'\x08NRES TOS'
'\x04NRUA'
'\x1dNS-SERIF INTERROBANG ORNAMENT'
'\x06NSANAQ'
'\x0bNSE CHEEKS '
'\x04NSHE'
'\x05NSIEE'
'\x07NSPLUTO'
'\x05NSUAE'
'\x02NT'
'\x14NT-FACING BABY CHICK'
'\x04NTAA'
'\x10NTAIGANA LETTER '
'\tNTESSENCE'
'\x05NTHA '
'\x0bNTIMONY ORE'
'\x05NTXIV'
'\x03NUB'
'\x05NUKTA'
'\x07NUMBER '
'\x11NUMBER MARK ABOVE'
'\x0bNUMBER SIGN'
'\x08NUMBER T'
'\x07NUMBERS'
'\rNUMERIC SIGN '
'\x03NUN'
'\x07NUSVARA'
'\x04NUTS'
'\x08NVERTED '
'\x03NYA'
'\x03NYI'
'\x03NYO'
'\x05NZEUM'
'\x01O'
'\x05O BOX'
'\tO HUNDRED'
'\x03O K'
'\tO LETTER '
'\x06O MARK'
'\x07O WITH '
'\x10O WITH DOT ABOVE'
'\x02O-'
'\x04OALA'
'\x03OAP'
'\x05OBILE'
'\x0eOBLIQUE STROKE'
'\x04OBRO'
'\x07OCALIC '
'\x08OCALIC M'
'\x07OCATION'
'\x03OCK'
'\x08OCK SALT'
'\x05OCKET'
'\x07OCTAGON'
'\x0cOCTET PRESET'
'\x08OCUS OF '
'\x02OD'
'\x03ODA'
'\x08ODESTONE'
'\x04ODLE'
'\x02OE'
'\x03OF '
'\x0bOF ENVELOPE'
'\nOF HYGIEIA'
'\x07OF SOAP'
'\x03OFF'
'\x07OFFICER'
'\x04OFUM'
'\x08OGOGRAM '
'\x0bOGONEK AND '
'\x19OGONEK AND DOT ABOVE AND '
'\x04OGRE'
'\x02OH'
'\x0bOHINGYA YEH'
'\x02OI'
'\x03OIL'
'\x06OITIC '
'\x04OJI '
'\x05OJKI '
'\x02OK'
'\x0cOK HAND SIGN'
'\tOKED HEAD'
'\tOKED TAIL'
'\x05OKEE '
'\x0cOKING SYMBOL'
'\x02OL'
'\x03OLD'
'\x04OLD '
'\x05OLDER'
'\x06OLIDUS'
'\x04OLIN'
'\nOLING FACE'
'\x03OLL'
'\x05OLLON'
'\rOLVING HEARTS'
'\x02OM'
'\x14OM HALF BLACK CIRCLE'
'\x08OM NTEUM'
'\x08OMANIAN '
'\x05OMBIE'
'\x17OMBINING ANUSVARA ABOVE'
'\x04OMBU'
'\x05OMEGA'
'\x0eOMING ENVELOPE'
'\x04OMMA'
'\x05OMMAE'
'\x03OMS'
'\x02ON'
'\x03ON '
'\x08ON CROSS'
'\x07ON FACE'
'\tON TEUAEQ'
'\x0fON TOP OF MODEM'
'\x0cON US SYMBOL'
'\x1eON WITH RIGHTWARDS ARROW ABOVE'
'\x03ONE'
'\x04ONE '
'\x08ONE DOT '
'\x0bONE HUNDRED'
'\x1bONE LARGE AND ONE SMALL EYE'
'\x10ONE QUARTER SIGN'
'\x0eONE SOUND WAVE'
'\tONE THIRD'
'\x19ONE UNDER EIGHTEEN SYMBOL'
'\x04ONE-'
'\x18ONE-HUNDRED-AND-SIXTIETH'
'\x04ONG '
'\tONG GRAVE'
'\x07ONGONAN'
'\x03ONI'
'\x0cONISHED FACE'
'\x08ONJOINED'
'\x0fONJOINED HINGED'
'\x16ONJOINING MACRON BELOW'
'\x06ONOCLE'
'\x1aONOMICAL SYMBOL FOR URANUS'
'\tONSONANT '
'\x11ONSONANT MODIFIER'
'\x06ONTACT'
'\x04ONTH'
'\x07ONTIEEN'
'\x03ONU'
'\x04ONUT'
'\x02OO'
'\x03OOI'
'\x03OOK'
'\x05OOKED'
'\x11OOKED SCHWA WITH '
'\x03OOL'
'\x06OOPED '
'\x1aOORPLANE SHOULDER HIP MOVE'
'\x02OP'
'\nOP NKAARAE'
'\x15OP SHADED WHITE ARROW'
'\x05OPARD'
'\x04OPEN'
'\x05OPEN '
'\x11OPEN CIRCLE ARROW'
'\x0fOPEN MARK BELOW'
'\nOPEN MOUTH'
'\tOPERATOR '
'\x03OPH'
'\x04OPOD'
'\x06OPPER '
'\x04OPUS'
'\x02OQ'
'\x03OQ '
'\x0cOQ NSHUT YUM'
'\x05OQPEN'
'\x02OR'
'\x17ORAH WITH NINE BRANCHES'
'\x05ORAIL'
'\x0eORANGE DIAMOND'
'\x04ORAX'
'\x04ORD '
'\rORD SEPARATOR'
'\x03ORE'
'\x08OREHEAD '
'\x07ORGIAN '
'\x08ORNAMENT'
'\x06ORNER '
'\x06ORNERS'
'\x04ORNS'
'\nOROME SIGN'
'\nORTHERN TA'
'\x07ORTIETH'
'\x04ORTY'
'\x02OS'
'\x04OSE '
'\x06OSETTE'
'\x06OSING '
'\x05OSTER'
'\x02OT'
'\nOT MACHINE'
'\x08OT MBUAE'
'\x07OT NGOM'
'\x07OTATED '
'\x07OTATION'
'\x04OTER'
'\x0eOTHERS CIRCLED'
'\tOTIFIED E'
'\nOTING STAR'
'\x07OTLESS '
'\x18OTTOM SHADED WHITE ARROW'
'\x18OTTOM-SHADED WHITE ARROW'
'\x04OTUS'
'\x02OU'
'\x06OUBLE '
'\x0bOUBLE DANDA'
'\x07OUBLE O'
'\x1bOUBLE RIGHT ARROWHEAD ABOVE'
'\x0cOUCHES THUMB'
'\x12OUCHTONE TELEPHONE'
'\rOUGHT BALLOON'
'\x05OUNCE'
'\x0bOUNDED FACE'
'\tOUNDED VE'
'\x03OUR'
'\x0bOUR FINGERS'
'\x15OUR FINGERS CONJOINED'
'\x05OUR K'
'\x0cOUR POINTED '
'\x12OUR POINTED BLACK '
'\x10OUR POINTED CUSP'
'\x0cOUR TWELFTHS'
'\x12OUR U VARIANT FORM'
'\x07OURTEEN'
'\x0bOUSEL HORSE'
'\x03OUT'
'\nOUT HANDLE'
'\nOUT INDEX '
'\rOUT MIDDLE UP'
'\tOUT MOUTH'
'\x05OUTH '
'\nOUTHERN TA'
'\x04OVAL'
'\x05OVER '
'$OVER LEFTWARDS TRIANGLE-HEADED ARROW'
'\x16OVER NU11 BUR OVER BUR'
'%OVER RIGHTWARDS TRIANGLE-HEADED ARROW'
'\x08OVER SHE'
'\x07OVERLAY'
'\x02OW'
'\x03OW '
'\x07OW ALEF'
'\x0fOW-FALLING TONE'
'\x03OWD'
'\nOWEL SIGN '
'\x03OWN'
'\rOWN POINTING '
'\x03OX '
'\x02OY'
'\x07OYSTICK'
'%OZENGE CONTAINING BLACK SMALL LOZENGE'
'\x01P'
'\x02P '
'\tP ELAMITE'
'\x07P PIEET'
'\nP STREAMER'
'\x17P WITH EXCLAMATION MARK'
'\x02PA'
'\rPA NJI PIPAEM'
'\x04PACE'
'\x12PACING CANDRABINDU'
'\x04PAGE'
'\x03PAH'
'\rPAIRED ARROWS'
'\x08PAKPAK E'
'\x0cPALATAL HOOK'
'\x04PALM'
'\x03PAN'
'\x07PANESE '
'\x03PAP'
'\tPAP PLUS '
'\x0cPAP PLUS LU3'
'\x0cPAP PLUS PAP'
'\x15PAP PLUS PAP PLUS LU3'
'\x04PARA'
'\x05PARAQ'
'\x0ePARATED SYMBOL'
'\x07PARATOR'
'\x08PARATOR '
'\x0cPARENTHESES '
'\x11PARENTHESES ABOVE'
'\x0bPARENTHESIS'
'$PART BETWEEN MIDDLE AND RING FINGERS'
'\x0ePARTMENT STORE'
'\nPASSIMBANG'
'\x06PBOARD'
'\x02PE'
'\x0cPE CARTRIDGE'
'\x06PEAKS '
'\x04PEEI'
'\x19PEH WITH SMALL MEEM ABOVE'
'\x0ePEN MARK BELOW'
'\tPEN MOUTH'
'\x05PEN O'
'\x07PENNANT'
'\x0fPENSION RAILWAY'
'\tPENTAGRAM'
'\x06PEPPER'
'\x03PER'
'\x1fPER RIGHT SHADOWED WHITE CIRCLE'
'\x07PERCLIP'
'\x06PERSON'
'\x03PES'
'\x04PEUX'
'\x02PH'
'\x04PHAB'
'\x05PHANT'
'\x05PHONE'
'\x06PHONE '
'\x05PHORA'
'\x02PI'
'\x06PICKET'
'\x07PICTURE'
'\x04PING'
'\x05PING '
'\rPINWHEEL STAR'
'\x05PIRIT'
'\x07PITULUM'
'\x0bPLACE MEDAL'
'\x0bPLACEHOLDER'
'\x10PLACEHOLDER MARK'
'\rPLE CRESCENTS'
'\nPLE DAGGER'
'\tPLE HEART'
'\x08PLE LEAF'
'\x0ePLE WITH HEART'
'\x04PLET'
'\x05PLHAU'
'\x19PLICATION PROGRAM COMMAND'
'\x07PLOYAN '
'\x04PLUG'
'\x05PLUS '
'\tPLUS SIGN'
'\x05PLUTA'
'\x05PMUNK'
'\x02PO'
'\x08POINTED '
'\x12POINTED BLACK STAR'
'\tPOINTING '
'\x13POINTING DOWNWARDS '
'\x19POINTING MAGNIFYING GLASS'
'\x06POKOJI'
'\nPOLICE CAR'
'\x04POLO'
'\x06POMMEE'
'\x0ePOMOFO LETTER '
'\x03POQ'
'\x0cPORT CONTROL'
'\x12POSITION INDICATOR'
'\tPOSITIONS'
'\x0bPOST OFFICE'
'\nPOUND SIGN'
'\x0cPOUTING FACE'
'\x02PP'
'\x0ePPED MIDDLE UP'
'\x06PPING '
'\nPPOPOTAMUS'
'\x08PPY DISK'
'\x1bPPY PERSON RAISING ONE HAND'
'\tPREFIXED '
'\x11PRESSIONLESS FACE'
'\x06PRINTS'
'\tPROJECTOR'
'\x0ePROTECTED AREA'
'\x02PS'
'\x07PSTICKS'
'\x04PTY '
'\x02PU'
'\x08PUB DAWB'
'\x06PUFFED'
'\x0bPUNCTUATION'
'\x0cPUNCTUATION '
'\x12PUNCTUATION BINDU '
'\x1dPUNCTUATION CHINOOK FULL STOP'
'#PUNCTUATION SIGN DIAGONAL QUADCOLON'
'\x03PUQ'
'\x07PUSHPIN'
'\x0bPUT MORTUUM'
'\x0fPUT SYMBOL FOR '
'\x06PWATCH'
'\x01Q'
'\x02QA'
'\x04QAAF'
'\x03QAF'
'\x12QAF WITH DOT BELOW'
'\x03QAR'
'\x02QE'
'\x04QHAU'
'\x03QIF'
'\x03QIG'
'\x04QOPH'
'\x02QU'
'\x03QUA'
'\x13QUADRUPLE CRESCENTS'
'\x1eQUALS SIGN WITH INFINITY BELOW'
'\x06QUARE '
'\x0cQUARED ARROW'
'\x07QUARTER'
'\x08QUARTER '
'\x0bQUARTER GUR'
'\rQUARTER MOON '
'\x12QUARTER NOTE STEM '
'\x08QUARTERS'
'\tQUEEN OF '
'\x07QUEEZE '
'\x0bQUERED FLAG'
'\rQUESTION MARK'
'\x16QUESTION MARK ORNAMENT'
'\x03QUI'
'\x08QUINTILE'
'\x01R'
'\tR COASTER'
'\x07R PLUS '
'\x03R S'
'\x06R WITH'
'\x10R WITH RIGHT LEG'
'\x0eR-OFF CALENDAR'
'\x05R-RUB'
'\x07R2 GUNU'
'\x02RA'
'\x03RA '
'\x0bRA SOMPENG '
'\x03RAA'
'\x06RACING'
'\x03RAE'
'\x0cRAFFIC LIGHT'
'\x0eRAGANA LETTER '
'\x03RAH'
'\x04RAIL'
'\x07RAILWAY'
'\x04RAIN'
'\x0bRAISED FLAG'
'\x0eRAISED KNUCKLE'
'\x0fRAISED KNUCKLES'
'!RAISING BOTH HANDS IN CELEBRATION'
'\x04RAL '
'\x04RAMA'
'\x04RAN '
'\nRANG CITI '
'\x0bRANSMISSION'
'\x07RANTHA '
'\x03RAT'
'\x15RATING SYSTEM COMMAND'
'\x13RATUM SUPER STRATUM'
'\x03RAU'
'\x06RAVEL-'
'\x04RAYS'
'\x05RAYS '
'\x10RAYS AND DOTTED '
'\x02RB'
'\x02RC'
'\x07RCHAIC '
'\x08RCHAIC E'
'\tRCHAIC SA'
'\x07RD DISK'
'\x07RD FACE'
'\x0eRD PLACE MEDAL'
'\nRDHACANDRA'
'\x02RE'
'\tREAK HERE'
'\x0fREAMY EYEBROWS '
'\x16REASE FONT SIZE SYMBOL'
'\x11REATIONAL VEHICLE'
'\x08RECEIVER'
'\nRECIPITATE'
'\x0fRECITATIVE MARK'
'\x08RECT HIT'
'\tRECTANGLE'
'\x04RED '
'\nRED CIRCLE'
'\x08RED HAIR'
'\tRED JOKER'
'\x0cRED KEYBOARD'
'\x0cRED TRIANGLE'
'\x03REE'
'\x0bREE HUNDRED'
'\x16REE-CIRCLE ALTERNATE I'
'\x13REE-QUARTER CIRCLE '
'\tREFORMED '
'\nREFORMED T'
'\x05REGIA'
'\x03REH'
'\x03REI'
'\x07RELAXED'
'\x15RELICT HOUSE BUILDING'
'\x06REMEDY'
'\x0cREN CROSSING'
'\x10REPETITION MARK-'
'\x04RESH'
'\nRESH BELOW'
'\tRESH-AYIN'
'\x10RESH-AYIN-DALETH'
'\x07RESSION'
'\x17RETROFLEX HOOK AND BELT'
'\x03REU'
'\x0fREVERSE SOLIDUS'
'\nREVERSED I'
'\x0cREVERSED TSE'
'\x0eREVERSED-SCHWA'
'\x03REX'
'\x04RFER'
'\x18RGLASS WITH FLOWING SAND'
'\x03RHO'
'\x02RI'
'\x03RI '
'\x07RIANGLE'
'\x06RIBBON'
'\x04RICE'
'\x04RICK'
'\x06RIDENT'
'\tRIED FACE'
'\x05RIEEN'
'\x04RIFY'
'\x05RIGHT'
'\x06RIGHT '
'\x10RIGHT ARROWHEAD '
'\x0bRIGHT GUARD'
'\nRIGHT HALF'
'\x10RIGHT HALF BELOW'
'\x10RIGHT HALF BLACK'
'\x17RIGHT HORIZONTAL SECANT'
'\x1dRIGHT POINTING BACKHAND INDEX'
'\x14RIGHT POINTING INDEX'
'\nRIGHT RING'
' RIGHT SEMICIRCLE WITH THREE DOTS'
'\x1bRIGHT SHADOWED WHITE CIRCLE'
'\x14RIGHT U-SHAPED ARROW'
'+RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD'
'\x16RIGHT-POINTING FLEURON'
'\x17RIGHT-POINTING TRIANGLE'
'\nRIGHTWARDS'
'\x0bRIGHTWARDS '
'\x0fRIGHTWARDS AND '
'\x10RIGHTWARDS ARROW'
'\x16RIGHTWARDS ARROW WITH '
' RIGHTWARDS EQUILATERAL ARROWHEAD'
'\x03RII'
'\x05RILLA'
'\x07RILLIC '
'\x08RILLIONS'
'\x03RIM'
'\x06RIN2 X'
'\x04RING'
'\x05RING '
'\nRING ABOVE'
'\x0bRING LITTLE'
'\x15RING LITTLE CONJOINED'
'\x0eRING MEGAPHONE'
'\nRING THUMB'
'\x07RINKLES'
'&RIOUS FACE WITH SYMBOLS COVERING MOUTH'
'\x19RIPLE BIRGA WITH ORNAMENT'
'\tRIPLE DOT'
'\x07RIPPLE '
'\x05RIPT '
'\tRIS FORM '
'\x04RISE'
'\x0fRISING DIAGONAL'
'\x0bRISING TONE'
'\x12RIST CIRCLE FRONT '
'\x19RIST CIRCLE HITTING WALL '
'\x0cRISTMAS TREE'
'\x05RITSI'
'\x04RITU'
'\rRIZONTAL TAIL'
'\x17RK SIDEWAYS NOON GHUNNA'
'\rRK SUNGLASSES'
'\nRKING FACE'
'\x03RKL'
'\x06RLICUE'
'\x03RMT'
'\x18RMUKHI ABBREVIATION SIGN'
'\x02RO'
'\x03RO '
'\x06ROCKET'
'\x0cROLLING EYES'
'\x03ROM'
'\x05RONOS'
' RONT-TILTED SHADOWED WHITE ARROW'
'\x06ROPLET'
'\x04ROSS'
'\x03ROT'
'\x14ROTATED ARDHAVISARGA'
'\rROTATED BIRGA'
'\x16ROTATED NINETY DEGREES'
'\x08ROTATION'
'\tROTATION-'
'\nROUNDED ER'
'\x05RPION'
'\x02RR'
'\x03RRA'
'\x05RRED '
'\nRRIS WHEEL'
'\x05RRITO'
'\x04RROW'
'\x11RROW SHAFT WIDTH '
'\x04RRRA'
'\x08RSE DUNG'
'\x06RSENIC'
'\x04RSO-'
'\x02RT'
'\rRTABLE STEREO'
'\tRTS MEDAL'
'\x03RTY'
'\x02RU'
'\x04RUDA'
'\nRUDIMENTA '
'\x05RULAI'
'\x05RULER'
'\x05RUMP-'
'\nRUPEE MARK'
'\x02RY'
'\x07RY FACE'
'\x01S'
'\x02S '
'\x0fS IN SILHOUETTE'
'\x12S INSIDE AND ABOVE'
'\x12S PRESSED TOGETHER'
'\x11S REVOLVING LIGHT'
'\x06S SHOE'
'\x08S SYMBOL'
'\rS UP TOGETHER'
'\x07S-SAJDA'
'\x08S-SERIF '
'\x02SA'
'\x07SA VAH '
'\x03SAA'
'\x03SAD'
'\x05SADHE'
'\x03SAH'
'\x05SAKIN'
'\x05SAKTA'
'\x05SALAD'
'\nSALIZATION'
'\x08SALT OF '
'\x0fSALTER PAHLAVI '
'\x07SALTIRE'
'\x06SANDAL'
'\x07SANDHI '
'\x0bSANDHI MARK'
'\x10SANS-SERIF ARROW'
'\x0bSAPPOINTED '
'\x03SAR'
'\x0cSARAM GONDI '
'\x05SARGA'
'\x03SAU'
'\x06SAUCER'
'\nSCENT MOON'
'\x05SCHWA'
'\x07SCOOTER'
'\x05SCOPE'
'\x08SCRIPT X'
'\x02SE'
'\x03SE '
'\x08SE WEDGE'
'\x06SECANT'
'\x0cSECTION MARK'
'\x0cSECTION SIGN'
'\x04SED '
'\x04SEEV'
'\rSELECTED AREA'
'\nSELINE ESH'
'\x08SENTAGON'
':SENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRACKET'
'\tSEPARATOR'
'\nSEPARATOR '
'\x0eSEPARATOR MARK'
'\x12SEPTUPLE CRESCENTS'
'\x13SEQUENCE INTRODUCER'
'\nSEQUENTIAL'
'\x07SERPINA'
'\x03SET'
'\x12SET OVER BUILDINGS'
'\x02SH'
'\x03SH '
'\x15SH AMPERSAND ORNAMENT'
'\x0bSH PLUS SHU'
'\x1bSH TIMES GISH CROSSING GISH'
'\x03SH2'
'\x11SH2 CROSSING ESH2'
'\x03SH3'
'\x03SHA'
'\tSHAB CEEB'
'\x04SHAD'
'\x04SHAE'
'\x05SHAKE'
'\x07SHAKING'
'\x08SHAN SAW'
'\x17SHAPE WITH A DOT INSIDE'
'\x0bSHE AT LEFT'
'\tSHED FACE'
'\x05SHELL'
'\x11SHELL FLOPPY DISK'
'\x04SHES'
'\rSHESH PLUS KI'
'\x0eSHESHIG TIMES '
'\x11SHESHIG TIMES BAD'
'\x13SHHA WITH DESCENDER'
'\x03SHI'
'\x07SHIFT T'
'\x04SHIM'
'\x04SHIN'
'\x05SHIRT'
'\nSHMIRI YEH'
'\x06SHORT '
'\x08SHORT ER'
'\x05SHPIN'
'\rSHTIN TIMES U'
'\x03SHU'
'\x04SHU '
'\x04SHU2'
'\x04SHUL'
'\x02SI'
'\rSIA-AUSTRALIA'
'\x07SIDDHAM'
'\x04SIDE'
'\x05SIDE '
'\x15SIDE TO SIDE SCISSORS'
'\x0eSIDE-DOWN FACE'
'\x04SIGN'
'\x05SIGN '
'\x0fSIGN COMBINING '
'\x11SIGN O WITH CROSS'
'\x0cSIGN SIDDHAM'
'\x07SIGN UD'
'\x0bSIGN VIRAMA'
'\x03SII'
'\x06SINGLE'
'$SINGLE COMMA QUOTATION MARK ORNAMENT'
'\x03SIU'
'\tSIVE FACE'
'\x03SIX'
'\x08SIX DOTS'
'\tSIXTEENTH'
'\nSIXTEENTHS'
'\x13SLANTED NORTH ARROW'
'\x05SMALL'
'\x06SMALL '
'\x0cSMALL DOUBLE'
'\rSMALL LETTER '
'\x1aSMALL LETTER BOHAIRIC KHEI'
'\x0eSMALL LETTER D'
'\rSMALL LETTERS'
'\x10SMALL NOON ABOVE'
'\x12SMALL RED TRIANGLE'
'\nSMALL TAH '
'\x0cSMALL TRIPLE'
'\tSMALL YUS'
'\x05SMILE'
'\x0cSMILING EYES'
'\x0cSMILING FACE'
'\x0eSMOKING SYMBOL'
'\x04SNOW'
'\tSOFT SIGN'
'\x08SOFTNESS'
'\x08SOGDIAN '
'\x07SOLDIER'
'\x05SOLVE'
'\x0eSONAL COMPUTER'
'\x06SOUTH '
'\x0cSOUTHERN TSE'
'\x07SOV ROG'
'\x02SP'
'\x06SPADES'
'\x06SPAPER'
'\x03SPE'
'\rSPEECH BUBBLE'
'\x0eSPEECH BUBBLES'
'\x0bSPEED TRAIN'
'\x05SPINE'
'\x06SPITAL'
'\x06SPLIT '
'\x0fSPOKED ASTERISK'
'\x03SQU'
'\x06SQUARE'
'\x08SQUARED '
'\x07SQUARES'
'\x08SQUEEZED'
'\x02SS'
'\x03SSA'
'\rSSAGE WAITING'
'\x0bSSANGKIYEOK'
'\rSSANGYESIEUNG'
'\x03SSI'
'\x1aSSIAN ASTROLOGICAL SYMBOL '
'\x0fSSICAL BUILDING'
'\x06SSLESS'
'\x04SSOM'
'\x04SSUS'
'\x02ST'
'\x03ST '
'\nST PALETTE'
'\x10ST QUARTER MOON '
'\x07ST TUBE'
'\nST-FEEDING'
'\tSTAL BALL'
'\x04STAR'
'\x14STAR WITH MIDDLE DOT'
'\x0bSTEAMY ROOM'
'\tSTEBASKET'
'\tSTER FACE'
'\x0cSTICKING OUT'
'\x10STICKING OUT FAR'
'\x07STITUTE'
'\x06STLERS'
'\x05STNUT'
'\x04STOL'
'\x08STRAIGHT'
'\tSTRAIGHT '
'\x11STRAIGHT MOVEMENT'
'\x10STRAIGHT STRETCH'
'\x13STRAIGHT THUMB BENT'
'\x06STRING'
'\x06STROKE'
'\x0cSTROKE BELOW'
'"STRONG CENTRALIZATION STROKE BELOW'
'\x0eSTRONG ISOLATE'
'\x06STROOM'
'\nSTRUCTION '
'\x03STU'
'\x10STUCK-OUT TONGUE'
'\x02SU'
'\x04SUAB'
'\x1bSUBLINEAR COLON SKEWED LEFT'
'\x04SUCK'
'\x06SUCKED'
'\x05SURYA'
'\x03SUU'
'\x08SWIMMING'
'\x0bSWIRL BIRGA'
'\tSYLLABLE '
'\nSYLLABLE M'
'\x18SYLLABLE REPETITION MARK'
'\x06SYMBOL'
'\x13SYMBOL FOR BEGINNER'
'\x0bSYMBOL VIDJ'
'\x07SYMBOLS'
'\x01T'
'\x02T '
'\x0cT ABOVE LEFT'
'\nT AND BOLT'
'\x07T ASHES'
'\x1cT LITTER IN ITS PLACE SYMBOL'
'\x0cT MONGKEUAEQ'
'\x08T NGGEET'
'\x06T NJAQ'
'\x05T OF '
'\tT OF MEAT'
'\x10T TRANSMIT STATE'
'\x07T WITH '
'\x02TA'
'\x0eTA LINK ESCAPE'
'\nTABULATION'
'\x0cTACKED COMMA'
'\x06TAGRAM'
'\x03TAH'
'\nTAI LAING '
'\x10TAI LAING DIGIT '
'\x0fTAI LAING TONE-'
'\x04TAK4'
'\x0eTAKANA LETTER '
'\nTAMAN SIGN'
'\x03TAN'
'\x08TAR EYES'
'\x06TARGET'
'\x06TATED '
'\x03TAW'
'\x04TAXI'
'\nTCOIN SIGN'
'\x02TE'
'\rTE ORDER MARK'
'\x06TE USE'
'\x0cTEARS OF JOY'
'\rTED HAND SIGN'
'\x03TEE'
'\x04TEEN'
'\x07TELLITE'
'\x0eTELPIECE CLOCK'
'\x03TEN'
'\x05TENSE'
'\x04TENU'
'\x03TER'
'\x0eTERMINAL MARK-'
'\x0cTERNATE AYIN'
'\x04TERY'
'\x06TEUWEN'
'\x04TEXT'
'\x04TFON'
'\x02TH'
'\tTH GLOBE '
'\x0bTH-THALATHA'
'\nTHDAY CAKE'
'\x0bTHEMATICAL '
'\x0eTHER CHRISTMAS'
'\x15THICK LETTER SELECTOR'
'\x05THIRD'
'\x0cTHLETIC SHOE'
'\x0eTHOUGHT BUBBLE'
'\x08THOUSAND'
'\tTHOUSANDS'
'\x0eTHOUSANDS MARK'
'\x06THREE '
'\nTHREE DISH'
'\x0cTHREE HEARTS'
'\x0eTHREE POINTED '
'\x0eTHREE QUARTERS'
'\x11THREE SOUND WAVES'
'\x0fTHROWING A KISS'
'\x05THUMB'
'\x06THUMB '
'\rTHUMB FORWARD'
'\nTHUMB SIDE'
'\x07THUMBS '
'\x02TI'
'\x11TIAL ARTS UNIFORM'
'\x04TIC '
'\x06TICAL '
'\nTICAL DISC'
'\x04TICK'
'\x0bTIEE SHEUOQ'
'\x0bTIGHT ACUTE'
'\x13TIGHTLY-CLOSED EYES'
'\x05TILDE'
'\x05TILES'
'\x04TILL'
'\x04TILT'
'\x12TILTING FROM WAIST'
'\x06TIMES '
'\tTIMES KUR'
'\x08TIMES UD'
'\x04TIN '
'\x05TING '
'\nTING HEART'
'\x0bTION BOTTLE'
'\x0bTIONAL PARK'
'\x04TIP '
'\x0fTIP ON THE LEFT'
'\x08TIRRUP R'
'\x06TITLO '
'\x03TIU'
'\x03TLE'
'\x06TLESS '
'\x02TO'
'\x06TO BAR'
'\x08TO FORM '
'\x0fTO-LEFT ISOLATE'
'\x10TO-RIGHT ISOLATE'
'\x03TOM'
'\x04TONE'
'\x05TONE '
'\x06TONGUE'
'\tTOP RIGHT'
'\x12TOP U-SHAPED ARROW'
'\x0cTOP-LIGHTED '
'\x03TOR'
'\x05TORCH'
'\x07TORNADO'
'\x05TORSO'
'\x04TORT'
'\x04TORY'
'\x15TOUCHING INSIDE MOUTH'
'\x13TOUCHTONE TELEPHONE'
'\x03TOV'
'\x08TOWARDS '
'\x02TR'
'\x03TRA'
'\x05TRACK'
'\x0bTRAIGHT WAW'
'\x14TRAILING MCHAN RTAGS'
'\x03TRE'
'\tTREDECILE'
'\nTREFACTION'
'\tTRETCHED '
'\x03TRI'
'\x08TRI DISH'
'\x0bTRIAN CAMEL'
'\x08TRIANGLE'
'\x12TRIANGLE ARROWHEAD'
'!TRIANGLE WITH DOUBLE VERTICAL BAR'
'\x10TRIANGLE-HEADED '
'\x15TRIANGLE-HEADED ARROW'
'!TRIANGLE-HEADED OPEN CIRCLE ARROW'
'\x06TRIKE '
'\x05TRING'
'\x05TRIOL'
'\x06TRIPLE'
'\x07TRIPLE '
'\x10TRIPLE CRESCENTS'
'\x0cTRIPLE FLAME'
'\x03TRO'
'\x05TROKE'
'\x05TROL '
'\x07TROLLEY'
'\x05TSEEB'
'\x05TSHEG'
'\x02TT'
'\x03TTA'
'\x03TTE'
'\x0cTTED SOLIDUS'
'\x05TTER '
'\x07TTERFLY'
'\x03TTH'
'\x04TTTA'
'\x02TU'
'\x03TUB'
'\x03TUJ'
'\x0bTUNE COOKIE'
'\x06TURBAN'
'\x05TURN '
'\x07TURNED '
'\nTURNED AYB'
'$TURNED COMMA QUOTATION MARK ORNAMENT'
'\x08TURNED M'
'\x13TURNED SECTION MARK'
'\x06TUXEDO'
'\x07TWELFTH'
'\x0fTWELVE POINTED '
'\nTWENTIETHS'
'\x03TWO'
'\x04TWO '
'\x08TWO DOTS'
'\tTWO DOTS '
'\x0eTWO ENCLOSURES'
'\x0bTWO FINGERS'
'\nTWO THIRDS'
'\x02TY'
'\x0bTY THOUSAND'
'\x07TYSCAPE'
'\x04TZEL'
'\x01U'
'\x02U '
'\nU CIN HAU '
'\x06U MBIT'
'\x13U OVER BU TIMES NA2'
'\x08U TIMES '
'\x05U U U'
'\x07U WITH '
'\x10U WITH LEFT HOOK'
'\x02U-'
'\x07U-BRJGU'
'\x12U-SHAPED ORNAMENTS'
'\x04U11 '
'\x03U2 '
'\x08U2 PLUS '
'\nU2 PLUS BA'
'\x02U3'
'\x03UAE'
'\x04UAEM'
'\x04UAEN'
'\x04UAEP'
'\x06UAEQTU'
'\x04UAET'
'\x03UAM'
'\nUAM TSHOOJ'
'\x06UANGXI'
'\x02UB'
'\x03UB '
'\x10UBJOINED LETTER '
'\x0eUBJOINED SIGN '
'\x08UBJOINER'
'\x04UBLE'
'\x08UBLE DOT'
'\x13UBLE DOT WITHIN DOT'
'\x17UBLE VERTICAL BAR BELOW'
'\x0cUBLE-STRUCK '
'\x16UBSCRIPT SMALL LETTER '
'\x11UCASIAN ALBANIAN '
'\x04UCH '
'\x06UCIBLE'
'\x02UD'
'\x08UD WITH '
'\x08UDAWADI '
'\x10UDLY CRYING FACE'
'\x02UE'
'\x03UE '
'\tUE MAEMBA'
'\rUE OF LIBERTY'
'\x03UEQ'
'\x0bUETTE BREAD'
'\x02UG'
'\tUG TIMES '
'\x06UGGAGE'
'\x07UGGLING'
'\x04UGU '
'\x02UH'
'\x0cUH PLUS GISH'
'\x02UI'
'\x04UIRY'
'\x0bUISHED FACE'
'\x08UKEUTNDA'
'\x03UKU'
'\x04UKUN'
'\x03UKY'
'\x02UL'
'\x05ULAR '
'\x07ULATION'
'\x07ULCANUS'
'\x03ULL'
'\tULL MOON '
'\x08ULL STOP'
'\x03ULT'
'\x02UM'
'\x03UM '
'\tUM TIMES '
'\x12UM WITH DRUMSTICKS'
'\x08UMBRELLA'
'\x05UMBS '
'\x02UN'
'\x07UN MEUT'
'\x0cUNBLENDED UK'
'\x03UND'
'\x05UNDER'
'\x06UNDER '
'\x1aUNEVEN EYES AND WAVY MOUTH'
'\x03UNG'
'\x06UNGAAM'
'\x05UNGBA'
'\tUNGLASSES'
'\x02UO'
'\x03UOM'
'\x03UOQ'
'\x02UP'
'\x03UP '
'\x10UP MIDDLE HINGED'
'\nUP NEUTRAL'
'\nUP OR DOWN'
'\x1aUP POINTING BACKHAND INDEX'
'\x11UP POINTING INDEX'
'\x07UP SIGN'
'\x17UP SPREAD THUMB FORWARD'
'\x07UP STEP'
'\rUP TACK ABOVE'
'\x14UP-POINTING TRIANGLE'
'\x0bUPADHMANIYA'
'\x05UPPED'
'\x0eUPPED INDEX UP'
'"UPPER BODY TILTING FROM HIP JOINTS'
'\x10UPPER OVER LOWER'
'\x07UPWARDS'
'\x08UPWARDS '
'\x0cUPWARDS AND '
'\rUPWARDS ARROW'
'\x13UPWARDS ARROW WITH '
'\rUPWARDS TREND'
'\x02UQ'
'\x03UQA'
'\x05UQUET'
'\x02UR'
'\x03UR '
'\nUR HUNDRED'
'\x06UR OF '
'\x07URFACE '
'\x05URINE'
'\nURIPIGMENT'
'\x03URL'
'\x06URNAMA'
'\x11URNED DAMMA BELOW'
'\tURNED GAN'
'&URNED SWIRL BIRGA WITH DOUBLE ORNAMENT'
'\x08UROPEAN '
'\x04URVE'
'\x05URVE '
'\x05URVED'
'\x06URVED '
'\x02US'
'\x07US TENT'
'\x0cUSEATED FACE'
'\tUSED FACE'
'\x03USH'
'\x04USH '
'\nUSHED FACE'
'\x07USHENNA'
'\x06USHPIN'
'\x0eUSPENSION MARK'
'\x06USTER-'
'\x02UT'
'\x03UT '
'\x04UTAE'
'\nUTBOX TRAY'
'\x05UTEUX'
'\x04UTH '
'\nUTH OR SPY'
'\x0bUTING WHALE'
'\tUTRA MARK'
'\nUTRAL FACE'
'\x04UTTY'
'\x02UU'
'\x02UX'
'\x01V'
'\x07V BELOW'
'\x07V WITH '
'\x02VA'
'\x07VAGRAHA'
'\x03VAH'
'\x07VAPOURS'
'\x07VARIANT'
'\x03VAU'
'\x02VD'
'\x02VE'
'\x03VE '
'\nVE HUNDRED'
'\x0bVE OF PEACE'
'\tVE THUMB '
'\x07VED ICE'
'\x04VEDE'
'\x0eVEDIC ANUSVARA'
'\x03VEE'
'\nVEL SLIDER'
'\x0cVELOPE WITH '
'\x07VEMENT-'
'\rVEN POINT ONE'
'\x0eVENIENCE STORE'
'\x03VER'
'\rVERGREEN TREE'
'\x07VERTED '
'\x08VERTICAL'
'\x0cVERTICAL BAR'
'\x13VERTICAL BAR VIRAMA'
'\rVERTICAL BARS'
'\x13VERTICAL LINE BELOW'
'\x0fVERTICAL SECANT'
'\x0fVERTICAL STROKE'
'\x0bVERTICALLY '
'\x15VERY HEAVY BARB ARROW'
'\x10VERY HEAVY SHAFT'
'\x0bVERY SMALL '
'\x12VERY SMALL DIAMOND'
'\x11VERY SMALL SQUARE'
'\x03VES'
'\x03VEU'
'\tVEUAENGAM'
'\x04VEUM'
'\x04VEUX'
'\x04VEYZ'
'\x03VHA'
'\x02VI'
'\x0cVICTORY HAND'
'\nVIE CAMERA'
'\x10VIEWING CEREMONY'
'\tVIGINTILE'
'\x07VILLAIN'
'\x03VIN'
'\tVINE LEAF'
'\x05VING '
'\x06VIRAMA'
'\x07VISARGA'
'\x06VISION'
'\x05VITAE'
'\x04VIYO'
'\x02VO'
'\x06VOCADO'
'\x08VOCALIC '
'\tVOCALIC R'
'\x11VOCALIZATION MARK'
'\x07VOICING'
'\x08VOLAPUK '
'\x08VOMITING'
'\x03VOP'
'\x04VOS '
'\x06VOWEL '
'\x07VOWEL K'
'\x11VOWEL LENGTH MARK'
'\x10VOWEL LENGTHENER'
'\x0bVOWEL SIGN '
'\x05VRIDO'
'\x02VS'
'\x02VU'
'\x04VUEQ'
'\x03VY '
'\x01W'
'\x08W PRINTS'
'\x0cW RIGHT RING'
'\x02WA'
'\x03WAA'
'\x04WAEN'
'\x04WAET'
'\nWALLPLANE '
'\x1bWALLPLANE SHOULDER HIP MOVE'
'\x0fWALLPLANE SPACE'
'\x05WAQFA'
'\x04WARD'
'\x06WARDS '
'&WARDS AND LEFTWARDS OPEN CIRCLE ARROWS'
'\x1bWARDS EQUILATERAL ARROWHEAD'
'\x04WAVE'
'\x10WAVY HAMZA BELOW'
'\x03WAW'
'\x13WAW WITH DOT WITHIN'
'\rWAW-AYIN-RESH'
'\x03WAY'
'\x02WB'
'\x06WBERRY'
'\x05WBOAT'
'\x08WBOY HAT'
'\x02WC'
'\x04WDER'
'\x02WE'
'\x0bWE PALAUNG '
'\x05WELVE'
'\x18WELVE POINTED BLACK STAR'
'\x08WENTIETH'
'\x05WENTY'
'\x03WER'
'\x04WER '
'\x11WER PLAYING CARDS'
'\x05WEST '
'\x0eWEST POINTING '
'\x12WEST POINTING LEAF'
'\x05WFISH'
'\x06WHITE '
'\x0cWHITE ARROW '
'%WHITE ARROW WITHIN TRIANGLE ARROWHEAD'
'\nWHITE FLAG'
'\x17WHITE FOUR POINTED CUSP'
'\nWHITE HAIR'
'\x0bWHITE JOKER'
'\x0cWHITE SQUARE'
'\nWHOLE NOTE'
'\x02WI'
'\x04WIDE'
'\x07WIDE ES'
'\x05WIDTH'
'\x07WIFRUIT'
'\x06WINDOW'
'\nWING HEART'
'\tWING STAR'
'\x04WINK'
'\x0bWINKING EYE'
'\x05WISE '
'\x04WITH'
'\x05WITH '
'\x06WITH C'
'\x08WITH DOT'
'\tWITH FACE'
'\x0bWITH GARDEN'
'\x12WITH JUSTIFICATION'
'\x10WITH LEFT UPTURN'
'\x1aWITH LEFTWARDS ARROW ABOVE'
'\x1dWITH RIGHTWARDS ARROW AT LEFT'
'\nWITH SERIF'
'\x10WITH SMALL CLOUD'
'\nWITH SPOON'
'\x18WITH UPWARDS ARROW ABOVE'
'\nWITH WINGS'
'\x19WITHIN TRIANGLE ARROWHEAD'
'\x02WJ'
'\x02WL'
'\x02WM'
'\x02WN'
'\x07WN FACE'
'\x1aWNING FACE WITH OPEN MOUTH'
'\rWNWARDS ARROW'
'\x13WNWARDS ARROW WITH '
'\x02WO'
'\x07WO DOTS'
'\x08WO DOTS '
'\nWO FINGERS'
'\x06WO OF '
'\x0bWO TWELFTHS'
'\x15WO-CIRCLE ALTERNATE I'
'\x15WO-CIRCLE NUKTA ABOVE'
'(WO-HEADED ARROW WITH TRIANGLE ARROWHEADS'
'\x05WOMAN'
'\x13WOMEN HOLDING HANDS'
'\x03WOQ'
'\x14WORD REPETITION MARK'
'\x0eWORD SEPARATOR'
'\x04WORK'
'\x06WORKER'
'\x08WRINKLED'
'\tWRINKLES '
'\nWRIST FLEX'
'\x08WRITING '
'\x0cWRITING HAND'
'\tWRY SMILE'
'\x02WU'
'\x05WUAET'
'\x01X'
'\x02X '
'\x06X FACE'
'\nX POINTED '
'\x07X WITH '
'\tX WITH LO'
'\tX-X BELOW'
'\x02XA'
'\x03XAN'
'\x03XAU'
'\tXCITEMENT'
'\x02XE'
'\x04XEYN'
'\nXHEEJ CEEV'
'\x02XI'
'\x08XIANGQI '
'\x06XIMIZE'
'\x05XING '
'\nXING GLOVE'
'\x07XOPHONE'
'\x07XT LINE'
'\x0bXTINGUISHER'
'\x15XTRA SHORT VOWEL MARK'
'\x03XWV'
'\x05XYOOJ'
'\x01Y'
'\x02Y '
'\nY AND RICE'
'\tY BLOSSOM'
'\x06Y FACE'
'\x07Y GREEN'
'\x06Y LOOP'
'\x08Y POPPER'
'\nY THOUSAND'
'\x16Y WITH SHORT RIGHT LEG'
'\x02YA'
'\x03YAA'
'\x03YAH'
'\x03YAI'
'\x03YAN'
'\x0cYAN NUMERAL '
'\x07YANMAR '
'\x07YANSAYA'
'\x03YAT'
'\x03YAU'
'\x04YAWN'
'\x03YAY'
'\x02YE'
'\x03YEE'
'\x03YEH'
'\x1aYEH WITH HAMZA ABOVE WITH '
'\x1cYEH WITH TWO DOTS BELOW AND '
'\x08YEN SIGN'
'\tYESIEUNG-'
'\x04YEUX'
'\x05YGIEA'
'\x02YI'
'\x03YI '
'\x0eYI WITH STROKE'
'\x03YIN'
'\x05YING '
'\nYING CARD '
'\tYING FACE'
'\x10YIR MKPARAQ MEUN'
'\x03YIT'
'\x0cYLEFT SYMBOL'
'\x05YMBOL'
'\x06YMBOL '
'\nYMBOL AIVA'
'\x0cYMBOL BINDU '
'\rYMBOL KIEVAN '
'\rYMBOL TAU RHO'
'\x08YMBOL VI'
'\x02YN'
'\x07YNAMIC '
'\x02YO'
'\x04YODH'
'\x06YOMBO '
'\x06YRENE '
'\x08YRILLIC '
'\x02YU'
'\x01Z'
'\x02ZA'
'\x03ZAH'
'\x1aZAIN WITH INVERTED V ABOVE'
'\x0eZAKAYA LANTERN'
'\x03ZAL'
'2ZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA VASIS'
'\nZAR AMULET'
'\x04ZARD'
'\x04ZATA'
'\x05ZAYIN'
'\x04ZAYN'
'\x04ZEN '
'\x04ZERO'
'\x03ZHE'
'\x07ZIGZAG '
'\x0cZIGZAG ARROW'
'\x04ZIZ2'
'\x02ZO'
'\nZU OVER ZU'
'\x08ZWJ THAJ'
'\x02ZY'
'\x03ZZA'
'\x04ZZHE'
'\x04ZZY '
)
_charnodes =[67466,
 -34782,
 -1,
 132262,
 16477,
 983080,
 197597,
 80378,
 -1,
 263132,
 169417,
 -1,
 328058,
 211655,
 -1,
 393581,
 266001,
 -1,
 459116,
 351332,
 -1,
 524501,
 406310,
 -1,
 590001,
 477265,
 121091,
 720895,
 524288,
 -1,
 721000,
 607315,
 120832,
 851967,
 655360,
 -1,
 852026,
 743696,
 120846,
 983039,
 786432,
 -1,
 983073,
 859447,
 -1,
 1048605,
 943048,
 120853,
 1179647,
 983040,
 -1,
 1179671,
 1082395,
 -1,
 1245206,
 1145883,
 120877,
 1376255,
 1179648,
 -1,
 -65515,
 1254047,
 120878,
 -1,
 1317239,
 120879,
 -1,
 1193497,
 120884,
 1572889,
 1130046,
 120857,
 -1,
 1508623,
 120882,
 1703963,
 1516783,
 120856,
 -1,
 1639661,
 120885,
 -65508,
 1661215,
 120855,
 -1,
 1786976,
 120854,
 2031615,
 1013522,
 -1,
 2031648,
 1911975,
 120858,
 -1,
 1967375,
 120883,
 -1,
 1966718,
 121001,
 2228269,
 951317,
 120862,
 2359295,
 2162688,
 -1,
 2359335,
 2235703,
 -1,
 -65499,
 2329660,
 120872,
 -65498,
 2384849,
 120893,
 -1,
 2443121,
 120873,
 2621482,
 2308807,
 -1,
 -65495,
 2581598,
 120874,
 -1,
 2639325,
 120875,
 2818092,
 2561041,
 120895,
 -1,
 2753391,
 120894,
 -1,
 2759031,
 120866,
 3014707,
 2191180,
 -1,
 3080242,
 2966778,
 120966,
 3211263,
 3014656,
 -1,
 -65487,
 3089055,
 120972,
 -1,
 3152247,
 120971,
 -1,
 3019211,
 120849,
 3407925,
 2965054,
 120850,
 -1,
 3343506,
 120867,
 3538999,
 3348855,
 120848,
 -1,
 3474715,
 120865,
 -65480,
 3509229,
 120871,
 -65479,
 3637274,
 120864,
 -1,
 3691442,
 120996,
 3866713,
 820251,
 -1,
 3932229,
 3832859,
 121052,
 4063231,
 3866624,
 -1,
 4063297,
 3965979,
 -1,
 -65473,
 4007859,
 121054,
 -65472,
 4072095,
 121055,
 -1,
 4135287,
 121056,
 4325444,
 4015193,
 -1,
 -65469,
 4275761,
 121059,
 -1,
 4331895,
 121057,
 -1,
 4266999,
 121058,
 4587599,
 3874103,
 -1,
 4653133,
 4556951,
 -1,
 4718668,
 4616012,
 -1,
 4784203,
 4689547,
 -1,
 -65462,
 4754236,
 121066,
 -1,
 4802131,
 121064,
 -1,
 4739787,
 121063,
 -1,
 4680939,
 120887,
 5177343,
 4605786,
 121067,
 -1,
 5055882,
 120892,
 5242963,
 4538051,
 121062,
 5373951,
 5188811,
 -1,
 -65454,
 5278602,
 120881,
 -1,
 5324350,
 120899,
 5505110,
 5191201,
 -1,
 -65451,
 5472228,
 121060,
 -1,
 5511543,
 121061,
 5767167,
 5444632,
 -1,
 -65448,
 5662645,
 120890,
 -1,
 5719012,
 120891,
 5898334,
 3817022,
 120843,
 6029311,
 5832704,
 -1,
 6029405,
 5921162,
 120852,
 -1,
 5965071,
 120870,
 -1,
 5985509,
 120844,
 6226018,
 5868433,
 120851,
 6356991,
 6161637,
 -1,
 -65439,
 6257691,
 120868,
 -1,
 6300319,
 120869,
 6488165,
 6188876,
 -1,
 -65436,
 6440281,
 121018,
 -1,
 6492605,
 120841,
 6684775,
 6429047,
 120838,
 -1,
 6620020,
 120861,
 -1,
 6628591,
 120842,
 6881407,
 689173,
 121077,
 7012351,
 6815744,
 -1,
 7012465,
 6916930,
 -1,
 7077998,
 6979918,
 -1,
 -65427,
 7050474,
 121086,
 -1,
 7094131,
 121088,
 -65425,
 7033793,
 120979,
 -65424,
 7226464,
 120840,
 -1,
 7288465,
 121089,
 7471222,
 6953397,
 -1,
 7536756,
 7423083,
 121083,
 -1,
 7472299,
 120876,
 -65419,
 7501137,
 121085,
 -1,
 7625003,
 121084,
 7798906,
 7437344,
 -1,
 -65416,
 7743411,
 121079,
 -65415,
 7807647,
 121080,
 -1,
 7870839,
 121081,
 8061053,
 7759843,
 -1,
 -65412,
 8030308,
 121087,
 -1,
 8074961,
 121090,
 -65410,
 8011080,
 121078,
 -1,
 8205849,
 121082,
 8388757,
 6838551,
 -1,
 8454285,
 8356891,
 -1,
 8519814,
 8396087,
 -1,
 8585349,
 8472440,
 -1,
 -65404,
 8555402,
 120888,
 -1,
 8601150,
 120889,
 -1,
 8555586,
 120886,
 8847499,
 8459288,
 -1,
 8913034,
 8808362,
 -1,
 -65399,
 8883082,
 120896,
 -1,
 8922206,
 120897,
 -1,
 8864976,
 120898,
 -65396,
 8803250,
 121035,
 -1,
 9125582,
 120880,
 9306255,
 8424330,
 121030,
 -1,
 9241871,
 121033,
 9437330,
 9269068,
 -1,
 -65391,
 9389401,
 121037,
 -1,
 9441725,
 121032,
 -65389,
 9393074,
 121036,
 -65388,
 9578966,
 121028,
 -1,
 9640316,
 120860,
 9830564,
 8344505,
 -1,
 9896092,
 9775574,
 120974,
 10027007,
 9830400,
 -1,
 10027163,
 9926112,
 -1,
 -65382,
 9994212,
 120975,
 -1,
 10036530,
 120976,
 -1,
 9987619,
 120977,
 10289311,
 9863502,
 -1,
 -65378,
 10249920,
 120985,
 -1,
 10305541,
 120986,
 10485921,
 10241107,
 120992,
 -1,
 10421470,
 120988,
 -65374,
 10455946,
 120978,
 -65373,
 10579961,
 120983,
 -1,
 10623351,
 120984,
 10813615,
 9794880,
 -1,
 10879145,
 10770704,
 121012,
 11010047,
 10813440,
 -1,
 -65368,
 10907656,
 121014,
 -1,
 10953375,
 121013,
 -65366,
 10849162,
 121006,
 -65365,
 11109397,
 121016,
 -65364,
 11169785,
 121007,
 -65363,
 11228082,
 121008,
 -65362,
 11289683,
 121015,
 -1,
 11348438,
 121003,
 -65360,
 10763592,
 121092,
 -1,
 11482805,
 120906,
 11730943,
 544395,
 120922,
 11796479,
 11599872,
 -1,
 11796675,
 11678502,
 -1,
 11862205,
 11749608,
 120908,
 11993087,
 11796480,
 -1,
 11993274,
 11877950,
 120919,
 12124159,
 11927552,
 -1,
 -65351,
 12026928,
 120920,
 -1,
 12082832,
 120921,
 -65349,
 11961378,
 120914,
 -65348,
 12203602,
 120910,
 -1,
 12261751,
 120912,
 12517375,
 11822862,
 120900,
 12582911,
 12386304,
 -1,
 12583105,
 12460703,
 120903,
 -1,
 12518539,
 120904,
 -65342,
 12533310,
 120902,
 -1,
 12654967,
 120901,
 12845257,
 11763335,
 -1,
 12910791,
 12787444,
 120930,
 13041663,
 12846351,
 120931,
 -1,
 12910837,
 120932,
 -65336,
 12866482,
 120933,
 -1,
 13059263,
 120929,
 13238480,
 12795208,
 120924,
 13369343,
 13172736,
 -1,
 13369551,
 13251850,
 120909,
 13500415,
 13303808,
 -1,
 -65330,
 13383250,
 120911,
 -1,
 13441399,
 120913,
 -1,
 13337648,
 120926,
 13697236,
 13206555,
 -1,
 -65326,
 13663259,
 120925,
 -65325,
 13710873,
 120928,
 -1,
 13769079,
 120927,
 -1,
 13638111,
 120923,
 14024977,
 466231,
 -1,
 14090480,
 13994135,
 -1,
 14156011,
 14051537,
 120941,
 14286847,
 14090240,
 -1,
 14287071,
 14181574,
 120940,
 14417919,
 14221312,
 -1,
 14418142,
 14320667,
 -1,
 -65315,
 14384155,
 120942,
 -1,
 14431769,
 120946,
 -1,
 14376592,
 120944,
 14680292,
 14238803,
 120834,
 14811135,
 14614528,
 -1,
 14811363,
 14713877,
 121068,
 -1,
 14746460,
 121069,
 -1,
 14775633,
 121024,
 15007975,
 14648347,
 -1,
 -65306,
 14973979,
 120943,
 -1,
 15021593,
 120947,
 15204585,
 14955786,
 120915,
 -1,
 15139676,
 120916,
 -65302,
 15163024,
 120945,
 -1,
 15292727,
 121040,
 15532031,
 14120609,
 120949,
 15597567,
 15400960,
 -1,
 -65298,
 15492294,
 120948,
 -65297,
 15554919,
 121039,
 -1,
 15615115,
 121020,
 15794439,
 14042970,
 120950,
 15925247,
 15728640,
 -1,
 15925503,
 15811667,
 120833,
 16056319,
 15859712,
 -1,
 16056572,
 15948048,
 120847,
 16187391,
 15990784,
 -1,
 16187641,
 16065584,
 -1,
 -65288,
 16133287,
 120859,
 -1,
 16188030,
 121002,
 -65286,
 16155669,
 120863,
 -65285,
 16348475,
 120967,
 -1,
 16405426,
 120997,
 -65283,
 16020817,
 121019,
 -65282,
 16530993,
 120845,
 -1,
 16587127,
 120839,
 16777475,
 15882519,
 -1,
 16843010,
 16741713,
 121038,
 -1,
 16777461,
 121045,
 -1,
 16812938,
 121031,
 17039622,
 16733113,
 -1,
 -65275,
 17009546,
 120980,
 -1,
 17056851,
 120993,
 -1,
 17003857,
 121009,
 17367039,
 15748802,
 120934,
 17432575,
 17235968,
 -1,
 17432844,
 17335323,
 -1,
 -65269,
 17398811,
 120935,
 -1,
 17446425,
 120937,
 17629454,
 17389898,
 121046,
 -1,
 17564778,
 121047,
 -65265,
 17587856,
 120936,
 -65264,
 17712288,
 121065,
 -1,
 17774238,
 120905,
 17957193,
 13974215,
 -1,
 18022715,
 17909208,
 120957,
 18153471,
 17956864,
 -1,
 18153763,
 18039891,
 120836,
 18284543,
 18087936,
 -1,
 18284829,
 18187285,
 121072,
 18415615,
 18219008,
 -1,
 18415899,
 18315298,
 -1,
 -65254,
 18372313,
 121073,
 -1,
 18432424,
 121053,
 -65252,
 18375878,
 121070,
 -1,
 18566674,
 121071,
 18743585,
 18241815,
 -1,
 18809120,
 18707771,
 120968,
 -1,
 18743656,
 120973,
 -1,
 18764722,
 120998,
 -65246,
 18707793,
 121025,
 -1,
 18955838,
 121051,
 19136809,
 18113734,
 120955,
 19267583,
 19070976,
 -1,
 19267880,
 19170331,
 -1,
 -65241,
 19233819,
 120959,
 -1,
 19281433,
 120956,
 -1,
 19226256,
 120961,
 19530030,
 19092402,
 120970,
 19660799,
 19464192,
 -1,
 19661101,
 19547219,
 120994,
 -1,
 19596510,
 120989,
 -1,
 19629077,
 120987,
 19857714,
 19498011,
 -1,
 19923249,
 19823643,
 120960,
 -1,
 19858785,
 120963,
 -1,
 19864011,
 120964,
 20119860,
 19821883,
 120999,
 -1,
 20054438,
 121004,
 20250934,
 20076816,
 121029,
 -1,
 20186162,
 121041,
 20382009,
 20198182,
 -1,
 -65224,
 20342554,
 120907,
 -1,
 20400379,
 120917,
 -65222,
 20348173,
 120958,
 -1,
 20536976,
 120962,
 20774911,
 17982554,
 120939,
 20840447,
 20643840,
 -1,
 20840771,
 20732183,
 -1,
 20906306,
 20804957,
 121050,
 21037055,
 20840448,
 -1,
 -65215,
 20932507,
 121048,
 -1,
 20988893,
 121049,
 -1,
 20874261,
 121034,
 21233991,
 20792440,
 -1,
 -65211,
 21203772,
 121023,
 -65210,
 21260187,
 121021,
 -1,
 21316573,
 121022,
 -65208,
 21198210,
 121017,
 -1,
 21439734,
 120938,
 21627234,
 17896459,
 120965,
 21757951,
 21561344,
 -1,
 21758294,
 21644371,
 120837,
 21889023,
 21692416,
 -1,
 21889361,
 21791765,
 121076,
 22020095,
 21823488,
 -1,
 -65200,
 21915547,
 121074,
 -1,
 21971933,
 121075,
 22151507,
 21853521,
 121027,
 -1,
 22086511,
 121026,
 22347775,
 22108439,
 -1,
 -65195,
 22246715,
 120969,
 -1,
 22303666,
 121000,
 22479195,
 21713849,
 -1,
 22544730,
 22430803,
 120995,
 22675455,
 22480124,
 120991,
 -1,
 22545263,
 120990,
 -1,
 22514570,
 120982,
 22806879,
 22436151,
 121044,
 22937599,
 22740992,
 -1,
 -65186,
 22833051,
 121042,
 -1,
 22889437,
 121043,
 23134207,
 22771008,
 -1,
 -65183,
 23024562,
 121011,
 -1,
 23079393,
 121005,
 23330815,
 21587934,
 120951,
 23396351,
 23199744,
 -1,
 23396711,
 23299099,
 -1,
 -65178,
 23362587,
 120952,
 -1,
 23410201,
 120954,
 -65176,
 23360849,
 121010,
 -65175,
 23551632,
 120953,
 -65174,
 23614401,
 120981,
 -65173,
 23675987,
 120835,
 -1,
 23737610,
 120918,
 -1,
 411463,
 121451,
 24051711,
 338935,
 121343,
 24117247,
 23920640,
 -1,
 24117625,
 24009369,
 -1,
 24183160,
 24053789,
 -1,
 24248693,
 24154434,
 -1,
 -65165,
 24216753,
 121346,
 -65164,
 24281060,
 121345,
 -1,
 24323365,
 121348,
 24575999,
 24196465,
 -1,
 -65161,
 24477668,
 121347,
 -1,
 24519973,
 121349,
 -1,
 24117594,
 121350,
 -1,
 24081712,
 121344,
 24838836,
 285206,
 -1,
 24904334,
 24809165,
 -1,
 24969717,
 24875330,
 -1,
 25035168,
 24911159,
 -1,
 25100694,
 25005417,
 -1,
 25166227,
 25034752,
 -1,
 25231753,
 25115335,
 -1,
 25297286,
 25170502,
 -1,
 25362820,
 25251346,
 121230,
 -1,
 25329458,
 121231,
 -65147,
 25328909,
 121228,
 -1,
 25450478,
 121229,
 25690111,
 25250007,
 -1,
 -65144,
 25573181,
 121254,
 -1,
 25632732,
 121261,
 25821582,
 25194173,
 -1,
 25887116,
 25775634,
 121226,
 -1,
 25853746,
 121227,
 -65139,
 25853197,
 121224,
 -1,
 25974766,
 121225,
 26214399,
 25789213,
 -1,
 26214802,
 26112489,
 -1,
 -65135,
 26180877,
 121232,
 -1,
 26236910,
 121233,
 -1,
 26160901,
 121247,
 26542079,
 25109889,
 -1,
 -65131,
 26443021,
 121248,
 -1,
 26499054,
 121249,
 26673563,
 25060765,
 -1,
 -65128,
 26639629,
 121147,
 -65127,
 26703701,
 121150,
 -65126,
 26761198,
 121148,
 -1,
 26824210,
 121149,
 27001247,
 26623286,
 -1,
 -65123,
 26967309,
 121151,
 -65122,
 27023342,
 121152,
 -1,
 27086354,
 121153,
 -1,
 26965778,
 121139,
 27328949,
 25006361,
 -1,
 27394482,
 27269076,
 -1,
 27460011,
 27338027,
 -1,
 27525543,
 27428637,
 -1,
 -65115,
 27491597,
 121244,
 -65114,
 27547630,
 121245,
 -1,
 27610642,
 121246,
 27852799,
 27470026,
 -1,
 -65111,
 27753741,
 121241,
 -65110,
 27809774,
 121242,
 -1,
 27872786,
 121243,
 28049839,
 27404230,
 -1,
 -65107,
 28015885,
 121268,
 -65106,
 28071918,
 121269,
 -1,
 28134930,
 121270,
 28377087,
 27999865,
 -1,
 -65103,
 28260157,
 121257,
 -1,
 28319708,
 121264,
 28573695,
 27358745,
 -1,
 -65100,
 28474525,
 121325,
 -1,
 28518595,
 121326,
 28705214,
 27293730,
 -1,
 28770749,
 28657140,
 -1,
 28836284,
 28737517,
 -1,
 28901818,
 28790290,
 121132,
 -1,
 28868402,
 121133,
 -65093,
 28867853,
 121130,
 -1,
 28989422,
 121131,
 -1,
 28808638,
 121134,
 -1,
 28719919,
 121253,
 29295046,
 28660928,
 -1,
 29360577,
 29261069,
 121237,
 -1,
 29295006,
 121240,
 29491652,
 29310585,
 -1,
 -65085,
 29439805,
 121256,
 -1,
 29499356,
 121263,
 -65083,
 29448174,
 121238,
 -1,
 29642258,
 121239,
 29819343,
 29235234,
 -1,
 29884875,
 29780124,
 -1,
 -65079,
 29850893,
 121154,
 -65078,
 29906926,
 121155,
 -1,
 29969938,
 121156,
 30212095,
 29830977,
 -1,
 -65075,
 30113037,
 121144,
 -65074,
 30169070,
 121145,
 -1,
 30232082,
 121146,
 30409174,
 29769738,
 -1,
 30474707,
 30359161,
 -1,
 -65070,
 30422845,
 121255,
 -1,
 30482396,
 121262,
 -65068,
 30440717,
 121234,
 -65067,
 30627822,
 121235,
 -1,
 30690834,
 121236,
 30867931,
 30377757,
 -1,
 30933465,
 30806698,
 121142,
 -1,
 30869512,
 121143,
 -65062,
 30905790,
 121141,
 -1,
 31031287,
 121140,
 31195616,
 30812362,
 -1,
 31261150,
 31134378,
 121137,
 -1,
 31197192,
 121138,
 -65057,
 31233470,
 121136,
 -1,
 31358948,
 121135,
 31523303,
 31135081,
 -1,
 31588836,
 31489299,
 -1,
 -65053,
 31554717,
 121315,
 -1,
 31598787,
 121317,
 31850495,
 31545333,
 -1,
 -65050,
 31751325,
 121316,
 -1,
 31795395,
 121318,
 31982059,
 31496464,
 -1,
 -65047,
 31948045,
 121157,
 -65046,
 32004078,
 121158,
 -1,
 32067090,
 121159,
 32244207,
 31943260,
 -1,
 -65043,
 32210189,
 121160,
 -65042,
 32266222,
 121161,
 -1,
 32329234,
 121162,
 32506356,
 32191640,
 -1,
 32571891,
 32458642,
 -1,
 -65038,
 32537757,
 121329,
 -1,
 32581827,
 121330,
 -1,
 32531510,
 121128,
 -1,
 32459326,
 121448,
 32899693,
 24917361,
 -1,
 32965130,
 32841015,
 -1,
 33030660,
 32935278,
 -1,
 33096191,
 32980601,
 -1,
 33161724,
 33043818,
 -1,
 -65029,
 33127693,
 121286,
 -1,
 33181202,
 121287,
 33423359,
 33103591,
 -1,
 -65026,
 33324301,
 121271,
 -1,
 33377810,
 121272,
 33554945,
 33050130,
 121303,
 -1,
 33521458,
 121304,
 -65022,
 33520909,
 121301,
 -65021,
 33642478,
 121302,
 -1,
 33694208,
 121305,
 33882632,
 32990621,
 -1,
 -65018,
 33848589,
 121204,
 -65017,
 33904622,
 121205,
 -1,
 33967634,
 121206,
 -65015,
 33847058,
 121198,
 -1,
 34094385,
 121207,
 34275866,
 32936217,
 -1,
 34341399,
 34215892,
 -1,
 34406931,
 34291321,
 -1,
 34472464,
 34354538,
 -1,
 -65009,
 34438413,
 121296,
 -1,
 34491922,
 121297,
 34734079,
 34414311,
 -1,
 -65006,
 34635021,
 121281,
 -1,
 34688530,
 121282,
 34865686,
 34371618,
 -1,
 -65003,
 34823136,
 121308,
 -1,
 34887385,
 121309,
 -1,
 34819602,
 121310,
 35192831,
 34305580,
 -1,
 -64999,
 35093661,
 121327,
 -1,
 35137731,
 121328,
 35324459,
 34231488,
 -1,
 35389994,
 35274361,
 -1,
 35455523,
 35337578,
 -1,
 35521056,
 35421459,
 -1,
 -64993,
 35486877,
 121292,
 -1,
 35530947,
 121294,
 35782655,
 35474968,
 -1,
 -64990,
 35683485,
 121293,
 -1,
 35727555,
 121295,
 35979263,
 35397351,
 -1,
 35979815,
 35880211,
 -1,
 -64986,
 35945629,
 121277,
 -1,
 35989699,
 121279,
 36241407,
 35933720,
 -1,
 -64983,
 36142237,
 121278,
 -1,
 36186307,
 121280,
 -1,
 35355917,
 121307,
 36438587,
 35274762,
 -1,
 36504122,
 36388473,
 -1,
 36569651,
 36451690,
 -1,
 36635185,
 36538141,
 -1,
 -64976,
 36601244,
 121290,
 -1,
 36654689,
 121291,
 -64974,
 36601114,
 121288,
 -1,
 36785695,
 121289,
 37027839,
 36511463,
 -1,
 37028407,
 36928787,
 -1,
 -64970,
 36996886,
 121275,
 -1,
 37038275,
 121273,
 37289983,
 36982296,
 -1,
 -64967,
 37193494,
 121276,
 -1,
 37234883,
 121274,
 -1,
 36470029,
 121306,
 37487172,
 36403234,
 -1,
 37552707,
 37438964,
 -1,
 37618242,
 37519341,
 -1,
 37683776,
 37572114,
 121191,
 -1,
 37650226,
 121192,
 -64959,
 37649677,
 121189,
 -1,
 37771246,
 121190,
 -1,
 37590462,
 121193,
 -1,
 37501750,
 121314,
 38077006,
 37426549,
 -1,
 38142536,
 38042899,
 -1,
 -64953,
 38108317,
 121319,
 -1,
 38152387,
 121322,
 38339147,
 38098933,
 -1,
 -64950,
 38304925,
 121320,
 -1,
 38348995,
 121323,
 38600703,
 38293016,
 -1,
 -64947,
 38501533,
 121321,
 -1,
 38545603,
 121324,
 38732372,
 38045469,
 -1,
 38797906,
 38671030,
 -1,
 -64943,
 38770110,
 121202,
 -1,
 38820505,
 121201,
 -64941,
 38770110,
 121200,
 -1,
 38961143,
 121199,
 39125593,
 38676682,
 -1,
 39191127,
 39064234,
 121196,
 -1,
 39127048,
 121197,
 -64936,
 39163326,
 121195,
 -1,
 39288804,
 121194,
 39453279,
 39065634,
 -1,
 39518814,
 39413916,
 -1,
 -64932,
 39484685,
 121208,
 -64931,
 39540718,
 121209,
 -1,
 39603730,
 121210,
 -1,
 39464765,
 121203,
 39846499,
 39426320,
 -1,
 -64927,
 39812365,
 121211,
 -64926,
 39868398,
 121212,
 -1,
 39931410,
 121213,
 40108647,
 39807580,
 -1,
 -64923,
 40074509,
 121214,
 -64922,
 40130542,
 121215,
 -1,
 40193554,
 121216,
 40370796,
 40055960,
 -1,
 40436331,
 40322970,
 -1,
 -64918,
 40402077,
 121331,
 -1,
 40446147,
 121332,
 -1,
 40395830,
 121129,
 -1,
 40323646,
 121449,
 40764035,
 32843708,
 -1,
 40829561,
 40704437,
 -1,
 40895092,
 40797705,
 -1,
 40960626,
 40848914,
 121187,
 -1,
 40927026,
 121188,
 -64909,
 40926477,
 121185,
 -1,
 41048046,
 121186,
 41287679,
 40835060,
 -1,
 41288311,
 41176594,
 121183,
 -1,
 41254706,
 121184,
 -64904,
 41254157,
 121181,
 -1,
 41375726,
 121182,
 41550462,
 40797705,
 -1,
 41615996,
 41504274,
 121179,
 -1,
 41582386,
 121180,
 -64899,
 41581837,
 121177,
 -1,
 41703406,
 121178,
 41943039,
 41490420,
 -1,
 41943681,
 41831954,
 121175,
 -1,
 41910066,
 121176,
 -64894,
 41909517,
 121173,
 -1,
 42031086,
 121174,
 42270719,
 40713783,
 -1,
 42271372,
 42175373,
 -1,
 42336907,
 42215899,
 -1,
 42402441,
 42275510,
 -1,
 -64888,
 42368269,
 121126,
 -1,
 42421778,
 121125,
 -64886,
 42368269,
 121122,
 -1,
 42552850,
 121121,
 -1,
 42302046,
 121123,
 -64883,
 42236966,
 121127,
 -1,
 42740256,
 121124,
 42991615,
 24874489,
 -1,
 42992283,
 42886347,
 -1,
 43057812,
 42955131,
 121418,
 43188223,
 42991616,
 -1,
 -64877,
 43095872,
 121420,
 -1,
 43161003,
 121419,
 43319960,
 43018206,
 121415,
 43450367,
 43253760,
 -1,
 -64873,
 43358016,
 121417,
 -1,
 43423147,
 121416,
 -64871,
 43292075,
 121414,
 -64870,
 43529753,
 121413,
 -1,
 43589678,
 121412,
 43778721,
 42933559,
 -1,
 43844256,
 43734218,
 -1,
 -64866,
 43801897,
 121403,
 -64865,
 43857433,
 121404,
 -1,
 43918107,
 121405,
 -1,
 43804068,
 121430,
 44171941,
 43746012,
 121424,
 44302335,
 44105728,
 -1,
 -64860,
 44204235,
 121426,
 -1,
 44250649,
 121425,
 44434089,
 44137907,
 121406,
 44564479,
 44367872,
 -1,
 -64856,
 44471723,
 121407,
 -1,
 44524742,
 121408,
 44696237,
 44387415,
 121421,
 44826623,
 44630016,
 -1,
 -64852,
 44733867,
 121423,
 -1,
 44774937,
 121422,
 44958385,
 44644168,
 121409,
 45088767,
 44892160,
 -1,
 -64848,
 44996011,
 121410,
 -1,
 45049030,
 121411,
 45285375,
 44930484,
 -1,
 -64845,
 45186205,
 121431,
 -1,
 45230275,
 121432,
 45417203,
 24805710,
 -1,
 45482704,
 45379738,
 -1,
 45548229,
 45453634,
 -1,
 45613760,
 45512542,
 -1,
 45679292,
 45584706,
 -1,
 -64838,
 45644957,
 121163,
 -64837,
 45689027,
 121164,
 -1,
 45748906,
 121165,
 46006271,
 45626737,
 -1,
 -64834,
 45907101,
 121166,
 -64833,
 45951171,
 121167,
 -1,
 46011050,
 121168,
 46203588,
 45553048,
 -1,
 -64830,
 46171926,
 121172,
 -64829,
 46234781,
 121170,
 -1,
 46278851,
 121171,
 -1,
 46168837,
 121169,
 46596095,
 45495665,
 -1,
 46596815,
 46495582,
 -1,
 46662347,
 46567746,
 -1,
 -64823,
 46627997,
 121220,
 -64822,
 46672067,
 121221,
 -1,
 46731946,
 121222,
 46989311,
 46609777,
 -1,
 -64819,
 46890141,
 121217,
 -64818,
 46934211,
 121218,
 -1,
 46994090,
 121219,
 -1,
 46562053,
 121223,
 47252197,
 45441125,
 -1,
 47317724,
 47209887,
 -1,
 47383253,
 47285521,
 -1,
 -64812,
 47351259,
 121436,
 -1,
 47389118,
 121435,
 47579864,
 47324923,
 -1,
 -64809,
 47546284,
 121439,
 -1,
 47597146,
 121440,
 -64807,
 47546297,
 121433,
 -64806,
 47733410,
 121438,
 -64805,
 47796917,
 121434,
 -1,
 47859303,
 121437,
 48038624,
 47286781,
 -1,
 -64802,
 48004253,
 121093,
 -64801,
 48061222,
 121094,
 -1,
 48109997,
 121095,
 48365567,
 48003011,
 -1,
 48366308,
 48271682,
 -1,
 -64797,
 48332809,
 121458,
 -1,
 48375097,
 121459,
 -1,
 48313742,
 121460,
 48693247,
 47197023,
 -1,
 48693999,
 48574863,
 121441,
 48824319,
 48627712,
 -1,
 48825069,
 48718505,
 -1,
 48890603,
 48792968,
 121443,
 -1,
 48825056,
 121444,
 49086463,
 48845729,
 121445,
 -1,
 48956128,
 121446,
 -64786,
 48781977,
 121442,
 -1,
 49093257,
 121447,
 49348607,
 48652149,
 -1,
 -64783,
 49240336,
 121390,
 -64782,
 49304805,
 121391,
 -1,
 49364453,
 121389,
 49546022,
 45379404,
 -1,
 49611554,
 49505814,
 -1,
 49677073,
 49547293,
 -1,
 49742596,
 49647938,
 -1,
 49808123,
 49708189,
 121250,
 49938431,
 49742366,
 -1,
 -64774,
 49821501,
 121258,
 -1,
 49881052,
 121265,
 50070271,
 49752259,
 121251,
 50200575,
 50004510,
 -1,
 -64770,
 50083645,
 121259,
 -1,
 50143196,
 121266,
 50397183,
 50008706,
 -1,
 50397955,
 50283845,
 -1,
 -64766,
 50345789,
 121260,
 -1,
 50405340,
 121267,
 -1,
 50342751,
 121252,
 50724863,
 49689969,
 -1,
 50725641,
 50625693,
 121311,
 50855935,
 50659870,
 -1,
 -64760,
 50738532,
 121298,
 -1,
 50798303,
 121283,
 50987789,
 50669763,
 121312,
 51118079,
 50922014,
 -1,
 -64756,
 51000676,
 121299,
 -1,
 51060447,
 121284,
 51314687,
 50926250,
 121313,
 51380223,
 51184158,
 -1,
 -64752,
 51262820,
 121300,
 -1,
 51322591,
 121285,
 51576831,
 49611477,
 -1,
 51577626,
 51448150,
 -1,
 -64748,
 51514569,
 121519,
 -64747,
 51579935,
 121518,
 -64746,
 51645315,
 121517,
 -64745,
 51710666,
 121516,
 -64744,
 51775986,
 121515,
 -64743,
 51841366,
 121514,
 -1,
 51906758,
 121513,
 -64741,
 51515014,
 121512,
 -64740,
 52039175,
 121511,
 -64739,
 52104545,
 121510,
 -64738,
 52169929,
 121509,
 -64737,
 52235295,
 121508,
 -64736,
 52300675,
 121507,
 -64735,
 52366026,
 121506,
 -1,
 52431346,
 121505,
 52690943,
 49580384,
 -1,
 -64732,
 52591773,
 121105,
 -64731,
 52648742,
 121106,
 -1,
 52697517,
 121107,
 52888400,
 49490783,
 -1,
 52953934,
 52860745,
 -1,
 53019447,
 52901978,
 -1,
 53084977,
 52990274,
 -1,
 53150510,
 53051364,
 121377,
 53280767,
 53084160,
 -1,
 -64723,
 53160131,
 121378,
 -1,
 53220010,
 121379,
 53477375,
 53091639,
 -1,
 -64720,
 53382516,
 121383,
 -1,
 53430191,
 121385,
 53673983,
 53032305,
 -1,
 53674806,
 53575652,
 121380,
 53805055,
 53608448,
 -1,
 -64715,
 53684419,
 121381,
 -1,
 53744298,
 121382,
 -1,
 53617970,
 121384,
 54002497,
 52983844,
 -1,
 54068027,
 53973828,
 -1,
 -64710,
 54025746,
 121372,
 -1,
 54068060,
 121370,
 54264638,
 54016866,
 -1,
 -64707,
 54224070,
 121369,
 -1,
 54272395,
 121371,
 -64705,
 54230714,
 121365,
 -64704,
 54420678,
 121364,
 -1,
 54469003,
 121366,
 54657861,
 53956206,
 -1,
 -64701,
 54627210,
 121374,
 -64700,
 54670770,
 121376,
 -1,
 54733270,
 121375,
 54920009,
 54598804,
 -1,
 -64697,
 54889354,
 121354,
 -64696,
 54943017,
 121355,
 -1,
 54995414,
 121356,
 55246847,
 54853632,
 -1,
 55247693,
 55122775,
 -1,
 -64692,
 55213213,
 121367,
 -1,
 55270182,
 121368,
 -1,
 55219067,
 121373,
 -64689,
 52926000,
 121452,
 -1,
 55449129,
 121392,
 55640941,
 52841719,
 -1,
 55706465,
 55591005,
 -1,
 55771996,
 55662476,
 -1,
 55837531,
 55726485,
 -1,
 -64683,
 55774561,
 121469,
 -64682,
 55839945,
 121468,
 -64681,
 55905311,
 121467,
 -64680,
 55970691,
 121466,
 -64679,
 56036042,
 121465,
 -64678,
 56101362,
 121464,
 -1,
 56166742,
 121463,
 -1,
 55779828,
 121462,
 56492031,
 55732433,
 -1,
 56492896,
 56360960,
 -1,
 -64673,
 56462452,
 121429,
 -1,
 56513920,
 121428,
 -1,
 56457290,
 121427,
 56819711,
 55664860,
 -1,
 56820586,
 56688640,
 -1,
 56886118,
 56769675,
 -1,
 -64667,
 56836702,
 121473,
 -1,
 56889450,
 121476,
 -64665,
 56857425,
 121474,
 -64664,
 57050571,
 121477,
 -64663,
 57103219,
 121478,
 -1,
 57157443,
 121475,
 57409535,
 56756253,
 -1,
 -64660,
 57315689,
 121471,
 -1,
 57357693,
 121472,
 57541514,
 55587622,
 -1,
 57607033,
 57494775,
 -1,
 57672568,
 57557366,
 -1,
 57738101,
 57636898,
 -1,
 57803636,
 57693918,
 -1,
 -64653,
 57769117,
 121116,
 -1,
 57826086,
 121118,
 -1,
 57749589,
 121119,
 58130431,
 57691672,
 -1,
 -64649,
 58031261,
 121115,
 -1,
 58088230,
 121117,
 -1,
 57631873,
 121456,
 58327937,
 57557085,
 -1,
 58393472,
 58282966,
 -1,
 -64644,
 58330313,
 121503,
 -64643,
 58395679,
 121502,
 -64642,
 58461059,
 121501,
 -64641,
 58526410,
 121500,
 -1,
 58591730,
 121499,
 -1,
 58350981,
 121470,
 58852229,
 58287491,
 -1,
 -64637,
 58824107,
 121363,
 -64636,
 58875177,
 121361,
 -1,
 58925851,
 121362,
 59114377,
 58789855,
 -1,
 59179912,
 59083693,
 121352,
 -1,
 59114795,
 121353,
 -1,
 59127344,
 121351,
 -1,
 59083488,
 121480,
 59442082,
 57505826,
 -1,
 59507605,
 59404038,
 -1,
 59573137,
 59471906,
 -1,
 59638672,
 59528926,
 -1,
 -64625,
 59604125,
 121111,
 -1,
 59661094,
 121113,
 -1,
 59584597,
 121114,
 59900820,
 59526680,
 -1,
 -64621,
 59866269,
 121110,
 -1,
 59923238,
 121112,
 -1,
 59848018,
 121120,
 60162969,
 59475715,
 -1,
 -64617,
 60128413,
 121099,
 -64616,
 60185382,
 121100,
 -1,
 60234157,
 121101,
 60425118,
 60112700,
 -1,
 60490653,
 60374615,
 -1,
 -64612,
 60456570,
 121453,
 -1,
 60517562,
 121454,
 -1,
 60458166,
 121457,
 60752801,
 60394745,
 -1,
 -64608,
 60719430,
 121108,
 -1,
 60758445,
 121109,
 -1,
 60698335,
 121481,
 61014966,
 59385183,
 -1,
 61080496,
 60987470,
 -1,
 61146024,
 61044770,
 -1,
 61211559,
 61096913,
 121339,
 -1,
 61145106,
 121340,
 -1,
 61166821,
 121336,
 61408171,
 61085185,
 -1,
 -64598,
 61373709,
 121333,
 -1,
 61427218,
 121334,
 -64596,
 61375196,
 121337,
 -64595,
 61567520,
 121338,
 -64594,
 61618725,
 121342,
 -64593,
 61682573,
 121335,
 -1,
 61747870,
 121341,
 61997055,
 61042965,
 -1,
 61998004,
 61889841,
 -1,
 -64589,
 61967242,
 121360,
 -1,
 62007766,
 121357,
 -64587,
 61967266,
 121359,
 -1,
 62138879,
 121358,
 62325694,
 60971863,
 -1,
 62391229,
 62285270,
 -1,
 62456763,
 62361881,
 -1,
 -64582,
 62420365,
 121395,
 -1,
 62472791,
 121396,
 -64580,
 62414121,
 121393,
 -1,
 62595867,
 121394,
 -1,
 62336144,
 121450,
 62849990,
 62266679,
 -1,
 62915523,
 62799169,
 -1,
 -64575,
 62881995,
 121388,
 -64574,
 62942601,
 121386,
 -1,
 63003945,
 121387,
 63242239,
 62873701,
 -1,
 -64571,
 63134226,
 121479,
 -1,
 63198307,
 121482,
 63374286,
 62790713,
 -1,
 63439819,
 63344039,
 -1,
 -64567,
 63405213,
 121102,
 -64566,
 63462182,
 121103,
 -1,
 63510957,
 121104,
 63766527,
 63384687,
 -1,
 -64563,
 63653371,
 121401,
 -1,
 63714050,
 121402,
 63898581,
 63312271,
 -1,
 63964114,
 63865030,
 -1,
 -64559,
 63915346,
 121398,
 -1,
 63964272,
 121400,
 64225279,
 63904617,
 -1,
 -64556,
 64112006,
 121397,
 -1,
 64160880,
 121399,
 64357337,
 63846986,
 -1,
 -64553,
 64322717,
 121096,
 -64552,
 64379686,
 121097,
 -1,
 64428461,
 121098,
 -64550,
 64328013,
 121455,
 -64549,
 64588881,
 121461,
 -1,
 64645626,
 121483,
 -1,
 197445,
 129304,
 64881765,
 140639,
 -1,
 64947290,
 64825244,
 -1,
 65012770,
 64901545,
 -1,
 65078250,
 64979278,
 -1,
 65143779,
 65049864,
 71129,
 -1,
 65093725,
 71130,
 65274854,
 65110350,
 -1,
 -64539,
 65223381,
 71065,
 -1,
 65277713,
 71064,
 65471465,
 65223367,
 -1,
 -64536,
 65434066,
 71128,
 -1,
 65474321,
 71070,
 -1,
 65408785,
 71069,
 65733617,
 65048117,
 -1,
 65799152,
 65691851,
 -1,
 65864686,
 65761100,
 71046,
 -1,
 65826636,
 71047,
 66060287,
 65817847,
 71048,
 -1,
 65948919,
 71049,
 -1,
 65736465,
 71082,
 66192374,
 65670929,
 71040,
 -64525,
 66160791,
 71053,
 -64524,
 66213332,
 71131,
 -64523,
 66273373,
 71051,
 -1,
 66326289,
 71041,
 66520059,
 66149207,
 -1,
 -64520,
 66492168,
 71063,
 -64519,
 66542512,
 71068,
 -64518,
 66598882,
 71058,
 -1,
 66653969,
 71073,
 66847745,
 66463071,
 -1,
 66913279,
 66790751,
 -1,
 -64514,
 66861781,
 71067,
 -1,
 66916113,
 71066,
 -64512,
 66861781,
 71072,
 -1,
 67047185,
 71071,
 67240965,
 66811938,
 -1,
 -64509,
 67205278,
 71084,
 -64508,
 67254997,
 71083,
 -1,
 67309329,
 71085,
 67503111,
 67209367,
 71044,
 -1,
 67471511,
 71045,
 67634186,
 67463377,
 -1,
 -64503,
 67582677,
 71075,
 -1,
 67637009,
 71074,
 67830797,
 67586755,
 -1,
 -64500,
 67779285,
 71055,
 -1,
 67833617,
 71054,
 68027408,
 67783157,
 -1,
 -64497,
 67975893,
 71062,
 -1,
 68030225,
 71061,
 68224018,
 67977309,
 71042,
 -1,
 68173917,
 71043,
 68355093,
 68171689,
 -1,
 -64492,
 68303573,
 71057,
 -1,
 68357905,
 71056,
 68551704,
 68295991,
 -1,
 -64489,
 68500181,
 71060,
 -1,
 68554513,
 71059,
 68748315,
 68491298,
 -1,
 -64486,
 68696789,
 71077,
 -1,
 68751121,
 71076,
 -64484,
 68720392,
 71079,
 -64483,
 68906905,
 71080,
 -64482,
 68968549,
 71052,
 -64481,
 69031518,
 71078,
 -64480,
 69094729,
 71081,
 -64479,
 69155541,
 71086,
 -1,
 69217119,
 71050,
 69403715,
 64976930,
 -1,
 69469243,
 69348191,
 -1,
 69534776,
 69411990,
 -1,
 69600310,
 69505943,
 -1,
 69665835,
 69568099,
 -1,
 69731370,
 69609213,
 -1,
 -64471,
 69699829,
 71114,
 -1,
 69740722,
 71115,
 -1,
 69692297,
 71122,
 69993519,
 69628076,
 -1,
 -64467,
 69961509,
 71118,
 -64466,
 70002978,
 71117,
 -1,
 70067203,
 71116,
 70255667,
 69935288,
 -1,
 -64463,
 70223957,
 71126,
 -64462,
 70283425,
 71125,
 -1,
 70334081,
 71127,
 -64460,
 70220343,
 71124,
 -64459,
 70479470,
 71123,
 -1,
 70527266,
 71121,
 70778879,
 69544325,
 71119,
 -1,
 70649722,
 71120,
 70909951,
 69495250,
 -1,
 -64454,
 70789255,
 71108,
 -1,
 70850764,
 71109,
 71106559,
 69419766,
 -1,
 71107647,
 71012353,
 -1,
 -64450,
 71072066,
 71102,
 -1,
 71135295,
 71103,
 -64448,
 71072787,
 71105,
 -64447,
 71262190,
 71104,
 -64446,
 71310798,
 71100,
 -1,
 71373961,
 71101,
 71566418,
 69374200,
 -1,
 71631946,
 71503633,
 -1,
 71697479,
 71587284,
 71132,
 -1,
 71665815,
 71133,
 -64440,
 71665815,
 71099,
 -64439,
 71778397,
 71097,
 -1,
 71831313,
 71087,
 72025164,
 71602311,
 71092,
 -1,
 71987020,
 71093,
 72156238,
 71993495,
 71090,
 -1,
 72124567,
 71091,
 72287312,
 72106077,
 71088,
 -1,
 72237149,
 71089,
 -64431,
 72245349,
 71098,
 -1,
 72362847,
 71096,
 72549462,
 71529042,
 -1,
 -64428,
 72485578,
 71112,
 -64427,
 72550898,
 71111,
 -1,
 72616278,
 71110,
 72811609,
 72492383,
 -1,
 -64424,
 72771216,
 71107,
 -1,
 72815547,
 71106,
 -1,
 72757077,
 71113,
 73138175,
 64893618,
 -1,
 73139296,
 73044661,
 -1,
 -64419,
 73108435,
 128414,
 -64418,
 73167832,
 128409,
 -64417,
 73224213,
 128408,
 -1,
 73280012,
 128415,
 73531391,
 73079466,
 -1,
 -64414,
 73436115,
 128416,
 -64413,
 73495512,
 128411,
 -64412,
 73551893,
 128410,
 -1,
 73607692,
 128417,
 73794722,
 64838487,
 -1,
 73860248,
 73743183,
 -1,
 73925765,
 73798925,
 -1,
 73991288,
 73883636,
 -1,
 74056813,
 73957710,
 -1,
 -64405,
 74027622,
 70123,
 -64404,
 74071667,
 70124,
 -1,
 74133230,
 70122,
 74318960,
 74020898,
 -1,
 -64401,
 74271171,
 70127,
 -1,
 74330735,
 70128,
 74515571,
 74277640,
 -1,
 -64398,
 74482580,
 70132,
 -1,
 74530832,
 70131,
 74712182,
 74461990,
 -1,
 -64395,
 74671566,
 70125,
 -1,
 74727928,
 70126,
 -64393,
 74669563,
 70130,
 -1,
 74853959,
 70129,
 75104255,
 73934841,
 -1,
 75105404,
 75006286,
 -1,
 -64389,
 75076822,
 70114,
 -1,
 75120466,
 70115,
 75302015,
 75069474,
 -1,
 -64386,
 75254141,
 70118,
 -1,
 75313718,
 70119,
 75498626,
 75248422,
 -1,
 -64383,
 75458314,
 70116,
 -1,
 75516127,
 70117,
 -64381,
 75457284,
 70113,
 -64380,
 75652546,
 70121,
 -1,
 75705856,
 70120,
 75891859,
 73880486,
 -1,
 75957385,
 75858254,
 -1,
 -64376,
 75928790,
 3560,
 -1,
 75972434,
 3561,
 76153996,
 75921442,
 -1,
 -64373,
 76106109,
 3564,
 -1,
 76165686,
 3565,
 76350607,
 76100390,
 -1,
 -64370,
 76310282,
 3562,
 -1,
 76368095,
 3563,
 -64368,
 76323079,
 3558,
 -64367,
 76505860,
 3559,
 -64366,
 76570050,
 3567,
 -1,
 76623360,
 3566,
 76873727,
 75834053,
 -1,
 76874903,
 76771148,
 -1,
 -64362,
 76820509,
 983935,
 -1,
 76878328,
 983934,
 -1,
 76846896,
 983933,
 77201407,
 73808361,
 -1,
 77202591,
 77070336,
 -1,
 77268125,
 77167528,
 -1,
 -64356,
 77239510,
 983154,
 -1,
 77283154,
 983157,
 -64354,
 77216301,
 983182,
 -1,
 77406044,
 983184,
 77660159,
 77138102,
 -1,
 -64351,
 77531850,
 983158,
 -1,
 77597170,
 983155,
 77792421,
 73766398,
 -1,
 -64348,
 77758327,
 128303,
 -1,
 77818692,
 128973,
 -1,
 77746842,
 128510,
 78054805,
 90213,
 983077,
 78120212,
 78026846,
 -1,
 78185696,
 78074281,
 -1,
 78251186,
 78152014,
 -1,
 78316717,
 78217550,
 -1,
 -64340,
 78265045,
 72295,
 -1,
 78319377,
 72294,
 78513328,
 78280738,
 -1,
 -64337,
 78461653,
 72310,
 -1,
 78515985,
 72309,
 -64335,
 78461653,
 72300,
 -1,
 78647057,
 72299,
 78841017,
 78194015,
 -1,
 78906550,
 78783839,
 -1,
 -64331,
 78854869,
 72297,
 -1,
 78909201,
 72296,
 -64329,
 78878842,
 72311,
 -64328,
 79051477,
 72302,
 -1,
 79105809,
 72301,
 79299774,
 78797655,
 -1,
 -64325,
 79271688,
 72293,
 -64324,
 79322032,
 72298,
 -64323,
 79378402,
 72288,
 -1,
 79433489,
 72303,
 79627458,
 79263778,
 -1,
 -64320,
 79591582,
 72320,
 -64319,
 79641301,
 72319,
 -1,
 79695633,
 72321,
 79889606,
 79579843,
 -1,
 -64316,
 79855302,
 72323,
 -64315,
 79903445,
 72285,
 -1,
 79957777,
 72284,
 80151753,
 79861880,
 -1,
 -64312,
 80100053,
 72312,
 -1,
 80154385,
 72313,
 80348364,
 80111825,
 -1,
 -64309,
 80296661,
 72305,
 -1,
 80350993,
 72304,
 80544975,
 80300533,
 -1,
 -64306,
 80493269,
 72292,
 -1,
 80547601,
 72291,
 80741586,
 80492457,
 -1,
 -64303,
 80689877,
 72287,
 -1,
 80744209,
 72286,
 80938197,
 80682295,
 -1,
 -64300,
 80886485,
 72290,
 -1,
 80940817,
 72289,
 81134808,
 80877602,
 -1,
 -64297,
 81083093,
 72307,
 -1,
 81137425,
 72306,
 -64295,
 81106696,
 72315,
 -64294,
 81301063,
 72318,
 -64293,
 81358745,
 72316,
 -64292,
 81417822,
 72308,
 -64291,
 81481033,
 72317,
 -64290,
 81541845,
 72322,
 -64289,
 81596177,
 72272,
 -1,
 81659938,
 72314,
 81855725,
 78132330,
 -1,
 81921251,
 81819682,
 72340,
 -1,
 81869511,
 72339,
 82052325,
 81877847,
 72334,
 -1,
 81999785,
 72332,
 -64282,
 82014028,
 72337,
 -64281,
 82138644,
 72336,
 -64280,
 82201847,
 72338,
 -64279,
 82266819,
 72331,
 -64278,
 82327465,
 72330,
 -64277,
 82388319,
 72333,
 -64276,
 82450466,
 72335,
 -1,
 82511906,
 72341,
 82707708,
 81825990,
 -1,
 82773243,
 82672720,
 -1,
 82838770,
 82743422,
 -1,
 -64271,
 82800460,
 72281,
 -1,
 82857207,
 72282,
 83035380,
 82806935,
 72275,
 -1,
 82979679,
 72274,
 83166454,
 82993253,
 72277,
 -1,
 83110751,
 72278,
 83297529,
 83103505,
 -1,
 -64264,
 83265687,
 72280,
 -1,
 83312733,
 72279,
 -64262,
 83247197,
 72273,
 -1,
 83438431,
 72276,
 -1,
 82727305,
 72283,
 83690753,
 82663240,
 -1,
 -64258,
 83658593,
 72346,
 -64257,
 83720949,
 72347,
 -64256,
 83782662,
 72349,
 -1,
 83831203,
 72348,
 84018439,
 83632563,
 -1,
 84083973,
 83982370,
 -1,
 -64252,
 84032213,
 72328,
 -1,
 84086545,
 72329,
 -64250,
 84045721,
 72326,
 -1,
 84233545,
 72327,
 84411660,
 83982370,
 -1,
 84477195,
 84361974,
 -1,
 -64246,
 84447322,
 72343,
 -1,
 84481161,
 72342,
 -1,
 84445572,
 72345,
 84739344,
 84360348,
 72352,
 84869119,
 84672543,
 -1,
 -64241,
 84772662,
 72350,
 -1,
 84817216,
 72351,
 85001491,
 84706027,
 -1,
 -64238,
 84937202,
 72354,
 -1,
 85002582,
 72353,
 -1,
 84949193,
 72344,
 85263693,
 78067846,
 -1,
 85329199,
 85217705,
 -1,
 85394715,
 85293090,
 -1,
 85460250,
 85331729,
 -1,
 -64231,
 85416067,
 69436,
 -1,
 85469090,
 69439,
 -1,
 85409325,
 69441,
 85722398,
 85347575,
 -1,
 -64227,
 85668167,
 69444,
 -1,
 85725943,
 69433,
 85919008,
 85671051,
 69427,
 -1,
 85885725,
 69430,
 86050083,
 85856017,
 -1,
 -64222,
 86022080,
 69437,
 -1,
 86069661,
 69424,
 -64220,
 86022391,
 69429,
 -64219,
 86218841,
 69431,
 -64218,
 86282724,
 69428,
 -64217,
 86344305,
 69442,
 -64216,
 86405747,
 69440,
 -64215,
 86469196,
 69438,
 -64214,
 86532153,
 69435,
 -64213,
 86595726,
 69434,
 -64212,
 86657858,
 69432,
 -64211,
 86718896,
 69426,
 -64210,
 86782958,
 69443,
 -1,
 86841768,
 69425,
 87033151,
 85271049,
 -1,
 87098675,
 87001163,
 -1,
 -64206,
 87038316,
 69447,
 -1,
 87101383,
 69449,
 87295286,
 87047880,
 -1,
 -64203,
 87234924,
 69453,
 -1,
 87297991,
 69452,
 87491897,
 87238795,
 -1,
 -64200,
 87431532,
 69446,
 -1,
 87494599,
 69448,
 87688508,
 87434539,
 -1,
 -64197,
 87628140,
 69451,
 -1,
 87691207,
 69450,
 -64195,
 87654460,
 69456,
 -64194,
 87847528,
 69455,
 -1,
 87905399,
 69454,
 88081734,
 86994332,
 -1,
 88147268,
 88049725,
 -1,
 88212803,
 88117046,
 69461,
 -1,
 88147504,
 69462,
 -1,
 88154309,
 69464,
 -64187,
 88095592,
 69465,
 -1,
 88350829,
 69463,
 88540492,
 88039412,
 -1,
 88606026,
 88506702,
 -1,
 -64183,
 88576614,
 69459,
 -1,
 88616686,
 69458,
 88866815,
 88564484,
 69457,
 -1,
 88736302,
 69460,
 -1,
 88491044,
 69445,
 88999289,
 85225376,
 -1,
 89064811,
 88953257,
 -1,
 89130323,
 89021271,
 -1,
 -64175,
 89102095,
 69857,
 -64174,
 89143320,
 69847,
 -1,
 89198943,
 69849,
 89392470,
 89085534,
 -1,
 -64171,
 89340615,
 69846,
 -1,
 89402207,
 69864,
 89589081,
 89336671,
 -1,
 -64168,
 89537223,
 69863,
 -1,
 89599443,
 69859,
 -64166,
 89560847,
 69852,
 -64165,
 89755218,
 69850,
 -64164,
 89819775,
 69861,
 -64163,
 89883143,
 69841,
 -64162,
 89946295,
 69840,
 -64161,
 90009559,
 69853,
 -64160,
 90073401,
 69851,
 -64159,
 90136981,
 69862,
 -64158,
 90197425,
 69848,
 -64157,
 90262316,
 69855,
 -64156,
 90327590,
 69856,
 -64155,
 90391373,
 69860,
 -64154,
 90454768,
 69854,
 -64153,
 90519576,
 69845,
 -64152,
 90580500,
 69844,
 -64151,
 90643828,
 69843,
 -64150,
 90708115,
 69842,
 -1,
 90771807,
 69858,
 91029503,
 89008121,
 -1,
 91030895,
 90931534,
 -1,
 -64146,
 91002070,
 69874,
 -1,
 91045714,
 69875,
 91227506,
 90994722,
 -1,
 -64143,
 91179389,
 69878,
 -1,
 91238966,
 69879,
 91424117,
 91173670,
 -1,
 -64140,
 91383562,
 69876,
 -1,
 91441375,
 69877,
 -64138,
 91396359,
 69872,
 -64137,
 91579140,
 69873,
 -64136,
 91643330,
 69881,
 -1,
 91696640,
 69880,
 91882890,
 88968697,
 -1,
 91948418,
 91853447,
 -1,
 92013951,
 91909169,
 -1,
 -64131,
 91983939,
 128601,
 -64130,
 92032911,
 128593,
 -1,
 92085444,
 128609,
 92276097,
 91981515,
 11113,
 -1,
 92210515,
 11129,
 -1,
 92240148,
 129111,
 92536831,
 91892784,
 -1,
 92538247,
 92433457,
 -1,
 -64123,
 92508227,
 128603,
 -64122,
 92557199,
 128595,
 -1,
 92609732,
 128611,
 92800393,
 92505803,
 11112,
 -1,
 92734803,
 11128,
 -1,
 92764436,
 129110,
 92997007,
 91830117,
 -1,
 93062542,
 92930048,
 -1,
 -64115,
 93027146,
 128428,
 -1,
 93077859,
 127846,
 -1,
 93001895,
 129358,
 93324689,
 92951249,
 128618,
 -1,
 93258301,
 128619,
 -64110,
 93288482,
 983181,
 -64109,
 93414117,
 128284,
 -64108,
 93469383,
 983043,
 -1,
 93528415,
 129510,
 93718072,
 78002887,
 -1,
 93783578,
 93654801,
 -1,
 93849112,
 93744972,
 -1,
 93914647,
 93786251,
 -1,
 93980121,
 93868457,
 -1,
 94045601,
 93949493,
 -1,
 94111136,
 94003403,
 -1,
 94176670,
 94072652,
 70025,
 -1,
 94138188,
 70026,
 94371839,
 94129399,
 70027,
 -1,
 94260471,
 70028,
 -1,
 94048017,
 70062,
 94504359,
 94011726,
 -1,
 94569893,
 94470478,
 -1,
 -64092,
 94517973,
 70044,
 -1,
 94572305,
 70043,
 -64090,
 94517973,
 70049,
 -1,
 94703377,
 70048,
 94897580,
 94460759,
 -1,
 -64087,
 94869256,
 70042,
 -64086,
 94919600,
 70047,
 -64085,
 94975970,
 70037,
 -1,
 95031057,
 70052,
 95225266,
 94840159,
 -1,
 95290800,
 95167839,
 -1,
 -64081,
 95238869,
 70046,
 -1,
 95293201,
 70045,
 -64079,
 95238869,
 70051,
 -1,
 95424273,
 70050,
 95618486,
 95162129,
 70019,
 -64076,
 95586455,
 70032,
 -64075,
 95633501,
 70030,
 -1,
 95686417,
 70020,
 95880634,
 95582242,
 -1,
 -64072,
 95844510,
 70064,
 -64071,
 95894229,
 70063,
 -1,
 95948561,
 70065,
 96142780,
 95848599,
 70023,
 -1,
 96110743,
 70024,
 96273855,
 96102609,
 -1,
 -64066,
 96221909,
 70054,
 -1,
 96276241,
 70053,
 96470466,
 96226551,
 -1,
 -64063,
 96423241,
 70061,
 -1,
 96472849,
 70060,
 96667077,
 96422595,
 -1,
 -64060,
 96615125,
 70034,
 -1,
 96669457,
 70033,
 96863688,
 96618997,
 -1,
 -64057,
 96811733,
 70041,
 -1,
 96866065,
 70040,
 97060298,
 96813149,
 70021,
 -1,
 97009757,
 70022,
 97191373,
 97007529,
 -1,
 -64052,
 97139413,
 70036,
 -1,
 97193745,
 70035,
 97387984,
 97131831,
 -1,
 -64049,
 97336021,
 70039,
 -1,
 97390353,
 70038,
 97584595,
 97327138,
 -1,
 -64046,
 97532629,
 70056,
 -1,
 97586961,
 70055,
 -64044,
 97556232,
 70058,
 -64043,
 97742745,
 70059,
 -64042,
 97804389,
 70031,
 -64041,
 97867358,
 70057,
 -64040,
 97925845,
 70066,
 -1,
 97987423,
 70029,
 98174443,
 93950150,
 -1,
 98239978,
 98139216,
 -1,
 98305504,
 98209918,
 -1,
 98371038,
 98266956,
 70072,
 -1,
 98332492,
 70073,
 98566143,
 98323703,
 70074,
 -1,
 98454775,
 70075,
 98633188,
 98242321,
 -1,
 -64030,
 98601111,
 70079,
 -64029,
 98648157,
 70077,
 -1,
 98701073,
 70067,
 98895334,
 98601111,
 70070,
 -1,
 98863255,
 70071,
 99026408,
 98844765,
 70068,
 -1,
 98975837,
 70069,
 -64023,
 98984037,
 70078,
 -1,
 99101535,
 70076,
 -1,
 98196069,
 70091,
 99354111,
 98138146,
 -1,
 99419640,
 99304182,
 -1,
 99485168,
 99389441,
 -1,
 -64017,
 99449154,
 70018,
 -1,
 99512383,
 70080,
 99681779,
 99421969,
 -1,
 -64014,
 99651146,
 70081,
 -1,
 99704893,
 70017,
 -64012,
 99650608,
 70083,
 -64011,
 99843091,
 70107,
 -64010,
 99901422,
 70090,
 -64009,
 99961453,
 70082,
 -1,
 100015566,
 70016,
 100206077,
 99363679,
 -1,
 100271612,
 100148386,
 -1,
 -64005,
 100207090,
 70111,
 -1,
 100272470,
 70110,
 -1,
 100231626,
 70088,
 -64002,
 100175381,
 70093,
 -1,
 100471744,
 70089,
 100664848,
 99296607,
 -1,
 100730382,
 100614889,
 -1,
 100795908,
 100696398,
 -1,
 -63997,
 100766934,
 70098,
 -1,
 100810578,
 70099,
 100992519,
 100759586,
 -1,
 -63994,
 100944253,
 70102,
 -1,
 101003830,
 70103,
 101189130,
 100938534,
 -1,
 -63991,
 101148426,
 70100,
 -1,
 101206239,
 70101,
 -63989,
 101161223,
 70096,
 -63988,
 101344004,
 70097,
 -63987,
 101408194,
 70105,
 -1,
 101461504,
 70104,
 -63985,
 100689552,
 70086,
 -1,
 101585851,
 70085,
 101778963,
 100608863,
 -1,
 -63982,
 101750413,
 70092,
 -1,
 101796670,
 70106,
 -63980,
 101737013,
 70084,
 -63979,
 101924055,
 70108,
 -63978,
 101983029,
 70109,
 -1,
 102043567,
 70087,
 -1,
 93866691,
 129416,
 -63975,
 93818517,
 127847,
 -1,
 102257705,
 129368,
 102434349,
 93741157,
 -1,
 102499879,
 102397896,
 -1,
 102565409,
 102448076,
 -1,
 -63970,
 102534149,
 113827,
 -63969,
 102584818,
 113824,
 -63968,
 102640186,
 113826,
 -1,
 102703943,
 113825,
 102893094,
 102498304,
 -1,
 102958629,
 102832162,
 -1,
 -63964,
 102903718,
 11103,
 -1,
 102961209,
 11087,
 -1,
 102923513,
 11086,
 -1,
 102833532,
 127856,
 103286314,
 102460666,
 -1,
 -63959,
 103253843,
 128722,
 -1,
 103291022,
 128717,
 -63957,
 103256684,
 128703,
 -63956,
 103441980,
 127776,
 -1,
 103489820,
 129327,
 103679539,
 102383709,
 -1,
 103745073,
 103626600,
 -1,
 -63952,
 103704475,
 983075,
 -1,
 103760861,
 983078,
 -63950,
 103704785,
 128674,
 -1,
 103886435,
 128737,
 104072758,
 103640908,
 -1,
 -63947,
 104041054,
 129335,
 -1,
 104088525,
 129424,
 -63945,
 104044205,
 983197,
 -1,
 104213854,
 128017,
 104400533,
 93679207,
 -1,
 104466068,
 104338766,
 -1,
 104531601,
 104408417,
 -1,
 104597081,
 104484087,
 -1,
 104662612,
 104535862,
 -1,
 104728147,
 104603126,
 -1,
 -63937,
 104700024,
 127305,
 -63936,
 104765101,
 127304,
 -63935,
 104830450,
 127303,
 -63934,
 104894005,
 127301,
 -63933,
 104958103,
 127300,
 -63932,
 105021774,
 127299,
 -63931,
 105082700,
 127297,
 -63930,
 105147949,
 127296,
 -63929,
 105209957,
 127294,
 -63928,
 105272852,
 127292,
 -63927,
 105336055,
 127291,
 -63926,
 105401027,
 127290,
 -63925,
 105466357,
 127289,
 -63924,
 105529437,
 127288,
 -63923,
 105593543,
 127287,
 -63922,
 105658281,
 127286,
 -63921,
 105722662,
 127285,
 -63920,
 105786207,
 127284,
 -63919,
 105850207,
 127283,
 -63918,
 105913655,
 127282,
 -1,
 105975569,
 127280,
 -1,
 104693072,
 127397,
 106299391,
 104620133,
 -1,
 106301016,
 106183067,
 -1,
 -63913,
 106259767,
 10191,
 -1,
 106304363,
 10190,
 -1,
 106266401,
 127401,
 106563179,
 104537399,
 -1,
 106628713,
 106515101,
 -1,
 106694239,
 106564961,
 -1,
 -63907,
 106631011,
 127539,
 -63906,
 106696461,
 127538,
 -1,
 106761405,
 127544,
 106956388,
 106630345,
 -1,
 107021923,
 106892780,
 -1,
 -63902,
 106958470,
 127542,
 -1,
 107023879,
 127543,
 -1,
 106965995,
 127541,
 107284072,
 106892319,
 -1,
 -63898,
 107220165,
 127546,
 -63897,
 107285522,
 127540,
 -1,
 107350726,
 127545,
 -1,
 107220741,
 127547,
 -63894,
 106587254,
 127378,
 -1,
 107564279,
 127377,
 107742834,
 106526754,
 -1,
 107808367,
 107686751,
 -1,
 -63890,
 107777749,
 127393,
 -1,
 107815571,
 127388,
 -63888,
 107767251,
 127384,
 -63887,
 107956680,
 127395,
 -1,
 108019777,
 127402,
 108201591,
 107708750,
 -1,
 108267126,
 108171545,
 -1,
 -63883,
 108224631,
 127389,
 -1,
 108277736,
 127394,
 -1,
 108216151,
 127387,
 108529275,
 108149447,
 -1,
 -63879,
 108478694,
 127400,
 -63878,
 108538597,
 127399,
 -1,
 108600631,
 127398,
 108791423,
 108475174,
 -1,
 -63875,
 108753346,
 127379,
 -63874,
 108816176,
 127390,
 -1,
 108874011,
 127392,
 109053570,
 108760629,
 -1,
 -63871,
 109017122,
 127386,
 -1,
 109076757,
 127404,
 109250181,
 109021335,
 -1,
 -63868,
 109209843,
 127385,
 -1,
 109264008,
 127403,
 109446792,
 109207653,
 -1,
 -63865,
 109403310,
 127396,
 -1,
 109464259,
 127383,
 109643403,
 109402967,
 -1,
 -63862,
 109590441,
 127382,
 -1,
 109654703,
 127381,
 109840014,
 109595537,
 -1,
 -63859,
 109803678,
 127490,
 -1,
 109857913,
 127489,
 -63857,
 109810215,
 127311,
 -63856,
 109986202,
 127380,
 -1,
 110046733,
 127391,
 110297087,
 104464384,
 -1,
 -63853,
 110199395,
 128918,
 -1,
 110259367,
 11216,
 -1,
 104415642,
 129425,
 110495420,
 104368279,
 -1,
 110560947,
 110451543,
 -1,
 110626478,
 110503528,
 -1,
 110692002,
 110587305,
 -1,
 110757532,
 110651601,
 -1,
 -63845,
 110726422,
 7362,
 -1,
 110760992,
 7361,
 -63843,
 110723282,
 7360,
 -63842,
 110907973,
 7364,
 -63841,
 110971677,
 7365,
 -63840,
 111027702,
 7366,
 -63839,
 111091079,
 7363,
 -1,
 111155280,
 7367,
 111347369,
 110645673,
 -1,
 111412902,
 111293503,
 -1,
 -63835,
 111367700,
 7103,
 -1,
 111430339,
 7102,
 -63833,
 111375022,
 7099,
 -63832,
 111563329,
 7100,
 -1,
 111614459,
 7101,
 111806124,
 111289090,
 -1,
 -63829,
 111776049,
 7085,
 -1,
 111826526,
 7084,
 -63827,
 111770765,
 7083,
 -1,
 111941579,
 7098,
 112133808,
 110589432,
 127749,
 -1,
 112067457,
 127748,
 -63823,
 112097909,
 127751,
 -63822,
 112211371,
 127803,
 -1,
 112264836,
 127774,
 112461494,
 110524450,
 -1,
 -63819,
 112421545,
 128671,
 -1,
 112475570,
 127843,
 112658105,
 112421578,
 -1,
 -63816,
 112627767,
 129465,
 -1,
 112672133,
 129464,
 112854715,
 112597026,
 983102,
 -1,
 112820170,
 983101,
 -1,
 112816877,
 127940,
 113051362,
 110461262,
 983189,
 113116879,
 112987921,
 -1,
 113182410,
 113078092,
 -1,
 113247943,
 113148333,
 -1,
 113313475,
 113211426,
 -1,
 -63806,
 113280778,
 983180,
 -1,
 113323649,
 983132,
 -63804,
 113279763,
 983044,
 -63803,
 113470814,
 983175,
 -63802,
 113523909,
 983042,
 -1,
 113588849,
 983174,
 113836031,
 113182084,
 -1,
 -63799,
 113734545,
 11243,
 -1,
 113790955,
 11242,
 113968845,
 113148238,
 -1,
 -63796,
 113936960,
 128509,
 -1,
 113985271,
 128649,
 -63794,
 113924793,
 128387,
 -1,
 114108478,
 127967,
 114296531,
 113084567,
 -1,
 -63791,
 114256139,
 128723,
 -63790,
 114308097,
 129369,
 -1,
 114370588,
 127897,
 114558680,
 114257740,
 -1,
 114624215,
 114495249,
 -1,
 -63786,
 114594321,
 127827,
 -1,
 114639470,
 128207,
 -1,
 114574782,
 983188,
 114886365,
 114502495,
 -1,
 114951900,
 114823882,
 -1,
 -63781,
 114902284,
 127836,
 -1,
 114950790,
 128642,
 -1,
 114908825,
 11836,
 115214048,
 114843749,
 -1,
 -63777,
 115174950,
 9201,
 -1,
 115220728,
 128480,
 -63775,
 115185138,
 983045,
 -1,
 115374114,
 983169,
 115541763,
 113010897,
 983117,
 115607279,
 115485535,
 -1,
 115672812,
 115544541,
 -1,
 115738346,
 115617909,
 128264,
 115867647,
 115672452,
 -1,
 -63768,
 115770355,
 128266,
 -63767,
 115827535,
 128265,
 -1,
 115875238,
 128263,
 -63765,
 115688740,
 128483,
 -1,
 116000898,
 128586,
 116260863,
 115616607,
 -1,
 -63762,
 116139663,
 128676,
 -1,
 116203324,
 128172,
 116393718,
 115564645,
 -1,
 116459251,
 116351077,
 -1,
 -63758,
 116415319,
 129348,
 -1,
 116477193,
 129525,
 -63756,
 116428297,
 128051,
 -63755,
 116619225,
 127941,
 -1,
 116678011,
 129533,
 116852477,
 116342877,
 -1,
 116918011,
 116813882,
 -1,
 -63751,
 116882244,
 128026,
 -63750,
 116940569,
 128466,
 -1,
 116989325,
 128467,
 117243903,
 116860745,
 128375,
 -1,
 117114239,
 128376,
 117311234,
 116789009,
 983176,
 117376769,
 117274269,
 -1,
 -63744,
 117327163,
 128150,
 -1,
 117387564,
 10024,
 -1,
 117324083,
 127837,
 -1,
 117263990,
 128166,
 117704479,
 115496468,
 -1,
 117770010,
 117653597,
 -1,
 117835545,
 117724055,
 -1,
 117901078,
 117781330,
 -1,
 117966605,
 117864482,
 -1,
 118032140,
 117922206,
 128522,
 118161407,
 117964831,
 -1,
 -63733,
 118064072,
 129392,
 -1,
 118111160,
 129325,
 -1,
 118000501,
 128526,
 118359826,
 117925107,
 128515,
 118489087,
 118292511,
 -1,
 -63728,
 118391948,
 128518,
 -63727,
 118455737,
 128516,
 -1,
 118497769,
 128517,
 118751231,
 118307527,
 -1,
 -63724,
 118646187,
 128520,
 -63723,
 118696985,
 128525,
 -1,
 118755960,
 128519,
 119013375,
 117841513,
 -1,
 -63720,
 118908147,
 128570,
 -1,
 118963432,
 128571,
 -1,
 117798546,
 128527,
 119211806,
 117707373,
 -1,
 -63716,
 119170392,
 128312,
 -63715,
 119217025,
 128313,
 -1,
 119280020,
 128745,
 -1,
 119169511,
 128684,
 119539511,
 117675693,
 -1,
 119605043,
 119501583,
 -1,
 119670578,
 119541709,
 -1,
 119736113,
 119624150,
 -1,
 119801641,
 119692119,
 -1,
 119867175,
 119757655,
 -1,
 -63706,
 119823280,
 2149,
 -1,
 119869201,
 2148,
 -63704,
 119838472,
 2146,
 -1,
 120010722,
 2144,
 120194860,
 119755731,
 -1,
 -63701,
 120147273,
 2153,
 -1,
 120196881,
 2152,
 -63699,
 120162154,
 2147,
 -63698,
 120356550,
 2154,
 -63697,
 120418201,
 2151,
 -63696,
 120474138,
 2145,
 -1,
 120527355,
 2150,
 -1,
 119701674,
 983202,
 -1,
 119627131,
 128137,
 120850230,
 119561047,
 983094,
 -63691,
 120791063,
 983093,
 -1,
 120852793,
 128333,
 -1,
 120805284,
 128325,
 121112394,
 119475985,
 -1,
 121177921,
 121068375,
 -1,
 121243456,
 121141397,
 -1,
 121308991,
 121191693,
 -1,
 121374526,
 121252042,
 -1,
 -63683,
 121341901,
 128630,
 -1,
 121381428,
 128631,
 -1,
 121328878,
 128632,
 -1,
 121259644,
 128634,
 -1,
 121187146,
 129386,
 121767748,
 121146592,
 -1,
 -63677,
 121726220,
 129429,
 -1,
 121771642,
 43205,
 121964358,
 121733825,
 128752,
 -1,
 121897075,
 128225,
 -63673,
 121935473,
 127927,
 -63672,
 122049972,
 129474,
 -63671,
 122112957,
 127862,
 -1,
 122172403,
 129527,
 122357597,
 121064695,
 -1,
 122423124,
 122301279,
 -1,
 122488658,
 122368019,
 -1,
 122554193,
 122438910,
 -1,
 -63665,
 122519839,
 128164,
 -63664,
 122565453,
 128564,
 -1,
 122621905,
 128716,
 -1,
 122525383,
 128554,
 -63661,
 122457598,
 128373,
 -1,
 122824031,
 128759,
 123012953,
 122372189,
 -1,
 123078488,
 122960253,
 -1,
 -63657,
 123043270,
 128578,
 -1,
 123090775,
 128577,
 -1,
 123018949,
 127829,
 123340636,
 122950746,
 -1,
 -63653,
 123303518,
 11100,
 -1,
 123363789,
 11098,
 -1,
 123299314,
 127920,
 123602792,
 122301279,
 -1,
 123668321,
 123546463,
 -1,
 -63648,
 123611203,
 127793,
 -1,
 123668610,
 128584,
 -63646,
 123634109,
 983168,
 -63645,
 123827605,
 129324,
 -63644,
 123890107,
 11259,
 -63643,
 123949709,
 129331,
 -63642,
 124004425,
 11250,
 -63641,
 124068482,
 129352,
 -1,
 124131023,
 128186,
 124323700,
 123542839,
 -1,
 124389229,
 124284748,
 -1,
 -63637,
 124346909,
 128220,
 -63636,
 124405547,
 128624,
 -1,
 124464474,
 128437,
 124651376,
 124346469,
 -1,
 -63633,
 124614515,
 129410,
 -1,
 124675614,
 128756,
 124847986,
 124600030,
 127979,
 -1,
 124781634,
 127890,
 -63629,
 124797021,
 983185,
 -1,
 124917074,
 129507,
 125110140,
 124279639,
 -1,
 125175672,
 125069404,
 -1,
 -63625,
 125115297,
 127938,
 -1,
 125174058,
 127956,
 125372283,
 125112081,
 -1,
 -63622,
 125324218,
 128013,
 -1,
 125387607,
 128012,
 -1,
 125316460,
 129319,
 125634433,
 125079833,
 -1,
 125699968,
 125570833,
 -1,
 -63617,
 125663887,
 128629,
 -1,
 125721431,
 129442,
 -1,
 125649859,
 127946,
 125962117,
 125597730,
 -1,
 -63613,
 125898513,
 983133,
 -63612,
 125962954,
 983159,
 -1,
 126028274,
 983156,
 126224265,
 125913795,
 -1,
 -63609,
 126192338,
 128128,
 -63608,
 126238815,
 127935,
 -1,
 126293745,
 128761,
 -1,
 126171267,
 983183,
 126553501,
 33102,
 -1,
 126618769,
 126488337,
 -1,
 126683866,
 126573399,
 -1,
 126749401,
 126629801,
 -1,
 126814936,
 126717407,
 -1,
 126880471,
 126755421,
 -1,
 126945279,
 126815433,
 -1,
 127010716,
 126881414,
 -1,
 -63597,
 126946950,
 101050,
 -63596,
 127012359,
 101049,
 -63595,
 127077729,
 101048,
 -63594,
 127143113,
 101047,
 -63593,
 127208479,
 101046,
 -63592,
 127273859,
 101045,
 -63591,
 127339210,
 101044,
 -63590,
 127404530,
 101043,
 -63589,
 127469910,
 101042,
 -1,
 127535302,
 101041,
 127731623,
 126946823,
 -1,
 -63586,
 127667846,
 101040,
 -63585,
 127733255,
 101039,
 -63584,
 127798625,
 101038,
 -63583,
 127864009,
 101037,
 -63582,
 127929375,
 101036,
 -63581,
 127994755,
 101035,
 -63580,
 128060106,
 101034,
 -63579,
 128125426,
 101033,
 -63578,
 128190806,
 101032,
 -1,
 128256198,
 101031,
 128452530,
 127667553,
 -1,
 -63575,
 128388742,
 101030,
 -63574,
 128454151,
 101029,
 -63573,
 128519521,
 101028,
 -63572,
 128584905,
 101027,
 -63571,
 128650271,
 101026,
 -63570,
 128715651,
 101025,
 -63569,
 128781002,
 101024,
 -63568,
 128846322,
 101023,
 -63567,
 128911702,
 101022,
 -1,
 128977094,
 101021,
 129173437,
 128388297,
 -1,
 -63564,
 129109638,
 101020,
 -63563,
 129175047,
 101019,
 -63562,
 129240417,
 101018,
 -63561,
 129305801,
 101017,
 -63560,
 129371167,
 101016,
 -63559,
 129436547,
 101015,
 -63558,
 129501898,
 101014,
 -63557,
 129567218,
 101013,
 -63556,
 129632598,
 101012,
 -1,
 129697990,
 101011,
 129894344,
 129109023,
 -1,
 -63553,
 129830534,
 101010,
 -63552,
 129895943,
 101009,
 -63551,
 129961313,
 101008,
 -63550,
 130026697,
 101007,
 -63549,
 130092063,
 101006,
 -63548,
 130157443,
 101005,
 -63547,
 130222794,
 101004,
 -63546,
 130288114,
 101003,
 -63545,
 130353494,
 101002,
 -1,
 130418886,
 101001,
 130615251,
 129829763,
 -1,
 -63542,
 130551430,
 101000,
 -63541,
 130616839,
 100999,
 -63540,
 130682209,
 100998,
 -63539,
 130747593,
 100997,
 -63538,
 130812959,
 100996,
 -63537,
 130878339,
 100995,
 -63536,
 130943690,
 100994,
 -63535,
 131009010,
 100993,
 -63534,
 131074390,
 100992,
 -1,
 131139782,
 100991,
 131336158,
 130550474,
 -1,
 -63531,
 131272326,
 100990,
 -63530,
 131337735,
 100989,
 -63529,
 131403105,
 100988,
 -63528,
 131468489,
 100987,
 -63527,
 131533855,
 100986,
 -63526,
 131599235,
 100985,
 -63525,
 131664586,
 100984,
 -63524,
 131729906,
 100983,
 -63523,
 131795286,
 100982,
 -1,
 131860678,
 100981,
 132057065,
 131271154,
 -1,
 -63520,
 131993222,
 100980,
 -63519,
 132058631,
 100979,
 -63518,
 132124001,
 100978,
 -63517,
 132189385,
 100977,
 -63516,
 132254751,
 100976,
 -63515,
 132320131,
 100975,
 -63514,
 132385482,
 100974,
 -63513,
 132450802,
 100973,
 -63512,
 132516182,
 100972,
 -1,
 132581574,
 100971,
 132777972,
 131991894,
 -1,
 -63509,
 132714118,
 100970,
 -63508,
 132779527,
 100969,
 -63507,
 132844897,
 100968,
 -63506,
 132910281,
 100967,
 -63505,
 132975647,
 100966,
 -63504,
 133041027,
 100965,
 -63503,
 133106378,
 100964,
 -63502,
 133171698,
 100963,
 -63501,
 133237078,
 100962,
 -1,
 133302470,
 100961,
 133562367,
 132712646,
 -1,
 -63498,
 133435014,
 100960,
 -63497,
 133500423,
 100959,
 -63496,
 133565793,
 100958,
 -63495,
 133631177,
 100957,
 -63494,
 133696543,
 100956,
 -63493,
 133761923,
 100955,
 -63492,
 133827274,
 100954,
 -63491,
 133892594,
 100953,
 -63490,
 133957974,
 100952,
 -1,
 134023366,
 100951,
 134219886,
 126880799,
 -1,
 134285323,
 134155910,
 -1,
 -63486,
 134221446,
 100950,
 -63485,
 134286855,
 100949,
 -63484,
 134352225,
 100948,
 -63483,
 134417609,
 100947,
 -63482,
 134482975,
 100946,
 -63481,
 134548355,
 100945,
 -63480,
 134613706,
 100944,
 -63479,
 134679026,
 100943,
 -63478,
 134744406,
 100942,
 -1,
 134809798,
 100941,
 135006230,
 134221319,
 -1,
 -63475,
 134942342,
 100940,
 -63474,
 135007751,
 100939,
 -63473,
 135073121,
 100938,
 -63472,
 135138505,
 100937,
 -63471,
 135203871,
 100936,
 -63470,
 135269251,
 100935,
 -63469,
 135334602,
 100934,
 -63468,
 135399922,
 100933,
 -63467,
 135465302,
 100932,
 -1,
 135530694,
 100931,
 135727137,
 134942049,
 -1,
 -63464,
 135663238,
 100930,
 -63463,
 135728647,
 100929,
 -63462,
 135794017,
 100928,
 -63461,
 135859401,
 100927,
 -63460,
 135924767,
 100926,
 -63459,
 135990147,
 100925,
 -63458,
 136055498,
 100924,
 -63457,
 136120818,
 100923,
 -63456,
 136186198,
 100922,
 -1,
 136251590,
 100921,
 136448044,
 135662793,
 -1,
 -63453,
 136384134,
 100920,
 -63452,
 136449543,
 100919,
 -63451,
 136514913,
 100918,
 -63450,
 136580297,
 100917,
 -63449,
 136645663,
 100916,
 -63448,
 136711043,
 100915,
 -63447,
 136776394,
 100914,
 -63446,
 136841714,
 100913,
 -63445,
 136907094,
 100912,
 -1,
 136972486,
 100911,
 137168951,
 136383519,
 -1,
 -63442,
 137105030,
 100910,
 -63441,
 137170439,
 100909,
 -63440,
 137235809,
 100908,
 -63439,
 137301193,
 100907,
 -63438,
 137366559,
 100906,
 -63437,
 137431939,
 100905,
 -63436,
 137497290,
 100904,
 -63435,
 137562610,
 100903,
 -63434,
 137627990,
 100902,
 -1,
 137693382,
 100901,
 137889858,
 137104259,
 -1,
 -63431,
 137825926,
 100900,
 -63430,
 137891335,
 100899,
 -63429,
 137956705,
 100898,
 -63428,
 138022089,
 100897,
 -63427,
 138087455,
 100896,
 -63426,
 138152835,
 100895,
 -63425,
 138218186,
 100894,
 -63424,
 138283506,
 100893,
 -63423,
 138348886,
 100892,
 -1,
 138414278,
 100891,
 138610765,
 137824970,
 -1,
 -63420,
 138546822,
 100890,
 -63419,
 138612231,
 100889,
 -63418,
 138677601,
 100888,
 -63417,
 138742985,
 100887,
 -63416,
 138808351,
 100886,
 -63415,
 138873731,
 100885,
 -63414,
 138939082,
 100884,
 -63413,
 139004402,
 100883,
 -63412,
 139069782,
 100882,
 -1,
 139135174,
 100881,
 139331672,
 138545650,
 -1,
 -63409,
 139267718,
 100880,
 -63408,
 139333127,
 100879,
 -63407,
 139398497,
 100878,
 -63406,
 139463881,
 100877,
 -63405,
 139529247,
 100876,
 -63404,
 139594627,
 100875,
 -63403,
 139659978,
 100874,
 -63402,
 139725298,
 100873,
 -63401,
 139790678,
 100872,
 -1,
 139856070,
 100871,
 140052579,
 139266390,
 -1,
 -63398,
 139988614,
 100870,
 -63397,
 140054023,
 100869,
 -63396,
 140119393,
 100868,
 -63395,
 140184777,
 100867,
 -63394,
 140250143,
 100866,
 -63393,
 140315523,
 100865,
 -63392,
 140380874,
 100864,
 -63391,
 140446194,
 100863,
 -63390,
 140511574,
 100862,
 -1,
 140576966,
 100861,
 140836863,
 139987142,
 -1,
 -63387,
 140709510,
 100860,
 -63386,
 140774919,
 100859,
 -63385,
 140840289,
 100858,
 -63384,
 140905673,
 100857,
 -63383,
 140971039,
 100856,
 -63382,
 141036419,
 100855,
 -63381,
 141101770,
 100854,
 -63380,
 141167090,
 100853,
 -63379,
 141232470,
 100852,
 -1,
 141297862,
 100851,
 141494493,
 134155139,
 -1,
 141559930,
 141430406,
 -1,
 -63375,
 141495942,
 100850,
 -63374,
 141561351,
 100849,
 -63373,
 141626721,
 100848,
 -63372,
 141692105,
 100847,
 -63371,
 141757471,
 100846,
 -63370,
 141822851,
 100845,
 -63369,
 141888202,
 100844,
 -63368,
 141953522,
 100843,
 -63367,
 142018902,
 100842,
 -1,
 142084294,
 100841,
 142280837,
 141495815,
 -1,
 -63364,
 142216838,
 100840,
 -63363,
 142282247,
 100839,
 -63362,
 142347617,
 100838,
 -63361,
 142413001,
 100837,
 -63360,
 142478367,
 100836,
 -63359,
 142543747,
 100835,
 -63358,
 142609098,
 100834,
 -63357,
 142674418,
 100833,
 -63356,
 142739798,
 100832,
 -1,
 142805190,
 100831,
 143001744,
 142216545,
 -1,
 -63353,
 142937734,
 100830,
 -63352,
 143003143,
 100829,
 -63351,
 143068513,
 100828,
 -63350,
 143133897,
 100827,
 -63349,
 143199263,
 100826,
 -63348,
 143264643,
 100825,
 -63347,
 143329994,
 100824,
 -63346,
 143395314,
 100823,
 -63345,
 143460694,
 100822,
 -1,
 143526086,
 100821,
 143722651,
 142937289,
 -1,
 -63342,
 143658630,
 100820,
 -63341,
 143724039,
 100819,
 -63340,
 143789409,
 100818,
 -63339,
 143854793,
 100817,
 -63338,
 143920159,
 100816,
 -63337,
 143985539,
 100815,
 -63336,
 144050890,
 100814,
 -63335,
 144116210,
 100813,
 -63334,
 144181590,
 100812,
 -1,
 144246982,
 100811,
 144443558,
 143658015,
 -1,
 -63331,
 144379526,
 100810,
 -63330,
 144444935,
 100809,
 -63329,
 144510305,
 100808,
 -63328,
 144575689,
 100807,
 -63327,
 144641055,
 100806,
 -63326,
 144706435,
 100805,
 -63325,
 144771786,
 100804,
 -63324,
 144837106,
 100803,
 -63323,
 144902486,
 100802,
 -1,
 144967878,
 100801,
 145164465,
 144378755,
 -1,
 -63320,
 145100422,
 100800,
 -63319,
 145165831,
 100799,
 -63318,
 145231201,
 100798,
 -63317,
 145296585,
 100797,
 -63316,
 145361951,
 100796,
 -63315,
 145427331,
 100795,
 -63314,
 145492682,
 100794,
 -63313,
 145558002,
 100793,
 -63312,
 145623382,
 100792,
 -1,
 145688774,
 100791,
 145885372,
 145099466,
 -1,
 -63309,
 145821318,
 100790,
 -63308,
 145886727,
 100789,
 -63307,
 145952097,
 100788,
 -63306,
 146017481,
 100787,
 -63305,
 146082847,
 100786,
 -63304,
 146148227,
 100785,
 -63303,
 146213578,
 100784,
 -63302,
 146278898,
 100783,
 -63301,
 146344278,
 100782,
 -1,
 146409670,
 100781,
 146606279,
 145820146,
 -1,
 -63298,
 146542214,
 100780,
 -63297,
 146607623,
 100779,
 -63296,
 146672993,
 100778,
 -63295,
 146738377,
 100777,
 -63294,
 146803743,
 100776,
 -63293,
 146869123,
 100775,
 -63292,
 146934474,
 100774,
 -63291,
 146999794,
 100773,
 -63290,
 147065174,
 100772,
 -1,
 147130566,
 100771,
 147327186,
 146540886,
 -1,
 -63287,
 147263110,
 100770,
 -63286,
 147328519,
 100769,
 -63285,
 147393889,
 100768,
 -63284,
 147459273,
 100767,
 -63283,
 147524639,
 100766,
 -63282,
 147590019,
 100765,
 -63281,
 147655370,
 100764,
 -63280,
 147720690,
 100763,
 -63279,
 147786070,
 100762,
 -1,
 147851462,
 100761,
 148111359,
 147261638,
 -1,
 -63276,
 147984006,
 100760,
 -63275,
 148049415,
 100759,
 -63274,
 148114785,
 100758,
 -63273,
 148180169,
 100757,
 -63272,
 148245535,
 100756,
 -63271,
 148310915,
 100755,
 -63270,
 148376266,
 100754,
 -63269,
 148441586,
 100753,
 -63268,
 148506966,
 100752,
 -1,
 148572358,
 100751,
 148769100,
 141429450,
 -1,
 148834537,
 148704902,
 -1,
 -63264,
 148770438,
 100750,
 -63263,
 148835847,
 100749,
 -63262,
 148901217,
 100748,
 -63261,
 148966601,
 100747,
 -63260,
 149031967,
 100746,
 -63259,
 149097347,
 100745,
 -63258,
 149162698,
 100744,
 -63257,
 149228018,
 100743,
 -63256,
 149293398,
 100742,
 -1,
 149358790,
 100741,
 149555444,
 148770311,
 -1,
 -63253,
 149491334,
 100740,
 -63252,
 149556743,
 100739,
 -63251,
 149622113,
 100738,
 -63250,
 149687497,
 100737,
 -63249,
 149752863,
 100736,
 -63248,
 149818243,
 100735,
 -63247,
 149883594,
 100734,
 -63246,
 149948914,
 100733,
 -63245,
 150014294,
 100732,
 -1,
 150079686,
 100731,
 150276351,
 149491041,
 -1,
 -63242,
 150212230,
 100730,
 -63241,
 150277639,
 100729,
 -63240,
 150343009,
 100728,
 -63239,
 150408393,
 100727,
 -63238,
 150473759,
 100726,
 -63237,
 150539139,
 100725,
 -63236,
 150604490,
 100724,
 -63235,
 150669810,
 100723,
 -63234,
 150735190,
 100722,
 -1,
 150800582,
 100721,
 150997258,
 150211785,
 -1,
 -63231,
 150933126,
 100720,
 -63230,
 150998535,
 100719,
 -63229,
 151063905,
 100718,
 -63228,
 151129289,
 100717,
 -63227,
 151194655,
 100716,
 -63226,
 151260035,
 100715,
 -63225,
 151325386,
 100714,
 -63224,
 151390706,
 100713,
 -63223,
 151456086,
 100712,
 -1,
 151521478,
 100711,
 151718165,
 150932511,
 -1,
 -63220,
 151654022,
 100710,
 -63219,
 151719431,
 100709,
 -63218,
 151784801,
 100708,
 -63217,
 151850185,
 100707,
 -63216,
 151915551,
 100706,
 -63215,
 151980931,
 100705,
 -63214,
 152046282,
 100704,
 -63213,
 152111602,
 100703,
 -63212,
 152176982,
 100702,
 -1,
 152242374,
 100701,
 152439072,
 151653251,
 -1,
 -63209,
 152374918,
 100700,
 -63208,
 152440327,
 100699,
 -63207,
 152505697,
 100698,
 -63206,
 152571081,
 100697,
 -63205,
 152636447,
 100696,
 -63204,
 152701827,
 100695,
 -63203,
 152767178,
 100694,
 -63202,
 152832498,
 100693,
 -63201,
 152897878,
 100692,
 -1,
 152963270,
 100691,
 153159979,
 152373962,
 -1,
 -63198,
 153095814,
 100690,
 -63197,
 153161223,
 100689,
 -63196,
 153226593,
 100688,
 -63195,
 153291977,
 100687,
 -63194,
 153357343,
 100686,
 -63193,
 153422723,
 100685,
 -63192,
 153488074,
 100684,
 -63191,
 153553394,
 100683,
 -63190,
 153618774,
 100682,
 -1,
 153684166,
 100681,
 153880886,
 153094642,
 -1,
 -63187,
 153816710,
 100680,
 -63186,
 153882119,
 100679,
 -63185,
 153947489,
 100678,
 -63184,
 154012873,
 100677,
 -63183,
 154078239,
 100676,
 -63182,
 154143619,
 100675,
 -63181,
 154208970,
 100674,
 -63180,
 154274290,
 100673,
 -63179,
 154339670,
 100672,
 -1,
 154405062,
 100671,
 154601793,
 153815382,
 -1,
 -63176,
 154537606,
 100670,
 -63175,
 154603015,
 100669,
 -63174,
 154668385,
 100668,
 -63173,
 154733769,
 100667,
 -63172,
 154799135,
 100666,
 -63171,
 154864515,
 100665,
 -63170,
 154929866,
 100664,
 -63169,
 154995186,
 100663,
 -63168,
 155060566,
 100662,
 -1,
 155125958,
 100661,
 155385855,
 154536134,
 -1,
 -63165,
 155258502,
 100660,
 -63164,
 155323911,
 100659,
 -63163,
 155389281,
 100658,
 -63162,
 155454665,
 100657,
 -63161,
 155520031,
 100656,
 -63160,
 155585411,
 100655,
 -63159,
 155650762,
 100654,
 -63158,
 155716082,
 100653,
 -63157,
 155781462,
 100652,
 -1,
 155846854,
 100651,
 156043707,
 148703730,
 -1,
 156109144,
 155979398,
 -1,
 -63153,
 156044934,
 100650,
 -63152,
 156110343,
 100649,
 -63151,
 156175713,
 100648,
 -63150,
 156241097,
 100647,
 -63149,
 156306463,
 100646,
 -63148,
 156371843,
 100645,
 -63147,
 156437194,
 100644,
 -63146,
 156502514,
 100643,
 -63145,
 156567894,
 100642,
 -1,
 156633286,
 100641,
 156830051,
 156044807,
 -1,
 -63142,
 156765830,
 100640,
 -63141,
 156831239,
 100639,
 -63140,
 156896609,
 100638,
 -63139,
 156961993,
 100637,
 -63138,
 157027359,
 100636,
 -63137,
 157092739,
 100635,
 -63136,
 157158090,
 100634,
 -63135,
 157223410,
 100633,
 -63134,
 157288790,
 100632,
 -1,
 157354182,
 100631,
 157550958,
 156765537,
 -1,
 -63131,
 157486726,
 100630,
 -63130,
 157552135,
 100629,
 -63129,
 157617505,
 100628,
 -63128,
 157682889,
 100627,
 -63127,
 157748255,
 100626,
 -63126,
 157813635,
 100625,
 -63125,
 157878986,
 100624,
 -63124,
 157944306,
 100623,
 -63123,
 158009686,
 100622,
 -1,
 158075078,
 100621,
 158271865,
 157486281,
 -1,
 -63120,
 158207622,
 100620,
 -63119,
 158273031,
 100619,
 -63118,
 158338401,
 100618,
 -63117,
 158403785,
 100617,
 -63116,
 158469151,
 100616,
 -63115,
 158534531,
 100615,
 -63114,
 158599882,
 100614,
 -63113,
 158665202,
 100613,
 -63112,
 158730582,
 100612,
 -1,
 158795974,
 100611,
 158992772,
 158207007,
 -1,
 -63109,
 158928518,
 100610,
 -63108,
 158993927,
 100609,
 -63107,
 159059297,
 100608,
 -63106,
 159124681,
 100607,
 -63105,
 159190047,
 100606,
 -63104,
 159255427,
 100605,
 -63103,
 159320778,
 100604,
 -63102,
 159386098,
 100603,
 -63101,
 159451478,
 100602,
 -1,
 159516870,
 100601,
 159713679,
 158927747,
 -1,
 -63098,
 159649414,
 100600,
 -63097,
 159714823,
 100599,
 -63096,
 159780193,
 100598,
 -63095,
 159845577,
 100597,
 -63094,
 159910943,
 100596,
 -63093,
 159976323,
 100595,
 -63092,
 160041674,
 100594,
 -63091,
 160106994,
 100593,
 -63090,
 160172374,
 100592,
 -1,
 160237766,
 100591,
 160434586,
 159648458,
 -1,
 -63087,
 160370310,
 100590,
 -63086,
 160435719,
 100589,
 -63085,
 160501089,
 100588,
 -63084,
 160566473,
 100587,
 -63083,
 160631839,
 100586,
 -63082,
 160697219,
 100585,
 -63081,
 160762570,
 100584,
 -63080,
 160827890,
 100583,
 -63079,
 160893270,
 100582,
 -1,
 160958662,
 100581,
 161155493,
 160369138,
 -1,
 -63076,
 161091206,
 100580,
 -63075,
 161156615,
 100579,
 -63074,
 161221985,
 100578,
 -63073,
 161287369,
 100577,
 -63072,
 161352735,
 100576,
 -63071,
 161418115,
 100575,
 -63070,
 161483466,
 100574,
 -63069,
 161548786,
 100573,
 -63068,
 161614166,
 100572,
 -1,
 161679558,
 100571,
 161876400,
 161089878,
 -1,
 -63065,
 161812102,
 100570,
 -63064,
 161877511,
 100569,
 -63063,
 161942881,
 100568,
 -63062,
 162008265,
 100567,
 -63061,
 162073631,
 100566,
 -63060,
 162139011,
 100565,
 -63059,
 162204362,
 100564,
 -63058,
 162269682,
 100563,
 -63057,
 162335062,
 100562,
 -1,
 162400454,
 100561,
 162660351,
 161810630,
 -1,
 -63054,
 162532998,
 100560,
 -63053,
 162598407,
 100559,
 -63052,
 162663777,
 100558,
 -63051,
 162729161,
 100557,
 -63050,
 162794527,
 100556,
 -63049,
 162859907,
 100555,
 -63048,
 162925258,
 100554,
 -63047,
 162990578,
 100553,
 -63046,
 163055958,
 100552,
 -1,
 163121350,
 100551,
 163318314,
 155978070,
 -1,
 163383751,
 163253894,
 -1,
 -63042,
 163319430,
 100550,
 -63041,
 163384839,
 100549,
 -63040,
 163450209,
 100548,
 -63039,
 163515593,
 100547,
 -63038,
 163580959,
 100546,
 -63037,
 163646339,
 100545,
 -63036,
 163711690,
 100544,
 -63035,
 163777010,
 100543,
 -63034,
 163842390,
 100542,
 -1,
 163907782,
 100541,
 164104658,
 163319303,
 -1,
 -63031,
 164040326,
 100540,
 -63030,
 164105735,
 100539,
 -63029,
 164171105,
 100538,
 -63028,
 164236489,
 100537,
 -63027,
 164301855,
 100536,
 -63026,
 164367235,
 100535,
 -63025,
 164432586,
 100534,
 -63024,
 164497906,
 100533,
 -63023,
 164563286,
 100532,
 -1,
 164628678,
 100531,
 164825565,
 164040033,
 -1,
 -63020,
 164761222,
 100530,
 -63019,
 164826631,
 100529,
 -63018,
 164892001,
 100528,
 -63017,
 164957385,
 100527,
 -63016,
 165022751,
 100526,
 -63015,
 165088131,
 100525,
 -63014,
 165153482,
 100524,
 -63013,
 165218802,
 100523,
 -63012,
 165284182,
 100522,
 -1,
 165349574,
 100521,
 165546472,
 164760777,
 -1,
 -63009,
 165482118,
 100520,
 -63008,
 165547527,
 100519,
 -63007,
 165612897,
 100518,
 -63006,
 165678281,
 100517,
 -63005,
 165743647,
 100516,
 -63004,
 165809027,
 100515,
 -63003,
 165874378,
 100514,
 -63002,
 165939698,
 100513,
 -63001,
 166005078,
 100512,
 -1,
 166070470,
 100511,
 166267379,
 165481503,
 -1,
 -62998,
 166203014,
 100510,
 -62997,
 166268423,
 100509,
 -62996,
 166333793,
 100508,
 -62995,
 166399177,
 100507,
 -62994,
 166464543,
 100506,
 -62993,
 166529923,
 100505,
 -62992,
 166595274,
 100504,
 -62991,
 166660594,
 100503,
 -62990,
 166725974,
 100502,
 -1,
 166791366,
 100501,
 166988286,
 166202243,
 -1,
 -62987,
 166923910,
 100500,
 -62986,
 166989319,
 100499,
 -62985,
 167054689,
 100498,
 -62984,
 167120073,
 100497,
 -62983,
 167185439,
 100496,
 -62982,
 167250819,
 100495,
 -62981,
 167316170,
 100494,
 -62980,
 167381490,
 100493,
 -62979,
 167446870,
 100492,
 -1,
 167512262,
 100491,
 167709193,
 166922954,
 -1,
 -62976,
 167644806,
 100490,
 -62975,
 167710215,
 100489,
 -62974,
 167775585,
 100488,
 -62973,
 167840969,
 100487,
 -62972,
 167906335,
 100486,
 -62971,
 167971715,
 100485,
 -62970,
 168037066,
 100484,
 -62969,
 168102386,
 100483,
 -62968,
 168167766,
 100482,
 -1,
 168233158,
 100481,
 168430100,
 167643634,
 -1,
 -62965,
 168365702,
 100480,
 -62964,
 168431111,
 100479,
 -62963,
 168496481,
 100478,
 -62962,
 168561865,
 100477,
 -62961,
 168627231,
 100476,
 -62960,
 168692611,
 100475,
 -62959,
 168757962,
 100474,
 -62958,
 168823282,
 100473,
 -62957,
 168888662,
 100472,
 -1,
 168954054,
 100471,
 169151007,
 168364374,
 -1,
 -62954,
 169086598,
 100470,
 -62953,
 169152007,
 100469,
 -62952,
 169217377,
 100468,
 -62951,
 169282761,
 100467,
 -62950,
 169348127,
 100466,
 -62949,
 169413507,
 100465,
 -62948,
 169478858,
 100464,
 -62947,
 169544178,
 100463,
 -62946,
 169609558,
 100462,
 -1,
 169674950,
 100461,
 169934847,
 169085126,
 -1,
 -62943,
 169807494,
 100460,
 -62942,
 169872903,
 100459,
 -62941,
 169938273,
 100458,
 -62940,
 170003657,
 100457,
 -62939,
 170069023,
 100456,
 -62938,
 170134403,
 100455,
 -62937,
 170199754,
 100454,
 -62936,
 170265074,
 100453,
 -62935,
 170330454,
 100452,
 -1,
 170395846,
 100451,
 170592920,
 163252422,
 -1,
 170658358,
 170528390,
 -1,
 -62931,
 170593926,
 100450,
 -62930,
 170659335,
 100449,
 -62929,
 170724705,
 100448,
 -62928,
 170790089,
 100447,
 -62927,
 170855455,
 100446,
 -62926,
 170920835,
 100445,
 -62925,
 170986186,
 100444,
 -62924,
 171051506,
 100443,
 -62923,
 171116886,
 100442,
 -1,
 171182278,
 100441,
 171379265,
 170593799,
 -1,
 -62920,
 171314822,
 100440,
 -62919,
 171380231,
 100439,
 -62918,
 171445601,
 100438,
 -62917,
 171510985,
 100437,
 -62916,
 171576351,
 100436,
 -62915,
 171641731,
 100435,
 -62914,
 171707082,
 100434,
 -62913,
 171772402,
 100433,
 -62912,
 171837782,
 100432,
 -1,
 171903174,
 100431,
 172100172,
 171314529,
 -1,
 -62909,
 172035718,
 100430,
 -62908,
 172101127,
 100429,
 -62907,
 172166497,
 100428,
 -62906,
 172231881,
 100427,
 -62905,
 172297247,
 100426,
 -62904,
 172362627,
 100425,
 -62903,
 172427978,
 100424,
 -62902,
 172493298,
 100423,
 -62901,
 172558678,
 100422,
 -1,
 172624070,
 100421,
 172821079,
 172035273,
 -1,
 -62898,
 172756614,
 100420,
 -62897,
 172822023,
 100419,
 -62896,
 172887393,
 100418,
 -62895,
 172952777,
 100417,
 -62894,
 173018143,
 100416,
 -62893,
 173083523,
 100415,
 -62892,
 173148874,
 100414,
 -62891,
 173214194,
 100413,
 -62890,
 173279574,
 100412,
 -1,
 173344966,
 100411,
 173541986,
 172755999,
 -1,
 -62887,
 173477510,
 100410,
 -62886,
 173542919,
 100409,
 -62885,
 173608289,
 100408,
 -62884,
 173673673,
 100407,
 -62883,
 173739039,
 100406,
 -62882,
 173804419,
 100405,
 -62881,
 173869770,
 100404,
 -62880,
 173935090,
 100403,
 -62879,
 174000470,
 100402,
 -1,
 174065862,
 100401,
 174262893,
 173476739,
 -1,
 -62876,
 174198406,
 100400,
 -62875,
 174263815,
 100399,
 -62874,
 174329185,
 100398,
 -62873,
 174394569,
 100397,
 -62872,
 174459935,
 100396,
 -62871,
 174525315,
 100395,
 -62870,
 174590666,
 100394,
 -62869,
 174655986,
 100393,
 -62868,
 174721366,
 100392,
 -1,
 174786758,
 100391,
 174983800,
 174197450,
 -1,
 -62865,
 174919302,
 100390,
 -62864,
 174984711,
 100389,
 -62863,
 175050081,
 100388,
 -62862,
 175115465,
 100387,
 -62861,
 175180831,
 100386,
 -62860,
 175246211,
 100385,
 -62859,
 175311562,
 100384,
 -62858,
 175376882,
 100383,
 -62857,
 175442262,
 100382,
 -1,
 175507654,
 100381,
 175704707,
 174918130,
 -1,
 -62854,
 175640198,
 100380,
 -62853,
 175705607,
 100379,
 -62852,
 175770977,
 100378,
 -62851,
 175836361,
 100377,
 -62850,
 175901727,
 100376,
 -62849,
 175967107,
 100375,
 -62848,
 176032458,
 100374,
 -62847,
 176097778,
 100373,
 -62846,
 176163158,
 100372,
 -1,
 176228550,
 100371,
 176425614,
 175638870,
 -1,
 -62843,
 176361094,
 100370,
 -62842,
 176426503,
 100369,
 -62841,
 176491873,
 100368,
 -62840,
 176557257,
 100367,
 -62839,
 176622623,
 100366,
 -62838,
 176688003,
 100365,
 -62837,
 176753354,
 100364,
 -62836,
 176818674,
 100363,
 -62835,
 176884054,
 100362,
 -1,
 176949446,
 100361,
 177209343,
 176359622,
 -1,
 -62832,
 177081990,
 100360,
 -62831,
 177147399,
 100359,
 -62830,
 177212769,
 100358,
 -62829,
 177278153,
 100357,
 -62828,
 177343519,
 100356,
 -62827,
 177408899,
 100355,
 -62826,
 177474250,
 100354,
 -62825,
 177539570,
 100353,
 -1,
 177604950,
 100352,
 177864703,
 170528097,
 -1,
 177867428,
 177736579,
 -1,
 -62821,
 177802886,
 101100,
 -62820,
 177868295,
 101099,
 -62819,
 177933665,
 101098,
 -62818,
 177999049,
 101097,
 -62817,
 178064415,
 101096,
 -62816,
 178129795,
 101095,
 -62815,
 178195146,
 101094,
 -62814,
 178260466,
 101093,
 -62813,
 178325846,
 101092,
 -1,
 178391238,
 101091,
 178588335,
 177801930,
 -1,
 -62810,
 178523782,
 101090,
 -62809,
 178589191,
 101089,
 -62808,
 178654561,
 101088,
 -62807,
 178719945,
 101087,
 -62806,
 178785311,
 101086,
 -62805,
 178850691,
 101085,
 -62804,
 178916042,
 101084,
 -62803,
 178981362,
 101083,
 -62802,
 179046742,
 101082,
 -1,
 179112134,
 101081,
 179309242,
 178522610,
 -1,
 -62799,
 179244678,
 101080,
 -62798,
 179310087,
 101079,
 -62797,
 179375457,
 101078,
 -62796,
 179440841,
 101077,
 -62795,
 179506207,
 101076,
 -62794,
 179571587,
 101075,
 -62793,
 179636938,
 101074,
 -62792,
 179702258,
 101073,
 -62791,
 179767638,
 101072,
 -1,
 179833030,
 101071,
 180030149,
 179243350,
 -1,
 -62788,
 179965574,
 101070,
 -62787,
 180030983,
 101069,
 -62786,
 180096353,
 101068,
 -62785,
 180161737,
 101067,
 -62784,
 180227103,
 101066,
 -62783,
 180292483,
 101065,
 -62782,
 180357834,
 101064,
 -62781,
 180423154,
 101063,
 -62780,
 180488534,
 101062,
 -1,
 180553926,
 101061,
 180751056,
 179964102,
 -1,
 -62777,
 180686470,
 101060,
 -62776,
 180751879,
 101059,
 -62775,
 180817249,
 101058,
 -62774,
 180882633,
 101057,
 -62773,
 180947999,
 101056,
 -62772,
 181013379,
 101055,
 -62771,
 181078730,
 101054,
 -62770,
 181144050,
 101053,
 -62769,
 181209430,
 101052,
 -1,
 181274822,
 101051,
 181534719,
 180685855,
 -1,
 -62766,
 181406751,
 101106,
 -62765,
 181472131,
 101105,
 -62764,
 181537482,
 101104,
 -62763,
 181602802,
 101103,
 -62762,
 181668182,
 101102,
 -1,
 181733574,
 101101,
 -1,
 126830765,
 94176,
 -1,
 126759133,
 127818,
 -1,
 126685073,
 127883,
 182127662,
 126638489,
 -1,
 182193173,
 182092017,
 -1,
 182258461,
 182147927,
 -1,
 182323959,
 182213463,
 -1,
 182389483,
 182278999,
 -1,
 182455011,
 182325009,
 -1,
 -62751,
 182421655,
 983864,
 -62750,
 182468701,
 983861,
 -1,
 182521617,
 983854,
 182717157,
 182421655,
 983857,
 -1,
 182683799,
 983858,
 182848231,
 182673509,
 983862,
 -1,
 182804581,
 983863,
 182979305,
 182796381,
 983855,
 -1,
 182927453,
 983856,
 183173119,
 182922079,
 983859,
 -1,
 183053151,
 983860,
 183241455,
 182325009,
 -1,
 -62739,
 183208087,
 983732,
 -62738,
 183255133,
 983729,
 -1,
 183308049,
 983722,
 183503601,
 183208087,
 983725,
 -1,
 183470231,
 983726,
 183634675,
 183459941,
 983730,
 -1,
 183591013,
 983731,
 183765749,
 183582813,
 983723,
 -1,
 183713885,
 983724,
 183959551,
 183708511,
 983727,
 -1,
 183839583,
 983728,
 184027908,
 182294189,
 -1,
 184093436,
 183963409,
 -1,
 -62726,
 184060055,
 983710,
 -62725,
 184107101,
 983707,
 -1,
 184160017,
 983700,
 184355582,
 184060055,
 983703,
 -1,
 184322199,
 983704,
 184486656,
 184311909,
 983708,
 -1,
 184442981,
 983709,
 184617730,
 184434781,
 983701,
 -1,
 184565853,
 983702,
 184811519,
 184560479,
 983705,
 -1,
 184691551,
 983706,
 184879889,
 183973801,
 -1,
 184945417,
 184815377,
 -1,
 -62713,
 184912023,
 983688,
 -62712,
 184959069,
 983685,
 -1,
 185011985,
 983678,
 185207563,
 184912023,
 983681,
 -1,
 185174167,
 983682,
 185338637,
 185163877,
 983686,
 -1,
 185294949,
 983687,
 185469711,
 185286749,
 983679,
 -1,
 185417821,
 983680,
 185663487,
 185412447,
 983683,
 -1,
 185543519,
 983684,
 185731861,
 184815377,
 -1,
 -62701,
 185698455,
 983754,
 -62700,
 185745501,
 983751,
 -1,
 185798417,
 983744,
 185994007,
 185698455,
 983747,
 -1,
 185960599,
 983748,
 186125081,
 185950309,
 983752,
 -1,
 186081381,
 983753,
 186256155,
 186073181,
 983745,
 -1,
 186204253,
 983746,
 186449919,
 186198879,
 983749,
 -1,
 186329951,
 983750,
 186518341,
 182220834,
 -1,
 186583852,
 186464967,
 -1,
 186649379,
 186519313,
 -1,
 -62687,
 186615959,
 983886,
 -62686,
 186663005,
 983883,
 -1,
 186715921,
 983876,
 186911525,
 186615959,
 983879,
 -1,
 186878103,
 983880,
 187042599,
 186867813,
 983884,
 -1,
 186998885,
 983885,
 187173673,
 186990685,
 983877,
 -1,
 187121757,
 983878,
 187304747,
 187116383,
 983881,
 -1,
 187247455,
 983882,
 -1,
 187266325,
 983932,
 187501369,
 186546210,
 -1,
 187566897,
 187436817,
 -1,
 -62673,
 187533463,
 983897,
 -62672,
 187580509,
 983894,
 -1,
 187633425,
 983887,
 187829043,
 187533463,
 983890,
 -1,
 187795607,
 983891,
 187960117,
 187785317,
 983895,
 -1,
 187916389,
 983896,
 188091191,
 187908189,
 983888,
 -1,
 188039261,
 983889,
 188284927,
 188033887,
 983892,
 -1,
 188164959,
 983893,
 188353341,
 187436817,
 -1,
 -62661,
 188319895,
 983908,
 -62660,
 188366941,
 983905,
 -1,
 188419857,
 983898,
 188615487,
 188319895,
 983901,
 -1,
 188582039,
 983902,
 188746561,
 188571749,
 983906,
 -1,
 188702821,
 983907,
 188877635,
 188694621,
 983899,
 -1,
 188825693,
 983900,
 189071359,
 188820319,
 983903,
 -1,
 188951391,
 983904,
 189139820,
 186469623,
 -1,
 189205344,
 189091063,
 -1,
 189270868,
 189156599,
 -1,
 189336396,
 189206289,
 -1,
 -62646,
 189302935,
 983831,
 -62645,
 189349981,
 983828,
 -1,
 189402897,
 983821,
 189598542,
 189302935,
 983824,
 -1,
 189565079,
 983825,
 189729616,
 189554789,
 983829,
 -1,
 189685861,
 983830,
 189860690,
 189677661,
 983822,
 -1,
 189808733,
 983823,
 190054399,
 189803359,
 983826,
 -1,
 189934431,
 983827,
 190122840,
 189206289,
 -1,
 -62634,
 190089367,
 983842,
 -62633,
 190136413,
 983839,
 -1,
 190189329,
 983832,
 190384986,
 190089367,
 983835,
 -1,
 190351511,
 983836,
 190516060,
 190341221,
 983840,
 -1,
 190472293,
 983841,
 190647134,
 190464093,
 983833,
 -1,
 190595165,
 983834,
 190840831,
 190589791,
 983837,
 -1,
 190720863,
 983838,
 190909284,
 189140753,
 -1,
 -62622,
 190875799,
 983809,
 -62621,
 190922845,
 983806,
 -1,
 190975761,
 983799,
 191171430,
 190875799,
 983802,
 -1,
 191137943,
 983803,
 191302504,
 191127653,
 983807,
 -1,
 191258725,
 983808,
 191433578,
 191250525,
 983800,
 -1,
 191381597,
 983801,
 191627263,
 191376223,
 983804,
 -1,
 191507295,
 983805,
 191695750,
 189090499,
 -1,
 191761274,
 191659715,
 -1,
 191826802,
 191696657,
 983920,
 -62608,
 191793303,
 983931,
 -62607,
 191840349,
 983928,
 -1,
 191893265,
 983921,
 192088948,
 191793303,
 983924,
 -1,
 192055447,
 983925,
 192220022,
 192045157,
 983929,
 -1,
 192176229,
 983930,
 192351096,
 192168029,
 983922,
 -1,
 192299101,
 983923,
 192544767,
 192293727,
 983926,
 -1,
 192424799,
 983927,
 192613246,
 191696657,
 -1,
 -62596,
 192579735,
 983677,
 -62595,
 192626781,
 983674,
 -1,
 192679697,
 983667,
 192875392,
 192579735,
 983670,
 -1,
 192841879,
 983671,
 193006466,
 192831589,
 983675,
 -1,
 192962661,
 983676,
 193137540,
 192954461,
 983668,
 -1,
 193085533,
 983669,
 193331199,
 193080159,
 983672,
 -1,
 193211231,
 983673,
 193399712,
 191660366,
 -1,
 193465236,
 193364302,
 -1,
 193530764,
 193400593,
 -1,
 -62582,
 193497239,
 983721,
 -62581,
 193544285,
 983718,
 -1,
 193597201,
 983711,
 193792910,
 193497239,
 983714,
 -1,
 193759383,
 983715,
 193923984,
 193749093,
 983719,
 -1,
 193880165,
 983720,
 194055058,
 193871965,
 983712,
 -1,
 194003037,
 983713,
 194248703,
 193997663,
 983716,
 -1,
 194128735,
 983717,
 194317208,
 193400593,
 -1,
 -62570,
 194283671,
 983743,
 -62569,
 194330717,
 983740,
 -1,
 194383633,
 983733,
 194579354,
 194283671,
 983736,
 -1,
 194545815,
 983737,
 194710428,
 194535525,
 983741,
 -1,
 194666597,
 983742,
 194841502,
 194658397,
 983734,
 -1,
 194789469,
 983735,
 195035135,
 194784095,
 983738,
 -1,
 194915167,
 983739,
 195103674,
 193359692,
 -1,
 195169198,
 195063628,
 -1,
 195234726,
 195104529,
 -1,
 -62556,
 195201175,
 983853,
 -62555,
 195248221,
 983850,
 -1,
 195301137,
 983843,
 195496872,
 195201175,
 983846,
 -1,
 195463319,
 983847,
 195627946,
 195453029,
 983851,
 -1,
 195584101,
 983852,
 195759020,
 195575901,
 983844,
 -1,
 195706973,
 983845,
 195952639,
 195701599,
 983848,
 -1,
 195832671,
 983849,
 196021170,
 195104529,
 -1,
 -62544,
 195987607,
 983798,
 -62543,
 196034653,
 983795,
 -1,
 196087569,
 983788,
 196283316,
 195987607,
 983791,
 -1,
 196249751,
 983792,
 196414390,
 196239461,
 983796,
 -1,
 196370533,
 983797,
 196545464,
 196362333,
 983789,
 -1,
 196493405,
 983790,
 196739071,
 196488031,
 983793,
 -1,
 196619103,
 983794,
 196807623,
 195073709,
 -1,
 196873151,
 196742929,
 -1,
 -62531,
 196839575,
 983787,
 -62530,
 196886621,
 983784,
 -1,
 196939537,
 983777,
 197135297,
 196839575,
 983780,
 -1,
 197101719,
 983781,
 197266371,
 197091429,
 983785,
 -1,
 197222501,
 983786,
 197397445,
 197214301,
 983778,
 -1,
 197345373,
 983779,
 197591039,
 197339999,
 983782,
 -1,
 197471071,
 983783,
 197659604,
 196775477,
 -1,
 197725132,
 197594897,
 -1,
 -62518,
 197691543,
 983820,
 -62517,
 197738589,
 983817,
 -1,
 197791505,
 983810,
 197987278,
 197691543,
 983813,
 -1,
 197953687,
 983814,
 198118352,
 197943397,
 983818,
 -1,
 198074469,
 983819,
 198249426,
 198066269,
 983811,
 -1,
 198197341,
 983812,
 198443007,
 198191967,
 983815,
 -1,
 198323039,
 983816,
 198511585,
 197617873,
 -1,
 198577113,
 198446865,
 -1,
 -62505,
 198543511,
 983765,
 -62504,
 198590557,
 983762,
 -1,
 198643473,
 983755,
 198839259,
 198543511,
 983758,
 -1,
 198805655,
 983759,
 198970333,
 198795365,
 983763,
 -1,
 198926437,
 983764,
 199101407,
 198918237,
 983756,
 -1,
 199049309,
 983757,
 199294975,
 199043935,
 983760,
 -1,
 199175007,
 983761,
 199363566,
 198465044,
 -1,
 199429094,
 199298833,
 -1,
 -62492,
 199395479,
 983776,
 -62491,
 199442525,
 983773,
 -1,
 199495441,
 983766,
 199691240,
 199395479,
 983769,
 -1,
 199657623,
 983770,
 199822314,
 199647333,
 983774,
 -1,
 199778405,
 983775,
 199953388,
 199770205,
 983767,
 -1,
 199901277,
 983768,
 200146943,
 199895903,
 983771,
 -1,
 200026975,
 983772,
 200215547,
 199313909,
 -1,
 200281075,
 200150801,
 -1,
 -62479,
 200247447,
 983875,
 -62478,
 200294493,
 983872,
 -1,
 200347409,
 983865,
 200543221,
 200247447,
 983868,
 -1,
 200509591,
 983869,
 200674295,
 200499301,
 983873,
 -1,
 200630373,
 983874,
 200805369,
 200622173,
 983866,
 -1,
 200753245,
 983867,
 200998911,
 200747871,
 983870,
 -1,
 200878943,
 983871,
 201067528,
 200161991,
 -1,
 201133056,
 201002769,
 -1,
 -62466,
 201099415,
 983919,
 -62465,
 201146461,
 983916,
 -1,
 201199377,
 983909,
 201395202,
 201099415,
 983912,
 -1,
 201361559,
 983913,
 201526276,
 201351269,
 983917,
 -1,
 201482341,
 983918,
 201657350,
 201474141,
 983910,
 -1,
 201605213,
 983911,
 201850879,
 201599839,
 983914,
 -1,
 201730911,
 983915,
 201981951,
 201006391,
 -1,
 201985037,
 201854737,
 -1,
 -62453,
 201951383,
 983699,
 -62452,
 201998429,
 983696,
 -1,
 202051345,
 983689,
 202247183,
 201951383,
 983692,
 -1,
 202213527,
 983693,
 202378257,
 202203237,
 983697,
 -1,
 202334309,
 983698,
 202509331,
 202326109,
 983690,
 -1,
 202457181,
 983691,
 202702847,
 202451807,
 983694,
 -1,
 202582879,
 983695,
 202833919,
 182133417,
 -1,
 202837019,
 202726231,
 983650,
 202902553,
 202791767,
 983648,
 -1,
 202857303,
 983660,
 -62438,
 202872493,
 983646,
 -1,
 202979241,
 983644,
 203164702,
 202799138,
 983664,
 -62435,
 203126818,
 983663,
 -1,
 203176647,
 983662,
 203361313,
 203115767,
 983655,
 203489279,
 203312375,
 983658,
 -1,
 203377911,
 983657,
 203557923,
 203325774,
 983649,
 -1,
 203522382,
 983647,
 203688997,
 203517772,
 983654,
 -1,
 203648844,
 983659,
 203820071,
 203639491,
 983643,
 -1,
 203783875,
 983666,
 -62424,
 203789997,
 983653,
 -62423,
 203918901,
 983656,
 -62422,
 203974865,
 983651,
 -62421,
 204035604,
 983652,
 -62420,
 204098037,
 983661,
 -62419,
 204159687,
 983665,
 -1,
 204217655,
 983645,
 204409993,
 182078147,
 -1,
 204475528,
 204370706,
 -1,
 204541033,
 204427689,
 -1,
 204606519,
 204505422,
 -1,
 204672053,
 204570958,
 -1,
 -62412,
 204618453,
 71317,
 -1,
 204672785,
 71316,
 -62410,
 204618453,
 71322,
 -1,
 204803857,
 71321,
 204999740,
 204561239,
 -1,
 -62407,
 204969736,
 71315,
 -62406,
 205020080,
 71320,
 -62405,
 205076450,
 71310,
 -1,
 205131537,
 71325,
 205327426,
 204940639,
 -1,
 205392960,
 205268319,
 -1,
 -62401,
 205339349,
 71319,
 -1,
 205393681,
 71318,
 -62399,
 205339349,
 71324,
 -1,
 205524753,
 71323,
 205720646,
 205262609,
 71296,
 -62396,
 205686935,
 71305,
 -62395,
 205733981,
 71303,
 -1,
 205786897,
 71297,
 205982792,
 205686935,
 71300,
 -1,
 205949079,
 71301,
 206113867,
 205944866,
 -1,
 -62390,
 206060245,
 71335,
 -1,
 206114577,
 71336,
 206310478,
 206073676,
 -1,
 -62387,
 206270361,
 71338,
 -1,
 206311185,
 71332,
 206507089,
 206268625,
 -1,
 -62384,
 206453461,
 71327,
 -1,
 206507793,
 71326,
 206703700,
 206457539,
 -1,
 -62381,
 206650069,
 71307,
 -1,
 206704401,
 71306,
 206900311,
 206653941,
 -1,
 -62378,
 206846677,
 71314,
 -1,
 206901009,
 71313,
 207096921,
 206848093,
 71298,
 -1,
 207044701,
 71299,
 207227996,
 207042473,
 -1,
 -62373,
 207174357,
 71309,
 -1,
 207228689,
 71308,
 207424607,
 207166775,
 -1,
 -62370,
 207370965,
 71312,
 -1,
 207425297,
 71311,
 207621218,
 207362082,
 -1,
 -62367,
 207567573,
 71329,
 -1,
 207621905,
 71328,
 -62365,
 207591176,
 71331,
 -62364,
 207785543,
 71334,
 -62363,
 207839333,
 71304,
 -62362,
 207902302,
 71330,
 -62361,
 207965513,
 71333,
 -62360,
 208026325,
 71337,
 -1,
 208087903,
 71302,
 208276599,
 204482553,
 -1,
 208342125,
 208240974,
 -1,
 -62356,
 208311510,
 71362,
 -1,
 208355154,
 71363,
 208538736,
 208304162,
 -1,
 -62353,
 208488829,
 71366,
 -1,
 208548406,
 71367,
 208735347,
 208483110,
 -1,
 -62350,
 208693002,
 71364,
 -1,
 208750815,
 71365,
 -62348,
 208705799,
 71360,
 -62347,
 208888580,
 71361,
 -62346,
 208952770,
 71369,
 -1,
 209006080,
 71368,
 209194114,
 208244984,
 -1,
 209259644,
 209129233,
 -1,
 -62342,
 209225879,
 71349,
 -62341,
 209272925,
 71347,
 -1,
 209325841,
 71341,
 209521790,
 209225879,
 71344,
 -1,
 209488023,
 71345,
 209652864,
 209469533,
 71342,
 -1,
 209600605,
 71343,
 -62335,
 209608805,
 71348,
 -1,
 209726303,
 71346,
 209977343,
 209157200,
 -1,
 209980550,
 209883137,
 -1,
 -62331,
 209942850,
 71340,
 -1,
 210006079,
 71350,
 -62329,
 209936366,
 71351,
 -1,
 210113673,
 71339,
 -1,
 204419082,
 129377,
 210373772,
 204362810,
 -1,
 -62325,
 210330372,
 119671,
 -1,
 210384127,
 119672,
 210570382,
 210311202,
 983061,
 -1,
 210521895,
 127955,
 -62321,
 210540109,
 128661,
 -62320,
 210659919,
 128429,
 -1,
 210706891,
 127790,
 210898199,
 126566493,
 -1,
 210963714,
 210857804,
 -1,
 211029249,
 210911286,
 -1,
 211094738,
 210981289,
 -1,
 211160220,
 211062325,
 -1,
 211225755,
 211116235,
 -1,
 211291289,
 211185484,
 70791,
 -1,
 211251020,
 70792,
 211484671,
 211242231,
 70793,
 -1,
 211373303,
 70794,
 -1,
 211160849,
 70827,
 211618978,
 211124558,
 -1,
 211684512,
 211583310,
 -1,
 -62305,
 211630805,
 70810,
 -1,
 211685137,
 70809,
 -62303,
 211630805,
 70815,
 -1,
 211816209,
 70814,
 212012199,
 211573591,
 -1,
 -62300,
 211982088,
 70808,
 -62299,
 212032432,
 70813,
 -62298,
 212088802,
 70803,
 -1,
 212143889,
 70818,
 212339885,
 211952991,
 -1,
 212405419,
 212280671,
 -1,
 -62294,
 212351701,
 70812,
 -1,
 212406033,
 70811,
 -62292,
 212351701,
 70817,
 -1,
 212537105,
 70816,
 212733105,
 212274961,
 70785,
 -62289,
 212699287,
 70798,
 -62288,
 212746333,
 70796,
 -1,
 212799249,
 70786,
 212995253,
 212695074,
 -1,
 -62285,
 212957342,
 70829,
 -62284,
 213007061,
 70828,
 -1,
 213061393,
 70830,
 213257399,
 212961431,
 70789,
 -1,
 213223575,
 70790,
 213388474,
 213215441,
 -1,
 -62279,
 213334741,
 70820,
 -1,
 213389073,
 70819,
 213585085,
 213338819,
 -1,
 -62276,
 213531349,
 70800,
 -1,
 213585681,
 70799,
 213781696,
 213535221,
 -1,
 -62273,
 213727957,
 70807,
 -1,
 213782289,
 70806,
 213978306,
 213729373,
 70787,
 -1,
 213925981,
 70788,
 214109381,
 213923753,
 -1,
 -62268,
 214055637,
 70802,
 -1,
 214109969,
 70801,
 214305992,
 214048055,
 -1,
 -62265,
 214252245,
 70805,
 -1,
 214306577,
 70804,
 214502603,
 214243362,
 -1,
 -62262,
 214448853,
 70822,
 -1,
 214503185,
 70821,
 -62260,
 214472456,
 70824,
 -62259,
 214658969,
 70825,
 -62258,
 214720613,
 70797,
 -62257,
 214783582,
 70823,
 -62256,
 214846793,
 70826,
 -62255,
 214907605,
 70831,
 -1,
 214969183,
 70795,
 215157989,
 211063032,
 -1,
 215223512,
 215126142,
 -1,
 215289046,
 215183180,
 70837,
 -1,
 215248716,
 70838,
 215482367,
 215239927,
 70839,
 -1,
 215370999,
 70840,
 215551196,
 215158545,
 -1,
 -62246,
 215517335,
 70846,
 -62245,
 215564381,
 70843,
 -1,
 215617297,
 70832,
 215813342,
 215517335,
 70835,
 -1,
 215779479,
 70836,
 215944417,
 215776203,
 -1,
 -62240,
 215900261,
 70845,
 -1,
 215952223,
 70842,
 216141027,
 215892061,
 70833,
 -1,
 216088669,
 70834,
 -62236,
 216096869,
 70844,
 -1,
 216214367,
 70841,
 216403187,
 215099385,
 -1,
 216468713,
 216367438,
 -1,
 -62232,
 216437974,
 70866,
 -1,
 216481618,
 70867,
 216665324,
 216430626,
 -1,
 -62229,
 216615293,
 70870,
 -1,
 216674870,
 70871,
 216861935,
 216609574,
 -1,
 -62226,
 216819466,
 70868,
 -1,
 216877279,
 70869,
 -62224,
 216832263,
 70864,
 -62223,
 217015044,
 70865,
 -62222,
 217079234,
 70873,
 -1,
 217132544,
 70872,
 217320700,
 216366160,
 -1,
 217386231,
 217288705,
 -1,
 -62218,
 217348418,
 70849,
 -1,
 217411647,
 70850,
 217582842,
 217321233,
 -1,
 -62215,
 217550410,
 70852,
 -1,
 217604157,
 70848,
 -62213,
 217538542,
 70851,
 -1,
 217718222,
 70847,
 217910527,
 217255697,
 -1,
 -62210,
 217865790,
 70784,
 -1,
 217913629,
 70854,
 -62208,
 217866805,
 70855,
 -1,
 218053305,
 70853,
 -1,
 210971834,
 128555,
 218303757,
 210901409,
 -1,
 218369289,
 218265634,
 -1,
 218434824,
 218335605,
 -1,
 -62202,
 218388423,
 3982,
 -62201,
 218451668,
 3981,
 -1,
 218515168,
 3983,
 -1,
 218383099,
 3980,
 218824703,
 218322760,
 -1,
 -62197,
 218727979,
 4058,
 -62196,
 218779515,
 4057,
 -1,
 218831507,
 983208,
 219024659,
 218248241,
 -1,
 219090193,
 218976805,
 -1,
 -62192,
 219045989,
 11623,
 -1,
 219097951,
 11622,
 -62190,
 219052584,
 11632,
 -1,
 219226804,
 11647,
 219417877,
 218970341,
 128005,
 -1,
 219349454,
 128047,
 -62186,
 219371716,
 9202,
 -1,
 219488586,
 127915,
 219680055,
 210844359,
 -1,
 219745579,
 219640258,
 -1,
 219811107,
 219676672,
 -1,
 219876639,
 219771046,
 -1,
 -62180,
 219837259,
 128487,
 -62179,
 219893691,
 128486,
 -62178,
 219945324,
 128485,
 -1,
 220008391,
 128484,
 -62176,
 219840095,
 128491,
 -62175,
 220163102,
 128962,
 -62174,
 220224789,
 128423,
 -1,
 220273959,
 128433,
 220528639,
 219744285,
 -1,
 220532010,
 220407137,
 -1,
 220597544,
 220497324,
 -1,
 -62169,
 220558580,
 11162,
 -1,
 220614925,
 11160,
 -62167,
 220558410,
 11161,
 -1,
 220745832,
 11163,
 -1,
 220475076,
 11835,
 220990770,
 219693149,
 -1,
 221056305,
 220945239,
 -1,
 221121840,
 220987392,
 -1,
 -62161,
 221083889,
 128936,
 -1,
 221133399,
 128929,
 -1,
 221072430,
 129300,
 -1,
 221016302,
 129353,
 221449525,
 220957466,
 -1,
 -62156,
 221416421,
 128077,
 -1,
 221456944,
 128078,
 -62154,
 221406944,
 128173,
 -1,
 221589731,
 127777,
 221777234,
 219639628,
 -1,
 221842752,
 221712145,
 -1,
 221908283,
 221795860,
 128650,
 -1,
 221839675,
 128651,
 222039358,
 221846839,
 -1,
 -62147,
 222004665,
 128668,
 -1,
 222055348,
 128434,
 -62145,
 221994892,
 11223,
 -1,
 222184413,
 128646,
 222367048,
 221790301,
 -1,
 222432582,
 222303190,
 -1,
 222498117,
 222399164,
 -1,
 -62140,
 222459904,
 128208,
 -1,
 222508339,
 128681,
 -1,
 222449494,
 128710,
 -62137,
 222391191,
 11851,
 -1,
 222701319,
 128305,
 222891343,
 222322789,
 -1,
 222956878,
 222849233,
 -1,
 223022413,
 222904656,
 -1,
 -62132,
 222967029,
 128032,
 -1,
 223030007,
 127865,
 -1,
 222969939,
 127942,
 -1,
 222909435,
 128654,
 223412223,
 222857367,
 -1,
 -62127,
 223304409,
 127930,
 -1,
 223357847,
 11231,
 223546731,
 221743255,
 -1,
 223612265,
 223506252,
 -1,
 223677797,
 223567042,
 -1,
 223743322,
 223639586,
 -1,
 223808857,
 223700941,
 -1,
 -62120,
 223777436,
 128597,
 -1,
 223816773,
 128599,
 -1,
 223751903,
 11829,
 224071007,
 223683935,
 -1,
 224136542,
 224019183,
 -1,
 -62115,
 224105686,
 8586,
 -1,
 224149330,
 8587,
 -1,
 224071987,
 11832,
 224398690,
 224026322,
 -1,
 -62111,
 224367260,
 128596,
 -1,
 224406597,
 128598,
 -62109,
 224354752,
 128399,
 -62108,
 224535086,
 11826,
 -1,
 224598769,
 11202,
 224791912,
 223627971,
 -1,
 -62105,
 224741365,
 8378,
 -1,
 224801556,
 129411,
 -1,
 224757050,
 128034,
 -62102,
 223565720,
 129347,
 -1,
 225006493,
 127799,
 225185153,
 223488863,
 -1,
 225250683,
 225135863,
 -1,
 225316212,
 225192799,
 -1,
 225381746,
 225274650,
 -1,
 225447281,
 225341774,
 128222,
 -1,
 225380165,
 128380,
 -1,
 225403592,
 128384,
 -62093,
 225349730,
 128250,
 -1,
 225605996,
 128301,
 225837055,
 225282682,
 -1,
 225840504,
 225737814,
 -1,
 -62089,
 225779162,
 3072,
 -1,
 225842322,
 3076,
 226099199,
 225792425,
 -1,
 -62086,
 225998766,
 3162,
 -1,
 226055204,
 3124,
 226233726,
 225185553,
 -1,
 -62083,
 226193276,
 128198,
 -1,
 226239708,
 127861,
 -62081,
 226197333,
 129514,
 -62080,
 226385509,
 127934,
 -1,
 226436775,
 129528,
 226626960,
 225140837,
 -1,
 226692489,
 226584787,
 -1,
 226758024,
 226638549,
 -1,
 226823559,
 226710126,
 -1,
 -62074,
 226785695,
 11833,
 -1,
 226826929,
 11210,
 -1,
 226787662,
 127913,
 -1,
 226726983,
 128285,
 227151244,
 226648165,
 -1,
 -62069,
 227115805,
 129463,
 -1,
 227167951,
 129520,
 -62067,
 227106202,
 128069,
 -62066,
 227301248,
 127813,
 -62065,
 227364077,
 128508,
 -1,
 227427223,
 128701,
 227610010,
 226595097,
 -1,
 227675545,
 227565669,
 -1,
 227741080,
 227606528,
 -1,
 -62060,
 227710307,
 128109,
 -62059,
 227769951,
 128490,
 -62058,
 227825819,
 128108,
 -62057,
 227884282,
 128149,
 -1,
 227941671,
 128432,
 -1,
 227674171,
 11834,
 -1,
 227625045,
 128256,
 228327423,
 227543069,
 -1,
 -62052,
 228228026,
 128085,
 -1,
 228291305,
 129430,
 228463597,
 126506516,
 -1,
 228528101,
 228404063,
 -1,
 228593304,
 228481879,
 -1,
 228658838,
 228533964,
 -1,
 228724349,
 228622587,
 -1,
 228789776,
 228657350,
 -1,
 228855214,
 228724358,
 -1,
 -62043,
 228789971,
 125069,
 -62042,
 228855401,
 125123,
 -62041,
 228920675,
 124959,
 -62040,
 228986086,
 125036,
 -62039,
 229051459,
 124932,
 -62038,
 229116866,
 124952,
 -62037,
 229182185,
 125097,
 -62036,
 229247505,
 125088,
 -62035,
 229312957,
 124999,
 -1,
 229378319,
 125047,
 229576121,
 228789767,
 -1,
 -62032,
 229510792,
 124993,
 -62031,
 229576222,
 125024,
 -62030,
 229641610,
 125043,
 -62029,
 229707020,
 125056,
 -62028,
 229772456,
 125117,
 -62027,
 229837744,
 124985,
 -62026,
 229903088,
 125039,
 -62025,
 229968461,
 125049,
 -62024,
 230033837,
 125071,
 -1,
 230099257,
 125015,
 230297028,
 229510497,
 -1,
 -62021,
 230231773,
 124980,
 -62020,
 230297112,
 125021,
 -62019,
 230362593,
 125119,
 -62018,
 230427900,
 124933,
 -62017,
 230493236,
 125022,
 -62016,
 230558629,
 125089,
 -62015,
 230624027,
 124986,
 -62014,
 230689338,
 125080,
 -62013,
 230754673,
 125099,
 -1,
 230820061,
 125100,
 231017935,
 230231241,
 -1,
 -62010,
 230952674,
 125002,
 -62009,
 231018096,
 125068,
 -62008,
 231083443,
 125107,
 -62007,
 231148852,
 125074,
 -62006,
 231214152,
 124931,
 -62005,
 231279567,
 125108,
 -62004,
 231344908,
 125009,
 -62003,
 231410228,
 125076,
 -62002,
 231475656,
 124945,
 -1,
 231541021,
 125124,
 231738842,
 230951967,
 -1,
 -61999,
 231673497,
 124951,
 -61998,
 231738978,
 125121,
 -61997,
 231804360,
 125066,
 -61996,
 231869653,
 125095,
 -61995,
 231935106,
 125000,
 -61994,
 232000438,
 124987,
 -61993,
 232065783,
 125041,
 -61992,
 232131072,
 125044,
 -61991,
 232196520,
 125072,
 -1,
 232261931,
 125070,
 232459749,
 231672707,
 -1,
 -61988,
 232394471,
 124946,
 -61987,
 232459838,
 124934,
 -61986,
 232525215,
 125078,
 -61985,
 232590581,
 125046,
 -61984,
 232656050,
 124942,
 -61983,
 232721310,
 125090,
 -61982,
 232786743,
 125048,
 -61981,
 232851974,
 125037,
 -61980,
 232917368,
 125033,
 -1,
 232982767,
 125035,
 233180656,
 232393418,
 -1,
 -61977,
 233115341,
 125029,
 -61976,
 233180764,
 125028,
 -61975,
 233246167,
 125027,
 -61974,
 233311440,
 125020,
 -61973,
 233376815,
 125019,
 -61972,
 233442195,
 125018,
 -61971,
 233507682,
 125013,
 -61970,
 233573033,
 125012,
 -61969,
 233638354,
 125011,
 -1,
 233703680,
 125005,
 233901563,
 233114098,
 -1,
 -61966,
 233836174,
 125004,
 -61965,
 233901621,
 125003,
 -61964,
 233967002,
 124984,
 -61963,
 234032391,
 124983,
 -61962,
 234097742,
 124982,
 -61961,
 234163184,
 124998,
 -61960,
 234228550,
 124997,
 -61959,
 234293868,
 124996,
 -61958,
 234359224,
 124976,
 -1,
 234424624,
 124975,
 234622470,
 233834838,
 -1,
 -61955,
 234557144,
 124974,
 -61954,
 234622478,
 124992,
 -61953,
 234687848,
 124991,
 -61952,
 234753227,
 124990,
 -61951,
 234818719,
 124964,
 -61950,
 234883973,
 124963,
 -61949,
 234949379,
 124962,
 -61948,
 235014651,
 124957,
 -61947,
 235080028,
 124956,
 -1,
 235145422,
 124955,
 235405311,
 234555590,
 -1,
 -61944,
 235277990,
 124950,
 -61943,
 235343439,
 124949,
 -61942,
 235408813,
 124948,
 -61941,
 235474256,
 124938,
 -61940,
 235539629,
 124937,
 -61939,
 235604987,
 124936,
 -61938,
 235670289,
 124930,
 -61937,
 235735564,
 124929,
 -1,
 235800962,
 124928,
 236060671,
 228723030,
 -1,
 236064284,
 235933191,
 -1,
 -61933,
 235998879,
 124954,
 -61932,
 236064341,
 125079,
 -61931,
 236129702,
 125083,
 -61930,
 236195056,
 125034,
 -61929,
 236260515,
 125114,
 -61928,
 236325845,
 125065,
 -61927,
 236391205,
 125058,
 -61926,
 236456608,
 125113,
 -61925,
 236521825,
 124995,
 -1,
 236587219,
 124994,
 236785191,
 235998561,
 -1,
 -61922,
 236719763,
 124935,
 -61921,
 236785171,
 124973,
 -61920,
 236850639,
 125067,
 -61919,
 236915947,
 125032,
 -61918,
 236981331,
 125010,
 -61917,
 237046716,
 125082,
 -61916,
 237112150,
 125116,
 -61915,
 237177408,
 125081,
 -61914,
 237242803,
 125101,
 -1,
 237308196,
 125122,
 237506098,
 236719305,
 -1,
 -61911,
 237440711,
 125031,
 -61910,
 237506089,
 125061,
 -61909,
 237571459,
 125064,
 -61908,
 237636827,
 125063,
 -61907,
 237702269,
 124967,
 -61906,
 237767651,
 125120,
 -61905,
 237832918,
 124965,
 -61904,
 237898342,
 124977,
 -61903,
 237963655,
 125084,
 -1,
 238029050,
 125008,
 238227005,
 237440031,
 -1,
 -61900,
 238161592,
 125054,
 -61899,
 238227017,
 125093,
 -61898,
 238292372,
 125006,
 -61897,
 238357804,
 125052,
 -61896,
 238423097,
 125059,
 -61895,
 238488520,
 124953,
 -61894,
 238553888,
 124988,
 -61893,
 238619220,
 125109,
 -61892,
 238684611,
 125115,
 -1,
 238749896,
 124958,
 238947912,
 238160771,
 -1,
 -61889,
 238882496,
 125111,
 -61888,
 238947875,
 125096,
 -61887,
 239013341,
 124968,
 -61886,
 239078693,
 125051,
 -61885,
 239144041,
 125075,
 -61884,
 239209461,
 125118,
 -61883,
 239274844,
 124944,
 -61882,
 239340073,
 125086,
 -61881,
 239405532,
 125016,
 -1,
 239470837,
 125038,
 239668819,
 238881482,
 -1,
 -61878,
 239603437,
 124947,
 -61877,
 239668745,
 124961,
 -61876,
 239734130,
 124969,
 -61875,
 239799620,
 124979,
 -61874,
 239864894,
 124971,
 -61873,
 239930332,
 125112,
 -61872,
 239995619,
 125023,
 -61871,
 240060951,
 125087,
 -61870,
 240126333,
 124970,
 -1,
 240191721,
 125042,
 240389726,
 239602162,
 -1,
 -61867,
 240324268,
 125103,
 -61866,
 240389678,
 125040,
 -61865,
 240455104,
 125055,
 -61864,
 240520522,
 124939,
 -61863,
 240585839,
 125104,
 -61862,
 240651160,
 125094,
 -61861,
 240716593,
 125102,
 -61860,
 240781895,
 125077,
 -61859,
 240847319,
 125017,
 -1,
 240912662,
 125053,
 241110633,
 240322902,
 -1,
 -61856,
 241045170,
 125106,
 -61855,
 241110645,
 124940,
 -61854,
 241175994,
 125030,
 -61853,
 241241401,
 124978,
 -61852,
 241306741,
 125050,
 -61851,
 241372160,
 124941,
 -61850,
 241437447,
 125007,
 -61849,
 241502749,
 125092,
 -61848,
 241568108,
 125060,
 -1,
 241633541,
 124989,
 241831540,
 241043654,
 -1,
 -61845,
 241766131,
 125014,
 -61844,
 241831491,
 125091,
 -61843,
 241896829,
 125098,
 -61842,
 241962264,
 125057,
 -61841,
 242027613,
 125085,
 -61840,
 242093034,
 125001,
 -61839,
 242158284,
 124960,
 -61838,
 242223712,
 125073,
 -61837,
 242288998,
 125026,
 -1,
 242354393,
 124966,
 242614271,
 241766022,
 -1,
 -61834,
 242486647,
 125025,
 -61833,
 242552126,
 124981,
 -61832,
 242617377,
 124972,
 -61831,
 242682886,
 124943,
 -61830,
 242748157,
 125045,
 -61829,
 242813530,
 125110,
 -61828,
 242878866,
 125105,
 -1,
 242944227,
 125062,
 243142282,
 228665337,
 -1,
 243207809,
 243106126,
 -1,
 -61824,
 243176662,
 125128,
 -1,
 243220306,
 125129,
 243404420,
 243169314,
 -1,
 -61821,
 243353981,
 125132,
 -1,
 243413558,
 125133,
 243601031,
 243348262,
 -1,
 -61818,
 243558154,
 125130,
 -1,
 243615967,
 125131,
 -61816,
 243557124,
 125127,
 -61815,
 243752386,
 125135,
 -1,
 243805696,
 125134,
 244056063,
 243081748,
 -1,
 244059794,
 243958094,
 -1,
 244125329,
 244001631,
 -1,
 244190864,
 244079447,
 -1,
 -61809,
 244152354,
 125137,
 -1,
 244188371,
 125140,
 -1,
 244133775,
 125136,
 -1,
 244072261,
 125139,
 244518549,
 244006928,
 -1,
 -61804,
 244480034,
 125138,
 -1,
 244516051,
 125141,
 -1,
 244472252,
 125142,
 -61801,
 228620406,
 128697,
 -1,
 244737338,
 128334,
 244911930,
 228552524,
 -1,
 244977465,
 244867499,
 -1,
 245042963,
 244917532,
 -1,
 245108448,
 244998132,
 -1,
 245173935,
 245072206,
 -1,
 245239461,
 245141785,
 -1,
 245304995,
 245194853,
 68033,
 245432319,
 245235712,
 -1,
 245436066,
 245317648,
 68051,
 -1,
 245368009,
 68078,
 -1,
 245400468,
 68060,
 245694463,
 245247971,
 68042,
 -1,
 245564617,
 68069,
 245763757,
 245185223,
 -1,
 245829291,
 245723586,
 68034,
 245956607,
 245760000,
 -1,
 245960362,
 245841936,
 68052,
 -1,
 245892297,
 68079,
 -1,
 245924756,
 68061,
 246218751,
 245778401,
 68043,
 -1,
 246088905,
 68070,
 246349823,
 245706478,
 68041,
 -1,
 246219977,
 68068,
 246419134,
 245135394,
 -1,
 246484663,
 246368637,
 68037,
 246550197,
 246415360,
 -1,
 246615732,
 246497296,
 68055,
 -1,
 246547657,
 68082,
 -1,
 246580116,
 68064,
 246874111,
 246515835,
 68046,
 -1,
 246744265,
 68073,
 247005183,
 246428214,
 68038,
 247008956,
 246874112,
 -1,
 247074491,
 246956048,
 68056,
 -1,
 247006409,
 68083,
 -1,
 247038868,
 68065,
 247332863,
 246974587,
 68047,
 -1,
 247203017,
 68074,
 247402191,
 246362918,
 -1,
 247467719,
 247357541,
 -1,
 247533253,
 247434464,
 68035,
 247660543,
 247463936,
 -1,
 247664324,
 247545872,
 68053,
 -1,
 247596233,
 68080,
 -1,
 247628692,
 68062,
 247922687,
 247494627,
 68044,
 -1,
 247792841,
 68071,
 248053759,
 247414877,
 -1,
 248057549,
 247959149,
 68036,
 248184831,
 247988224,
 -1,
 248188620,
 248070160,
 68054,
 -1,
 248120521,
 68081,
 -1,
 248152980,
 68063,
 248446975,
 248002452,
 68045,
 -1,
 248317129,
 68072,
 248516309,
 247356866,
 68040,
 248581844,
 248446976,
 -1,
 248647379,
 248528912,
 68058,
 -1,
 248579273,
 68085,
 -1,
 248611732,
 68067,
 -1,
 248547454,
 68076,
 248909531,
 248458752,
 68039,
 248975066,
 248840192,
 -1,
 249040601,
 248922128,
 68057,
 -1,
 248972489,
 68084,
 -1,
 249004948,
 68066,
 -1,
 248944358,
 68075,
 249364479,
 248865540,
 68032,
 249430015,
 249233408,
 -1,
 249433823,
 249315344,
 68050,
 -1,
 249365705,
 68077,
 -1,
 249398164,
 68059,
 249630465,
 245058807,
 -1,
 249695998,
 249573784,
 -1,
 249761510,
 249659726,
 -1,
 -61724,
 249716837,
 68022,
 -61723,
 249768799,
 68021,
 -1,
 249827089,
 68020,
 250023657,
 249722914,
 -1,
 -61720,
 249965407,
 68017,
 -1,
 250023697,
 68015,
 250220268,
 249977687,
 -1,
 -61717,
 250162015,
 68010,
 -1,
 250220305,
 68009,
 250416879,
 250170051,
 -1,
 -61714,
 250362581,
 68013,
 -1,
 250416913,
 68018,
 250613489,
 250351377,
 68000,
 -1,
 250573012,
 68016,
 -61710,
 250582792,
 68004,
 -61709,
 250712369,
 68005,
 -61708,
 250769305,
 68011,
 -61707,
 250834479,
 68019,
 -61706,
 250898699,
 68007,
 -61705,
 250962021,
 68003,
 -61704,
 251024990,
 68008,
 -61703,
 251088201,
 68012,
 -61702,
 251150429,
 68002,
 -61701,
 251215278,
 68014,
 -61700,
 251276127,
 68001,
 -61699,
 251340267,
 68023,
 -1,
 251402291,
 68006,
 251658239,
 249651553,
 -1,
 -61696,
 251557544,
 68030,
 -1,
 251610057,
 68031,
 251854847,
 249575142,
 -1,
 251858694,
 251756878,
 -1,
 -61692,
 251827452,
 68087,
 -61691,
 251871137,
 68088,
 -1,
 251932445,
 68095,
 252120841,
 251820066,
 -1,
 -61688,
 252070302,
 68091,
 -1,
 252129860,
 68092,
 252317452,
 252076808,
 -1,
 -61685,
 252282902,
 68086,
 -1,
 252328797,
 68029,
 252514063,
 252261158,
 -1,
 -61682,
 252471143,
 68089,
 -1,
 252528957,
 68090,
 252710674,
 252455775,
 -1,
 -61679,
 252662359,
 68028,
 -1,
 252723833,
 68093,
 -1,
 252665296,
 68094,
 253034495,
 244989392,
 -1,
 253038391,
 252924329,
 -1,
 253103899,
 253002062,
 -1,
 253169432,
 253045599,
 67994,
 -1,
 253102111,
 67995,
 253300506,
 253103889,
 67992,
 -1,
 253233183,
 67993,
 -1,
 253255781,
 67996,
 253497120,
 253057879,
 -1,
 253562654,
 253438815,
 67980,
 -1,
 253495327,
 67981,
 253755391,
 253497105,
 67978,
 -1,
 253626399,
 67979,
 253824804,
 253458466,
 -1,
 253890339,
 253759249,
 67987,
 -1,
 253823007,
 67988,
 -1,
 253832031,
 67989,
 254086950,
 253783961,
 67982,
 -1,
 254019615,
 67983,
 254218025,
 254036675,
 -1,
 -61656,
 254163669,
 67985,
 -1,
 254218001,
 67990,
 254414635,
 254154803,
 67974,
 -1,
 254347295,
 67975,
 -61652,
 254383880,
 67972,
 -61651,
 254513457,
 67973,
 -61650,
 254570031,
 67991,
 -61649,
 254634251,
 67976,
 -61648,
 254697573,
 67971,
 -61647,
 254760542,
 67977,
 -61646,
 254823753,
 67984,
 -61645,
 254885981,
 67970,
 -61644,
 254950830,
 67986,
 -61643,
 255011679,
 67969,
 -61642,
 255075819,
 67997,
 -1,
 255135505,
 67968,
 255393791,
 253002042,
 67998,
 -1,
 255264799,
 67999,
 -1,
 244935414,
 129500,
 255528894,
 244852063,
 -1,
 255594408,
 255470971,
 -1,
 255659873,
 255555618,
 -1,
 255725408,
 255612673,
 -1,
 255790913,
 255679319,
 93819,
 -61632,
 255760045,
 93815,
 -1,
 255801257,
 983265,
 255987524,
 255725329,
 93805,
 -61629,
 255952182,
 93796,
 -1,
 256000093,
 93822,
 256184134,
 255956653,
 93823,
 -1,
 256149655,
 93811,
 256315208,
 256139365,
 93821,
 -1,
 256256863,
 93818,
 256446282,
 256264899,
 93804,
 -1,
 256403665,
 93798,
 256577356,
 256391879,
 983264,
 -1,
 256534737,
 93814,
 -61619,
 256546936,
 93797,
 -61618,
 256677362,
 93816,
 -61617,
 256741657,
 93795,
 -61616,
 256806453,
 93794,
 -61615,
 256870551,
 93810,
 -61614,
 256934222,
 93800,
 -61613,
 256997410,
 93793,
 -61612,
 257060684,
 93820,
 -61611,
 257125933,
 93813,
 -61610,
 257190097,
 93799,
 -61609,
 257250836,
 93792,
 -61608,
 257314039,
 93812,
 -61607,
 257378805,
 93806,
 -61606,
 257441885,
 93803,
 -61605,
 257505193,
 93801,
 -61604,
 257569574,
 93802,
 -61603,
 257633119,
 93807,
 -61602,
 257697119,
 93817,
 -61601,
 257760567,
 93809,
 -1,
 257824802,
 93808,
 -1,
 255694862,
 93849,
 258084742,
 255597879,
 -1,
 258150277,
 258020554,
 -1,
 258215782,
 258104151,
 93787,
 -61595,
 258184877,
 93783,
 -1,
 258226089,
 983263,
 258412393,
 258150161,
 93773,
 -61592,
 258377014,
 93764,
 -1,
 258424925,
 93790,
 258609003,
 258381485,
 93791,
 -1,
 258574487,
 93779,
 258740077,
 258564197,
 93789,
 -1,
 258681695,
 93786,
 258871151,
 258689731,
 93772,
 -1,
 258828497,
 93766,
 259002225,
 258816711,
 983262,
 -1,
 258959569,
 93782,
 -61582,
 258971768,
 93765,
 -61581,
 259102194,
 93784,
 -61580,
 259166489,
 93763,
 -61579,
 259231285,
 93762,
 -61578,
 259295383,
 93778,
 -61577,
 259359054,
 93768,
 -61576,
 259422242,
 93761,
 -61575,
 259485516,
 93788,
 -61574,
 259550765,
 93781,
 -61573,
 259614929,
 93767,
 -61572,
 259675668,
 93760,
 -61571,
 259738871,
 93780,
 -61570,
 259803637,
 93774,
 -61569,
 259866717,
 93771,
 -61568,
 259930025,
 93769,
 -61567,
 259994406,
 93770,
 -61566,
 260057951,
 93775,
 -61565,
 260121951,
 93785,
 -61564,
 260185399,
 93777,
 -1,
 260249634,
 93776,
 -1,
 258106007,
 93847,
 260509591,
 258025465,
 -1,
 260575116,
 260473166,
 -1,
 260640650,
 260543702,
 93826,
 -1,
 260571138,
 93845,
 260833279,
 260587346,
 93827,
 -1,
 260702210,
 93846,
 260902799,
 260536354,
 -1,
 -61554,
 260852093,
 93830,
 -1,
 260911670,
 93831,
 261099409,
 260858628,
 93825,
 -1,
 261029890,
 93844,
 261230484,
 261042982,
 -1,
 -61549,
 261187338,
 93828,
 -1,
 261245151,
 93829,
 -61547,
 261200135,
 93824,
 -61546,
 261381570,
 93833,
 -1,
 261434880,
 93832,
 261623718,
 260464628,
 -1,
 261689244,
 261587278,
 -1,
 -61542,
 261657150,
 93836,
 -61541,
 261701227,
 93837,
 -1,
 261762798,
 93834,
 261951391,
 261650466,
 -1,
 -61538,
 261900732,
 93840,
 -1,
 261960294,
 93841,
 262148002,
 261894950,
 -1,
 -61535,
 262104967,
 93838,
 -1,
 262160876,
 93839,
 262344613,
 262089567,
 -1,
 -61532,
 262296145,
 93835,
 -1,
 262357699,
 93842,
 -1,
 262299122,
 93843,
 -61529,
 261568415,
 93848,
 -1,
 262550247,
 93850,
 262799359,
 255541341,
 -1,
 262803389,
 262703856,
 -1,
 262868911,
 262764578,
 -1,
 262934446,
 262818176,
 -1,
 -61523,
 262897294,
 128950,
 -1,
 262958110,
 128971,
 -1,
 262869699,
 128938,
 263196596,
 262812454,
 -1,
 263262131,
 263153462,
 -1,
 -61518,
 263220036,
 128967,
 -1,
 263265038,
 128965,
 -1,
 263211305,
 128944,
 263524279,
 263160789,
 -1,
 -61514,
 263482180,
 128963,
 -1,
 263527182,
 128961,
 263720890,
 263466502,
 -1,
 -61511,
 263683726,
 128956,
 -1,
 263744542,
 128974,
 -61509,
 263689001,
 128911,
 -61508,
 263862871,
 128931,
 -1,
 263920586,
 128901,
 -1,
 262746667,
 11852,
 264179680,
 255472003,
 -1,
 264245199,
 264130985,
 -1,
 264310723,
 264210279,
 -1,
 -61502,
 264256213,
 43749,
 -1,
 264310545,
 43748,
 264507334,
 264271906,
 -1,
 -61499,
 264468638,
 43754,
 -1,
 264518357,
 43753,
 264703945,
 264461143,
 -1,
 -61496,
 264673032,
 43747,
 -1,
 264723376,
 43752,
 264900556,
 264644245,
 -1,
 -61493,
 264846037,
 43751,
 -1,
 264900369,
 43750,
 -61491,
 264855653,
 43745,
 -61490,
 265038687,
 43744,
 -1,
 265101144,
 43746,
 265293786,
 264212021,
 -1,
 265359321,
 265250943,
 -1,
 265424854,
 265293585,
 -1,
 265490389,
 265359121,
 -1,
 -61484,
 265455767,
 43759,
 -1,
 265502813,
 43757,
 -1,
 265455767,
 43758,
 -61481,
 265392218,
 43765,
 -61480,
 265719343,
 43756,
 -1,
 265765712,
 43755,
 -1,
 265307988,
 43766,
 266014685,
 265228049,
 -1,
 -61476,
 265969214,
 43762,
 -1,
 266026027,
 43761,
 -61474,
 265983355,
 43764,
 -61473,
 266174726,
 43763,
 -1,
 266215346,
 43760,
 -61471,
 264144707,
 128647,
 -61470,
 266370762,
 983172,
 -61469,
 266426902,
 128221,
 -61468,
 266490979,
 127816,
 -1,
 266540754,
 127830,
 266736052,
 228462353,
 -1,
 266801243,
 266689367,
 128104,
 266866733,
 266748269,
 -1,
 266932249,
 266817961,
 -1,
 266997743,
 266893346,
 -1,
 267063277,
 266931985,
 -1,
 -61460,
 267016323,
 68312,
 -1,
 267069346,
 68317,
 -61458,
 267025333,
 68323,
 -1,
 267206189,
 68322,
 267390963,
 266961230,
 -1,
 -61455,
 267336598,
 68309,
 -61454,
 267399567,
 68302,
 -1,
 267458545,
 68324,
 267653111,
 267325201,
 -1,
 -61451,
 267622336,
 68313,
 -61450,
 267669917,
 68288,
 -1,
 267720725,
 68314,
 267915258,
 267622520,
 -1,
 -61447,
 267861122,
 68298,
 -1,
 267917333,
 68297,
 268111869,
 267884018,
 -1,
 -61444,
 268068104,
 68319,
 -1,
 268113073,
 68305,
 268308480,
 268070445,
 -1,
 -61441,
 268264712,
 68318,
 -1,
 268320492,
 68320,
 268505091,
 268257987,
 -1,
 -61438,
 268450871,
 68306,
 -1,
 268506289,
 68304,
 268701702,
 268454389,
 -1,
 -61435,
 268647554,
 68300,
 -1,
 268703765,
 68299,
 268898312,
 268647563,
 68294,
 -1,
 268862237,
 68301,
 269029387,
 268842921,
 -1,
 -61430,
 268977080,
 68291,
 -1,
 269041191,
 68292,
 269225998,
 268969311,
 -1,
 -61427,
 269171606,
 68308,
 -1,
 269226555,
 68293,
 269422609,
 269162530,
 -1,
 -61424,
 269368719,
 68290,
 -1,
 269431183,
 68289,
 -61422,
 269391961,
 68303,
 -61421,
 269586916,
 68295,
 -61420,
 269644387,
 68321,
 -61419,
 269707852,
 68315,
 -61418,
 269770809,
 68311,
 -61417,
 269834382,
 68310,
 -61416,
 269897178,
 68307,
 -1,
 269956021,
 68316,
 270143522,
 266890652,
 -1,
 270209054,
 270084173,
 -1,
 270274589,
 270172494,
 68340,
 -1,
 270206972,
 68339,
 -1,
 270240155,
 68338,
 -61409,
 270174274,
 68341,
 -61408,
 270434162,
 68336,
 -61407,
 270488459,
 68342,
 -1,
 270546250,
 68337,
 270733353,
 270098420,
 -1,
 270798886,
 270696782,
 -1,
 -61403,
 270766694,
 68334,
 -1,
 270806766,
 68333,
 270995496,
 270754564,
 68331,
 -1,
 270926382,
 68335,
 -1,
 270939391,
 68332,
 271192108,
 270667676,
 -1,
 -61397,
 271128940,
 68326,
 -1,
 271192007,
 68325,
 -1,
 271154309,
 68296,
 271454286,
 266806808,
 -1,
 271519818,
 271405481,
 -1,
 271585347,
 271453969,
 -1,
 271650867,
 271546402,
 2126,
 -61390,
 271620216,
 2129,
 -1,
 271661767,
 2132,
 271847477,
 271614286,
 2133,
 -1,
 271810894,
 2120,
 271978551,
 271796931,
 2122,
 -1,
 271939742,
 2121,
 -61384,
 271947896,
 2118,
 -61383,
 272068428,
 2131,
 -61382,
 272133677,
 2130,
 -61381,
 272197841,
 2128,
 -61380,
 272259927,
 2125,
 -61379,
 272324116,
 2124,
 -61378,
 272387319,
 2123,
 -61377,
 272450525,
 2136,
 -61376,
 272513735,
 2116,
 -61375,
 272578473,
 2114,
 -61374,
 272639327,
 2115,
 -1,
 272701474,
 2113,
 272896070,
 271532125,
 -1,
 -61371,
 272859470,
 2119,
 -1,
 272915287,
 2127,
 -61369,
 272862647,
 2117,
 -61368,
 273042216,
 2135,
 -61367,
 273103760,
 2112,
 -1,
 273165112,
 2134,
 -61365,
 271487121,
 2138,
 -61364,
 273313168,
 2142,
 -61363,
 273365193,
 2139,
 -1,
 273420556,
 2137,
 273616983,
 271384576,
 -1,
 273682514,
 273585047,
 -1,
 -61359,
 273647533,
 128115,
 -1,
 273693286,
 128114,
 273879125,
 273630176,
 -1,
 -61356,
 273844239,
 129333,
 -1,
 273882357,
 128372,
 -61354,
 273819226,
 128378,
 -1,
 274011043,
 128107,
 -61352,
 273580745,
 128368,
 -61351,
 274167919,
 128094,
 -61350,
 274217485,
 129389,
 -1,
 274274021,
 8380,
 274469054,
 266762549,
 -1,
 274534553,
 274420137,
 -1,
 274600036,
 274497870,
 -1,
 274665569,
 274563406,
 -1,
 -61344,
 274610901,
 72983,
 -1,
 274665233,
 72982,
 -61342,
 274624409,
 73008,
 -61341,
 274807509,
 72988,
 -1,
 274861841,
 72987,
 275058793,
 274553687,
 -1,
 -61338,
 275027720,
 72981,
 -61337,
 275078064,
 72986,
 -61336,
 275134434,
 72976,
 -1,
 275189521,
 72991,
 275386479,
 274998623,
 -1,
 275452013,
 275326303,
 -1,
 -61332,
 275397333,
 72985,
 -1,
 275451665,
 72984,
 -61330,
 275397333,
 72990,
 -1,
 275582737,
 72989,
 275779699,
 275320593,
 72960,
 -61327,
 275744919,
 72971,
 -61326,
 275791965,
 72968,
 -1,
 275844881,
 72961,
 276041847,
 275740706,
 -1,
 -61323,
 276002974,
 73002,
 -61322,
 276052693,
 73001,
 -1,
 276107025,
 73003,
 276303995,
 275991235,
 -1,
 -61319,
 276266694,
 73006,
 -61318,
 276314837,
 72973,
 -1,
 276369169,
 72972,
 276566143,
 276253173,
 -1,
 -61315,
 276521043,
 73007,
 -61314,
 276576981,
 72980,
 -1,
 276631313,
 72979,
 276828289,
 276531351,
 72964,
 -1,
 276793495,
 72965,
 276959364,
 276785361,
 -1,
 -61309,
 276904661,
 72993,
 -1,
 276958993,
 72992,
 277155975,
 276909303,
 -1,
 -61306,
 277105993,
 73005,
 -1,
 277155601,
 72999,
 277352585,
 277102685,
 72962,
 -1,
 277299293,
 72963,
 277483660,
 277297065,
 -1,
 -61301,
 277428949,
 72975,
 -1,
 277483281,
 72974,
 277680271,
 277421367,
 -1,
 -61298,
 277625557,
 72978,
 -1,
 277679889,
 72977,
 277876882,
 277616674,
 -1,
 -61295,
 277822165,
 72995,
 -1,
 277876497,
 72994,
 -61293,
 277845768,
 72997,
 -61292,
 278040135,
 73000,
 -61291,
 278097817,
 72998,
 -61290,
 278159461,
 72969,
 -61289,
 278222430,
 72996,
 -61288,
 278280917,
 73004,
 -1,
 278342495,
 72966,
 278532263,
 274501173,
 -1,
 278597798,
 278489215,
 -1,
 278663327,
 278531857,
 -1,
 -61283,
 278628503,
 73023,
 -61282,
 278675549,
 73020,
 -1,
 278728465,
 73009,
 278925473,
 278628503,
 73012,
 -1,
 278890647,
 73013,
 279056547,
 278872157,
 73010,
 -1,
 279003229,
 73011,
 -61276,
 279023751,
 73014,
 -61275,
 279142501,
 73021,
 -1,
 279194463,
 73018,
 -1,
 278546260,
 73029,
 279449781,
 278472697,
 -1,
 279515307,
 279413070,
 -1,
 -61270,
 279483606,
 73042,
 -1,
 279527250,
 73043,
 279711918,
 279476258,
 -1,
 -61267,
 279660925,
 73046,
 -1,
 279720502,
 73047,
 279908529,
 279655206,
 -1,
 -61264,
 279865098,
 73044,
 -1,
 279922911,
 73045,
 -61262,
 279877895,
 73040,
 -61261,
 280060676,
 73041,
 -61260,
 280124866,
 73049,
 -1,
 280178176,
 73048,
 280367291,
 279411792,
 -1,
 -61257,
 280334426,
 73025,
 -61256,
 280387566,
 73026,
 -61255,
 280443733,
 73028,
 -61254,
 280501690,
 73027,
 -1,
 280564873,
 73024,
 280821759,
 280325964,
 -1,
 -61251,
 280703015,
 73030,
 -1,
 280760142,
 73031,
 280957212,
 274427724,
 -1,
 281022747,
 280895440,
 -1,
 281088235,
 280983586,
 -1,
 281153768,
 281053540,
 -1,
 281219272,
 281117006,
 -1,
 281284806,
 281180194,
 -1,
 -61243,
 281230037,
 72867,
 -1,
 281284369,
 72866,
 -61241,
 281230037,
 72859,
 -1,
 281415441,
 72858,
 281612492,
 281172823,
 -1,
 -61238,
 281581320,
 72857,
 -61237,
 281622498,
 72853,
 -1,
 281677585,
 72861,
 281874639,
 281581688,
 -1,
 -61234,
 281819861,
 72870,
 -1,
 281874193,
 72871,
 282071250,
 281835554,
 -1,
 -61231,
 282016469,
 72876,
 -1,
 282070801,
 72877,
 282267861,
 282028241,
 -1,
 -61228,
 282213077,
 72863,
 -1,
 282267409,
 72862,
 282464472,
 282217155,
 -1,
 -61225,
 282409685,
 72851,
 -1,
 282464017,
 72850,
 282661083,
 282404191,
 -1,
 -61222,
 282630266,
 72868,
 -1,
 282660625,
 72860,
 282857694,
 282598711,
 -1,
 -61219,
 282802901,
 72855,
 -1,
 282857233,
 72854,
 -61217,
 282826504,
 72873,
 -61216,
 283021617,
 72869,
 -61215,
 283078553,
 72874,
 -61214,
 283137630,
 72865,
 -61213,
 283200841,
 72875,
 -61212,
 283265562,
 72856,
 -61211,
 283327189,
 72878,
 -61210,
 283391970,
 72852,
 -61209,
 283449395,
 72864,
 -1,
 283512593,
 72879,
 283770879,
 281101046,
 -1,
 -61206,
 283647438,
 72886,
 -1,
 283710601,
 72885,
 283906323,
 281039273,
 -1,
 283971826,
 283869518,
 -1,
 284037360,
 283932706,
 -1,
 -61201,
 283982549,
 72835,
 -1,
 284036881,
 72834,
 -61199,
 283982549,
 72827,
 -1,
 284167953,
 72826,
 284365046,
 283925335,
 -1,
 -61196,
 284333832,
 72825,
 -61195,
 284375010,
 72821,
 -1,
 284430097,
 72829,
 284627193,
 284334200,
 -1,
 -61192,
 284572373,
 72838,
 -1,
 284626705,
 72839,
 284823804,
 284588066,
 -1,
 -61189,
 284768981,
 72844,
 -1,
 284823313,
 72845,
 285020415,
 284780753,
 -1,
 -61186,
 284965589,
 72831,
 -1,
 285019921,
 72830,
 285217026,
 284969667,
 -1,
 -61183,
 285162197,
 72819,
 -1,
 285216529,
 72818,
 285413637,
 285156703,
 -1,
 -61180,
 285382778,
 72836,
 -1,
 285413137,
 72828,
 285610248,
 285351223,
 -1,
 -61177,
 285555413,
 72823,
 -1,
 285609745,
 72822,
 -61175,
 285579016,
 72841,
 -61174,
 285774129,
 72837,
 -61173,
 285831065,
 72842,
 -61172,
 285890142,
 72833,
 -61171,
 285953353,
 72843,
 -61170,
 286018074,
 72824,
 -61169,
 286079701,
 72846,
 -61168,
 286144482,
 72820,
 -61167,
 286201907,
 72832,
 -61166,
 286265105,
 72847,
 -1,
 286328866,
 72840,
 286527769,
 283873528,
 -1,
 -61163,
 286492823,
 72882,
 -61162,
 286548069,
 72884,
 -61161,
 286605405,
 72881,
 -61160,
 286665567,
 72883,
 -1,
 286723943,
 72880,
 -61158,
 286480216,
 72817,
 -1,
 286866578,
 72816,
 -1,
 280986694,
 129355,
 287117651,
 280902439,
 -1,
 287183183,
 287067383,
 -1,
 287248718,
 287125912,
 -1,
 287314213,
 287211854,
 -1,
 287379747,
 287277390,
 -1,
 -61150,
 287324885,
 69983,
 -1,
 287379217,
 69982,
 -61148,
 287324885,
 69988,
 -1,
 287510289,
 69987,
 287707435,
 287253855,
 -1,
 287772969,
 287647071,
 -1,
 -61144,
 287718101,
 69985,
 -1,
 287772433,
 69984,
 -61142,
 287718101,
 69990,
 -1,
 287903505,
 69989,
 288100655,
 287660887,
 -1,
 -61139,
 288069384,
 69981,
 -61138,
 288119728,
 69986,
 -1,
 288165649,
 69991,
 288362802,
 288059212,
 -1,
 -61135,
 288321433,
 70002,
 -1,
 288362257,
 69997,
 288559413,
 288319697,
 -1,
 -61132,
 288504533,
 69993,
 -1,
 288558865,
 69992,
 288756024,
 288508611,
 -1,
 -61129,
 288701141,
 69974,
 -1,
 288755473,
 69973,
 288952635,
 288705013,
 -1,
 -61126,
 288897749,
 69980,
 -1,
 288952081,
 69979,
 289149246,
 288896937,
 -1,
 -61123,
 289094357,
 69976,
 -1,
 289148689,
 69975,
 289345857,
 289086775,
 -1,
 -61120,
 289290965,
 69978,
 -1,
 289345297,
 69977,
 289542468,
 289282082,
 -1,
 -61117,
 289487573,
 69995,
 -1,
 289541905,
 69994,
 -61115,
 289508935,
 69999,
 -61114,
 289704087,
 69970,
 -61113,
 289765534,
 70000,
 -61112,
 289824869,
 69972,
 -61111,
 289887838,
 69996,
 -61110,
 289951049,
 69998,
 -61109,
 290013277,
 69969,
 -61108,
 290077397,
 70001,
 -61107,
 290138975,
 69971,
 -1,
 290197265,
 69968,
 -1,
 287195722,
 70006,
 290459986,
 287143970,
 -1,
 -61103,
 290407185,
 70003,
 -1,
 290466971,
 70005,
 -1,
 290394031,
 70004,
 290722160,
 287066975,
 -1,
 290787688,
 290673065,
 -1,
 290853209,
 290741079,
 -1,
 -61097,
 290821896,
 73451,
 -61096,
 290863074,
 73442,
 -1,
 290918161,
 73448,
 -61094,
 290821896,
 73452,
 -61093,
 291081799,
 73455,
 -61092,
 291144150,
 73446,
 -61091,
 291207326,
 73456,
 -61090,
 291270553,
 73453,
 -61089,
 291334411,
 73443,
 -61088,
 291395166,
 73445,
 -61087,
 291458377,
 73454,
 -61086,
 291523354,
 73440,
 -61085,
 291588634,
 73450,
 -61084,
 291649506,
 73441,
 -61083,
 291710443,
 73447,
 -61082,
 291773779,
 73449,
 -61081,
 291838003,
 73444,
 -1,
 291901201,
 73457,
 292098413,
 290754808,
 -1,
 -61078,
 292063383,
 73460,
 -61077,
 292118629,
 73462,
 -61076,
 292175965,
 73459,
 -1,
 292236127,
 73461,
 -61074,
 292055610,
 73463,
 -61073,
 292368198,
 73464,
 -1,
 292426749,
 73458,
 292622736,
 290672326,
 -1,
 292688256,
 292566758,
 -1,
 292753788,
 292643592,
 -1,
 292819318,
 292716878,
 -1,
 -61067,
 292786781,
 3419,
 -1,
 292827091,
 3420,
 293015929,
 292762406,
 -1,
 -61064,
 292971974,
 3417,
 -1,
 293028339,
 3422,
 -61062,
 292977892,
 3446,
 -61061,
 293168007,
 3416,
 -1,
 293219893,
 3447,
 293470207,
 292717494,
 -1,
 -61058,
 293373998,
 3421,
 -61057,
 293436654,
 3448,
 -1,
 293482044,
 3418,
 293671305,
 292639145,
 -1,
 293736837,
 293609452,
 -1,
 -61053,
 293705389,
 3413,
 -61052,
 293754388,
 3412,
 -1,
 293819424,
 3414,
 -61050,
 293701521,
 3386,
 -61049,
 293953147,
 3369,
 -61048,
 294004905,
 3406,
 -1,
 294065430,
 3423,
 294322175,
 293633104,
 -1,
 294326670,
 294198583,
 -1,
 -61044,
 294281829,
 3328,
 -61043,
 294340535,
 3388,
 -1,
 294392779,
 3329,
 -61041,
 294293282,
 3387,
 -1,
 294545840,
 3407,
 294719916,
 292591387,
 -1,
 294785433,
 294682958,
 -1,
 294850965,
 294752537,
 -1,
 -61036,
 294805605,
 119522,
 -1,
 294858428,
 119532,
 295047576,
 294795975,
 -1,
 -61033,
 295006658,
 119523,
 -1,
 295061466,
 119533,
 -1,
 294989550,
 119530,
 295309726,
 294746146,
 -1,
 295375260,
 295258493,
 119526,
 -1,
 295338684,
 119536,
 295567359,
 295318070,
 119527,
 -1,
 295469756,
 119537,
 295637412,
 295252774,
 -1,
 295702945,
 295593738,
 119524,
 -1,
 295666364,
 119534,
 295895039,
 295649373,
 -1,
 -61021,
 295800429,
 119525,
 -1,
 295843726,
 119535,
 296030632,
 295578463,
 -1,
 296096167,
 295977566,
 119528,
 -1,
 296037722,
 119538,
 -1,
 296047185,
 119531,
 296292778,
 295984578,
 119529,
 -1,
 296256188,
 119539,
 -61013,
 296261895,
 119520,
 -1,
 296379140,
 119521,
 296554927,
 294683457,
 -1,
 -61010,
 296515069,
 10187,
 -1,
 296563576,
 10189,
 296751538,
 296499113,
 -1,
 -61007,
 296705297,
 129522,
 -1,
 296758111,
 129497,
 -61005,
 296719961,
 128470,
 -1,
 296905644,
 127809,
 297079408,
 266682461,
 -1,
 297144929,
 297014433,
 -1,
 297210411,
 297095593,
 -1,
 297275849,
 297173326,
 -1,
 297341376,
 297231234,
 -1,
 -60998,
 297274887,
 94105,
 -60997,
 297340257,
 94104,
 -60996,
 297405641,
 94103,
 -60995,
 297471007,
 94102,
 -60994,
 297536387,
 94101,
 -60993,
 297601738,
 94100,
 -1,
 297667058,
 94099,
 297865668,
 297302050,
 -1,
 -60990,
 297826462,
 93994,
 -60989,
 297876181,
 93998,
 -1,
 297930513,
 94007,
 298127815,
 297816727,
 -1,
 -60986,
 298096392,
 93980,
 -1,
 298127121,
 93978,
 -60984,
 298090966,
 93966,
 -1,
 298258193,
 93962,
 298455510,
 297229143,
 -1,
 298521037,
 298423981,
 -1,
 -60980,
 298466005,
 93997,
 -1,
 298520337,
 93996,
 298717648,
 298474327,
 -1,
 -60977,
 298662613,
 93973,
 -1,
 298716945,
 93972,
 298914259,
 298661801,
 -1,
 -60974,
 298859221,
 93988,
 -1,
 298913553,
 93987,
 299110869,
 298848017,
 93968,
 -1,
 299071693,
 94032,
 -1,
 299055829,
 93969,
 299307490,
 298424440,
 -1,
 299373021,
 299276408,
 -1,
 299438555,
 299333666,
 -1,
 -60966,
 299407112,
 94017,
 -1,
 299437841,
 94014,
 -60964,
 299407112,
 94016,
 -1,
 299568913,
 94013,
 299766240,
 299333666,
 -1,
 -60961,
 299711189,
 94006,
 -1,
 299765521,
 94012,
 -60959,
 299711189,
 94005,
 -1,
 299896593,
 94011,
 300093933,
 299276205,
 -1,
 300159465,
 300056910,
 -1,
 300224999,
 300120098,
 -1,
 -60954,
 300169941,
 94000,
 -1,
 300224273,
 94009,
 -60952,
 300188118,
 93964,
 -1,
 300355345,
 93965,
 -60950,
 300116235,
 93954,
 -60949,
 300506710,
 93970,
 -60948,
 300567322,
 93984,
 -1,
 300624730,
 94001,
 300814838,
 300052999,
 -1,
 300880373,
 300770178,
 -1,
 -60944,
 300813831,
 94111,
 -60943,
 300879049,
 94110,
 -60942,
 300944415,
 94109,
 -60941,
 301009795,
 94108,
 -60940,
 301074930,
 94107,
 -1,
 301140310,
 94106,
 -1,
 300841703,
 94002,
 301404672,
 300754271,
 -1,
 301470203,
 301373560,
 -1,
 -60935,
 301439098,
 93995,
 -60934,
 301480661,
 93999,
 -1,
 301534993,
 94008,
 301732350,
 301421207,
 -1,
 -60931,
 301700872,
 93981,
 -1,
 301731601,
 93979,
 -60929,
 301671915,
 93967,
 -1,
 301862673,
 93963,
 302060040,
 301338385,
 -1,
 302125575,
 302018755,
 -1,
 302191109,
 302078807,
 -1,
 -60924,
 302135266,
 93989,
 -1,
 302190353,
 93971,
 -60922,
 302160196,
 94015,
 -1,
 302339678,
 93958,
 -1,
 302070471,
 94019,
 302584334,
 302009591,
 -1,
 302649868,
 302529223,
 -1,
 -60917,
 302618376,
 93977,
 -1,
 302649105,
 93976,
 -60915,
 302618376,
 93975,
 -1,
 302780177,
 93974,
 302977554,
 302544930,
 -1,
 -60912,
 302938270,
 94004,
 -60911,
 302987989,
 94003,
 -1,
 303042321,
 94010,
 303239703,
 302921641,
 -1,
 303305238,
 303184583,
 -1,
 -60907,
 303250133,
 93993,
 -1,
 303304465,
 93992,
 -1,
 303238929,
 93983,
 303567386,
 303205941,
 -1,
 -60903,
 303510346,
 93961,
 -1,
 303566609,
 93960,
 303763997,
 303525421,
 -1,
 -60900,
 303708130,
 93986,
 -1,
 303763217,
 93985,
 303960608,
 303720657,
 -1,
 -60897,
 303910217,
 93955,
 -1,
 303959825,
 93952,
 304157219,
 303912468,
 -1,
 -60894,
 304102101,
 93957,
 -1,
 304156433,
 93956,
 304353830,
 304102087,
 -1,
 -60891,
 304298709,
 94020,
 -1,
 304353041,
 93990,
 -60889,
 304322085,
 93991,
 -60888,
 304517425,
 94018,
 -60887,
 304565018,
 93982,
 -60886,
 304624458,
 93959,
 -1,
 304683059,
 93953,
 304878167,
 297177336,
 -1,
 304943669,
 304824413,
 94049,
 305009200,
 304877329,
 94050,
 305135615,
 304962391,
 94051,
 -1,
 305018793,
 94052,
 -60879,
 304973975,
 94056,
 -60878,
 305160293,
 94053,
 -60877,
 305225040,
 94057,
 -60876,
 305283165,
 94055,
 -1,
 305343327,
 94054,
 305533502,
 304877329,
 94036,
 305599032,
 305486679,
 94039,
 -1,
 305543081,
 94040,
 305730106,
 305539935,
 94067,
 -1,
 305671007,
 94068,
 -60869,
 305694871,
 94075,
 -60868,
 305807453,
 94073,
 -60867,
 305872299,
 94038,
 -1,
 305925905,
 94037,
 306123333,
 305498263,
 94058,
 306188866,
 306056977,
 94059,
 306315263,
 306142039,
 94060,
 -1,
 306198441,
 94061,
 -60861,
 306153623,
 94062,
 -60860,
 306339152,
 94064,
 -1,
 306392567,
 94063,
 306582091,
 306064223,
 94045,
 306647624,
 306540364,
 94071,
 -1,
 306605900,
 94069,
 306778698,
 306600791,
 94046,
 -1,
 306722729,
 94047,
 -1,
 306724957,
 94074,
 306975311,
 306536549,
 94041,
 -60851,
 306940055,
 94076,
 -60850,
 306995301,
 94042,
 -1,
 307049236,
 94048,
 307237457,
 306943661,
 94065,
 -1,
 307183709,
 94066,
 307368531,
 307204377,
 94044,
 -1,
 307322981,
 94043,
 307499605,
 307328872,
 94072,
 -1,
 307457868,
 94070,
 307691519,
 307452759,
 94077,
 -1,
 307574697,
 94078,
 307761756,
 304842114,
 -1,
 -60839,
 307725711,
 94096,
 -60838,
 307786571,
 94095,
 -60837,
 307829100,
 94098,
 -1,
 307892167,
 94097,
 308150271,
 307723344,
 -1,
 308154976,
 308048381,
 -1,
 -60833,
 308121763,
 94034,
 -1,
 308156056,
 94035,
 -1,
 308090520,
 94033,
 308417129,
 297083832,
 -1,
 308482662,
 308371557,
 -1,
 -60828,
 308443500,
 128300,
 -60827,
 308505364,
 127908,
 -1,
 308549934,
 129440,
 308805631,
 308412416,
 -1,
 -60824,
 308699864,
 983235,
 -1,
 308749942,
 983236,
 308941421,
 308370853,
 -1,
 -60821,
 308894221,
 128469,
 -60820,
 308946987,
 128189,
 -1,
 309009649,
 128656,
 309264383,
 308890871,
 -1,
 -60817,
 309152998,
 127756,
 -1,
 309217436,
 127894,
 309400365,
 297033829,
 -1,
 309465842,
 309339487,
 -1,
 309531377,
 309411933,
 -1,
 309596894,
 309460992,
 -1,
 309662388,
 309547433,
 -1,
 309727868,
 309628469,
 -1,
 309793403,
 309682379,
 -1,
 309858937,
 309751628,
 71174,
 -1,
 309817164,
 71175,
 310050815,
 309808375,
 71176,
 -1,
 309939447,
 71177,
 -1,
 309726993,
 71210,
 310186626,
 309690702,
 -1,
 310252160,
 310149454,
 -1,
 -60801,
 310196949,
 71193,
 -1,
 310251281,
 71192,
 -60799,
 310196949,
 71198,
 -1,
 310382353,
 71197,
 310579847,
 310139735,
 -1,
 -60796,
 310548232,
 71191,
 -60795,
 310598576,
 71196,
 -60794,
 310654946,
 71186,
 -1,
 310710033,
 71201,
 310907533,
 310519135,
 -1,
 310973067,
 310846815,
 -1,
 -60790,
 310917845,
 71195,
 -1,
 310972177,
 71194,
 -60788,
 310917845,
 71200,
 -1,
 311103249,
 71199,
 311300753,
 310841105,
 71168,
 -60785,
 311265431,
 71181,
 -60784,
 311312477,
 71179,
 -1,
 311365393,
 71169,
 311562901,
 311261218,
 -1,
 -60781,
 311523486,
 71212,
 -60780,
 311573205,
 71211,
 -1,
 311627537,
 71213,
 311825047,
 311527575,
 71172,
 -1,
 311789719,
 71173,
 311956122,
 311781585,
 -1,
 -60775,
 311900885,
 71203,
 -1,
 311955217,
 71202,
 312152733,
 311905527,
 -1,
 -60772,
 312102217,
 71215,
 -1,
 312151825,
 71209,
 312349344,
 312101571,
 -1,
 -60769,
 312294101,
 71183,
 -1,
 312348433,
 71182,
 312545955,
 312297973,
 -1,
 -60766,
 312490709,
 71190,
 -1,
 312545041,
 71189,
 312742565,
 312492125,
 71170,
 -1,
 312688733,
 71171,
 312873640,
 312686505,
 -1,
 -60761,
 312818389,
 71185,
 -1,
 312872721,
 71184,
 313070251,
 312810807,
 -1,
 -60758,
 313014997,
 71188,
 -1,
 313069329,
 71187,
 313266862,
 313006114,
 -1,
 -60755,
 313211605,
 71205,
 -1,
 313265937,
 71204,
 -60753,
 313235208,
 71207,
 -60752,
 313421721,
 71208,
 -60751,
 313483365,
 71180,
 -60750,
 313546334,
 71206,
 -60749,
 313604821,
 71214,
 -1,
 313666399,
 71178,
 313856708,
 309629176,
 -1,
 313922234,
 313823358,
 -1,
 313987768,
 313880396,
 71221,
 -1,
 313945932,
 71222,
 314179583,
 313937143,
 71223,
 -1,
 314068215,
 71224,
 314249918,
 313855761,
 -1,
 -60740,
 314214551,
 71228,
 -60739,
 314261597,
 71226,
 -1,
 314314513,
 71216,
 314512064,
 314214551,
 71219,
 -1,
 314476695,
 71220,
 314643138,
 314458205,
 71217,
 -1,
 314589277,
 71218,
 -60733,
 314597477,
 71227,
 -1,
 314714975,
 71225,
 314905301,
 313795935,
 -1,
 314970835,
 314852073,
 -1,
 315036361,
 314933582,
 -1,
 -60728,
 315004118,
 71250,
 -1,
 315047762,
 71251,
 315232972,
 314996770,
 -1,
 -60725,
 315181437,
 71254,
 -1,
 315241014,
 71255,
 315429583,
 315175718,
 -1,
 -60722,
 315385610,
 71252,
 -1,
 315443423,
 71253,
 -60720,
 315398407,
 71248,
 -60719,
 315581188,
 71249,
 -60718,
 315645378,
 71257,
 -1,
 315698688,
 71256,
 -60716,
 314926736,
 71234,
 -1,
 315823035,
 71233,
 316019421,
 314866768,
 -1,
 316084953,
 315985921,
 -1,
 -60712,
 316045634,
 71230,
 -1,
 316108863,
 71231,
 316281564,
 316018449,
 -1,
 -60709,
 316240125,
 71232,
 -1,
 316301373,
 71229,
 -1,
 316227644,
 71236,
 -1,
 315953071,
 71235,
 316669951,
 309539874,
 -1,
 316674800,
 316559785,
 -1,
 316740328,
 316636435,
 -1,
 316805862,
 316689655,
 -1,
 316871397,
 316736900,
 -1,
 -60700,
 316823933,
 43870,
 -1,
 316884688,
 43869,
 -1,
 316817958,
 43001,
 -60697,
 316770521,
 43871,
 -1,
 317078887,
 43868,
 317264621,
 316677431,
 -1,
 317330156,
 317233260,
 -1,
 -60693,
 317292007,
 42653,
 -1,
 317340761,
 42652,
 -1,
 317265077,
 43000,
 317652991,
 317207309,
 -1,
 -60689,
 317543703,
 983993,
 -1,
 317603312,
 983992,
 -1,
 316611670,
 43867,
 -1,
 309473517,
 129339,
 317920014,
 309418839,
 -1,
 317985542,
 317864477,
 -1,
 318051064,
 317948133,
 71273,
 318177279,
 317982084,
 -1,
 -60681,
 318072212,
 71274,
 -1,
 318122348,
 71275,
 318313212,
 318011184,
 71265,
 318439423,
 318244228,
 -1,
 -60677,
 318334356,
 71269,
 -1,
 318384492,
 71270,
 318575359,
 318275918,
 -1,
 -60674,
 318541113,
 71276,
 -1,
 318600636,
 71267,
 318771969,
 318523052,
 71271,
 -1,
 318703163,
 71272,
 318903044,
 318708342,
 -1,
 -60669,
 318858644,
 71264,
 -1,
 318908780,
 71268,
 -60667,
 318853553,
 6264,
 -1,
 319039714,
 71266,
 319230731,
 317928212,
 -1,
 319296266,
 319160320,
 -1,
 -60663,
 319263840,
 128184,
 -1,
 319297674,
 128176,
 -1,
 319228014,
 129297,
 319558413,
 319179760,
 128018,
 -1,
 319488462,
 128053,
 -1,
 319513938,
 128669,
 319755032,
 317884567,
 -1,
 319820565,
 319709082,
 -1,
 319886100,
 319754624,
 -1,
 -60654,
 319844320,
 128670,
 -60653,
 319888747,
 128672,
 -1,
 319953432,
 128693,
 -1,
 319816210,
 128507,
 320213783,
 319781243,
 128001,
 -1,
 320143822,
 128045,
 -1,
 320176925,
 128068,
 320410399,
 319717710,
 -1,
 320475934,
 320365879,
 -1,
 320541469,
 320405504,
 -1,
 -60644,
 320502116,
 128757,
 -1,
 320543657,
 128741,
 -1,
 320508426,
 128739,
 -1,
 320421228,
 129334,
 320869156,
 320364645,
 -1,
 320934691,
 320822105,
 -1,
 -60638,
 320901148,
 127889,
 -1,
 320937340,
 129390,
 -1,
 320873828,
 128496,
 321196840,
 320805439,
 128241,
 321323007,
 321126400,
 -1,
 -60633,
 321229826,
 128242,
 -1,
 321282384,
 128244,
 321458987,
 321158814,
 -1,
 -60630,
 321407187,
 129439,
 -1,
 321465183,
 128332,
 -60628,
 321427219,
 128511,
 -1,
 321622033,
 127909,
 321786748,
 309364887,
 -1,
 321852260,
 321738161,
 -1,
 321917795,
 321786933,
 -1,
 321983330,
 321868201,
 -1,
 322048824,
 321922399,
 -1,
 322114358,
 321987935,
 -1,
 -60620,
 322058965,
 70292,
 -60619,
 322119147,
 70291,
 -1,
 322178833,
 70290,
 -60617,
 322058965,
 70297,
 -1,
 322309905,
 70296,
 322507582,
 322011470,
 -1,
 322573116,
 322470222,
 -1,
 -60613,
 322517717,
 70289,
 -1,
 322572049,
 70288,
 -60611,
 322517717,
 70295,
 -1,
 322703121,
 70294,
 322900802,
 322465612,
 -1,
 -60608,
 322858905,
 70311,
 -60607,
 322910933,
 70312,
 -1,
 322965265,
 70306,
 323162950,
 322853719,
 -1,
 -60604,
 323131144,
 70287,
 -60603,
 323181488,
 70293,
 -1,
 323227409,
 70298,
 323425097,
 323119313,
 -1,
 -60600,
 323369685,
 70300,
 -1,
 323424017,
 70299,
 323621708,
 323373763,
 -1,
 -60597,
 323566293,
 70277,
 -1,
 323620625,
 70276,
 323818319,
 323570165,
 -1,
 -60594,
 323766810,
 70285,
 -1,
 323817233,
 70284,
 324014930,
 323762089,
 -1,
 -60591,
 323959509,
 70280,
 -1,
 324013841,
 70278,
 324211541,
 323951927,
 -1,
 -60588,
 324156117,
 70283,
 -1,
 324210449,
 70282,
 324408152,
 324147234,
 -1,
 -60585,
 324352725,
 70303,
 -1,
 324407057,
 70301,
 -60583,
 324376328,
 70305,
 -60582,
 324570695,
 70308,
 -60581,
 324634775,
 70274,
 -60580,
 324696222,
 70309,
 -60579,
 324752990,
 70304,
 -60578,
 324816201,
 70307,
 -60577,
 324878429,
 70273,
 -60576,
 324942549,
 70310,
 -60575,
 325004127,
 70275,
 -1,
 325062417,
 70272,
 -1,
 321943954,
 70313,
 -1,
 321865479,
 127926,
 325451775,
 321812514,
 -1,
 325456763,
 325337424,
 -1,
 325522296,
 325416994,
 -1,
 325587831,
 325490726,
 -1,
 325653357,
 325528415,
 -1,
 325718892,
 325599947,
 -1,
 -60565,
 325684106,
 119271,
 -1,
 325724630,
 119270,
 -1,
 325672002,
 119263,
 325981040,
 325611232,
 -1,
 -60561,
 325946250,
 119269,
 -1,
 325986774,
 119268,
 326177651,
 325923622,
 -1,
 -60558,
 326127247,
 119272,
 -1,
 326190096,
 119264,
 -60556,
 326144822,
 119266,
 -60555,
 326332770,
 119265,
 -60554,
 326384518,
 119267,
 -1,
 326442300,
 119262,
 -1,
 325526393,
 127932,
 326701946,
 325471220,
 127929,
 -1,
 326633207,
 127896,
 -1,
 326655764,
 127925,
 -1,
 325402579,
 127812,
 326964149,
 321746632,
 -1,
 327029668,
 326914473,
 -1,
 327095170,
 326992206,
 -1,
 -60544,
 327040142,
 92757,
 -60543,
 327102039,
 92766,
 -1,
 327159569,
 92736,
 327357317,
 327049317,
 92754,
 -60540,
 327311461,
 92753,
 -1,
 327372023,
 92749,
 327553929,
 327305923,
 -1,
 -60537,
 327508069,
 92761,
 -60536,
 327564033,
 92744,
 -1,
 327625714,
 92748,
 327816076,
 327511884,
 -1,
 -60533,
 327770213,
 92755,
 -1,
 327827549,
 92765,
 328012687,
 327772369,
 -1,
 -60530,
 327957938,
 92743,
 -1,
 328011537,
 92752,
 328209298,
 327965527,
 -1,
 -60527,
 328156125,
 92751,
 -1,
 328219012,
 92737,
 328405909,
 328160788,
 -1,
 -60524,
 328352674,
 92739,
 -1,
 328405149,
 92750,
 328602519,
 328355145,
 92763,
 -1,
 328555351,
 92762,
 328733594,
 328547029,
 -1,
 -60519,
 328687717,
 92745,
 -1,
 328745053,
 92764,
 328930204,
 328674143,
 92760,
 -1,
 328863505,
 92758,
 329061278,
 328869355,
 92741,
 -1,
 329007197,
 92746,
 -60513,
 329029718,
 92738,
 -60512,
 329158961,
 92759,
 -60511,
 329218980,
 92756,
 -60510,
 329261093,
 92747,
 -60509,
 329324595,
 92740,
 -1,
 329387793,
 92742,
 329646079,
 326968671,
 -1,
 329651123,
 329532137,
 -1,
 329716649,
 329613646,
 -1,
 -60504,
 329684182,
 92770,
 -1,
 329727826,
 92771,
 329913260,
 329676834,
 -1,
 -60501,
 329861501,
 92774,
 -1,
 329921078,
 92775,
 330109871,
 329855782,
 -1,
 -60498,
 330065674,
 92772,
 -1,
 330123487,
 92773,
 -60496,
 330078471,
 92768,
 -60495,
 330261252,
 92769,
 -60494,
 330325442,
 92777,
 -1,
 330378752,
 92776,
 -60492,
 329606800,
 92783,
 -1,
 330503099,
 92782,
 330699754,
 326932264,
 -1,
 330765270,
 330650025,
 -1,
 330830796,
 330727947,
 -1,
 330896318,
 330769759,
 -1,
 330961852,
 330835295,
 -1,
 -60485,
 330906325,
 43502,
 -1,
 330960657,
 43501,
 -60483,
 330906325,
 43516,
 -1,
 331091729,
 43515,
 331289537,
 330849111,
 -1,
 -60480,
 331257608,
 43495,
 -1,
 331307952,
 43503,
 331486148,
 331237877,
 -1,
 -60477,
 331430613,
 43500,
 -1,
 331484945,
 43499,
 331682759,
 331429801,
 -1,
 -60474,
 331627221,
 43498,
 -1,
 331681553,
 43497,
 331879370,
 331618338,
 -1,
 -60471,
 331823829,
 43518,
 -1,
 331878161,
 43517,
 -60469,
 331830243,
 43514,
 -1,
 332018506,
 43496,
 332267519,
 330791560,
 -1,
 332272595,
 332141361,
 -1,
 -60465,
 332226134,
 43491,
 -60464,
 332286569,
 43490,
 -60463,
 332347689,
 43488,
 -60462,
 332406616,
 43489,
 -1,
 332470779,
 43492,
 332726271,
 332239410,
 -1,
 -60459,
 332626663,
 43647,
 -1,
 332668760,
 43646,
 332862436,
 330727958,
 -1,
 332927962,
 332824910,
 -1,
 -60455,
 332895446,
 43506,
 -1,
 332939090,
 43507,
 333124573,
 332888098,
 -1,
 -60452,
 333072765,
 43510,
 -1,
 333132342,
 43511,
 333321184,
 333067046,
 -1,
 -60449,
 333276938,
 43508,
 -1,
 333334751,
 43509,
 -60447,
 333289735,
 43504,
 -60446,
 333472516,
 43505,
 -60445,
 333536706,
 43513,
 -1,
 333590016,
 43512,
 333779945,
 332823632,
 -1,
 333845480,
 333742631,
 -1,
 -60441,
 333777951,
 43645,
 -1,
 333842930,
 43644,
 -1,
 333806349,
 43493,
 -1,
 333732418,
 43494,
 -60437,
 330666265,
 983173,
 -60436,
 334139658,
 983216,
 -1,
 334191359,
 983228,
 334371174,
 228396817,
 -1,
 334435971,
 334322519,
 -1,
 334501493,
 334370650,
 -1,
 334566511,
 334432598,
 -1,
 334631943,
 334497990,
 -1,
 334697462,
 334564705,
 83070,
 -60428,
 334634295,
 83073,
 -60427,
 334698530,
 83072,
 -1,
 334761745,
 83071,
 334959610,
 334629763,
 83062,
 -60424,
 334896439,
 83065,
 -60423,
 334960674,
 83064,
 -1,
 335023889,
 83063,
 335221757,
 334892063,
 83066,
 -60420,
 335157282,
 83068,
 -1,
 335220497,
 83067,
 335418367,
 335153650,
 83059,
 -1,
 335351569,
 83060,
 335549441,
 335350102,
 83057,
 -1,
 335482641,
 83058,
 335680515,
 335481030,
 83055,
 -1,
 335613713,
 83056,
 -60412,
 335613574,
 83075,
 -60411,
 335744519,
 83074,
 -60410,
 335809737,
 83069,
 -1,
 335874762,
 83061,
 336073749,
 334563670,
 -1,
 336139275,
 336005318,
 83076,
 -60406,
 336074786,
 83078,
 -1,
 336138001,
 83077,
 336335885,
 336071711,
 83083,
 -1,
 336269073,
 83084,
 -60402,
 336268934,
 83088,
 -60401,
 336399879,
 83087,
 -60400,
 336465249,
 83086,
 -60399,
 336530633,
 83085,
 -60398,
 336595843,
 83082,
 -60397,
 336661194,
 83081,
 -60396,
 336726514,
 83080,
 -1,
 336791894,
 83079,
 336991265,
 336005834,
 -1,
 337056792,
 336923679,
 83105,
 -1,
 336989969,
 83106,
 -60391,
 336989830,
 83110,
 -60390,
 337120775,
 83109,
 -60389,
 337186145,
 83108,
 -60388,
 337251529,
 83107,
 -60387,
 337316739,
 83104,
 -60386,
 337382090,
 83103,
 -60385,
 337447410,
 83102,
 -60384,
 337512790,
 83101,
 -1,
 337578182,
 83100,
 337777709,
 336923122,
 -1,
 337843236,
 337710111,
 83094,
 -1,
 337776401,
 83095,
 -60379,
 337776262,
 83099,
 -60378,
 337907207,
 83098,
 -60377,
 337972577,
 83097,
 -60376,
 338037961,
 83096,
 -60375,
 338103171,
 83093,
 -60374,
 338168522,
 83092,
 -60373,
 338233842,
 83091,
 -60372,
 338299222,
 83090,
 -1,
 338364614,
 83089,
 338564152,
 337710726,
 -1,
 -60369,
 338497158,
 83170,
 -60368,
 338562567,
 83169,
 -60367,
 338627937,
 83168,
 -60366,
 338693321,
 83167,
 -60365,
 338758687,
 83166,
 -60364,
 338824067,
 83165,
 -60363,
 338889418,
 83164,
 -60362,
 338954738,
 83163,
 -60361,
 339020118,
 83162,
 -1,
 339085510,
 83161,
 339285059,
 338497031,
 -1,
 -60358,
 339218054,
 83160,
 -60357,
 339283463,
 83159,
 -60356,
 339348833,
 83158,
 -60355,
 339414217,
 83157,
 -60354,
 339479583,
 83156,
 -60353,
 339544963,
 83155,
 -60352,
 339610314,
 83154,
 -60351,
 339675634,
 83153,
 -60350,
 339741014,
 83152,
 -1,
 339806406,
 83151,
 340005966,
 339217761,
 -1,
 -60347,
 339938950,
 83150,
 -60346,
 340004359,
 83149,
 -60345,
 340069729,
 83148,
 -60344,
 340135113,
 83147,
 -60343,
 340200479,
 83146,
 -60342,
 340265859,
 83145,
 -60341,
 340331210,
 83144,
 -60340,
 340396530,
 83143,
 -60339,
 340461910,
 83142,
 -1,
 340527302,
 83141,
 340726873,
 339938505,
 -1,
 -60336,
 340659846,
 83140,
 -60335,
 340725255,
 83139,
 -60334,
 340790625,
 83138,
 -60333,
 340856009,
 83137,
 -60332,
 340921375,
 83136,
 -60331,
 340986755,
 83135,
 -60330,
 341052106,
 83134,
 -60329,
 341117426,
 83133,
 -60328,
 341182806,
 83132,
 -1,
 341248198,
 83131,
 341447780,
 340659231,
 -1,
 -60325,
 341380742,
 83130,
 -60324,
 341446151,
 83129,
 -60323,
 341511521,
 83128,
 -60322,
 341576905,
 83127,
 -60321,
 341642271,
 83126,
 -60320,
 341707651,
 83125,
 -60319,
 341773002,
 83124,
 -60318,
 341838322,
 83123,
 -60317,
 341903702,
 83122,
 -1,
 341969094,
 83121,
 342228991,
 341379971,
 -1,
 -60314,
 342101638,
 83120,
 -60313,
 342167047,
 83119,
 -60312,
 342232417,
 83118,
 -60311,
 342297801,
 83117,
 -60310,
 342363167,
 83116,
 -60309,
 342428547,
 83115,
 -60308,
 342493898,
 83114,
 -60307,
 342559218,
 83113,
 -60306,
 342624598,
 83112,
 -1,
 342689990,
 83111,
 342889710,
 334498506,
 -1,
 342955137,
 342821578,
 -1,
 343020661,
 342887625,
 83322,
 -60301,
 342957367,
 83325,
 -60300,
 343021602,
 83324,
 -1,
 343084817,
 83323,
 343282809,
 342952434,
 -1,
 -60297,
 343219511,
 83318,
 -60296,
 343283746,
 83317,
 -1,
 343346961,
 83316,
 -60294,
 343215750,
 83328,
 -60293,
 343477767,
 83327,
 -60292,
 343543137,
 83326,
 -60291,
 343608351,
 83321,
 -60290,
 343673731,
 83320,
 -60289,
 343739082,
 83319,
 -60288,
 343804246,
 83315,
 -1,
 343869638,
 83314,
 344069264,
 342887943,
 -1,
 344134788,
 344001737,
 83381,
 -1,
 344067857,
 83382,
 344265863,
 344066762,
 -1,
 -60282,
 344198929,
 83378,
 -1,
 344261672,
 83377,
 344462473,
 344197462,
 83374,
 -1,
 344395537,
 83375,
 -60278,
 344395398,
 83385,
 -60277,
 344526343,
 83384,
 -60276,
 344591713,
 83383,
 -60275,
 344656927,
 83380,
 -60274,
 344722307,
 83379,
 -60273,
 344787442,
 83376,
 -1,
 344852678,
 83373,
 345052317,
 344001737,
 -1,
 345117843,
 344985095,
 83359,
 -1,
 345050897,
 83360,
 345248917,
 345049987,
 83354,
 -1,
 345181969,
 83355,
 -60266,
 345181830,
 83361,
 -60265,
 345312609,
 83358,
 -60264,
 345377993,
 83357,
 -60263,
 345443359,
 83356,
 -60262,
 345508554,
 83353,
 -60261,
 345573874,
 83352,
 -60260,
 345639254,
 83351,
 -1,
 345704646,
 83350,
 345904297,
 344984929,
 -1,
 345969824,
 345835862,
 83363,
 -1,
 345902865,
 83364,
 -60255,
 345902726,
 83372,
 -60254,
 346033671,
 83371,
 -60253,
 346099041,
 83370,
 -60252,
 346164425,
 83369,
 -60251,
 346229791,
 83368,
 -60250,
 346295171,
 83367,
 -60249,
 346360522,
 83366,
 -60248,
 346425842,
 83365,
 -1,
 346491078,
 83362,
 346690741,
 345836575,
 -1,
 346756268,
 346623622,
 83348,
 -1,
 346689297,
 83349,
 -60243,
 346689031,
 83347,
 -60242,
 346819937,
 83346,
 -60241,
 346885321,
 83345,
 -60240,
 346950687,
 83344,
 -60239,
 347016067,
 83343,
 -60238,
 347081418,
 83342,
 -60237,
 347146738,
 83341,
 -60236,
 347212118,
 83340,
 -1,
 347277510,
 83339,
 347477185,
 346622450,
 -1,
 347542712,
 347410054,
 83312,
 -1,
 347475729,
 83313,
 -60231,
 347475463,
 83311,
 -60230,
 347606369,
 83310,
 -60229,
 347671753,
 83309,
 -60228,
 347737119,
 83308,
 -60227,
 347802499,
 83307,
 -60226,
 347867850,
 83306,
 -60225,
 347933170,
 83305,
 -60224,
 347998550,
 83304,
 -1,
 348063942,
 83303,
 348263629,
 347408582,
 -1,
 348329156,
 348196486,
 83291,
 -1,
 348262161,
 83292,
 -60219,
 348261895,
 83290,
 -60218,
 348392801,
 83289,
 -60217,
 348458185,
 83288,
 -60216,
 348523551,
 83287,
 -60215,
 348588931,
 83286,
 -60214,
 348654282,
 83285,
 -60213,
 348719602,
 83284,
 -60212,
 348784982,
 83283,
 -1,
 348850374,
 83282,
 349050072,
 348196486,
 -1,
 -60209,
 348982918,
 83395,
 -60208,
 349048327,
 83394,
 -60207,
 349113697,
 83393,
 -60206,
 349179081,
 83392,
 -60205,
 349244447,
 83391,
 -60204,
 349309827,
 83390,
 -60203,
 349375195,
 83389,
 -60202,
 349440498,
 83388,
 -60201,
 349505878,
 83387,
 -1,
 349571270,
 83386,
 349770979,
 348982147,
 -1,
 -60198,
 349703814,
 83338,
 -60197,
 349769223,
 83337,
 -60196,
 349834593,
 83336,
 -60195,
 349899977,
 83335,
 -60194,
 349965343,
 83334,
 -60193,
 350030723,
 83333,
 -60192,
 350096074,
 83332,
 -60191,
 350161394,
 83331,
 -60190,
 350226774,
 83330,
 -1,
 350292166,
 83329,
 350552063,
 349702486,
 -1,
 -60187,
 350424710,
 83302,
 -60186,
 350490119,
 83301,
 -60185,
 350555489,
 83300,
 -60184,
 350620873,
 83299,
 -60183,
 350686239,
 83298,
 -60182,
 350751619,
 83297,
 -60181,
 350816970,
 83296,
 -60180,
 350882290,
 83295,
 -60179,
 350947670,
 83294,
 -1,
 351013062,
 83293,
 351212904,
 342821362,
 -1,
 351278334,
 351144134,
 -1,
 351343859,
 351209970,
 83173,
 -60174,
 351279138,
 83175,
 -1,
 351342353,
 83174,
 351540469,
 351276678,
 83183,
 -1,
 351473425,
 83184,
 351671543,
 351472993,
 83180,
 -1,
 351604497,
 83181,
 -60168,
 351604231,
 83182,
 -60167,
 351734985,
 83179,
 -60166,
 351800351,
 83178,
 -60165,
 351865731,
 83177,
 -60164,
 351931082,
 83176,
 -60163,
 351996246,
 83172,
 -1,
 352061638,
 83171,
 352261387,
 351211142,
 -1,
 352326913,
 352194182,
 83280,
 -1,
 352259857,
 83281,
 352457987,
 352258947,
 83274,
 -1,
 352390929,
 83275,
 -60156,
 352390663,
 83279,
 -60155,
 352521569,
 83278,
 -60154,
 352586953,
 83277,
 -60153,
 352652319,
 83276,
 -60152,
 352717514,
 83273,
 -60151,
 352782834,
 83272,
 -60150,
 352848214,
 83271,
 -1,
 352913606,
 83270,
 353113368,
 352192854,
 -1,
 353178894,
 353045705,
 83192,
 -1,
 353111825,
 83193,
 353309968,
 353111071,
 83190,
 -1,
 353242897,
 83191,
 -60143,
 353242758,
 83196,
 -60142,
 353373703,
 83195,
 -60141,
 353439073,
 83194,
 -60140,
 353504131,
 83189,
 -60139,
 353569482,
 83188,
 -60138,
 353634802,
 83187,
 -60137,
 353700182,
 83186,
 -1,
 353765574,
 83185,
 353965348,
 353046023,
 -1,
 354030875,
 353898118,
 83268,
 -1,
 353963793,
 83269,
 -60132,
 353963527,
 83267,
 -60131,
 354094433,
 83266,
 -60130,
 354159817,
 83265,
 -60129,
 354225183,
 83264,
 -60128,
 354290563,
 83263,
 -60127,
 354355914,
 83262,
 -60126,
 354421234,
 83261,
 -60125,
 354486614,
 83260,
 -1,
 354552006,
 83259,
 354751792,
 353897673,
 -1,
 354817319,
 354684257,
 83245,
 -1,
 354750225,
 83246,
 -60120,
 354750086,
 83248,
 -60119,
 354881031,
 83247,
 -60118,
 354946249,
 83244,
 -60117,
 355011615,
 83243,
 -60116,
 355076995,
 83242,
 -60115,
 355142346,
 83241,
 -60114,
 355207666,
 83240,
 -60113,
 355273046,
 83239,
 -1,
 355338438,
 83238,
 355538236,
 354683378,
 -1,
 355603763,
 355470689,
 83204,
 -1,
 355536657,
 83205,
 -60108,
 355536518,
 83207,
 -60107,
 355667463,
 83206,
 -60106,
 355732681,
 83203,
 -60105,
 355798047,
 83202,
 -60104,
 355863427,
 83201,
 -60103,
 355928778,
 83200,
 -60102,
 355994098,
 83199,
 -60101,
 356059478,
 83198,
 -1,
 356124870,
 83197,
 356324679,
 355470689,
 -1,
 -60098,
 356257414,
 83258,
 -60097,
 356322823,
 83257,
 -60096,
 356388193,
 83256,
 -60095,
 356453577,
 83255,
 -60094,
 356518943,
 83254,
 -60093,
 356584323,
 83253,
 -60092,
 356649674,
 83252,
 -60091,
 356714994,
 83251,
 -60090,
 356780374,
 83250,
 -1,
 356845766,
 83249,
 357045586,
 356256799,
 -1,
 -60087,
 356978310,
 83237,
 -60086,
 357043719,
 83236,
 -60085,
 357109089,
 83235,
 -60084,
 357174473,
 83234,
 -60083,
 357239839,
 83233,
 -60082,
 357305219,
 83232,
 -60081,
 357370570,
 83231,
 -60080,
 357435890,
 83230,
 -60079,
 357501270,
 83229,
 -1,
 357566662,
 83228,
 357766493,
 356977539,
 -1,
 -60076,
 357699206,
 83227,
 -60075,
 357764615,
 83226,
 -60074,
 357829985,
 83225,
 -60073,
 357895369,
 83224,
 -60072,
 357960735,
 83223,
 -60071,
 358026115,
 83222,
 -60070,
 358091466,
 83221,
 -60069,
 358156786,
 83220,
 -60068,
 358222166,
 83219,
 -1,
 358287558,
 83218,
 358547455,
 357698250,
 -1,
 -60065,
 358420102,
 83217,
 -60064,
 358485511,
 83216,
 -60063,
 358550881,
 83215,
 -60062,
 358616265,
 83214,
 -60061,
 358681631,
 83213,
 -60060,
 358747011,
 83212,
 -60059,
 358812362,
 83211,
 -60058,
 358877682,
 83210,
 -60057,
 358943062,
 83209,
 -1,
 359008454,
 83208,
 359208418,
 351144134,
 -1,
 359273848,
 359140227,
 -1,
 359339373,
 359206089,
 82994,
 -60052,
 359274530,
 82996,
 -1,
 359337745,
 82995,
 359535983,
 359271455,
 82992,
 -1,
 359468817,
 82993,
 359667057,
 359467350,
 82987,
 -1,
 359599889,
 82988,
 -60046,
 359599750,
 82999,
 -60045,
 359730695,
 82998,
 -60044,
 359796065,
 82997,
 -60043,
 359861123,
 82991,
 -60042,
 359926474,
 82990,
 -60041,
 359991794,
 82989,
 -1,
 360057030,
 82986,
 360256902,
 359206089,
 -1,
 360322429,
 360189129,
 83016,
 -60037,
 360258871,
 83019,
 -60036,
 360323106,
 83018,
 -1,
 360386321,
 83017,
 -60034,
 360255110,
 83022,
 -60033,
 360517127,
 83021,
 -60032,
 360582497,
 83020,
 -60031,
 360647711,
 83015,
 -60030,
 360713091,
 83014,
 -60029,
 360778442,
 83013,
 -60028,
 360843762,
 83012,
 -60027,
 360909142,
 83011,
 -1,
 360974534,
 83010,
 361174419,
 360189574,
 -1,
 361239945,
 361106951,
 83052,
 -1,
 361172753,
 83053,
 361371019,
 361172321,
 83050,
 -1,
 361303825,
 83051,
 -60020,
 361303686,
 83054,
 -60019,
 361434313,
 83049,
 -60018,
 361499679,
 83048,
 -60017,
 361565059,
 83047,
 -60016,
 361630410,
 83046,
 -60015,
 361695730,
 83045,
 -60014,
 361761110,
 83044,
 -1,
 361826502,
 83043,
 362026399,
 361106122,
 -1,
 362091926,
 361959046,
 82984,
 -1,
 362024721,
 82985,
 -60009,
 362024455,
 82983,
 -60008,
 362155361,
 82982,
 -60007,
 362220745,
 82981,
 -60006,
 362286111,
 82980,
 -60005,
 362351491,
 82979,
 -60004,
 362416842,
 82978,
 -60003,
 362482162,
 82977,
 -60002,
 362547542,
 82976,
 -1,
 362612934,
 82975,
 362812843,
 361957874,
 -1,
 362878370,
 362745033,
 82970,
 -1,
 362811153,
 82971,
 -59997,
 362811014,
 82974,
 -59996,
 362941959,
 82973,
 -59995,
 363007329,
 82972,
 -59994,
 363072543,
 82969,
 -59993,
 363137923,
 82968,
 -59992,
 363203274,
 82967,
 -59991,
 363268594,
 82966,
 -59990,
 363333974,
 82965,
 -1,
 363399366,
 82964,
 363599287,
 362744150,
 -1,
 363664814,
 363530438,
 82953,
 -1,
 363597585,
 82954,
 -59985,
 363597446,
 82963,
 -59984,
 363728391,
 82962,
 -59983,
 363793761,
 82961,
 -59982,
 363859145,
 82960,
 -59981,
 363924511,
 82959,
 -59980,
 363989891,
 82958,
 -59979,
 364055242,
 82957,
 -59978,
 364120562,
 82956,
 -1,
 364185942,
 82955,
 364385730,
 363531783,
 -1,
 -59975,
 364318342,
 83042,
 -59974,
 364383751,
 83041,
 -59973,
 364449121,
 83040,
 -59972,
 364514505,
 83039,
 -59971,
 364579871,
 83038,
 -59970,
 364645251,
 83037,
 -59969,
 364710602,
 83036,
 -59968,
 364775922,
 83035,
 -59967,
 364841302,
 83034,
 -1,
 364906694,
 83033,
 365106637,
 364318049,
 -1,
 -59964,
 365039238,
 83032,
 -59963,
 365104647,
 83031,
 -59962,
 365170017,
 83030,
 -59961,
 365235401,
 83029,
 -59960,
 365300767,
 83028,
 -59959,
 365366147,
 83027,
 -59958,
 365431498,
 83026,
 -59957,
 365496818,
 83025,
 -59956,
 365562198,
 83024,
 -1,
 365627590,
 83023,
 365827544,
 365038623,
 -1,
 -59953,
 365760134,
 83009,
 -59952,
 365825543,
 83008,
 -59951,
 365890913,
 83007,
 -59950,
 365956297,
 83006,
 -59949,
 366021663,
 83005,
 -59948,
 366087043,
 83004,
 -59947,
 366152394,
 83003,
 -59946,
 366217714,
 83002,
 -59945,
 366283094,
 83001,
 -1,
 366348486,
 83000,
 366608383,
 365758662,
 -1,
 -59942,
 366481030,
 82952,
 -59941,
 366546439,
 82951,
 -59940,
 366611809,
 82950,
 -59939,
 366677193,
 82949,
 -59938,
 366742559,
 82948,
 -59937,
 366807939,
 82947,
 -59936,
 366873290,
 82946,
 -59935,
 366938610,
 82945,
 -1,
 367003990,
 82944,
 367203923,
 359140227,
 -1,
 367269360,
 367135775,
 -1,
 367334886,
 367201633,
 83455,
 -1,
 367267601,
 83456,
 367465960,
 367265990,
 83447,
 -1,
 367398673,
 83448,
 -59927,
 367398534,
 83458,
 -59926,
 367529479,
 83457,
 -59925,
 367594697,
 83454,
 -59924,
 367660063,
 83453,
 -59923,
 367725443,
 83452,
 -59922,
 367790794,
 83451,
 -59921,
 367856114,
 83450,
 -1,
 367921494,
 83449,
 368121341,
 367200598,
 -1,
 368186868,
 368052422,
 -1,
 -59917,
 368119574,
 83407,
 -1,
 368181465,
 83406,
 -59915,
 368119430,
 83416,
 -59914,
 368315911,
 83415,
 -59913,
 368381281,
 83414,
 -59912,
 368446665,
 83413,
 -59911,
 368512031,
 83412,
 -59910,
 368577411,
 83411,
 -59909,
 368642762,
 83410,
 -59908,
 368708082,
 83409,
 -1,
 368773462,
 83408,
 368973320,
 368053767,
 -1,
 -59905,
 368905862,
 83488,
 -59904,
 368971271,
 83487,
 -59903,
 369036641,
 83486,
 -59902,
 369102025,
 83485,
 -59901,
 369167391,
 83484,
 -59900,
 369232771,
 83483,
 -59899,
 369298122,
 83482,
 -59898,
 369363442,
 83481,
 -59897,
 369428822,
 83480,
 -1,
 369494214,
 83479,
 369694227,
 368905569,
 -1,
 -59894,
 369626758,
 83478,
 -59893,
 369692167,
 83477,
 -59892,
 369757537,
 83476,
 -59891,
 369822921,
 83475,
 -59890,
 369888287,
 83474,
 -59889,
 369953667,
 83473,
 -59888,
 370019018,
 83472,
 -59887,
 370084338,
 83471,
 -59886,
 370149718,
 83470,
 -1,
 370215110,
 83469,
 370415134,
 369626313,
 -1,
 -59883,
 370347654,
 83468,
 -59882,
 370413063,
 83467,
 -59881,
 370478433,
 83466,
 -59880,
 370543817,
 83465,
 -59879,
 370609183,
 83464,
 -59878,
 370674563,
 83463,
 -59877,
 370739914,
 83462,
 -59876,
 370805234,
 83461,
 -59875,
 370870614,
 83460,
 -1,
 370936006,
 83459,
 371136041,
 370346883,
 -1,
 -59872,
 371068550,
 83446,
 -59871,
 371133959,
 83445,
 -59870,
 371199329,
 83444,
 -59869,
 371264713,
 83443,
 -59868,
 371330079,
 83442,
 -59867,
 371395459,
 83441,
 -59866,
 371460810,
 83440,
 -59865,
 371526130,
 83439,
 -59864,
 371591510,
 83438,
 -1,
 371656902,
 83437,
 371856948,
 371067594,
 -1,
 -59861,
 371789446,
 83436,
 -59860,
 371854855,
 83435,
 -59859,
 371920225,
 83434,
 -59858,
 371985609,
 83433,
 -59857,
 372050975,
 83432,
 -59856,
 372116355,
 83431,
 -59855,
 372181706,
 83430,
 -59854,
 372247026,
 83429,
 -59853,
 372312406,
 83428,
 -1,
 372377798,
 83427,
 372577855,
 371788274,
 -1,
 -59850,
 372510342,
 83426,
 -59849,
 372575751,
 83425,
 -59848,
 372641121,
 83424,
 -59847,
 372706505,
 83423,
 -59846,
 372771871,
 83422,
 -59845,
 372837251,
 83421,
 -59844,
 372902602,
 83420,
 -59843,
 372967922,
 83419,
 -59842,
 373033302,
 83418,
 -1,
 373098694,
 83417,
 373298762,
 372508870,
 -1,
 -59839,
 373231238,
 83405,
 -59838,
 373296647,
 83404,
 -59837,
 373362017,
 83403,
 -59836,
 373427401,
 83402,
 -59835,
 373492767,
 83401,
 -59834,
 373558147,
 83400,
 -59833,
 373623498,
 83399,
 -59832,
 373688818,
 83398,
 -59831,
 373754198,
 83397,
 -1,
 373819590,
 83396,
 374079487,
 373231238,
 -1,
 -59828,
 373951841,
 83496,
 -59827,
 374017225,
 83495,
 -59826,
 374082591,
 83494,
 -59825,
 374147971,
 83493,
 -59824,
 374213322,
 83492,
 -59823,
 374278642,
 83491,
 -59822,
 374344022,
 83490,
 -1,
 374409414,
 83489,
 374669311,
 367135775,
 -1,
 374675039,
 374540786,
 -1,
 -59818,
 374607494,
 83525,
 -59817,
 374672903,
 83524,
 -59816,
 374738273,
 83523,
 -59815,
 374803657,
 83522,
 -59814,
 374869023,
 83521,
 -59813,
 374934403,
 83520,
 -59812,
 374999754,
 83519,
 -59811,
 375065074,
 83518,
 -59810,
 375130454,
 83517,
 -1,
 375195846,
 83516,
 375395946,
 374606166,
 -1,
 -59807,
 375328390,
 83515,
 -59806,
 375393799,
 83514,
 -59805,
 375459169,
 83513,
 -59804,
 375524553,
 83512,
 -59803,
 375589919,
 83511,
 -59802,
 375655299,
 83510,
 -59801,
 375720650,
 83509,
 -59800,
 375785970,
 83508,
 -59799,
 375851350,
 83507,
 -1,
 375916742,
 83506,
 376116852,
 375326918,
 -1,
 -59796,
 376049286,
 83505,
 -59795,
 376114695,
 83504,
 -59794,
 376180065,
 83503,
 -59793,
 376245449,
 83502,
 -59792,
 376310815,
 83501,
 -59791,
 376376195,
 83500,
 -59790,
 376441546,
 83499,
 -59789,
 376506866,
 83498,
 -1,
 376572246,
 83497,
 -1,
 376048493,
 83526,
 376837759,
 334463310,
 128028,
 376903294,
 376783233,
 -1,
 376968829,
 376866490,
 -1,
 -59783,
 376931737,
 11151,
 -59782,
 376992821,
 11148,
 -59781,
 377054417,
 11119,
 -59780,
 377114708,
 11150,
 -1,
 377166856,
 11149,
 -1,
 376908415,
 128260,
 -1,
 376844153,
 128246,
 377552895,
 376780713,
 -1,
 -59775,
 377457303,
 128551,
 -59774,
 377518106,
 128544,
 -1,
 377565324,
 128162,
 377755615,
 334393164,
 -1,
 377821143,
 377688001,
 -1,
 377886530,
 377771614,
 -1,
 377952065,
 377848641,
 -1,
 378017456,
 377890143,
 -1,
 378082989,
 377970789,
 -1,
 378148520,
 378046919,
 -1,
 378214032,
 378110286,
 -1,
 378279566,
 378157767,
 -1,
 -59763,
 378219987,
 126646,
 -1,
 378278426,
 126648,
 -59761,
 378219987,
 126645,
 -1,
 378409311,
 126632,
 378607252,
 378173474,
 -1,
 -59758,
 378551646,
 126644,
 -59757,
 378613082,
 126638,
 -1,
 378671207,
 126641,
 378869399,
 378574970,
 -1,
 -59754,
 378815453,
 126630,
 -1,
 378878663,
 126650,
 379066010,
 378807787,
 -1,
 -59751,
 379014391,
 126627,
 -1,
 379069791,
 126649,
 -59749,
 379033424,
 126633,
 -59748,
 379228644,
 126629,
 -59747,
 379286040,
 126643,
 -59746,
 379350583,
 126642,
 -59745,
 379412141,
 126637,
 -59744,
 379476051,
 126636,
 -59743,
 379538892,
 126635,
 -59742,
 379603965,
 126647,
 -59741,
 379669061,
 126626,
 -59740,
 379730672,
 126631,
 -59739,
 379795757,
 126651,
 -59738,
 379859906,
 126640,
 -59737,
 379918673,
 126625,
 -1,
 379982204,
 126639,
 380239871,
 378111294,
 -1,
 -59734,
 380137015,
 126495,
 -59733,
 380198573,
 126493,
 -59732,
 380253122,
 126494,
 -1,
 380311889,
 126492,
 380567551,
 378015505,
 -1,
 -59729,
 380456183,
 126467,
 -1,
 380511583,
 126489,
 380704469,
 377965815,
 -1,
 380770004,
 380658810,
 -1,
 380835512,
 380731726,
 -1,
 380901046,
 380779207,
 -1,
 -59723,
 380841427,
 126614,
 -1,
 380899866,
 126616,
 -59721,
 380841427,
 126613,
 -1,
 381030751,
 126600,
 381228732,
 380794914,
 -1,
 -59718,
 381173086,
 126612,
 -59717,
 381234522,
 126606,
 -1,
 381292647,
 126609,
 381490879,
 381196410,
 -1,
 -59714,
 381436893,
 126598,
 -1,
 381500103,
 126618,
 381687490,
 381434567,
 -1,
 -59711,
 381627859,
 126596,
 -1,
 381686111,
 126599,
 381884101,
 381625835,
 -1,
 -59708,
 381832439,
 126595,
 -1,
 381887839,
 126617,
 382080712,
 381816593,
 -1,
 -59705,
 382029751,
 126592,
 -1,
 382092253,
 126607,
 -59703,
 382048080,
 126601,
 -59702,
 382243300,
 126597,
 -59701,
 382300696,
 126611,
 -59700,
 382365239,
 126610,
 -59699,
 382426797,
 126605,
 -59698,
 382490707,
 126604,
 -59697,
 382553548,
 126603,
 -59696,
 382618621,
 126615,
 -59695,
 382683717,
 126594,
 -59694,
 382744877,
 126619,
 -59693,
 382809026,
 126608,
 -1,
 382867793,
 126593,
 -1,
 380703434,
 126475,
 383129335,
 380663842,
 -1,
 383194868,
 383092313,
 -1,
 383260379,
 383156558,
 -1,
 -59687,
 383204707,
 126582,
 -59686,
 383266259,
 126581,
 -1,
 383324511,
 126568,
 383522527,
 383219746,
 -1,
 -59683,
 383466846,
 126580,
 -59682,
 383528282,
 126574,
 -1,
 383586407,
 126577,
 383784676,
 383460703,
 -1,
 383850211,
 383739463,
 -1,
 -59678,
 383792066,
 126590,
 -1,
 383850833,
 126588,
 -1,
 383783015,
 126585,
 384112359,
 383732419,
 -1,
 -59674,
 384056048,
 126583,
 -1,
 384110825,
 126570,
 384308970,
 384056007,
 -1,
 -59671,
 384249299,
 126564,
 -1,
 384307551,
 126567,
 -59669,
 384276605,
 126586,
 -59668,
 384472912,
 126569,
 -59667,
 384527927,
 126578,
 -59666,
 384589485,
 126573,
 -59665,
 384653395,
 126572,
 -59664,
 384715333,
 126562,
 -59663,
 384776493,
 126587,
 -59662,
 384840642,
 126576,
 -59661,
 384899409,
 126561,
 -1,
 384962940,
 126575,
 -59659,
 383139166,
 126484,
 -59658,
 385101146,
 126478,
 -1,
 385159271,
 126481,
 385357584,
 383075842,
 -1,
 385423100,
 385316898,
 -1,
 -59654,
 385367390,
 126516,
 -59653,
 385428826,
 126510,
 -1,
 385486951,
 126513,
 385685247,
 385384782,
 -1,
 -59650,
 385629539,
 126518,
 -1,
 385691091,
 126517,
 385881858,
 385632963,
 -1,
 -59647,
 385825520,
 126519,
 -1,
 385880297,
 126506,
 386078469,
 385825479,
 -1,
 -59644,
 386018771,
 126500,
 -1,
 386077023,
 126503,
 -59642,
 386045776,
 126505,
 -59641,
 386231863,
 126514,
 -59640,
 386293421,
 126509,
 -59639,
 386357331,
 126508,
 -59638,
 386420172,
 126507,
 -59637,
 386484805,
 126498,
 -59636,
 386545965,
 126523,
 -59635,
 386610114,
 126512,
 -59634,
 386672144,
 126521,
 -59633,
 386734417,
 126497,
 -1,
 386797948,
 126511,
 386996010,
 385319246,
 -1,
 387061542,
 386928401,
 -1,
 387127077,
 387007377,
 -1,
 387192599,
 387086370,
 -1,
 -59627,
 387136862,
 126548,
 -59626,
 387198298,
 126542,
 -1,
 387256423,
 126545,
 387454748,
 387130719,
 -1,
 387520283,
 387409479,
 -1,
 -59622,
 387477047,
 126559,
 -1,
 387538605,
 126557,
 -1,
 387453031,
 126553,
 -59619,
 387422032,
 126537,
 -59618,
 387739191,
 126546,
 -59617,
 387800749,
 126541,
 -59616,
 387861964,
 126539,
 -59615,
 387927037,
 126551,
 -59614,
 387992133,
 126530,
 -59613,
 388053744,
 126535,
 -59612,
 388118829,
 126555,
 -1,
 388174204,
 126543,
 -1,
 387070663,
 126472,
 388437801,
 387005127,
 -1,
 -59608,
 388378067,
 126486,
 -1,
 388436506,
 126488,
 -1,
 388378067,
 126485,
 388699949,
 386963578,
 -1,
 -59604,
 388645853,
 126470,
 -1,
 388709063,
 126490,
 388896560,
 388654334,
 -1,
 -59601,
 388847715,
 126704,
 -1,
 388905716,
 126705,
 389093171,
 388844227,
 -1,
 -59598,
 389036784,
 126487,
 -1,
 389091561,
 126474,
 389289782,
 389025553,
 -1,
 -59595,
 389238711,
 126464,
 -1,
 389301213,
 126479,
 -59593,
 389257040,
 126473,
 -59592,
 389452260,
 126469,
 -59591,
 389509656,
 126483,
 -59590,
 389574199,
 126482,
 -59589,
 389635757,
 126477,
 -59588,
 389699667,
 126476,
 -59587,
 389761605,
 126466,
 -59586,
 389823216,
 126471,
 -59585,
 389888301,
 126491,
 -59584,
 389952450,
 126480,
 -1,
 390011217,
 126465,
 -1,
 377910892,
 2303,
 390272897,
 377845794,
 -1,
 390338397,
 390240263,
 -1,
 390403921,
 390299982,
 -1,
 390469451,
 390370529,
 -1,
 390534985,
 390434680,
 -1,
 -59576,
 390469996,
 64446,
 -1,
 390533063,
 64445,
 -59574,
 390469996,
 64437,
 -1,
 390664135,
 64436,
 390922239,
 390414184,
 -1,
 390928207,
 390818875,
 -1,
 -59570,
 390863212,
 64441,
 -1,
 390926279,
 64440,
 -59568,
 390863212,
 64439,
 -1,
 391057351,
 64438,
 391255894,
 390342733,
 -1,
 391321429,
 391217488,
 -1,
 -59564,
 391256428,
 64435,
 -1,
 391319495,
 64434,
 -1,
 391285167,
 64444,
 391583577,
 391216529,
 -1,
 -59560,
 391518572,
 64449,
 -1,
 391581639,
 64448,
 391780188,
 391525990,
 -1,
 -59557,
 391715180,
 64443,
 -1,
 391778247,
 64442,
 -1,
 391738683,
 64447,
 392042356,
 390289118,
 -1,
 392107889,
 391986666,
 -1,
 392173418,
 392073497,
 -1,
 392238953,
 392127852,
 -1,
 392304486,
 392171281,
 -1,
 -59549,
 392266538,
 2266,
 -59548,
 392329357,
 2267,
 -59547,
 392392587,
 2260,
 -1,
 392453010,
 2268,
 -59545,
 392270201,
 2271,
 -59544,
 392591553,
 2269,
 -1,
 392654426,
 2270,
 -1,
 392173553,
 2291,
 392894317,
 392132642,
 -1,
 -59540,
 392839963,
 2273,
 -1,
 392892519,
 2261,
 -59538,
 392850999,
 2263,
 -59537,
 393043634,
 2264,
 -59536,
 393098714,
 2272,
 -1,
 393154940,
 2262,
 393412607,
 392058089,
 -1,
 -59533,
 393318884,
 2259,
 -1,
 393371314,
 2265,
 393549696,
 391983180,
 -1,
 393615231,
 393516884,
 -1,
 393680762,
 393547537,
 -1,
 393746297,
 393629623,
 983633,
 -1,
 393675446,
 983635,
 -1,
 393685855,
 983640,
 -59525,
 393648245,
 983638,
 -59524,
 393908708,
 983634,
 -59523,
 393971863,
 983637,
 -59522,
 394027306,
 983636,
 -1,
 394079071,
 983639,
 -1,
 393567938,
 983641,
 -1,
 393495333,
 1540,
 394401713,
 390221604,
 -1,
 394467246,
 394364799,
 -1,
 394532745,
 394399505,
 -1,
 394598280,
 394475288,
 -1,
 -59514,
 394554935,
 2236,
 -59513,
 394616493,
 2237,
 -1,
 394671042,
 2235,
 -1,
 394544113,
 2227,
 394925965,
 394499951,
 -1,
 -59509,
 394886509,
 2234,
 -59508,
 394935203,
 2216,
 -1,
 394995856,
 2217,
 395188114,
 394882892,
 -1,
 395253649,
 395128278,
 -1,
 -59504,
 395214189,
 2233,
 -1,
 395269307,
 2218,
 -1,
 395207064,
 2220,
 395515799,
 395123029,
 -1,
 395581334,
 395476243,
 -1,
 -59499,
 395546167,
 2208,
 -1,
 395597912,
 2230,
 -1,
 395525027,
 2209,
 395843482,
 395477326,
 -1,
 -59495,
 395783647,
 2232,
 -1,
 395841890,
 2211,
 396040093,
 395802658,
 -1,
 -59492,
 396002847,
 2225,
 -1,
 396038258,
 2223,
 396236704,
 395990548,
 -1,
 -59489,
 396176704,
 2215,
 -1,
 396236129,
 1564,
 396433315,
 396184823,
 -1,
 -59486,
 396388451,
 2221,
 -1,
 396432077,
 2214,
 396629926,
 396380954,
 -1,
 -59483,
 396590016,
 1568,
 -1,
 396636971,
 2228,
 -59481,
 396597377,
 2226,
 -59480,
 396792296,
 2219,
 -59479,
 396848699,
 2213,
 -59478,
 396913256,
 2231,
 -59477,
 396970570,
 2210,
 -59476,
 397031412,
 2224,
 -59475,
 397095878,
 2212,
 -1,
 397157918,
 2222,
 397410303,
 394409836,
 -1,
 -59472,
 397285740,
 2297,
 -1,
 397348807,
 2295,
 397547453,
 394363214,
 -1,
 397612988,
 397501192,
 -1,
 397678518,
 397576267,
 -1,
 -59467,
 397613420,
 2286,
 -1,
 397676487,
 2283,
 397875129,
 397632269,
 -1,
 -59464,
 397810028,
 2285,
 -1,
 397873095,
 2282,
 398131199,
 397825216,
 -1,
 -59461,
 398006636,
 2287,
 -1,
 398069703,
 2284,
 -1,
 397577501,
 2275,
 398333892,
 397485311,
 -1,
 398399424,
 398281581,
 2278,
 -1,
 398361174,
 2281,
 398530498,
 398341010,
 2276,
 -1,
 398492246,
 2279,
 398721023,
 398468683,
 2277,
 -1,
 398623318,
 2280,
 398792649,
 398271839,
 -1,
 398858183,
 398747300,
 2299,
 -1,
 398788134,
 2300,
 -59448,
 398805031,
 2274,
 -1,
 398922502,
 2302,
 399120333,
 398750552,
 -1,
 399185868,
 399052743,
 2296,
 -1,
 399115814,
 2301,
 -1,
 399120748,
 2298,
 399382481,
 399074507,
 -1,
 -59441,
 399330184,
 2290,
 -59440,
 399389604,
 2288,
 -1,
 399451729,
 2289,
 399644628,
 399324056,
 -1,
 -59437,
 399603003,
 2292,
 -1,
 399648912,
 2293,
 -59435,
 399610323,
 1631,
 -59434,
 399794172,
 1541,
 -1,
 399854451,
 2294,
 400037852,
 377772205,
 -1,
 400103387,
 399998247,
 -1,
 -59430,
 400070577,
 1416,
 -1,
 400132034,
 1376,
 -1,
 400042733,
 1423,
 400424959,
 400000067,
 -1,
 -59426,
 400326457,
 127912,
 -1,
 400368832,
 128667,
 400562311,
 377703671,
 -1,
 400627843,
 400498619,
 -1,
 400693242,
 400586786,
 -1,
 400758764,
 400656535,
 -1,
 400824299,
 400694096,
 -1,
 400889834,
 400763817,
 -1,
 400955368,
 400849112,
 -1,
 -59417,
 400892767,
 128807,
 -1,
 400954496,
 128814,
 -59415,
 400892767,
 128802,
 -1,
 401085568,
 128812,
 -1,
 400836343,
 128862,
 -1,
 400773778,
 128781,
 401414130,
 400691738,
 -1,
 401479665,
 401375566,
 128788,
 401604607,
 401408788,
 -1,
 -59408,
 401482598,
 128806,
 -1,
 401544320,
 128813,
 -1,
 401410085,
 128825,
 401807350,
 401375566,
 -1,
 401872885,
 401764482,
 128860,
 -1,
 401803295,
 128861,
 -1,
 401806789,
 128850,
 -59401,
 401763154,
 128839,
 -59400,
 402022573,
 128852,
 -59399,
 402080668,
 128795,
 -1,
 402136843,
 128847,
 402331661,
 400625425,
 -1,
 402397186,
 402288234,
 -1,
 402462721,
 402325504,
 -1,
 402528255,
 402428009,
 128776,
 -1,
 402458655,
 128777,
 402718719,
 402485778,
 128774,
 -1,
 402589727,
 128775,
 -1,
 402404882,
 128773,
 402855943,
 402345207,
 -1,
 402921477,
 402803513,
 128822,
 -1,
 402851871,
 128823,
 -59386,
 402885357,
 128837,
 -1,
 402992844,
 128874,
 -59384,
 402820359,
 128829,
 -59383,
 403143516,
 128855,
 -59382,
 403208124,
 128826,
 -59381,
 403267544,
 128811,
 -59380,
 403330770,
 128859,
 -1,
 403392327,
 128769,
 403576865,
 402267447,
 -1,
 403642393,
 403533644,
 -1,
 403707925,
 403606018,
 128869,
 403832831,
 403638301,
 -1,
 -59374,
 403704863,
 128873,
 -59373,
 403770243,
 128872,
 -59372,
 403835594,
 128871,
 -1,
 403900914,
 128870,
 404160511,
 403661068,
 -1,
 404166680,
 404038495,
 128803,
 -1,
 404097055,
 128804,
 -1,
 404113356,
 128798,
 404363293,
 403574545,
 -1,
 -59365,
 404319754,
 128846,
 -59364,
 404379153,
 128844,
 -1,
 404433685,
 128848,
 404625440,
 404317457,
 -1,
 -59361,
 404579711,
 128800,
 -1,
 404624500,
 128805,
 -1,
 404571683,
 128787,
 404887601,
 403533644,
 -1,
 404953135,
 404826975,
 -1,
 405018668,
 404896406,
 128818,
 405084200,
 404949021,
 -1,
 -59354,
 405015427,
 128821,
 -59353,
 405080778,
 128820,
 -1,
 405146098,
 128819,
 405405695,
 405013268,
 -1,
 405411883,
 405279872,
 128816,
 -1,
 405342239,
 128817,
 -1,
 405358540,
 128799,
 405608494,
 404951634,
 128827,
 -1,
 405538847,
 128828,
 -1,
 405571025,
 128877,
 405864447,
 404906216,
 128792,
 -1,
 405735455,
 128793,
 405936188,
 404822050,
 -1,
 406001718,
 405890407,
 128834,
 406126591,
 405932061,
 -1,
 -59339,
 405998282,
 128836,
 -1,
 406063602,
 128835,
 406263865,
 405935905,
 -1,
 -59336,
 406228566,
 128876,
 -1,
 406280046,
 128875,
 -59334,
 406221610,
 128857,
 -59333,
 406408583,
 128783,
 -1,
 406472707,
 128830,
 406657094,
 405900853,
 -1,
 406722629,
 406601821,
 -1,
 406788163,
 406674640,
 128778,
 406853698,
 406718493,
 -1,
 -59327,
 406784714,
 128780,
 -1,
 406850034,
 128779,
 -1,
 406782745,
 128815,
 407175167,
 406750992,
 128790,
 -1,
 407046175,
 128791,
 -1,
 406663339,
 128808,
 407312464,
 406612177,
 -1,
 407377995,
 407265381,
 -1,
 407443530,
 407343658,
 128843,
 -1,
 407383210,
 128858,
 -1,
 407404907,
 128856,
 407640142,
 407341207,
 -1,
 -59315,
 407602766,
 128868,
 -1,
 407663430,
 128867,
 -59313,
 407597399,
 128863,
 -1,
 407780884,
 128782,
 407967832,
 407273806,
 -1,
 408033364,
 407913437,
 -1,
 -59309,
 407970997,
 128840,
 -1,
 408028010,
 128809,
 408229974,
 407967277,
 128831,
 -1,
 408160287,
 128832,
 -59305,
 408194602,
 128845,
 -1,
 408318767,
 128849,
 408492127,
 407918100,
 -1,
 408557661,
 408432794,
 128784,
 408682495,
 408487965,
 -1,
 -59300,
 408554186,
 128786,
 -1,
 408619506,
 128785,
 -59298,
 408511549,
 128881,
 -1,
 408753412,
 128824,
 408950886,
 408435399,
 -1,
 409016419,
 408903781,
 -1,
 -59294,
 408980704,
 128878,
 -1,
 409040819,
 128854,
 409272319,
 408949313,
 -1,
 -59291,
 409167598,
 128883,
 -1,
 409217768,
 128882,
 409409644,
 408888671,
 -1,
 409475179,
 409356266,
 -1,
 409540714,
 409435659,
 128865,
 -1,
 409471007,
 128866,
 -1,
 409502892,
 128864,
 -1,
 409409533,
 128880,
 409802864,
 409356236,
 -1,
 409868399,
 409731946,
 128796,
 -1,
 409798687,
 128797,
 -1,
 409798703,
 128801,
 410065011,
 409768241,
 -1,
 -59278,
 410031602,
 128842,
 -1,
 410092263,
 128772,
 410261622,
 410021695,
 -1,
 -59275,
 410214344,
 128768,
 -1,
 410263809,
 128833,
 410458233,
 410213797,
 -1,
 -59272,
 410420800,
 128789,
 -1,
 410466639,
 128879,
 410654844,
 410406135,
 -1,
 -59269,
 410607900,
 128851,
 -1,
 410659835,
 128810,
 410851455,
 410597289,
 -1,
 -59266,
 410815213,
 128841,
 -1,
 410870263,
 128794,
 -59264,
 410815745,
 128853,
 -59263,
 411001255,
 128838,
 -59262,
 411055327,
 128770,
 -1,
 411118634,
 128771,
 -59260,
 400578068,
 983201,
 -59259,
 411255246,
 128126,
 -59258,
 411316516,
 983054,
 -1,
 411374990,
 9200,
 411572475,
 400500063,
 -1,
 411638007,
 411520464,
 -1,
 411703477,
 411573559,
 -1,
 411769012,
 411636938,
 -1,
 411834511,
 411720535,
 -1,
 -59251,
 411801352,
 125209,
 -59250,
 411863840,
 125200,
 -1,
 411908821,
 125211,
 412096659,
 411781827,
 -1,
 -59247,
 412052498,
 125216,
 -59246,
 412105429,
 125213,
 -1,
 412160233,
 125201,
 412358806,
 412063405,
 -1,
 -59243,
 412302475,
 125198,
 -1,
 412356369,
 125202,
 412555417,
 412317730,
 -1,
 -59240,
 412501547,
 125189,
 -1,
 412564181,
 125217,
 412752028,
 412497833,
 -1,
 -59237,
 412686638,
 125214,
 -1,
 412749585,
 125208,
 412948639,
 412689759,
 -1,
 -59234,
 412891861,
 125197,
 -1,
 412946282,
 125185,
 413145250,
 412882978,
 -1,
 -59231,
 413088907,
 125191,
 -1,
 413142801,
 125188,
 -59229,
 413112491,
 125215,
 -59228,
 413307364,
 125199,
 -59227,
 413371975,
 125212,
 -59226,
 413436055,
 125203,
 -59225,
 413501334,
 125210,
 -59224,
 413560729,
 125192,
 -59223,
 413625906,
 125207,
 -59222,
 413690444,
 125190,
 -59221,
 413753445,
 125196,
 -59220,
 413817236,
 125187,
 -59219,
 413879628,
 125186,
 -59218,
 413944441,
 125204,
 -59217,
 414007389,
 125195,
 -59216,
 414071509,
 125206,
 -59215,
 414135114,
 125194,
 -59214,
 414198623,
 125193,
 -59213,
 414261218,
 125205,
 -1,
 414323288,
 125184,
 -1,
 411722788,
 125256,
 414587103,
 411663655,
 -1,
 414652602,
 414538583,
 -1,
 -59208,
 414619400,
 125243,
 -59207,
 414681888,
 125234,
 -1,
 414726869,
 125245,
 414914750,
 414599875,
 -1,
 -59204,
 414870546,
 125250,
 -59203,
 414923477,
 125247,
 -1,
 414978281,
 125235,
 415176897,
 414881453,
 -1,
 -59200,
 415120523,
 125232,
 -1,
 415174417,
 125236,
 415373508,
 415135778,
 -1,
 -59197,
 415319595,
 125223,
 -1,
 415382229,
 125251,
 415570119,
 415315881,
 -1,
 -59194,
 415504686,
 125248,
 -1,
 415567633,
 125242,
 415766730,
 415507807,
 -1,
 -59191,
 415709909,
 125231,
 -1,
 415764330,
 125219,
 415963341,
 415701026,
 -1,
 -59188,
 415906955,
 125225,
 -1,
 415960849,
 125222,
 -59186,
 415930539,
 125249,
 -59185,
 416125412,
 125233,
 -59184,
 416190023,
 125246,
 -59183,
 416254103,
 125237,
 -59182,
 416319382,
 125244,
 -59181,
 416378777,
 125226,
 -59180,
 416443954,
 125241,
 -59179,
 416508492,
 125224,
 -59178,
 416571493,
 125230,
 -59177,
 416635284,
 125221,
 -59176,
 416697676,
 125220,
 -59175,
 416762489,
 125238,
 -59174,
 416825437,
 125229,
 -59173,
 416889557,
 125240,
 -59172,
 416953162,
 125228,
 -59171,
 417016671,
 125227,
 -59170,
 417079266,
 125239,
 -1,
 417141336,
 125218,
 417339629,
 414525433,
 -1,
 417405155,
 417300814,
 -1,
 -59166,
 417371350,
 125266,
 -1,
 417414994,
 125267,
 417601766,
 417364002,
 -1,
 -59163,
 417548669,
 125270,
 -1,
 417608246,
 125271,
 417798377,
 417542950,
 -1,
 -59160,
 417752842,
 125268,
 -1,
 417810655,
 125269,
 -59158,
 417765639,
 125264,
 -59157,
 417948420,
 125265,
 -59156,
 418012610,
 125273,
 -1,
 418065920,
 125272,
 418257136,
 417285634,
 -1,
 -59153,
 418213658,
 125279,
 -1,
 418263740,
 125278,
 418453747,
 418199712,
 -1,
 -59150,
 418399995,
 125254,
 -1,
 418458483,
 125257,
 -59148,
 418418919,
 125253,
 -59147,
 418602990,
 125258,
 -59146,
 418659229,
 125255,
 -1,
 418714205,
 125252,
 418912506,
 411588116,
 -1,
 -59143,
 418859074,
 127903,
 -1,
 418918803,
 11237,
 -1,
 418876137,
 129489,
 419174731,
 411516606,
 -1,
 419240225,
 419123625,
 -1,
 419305730,
 419172113,
 71442,
 419430399,
 419255754,
 -1,
 -59136,
 419332566,
 71429,
 -59135,
 419379170,
 71446,
 -1,
 419436595,
 71450,
 419633414,
 419257175,
 -1,
 -59132,
 419600136,
 71440,
 -59131,
 419641314,
 71426,
 -1,
 419696401,
 71427,
 419895561,
 419594574,
 -1,
 -59128,
 419838677,
 71436,
 -1,
 419893009,
 71428,
 420092172,
 419850449,
 -1,
 -59125,
 420035285,
 71431,
 -1,
 420089617,
 71430,
 420288783,
 420039363,
 -1,
 -59122,
 420231893,
 71425,
 -1,
 420286225,
 71424,
 420485394,
 420235765,
 -1,
 -59119,
 420428501,
 71449,
 -1,
 420482833,
 71434,
 420682005,
 420427689,
 -1,
 -59116,
 420625109,
 71447,
 -1,
 420679441,
 71445,
 420878616,
 420619615,
 -1,
 -59113,
 420821717,
 71444,
 -1,
 420876049,
 71443,
 421075227,
 420812834,
 -1,
 -59110,
 421018325,
 71448,
 -1,
 421072657,
 71432,
 -59108,
 421034142,
 71439,
 -59107,
 421228441,
 71437,
 -59106,
 421287518,
 71433,
 -59105,
 421350729,
 71438,
 -59104,
 421411541,
 71441,
 -1,
 421470040,
 71435,
 421665069,
 419205368,
 -1,
 421730599,
 421596945,
 71456,
 -59100,
 421695769,
 71463,
 -59099,
 421746196,
 71466,
 -59098,
 421806173,
 71465,
 -1,
 421859089,
 71457,
 422058281,
 421693591,
 71460,
 -1,
 422021271,
 71461,
 422189355,
 422002781,
 71458,
 -1,
 422133853,
 71459,
 -59092,
 422142053,
 71464,
 -1,
 422259551,
 71462,
 422451515,
 421603321,
 -1,
 422517041,
 422412622,
 -1,
 -59088,
 422483158,
 71474,
 -1,
 422526802,
 71475,
 422713652,
 422475810,
 -1,
 -59085,
 422660477,
 71478,
 -1,
 422720054,
 71479,
 422910263,
 422654758,
 -1,
 -59082,
 422864650,
 71476,
 -1,
 422922463,
 71477,
 -59080,
 422877447,
 71472,
 -59079,
 423060228,
 71473,
 -59078,
 423124418,
 71481,
 -1,
 423177728,
 71480,
 423369027,
 422410274,
 -1,
 423434562,
 423314166,
 -1,
 423500096,
 423393314,
 -1,
 -59073,
 423450382,
 71484,
 -1,
 423505044,
 71485,
 -59071,
 423458810,
 71486,
 -1,
 423644178,
 71467,
 -1,
 423401538,
 71487,
 423893320,
 423305963,
 -1,
 423958855,
 423841015,
 -1,
 -59066,
 423903751,
 71455,
 -1,
 423956241,
 71453,
 -1,
 423915417,
 71454,
 424280063,
 423845914,
 -1,
 -59062,
 424186470,
 71483,
 -1,
 424226542,
 71482,
 424417616,
 419137687,
 -1,
 424483151,
 424379769,
 -1,
 -59058,
 424435889,
 128663,
 -1,
 424482554,
 127975,
 -1,
 424417685,
 127814,
 424745301,
 424378162,
 -1,
 424810836,
 424701772,
 -1,
 -59053,
 424764415,
 9954,
 -1,
 424808601,
 11225,
 -1,
 424764347,
 128562,
 425072985,
 424700113,
 -1,
 -59049,
 425028559,
 983194,
 -59048,
 425091617,
 11236,
 -1,
 425139511,
 983195,
 425335133,
 425022996,
 -1,
 -59045,
 425290529,
 127994,
 -59044,
 425341127,
 127944,
 -1,
 425401561,
 128657,
 425597280,
 425281489,
 -1,
 -59041,
 425535289,
 128747,
 -1,
 425596371,
 128748,
 425793890,
 425533685,
 983053,
 -1,
 425746233,
 983052,
 -59037,
 425758839,
 129361,
 -59036,
 425886584,
 128095,
 -59035,
 425930937,
 128673,
 -1,
 425990272,
 129518,
 426188599,
 334305314,
 -1,
 426253642,
 426118929,
 -1,
 426319002,
 426203951,
 -1,
 426383944,
 426257249,
 -1,
 426449318,
 426335063,
 -1,
 426514821,
 426391465,
 -1,
 426580341,
 426461891,
 -1,
 426645872,
 426543255,
 -1,
 -59025,
 426600657,
 92598,
 -1,
 426661396,
 92619,
 426842483,
 426586537,
 -1,
 -59022,
 426808818,
 92543,
 -1,
 426840221,
 92553,
 427098111,
 426774289,
 92531,
 -1,
 426971901,
 92601,
 427170174,
 426522537,
 -1,
 427235706,
 427133079,
 -1,
 -59016,
 427192247,
 92550,
 -59015,
 427256017,
 92624,
 -1,
 427299029,
 92563,
 427556863,
 427174751,
 -1,
 427563389,
 427460904,
 92607,
 -1,
 427524430,
 92535,
 -1,
 427502885,
 92557,
 427760000,
 427133224,
 92640,
 -1,
 427721038,
 92657,
 427891075,
 427712613,
 -1,
 -59006,
 427847213,
 92544,
 -1,
 427911377,
 92541,
 -59004,
 427831807,
 92579,
 -1,
 428019473,
 92658,
 428218767,
 426452319,
 -1,
 428284299,
 428150545,
 -1,
 428349834,
 428216083,
 -1,
 -58999,
 428310001,
 92562,
 -1,
 428366662,
 92637,
 -1,
 428304593,
 92518,
 428611982,
 428228701,
 -1,
 -58995,
 428568109,
 92558,
 -1,
 428610797,
 92592,
 -1,
 428575520,
 92528,
 428874133,
 428165621,
 -1,
 428939668,
 428813151,
 -1,
 429005203,
 428878687,
 92628,
 -1,
 428933575,
 92648,
 -1,
 428969522,
 92547,
 -1,
 428871847,
 92554,
 429267354,
 428833416,
 -1,
 429332889,
 429230231,
 -1,
 -58984,
 429286556,
 92527,
 -1,
 429337439,
 92545,
 -1,
 429277642,
 92540,
 429595037,
 429234296,
 -1,
 -58980,
 429558995,
 92609,
 -1,
 429593837,
 92583,
 429791648,
 429561773,
 -1,
 -58977,
 429728108,
 92589,
 -1,
 429791661,
 92608,
 429988259,
 429752654,
 -1,
 -58974,
 429951725,
 92604,
 -1,
 429986981,
 92622,
 430184869,
 429920017,
 92662,
 -1,
 430123871,
 92613,
 -1,
 430132350,
 92584,
 430381502,
 426404049,
 -1,
 430447021,
 430344343,
 92576,
 430512555,
 430378769,
 -1,
 -58966,
 430468653,
 92618,
 -1,
 430517087,
 92529,
 -58964,
 430462484,
 92561,
 -1,
 430648159,
 92649,
 430840243,
 430378769,
 -1,
 430905776,
 430771985,
 92524,
 -1,
 430855700,
 92536,
 431095807,
 430834636,
 -1,
 -58958,
 430986757,
 92634,
 -1,
 431042564,
 92625,
 431233463,
 430784605,
 92663,
 431357951,
 431172447,
 -1,
 -58954,
 431259982,
 92621,
 -1,
 431304777,
 92593,
 431495612,
 431172447,
 -1,
 431561147,
 431458455,
 -1,
 -58950,
 431527410,
 92647,
 -1,
 431587662,
 92605,
 -1,
 431500993,
 92548,
 431882239,
 431448165,
 92568,
 -1,
 431776422,
 92610,
 431954385,
 430331412,
 -1,
 432019908,
 431886097,
 92667,
 432085442,
 431958879,
 92600,
 -1,
 432035348,
 92542,
 -58941,
 432041517,
 92668,
 -1,
 432171217,
 92555,
 432347590,
 431964253,
 92654,
 -1,
 432287010,
 92611,
 432478665,
 432289888,
 -1,
 -58936,
 432418542,
 92581,
 -1,
 432475921,
 92551,
 432675276,
 432412974,
 -1,
 -58933,
 432638701,
 92520,
 -1,
 432679775,
 92582,
 -58931,
 432640001,
 92617,
 -58930,
 432834856,
 92614,
 -58929,
 432890534,
 92671,
 -58928,
 432944124,
 92591,
 -1,
 433008366,
 92666,
 433199588,
 431915342,
 -1,
 433265112,
 433131281,
 -1,
 433330645,
 433196817,
 92635,
 -1,
 433286701,
 92577,
 -58922,
 433286701,
 92636,
 -58921,
 433411604,
 92530,
 -1,
 433467125,
 92559,
 433658332,
 433227927,
 -1,
 433723867,
 433608212,
 92586,
 -1,
 433655958,
 92569,
 -1,
 433655958,
 92566,
 433920480,
 433610853,
 -1,
 433986015,
 433872997,
 92537,
 -1,
 433937239,
 92519,
 -1,
 433942061,
 92630,
 434241535,
 433859423,
 -1,
 434248163,
 434145431,
 92669,
 -1,
 434180299,
 92572,
 -1,
 434199383,
 92672,
 434444790,
 433165997,
 -1,
 434510314,
 434407575,
 -1,
 -58905,
 434466349,
 92644,
 -58904,
 434527063,
 92645,
 -58903,
 434581577,
 92594,
 -1,
 434639028,
 92641,
 434837999,
 434450857,
 -1,
 434903533,
 434770070,
 92567,
 -1,
 434864462,
 92623,
 -58898,
 434869746,
 92639,
 -1,
 434984468,
 92606,
 435165682,
 434791712,
 -1,
 -58895,
 435126492,
 92642,
 -1,
 435168178,
 92643,
 435362293,
 435109981,
 -1,
 -58892,
 435323214,
 92590,
 -1,
 435367202,
 92564,
 -1,
 435295397,
 92588,
 435624450,
 434403362,
 -1,
 435689980,
 435567303,
 -1,
 435755514,
 435642469,
 92659,
 -1,
 435711533,
 92660,
 -58885,
 435701572,
 92638,
 -1,
 435827147,
 92580,
 436017663,
 435628895,
 -1,
 -58882,
 435978574,
 92560,
 -1,
 436022111,
 92534,
 -58880,
 435980593,
 92571,
 -58879,
 436167221,
 92525,
 -1,
 436211559,
 92549,
 436410895,
 435571959,
 -1,
 436476425,
 436363365,
 -1,
 436541959,
 436428901,
 -1,
 -58874,
 436502862,
 92556,
 -1,
 436558679,
 92523,
 -58872,
 436497965,
 92664,
 -1,
 436688404,
 92539,
 436869645,
 436408081,
 -1,
 -58869,
 436825645,
 92633,
 -58868,
 436889809,
 92521,
 -1,
 436933322,
 92575,
 -58866,
 436832407,
 92653,
 -1,
 437072312,
 92595,
 437262876,
 436357827,
 -1,
 437328404,
 437225623,
 -1,
 -58862,
 437289294,
 92620,
 -58861,
 437347484,
 92538,
 -1,
 437399915,
 92587,
 437590553,
 437267295,
 -1,
 437656088,
 437553303,
 -1,
 -58857,
 437622258,
 92646,
 -1,
 437653654,
 92570,
 -1,
 437616974,
 92599,
 -58854,
 437545729,
 92532,
 -58853,
 437870693,
 92665,
 -1,
 437928029,
 92670,
 438114856,
 437203750,
 -1,
 438180388,
 438077591,
 -1,
 438245922,
 438108160,
 -1,
 -58848,
 438202942,
 92661,
 -58847,
 438255709,
 92616,
 -1,
 438312346,
 92626,
 438566911,
 438184799,
 92596,
 -1,
 438468942,
 92612,
 438639142,
 438112017,
 92603,
 -1,
 438595117,
 92673,
 -58841,
 438592053,
 92627,
 -1,
 438709538,
 92651,
 438901301,
 438056873,
 -1,
 438966834,
 438844103,
 -1,
 439032368,
 438905695,
 -1,
 439097903,
 438995095,
 -1,
 -58835,
 439064050,
 92552,
 -58834,
 439114583,
 92565,
 -1,
 439160982,
 92615,
 -1,
 439058766,
 92602,
 -58831,
 438985269,
 92674,
 -1,
 439357299,
 92578,
 439615487,
 438901038,
 -1,
 -58828,
 439520818,
 92597,
 -1,
 439583054,
 92585,
 439753275,
 438857548,
 -1,
 439818809,
 439684881,
 -1,
 -58824,
 439774765,
 92526,
 -1,
 439823199,
 92656,
 -58822,
 439763901,
 92546,
 -1,
 439956007,
 92655,
 440146496,
 439718169,
 -1,
 440212031,
 440109207,
 -1,
 -58818,
 440164453,
 92533,
 -1,
 440216415,
 92650,
 -1,
 440152615,
 92574,
 440474181,
 440110645,
 -1,
 440539716,
 440413023,
 -1,
 -58813,
 440502568,
 92573,
 -1,
 440544095,
 92652,
 -1,
 440492597,
 92522,
 -58810,
 440426597,
 92631,
 -58809,
 440746077,
 92632,
 -1,
 440798993,
 92629,
 440998639,
 426321249,
 -1,
 441064061,
 440949591,
 -1,
 441129563,
 441005993,
 -1,
 441195091,
 441076419,
 -1,
 441260623,
 441135529,
 -1,
 -58802,
 441217807,
 92432,
 -1,
 441258187,
 92457,
 -58800,
 441227084,
 92435,
 -58799,
 441420576,
 92412,
 -58798,
 441467338,
 92476,
 -1,
 441521317,
 92414,
 441778175,
 441137065,
 -1,
 441784920,
 441650961,
 -1,
 441850455,
 441717450,
 92465,
 -1,
 441782422,
 92409,
 -1,
 441805009,
 92483,
 -58791,
 441749816,
 92467,
 -58790,
 442010498,
 92485,
 -1,
 442053159,
 92475,
 442243683,
 441076213,
 -1,
 442309214,
 442187869,
 92403,
 -1,
 442248482,
 92405,
 442440289,
 442249641,
 -1,
 -58784,
 442401102,
 92407,
 -1,
 442437789,
 92430,
 -58782,
 442403406,
 92487,
 -1,
 442569893,
 92418,
 442767979,
 442202146,
 -1,
 442833511,
 442712522,
 -1,
 -58778,
 442794318,
 92459,
 -1,
 442853585,
 92447,
 443030122,
 442776263,
 -1,
 -58775,
 442994140,
 92486,
 -1,
 443034914,
 92408,
 -1,
 442993389,
 92480,
 443292272,
 442734253,
 -1,
 -58771,
 443255343,
 92463,
 -58770,
 443301981,
 92493,
 -58769,
 443363691,
 92450,
 -1,
 443421386,
 92410,
 443619958,
 443229535,
 -1,
 443685492,
 443558751,
 -1,
 -58765,
 443649586,
 92425,
 -1,
 443689823,
 92437,
 -58763,
 443638438,
 92440,
 -1,
 443814602,
 92471,
 444013179,
 443580750,
 -1,
 444078714,
 443951967,
 -1,
 -58759,
 444041965,
 92472,
 -1,
 444083039,
 92505,
 -1,
 444042799,
 92514,
 -58756,
 443975831,
 92503,
 -1,
 444285021,
 92507,
 444471960,
 441013780,
 92497,
 444537477,
 444412710,
 -1,
 444603009,
 444489829,
 92445,
 -1,
 444554071,
 92404,
 444734084,
 444543401,
 -1,
 -58749,
 444694862,
 92424,
 -1,
 444731542,
 92458,
 -1,
 444678602,
 92466,
 444996233,
 444479584,
 -1,
 -58745,
 444948828,
 92438,
 -58744,
 445006282,
 92444,
 -1,
 445067742,
 92442,
 445258382,
 444935007,
 -1,
 445323917,
 445221015,
 -1,
 -58740,
 445284686,
 92427,
 -1,
 445340503,
 92478,
 -1,
 445263141,
 92496,
 445586066,
 445192226,
 -1,
 445651601,
 445517671,
 92448,
 -1,
 445580387,
 92515,
 -1,
 445614975,
 92401,
 445848213,
 445517585,
 -1,
 -58732,
 445796273,
 92426,
 -1,
 445853555,
 92482,
 -58730,
 445812925,
 92510,
 -58729,
 446007447,
 92499,
 -1,
 446063543,
 92441,
 446241451,
 444430370,
 -1,
 446306978,
 446184135,
 -1,
 446372511,
 446245727,
 -1,
 446438046,
 446335127,
 -1,
 -58723,
 446404082,
 92501,
 -1,
 446435478,
 92417,
 -1,
 446376799,
 92413,
 -58720,
 446335127,
 92504,
 -58719,
 446653725,
 92508,
 -1,
 446710608,
 92500,
 446896806,
 446269591,
 -1,
 -58716,
 446859415,
 92498,
 -58715,
 446901087,
 92419,
 -1,
 446959766,
 92473,
 447158953,
 446828305,
 -1,
 -58712,
 447114797,
 92516,
 -1,
 447178961,
 92423,
 -58710,
 447112687,
 92452,
 -1,
 447295947,
 92428,
 447486649,
 446188227,
 -1,
 447552179,
 447425375,
 -1,
 447617714,
 447514775,
 -1,
 -58705,
 447572177,
 92460,
 -58704,
 447636989,
 92431,
 -58703,
 447698452,
 92454,
 -1,
 447746273,
 92415,
 -1,
 447578446,
 92420,
 448010935,
 447514775,
 92489,
 -58699,
 447966765,
 92479,
 -58698,
 448029237,
 92422,
 -1,
 448093015,
 92474,
 -58696,
 447977292,
 92502,
 -1,
 448237885,
 92449,
 448404165,
 447447374,
 -1,
 448469696,
 448342879,
 -1,
 448535231,
 448432279,
 -1,
 -58691,
 448495950,
 92416,
 -58690,
 448551767,
 92481,
 -1,
 448598196,
 92451,
 -1,
 448474405,
 92456,
 448862914,
 448432279,
 92433,
 -1,
 448816623,
 92477,
 -58685,
 448816413,
 92492,
 -58684,
 448938077,
 92513,
 -1,
 448991382,
 92491,
 449190607,
 448351479,
 -1,
 449256140,
 449129311,
 -1,
 449321674,
 449218711,
 -1,
 -58679,
 449271316,
 92484,
 -1,
 449319105,
 92439,
 -58677,
 449282382,
 92464,
 -1,
 449457445,
 92495,
 -58675,
 449219309,
 92446,
 -58674,
 449602845,
 92511,
 -1,
 449659338,
 92406,
 449845976,
 449145041,
 -1,
 449911507,
 449808535,
 -1,
 -58670,
 449875420,
 92443,
 -1,
 449932845,
 92509,
 450108118,
 449850207,
 -1,
 -58667,
 450072035,
 92462,
 -1,
 450112351,
 92506,
 -58665,
 450053892,
 92461,
 -1,
 450237605,
 92469,
 450435808,
 449812141,
 -1,
 450501342,
 450398359,
 -1,
 450566877,
 450453605,
 -1,
 -58660,
 450521297,
 92470,
 -1,
 450582036,
 92468,
 -1,
 450532727,
 92453,
 -58657,
 450440942,
 92429,
 -1,
 450760877,
 92421,
 450960102,
 450391884,
 -1,
 451025636,
 450899697,
 -1,
 -58653,
 450978295,
 92490,
 -1,
 451042081,
 92512,
 -58651,
 450970448,
 92494,
 -1,
 451154077,
 92455,
 451353321,
 450924825,
 -1,
 -58648,
 451316017,
 92411,
 -1,
 451351717,
 92402,
 451549932,
 451295526,
 -1,
 -58645,
 451490227,
 92488,
 -1,
 451546983,
 92434,
 451805183,
 451490598,
 -1,
 -58642,
 451686865,
 92436,
 -1,
 451743591,
 92517,
 451943298,
 440933689,
 -1,
 452008740,
 451894103,
 -1,
 452074238,
 451950505,
 -1,
 452139769,
 452016041,
 -1,
 452205304,
 452102295,
 92362,
 -58635,
 452158118,
 92341,
 -58634,
 452220436,
 92347,
 -58633,
 452275560,
 92370,
 -1,
 452333752,
 92336,
 -1,
 452144878,
 92307,
 452598524,
 452086467,
 -1,
 -58629,
 452561462,
 92303,
 -1,
 452596973,
 92309,
 -58627,
 452551221,
 92368,
 -1,
 452728045,
 92395,
 452926214,
 452032546,
 -1,
 452991746,
 452888727,
 -1,
 -58623,
 452945414,
 92359,
 -1,
 453008215,
 92374,
 -58621,
 452944437,
 92371,
 -58620,
 453131324,
 92351,
 -58619,
 453194174,
 92325,
 -1,
 453250833,
 92350,
 453450511,
 452863327,
 -1,
 453516042,
 453390761,
 -1,
 -58615,
 453476686,
 92349,
 -1,
 453513423,
 92308,
 453712653,
 453447441,
 -1,
 -58612,
 453667025,
 92378,
 -1,
 453727764,
 92375,
 -58610,
 453665405,
 92317,
 -1,
 453853597,
 92331,
 454040343,
 453396981,
 -1,
 454105875,
 453978975,
 -1,
 -58606,
 454069810,
 92389,
 -1,
 454110501,
 92360,
 454302486,
 454037265,
 -1,
 -58603,
 454252052,
 92367,
 -1,
 454307521,
 92356,
 -1,
 454265422,
 92333,
 454564637,
 454000974,
 -1,
 454630171,
 454503263,
 -1,
 -58598,
 454593391,
 92345,
 -1,
 454646615,
 92372,
 -58596,
 454592679,
 92314,
 -1,
 454758247,
 92340,
 454957856,
 454531192,
 -1,
 -58593,
 454898138,
 92323,
 -1,
 454954769,
 92304,
 455154467,
 454889233,
 -1,
 -58590,
 455110189,
 92396,
 -1,
 455171950,
 92338,
 -1,
 455120863,
 92313,
 455416641,
 451958292,
 -1,
 455482167,
 455350306,
 -1,
 455547692,
 455420767,
 -1,
 455613226,
 455510167,
 -1,
 -58583,
 455579122,
 92385,
 -1,
 455628308,
 92315,
 -58581,
 455569335,
 92354,
 -1,
 455749210,
 92311,
 455940911,
 455491677,
 92381,
 -58578,
 455901518,
 92326,
 -1,
 455963456,
 92343,
 456137524,
 455872273,
 -1,
 456203059,
 456068883,
 -1,
 -58574,
 456157994,
 92387,
 -1,
 456203606,
 92318,
 -1,
 456155223,
 92383,
 456523775,
 456099991,
 -1,
 -58570,
 456403807,
 92324,
 -1,
 456462493,
 92364,
 456661822,
 455413521,
 -1,
 456727355,
 456600415,
 -1,
 -58566,
 456686594,
 92363,
 -1,
 456742800,
 92382,
 456982527,
 456654848,
 -1,
 -58563,
 456875910,
 92376,
 -1,
 456936419,
 92339,
 -58561,
 456624424,
 92391,
 -58560,
 457064906,
 92390,
 -1,
 457128041,
 92344,
 457317202,
 455363267,
 -1,
 457382733,
 457255775,
 -1,
 457448265,
 457345175,
 -1,
 457513799,
 457406498,
 -1,
 -58554,
 457457050,
 92319,
 -1,
 457519655,
 92384,
 -58552,
 457463316,
 92386,
 -1,
 457657159,
 92321,
 457841484,
 457399129,
 -1,
 -58549,
 457789122,
 92393,
 -1,
 457847725,
 92394,
 -1,
 457802062,
 92361,
 458103632,
 457345175,
 -1,
 -58545,
 458064206,
 92366,
 -1,
 458122399,
 92373,
 -58543,
 458058165,
 92328,
 -1,
 458231655,
 92329,
 458431321,
 457283245,
 -1,
 458496855,
 458393751,
 -1,
 -58539,
 458462583,
 92388,
 -58538,
 458511892,
 92305,
 -1,
 458556138,
 92322,
 -58536,
 458437109,
 92327,
 -1,
 458690407,
 92377,
 458890081,
 458391886,
 -1,
 458955613,
 458836077,
 -1,
 -58532,
 458918198,
 92358,
 -1,
 458952517,
 92334,
 459152224,
 458894175,
 -1,
 -58529,
 459116019,
 92346,
 -1,
 459178318,
 92400,
 -1,
 459083647,
 92332,
 459414377,
 458848290,
 -1,
 459479909,
 459356871,
 -1,
 -58524,
 459442766,
 92379,
 -1,
 459491140,
 92392,
 459676520,
 459418463,
 -1,
 -58521,
 459640370,
 92330,
 -1,
 459703064,
 92380,
 -1,
 459639106,
 92335,
 459938671,
 459361527,
 -1,
 460004205,
 459869969,
 -1,
 -58516,
 459958481,
 92342,
 -1,
 460019220,
 92357,
 -58514,
 459966615,
 92365,
 -1,
 460146500,
 92397,
 460331892,
 459892945,
 -1,
 460397427,
 460275805,
 -1,
 -58510,
 460354368,
 92316,
 -1,
 460413783,
 92398,
 -1,
 460336878,
 92399,
 460659577,
 460273577,
 -1,
 460725112,
 460602069,
 -1,
 -58505,
 460681143,
 92310,
 -1,
 460744913,
 92320,
 -1,
 460658955,
 92312,
 460987260,
 460624153,
 -1,
 -58501,
 460950410,
 92369,
 -1,
 460985347,
 92306,
 461183871,
 460951520,
 -1,
 -58498,
 461149682,
 92337,
 -1,
 461181125,
 92353,
 -58496,
 461141991,
 92355,
 -58495,
 461322139,
 92348,
 -1,
 461380833,
 92352,
 461577216,
 451874579,
 -1,
 461642662,
 461527895,
 -1,
 461708170,
 461603150,
 -1,
 461773705,
 461640869,
 92223,
 461897727,
 461701120,
 -1,
 -58488,
 461791154,
 92194,
 -1,
 461854934,
 92185,
 -1,
 461727025,
 92178,
 462101392,
 461649833,
 -1,
 462166926,
 462048433,
 -1,
 -58483,
 462119007,
 92182,
 -1,
 462160581,
 92160,
 -58481,
 462108889,
 92229,
 -1,
 462296112,
 92173,
 462494612,
 462067373,
 -1,
 462560147,
 462438493,
 92239,
 -1,
 462520720,
 92225,
 -1,
 462500203,
 92233,
 462756759,
 462461048,
 -1,
 -58474,
 462719779,
 92191,
 -1,
 462753578,
 92167,
 462953370,
 462715528,
 -1,
 -58471,
 462897610,
 92237,
 -1,
 462950161,
 92241,
 463149981,
 462899907,
 -1,
 -58468,
 463095001,
 92180,
 -1,
 463146873,
 92227,
 463346592,
 463087083,
 -1,
 -58465,
 463279091,
 92212,
 -1,
 463340148,
 92201,
 463543203,
 463277841,
 -1,
 -58462,
 463498797,
 92245,
 -1,
 463540010,
 92164,
 -58460,
 463489586,
 92231,
 -58459,
 463684435,
 92204,
 -1,
 463744750,
 92244,
 463936445,
 461592084,
 -1,
 464001970,
 463867665,
 -1,
 464067504,
 463940447,
 -1,
 464133037,
 464016916,
 92238,
 -58453,
 464097267,
 92174,
 -58452,
 464145546,
 92203,
 -1,
 464198132,
 92171,
 -58450,
 464092162,
 92230,
 -58449,
 464347223,
 92210,
 -1,
 464407531,
 92186,
 -58447,
 464021728,
 92221,
 -1,
 464543636,
 92175,
 464722871,
 463954021,
 -1,
 464788406,
 464675381,
 -1,
 -58443,
 464743934,
 92198,
 -1,
 464794147,
 92214,
 -1,
 464739164,
 92190,
 465050554,
 464656435,
 -1,
 -58439,
 465006125,
 92246,
 -1,
 465068119,
 92232,
 -58437,
 465014756,
 92176,
 -58436,
 465188963,
 92196,
 -1,
 465252834,
 92197,
 465443789,
 463894562,
 -1,
 465509318,
 465386183,
 -1,
 465574850,
 465471639,
 -1,
 -58431,
 465524244,
 92215,
 -1,
 465579934,
 92165,
 465771461,
 465518685,
 -1,
 -58428,
 465727415,
 92222,
 -1,
 465788008,
 92168,
 -1,
 465724708,
 92224,
 466033610,
 465461349,
 -1,
 -58424,
 465994062,
 92235,
 -58423,
 466054701,
 92220,
 -1,
 466116153,
 92208,
 -58421,
 465997359,
 92181,
 -58420,
 466241517,
 92195,
 -1,
 466301422,
 92177,
 466492382,
 465397969,
 -1,
 466557909,
 466423569,
 -1,
 466623442,
 466489105,
 -1,
 -58415,
 466579383,
 92226,
 -1,
 466638356,
 92236,
 -58413,
 466582266,
 92187,
 -58412,
 466770661,
 92189,
 -1,
 466813556,
 92200,
 467016668,
 466510505,
 -1,
 467082201,
 466970894,
 -1,
 -58408,
 467023984,
 92169,
 -1,
 467081267,
 92170,
 467337215,
 467032283,
 -1,
 -58405,
 467220592,
 92162,
 -1,
 467277875,
 92163,
 -58403,
 466979722,
 92205,
 -1,
 467415403,
 92202,
 467606503,
 466438851,
 -1,
 467672034,
 467544927,
 -1,
 -58399,
 467634851,
 92179,
 -1,
 467697998,
 92211,
 467868645,
 467603217,
 -1,
 -58396,
 467824173,
 92240,
 -1,
 467874634,
 92199,
 -58394,
 467831686,
 92213,
 -1,
 468020374,
 92219,
 468196335,
 467566926,
 -1,
 468261867,
 468158615,
 -1,
 -58390,
 468193473,
 92206,
 -1,
 468255406,
 92172,
 468458478,
 468201897,
 -1,
 -58387,
 468419340,
 92209,
 -1,
 468455604,
 92234,
 -1,
 468404351,
 92166,
 468720629,
 468143351,
 -1,
 468786162,
 468682903,
 92243,
 -1,
 468717761,
 92207,
 -58381,
 468738716,
 92216,
 -58380,
 468857198,
 92184,
 -1,
 468915368,
 92183,
 469113850,
 468662185,
 -1,
 469179385,
 469056916,
 -1,
 -58376,
 469135287,
 92188,
 -1,
 469186874,
 92193,
 -1,
 469113390,
 92161,
 469441533,
 469076119,
 -1,
 -58372,
 469392972,
 92228,
 -1,
 469436436,
 92192,
 -58370,
 469405361,
 92242,
 -58369,
 469595872,
 92218,
 -1,
 469644528,
 92217,
 469834833,
 461510692,
 -1,
 469900308,
 469784084,
 -1,
 469965833,
 469833762,
 -1,
 470031366,
 469896977,
 -1,
 -58363,
 469964031,
 92255,
 -1,
 470024870,
 92252,
 -58361,
 469994374,
 92292,
 -58360,
 470173808,
 92268,
 -1,
 470233606,
 92286,
 470424589,
 469896977,
 92300,
 470548479,
 470352629,
 -1,
 -58356,
 470453462,
 92296,
 -1,
 470495684,
 92295,
 470686736,
 470364966,
 -1,
 -58353,
 470639294,
 92267,
 -1,
 470698461,
 92284,
 470883347,
 470626729,
 -1,
 -58350,
 470843805,
 92290,
 -1,
 470904365,
 92281,
 -1,
 470836290,
 92287,
 471145509,
 469850967,
 -1,
 471211037,
 471087017,
 -1,
 471276571,
 471152553,
 -1,
 471342105,
 471239558,
 92282,
 -1,
 471269997,
 92283,
 -58342,
 471282092,
 92277,
 -1,
 471404399,
 92298,
 -58340,
 471228981,
 92302,
 -1,
 471551001,
 92276,
 471735328,
 471176877,
 -1,
 -58337,
 471679100,
 92269,
 -1,
 471732385,
 92288,
 471931939,
 471693346,
 -1,
 -58334,
 471875584,
 92247,
 -1,
 471936750,
 92299,
 -58332,
 471893108,
 92260,
 -1,
 472066813,
 92261,
 472259629,
 471103522,
 -1,
 472325161,
 472202379,
 -1,
 -58328,
 472287547,
 92266,
 -1,
 472351142,
 92265,
 -58326,
 472287791,
 92285,
 -58325,
 472465866,
 92249,
 -58324,
 472527221,
 92250,
 -1,
 472584714,
 92279,
 472783926,
 472206019,
 -1,
 472849458,
 472723881,
 -1,
 -58320,
 472815519,
 92272,
 -58319,
 472870398,
 92270,
 -1,
 472912029,
 92294,
 473111605,
 472793181,
 -1,
 -58316,
 473067053,
 92301,
 -1,
 473115959,
 92253,
 -1,
 473043658,
 92256,
 473373755,
 472738001,
 -1,
 -58312,
 473336680,
 92289,
 -58311,
 473385069,
 92263,
 -58310,
 473443682,
 92257,
 -1,
 473503307,
 92274,
 473701441,
 473320695,
 -1,
 473766975,
 473632529,
 -1,
 -58306,
 473716256,
 92259,
 -1,
 473764701,
 92273,
 -58304,
 473719373,
 92251,
 -1,
 473903467,
 92297,
 474094662,
 473661774,
 -1,
 474160197,
 474056857,
 -1,
 -58300,
 474111878,
 92264,
 -1,
 474175156,
 92248,
 -1,
 474091375,
 92280,
 474422345,
 474060461,
 -1,
 -58296,
 474362361,
 92254,
 -1,
 474419485,
 92258,
 474618956,
 474364225,
 -1,
 -58293,
 474581292,
 92262,
 -1,
 474635095,
 92271,
 474815567,
 474559413,
 -1,
 -58290,
 474779186,
 92291,
 -1,
 474819423,
 92293,
 -58288,
 474781164,
 92278,
 -1,
 474976238,
 92275,
 475201535,
 469775144,
 -1,
 475208800,
 475093847,
 -1,
 475274325,
 475170967,
 92697,
 -1,
 475205782,
 92696,
 475405400,
 475220469,
 -1,
 -58281,
 475367720,
 92698,
 -1,
 475402397,
 92688,
 475602011,
 475346857,
 -1,
 -58278,
 475548896,
 92711,
 -1,
 475609058,
 92712,
 -58276,
 475568042,
 92681,
 -58275,
 475759288,
 92704,
 -58274,
 475822823,
 92702,
 -58273,
 475873373,
 92708,
 -1,
 475932172,
 92687,
 476126313,
 475166754,
 -1,
 476191845,
 476068551,
 -1,
 -58269,
 476154007,
 92700,
 -58268,
 476209253,
 92713,
 -1,
 476267344,
 92691,
 -58266,
 476155439,
 92690,
 -58265,
 476397661,
 92692,
 -58264,
 476459559,
 92693,
 -1,
 476517088,
 92727,
 476716146,
 476072643,
 -1,
 476781677,
 476654431,
 -1,
 -58260,
 476741966,
 92695,
 -1,
 476797783,
 92710,
 -58258,
 476747596,
 92694,
 -58257,
 476940439,
 92677,
 -58256,
 476997899,
 92726,
 -58255,
 477061221,
 92719,
 -1,
 477105937,
 92675,
 477305979,
 476671820,
 -1,
 477371511,
 477244255,
 -1,
 -58251,
 477335090,
 92709,
 -58250,
 477387607,
 92721,
 -1,
 477440863,
 92679,
 477633658,
 477315165,
 -1,
 -58247,
 477577309,
 92683,
 -1,
 477637922,
 92684,
 -1,
 477595799,
 92707,
 477895810,
 477255188,
 92689,
 477961343,
 477829154,
 -1,
 -58242,
 477900526,
 92720,
 -1,
 477957991,
 92724,
 -58240,
 477913189,
 92723,
 -58239,
 478096681,
 92685,
 -1,
 478154513,
 92722,
 478354567,
 477856078,
 -1,
 478420102,
 478285585,
 -1,
 -58235,
 478358367,
 92680,
 -1,
 478416657,
 92686,
 -1,
 478359915,
 92725,
 478682252,
 478308561,
 -1,
 478747787,
 478620511,
 -1,
 -58230,
 478711346,
 92703,
 -1,
 478751583,
 92706,
 -1,
 478710056,
 92714,
 479009936,
 478629111,
 -1,
 -58226,
 478962973,
 92718,
 -58225,
 479019101,
 92717,
 -1,
 479072017,
 92682,
 479272083,
 478975661,
 -1,
 -58222,
 479225117,
 92699,
 -1,
 479268625,
 92701,
 479468694,
 479236377,
 -1,
 -58219,
 479431215,
 92705,
 -1,
 479465233,
 92716,
 -58217,
 479432976,
 92728,
 -58216,
 479627415,
 92676,
 -58215,
 479671766,
 92715,
 -1,
 479735074,
 92678,
 479927524,
 426279246,
 129415,
 479993057,
 479859168,
 -1,
 480058568,
 479941033,
 -1,
 480124075,
 480016418,
 -1,
 480189609,
 480068525,
 -1,
 -58208,
 480155400,
 7132,
 -58207,
 480219441,
 7116,
 -58206,
 480278686,
 7129,
 -58205,
 480341913,
 7123,
 -58204,
 480405771,
 7112,
 -58203,
 480466526,
 7125,
 -58202,
 480529737,
 7135,
 -58201,
 480590549,
 7107,
 -58200,
 480655330,
 7119,
 -1,
 480710417,
 7105,
 -58198,
 480143315,
 7126,
 -1,
 480841489,
 7128,
 481041585,
 480074583,
 -1,
 -58195,
 481007368,
 7136,
 -58194,
 481060283,
 7127,
 -58193,
 481114082,
 7133,
 -58192,
 481175019,
 7138,
 -1,
 481234705,
 7113,
 481434808,
 480990740,
 -1,
 481500343,
 481365777,
 7124,
 481624063,
 481451123,
 -1,
 -58187,
 481523870,
 7130,
 -58186,
 481582000,
 7114,
 -1,
 481639125,
 7108,
 -1,
 481433651,
 7139,
 481893562,
 481388811,
 7111,
 -1,
 481840258,
 7117,
 -58181,
 481859336,
 7131,
 -58180,
 481988913,
 7115,
 -58179,
 482052247,
 7141,
 -58178,
 482111385,
 7122,
 -58177,
 482168137,
 7134,
 -58176,
 482233169,
 7110,
 -58175,
 482298394,
 7120,
 -58174,
 482361437,
 7140,
 -58173,
 482425557,
 7106,
 -58172,
 482490338,
 7118,
 -58171,
 482551275,
 7121,
 -58170,
 482614611,
 7137,
 -58169,
 482678835,
 7109,
 -1,
 482742033,
 7104,
 482942163,
 480022776,
 -1,
 483007691,
 482904215,
 7150,
 -1,
 482935295,
 7151,
 483138766,
 482954059,
 -1,
 -58163,
 483090533,
 7149,
 -1,
 483147869,
 7147,
 483335376,
 483076959,
 7143,
 -1,
 483273567,
 7145,
 -58159,
 483289419,
 7144,
 -58158,
 483418213,
 7148,
 -1,
 483475549,
 7146,
 483663067,
 482900002,
 -1,
 483728602,
 483629081,
 -1,
 483794136,
 483682513,
 -1,
 -58153,
 483738650,
 7165,
 -1,
 483791912,
 7167,
 -58151,
 483744717,
 7164,
 -1,
 483936957,
 7166,
 -1,
 483672880,
 7142,
 484187358,
 483617126,
 -1,
 -58147,
 484139951,
 7155,
 -1,
 484194839,
 7154,
 484442111,
 484123333,
 -1,
 -58144,
 484334928,
 7152,
 -1,
 484391623,
 7153,
 484580579,
 479935175,
 128704,
 -1,
 484542361,
 128705,
 -1,
 484541191,
 128267,
 484777236,
 479885346,
 -1,
 484842770,
 484735137,
 -1,
 484908297,
 484790697,
 -1,
 484973802,
 484846431,
 92908,
 -58135,
 484925018,
 92880,
 -1,
 484977503,
 92907,
 485170413,
 484939437,
 -1,
 -58132,
 485114300,
 92885,
 -1,
 485174862,
 92900,
 485367023,
 485134641,
 92891,
 -1,
 485303960,
 92902,
 485498097,
 485329047,
 92906,
 -1,
 485463529,
 92896,
 485629171,
 485449829,
 92904,
 -1,
 485580901,
 92905,
 485760246,
 485575363,
 -1,
 -58123,
 485714233,
 92888,
 -1,
 485756689,
 92881,
 485956857,
 485701545,
 -1,
 -58120,
 485891265,
 92893,
 -1,
 485953887,
 92886,
 486153468,
 485893471,
 -1,
 -58117,
 486105189,
 92894,
 -1,
 486161936,
 92887,
 -58115,
 486119722,
 92892,
 -58114,
 486314253,
 92899,
 -58113,
 486376773,
 92897,
 -58112,
 486439291,
 92882,
 -58111,
 486500619,
 92901,
 -58110,
 486561684,
 92884,
 -58109,
 486623923,
 92889,
 -58108,
 486686813,
 92909,
 -58107,
 486752334,
 92890,
 -58106,
 486814538,
 92883,
 -58105,
 486874814,
 92895,
 -58104,
 486938675,
 92898,
 -1,
 487001873,
 92903,
 487202065,
 484844041,
 -1,
 487267597,
 487150821,
 -1,
 -58100,
 487196772,
 92915,
 -1,
 487261531,
 92913,
 487464208,
 487210469,
 -1,
 -58097,
 487393357,
 92916,
 -1,
 487458139,
 92912,
 -1,
 487414008,
 92914,
 -1,
 487143327,
 92917,
 487849983,
 484789215,
 129530,
 -1,
 487725228,
 127936,
 487922980,
 484725715,
 -1,
 487988515,
 487874661,
 -1,
 488054050,
 487948624,
 -1,
 488119585,
 487988110,
 -1,
 488185120,
 488085001,
 -1,
 488250654,
 488118306,
 -1,
 488316189,
 488202747,
 -1,
 -58084,
 488274290,
 128503,
 -1,
 488316813,
 128505,
 -1,
 488247922,
 128499,
 -58081,
 488208754,
 128501,
 -1,
 488526674,
 11197,
 -1,
 488132352,
 128502,
 -1,
 488077682,
 128500,
 -1,
 488006310,
 127880,
 -1,
 487916371,
 129526,
 488971568,
 487857463,
 -1,
 489037102,
 488917699,
 -1,
 489102635,
 488994850,
 -1,
 489168170,
 489049587,
 -1,
 -58071,
 489125470,
 11101,
 -1,
 489185751,
 11099,
 -1,
 489122076,
 983056,
 489488383,
 489029632,
 -1,
 -58067,
 489395175,
 128281,
 -1,
 489447729,
 128386,
 -58065,
 488998512,
 128043,
 -1,
 489579174,
 129363,
 489758008,
 488921943,
 -1,
 489823543,
 489704131,
 127974,
 489947135,
 489774882,
 -1,
 -58060,
 489854860,
 128180,
 -58059,
 489909456,
 128183,
 -58058,
 489959947,
 128182,
 -1,
 490023025,
 128181,
 -1,
 489755464,
 127820,
 490282302,
 489692468,
 128118,
 490405887,
 490209280,
 -1,
 -58053,
 490307871,
 128700,
 -58052,
 490348518,
 128036,
 -58051,
 490413057,
 127868,
 -1,
 490476512,
 128124,
 490675523,
 490237772,
 -1,
 490741058,
 490602496,
 -1,
 -58047,
 490692936,
 129532,
 -1,
 490741630,
 128202,
 -1,
 490674572,
 128136,
 491003207,
 490616745,
 -1,
 -58043,
 490965586,
 129366,
 -58042,
 491010061,
 128708,
 -1,
 491073120,
 129391,
 491323391,
 490939743,
 -1,
 -58039,
 491215320,
 127992,
 -1,
 491272421,
 129441,
 491462128,
 426209100,
 -1,
 491527650,
 491392785,
 -1,
 491593185,
 491470481,
 -1,
 491658641,
 491540905,
 -1,
 491724117,
 491621941,
 -1,
 491789652,
 491675851,
 -1,
 491855186,
 491745100,
 69643,
 -1,
 491810636,
 69644,
 492044287,
 491801847,
 69645,
 -1,
 491932919,
 69646,
 -1,
 491720465,
 69679,
 492182875,
 491684174,
 -1,
 492248409,
 492142926,
 -1,
 -58024,
 492190421,
 69662,
 -1,
 492244753,
 69661,
 -58022,
 492190421,
 69667,
 -1,
 492375825,
 69666,
 492576096,
 492134501,
 69649,
 492699647,
 492523285,
 -1,
 -58018,
 492599164,
 69686,
 -58017,
 492658299,
 69687,
 -1,
 492721188,
 69685,
 492903781,
 492526423,
 -1,
 -58014,
 492869384,
 69660,
 -58013,
 492919728,
 69665,
 -58012,
 492976098,
 69655,
 -1,
 493031185,
 69670,
 493231467,
 492840287,
 -1,
 493297001,
 493167967,
 -1,
 -58008,
 493238997,
 69664,
 -1,
 493293329,
 69663,
 -58006,
 493238997,
 69669,
 -1,
 493424401,
 69668,
 493624687,
 493162257,
 69637,
 -58003,
 493586583,
 69650,
 -58002,
 493633629,
 69648,
 -1,
 493686545,
 69638,
 493886835,
 493582370,
 -1,
 -57999,
 493844638,
 69681,
 -57998,
 493894357,
 69680,
 -1,
 493948689,
 69682,
 494148981,
 493848727,
 69641,
 -1,
 494110871,
 69642,
 494280056,
 494102737,
 -1,
 -57993,
 494222037,
 69672,
 -1,
 494276369,
 69671,
 494476667,
 494226679,
 -1,
 -57990,
 494423369,
 69684,
 -1,
 494472977,
 69678,
 494673278,
 494422723,
 -1,
 -57987,
 494615253,
 69652,
 -1,
 494669585,
 69651,
 494869889,
 494619125,
 -1,
 -57984,
 494811861,
 69659,
 -1,
 494866193,
 69658,
 495066499,
 494813277,
 69639,
 -1,
 495009885,
 69640,
 495197574,
 495007657,
 -1,
 -57979,
 495139541,
 69654,
 -1,
 495193873,
 69653,
 495394185,
 495131959,
 -1,
 -57976,
 495336149,
 69657,
 -1,
 495390481,
 69656,
 495590796,
 495327266,
 -1,
 -57973,
 495532757,
 69674,
 -1,
 495587089,
 69673,
 -57971,
 495556360,
 69676,
 -57970,
 495742873,
 69677,
 -57969,
 495801950,
 69675,
 -57968,
 495860437,
 69683,
 -1,
 495922015,
 69647,
 496115119,
 491610100,
 -1,
 496180634,
 496075086,
 -1,
 496246166,
 496144665,
 -1,
 -57963,
 496197733,
 69715,
 -1,
 496250851,
 69724,
 496442777,
 496188103,
 -1,
 -57960,
 496398786,
 69716,
 -1,
 496453601,
 69725,
 -1,
 496381678,
 69723,
 496704927,
 496138274,
 -1,
 496770461,
 496650621,
 69719,
 -1,
 496732283,
 69728,
 496959487,
 496710198,
 69720,
 -1,
 496863355,
 69729,
 497032614,
 496644902,
 -1,
 497098147,
 496984165,
 -1,
 -57950,
 497061088,
 69717,
 -1,
 497121251,
 69726,
 497352703,
 497041501,
 -1,
 -57947,
 497258093,
 69718,
 -1,
 497301396,
 69727,
 497491370,
 496984836,
 69714,
 497614847,
 497418240,
 -1,
 -57943,
 497517460,
 69733,
 -1,
 497565712,
 69732,
 497753516,
 497442242,
 69722,
 -1,
 497715323,
 69731,
 497884590,
 497692160,
 69721,
 -1,
 497850029,
 69730,
 -1,
 497830582,
 69759,
 498081218,
 496078389,
 -1,
 498146753,
 498034815,
 -1,
 498212278,
 498110590,
 -1,
 498277812,
 498167628,
 69694,
 -1,
 498233164,
 69695,
 498466815,
 498224375,
 69696,
 -1,
 498355447,
 69697,
 498539962,
 498142993,
 -1,
 -57928,
 498501783,
 69701,
 -57927,
 498548829,
 69699,
 -1,
 498601745,
 69688,
 498802108,
 498501783,
 69692,
 -1,
 498763927,
 69693,
 498933182,
 498745437,
 69690,
 -1,
 498876509,
 69691,
 -57921,
 498884709,
 69700,
 -57920,
 499002207,
 69698,
 -1,
 499063295,
 69689,
 -1,
 498091860,
 69702,
 499326419,
 498017631,
 -1,
 499391953,
 499270377,
 -1,
 499457479,
 499351886,
 -1,
 -57914,
 499422422,
 69736,
 -1,
 499466066,
 69737,
 499654090,
 499415074,
 -1,
 -57911,
 499599741,
 69740,
 -1,
 499659318,
 69741,
 499850701,
 499594022,
 -1,
 -57908,
 499803914,
 69738,
 -1,
 499861727,
 69739,
 -57906,
 499816711,
 69734,
 -57905,
 499999492,
 69735,
 -57904,
 500063682,
 69743,
 -1,
 500116992,
 69742,
 -57902,
 499345040,
 69704,
 -1,
 500241339,
 69703,
 500440537,
 499285072,
 -1,
 -57899,
 500404314,
 69634,
 -57898,
 500468784,
 69636,
 -57897,
 500517485,
 69635,
 -57896,
 500571598,
 69632,
 -1,
 500634761,
 69633,
 500891647,
 500395420,
 -1,
 500899293,
 500780279,
 -1,
 -57892,
 500852353,
 69709,
 -1,
 500909293,
 69707,
 501095904,
 500836429,
 -1,
 -57889,
 501057938,
 69706,
 -1,
 501121358,
 69705,
 -1,
 501031905,
 69708,
 -1,
 491537373,
 129504,
 501423592,
 491470941,
 -1,
 501489126,
 501359967,
 -1,
 -57883,
 501430420,
 127753,
 -1,
 501492685,
 128112,
 -57881,
 501427589,
 128188,
 -1,
 501620981,
 129521,
 501816812,
 501375077,
 -1,
 -57878,
 501768757,
 129529,
 -57877,
 501828559,
 128148,
 -1,
 501882552,
 129382,
 502136831,
 501754863,
 -1,
 -57874,
 502038365,
 129329,
 -57873,
 502090474,
 983124,
 -1,
 502146399,
 127838,
 502341237,
 491404037,
 -1,
 502406702,
 502288809,
 -1,
 502472184,
 502369845,
 -1,
 502537719,
 502423755,
 -1,
 502603254,
 502493004,
 72710,
 -1,
 502558540,
 72711,
 -1,
 502549751,
 72712,
 -1,
 502468369,
 72746,
 502865406,
 502432078,
 -1,
 502930940,
 502825294,
 -1,
 -57861,
 502872789,
 72729,
 -1,
 502927121,
 72728,
 -57859,
 502872789,
 72734,
 -1,
 503058193,
 72733,
 503258627,
 502815575,
 -1,
 -57856,
 503224072,
 72727,
 -57855,
 503274416,
 72732,
 -57854,
 503330786,
 72722,
 -1,
 503385873,
 72737,
 503586313,
 503194975,
 -1,
 503651847,
 503522655,
 -1,
 -57850,
 503593685,
 72731,
 -1,
 503648017,
 72730,
 -57848,
 503593685,
 72736,
 -1,
 503779089,
 72735,
 503979533,
 503516945,
 72704,
 -57845,
 503941271,
 72717,
 -57844,
 503988317,
 72715,
 -1,
 504041233,
 72705,
 504241681,
 503937058,
 -1,
 -57841,
 504199326,
 72748,
 -57840,
 504249045,
 72747,
 -1,
 504303377,
 72749,
 504503827,
 504203415,
 72708,
 -1,
 504465559,
 72709,
 504634902,
 504457425,
 -1,
 -57835,
 504576725,
 72739,
 -1,
 504631057,
 72738,
 504831513,
 504580803,
 -1,
 -57832,
 504773333,
 72719,
 -1,
 504827665,
 72718,
 505028124,
 504777205,
 -1,
 -57829,
 504969941,
 72726,
 -1,
 505024273,
 72725,
 505224734,
 504971357,
 72706,
 -1,
 505167965,
 72707,
 505355809,
 505165737,
 -1,
 -57824,
 505297621,
 72721,
 -1,
 505351953,
 72720,
 505552420,
 505290039,
 -1,
 -57821,
 505494229,
 72724,
 -1,
 505548561,
 72723,
 505749031,
 505485346,
 -1,
 -57818,
 505690837,
 72741,
 -1,
 505745169,
 72740,
 -57816,
 505714440,
 72743,
 -57815,
 505900953,
 72744,
 -57814,
 505962597,
 72716,
 -57813,
 506025566,
 72742,
 -57812,
 506088777,
 72745,
 -57811,
 506149589,
 72750,
 -1,
 506211167,
 72714,
 506404424,
 502358004,
 -1,
 506469943,
 506364238,
 -1,
 506535475,
 506433817,
 -1,
 -57806,
 506486885,
 72795,
 -1,
 506540003,
 72804,
 506732086,
 506477255,
 -1,
 -57803,
 506687938,
 72796,
 -1,
 506742753,
 72805,
 -1,
 506670830,
 72803,
 506994236,
 506427426,
 -1,
 507059770,
 506939773,
 72799,
 -1,
 507021435,
 72808,
 507248639,
 506999350,
 72800,
 -1,
 507152507,
 72809,
 507321923,
 506934054,
 -1,
 507387456,
 507273317,
 -1,
 -57793,
 507350240,
 72797,
 -1,
 507410403,
 72806,
 507641855,
 507330653,
 -1,
 -57790,
 507547245,
 72798,
 -1,
 507590548,
 72807,
 507780677,
 507272642,
 72802,
 -1,
 507742331,
 72811,
 507911751,
 507719168,
 72801,
 -1,
 507877037,
 72810,
 -1,
 507863812,
 72794,
 508108375,
 506368248,
 -1,
 508173901,
 508072062,
 -1,
 508239436,
 508129100,
 72756,
 -1,
 508194636,
 72757,
 -1,
 508185847,
 72758,
 508436049,
 508104465,
 -1,
 -57777,
 508397719,
 72763,
 -57776,
 508444765,
 72761,
 -1,
 508497681,
 72751,
 508698195,
 508397719,
 72754,
 -1,
 508659863,
 72755,
 508829269,
 508641373,
 72752,
 -1,
 508772445,
 72753,
 -57770,
 508780645,
 72762,
 -1,
 508898143,
 72760,
 509091432,
 508044639,
 -1,
 509156966,
 509035241,
 -1,
 509222492,
 509116750,
 -1,
 -57765,
 509187286,
 72786,
 -1,
 509230930,
 72787,
 509419103,
 509179938,
 -1,
 -57762,
 509364605,
 72790,
 -1,
 509424182,
 72791,
 509615714,
 509358886,
 -1,
 -57759,
 509568778,
 72788,
 -1,
 509626591,
 72789,
 -57757,
 509581575,
 72784,
 -57756,
 509764356,
 72785,
 -57755,
 509828546,
 72793,
 -1,
 509881856,
 72792,
 -57753,
 509109904,
 72770,
 -1,
 510006203,
 72769,
 510205552,
 509049936,
 -1,
 510271084,
 510169089,
 -1,
 -57749,
 510228802,
 72766,
 -1,
 510292031,
 72767,
 510467695,
 510201617,
 -1,
 -57746,
 510430794,
 72768,
 -1,
 510484541,
 72765,
 -1,
 510401998,
 72764,
 510729843,
 510146624,
 -1,
 -57742,
 510659058,
 72773,
 -1,
 510724438,
 72772,
 -57740,
 510694800,
 72771,
 -1,
 510869528,
 72812,
 511057622,
 502287607,
 -1,
 511123152,
 510988296,
 -1,
 511188611,
 511072245,
 -1,
 511254138,
 511151131,
 9206,
 -1,
 511181120,
 11205,
 511385213,
 511212819,
 -1,
 -57732,
 511333790,
 128927,
 -1,
 511387605,
 128921,
 511581823,
 511341709,
 9205,
 -1,
 511508800,
 11208,
 511712897,
 511529109,
 9204,
 -1,
 511639872,
 11207,
 511901695,
 511650372,
 9207,
 -1,
 511770944,
 11206,
 511975058,
 511122743,
 -1,
 512040593,
 511937914,
 -1,
 512106120,
 512003222,
 -1,
 -57721,
 512062668,
 11179,
 -1,
 512119037,
 11178,
 512302731,
 512062652,
 -1,
 -57718,
 512265379,
 11181,
 -1,
 512305832,
 11183,
 512499342,
 512250094,
 -1,
 -57715,
 512461987,
 11180,
 -1,
 512502440,
 11182,
 512753663,
 512436848,
 -1,
 -57712,
 512652492,
 11177,
 -1,
 512708861,
 11176,
 -1,
 511985504,
 9210,
 512958108,
 511932450,
 -1,
 513023639,
 512913057,
 -1,
 -57707,
 512964074,
 9209,
 -57706,
 513023747,
 11200,
 -1,
 513088800,
 128306,
 513285786,
 512971610,
 -1,
 -57703,
 513244834,
 128909,
 -1,
 513286190,
 128900,
 -57701,
 513232053,
 128369,
 -1,
 513413356,
 9984,
 513613478,
 512913228,
 -1,
 513679013,
 513557086,
 -1,
 513744547,
 513607838,
 -1,
 513810081,
 513681839,
 9193,
 -1,
 513738683,
 9197,
 -57694,
 513771160,
 9199,
 -1,
 513886222,
 128898,
 -57692,
 513708466,
 11166,
 -1,
 513999874,
 128413,
 -1,
 513631707,
 127990,
 514268849,
 513549663,
 -1,
 514334381,
 514222218,
 -1,
 514399915,
 514263198,
 -1,
 -57686,
 514344974,
 128899,
 -1,
 514402735,
 9196,
 -57684,
 514363826,
 11167,
 -1,
 514524162,
 128419,
 514727600,
 514277655,
 -1,
 -57681,
 514679469,
 11230,
 -1,
 514727683,
 11201,
 -1,
 514684683,
 127778,
 514989752,
 514215867,
 -1,
 515055286,
 514918558,
 -1,
 515120821,
 514992559,
 9194,
 -1,
 515049403,
 9198,
 -1,
 515065870,
 128896,
 -57673,
 515019186,
 11164,
 -1,
 515245058,
 128412,
 515448510,
 514952074,
 -1,
 515514044,
 515377310,
 -1,
 -57669,
 515459086,
 128897,
 -1,
 515516847,
 9195,
 -57667,
 515477938,
 11165,
 -1,
 515638274,
 128418,
 515841732,
 515408206,
 -1,
 515907267,
 515786482,
 -1,
 -57663,
 515866274,
 128908,
 -57662,
 515921310,
 128925,
 -1,
 515975125,
 128919,
 -1,
 515860173,
 128383,
 516234951,
 515805099,
 -1,
 -57658,
 516183454,
 128926,
 -1,
 516237269,
 128920,
 516431562,
 516188369,
 -1,
 -57655,
 516394431,
 128392,
 -1,
 516435848,
 127986,
 516628173,
 516373191,
 -1,
 -57652,
 516566036,
 128420,
 -1,
 516625712,
 128426,
 -57650,
 516583208,
 10067,
 -57649,
 516776183,
 11204,
 -1,
 516830671,
 128447,
 517021395,
 511085106,
 -1,
 -57646,
 516963554,
 128153,
 -1,
 517020643,
 128216,
 517275647,
 516972645,
 -1,
 -57643,
 517182127,
 128033,
 -1,
 517242664,
 127804,
 517414654,
 511008869,
 -1,
 517480161,
 517361379,
 -1,
 517545691,
 517444277,
 -1,
 -57638,
 517504674,
 128912,
 -1,
 517546030,
 128902,
 517742302,
 517503010,
 -1,
 -57635,
 517687691,
 128951,
 -1,
 517739203,
 128939,
 -57633,
 517683799,
 128932,
 -57632,
 517879070,
 128945,
 -1,
 517942815,
 128957,
 518135527,
 517434503,
 -1,
 -57629,
 518101313,
 12730,
 -57628,
 518152340,
 12590,
 -57627,
 518217299,
 12591,
 -57626,
 518279831,
 12729,
 -1,
 518338854,
 12728,
 518528750,
 518099225,
 -1,
 518594285,
 518474999,
 -1,
 518659820,
 518520832,
 -1,
 -57621,
 518624316,
 129379,
 -1,
 518676797,
 128335,
 -1,
 518604026,
 127923,
 -1,
 518520869,
 127993,
 518987506,
 518480317,
 128366,
 519053041,
 518936387,
 128278,
 -1,
 518980797,
 128209,
 -1,
 519010338,
 128218,
 519249652,
 518952621,
 128102,
 -1,
 519207030,
 128713,
 519380726,
 519212250,
 128144,
 -1,
 519308070,
 127893,
 519511801,
 519341927,
 -1,
 -57608,
 519463480,
 11211,
 -1,
 519524161,
 127870,
 519708411,
 519460372,
 983258,
 -1,
 519641122,
 128163,
 -57604,
 519673446,
 129354,
 -57603,
 519789713,
 129460,
 -1,
 519836912,
 128023,
 520036122,
 517352287,
 -1,
 520101643,
 519986007,
 -1,
 520167176,
 520042528,
 -1,
 520232708,
 520114601,
 -1,
 -57597,
 520195746,
 2556,
 -1,
 520244226,
 983642,
 520429319,
 520163089,
 -1,
 -57594,
 520379966,
 2432,
 -1,
 520427805,
 2557,
 -1,
 520386824,
 2558,
 520749055,
 520126798,
 -1,
 -57590,
 520642663,
 127857,
 -1,
 520683652,
 11102,
 520888084,
 520032017,
 -1,
 520953615,
 520843084,
 -1,
 -57586,
 520890094,
 129492,
 -1,
 520946126,
 128059,
 521150226,
 520902620,
 -1,
 -57583,
 521086811,
 127901,
 -1,
 521147998,
 127900,
 -57581,
 521110766,
 128147,
 -1,
 521281351,
 127958,
 521477912,
 520834295,
 983055,
 521601023,
 521424119,
 128276,
 -57577,
 521486051,
 128718,
 -1,
 521536952,
 128277,
 -57575,
 521416837,
 127866,
 -1,
 521676127,
 128719,
 521871142,
 519997591,
 -1,
 521936672,
 521828386,
 128652,
 522002207,
 521896270,
 -1,
 -57570,
 521959463,
 128101,
 -1,
 521994830,
 128100,
 -1,
 521929893,
 128655,
 522264354,
 521884675,
 128363,
 -1,
 522192784,
 128364,
 -57565,
 522225541,
 129419,
 -57564,
 522352529,
 127791,
 -57563,
 522404722,
 127959,
 -1,
 522467241,
 128027,
 522657586,
 521814109,
 -1,
 522723114,
 522612556,
 -1,
 -57559,
 522683190,
 127874,
 -1,
 522724703,
 128038,
 522919725,
 522671059,
 -1,
 -57556,
 522862904,
 127921,
 -1,
 522923187,
 129506,
 523116336,
 522855770,
 -1,
 -57553,
 523061329,
 128692,
 -1,
 523119455,
 128690,
 -57551,
 523076218,
 8383,
 -1,
 523258936,
 128089,
 523444021,
 522622637,
 -1,
 -57548,
 523409583,
 983267,
 -1,
 523469448,
 983257,
 -57546,
 523401250,
 983057,
 -1,
 523594502,
 983125,
 523772824,
 426122551,
 -1,
 523837624,
 523733143,
 -1,
 523903144,
 523787517,
 -1,
 523968660,
 523861072,
 -1,
 524033961,
 523914487,
 -1,
 524099486,
 523964177,
 -1,
 524165019,
 524045073,
 -1,
 524230491,
 524094665,
 -1,
 524296013,
 524159468,
 75009,
 524419071,
 524223796,
 -1,
 524427077,
 524322967,
 -1,
 -57533,
 524384234,
 75019,
 -57532,
 524428639,
 75018,
 -1,
 524487154,
 75017,
 524689224,
 524386638,
 -1,
 -57529,
 524626783,
 75016,
 -1,
 524686576,
 75015,
 -57527,
 524635465,
 75014,
 -57526,
 524831917,
 75013,
 -57525,
 524888873,
 75012,
 -57524,
 524949638,
 75011,
 -1,
 525014646,
 75010,
 525213529,
 524225561,
 75021,
 525336575,
 525141300,
 -1,
 525344594,
 525240471,
 -1,
 -57519,
 525301738,
 75030,
 -1,
 525346143,
 75029,
 525541204,
 525288156,
 75024,
 -1,
 525468184,
 75025,
 -57515,
 525499233,
 75028,
 -57514,
 525625754,
 75027,
 -57513,
 525688229,
 75026,
 -57512,
 525744098,
 75023,
 -1,
 525806353,
 75022,
 -57510,
 525142909,
 75020,
 -1,
 525928787,
 75008,
 526131056,
 524159875,
 -1,
 526196582,
 526060419,
 -1,
 526262117,
 526126726,
 74993,
 526385151,
 526189876,
 -1,
 526393186,
 526281078,
 -1,
 -57503,
 526346624,
 74997,
 -1,
 526407153,
 74996,
 -57501,
 526354714,
 74998,
 -57500,
 526533340,
 74995,
 -1,
 526596707,
 74994,
 -1,
 526190934,
 74992,
 526851947,
 526126726,
 -1,
 -57496,
 526781471,
 75006,
 -57495,
 526846666,
 75005,
 -57494,
 526911986,
 75004,
 -1,
 526977222,
 75003,
 527179630,
 526781471,
 -1,
 -57491,
 527109473,
 75000,
 -1,
 527173830,
 74999,
 -57489,
 527109763,
 75002,
 -1,
 527306220,
 75001,
 527507327,
 526059718,
 -1,
 527572852,
 527437319,
 -1,
 -57485,
 527501721,
 74974,
 -1,
 527567046,
 74973,
 527769463,
 527502367,
 -1,
 -57482,
 527698262,
 74970,
 -1,
 527763654,
 74969,
 527966074,
 527698418,
 -1,
 -57479,
 527895583,
 74967,
 -1,
 527960406,
 74966,
 -57477,
 527896330,
 74975,
 -57476,
 528092658,
 74972,
 -57475,
 528158043,
 74971,
 -57474,
 528223085,
 74968,
 -1,
 528288080,
 74965,
 528490379,
 527436274,
 -1,
 528555908,
 528419314,
 -1,
 -57470,
 528485895,
 74982,
 -57469,
 528550943,
 74981,
 -1,
 528615622,
 74980,
 528818055,
 528485577,
 -1,
 -57466,
 528747721,
 74985,
 -1,
 528813087,
 74984,
 529014666,
 528746838,
 -1,
 -57463,
 528944774,
 74979,
 -1,
 529008838,
 74978,
 -1,
 528944000,
 74983,
 529276820,
 528419530,
 -1,
 529342352,
 529206147,
 -1,
 -57458,
 529272327,
 74988,
 -57457,
 529337697,
 74987,
 -1,
 529402570,
 74986,
 529604499,
 529272327,
 -1,
 -57454,
 529533827,
 74990,
 -1,
 529599178,
 74989,
 -1,
 529534719,
 74991,
 529866647,
 529206625,
 -1,
 -57450,
 529796124,
 75032,
 -1,
 529861307,
 75031,
 530063258,
 529795414,
 -1,
 -57447,
 529992726,
 74977,
 -1,
 530058093,
 74976,
 -1,
 529992897,
 75007,
 530382847,
 524105705,
 -1,
 -57443,
 530290989,
 74964,
 -1,
 530332036,
 74632,
 530579455,
 524060941,
 -1,
 530587559,
 530482377,
 -1,
 530653090,
 530540914,
 75036,
 -1,
 530580455,
 75037,
 -57437,
 530612791,
 75038,
 -57436,
 530742255,
 74635,
 -57435,
 530791238,
 75035,
 -57434,
 530854233,
 74634,
 -1,
 530917424,
 75034,
 -57432,
 530545534,
 74633,
 -1,
 531053212,
 75033,
 531242977,
 523969887,
 -1,
 531308499,
 531204247,
 -1,
 531374034,
 531249074,
 -1,
 531439538,
 531320055,
 -1,
 531505073,
 531369745,
 -1,
 531570608,
 531453460,
 74911,
 -1,
 531498300,
 74912,
 -1,
 531516180,
 74910,
 -1,
 531466882,
 74913,
 531832760,
 531385027,
 -1,
 531898295,
 531794071,
 -1,
 531963830,
 531856376,
 74908,
 -1,
 531891162,
 74909,
 -1,
 531918668,
 74907,
 -1,
 531830418,
 74906,
 532225981,
 531773353,
 -1,
 532291516,
 532168797,
 74900,
 -57413,
 532249224,
 74902,
 -1,
 532311953,
 74901,
 -1,
 532221713,
 74899,
 532553665,
 532174356,
 -1,
 -57409,
 532496477,
 74916,
 -57408,
 532558124,
 74915,
 -1,
 532616822,
 74914,
 532815813,
 532483857,
 -1,
 532881348,
 532773512,
 74894,
 -1,
 532807874,
 74895,
 -1,
 532832129,
 74893,
 533077960,
 532772898,
 -1,
 -57401,
 533020782,
 74920,
 -1,
 533085323,
 74919,
 533274571,
 533019335,
 -1,
 -57398,
 533217373,
 74904,
 -1,
 533270289,
 74903,
 533471182,
 533210463,
 -1,
 -57395,
 533433120,
 74897,
 -1,
 533480413,
 74896,
 -57393,
 533424935,
 74918,
 -57392,
 533618085,
 74917,
 -57391,
 533676768,
 74905,
 -1,
 533737687,
 74898,
 -1,
 531306535,
 74614,
 533995482,
 531251293,
 -1,
 534061017,
 533943828,
 -1,
 534126552,
 533988660,
 -1,
 -57385,
 534087883,
 74891,
 -1,
 534135516,
 74890,
 -1,
 534055573,
 74892,
 -1,
 534018725,
 74613,
 534511615,
 533925649,
 -1,
 534519776,
 534394793,
 -1,
 534585311,
 534446080,
 -1,
 -57378,
 534545616,
 74889,
 -1,
 534596669,
 74611,
 -1,
 534514378,
 74612,
 -1,
 534447431,
 74888,
 534913033,
 531183529,
 -1,
 534978560,
 534843153,
 -1,
 535044095,
 534907505,
 -1,
 535109608,
 534994065,
 74948,
 535232511,
 535036883,
 -1,
 -57369,
 535116164,
 74950,
 -1,
 535178204,
 74949,
 535371756,
 535055607,
 -1,
 535437291,
 535302858,
 74944,
 -1,
 535364924,
 74945,
 -1,
 535399039,
 74946,
 535633904,
 535312354,
 74939,
 535756799,
 535588696,
 -1,
 -57361,
 535649425,
 74941,
 -1,
 535701414,
 74940,
 535896053,
 535569759,
 -1,
 535961588,
 535857761,
 -1,
 -57357,
 535907174,
 74937,
 -1,
 535970528,
 74936,
 -1,
 535905189,
 74935,
 536223736,
 535826193,
 -1,
 -57353,
 536181453,
 74618,
 -1,
 536238951,
 74617,
 -57351,
 536189221,
 74952,
 -57350,
 536378288,
 74951,
 -57349,
 536435521,
 74947,
 -57348,
 536497357,
 74943,
 -57347,
 536558296,
 74942,
 -57346,
 536621236,
 74938,
 -1,
 536680599,
 74934,
 -1,
 534976566,
 74953,
 536944643,
 534939799,
 -1,
 -57342,
 536880534,
 74957,
 -1,
 536939140,
 74956,
 537141254,
 536887389,
 -1,
 -57339,
 537098929,
 74955,
 -1,
 537147305,
 74620,
 537395199,
 537078623,
 -1,
 -57336,
 537295841,
 74954,
 -1,
 537332408,
 74619,
 537534496,
 534862679,
 -1,
 537600027,
 537478109,
 74639,
 537665562,
 537536001,
 -1,
 537731087,
 537626775,
 75050,
 -57330,
 537688042,
 75052,
 -1,
 537723898,
 75051,
 537927699,
 537671593,
 -1,
 537993234,
 537870429,
 74642,
 -1,
 537950856,
 75043,
 -1,
 537955001,
 75044,
 -57324,
 537880973,
 75049,
 -57323,
 538138483,
 75048,
 -57322,
 538201525,
 75047,
 -57321,
 538266585,
 75046,
 -57320,
 538328498,
 75045,
 -57319,
 538388480,
 75042,
 -1,
 538450078,
 74641,
 -1,
 537595526,
 74640,
 538714143,
 537561352,
 -1,
 -57315,
 538673890,
 983260,
 -57314,
 538736446,
 74643,
 -1,
 538798094,
 983261,
 -1,
 538644309,
 74638,
 539041844,
 537479962,
 -1,
 539107379,
 538969396,
 -1,
 539172902,
 539068567,
 -1,
 539238437,
 539127628,
 74963,
 -1,
 539167218,
 74631,
 -1,
 539166074,
 74962,
 539435049,
 539113385,
 -1,
 -57304,
 539396617,
 74625,
 -1,
 539445233,
 74624,
 539631660,
 539365137,
 -1,
 -57301,
 539589347,
 74623,
 -1,
 539647873,
 74622,
 -57299,
 539592598,
 74630,
 -57298,
 539786237,
 74629,
 -57297,
 539846923,
 74628,
 -57296,
 539907585,
 74627,
 -57295,
 539970330,
 74961,
 -57294,
 540032437,
 74626,
 -1,
 540089537,
 74960,
 -1,
 539060438,
 74607,
 540352585,
 538979167,
 -1,
 540418116,
 540317954,
 -1,
 540483647,
 540375919,
 -1,
 540549177,
 540432336,
 74930,
 -1,
 540506146,
 74931,
 540680251,
 540495177,
 74928,
 -1,
 540626167,
 74929,
 -57284,
 540639394,
 74932,
 -57283,
 540754656,
 74927,
 -57282,
 540818866,
 74926,
 -1,
 540874358,
 74925,
 541130751,
 540443849,
 -1,
 541139011,
 541030434,
 -1,
 -57278,
 541100183,
 74933,
 -1,
 541146251,
 74616,
 -1,
 541080190,
 74615,
 541401159,
 540346993,
 -1,
 -57274,
 541354354,
 74922,
 -1,
 541412553,
 74921,
 -57272,
 541358801,
 74924,
 -1,
 541553972,
 74923,
 541728861,
 540309538,
 -1,
 541794389,
 541670087,
 -1,
 541859921,
 541731681,
 -1,
 541925456,
 541813750,
 -1,
 -57266,
 541882673,
 75061,
 -57265,
 541940709,
 75060,
 -1,
 541999099,
 75059,
 -1,
 541878347,
 75058,
 542253140,
 541821201,
 -1,
 -57261,
 542190559,
 75063,
 -1,
 542255900,
 75062,
 -1,
 542183256,
 75057,
 542515292,
 541724970,
 -1,
 542580827,
 542475465,
 -1,
 -57256,
 542540343,
 75056,
 -57255,
 542604078,
 75055,
 -57254,
 542655200,
 74646,
 -1,
 542715630,
 75054,
 -1,
 542522027,
 75053,
 -1,
 542458062,
 75064,
 543039593,
 541690007,
 -1,
 543105127,
 542994252,
 -1,
 543170660,
 543066306,
 -1,
 543236195,
 543116535,
 -1,
 -57246,
 543197477,
 75072,
 -1,
 543232484,
 75071,
 -1,
 543172208,
 75070,
 543555583,
 543099380,
 -1,
 -57242,
 543458522,
 75069,
 -1,
 543508131,
 75068,
 -57240,
 543053374,
 74648,
 -1,
 543622519,
 74649,
 543826034,
 542969617,
 -1,
 543891568,
 543758370,
 -1,
 543957103,
 543819060,
 -1,
 544022638,
 543907897,
 74608,
 -1,
 543950019,
 74880,
 -1,
 543980536,
 74881,
 -1,
 543885946,
 74609,
 -57231,
 543840053,
 74610,
 -1,
 544220623,
 74882,
 544415866,
 543774228,
 -1,
 544481400,
 544378275,
 -1,
 544546935,
 544408465,
 -1,
 -57226,
 544492336,
 75041,
 -1,
 544552930,
 75040,
 -1,
 544475979,
 74637,
 -57223,
 544424068,
 75039,
 -1,
 544747847,
 74636,
 544940162,
 544348194,
 -1,
 545005697,
 544870161,
 -1,
 545071232,
 544947268,
 -1,
 -57218,
 545036410,
 74886,
 -57217,
 545086885,
 74885,
 -1,
 545132425,
 74884,
 -1,
 545007037,
 74883,
 -1,
 544966830,
 74887,
 545464456,
 544899406,
 -1,
 545529990,
 545426164,
 -1,
 -57211,
 545489853,
 75067,
 -1,
 545536043,
 75066,
 -57209,
 545472748,
 74647,
 -1,
 545657323,
 75065,
 545857677,
 545429624,
 -1,
 545923212,
 545818775,
 -1,
 -57205,
 545852551,
 75075,
 -1,
 545915834,
 75074,
 -1,
 545853280,
 75073,
 546185361,
 545798855,
 -1,
 -57201,
 546147747,
 74621,
 -57200,
 546193584,
 74959,
 -1,
 546246449,
 74958,
 546504703,
 546138321,
 -1,
 -57197,
 546391882,
 74645,
 -1,
 546451787,
 74644,
 546644135,
 523919403,
 -1,
 546709661,
 546581343,
 -1,
 546775196,
 546655713,
 -1,
 546840730,
 546714406,
 -1,
 -57191,
 546792910,
 74855,
 -1,
 546849272,
 74856,
 -57189,
 546801776,
 74854,
 -1,
 546988894,
 74853,
 -1,
 546718343,
 74861,
 547233952,
 546666530,
 -1,
 -57185,
 547178922,
 74859,
 -1,
 547238482,
 74860,
 547430563,
 547185416,
 -1,
 -57182,
 547385030,
 74851,
 -1,
 547437437,
 74852,
 547627174,
 547369766,
 -1,
 -57179,
 547579764,
 74857,
 -1,
 547637578,
 74858,
 -1,
 547577310,
 74862,
 -1,
 546598362,
 74868,
 547954863,
 523857740,
 -1,
 548020396,
 547909452,
 -1,
 -57173,
 547985074,
 127835,
 -1,
 548024111,
 128177,
 548274175,
 547966199,
 -1,
 -57170,
 548181718,
 10160,
 -1,
 548226484,
 129356,
 548413619,
 547907793,
 -1,
 -57167,
 548356524,
 11232,
 -57166,
 548412796,
 129473,
 -1,
 548472738,
 129380,
 548675766,
 548372274,
 -1,
 -57163,
 548627106,
 128707,
 -1,
 548672812,
 127854,
 -57161,
 548635059,
 129385,
 -1,
 548807886,
 129362,
 549003674,
 523778759,
 -1,
 549069097,
 548940639,
 -1,
 549134627,
 549023564,
 -1,
 549200160,
 549085665,
 -1,
 549265695,
 549158183,
 -1,
 549331151,
 549224782,
 -1,
 549396677,
 549287970,
 -1,
 -57152,
 549359157,
 43960,
 -57151,
 549423255,
 43959,
 -57150,
 549478501,
 43958,
 -57149,
 549535837,
 43957,
 -57148,
 549595999,
 43956,
 -1,
 549654289,
 43955,
 549855436,
 549342455,
 -1,
 -57145,
 549817909,
 43954,
 -57144,
 549882007,
 43953,
 -57143,
 549937253,
 43952,
 -57142,
 549994589,
 43951,
 -57141,
 550054751,
 43950,
 -1,
 550113041,
 43949,
 -57139,
 549797981,
 43944,
 -57138,
 550251359,
 43942,
 -1,
 550309649,
 43940,
 550510806,
 549287970,
 43933,
 -57135,
 550473269,
 43938,
 -57134,
 550537367,
 43937,
 -57133,
 550592613,
 43936,
 -57132,
 550649949,
 43935,
 -57131,
 550710111,
 43934,
 -1,
 550768401,
 43932,
 550969566,
 550460247,
 -1,
 551035097,
 550899473,
 43918,
 -1,
 550976199,
 43920,
 -57126,
 550997557,
 43925,
 -57125,
 551127191,
 43924,
 -57124,
 551182437,
 43923,
 -57123,
 551239773,
 43922,
 -1,
 551299935,
 43921,
 551493862,
 550910663,
 -1,
 -57120,
 551456309,
 43906,
 -57119,
 551520407,
 43905,
 -57118,
 551575653,
 43904,
 -57117,
 551639984,
 43919,
 -57116,
 551698525,
 43903,
 -57115,
 551758687,
 43902,
 -1,
 551816977,
 43901,
 552018158,
 551429471,
 -1,
 -57112,
 551980597,
 43947,
 -57111,
 552044695,
 43946,
 -57110,
 552099941,
 43945,
 -57109,
 552160585,
 43948,
 -57108,
 552222813,
 43943,
 -57107,
 552282975,
 43941,
 -1,
 552341265,
 43939,
 552542453,
 551982765,
 -1,
 -57104,
 552504885,
 5116,
 -57103,
 552568983,
 5115,
 -57102,
 552624229,
 5114,
 -57101,
 552681565,
 5113,
 -57100,
 552741727,
 5112,
 -1,
 552800017,
 43967,
 553001212,
 552505625,
 -1,
 -57097,
 552963637,
 43966,
 -57096,
 553027735,
 43965,
 -57095,
 553082981,
 43964,
 -57094,
 553140317,
 43963,
 -57093,
 553200479,
 43962,
 -1,
 553258769,
 43961,
 553459971,
 552955495,
 -1,
 -57090,
 553422389,
 43931,
 -57089,
 553486487,
 43930,
 -57088,
 553541733,
 43929,
 -57087,
 553599069,
 43928,
 -57086,
 553659231,
 43927,
 -1,
 553717521,
 43926,
 553918730,
 553408020,
 -1,
 -57083,
 553881141,
 5117,
 -57082,
 553945239,
 43917,
 -57081,
 554000485,
 43916,
 -57080,
 554057821,
 43915,
 -57079,
 554117983,
 43914,
 -1,
 554176273,
 43913,
 554377489,
 553864439,
 -1,
 -57076,
 554339893,
 43912,
 -57075,
 554403991,
 43911,
 -57074,
 554459237,
 43910,
 -57073,
 554516573,
 43909,
 -57072,
 554576735,
 43908,
 -1,
 554635025,
 43907,
 554836248,
 554317737,
 -1,
 -57069,
 554798645,
 43900,
 -57068,
 554862743,
 43899,
 -57067,
 554917989,
 43898,
 -57066,
 554975325,
 43897,
 -57065,
 555035487,
 43896,
 -1,
 555093777,
 43894,
 -57063,
 554798645,
 43893,
 -57062,
 555255959,
 43892,
 -57061,
 555311205,
 43891,
 -57060,
 555371290,
 43895,
 -57059,
 555434077,
 43890,
 -57058,
 555494239,
 43889,
 -1,
 555552529,
 43888,
 -1,
 549212648,
 5109,
 555876351,
 549154636,
 -1,
 -57054,
 555783869,
 127800,
 -1,
 555827674,
 127826,
 556015910,
 549071711,
 -1,
 -57051,
 555972994,
 129472,
 -1,
 556037491,
 128227,
 -57049,
 555974617,
 127792,
 -57048,
 556166926,
 127937,
 -1,
 556212543,
 128638,
 556409233,
 548998929,
 -1,
 556474760,
 556354652,
 -1,
 556540254,
 556421545,
 -1,
 556605746,
 556499278,
 -1,
 556671280,
 556564814,
 -1,
 -57041,
 556612322,
 69906,
 -1,
 556666727,
 69905,
 -57039,
 556612322,
 69911,
 -1,
 556797799,
 69910,
 556998967,
 556555095,
 -1,
 -57036,
 556963595,
 69904,
 -57035,
 557013974,
 69909,
 -57034,
 557070309,
 69899,
 -1,
 557125479,
 69914,
 557326653,
 556934495,
 -1,
 557392187,
 557262175,
 -1,
 -57030,
 557333218,
 69908,
 -1,
 557387623,
 69907,
 -57028,
 557333218,
 69913,
 -1,
 557518695,
 69912,
 557719872,
 557291181,
 -1,
 -57025,
 557684491,
 69920,
 -1,
 557715303,
 69921,
 557916483,
 557672657,
 -1,
 -57022,
 557857506,
 69916,
 -1,
 557911911,
 69915,
 558113094,
 557862135,
 -1,
 -57019,
 558054114,
 69956,
 -1,
 558108519,
 69923,
 558309705,
 558058179,
 -1,
 -57016,
 558250722,
 69896,
 -1,
 558305127,
 69895,
 558506316,
 558254581,
 -1,
 -57013,
 558447330,
 69903,
 -1,
 558501735,
 69902,
 558702927,
 558446505,
 -1,
 -57010,
 558643938,
 69898,
 -1,
 558698343,
 69897,
 558899538,
 558636343,
 -1,
 -57007,
 558840546,
 69901,
 -1,
 558894951,
 69900,
 559096149,
 558831650,
 -1,
 -57004,
 559037154,
 69918,
 -1,
 559091559,
 69917,
 -57002,
 559059252,
 69924,
 -57001,
 559253655,
 69893,
 -57000,
 559315113,
 69925,
 -56999,
 559378348,
 69922,
 -56998,
 559437409,
 69919,
 -56997,
 559497309,
 69892,
 -56996,
 559561442,
 69926,
 -56995,
 559623007,
 69894,
 -1,
 559681383,
 69891,
 559882605,
 556502581,
 -1,
 559948140,
 559835263,
 -1,
 560013668,
 559877905,
 69927,
 -56990,
 559974551,
 69935,
 -56989,
 560021597,
 69933,
 -1,
 560074513,
 69957,
 560275814,
 559974551,
 69930,
 -1,
 560236695,
 69931,
 560406888,
 560226405,
 69934,
 -1,
 560349277,
 69936,
 560537962,
 560349277,
 69928,
 -1,
 560480349,
 69929,
 560726015,
 560474975,
 69932,
 -1,
 560611421,
 69958,
 -1,
 559892308,
 69939,
 560865662,
 559818079,
 -1,
 560931196,
 560808681,
 -1,
 560996722,
 560890190,
 -1,
 -56975,
 560960726,
 69944,
 -1,
 561004370,
 69945,
 561193333,
 560953378,
 -1,
 -56972,
 561138045,
 69948,
 -1,
 561197622,
 69949,
 561389944,
 561132326,
 -1,
 -56969,
 561342218,
 69946,
 -1,
 561400031,
 69947,
 -56967,
 561355015,
 69942,
 -56966,
 561537796,
 69943,
 -56965,
 561601986,
 69951,
 -1,
 561655296,
 69950,
 -56963,
 560883344,
 69954,
 -1,
 561779643,
 69953,
 561979780,
 560822306,
 -1,
 562045315,
 561922806,
 -1,
 -56959,
 562008154,
 69890,
 -56958,
 562044366,
 69888,
 -1,
 562107529,
 69889,
 -1,
 561982619,
 69952,
 -56955,
 561934106,
 69955,
 -56954,
 562323589,
 69937,
 -56953,
 562386533,
 69940,
 -1,
 562436009,
 69938,
 562692095,
 556429132,
 -1,
 562700685,
 562594254,
 -1,
 562766220,
 562662597,
 128200,
 -1,
 562692197,
 128185,
 -1,
 562703054,
 128201,
 563019775,
 562630736,
 983058,
 563085311,
 562888704,
 -1,
 -56944,
 562992067,
 983139,
 -1,
 563051121,
 983136,
 563224982,
 556351581,
 -1,
 563290516,
 563171040,
 129490,
 -1,
 563245637,
 128696,
 -56939,
 563244044,
 128063,
 -1,
 563355962,
 128020,
 563552665,
 563175525,
 -1,
 -56936,
 563506544,
 129378,
 -1,
 563552734,
 127851,
 -1,
 563508806,
 127876,
 563815046,
 548954213,
 -1,
 563880505,
 563762708,
 -1,
 563946038,
 563812965,
 -1,
 564011489,
 563885993,
 -1,
 564077008,
 563957151,
 -1,
 564142504,
 564041389,
 -1,
 564208037,
 564079455,
 -1,
 564273572,
 564162380,
 -1,
 -56925,
 564234391,
 122911,
 -1,
 564281437,
 122912,
 -1,
 564232333,
 122885,
 -56922,
 564168855,
 122915,
 -56921,
 564486245,
 122918,
 -1,
 564533033,
 122913,
 564732334,
 564084829,
 122891,
 564797868,
 564684302,
 -1,
 -56917,
 564755881,
 122919,
 -1,
 564795959,
 122921,
 -56915,
 564762892,
 122889,
 -1,
 564944416,
 122890,
 565125556,
 564688930,
 -1,
 565191090,
 565066439,
 -1,
 -56911,
 565150166,
 122907,
 -1,
 565186321,
 122910,
 -56909,
 565139227,
 122916,
 -1,
 565335264,
 122900,
 565518775,
 565090424,
 -1,
 -56906,
 565460618,
 122886,
 -1,
 565522152,
 122888,
 565715386,
 565477710,
 -1,
 -56903,
 565678340,
 122901,
 -1,
 565738498,
 122908,
 565911997,
 565654310,
 -1,
 -56900,
 565868121,
 122903,
 -1,
 565921915,
 122922,
 566108608,
 565847391,
 -1,
 -56897,
 566059206,
 122884,
 -1,
 566119011,
 122892,
 566305219,
 566040610,
 -1,
 -56894,
 566266549,
 122881,
 -1,
 566313472,
 122920,
 -56892,
 566267549,
 122882,
 -56891,
 566463148,
 122902,
 -56890,
 566523475,
 122899,
 -56889,
 566586473,
 122898,
 -56888,
 566649930,
 122897,
 -56887,
 566713348,
 122896,
 -56886,
 566778703,
 122895,
 -56885,
 566842315,
 122894,
 -56884,
 566905652,
 122893,
 -56883,
 566967690,
 122904,
 -56882,
 567032281,
 122883,
 -56881,
 567091216,
 122909,
 -1,
 567154718,
 122880,
 567410687,
 564031584,
 -1,
 567419355,
 567289849,
 -1,
 567484885,
 567378254,
 -1,
 -56876,
 567448790,
 70504,
 -1,
 567492434,
 70505,
 567681496,
 567423782,
 -1,
 -56873,
 567633674,
 70506,
 -1,
 567691487,
 70507,
 -56871,
 567646471,
 70502,
 -56870,
 567835863,
 70508,
 -1,
 567894788,
 70503,
 568131583,
 567366057,
 -1,
 -56867,
 568037377,
 70515,
 -56866,
 568092939,
 70516,
 -56865,
 568155056,
 70514,
 -56864,
 568216346,
 70513,
 -1,
 568266513,
 70512,
 568467961,
 563956983,
 -1,
 568533492,
 568399687,
 -1,
 568599014,
 568494289,
 -1,
 -56859,
 568546072,
 7664,
 -1,
 568600489,
 7668,
 568795625,
 568549516,
 -1,
 -56856,
 568742680,
 7661,
 -1,
 568797097,
 7667,
 568992235,
 568727586,
 7656,
 -1,
 568930683,
 7657,
 569123310,
 568921873,
 -1,
 -56851,
 569071014,
 7655,
 -1,
 569116182,
 7666,
 -56849,
 569086233,
 7665,
 -56848,
 569276766,
 7658,
 -56847,
 569338065,
 7662,
 -56846,
 569396526,
 7660,
 -56845,
 569455398,
 7659,
 -1,
 569520455,
 7663,
 569769983,
 568476157,
 -1,
 569778680,
 569644921,
 -1,
 -56841,
 569734016,
 65064,
 -1,
 569790427,
 65063,
 -1,
 569720796,
 6841,
 570040843,
 568401207,
 -1,
 570106378,
 570005612,
 -1,
 570171911,
 570053033,
 -1,
 570237439,
 570136237,
 -1,
 -56834,
 570179677,
 42614,
 -1,
 570241320,
 42617,
 570434049,
 570198167,
 42615,
 -1,
 570379407,
 42612,
 570565123,
 570376285,
 42613,
 -1,
 570517042,
 42655,
 -56828,
 570523111,
 42618,
 -56827,
 570647170,
 42619,
 -56826,
 570702937,
 42616,
 -1,
 570764664,
 42654,
 571015167,
 570131759,
 -1,
 -56823,
 570913653,
 65071,
 -1,
 570970065,
 65070,
 -1,
 570057697,
 65069,
 571220503,
 569976159,
 -1,
 571286037,
 571170917,
 -1,
 571351571,
 571246989,
 -1,
 571417106,
 571277312,
 -1,
 -56816,
 571369960,
 6844,
 -56815,
 571434211,
 6840,
 -1,
 571492027,
 7676,
 -1,
 571352429,
 6832,
 -56812,
 571315380,
 6835,
 -1,
 571703635,
 7672,
 -56810,
 571228403,
 6833,
 -1,
 571813527,
 7675,
 572006943,
 571170917,
 -1,
 572072478,
 571952878,
 -1,
 -56806,
 572037362,
 66424,
 -56805,
 572095641,
 66426,
 -56804,
 572153099,
 66425,
 -56803,
 572205149,
 66423,
 -1,
 572265262,
 66422,
 -1,
 572025474,
 6839,
 572531236,
 571965774,
 -1,
 572596771,
 572474220,
 -1,
 -56798,
 572552064,
 65066,
 -1,
 572608475,
 65065,
 -1,
 572552662,
 6836,
 572858920,
 572484059,
 -1,
 -56794,
 572811348,
 6846,
 -56793,
 572856684,
 6845,
 -1,
 572919751,
 6843,
 573121067,
 572822337,
 -1,
 -56790,
 573061379,
 6838,
 -1,
 573122227,
 7673,
 573317678,
 573068936,
 -1,
 -56787,
 573272960,
 65068,
 -1,
 573329371,
 65067,
 573514289,
 573262758,
 -1,
 -56784,
 573469515,
 7670,
 -1,
 573525947,
 7671,
 -56782,
 573478427,
 6837,
 -56781,
 573672461,
 7669,
 -56780,
 573734985,
 6842,
 -56779,
 573785329,
 6834,
 -1,
 573839961,
 70459,
 574095359,
 563898577,
 -1,
 -56776,
 573993614,
 128476,
 -1,
 574035619,
 129517,
 574235243,
 563833041,
 -1,
 574300778,
 574194776,
 -1,
 574366312,
 574238742,
 -1,
 574431834,
 574316532,
 -1,
 574497349,
 574390606,
 -1,
 574562881,
 574460185,
 -1,
 -56768,
 574513261,
 66292,
 -1,
 574566371,
 66283,
 574759492,
 574503623,
 -1,
 -56765,
 574714310,
 66293,
 -1,
 574769121,
 66284,
 -1,
 574697198,
 66282,
 575021644,
 574453794,
 -1,
 575087177,
 574966141,
 -1,
 -56760,
 575047803,
 66287,
 -1,
 575078958,
 66296,
 575340543,
 575025718,
 -1,
 -56757,
 575244411,
 66288,
 -1,
 575275566,
 66297,
 575480403,
 574960422,
 -1,
 575545936,
 575430757,
 -1,
 -56753,
 575507687,
 66294,
 -1,
 575567843,
 66285,
 575799295,
 575488093,
 -1,
 -56750,
 575704692,
 66295,
 -1,
 575747988,
 66286,
 575939158,
 575430082,
 -1,
 -56747,
 575899771,
 66290,
 -1,
 575930926,
 66299,
 576135769,
 575876608,
 -1,
 -56744,
 576100013,
 66289,
 -1,
 576127534,
 66298,
 -1,
 576086806,
 66291,
 576397927,
 574367737,
 -1,
 576463454,
 576356686,
 -1,
 -56739,
 576427222,
 66274,
 -1,
 576470866,
 66275,
 576660065,
 576419874,
 -1,
 -56736,
 576604541,
 66278,
 -1,
 576664118,
 66279,
 576856676,
 576598822,
 -1,
 -56733,
 576808714,
 66276,
 -1,
 576866527,
 66277,
 -56731,
 576807684,
 66273,
 -56730,
 577002946,
 66281,
 -1,
 577056256,
 66280,
 -1,
 576357287,
 66272,
 -56727,
 574324021,
 11507,
 -1,
 577248774,
 11506,
 -1,
 574265332,
 127279,
 577512055,
 574184279,
 -1,
 577577584,
 577450790,
 -1,
 -56722,
 577539481,
 128533,
 -56721,
 577595124,
 128534,
 -1,
 577647007,
 127882,
 577839731,
 577537869,
 -1,
 -56718,
 577796682,
 983186,
 -1,
 577850471,
 127899,
 578036342,
 577798274,
 -1,
 -56715,
 578000292,
 128119,
 -1,
 578059339,
 128679,
 -1,
 577998563,
 127978,
 578298492,
 577462717,
 -1,
 578364027,
 578240605,
 -1,
 -56710,
 578313552,
 127859,
 -1,
 578366303,
 127850,
 -1,
 578301156,
 127834,
 578626174,
 578261273,
 128004,
 -1,
 578552270,
 128046,
 578757249,
 578586775,
 -1,
 -56704,
 578710453,
 128145,
 -1,
 578756400,
 128715,
 578953860,
 578690359,
 -1,
 -56701,
 578905166,
 129381,
 -1,
 578964635,
 127864,
 -56699,
 578901009,
 128165,
 -1,
 579081935,
 129509,
 579281652,
 563744529,
 -1,
 579347155,
 579242475,
 -1,
 579412690,
 579293609,
 -1,
 579478165,
 579345719,
 -1,
 579543695,
 579418823,
 -1,
 579609229,
 579473169,
 66873,
 -1,
 579567950,
 66902,
 -56690,
 579561632,
 66889,
 -1,
 579682397,
 66890,
 579871378,
 579507976,
 -1,
 -56687,
 579835565,
 66891,
 -1,
 579899673,
 66911,
 580124671,
 579800849,
 -1,
 -56684,
 580032587,
 66912,
 -1,
 580087628,
 66882,
 580264603,
 579434530,
 -1,
 580330138,
 580205255,
 -1,
 580395673,
 580259601,
 66877,
 -1,
 580340419,
 66896,
 -1,
 580348064,
 66909,
 -1,
 580268823,
 66906,
 580657825,
 580199775,
 -1,
 580723359,
 580622456,
 -1,
 -56674,
 580687685,
 66895,
 -1,
 580720634,
 66901,
 -56672,
 580687639,
 66881,
 -1,
 580851407,
 66867,
 581051046,
 580622456,
 -1,
 581116581,
 580991687,
 -1,
 -56668,
 581059415,
 66871,
 -1,
 581111569,
 66875,
 -1,
 581047653,
 66869,
 581378730,
 581009742,
 -1,
 -56664,
 581343045,
 66899,
 -56663,
 581388665,
 66908,
 -1,
 581441109,
 66872,
 581640878,
 581320797,
 -1,
 -56660,
 581604494,
 66910,
 -56659,
 581660861,
 66876,
 -1,
 581722195,
 66879,
 581903025,
 581605037,
 -1,
 -56656,
 581855355,
 66874,
 -1,
 581900294,
 66913,
 582099636,
 581856815,
 -1,
 -56653,
 582063789,
 66887,
 -1,
 582119244,
 66893,
 582296247,
 582052049,
 -1,
 -56650,
 582240633,
 66914,
 -1,
 582299374,
 66903,
 582492858,
 582241527,
 -1,
 -56647,
 582457328,
 66885,
 -1,
 582488878,
 66878,
 582689469,
 582437571,
 -1,
 -56644,
 582633846,
 66915,
 -1,
 582685936,
 66884,
 582886080,
 582633973,
 -1,
 -56641,
 582827854,
 66883,
 -1,
 582883354,
 66897,
 583082691,
 582825897,
 -1,
 -56638,
 583025570,
 66866,
 -1,
 583089569,
 66904,
 583279302,
 583019359,
 -1,
 -56635,
 583243851,
 66870,
 -1,
 583276578,
 66868,
 583475913,
 583208721,
 -1,
 -56632,
 583427383,
 66888,
 -1,
 583488945,
 66864,
 -56630,
 583439933,
 66880,
 -56629,
 583634936,
 66907,
 -56628,
 583692392,
 66905,
 -56627,
 583754406,
 66898,
 -56626,
 583819060,
 66894,
 -56625,
 583882545,
 66892,
 -56624,
 583941542,
 66886,
 -56623,
 584004489,
 66900,
 -1,
 584063389,
 66865,
 -1,
 579346663,
 66927,
 584327900,
 579296087,
 983098,
 584393431,
 584261360,
 983097,
 -56618,
 584339125,
 128473,
 -1,
 584384841,
 983170,
 584590042,
 584328543,
 -1,
 -56615,
 584554157,
 127852,
 -1,
 584601380,
 128367,
 -56613,
 584540458,
 128758,
 -1,
 584735943,
 129387,
 584917734,
 584281932,
 -1,
 584983265,
 584852833,
 -1,
 585048800,
 584926291,
 128199,
 -1,
 584974740,
 128450,
 -1,
 584987688,
 128451,
 585245412,
 584937292,
 -1,
 -56605,
 585197039,
 129365,
 -1,
 585253121,
 983073,
 -56603,
 585197800,
 127887,
 -1,
 585394063,
 127904,
 585573099,
 584876366,
 128008,
 585695231,
 585499086,
 128049,
 585760767,
 585565572,
 -1,
 -56598,
 585668063,
 128572,
 -1,
 585728669,
 128569,
 585900783,
 585520660,
 -1,
 585966318,
 585838742,
 128247,
 -1,
 585893519,
 128248,
 -1,
 585919289,
 127957,
 586162930,
 585846007,
 -1,
 -56591,
 586108153,
 129305,
 -1,
 586166118,
 128197,
 -56589,
 586115928,
 11839,
 -1,
 586294459,
 127797,
 586490688,
 579226871,
 -1,
 586556213,
 586440805,
 -1,
 586621736,
 586490101,
 -1,
 586687265,
 586547668,
 -1,
 586752774,
 586645838,
 -1,
 586818304,
 586715417,
 -1,
 586883837,
 586768485,
 -1,
 -56580,
 586811582,
 128349,
 -1,
 586875660,
 128337,
 587137023,
 586821308,
 -1,
 -56577,
 587008190,
 128359,
 -1,
 587072268,
 128347,
 587277059,
 586760018,
 -1,
 -56574,
 587204798,
 128350,
 -1,
 587268876,
 128338,
 587530239,
 587214574,
 -1,
 -56571,
 587401406,
 128357,
 -1,
 587465484,
 128345,
 587670285,
 586709026,
 -1,
 587735818,
 587614589,
 -1,
 -56567,
 587663550,
 128353,
 -1,
 587727628,
 128341,
 587988991,
 587674166,
 -1,
 -56564,
 587860158,
 128354,
 -1,
 587924236,
 128342,
 588129044,
 587608870,
 -1,
 588194577,
 588080906,
 -1,
 -56560,
 588122302,
 128351,
 -1,
 588186380,
 128339,
 588447743,
 588138719,
 -1,
 -56557,
 588318910,
 128352,
 -1,
 588382988,
 128340,
 588587803,
 588065631,
 -1,
 588653336,
 588534353,
 -1,
 -56553,
 588581054,
 128358,
 -1,
 588645132,
 128346,
 588906495,
 588595806,
 -1,
 -56550,
 588777662,
 128355,
 -1,
 588841740,
 128343,
 589046558,
 588538628,
 -1,
 -56547,
 588974270,
 128348,
 -1,
 589038348,
 128336,
 589299711,
 588996034,
 -1,
 -56544,
 589170878,
 128356,
 -1,
 589234956,
 128344,
 589496319,
 586650508,
 -1,
 589505318,
 589394763,
 -1,
 589570853,
 589468043,
 128257,
 -1,
 589497810,
 128258,
 -1,
 589496368,
 128472,
 -56537,
 589465313,
 11118,
 -1,
 589703807,
 128259,
 589898543,
 586578348,
 -1,
 589964076,
 589846206,
 -1,
 -56533,
 589918189,
 128235,
 -1,
 589976977,
 128234,
 -56531,
 589925137,
 127746,
 -56530,
 590107733,
 128272,
 -1,
 590158819,
 128213,
 590357300,
 589859340,
 -1,
 -56527,
 590316995,
 127786,
 -56526,
 590380514,
 127784,
 -56525,
 590442472,
 127783,
 -1,
 590500713,
 127785,
 -1,
 590320785,
 129313,
 590750523,
 586485521,
 -1,
 590816057,
 590703848,
 -1,
 -56520,
 590759189,
 128079,
 -1,
 590819452,
 127916,
 -56518,
 590774033,
 127963,
 -1,
 590961387,
 128385,
 591200255,
 590692445,
 -1,
 591209279,
 591093317,
 -1,
 -56514,
 591149537,
 129346,
 -1,
 591206727,
 127867,
 -1,
 591161925,
 128203,
 591471461,
 586454701,
 -1,
 591536996,
 591426847,
 -1,
 591602521,
 591494439,
 -1,
 591668041,
 591561038,
 -1,
 591733576,
 591598189,
 -1,
 -56506,
 591697720,
 7303,
 -56505,
 591757957,
 7300,
 -1,
 591805529,
 7302,
 -1,
 591675332,
 7301,
 592061261,
 591603039,
 -1,
 -56501,
 592025928,
 1323,
 -56500,
 592078492,
 42649,
 -1,
 592125833,
 1325,
 592323408,
 592015180,
 -1,
 -56497,
 592275200,
 7296,
 -1,
 592327314,
 42593,
 592520019,
 592259935,
 -1,
 -56494,
 592468865,
 1321,
 -1,
 592530717,
 1327,
 -56492,
 592483145,
 7299,
 -56491,
 592677675,
 7304,
 -56490,
 592739216,
 1319,
 -56489,
 592796654,
 7298,
 -56488,
 592860316,
 7297,
 -1,
 592913510,
 42651,
 593166335,
 591535606,
 -1,
 593175390,
 593044831,
 -1,
 -56484,
 593140040,
 1322,
 -56483,
 593192604,
 42648,
 -1,
 593239945,
 1324,
 593437537,
 593111903,
 -1,
 -56480,
 593386369,
 1320,
 -1,
 593448221,
 1326,
 -56478,
 593394576,
 1318,
 -56477,
 593588941,
 42592,
 -1,
 593634406,
 42650,
 -1,
 591470973,
 127744,
 593896315,
 591425356,
 983074,
 593961840,
 593846373,
 -1,
 594027373,
 593919683,
 -1,
 594092908,
 593952768,
 -1,
 594158443,
 594046080,
 128322,
 -1,
 594085546,
 128321,
 -1,
 594106179,
 10060,
 -1,
 594029762,
 127884,
 -56466,
 593990798,
 128081,
 -56465,
 594364475,
 129360,
 -1,
 594420174,
 128010,
 594617205,
 593925805,
 -1,
 594682740,
 594560254,
 -1,
 -56461,
 594621261,
 128546,
 -1,
 594681440,
 128575,
 -1,
 594640744,
 128302,
 594944887,
 594559355,
 129431,
 -1,
 594870475,
 127951,
 595075962,
 594881375,
 -1,
 -56455,
 595032403,
 127769,
 -1,
 595077173,
 128179,
 -1,
 595005318,
 129408,
 595338129,
 593838173,
 -1,
 595403662,
 595292352,
 -1,
 595469197,
 595349408,
 -1,
 595534724,
 595403830,
 -1,
 595600259,
 595473918,
 129282,
 595722239,
 595527044,
 -1,
 -56446,
 595626050,
 129281,
 -1,
 595670620,
 129280,
 -1,
 595553408,
 128320,
 595927945,
 595476573,
 -1,
 595993480,
 595863319,
 -1,
 -56441,
 595929921,
 127568,
 -1,
 595992237,
 127569,
 -1,
 595942718,
 128712,
 -56438,
 595891698,
 11198,
 -56437,
 596215420,
 128981,
 -56436,
 596278946,
 128983,
 -1,
 596319196,
 11199,
 -1,
 595430788,
 127914,
 596583312,
 595363978,
 127961,
 -1,
 596508857,
 127750,
 -1,
 596532486,
 127910,
 596779924,
 595282558,
 -1,
 -56429,
 596718374,
 64047,
 -1,
 596781919,
 64046,
 -56427,
 596737026,
 983187,
 -56426,
 596916694,
 983200,
 -56425,
 596979376,
 128328,
 -1,
 597040941,
 983171,
 597239531,
 523717879,
 -1,
 597304655,
 597180509,
 -1,
 597370160,
 597252951,
 -1,
 597435693,
 597306207,
 -1,
 597501225,
 597366003,
 -1,
 597566461,
 597432354,
 -1,
 597631982,
 597493958,
 -1,
 597697454,
 597559794,
 -1,
 597762979,
 597625330,
 67090,
 -56414,
 597710356,
 67092,
 -1,
 597766950,
 67091,
 597959590,
 597690710,
 67087,
 -56411,
 597906964,
 67089,
 -1,
 597963558,
 67088,
 598156200,
 597887690,
 67093,
 -1,
 598103572,
 67094,
 -56407,
 598085254,
 67100,
 -56406,
 598216199,
 67098,
 -56405,
 598281569,
 67097,
 -56404,
 598346953,
 67096,
 -56403,
 598412163,
 67095,
 -1,
 598476998,
 67086,
 598680504,
 597625887,
 -1,
 -56400,
 598609542,
 67123,
 -56399,
 598674951,
 67122,
 -56398,
 598740321,
 67121,
 -56397,
 598805705,
 67120,
 -56396,
 598871071,
 67119,
 -56395,
 598936451,
 67118,
 -56394,
 599001802,
 67117,
 -56393,
 599066966,
 67116,
 -1,
 599132358,
 67115,
 599335874,
 598608070,
 -1,
 -56390,
 599264902,
 67080,
 -56389,
 599330311,
 67079,
 -56388,
 599395681,
 67078,
 -56387,
 599461065,
 67077,
 -56386,
 599526431,
 67076,
 -56385,
 599591811,
 67075,
 -56384,
 599657162,
 67074,
 -56383,
 599722482,
 67073,
 -1,
 599787862,
 67072,
 599991243,
 599264131,
 -1,
 -56380,
 599920262,
 67114,
 -56379,
 599985671,
 67113,
 -56378,
 600051041,
 67112,
 -56377,
 600116425,
 67111,
 -56376,
 600181791,
 67110,
 -56375,
 600247171,
 67109,
 -56374,
 600312150,
 67108,
 -1,
 600377542,
 67107,
 600581075,
 599919969,
 -1,
 -56371,
 600510086,
 67136,
 -56370,
 600575495,
 67135,
 -56369,
 600640865,
 67134,
 -56368,
 600706249,
 67133,
 -56367,
 600771459,
 67132,
 -56366,
 600836810,
 67131,
 -1,
 600901830,
 67130,
 601105370,
 600509959,
 -1,
 -56363,
 601034081,
 67142,
 -56362,
 601099465,
 67141,
 -56361,
 601164831,
 67140,
 -56360,
 601229810,
 67139,
 -56359,
 601295190,
 67138,
 -1,
 601360582,
 67137,
 601564129,
 601033929,
 -1,
 -56356,
 601493126,
 67129,
 -56355,
 601558369,
 67128,
 -56354,
 601623753,
 67127,
 -56353,
 601689119,
 67126,
 -56352,
 601753942,
 67125,
 -1,
 601819334,
 67124,
 602022888,
 601492170,
 -1,
 -56349,
 601951878,
 67106,
 -56348,
 602017287,
 67105,
 -56347,
 602082657,
 67104,
 -56346,
 602147715,
 67103,
 -56345,
 602212694,
 67102,
 -1,
 602278086,
 67101,
 602537983,
 601950550,
 -1,
 -56342,
 602410337,
 67085,
 -56341,
 602475721,
 67084,
 -56340,
 602540746,
 67083,
 -56339,
 602605910,
 67082,
 -1,
 602671302,
 67081,
 602931199,
 597559638,
 -1,
 602940403,
 602802674,
 -1,
 -56335,
 602868426,
 67148,
 -56334,
 602933746,
 67147,
 -1,
 602998982,
 67145,
 603202550,
 602869255,
 -1,
 -56331,
 603131399,
 67155,
 -1,
 603195590,
 67154,
 603399161,
 603130736,
 -1,
 -56328,
 603330594,
 67150,
 -1,
 603393809,
 67149,
 -56326,
 603328258,
 67156,
 -56325,
 603524591,
 67153,
 -56324,
 603589982,
 67152,
 -1,
 603654639,
 67144,
 603858008,
 597494815,
 -1,
 603923465,
 603786759,
 -1,
 -56320,
 603852422,
 67324,
 -56319,
 603917831,
 67323,
 -56318,
 603983201,
 67322,
 -56317,
 604048585,
 67321,
 -56316,
 604113951,
 67320,
 -56315,
 604179331,
 67319,
 -56314,
 604244682,
 67318,
 -56313,
 604310002,
 67317,
 -56312,
 604375382,
 67316,
 -1,
 604440774,
 67315,
 604644372,
 603852129,
 -1,
 -56309,
 604573318,
 67314,
 -56308,
 604638727,
 67313,
 -56307,
 604704097,
 67312,
 -56306,
 604769481,
 67311,
 -56305,
 604834847,
 67310,
 -56304,
 604900227,
 67309,
 -56303,
 604965578,
 67308,
 -56302,
 605030898,
 67307,
 -56301,
 605096278,
 67306,
 -1,
 605161670,
 67305,
 605365278,
 604572703,
 -1,
 -56298,
 605294214,
 67298,
 -56297,
 605359457,
 67297,
 -56296,
 605424841,
 67296,
 -56295,
 605490207,
 67295,
 -56294,
 605555587,
 67294,
 -56293,
 605620938,
 67293,
 -56292,
 605686258,
 67292,
 -56291,
 605751638,
 67291,
 -1,
 605817030,
 67290,
 606020648,
 605293258,
 -1,
 -56288,
 605949574,
 67282,
 -56287,
 606014983,
 67281,
 -56286,
 606080353,
 67280,
 -56285,
 606145737,
 67279,
 -56284,
 606211103,
 67278,
 -56283,
 606276483,
 67277,
 -56282,
 606341618,
 67276,
 -56281,
 606406998,
 67275,
 -1,
 606472390,
 67274,
 606676018,
 605948402,
 -1,
 -56278,
 606604934,
 67273,
 -56277,
 606670343,
 67272,
 -56276,
 606735713,
 67271,
 -56275,
 606801097,
 67270,
 -56274,
 606866463,
 67269,
 -56273,
 606931843,
 67268,
 -56272,
 606997194,
 67267,
 -56271,
 607062358,
 67266,
 -1,
 607127750,
 67265,
 607331387,
 606603462,
 -1,
 -56268,
 607260294,
 67258,
 -56267,
 607325703,
 67257,
 -56266,
 607390921,
 67256,
 -56265,
 607456287,
 67255,
 -56264,
 607521667,
 67254,
 -56263,
 607587018,
 67253,
 -56262,
 607652338,
 67252,
 -1,
 607717718,
 67251,
 607921219,
 607259523,
 -1,
 -56259,
 607850118,
 67289,
 -56258,
 607915527,
 67288,
 -56257,
 607980897,
 67287,
 -56256,
 608046111,
 67286,
 -56255,
 608111090,
 67285,
 -56254,
 608176470,
 67284,
 -1,
 608241862,
 67283,
 608445514,
 607850118,
 -1,
 -56251,
 608374279,
 67330,
 -56250,
 608439497,
 67329,
 -56249,
 608504863,
 67328,
 -56248,
 608570243,
 67327,
 -56247,
 608635378,
 67326,
 -1,
 608700758,
 67325,
 608904273,
 608373961,
 -1,
 -56244,
 608833158,
 67304,
 -56243,
 608898567,
 67303,
 -56242,
 608963785,
 67302,
 -56241,
 609029151,
 67301,
 -56240,
 609094531,
 67300,
 -1,
 609159882,
 67299,
 609419263,
 608831830,
 -1,
 -56237,
 609291465,
 67264,
 -56236,
 609356831,
 67263,
 -56235,
 609422026,
 67262,
 -56234,
 609487346,
 67261,
 -56233,
 609552726,
 67260,
 -1,
 609618118,
 67259,
 609821870,
 603785930,
 -1,
 609887335,
 609749334,
 -1,
 609952862,
 609815242,
 -1,
 -56228,
 609885495,
 67173,
 -56227,
 609949730,
 67172,
 -1,
 610012945,
 67171,
 -56225,
 609881734,
 67179,
 -56224,
 610143751,
 67178,
 -56223,
 610209121,
 67177,
 -56222,
 610274505,
 67176,
 -56221,
 610339871,
 67175,
 -56220,
 610405251,
 67174,
 -56219,
 610470386,
 67170,
 -56218,
 610535766,
 67169,
 -1,
 610601158,
 67168,
 610804852,
 609814726,
 -1,
 610870380,
 610733702,
 -1,
 -56214,
 610802999,
 67167,
 -56213,
 610867234,
 67166,
 -1,
 610930449,
 67165,
 -56211,
 610799111,
 67164,
 -56210,
 611061089,
 67163,
 -56209,
 611126473,
 67162,
 -56208,
 611191839,
 67161,
 -56207,
 611257219,
 67160,
 -56206,
 611322570,
 67159,
 -56205,
 611387890,
 67158,
 -1,
 611453270,
 67157,
 611656831,
 610733257,
 -1,
 -56202,
 611585670,
 67229,
 -56201,
 611651079,
 67228,
 -56200,
 611716449,
 67227,
 -56199,
 611781833,
 67226,
 -56198,
 611847199,
 67225,
 -56197,
 611912579,
 67224,
 -56196,
 611977930,
 67223,
 -56195,
 612043250,
 67222,
 -56194,
 612108630,
 67221,
 -1,
 612174022,
 67220,
 612377738,
 611585055,
 -1,
 -56191,
 612306566,
 67219,
 -56190,
 612371975,
 67218,
 -56189,
 612437345,
 67217,
 -56188,
 612502729,
 67216,
 -56187,
 612568095,
 67215,
 -56186,
 612633475,
 67214,
 -56185,
 612698826,
 67213,
 -56184,
 612764146,
 67212,
 -56183,
 612829526,
 67211,
 -1,
 612894918,
 67210,
 613098645,
 612305795,
 -1,
 -56180,
 613027462,
 67209,
 -56179,
 613092871,
 67208,
 -56178,
 613158241,
 67207,
 -56177,
 613223625,
 67206,
 -56176,
 613288991,
 67205,
 -56175,
 613354371,
 67204,
 -56174,
 613419722,
 67203,
 -56173,
 613485042,
 67202,
 -56172,
 613550422,
 67201,
 -1,
 613615814,
 67200,
 613819552,
 613026506,
 -1,
 -56169,
 613748358,
 67199,
 -56168,
 613813767,
 67198,
 -56167,
 613879137,
 67197,
 -56166,
 613944521,
 67196,
 -56165,
 614009887,
 67195,
 -56164,
 614075267,
 67194,
 -56163,
 614140618,
 67193,
 -56162,
 614205938,
 67192,
 -56161,
 614271318,
 67191,
 -1,
 614336710,
 67190,
 614540459,
 613747186,
 -1,
 -56158,
 614469254,
 67189,
 -56157,
 614534663,
 67188,
 -56156,
 614600033,
 67187,
 -56155,
 614665417,
 67186,
 -56154,
 614730783,
 67185,
 -56153,
 614796163,
 67184,
 -56152,
 614861514,
 67183,
 -56151,
 614926834,
 67182,
 -56150,
 614992214,
 67181,
 -1,
 615057606,
 67180,
 615317503,
 614468961,
 -1,
 -56147,
 615188822,
 67231,
 -1,
 615254214,
 67230,
 615458026,
 609750217,
 -1,
 615523514,
 615385430,
 -1,
 -56143,
 615452294,
 67348,
 -56142,
 615517703,
 67347,
 -56141,
 615583073,
 67346,
 -56140,
 615648457,
 67345,
 -56139,
 615713823,
 67344,
 -56138,
 615779203,
 67343,
 -56137,
 615844554,
 67342,
 -56136,
 615909874,
 67341,
 -56135,
 615975254,
 67340,
 -1,
 616040646,
 67339,
 616244420,
 615451679,
 -1,
 -56132,
 616173190,
 67377,
 -56131,
 616238599,
 67376,
 -56130,
 616303969,
 67375,
 -56129,
 616369353,
 67374,
 -56128,
 616434719,
 67373,
 -56127,
 616500099,
 67372,
 -56126,
 616565450,
 67371,
 -56125,
 616630770,
 67370,
 -1,
 616696150,
 67369,
 616899790,
 616172018,
 -1,
 -56122,
 616828550,
 67357,
 -56121,
 616893959,
 67356,
 -56120,
 616959329,
 67355,
 -56119,
 617024713,
 67354,
 -56118,
 617089923,
 67353,
 -56117,
 617155274,
 67352,
 -56116,
 617220594,
 67351,
 -56115,
 617285974,
 67350,
 -1,
 617351366,
 67349,
 617555159,
 616827779,
 -1,
 -56112,
 617483910,
 67368,
 -56111,
 617549319,
 67367,
 -56110,
 617614537,
 67366,
 -56109,
 617679903,
 67365,
 -56108,
 617745283,
 67364,
 -56107,
 617810634,
 67363,
 -56106,
 617875954,
 67362,
 -1,
 617941190,
 67361,
 618144992,
 617482438,
 -1,
 -56103,
 618073734,
 67338,
 -56102,
 618139143,
 67337,
 -56101,
 618204361,
 67336,
 -56100,
 618269571,
 67335,
 -56099,
 618334922,
 67334,
 -56098,
 618400242,
 67333,
 -56097,
 618465622,
 67332,
 -1,
 618531014,
 67331,
 618734822,
 618073289,
 -1,
 -56094,
 618662787,
 67382,
 -56093,
 618728138,
 67381,
 -56092,
 618793458,
 67380,
 -56091,
 618858838,
 67379,
 -1,
 618924230,
 67378,
 619184127,
 618662602,
 -1,
 -56088,
 619056647,
 67360,
 -56087,
 619122017,
 67359,
 -1,
 619187075,
 67358,
 619390213,
 615386465,
 -1,
 619455739,
 619317446,
 -1,
 619521267,
 619384454,
 -1,
 619586802,
 619448349,
 -1,
 -56081,
 619515138,
 67404,
 -56080,
 619580331,
 67403,
 -56079,
 619645718,
 67402,
 -1,
 619711012,
 67401,
 -1,
 619512426,
 67400,
 -56076,
 619449914,
 67399,
 -56075,
 619908496,
 67398,
 -56074,
 619973858,
 67397,
 -56073,
 620039211,
 67396,
 -56072,
 620104591,
 67395,
 -56071,
 620169938,
 67394,
 -56070,
 620235255,
 67393,
 -1,
 620300632,
 67392,
 620504323,
 619383126,
 -1,
 -56067,
 620432749,
 67411,
 -56066,
 620497958,
 67410,
 -56065,
 620563337,
 67409,
 -56064,
 620628798,
 67408,
 -56063,
 620694181,
 67407,
 -56062,
 620759502,
 67406,
 -1,
 620824885,
 67405,
 -56060,
 620432247,
 67413,
 -1,
 620956350,
 67412,
 621159707,
 619318147,
 -1,
 621225233,
 621086918,
 -1,
 -56056,
 621154041,
 67241,
 -56055,
 621219450,
 67240,
 -56054,
 621284838,
 67239,
 -56053,
 621350229,
 67238,
 -56052,
 621415607,
 67237,
 -56051,
 621480972,
 67236,
 -56050,
 621546343,
 67235,
 -56049,
 621611694,
 67234,
 -56048,
 621677030,
 67233,
 -1,
 621742398,
 67232,
 622002175,
 621152598,
 -1,
 -56045,
 621874810,
 67250,
 -56044,
 621940198,
 67249,
 -56043,
 622005589,
 67248,
 -56042,
 622070967,
 67247,
 -56041,
 622136332,
 67246,
 -56040,
 622201703,
 67245,
 -56039,
 622267054,
 67244,
 -56038,
 622332390,
 67243,
 -1,
 622397758,
 67242,
 622601508,
 621088384,
 -1,
 -56035,
 622529889,
 67431,
 -56034,
 622595273,
 67430,
 -56033,
 622660639,
 67429,
 -56032,
 622726019,
 67428,
 -56031,
 622791370,
 67427,
 -56030,
 622856690,
 67426,
 -56029,
 622922070,
 67425,
 -1,
 622987462,
 67424,
 623191336,
 622528854,
 -1,
 -56026,
 623119219,
 67151,
 -56025,
 623184564,
 67146,
 -1,
 623249732,
 67143,
 -1,
 623118667,
 67099,
 623575039,
 597426176,
 -1,
 623584556,
 623477224,
 983068,
 -1,
 623510622,
 983142,
 -1,
 623522744,
 983062,
 623837183,
 597379779,
 -1,
 -56017,
 623717590,
 128391,
 -1,
 623772853,
 128279,
 623977800,
 597309353,
 -1,
 624043335,
 623919065,
 -1,
 624108869,
 623968256,
 -1,
 624174394,
 624046886,
 -1,
 624239927,
 624125763,
 -1,
 -56010,
 624197490,
 128964,
 -1,
 624239941,
 11212,
 624492543,
 624183523,
 -1,
 -56007,
 624393870,
 128943,
 -1,
 624454686,
 128969,
 624633149,
 624132430,
 -1,
 -56004,
 624595524,
 128978,
 -1,
 624639881,
 128960,
 624829760,
 624588834,
 -1,
 -56001,
 624773515,
 128949,
 -1,
 624825027,
 128937,
 -55999,
 624792361,
 128910,
 -55998,
 624979931,
 128648,
 -55997,
 625031767,
 128930,
 -55996,
 625094175,
 128955,
 -1,
 625155987,
 128504,
 625410047,
 624057864,
 128498,
 -1,
 625279234,
 128497,
 -1,
 623974272,
 128626,
 625550666,
 623930733,
 128482,
 -1,
 625509487,
 128132,
 625681741,
 625498043,
 -1,
 -55988,
 625640981,
 6430,
 -1,
 625687234,
 6429,
 -55986,
 625645805,
 129422,
 -1,
 625828534,
 129409,
 626009710,
 597233425,
 -1,
 626075221,
 625968355,
 -1,
 626140669,
 626030626,
 -1,
 626206196,
 626087681,
 -1,
 626271588,
 626165911,
 -1,
 626337122,
 626196480,
 -1,
 626402657,
 626299799,
 -1,
 626468186,
 626349712,
 -1,
 -55976,
 626427040,
 983623,
 -55975,
 626473553,
 983589,
 -1,
 626528353,
 983621,
 626730333,
 626423842,
 -1,
 -55972,
 626689863,
 42937,
 -1,
 626736930,
 43854,
 626926944,
 626680170,
 -1,
 -55969,
 626885792,
 983619,
 -1,
 626921569,
 983617,
 -1,
 626872331,
 43858,
 -1,
 626333904,
 43855,
 -55965,
 626286693,
 43875,
 -1,
 627195997,
 43856,
 627385717,
 626207583,
 -1,
 627451252,
 627312004,
 -1,
 627516778,
 627412804,
 983567,
 627638271,
 627441695,
 -1,
 -55959,
 627522129,
 983569,
 -1,
 627576929,
 983571,
 627778925,
 627466602,
 -1,
 -55956,
 627737760,
 983597,
 -1,
 627773537,
 983595,
 627975536,
 627714202,
 -1,
 -55953,
 627934368,
 983601,
 -1,
 627970145,
 983599,
 628172147,
 627908823,
 -1,
 -55950,
 628119169,
 983573,
 -1,
 628170314,
 983575,
 -1,
 628110754,
 43828,
 -1,
 627400031,
 43836,
 628499843,
 627341346,
 -1,
 628565374,
 628432183,
 -1,
 628630907,
 628520424,
 -1,
 628696442,
 628584268,
 43851,
 -1,
 628623237,
 43852,
 -1,
 628635579,
 43830,
 628948991,
 628572228,
 -1,
 -55939,
 628832849,
 983629,
 -1,
 628887649,
 983630,
 629089665,
 628491652,
 -1,
 -55936,
 629051204,
 983587,
 -1,
 629104823,
 42921,
 -55934,
 629048614,
 43845,
 -1,
 629215761,
 43872,
 629417361,
 628441181,
 -1,
 629482893,
 629343620,
 -1,
 629548425,
 629418138,
 -1,
 -55929,
 629507232,
 983603,
 -55928,
 629553745,
 983602,
 -1,
 629608545,
 983578,
 629810572,
 629498230,
 -1,
 -55925,
 629769376,
 983607,
 -1,
 629805153,
 983605,
 -1,
 629757596,
 983577,
 630072720,
 629432394,
 -1,
 -55921,
 630022442,
 43840,
 -1,
 630067836,
 43876,
 -1,
 630023730,
 43873,
 630334877,
 629366885,
 -1,
 630400408,
 630287003,
 -1,
 630465943,
 630326660,
 -1,
 -55915,
 630423605,
 43839,
 -55914,
 630471249,
 983625,
 -1,
 630526049,
 983626,
 -1,
 630401887,
 43874,
 630793628,
 630327246,
 983581,
 630915071,
 630718495,
 -1,
 -55909,
 630798929,
 983583,
 -1,
 630853729,
 983585,
 -1,
 630741118,
 42935,
 631121321,
 630265890,
 -1,
 631186850,
 631066003,
 -1,
 631252385,
 631136357,
 43837,
 -1,
 631179182,
 43838,
 -1,
 631188319,
 43826,
 631448999,
 631115537,
 -1,
 631514534,
 631404416,
 -1,
 -55899,
 631450463,
 43827,
 -1,
 631509628,
 43824,
 -1,
 631470532,
 43853,
 -55896,
 631386491,
 42933,
 -1,
 631703195,
 42903,
 631907764,
 631080890,
 -1,
 631973296,
 631857253,
 -1,
 632038830,
 631909304,
 -1,
 -55891,
 631996469,
 43841,
 -1,
 632045315,
 43842,
 632291327,
 631964514,
 43843,
 -1,
 632162222,
 43844,
 632366515,
 631934527,
 -1,
 -55886,
 632306257,
 983627,
 -1,
 632361057,
 983628,
 -1,
 632326799,
 43857,
 632628668,
 631852279,
 -1,
 632694203,
 632554884,
 -1,
 -55881,
 632652960,
 983611,
 -55880,
 632713878,
 42894,
 -55879,
 632772907,
 43833,
 -55878,
 632833744,
 43831,
 -1,
 632891736,
 43832,
 -1,
 632631148,
 43829,
 633152964,
 632560951,
 -1,
 633218497,
 633093554,
 43859,
 633339903,
 633145110,
 -1,
 -55872,
 633238509,
 43860,
 -1,
 633294921,
 43861,
 633536511,
 633144708,
 -1,
 -55869,
 633432404,
 42900,
 -1,
 633477324,
 42899,
 633677261,
 633081617,
 -1,
 633742796,
 633602048,
 -1,
 633808331,
 633705367,
 -1,
 633873866,
 633758058,
 -1,
 -55863,
 633832608,
 983593,
 -1,
 633868385,
 983591,
 -1,
 633820828,
 983565,
 -1,
 633762522,
 43825,
 -1,
 633678784,
 983624,
 634267091,
 633640465,
 -1,
 634332626,
 634215763,
 43863,
 634454015,
 634257408,
 -1,
 -55855,
 634360864,
 43865,
 -1,
 634393488,
 43864,
 -1,
 634294564,
 43862,
 634660313,
 634220388,
 -1,
 634725848,
 634585088,
 -1,
 -55850,
 634684576,
 983615,
 -55849,
 634740919,
 42919,
 -1,
 634791024,
 43849,
 -1,
 634677151,
 43847,
 635053535,
 634608471,
 -1,
 635119070,
 634979716,
 -1,
 -55844,
 635068599,
 42917,
 -55843,
 635119441,
 42897,
 -1,
 635184240,
 43835,
 -1,
 635058127,
 983579,
 635446755,
 635015339,
 -1,
 -55839,
 635406895,
 42911,
 -55838,
 635461930,
 42909,
 -1,
 635506838,
 42907,
 635708904,
 635386567,
 -1,
 635774439,
 635659364,
 -1,
 -55834,
 635714129,
 983631,
 -1,
 635768929,
 983632,
 -1,
 635701072,
 42901,
 636036587,
 635655753,
 -1,
 -55830,
 635995296,
 983613,
 -1,
 636036208,
 43834,
 636233198,
 635975593,
 -1,
 -55827,
 636173013,
 983199,
 -1,
 636225313,
 42913,
 636429808,
 636168572,
 43848,
 -1,
 636356076,
 43850,
 -55823,
 636393201,
 43866,
 -55822,
 636504827,
 42915,
 -55821,
 636570111,
 983609,
 -1,
 636629820,
 42905,
 636878847,
 626166228,
 -1,
 -55818,
 636780878,
 8348,
 -55817,
 636844066,
 8347,
 -55816,
 636905681,
 8346,
 -55815,
 636967767,
 8345,
 -55814,
 637031956,
 8344,
 -55813,
 637095159,
 8343,
 -55812,
 637160131,
 8342,
 -1,
 637221575,
 8341,
 637412942,
 626073078,
 -1,
 637478412,
 637348792,
 -1,
 637543939,
 637439812,
 983566,
 637665279,
 637468703,
 -1,
 -55806,
 637549137,
 983568,
 -1,
 637603937,
 983570,
 637806086,
 637493610,
 -1,
 -55803,
 637764768,
 983596,
 -1,
 637800545,
 983594,
 638002697,
 637741210,
 -1,
 -55800,
 637961376,
 983600,
 -1,
 637997153,
 983598,
 638255103,
 637935831,
 -1,
 -55797,
 638146177,
 983572,
 -1,
 638197322,
 983574,
 638395925,
 637438161,
 -1,
 638461457,
 638342800,
 -1,
 -55793,
 638420128,
 983622,
 -55792,
 638466641,
 983588,
 -1,
 638521441,
 983620,
 638723604,
 638411114,
 -1,
 -55789,
 638682272,
 983618,
 -1,
 638718049,
 983616,
 -1,
 638681141,
 42936,
 638985755,
 638351394,
 -1,
 639051289,
 638911876,
 -1,
 -55784,
 639012676,
 983586,
 -1,
 639066295,
 42920,
 -55782,
 638998258,
 42926,
 -1,
 639181837,
 42924,
 639378977,
 638935141,
 -1,
 639444512,
 639305678,
 983580,
 639565823,
 639369247,
 -1,
 -55777,
 639449681,
 983582,
 -1,
 639504481,
 983584,
 -1,
 639391870,
 42934,
 639772197,
 639340715,
 -1,
 -55773,
 639732271,
 42910,
 -55772,
 639787306,
 42908,
 -1,
 639832214,
 42906,
 640034345,
 639731642,
 -1,
 -55769,
 639992142,
 42929,
 -55768,
 640043715,
 42928,
 -1,
 640105159,
 42893,
 640296494,
 639987532,
 -1,
 640362029,
 640222596,
 -1,
 -55764,
 640320672,
 983614,
 -1,
 640377015,
 42918,
 -1,
 640299651,
 42923,
 640624179,
 640237787,
 -1,
 640689714,
 640573802,
 -1,
 -55759,
 640648352,
 983606,
 -1,
 640684129,
 983604,
 -1,
 640636572,
 983576,
 640951864,
 640552765,
 -1,
 641017399,
 640901482,
 -1,
 -55754,
 640976032,
 983592,
 -1,
 641011809,
 983590,
 -1,
 640964252,
 983564,
 641279547,
 640899961,
 -1,
 -55750,
 641228983,
 42916,
 -1,
 641279825,
 42896,
 641476158,
 641223957,
 -1,
 -55747,
 641434784,
 983610,
 -1,
 641472882,
 42925,
 641672769,
 641419767,
 -1,
 -55744,
 641631392,
 983608,
 -1,
 641672304,
 42930,
 641869380,
 641611689,
 -1,
 -55741,
 641809109,
 983198,
 -1,
 641861409,
 42912,
 642065991,
 641801527,
 -1,
 -55738,
 642006450,
 42931,
 -1,
 642057611,
 42898,
 642262602,
 641996834,
 -1,
 -55735,
 642199931,
 42932,
 -1,
 642254491,
 42902,
 -55733,
 642209361,
 983612,
 -55732,
 642403067,
 42914,
 -55731,
 642464457,
 42922,
 -1,
 642528060,
 42904,
 642721364,
 637358593,
 -1,
 642786899,
 642668260,
 -1,
 -55727,
 642746354,
 43002,
 -55726,
 642805611,
 43846,
 -1,
 642870829,
 42927,
 -1,
 642729525,
 42895,
 -1,
 642658348,
 42999,
 643180126,
 626024571,
 -1,
 643245657,
 643124233,
 -1,
 -55720,
 643194971,
 3807,
 -1,
 643250701,
 3806,
 643442268,
 643184061,
 -1,
 -55717,
 643392166,
 983204,
 -1,
 643438586,
 983205,
 -55715,
 643397317,
 983206,
 -1,
 643585095,
 983207,
 643769958,
 643133260,
 -1,
 643835493,
 643709072,
 -1,
 643901027,
 643767163,
 -1,
 -55710,
 643835861,
 128311,
 -1,
 643899438,
 128309,
 -55708,
 643854730,
 128308,
 -1,
 644048216,
 128310,
 -1,
 643776655,
 8382,
 644294249,
 643727172,
 -1,
 -55704,
 644256685,
 127772,
 -1,
 644317471,
 127767,
 644490860,
 644225058,
 -1,
 -55701,
 644427360,
 127991,
 -1,
 644481378,
 129404,
 -55699,
 644426576,
 128030,
 -1,
 644621384,
 129357,
 644818631,
 625945439,
 -1,
 644884159,
 644757349,
 -1,
 644949668,
 644845956,
 -1,
 645015177,
 644907342,
 -1,
 645080711,
 644969238,
 -1,
 645146246,
 645007428,
 -1,
 645211780,
 645076444,
 11104,
 645332991,
 645136384,
 -1,
 645342850,
 645239703,
 -1,
 645408378,
 645289095,
 -1,
 -55687,
 645368965,
 11172,
 -1,
 645409371,
 11174,
 645604989,
 645343434,
 -1,
 -55684,
 645566312,
 983237,
 -1,
 645611267,
 11130,
 -55682,
 645566362,
 129072,
 -55681,
 645749751,
 129056,
 -55680,
 645814302,
 129060,
 -55679,
 645872933,
 129068,
 -1,
 645929919,
 129064,
 -55677,
 645301576,
 11120,
 -1,
 646080549,
 11136,
 -55675,
 645163325,
 11140,
 -1,
 646194818,
 11114,
 -1,
 645071022,
 129168,
 -55672,
 645043508,
 11244,
 -1,
 646407338,
 129186,
 646588049,
 644945397,
 -1,
 646653581,
 646544659,
 -1,
 -55668,
 646612613,
 129024,
 -1,
 646656095,
 129040,
 -55666,
 646602503,
 129176,
 -55665,
 646797369,
 129028,
 -55664,
 646860360,
 129032,
 -1,
 646918239,
 129044,
 647112341,
 646518818,
 -1,
 -55661,
 647063144,
 129184,
 -55660,
 647122275,
 11144,
 -1,
 647172109,
 129192,
 647374488,
 647067682,
 -1,
 -55657,
 647327400,
 129080,
 -1,
 647369792,
 129104,
 647571099,
 647327564,
 -1,
 -55654,
 647520497,
 128620,
 -1,
 647578283,
 129190,
 647767710,
 647511309,
 -1,
 -55651,
 647701096,
 129088,
 -1,
 647763420,
 129092,
 647964321,
 647705382,
 -1,
 -55648,
 647919338,
 129194,
 -1,
 647972323,
 129076,
 -55646,
 647926473,
 129172,
 -55645,
 648106156,
 129188,
 -1,
 648159848,
 129084,
 648357560,
 644874240,
 -1,
 648423088,
 648297173,
 -1,
 648488623,
 648368750,
 -1,
 648554158,
 648421422,
 129287,
 648675327,
 648480132,
 -1,
 648685228,
 648577358,
 -1,
 -55637,
 648647897,
 129285,
 -1,
 648691550,
 129284,
 -55635,
 648623708,
 129283,
 -1,
 648816775,
 129286,
 -1,
 648485646,
 11240,
 -1,
 648436814,
 128379,
 649143987,
 648377169,
 -1,
 -55630,
 649103051,
 11108,
 -1,
 649165076,
 129112,
 -55628,
 649106898,
 128398,
 -55627,
 649298821,
 128492,
 -55626,
 649363025,
 128488,
 -55625,
 649418233,
 128709,
 -1,
 649466854,
 128494,
 649723903,
 648284189,
 -1,
 649733820,
 649605981,
 -1,
 -55621,
 649671930,
 129307,
 -1,
 649729444,
 1422,
 -55619,
 649692520,
 8294,
 -55618,
 649882703,
 128269,
 -1,
 649935876,
 9958,
 650127042,
 644813033,
 -1,
 -55615,
 650090190,
 129388,
 -1,
 650117611,
 127811,
 -55613,
 650088117,
 127898,
 -55612,
 650273984,
 128006,
 -55611,
 650336883,
 127819,
 -55610,
 650393513,
 129461,
 -1,
 650454928,
 128210,
 650651362,
 644767845,
 -1,
 650716886,
 650613017,
 -1,
 650782418,
 650653816,
 -1,
 650847953,
 650727360,
 -1,
 650913486,
 650799313,
 -1,
 -55603,
 650850089,
 128393,
 -1,
 650908037,
 128396,
 -55601,
 650851904,
 128395,
 -55600,
 651043779,
 128397,
 -1,
 651106490,
 128394,
 -1,
 650802201,
 128318,
 651427839,
 650706944,
 -1,
 651437781,
 651316127,
 11847,
 -1,
 651363878,
 11848,
 -1,
 651369602,
 128261,
 651634395,
 650649845,
 128274,
 651699930,
 651576781,
 -1,
 -55591,
 651663623,
 983079,
 -1,
 651715332,
 983076,
 -1,
 651626217,
 128271,
 651962078,
 651595376,
 -1,
 -55587,
 651907490,
 128140,
 -1,
 651968310,
 127977,
 -55585,
 651921950,
 128557,
 -55584,
 652117241,
 129524,
 -55583,
 652170250,
 127853,
 -1,
 652221627,
 129438,
 652420839,
 650604364,
 -1,
 -55580,
 652370021,
 983225,
 -55579,
 652432916,
 983220,
 -55578,
 652492893,
 983230,
 -1,
 652553055,
 983222,
 -55576,
 652384213,
 129317,
 -55575,
 652708459,
 129523,
 -55574,
 652758485,
 129433,
 -1,
 652817190,
 983065,
 653011413,
 597187415,
 -1,
 653076634,
 652970135,
 -1,
 653142167,
 653032435,
 -1,
 653207702,
 653074289,
 -1,
 653273084,
 653134322,
 -1,
 653338369,
 653208415,
 -1,
 -55566,
 653275942,
 111343,
 -55565,
 653339487,
 111342,
 -55564,
 653403487,
 111341,
 -55563,
 653466935,
 111340,
 -55562,
 653531170,
 111339,
 -55561,
 653594385,
 111338,
 -55560,
 653659782,
 111337,
 -55559,
 653725191,
 111336,
 -55558,
 653790561,
 111335,
 -55557,
 653855945,
 111334,
 -55556,
 653921311,
 111333,
 -55555,
 653986691,
 111332,
 -55554,
 654052042,
 111331,
 -55553,
 654117362,
 111330,
 -55552,
 654182742,
 111329,
 -1,
 654248134,
 111328,
 654452498,
 653272415,
 -1,
 -55549,
 654390054,
 111327,
 -55548,
 654453599,
 111326,
 -55547,
 654517599,
 111325,
 -55546,
 654581047,
 111324,
 -55545,
 654645282,
 111323,
 -55544,
 654708497,
 111322,
 -55543,
 654773894,
 111321,
 -55542,
 654839303,
 111320,
 -55541,
 654904673,
 111319,
 -55540,
 654970057,
 111318,
 -55539,
 655035423,
 111317,
 -55538,
 655100803,
 111316,
 -55537,
 655166154,
 111315,
 -55536,
 655231474,
 111314,
 -55535,
 655296854,
 111313,
 -1,
 655362246,
 111312,
 655566627,
 654384439,
 -1,
 -55532,
 655504166,
 111311,
 -55531,
 655567711,
 111310,
 -55530,
 655631711,
 111309,
 -55529,
 655695159,
 111308,
 -55528,
 655759394,
 111307,
 -55527,
 655822609,
 111306,
 -55526,
 655888006,
 111305,
 -55525,
 655953415,
 111304,
 -55524,
 656018785,
 111303,
 -55523,
 656084169,
 111302,
 -55522,
 656149535,
 111301,
 -55521,
 656214915,
 111300,
 -55520,
 656280266,
 111299,
 -55519,
 656345586,
 111298,
 -55518,
 656410966,
 111297,
 -1,
 656476358,
 111296,
 656680756,
 655497250,
 -1,
 -55515,
 656618278,
 111295,
 -55514,
 656681823,
 111294,
 -55513,
 656745823,
 111293,
 -55512,
 656809271,
 111292,
 -55511,
 656873506,
 111291,
 -55510,
 656936721,
 111290,
 -55509,
 657002118,
 111289,
 -55508,
 657067527,
 111288,
 -55507,
 657132897,
 111287,
 -55506,
 657198281,
 111286,
 -55505,
 657263647,
 111285,
 -55504,
 657329027,
 111284,
 -55503,
 657394378,
 111283,
 -55502,
 657459698,
 111282,
 -55501,
 657525078,
 111281,
 -1,
 657590470,
 111280,
 657794885,
 656609041,
 -1,
 -55498,
 657732390,
 111279,
 -55497,
 657795935,
 111278,
 -55496,
 657859935,
 111277,
 -55495,
 657923383,
 111276,
 -55494,
 657987618,
 111275,
 -55493,
 658050833,
 111274,
 -55492,
 658116230,
 111273,
 -55491,
 658181639,
 111272,
 -55490,
 658247009,
 111271,
 -55489,
 658312393,
 111270,
 -55488,
 658377759,
 111269,
 -55487,
 658443139,
 111268,
 -55486,
 658508490,
 111267,
 -55485,
 658573810,
 111266,
 -55484,
 658639190,
 111265,
 -1,
 658704582,
 111264,
 658909014,
 657723014,
 -1,
 -55481,
 658846502,
 111263,
 -55480,
 658910047,
 111262,
 -55479,
 658974047,
 111261,
 -55478,
 659037495,
 111260,
 -55477,
 659101730,
 111259,
 -55476,
 659164945,
 111258,
 -55475,
 659230342,
 111257,
 -55474,
 659295751,
 111256,
 -55473,
 659361121,
 111255,
 -55472,
 659426505,
 111254,
 -55471,
 659491871,
 111253,
 -55470,
 659557251,
 111252,
 -55469,
 659622602,
 111251,
 -55468,
 659687922,
 111250,
 -55467,
 659753302,
 111249,
 -1,
 659818694,
 111248,
 660023143,
 658836999,
 -1,
 -55464,
 659960614,
 111247,
 -55463,
 660024159,
 111246,
 -55462,
 660088159,
 111245,
 -55461,
 660151607,
 111244,
 -55460,
 660215842,
 111243,
 -55459,
 660279057,
 111242,
 -55458,
 660344454,
 111241,
 -55457,
 660409863,
 111240,
 -55456,
 660475233,
 111239,
 -55455,
 660540617,
 111238,
 -55454,
 660605983,
 111237,
 -55453,
 660671363,
 111236,
 -55452,
 660736714,
 111235,
 -55451,
 660802034,
 111234,
 -55450,
 660867414,
 111233,
 -1,
 660932806,
 111232,
 661137272,
 659950945,
 -1,
 -55447,
 661074726,
 111231,
 -55446,
 661138271,
 111230,
 -55445,
 661202271,
 111229,
 -55444,
 661265719,
 111228,
 -55443,
 661329954,
 111227,
 -55442,
 661393169,
 111226,
 -55441,
 661458566,
 111225,
 -55440,
 661523975,
 111224,
 -55439,
 661589345,
 111223,
 -55438,
 661654729,
 111222,
 -55437,
 661720095,
 111221,
 -55436,
 661785475,
 111220,
 -55435,
 661850826,
 111219,
 -55434,
 661916146,
 111218,
 -55433,
 661981526,
 111217,
 -1,
 662046918,
 111216,
 662251401,
 661064905,
 -1,
 -55430,
 662188838,
 111215,
 -55429,
 662252383,
 111214,
 -55428,
 662316383,
 111213,
 -55427,
 662379831,
 111212,
 -55426,
 662444066,
 111211,
 -55425,
 662507281,
 111210,
 -55424,
 662572678,
 111209,
 -55423,
 662638087,
 111208,
 -55422,
 662703457,
 111207,
 -55421,
 662768841,
 111206,
 -55420,
 662834207,
 111205,
 -55419,
 662899587,
 111204,
 -55418,
 662964938,
 111203,
 -55417,
 663030258,
 111202,
 -55416,
 663095638,
 111201,
 -1,
 663161030,
 111200,
 663365530,
 662178847,
 -1,
 -55413,
 663302950,
 111199,
 -55412,
 663366495,
 111198,
 -55411,
 663430495,
 111197,
 -55410,
 663493943,
 111196,
 -55409,
 663558178,
 111195,
 -55408,
 663621393,
 111194,
 -55407,
 663686790,
 111193,
 -55406,
 663752199,
 111192,
 -55405,
 663817569,
 111191,
 -55404,
 663882953,
 111190,
 -55403,
 663948319,
 111189,
 -55402,
 664013699,
 111188,
 -55401,
 664079050,
 111187,
 -55400,
 664144370,
 111186,
 -55399,
 664209750,
 111185,
 -1,
 664275142,
 111184,
 664479659,
 663292803,
 -1,
 -55396,
 664417062,
 111183,
 -55395,
 664480607,
 111182,
 -55394,
 664544607,
 111181,
 -55393,
 664608055,
 111180,
 -55392,
 664672290,
 111179,
 -55391,
 664735505,
 111178,
 -55390,
 664800902,
 111177,
 -55389,
 664866311,
 111176,
 -55388,
 664931681,
 111175,
 -55387,
 664997065,
 111174,
 -55386,
 665062431,
 111173,
 -55385,
 665127811,
 111172,
 -55384,
 665193162,
 111171,
 -55383,
 665258482,
 111170,
 -55382,
 665323862,
 111169,
 -1,
 665389254,
 111168,
 665593788,
 664406730,
 -1,
 -55379,
 665531174,
 111167,
 -55378,
 665594719,
 111166,
 -55377,
 665658719,
 111165,
 -55376,
 665722167,
 111164,
 -55375,
 665786402,
 111163,
 -55374,
 665849617,
 111162,
 -55373,
 665915014,
 111161,
 -55372,
 665980423,
 111160,
 -55371,
 666045793,
 111159,
 -55370,
 666111177,
 111158,
 -55369,
 666176543,
 111157,
 -55368,
 666241923,
 111156,
 -55367,
 666307274,
 111155,
 -55366,
 666372594,
 111154,
 -55365,
 666437974,
 111153,
 -1,
 666503366,
 111152,
 666707917,
 665520626,
 -1,
 -55362,
 666645286,
 111151,
 -55361,
 666708831,
 111150,
 -55360,
 666772831,
 111149,
 -55359,
 666836279,
 111148,
 -55358,
 666900514,
 111147,
 -55357,
 666963729,
 111146,
 -55356,
 667029126,
 111145,
 -55355,
 667094535,
 111144,
 -55354,
 667159905,
 111143,
 -55353,
 667225289,
 111142,
 -55352,
 667290655,
 111141,
 -55351,
 667356035,
 111140,
 -55350,
 667421386,
 111139,
 -55349,
 667486706,
 111138,
 -55348,
 667552086,
 111137,
 -1,
 667617478,
 111136,
 667822046,
 666634582,
 -1,
 -55345,
 667759398,
 111135,
 -55344,
 667822943,
 111134,
 -55343,
 667886943,
 111133,
 -55342,
 667950391,
 111132,
 -55341,
 668014626,
 111131,
 -55340,
 668077841,
 111130,
 -55339,
 668143238,
 111129,
 -55338,
 668208647,
 111128,
 -55337,
 668274017,
 111127,
 -55336,
 668339401,
 111126,
 -55335,
 668404767,
 111125,
 -55334,
 668470147,
 111124,
 -55333,
 668535498,
 111123,
 -55332,
 668600818,
 111122,
 -55331,
 668666198,
 111121,
 -1,
 668731590,
 111120,
 668936175,
 667748550,
 -1,
 -55328,
 668873510,
 111119,
 -55327,
 668937055,
 111118,
 -55326,
 669001055,
 111117,
 -55325,
 669064503,
 111116,
 -55324,
 669128738,
 111115,
 -55323,
 669191953,
 111114,
 -55322,
 669257350,
 111113,
 -55321,
 669322759,
 111112,
 -55320,
 669388129,
 111111,
 -55319,
 669453513,
 111110,
 -55318,
 669518879,
 111109,
 -55317,
 669584259,
 111108,
 -55316,
 669649610,
 111107,
 -55315,
 669714930,
 111106,
 -55314,
 669780310,
 111105,
 -1,
 669845702,
 111104,
 670105599,
 668873510,
 -1,
 -55311,
 669980706,
 111355,
 -55310,
 670043921,
 111354,
 -55309,
 670109318,
 111353,
 -55308,
 670174727,
 111352,
 -55307,
 670240097,
 111351,
 -55306,
 670305481,
 111350,
 -55305,
 670370847,
 111349,
 -55304,
 670436227,
 111348,
 -55303,
 670501578,
 111347,
 -55302,
 670566898,
 111346,
 -55301,
 670632278,
 111345,
 -1,
 670697670,
 111344,
 670957567,
 653199702,
 -1,
 670967822,
 670839590,
 -1,
 -55297,
 670905126,
 111103,
 -55296,
 670968671,
 111102,
 -55295,
 671032671,
 111101,
 -55294,
 671096119,
 111100,
 -55293,
 671160354,
 111099,
 -55292,
 671223569,
 111098,
 -55291,
 671288966,
 111097,
 -55290,
 671354375,
 111096,
 -55289,
 671419745,
 111095,
 -55288,
 671485129,
 111094,
 -55287,
 671550495,
 111093,
 -55286,
 671615875,
 111092,
 -55285,
 671681226,
 111091,
 -55284,
 671746546,
 111090,
 -55283,
 671811926,
 111089,
 -1,
 671877318,
 111088,
 672081951,
 670903135,
 -1,
 -55280,
 672019238,
 111087,
 -55279,
 672082783,
 111086,
 -55278,
 672146783,
 111085,
 -55277,
 672210231,
 111084,
 -55276,
 672274466,
 111083,
 -55275,
 672337681,
 111082,
 -55274,
 672403078,
 111081,
 -55273,
 672468487,
 111080,
 -55272,
 672533857,
 111079,
 -55271,
 672599241,
 111078,
 -55270,
 672664607,
 111077,
 -55269,
 672729987,
 111076,
 -55268,
 672795338,
 111075,
 -55267,
 672860658,
 111074,
 -55266,
 672926038,
 111073,
 -1,
 672991430,
 111072,
 673196080,
 672015711,
 -1,
 -55263,
 673133350,
 111071,
 -55262,
 673196895,
 111070,
 -55261,
 673260895,
 111069,
 -55260,
 673324343,
 111068,
 -55259,
 673388578,
 111067,
 -55258,
 673451793,
 111066,
 -55257,
 673517190,
 111065,
 -55256,
 673582599,
 111064,
 -55255,
 673647969,
 111063,
 -55254,
 673713353,
 111062,
 -55253,
 673778719,
 111061,
 -55252,
 673844099,
 111060,
 -55251,
 673909450,
 111059,
 -55250,
 673974770,
 111058,
 -55249,
 674040150,
 111057,
 -1,
 674105542,
 111056,
 674310209,
 673127735,
 -1,
 -55246,
 674247462,
 111055,
 -55245,
 674311007,
 111054,
 -55244,
 674375007,
 111053,
 -55243,
 674438455,
 111052,
 -55242,
 674502690,
 111051,
 -55241,
 674565905,
 111050,
 -55240,
 674631302,
 111049,
 -55239,
 674696711,
 111048,
 -55238,
 674762081,
 111047,
 -55237,
 674827465,
 111046,
 -55236,
 674892831,
 111045,
 -55235,
 674958211,
 111044,
 -55234,
 675023562,
 111043,
 -55233,
 675088882,
 111042,
 -55232,
 675154262,
 111041,
 -1,
 675219654,
 111040,
 675424338,
 674240546,
 -1,
 -55229,
 675361574,
 111039,
 -55228,
 675425119,
 111038,
 -55227,
 675489119,
 111037,
 -55226,
 675552567,
 111036,
 -55225,
 675616802,
 111035,
 -55224,
 675680017,
 111034,
 -55223,
 675745414,
 111033,
 -55222,
 675810823,
 111032,
 -55221,
 675876193,
 111031,
 -55220,
 675941577,
 111030,
 -55219,
 676006943,
 111029,
 -55218,
 676072323,
 111028,
 -55217,
 676137674,
 111027,
 -55216,
 676202994,
 111026,
 -55215,
 676268374,
 111025,
 -1,
 676333766,
 111024,
 676538467,
 675352337,
 -1,
 -55212,
 676475686,
 111023,
 -55211,
 676539231,
 111022,
 -55210,
 676603231,
 111021,
 -55209,
 676666679,
 111020,
 -55208,
 676730914,
 111019,
 -55207,
 676794129,
 111018,
 -55206,
 676859526,
 111017,
 -55205,
 676924935,
 111016,
 -55204,
 676990305,
 111015,
 -55203,
 677055689,
 111014,
 -55202,
 677121055,
 111013,
 -55201,
 677186435,
 111012,
 -55200,
 677251786,
 111011,
 -55199,
 677317106,
 111010,
 -55198,
 677382486,
 111009,
 -1,
 677447878,
 111008,
 677652596,
 676466310,
 -1,
 -55195,
 677589798,
 111007,
 -55194,
 677653343,
 111006,
 -55193,
 677717343,
 111005,
 -55192,
 677780791,
 111004,
 -55191,
 677845026,
 111003,
 -55190,
 677908241,
 111002,
 -55189,
 677973638,
 111001,
 -55188,
 678039047,
 111000,
 -55187,
 678104417,
 110999,
 -55186,
 678169801,
 110998,
 -55185,
 678235167,
 110997,
 -55184,
 678300547,
 110996,
 -55183,
 678365898,
 110995,
 -55182,
 678431218,
 110994,
 -55181,
 678496598,
 110993,
 -1,
 678561990,
 110992,
 678766725,
 677580295,
 -1,
 -55178,
 678703910,
 110991,
 -55177,
 678767455,
 110990,
 -55176,
 678831455,
 110989,
 -55175,
 678894903,
 110988,
 -55174,
 678959138,
 110987,
 -55173,
 679022353,
 110986,
 -55172,
 679087750,
 110985,
 -55171,
 679153159,
 110984,
 -55170,
 679218529,
 110983,
 -55169,
 679283913,
 110982,
 -55168,
 679349279,
 110981,
 -55167,
 679414659,
 110980,
 -55166,
 679480010,
 110979,
 -55165,
 679545330,
 110978,
 -55164,
 679610710,
 110977,
 -1,
 679676102,
 110976,
 679935999,
 678694241,
 -1,
 -55161,
 679818022,
 110975,
 -55160,
 679881567,
 110974,
 -55159,
 679945567,
 110973,
 -55158,
 680009015,
 110972,
 -55157,
 680073250,
 110971,
 -55156,
 680136465,
 110970,
 -55155,
 680201862,
 110969,
 -55154,
 680267271,
 110968,
 -55153,
 680332641,
 110967,
 -55152,
 680398025,
 110966,
 -55151,
 680463391,
 110965,
 -55150,
 680528771,
 110964,
 -55149,
 680594122,
 110963,
 -55148,
 680659442,
 110962,
 -55147,
 680724822,
 110961,
 -1,
 680790214,
 110960,
 -1,
 653150381,
 94177,
 681060505,
 653085943,
 983041,
 -1,
 681004279,
 983040,
 -1,
 681017696,
 128297,
 681257314,
 653011807,
 -1,
 681322787,
 681218329,
 -1,
 681388314,
 681250579,
 -1,
 681453797,
 681333161,
 -1,
 681519272,
 681401175,
 -1,
 681584802,
 681481901,
 -1,
 -55135,
 681523925,
 70681,
 -1,
 681578257,
 70680,
 681781413,
 681523113,
 -1,
 -55132,
 681720533,
 70675,
 -1,
 681774865,
 70674,
 -55130,
 681728944,
 70686,
 -55129,
 681917141,
 70692,
 -1,
 681971473,
 70691,
 682174637,
 681480318,
 -1,
 682240171,
 682127180,
 70662,
 -1,
 682192716,
 70663,
 682426367,
 682183927,
 70664,
 -1,
 682314999,
 70665,
 682502323,
 682131790,
 -1,
 682567857,
 682459470,
 -1,
 -55120,
 682506965,
 70683,
 -1,
 682561297,
 70682,
 -55118,
 682506965,
 70688,
 -1,
 682692369,
 70687,
 682895545,
 682435935,
 -1,
 682961079,
 682829151,
 -1,
 -55114,
 682900181,
 70685,
 -1,
 682954513,
 70684,
 -55112,
 682900181,
 70690,
 -1,
 683085585,
 70689,
 683288765,
 682823441,
 70656,
 -55109,
 683247767,
 70669,
 -55108,
 683294813,
 70667,
 -1,
 683347729,
 70657,
 683550913,
 683243554,
 -1,
 -55105,
 683505822,
 70706,
 -55104,
 683555541,
 70705,
 -1,
 683609873,
 70707,
 683813059,
 683509911,
 70660,
 -1,
 683772055,
 70661,
 683944134,
 683765580,
 -1,
 -55099,
 683883221,
 70701,
 -1,
 683937553,
 70700,
 684140745,
 683894993,
 -1,
 -55096,
 684079829,
 70694,
 -1,
 684134161,
 70693,
 684337356,
 684086804,
 -1,
 -55093,
 684276437,
 70698,
 -1,
 684330769,
 70697,
 684533967,
 684281079,
 -1,
 -55090,
 684473045,
 70703,
 -1,
 684527377,
 70702,
 684730578,
 684477123,
 -1,
 -55087,
 684669653,
 70671,
 -1,
 684723985,
 70670,
 684927189,
 684673525,
 -1,
 -55084,
 684866261,
 70679,
 -1,
 684920593,
 70678,
 685123799,
 684867677,
 70658,
 -1,
 685064285,
 70659,
 685254874,
 685062057,
 -1,
 -55079,
 685193941,
 70673,
 -1,
 685248273,
 70672,
 685451485,
 685186359,
 -1,
 -55076,
 685390549,
 70677,
 -1,
 685444881,
 70676,
 685648096,
 685381666,
 -1,
 -55073,
 685587157,
 70696,
 -1,
 685641489,
 70695,
 -55071,
 685610760,
 70699,
 -55070,
 685805873,
 70704,
 -55069,
 685858917,
 70668,
 -55068,
 685914837,
 70708,
 -1,
 685976415,
 70666,
 686172405,
 681414904,
 -1,
 686237931,
 686133374,
 -1,
 686303465,
 686190412,
 70714,
 -1,
 686255948,
 70715,
 686489599,
 686247159,
 70716,
 -1,
 686378231,
 70717,
 686565615,
 686165777,
 -1,
 -55059,
 686524567,
 70721,
 -55058,
 686571613,
 70719,
 -1,
 686624529,
 70709,
 686827761,
 686524567,
 70712,
 -1,
 686786711,
 70713,
 686958835,
 686768221,
 70710,
 -1,
 686899293,
 70711,
 -55052,
 686907493,
 70720,
 -1,
 687024991,
 70718,
 687220998,
 686105951,
 -1,
 687286532,
 687162089,
 -1,
 687352058,
 687243598,
 -1,
 -55047,
 687314134,
 70738,
 -1,
 687357778,
 70739,
 687548669,
 687306786,
 -1,
 -55044,
 687491453,
 70742,
 -1,
 687551030,
 70743,
 687745280,
 687485734,
 -1,
 -55041,
 687695626,
 70740,
 -1,
 687753439,
 70741,
 -55039,
 687708423,
 70736,
 -55038,
 687891204,
 70737,
 -55037,
 687955394,
 70745,
 -1,
 688008704,
 70744,
 -55035,
 687236752,
 70732,
 -1,
 688133051,
 70731,
 688335124,
 687175714,
 -1,
 688400659,
 688275549,
 -1,
 688466194,
 688339453,
 -1,
 688531724,
 688427009,
 -1,
 -55029,
 688486722,
 70725,
 -1,
 688549951,
 70722,
 688728335,
 688459537,
 -1,
 -55026,
 688688714,
 70727,
 -1,
 688742461,
 70724,
 -55024,
 688676846,
 70726,
 -55023,
 688862278,
 70728,
 -1,
 688922062,
 70723,
 -1,
 688400028,
 70730,
 -1,
 688329664,
 70750,
 -55019,
 688286584,
 70747,
 -55018,
 689201717,
 70729,
 -55017,
 689260100,
 70749,
 -55016,
 689322037,
 70734,
 -55015,
 689381934,
 70733,
 -1,
 689442735,
 70735,
 689645855,
 681312256,
 -1,
 689711390,
 689592956,
 -1,
 -55011,
 689673133,
 127770,
 -1,
 689733919,
 127761,
 -1,
 689656704,
 983063,
 689973538,
 689591173,
 -1,
 -55007,
 689926987,
 11155,
 -1,
 689983419,
 11154,
 -1,
 689929798,
 128240,
 690235740,
 681261138,
 -1,
 690301248,
 690167933,
 -1,
 690366782,
 690245279,
 -1,
 -55001,
 690329720,
 127337,
 -55000,
 690394797,
 127336,
 -54999,
 690460146,
 127335,
 -54998,
 690524441,
 127334,
 -54997,
 690589237,
 127333,
 -54996,
 690653335,
 127332,
 -54995,
 690717006,
 127331,
 -54994,
 690780194,
 127330,
 -54993,
 690843468,
 127329,
 -54992,
 690908717,
 127328,
 -54991,
 690970725,
 127326,
 -54990,
 691034967,
 127325,
 -54989,
 691099156,
 127324,
 -54988,
 691162359,
 127323,
 -54987,
 691227331,
 127322,
 -54986,
 691292661,
 127321,
 -54985,
 691355741,
 127320,
 -54984,
 691419049,
 127318,
 -54983,
 691483430,
 127317,
 -54982,
 691546975,
 127316,
 -54981,
 691610975,
 127315,
 -54980,
 691674423,
 127314,
 -54979,
 691738658,
 127313,
 -1,
 691801873,
 127312,
 -54977,
 690325116,
 128982,
 -1,
 691961506,
 128984,
 692136283,
 690257577,
 -1,
 692201816,
 692080287,
 -1,
 -54973,
 692164728,
 127369,
 -54972,
 692229805,
 127368,
 -54971,
 692295154,
 127367,
 -54970,
 692359449,
 127366,
 -54969,
 692424245,
 127365,
 -54968,
 692488343,
 127364,
 -54967,
 692552014,
 127363,
 -54966,
 692615202,
 127362,
 -54965,
 692678476,
 127361,
 -54964,
 692743725,
 127360,
 -54963,
 692805733,
 127358,
 -54962,
 692869975,
 127357,
 -54961,
 692931267,
 127354,
 -54960,
 692994141,
 127352,
 -54959,
 693058247,
 127351,
 -54958,
 693122985,
 127350,
 -54957,
 693187366,
 127349,
 -54956,
 693250911,
 127348,
 -54955,
 693314911,
 127347,
 -54954,
 693378359,
 127346,
 -54953,
 693442594,
 127345,
 -1,
 693505809,
 127344,
 -54951,
 692163111,
 127375,
 -54950,
 693642301,
 10062,
 -1,
 693702534,
 127374,
 -1,
 692064301,
 983091,
 -54947,
 690198137,
 983130,
 -54946,
 693931551,
 128528,
 -54945,
 693993261,
 11228,
 -54944,
 694055142,
 129299,
 -54943,
 694111479,
 983131,
 -1,
 694165859,
 128084,
 694364572,
 681185041,
 -1,
 694430102,
 694294786,
 -1,
 694495625,
 694374825,
 -1,
 694561135,
 694432831,
 -1,
 -54937,
 694523993,
 67724,
 -54936,
 694582197,
 67740,
 -54935,
 694640697,
 67732,
 -54934,
 694704270,
 67730,
 -54933,
 694767066,
 67728,
 -54932,
 694831938,
 67726,
 -54931,
 694893707,
 67718,
 -54930,
 694950312,
 67714,
 -1,
 695013941,
 67712,
 695216500,
 694515746,
 -1,
 695282035,
 695144209,
 -1,
 -54926,
 695228547,
 67734,
 -1,
 695281570,
 67737,
 -1,
 695221805,
 67741,
 695544183,
 695173454,
 -1,
 -54922,
 695480719,
 67723,
 -1,
 695539697,
 67742,
 695740793,
 695483531,
 67719,
 -1,
 695698205,
 67722,
 695871868,
 695668497,
 -1,
 -54917,
 695834560,
 67735,
 -1,
 695882141,
 67713,
 -54915,
 695834871,
 67721,
 -54914,
 696031321,
 67725,
 -54913,
 696095204,
 67720,
 -54912,
 696152675,
 67739,
 -54911,
 696217186,
 67738,
 -54910,
 696281676,
 67736,
 -54909,
 696344633,
 67733,
 -54908,
 696408206,
 67731,
 -54907,
 696471002,
 67729,
 -54906,
 696535874,
 67727,
 -54905,
 696596912,
 67716,
 -54904,
 696657464,
 67717,
 -1,
 696719784,
 67715,
 696920469,
 694444020,
 -1,
 696986000,
 696877390,
 -1,
 697051534,
 696946969,
 -1,
 -54899,
 697000037,
 67752,
 -1,
 697053155,
 67758,
 -54897,
 696991570,
 67753,
 -1,
 697183982,
 67757,
 697379218,
 696935172,
 67751,
 -1,
 697303598,
 67759,
 697565183,
 697316134,
 -1,
 -54892,
 697460490,
 67754,
 -1,
 697518303,
 67756,
 -1,
 696853629,
 67755,
 -54889,
 694393058,
 129535,
 -54888,
 697732492,
 129314,
 -54887,
 697795845,
 127966,
 -54886,
 697849811,
 128219,
 -54885,
 697912003,
 983092,
 -1,
 697975650,
 128133,
 698165706,
 694313061,
 -1,
 698231218,
 698117964,
 -1,
 698296753,
 698188573,
 -1,
 698362288,
 698220544,
 -1,
 698427816,
 698323591,
 -1,
 698493349,
 698379313,
 -1,
 -54877,
 698454083,
 128600,
 -54876,
 698503055,
 128592,
 -1,
 698555588,
 128608,
 698755495,
 698451659,
 11110,
 -1,
 698680659,
 11126,
 -1,
 698710292,
 129108,
 699006975,
 698362928,
 -1,
 699017645,
 698903601,
 -1,
 -54869,
 698978371,
 128602,
 -54868,
 699027343,
 128594,
 -1,
 699079876,
 128610,
 699279791,
 698975947,
 11111,
 -1,
 699204947,
 11127,
 -1,
 699234580,
 129109,
 -1,
 698297432,
 128746,
 -1,
 698230763,
 8379,
 699607485,
 698155008,
 -1,
 699673014,
 699558097,
 -1,
 -54859,
 699615054,
 128370,
 -1,
 699673861,
 128695,
 699869625,
 699602978,
 -1,
 -54856,
 699822347,
 983126,
 -1,
 699875730,
 128691,
 -54854,
 699825619,
 128685,
 -54853,
 700015464,
 128286,
 -54852,
 700078617,
 128245,
 -1,
 700133336,
 128683,
 700328391,
 699564366,
 -1,
 700393924,
 700263263,
 128456,
 700459457,
 700324835,
 128211,
 -1,
 700384767,
 128212,
 700645375,
 700384207,
 -1,
 -54845,
 700528781,
 128457,
 -1,
 700589407,
 128458,
 700841983,
 700325804,
 -1,
 -54842,
 700740600,
 128324,
 -1,
 700796969,
 128323,
 -54840,
 700283259,
 128067,
 -54839,
 700930969,
 128689,
 -1,
 700996098,
 65934,
 701180367,
 698109040,
 -1,
 701245902,
 701113695,
 -1,
 -54835,
 701195696,
 2046,
 -1,
 701240400,
 2045,
 -1,
 701203019,
 2047,
 701508050,
 701110306,
 -1,
 -54831,
 701464124,
 983196,
 -1,
 701512391,
 983127,
 -54829,
 701455379,
 983227,
 -54828,
 701648119,
 983066,
 -1,
 701711003,
 127747,
 701901891,
 652950215,
 -1,
 701967235,
 701836127,
 -1,
 702032687,
 701915063,
 -1,
 702097923,
 701975235,
 -1,
 702163430,
 702025547,
 -1,
 702228957,
 702089558,
 110615,
 -54820,
 702155094,
 110625,
 -1,
 702220486,
 110624,
 -54818,
 702172090,
 110626,
 -54817,
 702353030,
 110623,
 -54816,
 702418439,
 110622,
 -54815,
 702483809,
 110621,
 -54814,
 702549193,
 110620,
 -54813,
 702614559,
 110619,
 -54812,
 702679939,
 110618,
 -54811,
 702745290,
 110617,
 -1,
 702810610,
 110616,
 703015407,
 702103779,
 -1,
 -54808,
 702942727,
 110634,
 -54807,
 703008097,
 110633,
 -54806,
 703073481,
 110632,
 -54805,
 703138847,
 110631,
 -54804,
 703204227,
 110630,
 -54803,
 703269578,
 110629,
 -54802,
 703334898,
 110628,
 -1,
 703400278,
 110627,
 703605239,
 702974186,
 -1,
 -54799,
 703532385,
 110641,
 -54798,
 703597769,
 110640,
 -54797,
 703663135,
 110639,
 -54796,
 703728515,
 110638,
 -54795,
 703793866,
 110637,
 -54794,
 703859186,
 110636,
 -1,
 703924566,
 110635,
 704129534,
 703540185,
 -1,
 -54791,
 704056521,
 110647,
 -54790,
 704121887,
 110646,
 -54789,
 704187267,
 110645,
 -54788,
 704252618,
 110644,
 -54787,
 704317938,
 110643,
 -1,
 704383318,
 110642,
 704643071,
 704077989,
 -1,
 -54784,
 704531471,
 110651,
 -54783,
 704580298,
 110650,
 -54782,
 704645618,
 110649,
 -1,
 704710998,
 110648,
 704916013,
 702036679,
 -1,
 704981520,
 704843595,
 -1,
 705047048,
 704907606,
 110750,
 -54777,
 704973142,
 110760,
 -1,
 705038534,
 110759,
 -54775,
 704974470,
 110758,
 -54774,
 705170951,
 110757,
 -54773,
 705236321,
 110756,
 -54772,
 705301705,
 110755,
 -54771,
 705367071,
 110754,
 -54770,
 705432451,
 110753,
 -54769,
 705497802,
 110752,
 -1,
 705563122,
 110751,
 705767961,
 704929957,
 -1,
 -54766,
 705695239,
 110785,
 -54765,
 705760609,
 110784,
 -54764,
 705825993,
 110783,
 -54763,
 705891359,
 110782,
 -54762,
 705956739,
 110781,
 -54761,
 706022090,
 110780,
 -54760,
 706087410,
 110779,
 -1,
 706152790,
 110778,
 706357793,
 705708259,
 -1,
 -54757,
 706284897,
 110767,
 -54756,
 706350281,
 110766,
 -54755,
 706415647,
 110765,
 -54754,
 706481027,
 110764,
 -54753,
 706546378,
 110763,
 -54752,
 706611698,
 110762,
 -1,
 706677078,
 110761,
 706882089,
 706292697,
 -1,
 -54749,
 706809185,
 110777,
 -54748,
 706874569,
 110776,
 -54747,
 706939935,
 110775,
 -54746,
 707005315,
 110774,
 -54745,
 707070666,
 110773,
 -54744,
 707135986,
 110772,
 -1,
 707201366,
 110771,
 707461119,
 706840810,
 -1,
 -54741,
 707332810,
 110770,
 -54740,
 707398130,
 110769,
 -1,
 707463510,
 110768,
 707668565,
 704870434,
 -1,
 707734071,
 707627242,
 -1,
 -54736,
 707661319,
 110673,
 -54735,
 707726689,
 110672,
 -54734,
 707792073,
 110671,
 -54733,
 707857439,
 110670,
 -54732,
 707922819,
 110669,
 -54731,
 707988170,
 110668,
 -54730,
 708053490,
 110667,
 -1,
 708118870,
 110666,
 708323904,
 707661643,
 -1,
 -54727,
 708251143,
 110659,
 -54726,
 708316513,
 110658,
 -54725,
 708381897,
 110657,
 -54724,
 708447263,
 110656,
 -54723,
 708512643,
 110655,
 -54722,
 708577994,
 110654,
 -54721,
 708643314,
 110653,
 -1,
 708708694,
 110652,
 708913736,
 708272293,
 -1,
 -54718,
 708840801,
 110685,
 -54717,
 708906185,
 110684,
 -54716,
 708971551,
 110683,
 -54715,
 709036931,
 110682,
 -54714,
 709102282,
 110681,
 -54713,
 709167602,
 110680,
 -1,
 709232982,
 110679,
 709438031,
 708853987,
 -1,
 -54710,
 709364937,
 110665,
 -54709,
 709430303,
 110664,
 -54708,
 709495683,
 110663,
 -54707,
 709561034,
 110662,
 -54706,
 709626354,
 110661,
 -1,
 709691734,
 110660,
 709951487,
 709372889,
 -1,
 -54703,
 709823519,
 110678,
 -54702,
 709888899,
 110677,
 -54701,
 709954250,
 110676,
 -54700,
 710019570,
 110675,
 -1,
 710084950,
 110674,
 710290046,
 707615575,
 -1,
 710355552,
 710217547,
 -1,
 -54696,
 710282886,
 110726,
 -54695,
 710348295,
 110725,
 -54694,
 710413665,
 110724,
 -54693,
 710479049,
 110723,
 -54692,
 710544415,
 110722,
 -54691,
 710609795,
 110721,
 -54690,
 710675146,
 110720,
 -54689,
 710740466,
 110719,
 -1,
 710805846,
 110718,
 711010921,
 710295779,
 -1,
 -54686,
 710967941,
 110734,
 -54685,
 711003489,
 110733,
 -54684,
 711068873,
 110732,
 -54683,
 711134239,
 110731,
 -54682,
 711199619,
 110730,
 -54681,
 711264970,
 110729,
 -54680,
 711330290,
 110728,
 -1,
 711395670,
 110727,
 711600753,
 710945753,
 -1,
 -54677,
 711543917,
 110744,
 -54676,
 711593161,
 110743,
 -54675,
 711658527,
 110742,
 -54674,
 711723907,
 110741,
 -54673,
 711789258,
 110740,
 -54672,
 711854578,
 110739,
 -1,
 711919958,
 110738,
 712125047,
 711549093,
 -1,
 -54669,
 712051743,
 110749,
 -54668,
 712117123,
 110748,
 -54667,
 712182474,
 110747,
 -54666,
 712247794,
 110746,
 -1,
 712313174,
 110745,
 712518267,
 712083690,
 -1,
 -54663,
 712444618,
 110737,
 -54662,
 712509938,
 110736,
 -1,
 712575318,
 110735,
 712835071,
 712444026,
 -1,
 -54659,
 712706546,
 110878,
 -1,
 712771926,
 110877,
 712977060,
 710246734,
 -1,
 713042569,
 712911833,
 -1,
 -54655,
 712969862,
 110710,
 -54654,
 713035271,
 110709,
 -54653,
 713100641,
 110708,
 -54652,
 713166025,
 110707,
 -54651,
 713231391,
 110706,
 -54650,
 713296771,
 110705,
 -54649,
 713362122,
 110704,
 -54648,
 713427442,
 110703,
 -1,
 713492822,
 110702,
 713697937,
 712990885,
 -1,
 -54645,
 713650073,
 110717,
 -54644,
 713690313,
 110716,
 -54643,
 713755679,
 110715,
 -54642,
 713821059,
 110714,
 -54641,
 713886410,
 110713,
 -54640,
 713951730,
 110712,
 -1,
 714017110,
 110711,
 714222233,
 713638115,
 -1,
 -54637,
 714149217,
 110696,
 -54636,
 714214601,
 110695,
 -54635,
 714279967,
 110694,
 -54634,
 714345347,
 110693,
 -54633,
 714410698,
 110692,
 -54632,
 714476018,
 110691,
 -1,
 714541398,
 110690,
 714746527,
 714180842,
 -1,
 -54629,
 714704197,
 110701,
 -54628,
 714738563,
 110700,
 -54627,
 714803914,
 110699,
 -54626,
 714869234,
 110698,
 -1,
 714934614,
 110697,
 715194367,
 714673995,
 -1,
 -54623,
 715066243,
 110689,
 -54622,
 715131594,
 110688,
 -54621,
 715196914,
 110687,
 -1,
 715262294,
 110686,
 715467461,
 712929100,
 -1,
 715532973,
 715407587,
 -1,
 -54617,
 715459937,
 110839,
 -54616,
 715525321,
 110838,
 -54615,
 715590687,
 110837,
 -54614,
 715656067,
 110836,
 -54613,
 715721418,
 110835,
 -54612,
 715786738,
 110834,
 -1,
 715852118,
 110833,
 716057268,
 715491562,
 -1,
 -54609,
 715984073,
 110845,
 -54608,
 716049439,
 110844,
 -54607,
 716114819,
 110843,
 -54606,
 716180170,
 110842,
 -54605,
 716245490,
 110841,
 -1,
 716310870,
 110840,
 716516027,
 716005541,
 -1,
 -54602,
 716442825,
 110855,
 -54601,
 716508191,
 110854,
 -54600,
 716573571,
 110853,
 -54599,
 716638922,
 110852,
 -54598,
 716704242,
 110851,
 -1,
 716769622,
 110850,
 716974784,
 716450777,
 -1,
 -54595,
 716901251,
 110849,
 -54594,
 716966602,
 110848,
 -54593,
 717031922,
 110847,
 -1,
 717097302,
 110846,
 717357055,
 716902219,
 -1,
 -54590,
 717228931,
 110832,
 -54589,
 717294282,
 110831,
 -54588,
 717359602,
 110830,
 -1,
 717424982,
 110829,
 717630182,
 715413012,
 -1,
 717695694,
 717570275,
 -1,
 -54584,
 717622625,
 110799,
 -54583,
 717688009,
 110798,
 -54582,
 717753375,
 110797,
 -54581,
 717818755,
 110796,
 -54580,
 717884106,
 110795,
 -54579,
 717949426,
 110794,
 -1,
 718014806,
 110793,
 718219990,
 717623115,
 -1,
 -54576,
 718146913,
 110792,
 -54575,
 718212297,
 110791,
 -54574,
 718277663,
 110790,
 -54573,
 718343043,
 110789,
 -54572,
 718408394,
 110788,
 -54571,
 718473714,
 110787,
 -1,
 718539094,
 110786,
 718744285,
 718168229,
 -1,
 -54568,
 718671049,
 110812,
 -54567,
 718736415,
 110811,
 -54566,
 718801795,
 110810,
 -54565,
 718867146,
 110809,
 -54564,
 718932466,
 110808,
 -1,
 718997846,
 110807,
 719203042,
 718702826,
 -1,
 -54561,
 719129475,
 110803,
 -54560,
 719194826,
 110802,
 -54559,
 719260146,
 110801,
 -1,
 719325526,
 110800,
 719585279,
 719137753,
 -1,
 -54556,
 719476318,
 110806,
 -54555,
 719522290,
 110805,
 -1,
 719587670,
 110804,
 719792896,
 717590809,
 -1,
 719858415,
 719741093,
 -1,
 -54551,
 719785313,
 110876,
 -54550,
 719850697,
 110875,
 -54549,
 719916063,
 110874,
 -54548,
 719981443,
 110873,
 -54547,
 720046794,
 110872,
 -54546,
 720112114,
 110871,
 -1,
 720177494,
 110870,
 720382709,
 719798499,
 -1,
 -54543,
 720309279,
 110865,
 -54542,
 720374659,
 110864,
 -54541,
 720440010,
 110863,
 -54540,
 720505330,
 110862,
 -1,
 720570710,
 110861,
 720775931,
 720310091,
 -1,
 -54537,
 720702495,
 110860,
 -54536,
 720767875,
 110859,
 -54535,
 720833226,
 110858,
 -54534,
 720898546,
 110857,
 -1,
 720963926,
 110856,
 721223679,
 720710617,
 -1,
 -54531,
 721095555,
 110869,
 -54530,
 721160906,
 110868,
 -54529,
 721226226,
 110867,
 -1,
 721291606,
 110866,
 721496852,
 719754925,
 -1,
 721562376,
 721445029,
 -1,
 -54525,
 721489097,
 110828,
 -54524,
 721554463,
 110827,
 -54523,
 721619843,
 110826,
 -54522,
 721685194,
 110825,
 -54521,
 721750514,
 110824,
 -1,
 721815894,
 110823,
 722021135,
 721489739,
 -1,
 -54518,
 721983574,
 110818,
 -54517,
 722013215,
 110817,
 -54516,
 722078595,
 110816,
 -54515,
 722143946,
 110815,
 -54514,
 722209266,
 110814,
 -1,
 722274646,
 110813,
 722534399,
 721979626,
 -1,
 -54511,
 722406275,
 110822,
 -54510,
 722471626,
 110821,
 -54509,
 722536946,
 110820,
 -1,
 722602326,
 110819,
 722807579,
 721431513,
 -1,
 -54506,
 722734281,
 110611,
 -54505,
 722799647,
 110610,
 -54504,
 722865027,
 110609,
 -54503,
 722930378,
 110608,
 -54502,
 722995698,
 110607,
 -1,
 723061078,
 983266,
 723266337,
 722766058,
 -1,
 -54499,
 723192863,
 110606,
 -54498,
 723258243,
 110605,
 -54497,
 723323594,
 110604,
 -54496,
 723388914,
 110603,
 -1,
 723454294,
 110602,
 723659558,
 723206371,
 -1,
 -54493,
 723585923,
 110601,
 -54492,
 723651274,
 110600,
 -54491,
 723716594,
 110599,
 -1,
 723781974,
 110598,
 723987243,
 723586891,
 -1,
 -54488,
 723948758,
 110597,
 -54487,
 723978954,
 110596,
 -54486,
 724044274,
 110595,
 -1,
 724109654,
 110594,
 724369407,
 723935397,
 -1,
 -54483,
 724241098,
 110614,
 -54482,
 724306418,
 110613,
 -1,
 724371798,
 110612,
 724577151,
 701959953,
 -1,
 724642678,
 724537621,
 -1,
 724708160,
 724596770,
 -1,
 724773689,
 724658125,
 -1,
 724839222,
 724734605,
 -1,
 -54475,
 724799555,
 128605,
 -1,
 724835524,
 128613,
 725090303,
 724773942,
 -1,
 -54472,
 724996163,
 128607,
 -1,
 725032132,
 128615,
 725232444,
 724715904,
 -1,
 -54469,
 725188238,
 128952,
 -1,
 725249054,
 128972,
 725429055,
 725159697,
 -1,
 -54466,
 725376848,
 128635,
 -1,
 725439967,
 128940,
 -1,
 725361685,
 128625,
 725691209,
 724651255,
 -1,
 725756740,
 725641311,
 -1,
 -54461,
 725712036,
 10079,
 -1,
 725756157,
 10080,
 725953351,
 725691838,
 -1,
 -54458,
 725896748,
 129052,
 -1,
 725954655,
 129048,
 -54456,
 725893681,
 128627,
 -1,
 726079292,
 128327,
 726281041,
 725618449,
 -1,
 726346576,
 726235036,
 -1,
 726412111,
 726295300,
 129180,
 726532095,
 726335488,
 -1,
 -54450,
 726434674,
 129183,
 -1,
 726481757,
 129182,
 -1,
 726370416,
 129181,
 -1,
 726293191,
 128628,
 726805336,
 726228690,
 -1,
 726870869,
 726766221,
 -1,
 -54444,
 726831171,
 128604,
 -1,
 726867140,
 128612,
 727121919,
 726805558,
 -1,
 -54441,
 727027779,
 128606,
 -1,
 727063748,
 128614,
 727264095,
 726738271,
 -1,
 727329630,
 727212133,
 -1,
 727395165,
 727291074,
 -1,
 -54436,
 727338540,
 129055,
 -1,
 727396447,
 129051,
 -1,
 727340007,
 128178,
 -1,
 727271785,
 10135,
 727722852,
 727199238,
 -1,
 727788387,
 727673877,
 -1,
 -54430,
 727739204,
 128977,
 -1,
 727784206,
 128975,
 -1,
 727744142,
 128958,
 728050535,
 727683765,
 -1,
 -54426,
 728006306,
 128913,
 -1,
 728047662,
 128903,
 728247146,
 728009905,
 -1,
 -54423,
 728190508,
 129053,
 -1,
 728248415,
 129049,
 728443757,
 728205342,
 -1,
 -54420,
 728394564,
 128980,
 -1,
 728439566,
 128979,
 728640368,
 728397021,
 -1,
 -54417,
 728583724,
 129054,
 -1,
 728641631,
 129050,
 728836979,
 728577284,
 -1,
 -54414,
 728792718,
 128946,
 -1,
 728853534,
 128970,
 -54412,
 728787964,
 10133,
 -54411,
 728979959,
 10134,
 -1,
 729040508,
 128633,
 729230206,
 724594508,
 -1,
 729295741,
 729186640,
 -1,
 729361276,
 729256855,
 -1,
 -54406,
 729318678,
 127892,
 -54405,
 729379614,
 128157,
 -1,
 729421276,
 128152,
 -1,
 729294563,
 128159,
 -1,
 729221250,
 128585,
 -1,
 729164510,
 127911,
 -54400,
 724529341,
 127807,
 -54399,
 729764546,
 128641,
 -54398,
 729819017,
 129428,
 -1,
 729881712,
 1519,
 730082306,
 701894417,
 -1,
 730147797,
 730028887,
 -1,
 730213320,
 730087902,
 -1,
 730278827,
 730157481,
 -1,
 730344333,
 730221251,
 -1,
 730409867,
 730285597,
 -1,
 -54390,
 730371848,
 68889,
 -1,
 730435889,
 68887,
 -54388,
 730348245,
 68872,
 -1,
 730533649,
 68881,
 730737553,
 730291031,
 -1,
 -54385,
 730699528,
 68891,
 -54384,
 730740706,
 68890,
 -1,
 730795793,
 68885,
 730999700,
 730693966,
 -1,
 -54381,
 730956246,
 68868,
 -1,
 730992401,
 68867,
 731196311,
 730953762,
 -1,
 -54378,
 731134677,
 68880,
 -1,
 731189009,
 68879,
 731392922,
 731148108,
 -1,
 -54375,
 731344793,
 68877,
 -1,
 731385617,
 68876,
 731589533,
 731325791,
 -1,
 -54372,
 731522539,
 68875,
 -1,
 731582225,
 68874,
 -54370,
 731551866,
 68878,
 -54369,
 731748104,
 68888,
 -54368,
 731812145,
 68886,
 -54367,
 731876935,
 68892,
 -54366,
 731932939,
 68866,
 -54365,
 731993694,
 68884,
 -54364,
 732056905,
 68883,
 -54363,
 732121626,
 68869,
 -54362,
 732183253,
 68871,
 -54361,
 732248034,
 68882,
 -54360,
 732312394,
 68873,
 -54359,
 732372307,
 68870,
 -54358,
 732436531,
 68865,
 -1,
 732499729,
 68864,
 732703673,
 730212345,
 -1,
 732769199,
 732660046,
 -1,
 -54354,
 732730582,
 68914,
 -1,
 732774226,
 68915,
 732965810,
 732723234,
 -1,
 -54351,
 732907901,
 68918,
 -1,
 732967478,
 68919,
 733162421,
 732902182,
 -1,
 -54348,
 733112074,
 68916,
 -1,
 733169887,
 68917,
 -54346,
 733124871,
 68912,
 -54345,
 733307652,
 68913,
 -54344,
 733371842,
 68921,
 -1,
 733425152,
 68920,
 733621183,
 732664006,
 -1,
 -54341,
 733579415,
 68895,
 -54340,
 733634661,
 68897,
 -54339,
 733691997,
 68894,
 -54338,
 733752159,
 68896,
 -1,
 733810449,
 68893,
 734014405,
 733576272,
 -1,
 734079940,
 733970902,
 -1,
 -54334,
 734035698,
 68903,
 -54333,
 734092208,
 68902,
 -1,
 734149450,
 68901,
 -1,
 734018640,
 68900,
 734461951,
 733960008,
 -1,
 -54329,
 734361787,
 68898,
 -1,
 734419907,
 68899,
 734604239,
 730151559,
 -1,
 734669774,
 734566293,
 -1,
 734735309,
 734612163,
 -1,
 -54324,
 734677474,
 983209,
 -1,
 734739934,
 983212,
 -1,
 734691032,
 983210,
 -1,
 734625508,
 983211,
 735117311,
 734537055,
 -1,
 735128531,
 734992435,
 -1,
 -54318,
 735073235,
 129342,
 -1,
 735131561,
 128092,
 -54316,
 735083263,
 129309,
 -1,
 735250114,
 129310,
 735456249,
 730104142,
 -1,
 735521784,
 735408196,
 -1,
 735587313,
 735465897,
 -1,
 735652829,
 735541282,
 -1,
 735718364,
 735579921,
 -1,
 -54309,
 735664259,
 67822,
 -1,
 735717282,
 67825,
 -1,
 735657517,
 67828,
 735980512,
 735609166,
 -1,
 -54305,
 735916431,
 67816,
 -1,
 735975409,
 67829,
 736177122,
 735919243,
 67812,
 -1,
 736133917,
 67815,
 736308197,
 736104209,
 -1,
 -54300,
 736270411,
 67823,
 -1,
 736317853,
 67808,
 -54298,
 736270589,
 67814,
 -54297,
 736467033,
 67817,
 -54296,
 736530916,
 67813,
 -54295,
 736587362,
 67826,
 -54294,
 736651852,
 67824,
 -54293,
 736714809,
 67821,
 -54292,
 736778382,
 67820,
 -54291,
 736841178,
 67819,
 -54290,
 736906050,
 67818,
 -54289,
 736967088,
 67810,
 -54288,
 737027647,
 67811,
 -1,
 737089960,
 67809,
 737345535,
 735535092,
 -1,
 737356789,
 737247566,
 -1,
 -54284,
 737317478,
 67838,
 -1,
 737357550,
 67837,
 737553399,
 737305348,
 67835,
 -1,
 737477166,
 67839,
 -1,
 737490175,
 67836,
 -1,
 735453178,
 128035,
 737815550,
 735401492,
 -1,
 737881084,
 737761467,
 128296,
 -1,
 737804377,
 128736,
 -54275,
 737836962,
 128057,
 -1,
 737942762,
 127828,
 -54273,
 737767646,
 128436,
 -54272,
 738094357,
 128587,
 -54271,
 738150342,
 128135,
 -1,
 738207565,
 11233,
 738405415,
 730030181,
 -1,
 738470930,
 738357068,
 -1,
 738536462,
 738413036,
 -1,
 738601997,
 738492750,
 -1,
 738667532,
 738529158,
 -1,
 738733067,
 738626242,
 983059,
 738852863,
 738656256,
 -1,
 -54262,
 738759619,
 983140,
 -1,
 738818673,
 983137,
 -1,
 738656869,
 11134,
 -1,
 738619323,
 128677,
 -1,
 738532067,
 11203,
 739246079,
 738490747,
 128014,
 739311615,
 739115008,
 -1,
 -54255,
 739209136,
 127943,
 -1,
 739259213,
 128052,
 739453976,
 738429079,
 -1,
 739519511,
 739408254,
 -1,
 739585046,
 739450064,
 127968,
 -1,
 739538978,
 127960,
 -1,
 739546039,
 127969,
 -1,
 739472114,
 9203,
 739847197,
 739410254,
 -1,
 739912732,
 739770368,
 -1,
 -54245,
 739863235,
 127798,
 -1,
 739911769,
 127789,
 -1,
 739847776,
 127976,
 740174881,
 739790071,
 -1,
 740240416,
 740119874,
 128616,
 -1,
 740164157,
 128617,
 -1,
 740174687,
 128371,
 740437028,
 740121914,
 -1,
 -54237,
 740366659,
 128029,
 -1,
 740426779,
 127855,
 -54235,
 740392576,
 127973,
 -54234,
 740583633,
 983123,
 -1,
 740630534,
 128298,
 740830267,
 738345053,
 -1,
 740895792,
 740782024,
 -1,
 740961327,
 740825634,
 -1,
 -54229,
 740919447,
 983980,
 -54228,
 740974693,
 983982,
 -54227,
 741032029,
 983979,
 -54226,
 741092191,
 983981,
 -1,
 741150481,
 983978,
 -1,
 740889889,
 110593,
 741420088,
 740833574,
 -1,
 741485621,
 741345309,
 -1,
 741551156,
 741441134,
 128644,
 -1,
 741475733,
 128645,
 -1,
 741489997,
 128096,
 741801983,
 741408768,
 -1,
 -54217,
 741695743,
 983122,
 -1,
 741743746,
 128262,
 -54215,
 741371137,
 129435,
 -54214,
 741887012,
 129406,
 -1,
 741939842,
 127802,
 742140991,
 740788375,
 -1,
 -54211,
 742095674,
 128559,
 -54210,
 742153341,
 128175,
 -1,
 742209778,
 129303,
 742403138,
 742097230,
 983060,
 -54207,
 742357026,
 983138,
 -1,
 742410741,
 983141,
 -1,
 742365092,
 11226,
 742665895,
 701851857,
 -1,
 742731158,
 742592273,
 -1,
 742796542,
 742669430,
 -1,
 742861947,
 742726967,
 -1,
 742927456,
 742810650,
 -1,
 742992976,
 742873943,
 -1,
 743058508,
 742949198,
 -1,
 -54197,
 743012680,
 92957,
 -1,
 743062638,
 92971,
 -54195,
 743001790,
 92960,
 -54194,
 743197595,
 92962,
 -54193,
 743251844,
 92968,
 -1,
 743315351,
 92972,
 743517268,
 742931143,
 -1,
 -54190,
 743463946,
 92969,
 -54189,
 743526078,
 92965,
 -1,
 743577495,
 92959,
 743779415,
 743447863,
 -1,
 -54186,
 743717998,
 92967,
 -1,
 743774103,
 92975,
 -54184,
 743741244,
 92964,
 -54183,
 743937580,
 92974,
 -54182,
 744001126,
 92956,
 -54181,
 744059030,
 92961,
 -54180,
 744123989,
 92963,
 -54179,
 744188873,
 92970,
 -54178,
 744249221,
 92966,
 -54177,
 744312510,
 92958,
 -1,
 744363927,
 92973,
 744620031,
 742870505,
 -1,
 744631399,
 744522062,
 -1,
 744696934,
 744585250,
 -1,
 -54172,
 744657422,
 93069,
 -54171,
 744701244,
 93053,
 -1,
 744755078,
 93062,
 -1,
 744636080,
 93061,
 745024619,
 744573635,
 -1,
 -54167,
 744985739,
 93070,
 -54166,
 745038931,
 93058,
 -1,
 745093862,
 93064,
 745286766,
 744986285,
 -1,
 -54163,
 745221422,
 93054,
 -1,
 745279962,
 93068,
 745483377,
 745246261,
 -1,
 -54160,
 745444485,
 93071,
 -1,
 745476570,
 93066,
 745679988,
 745426167,
 -1,
 -54157,
 745621482,
 93055,
 -1,
 745674673,
 93056,
 745876599,
 745618133,
 -1,
 -54154,
 745837701,
 93059,
 -1,
 745887252,
 93065,
 -54152,
 745838247,
 93057,
 -54151,
 746023689,
 93063,
 -54150,
 746085148,
 93060,
 -1,
 746140532,
 93067,
 746335406,
 742816848,
 -1,
 746400903,
 746266665,
 -1,
 746466433,
 746357070,
 -1,
 746531968,
 746428067,
 93044,
 -1,
 746455380,
 93045,
 -1,
 746487348,
 92997,
 746728580,
 746396983,
 -1,
 -54141,
 746686795,
 93043,
 -1,
 746732889,
 92985,
 -54139,
 746679680,
 93046,
 -54138,
 746872642,
 93047,
 -1,
 746928916,
 93042,
 747121809,
 746362354,
 -1,
 747187343,
 747083437,
 -1,
 747252878,
 747121979,
 -1,
 -54133,
 747210245,
 92990,
 -54132,
 747270923,
 92989,
 -54131,
 747331556,
 92988,
 -1,
 747385711,
 92991,
 -1,
 747201619,
 93028,
 -54128,
 747127023,
 93034,
 -1,
 747575225,
 92996,
 747777179,
 747081921,
 -1,
 747842711,
 747733326,
 -1,
 747908246,
 747780807,
 -1,
 -54123,
 747856437,
 92983,
 -1,
 747913455,
 92986,
 -1,
 747862763,
 92984,
 -54120,
 747796913,
 92992,
 -54119,
 748117835,
 92994,
 -54118,
 748180981,
 93027,
 -1,
 748237757,
 92987,
 748432543,
 747733326,
 -1,
 -54115,
 748394050,
 93037,
 -54114,
 748437084,
 93030,
 -1,
 748492695,
 93039,
 748694692,
 748377620,
 -1,
 748760227,
 748629298,
 -1,
 -54110,
 748717915,
 93038,
 -1,
 748781733,
 92993,
 -1,
 748719489,
 93041,
 749022375,
 748641111,
 -1,
 -54106,
 748980125,
 93035,
 -1,
 749039198,
 93033,
 749218986,
 748960455,
 -1,
 -54103,
 749166570,
 93032,
 -1,
 749228716,
 93029,
 -54101,
 749181240,
 93031,
 -54100,
 749360326,
 93040,
 -54099,
 749420862,
 92995,
 -1,
 749475784,
 93036,
 749677785,
 746295501,
 -1,
 749743294,
 749604625,
 -1,
 749808819,
 749703449,
 -1,
 -54094,
 749768245,
 92943,
 -1,
 749803554,
 92942,
 750005430,
 749766807,
 -1,
 -54091,
 749964853,
 92933,
 -1,
 750000162,
 92932,
 750202041,
 749944925,
 -1,
 -54088,
 750161461,
 92939,
 -1,
 750196770,
 92938,
 750398652,
 750128913,
 -1,
 -54085,
 750358069,
 92955,
 -1,
 750393378,
 92954,
 -54083,
 750358069,
 92951,
 -1,
 750524450,
 92950,
 750726340,
 749701271,
 -1,
 750791874,
 750653201,
 -1,
 -54079,
 750751285,
 92945,
 -1,
 750786594,
 92944,
 -54077,
 750751285,
 92935,
 -1,
 750917666,
 92934,
 751119562,
 750674021,
 -1,
 751185096,
 751067237,
 -1,
 -54073,
 751144501,
 92941,
 -1,
 751179810,
 92940,
 -54071,
 751144501,
 92947,
 -1,
 751310882,
 92946,
 751512784,
 751059037,
 -1,
 751578318,
 751439633,
 -1,
 -54067,
 751537717,
 92949,
 -1,
 751573026,
 92948,
 -54065,
 751537717,
 92931,
 -1,
 751704098,
 92930,
 751906006,
 751446879,
 -1,
 751971540,
 751840095,
 -1,
 -54061,
 751930933,
 92929,
 -1,
 751966242,
 92928,
 -54059,
 751930933,
 92937,
 -1,
 752097314,
 92936,
 752353279,
 751866137,
 -1,
 -54056,
 752258613,
 92953,
 -1,
 752293922,
 92952,
 752495847,
 749611001,
 -1,
 752561373,
 752451918,
 -1,
 -54052,
 752522454,
 93010,
 -1,
 752566098,
 93011,
 752757984,
 752515106,
 -1,
 -54049,
 752699773,
 93014,
 -1,
 752759350,
 93015,
 752954595,
 752694054,
 -1,
 -54046,
 752903946,
 93012,
 -1,
 752961759,
 93013,
 -54044,
 752916743,
 93008,
 -54043,
 753099524,
 93009,
 -54042,
 753163714,
 93017,
 -1,
 753217024,
 93016,
 753413363,
 752443380,
 -1,
 753478895,
 753369422,
 -1,
 753544430,
 753413870,
 -1,
 753609965,
 753467392,
 -1,
 -54036,
 753566621,
 93021,
 -1,
 753605194,
 93024,
 -1,
 753563682,
 93019,
 -1,
 753497383,
 93025,
 753937650,
 753418256,
 -1,
 -54031,
 753891362,
 93020,
 -1,
 753926859,
 93023,
 -1,
 753883580,
 93022,
 754253823,
 753358670,
 -1,
 754265335,
 754155854,
 -1,
 -54026,
 754223453,
 92976,
 -1,
 754259893,
 92982,
 754461946,
 754219042,
 -1,
 -54023,
 754420039,
 92980,
 -1,
 754475109,
 92977,
 754658557,
 754404035,
 -1,
 -54020,
 754596978,
 92979,
 -1,
 754659628,
 92978,
 -1,
 754597562,
 92981,
 754920775,
 742754460,
 -1,
 754986290,
 754863351,
 -1,
 755051821,
 754921880,
 -1,
 755117325,
 754987814,
 -1,
 755182860,
 755057674,
 -1,
 755248389,
 755129175,
 72416,
 -1,
 755185577,
 72419,
 -54010,
 755209901,
 72420,
 -54009,
 755339545,
 72418,
 -54008,
 755401038,
 72414,
 -54007,
 755460305,
 72412,
 -54006,
 755521044,
 72415,
 -54005,
 755584247,
 72417,
 -1,
 755649219,
 72413,
 -1,
 755109649,
 72403,
 755903759,
 755075223,
 72409,
 -1,
 755830545,
 72410,
 756034834,
 755859790,
 -1,
 -53999,
 755972821,
 72399,
 -1,
 756027153,
 72398,
 756231445,
 755984593,
 -1,
 -53996,
 756169429,
 72401,
 -1,
 756223761,
 72384,
 756428056,
 756177751,
 -1,
 -53993,
 756365282,
 72391,
 -1,
 756420369,
 72400,
 756624667,
 756370115,
 -1,
 -53990,
 756562645,
 72394,
 -1,
 756616977,
 72385,
 756821277,
 756564061,
 72407,
 -1,
 756748049,
 72411,
 756952352,
 756751671,
 -1,
 -53985,
 756890325,
 72404,
 -1,
 756944657,
 72397,
 -53983,
 756914298,
 72389,
 -53982,
 757108295,
 72390,
 -53981,
 757168286,
 72395,
 -53980,
 757231513,
 72402,
 -53979,
 757293157,
 72408,
 -53978,
 757356126,
 72387,
 -53977,
 757419337,
 72386,
 -53976,
 757480149,
 72392,
 -53975,
 757544930,
 72393,
 -53974,
 757607263,
 72406,
 -53973,
 757671403,
 72388,
 -53972,
 757733427,
 72396,
 -1,
 757796625,
 72405,
 758054911,
 755001451,
 72436,
 758120447,
 757923840,
 -1,
 758132017,
 758010983,
 72435,
 -1,
 758055396,
 72438,
 -1,
 758068281,
 72439,
 758328634,
 754940160,
 -1,
 758394168,
 758285693,
 72428,
 758513663,
 758317056,
 -1,
 758525239,
 758404199,
 72427,
 -1,
 758448612,
 72429,
 -1,
 758461497,
 72430,
 758775807,
 758331885,
 72423,
 -1,
 758645220,
 72426,
 758852927,
 758281741,
 72422,
 758972415,
 758775808,
 -1,
 758983998,
 758862951,
 72421,
 -1,
 758907364,
 72424,
 -1,
 758920249,
 72425,
 759180611,
 758798593,
 72431,
 759300095,
 759103488,
 -1,
 -53950,
 759190636,
 72433,
 -1,
 759247929,
 72434,
 759496703,
 759118317,
 72437,
 759562239,
 759365632,
 -1,
 -53946,
 759467614,
 72432,
 -1,
 759510073,
 72440,
 759704949,
 754865220,
 -1,
 759770483,
 759666789,
 -1,
 759836007,
 759713572,
 -1,
 759901542,
 759793535,
 -1,
 759967056,
 759855138,
 -1,
 760032591,
 759893777,
 -1,
 -53938,
 759978115,
 67695,
 -1,
 760031138,
 67698,
 -1,
 759971373,
 67701,
 760294739,
 759923022,
 -1,
 -53934,
 760230287,
 67688,
 -1,
 760289265,
 67702,
 760491349,
 760233099,
 67684,
 -1,
 760447773,
 67687,
 760622424,
 760418065,
 -1,
 -53929,
 760584128,
 67696,
 -1,
 760631709,
 67680,
 -53927,
 760584439,
 67686,
 -53926,
 760780889,
 67689,
 -53925,
 760844772,
 67685,
 -53924,
 760902243,
 67700,
 -53923,
 760966754,
 67699,
 -53922,
 761031244,
 67697,
 -53921,
 761094201,
 67694,
 -53920,
 761157774,
 67692,
 -53919,
 761220570,
 67691,
 -53918,
 761285442,
 67690,
 -53917,
 761346480,
 67682,
 -53916,
 761410702,
 67693,
 -53915,
 761472568,
 67683,
 -1,
 761534888,
 67681,
 -1,
 759838586,
 67703,
 761802098,
 759783412,
 -1,
 761867630,
 761758030,
 -1,
 761933164,
 761827609,
 -1,
 -53909,
 761880677,
 67706,
 -1,
 761933795,
 67711,
 -53907,
 761872210,
 67707,
 -1,
 762064622,
 67710,
 762260849,
 761803558,
 -1,
 -53904,
 762210058,
 67708,
 -1,
 762267871,
 67709,
 -1,
 762209028,
 67705,
 -1,
 761754742,
 67704,
 -53900,
 759724159,
 129330,
 -1,
 762512753,
 127796,
 762719615,
 759656268,
 -1,
 762785149,
 762675534,
 -1,
 762850684,
 762724621,
 -1,
 -53895,
 762809226,
 983149,
 -53894,
 762852889,
 983145,
 -53893,
 762915286,
 983146,
 -1,
 762976375,
 983148,
 -1,
 762812125,
 127881,
 -53890,
 762738455,
 129436,
 -1,
 763171153,
 11853,
 763374985,
 762656681,
 -1,
 763440520,
 763308895,
 128463,
 763506054,
 763363328,
 -1,
 763571589,
 763466653,
 -1,
 -53884,
 763530514,
 128195,
 -1,
 763578246,
 128479,
 -1,
 763507557,
 128196,
 -53881,
 763459618,
 128464,
 -1,
 763785036,
 128223,
 -1,
 763388184,
 128724,
 764030350,
 763330243,
 -1,
 764095885,
 763964255,
 -1,
 -53876,
 764042634,
 128755,
 -1,
 764093876,
 11261,
 -1,
 764046490,
 128706,
 764358033,
 763976535,
 -1,
 -53872,
 764290542,
 128060,
 -1,
 764353921,
 129374,
 764554643,
 764290399,
 983121,
 -1,
 764487689,
 983120,
 -53868,
 764514587,
 128062,
 -53867,
 764635886,
 128206,
 -1,
 764682518,
 128230,
 764882442,
 742673655,
 -1,
 764947969,
 764808977,
 -1,
 765013504,
 764909514,
 -1,
 765078975,
 764969294,
 -1,
 765144496,
 765032454,
 -1,
 765210022,
 765069654,
 127201,
 -53859,
 765136518,
 127219,
 -53858,
 765201927,
 127218,
 -53857,
 765267297,
 127217,
 -53856,
 765332681,
 127216,
 -53855,
 765398047,
 127215,
 -53854,
 765463427,
 127214,
 -53853,
 765528778,
 127213,
 -53852,
 765594098,
 127212,
 -53851,
 765659478,
 127211,
 -1,
 765724870,
 127210,
 765930921,
 765135346,
 127202,
 -53848,
 765856086,
 127221,
 -1,
 765921478,
 127220,
 -53846,
 765857414,
 127209,
 -53845,
 766053895,
 127208,
 -53844,
 766119265,
 127207,
 -53843,
 766184649,
 127206,
 -53842,
 766250015,
 127205,
 -53841,
 766315395,
 127204,
 -1,
 766380746,
 127203,
 766586293,
 765105397,
 -1,
 -53838,
 766541375,
 127138,
 -53837,
 766590202,
 127154,
 -53836,
 766650333,
 127170,
 -1,
 766714285,
 127186,
 766913978,
 766525312,
 -1,
 -53833,
 766869055,
 127139,
 -53832,
 766917882,
 127155,
 -53831,
 766978013,
 127171,
 -1,
 767041965,
 127187,
 767295487,
 766848766,
 -1,
 -53828,
 767196735,
 127146,
 -53827,
 767245562,
 127162,
 -53826,
 767305693,
 127178,
 -1,
 767369645,
 127194,
 767569356,
 765014822,
 -1,
 767634887,
 767516773,
 -1,
 767700422,
 767593714,
 -1,
 -53821,
 767655487,
 127140,
 -53820,
 767704314,
 127156,
 -53819,
 767764445,
 127172,
 -1,
 767828397,
 127188,
 -1,
 767648244,
 127200,
 768147455,
 767576339,
 -1,
 -53815,
 768048703,
 127141,
 -53814,
 768097530,
 127157,
 -53813,
 768157661,
 127173,
 -1,
 768221613,
 127189,
 768421335,
 767522850,
 -1,
 768486866,
 768362884,
 -1,
 -53809,
 768441919,
 127142,
 -53808,
 768490746,
 127158,
 -53807,
 768550877,
 127174,
 -1,
 768614829,
 127190,
 768868351,
 768422459,
 -1,
 -53804,
 768769599,
 127143,
 -53803,
 768818426,
 127159,
 -53802,
 768878557,
 127175,
 -1,
 768942509,
 127191,
 769142242,
 768363203,
 -1,
 769207773,
 769088940,
 -1,
 -53798,
 769162815,
 127148,
 -53797,
 769211642,
 127164,
 -53796,
 769271773,
 127180,
 -1,
 769335725,
 127196,
 769589247,
 769148260,
 -1,
 -53793,
 769490495,
 127150,
 -53792,
 769539322,
 127166,
 -53791,
 769599453,
 127182,
 -1,
 769663405,
 127198,
 769863143,
 769093372,
 -1,
 -53788,
 769818175,
 127149,
 -53787,
 769867002,
 127165,
 -53786,
 769927133,
 127181,
 -1,
 769991085,
 127197,
 770190828,
 769809863,
 -1,
 -53783,
 770145855,
 127145,
 -53782,
 770194682,
 127161,
 -53781,
 770254813,
 127177,
 -1,
 770318765,
 127193,
 770518513,
 770132509,
 -1,
 -53778,
 770473535,
 127147,
 -53777,
 770522362,
 127163,
 -53776,
 770582493,
 127179,
 -1,
 770646445,
 127195,
 770846198,
 770453013,
 -1,
 -53773,
 770801215,
 127144,
 -53772,
 770850042,
 127160,
 -53771,
 770910173,
 127176,
 -1,
 770974125,
 127192,
 771173883,
 770772988,
 -1,
 -53768,
 771128895,
 127137,
 -53767,
 771177722,
 127153,
 -53766,
 771237853,
 127169,
 -1,
 771301805,
 127185,
 771501566,
 771102754,
 -1,
 -53763,
 771444092,
 127183,
 -1,
 771493892,
 127136,
 -53761,
 771461917,
 127199,
 -1,
 771649950,
 127167,
 -1,
 764944081,
 128720,
 771894793,
 764905623,
 983150,
 772014079,
 771851599,
 -1,
 772025862,
 771916110,
 -1,
 -53755,
 771986646,
 11219,
 -1,
 772030290,
 11220,
 772276223,
 771961638,
 -1,
 -53752,
 772171530,
 11221,
 -1,
 772229343,
 11222,
 -1,
 771827039,
 983147,
 772484655,
 764836065,
 -1,
 772550176,
 772428201,
 -1,
 772615697,
 772503586,
 -1,
 772681232,
 772542225,
 -1,
 -53745,
 772626563,
 68493,
 -1,
 772679586,
 68495,
 -1,
 772619821,
 68496,
 772943379,
 772553867,
 68484,
 -1,
 772899613,
 68487,
 -53740,
 772905207,
 68486,
 -53739,
 773036121,
 68488,
 -53738,
 773100028,
 68485,
 -53737,
 773161585,
 68497,
 -53736,
 773220940,
 68494,
 -53735,
 773283897,
 68492,
 -53734,
 773347474,
 68491,
 -53733,
 773410266,
 68490,
 -53732,
 773475138,
 68489,
 -53731,
 773536176,
 68482,
 -53730,
 773596728,
 68483,
 -53729,
 773659048,
 68481,
 -1,
 773722677,
 68480,
 773926442,
 772497396,
 -1,
 773991975,
 773882190,
 -1,
 774057509,
 773951769,
 -1,
 -53724,
 774004837,
 68522,
 -1,
 774057955,
 68526,
 -53722,
 773996370,
 68523,
 -1,
 774188782,
 68525,
 774385193,
 773939972,
 68521,
 -1,
 774308398,
 68527,
 -1,
 774321741,
 68524,
 774581805,
 773863025,
 -1,
 -53716,
 774514823,
 68508,
 -1,
 774579248,
 68507,
 -53714,
 774539259,
 68506,
 -1,
 774732178,
 68505,
 774909521,
 772418399,
 -1,
 774975044,
 774860620,
 -1,
 775040579,
 774928418,
 -1,
 775106114,
 774988454,
 -1,
 775171649,
 775028736,
 -1,
 775237177,
 775132055,
 -1,
 -53706,
 775187675,
 128590,
 -53705,
 775240909,
 129493,
 -53704,
 775304642,
 128591,
 -1,
 775363422,
 128113,
 775564860,
 775177184,
 -1,
 -53701,
 775520140,
 129494,
 -1,
 775574737,
 129496,
 -53699,
 775516184,
 128588,
 -53698,
 775698254,
 128589,
 -53697,
 775759969,
 129336,
 -53696,
 775823732,
 129495,
 -1,
 775887902,
 128583,
 -1,
 775098909,
 128187,
 -1,
 775041654,
 128547,
 -1,
 774977029,
 127917,
 776285769,
 774921047,
 -1,
 -53690,
 776241664,
 9956,
 -53689,
 776305869,
 128532,
 -53688,
 776354434,
 128039,
 -1,
 776405923,
 128390,
 776613455,
 776212241,
 -1,
 776678989,
 776543543,
 -1,
 -53684,
 776626404,
 129434,
 -1,
 776682183,
 127825,
 -53682,
 776630092,
 127824,
 -1,
 776822853,
 129372,
 -53680,
 776570471,
 129515,
 -1,
 776939392,
 128694,
 777137779,
 774856805,
 -1,
 777203289,
 777097840,
 -1,
 777268822,
 777156642,
 -1,
 -53675,
 777230337,
 9211,
 -1,
 777277349,
 9214,
 777519103,
 777216678,
 -1,
 -53672,
 777390226,
 9212,
 -1,
 777454773,
 9213,
 777662047,
 777160855,
 -1,
 777727581,
 777618664,
 -1,
 -53668,
 777663309,
 128545,
 -1,
 777723488,
 128574,
 -53666,
 777672165,
 127831,
 -1,
 777854765,
 128093,
 778055268,
 777617742,
 -1,
 778120803,
 777981713,
 -1,
 -53662,
 778077509,
 129364,
 -1,
 778115878,
 128688,
 -1,
 778044210,
 127858,
 778382953,
 778008610,
 -1,
 778448488,
 778338638,
 -1,
 -53657,
 778378284,
 128238,
 -1,
 778441257,
 128239,
 -1,
 778382842,
 11239,
 778710637,
 778326703,
 -1,
 778776172,
 778640966,
 128659,
 -1,
 778729565,
 128680,
 -1,
 778723668,
 128110,
 778972784,
 778660049,
 -1,
 -53649,
 778904446,
 127871,
 -1,
 778961279,
 8297,
 -53647,
 778926027,
 128254,
 -53646,
 779116837,
 128041,
 -1,
 779166031,
 128425,
 779366027,
 777088844,
 -1,
 779431555,
 779305053,
 -1,
 779497086,
 779390535,
 -1,
 779562621,
 779453078,
 -1,
 779628154,
 779487261,
 -1,
 -53639,
 779553266,
 983166,
 -1,
 779618646,
 983163,
 779878399,
 779550720,
 -1,
 -53636,
 779782201,
 983165,
 -1,
 779838212,
 983162,
 -1,
 779494735,
 983192,
 780140543,
 779443031,
 -1,
 780152449,
 780042983,
 128424,
 -1,
 780075575,
 128438,
 780337151,
 780082878,
 129332,
 -1,
 780238531,
 128120,
 780414599,
 779365215,
 -1,
 -53627,
 780372114,
 129384,
 -53626,
 780433880,
 983256,
 -1,
 780483073,
 129328,
 780676746,
 780361829,
 -1,
 -53623,
 780630633,
 11224,
 -1,
 780680643,
 128711,
 -1,
 780605450,
 128255,
 780938904,
 779305053,
 -1,
 781004432,
 780875689,
 128022,
 781123583,
 780926976,
 -1,
 -53617,
 781016821,
 128061,
 -1,
 781071181,
 128055,
 781266579,
 780950673,
 -1,
 -53614,
 781194471,
 127821,
 -1,
 781255027,
 127885,
 781463190,
 781208823,
 -1,
 -53611,
 781405431,
 128138,
 -1,
 781462447,
 128169,
 -53609,
 781418463,
 128299,
 -1,
 781593439,
 129383,
 781790882,
 780896407,
 -1,
 781856412,
 781741900,
 -1,
 -53605,
 781810043,
 128091,
 -1,
 781872034,
 128156,
 -53603,
 781812083,
 128686,
 -53602,
 782007259,
 128204,
 -53601,
 782064683,
 11854,
 -53600,
 782113591,
 128226,
 -53599,
 782174706,
 983167,
 -1,
 782240086,
 983164,
 782446245,
 781722975,
 -1,
 -53596,
 782385245,
 983233,
 -1,
 782447398,
 983224,
 -53594,
 782390804,
 983193,
 -1,
 782581428,
 11227,
 782774356,
 742613093,
 -1,
 782839741,
 782716640,
 -1,
 782905273,
 782761984,
 -1,
 782970656,
 782843947,
 -1,
 783036129,
 782925095,
 -1,
 783101643,
 782969695,
 68809,
 783167154,
 783047511,
 68825,
 783232688,
 783122766,
 68839,
 -1,
 783157417,
 68849,
 -53583,
 783193773,
 68826,
 -1,
 783293751,
 68805,
 783494837,
 783097143,
 68804,
 -53580,
 783448098,
 68806,
 -1,
 783497927,
 68841,
 783691447,
 783456376,
 68847,
 -1,
 783644706,
 68848,
 783822521,
 783647054,
 68838,
 -1,
 783783597,
 68840,
 783953595,
 783775778,
 68836,
 -1,
 783915128,
 68837,
 784084669,
 783898132,
 68824,
 -1,
 784034001,
 68833,
 784215743,
 784026871,
 68822,
 -1,
 784176813,
 68823,
 784346817,
 784152489,
 68813,
 -1,
 784307885,
 68814,
 -53566,
 784305717,
 68846,
 -53565,
 784428876,
 68834,
 -53564,
 784492753,
 68832,
 -53563,
 784550595,
 68819,
 -53562,
 784615925,
 68818,
 -53561,
 784677575,
 68815,
 -53560,
 784741158,
 68812,
 -53559,
 784804703,
 68811,
 -53558,
 784868703,
 68807,
 -1,
 784930850,
 68802,
 785133264,
 783027985,
 68800,
 -53555,
 785079359,
 68808,
 -53554,
 785143689,
 68803,
 -53553,
 785205955,
 68820,
 -1,
 785256209,
 68801,
 785460948,
 785090711,
 68842,
 -53550,
 785418391,
 68843,
 -53549,
 785479714,
 68850,
 -1,
 785538626,
 68821,
 785723095,
 785408101,
 68827,
 -53546,
 785670245,
 68828,
 -1,
 785722658,
 68831,
 785919706,
 785676271,
 -1,
 -53543,
 785877551,
 68845,
 -1,
 785932586,
 68830,
 786116317,
 785866166,
 -1,
 -53540,
 786074159,
 68844,
 -1,
 786129194,
 68829,
 786312927,
 786055261,
 68816,
 -1,
 786251869,
 68817,
 -53536,
 786267090,
 68835,
 -1,
 786375043,
 68810,
 786575127,
 782966262,
 -1,
 786640641,
 786508639,
 68745,
 786706152,
 786586455,
 68761,
 786771686,
 786661710,
 68775,
 -1,
 786696361,
 68785,
 -53529,
 786732717,
 68762,
 -1,
 786832695,
 68741,
 787033835,
 786636087,
 68740,
 -53526,
 786987042,
 68742,
 -1,
 787036871,
 68777,
 787230445,
 786995320,
 68783,
 -1,
 787183650,
 68784,
 787361519,
 787185998,
 68774,
 -1,
 787322541,
 68776,
 787492593,
 787314722,
 68772,
 -1,
 787454072,
 68773,
 787623667,
 787437076,
 68760,
 -1,
 787572945,
 68769,
 787754741,
 787565815,
 68758,
 -1,
 787715757,
 68759,
 787885815,
 787691433,
 68749,
 -1,
 787846829,
 68750,
 -53512,
 787844661,
 68782,
 -53511,
 787967820,
 68770,
 -53510,
 788031697,
 68768,
 -53509,
 788089539,
 68755,
 -53508,
 788154869,
 68754,
 -53507,
 788216519,
 68751,
 -53506,
 788280102,
 68748,
 -53505,
 788343647,
 68747,
 -53504,
 788407647,
 68743,
 -1,
 788469794,
 68738,
 788672262,
 786566929,
 68736,
 -53501,
 788618303,
 68744,
 -53500,
 788682633,
 68739,
 -53499,
 788744899,
 68756,
 -1,
 788795153,
 68737,
 788999946,
 788629655,
 68778,
 -53496,
 788957335,
 68779,
 -53495,
 789018658,
 68786,
 -1,
 789077570,
 68757,
 789262093,
 788947045,
 68763,
 -53492,
 789209189,
 68764,
 -1,
 789261602,
 68767,
 789458704,
 789215215,
 -1,
 -53489,
 789416495,
 68781,
 -1,
 789471530,
 68766,
 789655315,
 789405110,
 -1,
 -53486,
 789613103,
 68780,
 -1,
 789668138,
 68765,
 789851925,
 789594205,
 68752,
 -1,
 789790813,
 68753,
 -53482,
 789806034,
 68771,
 -1,
 789913987,
 68746,
 790167551,
 786522100,
 -1,
 790179612,
 790061828,
 68858,
 790298623,
 790102016,
 -1,
 -53477,
 790201236,
 68863,
 -1,
 790249488,
 68862,
 790441759,
 790115359,
 -1,
 -53474,
 790400621,
 68859,
 -1,
 790443924,
 68861,
 -1,
 790397656,
 68860,
 790703957,
 782925306,
 -1,
 790769478,
 790646007,
 -1,
 790835013,
 790704536,
 -1,
 790900525,
 790770751,
 -1,
 790966054,
 790856305,
 69403,
 -1,
 790890472,
 69404,
 791097128,
 790919345,
 69398,
 -1,
 791021544,
 69399,
 791228202,
 791044153,
 69391,
 -1,
 791152616,
 69392,
 -53461,
 791166091,
 69382,
 -53460,
 791288232,
 69379,
 -1,
 791351861,
 69377,
 791555890,
 790853666,
 -1,
 791621425,
 791482129,
 -1,
 -53456,
 791566467,
 69393,
 -1,
 791619490,
 69397,
 -1,
 791559725,
 69401,
 791883575,
 791482129,
 -1,
 791949110,
 791825655,
 -1,
 -53451,
 791905018,
 69395,
 -1,
 791949347,
 69376,
 -1,
 791910336,
 69394,
 792211257,
 791821451,
 69381,
 -1,
 792167197,
 69385,
 -53446,
 792172791,
 69384,
 -53445,
 792303705,
 69386,
 -53444,
 792367588,
 69383,
 -53443,
 792429169,
 69402,
 -53442,
 792490621,
 69400,
 -53441,
 792554060,
 69396,
 -53440,
 792617017,
 69390,
 -53439,
 792680590,
 69389,
 -53438,
 792743386,
 69388,
 -53437,
 792808258,
 69387,
 -53436,
 792869296,
 69380,
 -1,
 792926632,
 69378,
 -1,
 790774290,
 69415,
 793194324,
 790716404,
 -1,
 793259855,
 793149774,
 -1,
 793325387,
 793219353,
 -1,
 -53430,
 793272421,
 69406,
 -1,
 793325539,
 69411,
 793521998,
 793262791,
 -1,
 -53427,
 793473474,
 69407,
 -1,
 793528289,
 69412,
 -1,
 793456366,
 69410,
 793784145,
 793207556,
 69405,
 -1,
 793707054,
 69413,
 793968639,
 793719590,
 -1,
 -53421,
 793863946,
 69408,
 -1,
 793921759,
 69409,
 -1,
 793130736,
 69414,
 794177414,
 790653642,
 -1,
 794242949,
 794122471,
 -1,
 794308447,
 794203821,
 -1,
 794373979,
 794243189,
 66415,
 -53414,
 794331287,
 66408,
 -1,
 794378333,
 66416,
 794570589,
 794300177,
 66420,
 -1,
 794526030,
 66417,
 -53410,
 794527895,
 66419,
 -1,
 794654743,
 66407,
 794832740,
 794261538,
 -1,
 794898275,
 794770119,
 -1,
 -53406,
 794846294,
 66405,
 -1,
 794894346,
 66406,
 -1,
 794837840,
 66401,
 795160423,
 794771549,
 66393,
 -53402,
 795093855,
 66418,
 -1,
 795152145,
 66421,
 795357036,
 795092319,
 -1,
 795422571,
 795318392,
 -1,
 -53398,
 795363451,
 66392,
 -1,
 795426476,
 66390,
 -1,
 795369892,
 66387,
 795684719,
 795318392,
 -1,
 -53394,
 795623084,
 66389,
 -1,
 795678445,
 66391,
 795881330,
 795643445,
 -1,
 -53391,
 795829334,
 66398,
 -1,
 795881589,
 66414,
 796077941,
 795836750,
 -1,
 -53388,
 796032201,
 66413,
 -1,
 796070265,
 66402,
 796274551,
 796024933,
 66409,
 -1,
 796221541,
 66410,
 796405625,
 796207967,
 66388,
 -1,
 796341030,
 66411,
 -53382,
 796362903,
 66403,
 -53381,
 796488220,
 66400,
 -53380,
 796551779,
 66399,
 -53379,
 796613899,
 66397,
 -53378,
 796678325,
 66396,
 -53377,
 796742021,
 66395,
 -53376,
 796806260,
 66394,
 -53375,
 796867285,
 66412,
 -53374,
 796932124,
 66386,
 -53373,
 796991446,
 66404,
 -53372,
 797056230,
 66385,
 -1,
 797119278,
 66384,
 -1,
 794197521,
 128435,
 797388723,
 794123993,
 -1,
 797454254,
 797331881,
 -1,
 797519758,
 797409614,
 -1,
 797585292,
 797457095,
 -1,
 -53365,
 797519315,
 68251,
 -1,
 797577754,
 68249,
 -53363,
 797519315,
 68233,
 -1,
 797708639,
 68247,
 797912978,
 797454639,
 -1,
 -53360,
 797838026,
 68239,
 -53359,
 797903346,
 68230,
 -1,
 797968726,
 68234,
 798175125,
 797874298,
 -1,
 -53356,
 798114781,
 68248,
 -1,
 798177991,
 68252,
 798371736,
 798116547,
 -1,
 -53353,
 798309104,
 68237,
 -1,
 798363881,
 68235,
 798568347,
 798309063,
 -1,
 -53350,
 798502355,
 68224,
 -1,
 798560607,
 68226,
 798764958,
 798504873,
 -1,
 -53347,
 798702351,
 68246,
 -1,
 798764343,
 68244,
 798961569,
 798696939,
 -1,
 -53344,
 798903543,
 68245,
 -1,
 798958943,
 68243,
 799158180,
 798887697,
 -1,
 -53341,
 799100855,
 68241,
 -1,
 799163357,
 68242,
 -53339,
 799119184,
 68250,
 -53338,
 799314404,
 68229,
 -53337,
 799373485,
 68238,
 -53336,
 799437336,
 68231,
 -53335,
 799501879,
 68228,
 -53334,
 799563437,
 68236,
 -53333,
 799627347,
 68227,
 -53332,
 799690188,
 68225,
 -53331,
 799749058,
 68240,
 -1,
 799807825,
 68232,
 800063487,
 797401076,
 -1,
 800075698,
 799965518,
 -1,
 -53327,
 800035430,
 68255,
 -1,
 800075502,
 68254,
 -1,
 800023300,
 68253,
 800337848,
 797329544,
 -1,
 -53323,
 800298825,
 66349,
 -53322,
 800357927,
 66351,
 -53321,
 800415464,
 66350,
 -1,
 800469351,
 66335,
 -1,
 800279536,
 128477,
 800784383,
 782839928,
 -1,
 -53317,
 800691549,
 128117,
 -53316,
 800741156,
 128116,
 -1,
 800788624,
 129491,
 800993306,
 782792738,
 -1,
 801058841,
 800919854,
 -1,
 801124332,
 801013031,
 -1,
 801189833,
 801057631,
 66783,
 801255368,
 801127111,
 -1,
 801320901,
 801210702,
 -1,
 -53308,
 801274014,
 66803,
 -1,
 801312529,
 66801,
 -53306,
 801270027,
 66797,
 -53305,
 801458970,
 66789,
 -1,
 801513304,
 66782,
 -1,
 801194973,
 66784,
 801779661,
 801115921,
 66776,
 801845196,
 801718365,
 66777,
 -1,
 801790807,
 66778,
 -1,
 801782471,
 66779,
 802041810,
 801734990,
 -1,
 802107345,
 801994786,
 -1,
 -53296,
 802044629,
 66804,
 -1,
 802098961,
 66802,
 -1,
 802033425,
 66800,
 802369494,
 801983171,
 -1,
 -53292,
 802330376,
 66790,
 -53291,
 802372309,
 66808,
 -1,
 802426641,
 66788,
 802631641,
 802330744,
 -1,
 -53288,
 802568917,
 66811,
 -1,
 802623249,
 66810,
 802828252,
 802584610,
 -1,
 -53285,
 802765525,
 66799,
 -1,
 802819857,
 66798,
 803024862,
 802775141,
 66794,
 -1,
 802964445,
 66795,
 803155937,
 802962119,
 -1,
 -53280,
 803116808,
 66786,
 -1,
 803147537,
 66785,
 -53278,
 803115313,
 66807,
 -53277,
 803309719,
 66806,
 -53276,
 803367179,
 66796,
 -53275,
 803429296,
 66793,
 -53274,
 803493470,
 66792,
 -53273,
 803556681,
 66791,
 -53272,
 803618909,
 66787,
 -53271,
 803682601,
 66809,
 -53270,
 803743640,
 66805,
 -53269,
 803807064,
 66781,
 -1,
 803871804,
 66780,
 804126719,
 801054198,
 -1,
 804138998,
 804006751,
 66743,
 804204533,
 804076231,
 -1,
 804270066,
 804159822,
 -1,
 -53263,
 804223134,
 66763,
 -1,
 804261649,
 66761,
 -53261,
 804219147,
 66757,
 -53260,
 804408090,
 66749,
 -1,
 804462424,
 66742,
 -1,
 804144093,
 66744,
 804728826,
 804065041,
 66736,
 804794361,
 804667485,
 66737,
 -1,
 804739927,
 66738,
 -1,
 804731591,
 66739,
 804990975,
 804684110,
 -1,
 805056510,
 804943906,
 -1,
 -53251,
 804993749,
 66764,
 -1,
 805048081,
 66762,
 -1,
 804982545,
 66760,
 805318659,
 804932291,
 -1,
 -53247,
 805279496,
 66750,
 -53246,
 805321429,
 66768,
 -1,
 805375761,
 66748,
 805580806,
 805279864,
 -1,
 -53243,
 805518037,
 66771,
 -1,
 805572369,
 66770,
 805777417,
 805533730,
 -1,
 -53240,
 805714645,
 66759,
 -1,
 805768977,
 66758,
 805974027,
 805724261,
 66754,
 -1,
 805913565,
 66755,
 806105102,
 805911239,
 -1,
 -53235,
 806065928,
 66746,
 -1,
 806096657,
 66745,
 -53233,
 806064433,
 66767,
 -53232,
 806258839,
 66766,
 -53231,
 806316299,
 66756,
 -53230,
 806378416,
 66753,
 -53229,
 806442590,
 66752,
 -53228,
 806505801,
 66751,
 -53227,
 806568029,
 66747,
 -53226,
 806631721,
 66769,
 -53225,
 806692760,
 66765,
 -53224,
 806756184,
 66741,
 -1,
 806820924,
 66740,
 -1,
 800988471,
 983191,
 807088170,
 800942289,
 -1,
 807153703,
 807021407,
 -1,
 807219238,
 807099225,
 -1,
 807284768,
 807163582,
 -1,
 -53217,
 807235565,
 128236,
 -1,
 807294353,
 128237,
 807481379,
 807220006,
 -1,
 -53214,
 807428608,
 128449,
 -1,
 807486342,
 128194,
 -53212,
 807425104,
 128275,
 -53211,
 807615520,
 128080,
 -1,
 807672803,
 128214,
 -1,
 807170156,
 983190,
 807940137,
 807109732,
 128191,
 -1,
 807862839,
 128440,
 -1,
 807878274,
 9934,
 808136759,
 807038796,
 -1,
 808202292,
 808077775,
 -1,
 808267825,
 808149768,
 -1,
 -53202,
 808221924,
 2933,
 -53201,
 808283829,
 2930,
 -53200,
 808336221,
 2931,
 -1,
 808398389,
 2934,
 808648703,
 808223670,
 -1,
 -53197,
 808549614,
 2935,
 -1,
 808611571,
 2932,
 808845311,
 808129498,
 -1,
 -53194,
 808729826,
 129505,
 -1,
 808786915,
 128217,
 808988736,
 808082263,
 -1,
 809054270,
 808919590,
 -1,
 -53190,
 809009781,
 128662,
 -53189,
 809069680,
 128660,
 -53188,
 809120996,
 128753,
 -53187,
 809180401,
 128653,
 -1,
 809244605,
 128664,
 -53185,
 808987492,
 128431,
 -1,
 809371217,
 128283,
 809578568,
 808947442,
 -1,
 809644103,
 809520654,
 128471,
 809762815,
 809593662,
 -1,
 809775174,
 809669301,
 -1,
 -53179,
 809729714,
 11194,
 -1,
 809767791,
 11195,
 -1,
 809704192,
 11196,
 -1,
 809581825,
 129397,
 810102859,
 809510035,
 -1,
 -53174,
 810050840,
 128025,
 -1,
 810094917,
 128721,
 -53172,
 810063346,
 128002,
 -53171,
 810259592,
 129417,
 -53170,
 810323432,
 128228,
 -53169,
 810374709,
 128329,
 -53168,
 810437342,
 128076,
 -53167,
 810500954,
 128738,
 -53166,
 810562576,
 127970,
 -53165,
 810624761,
 127842,
 -1,
 810687652,
 9215,
 810889723,
 782706015,
 -1,
 810955008,
 810846359,
 -1,
 811020542,
 810904553,
 -1,
 811086032,
 810963369,
 -1,
 811151476,
 811038754,
 113692,
 811216999,
 811073536,
 -1,
 811282524,
 811176868,
 113701,
 -1,
 811204846,
 113702,
 811413598,
 811237710,
 113714,
 -1,
 811336736,
 113715,
 811544672,
 811362513,
 113716,
 -1,
 811467808,
 113717,
 811675746,
 811485891,
 113727,
 -1,
 811598880,
 113728,
 811806820,
 811616757,
 113696,
 -1,
 811729983,
 113710,
 -53147,
 811759650,
 113706,
 -53146,
 811883351,
 113723,
 -1,
 811947540,
 113724,
 812134515,
 811160650,
 -1,
 812200044,
 812067679,
 -1,
 -53142,
 812145495,
 113767,
 -53141,
 812202695,
 113740,
 -1,
 812264287,
 113742,
 812462191,
 812146789,
 -1,
 -53138,
 812421401,
 113730,
 -1,
 812473175,
 113769,
 -53136,
 812419223,
 113752,
 -53135,
 812599797,
 113685,
 -53134,
 812656533,
 113682,
 -1,
 812716846,
 113768,
 -1,
 812072731,
 113737,
 812986495,
 811096919,
 113690,
 813052026,
 812914264,
 -1,
 -53129,
 813009047,
 113761,
 -53128,
 813064293,
 113762,
 -53127,
 813121629,
 113763,
 -1,
 813174545,
 113764,
 813432831,
 812974080,
 -1,
 813445245,
 813323796,
 113694,
 -1,
 813368383,
 113708,
 -53122,
 813405092,
 113698,
 -1,
 813529122,
 113704,
 813707401,
 812927477,
 113691,
 813826047,
 813629440,
 -1,
 813838467,
 813732772,
 113699,
 -1,
 813791287,
 113700,
 813969541,
 813791266,
 113705,
 -1,
 813893158,
 113711,
 814100615,
 813914967,
 113712,
 -1,
 814023743,
 113713,
 814284799,
 814044692,
 113695,
 -1,
 814154815,
 113709,
 814362769,
 813666585,
 113720,
 814428300,
 814309477,
 113757,
 -1,
 814387481,
 113760,
 -53107,
 814366813,
 113758,
 -53106,
 814496455,
 113721,
 -53105,
 814558711,
 113759,
 -53104,
 814616337,
 113756,
 -1,
 814679072,
 113722,
 814887063,
 814313292,
 113675,
 814952597,
 814834262,
 -1,
 -53100,
 814909591,
 113750,
 -1,
 814956637,
 113741,
 -53098,
 814889671,
 113688,
 -1,
 815072319,
 113680,
 815280284,
 814833765,
 113732,
 -53095,
 815239449,
 113754,
 -53094,
 815302807,
 113755,
 -53093,
 815358357,
 113753,
 -1,
 815402769,
 113731,
 815607970,
 815224340,
 113689,
 815726591,
 815529984,
 -1,
 815739040,
 815618903,
 113693,
 -1,
 815662143,
 113707,
 -53087,
 815698852,
 113697,
 -1,
 815822882,
 113703,
 816001190,
 815564951,
 113745,
 -53084,
 815939677,
 113738,
 -53083,
 816003783,
 113751,
 -1,
 816055026,
 113748,
 816263339,
 815956302,
 113667,
 816328874,
 816185344,
 -1,
 -53079,
 816281634,
 113718,
 -1,
 816344928,
 113719,
 -1,
 816265927,
 113681,
 816591024,
 816212177,
 113666,
 816656559,
 816525564,
 -1,
 -53074,
 816601943,
 113765,
 -1,
 816666132,
 113766,
 -1,
 816579314,
 113676,
 816918709,
 816532727,
 113670,
 816984244,
 816866208,
 -1,
 -53069,
 816941207,
 113749,
 -1,
 816988253,
 113743,
 -1,
 816921287,
 113687,
 817246394,
 816859843,
 113669,
 817311929,
 817168384,
 -1,
 -53064,
 817262432,
 113725,
 -1,
 817321492,
 113679,
 -1,
 817253059,
 113684,
 817574077,
 817179487,
 113735,
 -53060,
 817531031,
 113746,
 -1,
 817572703,
 113739,
 817770688,
 817505631,
 113672,
 -53057,
 817707719,
 113683,
 -1,
 817759295,
 113677,
 817967298,
 817731058,
 113665,
 -1,
 817926425,
 113747,
 818098372,
 817925685,
 113673,
 -1,
 818045139,
 113770,
 818229446,
 818036829,
 113734,
 -1,
 818162527,
 113736,
 818360520,
 818166471,
 113664,
 -1,
 818302199,
 113686,
 818491594,
 818296745,
 113674,
 -1,
 818414627,
 113726,
 818622668,
 818426662,
 113668,
 -1,
 818545394,
 113678,
 818753742,
 818548497,
 113729,
 -1,
 818701958,
 113733,
 -53041,
 818714441,
 113744,
 -1,
 818812962,
 113671,
 819015930,
 811012357,
 -1,
 819081441,
 818957559,
 -1,
 819146976,
 819030111,
 -1,
 819212501,
 819105548,
 113816,
 -1,
 819135563,
 113779,
 819343576,
 819154167,
 -1,
 -53033,
 819291045,
 113811,
 -1,
 819348717,
 113814,
 819540187,
 819269393,
 -1,
 -53030,
 819492759,
 113817,
 -1,
 819537226,
 113808,
 -53028,
 819499470,
 113815,
 -53027,
 819692672,
 113809,
 -53026,
 819739217,
 113810,
 -53025,
 819800199,
 113812,
 -1,
 819863598,
 113813,
 -1,
 819080588,
 113776,
 820130029,
 819019242,
 -1,
 820195556,
 820088588,
 113800,
 -1,
 820118603,
 113781,
 820326631,
 820137207,
 -1,
 -53018,
 820274085,
 113795,
 -1,
 820331757,
 113798,
 -53016,
 820285902,
 113799,
 -53015,
 820479104,
 113793,
 -53014,
 820525649,
 113794,
 -53013,
 820586631,
 113796,
 -53012,
 820650030,
 113797,
 -1,
 820711521,
 113792,
 820916470,
 820057967,
 -1,
 820982002,
 820871638,
 -1,
 821047537,
 820927871,
 113784,
 -1,
 820970024,
 113788,
 -1,
 820986711,
 113785,
 -53005,
 820935051,
 113782,
 -53004,
 821186756,
 113783,
 -53003,
 821248117,
 113787,
 -1,
 821308304,
 113786,
 821506297,
 820861171,
 -1,
 -53000,
 821464920,
 113780,
 -1,
 821509873,
 113777,
 -1,
 821457826,
 113778,
 -52997,
 818971484,
 113821,
 -52996,
 821722214,
 113820,
 -52995,
 821783996,
 113823,
 -1,
 821832012,
 113822,
 -52993,
 810965726,
 129375,
 -1,
 821960949,
 129414,
 822161820,
 810901605,
 -1,
 822227282,
 822097833,
 128021,
 822292817,
 822177692,
 -1,
 822358333,
 822235561,
 -1,
 822423818,
 822313294,
 -1,
 822489352,
 822378830,
 -1,
 -52985,
 822426325,
 71701,
 -1,
 822480657,
 71700,
 -52983,
 822426325,
 71706,
 -1,
 822611729,
 71705,
 822817039,
 822369111,
 -1,
 -52980,
 822777608,
 71699,
 -52979,
 822827952,
 71704,
 -52978,
 822884322,
 71694,
 -1,
 822939409,
 71709,
 823144725,
 822748511,
 -1,
 823210259,
 823076191,
 -1,
 -52974,
 823147221,
 71703,
 -1,
 823201553,
 71702,
 -52972,
 823147221,
 71708,
 -1,
 823332625,
 71707,
 823537945,
 823070481,
 71680,
 -52969,
 823494807,
 71689,
 -52968,
 823541853,
 71687,
 -1,
 823594769,
 71681,
 823800093,
 823490594,
 -1,
 -52965,
 823752862,
 71720,
 -52964,
 823802581,
 71719,
 -1,
 823856913,
 71721,
 824062239,
 823756951,
 71684,
 -1,
 824019095,
 71685,
 824193314,
 824012620,
 -1,
 -52959,
 824143769,
 71723,
 -1,
 824184593,
 71716,
 824389925,
 824142033,
 -1,
 -52956,
 824326869,
 71711,
 -1,
 824381201,
 71710,
 824586536,
 824330947,
 -1,
 -52953,
 824523477,
 71691,
 -1,
 824577809,
 71690,
 824783147,
 824527349,
 -1,
 -52950,
 824720085,
 71698,
 -1,
 824774417,
 71697,
 824979757,
 824721501,
 71682,
 -1,
 824918109,
 71683,
 825110832,
 824915881,
 -1,
 -52945,
 825047765,
 71693,
 -1,
 825102097,
 71692,
 825307443,
 825040183,
 -1,
 -52942,
 825244373,
 71696,
 -1,
 825298705,
 71695,
 825504054,
 825235490,
 -1,
 -52939,
 825440981,
 71713,
 -1,
 825495313,
 71712,
 -52937,
 825464584,
 71715,
 -52936,
 825658951,
 71718,
 -52935,
 825712741,
 71688,
 -52934,
 825775710,
 71714,
 -52933,
 825838921,
 71717,
 -52932,
 825899733,
 71722,
 -1,
 825961311,
 71686,
 826159434,
 822317304,
 -1,
 826224962,
 826085137,
 -1,
 -52928,
 826181783,
 71734,
 -52927,
 826228829,
 71732,
 -1,
 826281745,
 71724,
 826487108,
 826183815,
 71729,
 -1,
 826437452,
 71730,
 826618182,
 826443927,
 71727,
 -1,
 826574999,
 71728,
 826749256,
 826556509,
 71725,
 -1,
 826687581,
 71726,
 -52919,
 826695781,
 71733,
 -1,
 826813279,
 71731,
 827011408,
 826113104,
 -1,
 827076942,
 826970113,
 -1,
 -52915,
 827029826,
 71736,
 -1,
 827093055,
 71737,
 -52913,
 827023342,
 71738,
 -1,
 827200649,
 71735,
 -1,
 826937263,
 71739,
 -1,
 822215118,
 128054,
 827535750,
 822187150,
 -1,
 827601283,
 827494783,
 -1,
 827666814,
 827553828,
 -1,
 827732331,
 827621710,
 -1,
 827797866,
 827683606,
 -1,
 827863401,
 827721796,
 -1,
 827928934,
 827790812,
 11107,
 828047359,
 827850752,
 -1,
 828060004,
 827954071,
 -1,
 828125534,
 828003463,
 -1,
 -52899,
 828077221,
 11169,
 -1,
 828133593,
 11168,
 -52897,
 828084122,
 129075,
 -52896,
 828267511,
 129059,
 -52895,
 828332062,
 129063,
 -52894,
 828390693,
 129071,
 -52893,
 828451123,
 11133,
 -1,
 828513215,
 129067,
 -52891,
 828015944,
 11123,
 -1,
 828658010,
 11139,
 -52889,
 827889944,
 11085,
 -52888,
 828795197,
 11143,
 -1,
 828843650,
 11117,
 -1,
 827785390,
 129171,
 -1,
 827757876,
 11247,
 829174131,
 827659765,
 -1,
 829239663,
 829127955,
 -1,
 -52882,
 829195909,
 129027,
 -1,
 829239391,
 129043,
 -52880,
 829185799,
 129179,
 -52879,
 829380665,
 129031,
 -52878,
 829443656,
 129035,
 -1,
 829501535,
 129047,
 829698422,
 829126690,
 -1,
 -52875,
 829648552,
 129083,
 -1,
 829690944,
 129107,
 829895033,
 829635853,
 -1,
 -52872,
 829825640,
 129091,
 -1,
 829887964,
 129095,
 -52870,
 829854409,
 129175,
 -52869,
 830043852,
 128623,
 -52868,
 830092477,
 129079,
 -52867,
 830153320,
 129087,
 -1,
 830216894,
 11147,
 830472191,
 827589083,
 -1,
 830484865,
 830365434,
 129289,
 -1,
 830408230,
 129291,
 830668799,
 830422723,
 129288,
 -1,
 830539302,
 129290,
 830799871,
 827525278,
 -1,
 -52859,
 830700926,
 128317,
 -1,
 830763445,
 128315,
 830943634,
 827492503,
 -1,
 831009169,
 830872345,
 -1,
 831074704,
 830930944,
 -1,
 831140236,
 831027234,
 -1,
 -52853,
 831098310,
 11844,
 -1,
 831160819,
 11849,
 -52851,
 831098645,
 9208,
 -52850,
 831280476,
 11842,
 -52849,
 831340630,
 11840,
 -1,
 831399185,
 10175,
 -1,
 831006132,
 11260,
 -1,
 830945609,
 127849,
 831730071,
 830874837,
 128462,
 831848447,
 831653252,
 -1,
 831861142,
 831750931,
 128441,
 -1,
 831782988,
 128442,
 -1,
 831810353,
 128443,
 -52840,
 831688319,
 128330,
 -52839,
 832014194,
 11850,
 -52838,
 832070967,
 128682,
 -52837,
 832132523,
 128044,
 -1,
 832176889,
 128687,
 832385484,
 822094687,
 -1,
 832451005,
 832343605,
 -1,
 832516534,
 832377698,
 -1,
 832582058,
 832459177,
 -1,
 832647587,
 832538775,
 -1,
 -52830,
 832604719,
 2423,
 -1,
 832645983,
 2422,
 832844198,
 832594021,
 -1,
 -52827,
 832790826,
 2420,
 -1,
 832842591,
 2419,
 833040809,
 832769809,
 -1,
 -52824,
 833001133,
 43262,
 -1,
 833065241,
 2421,
 -1,
 832984930,
 2424,
 833302964,
 832540920,
 -1,
 833368494,
 833259671,
 -1,
 -52819,
 833325615,
 2391,
 -1,
 833366879,
 2390,
 833565105,
 833314917,
 -1,
 -52816,
 833511722,
 2363,
 -1,
 833563487,
 2362,
 833814527,
 833490705,
 -1,
 -52813,
 833722029,
 43263,
 -1,
 833786137,
 2383,
 -52811,
 833256568,
 43260,
 -1,
 833899050,
 43261,
 834142207,
 832454998,
 -1,
 834154938,
 834044238,
 -1,
 -52807,
 834114774,
 983085,
 -1,
 834158418,
 983087,
 -52805,
 834109486,
 983160,
 -52804,
 834298628,
 983083,
 -1,
 834352717,
 983089,
 834548163,
 832403490,
 -1,
 834613697,
 834489511,
 -1,
 -52800,
 834573151,
 128468,
 -1,
 834609785,
 128421,
 834863103,
 834548004,
 127964,
 -1,
 834732637,
 127965,
 834941382,
 834489591,
 983119,
 -52795,
 834881885,
 128666,
 -1,
 834941311,
 983118,
 835137993,
 834870583,
 -1,
 -52792,
 835088677,
 128475,
 -1,
 835142064,
 127795,
 -52790,
 835088936,
 127962,
 -52789,
 835283499,
 127980,
 -1,
 835334261,
 129420,
 835531227,
 832323677,
 -1,
 835596752,
 835492173,
 -1,
 -52785,
 835551519,
 128171,
 -1,
 835597133,
 128565,
 835793363,
 835549477,
 -1,
 -52782,
 835728205,
 128542,
 -1,
 835788046,
 128549,
 835989974,
 835738996,
 -1,
 -52779,
 835935446,
 127244,
 -1,
 835985542,
 127243,
 836186585,
 835916564,
 -1,
 -52776,
 836141667,
 128924,
 -1,
 836205334,
 128160,
 -52774,
 836137330,
 127919,
 -1,
 836317495,
 128754,
 836514281,
 835456785,
 -1,
 836579809,
 836450540,
 -1,
 836645344,
 836539287,
 -1,
 -52769,
 836596585,
 11831,
 -1,
 836652998,
 11830,
 -1,
 836586593,
 128481,
 836907492,
 836532875,
 -1,
 -52765,
 836867030,
 11843,
 -1,
 836927775,
 128168,
 837104103,
 836852567,
 -1,
 -52762,
 837040653,
 127841,
 -1,
 837099290,
 128131,
 -52760,
 837059033,
 983081,
 -1,
 837252740,
 128374,
 837431794,
 836464460,
 -1,
 837497326,
 837378149,
 -1,
 -52756,
 837446596,
 128167,
 -52755,
 837509650,
 129316,
 -1,
 837572577,
 128042,
 837759472,
 837423424,
 128009,
 -1,
 837681614,
 128050,
 -52751,
 837716734,
 129345,
 -1,
 837824871,
 128087,
 838021624,
 837360951,
 -1,
 -52748,
 837974050,
 983161,
 -52747,
 838011779,
 983090,
 -52746,
 838077130,
 983088,
 -52745,
 838142450,
 983086,
 -1,
 838207830,
 983084,
 -52743,
 837979754,
 128192,
 -52742,
 838359987,
 129516,
 -1,
 838422308,
 983082,
 838611760,
 810847797,
 -1,
 838677245,
 838563874,
 -1,
 838742636,
 838601046,
 983240,
 838808073,
 838667910,
 983270,
 -52736,
 838733446,
 983450,
 -52735,
 838798855,
 983449,
 -52734,
 838864225,
 983448,
 -52733,
 838929609,
 983447,
 -52732,
 838994975,
 983446,
 -52731,
 839060355,
 983445,
 -52730,
 839125706,
 983444,
 -52729,
 839191026,
 983443,
 -52728,
 839256406,
 983442,
 -1,
 839321798,
 983441,
 839528980,
 838733319,
 983269,
 -52725,
 839454342,
 983440,
 -52724,
 839519751,
 983439,
 -52723,
 839585121,
 983438,
 -52722,
 839650505,
 983437,
 -52721,
 839715871,
 983436,
 -52720,
 839781251,
 983435,
 -52719,
 839846602,
 983434,
 -52718,
 839911922,
 983433,
 -52717,
 839977302,
 983432,
 -1,
 840042694,
 983431,
 840249887,
 839454049,
 983268,
 -52714,
 840175238,
 983430,
 -52713,
 840240647,
 983429,
 -52712,
 840306017,
 983428,
 -52711,
 840371401,
 983427,
 -52710,
 840436767,
 983426,
 -52709,
 840502147,
 983425,
 -52708,
 840567498,
 983424,
 -52707,
 840632818,
 983423,
 -52706,
 840698198,
 983422,
 -1,
 840763590,
 983421,
 840970794,
 840174793,
 983255,
 -52703,
 840896134,
 983420,
 -52702,
 840961543,
 983419,
 -52701,
 841026913,
 983418,
 -52700,
 841092297,
 983417,
 -52699,
 841157663,
 983416,
 -52698,
 841223043,
 983415,
 -52697,
 841288394,
 983414,
 -52696,
 841353714,
 983413,
 -52695,
 841419094,
 983412,
 -1,
 841484486,
 983411,
 841691701,
 840895519,
 983254,
 -52692,
 841617030,
 983410,
 -52691,
 841682439,
 983409,
 -52690,
 841747809,
 983408,
 -52689,
 841813193,
 983407,
 -52688,
 841878559,
 983406,
 -52687,
 841943939,
 983405,
 -52686,
 842009290,
 983404,
 -52685,
 842074610,
 983403,
 -52684,
 842139990,
 983402,
 -1,
 842205382,
 983401,
 842412608,
 841616259,
 983253,
 -52681,
 842337926,
 983400,
 -52680,
 842403335,
 983399,
 -52679,
 842468705,
 983398,
 -52678,
 842534089,
 983397,
 -52677,
 842599455,
 983396,
 -52676,
 842664835,
 983395,
 -52675,
 842730186,
 983394,
 -52674,
 842795506,
 983393,
 -52673,
 842860886,
 983392,
 -1,
 842926278,
 983391,
 843133515,
 842336970,
 983252,
 -52670,
 843058822,
 983390,
 -52669,
 843124231,
 983389,
 -52668,
 843189601,
 983388,
 -52667,
 843254985,
 983387,
 -52666,
 843320351,
 983386,
 -52665,
 843385731,
 983385,
 -52664,
 843451082,
 983384,
 -52663,
 843516402,
 983383,
 -52662,
 843581782,
 983382,
 -1,
 843647174,
 983381,
 843854422,
 843057650,
 983251,
 -52659,
 843779718,
 983380,
 -52658,
 843845127,
 983379,
 -52657,
 843910497,
 983378,
 -52656,
 843975881,
 983377,
 -52655,
 844041247,
 983376,
 -52654,
 844106627,
 983375,
 -52653,
 844171978,
 983374,
 -52652,
 844237298,
 983373,
 -52651,
 844302678,
 983372,
 -1,
 844368070,
 983371,
 844575329,
 843778390,
 983250,
 -52648,
 844500614,
 983370,
 -52647,
 844566023,
 983369,
 -52646,
 844631393,
 983368,
 -52645,
 844696777,
 983367,
 -52644,
 844762143,
 983366,
 -52643,
 844827523,
 983365,
 -52642,
 844892874,
 983364,
 -52641,
 844958194,
 983363,
 -52640,
 845023574,
 983362,
 -1,
 845088966,
 983361,
 845348863,
 844499142,
 983249,
 -52637,
 845221510,
 983360,
 -52636,
 845286919,
 983359,
 -52635,
 845352289,
 983358,
 -52634,
 845417673,
 983357,
 -52633,
 845483039,
 983356,
 -52632,
 845548419,
 983355,
 -52631,
 845613770,
 983354,
 -52630,
 845679090,
 983353,
 -52629,
 845744470,
 983352,
 -1,
 845809862,
 983351,
 846017200,
 838666738,
 983241,
 846082680,
 845941635,
 983275,
 -52625,
 846007942,
 983500,
 -52624,
 846073351,
 983499,
 -52623,
 846138721,
 983498,
 -52622,
 846204105,
 983497,
 -52621,
 846269471,
 983496,
 -52620,
 846334851,
 983495,
 -52619,
 846400202,
 983494,
 -52618,
 846465522,
 983493,
 -52617,
 846530902,
 983492,
 -1,
 846596294,
 983491,
 846803587,
 846006986,
 983274,
 -52614,
 846728838,
 983490,
 -52613,
 846794247,
 983489,
 -52612,
 846859617,
 983488,
 -52611,
 846925001,
 983487,
 -52610,
 846990367,
 983486,
 -52609,
 847055747,
 983485,
 -52608,
 847121098,
 983484,
 -52607,
 847186418,
 983483,
 -52606,
 847251798,
 983482,
 -1,
 847317190,
 983481,
 847524494,
 846727666,
 983273,
 -52603,
 847449734,
 983480,
 -52602,
 847515143,
 983479,
 -52601,
 847580513,
 983478,
 -52600,
 847645897,
 983477,
 -52599,
 847711263,
 983476,
 -52598,
 847776643,
 983475,
 -52597,
 847841994,
 983474,
 -52596,
 847907314,
 983473,
 -52595,
 847972694,
 983472,
 -1,
 848038086,
 983471,
 848245401,
 847448406,
 983272,
 -52592,
 848170630,
 983470,
 -52591,
 848236039,
 983469,
 -52590,
 848301409,
 983468,
 -52589,
 848366793,
 983467,
 -52588,
 848432159,
 983466,
 -52587,
 848497539,
 983465,
 -52586,
 848562890,
 983464,
 -52585,
 848628210,
 983463,
 -52584,
 848693590,
 983462,
 -1,
 848758982,
 983461,
 848966308,
 848169158,
 983271,
 -52581,
 848891526,
 983460,
 -52580,
 848956935,
 983459,
 -52579,
 849022305,
 983458,
 -52578,
 849087689,
 983457,
 -52577,
 849153055,
 983456,
 -52576,
 849218435,
 983455,
 -52575,
 849283786,
 983454,
 -52574,
 849349106,
 983453,
 -52573,
 849414486,
 983452,
 -1,
 849479878,
 983451,
 849687212,
 848890911,
 983276,
 -52570,
 849611977,
 983507,
 -52569,
 849677343,
 983506,
 -52568,
 849742723,
 983505,
 -52567,
 849808074,
 983504,
 -52566,
 849873394,
 983503,
 -52565,
 849938774,
 983502,
 -1,
 850004166,
 983501,
 -52563,
 849612422,
 983280,
 -52562,
 850136583,
 983279,
 -52561,
 850201953,
 983278,
 -1,
 850267337,
 983277,
 850473659,
 845942406,
 983248,
 -52558,
 850398854,
 983350,
 -52557,
 850464263,
 983349,
 -52556,
 850529633,
 983348,
 -52555,
 850595017,
 983347,
 -52554,
 850660383,
 983346,
 -52553,
 850725763,
 983345,
 -52552,
 850791114,
 983344,
 -52551,
 850856434,
 983343,
 -52550,
 850921814,
 983342,
 -1,
 850987206,
 983341,
 851194566,
 850398727,
 983247,
 -52547,
 851119750,
 983340,
 -52546,
 851185159,
 983339,
 -52545,
 851250529,
 983338,
 -52544,
 851315913,
 983337,
 -52543,
 851381279,
 983336,
 -52542,
 851446659,
 983335,
 -52541,
 851512010,
 983334,
 -52540,
 851577330,
 983333,
 -52539,
 851642710,
 983332,
 -1,
 851708102,
 983331,
 851915473,
 851119457,
 983246,
 -52536,
 851840646,
 983330,
 -52535,
 851906055,
 983329,
 -52534,
 851971425,
 983328,
 -52533,
 852036809,
 983327,
 -52532,
 852102175,
 983326,
 -52531,
 852167555,
 983325,
 -52530,
 852232906,
 983324,
 -52529,
 852298226,
 983323,
 -52528,
 852363606,
 983322,
 -1,
 852428998,
 983321,
 852636380,
 851840201,
 983245,
 -52525,
 852561542,
 983320,
 -52524,
 852626951,
 983319,
 -52523,
 852692321,
 983318,
 -52522,
 852757705,
 983317,
 -52521,
 852823071,
 983316,
 -52520,
 852888451,
 983315,
 -52519,
 852953802,
 983314,
 -52518,
 853019122,
 983313,
 -52517,
 853084502,
 983312,
 -1,
 853149894,
 983311,
 853357287,
 852560927,
 983244,
 -52514,
 853282438,
 983310,
 -52513,
 853347847,
 983309,
 -52512,
 853413217,
 983308,
 -52511,
 853478601,
 983307,
 -52510,
 853543967,
 983306,
 -52509,
 853609347,
 983305,
 -52508,
 853674698,
 983304,
 -52507,
 853740018,
 983303,
 -52506,
 853805398,
 983302,
 -1,
 853870790,
 983301,
 854078194,
 853281667,
 983243,
 -52503,
 854003334,
 983300,
 -52502,
 854068743,
 983299,
 -52501,
 854134113,
 983298,
 -52500,
 854199497,
 983297,
 -52499,
 854264863,
 983296,
 -52498,
 854330243,
 983295,
 -52497,
 854395594,
 983294,
 -52496,
 854460914,
 983293,
 -52495,
 854526294,
 983292,
 -1,
 854591686,
 983291,
 854851583,
 854002378,
 983242,
 -52492,
 854724230,
 983290,
 -52491,
 854789639,
 983289,
 -52490,
 854855009,
 983288,
 -52489,
 854920393,
 983287,
 -52488,
 854985759,
 983286,
 -52487,
 855051139,
 983285,
 -52486,
 855116490,
 983284,
 -52485,
 855181810,
 983283,
 -52484,
 855247190,
 983282,
 -1,
 855312582,
 983281,
 855520033,
 838609759,
 -1,
 855585559,
 855469900,
 -1,
 855651087,
 855545519,
 -1,
 855716622,
 855588109,
 -1,
 855782149,
 855668770,
 -1,
 -52477,
 855728646,
 128636,
 -52476,
 855787915,
 128953,
 -1,
 855839427,
 128941,
 856044296,
 855741109,
 -1,
 -52473,
 855998114,
 128914,
 -1,
 856039470,
 128904,
 856240907,
 855977478,
 -1,
 -52470,
 856194702,
 128959,
 -1,
 856255518,
 128976,
 -52468,
 856191666,
 128637,
 -52467,
 856373847,
 128934,
 -1,
 856438046,
 128947,
 -1,
 855645102,
 128933,
 856752127,
 855606365,
 -1,
 856765206,
 856654158,
 -1,
 856830741,
 856690566,
 -1,
 856896276,
 856787650,
 983069,
 -1,
 856818782,
 983143,
 -1,
 856818277,
 11135,
 -1,
 856780731,
 128678,
 -1,
 856718555,
 11837,
 857276415,
 855517158,
 -1,
 857289501,
 857177168,
 -1,
 -52454,
 857246768,
 7414,
 -52453,
 857306907,
 7411,
 -52452,
 857361005,
 7413,
 -1,
 857413421,
 7415,
 857669631,
 857245058,
 -1,
 -52449,
 857568582,
 7416,
 -52448,
 857614737,
 7417,
 -1,
 857677249,
 7412,
 857879337,
 855457885,
 -1,
 857944871,
 857810707,
 -1,
 858010406,
 857866240,
 -1,
 -52443,
 857946150,
 127918,
 -1,
 858004895,
 128249,
 -1,
 857939536,
 128252,
 -52440,
 857891341,
 127931,
 -1,
 858201161,
 128243,
 858403627,
 857833806,
 983070,
 -1,
 858355746,
 983144,
 858534702,
 858350068,
 -1,
 -52435,
 858477158,
 127952,
 -1,
 858529260,
 127755,
 -52433,
 858491594,
 11238,
 -1,
 858657563,
 129499,
 858862714,
 838547369,
 -1,
 858928052,
 858812236,
 -1,
 858993559,
 858853137,
 -1,
 859059093,
 858939346,
 -1,
 859124599,
 859001257,
 -1,
 859190079,
 859082293,
 -1,
 859255611,
 859136203,
 -1,
 859321145,
 859205452,
 70411,
 -1,
 859270988,
 70496,
 859504639,
 859262199,
 70412,
 -1,
 859393271,
 70497,
 859583294,
 859188496,
 -1,
 -52419,
 859515090,
 70495,
 -1,
 859575433,
 70494,
 -1,
 859508497,
 70453,
 859845445,
 859144526,
 -1,
 859910979,
 859799886,
 -1,
 -52414,
 859847381,
 70432,
 -1,
 859901713,
 70431,
 -52412,
 859847381,
 70437,
 -1,
 860032785,
 70436,
 860238666,
 859790167,
 -1,
 -52409,
 860198664,
 70430,
 -52408,
 860249008,
 70435,
 -52407,
 860305378,
 70425,
 -1,
 860360465,
 70440,
 860566352,
 860169567,
 -1,
 860631886,
 860497247,
 -1,
 -52403,
 860568277,
 70434,
 -1,
 860622609,
 70433,
 -52401,
 860568277,
 70439,
 -1,
 860753681,
 70438,
 860959572,
 860491537,
 70405,
 -52398,
 860915863,
 70420,
 -52397,
 860962909,
 70416,
 -1,
 861015825,
 70406,
 861221720,
 860911650,
 -1,
 -52394,
 861173918,
 70455,
 -52393,
 861223637,
 70454,
 -1,
 861277969,
 70456,
 861483866,
 861178007,
 70409,
 -1,
 861440151,
 70410,
 861614941,
 861432017,
 -1,
 -52388,
 861551317,
 70443,
 -1,
 861605649,
 70442,
 861811552,
 861555959,
 -1,
 -52385,
 861752649,
 70451,
 -1,
 861802257,
 70450,
 862008163,
 861752003,
 -1,
 -52382,
 861944533,
 70422,
 -1,
 861998865,
 70421,
 862204774,
 861948405,
 -1,
 -52379,
 862141141,
 70429,
 -1,
 862195473,
 70428,
 862401384,
 862142557,
 70407,
 -1,
 862339165,
 70408,
 862532459,
 862336937,
 -1,
 -52374,
 862468821,
 70424,
 -1,
 862523153,
 70423,
 862729070,
 862461239,
 -1,
 -52371,
 862665429,
 70427,
 -1,
 862719761,
 70426,
 862925681,
 862656546,
 -1,
 -52368,
 862862037,
 70445,
 -1,
 862916369,
 70444,
 -52366,
 862885640,
 70447,
 -52365,
 863072153,
 70448,
 -52364,
 863134803,
 70419,
 -52363,
 863196766,
 70446,
 -52362,
 863255253,
 70457,
 -1,
 863317282,
 70415,
 863515527,
 859083000,
 -1,
 863581053,
 863473790,
 -1,
 863646587,
 863530828,
 70467,
 -1,
 863596364,
 70468,
 863830015,
 863587575,
 70498,
 -1,
 863718647,
 70499,
 863908737,
 863506193,
 -1,
 -52353,
 863864983,
 70476,
 -52352,
 863912029,
 70472,
 -1,
 863964945,
 70462,
 864170883,
 863864983,
 70465,
 -1,
 864127127,
 70466,
 864301957,
 864108637,
 70463,
 -1,
 864239709,
 70464,
 -52346,
 864248915,
 70475,
 -1,
 864365858,
 70471,
 864564115,
 863468624,
 -1,
 864629643,
 864522241,
 -1,
 -52342,
 864581954,
 70403,
 -1,
 864645183,
 70477,
 864826254,
 864558391,
 -1,
 -52339,
 864772709,
 70400,
 -1,
 864818123,
 70401,
 865022865,
 864751377,
 -1,
 -52336,
 864980554,
 70461,
 -1,
 865034301,
 70402,
 -52334,
 864971782,
 70493,
 -1,
 865165294,
 70460,
 -52332,
 864510517,
 70480,
 -1,
 865277850,
 70487,
 -52330,
 859007741,
 127815,
 -1,
 865413893,
 127891,
 865612709,
 858926370,
 -1,
 865678240,
 865553093,
 -1,
 865743772,
 865630242,
 -1,
 -52325,
 865703988,
 65952,
 -1,
 865748630,
 65932,
 -52323,
 865690430,
 65931,
 -52322,
 865882634,
 43877,
 -52321,
 865944798,
 65933,
 -1,
 866000419,
 895,
 866254847,
 865622873,
 -1,
 -52318,
 866154695,
 129367,
 -52317,
 866204898,
 128154,
 -52316,
 866261987,
 128215,
 -1,
 866325735,
 127823,
 866530223,
 865550429,
 -1,
 866595758,
 866475614,
 -1,
 866661293,
 866530125,
 128512,
 866779135,
 866583940,
 -1,
 866792364,
 866678818,
 -1,
 -52309,
 866746970,
 129321,
 -1,
 866802078,
 128513,
 -1,
 866738978,
 129322,
 -1,
 866590354,
 128568,
 -1,
 866539125,
 128556,
 867237887,
 866476133,
 -1,
 867251123,
 867142541,
 -1,
 -52302,
 867203603,
 983109,
 -1,
 867260227,
 11218,
 -1,
 867210086,
 128151,
 867513369,
 858884247,
 -1,
 867578890,
 867458604,
 -1,
 867644395,
 867520937,
 -1,
 867709885,
 867598670,
 -1,
 867775419,
 867664206,
 -1,
 -52294,
 867711701,
 73086,
 -1,
 867766033,
 73085,
 -52292,
 867711701,
 73076,
 -1,
 867897105,
 73075,
 868103107,
 867640671,
 -1,
 868168641,
 868033887,
 -1,
 -52288,
 868104917,
 73091,
 -1,
 868159249,
 73090,
 -52286,
 868104917,
 73081,
 -1,
 868290321,
 73080,
 868496327,
 868028177,
 73056,
 -52283,
 868452503,
 73067,
 -52282,
 868499549,
 73064,
 -1,
 868552465,
 73057,
 868758473,
 868452503,
 73060,
 -1,
 868714647,
 73061,
 868889548,
 868706513,
 -1,
 -52277,
 868825813,
 73094,
 -1,
 868880145,
 73093,
 869086159,
 868834135,
 -1,
 -52274,
 869021666,
 73092,
 -1,
 869076753,
 73082,
 869282770,
 869027063,
 -1,
 -52271,
 869223753,
 73087,
 -1,
 869273361,
 73077,
 869479381,
 869223107,
 -1,
 -52268,
 869415637,
 73074,
 -1,
 869469969,
 73073,
 869675992,
 869419509,
 -1,
 -52265,
 869612245,
 73089,
 -1,
 869666577,
 73088,
 869872602,
 869613661,
 73058,
 -1,
 869810269,
 73059,
 870003677,
 869808041,
 -1,
 -52260,
 869939925,
 73079,
 -1,
 869994257,
 73078,
 870200288,
 869932343,
 -1,
 -52257,
 870136533,
 73084,
 -1,
 870190865,
 73083,
 870396899,
 870127650,
 -1,
 -52254,
 870333141,
 73071,
 -1,
 870387473,
 73070,
 -52252,
 870356744,
 73068,
 -52251,
 870551111,
 73069,
 -52250,
 870611102,
 73097,
 -52249,
 870674329,
 73096,
 -52248,
 870736979,
 73066,
 -52247,
 870798942,
 73072,
 -52246,
 870857429,
 73095,
 -1,
 870919458,
 73063,
 871117816,
 867601973,
 -1,
 871183351,
 871065727,
 -1,
 871248881,
 871108369,
 -1,
 -52241,
 871205015,
 73108,
 -52240,
 871252061,
 73105,
 -1,
 871304977,
 73098,
 871511027,
 871205015,
 73101,
 -1,
 871467159,
 73102,
 871642101,
 871448669,
 73099,
 -1,
 871579741,
 73100,
 -52234,
 871588947,
 73107,
 -1,
 871705890,
 73104,
 -1,
 871122772,
 73111,
 871969798,
 871049209,
 -1,
 872035324,
 871924046,
 -1,
 -52229,
 871994582,
 73122,
 -1,
 872038226,
 73123,
 872231935,
 871987234,
 -1,
 -52226,
 872171901,
 73126,
 -1,
 872231478,
 73127,
 872428546,
 872166182,
 -1,
 -52223,
 872376074,
 73124,
 -1,
 872433887,
 73125,
 -52221,
 872388871,
 73120,
 -52220,
 872571652,
 73121,
 -52219,
 872635842,
 73129,
 -1,
 872689152,
 73128,
 872887305,
 871922768,
 -1,
 -52216,
 872845402,
 73110,
 -1,
 872879241,
 73109,
 -1,
 872833589,
 73112,
 873149462,
 867519030,
 -1,
 873214996,
 873102416,
 -1,
 873280527,
 873169230,
 -1,
 -52210,
 873239838,
 2815,
 -1,
 873283503,
 2813,
 873477138,
 873232418,
 -1,
 -52207,
 873433776,
 2810,
 -1,
 873478890,
 2811,
 -52205,
 873420461,
 2812,
 -1,
 873603162,
 2814,
 -52203,
 873157166,
 2809,
 -1,
 873729967,
 2800,
 -52201,
 873100972,
 2678,
 -52200,
 873875607,
 127928,
 -1,
 873928006,
 128130,
 874132582,
 867445599,
 -1,
 874198116,
 874079628,
 -1,
 874263641,
 874142467,
 -1,
 874329124,
 874199751,
 -1,
 874394657,
 874254097,
 -1,
 874460192,
 874344268,
 7348,
 -1,
 874390957,
 7358,
 -1,
 874392415,
 7344,
 -52190,
 874340650,
 7349,
 -52189,
 874594748,
 7346,
 -1,
 874654559,
 7345,
 874853418,
 874257719,
 -1,
 874918952,
 874789575,
 -1,
 -52185,
 874857437,
 7337,
 -1,
 874910960,
 7341,
 -52183,
 874857303,
 7340,
 -1,
 875041582,
 7338,
 875246639,
 874807630,
 -1,
 875312174,
 875171601,
 -1,
 -52179,
 875261772,
 7330,
 -1,
 875322199,
 7319,
 -1,
 875269423,
 7353,
 875574323,
 875171601,
 -1,
 -52175,
 875518807,
 7312,
 -52174,
 875578333,
 7354,
 -1,
 875638510,
 7357,
 875836470,
 875534456,
 -1,
 -52171,
 875772992,
 7327,
 -1,
 875835118,
 7318,
 876033081,
 875788322,
 -1,
 -52168,
 875970093,
 7336,
 -1,
 876024622,
 7329,
 876229692,
 875981009,
 -1,
 -52165,
 876166208,
 7332,
 -1,
 876221680,
 7326,
 876426303,
 876170569,
 -1,
 -52162,
 876378146,
 7322,
 -1,
 876419598,
 7359,
 876622914,
 876366531,
 -1,
 -52159,
 876559424,
 7333,
 -1,
 876614446,
 7321,
 876819525,
 876562933,
 -1,
 -52156,
 876757847,
 7339,
 -1,
 876821423,
 7343,
 877016136,
 876754857,
 -1,
 -52153,
 876952495,
 7334,
 -1,
 877007662,
 7314,
 877212747,
 876948319,
 -1,
 -52150,
 877157207,
 7316,
 -1,
 877220599,
 7352,
 -52148,
 877172811,
 7351,
 -52147,
 877368872,
 7342,
 -52146,
 877433391,
 7347,
 -52145,
 877498431,
 7317,
 -52144,
 877562656,
 7331,
 -52143,
 877621175,
 7328,
 -52142,
 877686350,
 7335,
 -52141,
 877748902,
 7325,
 -52140,
 877812714,
 7324,
 -52139,
 877877028,
 7323,
 -52138,
 877937629,
 7320,
 -52137,
 877999135,
 7350,
 -52136,
 878061699,
 7315,
 -1,
 878123208,
 7313,
 878326878,
 874205609,
 -1,
 -52133,
 878282989,
 983936,
 -52132,
 878333265,
 4351,
 -52131,
 878394457,
 4350,
 -1,
 878448820,
 4349,
 878654561,
 878279975,
 -1,
 -52128,
 878614603,
 11559,
 -1,
 878645428,
 11565,
 878903295,
 878583286,
 -1,
 -52125,
 878811211,
 4295,
 -1,
 878842036,
 4301,
 -52123,
 874143144,
 129502,
 -1,
 878990893,
 128142,
 879178861,
 874078309,
 -1,
 879244394,
 879103761,
 -1,
 -52119,
 879198542,
 128016,
 -1,
 879250691,
 129349,
 -52117,
 879195417,
 129421,
 -52116,
 879383176,
 127948,
 -1,
 879442173,
 129405,
 879637619,
 879119607,
 -1,
 879703154,
 879583333,
 -1,
 -52112,
 879661937,
 127775,
 -52111,
 879726556,
 129508,
 -1,
 879761713,
 127760,
 -1,
 879629991,
 129371,
 880030839,
 879576903,
 -1,
 880096374,
 879971575,
 128103,
 -1,
 880048246,
 128714,
 -1,
 880021755,
 129426,
 -52104,
 879982626,
 983110,
 -52103,
 880230193,
 128123,
 -1,
 880284389,
 127922,
 880489894,
 858802883,
 -1,
 880555370,
 880425671,
 -1,
 880620759,
 880511509,
 -1,
 880686266,
 880562601,
 -1,
 880751749,
 880616799,
 -1,
 880817283,
 880682335,
 -1,
 -52095,
 880753365,
 70347,
 -52094,
 880813547,
 70345,
 -1,
 880873233,
 70344,
 -52092,
 880753365,
 70352,
 -1,
 881004305,
 70351,
 881210507,
 880705870,
 -1,
 881276041,
 881164622,
 -1,
 -52088,
 881212117,
 70343,
 -1,
 881266449,
 70342,
 -52086,
 881212117,
 70350,
 -1,
 881397521,
 70349,
 881603728,
 881154903,
 -1,
 -52083,
 881563400,
 70341,
 -52082,
 881613744,
 70348,
 -52081,
 881670114,
 70335,
 -1,
 881725201,
 70353,
 881931412,
 881528593,
 70320,
 -52078,
 881887383,
 70329,
 -52077,
 881934429,
 70327,
 -1,
 881987345,
 70321,
 882193560,
 881871349,
 -1,
 -52074,
 882133530,
 70339,
 -52073,
 882195157,
 70340,
 -1,
 882249489,
 70338,
 882455708,
 882128809,
 -1,
 -52070,
 882391765,
 70334,
 -52069,
 882456546,
 70333,
 -1,
 882511633,
 70332,
 882717856,
 882382882,
 -1,
 -52066,
 882653909,
 70358,
 -52065,
 882710579,
 70357,
 -1,
 882773777,
 70356,
 882980002,
 882673815,
 70324,
 -1,
 882935959,
 70325,
 883111077,
 882931746,
 -1,
 -52060,
 883047125,
 70364,
 -1,
 883101457,
 70365,
 883307688,
 883060556,
 -1,
 -52057,
 883257241,
 70346,
 -1,
 883298065,
 70361,
 883504299,
 883255505,
 -1,
 -52054,
 883440341,
 70355,
 -1,
 883494673,
 70354,
 883700910,
 883444419,
 -1,
 -52051,
 883636949,
 70331,
 -1,
 883691281,
 70330,
 883897520,
 883638365,
 70322,
 -1,
 883834973,
 70323,
 884028595,
 883825975,
 -1,
 -52046,
 883964629,
 70337,
 -1,
 884018961,
 70336,
 -52044,
 883988232,
 70360,
 -52043,
 884182599,
 70363,
 -52042,
 884236389,
 70328,
 -52041,
 884299358,
 70359,
 -52040,
 884362569,
 70362,
 -52039,
 884423381,
 70366,
 -1,
 884484959,
 70326,
 884683976,
 880617465,
 -1,
 884749502,
 884638030,
 -1,
 -52035,
 884708566,
 70386,
 -1,
 884752210,
 70387,
 884946113,
 884701218,
 -1,
 -52032,
 884885885,
 70390,
 -1,
 884945462,
 70391,
 885142724,
 884880166,
 -1,
 -52029,
 885090058,
 70388,
 -1,
 885147871,
 70389,
 -52027,
 885102855,
 70384,
 -52026,
 885285636,
 70385,
 -52025,
 885349826,
 70393,
 -1,
 885403136,
 70392,
 885601491,
 884642040,
 -1,
 885667021,
 885526289,
 -1,
 -52021,
 885622935,
 70376,
 -52020,
 885669981,
 70374,
 -1,
 885722897,
 70368,
 885929167,
 885622935,
 70371,
 -1,
 885885079,
 70372,
 886060241,
 885866589,
 70369,
 -1,
 885997661,
 70370,
 -52014,
 886005861,
 70375,
 -1,
 886123359,
 70373,
 886374399,
 885554256,
 -1,
 -52011,
 886280275,
 70378,
 -52010,
 886333422,
 70377,
 -1,
 886379657,
 70367,
 886584618,
 880566711,
 -1,
 886650128,
 886526377,
 -1,
 886715616,
 886580575,
 -1,
 886781150,
 886646111,
 -1,
 -52004,
 886717141,
 70167,
 -52003,
 886777323,
 70172,
 -1,
 886837009,
 70166,
 -52001,
 886717141,
 70173,
 -1,
 886968081,
 70171,
 887174374,
 886669646,
 -1,
 887239908,
 887128398,
 -1,
 -51997,
 887175893,
 70165,
 -1,
 887230225,
 70164,
 -51995,
 887175893,
 70170,
 -1,
 887361297,
 70169,
 887567595,
 887118679,
 -1,
 -51992,
 887527176,
 70163,
 -51991,
 887577520,
 70168,
 -51990,
 887633890,
 70157,
 -1,
 887688977,
 70174,
 887895279,
 887492369,
 70144,
 -51987,
 887851159,
 70151,
 -51986,
 887898205,
 70149,
 -1,
 887951121,
 70145,
 888157427,
 887830441,
 -1,
 -51983,
 888093397,
 70156,
 -51982,
 888158178,
 70155,
 -1,
 888213265,
 70154,
 888419575,
 888084514,
 -1,
 -51979,
 888355541,
 70179,
 -51978,
 888412211,
 70178,
 -1,
 888475409,
 70177,
 888681722,
 888367313,
 -1,
 -51975,
 888617685,
 70176,
 -1,
 888672017,
 70175,
 888878333,
 888622327,
 -1,
 -51972,
 888819017,
 70187,
 -1,
 888868625,
 70183,
 889074944,
 888818371,
 -1,
 -51969,
 889010901,
 70153,
 -1,
 889065233,
 70152,
 889271555,
 889014773,
 -1,
 -51966,
 889211418,
 70161,
 -1,
 889261841,
 70160,
 889468166,
 889199927,
 -1,
 -51963,
 889404117,
 70159,
 -1,
 889458449,
 70158,
 -51961,
 889427720,
 70181,
 -51960,
 889622087,
 70184,
 -51959,
 889686167,
 70147,
 -51958,
 889747614,
 70185,
 -51957,
 889810841,
 70182,
 -51956,
 889872485,
 70150,
 -51955,
 889935454,
 70180,
 -51954,
 889995357,
 70146,
 -51953,
 890059477,
 70186,
 -1,
 890121055,
 70148,
 890320154,
 886608120,
 -1,
 890385685,
 890244881,
 -1,
 -51949,
 890341527,
 70195,
 -51948,
 890388573,
 70193,
 -1,
 890441489,
 70188,
 890647831,
 890323037,
 70189,
 -1,
 890585181,
 70190,
 -51944,
 890603671,
 70191,
 -51943,
 890724453,
 70194,
 -1,
 890776415,
 70192,
 890975523,
 890271778,
 -1,
 891041058,
 890913526,
 -1,
 891106591,
 890992674,
 -1,
 -51938,
 891062960,
 70206,
 -1,
 891108074,
 70199,
 -51936,
 891064403,
 70197,
 -51935,
 891248622,
 70198,
 -1,
 891294857,
 70196,
 -1,
 890973339,
 70203,
 891565352,
 890905951,
 -1,
 891630887,
 891512457,
 -1,
 -51930,
 891582866,
 70204,
 -1,
 891627106,
 70201,
 -1,
 891556795,
 70200,
 -51927,
 891524496,
 70202,
 -1,
 891817903,
 70205,
 892024165,
 886528191,
 -1,
 892089691,
 891953877,
 -1,
 892155189,
 892043598,
 -1,
 892220720,
 892109597,
 -1,
 -51921,
 892166245,
 983950,
 -1,
 892210961,
 983948,
 892417331,
 892156615,
 -1,
 -51918,
 892362853,
 983955,
 -1,
 892407569,
 983953,
 -51916,
 892362853,
 983954,
 -1,
 892538641,
 983952,
 892745018,
 892099415,
 -1,
 -51913,
 892704854,
 983946,
 -51912,
 892756069,
 983956,
 -51911,
 892811789,
 983941,
 -1,
 892866321,
 983951,
 893072704,
 892684995,
 -1,
 893138238,
 893008583,
 -1,
 -51907,
 893083749,
 983940,
 -1,
 893128465,
 983938,
 -51905,
 893083749,
 983939,
 -1,
 893259537,
 983937,
 893465926,
 893001015,
 -1,
 893531460,
 893401799,
 -1,
 -51901,
 893476965,
 983945,
 -1,
 893521681,
 983943,
 -51899,
 893476965,
 983944,
 -1,
 893652753,
 983942,
 893859146,
 893417506,
 -1,
 -51896,
 893810846,
 983967,
 -51895,
 893860565,
 983966,
 -1,
 893914897,
 983968,
 894121295,
 893806801,
 -1,
 894186830,
 894057159,
 -1,
 -51891,
 894132325,
 983960,
 -1,
 894177041,
 983958,
 -1,
 894132325,
 983959,
 894448978,
 894061815,
 -1,
 -51887,
 894394469,
 983964,
 -1,
 894439185,
 983970,
 894645589,
 894379359,
 -1,
 -51884,
 894591077,
 983949,
 -1,
 894635793,
 983947,
 -51882,
 894605398,
 983962,
 -51881,
 894799988,
 983965,
 -51880,
 894858949,
 983963,
 -51879,
 894917142,
 983961,
 -51878,
 894974677,
 983969,
 -1,
 895031347,
 983957,
 895235425,
 892027957,
 -1,
 895300958,
 895186967,
 983973,
 -1,
 895260333,
 983974,
 895483903,
 895249965,
 -1,
 -51872,
 895387799,
 983972,
 -1,
 895429471,
 983975,
 895680511,
 895193336,
 -1,
 -51869,
 895574581,
 983976,
 -51868,
 895623637,
 983971,
 -1,
 895684463,
 983977,
 895942655,
 891950523,
 -1,
 895956329,
 895832489,
 -1,
 -51864,
 895913981,
 68149,
 -1,
 895977361,
 68148,
 -1,
 895891184,
 68168,
 896218501,
 880480017,
 -1,
 896284026,
 896172604,
 -1,
 896349554,
 896211490,
 -1,
 -51858,
 896305303,
 983985,
 -51857,
 896360549,
 983987,
 -51856,
 896417885,
 983984,
 -51855,
 896478047,
 983986,
 -1,
 896536337,
 983983,
 896794623,
 896274193,
 -1,
 896808313,
 896681617,
 -1,
 896873847,
 896762190,
 -1,
 -51850,
 896829591,
 983989,
 -1,
 896884837,
 983990,
 -51848,
 896821457,
 983991,
 -1,
 896999102,
 983988,
 -1,
 896757963,
 110592,
 897267075,
 896228183,
 -1,
 897332610,
 897211354,
 -1,
 897398145,
 897285200,
 -1,
 897463680,
 897349666,
 -1,
 -51841,
 897411361,
 3200,
 -1,
 897466785,
 3204,
 -1,
 897392078,
 3201,
 -1,
 897339850,
 983203,
 -1,
 897267788,
 129432,
 -51836,
 897206460,
 69837,
 -1,
 897781645,
 128331,
 897987993,
 896152340,
 128273,
 898053528,
 897916401,
 -1,
 898119061,
 897984505,
 -1,
 898184587,
 898072910,
 -1,
 -51830,
 898143446,
 983556,
 -1,
 898187090,
 983557,
 898381198,
 898136098,
 -1,
 -51827,
 898320765,
 983560,
 -1,
 898380342,
 983561,
 898577809,
 898315046,
 -1,
 -51824,
 898524938,
 983558,
 -1,
 898582751,
 983559,
 -51822,
 898537735,
 983554,
 -51821,
 898720516,
 983555,
 -51820,
 898784706,
 983563,
 -1,
 898838016,
 983562,
 -51818,
 898073304,
 128287,
 -51817,
 898981902,
 983552,
 -1,
 899028678,
 983553,
 -1,
 897981329,
 128422,
 899298724,
 897925213,
 -1,
 899364258,
 899251907,
 128143,
 899429793,
 899302654,
 -1,
 899495328,
 899363661,
 128535,
 899612671,
 899417476,
 -1,
 -51809,
 899513785,
 128537,
 -1,
 899555730,
 128538,
 -1,
 899423864,
 128573,
 -1,
 899351231,
 128139,
 -51805,
 899322711,
 129373,
 -1,
 899832439,
 128088,
 -51803,
 899249892,
 11235,
 -1,
 899965096,
 128040,
 900150954,
 880447769,
 -1,
 900216359,
 900075281,
 -1,
 900281877,
 900165705,
 -1,
 900347345,
 900234535,
 -1,
 900412847,
 900306605,
 -1,
 900478381,
 900368535,
 71875,
 -1,
 900418037,
 71886,
 -51794,
 900423781,
 71877,
 -1,
 900534033,
 71876,
 900740533,
 900348615,
 -1,
 900806067,
 900685925,
 -1,
 -51790,
 900757369,
 71899,
 -1,
 900813895,
 71898,
 -51788,
 900745704,
 71897,
 -1,
 900928752,
 71900,
 901133753,
 900665105,
 71873,
 -51785,
 901087566,
 71893,
 -51784,
 901143888,
 71882,
 -1,
 901207572,
 71894,
 901395901,
 901065567,
 71880,
 901513215,
 901339991,
 -1,
 -51780,
 901420717,
 71885,
 -1,
 901471063,
 71888,
 901658048,
 901351575,
 -1,
 -51777,
 901613719,
 71879,
 -1,
 901651767,
 71887,
 901854659,
 901609506,
 -1,
 -51774,
 901808344,
 71901,
 -1,
 901858128,
 71902,
 902051269,
 901800037,
 71881,
 -1,
 901981845,
 71889,
 902182344,
 901995351,
 -1,
 -51769,
 902138724,
 71891,
 -1,
 902182885,
 71872,
 -51767,
 902140737,
 71874,
 -51766,
 902336623,
 71903,
 -51765,
 902399854,
 71890,
 -51764,
 902458749,
 71896,
 -51763,
 902515821,
 71884,
 -51762,
 902579024,
 71878,
 -51761,
 902641634,
 71883,
 -51760,
 902702571,
 71892,
 -1,
 902765761,
 71895,
 902968825,
 900275702,
 -1,
 903034327,
 902928045,
 -1,
 903099861,
 902989975,
 71843,
 -1,
 903039477,
 71854,
 -51754,
 903045221,
 71845,
 -1,
 903155473,
 71844,
 903362013,
 902970055,
 -1,
 903427547,
 903307365,
 -1,
 -51750,
 903378809,
 71867,
 -1,
 903435335,
 71866,
 -51748,
 903367144,
 71865,
 -1,
 903550192,
 71868,
 903755233,
 903286545,
 71841,
 -51745,
 903709006,
 71861,
 -51744,
 903765328,
 71850,
 -1,
 903829012,
 71862,
 904017381,
 903687007,
 71848,
 904134655,
 903961431,
 -1,
 -51740,
 904042157,
 71853,
 -1,
 904092503,
 71856,
 904279528,
 903973015,
 -1,
 -51737,
 904235159,
 71847,
 -1,
 904273207,
 71855,
 904476139,
 904230946,
 -1,
 -51734,
 904429784,
 71869,
 -1,
 904479568,
 71870,
 904672749,
 904421477,
 71849,
 -1,
 904603285,
 71857,
 904803824,
 904616791,
 -1,
 -51729,
 904760164,
 71859,
 -1,
 904804325,
 71840,
 -51727,
 904762177,
 71842,
 -51726,
 904958063,
 71871,
 -51725,
 905021294,
 71858,
 -51724,
 905080189,
 71864,
 -51723,
 905137261,
 71852,
 -51722,
 905200464,
 71846,
 -51721,
 905263074,
 71851,
 -51720,
 905324011,
 71860,
 -1,
 905387201,
 71863,
 905590279,
 902899705,
 -1,
 905655805,
 905544014,
 -1,
 -51716,
 905614550,
 71906,
 -1,
 905658194,
 71907,
 905852416,
 905607202,
 -1,
 -51713,
 905791869,
 71910,
 -1,
 905851446,
 71911,
 906049027,
 905786150,
 -1,
 -51710,
 905996042,
 71908,
 -1,
 906053855,
 71909,
 -51708,
 906008839,
 71904,
 -51707,
 906191620,
 71905,
 -51706,
 906255810,
 71913,
 -1,
 906309120,
 71912,
 906507796,
 905535476,
 -1,
 906573324,
 906461518,
 -1,
 -51702,
 906531430,
 71915,
 -51701,
 906575475,
 71916,
 -1,
 906637038,
 71914,
 906835471,
 906524706,
 -1,
 -51698,
 906774979,
 71919,
 -1,
 906834543,
 71920,
 907032082,
 906769190,
 -1,
 -51695,
 906978766,
 71917,
 -1,
 907035128,
 71918,
 -51693,
 906976763,
 71922,
 -1,
 907161159,
 71921,
 -1,
 906453557,
 71935,
 907425308,
 900236007,
 -1,
 907490843,
 907345920,
 -1,
 -51688,
 907448782,
 127754,
 -51687,
 907504763,
 129341,
 -51686,
 907551134,
 128702,
 -1,
 907615432,
 128003,
 -1,
 907434120,
 127817,
 907884064,
 907382861,
 -1,
 -51682,
 907842287,
 127987,
 -51681,
 907885529,
 128075,
 -1,
 907942616,
 127988,
 908146211,
 907843168,
 -1,
 -51678,
 908081543,
 127764,
 -1,
 908141550,
 127762,
 908342822,
 908090882,
 -1,
 -51675,
 908278151,
 127766,
 -1,
 908338158,
 127768,
 -1,
 908296088,
 128465,
 908605028,
 900153437,
 -1,
 908670555,
 908535512,
 -1,
 908736054,
 908623392,
 -1,
 908801584,
 908694151,
 -1,
 -51668,
 908758916,
 129159,
 -51667,
 908810237,
 129143,
 -51666,
 908874492,
 129127,
 -51665,
 908934420,
 129151,
 -1,
 908990697,
 129135,
 909246463,
 908733488,
 -1,
 -51662,
 909152132,
 129158,
 -51661,
 909203453,
 129142,
 -51660,
 909267708,
 129126,
 -51659,
 909327636,
 129150,
 -1,
 909383913,
 129134,
 909588035,
 908680914,
 -1,
 909653565,
 909546119,
 -1,
 -51655,
 909610884,
 129156,
 -51654,
 909662205,
 129140,
 -51653,
 909726460,
 129124,
 -51652,
 909786388,
 129148,
 -1,
 909842665,
 129132,
 910098431,
 909585456,
 -1,
 -51649,
 910004100,
 129157,
 -51648,
 910055421,
 129141,
 -51647,
 910119676,
 129125,
 -51646,
 910179604,
 129149,
 -1,
 910235881,
 129133,
 910440009,
 909544589,
 -1,
 -51643,
 910397316,
 129153,
 -51642,
 910448637,
 129137,
 -51641,
 910512892,
 129121,
 -51640,
 910572820,
 129145,
 -1,
 910629097,
 129129,
 910833231,
 910390448,
 -1,
 -51637,
 910790532,
 129154,
 -51636,
 910841853,
 129138,
 -51635,
 910906108,
 129122,
 -51634,
 910966036,
 129146,
 -1,
 911022313,
 129130,
 911226453,
 910774499,
 -1,
 -51631,
 911183748,
 129152,
 -51630,
 911235069,
 129136,
 -51629,
 911299324,
 129120,
 -51628,
 911359252,
 129144,
 -1,
 911415529,
 129128,
 911671295,
 911157861,
 -1,
 -51625,
 911576964,
 129155,
 -51624,
 911628285,
 129139,
 -51623,
 911692540,
 129123,
 -51622,
 911752468,
 129147,
 -1,
 911808745,
 129131,
 912012897,
 908614487,
 -1,
 912078431,
 911943009,
 -1,
 -51618,
 912007156,
 127888,
 -1,
 912071534,
 127788,
 -51616,
 912018478,
 128521,
 -1,
 912206728,
 127863,
 -51614,
 911962536,
 128430,
 -51613,
 912348606,
 129344,
 -1,
 912406803,
 11838,
 912602766,
 908540615,
 -1,
 912668301,
 912541864,
 -1,
 912733809,
 912619554,
 -1,
 912799340,
 912689952,
 127779,
 912916479,
 912719872,
 -1,
 912930411,
 912791903,
 127781,
 -1,
 912852847,
 127782,
 -1,
 912888875,
 127780,
 913178623,
 912748193,
 -1,
 913192560,
 913056547,
 -1,
 -51601,
 913149898,
 128916,
 -1,
 913201195,
 128917,
 -1,
 913120544,
 128307,
 913454712,
 912663903,
 -1,
 913520245,
 913401998,
 -1,
 -51596,
 913461243,
 128407,
 -1,
 913512552,
 128071,
 913768447,
 913457439,
 -1,
 -51593,
 913674167,
 128922,
 -1,
 913725455,
 128923,
 913913468,
 913394935,
 -1,
 -51590,
 913860779,
 128928,
 -51589,
 913911202,
 128072,
 -1,
 913971004,
 128326,
 914175615,
 913849031,
 -1,
 -51586,
 914107509,
 9989,
 -1,
 914167088,
 128427,
 914372226,
 914109222,
 -1,
 -51583,
 914319190,
 11214,
 -1,
 914380154,
 128174,
 914568837,
 914298338,
 -1,
 -51580,
 914524272,
 129197,
 -1,
 914580228,
 129196,
 -51578,
 914525112,
 128070,
 -51577,
 914720241,
 128382,
 -51576,
 914781114,
 128073,
 -51575,
 914845480,
 10068,
 -51574,
 914909857,
 127985,
 -51573,
 914971266,
 11229,
 -51572,
 915026637,
 10069,
 -1,
 915087413,
 128906,
 -1,
 912593457,
 128011,
 915355292,
 912547941,
 -1,
 915420824,
 915297812,
 -1,
 915486359,
 915346222,
 128105,
 915551894,
 915437604,
 -1,
 -51565,
 915503353,
 128097,
 -51564,
 915553386,
 128082,
 -51563,
 915612069,
 128090,
 -1,
 915676136,
 128098,
 -1,
 915473831,
 128111,
 -1,
 915419027,
 128698,
 916010651,
 915369804,
 -1,
 -51558,
 915960630,
 128543,
 -1,
 916016871,
 128506,
 -1,
 915952256,
 128058,
 916272804,
 915286879,
 -1,
 916338336,
 916209757,
 -1,
 -51553,
 916273522,
 127947,
 -1,
 916336905,
 983234,
 916534947,
 916264528,
 -1,
 -51550,
 916468557,
 128553,
 -1,
 916528736,
 128576,
 -1,
 916465313,
 128146,
 916797097,
 916221772,
 -1,
 916862632,
 916728671,
 -1,
 -51545,
 916815826,
 129340,
 -1,
 916872221,
 128295,
 -1,
 916788441,
 127873,
 -1,
 916736501,
 983229,
 917190560,
 900099916,
 -1,
 917255946,
 917127261,
 983153,
 917321462,
 917190991,
 -1,
 917386979,
 917279108,
 -1,
 917452486,
 917340494,
 -1,
 917518020,
 917402390,
 -1,
 917583555,
 917440580,
 -1,
 917649089,
 917509596,
 11106,
 917766143,
 917569536,
 -1,
 917780159,
 917672855,
 -1,
 917845687,
 917722247,
 -1,
 -51530,
 917802117,
 11173,
 -1,
 917842523,
 11175,
 918042298,
 917776586,
 -1,
 -51527,
 917999464,
 983238,
 -1,
 918044419,
 11132,
 -51525,
 917999514,
 129074,
 -51524,
 918182903,
 129058,
 -51523,
 918247454,
 129062,
 -51522,
 918306085,
 129070,
 -1,
 918363071,
 129066,
 -51520,
 917734728,
 11122,
 -1,
 918513641,
 11138,
 -51518,
 917596477,
 11142,
 -1,
 918627970,
 11116,
 -1,
 917504174,
 129170,
 -51515,
 917476660,
 11246,
 -1,
 918840490,
 129187,
 919025358,
 917378549,
 -1,
 919090890,
 918977811,
 -1,
 -51511,
 919045765,
 129026,
 -1,
 919089247,
 129042,
 -51509,
 919035655,
 129178,
 -51508,
 919230521,
 129030,
 -51507,
 919293512,
 129034,
 -1,
 919351391,
 129046,
 919549652,
 918951970,
 -1,
 919615186,
 919489885,
 -1,
 -51503,
 919543972,
 11146,
 -1,
 919606748,
 11157,
 -51501,
 919561807,
 129185,
 -1,
 919736333,
 129193,
 919942871,
 919500834,
 -1,
 -51498,
 919891624,
 129082,
 -1,
 919934016,
 129106,
 920139482,
 919891788,
 -1,
 -51495,
 920084721,
 128622,
 -1,
 920142507,
 129189,
 920336093,
 920075533,
 -1,
 -51492,
 920265320,
 129090,
 -1,
 920327644,
 129094,
 920532704,
 920269606,
 -1,
 -51489,
 920483562,
 129195,
 -1,
 920536547,
 129078,
 -51487,
 920490697,
 129174,
 -51486,
 920670380,
 129191,
 -1,
 920724072,
 129086,
 920925935,
 917307392,
 -1,
 920991466,
 920878669,
 -1,
 921057001,
 920916485,
 128360,
 921174015,
 920978820,
 -1,
 -51480,
 921076723,
 128362,
 -1,
 921133903,
 128361,
 -1,
 920988805,
 128489,
 921384685,
 920926933,
 -1,
 -51476,
 921328718,
 128381,
 -1,
 921391730,
 11241,
 -51474,
 921338757,
 128493,
 -1,
 921506790,
 128495,
 921763839,
 920848413,
 -1,
 921777907,
 921645917,
 -1,
 -51470,
 921711866,
 129308,
 -1,
 921769380,
 1421,
 -51468,
 921732440,
 8295,
 -51467,
 921922639,
 128270,
 -1,
 921975812,
 9957,
 922171140,
 917248280,
 127872,
 922288127,
 922091644,
 -1,
 922302203,
 922192781,
 -1,
 -51462,
 922252107,
 11187,
 -1,
 922308539,
 11186,
 922498814,
 922252113,
 -1,
 -51459,
 922454922,
 11189,
 -1,
 922495446,
 11191,
 922695425,
 922439616,
 -1,
 -51456,
 922651530,
 11188,
 -1,
 922692054,
 11190,
 922943487,
 922626523,
 -1,
 -51453,
 922841931,
 11185,
 -1,
 922898363,
 11184,
 923088646,
 922115408,
 128141,
 -1,
 923026691,
 128365,
 923219721,
 923016897,
 -1,
 -51448,
 923149243,
 127832,
 -1,
 923211943,
 127833,
 -1,
 923153734,
 129350,
 923481926,
 917187423,
 -1,
 923547430,
 923417014,
 -1,
 -51443,
 923506808,
 127487,
 -51442,
 923571885,
 127486,
 -51441,
 923637234,
 127485,
 -51440,
 923701529,
 127484,
 -51439,
 923766325,
 127483,
 -51438,
 923830423,
 127482,
 -51437,
 923894094,
 127481,
 -51436,
 923957282,
 127480,
 -51435,
 924020556,
 127479,
 -51434,
 924085805,
 127478,
 -51433,
 924149969,
 127477,
 -51432,
 924213349,
 127476,
 -51431,
 924277591,
 127475,
 -51430,
 924341780,
 127474,
 -51429,
 924404983,
 127473,
 -51428,
 924469955,
 127472,
 -51427,
 924535285,
 127471,
 -51426,
 924598365,
 127470,
 -51425,
 924662471,
 127469,
 -51424,
 924727209,
 127468,
 -51423,
 924791590,
 127467,
 -51422,
 924855135,
 127466,
 -51421,
 924919135,
 127465,
 -51420,
 924982583,
 127464,
 -51419,
 925046818,
 127463,
 -1,
 925110033,
 127462,
 925316921,
 923504181,
 -1,
 925382456,
 925249796,
 -1,
 925447986,
 925312353,
 -1,
 925513516,
 925402171,
 -1,
 -51413,
 925469669,
 128402,
 -1,
 925510192,
 128403,
 925710127,
 925462348,
 -1,
 -51410,
 925647459,
 11262,
 -1,
 925700509,
 128401,
 -51408,
 925667332,
 128404,
 -51407,
 925842403,
 128405,
 -1,
 925901358,
 11841,
 926154751,
 925368320,
 -1,
 926168886,
 926044844,
 -1,
 -51403,
 926112934,
 983151,
 -1,
 926169427,
 128968,
 -51401,
 926106707,
 983152,
 -1,
 926293918,
 128639,
 -1,
 925327911,
 128158,
 926562109,
 925244727,
 -1,
 -51397,
 926511420,
 128665,
 -51396,
 926573937,
 983112,
 -1,
 926625362,
 129534,
 926824256,
 926517172,
 -1,
 -51393,
 926774091,
 11153,
 -1,
 926830523,
 11152,
 927020867,
 926754145,
 -1,
 -51390,
 926955938,
 129511,
 -1,
 927012071,
 127822,
 -51388,
 926974075,
 128699,
 -51387,
 927160778,
 127895,
 -1,
 927224555,
 128524,
 927414115,
 923426917,
 -1,
 927479635,
 927370040,
 -1,
 927545168,
 927411446,
 -1,
 927610700,
 927496840,
 -1,
 -51381,
 927566166,
 127588,
 -1,
 927622790,
 127586,
 -51379,
 927569485,
 127587,
 -51378,
 927749614,
 127585,
 -51377,
 927807384,
 127584,
 -1,
 927866232,
 127589,
 928120831,
 927465472,
 -1,
 -51374,
 928023139,
 128907,
 -1,
 928083458,
 128205,
 928266073,
 927421395,
 -1,
 928331607,
 928197471,
 -1,
 -51370,
 928280398,
 127906,
 -1,
 928327132,
 128478,
 -51368,
 928269676,
 129315,
 -1,
 928449339,
 129531,
 928659292,
 928219754,
 -1,
 -51365,
 928617210,
 11215,
 -1,
 928666420,
 11213,
 928855902,
 928610683,
 127801,
 -1,
 928810862,
 127989,
 -51361,
 928813592,
 128675,
 -51360,
 928933353,
 128019,
 -51359,
 928981322,
 128640,
 -51358,
 929045486,
 129302,
 -1,
 929109683,
 127840,
 929314688,
 927338257,
 -1,
 929380213,
 929251421,
 -1,
 929445745,
 929331628,
 -1,
 929511274,
 929381299,
 9995,
 929628159,
 929432964,
 -1,
 -51351,
 929524230,
 128406,
 -1,
 929576143,
 128400,
 929773421,
 929453588,
 -1,
 -51348,
 929703341,
 127339,
 -1,
 929766723,
 127338,
 -51346,
 929707258,
 9994,
 -51345,
 929900679,
 11827,
 -51344,
 929964590,
 11828,
 -1,
 930027611,
 129306,
 930232180,
 929388043,
 -1,
 -51341,
 930186777,
 128740,
 -1,
 930225734,
 128643,
 -1,
 930176014,
 127752,
 930494330,
 929307959,
 -1,
 930559865,
 930432254,
 -1,
 -51336,
 930503310,
 127949,
 -1,
 930553414,
 127950,
 -1,
 930489178,
 129437,
 930822012,
 930424856,
 128251,
 -1,
 930742538,
 128280,
 930953086,
 930748691,
 128007,
 -1,
 930873806,
 128048,
 -51329,
 930906446,
 128000,
 -1,
 931026452,
 128015,
 931215257,
 929269911,
 -1,
 931280784,
 931158871,
 -1,
 931346317,
 931217733,
 -1,
 931411850,
 931280649,
 -1,
 931477383,
 931335953,
 -1,
 -51322,
 931410227,
 5880,
 -1,
 931470647,
 5879,
 -51320,
 931423699,
 5876,
 -51319,
 931612650,
 5877,
 -1,
 931671507,
 5878,
 -51317,
 931363464,
 5874,
 -51316,
 931816531,
 5875,
 -1,
 931875523,
 5873,
 932118527,
 931289943,
 -1,
 -51313,
 932005280,
 127933,
 -1,
 932065397,
 127939,
 932263831,
 931233526,
 -1,
 -51310,
 932220973,
 11251,
 -51309,
 932283972,
 11256,
 -51308,
 932346319,
 11255,
 -51307,
 932409155,
 11253,
 -51306,
 932470573,
 11252,
 -1,
 932518509,
 11254,
 -51304,
 932198518,
 127945,
 -1,
 932649757,
 8381,
 932853662,
 931155191,
 -1,
 -51301,
 932798565,
 983226,
 -51300,
 932861460,
 983221,
 -51299,
 932921437,
 983231,
 -1,
 932981599,
 983223,
 -51297,
 932804642,
 983113,
 -1,
 933117509,
 129423,
 933312608,
 917121887,
 -1,
 933378013,
 933252343,
 -1,
 933443542,
 933304564,
 -1,
 933509032,
 933387095,
 -1,
 -51291,
 933448258,
 66837,
 -51290,
 933505887,
 66835,
 -51289,
 933570224,
 66821,
 -1,
 933629713,
 66836,
 933836718,
 933443497,
 -1,
 933902252,
 933771975,
 -1,
 -51285,
 933833567,
 66853,
 -1,
 933892865,
 66854,
 -51283,
 933841474,
 66827,
 -1,
 934030175,
 66826,
 934229937,
 933795960,
 -1,
 -51280,
 934165643,
 66852,
 -1,
 934226783,
 66851,
 934426548,
 934183246,
 -1,
 -51277,
 934362251,
 66846,
 -1,
 934423391,
 66845,
 934623159,
 934377506,
 -1,
 -51274,
 934558859,
 66844,
 -1,
 934619999,
 66843,
 934819770,
 934571852,
 -1,
 -51271,
 934768904,
 66842,
 -1,
 934816607,
 66841,
 935016381,
 934759671,
 -1,
 -51268,
 934956836,
 66833,
 -1,
 935013215,
 66832,
 935212992,
 934955715,
 -1,
 -51265,
 935148683,
 66855,
 -1,
 935209823,
 66831,
 935409602,
 935144287,
 66824,
 -1,
 935346269,
 66823,
 935540677,
 935339359,
 -1,
 -51260,
 935476363,
 66822,
 -1,
 935537503,
 66820,
 935737288,
 935468343,
 -1,
 -51257,
 935672971,
 66819,
 -1,
 935734111,
 66818,
 -51255,
 935696045,
 66850,
 -51254,
 935892538,
 66849,
 -51253,
 935956077,
 66848,
 -51252,
 936020119,
 66847,
 -51251,
 936078930,
 66840,
 -51250,
 936143436,
 66839,
 -51249,
 936206437,
 66838,
 -51248,
 936269776,
 66834,
 -51247,
 936331842,
 66830,
 -51246,
 936394845,
 66829,
 -51245,
 936459403,
 66828,
 -51244,
 936522677,
 66825,
 -51243,
 936581422,
 66817,
 -1,
 936644369,
 66816,
 936851420,
 933374815,
 -1,
 936916955,
 936780974,
 -1,
 -51239,
 936871357,
 128294,
 -51238,
 936930289,
 128268,
 -1,
 936989453,
 128161,
 -1,
 936864526,
 128024,
 -1,
 936784678,
 129501,
 937310219,
 933331278,
 -1,
 937375753,
 937246287,
 -1,
 937441286,
 937328881,
 -1,
 937506799,
 937370975,
 -1,
 937572328,
 937465976,
 -1,
 937637860,
 937503583,
 43797,
 -1,
 937569119,
 43796,
 -51227,
 937592983,
 43793,
 -51226,
 937713765,
 43798,
 -51225,
 937771101,
 43794,
 -1,
 937824103,
 43795,
 938082303,
 937502613,
 -1,
 938096619,
 937962335,
 43789,
 -1,
 938027871,
 43788,
 -51220,
 938051735,
 43785,
 -51219,
 938172517,
 43790,
 -51218,
 938229853,
 43786,
 -1,
 938282855,
 43787,
 938489847,
 937434803,
 -1,
 938555378,
 938421087,
 43813,
 -1,
 938486623,
 43812,
 938686452,
 938479377,
 43808,
 -1,
 938610449,
 43811,
 -51211,
 938641559,
 43809,
 -51210,
 938762341,
 43814,
 -1,
 938819677,
 43810,
 939014143,
 938416400,
 -1,
 939079674,
 938945375,
 43821,
 -1,
 939010911,
 43820,
 939210748,
 939003665,
 43816,
 -1,
 939134737,
 43819,
 -51203,
 939165847,
 43817,
 -51202,
 939286629,
 43822,
 -1,
 939343965,
 43818,
 939589631,
 938968973,
 -1,
 939603970,
 939469663,
 43781,
 -1,
 939535199,
 43780,
 -51197,
 939559063,
 43777,
 -51196,
 939679845,
 43782,
 -51195,
 939737181,
 43778,
 -1,
 939790183,
 43779,
 940048383,
 937370121,
 -1,
 -51192,
 939954389,
 4958,
 -1,
 939997352,
 4957,
 -51190,
 937334258,
 983047,
 -1,
 940120098,
 983096,
 940324896,
 937252372,
 -1,
 940390424,
 940270002,
 -1,
 940455955,
 940333607,
 -1,
 -51185,
 940379337,
 127999,
 -51184,
 940444703,
 127998,
 -51183,
 940510083,
 127997,
 -51182,
 940575434,
 127996,
 -1,
 940640738,
 127995,
 940900351,
 940384850,
 -1,
 -51179,
 940806930,
 129459,
 -51178,
 940863893,
 129456,
 -51177,
 940909830,
 129457,
 -1,
 940972194,
 129458,
 941228031,
 940338552,
 -1,
 941242397,
 941121300,
 128453,
 941359103,
 941163471,
 -1,
 -51172,
 941242509,
 128454,
 -1,
 941303135,
 128455,
 941504543,
 941189428,
 128460,
 -1,
 941455394,
 128461,
 -1,
 941434960,
 128459,
 941701170,
 940268375,
 -1,
 941766701,
 941630817,
 -1,
 941832236,
 941711661,
 -1,
 941897767,
 941785422,
 -1,
 941963302,
 941846612,
 983048,
 -1,
 941883643,
 983095,
 -1,
 941896457,
 983046,
 -51160,
 941849014,
 983134,
 -51159,
 942107998,
 983178,
 -51158,
 942168046,
 983099,
 -51157,
 942232448,
 983064,
 -1,
 942291569,
 983177,
 -1,
 941790183,
 128282,
 942553136,
 941723328,
 -1,
 -51153,
 942494569,
 128388,
 -1,
 942549688,
 128233,
 942800895,
 942501421,
 983051,
 -1,
 942705298,
 983050,
 942880831,
 941659634,
 -1,
 942946366,
 942835218,
 -1,
 943011901,
 942878418,
 -1,
 943077432,
 942969525,
 -1,
 -51145,
 943029922,
 128915,
 -1,
 943071278,
 128905,
 943274043,
 943028258,
 -1,
 -51142,
 943212939,
 128954,
 -1,
 943264451,
 128942,
 -51140,
 943209047,
 128935,
 -1,
 943404318,
 128948,
 -1,
 942937870,
 128125,
 -1,
 942894395,
 128529,
 943732810,
 942804753,
 -1,
 943798345,
 943681356,
 128066,
 943863878,
 943751968,
 -1,
 943929413,
 943787793,
 -1,
 -51132,
 943881221,
 127759,
 -1,
 943937742,
 127758,
 -1,
 943862293,
 127757,
 944242687,
 943784724,
 -1,
 -51128,
 944141093,
 127806,
 -1,
 944199372,
 127805,
 -1,
 943733225,
 129413,
 944453709,
 943691593,
 128065,
 -51124,
 944404514,
 128064,
 -1,
 944454113,
 128083,
 944650321,
 944404514,
 -1,
 944715856,
 944577847,
 983104,
 -1,
 944641197,
 983103,
 -1,
 944639761,
 983135,
 944912469,
 944595045,
 -1,
 -51117,
 944865614,
 983049,
 -51116,
 944920084,
 983100,
 -1,
 944983287,
 983067,
 945174616,
 944868704,
 -1,
 -51113,
 945122500,
 127972,
 -1,
 945167961,
 127984,
 945371227,
 945124846,
 -1,
 -51110,
 945326137,
 11249,
 -1,
 945382148,
 11248,
 -51108,
 945327862,
 127794,
 -51107,
 945516162,
 11257,
 -51106,
 945580299,
 983179,
 -51105,
 945633513,
 129370,
 -1,
 945686615,
 128231,
 945895657,
 933249117,
 -1,
 945961179,
 945838935,
 -1,
 946026692,
 945890655,
 983129,
 946092227,
 945963101,
 -1,
 946157762,
 946019658,
 -1,
 946223289,
 946102260,
 -1,
 946288759,
 946176334,
 -1,
 946354286,
 946245913,
 -1,
 946419820,
 946298981,
 126066,
 946536447,
 946339840,
 -1,
 -51093,
 946439060,
 126093,
 -1,
 946487312,
 126084,
 946733055,
 946352099,
 126075,
 -1,
 946603209,
 126102,
 946813045,
 946289351,
 -1,
 946878579,
 946762178,
 126067,
 946995199,
 946798592,
 -1,
 -51086,
 946897812,
 126094,
 -1,
 946946064,
 126085,
 947191807,
 946816993,
 126076,
 -1,
 947061961,
 126103,
 947322879,
 946745070,
 126074,
 -1,
 947193033,
 126101,
 947402884,
 946239522,
 -1,
 947468414,
 947341693,
 126070,
 947533947,
 947423355,
 126079,
 -1,
 947455177,
 126106,
 947716095,
 947453952,
 -1,
 -51075,
 947618708,
 126097,
 -1,
 947666960,
 126088,
 947912703,
 947401270,
 126071,
 947927169,
 947816571,
 126080,
 -1,
 947848393,
 126107,
 948109311,
 947847168,
 -1,
 -51069,
 948011924,
 126098,
 -1,
 948060176,
 126089,
 948254867,
 947335974,
 -1,
 948320396,
 948199525,
 -1,
 948385930,
 948276448,
 126068,
 948502527,
 948305920,
 -1,
 -51063,
 948405140,
 126095,
 -1,
 948453392,
 126086,
 948699135,
 948336611,
 126077,
 -1,
 948569289,
 126104,
 948830207,
 948256861,
 -1,
 948844689,
 948735597,
 126069,
 948961279,
 948764672,
 -1,
 -51056,
 948863892,
 126096,
 -1,
 948912144,
 126087,
 949157887,
 948778900,
 126078,
 -1,
 949028041,
 126105,
 949237920,
 948202801,
 -1,
 949303447,
 949190990,
 -1,
 -51050,
 949261526,
 126116,
 -1,
 949305170,
 126117,
 949500058,
 949254178,
 -1,
 -51047,
 949438845,
 126120,
 -1,
 949498422,
 126121,
 949696669,
 949433126,
 -1,
 -51044,
 949643018,
 126118,
 -1,
 949700831,
 126119,
 -51042,
 949641988,
 126115,
 -51041,
 949837250,
 126123,
 -1,
 949890560,
 126122,
 950089894,
 949181890,
 126073,
 950155427,
 950044795,
 126082,
 -1,
 950076617,
 126109,
 950337535,
 950075392,
 -1,
 -51035,
 950240148,
 126100,
 -1,
 950288400,
 126091,
 950483116,
 950021632,
 126072,
 950548649,
 950441645,
 126081,
 -1,
 950469833,
 126108,
 950730751,
 950468608,
 -1,
 -51029,
 950633364,
 126099,
 -1,
 950681616,
 126090,
 950876336,
 950428420,
 126065,
 950992895,
 950796288,
 -1,
 -51025,
 950895508,
 126092,
 -1,
 950943760,
 126083,
 951138485,
 950801035,
 -1,
 951204020,
 951091534,
 -1,
 -51021,
 951162070,
 126130,
 -1,
 951201553,
 126131,
 -1,
 951149316,
 126129,
 951466167,
 951078333,
 126110,
 -1,
 951391022,
 126111,
 951648255,
 951405401,
 126113,
 -1,
 951522094,
 126114,
 951728318,
 946157286,
 -1,
 951793853,
 951673608,
 -1,
 -51012,
 951742133,
 126125,
 -1,
 951794525,
 126126,
 -1,
 951747556,
 126127,
 -51009,
 951678988,
 126128,
 -51008,
 952003436,
 126124,
 -51007,
 952061378,
 126112,
 -1,
 952111766,
 126132,
 -1,
 946082613,
 8377,
 -1,
 946025145,
 983128,
 952449227,
 945974806,
 -1,
 952514761,
 952389272,
 -1,
 -51001,
 952466783,
 128289,
 -51000,
 952521273,
 128292,
 -1,
 952573494,
 128288,
 -50998,
 952467782,
 128291,
 -1,
 952721443,
 128290,
 952907987,
 952382963,
 -1,
 952973522,
 952859165,
 -1,
 953039056,
 952926542,
 -1,
 -50993,
 952997078,
 983111,
 -1,
 953040722,
 983108,
 -50991,
 952984324,
 983114,
 -1,
 953169485,
 983105,
 -1,
 952903540,
 128129,
 953432279,
 952864516,
 -1,
 953497814,
 953374007,
 11845,
 -1,
 953419523,
 11846,
 -1,
 953445049,
 9959,
 953694426,
 953359671,
 -1,
 -50983,
 953643301,
 128474,
 -1,
 953705096,
 128232,
 -1,
 953621552,
 128229,
 953956579,
 945891106,
 -1,
 954022111,
 953909582,
 -1,
 -50978,
 953980118,
 119667,
 -1,
 954023762,
 119668,
 954218722,
 953955110,
 -1,
 -50975,
 954165002,
 119669,
 -1,
 954222815,
 119670,
 -1,
 954163972,
 119666,
 954480870,
 953884353,
 -1,
 -50971,
 954416790,
 127954,
 -1,
 954475466,
 127848,
 -50969,
 954439836,
 127982,
 -50968,
 954620598,
 128127,
 -1,
 954663570,
 129311,
 954874223,
 945828646,
 -1,
 954939675,
 954797841,
 -1,
 955005204,
 954866999,
 -1,
 955070739,
 954936161,
 -1,
 955136269,
 955028370,
 -1,
 955201804,
 955056128,
 -1,
 955267318,
 955146341,
 -1,
 955332852,
 955214481,
 128558,
 955449343,
 955252736,
 -1,
 -50957,
 955355316,
 129326,
 -1,
 955388801,
 128560,
 -50955,
 955276436,
 129320,
 -1,
 955534036,
 128582,
 955726074,
 955220113,
 128539,
 955842559,
 955645983,
 -1,
 -50951,
 955749248,
 128540,
 -1,
 955810956,
 128541,
 955988221,
 955679054,
 -1,
 -50948,
 955923834,
 129298,
 -1,
 955984904,
 128514,
 956184832,
 955934929,
 -1,
 -50945,
 956125038,
 129402,
 -1,
 956175923,
 129395,
 956381443,
 956126740,
 -1,
 -50942,
 956326904,
 129488,
 -1,
 956378390,
 128567,
 956578054,
 956309963,
 -1,
 -50939,
 956535326,
 129312,
 -1,
 956583692,
 128531,
 -50937,
 956533577,
 129396,
 -50936,
 956724947,
 128580,
 -50935,
 956784256,
 128581,
 -50934,
 956847275,
 128548,
 -50933,
 956906680,
 129301,
 -1,
 956970145,
 129323,
 -1,
 955148227,
 128566,
 957233424,
 955086882,
 -1,
 -50929,
 957162448,
 128561,
 -1,
 957224921,
 128523,
 -50927,
 957187077,
 128536,
 -50926,
 957376865,
 129318,
 -1,
 957437816,
 128134,
 -1,
 955024854,
 127981,
 957692183,
 954963444,
 -1,
 -50922,
 957634157,
 128224,
 -1,
 957694349,
 128439,
 -50920,
 957645645,
 127877,
 -50919,
 957831621,
 128106,
 -50918,
 957895665,
 127810,
 -1,
 957958118,
 129498,
 958150969,
 954875997,
 -1,
 958216491,
 958099276,
 -1,
 958282021,
 958147423,
 128293,
 958347553,
 958240159,
 -1,
 -50912,
 958298146,
 127878,
 -1,
 958334081,
 127879,
 958544164,
 958267844,
 -1,
 -50909,
 958502529,
 129519,
 -1,
 958553492,
 128658,
 -1,
 958473147,
 129512,
 958857215,
 958234421,
 -1,
 958871849,
 958754514,
 -1,
 -50904,
 958829485,
 127771,
 -1,
 958890271,
 127763,
 -50902,
 958824556,
 8296,
 -1,
 959015776,
 129351,
 959199539,
 958156023,
 -1,
 959265072,
 959130465,
 -1,
 -50898,
 959216147,
 983106,
 -50897,
 959264207,
 128193,
 -1,
 959323491,
 128452,
 959578111,
 959206934,
 -1,
 -50894,
 959475028,
 128253,
 -1,
 959526658,
 127902,
 959723832,
 959150114,
 -1,
 959789367,
 959658695,
 128031,
 -50890,
 959726990,
 127907,
 -1,
 959774994,
 127845,
 -1,
 959742634,
 128074,
 -1,
 959655527,
 127953,
 960117065,
 958095461,
 -1,
 960182591,
 960065356,
 -1,
 960248125,
 960121544,
 127860,
 -1,
 960169827,
 127869,
 -50882,
 960202657,
 129376,
 -1,
 960321049,
 983071,
 960510275,
 960138467,
 -1,
 -50879,
 960457758,
 128966,
 -50878,
 960515988,
 127808,
 -1,
 960570253,
 11156,
 960772421,
 960456175,
 129462,
 -1,
 960720205,
 128099,
 960903495,
 960706473,
 127787,
 -1,
 960838335,
 127745,
 -50872,
 960861687,
 129418,
 -1,
 960974623,
 128448,
 961165654,
 960065356,
 -1,
 961231182,
 961110117,
 -1,
 -50868,
 961189017,
 128550,
 -50867,
 961240989,
 128037,
 -1,
 961296299,
 128056,
 961493330,
 961155821,
 -1,
 -50864,
 961447078,
 128445,
 -50863,
 961506097,
 128444,
 -1,
 961549123,
 128446,
 961755477,
 961424223,
 -1,
 -50860,
 961698849,
 127839,
 -1,
 961753883,
 129398,
 -1,
 961692095,
 127844,
 962017633,
 961105143,
 -1,
 962083163,
 961976260,
 -1,
 -50855,
 962033996,
 128760,
 -50854,
 962080763,
 128389,
 -1,
 962144299,
 129359,
 962345310,
 962027621,
 -1,
 -50851,
 962302581,
 127924,
 -1,
 962358540,
 128190,
 -50849,
 962301356,
 128563,
 -50848,
 962474742,
 128170,
 -1,
 962533085,
 129407,
 962738533,
 961974538,
 -1,
 -50845,
 962661066,
 983215,
 -50844,
 962726386,
 983214,
 -1,
 962791766,
 983213,
 963000681,
 962669407,
 -1,
 -50841,
 962951046,
 127905,
 -50840,
 963009560,
 129338,
 -1,
 963056982,
 128552,
 963262828,
 962955990,
 -1,
 -50837,
 963220397,
 127773,
 -1,
 963281183,
 127765,
 963459438,
 963213346,
 983107,
 -1,
 963395677,
 983232,
 -1,
 963392294,
 983072,
 963656160,
 954833016,
 -1,
 963721685,
 963580748,
 -1,
 963787177,
 963662249,
 -1,
 963852667,
 963739982,
 -1,
 963918198,
 963805518,
 -1,
 -50827,
 963853013,
 72213,
 -1,
 963907345,
 72212,
 964114809,
 963868706,
 -1,
 -50824,
 964049621,
 72228,
 -1,
 964103953,
 72227,
 -50822,
 964049621,
 72218,
 -1,
 964235025,
 72217,
 964442500,
 963781983,
 -1,
 964508031,
 964401272,
 -1,
 -50818,
 964442837,
 72230,
 -1,
 964497169,
 72229,
 964704642,
 964437343,
 -1,
 -50815,
 964639445,
 72215,
 -1,
 964693777,
 72214,
 -50813,
 964639445,
 72220,
 -1,
 964824849,
 72219,
 965032329,
 964385623,
 -1,
 -50810,
 964990728,
 72211,
 -50809,
 965041072,
 72216,
 -50808,
 965097442,
 72207,
 -1,
 965152529,
 72221,
 965360013,
 964982818,
 -1,
 -50805,
 965310622,
 72239,
 -50804,
 965360341,
 72238,
 -1,
 965414673,
 72240,
 965622161,
 965298883,
 -1,
 -50801,
 965574342,
 72242,
 -50800,
 965622485,
 72204,
 -1,
 965676817,
 72203,
 965884308,
 965580920,
 -1,
 -50797,
 965819093,
 72231,
 -1,
 965873425,
 72232,
 966080919,
 965830865,
 -1,
 -50794,
 966015701,
 72223,
 -1,
 966070033,
 72222,
 966277530,
 966014889,
 -1,
 -50791,
 966212309,
 72206,
 -1,
 966266641,
 72205,
 966474141,
 966204727,
 -1,
 -50788,
 966408917,
 72209,
 -1,
 966463249,
 72208,
 966670752,
 966400034,
 -1,
 -50785,
 966605525,
 72225,
 -1,
 966659857,
 72224,
 -50783,
 966629128,
 72234,
 -50782,
 966823495,
 72237,
 -50781,
 966881177,
 72235,
 -50780,
 966940254,
 72226,
 -50779,
 967003465,
 72236,
 -50778,
 967068186,
 72210,
 -50777,
 967129813,
 72241,
 -50776,
 967184145,
 72192,
 -1,
 967247906,
 72233,
 967457206,
 963743942,
 -1,
 967522741,
 967408720,
 -1,
 967588269,
 967477399,
 72195,
 -1,
 967519071,
 72194,
 967719343,
 967532645,
 72198,
 -1,
 967650143,
 72197,
 967850418,
 967642897,
 -1,
 -50767,
 967805079,
 72200,
 -1,
 967852125,
 72199,
 -50765,
 967799490,
 72201,
 -50764,
 967983197,
 72193,
 -1,
 968043359,
 72196,
 -1,
 967463305,
 72202,
 968309185,
 967407650,
 -1,
 968374720,
 968246006,
 -1,
 968440252,
 968302010,
 -1,
 968505787,
 968366675,
 72245,
 -1,
 968427318,
 72246,
 -1,
 968427318,
 72247,
 968702399,
 968396801,
 -1,
 -50754,
 968653122,
 72249,
 -1,
 968716351,
 72244,
 -1,
 968627337,
 72248,
 -1,
 968329604,
 72263,
 969030092,
 968237417,
 -1,
 969095625,
 968986069,
 -1,
 969161160,
 969028736,
 -1,
 -50747,
 969119496,
 72251,
 -50746,
 969182791,
 72254,
 -50745,
 969240473,
 72252,
 -1,
 969297225,
 72253,
 -1,
 969098763,
 72250,
 969605119,
 969041378,
 -1,
 -50741,
 969489554,
 72256,
 -1,
 969550271,
 72262,
 969750993,
 968972104,
 -1,
 -50738,
 969705313,
 72257,
 -50737,
 969767669,
 72258,
 -50736,
 969823377,
 72260,
 -1,
 969877923,
 72259,
 970078676,
 969688578,
 -1,
 -50733,
 970013842,
 72255,
 -1,
 970074559,
 72261,
 -1,
 970011733,
 72243,
 970340827,
 963678489,
 -1,
 970406361,
 970283863,
 -1,
 -50728,
 970344949,
 983218,
 -1,
 970398903,
 983259,
 -50726,
 970358332,
 983217,
 -1,
 970541557,
 983219,
 970734046,
 970271583,
 -1,
 -50723,
 970689921,
 11234,
 -1,
 970726464,
 129427,
 -50721,
 970678879,
 129503,
 -1,
 970868506,
 129296,
 971061796,
 963610775,
 -1,
 971127323,
 971008209,
 -1,
 971192845,
 971084164,
 -1,
 971258360,
 971145550,
 -1,
 971323895,
 971207446,
 -1,
 971389430,
 971245636,
 -1,
 971454964,
 971314652,
 11105,
 971571199,
 971374592,
 -1,
 971586034,
 971477911,
 -1,
 971651564,
 971527303,
 -1,
 -50709,
 971601061,
 11171,
 -1,
 971657433,
 11170,
 -50707,
 971607962,
 129073,
 -50706,
 971791351,
 129057,
 -50705,
 971855902,
 129061,
 -50704,
 971914533,
 129069,
 -50703,
 971974963,
 11131,
 -1,
 972037055,
 129065,
 -50701,
 971539784,
 11121,
 -1,
 972181805,
 11137,
 -50699,
 971401533,
 11141,
 -1,
 972301954,
 11115,
 -1,
 971309230,
 129169,
 -1,
 971281716,
 11245,
 972634624,
 971183605,
 -1,
 972700156,
 972586259,
 -1,
 -50693,
 972654213,
 129025,
 -1,
 972697695,
 129041,
 -50691,
 972644103,
 129177,
 -50690,
 972838969,
 129029,
 -50689,
 972901960,
 129033,
 -1,
 972959839,
 129045,
 973158915,
 972591804,
 -1,
 -50686,
 973116523,
 129173,
 -1,
 973158176,
 11192,
 973355526,
 973109282,
 -1,
 -50683,
 973303464,
 129081,
 -1,
 973345856,
 129105,
 973552137,
 973290765,
 -1,
 -50680,
 973480552,
 129089,
 -1,
 973542876,
 129093,
 -50678,
 973502156,
 128621,
 -50677,
 973681853,
 129077,
 -50676,
 973742696,
 129085,
 -1,
 973806270,
 11145,
 974010900,
 971114654,
 -1,
 974076433,
 973962515,
 -1,
 -50672,
 974025141,
 128316,
 -1,
 974066068,
 128744,
 -50670,
 974025141,
 128314,
 -50669,
 974215594,
 128742,
 -1,
 974262676,
 128743,
 974469657,
 973930496,
 -1,
 974535192,
 974399963,
 -1,
 -50665,
 974489291,
 11109,
 -1,
 974551316,
 129113,
 -1,
 974460428,
 11193,
 -50662,
 974421052,
 128579,
 -1,
 974744270,
 128319,
 974928419,
 971070295,
 -1,
 974993953,
 974864477,
 -1,
 975059488,
 974946638,
 -1,
 -50657,
 974990572,
 11258,
 -1,
 975045715,
 983115,
 -1,
 974988163,
 129412,
 -50654,
 974921502,
 11217,
 -1,
 975246114,
 128530,
 -1,
 974878754,
 983116,
 975518263,
 971019856,
 -1,
 975583790,
 975466885,
 -1,
 975649321,
 975510839,
 -1,
 -50648,
 975584355,
 129636,
 -1,
 975639610,
 129637,
 -50646,
 975601155,
 129638,
 -50645,
 975787816,
 129633,
 -50644,
 975847189,
 129635,
 -50643,
 975911133,
 129632,
 -1,
 975974030,
 129634,
 976224255,
 975510186,
 -1,
 976239154,
 976100663,
 -1,
 -50639,
 976174179,
 129643,
 -1,
 976229434,
 129644,
 -50637,
 976190979,
 129645,
 -50636,
 976377640,
 129640,
 -50635,
 976437013,
 129642,
 -50634,
 976500957,
 129639,
 -1,
 976563854,
 129641,
 976763461,
 975456757,
 -1,
 976828993,
 976686865,
 -1,
 976894528,
 976775530,
 -1,
 -50629,
 976847142,
 128304,
 -50628,
 976907460,
 127971,
 -50627,
 976970128,
 128121,
 -50626,
 977025552,
 128122,
 -50625,
 977086589,
 127886,
 -1,
 977149529,
 127983,
 -1,
 976822537,
 127875,
 -50622,
 976783986,
 129337,
 -50621,
 977365155,
 128377,
 -50620,
 977421114,
 129513,
 -1,
 977480707,
 128086,
 977731583,
 976721581,
 -1,
 -50617,
 977617046,
 983239,
 -1,
 977677988,
 128155]
_charnames_1318 = [
9057,
9045,
9055,
9041,
9051,
9034,
9053,
9036,
9056,
9042,
]

_charnames_1416 = [
6105,
-1,
-1,
-1,
-1,
14066,
9915,
6107,
]

_charnames_2112 = [
4168,
4162,
4160,
4161,
4159,
4166,
4151,
4164,
4148,
4150,
4149,
4157,
4156,
4155,
4144,
4165,
4154,
4145,
4153,
4152,
4146,
4147,
4169,
4167,
4158,
4173,
4170,
4172,
-1,
-1,
4171,
-1,
1832,
1839,
1831,
1836,
1830,
1829,
1840,
1838,
1835,
1834,
1837,
]

_charnames_2208 = [
6036,
6038,
6058,
6041,
6060,
6056,
6050,
6046,
6027,
6028,
6032,
6055,
6033,
6049,
6061,
6044,
6059,
6043,
6054,
6024,
6053,
-1,
6037,
6057,
6040,
6031,
6026,
6023,
6021,
6022,
]

_charnames_2259 = [
6002,
5988,
5996,
6000,
5997,
5998,
6003,
5986,
5987,
5989,
5991,
5992,
5990,
5999,
5995,
6087,
6076,
6080,
6082,
6078,
6081,
6083,
6079,
6072,
6069,
6075,
6071,
6068,
6074,
6095,
6096,
6094,
5993,
6098,
6099,
6102,
6064,
6090,
6063,
6092,
6085,
6086,
6091,
6088,
5953,
]

_charnames_2383 = [
12723,
-1,
-1,
-1,
-1,
-1,
-1,
12717,
12716,
]

_charnames_2809 = [
13332,
13328,
13329,
13330,
13326,
13331,
13325,
]

_charnames_3406 = [
4487,
4495,
-1,
-1,
-1,
-1,
4483,
4482,
4484,
-1,
4474,
4471,
4479,
4468,
4469,
4477,
4472,
4488,
]

_charnames_3558 = [
1167,
1168,
1159,
1160,
1165,
1166,
1162,
1163,
1170,
1169,
]

_charnames_4295 = [
13410,
-1,
-1,
-1,
-1,
-1,
13411,
]

_charnames_5109 = [
8479,
-1,
-1,
8435,
8434,
8433,
8432,
8431,
8452,
]

_charnames_5873 = [
14220,
14218,
14219,
14215,
14216,
14217,
14214,
14213,
]

_charnames_6832 = [
8722,
8725,
8756,
8723,
8739,
8753,
8745,
8734,
8720,
8696,
8755,
8743,
8719,
8742,
8741,
]

_charnames_7098 = [
1709,
1702,
1703,
1704,
1701,
1700,
7367,
7336,
7362,
7334,
7350,
7366,
7359,
7352,
7331,
7344,
7349,
7355,
7328,
7353,
7363,
7335,
7360,
7364,
7357,
7330,
7346,
7332,
7337,
7341,
7338,
7329,
7348,
7354,
7327,
7342,
7358,
7333,
7340,
7365,
7343,
7351,
7361,
7356,
7386,
7374,
7376,
7375,
7378,
7373,
7377,
7372,
7369,
7370,
7391,
7392,
7389,
7388,
]

_charnames_7296 = [
9038,
9047,
9046,
9043,
9030,
9032,
9031,
9029,
9044,
]

_charnames_7312 = [
13360,
13400,
13383,
13399,
13385,
13390,
13365,
13357,
13397,
13377,
13373,
13396,
13395,
13394,
13371,
13364,
13392,
13368,
13356,
13391,
13370,
13376,
13382,
13393,
13367,
13350,
13353,
13379,
13352,
13351,
13388,
13380,
13344,
13347,
13346,
13389,
13342,
13345,
13398,
13387,
13386,
13358,
13361,
-1,
-1,
13362,
13343,
13374,
1692,
1691,
1690,
1696,
1693,
1694,
1695,
1697,
]

_charnames_7411 = [
13082,
13088,
13083,
13081,
13084,
13086,
13087,
]

_charnames_7655 = [
8684,
8681,
8682,
8687,
8690,
8689,
8679,
8688,
8691,
8676,
8686,
8685,
8680,
8677,
8754,
8751,
8752,
8724,
8746,
-1,
8726,
8721,
]

_charnames_8341 = [
9724,
9723,
9722,
9721,
9720,
9719,
9718,
9717,
]

_charnames_8377 = [
14530,
3430,
10673,
4186,
14232,
9829,
7984,
]

_charnames_9193 = [
7839,
7859,
7867,
7850,
7840,
7860,
7841,
6278,
1758,
3349,
11287,
7807,
7805,
7800,
7809,
12684,
7828,
7825,
11860,
11863,
11864,
11861,
12371,
]

_charnames_9984 = [
7835,
-1,
-1,
-1,
-1,
13949,
-1,
-1,
-1,
-1,
14189,
14182,
]

_charnames_10060 = [
9067,
-1,
10585,
-1,
-1,
-1,
-1,
7885,
13960,
13963,
]

_charnames_11098 = [
1883,
7465,
1882,
7464,
7946,
1571,
9844,
14822,
14001,
12632,
9905,
14870,
10661,
10669,
1415,
1407,
9861,
14837,
14018,
12648,
8998,
5754,
9858,
14834,
14015,
12644,
-1,
-1,
10662,
10670,
1416,
1408,
9852,
14832,
14009,
12642,
11275,
13076,
9859,
14835,
14016,
12645,
9860,
14836,
14017,
12647,
9875,
14860,
14032,
12669,
5753,
5756,
5755,
5752,
14143,
14142,
10529,
10528,
14658,
14033,
-1,
-1,
3367,
3368,
3366,
3369,
7862,
7868,
7843,
7851,
12637,
12636,
14827,
14826,
9848,
14005,
9849,
14006,
7824,
7823,
7815,
7814,
7820,
7817,
7821,
7818,
14083,
14082,
14074,
14073,
14079,
14076,
14080,
14077,
14850,
14872,
12356,
12357,
12358,
7455,
9097,
9100,
7829,
7855,
3428,
11277,
7886,
7801,
7810,
7808,
7806,
-1,
3462,
7927,
9526,
14171,
13952,
14170,
1683,
14881,
13234,
11780,
11781,
11783,
11784,
3390,
11912,
6483,
11330,
11942,
10590,
13962,
7854,
3409,
8368,
11265,
14812,
13732,
6487,
6393,
13102,
11880,
9902,
14060,
1737,
1736,
9863,
14839,
14020,
12650,
14426,
14425,
1893,
14225,
14229,
14228,
14230,
14227,
14226,
14428,
14878,
1891,
12688,
11660,
14125,
]

_charnames_11559 = [
13407,
-1,
-1,
-1,
-1,
-1,
13408,
]

_charnames_11826 = [
3427,
14190,
14191,
3417,
12767,
12766,
3422,
3461,
3480,
3370,
1756,
13078,
13923,
8946,
12686,
14129,
12685,
12770,
12682,
14548,
14549,
9939,
9940,
12683,
12696,
3398,
4029,
11646,
11934,
]

_charnames_42612 = [
8704,
8705,
8701,
8703,
8709,
8702,
8707,
8708,
]

_charnames_42648 = [
9052,
9035,
9059,
9048,
4843,
4842,
8710,
8706,
]

_charnames_42893 = [
9768,
9655,
9811,
9786,
9692,
9798,
9667,
9666,
9703,
9801,
9640,
9805,
9715,
9764,
9698,
9763,
9697,
9762,
9696,
9795,
9709,
9803,
9713,
9785,
9691,
9772,
9686,
9752,
9600,
9804,
9773,
9754,
9789,
9753,
9810,
9767,
9766,
9792,
9797,
9800,
9639,
9760,
9628,
9748,
9563,
]

_charnames_43488 = [
5072,
5073,
5071,
5070,
5074,
5096,
5097,
5055,
5067,
5062,
5061,
5059,
5058,
5051,
5050,
5056,
5088,
5089,
5080,
5081,
5086,
5087,
5083,
5084,
5091,
5090,
5066,
5053,
5052,
5065,
5064,
]

_charnames_43744 = [
4045,
4044,
4046,
4039,
4034,
4033,
4043,
4042,
4040,
4037,
4036,
4056,
4055,
4052,
4053,
4051,
4063,
4060,
4059,
4062,
4061,
4054,
4057,
]

_charnames_43777 = [
14338,
14340,
14341,
14337,
14336,
14339,
-1,
-1,
14315,
14317,
14318,
14314,
14313,
14316,
-1,
-1,
14308,
14310,
14311,
14307,
14306,
14309,
]

_charnames_43808 = [
14322,
14324,
14326,
14323,
14321,
14320,
14325,
-1,
14330,
14332,
14334,
14331,
14329,
14328,
14333,
-1,
9637,
9675,
9633,
9636,
9587,
9659,
9594,
9657,
9658,
9656,
9706,
9693,
9588,
9631,
9632,
9620,
9614,
9644,
9645,
9646,
9647,
9601,
9809,
9688,
9710,
9687,
9711,
9592,
9593,
9638,
9564,
9569,
9571,
9651,
9568,
9661,
9663,
9664,
9682,
9678,
9681,
9680,
9712,
4848,
4839,
4836,
4835,
4838,
9602,
9616,
9623,
9570,
9615,
13213,
]

_charnames_43888 = [
8478,
8477,
8476,
8474,
8473,
8472,
8471,
8475,
8470,
8469,
8468,
8467,
8466,
8421,
8420,
8419,
8417,
8416,
8415,
8464,
8463,
8462,
8461,
8460,
8459,
8457,
8456,
8455,
8454,
8453,
8407,
8418,
8408,
8413,
8412,
8411,
8410,
8409,
8450,
8449,
8448,
8447,
8446,
8445,
8405,
8399,
8404,
8403,
8402,
8401,
8400,
8429,
8398,
8428,
8397,
8427,
8396,
8425,
8424,
8423,
8426,
8395,
8394,
8393,
8392,
8391,
8390,
8388,
8387,
8386,
8385,
8384,
8383,
8443,
8442,
8441,
8440,
8439,
8438,
8436,
]

_charnames_64434 = [
5972,
5971,
5962,
5961,
5968,
5967,
5966,
5965,
5979,
5978,
5973,
5960,
5959,
5980,
5976,
5975,
]

_charnames_65063 = [
8695,
8694,
8738,
8737,
8749,
8748,
8714,
8713,
8712,
]

_charnames_66272 = [
8807,
8804,
8796,
8797,
8802,
8803,
8799,
8800,
8806,
8805,
8772,
8768,
8771,
8783,
8786,
8775,
8778,
8791,
8788,
8793,
8767,
8770,
8782,
8785,
8776,
8779,
8792,
8789,
]

_charnames_66384 = [
12164,
12163,
12161,
12139,
12151,
12141,
12138,
12142,
12137,
12132,
12159,
12158,
12157,
12156,
12144,
12155,
12154,
12131,
12148,
12153,
12162,
12129,
12130,
12126,
12121,
12149,
12150,
12152,
12160,
12147,
12145,
12120,
12122,
12124,
12133,
12125,
12123,
12134,
8733,
8732,
8729,
8731,
8730,
]

_charnames_66736 = [
12278,
12279,
12280,
12281,
12312,
12311,
12276,
12269,
12277,
12301,
12300,
12308,
12290,
12275,
12288,
12307,
12306,
12305,
12297,
12298,
12304,
12274,
12296,
12295,
12286,
12273,
12285,
12272,
12284,
12310,
12303,
12302,
12289,
12309,
12293,
12292,
-1,
-1,
-1,
-1,
12233,
12234,
12235,
12236,
12267,
12266,
12231,
12224,
12232,
12256,
12255,
12263,
12245,
12230,
12243,
12262,
12261,
12260,
12252,
12253,
12259,
12229,
12251,
12250,
12241,
12228,
12240,
12227,
12239,
12265,
12258,
12257,
12244,
12264,
12248,
12247,
-1,
-1,
-1,
-1,
14293,
14292,
14279,
14278,
14276,
14246,
14275,
14273,
14272,
14291,
14253,
14252,
14290,
14289,
14288,
14271,
14268,
14267,
14287,
14245,
14247,
14244,
14286,
14285,
14284,
14265,
14264,
14262,
14261,
14259,
14258,
14283,
14282,
14281,
14280,
14256,
14255,
14250,
14251,
14270,
]

_charnames_66864 = [
8904,
8913,
8897,
8864,
8901,
8869,
8900,
8867,
8873,
8843,
8879,
8868,
8876,
8855,
8889,
8877,
8905,
8863,
8852,
8894,
8892,
8888,
8911,
8882,
8903,
8845,
8846,
8848,
8910,
8883,
8909,
8861,
8856,
8895,
8908,
8871,
8912,
8862,
8844,
8886,
8898,
8907,
8858,
8906,
8872,
8857,
8875,
8849,
8851,
8880,
8885,
8891,
]

_charnames_67072 = [
9153,
9152,
9151,
9150,
9149,
9148,
9147,
9146,
9145,
9197,
9196,
9195,
9194,
9193,
9133,
9123,
9125,
9124,
9120,
9122,
9121,
9126,
9127,
9132,
9131,
9130,
9129,
9512,
9128,
9191,
9190,
9189,
9188,
9187,
9186,
9162,
9161,
9160,
9159,
9158,
9157,
9156,
9155,
9143,
9142,
9141,
9140,
9139,
9138,
9137,
9136,
9135,
9184,
9183,
9182,
9181,
9180,
9179,
9170,
9169,
9168,
9167,
9166,
9165,
9164,
9177,
9176,
9175,
9174,
9173,
9172,
9511,
9212,
9202,
9510,
9201,
9200,
9208,
9207,
9509,
9211,
9210,
9205,
9204,
9209,
9331,
9330,
9329,
9328,
9327,
9326,
9325,
9324,
9323,
9322,
9321,
9318,
9317,
9316,
9309,
9308,
9307,
9315,
9314,
9313,
9312,
9311,
9310,
9386,
9385,
9384,
9383,
9382,
9381,
9380,
9379,
9378,
9377,
9375,
9374,
9373,
9372,
9371,
9370,
9369,
9368,
9367,
9366,
9364,
9363,
9362,
9361,
9360,
9359,
9358,
9357,
9356,
9355,
9353,
9352,
9351,
9350,
9349,
9348,
9347,
9346,
9345,
9344,
9342,
9341,
9340,
9339,
9338,
9337,
9336,
9335,
9334,
9333,
9389,
9388,
9488,
9487,
9486,
9485,
9484,
9483,
9482,
9481,
9480,
9479,
9498,
9497,
9496,
9495,
9494,
9493,
9492,
9491,
9490,
9274,
9273,
9272,
9271,
9270,
9269,
9268,
9267,
9303,
9302,
9301,
9300,
9299,
9298,
9265,
9264,
9263,
9262,
9261,
9260,
9259,
9258,
9257,
9255,
9254,
9253,
9252,
9251,
9250,
9249,
9248,
9247,
9282,
9281,
9280,
9279,
9278,
9277,
9276,
9245,
9244,
9243,
9242,
9241,
9240,
9239,
9238,
9237,
9296,
9295,
9294,
9293,
9292,
9291,
9235,
9234,
9233,
9232,
9231,
9230,
9229,
9228,
9227,
9226,
9224,
9223,
9222,
9221,
9220,
9219,
9218,
9217,
9216,
9215,
9289,
9288,
9287,
9286,
9285,
9284,
9439,
9438,
9437,
9436,
9435,
9434,
9433,
9432,
9401,
9400,
9399,
9398,
9397,
9396,
9395,
9394,
9393,
9392,
9421,
9420,
9419,
9418,
9417,
9416,
9415,
9414,
9413,
9449,
9448,
9447,
9430,
9429,
9428,
9427,
9426,
9425,
9424,
9423,
9411,
9410,
9409,
9408,
9407,
9406,
9405,
9404,
9403,
9445,
9444,
9443,
9442,
9441,
]

_charnames_67392 = [
9466,
9465,
9464,
9463,
9462,
9461,
9460,
9459,
9458,
9457,
9456,
9455,
9454,
9474,
9473,
9472,
9471,
9470,
9469,
9468,
9476,
9475,
]

_charnames_67424 = [
9507,
9506,
9505,
9504,
9503,
9502,
9501,
9500,
]

_charnames_67680 = [
11607,
11621,
11618,
11620,
11603,
11610,
11608,
11604,
11601,
11609,
11617,
11616,
11615,
11619,
11614,
11597,
11606,
11613,
11598,
11612,
11611,
11599,
11602,
11622,
11634,
11633,
11626,
11628,
11631,
11632,
11629,
11627,
10606,
10619,
10605,
10632,
10630,
10631,
10604,
10615,
10622,
10620,
10616,
10613,
10598,
10621,
10603,
10629,
10602,
10628,
10601,
10627,
10600,
10626,
10609,
10618,
10625,
10610,
10624,
10623,
10599,
10611,
10614,
]

_charnames_67751 = [
10640,
10636,
10638,
10643,
10645,
10644,
10639,
10637,
10641,
]

_charnames_67808 = [
11236,
11248,
11246,
11247,
11232,
11239,
11237,
11233,
11230,
11238,
11245,
11244,
11243,
11242,
11226,
11235,
11241,
11227,
11240,
-1,
11228,
11231,
-1,
-1,
-1,
-1,
-1,
11253,
11255,
11252,
11251,
11254,
]

_charnames_67968 = [
3894,
3892,
3890,
3887,
3883,
3884,
3881,
3882,
3886,
3888,
3870,
3871,
3868,
3869,
3876,
3877,
3889,
3879,
3891,
3873,
3874,
3875,
3880,
3885,
3864,
3865,
3862,
3863,
3866,
3893,
3895,
3896,
3823,
3835,
3833,
3830,
3825,
3826,
3837,
3829,
3831,
3819,
3818,
3827,
3832,
3821,
3834,
3816,
3824,
3815,
3822,
3828,
3813,
3812,
3811,
3836,
-1,
-1,
-1,
-1,
3856,
3851,
3839,
3840,
3803,
3742,
3750,
3776,
3784,
3760,
3767,
3797,
3791,
3757,
3747,
3755,
3781,
3789,
3765,
3772,
-1,
-1,
3805,
3744,
3752,
3778,
3786,
3762,
3769,
3799,
3793,
3807,
3746,
3754,
3780,
3788,
3764,
3771,
3801,
3795,
3758,
3748,
3756,
3782,
3790,
3766,
3773,
3802,
3796,
3806,
3745,
3753,
3779,
3787,
3763,
3770,
3800,
3794,
3850,
3843,
3844,
3853,
3854,
3847,
3848,
3857,
3858,
3845,
]

_charnames_68224 = [
12185,
12203,
12186,
12202,
12200,
12197,
12176,
12199,
12205,
12172,
12177,
12183,
12201,
12182,
12198,
12175,
12204,
12194,
12195,
12192,
12189,
12191,
12188,
12173,
12179,
12171,
12196,
12170,
12180,
12210,
12209,
12208,
]

_charnames_68288 = [
4085,
4112,
4111,
4105,
4106,
4109,
4102,
4114,
4140,
4089,
4088,
4101,
4100,
4103,
4081,
4113,
4098,
4092,
4097,
4119,
4108,
4080,
4118,
4117,
4075,
4084,
4086,
4116,
4120,
4076,
4094,
4091,
4095,
4115,
4078,
4077,
4082,
4139,
4138,
-1,
-1,
-1,
-1,
4134,
4136,
4133,
4132,
4135,
4127,
4129,
4125,
4124,
4123,
4126,
4128,
]

_charnames_68480 = [
11807,
11806,
11804,
11805,
11793,
11797,
11795,
11794,
11796,
11803,
11802,
11801,
11800,
11790,
11799,
11791,
11792,
11798,
]

_charnames_68521 = [
11815,
11811,
11813,
11817,
11814,
11812,
11816,
]

_charnames_68736 = [
12033,
12037,
12032,
12035,
12008,
12007,
12009,
12031,
12034,
12002,
12054,
12030,
12029,
12021,
12022,
12028,
12051,
12052,
12027,
12026,
12036,
12041,
12019,
12020,
12017,
12003,
12006,
12042,
12043,
12050,
12047,
12044,
12025,
12018,
12024,
12053,
12015,
12016,
12013,
12004,
12014,
12010,
12038,
12039,
12049,
12046,
12023,
12011,
12012,
12005,
12040,
]

_charnames_68800 = [
11979,
11983,
11978,
11981,
11954,
11953,
11955,
11977,
11980,
11948,
12000,
11976,
11975,
11967,
11968,
11974,
11997,
11998,
11973,
11972,
11982,
11987,
11965,
11966,
11963,
11949,
11952,
11988,
11989,
11996,
11993,
11990,
11971,
11964,
11970,
11999,
11961,
11962,
11959,
11950,
11960,
11956,
11984,
11985,
11995,
11992,
11969,
11957,
11958,
11951,
11986,
]

_charnames_68858 = [
12056,
12061,
12063,
12062,
12059,
12058,
11178,
11177,
11169,
11155,
11154,
11172,
11176,
11173,
11147,
11175,
11164,
11163,
11161,
11160,
11165,
11158,
11157,
11148,
11174,
11171,
11170,
11152,
11167,
11146,
11166,
11145,
11151,
11150,
11168,
11198,
11196,
11194,
11197,
11195,
11206,
11207,
11204,
11203,
11202,
11201,
]

_charnames_68912 = [
11189,
11190,
11181,
11182,
11187,
11188,
11184,
11185,
11192,
11191,
]

_charnames_69376 = [
12085,
12076,
12100,
12075,
12099,
12087,
12074,
12091,
12089,
12088,
12090,
12098,
12097,
12096,
12095,
12072,
12073,
12079,
12086,
12084,
12094,
12080,
12070,
12071,
12093,
12081,
12092,
12068,
12069,
12111,
12105,
12108,
12114,
12115,
12110,
12106,
12109,
12112,
12116,
12101,
]

_charnames_69424 = [
1314,
1326,
1324,
1310,
1317,
1315,
1311,
1316,
1323,
1309,
1322,
1321,
1304,
1313,
1320,
1305,
1319,
1306,
1318,
1325,
1308,
1356,
1335,
1329,
1336,
1330,
1339,
1338,
1333,
1332,
1342,
1341,
1340,
1354,
1353,
1352,
1355,
1345,
1346,
1349,
1347,
1348,
]

_charnames_69632 = [
7639,
7640,
7636,
7638,
7637,
7531,
7534,
7553,
7554,
7539,
7540,
7504,
7505,
7506,
7507,
7568,
7533,
7515,
7532,
7549,
7548,
7557,
7556,
7523,
7560,
7559,
7552,
7551,
7521,
7512,
7511,
7528,
7527,
7522,
7514,
7513,
7530,
7529,
7524,
7543,
7542,
7563,
7562,
7566,
7564,
7565,
7546,
7508,
7537,
7536,
7538,
7567,
7545,
7519,
7517,
7518,
7609,
7616,
7612,
7613,
7610,
7611,
7602,
7603,
7604,
7605,
7615,
7608,
7614,
7607,
7617,
7634,
7633,
7647,
7646,
7644,
7648,
7643,
-1,
-1,
-1,
-1,
7590,
7572,
7575,
7585,
7588,
7579,
7581,
7596,
7594,
7577,
7573,
7576,
7586,
7589,
7580,
7582,
7597,
7595,
7593,
7592,
7629,
7630,
7621,
7622,
7627,
7628,
7624,
7625,
7632,
7631,
]

_charnames_69837 = [
13699,
-1,
-1,
1373,
1372,
1385,
1384,
1383,
1382,
1364,
1361,
1377,
1362,
1370,
1375,
1369,
1374,
1381,
1378,
1379,
1360,
1386,
1368,
1380,
1371,
1376,
1367,
1365,
]

_charnames_69872 = [
1397,
1398,
1389,
1390,
1395,
1396,
1392,
1393,
1400,
1399,
-1,
-1,
-1,
-1,
-1,
-1,
8577,
8578,
8576,
8541,
8538,
8534,
8540,
8520,
8519,
8526,
8525,
8501,
8529,
8528,
8523,
8522,
8499,
8495,
8494,
8506,
8505,
8500,
8497,
8496,
8508,
8507,
8502,
8514,
8513,
8532,
8531,
8537,
8510,
8511,
8536,
8517,
8533,
8535,
8539,
8544,
8552,
8553,
8548,
8549,
8554,
8546,
8550,
8545,
8551,
8581,
8583,
8556,
8582,
-1,
8568,
8569,
8560,
8561,
8566,
8567,
8563,
8564,
8571,
8570,
8579,
8573,
8572,
8580,
8516,
8547,
8555,
]

_charnames_69968 = [
4429,
4426,
4421,
4428,
4423,
4407,
4406,
4413,
4412,
4416,
4415,
4410,
4409,
4396,
4386,
4385,
4392,
4391,
4397,
4388,
4387,
4394,
4393,
4398,
4404,
4403,
4419,
4418,
4424,
4401,
4425,
4420,
4422,
4427,
4400,
4432,
4434,
4433,
4430,
]

_charnames_70016 = [
1527,
1522,
1518,
1458,
1461,
1480,
1481,
1466,
1467,
1436,
1437,
1438,
1439,
1496,
1460,
1493,
1459,
1476,
1475,
1484,
1483,
1450,
1487,
1486,
1479,
1478,
1448,
1444,
1443,
1455,
1454,
1449,
1446,
1445,
1457,
1456,
1451,
1470,
1469,
1490,
1489,
1494,
1491,
1492,
1473,
1472,
1440,
1464,
1463,
1465,
1495,
1507,
1510,
1511,
1508,
1509,
1500,
1501,
1502,
1503,
1513,
1506,
1512,
1505,
1519,
1521,
1526,
1523,
1555,
1551,
1550,
1558,
1532,
1534,
1525,
1514,
1553,
1533,
-1,
-1,
1546,
1547,
1538,
1539,
1544,
1545,
1541,
1542,
1549,
1548,
1554,
1524,
1556,
1557,
1531,
1530,
-1,
1154,
1146,
1147,
1152,
1153,
1149,
1150,
1156,
1155,
1132,
1130,
1131,
1140,
1141,
1134,
1135,
1143,
1142,
1138,
1137,
]

_charnames_70144 = [
13547,
13550,
13581,
13576,
13583,
13549,
13579,
13548,
13567,
13566,
13554,
13553,
13552,
13545,
13573,
13572,
13570,
13569,
-1,
13543,
13539,
13538,
13533,
13531,
13544,
13541,
13540,
13535,
13532,
13534,
13546,
13561,
13560,
13558,
13557,
13556,
13580,
13574,
13578,
13564,
13575,
13577,
13582,
13563,
13588,
13589,
13590,
13591,
13593,
13587,
13592,
13586,
13601,
13599,
13600,
13598,
13607,
13606,
13608,
13602,
13605,
13609,
13597,
]

_charnames_70272 = [
4961,
4958,
4954,
4960,
4939,
4938,
4945,
-1,
4944,
-1,
4948,
4947,
4942,
4941,
-1,
4931,
4923,
4922,
4917,
4916,
4915,
4932,
4925,
4924,
4919,
4918,
4933,
4936,
4935,
4951,
-1,
4950,
4956,
4952,
4929,
4957,
4953,
4955,
4959,
4927,
4928,
4962,
-1,
-1,
-1,
-1,
-1,
-1,
13456,
13459,
13486,
13487,
13472,
13473,
13497,
13458,
13493,
13457,
13485,
13484,
13467,
13466,
13465,
13454,
13490,
13489,
13463,
13461,
13462,
13452,
13448,
13447,
13442,
13441,
13478,
13440,
13453,
13450,
13449,
13444,
13443,
13455,
13482,
13481,
13471,
13470,
13469,
13494,
13491,
13479,
13495,
13492,
13475,
13476,
13496,
13526,
13516,
13519,
13520,
13517,
13518,
13522,
13515,
13521,
13514,
13525,
13524,
-1,
-1,
-1,
-1,
-1,
13508,
13509,
13500,
13501,
13506,
13507,
13503,
13504,
13511,
13510,
-1,
-1,
-1,
-1,
-1,
-1,
13196,
13197,
13200,
13193,
-1,
13136,
13139,
13158,
13159,
13144,
13145,
13111,
13113,
-1,
-1,
13174,
13138,
-1,
-1,
13171,
13137,
13154,
13153,
13162,
13161,
13128,
13165,
13164,
13157,
13156,
13126,
13122,
13121,
13133,
13132,
13127,
13124,
13123,
13135,
13134,
13129,
-1,
13148,
13147,
13168,
13167,
13172,
13169,
13170,
-1,
13151,
13150,
-1,
13118,
13142,
13141,
13143,
13173,
-1,
8757,
13202,
13199,
13184,
13187,
13188,
13185,
13186,
13177,
13178,
-1,
-1,
13190,
13183,
-1,
-1,
13189,
13182,
13194,
-1,
-1,
13203,
-1,
-1,
-1,
-1,
-1,
-1,
13204,
-1,
-1,
-1,
-1,
-1,
13201,
13117,
13116,
13112,
13114,
13179,
13180,
-1,
-1,
8664,
8666,
8659,
8660,
8662,
8663,
8665,
-1,
-1,
-1,
8672,
8671,
8670,
8668,
8669,
]

_charnames_70656 = [
10425,
10428,
10453,
10454,
10433,
10434,
10409,
10410,
10411,
10412,
10468,
10427,
10466,
10426,
10449,
10448,
10457,
10456,
10404,
10403,
10460,
10459,
10452,
10451,
10401,
10400,
10416,
10415,
10422,
10421,
10405,
10418,
10417,
10424,
10423,
10407,
10406,
10440,
10439,
10463,
10462,
10443,
10442,
10464,
10437,
10436,
10446,
10445,
10465,
10431,
10430,
10432,
10467,
10478,
10481,
10482,
10479,
10480,
10471,
10472,
10473,
10474,
10484,
10477,
10483,
10476,
10507,
10513,
10510,
10506,
10511,
10509,
10512,
10517,
10514,
10501,
10500,
10520,
10519,
10521,
10496,
10497,
10488,
10489,
10494,
10495,
10491,
10492,
10499,
10498,
-1,
10516,
-1,
10518,
10515,
]

_charnames_70784 = [
3325,
3245,
3248,
3264,
3265,
3253,
3254,
3223,
3224,
3225,
3226,
3281,
3247,
3277,
3246,
3260,
3259,
3268,
3267,
3237,
3271,
3270,
3263,
3262,
3235,
3231,
3230,
3242,
3241,
3236,
3233,
3232,
3244,
3243,
3238,
3257,
3256,
3274,
3273,
3278,
3275,
3276,
3279,
3227,
3251,
3250,
3252,
3280,
3291,
3297,
3298,
3292,
3293,
3284,
3285,
3286,
3287,
3300,
3296,
3290,
3299,
3295,
3289,
3323,
3321,
3317,
3318,
3322,
3320,
3328,
3326,
3327,
]

_charnames_70864 = [
3311,
3312,
3303,
3304,
3309,
3310,
3306,
3307,
3314,
3313,
]

_charnames_71040 = [
1009,
1013,
1040,
1041,
1029,
1030,
1004,
1005,
1006,
1007,
1057,
1012,
1053,
1010,
1036,
1035,
1044,
1043,
1017,
1047,
1046,
1039,
1038,
1015,
997,
996,
1022,
1021,
1016,
1001,
1000,
1024,
1023,
1018,
1033,
1032,
1050,
1049,
1054,
1051,
1052,
1055,
1008,
1027,
1026,
1028,
1056,
1097,
1102,
1103,
1100,
1101,
1098,
1099,
-1,
-1,
1105,
1096,
1104,
1095,
1089,
1090,
1085,
1086,
1088,
1087,
1112,
1111,
1081,
1082,
1109,
1108,
1107,
1113,
1064,
1065,
1070,
1069,
1068,
1078,
1079,
1077,
1066,
1076,
1075,
1073,
1072,
1074,
999,
993,
994,
1011,
1093,
1094,
]

_charnames_71168 = [
4749,
4752,
4771,
4772,
4757,
4758,
4727,
4728,
4729,
4730,
4787,
4751,
4784,
4750,
4767,
4766,
4775,
4774,
4741,
4778,
4777,
4770,
4769,
4739,
4735,
4734,
4746,
4745,
4740,
4737,
4736,
4748,
4747,
4742,
4761,
4760,
4781,
4780,
4785,
4782,
4783,
4764,
4731,
4755,
4754,
4756,
4786,
4763,
4797,
4800,
4801,
4798,
4799,
4790,
4791,
4792,
4793,
4803,
4796,
4802,
4795,
4827,
4823,
4824,
4826,
4820,
4819,
4829,
4828,
]

_charnames_71248 = [
4815,
4816,
4807,
4808,
4813,
4814,
4810,
4811,
4818,
4817,
-1,
-1,
-1,
-1,
-1,
-1,
4866,
4856,
4869,
4862,
4867,
4858,
4859,
4863,
4864,
4852,
4854,
4855,
4861,
]

_charnames_71296 = [
3138,
3141,
3159,
3160,
3142,
3143,
3176,
3140,
3172,
3139,
3155,
3154,
3163,
3162,
3130,
3166,
3165,
3158,
3157,
3128,
3124,
3123,
3135,
3134,
3129,
3126,
3125,
3137,
3136,
3131,
3152,
3151,
3169,
3168,
3173,
3170,
3149,
3174,
3171,
3145,
3146,
3175,
3148,
3207,
3204,
3195,
3198,
3199,
3196,
3197,
3201,
3194,
3200,
3193,
3205,
3206,
]

_charnames_71360 = [
3187,
3188,
3179,
3180,
3185,
3186,
3182,
3183,
3190,
3189,
]

_charnames_71424 = [
6414,
6413,
6404,
6405,
6408,
6399,
6411,
6410,
6426,
6429,
6417,
6432,
6407,
6428,
6430,
6427,
6403,
6431,
6397,
6423,
6422,
6420,
6400,
6419,
6425,
6416,
6401,
-1,
-1,
6470,
6471,
6469,
6434,
6438,
6441,
6442,
6439,
6440,
6444,
6435,
6443,
6437,
6436,
6465,
-1,
-1,
-1,
-1,
6455,
6456,
6447,
6448,
6453,
6454,
6450,
6451,
6458,
6457,
6474,
6473,
6462,
6463,
6464,
6466,
]

_charnames_71680 = [
12565,
12568,
12587,
12588,
12573,
12574,
12604,
12567,
12600,
12566,
12583,
12582,
12591,
12590,
12557,
12594,
12593,
12586,
12585,
12555,
12551,
12550,
12562,
12561,
12556,
12553,
12552,
12564,
12563,
12558,
12580,
12579,
12597,
12596,
12601,
12598,
12577,
12602,
12599,
12571,
12570,
12572,
12603,
12576,
12609,
12614,
12615,
12612,
12613,
12610,
12611,
12617,
12608,
12616,
12607,
12623,
12620,
12621,
12622,
12624,
]

_charnames_71840 = [
13807,
13789,
13808,
13779,
13782,
13781,
13813,
13798,
13793,
13803,
13791,
13814,
13812,
13795,
13780,
13799,
13796,
13804,
13810,
13806,
13815,
13790,
13792,
13816,
13811,
13787,
13786,
13785,
13788,
13801,
13802,
13809,
13767,
13749,
13768,
13739,
13742,
13741,
13773,
13758,
13753,
13763,
13751,
13774,
13772,
13755,
13740,
13759,
13756,
13764,
13770,
13766,
13775,
13750,
13752,
13776,
13771,
13747,
13746,
13745,
13748,
13761,
13762,
13769,
13827,
13828,
13819,
13820,
13825,
13826,
13822,
13823,
13830,
13829,
13835,
13833,
13834,
13840,
13841,
13837,
13838,
13843,
13842,
]

_charnames_72192 = [
14759,
14771,
14764,
14763,
14772,
14766,
14765,
14769,
14768,
14770,
14773,
14736,
14735,
14745,
14744,
14727,
14748,
14747,
14757,
14725,
14709,
14708,
14721,
14720,
14726,
14714,
14713,
14723,
14722,
14728,
14742,
14741,
14751,
14750,
14755,
14712,
14711,
14718,
14717,
14738,
14739,
14760,
14752,
14754,
14756,
14753,
14731,
14730,
14732,
14758,
14734,
14804,
14782,
14777,
14778,
14779,
14783,
14781,
14792,
14788,
14790,
14791,
14789,
14802,
14794,
14797,
14798,
14800,
14799,
14803,
14795,
14784,
]

_charnames_72272 = [
1246,
1273,
1267,
1266,
1274,
1268,
1269,
1272,
1271,
1264,
1265,
1275,
1221,
1220,
1233,
1232,
1212,
1236,
1235,
1230,
1229,
1210,
1196,
1195,
1205,
1204,
1211,
1201,
1200,
1208,
1207,
1213,
1227,
1226,
1239,
1238,
1243,
1199,
1198,
1206,
1223,
1224,
1247,
1240,
1242,
1244,
1241,
1216,
1215,
1217,
1245,
1219,
-1,
-1,
1285,
1286,
1283,
1284,
1257,
1256,
1252,
1258,
1251,
1259,
1254,
1253,
1255,
1250,
1249,
1260,
1290,
1289,
1299,
1291,
1277,
1278,
1280,
1279,
1294,
1295,
1292,
1298,
1297,
]

_charnames_72384 = [
11540,
11546,
11558,
11557,
11562,
11552,
11553,
11542,
11559,
11560,
11545,
11554,
11563,
11551,
11537,
11536,
11543,
11539,
11555,
11532,
11550,
11564,
11561,
11547,
11556,
11533,
11534,
11548,
11528,
11531,
11527,
11529,
11523,
11530,
11526,
11524,
11525,
11580,
11578,
11576,
11581,
11582,
11577,
11573,
11571,
11574,
11575,
11583,
11589,
11585,
11586,
11567,
11565,
11587,
11568,
11569,
11590,
]

_charnames_72704 = [
7689,
7692,
7708,
7709,
7697,
7698,
7668,
7669,
7670,
-1,
7725,
7691,
7721,
7690,
7704,
7703,
7712,
7711,
7681,
7715,
7714,
7707,
7706,
7679,
7675,
7674,
7686,
7685,
7680,
7677,
7676,
7688,
7687,
7682,
7701,
7700,
7718,
7717,
7722,
7719,
7720,
7723,
7671,
7695,
7694,
7696,
7724,
7760,
7763,
7764,
7761,
7762,
7754,
7755,
7756,
-1,
7766,
7759,
7765,
7758,
7791,
7790,
7786,
7787,
7789,
7783,
7782,
7795,
7794,
7793,
]

_charnames_72784 = [
7778,
7779,
7770,
7771,
7776,
7777,
7773,
7774,
7781,
7780,
7751,
7729,
7732,
7742,
7745,
7736,
7738,
7749,
7747,
7734,
7730,
7733,
7743,
7746,
7737,
7739,
7750,
7748,
7796,
-1,
-1,
-1,
4378,
4377,
4353,
4352,
4367,
4340,
4359,
4358,
4365,
4339,
4337,
4336,
4356,
4341,
4350,
4349,
4368,
4363,
4335,
4334,
4355,
4361,
4343,
4344,
4370,
4360,
4362,
4364,
4346,
4347,
4366,
4369,
-1,
-1,
4311,
4310,
4325,
4298,
4317,
4316,
4323,
4297,
4295,
4294,
4314,
4299,
4308,
4307,
4326,
4321,
4293,
4292,
4313,
4319,
4301,
4302,
-1,
4318,
4320,
4322,
4304,
4305,
4324,
4327,
4376,
4374,
4372,
4375,
4373,
4330,
4329,
]

_charnames_72960 = [
4207,
4210,
4231,
4232,
4223,
4224,
4248,
-1,
4209,
4245,
-1,
4208,
4218,
4217,
4235,
4234,
4199,
4238,
4237,
4222,
4221,
4197,
4192,
4191,
4204,
4203,
4198,
4195,
4194,
4206,
4205,
4200,
4227,
4226,
4241,
4240,
4246,
4242,
4244,
4230,
4243,
4213,
4212,
4214,
4247,
4229,
4216,
4220,
4193,
4254,
4257,
4258,
4255,
4256,
4259,
-1,
-1,
-1,
4261,
-1,
4253,
4260,
-1,
4252,
4282,
4278,
4279,
4281,
4280,
4262,
4284,
4285,
]

_charnames_73040 = [
4273,
4274,
4265,
4266,
4271,
4272,
4268,
4269,
4276,
4275,
-1,
-1,
-1,
-1,
-1,
-1,
13251,
13254,
13272,
13273,
13255,
13256,
-1,
13290,
13253,
-1,
13287,
13252,
13283,
13284,
13282,
13281,
13288,
13268,
13267,
13244,
13243,
13265,
13276,
13275,
13250,
13249,
13262,
13279,
13278,
13242,
13241,
13264,
13271,
13270,
13248,
13247,
13261,
13259,
13258,
13289,
13286,
13285,
13296,
13299,
13300,
13297,
13298,
-1,
13302,
13295,
-1,
13301,
13294,
13320,
13319,
13303,
13321,
]

_charnames_73120 = [
13314,
13315,
13306,
13307,
13312,
13313,
13309,
13310,
13317,
13316,
]

_charnames_73440 = [
4449,
4451,
4439,
4446,
4454,
4447,
4443,
4452,
4440,
4453,
4450,
4438,
4441,
4445,
4448,
4442,
4444,
4455,
4463,
4459,
4457,
4460,
4458,
4461,
4462,
]

_charnames_74607 = [
8243,
8300,
8303,
8304,
8158,
8159,
8153,
8146,
8259,
8258,
8183,
8182,
8200,
8197,
8334,
8235,
8234,
8232,
8231,
8241,
8239,
8238,
8237,
8236,
8228,
8093,
8103,
8101,
8099,
8313,
8311,
8223,
8202,
8218,
8217,
8208,
8221,
8339,
8338,
8281,
8326,
8295,
8296,
]

_charnames_74851 = [
8353,
8354,
8347,
8346,
8344,
8345,
8356,
8357,
8350,
8351,
8348,
8358,
-1,
-1,
-1,
-1,
-1,
8359,
]

_charnames_74880 = [
8301,
8302,
8305,
8320,
8319,
8318,
8317,
8321,
8160,
8157,
8151,
8150,
8152,
8132,
8130,
8131,
8141,
8140,
8145,
8124,
8121,
8123,
8122,
8138,
8137,
8144,
8119,
8118,
8116,
8117,
8112,
8110,
8111,
8113,
8128,
8127,
8126,
8143,
8142,
8135,
8134,
8262,
8261,
8264,
8263,
8254,
8253,
8252,
8249,
8250,
8247,
8248,
8251,
8257,
8190,
8180,
8179,
8178,
8189,
8172,
8175,
8174,
8188,
8187,
8169,
8170,
8171,
8186,
8164,
8167,
8166,
8185,
8184,
8191,
8199,
8196,
8194,
8193,
8336,
8335,
8242,
8240,
8229,
8227,
8092,
8062,
8057,
8056,
8061,
8054,
8053,
8060,
8059,
8051,
8050,
8058,
8089,
8088,
8073,
8072,
8067,
8066,
8065,
8074,
8070,
8069,
8079,
8078,
8077,
8082,
8081,
8083,
8037,
8029,
8036,
8035,
8033,
8032,
8034,
8045,
8044,
8047,
8046,
8042,
8041,
8040,
8039,
8090,
8026,
7999,
8012,
8011,
8010,
8009,
8008,
8007,
8006,
8004,
8003,
8002,
8025,
8013,
8024,
8023,
8018,
8019,
8022,
8021,
8020,
8017,
8016,
8086,
8085,
8104,
8102,
8100,
8096,
8097,
8098,
8312,
8310,
8309,
8216,
8209,
8210,
8215,
8214,
8213,
8212,
8211,
8204,
8206,
8205,
8283,
8282,
8280,
8279,
8276,
8272,
8271,
8270,
8269,
8275,
8274,
8284,
8327,
8325,
8324,
8294,
8293,
8291,
8290,
8289,
8332,
8331,
8330,
]

_charnames_82944 = [
5601,
5600,
5599,
5598,
5597,
5596,
5595,
5594,
5593,
5548,
5549,
5558,
5557,
5556,
5555,
5554,
5553,
5552,
5551,
5550,
5546,
5545,
5544,
5543,
5542,
5541,
5536,
5537,
5540,
5539,
5538,
5534,
5533,
5532,
5531,
5530,
5529,
5528,
5527,
5526,
5524,
5525,
5495,
5487,
5488,
5494,
5493,
5492,
5485,
5486,
5482,
5484,
5483,
5491,
5490,
5489,
5591,
5590,
5589,
5588,
5587,
5586,
5585,
5584,
5583,
5582,
5509,
5508,
5507,
5506,
5505,
5504,
5497,
5500,
5499,
5498,
5503,
5502,
5501,
5580,
5579,
5578,
5577,
5576,
5575,
5574,
5573,
5572,
5571,
5569,
5568,
5567,
5566,
5565,
5564,
5563,
5562,
5561,
5560,
5522,
5521,
5520,
5519,
5518,
5517,
5516,
5513,
5514,
5511,
5512,
5515,
5121,
5122,
5119,
5120,
5117,
5118,
5126,
5110,
5113,
5112,
5111,
5114,
5116,
5115,
5125,
5106,
5109,
5108,
5107,
5124,
5123,
5128,
5130,
5129,
5140,
5139,
5138,
5137,
5131,
5132,
5136,
5135,
5134,
5133,
5164,
5163,
5162,
5161,
5160,
5154,
5155,
5159,
5158,
5157,
5156,
5152,
5151,
5150,
5149,
5148,
5142,
5143,
5147,
5146,
5145,
5144,
5230,
5229,
5228,
5227,
5226,
5225,
5224,
5223,
5222,
5221,
5219,
5218,
5217,
5216,
5215,
5214,
5213,
5212,
5211,
5210,
5208,
5207,
5206,
5205,
5204,
5203,
5202,
5201,
5200,
5199,
5197,
5196,
5195,
5194,
5193,
5192,
5191,
5190,
5189,
5188,
5186,
5185,
5184,
5183,
5182,
5181,
5180,
5179,
5178,
5177,
5175,
5174,
5173,
5172,
5171,
5170,
5169,
5168,
5167,
5166,
5373,
5372,
5360,
5362,
5361,
5371,
5370,
5369,
5368,
5365,
5366,
5367,
5363,
5364,
5399,
5398,
5397,
5396,
5395,
5390,
5391,
5388,
5389,
5394,
5393,
5392,
5435,
5434,
5433,
5432,
5431,
5430,
5429,
5425,
5426,
5428,
5427,
5479,
5478,
5477,
5476,
5475,
5474,
5473,
5472,
5471,
5470,
5468,
5467,
5466,
5465,
5464,
5463,
5462,
5461,
5460,
5459,
5457,
5456,
5455,
5454,
5453,
5452,
5451,
5450,
5449,
5448,
5423,
5422,
5421,
5420,
5419,
5418,
5417,
5413,
5414,
5416,
5415,
5446,
5445,
5444,
5443,
5442,
5441,
5440,
5439,
5438,
5437,
5411,
5410,
5409,
5408,
5407,
5406,
5405,
5404,
5403,
5401,
5402,
5386,
5385,
5384,
5383,
5377,
5378,
5382,
5381,
5380,
5379,
5375,
5376,
5324,
5323,
5322,
5321,
5320,
5319,
5318,
5317,
5316,
5314,
5315,
5357,
5356,
5355,
5354,
5353,
5352,
5351,
5350,
5349,
5348,
5312,
5311,
5310,
5309,
5308,
5307,
5306,
5305,
5304,
5302,
5303,
5248,
5247,
5240,
5239,
5238,
5246,
5245,
5244,
5233,
5236,
5235,
5234,
5243,
5242,
5241,
5346,
5345,
5344,
5343,
5342,
5341,
5340,
5339,
5338,
5337,
5300,
5299,
5298,
5297,
5296,
5295,
5294,
5293,
5292,
5290,
5291,
5276,
5275,
5274,
5273,
5267,
5268,
5272,
5271,
5270,
5265,
5266,
5269,
5288,
5278,
5279,
5287,
5286,
5285,
5284,
5283,
5282,
5281,
5280,
5263,
5255,
5256,
5262,
5254,
5253,
5261,
5260,
5250,
5251,
5259,
5258,
5257,
5335,
5334,
5333,
5332,
5331,
5330,
5329,
5328,
5327,
5326,
5705,
5704,
5703,
5702,
5701,
5700,
5699,
5698,
5697,
5696,
5619,
5618,
5628,
5627,
5626,
5625,
5624,
5623,
5622,
5621,
5620,
5694,
5693,
5692,
5691,
5690,
5689,
5688,
5687,
5686,
5685,
5683,
5682,
5681,
5680,
5679,
5678,
5677,
5676,
5675,
5674,
5672,
5671,
5670,
5669,
5668,
5667,
5666,
5665,
5664,
5663,
5606,
5607,
5615,
5614,
5613,
5612,
5611,
5610,
5604,
5605,
5609,
5608,
5661,
5660,
5659,
5658,
5657,
5656,
5655,
5654,
5653,
5652,
5650,
5649,
5648,
5647,
5646,
5645,
5644,
5643,
5642,
5641,
5639,
5638,
5637,
5636,
5635,
5634,
5633,
5632,
5631,
5630,
5714,
5713,
5712,
5711,
5710,
5709,
5708,
5707,
5747,
5746,
5745,
5744,
5743,
5742,
5741,
5740,
5739,
5737,
5736,
5735,
5734,
5733,
5732,
5731,
5730,
5729,
5728,
5726,
5725,
5724,
5723,
5722,
5721,
5720,
5719,
5718,
5717,
5748,
]

_charnames_92160 = [
7053,
7161,
7130,
7131,
7074,
7105,
7150,
7062,
7108,
7127,
7128,
7084,
7146,
7055,
7082,
7089,
7098,
7116,
7049,
7136,
7067,
7114,
7052,
7156,
7155,
7048,
7087,
7122,
7159,
7123,
7094,
7061,
7164,
7160,
7047,
7115,
7099,
7100,
7092,
7140,
7124,
7071,
7133,
7083,
7076,
7132,
7145,
7153,
7113,
7148,
7086,
7137,
7070,
7141,
7093,
7104,
7154,
7167,
7166,
7142,
7112,
7088,
7107,
7045,
7109,
7058,
7120,
7068,
7163,
7054,
7085,
7075,
7097,
7059,
7149,
7111,
7121,
7064,
7081,
7057,
7139,
7065,
7165,
7152,
7077,
7073,
7096,
7201,
7236,
7210,
7211,
7231,
7173,
7220,
7239,
7172,
7221,
7225,
7240,
7229,
7203,
7204,
7242,
7224,
7235,
7208,
7207,
7182,
7175,
7198,
7216,
7243,
7215,
7230,
7226,
7248,
7196,
7193,
7247,
7212,
7237,
7186,
7191,
7192,
7183,
7209,
7176,
7187,
7199,
7223,
7185,
7245,
7174,
7246,
7217,
7180,
7179,
7232,
7194,
7202,
7177,
7219,
7195,
6906,
6943,
6997,
7035,
6904,
6921,
6907,
7030,
6955,
7032,
6947,
6939,
6953,
7025,
6925,
6962,
6981,
7031,
6984,
6998,
6942,
6965,
6916,
6957,
6999,
6992,
6993,
7014,
6926,
7008,
6934,
7004,
7016,
6903,
7037,
6946,
6973,
6940,
6900,
7019,
6958,
6976,
6937,
7006,
6901,
7040,
6920,
6917,
6915,
7041,
7038,
6954,
7039,
6933,
7020,
7003,
6912,
6930,
6988,
6899,
6969,
6966,
7021,
6990,
6932,
6908,
7034,
6902,
6914,
6938,
6991,
6913,
6924,
6972,
7000,
6923,
7011,
7015,
6956,
6970,
6963,
6982,
6952,
6983,
6961,
6996,
6929,
6975,
6974,
7012,
6986,
6987,
6909,
6945,
7022,
7026,
7027,
7007,
6801,
6888,
6748,
6784,
6749,
6862,
6751,
6761,
6742,
6767,
6887,
6736,
6814,
6738,
6833,
6844,
6813,
6754,
6820,
6834,
6879,
6837,
6824,
6786,
6770,
6803,
6795,
6826,
6878,
6752,
6831,
6733,
6848,
6891,
6735,
6893,
6771,
6790,
6857,
6772,
6807,
6792,
6865,
6791,
6783,
6860,
6758,
6799,
6840,
6766,
6846,
6825,
6877,
6832,
6885,
6847,
6734,
6787,
6757,
6830,
6870,
6868,
6764,
6858,
6741,
6788,
6744,
6876,
6871,
6875,
6773,
6776,
6821,
6838,
6746,
6737,
6849,
6796,
6836,
6762,
6845,
6804,
6743,
6856,
6745,
6760,
6753,
6890,
6835,
6882,
6852,
6850,
6765,
6884,
6859,
6797,
6781,
6819,
6806,
6817,
6812,
6839,
6779,
6815,
6777,
6869,
6780,
6816,
6866,
6805,
6861,
6883,
6851,
6778,
6800,
6823,
6894,
6538,
6622,
6602,
6667,
6724,
6662,
6574,
6656,
6711,
6551,
6542,
6570,
6614,
6515,
6681,
6717,
6654,
6524,
6575,
6621,
6674,
6664,
6553,
6530,
6593,
6513,
6529,
6552,
6713,
6547,
6587,
6657,
6519,
6600,
6700,
6514,
6548,
6595,
6661,
6525,
6540,
6615,
6653,
6571,
6536,
6521,
6644,
6701,
6619,
6635,
6588,
6618,
6679,
6655,
6626,
6722,
6719,
6668,
6567,
6612,
6705,
6531,
6651,
6599,
6603,
6556,
6565,
6708,
6617,
6675,
6645,
6558,
6643,
6607,
6541,
6582,
6632,
6670,
6690,
6707,
6510,
6680,
6592,
6516,
6703,
6692,
6561,
6586,
6638,
6523,
6559,
6555,
6589,
6597,
6691,
6564,
6605,
6702,
6688,
6604,
6569,
6511,
6673,
6581,
6562,
6636,
6520,
6578,
6689,
6694,
6545,
6727,
6623,
6725,
6726,
6666,
6577,
6611,
6613,
6537,
6650,
6637,
6526,
6633,
6640,
6641,
6630,
6631,
6678,
6585,
6546,
6572,
6718,
6695,
6723,
6669,
6596,
6714,
6712,
6527,
6532,
6648,
6649,
6687,
6563,
6579,
6663,
6682,
6608,
6591,
6594,
6625,
6683,
6606,
6627,
6693,
6704,
7281,
7319,
7278,
7321,
7286,
7300,
7259,
7311,
7288,
7289,
7296,
7301,
7263,
7255,
7291,
7269,
7268,
7270,
7271,
7277,
7275,
7252,
7251,
7254,
7313,
7266,
7314,
7261,
7305,
7260,
7316,
7306,
7290,
7262,
7284,
7276,
7257,
7258,
7267,
7307,
7320,
7317,
7310,
7309,
7280,
7293,
7285,
7297,
7295,
7294,
7302,
7279,
7272,
7318,
]

_charnames_92736 = [
4993,
5009,
5022,
5011,
5026,
5020,
5027,
5005,
4999,
5016,
5021,
5025,
5000,
4996,
5012,
5008,
5006,
4995,
4994,
5002,
5024,
4991,
5019,
5023,
5018,
4998,
5014,
5013,
5017,
5003,
4992,
-1,
5039,
5040,
5031,
5032,
5037,
5038,
5034,
5035,
5042,
5041,
-1,
-1,
-1,
-1,
5044,
5043,
]

_charnames_92880 = [
7400,
7413,
7423,
7429,
7425,
7403,
7416,
7419,
7412,
7426,
7428,
7405,
7420,
7415,
7418,
7430,
7408,
7422,
7431,
7421,
7404,
7424,
7406,
7432,
7409,
7410,
7407,
7401,
7399,
7427,
-1,
-1,
7439,
7436,
7440,
7435,
7438,
7441,
]

_charnames_92928 = [
11475,
11474,
11471,
11470,
11445,
11444,
11459,
11458,
11477,
11476,
11448,
11447,
11463,
11462,
11442,
11441,
11457,
11456,
11465,
11464,
11469,
11468,
11453,
11452,
11480,
11479,
11451,
11450,
11353,
11338,
11358,
11347,
11340,
11354,
11341,
11355,
11351,
11346,
11357,
11349,
11342,
11345,
11356,
11339,
11343,
11359,
11352,
11350,
11509,
11513,
11516,
11515,
11512,
11517,
11510,
11412,
11414,
11395,
11413,
11418,
11404,
11403,
11402,
11405,
11415,
11426,
11416,
11436,
11408,
11392,
]

_charnames_93008 = [
11491,
11492,
11483,
11484,
11489,
11490,
11486,
11487,
11494,
11493,
-1,
11501,
11504,
11499,
11506,
11505,
11500,
11502,
-1,
11417,
11406,
11433,
11421,
11434,
11432,
11430,
11407,
11429,
11437,
11420,
11425,
11422,
11435,
11427,
11398,
11394,
11390,
11391,
11396,
11397,
-1,
-1,
-1,
-1,
-1,
11364,
11372,
11378,
11379,
11383,
11369,
11381,
11385,
11366,
11365,
11384,
11370,
11382,
11376,
11386,
11373,
11363,
11368,
11375,
]

_charnames_93760 = [
3963,
3959,
3956,
3955,
3943,
3953,
3950,
3962,
3958,
3967,
3968,
3966,
3949,
3942,
3965,
3969,
3972,
3971,
3957,
3946,
3964,
3961,
3952,
3940,
3954,
3970,
3948,
3939,
3960,
3947,
3944,
3945,
3926,
3922,
3919,
3918,
3906,
3916,
3913,
3925,
3921,
3930,
3931,
3929,
3912,
3905,
3928,
3932,
3935,
3934,
3920,
3909,
3927,
3924,
3915,
3903,
3917,
3933,
3911,
3902,
3923,
3910,
3907,
3908,
3988,
3983,
3976,
3978,
3986,
3987,
3981,
3982,
3990,
3989,
3995,
4003,
3993,
3994,
4000,
4001,
3997,
3998,
4004,
4005,
3984,
3977,
3979,
3973,
4006,
3936,
4007,
]

_charnames_93952 = [
4639,
4650,
4585,
4638,
4642,
4641,
4614,
4649,
4633,
4632,
4552,
4607,
4583,
4584,
4551,
4606,
4563,
4565,
4586,
4612,
4559,
4558,
4621,
4620,
4619,
4618,
4550,
4605,
4549,
4604,
4648,
4630,
4587,
4636,
4635,
4562,
4561,
4611,
4645,
4646,
4629,
4628,
4545,
4600,
4556,
4555,
4546,
4601,
4581,
4588,
4597,
4624,
4623,
4576,
4574,
4547,
4602,
4582,
4625,
4577,
4575,
4572,
4570,
4613,
4571,
4569,
4647,
4615,
4644,
]

_charnames_94032 = [
4564,
4704,
4702,
4703,
4661,
4669,
4668,
4662,
4663,
4683,
4685,
4690,
4689,
4677,
4680,
4681,
4686,
4652,
4653,
4654,
4655,
4657,
4660,
4659,
4656,
4658,
4670,
4671,
4672,
4673,
4674,
4676,
4675,
4687,
4688,
4664,
4665,
4679,
4692,
4678,
4691,
4667,
4682,
4666,
4684,
4693,
4694,
]

_charnames_94095 = [
4697,
4696,
4699,
4698,
4543,
4542,
4541,
4540,
4539,
4538,
4537,
4596,
4595,
4594,
4593,
4592,
4591,
]

_charnames_100352 = [
2711,
2710,
2709,
2708,
2707,
2706,
2705,
2704,
2703,
2701,
2700,
2699,
2698,
2697,
2696,
2695,
2694,
2693,
2692,
2690,
2689,
2688,
2687,
2686,
2685,
2684,
2683,
2682,
2681,
2679,
2678,
2677,
2676,
2675,
2674,
2673,
2672,
2671,
2670,
2668,
2667,
2666,
2665,
2664,
2663,
2662,
2661,
2660,
2659,
2657,
2656,
2655,
2654,
2653,
2652,
2651,
2650,
2649,
2648,
2646,
2645,
2644,
2643,
2642,
2641,
2640,
2639,
2638,
2637,
2635,
2634,
2633,
2632,
2631,
2630,
2629,
2628,
2627,
2626,
2624,
2623,
2622,
2621,
2620,
2619,
2618,
2617,
2616,
2615,
2613,
2612,
2611,
2610,
2609,
2608,
2607,
2606,
2605,
2604,
2601,
2600,
2599,
2598,
2597,
2596,
2595,
2594,
2593,
2592,
2590,
2589,
2588,
2587,
2586,
2585,
2584,
2583,
2582,
2581,
2579,
2578,
2577,
2576,
2575,
2574,
2573,
2572,
2571,
2570,
2568,
2567,
2566,
2565,
2564,
2563,
2562,
2561,
2560,
2559,
2557,
2556,
2555,
2554,
2553,
2552,
2551,
2550,
2549,
2548,
2546,
2545,
2544,
2543,
2542,
2541,
2540,
2539,
2538,
2537,
2535,
2534,
2533,
2532,
2531,
2530,
2529,
2528,
2527,
2526,
2524,
2523,
2522,
2521,
2520,
2519,
2518,
2517,
2516,
2515,
2513,
2512,
2511,
2510,
2509,
2508,
2507,
2506,
2505,
2504,
2502,
2501,
2500,
2499,
2498,
2497,
2496,
2495,
2494,
2493,
2490,
2489,
2488,
2487,
2486,
2485,
2484,
2483,
2482,
2481,
2479,
2478,
2477,
2476,
2475,
2474,
2473,
2472,
2471,
2470,
2468,
2467,
2466,
2465,
2464,
2463,
2462,
2461,
2460,
2459,
2457,
2456,
2455,
2454,
2453,
2452,
2451,
2450,
2449,
2448,
2446,
2445,
2444,
2443,
2442,
2441,
2440,
2439,
2438,
2437,
2435,
2434,
2433,
2432,
2431,
2430,
2429,
2428,
2427,
2426,
2424,
2423,
2422,
2421,
2420,
2419,
2418,
2417,
2416,
2415,
2413,
2412,
2411,
2410,
2409,
2408,
2407,
2406,
2405,
2404,
2402,
2401,
2400,
2399,
2398,
2397,
2396,
2395,
2394,
2393,
2391,
2390,
2389,
2388,
2387,
2386,
2385,
2384,
2383,
2382,
2379,
2378,
2377,
2376,
2375,
2374,
2373,
2372,
2371,
2370,
2368,
2367,
2366,
2365,
2364,
2363,
2362,
2361,
2360,
2359,
2357,
2356,
2355,
2354,
2353,
2352,
2351,
2350,
2349,
2348,
2346,
2345,
2344,
2343,
2342,
2341,
2340,
2339,
2338,
2337,
2335,
2334,
2333,
2332,
2331,
2330,
2329,
2328,
2327,
2326,
2324,
2323,
2322,
2321,
2320,
2319,
2318,
2317,
2316,
2315,
2313,
2312,
2311,
2310,
2309,
2308,
2307,
2306,
2305,
2304,
2302,
2301,
2300,
2299,
2298,
2297,
2296,
2295,
2294,
2293,
2291,
2290,
2289,
2288,
2287,
2286,
2285,
2284,
2283,
2282,
2280,
2279,
2278,
2277,
2276,
2275,
2274,
2273,
2272,
2271,
2268,
2267,
2266,
2265,
2264,
2263,
2262,
2261,
2260,
2259,
2257,
2256,
2255,
2254,
2253,
2252,
2251,
2250,
2249,
2248,
2246,
2245,
2244,
2243,
2242,
2241,
2240,
2239,
2238,
2237,
2235,
2234,
2233,
2232,
2231,
2230,
2229,
2228,
2227,
2226,
2224,
2223,
2222,
2221,
2220,
2219,
2218,
2217,
2216,
2215,
2213,
2212,
2211,
2210,
2209,
2208,
2207,
2206,
2205,
2204,
2202,
2201,
2200,
2199,
2198,
2197,
2196,
2195,
2194,
2193,
2191,
2190,
2189,
2188,
2187,
2186,
2185,
2184,
2183,
2182,
2180,
2179,
2178,
2177,
2176,
2175,
2174,
2173,
2172,
2171,
2169,
2168,
2167,
2166,
2165,
2164,
2163,
2162,
2161,
2160,
2157,
2156,
2155,
2154,
2153,
2152,
2151,
2150,
2149,
2148,
2146,
2145,
2144,
2143,
2142,
2141,
2140,
2139,
2138,
2137,
2135,
2134,
2133,
2132,
2131,
2130,
2129,
2128,
2127,
2126,
2124,
2123,
2122,
2121,
2120,
2119,
2118,
2117,
2116,
2115,
2113,
2112,
2111,
2110,
2109,
2108,
2107,
2106,
2105,
2104,
2102,
2101,
2100,
2099,
2098,
2097,
2096,
2095,
2094,
2093,
2091,
2090,
2089,
2088,
2087,
2086,
2085,
2084,
2083,
2082,
2080,
2079,
2078,
2077,
2076,
2075,
2074,
2073,
2072,
2071,
2069,
2068,
2067,
2066,
2065,
2064,
2063,
2062,
2061,
2060,
2058,
2057,
2056,
2055,
2054,
2053,
2052,
2051,
2050,
2049,
2046,
2045,
2044,
2043,
2042,
2041,
2040,
2039,
2038,
2037,
2035,
2034,
2033,
2032,
2031,
2030,
2029,
2028,
2027,
2026,
2024,
2023,
2022,
2021,
2020,
2019,
2018,
2017,
2016,
2015,
2013,
2012,
2011,
2010,
2009,
2008,
2007,
2006,
2005,
2004,
2002,
2001,
2000,
1999,
1998,
1997,
1996,
1995,
1994,
1993,
1991,
1990,
1989,
1988,
1987,
1986,
1985,
1984,
1983,
1982,
1980,
1979,
1978,
1977,
1976,
1975,
1974,
1973,
1972,
1971,
1969,
1968,
1967,
1966,
1965,
1964,
1963,
1962,
1961,
1960,
1958,
1957,
1956,
1955,
1954,
1953,
1952,
1951,
1950,
1949,
1947,
1946,
1945,
1944,
1943,
1942,
1941,
1940,
1939,
1938,
2767,
2766,
2765,
2764,
2763,
2762,
2761,
2760,
2759,
2758,
2756,
2755,
2754,
2753,
2752,
2751,
2750,
2749,
2748,
2747,
2745,
2744,
2743,
2742,
2741,
2740,
2739,
2738,
2737,
2736,
2734,
2733,
2732,
2731,
2730,
2729,
2728,
2727,
2726,
2725,
2723,
2722,
2721,
2720,
2719,
2718,
2717,
2716,
2715,
2714,
2774,
2773,
2772,
2771,
2770,
2769,
]

_charnames_110592 = [
13689,
11311,
11050,
11049,
11048,
11047,
11045,
11044,
11043,
11042,
11040,
11039,
11038,
11037,
11036,
11033,
11032,
11031,
11030,
11029,
11054,
11053,
11052,
10714,
10725,
10724,
10723,
10722,
10721,
10720,
10719,
10718,
10716,
10715,
10717,
10734,
10733,
10732,
10731,
10730,
10729,
10728,
10727,
10742,
10741,
10740,
10739,
10738,
10737,
10736,
10749,
10748,
10747,
10746,
10745,
10744,
10754,
10753,
10752,
10751,
10815,
10814,
10813,
10812,
10811,
10810,
10809,
10808,
10830,
10829,
10828,
10827,
10826,
10825,
10806,
10805,
10804,
10803,
10802,
10801,
10800,
10799,
10836,
10835,
10834,
10833,
10832,
10823,
10822,
10821,
10820,
10819,
10818,
10817,
10915,
10914,
10913,
10912,
10904,
10903,
10902,
10901,
10900,
10899,
10898,
10910,
10909,
10908,
10907,
10906,
10888,
10887,
10886,
10885,
10884,
10883,
10882,
10881,
10880,
10896,
10895,
10894,
10893,
10892,
10891,
10890,
10847,
10846,
10845,
10844,
10843,
10842,
10841,
10840,
10839,
10856,
10855,
10854,
10853,
10852,
10851,
10850,
10849,
10874,
10873,
10872,
10864,
10863,
10862,
10861,
10860,
10859,
10858,
10870,
10869,
10868,
10867,
10866,
10757,
10767,
10766,
10765,
10764,
10763,
10762,
10761,
10760,
10759,
10758,
10784,
10783,
10782,
10781,
10780,
10779,
10778,
10796,
10795,
10794,
10792,
10791,
10790,
10789,
10788,
10787,
10786,
10776,
10775,
10774,
10773,
10772,
10771,
10770,
10769,
10965,
10964,
10963,
10962,
10961,
10960,
10959,
10957,
10956,
10955,
10954,
10953,
10952,
10951,
10977,
10976,
10975,
10974,
10981,
10980,
10979,
10972,
10971,
10970,
10969,
10968,
10967,
11022,
11021,
11020,
11019,
11018,
11017,
11027,
11026,
11025,
11024,
11015,
11014,
11013,
11012,
11011,
11010,
10948,
10947,
10946,
10945,
10924,
10923,
10922,
10921,
10920,
10919,
10918,
10931,
10930,
10929,
10928,
10927,
10926,
10943,
10942,
10941,
10940,
10938,
10937,
10936,
10935,
10934,
10933,
11002,
11001,
11000,
10999,
10998,
10996,
10995,
10994,
10993,
10992,
11007,
11006,
11005,
11004,
10990,
10989,
10988,
10987,
10986,
10985,
10984,
10877,
10876,
]

_charnames_110960 = [
10389,
10388,
10387,
10386,
10385,
10384,
10383,
10382,
10381,
10380,
10379,
10378,
10377,
10376,
10375,
10374,
10372,
10371,
10370,
10369,
10368,
10367,
10366,
10365,
10364,
10363,
10362,
10361,
10360,
10359,
10358,
10357,
10355,
10354,
10353,
10352,
10351,
10350,
10349,
10348,
10347,
10346,
10345,
10344,
10343,
10342,
10341,
10340,
10338,
10337,
10336,
10335,
10334,
10333,
10332,
10331,
10330,
10329,
10328,
10327,
10326,
10325,
10324,
10323,
10321,
10320,
10319,
10318,
10317,
10316,
10315,
10314,
10313,
10312,
10311,
10310,
10309,
10308,
10307,
10306,
10304,
10303,
10302,
10301,
10300,
10299,
10298,
10297,
10296,
10295,
10294,
10293,
10292,
10291,
10290,
10289,
10287,
10286,
10285,
10284,
10283,
10282,
10281,
10280,
10279,
10278,
10277,
10276,
10275,
10274,
10273,
10272,
10270,
10269,
10268,
10267,
10266,
10265,
10264,
10263,
10262,
10261,
10260,
10259,
10258,
10257,
10256,
10255,
10253,
10252,
10251,
10250,
10249,
10248,
10247,
10246,
10245,
10244,
10243,
10242,
10241,
10240,
10239,
10238,
10222,
10221,
10220,
10219,
10218,
10217,
10216,
10215,
10214,
10213,
10212,
10211,
10210,
10209,
10208,
10207,
10205,
10204,
10203,
10202,
10201,
10200,
10199,
10198,
10197,
10196,
10195,
10194,
10193,
10192,
10191,
10190,
10188,
10187,
10186,
10185,
10184,
10183,
10182,
10181,
10180,
10179,
10178,
10177,
10176,
10175,
10174,
10173,
10171,
10170,
10169,
10168,
10167,
10166,
10165,
10164,
10163,
10162,
10161,
10160,
10159,
10158,
10157,
10156,
10154,
10153,
10152,
10151,
10150,
10149,
10148,
10147,
10146,
10145,
10144,
10143,
10142,
10141,
10140,
10139,
10137,
10136,
10135,
10134,
10133,
10132,
10131,
10130,
10129,
10128,
10127,
10126,
10125,
10124,
10123,
10122,
10120,
10119,
10118,
10117,
10116,
10115,
10114,
10113,
10112,
10111,
10110,
10109,
10108,
10107,
10106,
10105,
10103,
10102,
10101,
10100,
10099,
10098,
10097,
10096,
10095,
10094,
10093,
10092,
10091,
10090,
10089,
10088,
10086,
10085,
10084,
10083,
10082,
10081,
10080,
10079,
10078,
10077,
10076,
10075,
10074,
10073,
10072,
10071,
10069,
10068,
10067,
10066,
10065,
10064,
10063,
10062,
10061,
10060,
10059,
10058,
10057,
10056,
10055,
10054,
10052,
10051,
10050,
10049,
10048,
10047,
10046,
10045,
10044,
10043,
10042,
10041,
10040,
10039,
10038,
10037,
10035,
10034,
10033,
10032,
10031,
10030,
10029,
10028,
10027,
10026,
10025,
10024,
10023,
10022,
10021,
10020,
10018,
10017,
10016,
10015,
10014,
10013,
10012,
10011,
10010,
10009,
10008,
10007,
10006,
10005,
10004,
10003,
10001,
10000,
9999,
9998,
9997,
9996,
9995,
9994,
9993,
9992,
9991,
9990,
9989,
9988,
9987,
9986,
9984,
9983,
9982,
9981,
9980,
9979,
9978,
9977,
9976,
9975,
9974,
9973,
9972,
9971,
9970,
9969,
10235,
10234,
10233,
10232,
10231,
10230,
10229,
10228,
10227,
10226,
10225,
10224,
]

_charnames_113664 = [
12486,
12480,
12459,
12454,
12490,
12469,
12464,
12495,
12477,
12482,
12488,
12433,
12463,
12479,
12491,
12472,
12438,
12458,
12401,
12478,
12473,
12400,
12487,
12468,
12437,
12444,
12404,
12415,
12376,
12446,
12411,
12423,
12386,
12448,
12413,
12417,
12418,
12378,
12379,
12449,
12414,
12419,
12388,
12447,
12412,
12424,
12387,
12420,
12421,
12422,
12380,
12381,
12382,
12383,
12456,
12457,
12425,
12429,
12432,
12389,
12390,
12471,
12489,
12384,
12385,
12492,
12397,
12443,
12439,
12493,
12484,
12474,
12485,
12403,
12451,
12476,
12394,
12436,
12395,
12467,
12494,
12450,
12475,
12481,
12453,
12466,
12435,
12452,
12399,
12442,
12440,
12441,
12431,
12426,
12428,
12430,
12427,
12406,
12407,
12408,
12409,
12461,
12462,
12393,
12402,
12398,
12483,
-1,
-1,
-1,
-1,
-1,
12512,
12536,
12537,
12500,
12535,
12515,
12530,
12531,
12527,
12529,
12533,
12532,
12528,
-1,
-1,
-1,
12524,
12520,
12521,
12517,
12522,
12523,
12518,
12519,
12514,
]

_charnames_113808 = [
12506,
12508,
12509,
12502,
12510,
12511,
12503,
12507,
12499,
12505,
-1,
-1,
12539,
12538,
12541,
12540,
1566,
1568,
1567,
1565,
]

_charnames_119262 = [
4982,
4972,
4978,
4980,
4979,
4981,
4975,
4974,
4971,
4970,
4977,
]

_charnames_119520 = [
4522,
4523,
4499,
4502,
4511,
4514,
4506,
4508,
4517,
4520,
4504,
4519,
4500,
4503,
4512,
4515,
4507,
4509,
4518,
4521,
]

_charnames_119666 = [
14562,
14557,
14558,
14560,
14561,
3210,
3211,
]

_charnames_120832 = [
10,
242,
223,
362,
276,
331,
101,
254,
111,
100,
103,
89,
93,
253,
12,
244,
53,
50,
51,
94,
91,
15,
28,
27,
25,
23,
30,
247,
148,
102,
33,
249,
56,
54,
44,
52,
96,
97,
92,
55,
36,
38,
40,
41,
115,
18,
20,
21,
140,
81,
24,
31,
22,
26,
133,
76,
131,
132,
87,
88,
78,
37,
43,
42,
136,
137,
138,
82,
189,
194,
193,
191,
192,
272,
176,
311,
180,
203,
187,
205,
188,
206,
186,
231,
232,
312,
363,
182,
184,
185,
177,
212,
201,
209,
207,
211,
210,
200,
196,
197,
198,
199,
263,
266,
270,
267,
328,
315,
217,
215,
220,
229,
222,
233,
221,
230,
237,
235,
240,
354,
357,
360,
358,
291,
295,
274,
313,
294,
303,
296,
314,
304,
305,
329,
46,
250,
286,
340,
297,
49,
48,
287,
150,
153,
154,
155,
161,
110,
260,
361,
346,
162,
163,
157,
158,
301,
160,
300,
345,
344,
159,
261,
299,
343,
57,
251,
288,
306,
341,
32,
248,
174,
307,
353,
169,
171,
172,
262,
359,
352,
165,
168,
167,
173,
170,
327,
99,
252,
239,
325,
326,
324,
227,
289,
338,
337,
147,
308,
141,
258,
145,
142,
322,
139,
146,
144,
256,
238,
234,
309,
349,
350,
347,
257,
268,
269,
320,
321,
318,
290,
59,
282,
62,
63,
64,
67,
68,
66,
84,
85,
79,
75,
74,
271,
73,
77,
225,
226,
283,
284,
278,
281,
335,
336,
333,
104,
125,
119,
120,
121,
126,
114,
117,
116,
108,
123,
109,
112,
124,
8,
175,
733,
734,
735,
982,
983,
984,
918,
919,
920,
968,
969,
970,
803,
804,
805,
927,
928,
914,
910,
915,
911,
912,
886,
882,
887,
883,
884,
916,
650,
649,
651,
653,
648,
647,
652,
499,
619,
442,
443,
440,
441,
444,
479,
478,
476,
477,
415,
474,
473,
471,
472,
460,
461,
462,
407,
409,
410,
408,
412,
413,
414,
456,
457,
458,
488,
489,
490,
492,
493,
494,
697,
698,
699,
701,
702,
703,
708,
706,
707,
705,
641,
642,
639,
640,
636,
637,
634,
635,
631,
632,
629,
630,
626,
627,
624,
625,
576,
577,
574,
575,
578,
600,
599,
597,
598,
520,
595,
594,
593,
592,
606,
517,
518,
519,
521,
603,
604,
605,
608,
609,
610,
612,
613,
614,
716,
717,
718,
712,
713,
714,
719,
396,
397,
394,
395,
388,
389,
386,
387,
400,
401,
467,
468,
469,
447,
452,
453,
448,
424,
425,
426,
420,
421,
422,
402,
404,
405,
759,
763,
771,
445,
391,
465,
450,
432,
761,
765,
769,
392,
466,
451,
433,
762,
766,
770,
428,
429,
430,
509,
510,
566,
569,
565,
568,
549,
552,
550,
553,
529,
530,
776,
780,
784,
506,
507,
561,
562,
559,
560,
542,
545,
543,
546,
526,
527,
775,
779,
783,
513,
514,
511,
512,
515,
570,
554,
532,
533,
534,
773,
777,
781,
579,
482,
485,
483,
486,
582,
585,
588,
583,
586,
589,
435,
436,
536,
537,
497,
498,
617,
618,
937,
938,
942,
935,
939,
940,
933,
934,
943,
941,
365,
377,
371,
370,
374,
372,
375,
376,
904,
902,
903,
838,
839,
840,
947,
949,
948,
946,
899,
900,
898,
831,
830,
832,
843,
844,
828,
826,
829,
825,
845,
834,
836,
835,
810,
812,
813,
818,
820,
821,
815,
822,
816,
961,
962,
960,
754,
752,
753,
847,
955,
956,
953,
954,
979,
976,
980,
977,
972,
973,
669,
670,
671,
677,
679,
680,
685,
687,
688,
666,
665,
664,
660,
663,
662,
656,
659,
658,
681,
684,
683,
673,
676,
675,
864,
863,
862,
672,
690,
691,
728,
730,
724,
723,
731,
729,
726,
727,
742,
749,
745,
746,
747,
748,
750,
500,
620,
957,
364,
846,
923,
924,
985,
888,
925,
738,
739,
740,
986,
859,
858,
857,
856,
855,
854,
853,
852,
896,
875,
876,
868,
870,
873,
869,
871,
872,
964,
905,
929,
965,
987,
]

_charnames_121499 = [
895,
894,
893,
892,
891,
-1,
801,
800,
799,
798,
797,
796,
795,
794,
793,
792,
791,
790,
789,
788,
787,
]

_charnames_122880 = [
8655,
8641,
8643,
8653,
8638,
8612,
8629,
-1,
8630,
8620,
8621,
8616,
8639,
8651,
8650,
8649,
8648,
8647,
8646,
8645,
8627,
8632,
8644,
8635,
8652,
-1,
-1,
8624,
8633,
8654,
8625,
8610,
8611,
8615,
-1,
8613,
8626,
-1,
8614,
8618,
8642,
8619,
8636,
]

_charnames_124928 = [
3599,
3598,
3597,
3529,
3496,
3517,
3548,
3613,
3596,
3595,
3594,
3671,
3680,
3684,
3551,
3704,
3652,
3533,
3547,
3657,
3593,
3592,
3591,
3536,
3497,
3640,
3602,
3589,
3588,
3587,
3644,
3494,
3696,
3658,
3586,
3585,
3584,
3630,
3699,
3628,
3648,
3659,
3665,
3661,
3703,
3614,
3580,
3578,
3577,
3631,
3682,
3660,
3514,
3702,
3573,
3572,
3571,
3508,
3520,
3541,
3641,
3688,
3583,
3582,
3581,
3503,
3611,
3610,
3576,
3575,
3574,
3500,
3540,
3695,
3525,
3570,
3569,
3567,
3637,
3685,
3633,
3531,
3617,
3566,
3565,
3564,
3690,
3512,
3654,
3676,
3563,
3562,
3561,
3515,
3518,
3663,
3504,
3701,
3698,
3560,
3559,
3558,
3681,
3624,
3616,
3555,
3605,
3556,
3495,
3554,
3655,
3509,
3669,
3542,
3666,
3505,
3543,
3705,
3550,
3501,
3553,
3510,
3683,
3649,
3638,
3677,
3635,
3670,
3506,
3693,
3608,
3639,
3687,
3625,
3708,
3627,
3626,
3607,
3538,
3615,
3526,
3492,
3545,
3511,
3544,
3697,
3528,
3650,
3532,
3675,
3549,
3603,
3521,
3620,
3618,
3604,
3632,
3694,
3653,
3664,
3499,
3519,
3552,
3691,
3686,
3636,
3673,
3539,
3647,
3498,
3692,
3522,
3523,
3621,
3674,
3668,
3672,
3707,
3679,
3527,
3530,
3642,
3706,
3646,
3662,
3609,
3606,
3643,
3619,
3507,
3651,
3516,
3629,
3537,
3622,
3493,
3534,
-1,
-1,
3719,
3711,
3712,
3717,
3718,
3714,
3715,
3721,
3720,
3728,
3726,
3731,
3729,
3727,
3732,
3733,
]

_charnames_125184 = [
6323,
6302,
6316,
6315,
6305,
6295,
6313,
6304,
6311,
6321,
6320,
6318,
6314,
6301,
6292,
6307,
6285,
6290,
6293,
6309,
6317,
6322,
6319,
6312,
6299,
6284,
6310,
6286,
6308,
6289,
6298,
6306,
6288,
6296,
6366,
6345,
6359,
6358,
6348,
6338,
6356,
6347,
6354,
6364,
6363,
6361,
6357,
6344,
6335,
6350,
6328,
6333,
6336,
6352,
6360,
6365,
6362,
6355,
6342,
6327,
6353,
6329,
6351,
6332,
6341,
6349,
6331,
6339,
6390,
6387,
6385,
6389,
6324,
6386,
6388,
-1,
-1,
-1,
-1,
-1,
6377,
6378,
6369,
6370,
6375,
6376,
6372,
6373,
6380,
6379,
-1,
-1,
-1,
-1,
6383,
6382,
]

_charnames_126065 = [
14508,
14440,
14447,
14470,
14477,
14456,
14462,
14502,
14496,
14453,
14444,
14451,
14474,
14481,
14457,
14463,
14503,
14497,
14511,
14443,
14450,
14473,
14480,
14461,
14467,
14507,
14501,
14510,
14442,
14449,
14472,
14479,
14460,
14466,
14506,
14500,
14454,
14445,
14452,
14475,
14482,
14458,
14464,
14504,
14498,
14517,
14518,
14528,
14519,
14520,
14493,
14485,
14486,
14491,
14492,
14488,
14489,
14495,
14494,
14527,
14523,
14524,
14525,
14526,
14516,
14514,
14515,
14529,
]

_charnames_126464 = [
5940,
5952,
5948,
5806,
-1,
5943,
5931,
5949,
5925,
5942,
5938,
5844,
5947,
5946,
5877,
5941,
5951,
5878,
5945,
5944,
5876,
5929,
5927,
5937,
5928,
5807,
5932,
5950,
5804,
5802,
5803,
5801,
-1,
5902,
5898,
-1,
5891,
-1,
-1,
5892,
-1,
5893,
5889,
5897,
5896,
5895,
5882,
5903,
5900,
5883,
5894,
-1,
5881,
5886,
5885,
5888,
-1,
5901,
-1,
5899,
-1,
-1,
-1,
-1,
-1,
-1,
5921,
-1,
-1,
-1,
-1,
5922,
-1,
5916,
-1,
5919,
-1,
5918,
5909,
5924,
-1,
5910,
5917,
-1,
5908,
-1,
-1,
5920,
-1,
5915,
-1,
5923,
-1,
5914,
-1,
5913,
-1,
5874,
5871,
-1,
5864,
-1,
-1,
5865,
5850,
5867,
5862,
-1,
5870,
5869,
5853,
5875,
5873,
5854,
5868,
-1,
5852,
5849,
5848,
5861,
-1,
5859,
5866,
5872,
5858,
-1,
5857,
-1,
5830,
5843,
5840,
5827,
5824,
5833,
5821,
5825,
5815,
5832,
-1,
5838,
5837,
5836,
5818,
5831,
5842,
5819,
5835,
5834,
5817,
5814,
5812,
5839,
5813,
5828,
5822,
5841,
-1,
-1,
-1,
-1,
-1,
5798,
5794,
5784,
-1,
5787,
5781,
5795,
5775,
5786,
-1,
5792,
5791,
5790,
5778,
5799,
5797,
5779,
5789,
5788,
5777,
5774,
5772,
5793,
5773,
5785,
5782,
5796,
]

_charnames_127136 = [
11773,
11767,
11697,
11702,
11714,
11720,
11726,
11731,
11762,
11752,
11707,
11757,
11737,
11747,
11742,
-1,
-1,
11768,
11698,
11703,
11715,
11721,
11727,
11732,
11763,
11753,
11708,
11758,
11738,
11748,
11743,
11775,
-1,
11769,
11699,
11704,
11716,
11722,
11728,
11733,
11764,
11754,
11709,
11759,
11739,
11749,
11744,
11772,
-1,
11770,
11700,
11705,
11717,
11723,
11729,
11734,
11765,
11755,
11710,
11760,
11740,
11750,
11745,
11774,
11718,
11675,
11686,
11695,
11694,
11693,
11692,
11691,
11690,
11689,
11685,
11684,
11683,
11682,
11681,
11680,
11679,
11678,
11677,
11676,
11688,
11687,
]

_charnames_127279 = [
8810,
1618,
-1,
1617,
1616,
1615,
1614,
1613,
1612,
1611,
1610,
1609,
1608,
1607,
-1,
1606,
-1,
1605,
1604,
-1,
1603,
1602,
1601,
-1,
1600,
1599,
1598,
-1,
-1,
-1,
-1,
-1,
1678,
10557,
10556,
10555,
10554,
10553,
10552,
10551,
-1,
10550,
10549,
10548,
10547,
10546,
10545,
10544,
-1,
10543,
10542,
10541,
10540,
10539,
10538,
10537,
10536,
10535,
10534,
14188,
14187,
-1,
-1,
-1,
-1,
10583,
10582,
10581,
10580,
10579,
10578,
10577,
10576,
10575,
-1,
10574,
-1,
-1,
10573,
10572,
-1,
10571,
10570,
10569,
10568,
10567,
10566,
10565,
10564,
10563,
10562,
-1,
-1,
-1,
-1,
10586,
10584,
-1,
1642,
1641,
1660,
1679,
1674,
1673,
1671,
1647,
1667,
1664,
1654,
1646,
1652,
1661,
1680,
1662,
1645,
1653,
1648,
1670,
1619,
1658,
1657,
1656,
1624,
1649,
1668,
1665,
]

_charnames_127462 = [
14117,
14116,
14115,
14114,
14113,
14112,
14111,
14110,
14109,
14108,
14107,
14106,
14105,
14104,
14103,
14102,
14101,
14100,
14099,
14098,
14097,
14096,
14095,
14094,
14093,
14092,
-1,
1677,
1676,
]

_charnames_127538 = [
1629,
1628,
1638,
1635,
1633,
1634,
1630,
1639,
1637,
1640,
]

_charnames_127744 = [
9060,
14662,
9004,
10708,
1711,
1710,
9103,
1712,
14196,
7652,
13847,
13101,
4718,
14405,
14404,
14403,
13425,
10525,
13858,
14632,
13857,
14699,
13860,
9832,
13861,
9080,
10524,
14631,
9831,
14698,
1714,
13423,
1579,
3382,
7856,
13927,
13931,
13929,
13930,
9010,
9009,
9011,
9008,
14661,
13918,
11291,
3216,
7971,
8486,
1887,
14427,
12744,
11636,
8947,
11290,
3434,
8481,
14172,
11322,
1713,
7893,
14408,
14407,
11135,
14657,
4531,
14617,
9921,
4987,
3469,
6479,
13205,
4067,
13851,
2776,
9924,
7479,
11921,
14146,
13220,
11853,
11852,
8482,
1749,
11261,
1880,
4068,
11869,
14087,
14088,
8827,
8362,
1754,
1793,
7663,
14675,
14178,
12773,
12370,
1717,
14677,
14646,
1421,
1560,
14565,
12689,
8826,
8600,
8920,
9952,
8373,
11299,
1574,
7945,
11875,
8825,
14651,
3453,
1864,
13920,
8835,
3404,
7960,
9022,
7484,
14652,
7928,
11886,
14070,
13992,
7976,
14912,
8601,
14615,
14623,
14624,
7458,
11644,
8815,
2777,
9068,
11922,
14910,
8932,
13917,
4897,
1905,
13206,
11129,
7925,
4719,
14148,
4985,
1746,
9922,
8818,
7953,
7952,
14642,
6392,
8933,
14694,
14165,
14645,
4708,
4908,
9104,
11134,
6109,
3463,
9101,
3350,
9016,
11843,
13092,
12761,
1884,
7979,
13433,
7916,
14684,
4986,
4963,
1862,
13335,
4984,
3408,
13095,
4983,
14222,
3455,
1927,
7443,
8487,
1910,
14223,
1723,
1780,
3405,
11280,
6491,
14231,
1920,
13982,
13419,
14199,
14200,
9078,
13100,
14648,
14564,
3213,
1911,
8942,
7955,
7972,
11285,
9102,
12745,
9017,
12737,
12738,
10648,
1742,
11284,
11286,
12369,
14907,
14422,
11300,
7473,
6478,
11292,
9949,
8822,
1904,
12746,
14611,
14566,
14911,
14423,
13961,
7881,
13853,
13855,
14173,
7845,
9834,
7496,
7917,
6490,
14354,
14353,
14352,
14351,
14350,
14206,
4885,
12363,
13850,
8828,
3347,
9923,
14204,
8934,
12782,
9071,
13965,
1914,
1913,
11278,
14207,
13416,
1591,
4875,
14175,
8597,
12545,
11916,
7933,
14299,
12361,
1784,
7973,
5749,
11298,
9836,
14644,
3403,
7892,
3432,
11256,
7483,
14668,
7977,
11847,
13733,
11889,
12781,
7470,
12698,
4886,
8829,
3348,
14205,
8935,
12783,
1779,
11281,
4876,
12625,
11919,
14669,
11260,
13979,
7950,
11663,
11918,
11667,
8596,
14411,
14410,
14400,
10695,
4887,
3468,
13957,
13940,
13946,
13959,
14647,
13854,
12367,
3379,
3380,
9015,
12324,
9069,
13971,
14412,
10593,
3483,
14916,
12785,
13731,
7985,
13972,
11930,
11218,
11870,
4184,
6499,
11316,
13970,
13973,
14660,
7966,
7965,
7922,
13428,
4070,
13968,
14616,
4182,
3477,
3475,
11884,
13974,
7653,
11832,
4177,
4176,
12219,
12218,
7480,
8820,
11906,
14908,
14909,
13432,
7485,
14397,
6276,
14567,
1926,
14546,
13336,
12774,
9545,
10651,
14610,
11264,
7490,
1842,
11924,
13729,
9948,
14084,
13413,
13722,
7924,
8831,
13987,
7954,
7658,
3478,
1791,
13235,
11131,
7889,
13218,
14919,
11931,
11130,
14136,
11132,
12760,
14298,
5762,
7930,
1870,
8836,
1794,
12779,
12771,
11925,
14687,
12750,
1774,
3381,
13953,
11325,
4873,
8363,
11101,
9081,
7475,
7478,
7477,
7476,
4872,
8587,
1895,
11841,
7654,
4715,
14685,
12327,
12792,
14638,
12322,
11651,
11653,
8945,
3452,
8926,
8586,
8588,
7489,
9023,
11933,
14162,
11668,
1750,
3395,
7920,
9926,
10687,
10688,
9006,
12325,
13219,
7890,
12342,
7921,
10649,
1898,
4066,
3439,
11655,
14613,
1861,
11935,
8485,
12365,
14554,
11669,
14431,
14553,
14383,
9003,
9002,
12318,
12319,
11878,
11879,
10530,
4900,
4902,
13096,
4903,
10683,
5758,
8940,
8941,
13093,
3442,
14202,
13094,
14641,
11888,
11914,
3481,
8995,
8996,
8999,
5757,
9941,
11319,
1769,
1765,
1768,
1767,
7395,
14297,
9917,
14068,
9946,
9005,
13701,
9942,
12323,
7957,
7959,
7919,
9519,
14203,
7468,
14380,
12351,
1426,
3464,
10682,
13717,
14536,
14534,
14538,
14537,
14535,
14621,
14296,
13991,
11258,
10393,
11302,
11926,
4707,
3443,
9076,
1187,
14906,
3399,
7830,
13936,
9827,
9826,
9828,
9825,
1819,
1820,
14865,
12677,
14863,
12676,
9937,
14874,
9091,
9066,
9065,
10694,
10693,
1846,
13947,
11080,
9110,
12366,
12695,
13700,
4906,
1845,
3735,
7915,
8989,
8956,
8962,
8976,
8979,
8969,
8972,
8986,
8992,
8965,
8983,
8959,
8988,
8955,
8961,
8975,
8978,
8968,
8971,
8985,
8991,
8964,
8982,
8958,
14053,
14056,
14055,
7968,
7969,
14085,
7918,
8921,
4183,
7834,
10676,
11296,
4180,
1874,
12776,
1787,
1788,
14914,
4181,
9903,
3440,
14059,
13958,
7875,
3441,
9018,
7469,
1741,
14382,
14681,
11848,
9518,
7880,
9932,
9936,
9934,
9933,
9935,
9907,
3426,
14185,
14126,
14122,
14123,
14127,
14128,
14184,
13939,
1118,
1117,
1123,
1122,
7863,
7844,
1116,
1119,
1121,
1124,
7869,
7852,
7883,
12736,
13720,
3361,
11903,
11890,
7884,
13950,
1420,
3215,
13921,
12350,
3479,
3362,
3389,
12165,
11262,
1900,
11904,
14614,
12328,
12692,
12693,
12694,
14672,
14671,
14673,
7887,
14664,
12321,
8927,
8928,
14639,
14361,
14363,
14364,
10686,
10690,
10691,
14367,
14365,
14366,
12690,
11648,
11654,
13862,
1785,
1786,
12735,
4714,
4530,
12353,
8997,
8917,
14552,
12743,
8759,
12216,
14166,
11652,
1759,
12768,
9544,
1770,
3358,
3357,
3356,
3355,
9909,
14057,
3476,
3359,
9908,
14061,
9911,
14062,
4899,
9542,
9541,
7453,
7457,
7454,
7456,
7451,
9540,
7452,
13978,
4884,
3470,
1739,
1189,
4907,
13223,
13227,
14588,
1805,
1808,
1809,
1807,
1813,
1811,
13919,
1800,
14607,
14149,
1812,
1804,
1817,
10589,
14398,
14882,
14597,
11846,
8813,
8814,
13724,
14608,
13726,
13727,
14582,
14584,
14585,
12753,
13977,
5761,
11867,
9074,
11842,
14601,
12754,
14667,
5760,
14696,
13985,
1873,
3329,
13230,
9950,
14576,
11324,
14579,
14606,
6484,
14686,
1871,
12751,
14604,
14594,
13229,
8938,
1815,
1816,
8937,
13728,
11868,
9075,
13986,
1879,
1878,
14873,
14599,
14600,
14581,
11840,
1888,
11133,
1771,
11263,
11836,
11837,
11829,
11831,
10659,
1405,
10667,
1413,
3424,
3415,
3425,
3416,
10658,
1404,
10666,
1412,
11091,
11060,
11094,
11063,
10660,
1406,
10668,
1414,
11092,
11061,
11095,
11064,
11294,
11295,
1423,
1424,
9881,
14857,
14040,
12666,
1899,
11071,
9543,
11079,
11088,
1918,
1852,
1853,
1854,
11125,
1855,
11069,
13058,
13067,
8488,
14135,
14176,
11136,
1755,
14195,
11314,
11315,
3391,
4064,
9537,
1740,
3385,
3386,
7963,
12348,
3406,
7967,
4716,
6492,
14627,
11882,
12346,
3214,
12345,
6477,
12349,
14138,
12740,
6110,
3388,
4877,
4881,
1716,
4882,
6500,
1585,
14174,
1773,
11276,
13077,
8821,
11883,
3396,
12697,
10684,
1822,
10681,
11932,
12699,
11874,
10696,
7983,
10680,
7982,
4883,
11856,
10677,
8595,
3734,
13975,
14147,
7482,
3471,
13849,
1578,
7393,
7394,
11661,
8372,
7493,
9910,
3397,
11913,
9096,
7923,
13429,
8832,
1872,
1577,
7958,
7961,
11776,
12362,
1576,
1744,
11656,
]

_charnames_128736 = [
11259,
1586,
12368,
4893,
14194,
4892,
14866,
14867,
14864,
1821,
10672,
6494,
6495,
-1,
-1,
-1,
1860,
12347,
12762,
11659,
1903,
4891,
8922,
1875,
14680,
1928,
-1,
-1,
-1,
-1,
-1,
-1,
6260,
6156,
6273,
6274,
6258,
6145,
6143,
6144,
6141,
6142,
6206,
6209,
6208,
6123,
6223,
6202,
6233,
6236,
6235,
6176,
6125,
6263,
6211,
6212,
6191,
6192,
6270,
6136,
6253,
6254,
6168,
6187,
6174,
6255,
6120,
6166,
6167,
6175,
6127,
6118,
6213,
6227,
6267,
6154,
6121,
6128,
6119,
6210,
6185,
6186,
6179,
6183,
6182,
6181,
6147,
6148,
6238,
6129,
6153,
6188,
6189,
6151,
6203,
6228,
6229,
6261,
6194,
6197,
6196,
6149,
6272,
6134,
6226,
6269,
6257,
6216,
6171,
6230,
6170,
6137,
6172,
6231,
6133,
6266,
6135,
6271,
6242,
6152,
6218,
6201,
6217,
6155,
6131,
6132,
6122,
6222,
6250,
6248,
6249,
6221,
6220,
6159,
6164,
6163,
6162,
6161,
6150,
6200,
6199,
6190,
6241,
6264,
6251,
6237,
6245,
6244,
]

_charnames_128896 = [
7861,
7866,
7842,
7849,
7833,
4028,
7898,
11110,
13063,
14391,
13964,
14161,
7872,
7832,
9536,
4026,
7897,
11109,
13062,
14390,
13934,
13935,
1682,
7874,
7878,
7804,
13942,
13943,
12759,
7873,
7877,
7803,
13945,
3375,
9538,
4027,
7902,
13070,
13068,
14395,
3374,
9535,
4014,
7901,
11070,
13060,
14394,
9528,
4019,
7903,
11121,
13069,
14396,
9534,
4012,
7900,
11066,
13059,
14393,
9539,
4024,
7904,
11107,
13065,
9532,
4022,
3360,
4021,
9525,
4018,
14656,
4017,
14133,
9529,
11122,
4013,
11067,
1188,
4025,
11106,
13066,
11105,
9531,
11116,
11115,
9098,
10558,
9099,
10559,
]

_charnames_129024 = [
9867,
14842,
14024,
12653,
9870,
14845,
14027,
12656,
9871,
14846,
14028,
12657,
-1,
-1,
-1,
-1,
9868,
14843,
14025,
12654,
9872,
14847,
14029,
12658,
11078,
11113,
11119,
11100,
11077,
11112,
11118,
11099,
9854,
14829,
14011,
12639,
9855,
14830,
14012,
12640,
9857,
14833,
14014,
12643,
9856,
14831,
14013,
12641,
9853,
14828,
14010,
12638,
9888,
14858,
14047,
12667,
9878,
14852,
14037,
12660,
9891,
14859,
14050,
12668,
9884,
14855,
14043,
12663,
9885,
14856,
14044,
12664,
]

_charnames_129104 = [
9879,
14853,
14038,
12661,
10663,
10671,
1417,
1409,
9906,
14871,
-1,
-1,
-1,
-1,
-1,
-1,
13906,
13894,
13900,
13912,
13882,
13888,
13875,
13869,
13908,
13896,
13902,
13914,
13884,
13890,
13877,
13871,
13905,
13893,
13899,
13911,
13881,
13887,
13874,
13868,
13907,
13895,
13901,
13913,
13883,
13889,
13876,
13870,
13904,
13892,
13898,
13910,
13880,
13886,
13873,
13867,
]

_charnames_129168 = [
9862,
14838,
14019,
12649,
9889,
14849,
14048,
12665,
9869,
14844,
14026,
12655,
11083,
11087,
11086,
11085,
9874,
14034,
9864,
14021,
9890,
14041,
9882,
14049,
9876,
14035,
9887,
14046,
13956,
13955,
]

_charnames_129280 = [
9090,
9089,
9087,
9900,
9899,
9898,
9901,
9895,
12673,
12671,
12674,
12672,
-1,
-1,
-1,
-1,
14815,
4874,
14587,
10591,
3376,
14602,
14177,
11326,
988,
8944,
14192,
9914,
14065,
11219,
11220,
14568,
14596,
9012,
10647,
14167,
12780,
9959,
14609,
1915,
14580,
13226,
13228,
14603,
1890,
1803,
14578,
1580,
11910,
7661,
11635,
1892,
11905,
4179,
4894,
1588,
11838,
14913,
14695,
4849,
13990,
13848,
11217,
-1,
13922,
12784,
9021,
3433,
1777,
13417,
14089,
14634,
1894,
3377,
7931,
4379,
8366,
9837,
1422,
14682,
9070,
6498,
8375,
7471,
11873,
8930,
7492,
13217,
1561,
1745,
14430,
13426,
11854,
13730,
11664,
12542,
14653,
3208,
8599,
7914,
8370,
8834,
7659,
11927,
11908,
8374,
1856,
8923,
9920,
4185,
4898,
7494,
1802,
-1,
-1,
14591,
14598,
12359,
14676,
-1,
-1,
-1,
14590,
-1,
9835,
13420,
11321,
14688,
9082,
9550,
1902,
3431,
14880,
14409,
12543,
7322,
1559,
12364,
14663,
7970,
12747,
13418,
9549,
14239,
1589,
1684,
13430,
14813,
11137,
1858,
3484,
9077,
13698,
9961,
11851,
11320,
11645,
14201,
9953,
4905,
4709,
7497,
1919,
]

_charnames_129456 = [
14357,
14358,
14359,
14356,
7932,
9925,
14659,
3466,
1720,
1719,
-1,
-1,
-1,
-1,
-1,
-1,
8484,
8369,
1863,
]

_charnames_129488 = [
14593,
6394,
8594,
12220,
7949,
11830,
11834,
11839,
11835,
4529,
14618,
13103,
3897,
14300,
13412,
14814,
7649,
12341,
7980,
1907,
13424,
8837,
1428,
14145,
14628,
14915,
3454,
11855,
12793,
8760,
6501,
14626,
3467,
7655,
4528,
9960,
9951,
1778,
7459,
1865,
3456,
7657,
7442,
14168,
7488,
1781,
14140,
10646,
]

_charnames_129632 = [
14892,
14890,
14893,
14891,
14887,
14888,
14889,
14901,
14899,
14902,
14900,
14896,
14897,
14898,
]

_charnames_983040 = [
10392,
10391,
1733,
1427,
1731,
1760,
14374,
14345,
14372,
14418,
14385,
14384,
6497,
6496,
6277,
7956,
7466,
7989,
8589,
11271,
11327,
3212,
9516,
10526,
14378,
9962,
10707,
14420,
9514,
13074,
13097,
14654,
14702,
8931,
9061,
1583,
9945,
1190,
1584,
9944,
1,
12775,
12794,
12731,
12791,
12728,
12790,
12729,
12789,
12732,
12788,
10587,
10650,
1844,
1843,
14373,
14346,
8916,
8915,
14377,
14419,
1722,
1721,
14415,
14414,
14545,
14637,
14700,
14543,
13233,
13431,
14542,
14139,
14238,
14544,
14879,
14883,
1762,
12741,
12739,
11666,
11665,
11318,
11301,
7662,
7990,
10679,
10705,
14531,
14434,
10588,
10592,
1730,
1922,
14375,
14416,
8592,
11274,
11328,
8591,
11273,
11329,
9515,
13075,
13098,
11641,
11642,
11785,
11643,
11640,
11777,
14132,
14134,
13995,
1179,
1185,
1924,
1180,
1184,
1923,
12730,
12787,
11900,
11897,
11937,
11899,
11896,
11936,
1889,
1761,
8918,
9111,
4065,
5098,
1734,
1732,
1789,
14379,
14376,
14429,
1729,
1425,
1181,
1929,
1182,
1906,
8817,
9108,
1751,
1724,
12326,
12313,
11901,
11941,
6486,
6488,
10704,
1590,
9794,
9708,
9109,
6275,
1841,
13697,
9818,
9819,
9820,
9821,
3340,
11211,
11213,
11214,
11212,
14692,
14691,
14690,
5099,
14809,
14807,
14810,
9956,
14235,
9958,
14237,
11940,
9955,
14234,
10706,
5100,
13993,
9957,
14236,
14701,
11939,
13983,
4711,
4712,
9851,
14008,
14918,
12797,
12908,
13042,
13031,
13020,
13009,
12998,
12987,
12976,
12897,
12886,
12875,
12864,
12853,
12842,
12831,
11909,
7988,
7929,
14808,
8220,
8222,
3951,
3941,
3914,
3904,
11034,
7987,
12820,
12809,
12798,
12953,
12942,
12931,
12920,
12909,
12964,
12975,
12974,
12973,
12972,
13052,
13051,
13050,
13049,
13048,
13047,
13046,
13045,
13044,
13043,
13041,
13040,
13039,
13038,
13037,
13036,
13035,
13034,
13033,
13032,
13030,
13029,
13028,
13027,
13026,
13025,
13024,
13023,
13022,
13021,
13019,
13018,
13017,
13016,
13015,
13014,
13013,
13012,
13011,
13010,
13008,
13007,
13006,
13005,
13004,
13003,
13002,
13001,
13000,
12999,
12997,
12996,
12995,
12994,
12993,
12992,
12991,
12990,
12989,
12988,
12986,
12985,
12984,
12983,
12982,
12981,
12980,
12979,
12978,
12977,
12907,
12906,
12905,
12904,
12903,
12902,
12901,
12900,
12899,
12898,
12896,
12895,
12894,
12893,
12892,
12891,
12890,
12889,
12888,
12887,
12885,
12884,
12883,
12882,
12881,
12880,
12879,
12878,
12877,
12876,
12874,
12873,
12872,
12871,
12870,
12869,
12868,
12867,
12866,
12865,
12863,
12862,
12861,
12860,
12859,
12858,
12857,
12856,
12855,
12854,
12852,
12851,
12850,
12849,
12848,
12847,
12846,
12845,
12844,
12843,
12841,
12840,
12839,
12838,
12837,
12836,
12835,
12834,
12833,
12832,
12830,
12829,
12828,
12827,
12826,
12825,
12824,
12823,
12822,
12821,
12819,
12818,
12817,
12816,
12815,
12814,
12813,
12812,
12811,
12810,
12808,
12807,
12806,
12805,
12804,
12803,
12802,
12801,
12800,
12799,
12963,
12962,
12961,
12960,
12959,
12958,
12957,
12956,
12955,
12954,
12952,
12951,
12950,
12949,
12948,
12947,
12946,
12945,
12944,
12943,
12941,
12940,
12939,
12938,
12937,
12936,
12935,
12934,
12933,
12932,
12930,
12929,
12928,
12927,
12926,
12925,
12924,
12923,
12922,
12921,
12919,
12918,
12917,
12916,
12915,
12914,
12913,
12912,
12911,
12910,
12971,
12970,
12969,
12968,
12967,
12966,
12965,
]

_charnames_983552 = [
13718,
13719,
13713,
13714,
13705,
13706,
13711,
13712,
13708,
13709,
13716,
13715,
9783,
9674,
9727,
9574,
9729,
9576,
9730,
9577,
9738,
9585,
9739,
9586,
9778,
9612,
9608,
9694,
9756,
9624,
9758,
9626,
9759,
9627,
9751,
9599,
9743,
9560,
9782,
9673,
9781,
9672,
9733,
9580,
9732,
9579,
9736,
9583,
9735,
9582,
9607,
9606,
9777,
9611,
9776,
9610,
9791,
9714,
9788,
9654,
9802,
9705,
9771,
9685,
9747,
9567,
9746,
9566,
9744,
9561,
9742,
9559,
9676,
9621,
9622,
9649,
9650,
9596,
9597,
9701,
9702,
6007,
6011,
6008,
6013,
6012,
6010,
6014,
6009,
6015,
7939,
3109,
3098,
3117,
3097,
3106,
3095,
3105,
3094,
3113,
3114,
3111,
3107,
3102,
3112,
3104,
3103,
3108,
3096,
3115,
3101,
3100,
3099,
3116,
3110,
2941,
2946,
2947,
2942,
2943,
2948,
2949,
2940,
2944,
2945,
2939,
2824,
2829,
2830,
2825,
2826,
2831,
2832,
2823,
2827,
2828,
2822,
3084,
3089,
3090,
3085,
3086,
3091,
3092,
3083,
3087,
3088,
3082,
2811,
2816,
2817,
2812,
2813,
2818,
2819,
2810,
2814,
2815,
2809,
2955,
2960,
2961,
2956,
2957,
2962,
2963,
2954,
2958,
2959,
2953,
2798,
2803,
2804,
2799,
2800,
2805,
2806,
2797,
2801,
2802,
2796,
2967,
2972,
2973,
2968,
2969,
2974,
2975,
2966,
2970,
2971,
2965,
2836,
2841,
2842,
2837,
2838,
2843,
2844,
2835,
2839,
2840,
2834,
3032,
3037,
3038,
3033,
3034,
3039,
3040,
3031,
3035,
3036,
3030,
3045,
3050,
3051,
3046,
3047,
3052,
3053,
3044,
3048,
3049,
3043,
3006,
3011,
3012,
3007,
3008,
3013,
3014,
3005,
3009,
3010,
3004,
2993,
2998,
2999,
2994,
2995,
3000,
3001,
2992,
2996,
2997,
2991,
2915,
2920,
2921,
2916,
2917,
2922,
2923,
2914,
2918,
2919,
2913,
3019,
3024,
3025,
3020,
3021,
3026,
3027,
3018,
3022,
3023,
3017,
2891,
2896,
2897,
2892,
2893,
2898,
2899,
2890,
2894,
2895,
2889,
2903,
2908,
2909,
2904,
2905,
2910,
2911,
2902,
2906,
2907,
2901,
2981,
2986,
2987,
2982,
2983,
2988,
2989,
2980,
2984,
2985,
2979,
2786,
2791,
2792,
2787,
2788,
2793,
2794,
2785,
2789,
2790,
2784,
3058,
3063,
3064,
3059,
3060,
3065,
3066,
3057,
3061,
3062,
3056,
2850,
2855,
2856,
2851,
2852,
2857,
2858,
2849,
2853,
2854,
2848,
2864,
2869,
2870,
2865,
2866,
2871,
2872,
2863,
2867,
2868,
2862,
2876,
2881,
2882,
2877,
2878,
2883,
2884,
2875,
2879,
2880,
2874,
3071,
3076,
3077,
3072,
3073,
3078,
3079,
3070,
3074,
3075,
3069,
2926,
2929,
2934,
2935,
2930,
2931,
2936,
2937,
2928,
2932,
2933,
2927,
2859,
1175,
1174,
1173,
13402,
13631,
13629,
13630,
13628,
13624,
13637,
13635,
13636,
13634,
13622,
13652,
13615,
13651,
13614,
13625,
13620,
13618,
13619,
13617,
13623,
13658,
13645,
13646,
13644,
13656,
13653,
13655,
13648,
13654,
13640,
13639,
13641,
13657,
13649,
13667,
13663,
13660,
13661,
13664,
13666,
13668,
11310,
11308,
11306,
11309,
11307,
13681,
13679,
13677,
13680,
13678,
13688,
13685,
13686,
13687,
4847,
4846,
]

def lookup_charcode(code):
    res = -1
    if code == 895: res = 13215
    elif 1318 <= code <= 1327: res = _charnames_1318[code-1318]
    elif code == 1376: res = 6106
    elif 1416 <= code <= 1423: res = _charnames_1416[code-1416]
    elif code == 1519: res = 11138
    elif code == 1540: res = 6016
    elif code == 1541: res = 6101
    elif code == 1564: res = 6047
    elif code == 1568: res = 6052
    elif code == 1631: res = 6100
    elif code == 2045: res = 10701
    elif code == 2046: res = 10700
    elif code == 2047: res = 10702
    elif 2112 <= code <= 2154: res = _charnames_2112[code-2112]
    elif 2208 <= code <= 2237: res = _charnames_2208[code-2208]
    elif 2259 <= code <= 2303: res = _charnames_2259[code-2259]
    elif code == 2362: res = 12720
    elif code == 2363: res = 12719
    elif 2383 <= code <= 2391: res = _charnames_2383[code-2383]
    elif code == 2419: res = 12709
    elif code == 2420: res = 12708
    elif code == 2421: res = 12712
    elif code == 2422: res = 12706
    elif code == 2423: res = 12705
    elif code == 2424: res = 12713
    elif code == 2432: res = 7941
    elif code == 2556: res = 7938
    elif code == 2557: res = 7942
    elif code == 2558: res = 7943
    elif code == 2678: res = 13334
    elif code == 2800: res = 13333
    elif 2809 <= code <= 2815: res = _charnames_2809[code-2809]
    elif code == 2930: res = 12334
    elif code == 2931: res = 12335
    elif code == 2932: res = 12339
    elif code == 2933: res = 12333
    elif code == 2934: res = 12336
    elif code == 2935: res = 12338
    elif code == 3072: res = 3446
    elif code == 3076: res = 3447
    elif code == 3124: res = 3450
    elif code == 3162: res = 3449
    elif code == 3200: res = 13694
    elif code == 3201: res = 13696
    elif code == 3204: res = 13695
    elif code == 3328: res = 4491
    elif code == 3329: res = 4493
    elif code == 3369: res = 4486
    elif code == 3386: res = 4485
    elif code == 3387: res = 4494
    elif code == 3388: res = 4492
    elif 3406 <= code <= 3423: res = _charnames_3406[code-3406]
    elif code == 3446: res = 4473
    elif code == 3447: res = 4475
    elif code == 3448: res = 4478
    elif 3558 <= code <= 3567: res = _charnames_3558[code-3558]
    elif code == 3806: res = 9816
    elif code == 3807: res = 9815
    elif code == 3980: res = 3336
    elif code == 3981: res = 3334
    elif code == 3982: res = 3333
    elif code == 3983: res = 3335
    elif code == 4057: res = 3339
    elif code == 4058: res = 3338
    elif 4295 <= code <= 4301: res = _charnames_4295[code-4295]
    elif code == 4349: res = 13405
    elif code == 4350: res = 13404
    elif code == 4351: res = 13403
    elif code == 4957: res = 14344
    elif code == 4958: res = 14343
    elif 5109 <= code <= 5117: res = _charnames_5109[code-5109]
    elif 5873 <= code <= 5880: res = _charnames_5873[code-5873]
    elif code == 6264: res = 4868
    elif code == 6429: res = 9548
    elif code == 6430: res = 9547
    elif 6832 <= code <= 6846: res = _charnames_6832[code-6832]
    elif code == 7083: res = 1708
    elif code == 7084: res = 1707
    elif code == 7085: res = 1706
    elif 7098 <= code <= 7155: res = _charnames_7098[code-7098]
    elif code == 7164: res = 7384
    elif code == 7165: res = 7382
    elif code == 7166: res = 7385
    elif code == 7167: res = 7383
    elif 7296 <= code <= 7304: res = _charnames_7296[code-7296]
    elif 7312 <= code <= 7367: res = _charnames_7312[code-7312]
    elif 7411 <= code <= 7417: res = _charnames_7411[code-7411]
    elif 7655 <= code <= 7676: res = _charnames_7655[code-7655]
    elif code == 8294: res = 9916
    elif code == 8295: res = 14067
    elif code == 8296: res = 14633
    elif code == 8297: res = 11887
    elif 8341 <= code <= 8348: res = _charnames_8341[code-8341]
    elif 8377 <= code <= 8383: res = _charnames_8377[code-8377]
    elif code == 8586: res = 3420
    elif code == 8587: res = 3421
    elif 9193 <= code <= 9215: res = _charnames_9193[code-9193]
    elif code == 9934: res = 12329
    elif code == 9954: res = 6482
    elif code == 9956: res = 11845
    elif code == 9957: res = 14069
    elif code == 9958: res = 9918
    elif code == 9959: res = 14550
    elif 9984 <= code <= 9995: res = _charnames_9984[code-9984]
    elif code == 10024: res = 1792
    elif 10060 <= code <= 10069: res = _charnames_10060[code-10060]
    elif code == 10079: res = 11074
    elif code == 10080: res = 11075
    elif code == 10133: res = 11123
    elif code == 10134: res = 11124
    elif code == 10135: res = 11102
    elif code == 10160: res = 8365
    elif code == 10175: res = 12687
    elif code == 10187: res = 4525
    elif code == 10189: res = 4526
    elif code == 10190: res = 1623
    elif code == 10191: res = 1622
    elif code == 11085: res = 12646
    elif code == 11086: res = 1573
    elif code == 11087: res = 1572
    elif 11098 <= code <= 11262: res = _charnames_11098[code-11098]
    elif code == 11506: res = 8809
    elif code == 11507: res = 8808
    elif 11559 <= code <= 11565: res = _charnames_11559[code-11559]
    elif code == 11622: res = 3344
    elif code == 11623: res = 3343
    elif code == 11632: res = 3345
    elif code == 11647: res = 3346
    elif 11826 <= code <= 11854: res = _charnames_11826[code-11826]
    elif code == 12590: res = 7907
    elif code == 12591: res = 7908
    elif code == 12728: res = 7910
    elif code == 12729: res = 7909
    elif code == 12730: res = 7906
    elif code == 42592: res = 9058
    elif code == 42593: res = 9039
    elif 42612 <= code <= 42619: res = _charnames_42612[code-42612]
    elif 42648 <= code <= 42655: res = _charnames_42648[code-42648]
    elif 42893 <= code <= 42937: res = _charnames_42893[code-42893]
    elif code == 42999: res = 9812
    elif code == 43000: res = 4844
    elif code == 43001: res = 4837
    elif code == 43002: res = 9808
    elif code == 43205: res = 1859
    elif code == 43260: res = 12724
    elif code == 43261: res = 12725
    elif code == 43262: res = 12711
    elif code == 43263: res = 12722
    elif 43488 <= code <= 43518: res = _charnames_43488[code-43488]
    elif code == 43644: res = 5095
    elif code == 43645: res = 5094
    elif code == 43646: res = 5077
    elif code == 43647: res = 5076
    elif 43744 <= code <= 43766: res = _charnames_43744[code-43744]
    elif 43777 <= code <= 43798: res = _charnames_43777[code-43777]
    elif 43808 <= code <= 43877: res = _charnames_43808[code-43808]
    elif 43888 <= code <= 43967: res = _charnames_43888[code-43888]
    elif code == 64046: res = 9107
    elif code == 64047: res = 9106
    elif 64434 <= code <= 64449: res = _charnames_64434[code-64434]
    elif 65063 <= code <= 65071: res = _charnames_65063[code-65063]
    elif code == 65931: res = 13212
    elif code == 65932: res = 13211
    elif code == 65933: res = 13214
    elif code == 65934: res = 10697
    elif code == 65952: res = 13210
    elif 66272 <= code <= 66299: res = _charnames_66272[code-66272]
    elif code == 66335: res = 12215
    elif code == 66349: res = 12212
    elif code == 66350: res = 12214
    elif code == 66351: res = 12213
    elif 66384 <= code <= 66426: res = _charnames_66384[code-66384]
    elif 66736 <= code <= 66855: res = _charnames_66736[code-66736]
    elif 66864 <= code <= 66915: res = _charnames_66864[code-66864]
    elif code == 66927: res = 8914
    elif 67072 <= code <= 67382: res = _charnames_67072[code-67072]
    elif 67392 <= code <= 67413: res = _charnames_67392[code-67392]
    elif 67424 <= code <= 67431: res = _charnames_67424[code-67424]
    elif 67680 <= code <= 67742: res = _charnames_67680[code-67680]
    elif 67751 <= code <= 67759: res = _charnames_67751[code-67751]
    elif 67808 <= code <= 67839: res = _charnames_67808[code-67808]
    elif 67968 <= code <= 68095: res = _charnames_67968[code-67968]
    elif code == 68148: res = 13672
    elif code == 68149: res = 13671
    elif code == 68168: res = 13673
    elif 68224 <= code <= 68255: res = _charnames_68224[code-68224]
    elif 68288 <= code <= 68342: res = _charnames_68288[code-68288]
    elif 68480 <= code <= 68497: res = _charnames_68480[code-68480]
    elif code == 68505: res = 11822
    elif code == 68506: res = 11821
    elif code == 68507: res = 11820
    elif code == 68508: res = 11819
    elif 68521 <= code <= 68527: res = _charnames_68521[code-68521]
    elif 68736 <= code <= 68786: res = _charnames_68736[code-68736]
    elif 68800 <= code <= 68850: res = _charnames_68800[code-68800]
    elif 68858 <= code <= 68903: res = _charnames_68858[code-68858]
    elif 68912 <= code <= 68921: res = _charnames_68912[code-68912]
    elif 69376 <= code <= 69415: res = _charnames_69376[code-69376]
    elif 69424 <= code <= 69465: res = _charnames_69424[code-69424]
    elif 69632 <= code <= 69743: res = _charnames_69632[code-69632]
    elif code == 69759: res = 7598
    elif 69837 <= code <= 69864: res = _charnames_69837[code-69837]
    elif 69872 <= code <= 69958: res = _charnames_69872[code-69872]
    elif 69968 <= code <= 70006: res = _charnames_69968[code-69968]
    elif 70016 <= code <= 70132: res = _charnames_70016[code-70016]
    elif 70144 <= code <= 70206: res = _charnames_70144[code-70144]
    elif 70272 <= code <= 70516: res = _charnames_70272[code-70272]
    elif 70656 <= code <= 70750: res = _charnames_70656[code-70656]
    elif 70784 <= code <= 70855: res = _charnames_70784[code-70784]
    elif 70864 <= code <= 70873: res = _charnames_70864[code-70864]
    elif 71040 <= code <= 71133: res = _charnames_71040[code-71040]
    elif 71168 <= code <= 71236: res = _charnames_71168[code-71168]
    elif 71248 <= code <= 71276: res = _charnames_71248[code-71248]
    elif 71296 <= code <= 71351: res = _charnames_71296[code-71296]
    elif 71360 <= code <= 71369: res = _charnames_71360[code-71360]
    elif 71424 <= code <= 71487: res = _charnames_71424[code-71424]
    elif 71680 <= code <= 71739: res = _charnames_71680[code-71680]
    elif 71840 <= code <= 71922: res = _charnames_71840[code-71840]
    elif code == 71935: res = 13844
    elif 72192 <= code <= 72263: res = _charnames_72192[code-72192]
    elif 72272 <= code <= 72354: res = _charnames_72272[code-72272]
    elif 72384 <= code <= 72440: res = _charnames_72384[code-72384]
    elif 72704 <= code <= 72773: res = _charnames_72704[code-72704]
    elif 72784 <= code <= 72886: res = _charnames_72784[code-72784]
    elif 72960 <= code <= 73031: res = _charnames_72960[code-72960]
    elif 73040 <= code <= 73112: res = _charnames_73040[code-73040]
    elif 73120 <= code <= 73129: res = _charnames_73120[code-73120]
    elif 73440 <= code <= 73464: res = _charnames_73440[code-73440]
    elif 74607 <= code <= 74649: res = _charnames_74607[code-74607]
    elif 74851 <= code <= 74868: res = _charnames_74851[code-74851]
    elif 74880 <= code <= 75075: res = _charnames_74880[code-74880]
    elif 82944 <= code <= 83526: res = _charnames_82944[code-82944]
    elif 92160 <= code <= 92728: res = _charnames_92160[code-92160]
    elif 92736 <= code <= 92783: res = _charnames_92736[code-92736]
    elif 92880 <= code <= 92917: res = _charnames_92880[code-92880]
    elif 92928 <= code <= 92997: res = _charnames_92928[code-92928]
    elif 93008 <= code <= 93071: res = _charnames_93008[code-93008]
    elif 93760 <= code <= 93850: res = _charnames_93760[code-93760]
    elif 93952 <= code <= 94020: res = _charnames_93952[code-93952]
    elif 94032 <= code <= 94078: res = _charnames_94032[code-94032]
    elif 94095 <= code <= 94111: res = _charnames_94095[code-94095]
    elif code == 94176: res = 2775
    elif code == 94177: res = 10390
    elif 100352 <= code <= 101106: res = _charnames_100352[code-100352]
    elif 110592 <= code <= 110878: res = _charnames_110592[code-110592]
    elif 110960 <= code <= 111355: res = _charnames_110960[code-110960]
    elif 113664 <= code <= 113800: res = _charnames_113664[code-113664]
    elif 113808 <= code <= 113827: res = _charnames_113808[code-113808]
    elif 119262 <= code <= 119272: res = _charnames_119262[code-119262]
    elif 119520 <= code <= 119539: res = _charnames_119520[code-119520]
    elif 119666 <= code <= 119672: res = _charnames_119666[code-119666]
    elif 120832 <= code <= 121483: res = _charnames_120832[code-120832]
    elif 121499 <= code <= 121519: res = _charnames_121499[code-121499]
    elif 122880 <= code <= 122922: res = _charnames_122880[code-122880]
    elif 124928 <= code <= 125142: res = _charnames_124928[code-124928]
    elif 125184 <= code <= 125279: res = _charnames_125184[code-125184]
    elif 126065 <= code <= 126132: res = _charnames_126065[code-126065]
    elif 126464 <= code <= 126651: res = _charnames_126464[code-126464]
    elif code == 126704: res = 5934
    elif code == 126705: res = 5935
    elif 127136 <= code <= 127221: res = _charnames_127136[code-127136]
    elif code == 127243: res = 12757
    elif code == 127244: res = 12756
    elif 127279 <= code <= 127404: res = _charnames_127279[code-127279]
    elif 127462 <= code <= 127490: res = _charnames_127462[code-127462]
    elif 127538 <= code <= 127547: res = _charnames_127538[code-127538]
    elif code == 127568: res = 9094
    elif code == 127569: res = 9095
    elif code == 127584: res = 14158
    elif code == 127585: res = 14157
    elif code == 127586: res = 14155
    elif code == 127587: res = 14156
    elif code == 127588: res = 14154
    elif code == 127589: res = 14159
    elif 127744 <= code <= 128724: res = _charnames_127744[code-127744]
    elif 128736 <= code <= 128883: res = _charnames_128736[code-128736]
    elif 128896 <= code <= 128984: res = _charnames_128896[code-128896]
    elif 129024 <= code <= 129095: res = _charnames_129024[code-129024]
    elif 129104 <= code <= 129159: res = _charnames_129104[code-129104]
    elif 129168 <= code <= 129197: res = _charnames_129168[code-129168]
    elif 129280 <= code <= 129442: res = _charnames_129280[code-129280]
    elif 129456 <= code <= 129474: res = _charnames_129456[code-129456]
    elif 129488 <= code <= 129535: res = _charnames_129488[code-129488]
    elif 129632 <= code <= 129645: res = _charnames_129632[code-129632]
    elif 983040 <= code <= 983507: res = _charnames_983040[code-983040]
    elif 983552 <= code <= 983993: res = _charnames_983552[code-983552]
    if res == -1: raise KeyError, code
    return name_of_node(res)

# end output from build_compression_tree
#____________________________________________________________
_names_corrected = {
}
_code_by_name_corrected = {
}

_cjk_prefix = "CJK UNIFIED IDEOGRAPH-"
_hangul_prefix = 'HANGUL SYLLABLE '

_hangul_L = ['G', 'GG', 'N', 'D', 'DD', 'R', 'M', 'B', 'BB',
            'S', 'SS', '', 'J', 'JJ', 'C', 'K', 'T', 'P', 'H']
_hangul_V = ['A', 'AE', 'YA', 'YAE', 'EO', 'E', 'YEO', 'YE', 'O', 'WA', 'WAE',
            'OE', 'YO', 'U', 'WEO', 'WE', 'WI', 'YU', 'EU', 'YI', 'I']
_hangul_T = ['', 'G', 'GG', 'GS', 'N', 'NJ', 'NH', 'D', 'L', 'LG', 'LM',
            'LB', 'LS', 'LT', 'LP', 'LH', 'M', 'B', 'BS', 'S', 'SS',
            'NG', 'J', 'C', 'K', 'T', 'P', 'H']

def _lookup_hangul(syllables):
    l_code = v_code = t_code = -1
    for i in range(len(_hangul_L)):
        jamo = _hangul_L[i]
        if (syllables[:len(jamo)] == jamo and
            (l_code < 0 or len(jamo) > len(_hangul_L[l_code]))):
            l_code = i
    if l_code < 0:
        raise KeyError
    start = len(_hangul_L[l_code])

    for i in range(len(_hangul_V)):
        jamo = _hangul_V[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (v_code < 0 or len(jamo) > len(_hangul_V[v_code]))):
            v_code = i
    if v_code < 0:
        raise KeyError
    start += len(_hangul_V[v_code])

    for i in range(len(_hangul_T)):
        jamo = _hangul_T[i]
        if (syllables[start:start + len(jamo)] == jamo and
            (t_code < 0 or len(jamo) > len(_hangul_T[t_code]))):
            t_code = i
    if t_code < 0:
        raise KeyError
    start += len(_hangul_T[t_code])

    if len(syllables[start:]):
        raise KeyError
    return 0xAC00 + (l_code * 21 + v_code) * 28 + t_code

def _lookup_cjk(cjk_code):
    if len(cjk_code) != 4 and len(cjk_code) != 5:
        raise KeyError
    for c in cjk_code:
        if not ('0' <= c <= '9' or 'A' <= c <= 'F'):
            raise KeyError
    code = int(cjk_code, 16)
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FEF or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return code
    raise KeyError

def lookup(name, with_named_sequence=False):
    if name[:len(_cjk_prefix)] == _cjk_prefix:
        return _lookup_cjk(name[len(_cjk_prefix):])
    if name[:len(_hangul_prefix)] == _hangul_prefix:
        return _lookup_hangul(name[len(_hangul_prefix):])

    if not base_mod:
        code = trie_lookup(name)
    else:
        try:
            code = trie_lookup(name)
        except KeyError:
            if name not in _code_by_name_corrected:
                code = base_mod.trie_lookup(name)
            else:
                raise
    if not with_named_sequence and 0xF0200 <= code < 0xF0400:
        raise KeyError
    return code

def name(code):
    if (0x3400 <= code <= 0x4DB5 or 0x4E00 <= code <= 0x9FEF or 0x20000 <= code <= 0x2A6D6 or 0x2A700 <= code <= 0x2B734 or 0x2B740 <= code <= 0x2B81D or 0x2B820 <= code <= 0x2CEA1):
        return "CJK UNIFIED IDEOGRAPH-" + hex(code)[2:].upper()
    if 0xAC00 <= code <= 0xD7A3:
        # vl_code, t_code = divmod(code - 0xAC00, len(_hangul_T))
        vl_code = (code - 0xAC00) // len(_hangul_T)
        t_code = (code - 0xAC00) % len(_hangul_T)
        # l_code, v_code = divmod(vl_code,  len(_hangul_V))
        l_code = vl_code // len(_hangul_V)
        v_code = vl_code % len(_hangul_V)
        return ("HANGUL SYLLABLE " + _hangul_L[l_code] +
                _hangul_V[v_code] + _hangul_T[t_code])
    if 0xF0000 <= code < 0xF0400:
        raise KeyError

    if not base_mod:
        return lookup_charcode(code)
    else:
        try:
            return lookup_charcode(code)
        except KeyError:
            if code not in _names_corrected:
                return base_mod.lookup_charcode(code)
            else:
                raise

_db_records = [
('Cc', 'B', 'N', 5),
('Cc', 'BN', 'N', 0),
('Cc', 'S', 'N', 1),
('Cc', 'S', 'N', 5),
('Cc', 'WS', 'N', 5),
('Cf', 'AL', 'N', 8192),
('Cf', 'AN', 'N', 8192),
('Cf', 'BN', 'A', 8192),
('Cf', 'BN', 'N', 8192),
('Cf', 'FSI', 'N', 8192),
('Cf', 'L', 'N', 8192),
('Cf', 'LRE', 'N', 8192),
('Cf', 'LRI', 'N', 8192),
('Cf', 'LRO', 'N', 8192),
('Cf', 'ON', 'N', 8192),
('Cf', 'PDF', 'N', 8192),
('Cf', 'PDI', 'N', 8192),
('Cf', 'R', 'N', 8192),
('Cf', 'RLE', 'N', 8192),
('Cf', 'RLI', 'N', 8192),
('Cf', 'RLO', 'N', 8192),
('Cn', '', 'N', 0),
('Cn', '', 'W', 0),
('Co', 'L', 'A', 0),
('Cs', 'L', 'N', 0),
('Ll', 'L', 'A', 7202),
('Ll', 'L', 'F', 7202),
('Ll', 'L', 'N', 7202),
('Ll', 'L', 'Na', 7202),
('Ll', 'R', 'N', 7202),
('Lm', 'AL', 'N', 15362),
('Lm', 'L', 'A', 15362),
('Lm', 'L', 'A', 15394),
('Lm', 'L', 'H', 14338),
('Lm', 'L', 'H', 15362),
('Lm', 'L', 'N', 12322),
('Lm', 'L', 'N', 15362),
('Lm', 'L', 'N', 15394),
('Lm', 'L', 'W', 15362),
('Lm', 'ON', 'A', 15362),
('Lm', 'ON', 'N', 12290),
('Lm', 'ON', 'N', 15362),
('Lm', 'R', 'N', 15362),
('Lo', 'AL', 'N', 4098),
('Lo', 'AL', 'N', 7170),
('Lo', 'L', 'A', 7202),
('Lo', 'L', 'H', 7170),
('Lo', 'L', 'N', 6146),
('Lo', 'L', 'N', 7170),
('Lo', 'L', 'W', 7170),
('Lo', 'L', 'W', 7234),
('Lo', 'R', 'N', 7170),
('Lt', 'L', 'N', 7186),
('Lu', 'L', 'A', 7178),
('Lu', 'L', 'F', 7178),
('Lu', 'L', 'N', 7178),
('Lu', 'L', 'Na', 7178),
('Lu', 'R', 'N', 7178),
('Mc', 'L', 'N', 6144),
('Mc', 'L', 'W', 6144),
('Me', 'NSM', 'N', 12288),
('Mn', 'L', 'N', 14336),
('Mn', 'NSM', 'A', 14336),
('Mn', 'NSM', 'A', 14368),
('Mn', 'NSM', 'N', 14336),
('Mn', 'NSM', 'N', 15360),
('Mn', 'NSM', 'W', 14336),
('Nd', 'AN', 'N', 6592),
('Nd', 'EN', 'F', 6592),
('Nd', 'EN', 'N', 6592),
('Nd', 'EN', 'Na', 6592),
('Nd', 'L', 'N', 6592),
('Nd', 'R', 'N', 6592),
('Nl', 'L', 'A', 7240),
('Nl', 'L', 'A', 7264),
('Nl', 'L', 'N', 7232),
('Nl', 'L', 'N', 7240),
('Nl', 'L', 'N', 7264),
('Nl', 'L', 'W', 7232),
('Nl', 'ON', 'N', 7232),
('No', 'AL', 'N', 4160),
('No', 'AN', 'N', 4160),
('No', 'AN', 'N', 4288),
('No', 'EN', 'A', 4160),
('No', 'EN', 'A', 4288),
('No', 'EN', 'N', 4160),
('No', 'EN', 'N', 4288),
('No', 'L', 'A', 4160),
('No', 'L', 'N', 4160),
('No', 'L', 'N', 6336),
('No', 'L', 'W', 4160),
('No', 'ON', 'A', 4160),
('No', 'ON', 'A', 4288),
('No', 'ON', 'N', 4160),
('No', 'ON', 'N', 4288),
('No', 'ON', 'W', 4160),
('No', 'R', 'N', 4160),
('No', 'R', 'N', 4288),
('Pc', 'ON', 'F', 6144),
('Pc', 'ON', 'N', 6144),
('Pc', 'ON', 'Na', 6144),
('Pc', 'ON', 'W', 6144),
('Pd', 'ES', 'F', 4096),
('Pd', 'ES', 'Na', 4096),
('Pd', 'ES', 'W', 4096),
('Pd', 'ON', 'A', 4096),
('Pd', 'ON', 'N', 4096),
('Pd', 'ON', 'W', 4096),
('Pd', 'R', 'N', 4096),
('Pe', 'ON', 'F', 4608),
('Pe', 'ON', 'H', 4608),
('Pe', 'ON', 'N', 4096),
('Pe', 'ON', 'N', 4608),
('Pe', 'ON', 'Na', 4608),
('Pe', 'ON', 'W', 4096),
('Pe', 'ON', 'W', 4608),
('Pf', 'ON', 'A', 4096),
('Pf', 'ON', 'A', 12288),
('Pf', 'ON', 'N', 4608),
('Pi', 'ON', 'A', 4096),
('Pi', 'ON', 'A', 12288),
('Pi', 'ON', 'N', 4096),
('Pi', 'ON', 'N', 4608),
('Po', 'AL', 'N', 4096),
('Po', 'AN', 'N', 4096),
('Po', 'CS', 'F', 4096),
('Po', 'CS', 'F', 12288),
('Po', 'CS', 'N', 4096),
('Po', 'CS', 'Na', 4096),
('Po', 'CS', 'Na', 12288),
('Po', 'CS', 'W', 4096),
('Po', 'CS', 'W', 12288),
('Po', 'ET', 'A', 4096),
('Po', 'ET', 'F', 4096),
('Po', 'ET', 'N', 4096),
('Po', 'ET', 'Na', 4096),
('Po', 'ET', 'W', 4096),
('Po', 'L', 'N', 4096),
('Po', 'ON', 'A', 4096),
('Po', 'ON', 'A', 12288),
('Po', 'ON', 'A', 14336),
('Po', 'ON', 'F', 4096),
('Po', 'ON', 'F', 12288),
('Po', 'ON', 'H', 4096),
('Po', 'ON', 'N', 4096),
('Po', 'ON', 'N', 14336),
('Po', 'ON', 'Na', 4096),
('Po', 'ON', 'Na', 12288),
('Po', 'ON', 'W', 4096),
('Po', 'ON', 'W', 12288),
('Po', 'R', 'N', 4096),
('Po', 'R', 'N', 12288),
('Ps', 'ON', 'F', 4608),
('Ps', 'ON', 'H', 4608),
('Ps', 'ON', 'N', 4096),
('Ps', 'ON', 'N', 4608),
('Ps', 'ON', 'Na', 4608),
('Ps', 'ON', 'W', 4096),
('Ps', 'ON', 'W', 4608),
('Sc', 'AL', 'N', 4096),
('Sc', 'ET', 'A', 4096),
('Sc', 'ET', 'F', 4096),
('Sc', 'ET', 'H', 4096),
('Sc', 'ET', 'N', 4096),
('Sc', 'ET', 'Na', 4096),
('Sc', 'ET', 'W', 4096),
('Sc', 'R', 'N', 4096),
('Sk', 'AL', 'N', 12288),
('Sk', 'L', 'N', 12288),
('Sk', 'ON', 'A', 12288),
('Sk', 'ON', 'F', 12288),
('Sk', 'ON', 'N', 12288),
('Sk', 'ON', 'Na', 12288),
('Sk', 'ON', 'W', 12288),
('Sm', 'AL', 'N', 4096),
('Sm', 'CS', 'N', 4096),
('Sm', 'ES', 'F', 4096),
('Sm', 'ES', 'N', 4096),
('Sm', 'ES', 'Na', 4096),
('Sm', 'ES', 'W', 4096),
('Sm', 'ET', 'A', 4096),
('Sm', 'ET', 'N', 4096),
('Sm', 'L', 'N', 4096),
('Sm', 'ON', 'A', 4096),
('Sm', 'ON', 'A', 4608),
('Sm', 'ON', 'F', 4096),
('Sm', 'ON', 'F', 4608),
('Sm', 'ON', 'H', 4096),
('Sm', 'ON', 'N', 4096),
('Sm', 'ON', 'N', 4608),
('Sm', 'ON', 'N', 7168),
('Sm', 'ON', 'Na', 4096),
('Sm', 'ON', 'Na', 4608),
('Sm', 'ON', 'W', 4096),
('Sm', 'ON', 'W', 4608),
('So', 'AL', 'N', 4096),
('So', 'ET', 'A', 4096),
('So', 'ET', 'N', 4096),
('So', 'ET', 'N', 7168),
('So', 'L', 'A', 4096),
('So', 'L', 'A', 4104),
('So', 'L', 'A', 4128),
('So', 'L', 'N', 4096),
('So', 'L', 'W', 4096),
('So', 'ON', 'A', 4096),
('So', 'ON', 'F', 4096),
('So', 'ON', 'H', 4096),
('So', 'ON', 'N', 4096),
('So', 'ON', 'N', 4608),
('So', 'ON', 'Na', 4096),
('So', 'ON', 'W', 4096),
('So', 'R', 'N', 4096),
('Zl', 'WS', 'N', 5),
('Zp', 'B', 'N', 5),
('Zs', 'CS', 'N', 1),
('Zs', 'WS', 'F', 1),
('Zs', 'WS', 'N', 1),
('Zs', 'WS', 'Na', 4097),
]
_db_pgtbl = (
'\x00\x01\x02\x03\x04\x05\x06\x07\x08\t\n\x0b\x0c\r\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f !"#$%&\'()*+,-./0123455565575555'
'555555555555589:5;5<55=5>55555?@55AB555C5555555D555E55F555555555'
'G555H5555555IJ55555555K55555555LM555N\x15OPQRST55555555555555555555'
'55555555555555555555555UVVVVVVVVWWWWWWWWWWWWWWWWWWWWWWWWWXYZ[\\]^'
'_`abcd\x15efghijklmnopqrstuvwxwyz{w\x15\x15\x15|}~wwwwwwwwww\x15\x15\x15\x15\x7fwwwwwwwwwww'
'wwww\x15\x15\x80wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww\x15\x15\x81\x82ww\x83\x845555555555555555'
'5555555\x8555\x86wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww5\x87\x88wwwwwwwww\x89www'
'wwwwwwwwwwwwwwww\x8a\x8b\x8c\x8d\x8e\x8f\x90\x91((\x92wwwww\x93wwwwwww\x94\x95ww\x96w\x97w\x98\x99\x9a\x9b\x9c\x9d\x9e\x9f\xa0\xa1\xa2wwwww'
'\xa3\xa45555555\xa5\xa6\xa755555555555555555555555\xa855555\xa955555555555555555\xaa5555'
'5555555555555555555555555555555555\xab55555555555555555555555555555'
'55555555555555555555555555555555555555\xac5555555555555555\xad\xae5555555'
'55555555555555\xaf5555555555555555555555555555\xb0\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xa85\xb2\xb1\xb1\xb1\xb1\xb3'
'\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1'
'\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1'
'\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1'
'\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb1\xb3'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'\xb4\xb5wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xb6'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW'
'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\xb6'
)
_db_pages = ( 
'\x01\x01\x01\x01\x01\x01\x01\x01\x01\x02\x00\x03\x04\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x00\x00\x00\x02\xd9\x92\x92\x87\xa4\x87\x92\x93\x9cq\x92\xb2\x80g\x81\x80FFFFFFFFFF\x81\x92\xc0\xbf\xc0\x92'
'\x9288888888888888888888888888\x9c\x92q\xacd\xac\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x1c\x9c\xbfq\xbf\x01'
'\x01\x01\x01\x01\x01\x00\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\x01\xd6\x8a\xa4\xa4\xa0\xa4\xd1\x8a\xa9\xcf-z\xbf\x07\xcc\xac\xc4\xb4TT\xa9\x1b\x8a\x8c\xa9T-v[[[\x8a'
'77777757777777775777777\xb75777775\x19\x19\x19\x1b\x1b\x1b\x1b\x19\x1b\x19\x19\x19\x1b\x19\x19\x1b\x1b\x19\x1b\x19\x19\x1b\x1b\x1b\xb7\x19\x19\x19\x1b\x19\x1b\x19\x1b'
'7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x197\x197\x1b7\x1b7\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x195\x197\x1b7\x1b\x197\x1b7\x1b7\x1b5'
'\x195\x197\x197\x1b7\x19\x195\x197\x197\x1b7\x1b5\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b5\x197\x1b7\x197\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77\x1b7\x1b7\x1b\x1b'
'\x1b77\x1b7\x1b77\x1b777\x1b\x1b7777\x1b77\x1b777\x1b\x1b\x1b77\x1b77\x1b7\x1b7\x1b77\x1b7\x1b\x1b7\x1b77\x1b777\x1b7\x1b77\x1b\x1b07\x1b\x1b\x1b'
'000074\x1b74\x1b74\x1b7\x197\x197\x197\x197\x197\x197\x197\x19\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b74\x1b7\x1b777\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x1b77\x1b'
'\x1b7\x1b7777\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b0\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%))$$$$$'
"%%\xab\xab\xa9\xab)')''')'))\x1f$\xab\xab\xab\xab\xab\xab\xa9\xa9\xa9\xa9\xab\xa9\xab\xa9%%%%%\xab\xab\xab\xab\xab\xab\xab)\xab$\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab"
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>?>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>7\x1b7\x1b)\xab7\x1b\x15\x15#\x1b\x1b\x1b\x907'
'\x15\x15\x15\x15\xab\xab7\x91777\x157\x1577\x1b55555555555555555\x15555555577\x1b\x1b\x1b\x1b\x1b\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x1b\x19\x19\x19\x19\x19\x19\x19\x1b\x1b\x1b\x1b\x1b7\x1b\x1b777\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b7\x1b\xbc7\x1b77\x1b\x1b777'
'757777777777777755555555555555555555555555555555\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19'
'\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x19\x1b\x19\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b\xca@@@@@<<7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'77\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x15777777777777777'
'77777777777777777777777\x15\x15$\x89\x89\x89\x89\x89\x89\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x89j\x15\x15\xcf\xcf\xa3\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@l@'
'\x96@@\x96@@\x96@\x15\x15\x15\x15\x15\x15\x15\x15333333333333333333333333333\x15\x15\x15\x153333\x96\x97\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x06\x06\x06\x06\x06\x06\xbc\xbc\xae\x86\x86\x9f\x7f{\xcf\xcf@@@@@@@@@@@{\x05\x15{{,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
'\x1e,,,,,,,,,,@@@@@@@@@@@@@@@@@@@@@CCCCCCCCCC\x86||{,,@,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,{,@@@@@@@\x06\xcf@@@@@@\x1e\x1e@@\xcf@@@@,,EEEEEEEEEE,,,\xc3\xc3,'
'{{{{{{{{{{{{{{\x15\x05,@,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@@@@@@'
'@@@@@@@@@@@\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@@@@@@@@,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'HHHHHHHHHH333333333333333333333333333333333@@@@@@@@@**\xcf\x90\x90\x90*\x15\x15@\xa6\xa6'
'3333333333333333333333@@@@*@@@@@@@@@*@@@*@@@@@\x15\x15\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x96\x15'
'3333333333333333333333333@@@\x15\x15\x96\x15,,,,,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,\x15,,,,,,,,\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@\x06@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'@@@:000000000000000000000000000000000000000000000000000000@:@0::'
':@@@@@@@@::::@::0@@@@@@@0000000000@@\x89\x89GGGGGGGGGG\x89$00000000000000'
'0@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x150\x15\x15\x150000\x15\x15@0::'
':@@@@\x15\x15::\x15\x15::@0\x15\x15\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x1500\x15000@@\x15\x15GGGGGGGGGG00\xa3\xa3XXXXXX\xca\xa30\x89@\x15'
'\x15@@:\x15000000\x15\x15\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500\x1500\x15\x15@\x15::'
':@@\x15\x15\x15\x15@@\x15\x15@@@\x15\x15\x15@\x15\x15\x15\x15\x15\x15\x150000\x150\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG@@000@\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15@@:\x15000000000\x15000\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0::'
':@@@@@\x15@@:\x15::@\x15\x150\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500@@\x15\x15GGGGGGGGGG\x89\xa3\x15\x15\x15\x15\x15\x15\x150@@@@@@'
'\x15@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15\x15@0:@'
':@@@@\x15\x15::\x15\x15::@\x15\x15\x15\x15\x15\x15\x15\x15@:\x15\x15\x15\x1500\x15000@@\x15\x15GGGGGGGGGG\xca0XXXXXX\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15@0\x15000000\x15\x15\x15000\x150000\x15\x15\x1500\x150\x1500\x15\x15\x1500\x15\x15\x15000\x15\x15\x15000000000000\x15\x15\x15\x15::'
'@::\x15\x15\x15:::\x15:::@\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGGXXX\xcf\xcf\xcf\xcf\xcf\xcf\xa3\xcf\x15\x15\x15\x15\x15'
'@:::@00000000\x15000\x1500000000000000000000000\x150000000000000000\x15\x15\x150@@'
'@::::\x15@@@\x15@@@@\x15\x15\x15\x15\x15\x15\x15@@\x15000\x15\x15\x15\x15\x1500@@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15]]]]]]]\xca'
'0@::\x8900000000\x15000\x1500000000000000000000000\x150000000000\x1500000\x15\x15@0:='
':::::\x15=::\x15::@@\x15\x15\x15\x15\x15\x15\x15::\x15\x15\x15\x15\x15\x15\x150\x1500@@\x15\x15GGGGGGGGGG\x1500\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@::\x1500000000\x15000\x1500000000000000000000000000000000000000000@@0::'
':@@@@\x15:::\x15:::@0\xca\x15\x15\x15\x15000:XXXXXXX000@@\x15\x15GGGGGGGGGGXXXXXXXXX\xca000000'
'\x15\x15::\x15000000000000000000\x15\x15\x15000000000000000000000000\x15000000000\x150\x15\x15'
'0000000\x15\x15\x15@\x15\x15\x15\x15:::@@@\x15@\x15::::::::\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15::\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000000000000000000000000000000000000000000000@0/@@@@@@@\x15\x15\x15\x15\xa3'
'000000$@@@@@@@@\x89GGGGGGGGGG\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1500\x150\x15\x1500\x150\x15\x150\x15\x15\x15\x15\x15\x150000\x150000000\x15000\x150\x150\x15\x1500\x150000@0/@@@@@@\x15@@0\x15\x15'
'00000\x15$\x15@@@@@@\x15\x15GGGGGGGGGG\x15\x150000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0\xca\xca\xca\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\xca\x89\xca\xca\xca@@\xca\xca\xca\xca\xca\xcaGGGGGGGGGGXXXXXXXXXX\xca@\xca@\xca@\x9bp\x9bp::'
'00000000\x15000000000000000000000000000000000000\x15\x15\x15\x15@@@@@@@@@@@@@@:'
'@@@@@\x89@@00000@@@@@@@@@@@\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15\xca\xca'
'\xca\xca\xca\xca\xca\xca@\xca\xca\xca\xca\xca\xca\x15\xca\xca\x89\x89\x89\x89\x89\xca\xca\xca\xca\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000::@@@@:@@@@@@:@@::@@0'
'GGGGGGGGGG\x89\x89\x89\x89\x89\x89000000::@@0000@@@0:::00:::::::000@@@@00000000000'
'00@::@@::::::@0:GGGGGGGGGG:::@\xca\xca77777777777777777777777777777777'
'777777\x157\x15\x15\x15\x15\x157\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x89$\x1b\x1b\x1b'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111100000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000\x150000\x15\x150000000\x150\x150000\x15\x1500000000000000000000000000000000'
'000000000\x150000\x15\x15000000000000000000000000000000000\x150000\x15\x150000000\x15'
'0\x150000\x15\x15000000000000000\x150000000000000000000000000000000000000000'
'00000000000000000\x150000\x15\x150000000000000000000000000000000000000000'
'000000000000000000000000000\x15\x15@@@\x89\x89\x89\x89\x89\x89\x89\x89\x89YYYYYYYYYXXXXXXXXXXX\x15\x15\x15'
'0000000000000000\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'777777777777777777777777777777777777777777777777777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'j000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'000000000000000000000000000000000000000000000\x89\x8900000000000000000'
'\xd800000000000000000000000000\x9bp\x15\x15\x1500000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x89\x89\x89KKK00000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000\x150000@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000@@@\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000\x15000\x15@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000@@:@@@@@@@::'
'::::::@::@@@@@@@@@@@\x89\x89\x89$\x89\x89\x89\xa30@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15]]]]]]]]]]\x15\x15\x15\x15\x15\x15'
'\x90\x90\x90\x90\x90\x90j\x90\x90\x90\x90@@@\x08\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x1500000000000000000000000000000000'
'000$00000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'00000AA0000000000000000000000000000000000@0\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15@@@::::@@:::\x15\x15\x15\x15::@::::::@@@\x15\x15\x15\x15'
'\xcf\x15\x15\x15\x90\x90GGGGGGGGGG000000000000000000000000000000\x15\x1500000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000\x15\x15\x15\x150000000000000000'
'0000000000\x15\x15\x15\x15\x15\x15GGGGGGGGGGY\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'00000000000000000000000@@::@\x15\x15\x89\x8900000000000000000000000000000000'
'000000000000000000000:@:@@@@@@@\x15@:@::@@@@@@@@::::::@@@@@@@@@@\x15\x15@'
'GGGGGGGGGG\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x89\x89\x89\x89\x89\x89\x89$\x89\x89\x89\x89\x89\x89\x15\x15@@@@@@@@@@@@@@<\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@:00000000000000000000000000000000000000000000000@:@@@@@:@:::'
'::@::0000000\x15\x15\x15\x15GGGGGGGGGG\x89\x89\x89\x89\x89\x89\x89\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca@@@@@@@@@\xca\xca\xca\xca\xca\xca\xca\xca\xca\x15\x15\x15'
'@@:000000000000000000000000000000:@@@@::@@:@@@00GGGGGGGGGG000000'
'00000000000000000000000000000000000000@:@@:::@:@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x89\x89\x89\x89'
'000000000000000000000000000000000000::::::::@@@@@@@@::@@\x15\x15\x15\x89\x89\x89\x89\x89'
'GGGGGGGGGG\x15\x15\x15000GGGGGGGGGG000000000000000000000000000000$$$$$$\x89\x89'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x157777777777777777777777777777777777777777777\x15\x15777'
'\x89\x89\x89\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15@@@\x89@@@@@@@@@@@@@:@@@@@@@0000@0000::@00:@@\x15\x15\x15\x15\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%'
'%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\x15@@@@@'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x157\x157\x157\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b44444444\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b77774\xab\x1b\xab'
'\xab\xab\x1b\x1b\x1b\x15\x1b\x1b77774\xab\xab\xab\x1b\x1b\x1b\x1b\x15\x15\x1b\x1b7777\x15\xab\xab\xab\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777\xab\xab\xab\x15\x15\x1b\x1b\x1b\x15\x1b\x1b77774\xab\xab\x15'
'\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\xd8\x08\x08\x08\n\x11ijjiii\x8a\x90xu\x9aywt\x9ay\x8a\x8a\x8a\x90\x8b\x8a\x8a\x8b\xd4\xd5\x0b\x12\x0f\r\x14\xd6\x84\x86\x84\x84\x86\x8a\x90\x90\x90zv\x8a\x90\x90\x8ac'
'c\x90\x90\x90\xaf\x9bp\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\xbc\x90c\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\xd8\x08\x08\x08\x08\x08\x15\x0c\x13\t\x10\x08\x08\x08\x08\x08\x08V%\x15\x15TVVVVV\xb1\xb1\xbc\x9bp '
'VTTTTVVVVV\xb1\xb1\xbc\x9bp\x15%%%%%%%%%%%%%\x15\x15\x15\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa2\xa3\xa3\xa0\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3\xa3'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@<<<<@<<<@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf7\xcc\xcf\xcc\xcf7\xcf\xcc\x1b777\x1b\x1b777\x19\xcf7\xcc\xcf\xbe77777\xcf\xcf\xcf\xcc\xcc\xcf7\xcf5\xcf7\xcf7577\xc6\x1b7777\x1b0000\x1b\xcf\xcf\x1b\x1b77'
'\xbd\xbc\xbc\xbc\xbc7\x1b\x1b\x1b\x1b\xcf\xbc\xcf\xcf\x1b\xca]]][[]]]]]][[[[]IIIIIIIIIIIILLLLJJJJJJJJJJMMMMMM'
'KKK7\x1bKKKK[\xcf\xcf\x15\x15\x15\x15\xb7\xb7\xb7\xb7\xb7\xcc\xcc\xcc\xcc\xcc\xbc\xbc\xcf\xcf\xcf\xcf\xbc\xcf\xcf\xbc\xcf\xcf\xbc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xcf\xcf\xb7\xcf\xb7\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xb7\xbd\xb8\xb8\xbd\xbc\xbc\xb7\xb8\xbd\xbd\xb8\xbd\xbd\xbc\xb7\xbc\xb8\xb1\xb5\xbc\xb8\xbd\xbc\xbc\xbc\xb8\xbd\xbd\xb8\xb7\xb8\xb8\xbd\xbd\xb7\xbd\xb7\xbd\xb7\xb7\xb7\xb7\xb8\xb8\xbd\xb8\xbd\xbd\xbd\xbd\xbd\xb7\xb7\xb7\xb7\xbc\xbd\xbc\xbd\xb8\xb8\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xb8\xbd\xbd\xbd\xb8\xbc\xbc\xbc\xbc\xbc\xb8\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xb8\xb7\xbd\xbc\xb8\xb8\xb8\xb8\xbd\xbd\xb8\xb8\xbc\xbc\xb8\xb8\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xb8\xb8\xbd\xbd\xb8\xb8\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbd\xbd\xbd\xbd\xbc\xbc\xb7\xbc\xbc\xbd\xb7\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbc\xb7\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xb8'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x9bp\x9bp\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xcf\xcf\xcf\xcf\xbd\xbd\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x9es\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xcf\xbc\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xca\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xd2\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\\\\\\\\\\\\\\\\\\[[[[[[[[[[[\\\\\\\\\\\\\\\\\\[[['
'[[[[[[[[TTTTTTTTTSSSSSSSSSSS\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9\xc9^[[[[[[[[[[\\\\\\\\\\\\\\\\\\[\\'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcf\xcf\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf\xcc\xb7\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf'
'\xcc\xb7\xcf\xcf\xcf\xcf\xcc\xcc\xcc\xcf\xcf\xcc\xcf\xcf\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xc1\xc1\xbc'
'\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf\xcc\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcf\xcf\xcf\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcc\xcf\xcc\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xcc\xcc\xcc\xcf\xcc\xcc\xcc\xcc\xcf\xcc\xcc\xcf\xb7\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcc\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xca\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xcc'
'\xcf\xcf\xcf\xcf\xd2\xd2\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xd2\xcc\xcc\xcc\xcc\xcc\xd2\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xcf\xcc\xcf\xcf\xcf\xcf\xcc\xcc\xd2\xcc\xcc\xcc\xcc\xcc\xcc\xcc\xd2\xd2\xcc\xd2\xcc\xcc\xcc\xcc\xd2\xcc\xcc\xd2\xcc\xcc'
'\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcc\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xd2\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\\\\\\\\\\\\\\\\\\['
'^^^^^^^^^]^^^^^^^^^]\xcf\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2'
'\xbd\xbc\xbc\xbd\xbd\x9bp\xbc\xbd\xbd\xbc\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbc\xbc\xbc\xbd\xbd\xbd\xbd\x9cq\x9cq\x9cq\x9cq\x9bp\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\x9bp\x9cq\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\x9bp\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbd\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbc\xbd\xbd\xbc\xbc\x9bp\x9bp\xbd\xbc\xbc\xbc\xbc\xbd\xbc\xbd\xbd\xbd\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\x9bp\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbd\xbd\xbd\xbd\xbc\xbc\xbd\xbc\xbd\xbc\xbc\xbd\xbc\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbc'
'\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbc\xbd\xbd\xbc\xbc\xbd\xbd\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd'
'\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xbc\xbd\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbc\xbd\xbd\xbd\xbc\xbc\xbc\xbc\xbd\xbc\xbc\xbc\xbd\xbd\xbd\xbd\xbd\xbc\xbd\xbc\xbc'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc\xbc'
'\xbc\xbc\xbc\xbc\xbc\xcf\xcf\xbc\xbc\xbc\xbc\xbc\xbc\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xd2\xcc\xcc\xcc\xcc\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd0\x15'
'77777777777777777777777777777777777777777777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x157\x1b777\x1b\x1b7\x1b7\x1b7\x1b7777\x1b7\x1b\x1b7\x1b\x1b\x1b\x1b\x1b\x1b%%77'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\xcf\xcf\xcf\xcf\xcf\xcf7\x1b7\x1b@@@7\x1b\x15\x15\x15\x15\x15\x90\x90\x90\x90]\x90\x90'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x15\x15\x15\x15\x15\x1b\x15\x150000000000000000'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15$\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'00000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x150000000\x150000000\x15'
'0000000\x150000000\x150000000\x150000000\x15@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@'
'\x90\x90zvzv\x90\x90\x90zv\x90zv\x90\x90\x90\x90\x90\x90\x90\x90\x90j\x90\x90j\x90zv\x90\x90zv\x9bp\x9bp\x9bp\x9bp\x90\x90\x90\x90\x90(\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90jj\x90\x90\x90\x90'
'j\x90\x9a\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15'
'\xd7\x94\x94\x94\xd2&1N\x9es\x9es\x9es\x9es\x9es\xd2\xd2\x9es\x9es\x9es\x9esk\x9drr\xd2NNNNNNNNNBBBB;;k&&&&&\xd2\xd2NNN&1\x94\xd2\xcf'
'\x15111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x15\x15BB\xad\xad&&1k1111111111111111111111111111111'
'11111111111111111111111111111111111111111111111111111111111\x94&&&1'
'\x15\x15\x15\x15\x151111111111111111111111111111111111111111111\x15111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111\x15\xcb\xcbZZZZ\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb111111111111111111111111111\x15\x15\x15\x15\x15'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x151111111111111111'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2\xd2\x15ZZZZZZZZZZ\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcbWWWWWWWW\xd2_______________\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2\xd2\xd2\xcb'
'ZZZZZZZZZZ\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb_______________'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2\xd2\xd2\xd2\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\x15'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2\xd2\xd2\xd2\xcb\xcb\xcb\xcb\xcb'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2\xd2\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xd2'
'1111121111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'2112111212111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111121111111111111111111111111111111111'
'1111111111112111111121211111111111111111111111111111111111111112'
'2111111111111111111111111111111211111111211111111111111111111111'
'1111111111111211111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111211111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111121212111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1212221111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1222211111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111211111112111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111211111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111122'
'1111111111112221211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111112111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111112111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111211111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111121'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111112111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111121111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111211112111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111112111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111112111112111111111111111111111111111111111111111111121111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111112111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111&111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000000000000000000000000$$$$$$\x89\x89'
'000000000000$\x90\x90\x900000000000000000GGGGGGGGGG00\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b0@<<<\x90@@@@@@@@@@\x90)'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%%@@00000000000000000000000000000000'
'00000000000000000000000000000000000000KKKKKKKKKK@@\x89\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15'
'\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab\xab)))))))))\xab\xab7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b'
'7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b%\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1b7\x1b77\x1b'
'7\x1b7\x1b7\x1b7\x1b)\xa8\xa87\x1b7\x1b07\x1b7\x1b\x1b\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b7\x1b77777\x1b77777\x1b7\x1b7\x1b\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150%%\x1b00000'
'00@000@0000@00000000000000000000000::@@:\xcf\xcf\xcf\xcf\x15\x15\x15\x15XXXXXX\xca\xca\xa3\xc5\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000\x90\x90\x90\x90\x15\x15\x15\x15\x15\x15\x15\x15'
'::00000000000000000000000000000000000000000000000000::::::::::::'
'::::@@\x15\x15\x15\x15\x15\x15\x15\x15\x89\x89GGGGGGGGGG\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@@@000000\x89\x89\x890\x8900@'
'GGGGGGGGGG0000000000000000000000000000@@@@@@@@\x89\x890000000000000000'
'0000000@@@@@@@@@@@::\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x8911111111111111111111111111111\x15\x15\x15'
'@@@:00000000000000000000000000000000000000000000000@::@@@@::@:::'
':\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x15$GGGGGGGGGG\x15\x15\x15\x15\x89\x8900000@$000000000GGGGGGGGGG00000\x15'
'00000000000000000000000000000000000000000@@@@@@::@@::@@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000@00000000@:\x15\x15GGGGGGGGGG\x15\x15\x89\x89\x89\x890000000000000000$000000\xca\xca\xca0:@:00'
'000000000000000000000000000000000000000000000000@0@@@00@@00000@@'
'0@0\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500$\x89\x8900000000000:@@::\x89\x890$$:@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15000000\x15\x15000000\x15\x15000000\x15\x15\x15\x15\x15\x15\x15\x15\x150000000\x150000000\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xa8%%%%\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'00000000000000000000000000000000000::@::@::\x89:@\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'0000000\x15\x15\x15\x150000000000000000000000000000000000000000000000000\x15\x15\x15\x15'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18\x18'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111211111112111121111111'
'1111111111111111111111111111111111111111111111111121111111111111'
'1111111111111111121211111111111111111111111111111111111111111211'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111\x16\x161111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15\x153@3333333333\xb13333333333333\x1533333\x153\x15'
'33\x1533\x153333333333,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7\xa7'
'\xa7\xa7\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,++++++,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,o\x9a'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,\x15\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,++\x9f\xcf\x15\x15'
'>>>>>>>>>>>>>>>>\x94\x94\x94\x95\x94\x94\x94\x9dr\x94\x15\x15\x15\x15\x15\x15@@@@@@@@@@@@@@@@\x94kkee\x9dr\x9dr\x9dr\x9dr\x9dr\x9d'
'r\x9dr\x9dr\x94\x94\x9dr\x94\x94\x94\x94eee\x82\x94\x83\x15\x94\x83\x94\x94k\x9es\x9es\x9es\x88\x94\x94\xb3h\xc2\xc2\xc1\x15\x94\xa5\x88\x94\x15\x15\x15\x15+,+,+\x15+,+,+,+,+,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15\x15\x08'
'\x15\x8d\x8d\x85\xa1\x85\x8d\x8e\x98m\x8d\xb0}f~}DDDDDDDDDD~\x8d\xba\xb9\xba\x8d\x8d66666666666666666666666666\x98\x8dm\xaab'
'\xaa\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x98\xb9m\xb9\x98m\x8f\x99n\x8f\x8f.........."...............'
'..............................!!...............................\x15'
'\x15\x15......\x15\x15......\x15\x15......\x15\x15...\x15\x15\x15\xa1\xa1\xb9\xaa\xcd\xa1\xa1\x15\xce\xbb\xbb\xbb\xbb\xce\xce\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x0e\x0e\x0e\xcf\xcc\x15\x15'
'000000000000\x1500000000000000000000000000\x150000000000000000000\x1500\x150'
'00000000000000\x15\x1500000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15'
'\x89\x90\x89\x15\x15\x15\x15XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX\x15\x15\x15\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO]]]]\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf]]\xcf\xca\xca\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca@\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000\x15\x15\x1500000000000000000000000000000000'
'00000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@UUUUUUUUUUUUUUUUUUUUUUUUUUU\x15\x15\x15\x15'
'00000000000000000000000000000000XXXX\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000'
'0K00000000K\x15\x15\x15\x15\x1500000000000000000000000000000000000000@@@@@\x15\x15\x15\x15\x15'
'000000000000000000000000000000\x15\x8900000000000000000000000000000000'
'0000\x15\x15\x15\x1500000000\x89KKKKK\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'7777777777777777777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b000000000000000000000000000000000000000000000000'
'000000000000000000000000000000\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x157777777777777777'
'77777777777777777777\x15\x15\x15\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15\x15\x15'
'0000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x150000000000000000'
'000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333\x15\x153\x1533333333333333333333333333333333333333333333\x1533\x15\x15\x153\x15\x153'
'3333333333333333333333\x15\x96````````33333333333333333333333\xd3\xd3```````'
'3333333333333333333333333333333\x15\x15\x15\x15\x15\x15\x15\x15`````````\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x153333333333333333333\x1533\x15\x15\x15\x15\x15`````'
'3333333333333333333333``````\x15\x15\x15\x9033333333333333333333333333\x15\x15\x15\x15\x15\x96'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333333333333333333333333333333333333333333333333333\x15\x15\x15\x15``33'
'````````````````\x15\x15``````````````````````````````````````````````'
'3@@@\x15@@\x15\x15\x15\x15\x15@@@@3333\x15333\x1533333333333333333333333333333\x15\x15@@@\x15\x15\x15\x15@'
'aaaa`````\x15\x15\x15\x15\x15\x15\x15\x96\x96\x96\x96\x96\x96\x96\x96\x96\x15\x15\x15\x15\x15\x15\x1533333333333333333333333333333``\x96'
'33333333333333333333333333333```\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333\xd33333333333333333333333333333@@\x15\x15\x15\x15`````\x96\x96\x96\x96\x96\x96\x96\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'333333333333333333333333333333333333333333333333333333\x15\x15\x15\x90\x90\x90\x90\x90\x90\x90'
'3333333333333333333333\x15\x15````````3333333333333333333\x15\x15\x15\x15\x15````````'
'333333333333333333\x15\x15\x15\x15\x15\x15\x15\x96\x96\x96\x96\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15```````\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'333333333\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'999999999999999999999999999999999999999999999999999\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x15\x15\x15\x15\x15\x15\x15``````'
',,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,@@@@\x15\x15\x15\x15\x15\x15\x15\x15CCCCCCCCCC\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15RRRRRRRRRQQQQQQQQQQQQQQQQQQQQQQ\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'33333333333333333333333333333``````````3\x15\x15\x15\x15\x15\x15\x15\x15,,,,,,,,,,,,,,,,'
',,,,,,@@@@@@@@@@@PPPP{{{{{\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
':@:00000000000000000000000000000000000000000000000000000@@@@@@@@'
'@@@@@@@\x89\x89\x89\x89\x89\x89\x89\x15\x15\x15\x15^^^^^^^^^]]]]]]]]]]]GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@'
'@@:000000000000000000000000000000000000000000000:::@@@@::@@\x89\x89\n\x89\x89'
'\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\n\x15\x150000000000000000000000000\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'@@@000000000000000000000000000000000000@@@@@:@@@@@@@@\x15GGGGGGGGGG'
'\x89\x89\x89\x890::\x15\x15\x15\x15\x15\x15\x15\x15\x1500000000000000000000000000000000000@\x89\x890\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@:000000000000000000000000000000000000000000000000:::@@@@@@@@@:'
':0000\x89\x89\x89\x89@@@@\x89\x15\x15GGGGGGGGGG0\x890\x89\x89\x89\x15XXXXXXXXXXXXXXXXXXXX\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000\x150000000000000000000000000:::@@@::@:@@\x89\x89\x89\x89\x89\x89@\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000\x150\x150000\x15000000000000000\x150000000000\x89\x15\x15\x15\x15\x15\x150000000000000000'
'0000000000000000000000000000000@:::@@@@@@@@\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15'
'@@::\x1500000000\x15\x1500\x15\x150000000000000000000000\x150000000\x1500\x1500000\x15@@0::'
'@::::\x15\x15::\x15\x15:::\x15\x150\x15\x15\x15\x15\x15\x15:\x15\x15\x15\x15\x1500000::\x15\x15@@@@@@@\x15\x15\x15@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000000000:::@@@@@@@@'
'::@@@:@0000\x89\x89\x89\x89\x89GGGGGGGGGG\x15\x89\x15\x89@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@:@::::@'
'@:@@00\x890\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000:::@@@@\x15\x15::::@@:@'
'@\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x89\x890000@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000:::@@@@@@@@::@:@'
'@\x89\x89\x890\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x90\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000@:@::@@@@@@:@\x15\x15\x15\x15\x15\x15\x15\x15'
'GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000\x15\x15@@@::@@@@:@@@@@\x15\x15\x15\x15GGGGGGGGGGXX\x89\x89\x89\xca'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000:::@@@@@@@@@:@@\x89\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x1577777777777777777777777777777777'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1bGGGGGGGGGGXXXXXXXXX\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0@@@@@@==@@0000000000000000000000000000000000000000@@@@@@:0@@@@\x89'
'\x89\x89\x89\x89\x89\x89\x89@\x15\x15\x15\x15\x15\x15\x15\x150@@@@@@::@@@000000000000000000000000000000000000'
'0000\x15\x150000@@@@@@@@@@@@@:@@\x89\x89\x890\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'000000000\x150000000000000000000000000000000000000:@@@@@@@\x15@@@@@@:='
'0\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGGXXXXXXXXXXXXXXXXXXX\x15\x15\x15\x89\x8900000000000000'
'0000000000000000\x15\x15@@@@@@@@@@@@@@@@@@@@@@\x15:@@@@@@@:@@:@@\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000\x1500\x1500000000000000000000000000000000000000@@@@@@\x15\x15\x15@\x15@@\x15@'
'@@@@@@0@\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15000000\x1500\x150000000000000000000000'
'0000000000:::::\x15@@\x15::@:@0\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150000000000000000000@@::\x89\x89\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK'
'KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK\x15\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'00000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000000000000\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000\x15GGGGGGGGGG\x15\x15\x15\x15\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15000000000000000000000000000000\x15\x15@@@@@\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'000000000000000000000000000000000000000000000000@@@@@@@\x89\x89\x89\x89\x89\xca\xca\xca\xca'
'$$$$\x89\xca\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15GGGGGGGGGG\x15XXXXXXX\x15000000000000000000000\x15\x15\x15\x15\x15000'
'0000000000000000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'XXXXXXXXXXXXXXXXXXXXXXX\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'00000\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x150::::::::::::::::::::::::::::::::::::::::::::::\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@$$$$$$$$$$$$$\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15&&\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1111111111111111111111111111111\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x151111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111111111111111111111111111111\x15\x15\x15\x15'
'0000000000000000000000000000000000000000000000000000000000000000'
'0000000000000000000000000000000000000000000\x15\x15\x15\x15\x150000000000000\x15\x15\x15'
'000000000\x15\x15\x15\x15\x15\x15\x150000000000\x15\x15\xca@@\x89\x08\x08\x08\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\x15\x15\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca::@@@\xca\xca\xca::::::\x08\x08\x08\x08\x08\x08\x08\x08@@@@@'
'@@@\xca\xca@@@@@@@\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca@@@@\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf@@@\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15XXXXXXXXXXXXXXXXXXXX\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15XXXXXXXXXXXXXXXXXXXXXXXXX\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777'
'77777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b777777777777777777777777'
'77\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7\x1577\x15\x157\x15\x1577\x15\x157777\x1577777777\x1b\x1b\x1b\x1b\x15\x1b\x15\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b77\x157777\x15\x1577777777\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77\x157777\x15'
'77777\x157\x15\x15\x157777777\x15\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777'
'777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b77777777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777'
'7777777777777777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777'
'7777777777\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x15\x15777777777777777777777777'
'7\xb6\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbd\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb6\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbd\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb6\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbd\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb6\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\xbd\x1b\x1b\x1b\x1b\x1b\x1b7777777777777777777777777\xb6\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b'
'\x1b\x1b\x1b\xbd\x1b\x1b\x1b\x1b\x1b\x1b7\x1b\x15\x15EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xca\xca\xca\xca@@@@@'
'@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\xca\xca\xca\xca\xca\xca\xca\xca@\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xca\xca\xca\xca@\xca\xca\x89\x89\x89\x89\x89\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15@@@@@\x15@@@@@@@@@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'@@@@@@@\x15@@@@@@@@@@@@@@@@@\x15\x15@@@@@@@\x15@@\x15@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'3333333333333333333333333333333333333333333333333333333333333333'
'33333\x15\x15`````````@@@@@@@\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'9999999999999999999999999999999999\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d\x1d'
'\x1d\x1d\x1d\x1d@@@@@@@\x15\x15\x15\x15\x15HHHHHHHHHH\x15\x15\x15\x15\x96\x96\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15PPPPPPPPPPPPPPP'
'PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP\xc3PPP\x9fPPPP\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
',,,,\x15,,,,,,,,,,,,,,,,,,,,,,,,,,,\x15,,\x15,\x15\x15,\x15,,,,,,,,,,\x15,,,,\x15,\x15,\x15\x15\x15\x15'
'\x15\x15,\x15\x15\x15\x15,\x15,\x15,\x15,,,\x15,,\x15,\x15\x15,\x15,\x15,\x15,\x15,\x15,,\x15,\x15\x15,,,,\x15,,,,,,,\x15,,,,\x15,,,,\x15,\x15'
',,,,,,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15\x15,,,\x15,,,,,\x15,,,,,,,,,,,,,,,,,\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xbc\xbc\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'TTTTTTTTTTT]]\x15\x15\x15\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xca\xcf\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc7\xc7\xc7\xc7\xc7\xc7\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xcf\xcf\x15\x15\x15\x15\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8'
'\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc8\xc7\xc7\xc7\xc7\xcb\xc7\xc7\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\xc7\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca\xca'
'\xcb\xcb\xcb\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\x15\x15\x15\x15'
'\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\xcb\x15\x15\x15\x15\x15\x15\x15\xcb\xcb\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xd2\xd2\xd2\xad\xad\xad\xad\xad'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf'
'\xd2\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xcf\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xcf\xcf\xcf\xd2\xd2\xd2\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xd2\xd2\x15\x15\x15\xcf\xcf\xcf\xcf\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\xd2\xd2\xd2\xd2\x15\x15\x15\xd2\x15\xd2\xd2\xd2\xd2'
'\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15'
'\xd2\xd2\xd2\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2\xd2'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\xcf\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'1211111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111112111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111211111111111111111111111111111'
'1111111111111111111111111111111112111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1112111111112111111111111111211111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111112111111111111111111211'
'1111111111111111111111111211111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111211111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111112111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111112111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111112111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'11111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'11111111111111111111111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111\x16\x1611111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x161111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'1111111111111111111111111111111111111111111111111111111111111111'
'111111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'111111111111111111111111111111\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16'
'\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x16\x15\x15'
'\x15\x08\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08\x08'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>'
'>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15\x15'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17'
'\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x17\x15\x15'
)

def _get_record(code):
    return _db_records[ord(_db_pages[(ord(_db_pgtbl[code >> 8]) << 8) + (code & 255)])]

def category(code): return _get_record(code)[0]
def bidirectional(code): return _get_record(code)[1]
def east_asian_width(code): return _get_record(code)[2]
def isspace(code): return _get_record(code)[3] & 1 != 0
def isalpha(code): return _get_record(code)[3] & 2 != 0
def islinebreak(code): return _get_record(code)[3] & 4 != 0
def isnumeric(code): return _get_record(code)[3] & 64 != 0
def isdigit(code): return _get_record(code)[3] & 128 != 0
def isdecimal(code): return _get_record(code)[3] & 256 != 0
def isalnum(code): return _get_record(code)[3] & 66 != 0
def isupper(code): return _get_record(code)[3] & 8 != 0
def istitle(code): return _get_record(code)[3] & 16 != 0
def islower(code): return _get_record(code)[3] & 32 != 0
def iscased(code): return _get_record(code)[3] & 56 != 0
def isxidstart(code): return _get_record(code)[3] & 1024 != 0
def isxidcontinue(code): return _get_record(code)[3] & 2048 != 0
def isprintable(code): return _get_record(code)[3] & 4096 != 0
def mirrored(code): return _get_record(code)[3] & 512 != 0
def iscaseignorable(code): return _get_record(code)[3] & 8192 != 0
_decimal = {
3558: 0,
3559: 1,
3560: 2,
3561: 3,
3562: 4,
3563: 5,
3564: 6,
3565: 7,
3566: 8,
3567: 9,
43504: 0,
43505: 1,
43506: 2,
43507: 3,
43508: 4,
43509: 5,
43510: 6,
43511: 7,
43512: 8,
43513: 9,
68912: 0,
68913: 1,
68914: 2,
68915: 3,
68916: 4,
68917: 5,
68918: 6,
68919: 7,
68920: 8,
68921: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
70384: 0,
70385: 1,
70386: 2,
70387: 3,
70388: 4,
70389: 5,
70390: 6,
70391: 7,
70392: 8,
70393: 9,
70736: 0,
70737: 1,
70738: 2,
70739: 3,
70740: 4,
70741: 5,
70742: 6,
70743: 7,
70744: 8,
70745: 9,
70864: 0,
70865: 1,
70866: 2,
70867: 3,
70868: 4,
70869: 5,
70870: 6,
70871: 7,
70872: 8,
70873: 9,
71248: 0,
71249: 1,
71250: 2,
71251: 3,
71252: 4,
71253: 5,
71254: 6,
71255: 7,
71256: 8,
71257: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
71472: 0,
71473: 1,
71474: 2,
71475: 3,
71476: 4,
71477: 5,
71478: 6,
71479: 7,
71480: 8,
71481: 9,
71904: 0,
71905: 1,
71906: 2,
71907: 3,
71908: 4,
71909: 5,
71910: 6,
71911: 7,
71912: 8,
71913: 9,
72784: 0,
72785: 1,
72786: 2,
72787: 3,
72788: 4,
72789: 5,
72790: 6,
72791: 7,
72792: 8,
72793: 9,
73040: 0,
73041: 1,
73042: 2,
73043: 3,
73044: 4,
73045: 5,
73046: 6,
73047: 7,
73048: 8,
73049: 9,
73120: 0,
73121: 1,
73122: 2,
73123: 3,
73124: 4,
73125: 5,
73126: 6,
73127: 7,
73128: 8,
73129: 9,
92768: 0,
92769: 1,
92770: 2,
92771: 3,
92772: 4,
92773: 5,
92774: 6,
92775: 7,
92776: 8,
92777: 9,
93008: 0,
93009: 1,
93010: 2,
93011: 3,
93012: 4,
93013: 5,
93014: 6,
93015: 7,
93016: 8,
93017: 9,
125264: 0,
125265: 1,
125266: 2,
125267: 3,
125268: 4,
125269: 5,
125270: 6,
125271: 7,
125272: 8,
125273: 9,
}

_decimal_corrected = {
6618: None,
}
_digit = {
3558: 0,
3559: 1,
3560: 2,
3561: 3,
3562: 4,
3563: 5,
3564: 6,
3565: 7,
3566: 8,
3567: 9,
43504: 0,
43505: 1,
43506: 2,
43507: 3,
43508: 4,
43509: 5,
43510: 6,
43511: 7,
43512: 8,
43513: 9,
68912: 0,
68913: 1,
68914: 2,
68915: 3,
68916: 4,
68917: 5,
68918: 6,
68919: 7,
68920: 8,
68921: 9,
69714: 1,
69715: 2,
69716: 3,
69717: 4,
69718: 5,
69719: 6,
69720: 7,
69721: 8,
69722: 9,
69734: 0,
69735: 1,
69736: 2,
69737: 3,
69738: 4,
69739: 5,
69740: 6,
69741: 7,
69742: 8,
69743: 9,
69872: 0,
69873: 1,
69874: 2,
69875: 3,
69876: 4,
69877: 5,
69878: 6,
69879: 7,
69880: 8,
69881: 9,
69942: 0,
69943: 1,
69944: 2,
69945: 3,
69946: 4,
69947: 5,
69948: 6,
69949: 7,
69950: 8,
69951: 9,
70096: 0,
70097: 1,
70098: 2,
70099: 3,
70100: 4,
70101: 5,
70102: 6,
70103: 7,
70104: 8,
70105: 9,
70384: 0,
70385: 1,
70386: 2,
70387: 3,
70388: 4,
70389: 5,
70390: 6,
70391: 7,
70392: 8,
70393: 9,
70736: 0,
70737: 1,
70738: 2,
70739: 3,
70740: 4,
70741: 5,
70742: 6,
70743: 7,
70744: 8,
70745: 9,
70864: 0,
70865: 1,
70866: 2,
70867: 3,
70868: 4,
70869: 5,
70870: 6,
70871: 7,
70872: 8,
70873: 9,
71248: 0,
71249: 1,
71250: 2,
71251: 3,
71252: 4,
71253: 5,
71254: 6,
71255: 7,
71256: 8,
71257: 9,
71360: 0,
71361: 1,
71362: 2,
71363: 3,
71364: 4,
71365: 5,
71366: 6,
71367: 7,
71368: 8,
71369: 9,
71472: 0,
71473: 1,
71474: 2,
71475: 3,
71476: 4,
71477: 5,
71478: 6,
71479: 7,
71480: 8,
71481: 9,
71904: 0,
71905: 1,
71906: 2,
71907: 3,
71908: 4,
71909: 5,
71910: 6,
71911: 7,
71912: 8,
71913: 9,
72784: 0,
72785: 1,
72786: 2,
72787: 3,
72788: 4,
72789: 5,
72790: 6,
72791: 7,
72792: 8,
72793: 9,
73040: 0,
73041: 1,
73042: 2,
73043: 3,
73044: 4,
73045: 5,
73046: 6,
73047: 7,
73048: 8,
73049: 9,
73120: 0,
73121: 1,
73122: 2,
73123: 3,
73124: 4,
73125: 5,
73126: 6,
73127: 7,
73128: 8,
73129: 9,
92768: 0,
92769: 1,
92770: 2,
92771: 3,
92772: 4,
92773: 5,
92774: 6,
92775: 7,
92776: 8,
92777: 9,
93008: 0,
93009: 1,
93010: 2,
93011: 3,
93012: 4,
93013: 5,
93014: 6,
93015: 7,
93016: 8,
93017: 9,
125264: 0,
125265: 1,
125266: 2,
125267: 3,
125268: 4,
125269: 5,
125270: 6,
125271: 7,
125272: 8,
125273: 9,
}

_digit_corrected = {
}
_numeric = {
188: 1.0 / 4.0,
189: 1.0 / 2.0,
190: 3.0 / 4.0,
2548: 1.0 / 16.0,
2549: 1.0 / 8.0,
2550: 3.0 / 16.0,
2551: 1.0 / 4.0,
2552: 3.0 / 4.0,
2930: 1.0 / 4.0,
2931: 1.0 / 2.0,
2932: 3.0 / 4.0,
2933: 1.0 / 16.0,
2934: 1.0 / 8.0,
2935: 3.0 / 16.0,
3416: 1.0 / 160.0,
3417: 1.0 / 40.0,
3418: 3.0 / 80.0,
3419: 1.0 / 20.0,
3420: 1.0 / 10.0,
3421: 3.0 / 20.0,
3422: 1.0 / 5.0,
3443: 1.0 / 4.0,
3444: 1.0 / 2.0,
3445: 3.0 / 4.0,
3446: 1.0 / 16.0,
3447: 1.0 / 8.0,
3448: 3.0 / 16.0,
3558: 0.0,
3559: 1.0,
3560: 2.0,
3561: 3.0,
3562: 4.0,
3563: 5.0,
3564: 6.0,
3565: 7.0,
3566: 8.0,
3567: 9.0,
3882: 1.0 / 2.0,
3883: 3.0 / 2.0,
3884: 5.0 / 2.0,
3885: 7.0 / 2.0,
3886: 9.0 / 2.0,
3887: 11.0 / 2.0,
3888: 13.0 / 2.0,
3889: 15.0 / 2.0,
3890: 17.0 / 2.0,
3891: -1.0 / 2.0,
8528: 1.0 / 7.0,
8529: 1.0 / 9.0,
8530: 1.0 / 10.0,
8531: 1.0 / 3.0,
8532: 2.0 / 3.0,
8533: 1.0 / 5.0,
8534: 2.0 / 5.0,
8535: 3.0 / 5.0,
8536: 4.0 / 5.0,
8537: 1.0 / 6.0,
8538: 5.0 / 6.0,
8539: 1.0 / 8.0,
8540: 3.0 / 8.0,
8541: 5.0 / 8.0,
8542: 7.0 / 8.0,
11517: 1.0 / 2.0,
12872: 10.0,
12873: 20.0,
12874: 30.0,
12875: 40.0,
12876: 50.0,
12877: 60.0,
12878: 70.0,
12879: 80.0,
43056: 1.0 / 4.0,
43057: 1.0 / 2.0,
43058: 3.0 / 4.0,
43059: 1.0 / 16.0,
43060: 1.0 / 8.0,
43061: 3.0 / 16.0,
43504: 0.0,
43505: 1.0,
43506: 2.0,
43507: 3.0,
43508: 4.0,
43509: 5.0,
43510: 6.0,
43511: 7.0,
43512: 8.0,
43513: 9.0,
65856: 1.0 / 4.0,
65857: 1.0 / 2.0,
65909: 1.0 / 2.0,
65910: 1.0 / 2.0,
65911: 2.0 / 3.0,
65912: 3.0 / 4.0,
65931: 1.0 / 4.0,
66273: 1.0,
66274: 2.0,
66275: 3.0,
66276: 4.0,
66277: 5.0,
66278: 6.0,
66279: 7.0,
66280: 8.0,
66281: 9.0,
66282: 10.0,
66283: 20.0,
66284: 30.0,
66285: 40.0,
66286: 50.0,
66287: 60.0,
66288: 70.0,
66289: 80.0,
66290: 90.0,
66291: 100.0,
66292: 200.0,
66293: 300.0,
66294: 400.0,
66295: 500.0,
66296: 600.0,
66297: 700.0,
66298: 800.0,
66299: 900.0,
67705: 1.0,
67706: 2.0,
67707: 3.0,
67708: 4.0,
67709: 5.0,
67710: 10.0,
67711: 20.0,
67751: 1.0,
67752: 2.0,
67753: 3.0,
67754: 4.0,
67755: 4.0,
67756: 5.0,
67757: 10.0,
67758: 20.0,
67759: 100.0,
67835: 1.0,
67836: 5.0,
67837: 10.0,
67838: 20.0,
67839: 100.0,
68028: 11.0 / 12.0,
68029: 1.0 / 2.0,
68032: 1.0,
68033: 2.0,
68034: 3.0,
68035: 4.0,
68036: 5.0,
68037: 6.0,
68038: 7.0,
68039: 8.0,
68040: 9.0,
68041: 10.0,
68042: 20.0,
68043: 30.0,
68044: 40.0,
68045: 50.0,
68046: 60.0,
68047: 70.0,
68050: 100.0,
68051: 200.0,
68052: 300.0,
68053: 400.0,
68054: 500.0,
68055: 600.0,
68056: 700.0,
68057: 800.0,
68058: 900.0,
68059: 1000.0,
68060: 2000.0,
68061: 3000.0,
68062: 4000.0,
68063: 5000.0,
68064: 6000.0,
68065: 7000.0,
68066: 8000.0,
68067: 9000.0,
68068: 10000.0,
68069: 20000.0,
68070: 30000.0,
68071: 40000.0,
68072: 50000.0,
68073: 60000.0,
68074: 70000.0,
68075: 80000.0,
68076: 90000.0,
68077: 100000.0,
68078: 200000.0,
68079: 300000.0,
68080: 400000.0,
68081: 500000.0,
68082: 600000.0,
68083: 700000.0,
68084: 800000.0,
68085: 900000.0,
68086: 1.0 / 12.0,
68087: 2.0 / 12.0,
68088: 3.0 / 12.0,
68089: 4.0 / 12.0,
68090: 5.0 / 12.0,
68091: 6.0 / 12.0,
68092: 7.0 / 12.0,
68093: 8.0 / 12.0,
68094: 9.0 / 12.0,
68095: 10.0 / 12.0,
68168: 1.0 / 2.0,
68253: 1.0,
68254: 10.0,
68255: 20.0,
68331: 1.0,
68332: 5.0,
68333: 10.0,
68334: 20.0,
68335: 100.0,
68521: 1.0,
68522: 2.0,
68523: 3.0,
68524: 4.0,
68525: 10.0,
68526: 20.0,
68527: 100.0,
68858: 1.0,
68859: 5.0,
68860: 10.0,
68861: 50.0,
68862: 100.0,
68863: 1000.0,
68912: 0.0,
68913: 1.0,
68914: 2.0,
68915: 3.0,
68916: 4.0,
68917: 5.0,
68918: 6.0,
68919: 7.0,
68920: 8.0,
68921: 9.0,
69243: 1.0 / 2.0,
69244: 1.0 / 4.0,
69245: 1.0 / 3.0,
69246: 2.0 / 3.0,
69405: 1.0,
69406: 2.0,
69407: 3.0,
69408: 4.0,
69409: 5.0,
69410: 10.0,
69411: 20.0,
69412: 30.0,
69413: 100.0,
69414: 1.0 / 2.0,
69457: 1.0,
69458: 10.0,
69459: 20.0,
69460: 100.0,
69714: 1.0,
69715: 2.0,
69716: 3.0,
69717: 4.0,
69718: 5.0,
69719: 6.0,
69720: 7.0,
69721: 8.0,
69722: 9.0,
69723: 10.0,
69724: 20.0,
69725: 30.0,
69726: 40.0,
69727: 50.0,
69728: 60.0,
69729: 70.0,
69730: 80.0,
69731: 90.0,
69732: 100.0,
69733: 1000.0,
69734: 0.0,
69735: 1.0,
69736: 2.0,
69737: 3.0,
69738: 4.0,
69739: 5.0,
69740: 6.0,
69741: 7.0,
69742: 8.0,
69743: 9.0,
69872: 0.0,
69873: 1.0,
69874: 2.0,
69875: 3.0,
69876: 4.0,
69877: 5.0,
69878: 6.0,
69879: 7.0,
69880: 8.0,
69881: 9.0,
69942: 0.0,
69943: 1.0,
69944: 2.0,
69945: 3.0,
69946: 4.0,
69947: 5.0,
69948: 6.0,
69949: 7.0,
69950: 8.0,
69951: 9.0,
70096: 0.0,
70097: 1.0,
70098: 2.0,
70099: 3.0,
70100: 4.0,
70101: 5.0,
70102: 6.0,
70103: 7.0,
70104: 8.0,
70105: 9.0,
70113: 1.0,
70114: 2.0,
70115: 3.0,
70116: 4.0,
70117: 5.0,
70118: 6.0,
70119: 7.0,
70120: 8.0,
70121: 9.0,
70122: 10.0,
70123: 20.0,
70124: 30.0,
70125: 40.0,
70126: 50.0,
70127: 60.0,
70128: 70.0,
70129: 80.0,
70130: 90.0,
70131: 100.0,
70132: 1000.0,
70384: 0.0,
70385: 1.0,
70386: 2.0,
70387: 3.0,
70388: 4.0,
70389: 5.0,
70390: 6.0,
70391: 7.0,
70392: 8.0,
70393: 9.0,
70736: 0.0,
70737: 1.0,
70738: 2.0,
70739: 3.0,
70740: 4.0,
70741: 5.0,
70742: 6.0,
70743: 7.0,
70744: 8.0,
70745: 9.0,
70864: 0.0,
70865: 1.0,
70866: 2.0,
70867: 3.0,
70868: 4.0,
70869: 5.0,
70870: 6.0,
70871: 7.0,
70872: 8.0,
70873: 9.0,
71248: 0.0,
71249: 1.0,
71250: 2.0,
71251: 3.0,
71252: 4.0,
71253: 5.0,
71254: 6.0,
71255: 7.0,
71256: 8.0,
71257: 9.0,
71360: 0.0,
71361: 1.0,
71362: 2.0,
71363: 3.0,
71364: 4.0,
71365: 5.0,
71366: 6.0,
71367: 7.0,
71368: 8.0,
71369: 9.0,
71472: 0.0,
71473: 1.0,
71474: 2.0,
71475: 3.0,
71476: 4.0,
71477: 5.0,
71478: 6.0,
71479: 7.0,
71480: 8.0,
71481: 9.0,
71482: 10.0,
71483: 20.0,
71904: 0.0,
71905: 1.0,
71906: 2.0,
71907: 3.0,
71908: 4.0,
71909: 5.0,
71910: 6.0,
71911: 7.0,
71912: 8.0,
71913: 9.0,
71914: 10.0,
71915: 20.0,
71916: 30.0,
71917: 40.0,
71918: 50.0,
71919: 60.0,
71920: 70.0,
71921: 80.0,
71922: 90.0,
72784: 0.0,
72785: 1.0,
72786: 2.0,
72787: 3.0,
72788: 4.0,
72789: 5.0,
72790: 6.0,
72791: 7.0,
72792: 8.0,
72793: 9.0,
72794: 1.0,
72795: 2.0,
72796: 3.0,
72797: 4.0,
72798: 5.0,
72799: 6.0,
72800: 7.0,
72801: 8.0,
72802: 9.0,
72803: 10.0,
72804: 20.0,
72805: 30.0,
72806: 40.0,
72807: 50.0,
72808: 60.0,
72809: 70.0,
72810: 80.0,
72811: 90.0,
72812: 100.0,
73040: 0.0,
73041: 1.0,
73042: 2.0,
73043: 3.0,
73044: 4.0,
73045: 5.0,
73046: 6.0,
73047: 7.0,
73048: 8.0,
73049: 9.0,
73120: 0.0,
73121: 1.0,
73122: 2.0,
73123: 3.0,
73124: 4.0,
73125: 5.0,
73126: 6.0,
73127: 7.0,
73128: 8.0,
73129: 9.0,
74802: 216000.0,
74803: 432000.0,
74838: 2.0,
74839: 3.0,
74842: 1.0 / 3.0,
74843: 2.0 / 3.0,
74844: 5.0 / 6.0,
74845: 1.0 / 3.0,
74846: 2.0 / 3.0,
74847: 1.0 / 8.0,
74848: 1.0 / 4.0,
74849: 1.0 / 6.0,
74850: 1.0 / 4.0,
74851: 1.0 / 4.0,
74852: 1.0 / 2.0,
74853: 1.0 / 3.0,
74854: 2.0 / 3.0,
74855: 40.0,
74856: 50.0,
74857: 4.0,
74858: 5.0,
74859: 6.0,
74860: 7.0,
74861: 8.0,
74862: 9.0,
92768: 0.0,
92769: 1.0,
92770: 2.0,
92771: 3.0,
92772: 4.0,
92773: 5.0,
92774: 6.0,
92775: 7.0,
92776: 8.0,
92777: 9.0,
93008: 0.0,
93009: 1.0,
93010: 2.0,
93011: 3.0,
93012: 4.0,
93013: 5.0,
93014: 6.0,
93015: 7.0,
93016: 8.0,
93017: 9.0,
93019: 10.0,
93020: 100.0,
93021: 10000.0,
93022: 1000000.0,
93023: 100000000.0,
93024: 10000000000.0,
93025: 1000000000000.0,
93824: 0.0,
93825: 1.0,
93826: 2.0,
93827: 3.0,
93828: 4.0,
93829: 5.0,
93830: 6.0,
93831: 7.0,
93832: 8.0,
93833: 9.0,
93834: 10.0,
93835: 11.0,
93836: 12.0,
93837: 13.0,
93838: 14.0,
93839: 15.0,
93840: 16.0,
93841: 17.0,
93842: 18.0,
93843: 19.0,
93844: 1.0,
93845: 2.0,
93846: 3.0,
119520: 0.0,
119521: 1.0,
119522: 2.0,
119523: 3.0,
119524: 4.0,
119525: 5.0,
119526: 6.0,
119527: 7.0,
119528: 8.0,
119529: 9.0,
119530: 10.0,
119531: 11.0,
119532: 12.0,
119533: 13.0,
119534: 14.0,
119535: 15.0,
119536: 16.0,
119537: 17.0,
119538: 18.0,
119539: 19.0,
119666: 1.0,
119667: 2.0,
119668: 3.0,
119669: 4.0,
119670: 5.0,
119671: 1.0,
119672: 5.0,
125127: 1.0,
125128: 2.0,
125129: 3.0,
125130: 4.0,
125131: 5.0,
125132: 6.0,
125133: 7.0,
125134: 8.0,
125135: 9.0,
125264: 0.0,
125265: 1.0,
125266: 2.0,
125267: 3.0,
125268: 4.0,
125269: 5.0,
125270: 6.0,
125271: 7.0,
125272: 8.0,
125273: 9.0,
126065: 1.0,
126066: 2.0,
126067: 3.0,
126068: 4.0,
126069: 5.0,
126070: 6.0,
126071: 7.0,
126072: 8.0,
126073: 9.0,
126074: 10.0,
126075: 20.0,
126076: 30.0,
126077: 40.0,
126078: 50.0,
126079: 60.0,
126080: 70.0,
126081: 80.0,
126082: 90.0,
126083: 100.0,
126084: 200.0,
126085: 300.0,
126086: 400.0,
126087: 500.0,
126088: 600.0,
126089: 700.0,
126090: 800.0,
126091: 900.0,
126092: 1000.0,
126093: 2000.0,
126094: 3000.0,
126095: 4000.0,
126096: 5000.0,
126097: 6000.0,
126098: 7000.0,
126099: 8000.0,
126100: 9000.0,
126101: 10000.0,
126102: 20000.0,
126103: 30000.0,
126104: 40000.0,
126105: 50000.0,
126106: 60000.0,
126107: 70000.0,
126108: 80000.0,
126109: 90000.0,
126110: 100000.0,
126111: 200000.0,
126112: 100000.0,
126113: 10000000.0,
126114: 20000000.0,
126115: 1.0,
126116: 2.0,
126117: 3.0,
126118: 4.0,
126119: 5.0,
126120: 6.0,
126121: 7.0,
126122: 8.0,
126123: 9.0,
126125: 1.0 / 4.0,
126126: 1.0 / 2.0,
126127: 3.0 / 4.0,
126129: 1.0,
126130: 2.0,
126131: 10000.0,
126132: 100000.0,
127243: 0.0,
127244: 0.0,
}

_numeric_corrected = {
}

def decimal(code):
    try:
        return _decimal[code]
    except KeyError:
        if base_mod is not None and code not in _decimal_corrected:
            return base_mod._decimal[code]
        else:
            raise

def digit(code):
    try:
        return _digit[code]
    except KeyError:
        if base_mod is not None and code not in _digit_corrected:
            return base_mod._digit[code]
        else:
            raise

def numeric(code):
    try:
        return _numeric[code]
    except KeyError:
        if base_mod is not None and code not in _numeric_corrected:
            return base_mod._numeric[code]
        else:
            raise

_toupper = {
604: 42923,
609: 42924,
613: 42893,
614: 42922,
618: 42926,
620: 42925,
647: 42929,
669: 42930,
670: 42928,
1011: 895,
1319: 1318,
1321: 1320,
1323: 1322,
1325: 1324,
1327: 1326,
4304: 7312,
4305: 7313,
4306: 7314,
4307: 7315,
4308: 7316,
4309: 7317,
4310: 7318,
4311: 7319,
4312: 7320,
4313: 7321,
4314: 7322,
4315: 7323,
4316: 7324,
4317: 7325,
4318: 7326,
4319: 7327,
4320: 7328,
4321: 7329,
4322: 7330,
4323: 7331,
4324: 7332,
4325: 7333,
4326: 7334,
4327: 7335,
4328: 7336,
4329: 7337,
4330: 7338,
4331: 7339,
4332: 7340,
4333: 7341,
4334: 7342,
4335: 7343,
4336: 7344,
4337: 7345,
4338: 7346,
4339: 7347,
4340: 7348,
4341: 7349,
4342: 7350,
4343: 7351,
4344: 7352,
4345: 7353,
4346: 7354,
4349: 7357,
4350: 7358,
4351: 7359,
5112: 5104,
5113: 5105,
5114: 5106,
5115: 5107,
5116: 5108,
5117: 5109,
7296: 1042,
7297: 1044,
7298: 1054,
7299: 1057,
7300: 1058,
7301: 1058,
7302: 1066,
7303: 1122,
7304: 42570,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42649: 42648,
42651: 42650,
42897: 42896,
42899: 42898,
42903: 42902,
42905: 42904,
42907: 42906,
42909: 42908,
42911: 42910,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
42933: 42932,
42935: 42934,
42937: 42936,
43859: 42931,
43888: 5024,
43889: 5025,
43890: 5026,
43891: 5027,
43892: 5028,
43893: 5029,
43894: 5030,
43895: 5031,
43896: 5032,
43897: 5033,
43898: 5034,
43899: 5035,
43900: 5036,
43901: 5037,
43902: 5038,
43903: 5039,
43904: 5040,
43905: 5041,
43906: 5042,
43907: 5043,
43908: 5044,
43909: 5045,
43910: 5046,
43911: 5047,
43912: 5048,
43913: 5049,
43914: 5050,
43915: 5051,
43916: 5052,
43917: 5053,
43918: 5054,
43919: 5055,
43920: 5056,
43921: 5057,
43922: 5058,
43923: 5059,
43924: 5060,
43925: 5061,
43926: 5062,
43927: 5063,
43928: 5064,
43929: 5065,
43930: 5066,
43931: 5067,
43932: 5068,
43933: 5069,
43934: 5070,
43935: 5071,
43936: 5072,
43937: 5073,
43938: 5074,
43939: 5075,
43940: 5076,
43941: 5077,
43942: 5078,
43943: 5079,
43944: 5080,
43945: 5081,
43946: 5082,
43947: 5083,
43948: 5084,
43949: 5085,
43950: 5086,
43951: 5087,
43952: 5088,
43953: 5089,
43954: 5090,
43955: 5091,
43956: 5092,
43957: 5093,
43958: 5094,
43959: 5095,
43960: 5096,
43961: 5097,
43962: 5098,
43963: 5099,
43964: 5100,
43965: 5101,
43966: 5102,
43967: 5103,
66776: 66736,
66777: 66737,
66778: 66738,
66779: 66739,
66780: 66740,
66781: 66741,
66782: 66742,
66783: 66743,
66784: 66744,
66785: 66745,
66786: 66746,
66787: 66747,
66788: 66748,
66789: 66749,
66790: 66750,
66791: 66751,
66792: 66752,
66793: 66753,
66794: 66754,
66795: 66755,
66796: 66756,
66797: 66757,
66798: 66758,
66799: 66759,
66800: 66760,
66801: 66761,
66802: 66762,
66803: 66763,
66804: 66764,
66805: 66765,
66806: 66766,
66807: 66767,
66808: 66768,
66809: 66769,
66810: 66770,
66811: 66771,
68800: 68736,
68801: 68737,
68802: 68738,
68803: 68739,
68804: 68740,
68805: 68741,
68806: 68742,
68807: 68743,
68808: 68744,
68809: 68745,
68810: 68746,
68811: 68747,
68812: 68748,
68813: 68749,
68814: 68750,
68815: 68751,
68816: 68752,
68817: 68753,
68818: 68754,
68819: 68755,
68820: 68756,
68821: 68757,
68822: 68758,
68823: 68759,
68824: 68760,
68825: 68761,
68826: 68762,
68827: 68763,
68828: 68764,
68829: 68765,
68830: 68766,
68831: 68767,
68832: 68768,
68833: 68769,
68834: 68770,
68835: 68771,
68836: 68772,
68837: 68773,
68838: 68774,
68839: 68775,
68840: 68776,
68841: 68777,
68842: 68778,
68843: 68779,
68844: 68780,
68845: 68781,
68846: 68782,
68847: 68783,
68848: 68784,
68849: 68785,
68850: 68786,
71872: 71840,
71873: 71841,
71874: 71842,
71875: 71843,
71876: 71844,
71877: 71845,
71878: 71846,
71879: 71847,
71880: 71848,
71881: 71849,
71882: 71850,
71883: 71851,
71884: 71852,
71885: 71853,
71886: 71854,
71887: 71855,
71888: 71856,
71889: 71857,
71890: 71858,
71891: 71859,
71892: 71860,
71893: 71861,
71894: 71862,
71895: 71863,
71896: 71864,
71897: 71865,
71898: 71866,
71899: 71867,
71900: 71868,
71901: 71869,
71902: 71870,
71903: 71871,
93792: 93760,
93793: 93761,
93794: 93762,
93795: 93763,
93796: 93764,
93797: 93765,
93798: 93766,
93799: 93767,
93800: 93768,
93801: 93769,
93802: 93770,
93803: 93771,
93804: 93772,
93805: 93773,
93806: 93774,
93807: 93775,
93808: 93776,
93809: 93777,
93810: 93778,
93811: 93779,
93812: 93780,
93813: 93781,
93814: 93782,
93815: 93783,
93816: 93784,
93817: 93785,
93818: 93786,
93819: 93787,
93820: 93788,
93821: 93789,
93822: 93790,
93823: 93791,
125218: 125184,
125219: 125185,
125220: 125186,
125221: 125187,
125222: 125188,
125223: 125189,
125224: 125190,
125225: 125191,
125226: 125192,
125227: 125193,
125228: 125194,
125229: 125195,
125230: 125196,
125231: 125197,
125232: 125198,
125233: 125199,
125234: 125200,
125235: 125201,
125236: 125202,
125237: 125203,
125238: 125204,
125239: 125205,
125240: 125206,
125241: 125207,
125242: 125208,
125243: 125209,
125244: 125210,
125245: 125211,
125246: 125212,
125247: 125213,
125248: 125214,
125249: 125215,
125250: 125216,
125251: 125217,
}

_toupper_corrected = {
}
_tolower = {
895: 1011,
1318: 1319,
1320: 1321,
1322: 1323,
1324: 1325,
1326: 1327,
4295: 11559,
4301: 11565,
5024: 43888,
5025: 43889,
5026: 43890,
5027: 43891,
5028: 43892,
5029: 43893,
5030: 43894,
5031: 43895,
5032: 43896,
5033: 43897,
5034: 43898,
5035: 43899,
5036: 43900,
5037: 43901,
5038: 43902,
5039: 43903,
5040: 43904,
5041: 43905,
5042: 43906,
5043: 43907,
5044: 43908,
5045: 43909,
5046: 43910,
5047: 43911,
5048: 43912,
5049: 43913,
5050: 43914,
5051: 43915,
5052: 43916,
5053: 43917,
5054: 43918,
5055: 43919,
5056: 43920,
5057: 43921,
5058: 43922,
5059: 43923,
5060: 43924,
5061: 43925,
5062: 43926,
5063: 43927,
5064: 43928,
5065: 43929,
5066: 43930,
5067: 43931,
5068: 43932,
5069: 43933,
5070: 43934,
5071: 43935,
5072: 43936,
5073: 43937,
5074: 43938,
5075: 43939,
5076: 43940,
5077: 43941,
5078: 43942,
5079: 43943,
5080: 43944,
5081: 43945,
5082: 43946,
5083: 43947,
5084: 43948,
5085: 43949,
5086: 43950,
5087: 43951,
5088: 43952,
5089: 43953,
5090: 43954,
5091: 43955,
5092: 43956,
5093: 43957,
5094: 43958,
5095: 43959,
5096: 43960,
5097: 43961,
5098: 43962,
5099: 43963,
5100: 43964,
5101: 43965,
5102: 43966,
5103: 43967,
5104: 5112,
5105: 5113,
5106: 5114,
5107: 5115,
5108: 5116,
5109: 5117,
7312: 4304,
7313: 4305,
7314: 4306,
7315: 4307,
7316: 4308,
7317: 4309,
7318: 4310,
7319: 4311,
7320: 4312,
7321: 4313,
7322: 4314,
7323: 4315,
7324: 4316,
7325: 4317,
7326: 4318,
7327: 4319,
7328: 4320,
7329: 4321,
7330: 4322,
7331: 4323,
7332: 4324,
7333: 4325,
7334: 4326,
7335: 4327,
7336: 4328,
7337: 4329,
7338: 4330,
7339: 4331,
7340: 4332,
7341: 4333,
7342: 4334,
7343: 4335,
7344: 4336,
7345: 4337,
7346: 4338,
7347: 4339,
7348: 4340,
7349: 4341,
7350: 4342,
7351: 4343,
7352: 4344,
7353: 4345,
7354: 4346,
7357: 4349,
7358: 4350,
7359: 4351,
11506: 11507,
42592: 42593,
42648: 42649,
42650: 42651,
42893: 613,
42896: 42897,
42898: 42899,
42902: 42903,
42904: 42905,
42906: 42907,
42908: 42909,
42910: 42911,
42912: 42913,
42914: 42915,
42916: 42917,
42918: 42919,
42920: 42921,
42922: 614,
42923: 604,
42924: 609,
42925: 620,
42926: 618,
42928: 670,
42929: 647,
42930: 669,
42931: 43859,
42932: 42933,
42934: 42935,
42936: 42937,
66736: 66776,
66737: 66777,
66738: 66778,
66739: 66779,
66740: 66780,
66741: 66781,
66742: 66782,
66743: 66783,
66744: 66784,
66745: 66785,
66746: 66786,
66747: 66787,
66748: 66788,
66749: 66789,
66750: 66790,
66751: 66791,
66752: 66792,
66753: 66793,
66754: 66794,
66755: 66795,
66756: 66796,
66757: 66797,
66758: 66798,
66759: 66799,
66760: 66800,
66761: 66801,
66762: 66802,
66763: 66803,
66764: 66804,
66765: 66805,
66766: 66806,
66767: 66807,
66768: 66808,
66769: 66809,
66770: 66810,
66771: 66811,
68736: 68800,
68737: 68801,
68738: 68802,
68739: 68803,
68740: 68804,
68741: 68805,
68742: 68806,
68743: 68807,
68744: 68808,
68745: 68809,
68746: 68810,
68747: 68811,
68748: 68812,
68749: 68813,
68750: 68814,
68751: 68815,
68752: 68816,
68753: 68817,
68754: 68818,
68755: 68819,
68756: 68820,
68757: 68821,
68758: 68822,
68759: 68823,
68760: 68824,
68761: 68825,
68762: 68826,
68763: 68827,
68764: 68828,
68765: 68829,
68766: 68830,
68767: 68831,
68768: 68832,
68769: 68833,
68770: 68834,
68771: 68835,
68772: 68836,
68773: 68837,
68774: 68838,
68775: 68839,
68776: 68840,
68777: 68841,
68778: 68842,
68779: 68843,
68780: 68844,
68781: 68845,
68782: 68846,
68783: 68847,
68784: 68848,
68785: 68849,
68786: 68850,
71840: 71872,
71841: 71873,
71842: 71874,
71843: 71875,
71844: 71876,
71845: 71877,
71846: 71878,
71847: 71879,
71848: 71880,
71849: 71881,
71850: 71882,
71851: 71883,
71852: 71884,
71853: 71885,
71854: 71886,
71855: 71887,
71856: 71888,
71857: 71889,
71858: 71890,
71859: 71891,
71860: 71892,
71861: 71893,
71862: 71894,
71863: 71895,
71864: 71896,
71865: 71897,
71866: 71898,
71867: 71899,
71868: 71900,
71869: 71901,
71870: 71902,
71871: 71903,
93760: 93792,
93761: 93793,
93762: 93794,
93763: 93795,
93764: 93796,
93765: 93797,
93766: 93798,
93767: 93799,
93768: 93800,
93769: 93801,
93770: 93802,
93771: 93803,
93772: 93804,
93773: 93805,
93774: 93806,
93775: 93807,
93776: 93808,
93777: 93809,
93778: 93810,
93779: 93811,
93780: 93812,
93781: 93813,
93782: 93814,
93783: 93815,
93784: 93816,
93785: 93817,
93786: 93818,
93787: 93819,
93788: 93820,
93789: 93821,
93790: 93822,
93791: 93823,
125184: 125218,
125185: 125219,
125186: 125220,
125187: 125221,
125188: 125222,
125189: 125223,
125190: 125224,
125191: 125225,
125192: 125226,
125193: 125227,
125194: 125228,
125195: 125229,
125196: 125230,
125197: 125231,
125198: 125232,
125199: 125233,
125200: 125234,
125201: 125235,
125202: 125236,
125203: 125237,
125204: 125238,
125205: 125239,
125206: 125240,
125207: 125241,
125208: 125242,
125209: 125243,
125210: 125244,
125211: 125245,
125212: 125246,
125213: 125247,
125214: 125248,
125215: 125249,
125216: 125250,
125217: 125251,
}

_tolower_corrected = {
}
_totitle = {
604: 42923,
609: 42924,
613: 42893,
614: 42922,
618: 42926,
620: 42925,
647: 42929,
669: 42930,
670: 42928,
1011: 895,
1319: 1318,
1321: 1320,
1323: 1322,
1325: 1324,
1327: 1326,
4304: 4304,
4305: 4305,
4306: 4306,
4307: 4307,
4308: 4308,
4309: 4309,
4310: 4310,
4311: 4311,
4312: 4312,
4313: 4313,
4314: 4314,
4315: 4315,
4316: 4316,
4317: 4317,
4318: 4318,
4319: 4319,
4320: 4320,
4321: 4321,
4322: 4322,
4323: 4323,
4324: 4324,
4325: 4325,
4326: 4326,
4327: 4327,
4328: 4328,
4329: 4329,
4330: 4330,
4331: 4331,
4332: 4332,
4333: 4333,
4334: 4334,
4335: 4335,
4336: 4336,
4337: 4337,
4338: 4338,
4339: 4339,
4340: 4340,
4341: 4341,
4342: 4342,
4343: 4343,
4344: 4344,
4345: 4345,
4346: 4346,
4349: 4349,
4350: 4350,
4351: 4351,
5112: 5104,
5113: 5105,
5114: 5106,
5115: 5107,
5116: 5108,
5117: 5109,
7296: 1042,
7297: 1044,
7298: 1054,
7299: 1057,
7300: 1058,
7301: 1058,
7302: 1066,
7303: 1122,
7304: 42570,
11507: 11506,
11559: 4295,
11565: 4301,
42593: 42592,
42649: 42648,
42651: 42650,
42897: 42896,
42899: 42898,
42903: 42902,
42905: 42904,
42907: 42906,
42909: 42908,
42911: 42910,
42913: 42912,
42915: 42914,
42917: 42916,
42919: 42918,
42921: 42920,
42933: 42932,
42935: 42934,
42937: 42936,
43859: 42931,
43888: 5024,
43889: 5025,
43890: 5026,
43891: 5027,
43892: 5028,
43893: 5029,
43894: 5030,
43895: 5031,
43896: 5032,
43897: 5033,
43898: 5034,
43899: 5035,
43900: 5036,
43901: 5037,
43902: 5038,
43903: 5039,
43904: 5040,
43905: 5041,
43906: 5042,
43907: 5043,
43908: 5044,
43909: 5045,
43910: 5046,
43911: 5047,
43912: 5048,
43913: 5049,
43914: 5050,
43915: 5051,
43916: 5052,
43917: 5053,
43918: 5054,
43919: 5055,
43920: 5056,
43921: 5057,
43922: 5058,
43923: 5059,
43924: 5060,
43925: 5061,
43926: 5062,
43927: 5063,
43928: 5064,
43929: 5065,
43930: 5066,
43931: 5067,
43932: 5068,
43933: 5069,
43934: 5070,
43935: 5071,
43936: 5072,
43937: 5073,
43938: 5074,
43939: 5075,
43940: 5076,
43941: 5077,
43942: 5078,
43943: 5079,
43944: 5080,
43945: 5081,
43946: 5082,
43947: 5083,
43948: 5084,
43949: 5085,
43950: 5086,
43951: 5087,
43952: 5088,
43953: 5089,
43954: 5090,
43955: 5091,
43956: 5092,
43957: 5093,
43958: 5094,
43959: 5095,
43960: 5096,
43961: 5097,
43962: 5098,
43963: 5099,
43964: 5100,
43965: 5101,
43966: 5102,
43967: 5103,
66776: 66736,
66777: 66737,
66778: 66738,
66779: 66739,
66780: 66740,
66781: 66741,
66782: 66742,
66783: 66743,
66784: 66744,
66785: 66745,
66786: 66746,
66787: 66747,
66788: 66748,
66789: 66749,
66790: 66750,
66791: 66751,
66792: 66752,
66793: 66753,
66794: 66754,
66795: 66755,
66796: 66756,
66797: 66757,
66798: 66758,
66799: 66759,
66800: 66760,
66801: 66761,
66802: 66762,
66803: 66763,
66804: 66764,
66805: 66765,
66806: 66766,
66807: 66767,
66808: 66768,
66809: 66769,
66810: 66770,
66811: 66771,
68800: 68736,
68801: 68737,
68802: 68738,
68803: 68739,
68804: 68740,
68805: 68741,
68806: 68742,
68807: 68743,
68808: 68744,
68809: 68745,
68810: 68746,
68811: 68747,
68812: 68748,
68813: 68749,
68814: 68750,
68815: 68751,
68816: 68752,
68817: 68753,
68818: 68754,
68819: 68755,
68820: 68756,
68821: 68757,
68822: 68758,
68823: 68759,
68824: 68760,
68825: 68761,
68826: 68762,
68827: 68763,
68828: 68764,
68829: 68765,
68830: 68766,
68831: 68767,
68832: 68768,
68833: 68769,
68834: 68770,
68835: 68771,
68836: 68772,
68837: 68773,
68838: 68774,
68839: 68775,
68840: 68776,
68841: 68777,
68842: 68778,
68843: 68779,
68844: 68780,
68845: 68781,
68846: 68782,
68847: 68783,
68848: 68784,
68849: 68785,
68850: 68786,
71872: 71840,
71873: 71841,
71874: 71842,
71875: 71843,
71876: 71844,
71877: 71845,
71878: 71846,
71879: 71847,
71880: 71848,
71881: 71849,
71882: 71850,
71883: 71851,
71884: 71852,
71885: 71853,
71886: 71854,
71887: 71855,
71888: 71856,
71889: 71857,
71890: 71858,
71891: 71859,
71892: 71860,
71893: 71861,
71894: 71862,
71895: 71863,
71896: 71864,
71897: 71865,
71898: 71866,
71899: 71867,
71900: 71868,
71901: 71869,
71902: 71870,
71903: 71871,
93792: 93760,
93793: 93761,
93794: 93762,
93795: 93763,
93796: 93764,
93797: 93765,
93798: 93766,
93799: 93767,
93800: 93768,
93801: 93769,
93802: 93770,
93803: 93771,
93804: 93772,
93805: 93773,
93806: 93774,
93807: 93775,
93808: 93776,
93809: 93777,
93810: 93778,
93811: 93779,
93812: 93780,
93813: 93781,
93814: 93782,
93815: 93783,
93816: 93784,
93817: 93785,
93818: 93786,
93819: 93787,
93820: 93788,
93821: 93789,
93822: 93790,
93823: 93791,
125218: 125184,
125219: 125185,
125220: 125186,
125221: 125187,
125222: 125188,
125223: 125189,
125224: 125190,
125225: 125191,
125226: 125192,
125227: 125193,
125228: 125194,
125229: 125195,
125230: 125196,
125231: 125197,
125232: 125198,
125233: 125199,
125234: 125200,
125235: 125201,
125236: 125202,
125237: 125203,
125238: 125204,
125239: 125205,
125240: 125206,
125241: 125207,
125242: 125208,
125243: 125209,
125244: 125210,
125245: 125211,
125246: 125212,
125247: 125213,
125248: 125214,
125249: 125215,
125250: 125216,
125251: 125217,
}

_totitle_corrected = {
}
_special_casing = {
}

_special_casing_corrected = {
}

def toupper(code):
    try:
        return _toupper[code]
    except KeyError:
        if base_mod is not None and code not in _toupper_corrected:
            return base_mod._toupper.get(code, code)
        else:
            return code

def tolower(code):
    try:
        return _tolower[code]
    except KeyError:
        if base_mod is not None and code not in _tolower_corrected:
            return base_mod._tolower.get(code, code)
        else:
            return code

def totitle(code):
    try:
        return _totitle[code]
    except KeyError:
        if base_mod is not None and code not in _totitle_corrected:
            return base_mod._totitle.get(code, code)
        else:
            return code

def toupper_full(code):
    try:
        return _special_casing[code][2]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][2]
            except KeyError:
                pass
    return [toupper(code)]

def tolower_full(code):
    try:
        return _special_casing[code][0]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][0]
            except KeyError:
                pass
    return [tolower(code)]

def totitle_full(code):
    try:
        return _special_casing[code][1]
    except KeyError:
        if base_mod is not None and code not in _special_casing_corrected:
            try:
                return base_mod._special_casing[code][1]
            except KeyError:
                pass
    return [totitle(code)]

_raw_decomposition = {
8341: '<sub> 0068',
8342: '<sub> 006B',
8343: '<sub> 006C',
8344: '<sub> 006D',
8345: '<sub> 006E',
8346: '<sub> 0070',
8347: '<sub> 0073',
8348: '<sub> 0074',
42652: '<super> 044A',
42653: '<super> 044C',
43000: '<super> 0126',
43001: '<super> 0153',
43868: '<super> A727',
43869: '<super> AB37',
43870: '<super> 026B',
43871: '<super> AB52',
64046: '90DE',
64047: '96B7',
69934: '11131 11127',
69935: '11132 11127',
70475: '11347 1133E',
70476: '11347 11357',
70843: '114B9 114BA',
70844: '114B9 114B0',
70846: '114B9 114BD',
71098: '115B8 115AF',
71099: '115B9 115AF',
126464: '<font> 0627',
126465: '<font> 0628',
126466: '<font> 062C',
126467: '<font> 062F',
126469: '<font> 0648',
126470: '<font> 0632',
126471: '<font> 062D',
126472: '<font> 0637',
126473: '<font> 064A',
126474: '<font> 0643',
126475: '<font> 0644',
126476: '<font> 0645',
126477: '<font> 0646',
126478: '<font> 0633',
126479: '<font> 0639',
126480: '<font> 0641',
126481: '<font> 0635',
126482: '<font> 0642',
126483: '<font> 0631',
126484: '<font> 0634',
126485: '<font> 062A',
126486: '<font> 062B',
126487: '<font> 062E',
126488: '<font> 0630',
126489: '<font> 0636',
126490: '<font> 0638',
126491: '<font> 063A',
126492: '<font> 066E',
126493: '<font> 06BA',
126494: '<font> 06A1',
126495: '<font> 066F',
126497: '<font> 0628',
126498: '<font> 062C',
126500: '<font> 0647',
126503: '<font> 062D',
126505: '<font> 064A',
126506: '<font> 0643',
126507: '<font> 0644',
126508: '<font> 0645',
126509: '<font> 0646',
126510: '<font> 0633',
126511: '<font> 0639',
126512: '<font> 0641',
126513: '<font> 0635',
126514: '<font> 0642',
126516: '<font> 0634',
126517: '<font> 062A',
126518: '<font> 062B',
126519: '<font> 062E',
126521: '<font> 0636',
126523: '<font> 063A',
126530: '<font> 062C',
126535: '<font> 062D',
126537: '<font> 064A',
126539: '<font> 0644',
126541: '<font> 0646',
126542: '<font> 0633',
126543: '<font> 0639',
126545: '<font> 0635',
126546: '<font> 0642',
126548: '<font> 0634',
126551: '<font> 062E',
126553: '<font> 0636',
126555: '<font> 063A',
126557: '<font> 06BA',
126559: '<font> 066F',
126561: '<font> 0628',
126562: '<font> 062C',
126564: '<font> 0647',
126567: '<font> 062D',
126568: '<font> 0637',
126569: '<font> 064A',
126570: '<font> 0643',
126572: '<font> 0645',
126573: '<font> 0646',
126574: '<font> 0633',
126575: '<font> 0639',
126576: '<font> 0641',
126577: '<font> 0635',
126578: '<font> 0642',
126580: '<font> 0634',
126581: '<font> 062A',
126582: '<font> 062B',
126583: '<font> 062E',
126585: '<font> 0636',
126586: '<font> 0638',
126587: '<font> 063A',
126588: '<font> 066E',
126590: '<font> 06A1',
126592: '<font> 0627',
126593: '<font> 0628',
126594: '<font> 062C',
126595: '<font> 062F',
126596: '<font> 0647',
126597: '<font> 0648',
126598: '<font> 0632',
126599: '<font> 062D',
126600: '<font> 0637',
126601: '<font> 064A',
126603: '<font> 0644',
126604: '<font> 0645',
126605: '<font> 0646',
126606: '<font> 0633',
126607: '<font> 0639',
126608: '<font> 0641',
126609: '<font> 0635',
126610: '<font> 0642',
126611: '<font> 0631',
126612: '<font> 0634',
126613: '<font> 062A',
126614: '<font> 062B',
126615: '<font> 062E',
126616: '<font> 0630',
126617: '<font> 0636',
126618: '<font> 0638',
126619: '<font> 063A',
126625: '<font> 0628',
126626: '<font> 062C',
126627: '<font> 062F',
126629: '<font> 0648',
126630: '<font> 0632',
126631: '<font> 062D',
126632: '<font> 0637',
126633: '<font> 064A',
126635: '<font> 0644',
126636: '<font> 0645',
126637: '<font> 0646',
126638: '<font> 0633',
126639: '<font> 0639',
126640: '<font> 0641',
126641: '<font> 0635',
126642: '<font> 0642',
126643: '<font> 0631',
126644: '<font> 0634',
126645: '<font> 062A',
126646: '<font> 062B',
126647: '<font> 062E',
126648: '<font> 0630',
126649: '<font> 0636',
126650: '<font> 0638',
126651: '<font> 063A',
127280: '<square> 0041',
127282: '<square> 0043',
127283: '<square> 0044',
127284: '<square> 0045',
127285: '<square> 0046',
127286: '<square> 0047',
127287: '<square> 0048',
127288: '<square> 0049',
127289: '<square> 004A',
127290: '<square> 004B',
127291: '<square> 004C',
127292: '<square> 004D',
127294: '<square> 004F',
127296: '<square> 0051',
127297: '<square> 0052',
127299: '<square> 0054',
127300: '<square> 0055',
127301: '<square> 0056',
127303: '<square> 0058',
127304: '<square> 0059',
127305: '<square> 005A',
127311: '<square> 0057 0043',
127338: '<super> 004D 0043',
127339: '<super> 004D 0044',
127489: '<square> 30B3 30B3',
127490: '<square> 30B5',
127538: '<square> 7981',
127539: '<square> 7A7A',
127540: '<square> 5408',
127541: '<square> 6E80',
127542: '<square> 6709',
127543: '<square> 6708',
127544: '<square> 7533',
127545: '<square> 5272',
127546: '<square> 55B6',
127547: '<square> 914D',
127568: '<circle> 5F97',
127569: '<circle> 53EF',
}

_raw_decomposition_corrected = {
}

def decomposition(code):
    try:
        return _raw_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _raw_decomposition_corrected:
            return base_mod._raw_decomposition.get(code, '')
        else:
            return ''

_composition = {
r_longlong(   65 << 32 |   768):   192,
r_longlong(   65 << 32 |   769):   193,
r_longlong(   65 << 32 |   770):   194,
r_longlong(   65 << 32 |   771):   195,
r_longlong(   65 << 32 |   776):   196,
r_longlong(   65 << 32 |   778):   197,
r_longlong(   67 << 32 |   807):   199,
r_longlong(   69 << 32 |   768):   200,
r_longlong(   69 << 32 |   769):   201,
r_longlong(   69 << 32 |   770):   202,
r_longlong(   69 << 32 |   776):   203,
r_longlong(   73 << 32 |   768):   204,
r_longlong(   73 << 32 |   769):   205,
r_longlong(   73 << 32 |   770):   206,
r_longlong(   73 << 32 |   776):   207,
r_longlong(   78 << 32 |   771):   209,
r_longlong(   79 << 32 |   768):   210,
r_longlong(   79 << 32 |   769):   211,
r_longlong(   79 << 32 |   770):   212,
r_longlong(   79 << 32 |   771):   213,
r_longlong(   79 << 32 |   776):   214,
r_longlong(   85 << 32 |   768):   217,
r_longlong(   85 << 32 |   769):   218,
r_longlong(   85 << 32 |   770):   219,
r_longlong(   85 << 32 |   776):   220,
r_longlong(   89 << 32 |   769):   221,
r_longlong(   97 << 32 |   768):   224,
r_longlong(   97 << 32 |   769):   225,
r_longlong(   97 << 32 |   770):   226,
r_longlong(   97 << 32 |   771):   227,
r_longlong(   97 << 32 |   776):   228,
r_longlong(   97 << 32 |   778):   229,
r_longlong(   99 << 32 |   807):   231,
r_longlong(  101 << 32 |   768):   232,
r_longlong(  101 << 32 |   769):   233,
r_longlong(  101 << 32 |   770):   234,
r_longlong(  101 << 32 |   776):   235,
r_longlong(  105 << 32 |   768):   236,
r_longlong(  105 << 32 |   769):   237,
r_longlong(  105 << 32 |   770):   238,
r_longlong(  105 << 32 |   776):   239,
r_longlong(  110 << 32 |   771):   241,
r_longlong(  111 << 32 |   768):   242,
r_longlong(  111 << 32 |   769):   243,
r_longlong(  111 << 32 |   770):   244,
r_longlong(  111 << 32 |   771):   245,
r_longlong(  111 << 32 |   776):   246,
r_longlong(  117 << 32 |   768):   249,
r_longlong(  117 << 32 |   769):   250,
r_longlong(  117 << 32 |   770):   251,
r_longlong(  117 << 32 |   776):   252,
r_longlong(  121 << 32 |   769):   253,
r_longlong(  121 << 32 |   776):   255,
r_longlong(   65 << 32 |   772):   256,
r_longlong(   97 << 32 |   772):   257,
r_longlong(   65 << 32 |   774):   258,
r_longlong(   97 << 32 |   774):   259,
r_longlong(   65 << 32 |   808):   260,
r_longlong(   97 << 32 |   808):   261,
r_longlong(   67 << 32 |   769):   262,
r_longlong(   99 << 32 |   769):   263,
r_longlong(   67 << 32 |   770):   264,
r_longlong(   99 << 32 |   770):   265,
r_longlong(   67 << 32 |   775):   266,
r_longlong(   99 << 32 |   775):   267,
r_longlong(   67 << 32 |   780):   268,
r_longlong(   99 << 32 |   780):   269,
r_longlong(   68 << 32 |   780):   270,
r_longlong(  100 << 32 |   780):   271,
r_longlong(   69 << 32 |   772):   274,
r_longlong(  101 << 32 |   772):   275,
r_longlong(   69 << 32 |   774):   276,
r_longlong(  101 << 32 |   774):   277,
r_longlong(   69 << 32 |   775):   278,
r_longlong(  101 << 32 |   775):   279,
r_longlong(   69 << 32 |   808):   280,
r_longlong(  101 << 32 |   808):   281,
r_longlong(   69 << 32 |   780):   282,
r_longlong(  101 << 32 |   780):   283,
r_longlong(   71 << 32 |   770):   284,
r_longlong(  103 << 32 |   770):   285,
r_longlong(   71 << 32 |   774):   286,
r_longlong(  103 << 32 |   774):   287,
r_longlong(   71 << 32 |   775):   288,
r_longlong(  103 << 32 |   775):   289,
r_longlong(   71 << 32 |   807):   290,
r_longlong(  103 << 32 |   807):   291,
r_longlong(   72 << 32 |   770):   292,
r_longlong(  104 << 32 |   770):   293,
r_longlong(   73 << 32 |   771):   296,
r_longlong(  105 << 32 |   771):   297,
r_longlong(   73 << 32 |   772):   298,
r_longlong(  105 << 32 |   772):   299,
r_longlong(   73 << 32 |   774):   300,
r_longlong(  105 << 32 |   774):   301,
r_longlong(   73 << 32 |   808):   302,
r_longlong(  105 << 32 |   808):   303,
r_longlong(   73 << 32 |   775):   304,
r_longlong(   74 << 32 |   770):   308,
r_longlong(  106 << 32 |   770):   309,
r_longlong(   75 << 32 |   807):   310,
r_longlong(  107 << 32 |   807):   311,
r_longlong(   76 << 32 |   769):   313,
r_longlong(  108 << 32 |   769):   314,
r_longlong(   76 << 32 |   807):   315,
r_longlong(  108 << 32 |   807):   316,
r_longlong(   76 << 32 |   780):   317,
r_longlong(  108 << 32 |   780):   318,
r_longlong(   78 << 32 |   769):   323,
r_longlong(  110 << 32 |   769):   324,
r_longlong(   78 << 32 |   807):   325,
r_longlong(  110 << 32 |   807):   326,
r_longlong(   78 << 32 |   780):   327,
r_longlong(  110 << 32 |   780):   328,
r_longlong(   79 << 32 |   772):   332,
r_longlong(  111 << 32 |   772):   333,
r_longlong(   79 << 32 |   774):   334,
r_longlong(  111 << 32 |   774):   335,
r_longlong(   79 << 32 |   779):   336,
r_longlong(  111 << 32 |   779):   337,
r_longlong(   82 << 32 |   769):   340,
r_longlong(  114 << 32 |   769):   341,
r_longlong(   82 << 32 |   807):   342,
r_longlong(  114 << 32 |   807):   343,
r_longlong(   82 << 32 |   780):   344,
r_longlong(  114 << 32 |   780):   345,
r_longlong(   83 << 32 |   769):   346,
r_longlong(  115 << 32 |   769):   347,
r_longlong(   83 << 32 |   770):   348,
r_longlong(  115 << 32 |   770):   349,
r_longlong(   83 << 32 |   807):   350,
r_longlong(  115 << 32 |   807):   351,
r_longlong(   83 << 32 |   780):   352,
r_longlong(  115 << 32 |   780):   353,
r_longlong(   84 << 32 |   807):   354,
r_longlong(  116 << 32 |   807):   355,
r_longlong(   84 << 32 |   780):   356,
r_longlong(  116 << 32 |   780):   357,
r_longlong(   85 << 32 |   771):   360,
r_longlong(  117 << 32 |   771):   361,
r_longlong(   85 << 32 |   772):   362,
r_longlong(  117 << 32 |   772):   363,
r_longlong(   85 << 32 |   774):   364,
r_longlong(  117 << 32 |   774):   365,
r_longlong(   85 << 32 |   778):   366,
r_longlong(  117 << 32 |   778):   367,
r_longlong(   85 << 32 |   779):   368,
r_longlong(  117 << 32 |   779):   369,
r_longlong(   85 << 32 |   808):   370,
r_longlong(  117 << 32 |   808):   371,
r_longlong(   87 << 32 |   770):   372,
r_longlong(  119 << 32 |   770):   373,
r_longlong(   89 << 32 |   770):   374,
r_longlong(  121 << 32 |   770):   375,
r_longlong(   89 << 32 |   776):   376,
r_longlong(   90 << 32 |   769):   377,
r_longlong(  122 << 32 |   769):   378,
r_longlong(   90 << 32 |   775):   379,
r_longlong(  122 << 32 |   775):   380,
r_longlong(   90 << 32 |   780):   381,
r_longlong(  122 << 32 |   780):   382,
r_longlong(   79 << 32 |   795):   416,
r_longlong(  111 << 32 |   795):   417,
r_longlong(   85 << 32 |   795):   431,
r_longlong(  117 << 32 |   795):   432,
r_longlong(   65 << 32 |   780):   461,
r_longlong(   97 << 32 |   780):   462,
r_longlong(   73 << 32 |   780):   463,
r_longlong(  105 << 32 |   780):   464,
r_longlong(   79 << 32 |   780):   465,
r_longlong(  111 << 32 |   780):   466,
r_longlong(   85 << 32 |   780):   467,
r_longlong(  117 << 32 |   780):   468,
r_longlong(  220 << 32 |   772):   469,
r_longlong(  252 << 32 |   772):   470,
r_longlong(  220 << 32 |   769):   471,
r_longlong(  252 << 32 |   769):   472,
r_longlong(  220 << 32 |   780):   473,
r_longlong(  252 << 32 |   780):   474,
r_longlong(  220 << 32 |   768):   475,
r_longlong(  252 << 32 |   768):   476,
r_longlong(  196 << 32 |   772):   478,
r_longlong(  228 << 32 |   772):   479,
r_longlong(  550 << 32 |   772):   480,
r_longlong(  551 << 32 |   772):   481,
r_longlong(  198 << 32 |   772):   482,
r_longlong(  230 << 32 |   772):   483,
r_longlong(   71 << 32 |   780):   486,
r_longlong(  103 << 32 |   780):   487,
r_longlong(   75 << 32 |   780):   488,
r_longlong(  107 << 32 |   780):   489,
r_longlong(   79 << 32 |   808):   490,
r_longlong(  111 << 32 |   808):   491,
r_longlong(  490 << 32 |   772):   492,
r_longlong(  491 << 32 |   772):   493,
r_longlong(  439 << 32 |   780):   494,
r_longlong(  658 << 32 |   780):   495,
r_longlong(  106 << 32 |   780):   496,
r_longlong(   71 << 32 |   769):   500,
r_longlong(  103 << 32 |   769):   501,
r_longlong(   78 << 32 |   768):   504,
r_longlong(  110 << 32 |   768):   505,
r_longlong(  197 << 32 |   769):   506,
r_longlong(  229 << 32 |   769):   507,
r_longlong(  198 << 32 |   769):   508,
r_longlong(  230 << 32 |   769):   509,
r_longlong(  216 << 32 |   769):   510,
r_longlong(  248 << 32 |   769):   511,
r_longlong(   65 << 32 |   783):   512,
r_longlong(   97 << 32 |   783):   513,
r_longlong(   65 << 32 |   785):   514,
r_longlong(   97 << 32 |   785):   515,
r_longlong(   69 << 32 |   783):   516,
r_longlong(  101 << 32 |   783):   517,
r_longlong(   69 << 32 |   785):   518,
r_longlong(  101 << 32 |   785):   519,
r_longlong(   73 << 32 |   783):   520,
r_longlong(  105 << 32 |   783):   521,
r_longlong(   73 << 32 |   785):   522,
r_longlong(  105 << 32 |   785):   523,
r_longlong(   79 << 32 |   783):   524,
r_longlong(  111 << 32 |   783):   525,
r_longlong(   79 << 32 |   785):   526,
r_longlong(  111 << 32 |   785):   527,
r_longlong(   82 << 32 |   783):   528,
r_longlong(  114 << 32 |   783):   529,
r_longlong(   82 << 32 |   785):   530,
r_longlong(  114 << 32 |   785):   531,
r_longlong(   85 << 32 |   783):   532,
r_longlong(  117 << 32 |   783):   533,
r_longlong(   85 << 32 |   785):   534,
r_longlong(  117 << 32 |   785):   535,
r_longlong(   83 << 32 |   806):   536,
r_longlong(  115 << 32 |   806):   537,
r_longlong(   84 << 32 |   806):   538,
r_longlong(  116 << 32 |   806):   539,
r_longlong(   72 << 32 |   780):   542,
r_longlong(  104 << 32 |   780):   543,
r_longlong(   65 << 32 |   775):   550,
r_longlong(   97 << 32 |   775):   551,
r_longlong(   69 << 32 |   807):   552,
r_longlong(  101 << 32 |   807):   553,
r_longlong(  214 << 32 |   772):   554,
r_longlong(  246 << 32 |   772):   555,
r_longlong(  213 << 32 |   772):   556,
r_longlong(  245 << 32 |   772):   557,
r_longlong(   79 << 32 |   775):   558,
r_longlong(  111 << 32 |   775):   559,
r_longlong(  558 << 32 |   772):   560,
r_longlong(  559 << 32 |   772):   561,
r_longlong(   89 << 32 |   772):   562,
r_longlong(  121 << 32 |   772):   563,
r_longlong(  168 << 32 |   769):   901,
r_longlong(  913 << 32 |   769):   902,
r_longlong(  917 << 32 |   769):   904,
r_longlong(  919 << 32 |   769):   905,
r_longlong(  921 << 32 |   769):   906,
r_longlong(  927 << 32 |   769):   908,
r_longlong(  933 << 32 |   769):   910,
r_longlong(  937 << 32 |   769):   911,
r_longlong(  970 << 32 |   769):   912,
r_longlong(  921 << 32 |   776):   938,
r_longlong(  933 << 32 |   776):   939,
r_longlong(  945 << 32 |   769):   940,
r_longlong(  949 << 32 |   769):   941,
r_longlong(  951 << 32 |   769):   942,
r_longlong(  953 << 32 |   769):   943,
r_longlong(  971 << 32 |   769):   944,
r_longlong(  953 << 32 |   776):   970,
r_longlong(  965 << 32 |   776):   971,
r_longlong(  959 << 32 |   769):   972,
r_longlong(  965 << 32 |   769):   973,
r_longlong(  969 << 32 |   769):   974,
r_longlong(  978 << 32 |   769):   979,
r_longlong(  978 << 32 |   776):   980,
r_longlong( 1045 << 32 |   768):  1024,
r_longlong( 1045 << 32 |   776):  1025,
r_longlong( 1043 << 32 |   769):  1027,
r_longlong( 1030 << 32 |   776):  1031,
r_longlong( 1050 << 32 |   769):  1036,
r_longlong( 1048 << 32 |   768):  1037,
r_longlong( 1059 << 32 |   774):  1038,
r_longlong( 1048 << 32 |   774):  1049,
r_longlong( 1080 << 32 |   774):  1081,
r_longlong( 1077 << 32 |   768):  1104,
r_longlong( 1077 << 32 |   776):  1105,
r_longlong( 1075 << 32 |   769):  1107,
r_longlong( 1110 << 32 |   776):  1111,
r_longlong( 1082 << 32 |   769):  1116,
r_longlong( 1080 << 32 |   768):  1117,
r_longlong( 1091 << 32 |   774):  1118,
r_longlong( 1140 << 32 |   783):  1142,
r_longlong( 1141 << 32 |   783):  1143,
r_longlong( 1046 << 32 |   774):  1217,
r_longlong( 1078 << 32 |   774):  1218,
r_longlong( 1040 << 32 |   774):  1232,
r_longlong( 1072 << 32 |   774):  1233,
r_longlong( 1040 << 32 |   776):  1234,
r_longlong( 1072 << 32 |   776):  1235,
r_longlong( 1045 << 32 |   774):  1238,
r_longlong( 1077 << 32 |   774):  1239,
r_longlong( 1240 << 32 |   776):  1242,
r_longlong( 1241 << 32 |   776):  1243,
r_longlong( 1046 << 32 |   776):  1244,
r_longlong( 1078 << 32 |   776):  1245,
r_longlong( 1047 << 32 |   776):  1246,
r_longlong( 1079 << 32 |   776):  1247,
r_longlong( 1048 << 32 |   772):  1250,
r_longlong( 1080 << 32 |   772):  1251,
r_longlong( 1048 << 32 |   776):  1252,
r_longlong( 1080 << 32 |   776):  1253,
r_longlong( 1054 << 32 |   776):  1254,
r_longlong( 1086 << 32 |   776):  1255,
r_longlong( 1256 << 32 |   776):  1258,
r_longlong( 1257 << 32 |   776):  1259,
r_longlong( 1069 << 32 |   776):  1260,
r_longlong( 1101 << 32 |   776):  1261,
r_longlong( 1059 << 32 |   772):  1262,
r_longlong( 1091 << 32 |   772):  1263,
r_longlong( 1059 << 32 |   776):  1264,
r_longlong( 1091 << 32 |   776):  1265,
r_longlong( 1059 << 32 |   779):  1266,
r_longlong( 1091 << 32 |   779):  1267,
r_longlong( 1063 << 32 |   776):  1268,
r_longlong( 1095 << 32 |   776):  1269,
r_longlong( 1067 << 32 |   776):  1272,
r_longlong( 1099 << 32 |   776):  1273,
r_longlong( 1575 << 32 |  1619):  1570,
r_longlong( 1575 << 32 |  1620):  1571,
r_longlong( 1608 << 32 |  1620):  1572,
r_longlong( 1575 << 32 |  1621):  1573,
r_longlong( 1610 << 32 |  1620):  1574,
r_longlong( 1749 << 32 |  1620):  1728,
r_longlong( 1729 << 32 |  1620):  1730,
r_longlong( 1746 << 32 |  1620):  1747,
r_longlong( 2344 << 32 |  2364):  2345,
r_longlong( 2352 << 32 |  2364):  2353,
r_longlong( 2355 << 32 |  2364):  2356,
r_longlong( 2503 << 32 |  2494):  2507,
r_longlong( 2503 << 32 |  2519):  2508,
r_longlong( 2887 << 32 |  2902):  2888,
r_longlong( 2887 << 32 |  2878):  2891,
r_longlong( 2887 << 32 |  2903):  2892,
r_longlong( 2962 << 32 |  3031):  2964,
r_longlong( 3014 << 32 |  3006):  3018,
r_longlong( 3015 << 32 |  3006):  3019,
r_longlong( 3014 << 32 |  3031):  3020,
r_longlong( 3142 << 32 |  3158):  3144,
r_longlong( 3263 << 32 |  3285):  3264,
r_longlong( 3270 << 32 |  3285):  3271,
r_longlong( 3270 << 32 |  3286):  3272,
r_longlong( 3270 << 32 |  3266):  3274,
r_longlong( 3274 << 32 |  3285):  3275,
r_longlong( 3398 << 32 |  3390):  3402,
r_longlong( 3399 << 32 |  3390):  3403,
r_longlong( 3398 << 32 |  3415):  3404,
r_longlong( 3545 << 32 |  3530):  3546,
r_longlong( 3545 << 32 |  3535):  3548,
r_longlong( 3548 << 32 |  3530):  3549,
r_longlong( 3545 << 32 |  3551):  3550,
r_longlong( 4133 << 32 |  4142):  4134,
r_longlong( 6917 << 32 |  6965):  6918,
r_longlong( 6919 << 32 |  6965):  6920,
r_longlong( 6921 << 32 |  6965):  6922,
r_longlong( 6923 << 32 |  6965):  6924,
r_longlong( 6925 << 32 |  6965):  6926,
r_longlong( 6929 << 32 |  6965):  6930,
r_longlong( 6970 << 32 |  6965):  6971,
r_longlong( 6972 << 32 |  6965):  6973,
r_longlong( 6974 << 32 |  6965):  6976,
r_longlong( 6975 << 32 |  6965):  6977,
r_longlong( 6978 << 32 |  6965):  6979,
r_longlong(   65 << 32 |   805):  7680,
r_longlong(   97 << 32 |   805):  7681,
r_longlong(   66 << 32 |   775):  7682,
r_longlong(   98 << 32 |   775):  7683,
r_longlong(   66 << 32 |   803):  7684,
r_longlong(   98 << 32 |   803):  7685,
r_longlong(   66 << 32 |   817):  7686,
r_longlong(   98 << 32 |   817):  7687,
r_longlong(  199 << 32 |   769):  7688,
r_longlong(  231 << 32 |   769):  7689,
r_longlong(   68 << 32 |   775):  7690,
r_longlong(  100 << 32 |   775):  7691,
r_longlong(   68 << 32 |   803):  7692,
r_longlong(  100 << 32 |   803):  7693,
r_longlong(   68 << 32 |   817):  7694,
r_longlong(  100 << 32 |   817):  7695,
r_longlong(   68 << 32 |   807):  7696,
r_longlong(  100 << 32 |   807):  7697,
r_longlong(   68 << 32 |   813):  7698,
r_longlong(  100 << 32 |   813):  7699,
r_longlong(  274 << 32 |   768):  7700,
r_longlong(  275 << 32 |   768):  7701,
r_longlong(  274 << 32 |   769):  7702,
r_longlong(  275 << 32 |   769):  7703,
r_longlong(   69 << 32 |   813):  7704,
r_longlong(  101 << 32 |   813):  7705,
r_longlong(   69 << 32 |   816):  7706,
r_longlong(  101 << 32 |   816):  7707,
r_longlong(  552 << 32 |   774):  7708,
r_longlong(  553 << 32 |   774):  7709,
r_longlong(   70 << 32 |   775):  7710,
r_longlong(  102 << 32 |   775):  7711,
r_longlong(   71 << 32 |   772):  7712,
r_longlong(  103 << 32 |   772):  7713,
r_longlong(   72 << 32 |   775):  7714,
r_longlong(  104 << 32 |   775):  7715,
r_longlong(   72 << 32 |   803):  7716,
r_longlong(  104 << 32 |   803):  7717,
r_longlong(   72 << 32 |   776):  7718,
r_longlong(  104 << 32 |   776):  7719,
r_longlong(   72 << 32 |   807):  7720,
r_longlong(  104 << 32 |   807):  7721,
r_longlong(   72 << 32 |   814):  7722,
r_longlong(  104 << 32 |   814):  7723,
r_longlong(   73 << 32 |   816):  7724,
r_longlong(  105 << 32 |   816):  7725,
r_longlong(  207 << 32 |   769):  7726,
r_longlong(  239 << 32 |   769):  7727,
r_longlong(   75 << 32 |   769):  7728,
r_longlong(  107 << 32 |   769):  7729,
r_longlong(   75 << 32 |   803):  7730,
r_longlong(  107 << 32 |   803):  7731,
r_longlong(   75 << 32 |   817):  7732,
r_longlong(  107 << 32 |   817):  7733,
r_longlong(   76 << 32 |   803):  7734,
r_longlong(  108 << 32 |   803):  7735,
r_longlong( 7734 << 32 |   772):  7736,
r_longlong( 7735 << 32 |   772):  7737,
r_longlong(   76 << 32 |   817):  7738,
r_longlong(  108 << 32 |   817):  7739,
r_longlong(   76 << 32 |   813):  7740,
r_longlong(  108 << 32 |   813):  7741,
r_longlong(   77 << 32 |   769):  7742,
r_longlong(  109 << 32 |   769):  7743,
r_longlong(   77 << 32 |   775):  7744,
r_longlong(  109 << 32 |   775):  7745,
r_longlong(   77 << 32 |   803):  7746,
r_longlong(  109 << 32 |   803):  7747,
r_longlong(   78 << 32 |   775):  7748,
r_longlong(  110 << 32 |   775):  7749,
r_longlong(   78 << 32 |   803):  7750,
r_longlong(  110 << 32 |   803):  7751,
r_longlong(   78 << 32 |   817):  7752,
r_longlong(  110 << 32 |   817):  7753,
r_longlong(   78 << 32 |   813):  7754,
r_longlong(  110 << 32 |   813):  7755,
r_longlong(  213 << 32 |   769):  7756,
r_longlong(  245 << 32 |   769):  7757,
r_longlong(  213 << 32 |   776):  7758,
r_longlong(  245 << 32 |   776):  7759,
r_longlong(  332 << 32 |   768):  7760,
r_longlong(  333 << 32 |   768):  7761,
r_longlong(  332 << 32 |   769):  7762,
r_longlong(  333 << 32 |   769):  7763,
r_longlong(   80 << 32 |   769):  7764,
r_longlong(  112 << 32 |   769):  7765,
r_longlong(   80 << 32 |   775):  7766,
r_longlong(  112 << 32 |   775):  7767,
r_longlong(   82 << 32 |   775):  7768,
r_longlong(  114 << 32 |   775):  7769,
r_longlong(   82 << 32 |   803):  7770,
r_longlong(  114 << 32 |   803):  7771,
r_longlong( 7770 << 32 |   772):  7772,
r_longlong( 7771 << 32 |   772):  7773,
r_longlong(   82 << 32 |   817):  7774,
r_longlong(  114 << 32 |   817):  7775,
r_longlong(   83 << 32 |   775):  7776,
r_longlong(  115 << 32 |   775):  7777,
r_longlong(   83 << 32 |   803):  7778,
r_longlong(  115 << 32 |   803):  7779,
r_longlong(  346 << 32 |   775):  7780,
r_longlong(  347 << 32 |   775):  7781,
r_longlong(  352 << 32 |   775):  7782,
r_longlong(  353 << 32 |   775):  7783,
r_longlong( 7778 << 32 |   775):  7784,
r_longlong( 7779 << 32 |   775):  7785,
r_longlong(   84 << 32 |   775):  7786,
r_longlong(  116 << 32 |   775):  7787,
r_longlong(   84 << 32 |   803):  7788,
r_longlong(  116 << 32 |   803):  7789,
r_longlong(   84 << 32 |   817):  7790,
r_longlong(  116 << 32 |   817):  7791,
r_longlong(   84 << 32 |   813):  7792,
r_longlong(  116 << 32 |   813):  7793,
r_longlong(   85 << 32 |   804):  7794,
r_longlong(  117 << 32 |   804):  7795,
r_longlong(   85 << 32 |   816):  7796,
r_longlong(  117 << 32 |   816):  7797,
r_longlong(   85 << 32 |   813):  7798,
r_longlong(  117 << 32 |   813):  7799,
r_longlong(  360 << 32 |   769):  7800,
r_longlong(  361 << 32 |   769):  7801,
r_longlong(  362 << 32 |   776):  7802,
r_longlong(  363 << 32 |   776):  7803,
r_longlong(   86 << 32 |   771):  7804,
r_longlong(  118 << 32 |   771):  7805,
r_longlong(   86 << 32 |   803):  7806,
r_longlong(  118 << 32 |   803):  7807,
r_longlong(   87 << 32 |   768):  7808,
r_longlong(  119 << 32 |   768):  7809,
r_longlong(   87 << 32 |   769):  7810,
r_longlong(  119 << 32 |   769):  7811,
r_longlong(   87 << 32 |   776):  7812,
r_longlong(  119 << 32 |   776):  7813,
r_longlong(   87 << 32 |   775):  7814,
r_longlong(  119 << 32 |   775):  7815,
r_longlong(   87 << 32 |   803):  7816,
r_longlong(  119 << 32 |   803):  7817,
r_longlong(   88 << 32 |   775):  7818,
r_longlong(  120 << 32 |   775):  7819,
r_longlong(   88 << 32 |   776):  7820,
r_longlong(  120 << 32 |   776):  7821,
r_longlong(   89 << 32 |   775):  7822,
r_longlong(  121 << 32 |   775):  7823,
r_longlong(   90 << 32 |   770):  7824,
r_longlong(  122 << 32 |   770):  7825,
r_longlong(   90 << 32 |   803):  7826,
r_longlong(  122 << 32 |   803):  7827,
r_longlong(   90 << 32 |   817):  7828,
r_longlong(  122 << 32 |   817):  7829,
r_longlong(  104 << 32 |   817):  7830,
r_longlong(  116 << 32 |   776):  7831,
r_longlong(  119 << 32 |   778):  7832,
r_longlong(  121 << 32 |   778):  7833,
r_longlong(  383 << 32 |   775):  7835,
r_longlong(   65 << 32 |   803):  7840,
r_longlong(   97 << 32 |   803):  7841,
r_longlong(   65 << 32 |   777):  7842,
r_longlong(   97 << 32 |   777):  7843,
r_longlong(  194 << 32 |   769):  7844,
r_longlong(  226 << 32 |   769):  7845,
r_longlong(  194 << 32 |   768):  7846,
r_longlong(  226 << 32 |   768):  7847,
r_longlong(  194 << 32 |   777):  7848,
r_longlong(  226 << 32 |   777):  7849,
r_longlong(  194 << 32 |   771):  7850,
r_longlong(  226 << 32 |   771):  7851,
r_longlong( 7840 << 32 |   770):  7852,
r_longlong( 7841 << 32 |   770):  7853,
r_longlong(  258 << 32 |   769):  7854,
r_longlong(  259 << 32 |   769):  7855,
r_longlong(  258 << 32 |   768):  7856,
r_longlong(  259 << 32 |   768):  7857,
r_longlong(  258 << 32 |   777):  7858,
r_longlong(  259 << 32 |   777):  7859,
r_longlong(  258 << 32 |   771):  7860,
r_longlong(  259 << 32 |   771):  7861,
r_longlong( 7840 << 32 |   774):  7862,
r_longlong( 7841 << 32 |   774):  7863,
r_longlong(   69 << 32 |   803):  7864,
r_longlong(  101 << 32 |   803):  7865,
r_longlong(   69 << 32 |   777):  7866,
r_longlong(  101 << 32 |   777):  7867,
r_longlong(   69 << 32 |   771):  7868,
r_longlong(  101 << 32 |   771):  7869,
r_longlong(  202 << 32 |   769):  7870,
r_longlong(  234 << 32 |   769):  7871,
r_longlong(  202 << 32 |   768):  7872,
r_longlong(  234 << 32 |   768):  7873,
r_longlong(  202 << 32 |   777):  7874,
r_longlong(  234 << 32 |   777):  7875,
r_longlong(  202 << 32 |   771):  7876,
r_longlong(  234 << 32 |   771):  7877,
r_longlong( 7864 << 32 |   770):  7878,
r_longlong( 7865 << 32 |   770):  7879,
r_longlong(   73 << 32 |   777):  7880,
r_longlong(  105 << 32 |   777):  7881,
r_longlong(   73 << 32 |   803):  7882,
r_longlong(  105 << 32 |   803):  7883,
r_longlong(   79 << 32 |   803):  7884,
r_longlong(  111 << 32 |   803):  7885,
r_longlong(   79 << 32 |   777):  7886,
r_longlong(  111 << 32 |   777):  7887,
r_longlong(  212 << 32 |   769):  7888,
r_longlong(  244 << 32 |   769):  7889,
r_longlong(  212 << 32 |   768):  7890,
r_longlong(  244 << 32 |   768):  7891,
r_longlong(  212 << 32 |   777):  7892,
r_longlong(  244 << 32 |   777):  7893,
r_longlong(  212 << 32 |   771):  7894,
r_longlong(  244 << 32 |   771):  7895,
r_longlong( 7884 << 32 |   770):  7896,
r_longlong( 7885 << 32 |   770):  7897,
r_longlong(  416 << 32 |   769):  7898,
r_longlong(  417 << 32 |   769):  7899,
r_longlong(  416 << 32 |   768):  7900,
r_longlong(  417 << 32 |   768):  7901,
r_longlong(  416 << 32 |   777):  7902,
r_longlong(  417 << 32 |   777):  7903,
r_longlong(  416 << 32 |   771):  7904,
r_longlong(  417 << 32 |   771):  7905,
r_longlong(  416 << 32 |   803):  7906,
r_longlong(  417 << 32 |   803):  7907,
r_longlong(   85 << 32 |   803):  7908,
r_longlong(  117 << 32 |   803):  7909,
r_longlong(   85 << 32 |   777):  7910,
r_longlong(  117 << 32 |   777):  7911,
r_longlong(  431 << 32 |   769):  7912,
r_longlong(  432 << 32 |   769):  7913,
r_longlong(  431 << 32 |   768):  7914,
r_longlong(  432 << 32 |   768):  7915,
r_longlong(  431 << 32 |   777):  7916,
r_longlong(  432 << 32 |   777):  7917,
r_longlong(  431 << 32 |   771):  7918,
r_longlong(  432 << 32 |   771):  7919,
r_longlong(  431 << 32 |   803):  7920,
r_longlong(  432 << 32 |   803):  7921,
r_longlong(   89 << 32 |   768):  7922,
r_longlong(  121 << 32 |   768):  7923,
r_longlong(   89 << 32 |   803):  7924,
r_longlong(  121 << 32 |   803):  7925,
r_longlong(   89 << 32 |   777):  7926,
r_longlong(  121 << 32 |   777):  7927,
r_longlong(   89 << 32 |   771):  7928,
r_longlong(  121 << 32 |   771):  7929,
r_longlong(  945 << 32 |   787):  7936,
r_longlong(  945 << 32 |   788):  7937,
r_longlong( 7936 << 32 |   768):  7938,
r_longlong( 7937 << 32 |   768):  7939,
r_longlong( 7936 << 32 |   769):  7940,
r_longlong( 7937 << 32 |   769):  7941,
r_longlong( 7936 << 32 |   834):  7942,
r_longlong( 7937 << 32 |   834):  7943,
r_longlong(  913 << 32 |   787):  7944,
r_longlong(  913 << 32 |   788):  7945,
r_longlong( 7944 << 32 |   768):  7946,
r_longlong( 7945 << 32 |   768):  7947,
r_longlong( 7944 << 32 |   769):  7948,
r_longlong( 7945 << 32 |   769):  7949,
r_longlong( 7944 << 32 |   834):  7950,
r_longlong( 7945 << 32 |   834):  7951,
r_longlong(  949 << 32 |   787):  7952,
r_longlong(  949 << 32 |   788):  7953,
r_longlong( 7952 << 32 |   768):  7954,
r_longlong( 7953 << 32 |   768):  7955,
r_longlong( 7952 << 32 |   769):  7956,
r_longlong( 7953 << 32 |   769):  7957,
r_longlong(  917 << 32 |   787):  7960,
r_longlong(  917 << 32 |   788):  7961,
r_longlong( 7960 << 32 |   768):  7962,
r_longlong( 7961 << 32 |   768):  7963,
r_longlong( 7960 << 32 |   769):  7964,
r_longlong( 7961 << 32 |   769):  7965,
r_longlong(  951 << 32 |   787):  7968,
r_longlong(  951 << 32 |   788):  7969,
r_longlong( 7968 << 32 |   768):  7970,
r_longlong( 7969 << 32 |   768):  7971,
r_longlong( 7968 << 32 |   769):  7972,
r_longlong( 7969 << 32 |   769):  7973,
r_longlong( 7968 << 32 |   834):  7974,
r_longlong( 7969 << 32 |   834):  7975,
r_longlong(  919 << 32 |   787):  7976,
r_longlong(  919 << 32 |   788):  7977,
r_longlong( 7976 << 32 |   768):  7978,
r_longlong( 7977 << 32 |   768):  7979,
r_longlong( 7976 << 32 |   769):  7980,
r_longlong( 7977 << 32 |   769):  7981,
r_longlong( 7976 << 32 |   834):  7982,
r_longlong( 7977 << 32 |   834):  7983,
r_longlong(  953 << 32 |   787):  7984,
r_longlong(  953 << 32 |   788):  7985,
r_longlong( 7984 << 32 |   768):  7986,
r_longlong( 7985 << 32 |   768):  7987,
r_longlong( 7984 << 32 |   769):  7988,
r_longlong( 7985 << 32 |   769):  7989,
r_longlong( 7984 << 32 |   834):  7990,
r_longlong( 7985 << 32 |   834):  7991,
r_longlong(  921 << 32 |   787):  7992,
r_longlong(  921 << 32 |   788):  7993,
r_longlong( 7992 << 32 |   768):  7994,
r_longlong( 7993 << 32 |   768):  7995,
r_longlong( 7992 << 32 |   769):  7996,
r_longlong( 7993 << 32 |   769):  7997,
r_longlong( 7992 << 32 |   834):  7998,
r_longlong( 7993 << 32 |   834):  7999,
r_longlong(  959 << 32 |   787):  8000,
r_longlong(  959 << 32 |   788):  8001,
r_longlong( 8000 << 32 |   768):  8002,
r_longlong( 8001 << 32 |   768):  8003,
r_longlong( 8000 << 32 |   769):  8004,
r_longlong( 8001 << 32 |   769):  8005,
r_longlong(  927 << 32 |   787):  8008,
r_longlong(  927 << 32 |   788):  8009,
r_longlong( 8008 << 32 |   768):  8010,
r_longlong( 8009 << 32 |   768):  8011,
r_longlong( 8008 << 32 |   769):  8012,
r_longlong( 8009 << 32 |   769):  8013,
r_longlong(  965 << 32 |   787):  8016,
r_longlong(  965 << 32 |   788):  8017,
r_longlong( 8016 << 32 |   768):  8018,
r_longlong( 8017 << 32 |   768):  8019,
r_longlong( 8016 << 32 |   769):  8020,
r_longlong( 8017 << 32 |   769):  8021,
r_longlong( 8016 << 32 |   834):  8022,
r_longlong( 8017 << 32 |   834):  8023,
r_longlong(  933 << 32 |   788):  8025,
r_longlong( 8025 << 32 |   768):  8027,
r_longlong( 8025 << 32 |   769):  8029,
r_longlong( 8025 << 32 |   834):  8031,
r_longlong(  969 << 32 |   787):  8032,
r_longlong(  969 << 32 |   788):  8033,
r_longlong( 8032 << 32 |   768):  8034,
r_longlong( 8033 << 32 |   768):  8035,
r_longlong( 8032 << 32 |   769):  8036,
r_longlong( 8033 << 32 |   769):  8037,
r_longlong( 8032 << 32 |   834):  8038,
r_longlong( 8033 << 32 |   834):  8039,
r_longlong(  937 << 32 |   787):  8040,
r_longlong(  937 << 32 |   788):  8041,
r_longlong( 8040 << 32 |   768):  8042,
r_longlong( 8041 << 32 |   768):  8043,
r_longlong( 8040 << 32 |   769):  8044,
r_longlong( 8041 << 32 |   769):  8045,
r_longlong( 8040 << 32 |   834):  8046,
r_longlong( 8041 << 32 |   834):  8047,
r_longlong(  945 << 32 |   768):  8048,
r_longlong(  949 << 32 |   768):  8050,
r_longlong(  951 << 32 |   768):  8052,
r_longlong(  953 << 32 |   768):  8054,
r_longlong(  959 << 32 |   768):  8056,
r_longlong(  965 << 32 |   768):  8058,
r_longlong(  969 << 32 |   768):  8060,
r_longlong( 7936 << 32 |   837):  8064,
r_longlong( 7937 << 32 |   837):  8065,
r_longlong( 7938 << 32 |   837):  8066,
r_longlong( 7939 << 32 |   837):  8067,
r_longlong( 7940 << 32 |   837):  8068,
r_longlong( 7941 << 32 |   837):  8069,
r_longlong( 7942 << 32 |   837):  8070,
r_longlong( 7943 << 32 |   837):  8071,
r_longlong( 7944 << 32 |   837):  8072,
r_longlong( 7945 << 32 |   837):  8073,
r_longlong( 7946 << 32 |   837):  8074,
r_longlong( 7947 << 32 |   837):  8075,
r_longlong( 7948 << 32 |   837):  8076,
r_longlong( 7949 << 32 |   837):  8077,
r_longlong( 7950 << 32 |   837):  8078,
r_longlong( 7951 << 32 |   837):  8079,
r_longlong( 7968 << 32 |   837):  8080,
r_longlong( 7969 << 32 |   837):  8081,
r_longlong( 7970 << 32 |   837):  8082,
r_longlong( 7971 << 32 |   837):  8083,
r_longlong( 7972 << 32 |   837):  8084,
r_longlong( 7973 << 32 |   837):  8085,
r_longlong( 7974 << 32 |   837):  8086,
r_longlong( 7975 << 32 |   837):  8087,
r_longlong( 7976 << 32 |   837):  8088,
r_longlong( 7977 << 32 |   837):  8089,
r_longlong( 7978 << 32 |   837):  8090,
r_longlong( 7979 << 32 |   837):  8091,
r_longlong( 7980 << 32 |   837):  8092,
r_longlong( 7981 << 32 |   837):  8093,
r_longlong( 7982 << 32 |   837):  8094,
r_longlong( 7983 << 32 |   837):  8095,
r_longlong( 8032 << 32 |   837):  8096,
r_longlong( 8033 << 32 |   837):  8097,
r_longlong( 8034 << 32 |   837):  8098,
r_longlong( 8035 << 32 |   837):  8099,
r_longlong( 8036 << 32 |   837):  8100,
r_longlong( 8037 << 32 |   837):  8101,
r_longlong( 8038 << 32 |   837):  8102,
r_longlong( 8039 << 32 |   837):  8103,
r_longlong( 8040 << 32 |   837):  8104,
r_longlong( 8041 << 32 |   837):  8105,
r_longlong( 8042 << 32 |   837):  8106,
r_longlong( 8043 << 32 |   837):  8107,
r_longlong( 8044 << 32 |   837):  8108,
r_longlong( 8045 << 32 |   837):  8109,
r_longlong( 8046 << 32 |   837):  8110,
r_longlong( 8047 << 32 |   837):  8111,
r_longlong(  945 << 32 |   774):  8112,
r_longlong(  945 << 32 |   772):  8113,
r_longlong( 8048 << 32 |   837):  8114,
r_longlong(  945 << 32 |   837):  8115,
r_longlong(  940 << 32 |   837):  8116,
r_longlong(  945 << 32 |   834):  8118,
r_longlong( 8118 << 32 |   837):  8119,
r_longlong(  913 << 32 |   774):  8120,
r_longlong(  913 << 32 |   772):  8121,
r_longlong(  913 << 32 |   768):  8122,
r_longlong(  913 << 32 |   837):  8124,
r_longlong(  168 << 32 |   834):  8129,
r_longlong( 8052 << 32 |   837):  8130,
r_longlong(  951 << 32 |   837):  8131,
r_longlong(  942 << 32 |   837):  8132,
r_longlong(  951 << 32 |   834):  8134,
r_longlong( 8134 << 32 |   837):  8135,
r_longlong(  917 << 32 |   768):  8136,
r_longlong(  919 << 32 |   768):  8138,
r_longlong(  919 << 32 |   837):  8140,
r_longlong( 8127 << 32 |   768):  8141,
r_longlong( 8127 << 32 |   769):  8142,
r_longlong( 8127 << 32 |   834):  8143,
r_longlong(  953 << 32 |   774):  8144,
r_longlong(  953 << 32 |   772):  8145,
r_longlong(  970 << 32 |   768):  8146,
r_longlong(  953 << 32 |   834):  8150,
r_longlong(  970 << 32 |   834):  8151,
r_longlong(  921 << 32 |   774):  8152,
r_longlong(  921 << 32 |   772):  8153,
r_longlong(  921 << 32 |   768):  8154,
r_longlong( 8190 << 32 |   768):  8157,
r_longlong( 8190 << 32 |   769):  8158,
r_longlong( 8190 << 32 |   834):  8159,
r_longlong(  965 << 32 |   774):  8160,
r_longlong(  965 << 32 |   772):  8161,
r_longlong(  971 << 32 |   768):  8162,
r_longlong(  961 << 32 |   787):  8164,
r_longlong(  961 << 32 |   788):  8165,
r_longlong(  965 << 32 |   834):  8166,
r_longlong(  971 << 32 |   834):  8167,
r_longlong(  933 << 32 |   774):  8168,
r_longlong(  933 << 32 |   772):  8169,
r_longlong(  933 << 32 |   768):  8170,
r_longlong(  929 << 32 |   788):  8172,
r_longlong(  168 << 32 |   768):  8173,
r_longlong( 8060 << 32 |   837):  8178,
r_longlong(  969 << 32 |   837):  8179,
r_longlong(  974 << 32 |   837):  8180,
r_longlong(  969 << 32 |   834):  8182,
r_longlong( 8182 << 32 |   837):  8183,
r_longlong(  927 << 32 |   768):  8184,
r_longlong(  937 << 32 |   768):  8186,
r_longlong(  937 << 32 |   837):  8188,
r_longlong( 8592 << 32 |   824):  8602,
r_longlong( 8594 << 32 |   824):  8603,
r_longlong( 8596 << 32 |   824):  8622,
r_longlong( 8656 << 32 |   824):  8653,
r_longlong( 8660 << 32 |   824):  8654,
r_longlong( 8658 << 32 |   824):  8655,
r_longlong( 8707 << 32 |   824):  8708,
r_longlong( 8712 << 32 |   824):  8713,
r_longlong( 8715 << 32 |   824):  8716,
r_longlong( 8739 << 32 |   824):  8740,
r_longlong( 8741 << 32 |   824):  8742,
r_longlong( 8764 << 32 |   824):  8769,
r_longlong( 8771 << 32 |   824):  8772,
r_longlong( 8773 << 32 |   824):  8775,
r_longlong( 8776 << 32 |   824):  8777,
r_longlong(   61 << 32 |   824):  8800,
r_longlong( 8801 << 32 |   824):  8802,
r_longlong( 8781 << 32 |   824):  8813,
r_longlong(   60 << 32 |   824):  8814,
r_longlong(   62 << 32 |   824):  8815,
r_longlong( 8804 << 32 |   824):  8816,
r_longlong( 8805 << 32 |   824):  8817,
r_longlong( 8818 << 32 |   824):  8820,
r_longlong( 8819 << 32 |   824):  8821,
r_longlong( 8822 << 32 |   824):  8824,
r_longlong( 8823 << 32 |   824):  8825,
r_longlong( 8826 << 32 |   824):  8832,
r_longlong( 8827 << 32 |   824):  8833,
r_longlong( 8834 << 32 |   824):  8836,
r_longlong( 8835 << 32 |   824):  8837,
r_longlong( 8838 << 32 |   824):  8840,
r_longlong( 8839 << 32 |   824):  8841,
r_longlong( 8866 << 32 |   824):  8876,
r_longlong( 8872 << 32 |   824):  8877,
r_longlong( 8873 << 32 |   824):  8878,
r_longlong( 8875 << 32 |   824):  8879,
r_longlong( 8828 << 32 |   824):  8928,
r_longlong( 8829 << 32 |   824):  8929,
r_longlong( 8849 << 32 |   824):  8930,
r_longlong( 8850 << 32 |   824):  8931,
r_longlong( 8882 << 32 |   824):  8938,
r_longlong( 8883 << 32 |   824):  8939,
r_longlong( 8884 << 32 |   824):  8940,
r_longlong( 8885 << 32 |   824):  8941,
r_longlong(12363 << 32 | 12441): 12364,
r_longlong(12365 << 32 | 12441): 12366,
r_longlong(12367 << 32 | 12441): 12368,
r_longlong(12369 << 32 | 12441): 12370,
r_longlong(12371 << 32 | 12441): 12372,
r_longlong(12373 << 32 | 12441): 12374,
r_longlong(12375 << 32 | 12441): 12376,
r_longlong(12377 << 32 | 12441): 12378,
r_longlong(12379 << 32 | 12441): 12380,
r_longlong(12381 << 32 | 12441): 12382,
r_longlong(12383 << 32 | 12441): 12384,
r_longlong(12385 << 32 | 12441): 12386,
r_longlong(12388 << 32 | 12441): 12389,
r_longlong(12390 << 32 | 12441): 12391,
r_longlong(12392 << 32 | 12441): 12393,
r_longlong(12399 << 32 | 12441): 12400,
r_longlong(12399 << 32 | 12442): 12401,
r_longlong(12402 << 32 | 12441): 12403,
r_longlong(12402 << 32 | 12442): 12404,
r_longlong(12405 << 32 | 12441): 12406,
r_longlong(12405 << 32 | 12442): 12407,
r_longlong(12408 << 32 | 12441): 12409,
r_longlong(12408 << 32 | 12442): 12410,
r_longlong(12411 << 32 | 12441): 12412,
r_longlong(12411 << 32 | 12442): 12413,
r_longlong(12358 << 32 | 12441): 12436,
r_longlong(12445 << 32 | 12441): 12446,
r_longlong(12459 << 32 | 12441): 12460,
r_longlong(12461 << 32 | 12441): 12462,
r_longlong(12463 << 32 | 12441): 12464,
r_longlong(12465 << 32 | 12441): 12466,
r_longlong(12467 << 32 | 12441): 12468,
r_longlong(12469 << 32 | 12441): 12470,
r_longlong(12471 << 32 | 12441): 12472,
r_longlong(12473 << 32 | 12441): 12474,
r_longlong(12475 << 32 | 12441): 12476,
r_longlong(12477 << 32 | 12441): 12478,
r_longlong(12479 << 32 | 12441): 12480,
r_longlong(12481 << 32 | 12441): 12482,
r_longlong(12484 << 32 | 12441): 12485,
r_longlong(12486 << 32 | 12441): 12487,
r_longlong(12488 << 32 | 12441): 12489,
r_longlong(12495 << 32 | 12441): 12496,
r_longlong(12495 << 32 | 12442): 12497,
r_longlong(12498 << 32 | 12441): 12499,
r_longlong(12498 << 32 | 12442): 12500,
r_longlong(12501 << 32 | 12441): 12502,
r_longlong(12501 << 32 | 12442): 12503,
r_longlong(12504 << 32 | 12441): 12505,
r_longlong(12504 << 32 | 12442): 12506,
r_longlong(12507 << 32 | 12441): 12508,
r_longlong(12507 << 32 | 12442): 12509,
r_longlong(12454 << 32 | 12441): 12532,
r_longlong(12527 << 32 | 12441): 12535,
r_longlong(12528 << 32 | 12441): 12536,
r_longlong(12529 << 32 | 12441): 12537,
r_longlong(12530 << 32 | 12441): 12538,
r_longlong(12541 << 32 | 12441): 12542,
r_longlong(69785 << 32 | 69818): 69786,
r_longlong(69787 << 32 | 69818): 69788,
r_longlong(69797 << 32 | 69818): 69803,
r_longlong(69937 << 32 | 69927): 69934,
r_longlong(69938 << 32 | 69927): 69935,
r_longlong(70471 << 32 | 70462): 70475,
r_longlong(70471 << 32 | 70487): 70476,
r_longlong(70841 << 32 | 70842): 70843,
r_longlong(70841 << 32 | 70832): 70844,
r_longlong(70841 << 32 | 70845): 70846,
r_longlong(71096 << 32 | 71087): 71098,
r_longlong(71097 << 32 | 71087): 71099,
}

_canon_decomposition = {
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
70475: [70471, 70462],
70476: [70471, 70487],
70843: [70841, 70842],
70844: [70841, 70832],
70846: [70841, 70845],
71098: [71096, 71087],
71099: [71097, 71087],
}

_canon_decomposition_corrected = {
}
_compat_decomposition = {
8341: [104],
8342: [107],
8343: [108],
8344: [109],
8345: [110],
8346: [112],
8347: [115],
8348: [116],
42652: [1098],
42653: [1100],
43000: [294],
43001: [339],
43868: [42791],
43869: [43831],
43870: [619],
43871: [43858],
64046: [37086],
64047: [38583],
69934: [69937, 69927],
69935: [69938, 69927],
70475: [70471, 70462],
70476: [70471, 70487],
70843: [70841, 70842],
70844: [70841, 70832],
70846: [70841, 70845],
71098: [71096, 71087],
71099: [71097, 71087],
126464: [1575],
126465: [1576],
126466: [1580],
126467: [1583],
126469: [1608],
126470: [1586],
126471: [1581],
126472: [1591],
126473: [1610],
126474: [1603],
126475: [1604],
126476: [1605],
126477: [1606],
126478: [1587],
126479: [1593],
126480: [1601],
126481: [1589],
126482: [1602],
126483: [1585],
126484: [1588],
126485: [1578],
126486: [1579],
126487: [1582],
126488: [1584],
126489: [1590],
126490: [1592],
126491: [1594],
126492: [1646],
126493: [1722],
126494: [1697],
126495: [1647],
126497: [1576],
126498: [1580],
126500: [1607],
126503: [1581],
126505: [1610],
126506: [1603],
126507: [1604],
126508: [1605],
126509: [1606],
126510: [1587],
126511: [1593],
126512: [1601],
126513: [1589],
126514: [1602],
126516: [1588],
126517: [1578],
126518: [1579],
126519: [1582],
126521: [1590],
126523: [1594],
126530: [1580],
126535: [1581],
126537: [1610],
126539: [1604],
126541: [1606],
126542: [1587],
126543: [1593],
126545: [1589],
126546: [1602],
126548: [1588],
126551: [1582],
126553: [1590],
126555: [1594],
126557: [1722],
126559: [1647],
126561: [1576],
126562: [1580],
126564: [1607],
126567: [1581],
126568: [1591],
126569: [1610],
126570: [1603],
126572: [1605],
126573: [1606],
126574: [1587],
126575: [1593],
126576: [1601],
126577: [1589],
126578: [1602],
126580: [1588],
126581: [1578],
126582: [1579],
126583: [1582],
126585: [1590],
126586: [1592],
126587: [1594],
126588: [1646],
126590: [1697],
126592: [1575],
126593: [1576],
126594: [1580],
126595: [1583],
126596: [1607],
126597: [1608],
126598: [1586],
126599: [1581],
126600: [1591],
126601: [1610],
126603: [1604],
126604: [1605],
126605: [1606],
126606: [1587],
126607: [1593],
126608: [1601],
126609: [1589],
126610: [1602],
126611: [1585],
126612: [1588],
126613: [1578],
126614: [1579],
126615: [1582],
126616: [1584],
126617: [1590],
126618: [1592],
126619: [1594],
126625: [1576],
126626: [1580],
126627: [1583],
126629: [1608],
126630: [1586],
126631: [1581],
126632: [1591],
126633: [1610],
126635: [1604],
126636: [1605],
126637: [1606],
126638: [1587],
126639: [1593],
126640: [1601],
126641: [1589],
126642: [1602],
126643: [1585],
126644: [1588],
126645: [1578],
126646: [1579],
126647: [1582],
126648: [1584],
126649: [1590],
126650: [1592],
126651: [1594],
127280: [65],
127282: [67],
127283: [68],
127284: [69],
127285: [70],
127286: [71],
127287: [72],
127288: [73],
127289: [74],
127290: [75],
127291: [76],
127292: [77],
127294: [79],
127296: [81],
127297: [82],
127299: [84],
127300: [85],
127301: [86],
127303: [88],
127304: [89],
127305: [90],
127311: [87, 67],
127338: [77, 67],
127339: [77, 68],
127489: [12467, 12467],
127490: [12469],
127538: [31105],
127539: [31354],
127540: [21512],
127541: [28288],
127542: [26377],
127543: [26376],
127544: [30003],
127545: [21106],
127546: [21942],
127547: [37197],
127568: [24471],
127569: [21487],
}

_compat_decomposition_corrected = {
}

def canon_decomposition(code):
    try:
        return _canon_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _canon_decomposition_corrected:
            return base_mod._canon_decomposition.get(code, [])
        else:
            return []
def compat_decomposition(code):
    try:
        return _compat_decomposition[code]
    except KeyError:
        if base_mod is not None and code not in _compat_decomposition_corrected:
            return base_mod._compat_decomposition.get(code, [])
        else:
            return []


_named_sequences = [
u'#\ufe0f\u20e3',
u'*\ufe0f\u20e3',
u'0\ufe0f\u20e3',
u'1\ufe0f\u20e3',
u'2\ufe0f\u20e3',
u'3\ufe0f\u20e3',
u'4\ufe0f\u20e3',
u'5\ufe0f\u20e3',
u'6\ufe0f\u20e3',
u'7\ufe0f\u20e3',
u'8\ufe0f\u20e3',
u'9\ufe0f\u20e3',
u'\u0100\u0300',
u'\u0101\u0300',
u'E\u0329',
u'e\u0329',
u'\xc8\u0329',
u'\xe8\u0329',
u'\xc9\u0329',
u'\xe9\u0329',
u'\xca\u0304',
u'\xea\u0304',
u'\xca\u030c',
u'\xea\u030c',
u'\u012a\u0300',
u'\u012b\u0300',
u'i\u0307\u0301',
u'n\u0360g',
u'O\u0329',
u'o\u0329',
u'\xd2\u0329',
u'\xf2\u0329',
u'\xd3\u0329',
u'\xf3\u0329',
u'S\u0329',
u's\u0329',
u'\u016a\u0300',
u'\u016b\u0300',
u'\u0104\u0301',
u'\u0105\u0301',
u'\u0104\u0303',
u'\u0105\u0303',
u'\u0118\u0301',
u'\u0119\u0301',
u'\u0118\u0303',
u'\u0119\u0303',
u'\u0116\u0301',
u'\u0117\u0301',
u'\u0116\u0303',
u'\u0117\u0303',
u'i\u0307\u0300',
u'i\u0307\u0303',
u'\u012e\u0301',
u'\u012f\u0307\u0301',
u'\u012e\u0303',
u'\u012f\u0307\u0303',
u'J\u0303',
u'j\u0307\u0303',
u'L\u0303',
u'l\u0303',
u'M\u0303',
u'm\u0303',
u'R\u0303',
u'r\u0303',
u'\u0172\u0301',
u'\u0173\u0301',
u'\u0172\u0303',
u'\u0173\u0303',
u'\u016a\u0301',
u'\u016b\u0301',
u'\u016a\u0303',
u'\u016b\u0303',
u'\xe6\u0300',
u'\u0254\u0300',
u'\u0254\u0301',
u'\u028c\u0300',
u'\u028c\u0301',
u'\u0259\u0300',
u'\u0259\u0301',
u'\u025a\u0300',
u'\u025a\u0301',
u'\u0626\u0627',
u'\u0626\u0648',
u'\u0626\u0649',
u'\u0626\u06c6',
u'\u0626\u06c7',
u'\u0626\u06c8',
u'\u0626\u06d0',
u'\u0626\u06d5',
u'\u0646\u06a9',
u'\u0995\u09cd\u09b7',
u'\u0b95\u0bcd',
u'\u0b99\u0bcd',
u'\u0b9a\u0bcd',
u'\u0b9e\u0bcd',
u'\u0b9f\u0bcd',
u'\u0ba3\u0bcd',
u'\u0ba4\u0bcd',
u'\u0ba8\u0bcd',
u'\u0baa\u0bcd',
u'\u0bae\u0bcd',
u'\u0baf\u0bcd',
u'\u0bb0\u0bcd',
u'\u0bb2\u0bcd',
u'\u0bb5\u0bcd',
u'\u0bb4\u0bcd',
u'\u0bb3\u0bcd',
u'\u0bb1\u0bcd',
u'\u0ba9\u0bcd',
u'\u0b9c\u0bcd',
u'\u0bb6\u0bcd',
u'\u0bb7\u0bcd',
u'\u0bb8\u0bcd',
u'\u0bb9\u0bcd',
u'\u0b95\u0bcd\u0bb7\u0bcd',
u'\u0b95\u0bbe',
u'\u0b95\u0bbf',
u'\u0b95\u0bc0',
u'\u0b95\u0bc1',
u'\u0b95\u0bc2',
u'\u0b95\u0bc6',
u'\u0b95\u0bc7',
u'\u0b95\u0bc8',
u'\u0b95\u0bca',
u'\u0b95\u0bcb',
u'\u0b95\u0bcc',
u'\u0b99\u0bbe',
u'\u0b99\u0bbf',
u'\u0b99\u0bc0',
u'\u0b99\u0bc1',
u'\u0b99\u0bc2',
u'\u0b99\u0bc6',
u'\u0b99\u0bc7',
u'\u0b99\u0bc8',
u'\u0b99\u0bca',
u'\u0b99\u0bcb',
u'\u0b99\u0bcc',
u'\u0b9a\u0bbe',
u'\u0b9a\u0bbf',
u'\u0b9a\u0bc0',
u'\u0b9a\u0bc1',
u'\u0b9a\u0bc2',
u'\u0b9a\u0bc6',
u'\u0b9a\u0bc7',
u'\u0b9a\u0bc8',
u'\u0b9a\u0bca',
u'\u0b9a\u0bcb',
u'\u0b9a\u0bcc',
u'\u0b9e\u0bbe',
u'\u0b9e\u0bbf',
u'\u0b9e\u0bc0',
u'\u0b9e\u0bc1',
u'\u0b9e\u0bc2',
u'\u0b9e\u0bc6',
u'\u0b9e\u0bc7',
u'\u0b9e\u0bc8',
u'\u0b9e\u0bca',
u'\u0b9e\u0bcb',
u'\u0b9e\u0bcc',
u'\u0b9f\u0bbe',
u'\u0b9f\u0bbf',
u'\u0b9f\u0bc0',
u'\u0b9f\u0bc1',
u'\u0b9f\u0bc2',
u'\u0b9f\u0bc6',
u'\u0b9f\u0bc7',
u'\u0b9f\u0bc8',
u'\u0b9f\u0bca',
u'\u0b9f\u0bcb',
u'\u0b9f\u0bcc',
u'\u0ba3\u0bbe',
u'\u0ba3\u0bbf',
u'\u0ba3\u0bc0',
u'\u0ba3\u0bc1',
u'\u0ba3\u0bc2',
u'\u0ba3\u0bc6',
u'\u0ba3\u0bc7',
u'\u0ba3\u0bc8',
u'\u0ba3\u0bca',
u'\u0ba3\u0bcb',
u'\u0ba3\u0bcc',
u'\u0ba4\u0bbe',
u'\u0ba4\u0bbf',
u'\u0ba4\u0bc0',
u'\u0ba4\u0bc1',
u'\u0ba4\u0bc2',
u'\u0ba4\u0bc6',
u'\u0ba4\u0bc7',
u'\u0ba4\u0bc8',
u'\u0ba4\u0bca',
u'\u0ba4\u0bcb',
u'\u0ba4\u0bcc',
u'\u0ba8\u0bbe',
u'\u0ba8\u0bbf',
u'\u0ba8\u0bc0',
u'\u0ba8\u0bc1',
u'\u0ba8\u0bc2',
u'\u0ba8\u0bc6',
u'\u0ba8\u0bc7',
u'\u0ba8\u0bc8',
u'\u0ba8\u0bca',
u'\u0ba8\u0bcb',
u'\u0ba8\u0bcc',
u'\u0baa\u0bbe',
u'\u0baa\u0bbf',
u'\u0baa\u0bc0',
u'\u0baa\u0bc1',
u'\u0baa\u0bc2',
u'\u0baa\u0bc6',
u'\u0baa\u0bc7',
u'\u0baa\u0bc8',
u'\u0baa\u0bca',
u'\u0baa\u0bcb',
u'\u0baa\u0bcc',
u'\u0bae\u0bbe',
u'\u0bae\u0bbf',
u'\u0bae\u0bc0',
u'\u0bae\u0bc1',
u'\u0bae\u0bc2',
u'\u0bae\u0bc6',
u'\u0bae\u0bc7',
u'\u0bae\u0bc8',
u'\u0bae\u0bca',
u'\u0bae\u0bcb',
u'\u0bae\u0bcc',
u'\u0baf\u0bbe',
u'\u0baf\u0bbf',
u'\u0baf\u0bc0',
u'\u0baf\u0bc1',
u'\u0baf\u0bc2',
u'\u0baf\u0bc6',
u'\u0baf\u0bc7',
u'\u0baf\u0bc8',
u'\u0baf\u0bca',
u'\u0baf\u0bcb',
u'\u0baf\u0bcc',
u'\u0bb0\u0bbe',
u'\u0bb0\u0bbf',
u'\u0bb0\u0bc0',
u'\u0bb0\u0bc1',
u'\u0bb0\u0bc2',
u'\u0bb0\u0bc6',
u'\u0bb0\u0bc7',
u'\u0bb0\u0bc8',
u'\u0bb0\u0bca',
u'\u0bb0\u0bcb',
u'\u0bb0\u0bcc',
u'\u0bb2\u0bbe',
u'\u0bb2\u0bbf',
u'\u0bb2\u0bc0',
u'\u0bb2\u0bc1',
u'\u0bb2\u0bc2',
u'\u0bb2\u0bc6',
u'\u0bb2\u0bc7',
u'\u0bb2\u0bc8',
u'\u0bb2\u0bca',
u'\u0bb2\u0bcb',
u'\u0bb2\u0bcc',
u'\u0bb5\u0bbe',
u'\u0bb5\u0bbf',
u'\u0bb5\u0bc0',
u'\u0bb5\u0bc1',
u'\u0bb5\u0bc2',
u'\u0bb5\u0bc6',
u'\u0bb5\u0bc7',
u'\u0bb5\u0bc8',
u'\u0bb5\u0bca',
u'\u0bb5\u0bcb',
u'\u0bb5\u0bcc',
u'\u0bb4\u0bbe',
u'\u0bb4\u0bbf',
u'\u0bb4\u0bc0',
u'\u0bb4\u0bc1',
u'\u0bb4\u0bc2',
u'\u0bb4\u0bc6',
u'\u0bb4\u0bc7',
u'\u0bb4\u0bc8',
u'\u0bb4\u0bca',
u'\u0bb4\u0bcb',
u'\u0bb4\u0bcc',
u'\u0bb3\u0bbe',
u'\u0bb3\u0bbf',
u'\u0bb3\u0bc0',
u'\u0bb3\u0bc1',
u'\u0bb3\u0bc2',
u'\u0bb3\u0bc6',
u'\u0bb3\u0bc7',
u'\u0bb3\u0bc8',
u'\u0bb3\u0bca',
u'\u0bb3\u0bcb',
u'\u0bb3\u0bcc',
u'\u0bb1\u0bbe',
u'\u0bb1\u0bbf',
u'\u0bb1\u0bc0',
u'\u0bb1\u0bc1',
u'\u0bb1\u0bc2',
u'\u0bb1\u0bc6',
u'\u0bb1\u0bc7',
u'\u0bb1\u0bc8',
u'\u0bb1\u0bca',
u'\u0bb1\u0bcb',
u'\u0bb1\u0bcc',
u'\u0ba9\u0bbe',
u'\u0ba9\u0bbf',
u'\u0ba9\u0bc0',
u'\u0ba9\u0bc1',
u'\u0ba9\u0bc2',
u'\u0ba9\u0bc6',
u'\u0ba9\u0bc7',
u'\u0ba9\u0bc8',
u'\u0ba9\u0bca',
u'\u0ba9\u0bcb',
u'\u0ba9\u0bcc',
u'\u0b9c\u0bbe',
u'\u0b9c\u0bbf',
u'\u0b9c\u0bc0',
u'\u0b9c\u0bc1',
u'\u0b9c\u0bc2',
u'\u0b9c\u0bc6',
u'\u0b9c\u0bc7',
u'\u0b9c\u0bc8',
u'\u0b9c\u0bca',
u'\u0b9c\u0bcb',
u'\u0b9c\u0bcc',
u'\u0bb6\u0bbe',
u'\u0bb6\u0bbf',
u'\u0bb6\u0bc0',
u'\u0bb6\u0bc1',
u'\u0bb6\u0bc2',
u'\u0bb6\u0bc6',
u'\u0bb6\u0bc7',
u'\u0bb6\u0bc8',
u'\u0bb6\u0bca',
u'\u0bb6\u0bcb',
u'\u0bb6\u0bcc',
u'\u0bb7\u0bbe',
u'\u0bb7\u0bbf',
u'\u0bb7\u0bc0',
u'\u0bb7\u0bc1',
u'\u0bb7\u0bc2',
u'\u0bb7\u0bc6',
u'\u0bb7\u0bc7',
u'\u0bb7\u0bc8',
u'\u0bb7\u0bca',
u'\u0bb7\u0bcb',
u'\u0bb7\u0bcc',
u'\u0bb8\u0bbe',
u'\u0bb8\u0bbf',
u'\u0bb8\u0bc0',
u'\u0bb8\u0bc1',
u'\u0bb8\u0bc2',
u'\u0bb8\u0bc6',
u'\u0bb8\u0bc7',
u'\u0bb8\u0bc8',
u'\u0bb8\u0bca',
u'\u0bb8\u0bcb',
u'\u0bb8\u0bcc',
u'\u0bb9\u0bbe',
u'\u0bb9\u0bbf',
u'\u0bb9\u0bc0',
u'\u0bb9\u0bc1',
u'\u0bb9\u0bc2',
u'\u0bb9\u0bc6',
u'\u0bb9\u0bc7',
u'\u0bb9\u0bc8',
u'\u0bb9\u0bca',
u'\u0bb9\u0bcb',
u'\u0bb9\u0bcc',
u'\u0b95\u0bcd\u0bb7',
u'\u0b95\u0bcd\u0bb7\u0bbe',
u'\u0b95\u0bcd\u0bb7\u0bbf',
u'\u0b95\u0bcd\u0bb7\u0bc0',
u'\u0b95\u0bcd\u0bb7\u0bc1',
u'\u0b95\u0bcd\u0bb7\u0bc2',
u'\u0b95\u0bcd\u0bb7\u0bc6',
u'\u0b95\u0bcd\u0bb7\u0bc7',
u'\u0b95\u0bcd\u0bb7\u0bc8',
u'\u0b95\u0bcd\u0bb7\u0bca',
u'\u0b95\u0bcd\u0bb7\u0bcb',
u'\u0b95\u0bcd\u0bb7\u0bcc',
u'\u0bb6\u0bcd\u0bb0\u0bc0',
u'\u0dca\u200d\u0dba',
u'\u0dca\u200d\u0dbb',
u'\u0dbb\u0dca\u200d',
u'\u10e3\u0302',
u'\u17d2\u1780',
u'\u17d2\u1781',
u'\u17d2\u1782',
u'\u17d2\u1783',
u'\u17d2\u1784',
u'\u17d2\u1785',
u'\u17d2\u1786',
u'\u17d2\u1787',
u'\u17d2\u1788',
u'\u17d2\u1789',
u'\u17d2\u178a',
u'\u17d2\u178b',
u'\u17d2\u178c',
u'\u17d2\u178d',
u'\u17d2\u178e',
u'\u17d2\u178f',
u'\u17d2\u1790',
u'\u17d2\u1791',
u'\u17d2\u1792',
u'\u17d2\u1793',
u'\u17d2\u1794',
u'\u17d2\u1795',
u'\u17d2\u1796',
u'\u17d2\u1797',
u'\u17d2\u1798',
u'\u17d2\u1799',
u'\u17d2\u179a',
u'\u17d2\u179b',
u'\u17d2\u179c',
u'\u17d2\u179d',
u'\u17d2\u179e',
u'\u17d2\u179f',
u'\u17d2\u17a0',
u'\u17d2\u17a1',
u'\u17d2\u17a2',
u'\u17d2\u17a7',
u'\u17d2\u17ab',
u'\u17d2\u17ac',
u'\u17d2\u17af',
u'\u17bb\u17c6',
u'\u17b6\u17c6',
u'\u304b\u309a',
u'\u304d\u309a',
u'\u304f\u309a',
u'\u3051\u309a',
u'\u3053\u309a',
u'\u30ab\u309a',
u'\u30ad\u309a',
u'\u30af\u309a',
u'\u30b1\u309a',
u'\u30b3\u309a',
u'\u30bb\u309a',
u'\u30c4\u309a',
u'\u30c8\u309a',
u'\u31f7\u309a',
u'\u02e5\u02e9',
u'\u02e9\u02e5',
]


def lookup_named_sequence(code):
    if 0 <= code - 983552 < len(_named_sequences):
        return _named_sequences[code - 983552]
    else:
        return None

_name_aliases = [
0,
0,
1,
1,
2,
2,
3,
3,
4,
4,
5,
5,
6,
6,
7,
7,
8,
8,
9,
9,
9,
9,
10,
10,
10,
10,
10,
10,
11,
11,
11,
12,
12,
13,
13,
14,
14,
14,
15,
15,
15,
16,
16,
17,
17,
18,
18,
19,
19,
20,
20,
21,
21,
22,
22,
23,
23,
24,
24,
25,
25,
26,
26,
27,
27,
28,
28,
28,
29,
29,
29,
30,
30,
30,
31,
31,
31,
32,
127,
127,
128,
128,
129,
129,
130,
130,
131,
131,
132,
132,
133,
133,
134,
134,
135,
135,
136,
136,
136,
137,
137,
137,
138,
138,
138,
139,
139,
139,
140,
140,
140,
141,
141,
141,
142,
142,
142,
143,
143,
143,
144,
144,
145,
145,
145,
146,
146,
146,
147,
147,
148,
148,
149,
149,
150,
150,
150,
151,
151,
151,
152,
152,
153,
153,
154,
154,
155,
155,
156,
156,
157,
157,
158,
158,
159,
159,
160,
173,
418,
419,
847,
1564,
1801,
3294,
3741,
3743,
3747,
3749,
4048,
4588,
4589,
4590,
4591,
6155,
6156,
6157,
6158,
8203,
8204,
8205,
8206,
8207,
8234,
8235,
8236,
8237,
8238,
8239,
8287,
8288,
8294,
8295,
8296,
8297,
8472,
9288,
9289,
11130,
11132,
40981,
65024,
65025,
65026,
65027,
65028,
65029,
65030,
65031,
65032,
65033,
65034,
65035,
65036,
65037,
65038,
65039,
65048,
65279,
65279,
65279,
74452,
74453,
93782,
93783,
93814,
93815,
110593,
118981,
917760,
917761,
917762,
917763,
917764,
917765,
917766,
917767,
917768,
917769,
917770,
917771,
917772,
917773,
917774,
917775,
917776,
917777,
917778,
917779,
917780,
917781,
917782,
917783,
917784,
917785,
917786,
917787,
917788,
917789,
917790,
917791,
917792,
917793,
917794,
917795,
917796,
917797,
917798,
917799,
917800,
917801,
917802,
917803,
917804,
917805,
917806,
917807,
917808,
917809,
917810,
917811,
917812,
917813,
917814,
917815,
917816,
917817,
917818,
917819,
917820,
917821,
917822,
917823,
917824,
917825,
917826,
917827,
917828,
917829,
917830,
917831,
917832,
917833,
917834,
917835,
917836,
917837,
917838,
917839,
917840,
917841,
917842,
917843,
917844,
917845,
917846,
917847,
917848,
917849,
917850,
917851,
917852,
917853,
917854,
917855,
917856,
917857,
917858,
917859,
917860,
917861,
917862,
917863,
917864,
917865,
917866,
917867,
917868,
917869,
917870,
917871,
917872,
917873,
917874,
917875,
917876,
917877,
917878,
917879,
917880,
917881,
917882,
917883,
917884,
917885,
917886,
917887,
917888,
917889,
917890,
917891,
917892,
917893,
917894,
917895,
917896,
917897,
917898,
917899,
917900,
917901,
917902,
917903,
917904,
917905,
917906,
917907,
917908,
917909,
917910,
917911,
917912,
917913,
917914,
917915,
917916,
917917,
917918,
917919,
917920,
917921,
917922,
917923,
917924,
917925,
917926,
917927,
917928,
917929,
917930,
917931,
917932,
917933,
917934,
917935,
917936,
917937,
917938,
917939,
917940,
917941,
917942,
917943,
917944,
917945,
917946,
917947,
917948,
917949,
917950,
917951,
917952,
917953,
917954,
917955,
917956,
917957,
917958,
917959,
917960,
917961,
917962,
917963,
917964,
917965,
917966,
917967,
917968,
917969,
917970,
917971,
917972,
917973,
917974,
917975,
917976,
917977,
917978,
917979,
917980,
917981,
917982,
917983,
917984,
917985,
917986,
917987,
917988,
917989,
917990,
917991,
917992,
917993,
917994,
917995,
917996,
917997,
917998,
917999,
]


def lookup_with_alias(name, with_named_sequence=False):
    code = lookup(name, with_named_sequence=with_named_sequence)
    if 0 <= code - 983040 < len(_name_aliases):
        return _name_aliases[code - 983040]
    else:
        return code

_casefolds = {
5024: [5024],
5025: [5025],
5026: [5026],
5027: [5027],
5028: [5028],
5029: [5029],
5030: [5030],
5031: [5031],
5032: [5032],
5033: [5033],
5034: [5034],
5035: [5035],
5036: [5036],
5037: [5037],
5038: [5038],
5039: [5039],
5040: [5040],
5041: [5041],
5042: [5042],
5043: [5043],
5044: [5044],
5045: [5045],
5046: [5046],
5047: [5047],
5048: [5048],
5049: [5049],
5050: [5050],
5051: [5051],
5052: [5052],
5053: [5053],
5054: [5054],
5055: [5055],
5056: [5056],
5057: [5057],
5058: [5058],
5059: [5059],
5060: [5060],
5061: [5061],
5062: [5062],
5063: [5063],
5064: [5064],
5065: [5065],
5066: [5066],
5067: [5067],
5068: [5068],
5069: [5069],
5070: [5070],
5071: [5071],
5072: [5072],
5073: [5073],
5074: [5074],
5075: [5075],
5076: [5076],
5077: [5077],
5078: [5078],
5079: [5079],
5080: [5080],
5081: [5081],
5082: [5082],
5083: [5083],
5084: [5084],
5085: [5085],
5086: [5086],
5087: [5087],
5088: [5088],
5089: [5089],
5090: [5090],
5091: [5091],
5092: [5092],
5093: [5093],
5094: [5094],
5095: [5095],
5096: [5096],
5097: [5097],
5098: [5098],
5099: [5099],
5100: [5100],
5101: [5101],
5102: [5102],
5103: [5103],
5104: [5104],
5105: [5105],
5106: [5106],
5107: [5107],
5108: [5108],
5109: [5109],
5112: [5104],
5113: [5105],
5114: [5106],
5115: [5107],
5116: [5108],
5117: [5109],
7296: [1074],
7297: [1076],
7298: [1086],
7299: [1089],
7300: [1090],
7301: [1090],
7302: [1098],
7303: [1123],
7304: [42571],
43888: [5024],
43889: [5025],
43890: [5026],
43891: [5027],
43892: [5028],
43893: [5029],
43894: [5030],
43895: [5031],
43896: [5032],
43897: [5033],
43898: [5034],
43899: [5035],
43900: [5036],
43901: [5037],
43902: [5038],
43903: [5039],
43904: [5040],
43905: [5041],
43906: [5042],
43907: [5043],
43908: [5044],
43909: [5045],
43910: [5046],
43911: [5047],
43912: [5048],
43913: [5049],
43914: [5050],
43915: [5051],
43916: [5052],
43917: [5053],
43918: [5054],
43919: [5055],
43920: [5056],
43921: [5057],
43922: [5058],
43923: [5059],
43924: [5060],
43925: [5061],
43926: [5062],
43927: [5063],
43928: [5064],
43929: [5065],
43930: [5066],
43931: [5067],
43932: [5068],
43933: [5069],
43934: [5070],
43935: [5071],
43936: [5072],
43937: [5073],
43938: [5074],
43939: [5075],
43940: [5076],
43941: [5077],
43942: [5078],
43943: [5079],
43944: [5080],
43945: [5081],
43946: [5082],
43947: [5083],
43948: [5084],
43949: [5085],
43950: [5086],
43951: [5087],
43952: [5088],
43953: [5089],
43954: [5090],
43955: [5091],
43956: [5092],
43957: [5093],
43958: [5094],
43959: [5095],
43960: [5096],
43961: [5097],
43962: [5098],
43963: [5099],
43964: [5100],
43965: [5101],
43966: [5102],
43967: [5103],
}

_casefolds_corrected = {
}


def casefold_lookup(code):
    try:
        return _casefolds[code]
    except KeyError:
        if base_mod is not None and code not in _casefolds_corrected:
            return base_mod._casefolds.get(code, None)
        else:
            return None

_combining = {
1631: 220,
2045: 220,
2137: 220,
2138: 220,
2139: 220,
2259: 220,
2260: 230,
2261: 230,
2262: 230,
2263: 230,
2264: 230,
2265: 230,
2266: 230,
2267: 230,
2268: 230,
2269: 230,
2270: 230,
2271: 230,
2272: 230,
2273: 230,
2275: 220,
2276: 230,
2277: 230,
2278: 220,
2279: 230,
2280: 230,
2281: 220,
2282: 230,
2283: 230,
2284: 230,
2285: 220,
2286: 220,
2287: 220,
2288: 27,
2289: 28,
2290: 29,
2291: 230,
2292: 230,
2293: 230,
2294: 220,
2295: 230,
2296: 230,
2297: 220,
2298: 220,
2299: 230,
2300: 230,
2301: 230,
2302: 230,
2303: 230,
2558: 230,
3387: 9,
3388: 9,
4957: 230,
4958: 230,
6832: 230,
6833: 230,
6834: 230,
6835: 230,
6836: 230,
6837: 220,
6838: 220,
6839: 220,
6840: 220,
6841: 220,
6842: 220,
6843: 230,
6844: 230,
6845: 220,
7083: 9,
7142: 7,
7154: 9,
7155: 9,
7412: 230,
7416: 230,
7417: 230,
7655: 230,
7656: 230,
7657: 230,
7658: 230,
7659: 230,
7660: 230,
7661: 230,
7662: 230,
7663: 230,
7664: 230,
7665: 230,
7666: 230,
7667: 230,
7668: 230,
7669: 230,
7670: 232,
7671: 228,
7672: 228,
7673: 220,
7675: 230,
7676: 233,
11647: 9,
42612: 230,
42613: 230,
42614: 230,
42615: 230,
42616: 230,
42617: 230,
42618: 230,
42619: 230,
42654: 230,
42655: 230,
43766: 9,
65063: 220,
65064: 220,
65065: 220,
65066: 220,
65067: 220,
65068: 220,
65069: 220,
65070: 230,
65071: 230,
66272: 220,
66422: 230,
66423: 230,
66424: 230,
66425: 230,
66426: 230,
68325: 230,
68326: 220,
68900: 230,
68901: 230,
68902: 230,
68903: 230,
69446: 220,
69447: 220,
69448: 230,
69449: 230,
69450: 230,
69451: 220,
69452: 230,
69453: 220,
69454: 220,
69455: 220,
69456: 220,
69702: 9,
69759: 9,
69888: 230,
69889: 230,
69890: 230,
69939: 9,
69940: 9,
70003: 7,
70080: 9,
70090: 7,
70197: 9,
70198: 7,
70377: 7,
70378: 9,
70459: 7,
70460: 7,
70477: 9,
70502: 230,
70503: 230,
70504: 230,
70505: 230,
70506: 230,
70507: 230,
70508: 230,
70512: 230,
70513: 230,
70514: 230,
70515: 230,
70516: 230,
70722: 9,
70726: 7,
70750: 230,
70850: 9,
70851: 7,
71103: 9,
71104: 7,
71231: 9,
71350: 9,
71351: 7,
71467: 9,
71737: 9,
71738: 7,
72244: 9,
72263: 9,
72345: 9,
72767: 9,
73026: 7,
73028: 9,
73029: 9,
73111: 9,
92912: 1,
92913: 1,
92914: 1,
92915: 1,
92916: 1,
92976: 230,
92977: 230,
92978: 230,
92979: 230,
92980: 230,
92981: 230,
92982: 230,
113822: 1,
122880: 230,
122881: 230,
122882: 230,
122883: 230,
122884: 230,
122885: 230,
122886: 230,
122888: 230,
122889: 230,
122890: 230,
122891: 230,
122892: 230,
122893: 230,
122894: 230,
122895: 230,
122896: 230,
122897: 230,
122898: 230,
122899: 230,
122900: 230,
122901: 230,
122902: 230,
122903: 230,
122904: 230,
122907: 230,
122908: 230,
122909: 230,
122910: 230,
122911: 230,
122912: 230,
122913: 230,
122915: 230,
122916: 230,
122918: 230,
122919: 230,
122920: 230,
122921: 230,
122922: 230,
125136: 220,
125137: 220,
125138: 220,
125139: 220,
125140: 220,
125141: 220,
125142: 220,
125252: 230,
125253: 230,
125254: 230,
125255: 230,
125256: 230,
125257: 230,
125258: 7,
}

_combining_corrected = {
}


def combining(code):
    try:
        return _combining[code]
    except KeyError:
        if base_mod is not None and code not in _combining_corrected:
            return base_mod._combining.get(code, 0)
        else:
            return 0

