#!/bin/bash
echo "A regular release requires the following steps:"
echo "  - Execute 'bump.sh patch'"
echo "    - Increments versions in configured files"
echo "      - Patch level part is incremented (1.1.X)"
echo "      - See .bumpversion.cfg for details"
echo "    - Creates local git tag"
echo "  - Execute 'git push --follow-tags'"
echo "    - Latest commits are pushed"
echo "    - Latest git tags are pushed"
echo "    - Github actions release workflow is triggered"
echo "      - Reacts on tags named v*"
echo "      - A github release is created"
echo "      - and connected to the tag just pushed."
echo "      - If a release with the pushed tag version was online already, it"
echo "        will be used instead of creating a new one."
echo "  - Fill out the prepared release notes on github"
echo "    - Use the \"Generate release notes\" button to get started."
echo "    - Add to the sections with changes"
echo "    - Delete the sections without news"
echo "    - Keep a consistent format between releases as good as possible."
echo "  - Execute 'pypi.sh'"
echo "    - Builds package (wheel)"
echo "    - Uploads to Test-PyPI"
echo "    - Execute the suggested install command to briefly test the package"
echo "    - Execute the suggested command to finally upload to real PyPI"
echo "  - If things go wrong, refer to release_troubleshooting.txt"
