#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (C) 2007 Søren Roug, European Environment Agency
#
# This is free software.  You may redistribute it under the terms
# of the Apache license and the GNU General Public License Version
# 2 or at your option any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#

import unittest
from odf import chart, draw, presentation, style, svg

from odf.element import IllegalChild

class TestDrawElements(unittest.TestCase):

    def test_calls(self):
        """ Simple calls """
        chart.Chart( attributes={'class':'chart:bar'}, height="0cm" )
        chart.Chart( attributes={'class':'chart:bar'}, width="0cm" )
        draw.AreaCircle( cy="1cm", cx="1cm", r="0cm" )
        draw.AreaPolygon( height="1cm", points="0,0 1,1", y="1cm", x="1cm", viewbox="0 0 1000 1000", width="0cm" )
        draw.AreaPolygon( height="1cm", width="1cm", points="0,0 1,1", x="1cm", viewbox="0 0 1000 1000", y="0cm" )
        draw.AreaPolygon( height="1cm", width="1cm", points="0,0 1,1", y="1cm", viewbox="0 0 1000 1000", x="0cm" )
        draw.AreaPolygon( width="1cm", points="0,0 1,1", y="1cm", x="1cm", viewbox="0 0 1000 1000", height="0cm" )
        draw.AreaRectangle( x="1cm", height="1cm", width="1cm", y="0cm" )
        draw.AreaRectangle( y="1cm", height="1cm", width="1cm", x="0cm" )
        draw.AreaRectangle( y="1cm", x="1cm", height="1cm", width="0cm" )
        draw.AreaRectangle( y="1cm", x="1cm", width="1cm", height="0cm" )
        draw.ContourPath( recreateonedit="true", viewbox="0 0 1000 1000", d="1cm", height="0cm" )
        draw.ContourPath( recreateonedit="true", viewbox="0 0 1000 1000", d="1cm", width="0cm" )
        draw.ContourPolygon( points="0,0 1,1", recreateonedit="true", viewbox="0 0 1000 1000", height="0cm" )
        draw.ContourPolygon( points="0,0 1,1", recreateonedit="true", viewbox="0 0 1000 1000", width="0cm" )
        draw.Control( control="1cm", endx="0cm" )
        draw.Control( control="1cm", endy="0cm" )
        draw.Control( control="1cm", height="0cm" )
        draw.Control( control="1cm", width="0cm" )
        draw.Control( control="1cm", x="0cm" )
        draw.Control( control="1cm", y="0cm" )
        draw.FillImage( href="1cm", type="simple", name="1cm", height="0cm" )
        draw.FillImage( href="1cm", type="simple", name="1cm", width="0cm" )
        draw.GluePoint( x="1cm", align="1cm", id="1cm", y="0cm", escapedirection="right" )
        draw.GluePoint( y="1cm", align="1cm", id="1cm", x="0cm", escapedirection="right" )
        draw.Line( x2="1cm", x1="1cm", y2="1cm", y1="0cm" )
        draw.Line( y1="1cm", x1="1cm", y2="1cm", x2="0cm" )
        draw.Line( y1="1cm", x2="1cm", x1="1cm", y2="0cm" )
        draw.Line( y1="1cm", x2="1cm", x1="1cm", y2="1cm", endx="0cm" )
        draw.Line( y1="1cm", x2="1cm", x1="1cm", y2="1cm", endy="0cm" )
        draw.Line( y1="1cm", x2="1cm", y2="1cm", x1="0cm" )
        draw.Measure( x2="1cm", x1="1cm", y2="1cm", y1="0cm" )
        draw.Measure( y1="1cm", x1="1cm", y2="1cm", x2="0cm" )
        draw.Measure( y1="1cm", x2="1cm", x1="1cm", y2="0cm" )
        draw.Measure( y1="1cm", x2="1cm", x1="1cm", y2="1cm", endx="0cm" )
        draw.Measure( y1="1cm", x2="1cm", x1="1cm", y2="1cm", endy="0cm" )
        draw.Measure( y1="1cm", x2="1cm", y2="1cm", x1="0cm" )
        draw.Path( d="1cm", viewbox="0 0 1000 1000", endx="0cm" )
        draw.Path( d="1cm", viewbox="0 0 1000 1000", endy="0cm" )
        draw.Path( d="1cm", viewbox="0 0 1000 1000", height="0cm" )
        draw.Path( d="1cm", viewbox="0 0 1000 1000", width="0cm" )
        draw.Path( d="1cm", viewbox="0 0 1000 1000", x="0cm" )
        draw.Path( d="1cm", viewbox="0 0 1000 1000", y="0cm" )
        draw.Polygon( points="0,0 1,1", viewbox="0 0 1000 1000", endx="0cm" )
        draw.Polygon( points="0,0 1,1", viewbox="0 0 1000 1000", endy="0cm" )
        draw.Polygon( points="0,0 1,1", viewbox="0 0 1000 1000", height="0cm" )
        draw.Polygon( points="0,0 1,1", viewbox="0 0 1000 1000", width="0cm" )
        draw.Polygon( points="0,0 1,1", viewbox="0 0 1000 1000", x="0cm" )
        draw.Polygon( points="0,0 1,1", viewbox="0 0 1000 1000", y="0cm" )
        draw.Polyline( points="0,0 1,1", viewbox="0 0 1000 1000", endx="0cm" )
        draw.Polyline( points="0,0 1,1", viewbox="0 0 1000 1000", endy="0cm" )
        draw.Polyline( points="0,0 1,1", viewbox="0 0 1000 1000", height="0cm" )
        draw.Polyline( points="0,0 1,1", viewbox="0 0 1000 1000", width="0cm" )
        draw.Polyline( points="0,0 1,1", viewbox="0 0 1000 1000", x="0cm" )
        draw.Polyline( points="0,0 1,1", viewbox="0 0 1000 1000", y="0cm" )
        draw.RegularPolygon( corners="1cm", endx="0cm" )
        draw.RegularPolygon( corners="1cm", endy="0cm" )
        draw.RegularPolygon( corners="1cm", height="0cm" )
        draw.RegularPolygon( corners="1cm", width="0cm" )
        draw.RegularPolygon( corners="1cm", x="0cm" )
        draw.RegularPolygon( corners="1cm", y="0cm" )
        draw.StrokeDash( name="1cm", dots1length="0cm" )
        draw.StrokeDash( name="1cm", dots2length="0cm" )
        presentation.Placeholder( x="1cm", height="1cm", object="1cm", width="1cm", y="0cm" )
        presentation.Placeholder( y="1cm", height="1cm", object="1cm", width="1cm", x="0cm" )
        presentation.Placeholder( y="1cm", x="1cm", height="1cm", object="1cm", width="0cm" )
        presentation.Placeholder( y="1cm", x="1cm", object="1cm", width="1cm", height="0cm" )
        style.Column( relwidth="1cm", endindent="0cm" )
        style.Column( relwidth="1cm", spaceafter="0cm" )
        style.Column( relwidth="1cm", spacebefore="0cm" )
        style.Column( relwidth="1cm", startindent="0cm" )
        style.Columns( columncount="1cm", columngap="0cm" )
        style.TabStop( position="0cm" )
        svg.Lineargradient( name="1cm", x1="0cm" )
        svg.Lineargradient( name="1cm", x2="0cm" )
        svg.Lineargradient( name="1cm", y1="0cm" )
        svg.Lineargradient( name="1cm", y2="0cm" )
        svg.Radialgradient( name="1cm", r="0cm" )

    def test_invalid_length(self):
        """ Fail is the length is invalid """
        self.assertRaises(ValueError, chart.Chart, attributes={'class':'chart:bar'}, height="xxx" )
        self.assertRaises(ValueError, chart.Chart, attributes={'class':'chart:bar'}, width="xxx" )
        self.assertRaises(ValueError, draw.AreaCircle, cy="1cm", cx="1cm", r="xxx" )
        self.assertRaises(ValueError, draw.AreaPolygon, height="1cm", points="0,0 1,1", y="1cm", x="1cm", viewbox="0 0 1000 1000", width="xxx" )
        self.assertRaises(ValueError, draw.AreaPolygon, height="1cm", width="1cm", points="0,0 1,1", x="1cm", viewbox="0 0 1000 1000", y="xxx" )
        self.assertRaises(ValueError, draw.AreaPolygon, height="1cm", width="1cm", points="0,0 1,1", y="1cm", viewbox="0 0 1000 1000", x="xxx" )
        self.assertRaises(ValueError, draw.AreaPolygon, width="1cm", points="0,0 1,1", y="1cm", x="1cm", viewbox="0 0 1000 1000", height="xxx" )
        self.assertRaises(ValueError, draw.AreaRectangle, x="1cm", height="1cm", width="1cm", y="xxx" )
        self.assertRaises(ValueError, draw.AreaRectangle, y="1cm", height="1cm", width="1cm", x="xxx" )
        self.assertRaises(ValueError, draw.AreaRectangle, y="1cm", x="1cm", height="1cm", width="xxx" )
        self.assertRaises(ValueError, draw.AreaRectangle, y="1cm", x="1cm", width="1cm", height="xxx" )
        self.assertRaises(ValueError, draw.ContourPath, recreateonedit="true", viewbox="0 0 1000 1000", d="1cm", height="xxx" )
        self.assertRaises(ValueError, draw.ContourPath, recreateonedit="true", viewbox="0 0 1000 1000", d="1cm", width="xxx" )
        self.assertRaises(ValueError, draw.ContourPolygon, points="0,0 1,1", recreateonedit="true", viewbox="0 0 1000 1000", height="xxx" )
        self.assertRaises(ValueError, draw.ContourPolygon, points="0,0 1,1", recreateonedit="true", viewbox="0 0 1000 1000", width="xxx" )
        self.assertRaises(ValueError, draw.Control, control="1cm", endx="xxx" )
        self.assertRaises(ValueError, draw.Control, control="1cm", endy="xxx" )
        self.assertRaises(ValueError, draw.Control, control="1cm", height="xxx" )
        self.assertRaises(ValueError, draw.Control, control="1cm", width="xxx" )
        self.assertRaises(ValueError, draw.Control, control="1cm", x="xxx" )
        self.assertRaises(ValueError, draw.Control, control="1cm", y="xxx" )
        self.assertRaises(ValueError, draw.FillImage, href="1cm", name="1cm", height="xxx" )
        self.assertRaises(ValueError, draw.FillImage, href="1cm", name="1cm", width="xxx" )
        self.assertRaises(ValueError, draw.GluePoint, x="1cm", align="1cm", id="1cm", y="xxx", escapedirection="right" )
        self.assertRaises(ValueError, draw.GluePoint, y="1cm", align="1cm", id="1cm", x="xxx", escapedirection="right" )
        self.assertRaises(ValueError, draw.Line, x2="1cm", x1="1cm", y2="1cm", y1="xxx" )
        self.assertRaises(ValueError, draw.Line, y1="1cm", x1="1cm", y2="1cm", x2="xxx" )
        self.assertRaises(ValueError, draw.Line, y1="1cm", x2="1cm", x1="1cm", y2="xxx" )
        self.assertRaises(ValueError, draw.Line, y1="1cm", x2="1cm", x1="1cm", y2="1cm", endx="xxx" )
        self.assertRaises(ValueError, draw.Line, y1="1cm", x2="1cm", x1="1cm", y2="1cm", endy="xxx" )
        self.assertRaises(ValueError, draw.Line, y1="1cm", x2="1cm", y2="1cm", x1="xxx" )
        self.assertRaises(ValueError, draw.Measure, x2="1cm", x1="1cm", y2="1cm", y1="xxx" )
        self.assertRaises(ValueError, draw.Measure, y1="1cm", x1="1cm", y2="1cm", x2="xxx" )
        self.assertRaises(ValueError, draw.Measure, y1="1cm", x2="1cm", x1="1cm", y2="xxx" )
        self.assertRaises(ValueError, draw.Measure, y1="1cm", x2="1cm", x1="1cm", y2="1cm", endx="xxx" )
        self.assertRaises(ValueError, draw.Measure, y1="1cm", x2="1cm", x1="1cm", y2="1cm", endy="xxx" )
        self.assertRaises(ValueError, draw.Measure, y1="1cm", x2="1cm", y2="1cm", x1="xxx" )
        self.assertRaises(ValueError, draw.Path, d="1cm", viewbox="0 0 1000 1000", endx="xxx" )
        self.assertRaises(ValueError, draw.Path, d="1cm", viewbox="0 0 1000 1000", endy="xxx" )
        self.assertRaises(ValueError, draw.Path, d="1cm", viewbox="0 0 1000 1000", height="xxx" )
        self.assertRaises(ValueError, draw.Path, d="1cm", viewbox="0 0 1000 1000", width="xxx" )
        self.assertRaises(ValueError, draw.Path, d="1cm", viewbox="0 0 1000 1000", x="xxx" )
        self.assertRaises(ValueError, draw.Path, d="1cm", viewbox="0 0 1000 1000", y="xxx" )
        self.assertRaises(ValueError, draw.Polygon, points="0,0 1,1", viewbox="0 0 1000 1000", endx="xxx" )
        self.assertRaises(ValueError, draw.Polygon, points="0,0 1,1", viewbox="0 0 1000 1000", endy="xxx" )
        self.assertRaises(ValueError, draw.Polygon, points="0,0 1,1", viewbox="0 0 1000 1000", height="xxx" )
        self.assertRaises(ValueError, draw.Polygon, points="0,0 1,1", viewbox="0 0 1000 1000", width="xxx" )
        self.assertRaises(ValueError, draw.Polygon, points="0,0 1,1", viewbox="0 0 1000 1000", x="xxx" )
        self.assertRaises(ValueError, draw.Polygon, points="0,0 1,1", viewbox="0 0 1000 1000", y="xxx" )
        self.assertRaises(ValueError, draw.Polyline, points="0,0 1,1", viewbox="0 0 1000 1000", endx="xxx" )
        self.assertRaises(ValueError, draw.Polyline, points="0,0 1,1", viewbox="0 0 1000 1000", endy="xxx" )
        self.assertRaises(ValueError, draw.Polyline, points="0,0 1,1", viewbox="0 0 1000 1000", height="xxx" )
        self.assertRaises(ValueError, draw.Polyline, points="0,0 1,1", viewbox="0 0 1000 1000", width="xxx" )
        self.assertRaises(ValueError, draw.Polyline, points="0,0 1,1", viewbox="0 0 1000 1000", x="xxx" )
        self.assertRaises(ValueError, draw.Polyline, points="0,0 1,1", viewbox="0 0 1000 1000", y="xxx" )
        self.assertRaises(ValueError, draw.RegularPolygon, corners="1cm", endx="xxx" )
        self.assertRaises(ValueError, draw.RegularPolygon, corners="1cm", endy="xxx" )
        self.assertRaises(ValueError, draw.RegularPolygon, corners="1cm", height="xxx" )
        self.assertRaises(ValueError, draw.RegularPolygon, corners="1cm", width="xxx" )
        self.assertRaises(ValueError, draw.RegularPolygon, corners="1cm", x="xxx" )
        self.assertRaises(ValueError, draw.RegularPolygon, corners="1cm", y="xxx" )
        self.assertRaises(ValueError, draw.StrokeDash, name="1cm", dots1length="xxx" )
        self.assertRaises(ValueError, draw.StrokeDash, name="1cm", dots2length="xxx" )
        self.assertRaises(ValueError, presentation.Placeholder, x="1cm", height="1cm", object="1cm", width="1cm", y="xxx" )
        self.assertRaises(ValueError, presentation.Placeholder, y="1cm", height="1cm", object="1cm", width="1cm", x="xxx" )
        self.assertRaises(ValueError, presentation.Placeholder, y="1cm", x="1cm", height="1cm", object="1cm", width="xxx" )
        self.assertRaises(ValueError, presentation.Placeholder, y="1cm", x="1cm", object="1cm", width="1cm", height="xxx" )
        self.assertRaises(ValueError, style.Column, relwidth="1cm", endindent="xxx" )
        self.assertRaises(ValueError, style.Column, relwidth="1cm", spaceafter="xxx" )
        self.assertRaises(ValueError, style.Column, relwidth="1cm", spacebefore="xxx" )
        self.assertRaises(ValueError, style.Column, relwidth="1cm", startindent="xxx" )
        self.assertRaises(ValueError, style.Columns, columncount="1cm", columngap="xxx" )
        self.assertRaises(ValueError, style.TabStop, position="xxx" )
        self.assertRaises(ValueError, svg.Lineargradient, name="1cm", x1="xxx" )
        self.assertRaises(ValueError, svg.Lineargradient, name="1cm", x2="xxx" )
        self.assertRaises(ValueError, svg.Lineargradient, name="1cm", y1="xxx" )
        self.assertRaises(ValueError, svg.Lineargradient, name="1cm", y2="xxx" )
        self.assertRaises(ValueError, svg.Radialgradient, name="1cm", r="xxx" )

if __name__ == '__main__':
    unittest.main()
