/**************************************************************************
 * Copyright 2009-2015 Olivier Belanger                                   *
 *                                                                        *
 * This file is part of pyo, a python module to help digital signal       *
 * processing script creation.                                            *
 *                                                                        *
 * pyo is free software: you can redistribute it and/or modify            *
 * it under the terms of the GNU Lesser General Public License as         *
 * published by the Free Software Foundation, either version 3 of the     *
 * License, or (at your option) any later version.                        *
 *                                                                        *
 * pyo is distributed in the hope that it will be useful,                 *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 * GNU Lesser General Public License for more details.                    *
 *                                                                        *
 * You should have received a copy of the GNU Lesser General Public       *
 * License along with pyo.  If not, see <http://www.gnu.org/licenses/>.   *
 *************************************************************************/

#include <Python.h>
#include "py2to3.h"
#include "structmember.h"
#include <math.h>
#include "pyomodule.h"
#include "streammodule.h"
#include "servermodule.h"
#include "dummymodule.h"

// halfsine window
static MYFLT ENVELOPE[8193] = {0.0, 0.0003834952076431364, 0.0007669903570786119, 0.001150485360994935, 0.0015339802484959364, 0.001917474903166294, 0.0023009690921753645, 0.002684463281184435, 0.0030679567717015743, 0.00345145002938807, 0.0038349428214132786, 0.004218434914946556, 0.004601926077157259, 0.004985417239367962, 0.00536890747025609, 0.0057523963041603565, 0.006135884672403336, 0.006519372574985027, 0.00690285861492157, 0.007286344654858112, 0.007669829297810793, 0.008053313009440899, 0.008436795324087143, 0.008820274844765663, 0.009203754365444183, 0.009587232954800129, 0.0099707106128335, 0.010354185476899147, 0.01073765940964222, 0.011121131479740143, 0.011504601687192917, 0.011888070963323116, 0.012271538376808167, 0.012655003927648067, 0.01303846761584282, 0.013421929441392422, 0.0138053884729743, 0.014188846573233604, 0.014572301879525185, 0.014955755323171616, 0.015339206904172897, 0.01572265475988388, 0.016106102615594864, 0.01648954674601555, 0.016872989013791084, 0.01725642755627632, 0.01763986423611641, 0.018023299053311348, 0.018406730145215988, 0.01879015937447548, 0.01917358487844467, 0.019557010382413864, 0.01994042843580246, 0.020323846489191055, 0.020707260817289352, 0.02109067142009735, 0.02147408202290535, 0.02185748517513275, 0.022240886464715004, 0.022624287754297256, 0.023007681593298912, 0.023391075432300568, 0.023774461820721626, 0.024157848209142685, 0.024541229009628296, 0.02492460608482361, 0.02530798129737377, 0.025691350921988487, 0.026074718683958054, 0.026458080857992172, 0.02684144116938114, 0.027224795892834663, 0.027608145028352737, 0.02799149416387081, 0.02837483584880829, 0.028758175671100616, 0.029141509905457497, 0.02952483855187893, 0.029908165335655212, 0.030291486531496048, 0.030674804002046585, 0.031058115884661674, 0.031441424041986465, 0.03182472661137581, 0.03220802918076515, 0.0325913168489933, 0.03297460824251175, 0.0333578921854496, 0.03374117612838745, 0.03412444517016411, 0.034507717937231064, 0.03489098325371742, 0.035274237394332886, 0.03565749153494835, 0.036040741950273514, 0.03642398864030838, 0.03680722415447235, 0.037190455943346024, 0.0375736840069294, 0.037956904619932175, 0.03834012150764465, 0.038723330944776535, 0.03910653665661812, 0.039489734917879105, 0.03987292945384979, 0.04025611653923988, 0.04063929617404938, 0.04102247208356857, 0.04140564426779747, 0.04178880527615547, 0.042171962559223175, 0.04255511239171028, 0.04293825849890709, 0.043321393430233, 0.043704528361558914, 0.04408765584230423, 0.04447077214717865, 0.04485388472676277, 0.045236993581056595, 0.04562009125947952, 0.046003181487321854, 0.046386267989873886, 0.04676935076713562, 0.04715241864323616, 0.0475354865193367, 0.047918543219566345, 0.04830159619450569, 0.04868463799357414, 0.049067676067352295, 0.04945070669054985, 0.04983372613787651, 0.05021674185991287, 0.05059975013136864, 0.050982750952243805, 0.05136574059724808, 0.05174873024225235, 0.05213170871138573, 0.05251467600464821, 0.05289763957262039, 0.05328059196472168, 0.05366354063153267, 0.05404647812247276, 0.05442940816283226, 0.05481233075261116, 0.055195245891809464, 0.05557815358042717, 0.05596105009317398, 0.05634394288063049, 0.05672682076692581, 0.05710969492793083, 0.057492561638355255, 0.05787541717290878, 0.058258265256881714, 0.05864110589027405, 0.059023935347795486, 0.05940675735473633, 0.05978957191109657, 0.06017237901687622, 0.060555171221494675, 0.06093795970082283, 0.06132074072957039, 0.061703506857156754, 0.06208626553416252, 0.062469013035297394, 0.06285175681114197, 0.06323449313640594, 0.06361721456050873, 0.06399992853403091, 0.0643826350569725, 0.0647653341293335, 0.0651480108499527, 0.0655306875705719, 0.0659133568406105, 0.06629601120948792, 0.06667865812778473, 0.06706129759550095, 0.06744392216205597, 0.0678265318274498, 0.06820914149284363, 0.06859174370765686, 0.0689743310213089, 0.06935691088438034, 0.06973947584629059, 0.07012203335762024, 0.0705045759677887, 0.07088711112737656, 0.07126963883638382, 0.07165215164422989, 0.07203465700149536, 0.07241715490818024, 0.07279963791370392, 0.07318209856748581, 0.0735645666718483, 0.073947012424469, 0.07432945817708969, 0.0747118890285492, 0.0750943049788475, 0.07547671347856522, 0.07585909962654114, 0.07624148577451706, 0.07662386447191238, 0.07700622826814651, 0.07738857716321945, 0.07777091860771179, 0.07815324515104294, 0.07853555679321289, 0.07891786098480225, 0.079300157725811, 0.07968243956565857, 0.08006471395492554, 0.08044697344303131, 0.08082921802997589, 0.08121144771575928, 0.08159366995096207, 0.08197588473558426, 0.08235808461904526, 0.08274026960134506, 0.08312244713306427, 0.08350460231304169, 0.08388675004243851, 0.08426889032125473, 0.08465101569890976, 0.0850331261754036, 0.08541522920131683, 0.08579731732606888, 0.08617938309907913, 0.08656144887208939, 0.08694349974393845, 0.08732553571462631, 0.08770756423473358, 0.08808957040309906, 0.08847157657146454, 0.08885355293750763, 0.08923552185297012, 0.08961748331785202, 0.08999942988157272, 0.09038136154413223, 0.09076328575611115, 0.09114518761634827, 0.0915270745754242, 0.09190895408391953, 0.09229082614183426, 0.0926726758480072, 0.09305451810359955, 0.0934363380074501, 0.09381815046072006, 0.09419994056224823, 0.0945817232131958, 0.09496349841356277, 0.09534525126218796, 0.09572699666023254, 0.09610871970653534, 0.09649043530225754, 0.09687212854623795, 0.09725381433963776, 0.09763548523187637, 0.0980171412229538, 0.09839878231287003, 0.09878041595220566, 0.0991620272397995, 0.09954361617565155, 0.0999252051115036, 0.10030677169561386, 0.10068832337856293, 0.1010698676109314, 0.10145138949155807, 0.10183290392160416, 0.10221438854932785, 0.10259587317705154, 0.10297733545303345, 0.10335878282785416, 0.10374022275209427, 0.10412164032459259, 0.10450304299592972, 0.10488442331552505, 0.1052657961845398, 0.10564715415239334, 0.1060284972190857, 0.10640982538461685, 0.10679113864898682, 0.10717242956161499, 0.10755370557308197, 0.10793496668338776, 0.10831621289253235, 0.10869744420051575, 0.10907866060733795, 0.10945986211299896, 0.10984104871749878, 0.11022220551967621, 0.11060336232185364, 0.11098449677228928, 0.11136561632156372, 0.11174671351909637, 0.11212780326604843, 0.1125088706612587, 0.11288991570472717, 0.11327095329761505, 0.11365197598934174, 0.11403297632932663, 0.11441396176815033, 0.11479493230581284, 0.11517588049173355, 0.11555681377649307, 0.1159377321600914, 0.11631863564252853, 0.11669951677322388, 0.11708038300275803, 0.11746123433113098, 0.11784206330776215, 0.11822287738323212, 0.1186036765575409, 0.11898445338010788, 0.11936521530151367, 0.11974596232175827, 0.12012669444084167, 0.12050739675760269, 0.12088809162378311, 0.12126876413822174, 0.12164942175149918, 0.12203005701303482, 0.12241067737340927, 0.12279128283262253, 0.1231718584895134, 0.12355242669582367, 0.12393298000097275, 0.12431351095438004, 0.12469401210546494, 0.12507450580596924, 0.12545497715473175, 0.12583543360233307, 0.1262158751487732, 0.12659630179405212, 0.12697669863700867, 0.12735708057880402, 0.12773744761943817, 0.12811778485774994, 0.1284981220960617, 0.1288784295320511, 0.12925872206687927, 0.12963898479938507, 0.13001921772956848, 0.1303994506597519, 0.1307796686887741, 0.13115985691547394, 0.13154003024101257, 0.13192018866539001, 0.13230031728744507, 0.13268043100833893, 0.1330605298280716, 0.13344061374664307, 0.13382066786289215, 0.13420070707798004, 0.13458071649074554, 0.13496069610118866, 0.13534067571163177, 0.1357206404209137, 0.13610057532787323, 0.13648049533367157, 0.13686038553714752, 0.13724026083946228, 0.13762012124061584, 0.13799996674060822, 0.1383797824382782, 0.138759583234787, 0.1391393542289734, 0.1395191103219986, 0.13989883661270142, 0.14027854800224304, 0.14065824449062347, 0.14103791117668152, 0.14141756296157837, 0.14179719984531403, 0.1421768069267273, 0.14255639910697937, 0.14293596148490906, 0.14331550896167755, 0.14369504153728485, 0.14407454431056976, 0.14445403218269348, 0.1448334902524948, 0.14521293342113495, 0.1455923467874527, 0.14597174525260925, 0.14635111391544342, 0.1467304676771164, 0.14710980653762817, 0.14748911559581757, 0.14786840975284576, 0.14824768900871277, 0.14862693846225739, 0.14900615811347961, 0.14938536286354065, 0.1497645378112793, 0.15014369785785675, 0.150522843003273, 0.1509019434452057, 0.15128104388713837, 0.15166011452674866, 0.15203915536403656, 0.15241818130016327, 0.15279719233512878, 0.1531761735677719, 0.15355512499809265, 0.1539340615272522, 0.15431298315525055, 0.1546918749809265, 0.1550707370042801, 0.15544958412647247, 0.15582841634750366, 0.15620718896389008, 0.15658597648143768, 0.1569647192955017, 0.15734346210956573, 0.15772216022014618, 0.15810084342956543, 0.1584795117378235, 0.15885815024375916, 0.15923675894737244, 0.15961535274982452, 0.15999391674995422, 0.16037246584892273, 0.16075098514556885, 0.16112948954105377, 0.16150794923305511, 0.16188639402389526, 0.16226482391357422, 0.1626432240009308, 0.16302159428596497, 0.16339994966983795, 0.16377829015254974, 0.16415658593177795, 0.16453486680984497, 0.1649131327867508, 0.16529136896133423, 0.16566957533359528, 0.16604775190353394, 0.1664258986711502, 0.16680403053760529, 0.16718214750289917, 0.16756023466587067, 0.16793829202651978, 0.1683163344860077, 0.16869434714317322, 0.16907232999801636, 0.1694502979516983, 0.16982823610305786, 0.17020614445209503, 0.170584037899971, 0.1709619015455246, 0.1713397353887558, 0.1717175394296646, 0.17209532856941223, 0.17247308790683746, 0.1728508174419403, 0.17322853207588196, 0.17360621690750122, 0.1739838719367981, 0.17436151206493378, 0.17473912239074707, 0.17511670291423798, 0.1754942685365677, 0.17587178945541382, 0.17624929547309875, 0.1766267865896225, 0.17700421810150146, 0.17738164961338043, 0.177759051322937, 0.1781364232301712, 0.1785137802362442, 0.17889109253883362, 0.17926838994026184, 0.17964565753936768, 0.18002291023731232, 0.18040011823177338, 0.18077731132507324, 0.18115447461605072, 0.181531623005867, 0.1819087266921997, 0.18228580057621002, 0.18266285955905914, 0.18303988873958588, 0.18341688811779022, 0.18379387259483337, 0.18417081236839294, 0.18454773724079132, 0.1849246323108673, 0.1853015124797821, 0.18567834794521332, 0.18605515360832214, 0.18643194437026978, 0.18680870532989502, 0.18718543648719788, 0.18756212294101715, 0.18793880939483643, 0.18831545114517212, 0.18869207799434662, 0.18906866014003754, 0.18944522738456726, 0.1898217648267746, 0.19019828736782074, 0.1905747652053833, 0.19095121324062347, 0.19132764637470245, 0.19170403480529785, 0.19208040833473206, 0.19245675206184387, 0.1928330510854721, 0.19320933520793915, 0.1935855895280838, 0.19396181404590607, 0.19433800876140594, 0.19471418857574463, 0.19509032368659973, 0.19546644389629364, 0.19584251940250397, 0.1962185800075531, 0.19659461081027985, 0.1969706118106842, 0.19734656810760498, 0.19772249460220337, 0.19809840619564056, 0.19847428798675537, 0.1988501399755478, 0.19922596216201782, 0.19960175454616547, 0.19997753202915192, 0.20035326480865479, 0.20072896778583527, 0.20110464096069336, 0.20148028433322906, 0.20185591280460358, 0.2022314965724945, 0.20260705053806305, 0.202982559800148, 0.20335806906223297, 0.20373353362083435, 0.20410896837711334, 0.20448437333106995, 0.20485974848270416, 0.20523510873317719, 0.20561042428016663, 0.20598571002483368, 0.20636096596717834, 0.20673619210720062, 0.2071113884449005, 0.20748655498027802, 0.20786169171333313, 0.20823678374290466, 0.2086118459701538, 0.20898689329624176, 0.20936191082000732, 0.2097368836402893, 0.2101118415594101, 0.2104867547750473, 0.21086165308952332, 0.21123650670051575, 0.2116113305091858, 0.21198612451553345, 0.2123609036207199, 0.2127356231212616, 0.2131103277206421, 0.213484987616539, 0.21385963261127472, 0.21423423290252686, 0.2146088182926178, 0.21498335897922516, 0.21535786986351013, 0.21573235094547272, 0.21610680222511292, 0.21648122370243073, 0.21685561537742615, 0.217229962348938, 0.21760427951812744, 0.2179785817861557, 0.21835283935070038, 0.21872705221176147, 0.21910123527050018, 0.2194754034280777, 0.21984952688217163, 0.22022363543510437, 0.22059769928455353, 0.2209717333316803, 0.2213457226753235, 0.22171969711780548, 0.2220936268568039, 0.22246752679347992, 0.22284139692783356, 0.2232152372598648, 0.22358904778957367, 0.22396279871463776, 0.22433653473854065, 0.22471024096012115, 0.22508391737937927, 0.2254575490951538, 0.22583116590976715, 0.2262047380208969, 0.2265782654285431, 0.22695177793502808, 0.22732524573802948, 0.2276986837387085, 0.22807209193706512, 0.22844547033309937, 0.22881878912448883, 0.2291920930147171, 0.22956536710262299, 0.22993861138820648, 0.2303118109703064, 0.23068498075008392, 0.23105812072753906, 0.23143121600151062, 0.2318042814731598, 0.23217731714248657, 0.23255032300949097, 0.23292328417301178, 0.2332962155342102, 0.23366911709308624, 0.2340419590473175, 0.23441478610038757, 0.23478758335113525, 0.23516033589839935, 0.23553305864334106, 0.2359057515859604, 0.23627841472625732, 0.23665103316307068, 0.23702360689640045, 0.23739616572856903, 0.23776867985725403, 0.23814116418361664, 0.23851360380649567, 0.2388860136270523, 0.23925837874412537, 0.23963071405887604, 0.24000301957130432, 0.24037529528141022, 0.24074752628803253, 0.24111972749233246, 0.2414918839931488, 0.24186402559280396, 0.24223610758781433, 0.2426081746816635, 0.2429801970720291, 0.24335217475891113, 0.24372412264347076, 0.244096040725708, 0.24446789920330048, 0.24483974277973175, 0.24521155655384064, 0.24558332562446594, 0.24595504999160767, 0.2463267594575882, 0.24669840931892395, 0.2470700442790985, 0.2474416196346283, 0.2478131651878357, 0.2481846809387207, 0.24855616688728333, 0.24892760813236237, 0.24929900467395782, 0.2496703863143921, 0.2500417232513428, 0.2504130005836487, 0.2507842779159546, 0.2511554956436157, 0.25152668356895447, 0.25189781188964844, 0.2522689402103424, 0.2526400089263916, 0.2530110478401184, 0.2533820569515228, 0.25375300645828247, 0.2541239261627197, 0.2544948160648346, 0.2548656761646271, 0.2552364766597748, 0.2556072771549225, 0.255977988243103, 0.25634869933128357, 0.25671935081481934, 0.2570900022983551, 0.2574605345726013, 0.2578310966491699, 0.25820159912109375, 0.2585720717906952, 0.25894251465797424, 0.2593129277229309, 0.2596832811832428, 0.2600536048412323, 0.260423868894577, 0.26079413294792175, 0.2611643373966217, 0.2615344822406769, 0.26190462708473206, 0.26227471232414246, 0.26264476776123047, 0.2630147933959961, 0.26338475942611694, 0.2637546956539154, 0.2641246020793915, 0.2644944489002228, 0.2648642659187317, 0.2652340531349182, 0.26560378074645996, 0.2659734785556793, 0.2663431465625763, 0.2667127847671509, 0.2670823633670807, 0.2674518823623657, 0.26782137155532837, 0.268190860748291, 0.2685602903366089, 0.268929660320282, 0.2692990303039551, 0.269668310880661, 0.27003759145736694, 0.2704068124294281, 0.27077600359916687, 0.27114516496658325, 0.27151426672935486, 0.2718833386898041, 0.2722523808479309, 0.27262136340141296, 0.27299031615257263, 0.2733592092990875, 0.2737281024456024, 0.27409693598747253, 0.2744657099246979, 0.27483445405960083, 0.2752031683921814, 0.2755718231201172, 0.2759404480457306, 0.2763090431690216, 0.27667760848999023, 0.2770461142063141, 0.27741456031799316, 0.27778294682502747, 0.27815133333206177, 0.2785196900367737, 0.2788879871368408, 0.27925625443458557, 0.27962446212768555, 0.27999264001846313, 0.28036078810691833, 0.28072887659072876, 0.2810969352722168, 0.28146493434906006, 0.28183290362358093, 0.2822008430957794, 0.28256872296333313, 0.28293657302856445, 0.2833043932914734, 0.28367215394973755, 0.28403985500335693, 0.2844075560569763, 0.2847751975059509, 0.28514277935028076, 0.2855103313922882, 0.28587785363197327, 0.28624531626701355, 0.28661274909973145, 0.28698012232780457, 0.2873474657535553, 0.28771477937698364, 0.2880820035934448, 0.288449227809906, 0.2888163924217224, 0.28918352723121643, 0.28955063223838806, 0.2899176776409149, 0.290284663438797, 0.2906516492366791, 0.291018545627594, 0.2913854420185089, 0.29175227880477905, 0.2921190559864044, 0.2924858033657074, 0.292852520942688, 0.2932191789150238, 0.29358577728271484, 0.2939523756504059, 0.29431888461112976, 0.29468539357185364, 0.29505184292793274, 0.29541823267936707, 0.295784592628479, 0.29615089297294617, 0.29651716351509094, 0.29688340425491333, 0.29724958539009094, 0.29761573672294617, 0.29798179864883423, 0.2983478605747223, 0.2987138628959656, 0.2990798354148865, 0.2994457483291626, 0.29981163144111633, 0.3001774549484253, 0.30054324865341187, 0.30090898275375366, 0.30127468705177307, 0.3016403317451477, 0.30200594663619995, 0.3023715317249298, 0.3027370572090149, 0.3031025230884552, 0.3034679591655731, 0.30383333563804626, 0.304198682308197, 0.3045639991760254, 0.304929256439209, 0.3052944540977478, 0.30565962195396423, 0.3060247302055359, 0.30638980865478516, 0.30675485730171204, 0.30711981654167175, 0.30748477578163147, 0.3078496754169464, 0.3082144856452942, 0.30857929587364197, 0.30894404649734497, 0.3093087673187256, 0.3096734285354614, 0.3100380599498749, 0.31040263175964355, 0.31076714396476746, 0.31113162636756897, 0.3114960789680481, 0.31186047196388245, 0.312224805355072, 0.3125891089439392, 0.312953382730484, 0.31331759691238403, 0.3136817514896393, 0.31404587626457214, 0.31440994143486023, 0.3147739768028259, 0.31513795256614685, 0.315501868724823, 0.31586575508117676, 0.31622961163520813, 0.3165934085845947, 0.31695714592933655, 0.317320853471756, 0.31768450140953064, 0.3180480897426605, 0.31841161847114563, 0.31877514719963074, 0.31913861632347107, 0.3195020258426666, 0.3198654055595398, 0.3202287256717682, 0.3205920159816742, 0.3209552466869354, 0.3213184177875519, 0.32168155908584595, 0.32204464077949524, 0.32240769267082214, 0.3227706849575043, 0.3231336176395416, 0.3234965205192566, 0.3238593637943268, 0.3242221772670746, 0.3245849311351776, 0.32494765520095825, 0.3253103196620941, 0.3256729245185852, 0.3260354995727539, 0.32639801502227783, 0.326760470867157, 0.32712289690971375, 0.32748526334762573, 0.32784759998321533, 0.32820984721183777, 0.3285720646381378, 0.3289342522621155, 0.32929638028144836, 0.3296584486961365, 0.3300204873085022, 0.33038249611854553, 0.3307444155216217, 0.3311063051223755, 0.3314681351184845, 0.3318299353122711, 0.33219167590141296, 0.3325533866882324, 0.3329150080680847, 0.333276629447937, 0.33363816142082214, 0.3339996635913849, 0.33436110615730286, 0.33472251892089844, 0.33508387207984924, 0.3354451656341553, 0.33580639958381653, 0.3361676037311554, 0.3365287780761719, 0.3368898630142212, 0.3372509181499481, 0.33761194348335266, 0.33797287940979004, 0.33833375573158264, 0.33869463205337524, 0.3390554189682007, 0.33941617608070374, 0.339776873588562, 0.3401375412940979, 0.340498149394989, 0.34085869789123535, 0.3412192165851593, 0.3415796756744385, 0.3419400751590729, 0.3423004150390625, 0.34266072511672974, 0.3430209755897522, 0.34338119626045227, 0.3437413275241852, 0.3441014289855957, 0.34446150064468384, 0.3448214828968048, 0.3451814353466034, 0.3455413281917572, 0.3459011912345886, 0.34626099467277527, 0.34662073850631714, 0.34698042273521423, 0.34734007716178894, 0.34769967198371887, 0.34805920720100403, 0.3484186828136444, 0.3487781286239624, 0.3491375148296356, 0.34949684143066406, 0.3498561382293701, 0.3502153754234314, 0.3505745530128479, 0.35093367099761963, 0.35129275918006897, 0.35165178775787354, 0.3520107567310333, 0.3523696959018707, 0.35272857546806335, 0.3530873954296112, 0.3534461557865143, 0.35380488634109497, 0.3541635274887085, 0.35452213883399963, 0.3548807203769684, 0.35523921251296997, 0.35559767484664917, 0.3559560775756836, 0.35631442070007324, 0.3566727340221405, 0.357030987739563, 0.3573891818523407, 0.35774731636047363, 0.3581053912639618, 0.3584634065628052, 0.35882139205932617, 0.3591793477535248, 0.3595372140407562, 0.3598950505256653, 0.3602527976036072, 0.3606105446815491, 0.3609682023525238, 0.36132580041885376, 0.36168336868286133, 0.3620408773422241, 0.36239832639694214, 0.36275574564933777, 0.36311307549476624, 0.3634703755378723, 0.3638276159763336, 0.36418479681015015, 0.3645419478416443, 0.36489900946617126, 0.36525604128837585, 0.36561301350593567, 0.3659699261188507, 0.36632680892944336, 0.36668360233306885, 0.36704036593437195, 0.3673970699310303, 0.3677537143230438, 0.3681102991104126, 0.3684668242931366, 0.3688233196735382, 0.36917975544929504, 0.3695361316204071, 0.3698924481868744, 0.3702487051486969, 0.370604932308197, 0.37096109986305237, 0.37131720781326294, 0.37167325615882874, 0.37202924489974976, 0.3723852038383484, 0.37274107336997986, 0.37309691309928894, 0.37345269322395325, 0.3738084137439728, 0.37416407465934753, 0.3745196759700775, 0.3748752474784851, 0.3752307593822479, 0.3755861818790436, 0.37594157457351685, 0.3762969374656677, 0.37665221095085144, 0.3770074248313904, 0.37736260890960693, 0.3777177035808563, 0.37807273864746094, 0.37842774391174316, 0.3787826895713806, 0.3791376054286957, 0.3794924318790436, 0.3798471987247467, 0.38020193576812744, 0.3805566132068634, 0.3809112310409546, 0.381265789270401, 0.38162028789520264, 0.3819747269153595, 0.3823291063308716, 0.3826834559440613, 0.3830377161502838, 0.38339194655418396, 0.38374608755111694, 0.38410019874572754, 0.38445425033569336, 0.3848082423210144, 0.38516220450401306, 0.38551607728004456, 0.3858698904514313, 0.3862236738204956, 0.3865773677825928, 0.38693103194236755, 0.38728463649749756, 0.3876381516456604, 0.38799160718917847, 0.38834503293037415, 0.38869842886924744, 0.38905173540115356, 0.3894049823284149, 0.3897581696510315, 0.3901113271713257, 0.3904643952846527, 0.39081743359565735, 0.3911703824996948, 0.3915233016014099, 0.3918761610984802, 0.39222896099090576, 0.39258167147636414, 0.3929343521595001, 0.39328697323799133, 0.39363953471183777, 0.3939920663833618, 0.3943445086479187, 0.3946968913078308, 0.39504921436309814, 0.3954015076160431, 0.3957537114620209, 0.3961058557033539, 0.3964579701423645, 0.39680999517440796, 0.39716199040412903, 0.39751389622688293, 0.39786574244499207, 0.3982175588607788, 0.3985693156719208, 0.39892101287841797, 0.399272620677948, 0.39962419867515564, 0.3999757170677185, 0.4003271758556366, 0.4006785750389099, 0.40102991461753845, 0.4013811945915222, 0.4017324149608612, 0.4020835757255554, 0.40243467688560486, 0.4027857184410095, 0.4031367003917694, 0.4034876227378845, 0.40383848547935486, 0.4041892886161804, 0.4045400321483612, 0.4048907160758972, 0.40524134039878845, 0.4055919051170349, 0.4059424102306366, 0.4062928557395935, 0.40664324164390564, 0.406993567943573, 0.4073438048362732, 0.407694011926651, 0.40804415941238403, 0.4083942472934723, 0.40874427556991577, 0.4090942442417145, 0.4094441533088684, 0.40979400277137756, 0.41014379262924194, 0.41049352288246155, 0.4108431935310364, 0.41119277477264404, 0.4115423262119293, 0.4118918180465698, 0.41224125027656555, 0.4125905930995941, 0.4129399061203003, 0.4132891595363617, 0.41363832354545593, 0.4139874577522278, 0.41433650255203247, 0.41468551754951477, 0.4150344431400299, 0.41538330912590027, 0.41573214530944824, 0.41608089208602905, 0.4164295792579651, 0.41677817702293396, 0.41712674498558044, 0.41747528314590454, 0.4178237020969391, 0.41817209124565125, 0.41852042078971863, 0.41886869072914124, 0.41921690106391907, 0.41956502199172974, 0.419913113117218, 0.42026111483573914, 0.42060908675193787, 0.42095696926116943, 0.4213047921657562, 0.42165258526802063, 0.42200028896331787, 0.42234793305397034, 0.422695517539978, 0.42304304242134094, 0.4233904778957367, 0.42373788356781006, 0.42408522963523865, 0.4244324862957001, 0.4247797131538391, 0.425126850605011, 0.4254739284515381, 0.4258209466934204, 0.42616790533065796, 0.42651477456092834, 0.42686161398887634, 0.42720839381217957, 0.4275550842285156, 0.4279017448425293, 0.4282483160495758, 0.42859482765197754, 0.4289413094520569, 0.42928770184516907, 0.4296340346336365, 0.4299802780151367, 0.4303264915943146, 0.43067261576652527, 0.4310187101364136, 0.4313647150993347, 0.4317106604576111, 0.4320565462112427, 0.4324023723602295, 0.43274813890457153, 0.4330938458442688, 0.4334394633769989, 0.43378502130508423, 0.43413054943084717, 0.43447598814964294, 0.43482136726379395, 0.4351666569709778, 0.43551191687583923, 0.4358571171760559, 0.43620219826698303, 0.43654724955558777, 0.43689224123954773, 0.4372371733188629, 0.4375820457935333, 0.4379268288612366, 0.43827158212661743, 0.43861624598503113, 0.43896085023880005, 0.4393053948879242, 0.43964987993240356, 0.43999427556991577, 0.4403386414051056, 0.44068291783332825, 0.44102713465690613, 0.44137129187583923, 0.4417153596878052, 0.44205939769744873, 0.4424033463001251, 0.44274723529815674, 0.4430910646915436, 0.44343483448028564, 0.44377854466438293, 0.44412216544151306, 0.4444657266139984, 0.444809228181839, 0.4451526701450348, 0.4454960227012634, 0.4458393156528473, 0.4461825489997864, 0.4465257227420807, 0.4468688368797302, 0.447211891412735, 0.4475548565387726, 0.4478977620601654, 0.44824060797691345, 0.4485833942890167, 0.4489261209964752, 0.44926875829696655, 0.4496113359928131, 0.4499538540840149, 0.4502963125705719, 0.45063868165016174, 0.4509809911251068, 0.4513232409954071, 0.4516654312610626, 0.45200756192207336, 0.45234960317611694, 0.45269158482551575, 0.4530335068702698, 0.45337536931037903, 0.4537171423435211, 0.45405885577201843, 0.45440050959587097, 0.45474210381507874, 0.45508357882499695, 0.4554250240325928, 0.4557664096355438, 0.4561077356338501, 0.4564489722251892, 0.45679017901420593, 0.4571312963962555, 0.4574723243713379, 0.4578133225440979, 0.45815423130989075, 0.4584950804710388, 0.4588358402252197, 0.45917657017707825, 0.4595172107219696, 0.4598577916622162, 0.4601982831954956, 0.46053871512413025, 0.4608790874481201, 0.4612194001674652, 0.4615596532821655, 0.4618998169898987, 0.46223992109298706, 0.4625799357891083, 0.4629199206829071, 0.46325981616973877, 0.46359962224960327, 0.4639393985271454, 0.46427908539772034, 0.4646186828613281, 0.4649582505226135, 0.46529772877693176, 0.4656371474266052, 0.4659765064716339, 0.46631577610969543, 0.4666549861431122, 0.46699413657188416, 0.46733322739601135, 0.4676722288131714, 0.46801117062568665, 0.46835002303123474, 0.46868884563446045, 0.469027578830719, 0.4693662226200104, 0.46970483660697937, 0.4700433611869812, 0.47038179636001587, 0.47072020173072815, 0.47105851769447327, 0.4713967442512512, 0.4717349410057068, 0.4720730483531952, 0.4724110960960388, 0.4727490544319153, 0.473086953163147, 0.4734247922897339, 0.47376251220703125, 0.4741002023220062, 0.4744378328323364, 0.47477540373802185, 0.4751128852367401, 0.4754502773284912, 0.4757876396179199, 0.47612491250038147, 0.47646209597587585, 0.47679924964904785, 0.4771363139152527, 0.47747328877449036, 0.47781020402908325, 0.47814705967903137, 0.4784838557243347, 0.4788205623626709, 0.4791572093963623, 0.47949373722076416, 0.47983023524284363, 0.4801666736602783, 0.48050302267074585, 0.4808393120765686, 0.4811755418777466, 0.4815116822719574, 0.48184776306152344, 0.4821837544441223, 0.4825197160243988, 0.48285555839538574, 0.4831913709640503, 0.4835270941257477, 0.4838627278804779, 0.48419830203056335, 0.48453381657600403, 0.48486924171447754, 0.4852046072483063, 0.48553991317749023, 0.48587512969970703, 0.48621028661727905, 0.4865453541278839, 0.486880362033844, 0.4872153103351593, 0.48755016922950745, 0.4878849685192108, 0.488219678401947, 0.48855432868003845, 0.4888889193534851, 0.4892234206199646, 0.4895578622817993, 0.48989221453666687, 0.49022650718688965, 0.49056071043014526, 0.4908948540687561, 0.49122893810272217, 0.49156293272972107, 0.4918968677520752, 0.49223071336746216, 0.49256449937820435, 0.49289822578430176, 0.493231862783432, 0.4935654103755951, 0.4938989281654358, 0.49423232674598694, 0.4945656955242157, 0.4948989748954773, 0.49523216485977173, 0.4955652952194214, 0.49589836597442627, 0.496231347322464, 0.49656423926353455, 0.4968971014022827, 0.49722981452941895, 0.4975624978542328, 0.49789512157440186, 0.49822765588760376, 0.4985601305961609, 0.49889251589775085, 0.49922484159469604, 0.49955710768699646, 0.4998892843723297, 0.5002213716506958, 0.5005534291267395, 0.5008853673934937, 0.501217246055603, 0.5015490651130676, 0.5018808245658875, 0.5022124648094177, 0.5025440454483032, 0.502875566482544, 0.5032070279121399, 0.5035383701324463, 0.5038696527481079, 0.5042008757591248, 0.5045320391654968, 0.5048631429672241, 0.5051941275596619, 0.5055250525474548, 0.5058558583259583, 0.5061866641044617, 0.5065173506736755, 0.5068479776382446, 0.507178544998169, 0.5075089931488037, 0.5078393816947937, 0.5081697106361389, 0.5084999799728394, 0.508830189704895, 0.5091602802276611, 0.5094903111457825, 0.5098202228546143, 0.510150134563446, 0.5104799270629883, 0.5108096599578857, 0.5111392736434937, 0.5114688873291016, 0.5117983818054199, 0.5121278166770935, 0.5124571323394775, 0.5127864480018616, 0.513115644454956, 0.5134447813034058, 0.5137737989425659, 0.5141027569770813, 0.5144316554069519, 0.5147604942321777, 0.5150892734527588, 0.5154178738594055, 0.5157464742660522, 0.5160749554634094, 0.5164034366607666, 0.5167317986488342, 0.5170601010322571, 0.5173882842063904, 0.5177164077758789, 0.5180444717407227, 0.5183724761009216, 0.5187004208564758, 0.5190282464027405, 0.5193560123443604, 0.5196836590766907, 0.520011305809021, 0.5203388333320618, 0.520666241645813, 0.5209936499595642, 0.5213209390640259, 0.5216481685638428, 0.5219752788543701, 0.5223023891448975, 0.5226293802261353, 0.5229562520980835, 0.5232831239700317, 0.5236098766326904, 0.5239365696907043, 0.5242631435394287, 0.5245897173881531, 0.5249161720275879, 0.5252425074577332, 0.5255688428878784, 0.5258950591087341, 0.5262212157249451, 0.5265472531318665, 0.5268732309341431, 0.5271991491317749, 0.527525007724762, 0.5278507471084595, 0.5281764268875122, 0.5285020470619202, 0.5288275480270386, 0.5291529893875122, 0.5294783711433411, 0.5298036336898804, 0.5301288366317749, 0.5304539799690247, 0.5307790637016296, 0.5311040282249451, 0.5314289331436157, 0.5317537784576416, 0.5320785045623779, 0.5324031710624695, 0.5327277779579163, 0.5330522656440735, 0.5333766341209412, 0.5337010025978088, 0.534025251865387, 0.5343494415283203, 0.5346735715866089, 0.5349976420402527, 0.5353215932846069, 0.5356454253196716, 0.5359692573547363, 0.5362929701805115, 0.5366166234016418, 0.5369401574134827, 0.5372636914253235, 0.5375871062278748, 0.5379104018211365, 0.5382336378097534, 0.5385568141937256, 0.538879930973053, 0.5392029285430908, 0.5395258665084839, 0.5398486852645874, 0.5401715040206909, 0.5404941439628601, 0.5408167839050293, 0.5411393046379089, 0.5414617657661438, 0.5417841672897339, 0.5421064496040344, 0.5424286723136902, 0.5427507758140564, 0.5430728793144226, 0.5433948040008545, 0.5437167286872864, 0.5440385341644287, 0.5443602800369263, 0.544681966304779, 0.5450035333633423, 0.545324981212616, 0.5456464290618896, 0.5459677577018738, 0.5462890267372131, 0.5466101765632629, 0.546931266784668, 0.5472522974014282, 0.5475732088088989, 0.5478940606117249, 0.548214852809906, 0.5485355257987976, 0.5488561391830444, 0.5491766929626465, 0.549497127532959, 0.5498175024986267, 0.5501378178596497, 0.5504580140113831, 0.5507781505584717, 0.5510981678962708, 0.5514180660247803, 0.5517379641532898, 0.5520578026771545, 0.5523775219917297, 0.5526971220970154, 0.553016722202301, 0.5533362030982971, 0.5536555647850037, 0.5539748668670654, 0.5542941093444824, 0.5546132922172546, 0.5549323558807373, 0.5552513003349304, 0.5555702447891235, 0.5558890700340271, 0.5562077760696411, 0.5565264821052551, 0.5568450689315796, 0.5571635365486145, 0.5574819445610046, 0.55780029296875, 0.5581185221672058, 0.5584366917610168, 0.5587548017501831, 0.5590727925300598, 0.5593907237052917, 0.5597085356712341, 0.5600263476371765, 0.5603439807891846, 0.5606616139411926, 0.5609791278839111, 0.5612965226173401, 0.5616138577461243, 0.5619311332702637, 0.5622483491897583, 0.5625654458999634, 0.5628824234008789, 0.5631993412971497, 0.5635161995887756, 0.5638329982757568, 0.5641496777534485, 0.5644662976264954, 0.5647827982902527, 0.5650992393493652, 0.5654155611991882, 0.5657318234443665, 0.5660480260848999, 0.5663641095161438, 0.5666801333427429, 0.5669960975646973, 0.5673119425773621, 0.5676277279853821, 0.5679433941841125, 0.5682590007781982, 0.5685744881629944, 0.5688899159431458, 0.5692052245140076, 0.5695205330848694, 0.5698357224464417, 0.5701507925987244, 0.5704658031463623, 0.5707807540893555, 0.5710955858230591, 0.5714103579521179, 0.5717250108718872, 0.5720396041870117, 0.5723541378974915, 0.5726685523986816, 0.572982907295227, 0.5732971429824829, 0.573611319065094, 0.5739254355430603, 0.5742394328117371, 0.574553370475769, 0.5748671889305115, 0.5751809477806091, 0.575494647026062, 0.5758082270622253, 0.5761216878890991, 0.5764350891113281, 0.5767484307289124, 0.5770617127418518, 0.5773748159408569, 0.5776879191398621, 0.5780009031295776, 0.5783138275146484, 0.5786266326904297, 0.5789393782615662, 0.5792520046234131, 0.5795645713806152, 0.5798770785331726, 0.5801894664764404, 0.5805017352104187, 0.580814003944397, 0.5811260938644409, 0.5814381837844849, 0.5817501544952393, 0.5820620059967041, 0.5823737978935242, 0.5826855301856995, 0.5829971432685852, 0.5833086967468262, 0.5836201310157776, 0.5839315056800842, 0.5842427611351013, 0.5845539569854736, 0.5848650932312012, 0.5851761102676392, 0.5854870676994324, 0.585797905921936, 0.5861086249351501, 0.5864192843437195, 0.586729884147644, 0.587040364742279, 0.5873507857322693, 0.5876611471176147, 0.5879713892936707, 0.5882815718650818, 0.5885916352272034, 0.5889015793800354, 0.5892115235328674, 0.5895212888717651, 0.5898310542106628, 0.590140700340271, 0.5904502272605896, 0.5907596945762634, 0.5910691022872925, 0.591378390789032, 0.5916875600814819, 0.5919967293739319, 0.5923057198524475, 0.5926146507263184, 0.5929235219955444, 0.5932323336601257, 0.5935409665107727, 0.5938495993614197, 0.5941581130027771, 0.594466507434845, 0.5947748422622681, 0.5950831174850464, 0.5953912734985352, 0.5956993103027344, 0.5960072875022888, 0.5963152050971985, 0.5966230034828186, 0.596930742263794, 0.5972383618354797, 0.5975459218025208, 0.5978533625602722, 0.5981607437133789, 0.598468005657196, 0.5987752079963684, 0.5990822911262512, 0.5993893146514893, 0.5996962785720825, 0.6000031232833862, 0.6003098487854004, 0.6006165146827698, 0.6009230613708496, 0.6012295484542847, 0.601535975933075, 0.6018422842025757, 0.6021485328674316, 0.602454662322998, 0.6027606725692749, 0.603066623210907, 0.6033724546432495, 0.6036782264709473, 0.6039839386940002, 0.6042895317077637, 0.6045950651168823, 0.6049004793167114, 0.605205774307251, 0.6055110096931458, 0.6058161854743958, 0.6061212420463562, 0.6064262390136719, 0.606731116771698, 0.6070359349250793, 0.6073406338691711, 0.6076452732086182, 0.6079497933387756, 0.6082542538642883, 0.6085585951805115, 0.6088628172874451, 0.6091670393943787, 0.6094710826873779, 0.6097751259803772, 0.6100789904594421, 0.6103827953338623, 0.6106865406036377, 0.6109901666641235, 0.6112937331199646, 0.6115971803665161, 0.6119005680084229, 0.61220383644104, 0.6125069856643677, 0.6128100752830505, 0.6131131052970886, 0.6134160161018372, 0.6137188673019409, 0.6140215992927551, 0.6143242120742798, 0.6146267652511597, 0.6149292588233948, 0.6152316331863403, 0.6155338883399963, 0.6158360838890076, 0.616138219833374, 0.6164401769638062, 0.6167421340942383, 0.6170439720153809, 0.6173456907272339, 0.6176473498344421, 0.6179488897323608, 0.6182503700256348, 0.6185517311096191, 0.6188530325889587, 0.6191542148590088, 0.6194553375244141, 0.6197563409805298, 0.620057225227356, 0.6203580498695374, 0.6206587553024292, 0.6209594011306763, 0.6212599873542786, 0.6215604543685913, 0.6218608021736145, 0.6221610903739929, 0.6224612593650818, 0.6227613687515259, 0.6230613589286804, 0.6233612895011902, 0.6236611008644104, 0.6239608526229858, 0.6242604851722717, 0.6245600581169128, 0.6248595118522644, 0.6251588463783264, 0.6254581212997437, 0.6257573366165161, 0.6260563731193542, 0.6263554096221924, 0.6266542673110962, 0.626953125, 0.6272518038749695, 0.627550482749939, 0.6278489828109741, 0.6281474232673645, 0.6284458041191101, 0.6287440657615662, 0.6290422081947327, 0.6293402910232544, 0.6296382546424866, 0.629936158657074, 0.6302339434623718, 0.6305316686630249, 0.6308292746543884, 0.6311267614364624, 0.6314241886138916, 0.6317214965820312, 0.6320187449455261, 0.6323159337043762, 0.632612943649292, 0.632909893989563, 0.6332067847251892, 0.6335035562515259, 0.633800208568573, 0.6340968012809753, 0.6343933343887329, 0.6346896886825562, 0.6349860429763794, 0.6352822184562683, 0.6355783343315125, 0.6358743906021118, 0.6361703276634216, 0.6364660859107971, 0.6367618441581726, 0.6370574831962585, 0.6373530626296997, 0.6376485228538513, 0.6379439234733582, 0.6382392048835754, 0.6385343670845032, 0.6388294696807861, 0.6391244530677795, 0.6394193172454834, 0.6397141814231873, 0.6400088667869568, 0.6403034925460815, 0.6405979990959167, 0.6408924460411072, 0.6411867737770081, 0.6414810419082642, 0.6417751908302307, 0.6420692205429077, 0.6423631906509399, 0.6426570415496826, 0.6429508328437805, 0.6432445049285889, 0.6435380578041077, 0.6438315510749817, 0.6441249251365662, 0.6444182395935059, 0.644711434841156, 0.6450045704841614, 0.6452975869178772, 0.6455904841423035, 0.645883321762085, 0.6461760401725769, 0.6464686393737793, 0.6467611789703369, 0.6470536589622498, 0.647346019744873, 0.6476382613182068, 0.647930383682251, 0.6482224464416504, 0.648514449596405, 0.6488062739372253, 0.6490980982780457, 0.6493897438049316, 0.6496813297271729, 0.6499727964401245, 0.6502642035484314, 0.6505554914474487, 0.6508467197418213, 0.6511378288269043, 0.6514288187026978, 0.6517197489738464, 0.6520105600357056, 0.6523013114929199, 0.6525919437408447, 0.6528823971748352, 0.6531728506088257, 0.6534631848335266, 0.653753399848938, 0.6540435552597046, 0.6543335914611816, 0.6546235680580139, 0.6549134254455566, 0.6552031636238098, 0.6554928421974182, 0.6557824015617371, 0.6560719013214111, 0.6563612818717957, 0.6566505432128906, 0.6569397449493408, 0.6572288274765015, 0.6575177907943726, 0.6578066945075989, 0.6580954790115356, 0.6583842039108276, 0.6586728096008301, 0.658961296081543, 0.6592497229576111, 0.6595380306243896, 0.6598262190818787, 0.6601143479347229, 0.6604023575782776, 0.6606903076171875, 0.6609781384468079, 0.6612658500671387, 0.6615535020828247, 0.6618410348892212, 0.6621284484863281, 0.6624158024787903, 0.6627030372619629, 0.6629902124404907, 0.6632772088050842, 0.6635642051696777, 0.6638510227203369, 0.6641377806663513, 0.6644244194030762, 0.6647109985351562, 0.6649974584579468, 0.6652838587760925, 0.665570080280304, 0.6658562421798706, 0.6661423444747925, 0.6664283275604248, 0.6667141914367676, 0.6669999361038208, 0.6672856211662292, 0.6675711870193481, 0.6678566932678223, 0.6681420803070068, 0.6684273481369019, 0.6687124967575073, 0.668997585773468, 0.6692825555801392, 0.6695674657821655, 0.6698522567749023, 0.6701369881629944, 0.6704215407371521, 0.670706033706665, 0.6709904670715332, 0.6712747812271118, 0.6715589761734009, 0.6718430519104004, 0.6721270680427551, 0.6724109649658203, 0.6726948022842407, 0.6729784607887268, 0.6732620596885681, 0.6735455989837646, 0.6738290190696716, 0.6741123199462891, 0.6743955016136169, 0.6746786236763, 0.6749616861343384, 0.6752445697784424, 0.6755273938179016, 0.6758100986480713, 0.6760927438735962, 0.6763752102851868, 0.6766576766967773, 0.6769399642944336, 0.6772221922874451, 0.677504301071167, 0.6777863502502441, 0.678068220615387, 0.6783500909805298, 0.6786317825317383, 0.678913414478302, 0.6791949272155762, 0.6794763207435608, 0.6797576546669006, 0.6800388693809509, 0.6803200244903564, 0.6806010007858276, 0.680881917476654, 0.6811627745628357, 0.6814435124397278, 0.6817241311073303, 0.6820046305656433, 0.6822850704193115, 0.6825653314590454, 0.6828455924987793, 0.6831256747245789, 0.6834056973457336, 0.6836856603622437, 0.6839654445648193, 0.6842451095581055, 0.6845247149467468, 0.6848042607307434, 0.6850836873054504, 0.6853629946708679, 0.6856421828269958, 0.685921311378479, 0.6862003207206726, 0.6864792108535767, 0.6867580413818359, 0.6870367527008057, 0.6873153448104858, 0.6875938773155212, 0.6878722310066223, 0.6881505846977234, 0.6884287595748901, 0.6887068748474121, 0.6889848709106445, 0.6892627477645874, 0.6895405650138855, 0.689818263053894, 0.690095841884613, 0.6903733611106873, 0.6906507015228271, 0.690928041934967, 0.6912052035331726, 0.6914823055267334, 0.6917592883110046, 0.6920361518859863, 0.6923129558563232, 0.6925896406173706, 0.6928662061691284, 0.6931426525115967, 0.6934190392494202, 0.6936953067779541, 0.6939714550971985, 0.6942475438117981, 0.6945235133171082, 0.6947993636131287, 0.6950751543045044, 0.6953508257865906, 0.6956263780593872, 0.6959018111228943, 0.6961771845817566, 0.6964523792266846, 0.6967275738716125, 0.6970025897026062, 0.6972775459289551, 0.6975523829460144, 0.6978271007537842, 0.6981017589569092, 0.6983762979507446, 0.6986507177352905, 0.6989250183105469, 0.6991992592811584, 0.6994733810424805, 0.6997473835945129, 0.7000212669372559, 0.700295090675354, 0.7005687952041626, 0.7008423805236816, 0.7011159062385559, 0.7013893127441406, 0.7016626000404358, 0.7019357681274414, 0.7022088766098022, 0.7024818658828735, 0.7027547359466553, 0.7030275464057922, 0.7033001780509949, 0.7035727500915527, 0.7038452625274658, 0.7041175961494446, 0.7043898701667786, 0.704662024974823, 0.7049340605735779, 0.705206036567688, 0.7054778933525085, 0.7057496309280396, 0.706021249294281, 0.7062928080558777, 0.7065642476081848, 0.7068355679512024, 0.7071067690849304, 0.7073779106140137, 0.7076489329338074, 0.7079198360443115, 0.7081906795501709, 0.708461344242096, 0.7087319493293762, 0.7090024352073669, 0.7092728614807129, 0.7095431089401245, 0.7098132967948914, 0.7100834250450134, 0.7103533744812012, 0.7106232643127441, 0.7108930349349976, 0.7111626863479614, 0.7114322185516357, 0.7117016911506653, 0.7119710445404053, 0.7122402787208557, 0.7125093936920166, 0.7127784490585327, 0.7130473852157593, 0.7133162021636963, 0.7135848999023438, 0.7138535380363464, 0.7141219973564148, 0.7143903970718384, 0.7146586775779724, 0.7149268984794617, 0.7151949405670166, 0.7154629230499268, 0.7157308459281921, 0.7159985899925232, 0.7162662744522095, 0.7165338397026062, 0.7168012857437134, 0.717068612575531, 0.7173358798027039, 0.7176030278205872, 0.7178700566291809, 0.7181369662284851, 0.7184038162231445, 0.7186705470085144, 0.7189371585845947, 0.7192036509513855, 0.7194700241088867, 0.7197363376617432, 0.7200025320053101, 0.7202686071395874, 0.7205345630645752, 0.7208004593849182, 0.7210662364959717, 0.7213318943977356, 0.72159743309021, 0.7218628525733948, 0.7221282124519348, 0.7223934531211853, 0.7226585745811462, 0.7229235768318176, 0.7231885194778442, 0.7234533429145813, 0.7237180471420288, 0.7239826321601868, 0.7242470979690552, 0.7245115041732788, 0.7247757911682129, 0.7250399589538574, 0.7253040075302124, 0.7255679368972778, 0.7258318066596985, 0.7260955572128296, 0.7263591885566711, 0.7266227006912231, 0.7268861532211304, 0.7271494269371033, 0.7274126410484314, 0.72767573595047, 0.7279387712478638, 0.7282016277313232, 0.7284644246101379, 0.7287271022796631, 0.7289896607398987, 0.7292520999908447, 0.7295144200325012, 0.7297766804695129, 0.7300388216972351, 0.7303008437156677, 0.7305627465248108, 0.7308245897293091, 0.7310863137245178, 0.731347918510437, 0.7316094040870667, 0.7318707704544067, 0.7321320176124573, 0.732393205165863, 0.7326542735099792, 0.7329152226448059, 0.733176052570343, 0.7334368228912354, 0.7336974740028381, 0.7339579463005066, 0.7342183589935303, 0.7344787120819092, 0.7347388863563538, 0.7349990010261536, 0.735258936882019, 0.7355188131332397, 0.7357786297798157, 0.7360382676124573, 0.7362977862358093, 0.7365572452545166, 0.7368165850639343, 0.7370758056640625, 0.7373349070549011, 0.737593948841095, 0.7378528118133545, 0.7381116151809692, 0.7383702993392944, 0.7386288642883301, 0.738887369632721, 0.7391456961631775, 0.7394039630889893, 0.7396621108055115, 0.7399201393127441, 0.7401780486106873, 0.7404358386993408, 0.7406935691833496, 0.7409511804580688, 0.7412086129188538, 0.7414660453796387, 0.7417232990264893, 0.7419804334640503, 0.7422375082969666, 0.7424944043159485, 0.7427512407302856, 0.7430079579353333, 0.7432646155357361, 0.7435210943222046, 0.7437774538993835, 0.7440337538719177, 0.7442899346351624, 0.7445459961891174, 0.744801938533783, 0.7450577616691589, 0.7453135251998901, 0.7455691695213318, 0.7458246946334839, 0.7460801005363464, 0.7463353872299194, 0.7465905547142029, 0.7468456625938416, 0.7471005916595459, 0.7473554611206055, 0.7476102113723755, 0.747864842414856, 0.7481194138526917, 0.748373806476593, 0.7486281394958496, 0.7488822937011719, 0.7491363883018494, 0.7493903636932373, 0.7496442794799805, 0.7498980164527893, 0.7501516342163086, 0.7504051923751831, 0.7506586313247681, 0.7509119510650635, 0.7511651515960693, 0.7514182329177856, 0.7516712546348572, 0.7519240975379944, 0.7521768808364868, 0.7524295449256897, 0.752682089805603, 0.7529345154762268, 0.753186821937561, 0.7534390091896057, 0.7536911368370056, 0.753943145275116, 0.754194974899292, 0.7544467449188232, 0.7546983957290649, 0.7549499869346619, 0.7552013993263245, 0.7554527521133423, 0.7557039260864258, 0.7559550404548645, 0.7562060356140137, 0.7564569115638733, 0.7567076683044434, 0.7569583058357239, 0.7572088837623596, 0.7574593424797058, 0.7577096223831177, 0.75795978307724, 0.7582098841667175, 0.7584598660469055, 0.7587097883224487, 0.7589595317840576, 0.7592092156410217, 0.7594587206840515, 0.7597081661224365, 0.759957492351532, 0.7602066993713379, 0.7604557871818542, 0.760704755783081, 0.7609536051750183, 0.7612023949623108, 0.7614510655403137, 0.7616995573043823, 0.7619479894638062, 0.7621963024139404, 0.7624444961547852, 0.7626925706863403, 0.7629405856132507, 0.7631884217262268, 0.7634361982345581, 0.7636837959289551, 0.7639313340187073, 0.7641787528991699, 0.764426052570343, 0.7646732330322266, 0.7649202942848206, 0.7651672959327698, 0.7654141187667847, 0.7656608819961548, 0.7659075260162354, 0.7661539912223816, 0.7664003968238831, 0.766646683216095, 0.7668928503990173, 0.7671389579772949, 0.7673848867416382, 0.7676306962966919, 0.7678764462471008, 0.7681220769882202, 0.7683675289154053, 0.7686129212379456, 0.7688581943511963, 0.7691033482551575, 0.7693483829498291, 0.769593358039856, 0.7698381543159485, 0.7700828909873962, 0.7703274488449097, 0.7705719470977783, 0.7708163261413574, 0.771060585975647, 0.771304726600647, 0.7715486884117126, 0.7717925906181335, 0.7720363736152649, 0.7722800970077515, 0.7725236415863037, 0.7727671265602112, 0.7730104327201843, 0.7732536792755127, 0.7734968066215515, 0.7737398147583008, 0.7739827036857605, 0.7742254734039307, 0.7744681239128113, 0.7747106552124023, 0.7749531269073486, 0.7751954197883606, 0.7754376530647278, 0.7756797075271606, 0.7759217023849487, 0.7761635780334473, 0.7764053344726562, 0.7766469717025757, 0.7768884897232056, 0.7771298885345459, 0.7773711681365967, 0.7776123285293579, 0.7778534293174744, 0.7780943512916565, 0.7783352136611938, 0.7785758972167969, 0.7788165211677551, 0.7790570259094238, 0.779297411441803, 0.7795376777648926, 0.7797778248786926, 0.7800178527832031, 0.7802577614784241, 0.7804975509643555, 0.7807372808456421, 0.7809768319129944, 0.7812162637710571, 0.7814556360244751, 0.7816948294639587, 0.7819339632987976, 0.7821729779243469, 0.7824118733406067, 0.7826506495475769, 0.7828893065452576, 0.7831278443336487, 0.7833662629127502, 0.7836045622825623, 0.7838427424430847, 0.7840808033943176, 0.7843188047409058, 0.7845566272735596, 0.7847943305969238, 0.7850319147109985, 0.7852694392204285, 0.7855068445205688, 0.7857440710067749, 0.7859812378883362, 0.7862182855606079, 0.7864552140235901, 0.7866920232772827, 0.7869287133216858, 0.7871652841567993, 0.7874017357826233, 0.7876380681991577, 0.7878743410110474, 0.7881104350090027, 0.7883464097976685, 0.7885823249816895, 0.7888180613517761, 0.789053738117218, 0.7892892360687256, 0.7895246744155884, 0.7897599935531616, 0.7899951934814453, 0.7902302145957947, 0.7904651761054993, 0.7907000184059143, 0.7909347414970398, 0.7911693453788757, 0.7914038300514221, 0.791638195514679, 0.7918724417686462, 0.792106568813324, 0.7923406362533569, 0.7925745248794556, 0.7928082942962646, 0.793042004108429, 0.7932755351066589, 0.7935089468955994, 0.793742299079895, 0.7939754724502563, 0.7942085862159729, 0.7944415807723999, 0.7946743965148926, 0.7949071526527405, 0.7951397895812988, 0.7953722476959229, 0.7956046462059021, 0.7958369255065918, 0.7960690855979919, 0.7963011264801025, 0.7965330481529236, 0.7967648506164551, 0.796996533870697, 0.7972280979156494, 0.7974595427513123, 0.7976908683776855, 0.7979220747947693, 0.7981531620025635, 0.7983841300010681, 0.7986149787902832, 0.7988457679748535, 0.7990763783454895, 0.7993068695068359, 0.7995373010635376, 0.7997675538063049, 0.7999976873397827, 0.8002277612686157, 0.8004576563835144, 0.8006874918937683, 0.8009171485900879, 0.8011467456817627, 0.8013761639595032, 0.8016055226325989, 0.8018347024917603, 0.8020638227462769, 0.8022928237915039, 0.8025216460227966, 0.8027504086494446, 0.802979052066803, 0.803207516670227, 0.8034359216690063, 0.8036642074584961, 0.8038923740386963, 0.8041204214096069, 0.8043482899665833, 0.8045760989189148, 0.8048037886619568, 0.8050313591957092, 0.8052588105201721, 0.8054861426353455, 0.8057132959365845, 0.8059403896331787, 0.8061673641204834, 0.8063942193984985, 0.8066209554672241, 0.8068475723266602, 0.8070740699768066, 0.8073004484176636, 0.807526707649231, 0.8077528476715088, 0.8079788684844971, 0.8082047700881958, 0.808430552482605, 0.8086562156677246, 0.8088817596435547, 0.8091071844100952, 0.8093324899673462, 0.8095576763153076, 0.8097827434539795, 0.8100076913833618, 0.8102325201034546, 0.810457170009613, 0.8106817603111267, 0.8109062314033508, 0.8111306428909302, 0.8113548755645752, 0.8115789890289307, 0.8118029832839966, 0.812026858329773, 0.8122506141662598, 0.812474250793457, 0.8126977682113647, 0.8129211664199829, 0.8131444454193115, 0.8133676052093506, 0.8135906457901001, 0.8138135671615601, 0.8140363097190857, 0.8142589926719666, 0.8144815564155579, 0.8147040009498596, 0.8149263262748718, 0.8151485323905945, 0.8153706192970276, 0.8155925869941711, 0.8158144354820251, 0.8160361647605896, 0.8162577748298645, 0.8164792060852051, 0.8167005777359009, 0.8169218301773071, 0.8171429634094238, 0.817363977432251, 0.8175848126411438, 0.8178055882453918, 0.8180262446403503, 0.8182467222213745, 0.8184671401977539, 0.8186874389648438, 0.8189075589179993, 0.81912761926651, 0.8193475604057312, 0.8195673227310181, 0.8197870254516602, 0.8200065493583679, 0.8202260136604309, 0.8204452991485596, 0.8206645250320435, 0.820883572101593, 0.8211025595664978, 0.8213213682174683, 0.8215400576591492, 0.8217586874961853, 0.8219771385192871, 0.8221954703330994, 0.8224137425422668, 0.8226317763328552, 0.8228498101234436, 0.8230676651000977, 0.8232854008674622, 0.8235030174255371, 0.8237205147743225, 0.8239378929138184, 0.8241551518440247, 0.8243722915649414, 0.8245893120765686, 0.8248062133789062, 0.8250229954719543, 0.8252396583557129, 0.8254561424255371, 0.8256725668907166, 0.8258888721466064, 0.826104998588562, 0.8263210654258728, 0.826537013053894, 0.826752781867981, 0.8269684910774231, 0.8271840214729309, 0.827399492263794, 0.8276147842407227, 0.8278299570083618, 0.8280450701713562, 0.8282600045204163, 0.8284748196601868, 0.8286895751953125, 0.8289041519165039, 0.8291186094284058, 0.8293329477310181, 0.8295471668243408, 0.829761266708374, 0.8299752473831177, 0.8301891088485718, 0.8304027915000916, 0.8306164145469666, 0.830829918384552, 0.8310432434082031, 0.8312565088272095, 0.8314696550369263, 0.8316826224327087, 0.8318955302238464, 0.8321082592010498, 0.8323208689689636, 0.8325334191322327, 0.8327457904815674, 0.8329580426216125, 0.8331701755523682, 0.8333821892738342, 0.8335940837860107, 0.8338058590888977, 0.8340175151824951, 0.834229052066803, 0.8344404101371765, 0.8346517086029053, 0.8348628878593445, 0.8350738883018494, 0.8352848291397095, 0.8354955911636353, 0.8357062935829163, 0.8359168171882629, 0.8361272811889648, 0.8363375663757324, 0.8365477323532104, 0.8367577791213989, 0.8369677066802979, 0.8371775150299072, 0.837387204170227, 0.8375967741012573, 0.837806224822998, 0.8380154967308044, 0.8382247090339661, 0.8384338021278381, 0.8386427164077759, 0.8388515710830688, 0.8390602469444275, 0.8392688035964966, 0.8394773006439209, 0.8396856188774109, 0.8398938179016113, 0.8401018977165222, 0.8403098583221436, 0.8405176997184753, 0.8407253623008728, 0.8409329652786255, 0.8411404490470886, 0.8413477540016174, 0.8415549397468567, 0.8417620658874512, 0.8419690132141113, 0.8421758413314819, 0.8423826098442078, 0.8425891995429993, 0.8427956700325012, 0.8430020213127136, 0.8432082533836365, 0.843414306640625, 0.8436203002929688, 0.843826174736023, 0.8440318703651428, 0.8442375063896179, 0.8444429636001587, 0.8446483016014099, 0.8448535799980164, 0.8450586795806885, 0.845263659954071, 0.8454685211181641, 0.8456732630729675, 0.8458778262138367, 0.846082329750061, 0.8462867140769958, 0.8464909195899963, 0.846695065498352, 0.8468990325927734, 0.8471028804779053, 0.8473066687583923, 0.8475102782249451, 0.8477137684822083, 0.8479171395301819, 0.8481203317642212, 0.8483234643936157, 0.8485264778137207, 0.8487293124198914, 0.8489320874214172, 0.8491346836090088, 0.8493371605873108, 0.8495395183563232, 0.8497417569160461, 0.8499438762664795, 0.8501458764076233, 0.8503477573394775, 0.8505495190620422, 0.8507511019706726, 0.8509526252746582, 0.8511539697647095, 0.8513551950454712, 0.8515563011169434, 0.851757287979126, 0.851958155632019, 0.8521589040756226, 0.8523595333099365, 0.8525600433349609, 0.852760374546051, 0.8529606461524963, 0.8531607389450073, 0.8533607125282288, 0.8535605669021606, 0.853760302066803, 0.8539599180221558, 0.854159414768219, 0.8543587923049927, 0.854557991027832, 0.8547571301460266, 0.8549560904502869, 0.8551549315452576, 0.8553537130355835, 0.8555523157119751, 0.8557507991790771, 0.8559491038322449, 0.8561473488807678, 0.8563454747200012, 0.8565434217453003, 0.8567413091659546, 0.8569390177726746, 0.857136607170105, 0.8573340773582458, 0.8575314283370972, 0.8577286601066589, 0.8579257130622864, 0.858122706413269, 0.8583195209503174, 0.858516275882721, 0.8587128520011902, 0.8589093089103699, 0.85910564661026, 0.8593018651008606, 0.8594979643821716, 0.8596938848495483, 0.8598897457122803, 0.8600854277610779, 0.8602809906005859, 0.8604764342308044, 0.8606717586517334, 0.8608669638633728, 0.8610620498657227, 0.861257016658783, 0.8614518046379089, 0.8616465330123901, 0.861841082572937, 0.8620355129241943, 0.8622298240661621, 0.8624240159988403, 0.8626179695129395, 0.8628119230270386, 0.8630057573318481, 0.8631994128227234, 0.8633929491043091, 0.8635863661766052, 0.8637796640396118, 0.8639728426933289, 0.8641659021377563, 0.8643587827682495, 0.8645516037940979, 0.864744246006012, 0.8649367690086365, 0.8651291728019714, 0.8653214573860168, 0.8655136227607727, 0.865705668926239, 0.865897536277771, 0.8660892844200134, 0.8662809729576111, 0.8664724826812744, 0.8666638731956482, 0.8668550848960876, 0.8670462369918823, 0.8672372698783875, 0.8674281239509583, 0.8676188588142395, 0.8678094744682312, 0.8679999709129333, 0.868190348148346, 0.868380606174469, 0.8685706853866577, 0.8687607049942017, 0.8689505457878113, 0.8691402673721313, 0.8693298697471619, 0.8695193529129028, 0.8697087168693542, 0.8698979020118713, 0.8700869679450989, 0.8702759742736816, 0.8704648017883301, 0.870653510093689, 0.8708420991897583, 0.8710305094718933, 0.8712188601493835, 0.8714070320129395, 0.8715950846672058, 0.8717830181121826, 0.8719708323478699, 0.8721585273742676, 0.872346043586731, 0.8725335001945496, 0.8727207779884338, 0.8729079365730286, 0.8730949759483337, 0.8732818961143494, 0.8734686970710754, 0.8736553192138672, 0.8738418817520142, 0.8740282654762268, 0.8742145299911499, 0.8744006752967834, 0.8745866417884827, 0.8747725486755371, 0.8749582767486572, 0.8751439452171326, 0.8753294348716736, 0.875514805316925, 0.875700056552887, 0.8758851289749146, 0.8760701417922974, 0.8762549757957458, 0.8764396905899048, 0.8766242861747742, 0.876808762550354, 0.8769930601119995, 0.8771772980690002, 0.8773613572120667, 0.8775452971458435, 0.8777291178703308, 0.8779128193855286, 0.8780964016914368, 0.8782798051834106, 0.8784631490707397, 0.8786463141441345, 0.8788293600082397, 0.8790122866630554, 0.8791950345039368, 0.8793777227401733, 0.8795602321624756, 0.8797426223754883, 0.8799248933792114, 0.880107045173645, 0.8802890181541443, 0.8804709315299988, 0.880652666091919, 0.8808342814445496, 0.8810157775878906, 0.8811971545219421, 0.8813784122467041, 0.8815594911575317, 0.8817404508590698, 0.8819212913513184, 0.8821020126342773, 0.8822826147079468, 0.8824630379676819, 0.8826434016227722, 0.8828235864639282, 0.8830036520957947, 0.8831835389137268, 0.8833633065223694, 0.8835430145263672, 0.8837225437164307, 0.8839019536972046, 0.884081244468689, 0.8842604160308838, 0.8844394087791443, 0.88461834192276, 0.8847970962524414, 0.8849757313728333, 0.8851542472839355, 0.8853325843811035, 0.8855108618736267, 0.8856889605522156, 0.8858669400215149, 0.8860448002815247, 0.8862225413322449, 0.8864001035690308, 0.8865776062011719, 0.8867549300193787, 0.8869321346282959, 0.8871091604232788, 0.8872861266136169, 0.8874629139900208, 0.8876396417617798, 0.8878161907196045, 0.8879925608634949, 0.8881688714027405, 0.8883450627326965, 0.8885210752487183, 0.8886969685554504, 0.8888727426528931, 0.8890483379364014, 0.8892238736152649, 0.8893992304801941, 0.8895744681358337, 0.8897495865821838, 0.8899245858192444, 0.8900994062423706, 0.890274167060852, 0.8904487490653992, 0.8906232118606567, 0.89079749584198, 0.8909717202186584, 0.8911457657814026, 0.8913196921348572, 0.8914934992790222, 0.8916671872138977, 0.8918406963348389, 0.8920141458511353, 0.8921874165534973, 0.8923605680465698, 0.892533540725708, 0.8927064538002014, 0.8928791880607605, 0.89305180311203, 0.89322429895401, 0.8933966755867004, 0.8935688734054565, 0.8937410116195679, 0.8939129710197449, 0.8940848112106323, 0.8942564725875854, 0.8944280743598938, 0.8945994973182678, 0.8947708010673523, 0.8949419856071472, 0.8951130509376526, 0.8952839374542236, 0.8954547047615051, 0.8956253528594971, 0.8957958817481995, 0.8959662914276123, 0.8961365222930908, 0.8963066339492798, 0.8964766263961792, 0.8966464996337891, 0.8968161940574646, 0.8969858288764954, 0.8971552848815918, 0.8973246216773987, 0.8974937796592712, 0.897662878036499, 0.8978317975997925, 0.8980005979537964, 0.8981692790985107, 0.8983378410339355, 0.898506224155426, 0.898674488067627, 0.8988426327705383, 0.8990106582641602, 0.8991785049438477, 0.8993462920188904, 0.8995139002799988, 0.8996813893318176, 0.8998486995697021, 0.9000159502029419, 0.9001830220222473, 0.9003499746322632, 0.9005167484283447, 0.9006834626197815, 0.9008499979972839, 0.9010164141654968, 0.9011827111244202, 0.901348888874054, 0.9015148878097534, 0.9016808271408081, 0.9018465280532837, 0.9020121693611145, 0.9021776914596558, 0.9023429751396179, 0.9025081992149353, 0.9026733040809631, 0.9028382897377014, 0.9030030965805054, 0.9031677842140198, 0.9033323526382446, 0.9034968018531799, 0.9036610722541809, 0.9038252830505371, 0.903989315032959, 0.9041531682014465, 0.9043169617652893, 0.9044805765151978, 0.9046440720558167, 0.904807448387146, 0.9049707055091858, 0.9051337838172913, 0.9052967429161072, 0.9054595828056335, 0.9056223034858704, 0.9057848453521729, 0.9059472680091858, 0.9061095714569092, 0.906271755695343, 0.9064338207244873, 0.9065957069396973, 0.9067574739456177, 0.9069191217422485, 0.9070805907249451, 0.9072420001029968, 0.9074032306671143, 0.9075643420219421, 0.9077252745628357, 0.9078861474990845, 0.9080468416213989, 0.9082074165344238, 0.9083678126335144, 0.9085281491279602, 0.9086883068084717, 0.9088483452796936, 0.9090082049369812, 0.909168004989624, 0.9093276262283325, 0.9094871282577515, 0.9096465110778809, 0.9098057150840759, 0.9099647998809814, 0.9101237654685974, 0.9102826118469238, 0.9104412794113159, 0.9105998873710632, 0.9107583165168762, 0.9109165668487549, 0.9110747575759888, 0.9112327694892883, 0.9113906621932983, 0.9115484356880188, 0.9117060303688049, 0.9118635654449463, 0.9120208621025085, 0.912178099155426, 0.912335216999054, 0.9124921560287476, 0.9126489758491516, 0.9128056764602661, 0.9129621982574463, 0.9131186008453369, 0.913274884223938, 0.9134310483932495, 0.9135870933532715, 0.9137429594993591, 0.9138987064361572, 0.914054274559021, 0.91420978307724, 0.9143651127815247, 0.9145203232765198, 0.9146754145622253, 0.9148303270339966, 0.9149851202964783, 0.9151397943496704, 0.915294349193573, 0.9154487252235413, 0.91560298204422, 0.9157571196556091, 0.9159111380577087, 0.916064977645874, 0.9162186980247498, 0.9163722991943359, 0.9165257811546326, 0.9166790843009949, 0.9168322682380676, 0.9169853329658508, 0.9171382188796997, 0.9172910451889038, 0.9174436926841736, 0.917596161365509, 0.9177485704421997, 0.917900800704956, 0.9180529117584229, 0.9182049036026001, 0.918356716632843, 0.9185084104537964, 0.9186599850654602, 0.9188114404678345, 0.9189627170562744, 0.9191138744354248, 0.9192649126052856, 0.9194158315658569, 0.9195665717124939, 0.9197171926498413, 0.9198676347732544, 0.9200179576873779, 0.9201681613922119, 0.9203182458877563, 0.9204682111740112, 0.9206179976463318, 0.9207677245140076, 0.9209172129631042, 0.9210666418075562, 0.9212158918380737, 0.9213650226593018, 0.9215140342712402, 0.9216628670692444, 0.9218116402626038, 0.9219602346420288, 0.9221086502075195, 0.9222570061683655, 0.9224051833152771, 0.9225532412528992, 0.9227011203765869, 0.9228488802909851, 0.9229965209960938, 0.9231440424919128, 0.9232914447784424, 0.9234386682510376, 0.9235857725143433, 0.9237326979637146, 0.9238795042037964, 0.9240262508392334, 0.9241727590560913, 0.9243192076683044, 0.9244654774665833, 0.9246116280555725, 0.9247576594352722, 0.9249035120010376, 0.9250492453575134, 0.9251948595046997, 0.9253402948379517, 0.9254856705665588, 0.9256308078765869, 0.9257758855819702, 0.925920844078064, 0.9260656237602234, 0.9262102246284485, 0.9263547658920288, 0.9264991283416748, 0.9266433715820312, 0.9267874956130981, 0.9269314408302307, 0.9270752668380737, 0.9272189736366272, 0.9273625612258911, 0.9275059700012207, 0.9276492595672607, 0.9277923703193665, 0.9279354214668274, 0.928078293800354, 0.9282210469245911, 0.9283636212348938, 0.928506076335907, 0.9286484122276306, 0.9287906289100647, 0.9289326667785645, 0.9290745854377747, 0.9292163848876953, 0.9293580055236816, 0.9294995665550232, 0.9296408891677856, 0.9297821521759033, 0.9299232363700867, 0.9300642013549805, 0.9302050471305847, 0.9303457140922546, 0.930486261844635, 0.9306266903877258, 0.9307669997215271, 0.930907130241394, 0.9310471415519714, 0.9311869740486145, 0.9313267469406128, 0.9314663410186768, 0.9316057562828064, 0.9317451119422913, 0.9318842887878418, 0.9320233464241028, 0.9321622252464294, 0.9323010444641113, 0.9324396252632141, 0.9325781464576721, 0.9327164888381958, 0.9328547120094299, 0.9329928159713745, 0.9331308007240295, 0.9332686066627502, 0.9334062337875366, 0.9335438013076782, 0.9336811900138855, 0.9338184595108032, 0.9339556097984314, 0.9340925812721252, 0.9342294335365295, 0.9343661665916443, 0.9345027208328247, 0.9346391558647156, 0.9347754716873169, 0.9349116086959839, 0.9350476264953613, 0.9351835250854492, 0.9353193044662476, 0.9354549050331116, 0.935590386390686, 0.9357256889343262, 0.9358608722686768, 0.9359959363937378, 0.9361308813095093, 0.9362656474113464, 0.936400294303894, 0.9365348219871521, 0.9366691708564758, 0.9368034601211548, 0.9369375109672546, 0.9370715022087097, 0.9372053146362305, 0.9373390078544617, 0.9374725818634033, 0.9376059770584106, 0.9377392530441284, 0.9378723502159119, 0.9380053877830505, 0.9381382465362549, 0.9382709264755249, 0.9384035468101501, 0.9385359883308411, 0.9386683106422424, 0.9388004541397095, 0.938932478427887, 0.9390643835067749, 0.9391961097717285, 0.9393277764320374, 0.9394592046737671, 0.939590573310852, 0.9397217631340027, 0.9398528337478638, 0.9399837851524353, 0.9401145577430725, 0.9402452111244202, 0.9403756856918335, 0.940506100654602, 0.9406363368034363, 0.9407663941383362, 0.9408963918685913, 0.9410262107849121, 0.9411558508872986, 0.9412854313850403, 0.9414148330688477, 0.9415440559387207, 0.941673219203949, 0.9418022036552429, 0.9419310092926025, 0.9420597553253174, 0.9421883225440979, 0.9423167705535889, 0.9424450397491455, 0.9425731897354126, 0.9427012205123901, 0.9428291320800781, 0.9429568648338318, 0.9430844783782959, 0.9432119131088257, 0.9433392286300659, 0.9434664249420166, 0.943593442440033, 0.9437204003334045, 0.9438471794128418, 0.9439737796783447, 0.9441002607345581, 0.9442266225814819, 0.9443528652191162, 0.9444789290428162, 0.9446048736572266, 0.9447306394577026, 0.9448562860488892, 0.9449818134307861, 0.9451072216033936, 0.9452324509620667, 0.9453575611114502, 0.9454824924468994, 0.9456073641777039, 0.945732057094574, 0.9458565711975098, 0.945980966091156, 0.9461052417755127, 0.9462293982505798, 0.9463533759117126, 0.9464772343635559, 0.9466009140014648, 0.946724534034729, 0.9468479156494141, 0.9469712376594543, 0.9470943808555603, 0.9472174048423767, 0.9473403096199036, 0.9474630355834961, 0.9475856423377991, 0.9477080702781677, 0.9478303790092468, 0.9479525685310364, 0.9480746388435364, 0.948196530342102, 0.9483182430267334, 0.94843989610672, 0.9485613703727722, 0.9486827254295349, 0.9488039016723633, 0.9489249587059021, 0.9490458965301514, 0.9491667151451111, 0.9492873549461365, 0.9494078159332275, 0.9495282173156738, 0.9496484398841858, 0.9497684836387634, 0.9498884081840515, 0.95000821352005, 0.950127899646759, 0.9502474069595337, 0.9503667950630188, 0.9504860639572144, 0.9506051540374756, 0.9507241249084473, 0.9508429765701294, 0.9509616494178772, 0.9510802030563354, 0.9511986374855042, 0.9513168931007385, 0.9514350295066833, 0.9515529870986938, 0.9516708850860596, 0.9517885446548462, 0.951906144618988, 0.9520235657691956, 0.9521408677101135, 0.9522579908370972, 0.9523749947547913, 0.9524918794631958, 0.952608585357666, 0.9527251720428467, 0.9528416395187378, 0.9529579281806946, 0.9530740976333618, 0.9531901478767395, 0.9533060193061829, 0.9534217715263367, 0.9535374045372009, 0.9536528587341309, 0.9537681937217712, 0.9538834095001221, 0.9539984464645386, 0.9541133046150208, 0.9542281031608582, 0.9543427228927612, 0.9544572234153748, 0.954571545124054, 0.9546857476234436, 0.9547998309135437, 0.9549137353897095, 0.9550275206565857, 0.9551411867141724, 0.9552546739578247, 0.9553680419921875, 0.9554812908172607, 0.9555943608283997, 0.955707311630249, 0.9558200836181641, 0.9559327363967896, 0.9560452699661255, 0.9561576247215271, 0.9562698602676392, 0.9563819766044617, 0.9564939141273499, 0.9566057324409485, 0.9567174315452576, 0.9568289518356323, 0.9569403529167175, 0.9570515751838684, 0.9571627378463745, 0.9572736620903015, 0.9573845267295837, 0.9574952125549316, 0.95760577917099, 0.957716166973114, 0.9578264355659485, 0.9579365253448486, 0.958046555519104, 0.958156406879425, 0.9582660794258118, 0.9583756327629089, 0.9584850668907166, 0.9585943818092346, 0.9587035179138184, 0.9588124752044678, 0.9589213728904724, 0.9590300917625427, 0.9591386318206787, 0.9592470526695251, 0.959355354309082, 0.9594635367393494, 0.9595715403556824, 0.9596794247627258, 0.959787130355835, 0.9598947167396545, 0.9600021839141846, 0.9601094722747803, 0.9602166414260864, 0.9603236317634583, 0.9604305624961853, 0.9605372548103333, 0.9606438875198364, 0.9607503414154053, 0.9608566761016846, 0.9609628319740295, 0.961068868637085, 0.9611747860908508, 0.9612805247306824, 0.9613861441612244, 0.961491584777832, 0.9615969061851501, 0.9617021083831787, 0.961807131767273, 0.9619120359420776, 0.9620168209075928, 0.9621214270591736, 0.9622258543968201, 0.9623302221298218, 0.9624344110488892, 0.962538480758667, 0.9626423716545105, 0.9627461433410645, 0.9628497958183289, 0.9629532694816589, 0.9630566239356995, 0.9631597995758057, 0.9632628560066223, 0.9633657932281494, 0.9634685516357422, 0.9635711908340454, 0.9636737108230591, 0.9637760519981384, 0.9638782739639282, 0.9639803767204285, 0.9640823006629944, 0.964184045791626, 0.9642857313156128, 0.9643872380256653, 0.9644885659217834, 0.9645897746086121, 0.9646908640861511, 0.9647918343544006, 0.9648926258087158, 0.9649932384490967, 0.9650937914848328, 0.9651941061019897, 0.965294361114502, 0.9653944373130798, 0.9654943943023682, 0.9655941724777222, 0.9656938314437866, 0.9657933712005615, 0.9658927321434021, 0.9659919738769531, 0.9660910367965698, 0.966189980506897, 0.9662888050079346, 0.9663874506950378, 0.9664859771728516, 0.9665843844413757, 0.9666826128959656, 0.9667807221412659, 0.9668786525726318, 0.9669764637947083, 0.9670741558074951, 0.9671716690063477, 0.9672690629959106, 0.9673662781715393, 0.9674633741378784, 0.967560350894928, 0.9676571488380432, 0.9677538275718689, 0.967850387096405, 0.9679467678070068, 0.9680430293083191, 0.968139111995697, 0.9682350754737854, 0.9683309197425842, 0.9684265851974487, 0.9685221314430237, 0.9686174988746643, 0.9687127470970154, 0.9688078761100769, 0.9689028263092041, 0.9689976572990417, 0.9690923094749451, 0.9691868424415588, 0.9692812561988831, 0.969375491142273, 0.9694696068763733, 0.9695636034011841, 0.9696574211120605, 0.9697510600090027, 0.9698446393013, 0.9699380397796631, 0.9700312614440918, 0.970124363899231, 0.9702173471450806, 0.9703101515769958, 0.9704028367996216, 0.9704954028129578, 0.9705877900123596, 0.9706800580024719, 0.9707721471786499, 0.9708641171455383, 0.9709559679031372, 0.9710476398468018, 0.9711391925811768, 0.9712305665016174, 0.9713218212127686, 0.9714129567146301, 0.9715039134025574, 0.9715947508811951, 0.9716854095458984, 0.9717759490013123, 0.9718663692474365, 0.9719566106796265, 0.9720467329025269, 0.9721366763114929, 0.9722265005111694, 0.9723162055015564, 0.972405731678009, 0.9724951386451721, 0.9725843667984009, 0.9726734757423401, 0.9727624654769897, 0.9728512763977051, 0.9729399681091309, 0.9730284810066223, 0.9731168746948242, 0.9732051491737366, 0.9732932448387146, 0.9733812212944031, 0.9734690189361572, 0.9735566973686218, 0.9736442565917969, 0.9737316370010376, 0.9738188982009888, 0.9739059805870056, 0.9739929437637329, 0.9740797877311707, 0.9741664528846741, 0.9742529988288879, 0.9743393659591675, 0.9744256138801575, 0.9745117425918579, 0.974597692489624, 0.9746835231781006, 0.9747691750526428, 0.9748547077178955, 0.9749401211738586, 0.9750253558158875, 0.9751104712486267, 0.9751954078674316, 0.975280225276947, 0.9753648638725281, 0.9754494428634644, 0.9755337834358215, 0.9756180644035339, 0.9757021069526672, 0.9757860898971558, 0.97586989402771, 0.9759535789489746, 0.9760370850563049, 0.9761204719543457, 0.9762036800384521, 0.976286768913269, 0.9763697385787964, 0.9764525294303894, 0.9765352010726929, 0.976617693901062, 0.9767000675201416, 0.9767823219299316, 0.9768643975257874, 0.9769463539123535, 0.9770281314849854, 0.9771097898483276, 0.9771913290023804, 0.9772726893424988, 0.9773539304733276, 0.9774349927902222, 0.9775159358978271, 0.9775967001914978, 0.9776773452758789, 0.9777578711509705, 0.9778382182121277, 0.9779184460639954, 0.9779984951019287, 0.9780784249305725, 0.9781582355499268, 0.9782378673553467, 0.978317379951477, 0.9783967137336731, 0.9784759283065796, 0.9785550236701965, 0.9786339402198792, 0.9787127375602722, 0.978791356086731, 0.9788698554039001, 0.978948175907135, 0.9790263772010803, 0.9791044592857361, 0.9791823625564575, 0.9792601466178894, 0.979337751865387, 0.979415237903595, 0.9794926047325134, 0.9795697927474976, 0.9796468019485474, 0.9797237515449524, 0.9798005223274231, 0.9798771142959595, 0.9799535870552063, 0.9800299406051636, 0.9801061153411865, 0.9801821708679199, 0.980258047580719, 0.9803338050842285, 0.9804093837738037, 0.9804849028587341, 0.9805601835250854, 0.980635404586792, 0.9807103872299194, 0.9807853102684021, 0.9808600544929504, 0.9809346199035645, 0.9810091257095337, 0.9810833930969238, 0.9811576008796692, 0.9812315702438354, 0.9813054800033569, 0.9813792109489441, 0.9814528226852417, 0.981526255607605, 0.9815995693206787, 0.9816727042198181, 0.981745719909668, 0.9818185567855835, 0.9818912744522095, 0.9819638729095459, 0.982036292552948, 0.9821085929870605, 0.9821807146072388, 0.9822527170181274, 0.9823246002197266, 0.9823963046073914, 0.9824678897857666, 0.9825392961502075, 0.9826105833053589, 0.9826816916465759, 0.9827526807785034, 0.9828235507011414, 0.982894241809845, 0.982964813709259, 0.9830352067947388, 0.983105480670929, 0.9831756353378296, 0.9832456111907959, 0.9833154082298279, 0.9833850860595703, 0.9834546446800232, 0.9835240840911865, 0.9835932850837708, 0.9836624264717102, 0.9837313890457153, 0.9838002324104309, 0.9838688969612122, 0.9839374423027039, 0.9840058088302612, 0.984074056148529, 0.9841421246528625, 0.9842100739479065, 0.9842779040336609, 0.984345555305481, 0.9844130873680115, 0.9844804406166077, 0.9845476746559143, 0.9846147894859314, 0.9846817255020142, 0.9847484827041626, 0.9848151803016663, 0.9848816394805908, 0.9849480390548706, 0.9850142598152161, 0.9850803017616272, 0.9851462244987488, 0.9852120280265808, 0.9852776527404785, 0.9853431582450867, 0.9854084849357605, 0.9854736924171448, 0.9855387210845947, 0.9856036305427551, 0.985668420791626, 0.9857330322265625, 0.9857975244522095, 0.9858618378639221, 0.9859260320663452, 0.985990047454834, 0.9860539436340332, 0.9861177206039429, 0.9861813187599182, 0.986244797706604, 0.9863080978393555, 0.9863712787628174, 0.986434280872345, 0.986497163772583, 0.9865599274635315, 0.9866225123405457, 0.9866849780082703, 0.9867472648620605, 0.9868094325065613, 0.9868714213371277, 0.9869332909584045, 0.9869949817657471, 0.9870565533638, 0.9871180057525635, 0.9871792793273926, 0.9872404336929321, 0.9873014092445374, 0.987362265586853, 0.9874230027198792, 0.987483561038971, 0.9875439405441284, 0.9876042008399963, 0.9876643419265747, 0.9877243041992188, 0.9877841472625732, 0.9878438115119934, 0.987903356552124, 0.9879627823829651, 0.9880220293998718, 0.988081157207489, 0.9881401062011719, 0.9881989359855652, 0.9882575869560242, 0.9883161187171936, 0.9883744716644287, 0.9884327054023743, 0.9884908199310303, 0.988548755645752, 0.9886065721511841, 0.9886642098426819, 0.9887217283248901, 0.9887790679931641, 0.9888362884521484, 0.9888933300971985, 0.988950252532959, 0.9890070557594299, 0.9890636801719666, 0.9891201853752136, 0.9891765117645264, 0.9892327189445496, 0.9892887473106384, 0.9893446564674377, 0.9894004464149475, 0.989456057548523, 0.9895114898681641, 0.9895668625831604, 0.9896219968795776, 0.9896770715713501, 0.9897319674491882, 0.989786684513092, 0.9898412823677063, 0.9898957014083862, 0.9899500608444214, 0.9900041818618774, 0.990058183670044, 0.9901120662689209, 0.9901658296585083, 0.9902193546295166, 0.9902728199958801, 0.9903261065483093, 0.9903792142868042, 0.9904322624206543, 0.9904850721359253, 0.9905377626419067, 0.9905903339385986, 0.990642786026001, 0.9906949996948242, 0.9907471537590027, 0.9907991290092468, 0.9908509254455566, 0.9909026622772217, 0.9909541606903076, 0.991005539894104, 0.9910567998886108, 0.9911079406738281, 0.9911588430404663, 0.9912096858024597, 0.9912603497505188, 0.9913108348846436, 0.9913612604141235, 0.9914114475250244, 0.9914615154266357, 0.9915114641189575, 0.9915612936019897, 0.9916108846664429, 0.9916604161262512, 0.9917097687721252, 0.9917589426040649, 0.9918079972267151, 0.9918569326400757, 0.991905689239502, 0.9919543266296387, 0.9920027852058411, 0.9920511245727539, 0.9920993447303772, 0.9921473860740662, 0.9921952486038208, 0.9922429919242859, 0.9922906160354614, 0.9923380613327026, 0.9923853874206543, 0.9924325346946716, 0.9924795627593994, 0.9925264120101929, 0.9925731420516968, 0.9926196932792664, 0.9926661252975464, 0.9927124381065369, 0.992758572101593, 0.9928045868873596, 0.9928504228591919, 0.9928961396217346, 0.992941677570343, 0.9929870963096619, 0.9930323362350464, 0.9930774569511414, 0.9931224584579468, 0.9931672811508179, 0.9932119846343994, 0.9932565093040466, 0.9933008551597595, 0.9933451414108276, 0.9933892488479614, 0.9934331774711609, 0.9934769868850708, 0.9935206174850464, 0.9935641288757324, 0.9936075210571289, 0.9936507344245911, 0.9936938285827637, 0.993736743927002, 0.9937795400619507, 0.9938221573829651, 0.9938646554946899, 0.9939069747924805, 0.9939491748809814, 0.9939912557601929, 0.99403315782547, 0.9940748810768127, 0.994116485118866, 0.9941579699516296, 0.994199275970459, 0.9942404627799988, 0.9942814707756042, 0.9943223595619202, 0.9943631291389465, 0.9944036602973938, 0.9944441318511963, 0.9944844245910645, 0.9945245385169983, 0.9945645928382874, 0.9946044087409973, 0.9946441650390625, 0.9946836829185486, 0.9947231411933899, 0.9947624206542969, 0.9948015213012695, 0.9948405027389526, 0.9948793053627014, 0.9949179887771606, 0.9949565529823303, 0.9949949383735657, 0.9950332045555115, 0.995071291923523, 0.9951092600822449, 0.9951470494270325, 0.9951847195625305, 0.995222270488739, 0.9952595829963684, 0.995296835899353, 0.9953339099884033, 0.9953708648681641, 0.9954076409339905, 0.9954442381858826, 0.9954807758331299, 0.9955170750617981, 0.9955533146858215, 0.9955893754959106, 0.9956252574920654, 0.9956610202789307, 0.9956966042518616, 0.9957320690155029, 0.9957674145698547, 0.9958025813102722, 0.9958376288414001, 0.9958724975585938, 0.9959072470664978, 0.9959418177604675, 0.9959762692451477, 0.9960105419158936, 0.9960446953773499, 0.9960787296295166, 0.996112585067749, 0.9961462616920471, 0.9961798191070557, 0.9962132573127747, 0.9962465167045593, 0.9962796568870544, 0.9963126182556152, 0.9963454604148865, 0.9963781237602234, 0.9964106678962708, 0.9964430332183838, 0.9964752793312073, 0.9965074062347412, 0.9965393543243408, 0.9965711236000061, 0.9966028332710266, 0.996634304523468, 0.9966656565666199, 0.9966968894004822, 0.9967279434204102, 0.9967588782310486, 0.9967896938323975, 0.996820330619812, 0.9968507885932922, 0.9968811273574829, 0.996911346912384, 0.9969413876533508, 0.9969712495803833, 0.9970009922981262, 0.9970306158065796, 0.9970600605010986, 0.9970893859863281, 0.9971185326576233, 0.9971475601196289, 0.997176468372345, 0.9972051382064819, 0.9972337484359741, 0.997262179851532, 0.9972904324531555, 0.9973186254501343, 0.9973465800285339, 0.997374415397644, 0.9974021315574646, 0.9974296689033508, 0.9974570870399475, 0.9974843263626099, 0.9975114464759827, 0.9975384473800659, 0.9975652694702148, 0.9975919127464294, 0.9976184368133545, 0.99764484167099, 0.9976710677146912, 0.997697114944458, 0.9977230429649353, 0.997748851776123, 0.9977744817733765, 0.9977999925613403, 0.9978253841400146, 0.9978505373001099, 0.9978756308555603, 0.9979005455970764, 0.9979252815246582, 0.9979498982429504, 0.9979743957519531, 0.9979987144470215, 0.9980228543281555, 0.998046875, 0.9980707764625549, 0.9980944991111755, 0.9981181025505066, 0.9981415271759033, 0.9981648325920105, 0.9981880187988281, 0.9982110261917114, 0.9982338547706604, 0.9982565641403198, 0.9982791543006897, 0.9983015656471252, 0.9983237981796265, 0.9983459115028381, 0.9983679056167603, 0.998389720916748, 0.9984114170074463, 0.9984329342842102, 0.9984543323516846, 0.9984755516052246, 0.9984966516494751, 0.998517632484436, 0.9985384345054626, 0.9985590577125549, 0.9985795617103577, 0.9985999464988708, 0.9986201524734497, 0.998640239238739, 0.998660147190094, 0.9986799359321594, 0.9986995458602905, 0.9987190365791321, 0.9987383484840393, 0.998757541179657, 0.9987765550613403, 0.9987954497337341, 0.9988142251968384, 0.9988328218460083, 0.9988512396812439, 0.9988695383071899, 0.9988877177238464, 0.9989057183265686, 0.9989235997200012, 0.9989413022994995, 0.9989588856697083, 0.9989762902259827, 0.9989935755729675, 0.9990106821060181, 0.999027669429779, 0.9990444779396057, 0.9990611672401428, 0.9990777373313904, 0.9990941286087036, 0.9991103410720825, 0.9991264939308167, 0.9991424083709717, 0.9991582036018372, 0.9991738796234131, 0.9991893768310547, 0.9992047548294067, 0.9992199540138245, 0.9992350339889526, 0.9992499947547913, 0.9992647767066956, 0.9992793798446655, 0.999293863773346, 0.999308168888092, 0.9993224143981934, 0.9993364214897156, 0.9993503093719482, 0.9993640780448914, 0.9993776679039001, 0.9993911385536194, 0.9994044303894043, 0.9994176030158997, 0.9994305968284607, 0.9994434714317322, 0.9994561672210693, 0.9994687438011169, 0.999481201171875, 0.9994934797286987, 0.9995055794715881, 0.999517560005188, 0.9995294213294983, 0.9995411038398743, 0.9995526671409607, 0.9995640516281128, 0.9995753169059753, 0.9995864033699036, 0.9995973706245422, 0.9996081590652466, 0.9996188282966614, 0.9996293187141418, 0.9996396899223328, 0.9996499419212341, 0.9996600151062012, 0.9996699094772339, 0.999679684638977, 0.9996893405914307, 0.99969881772995, 0.9997081756591797, 0.9997173547744751, 0.999726414680481, 0.9997352957725525, 0.9997440576553345, 0.9997526407241821, 0.9997611045837402, 0.999769389629364, 0.9997775554656982, 0.9997856020927429, 0.9997934699058533, 0.9998011589050293, 0.9998087286949158, 0.9998161792755127, 0.9998234510421753, 0.9998306035995483, 0.9998375773429871, 0.9998444318771362, 0.9998511075973511, 0.9998576641082764, 0.9998640418052673, 0.9998703002929688, 0.9998763799667358, 0.9998823404312134, 0.9998881816864014, 0.999893844127655, 0.9998993277549744, 0.9999046921730042, 0.9999099373817444, 0.9999150037765503, 0.9999199509620667, 0.9999247193336487, 0.9999293088912964, 0.9999338388442993, 0.9999381303787231, 0.9999423623085022, 0.9999464154243469, 0.9999502897262573, 0.9999540448188782, 0.9999576210975647, 0.9999610781669617, 0.9999644160270691, 0.9999675750732422, 0.9999706149101257, 0.999973475933075, 0.9999761581420898, 0.9999787211418152, 0.999981164932251, 0.9999834299087524, 0.9999855756759644, 0.9999876022338867, 0.99998939037323, 0.9999911189079285, 0.9999926686286926, 0.9999940395355225, 0.9999952912330627, 0.9999964237213135, 0.9999973773956299, 0.999998152256012, 0.9999988079071045, 0.9999993443489075, 0.9999997019767761, 0.9999999403953552, 1.0, 0.9999999403953552, 0.9999997019767761, 0.9999993443489075, 0.9999988079071045, 0.999998152256012, 0.9999973773956299, 0.9999964237213135, 0.9999952912330627, 0.9999940395355225, 0.9999926686286926, 0.9999911189079285, 0.99998939037323, 0.9999876022338867, 0.9999855756759644, 0.9999834299087524, 0.999981164932251, 0.9999787211418152, 0.9999761581420898, 0.999973475933075, 0.9999706149101257, 0.9999675750732422, 0.9999644160270691, 0.9999610781669617, 0.9999576210975647, 0.9999540448188782, 0.9999502897262573, 0.9999464154243469, 0.9999423623085022, 0.9999381303787231, 0.9999338388442993, 0.9999293088912964, 0.9999247193336487, 0.9999199509620667, 0.9999150037765503, 0.9999099373817444, 0.9999046921730042, 0.9998993277549744, 0.999893844127655, 0.9998881816864014, 0.9998823404312134, 0.9998763799667358, 0.9998703002929688, 0.9998640418052673, 0.9998576641082764, 0.9998511075973511, 0.9998444318771362, 0.9998375773429871, 0.9998306035995483, 0.9998234510421753, 0.9998161792755127, 0.9998087286949158, 0.9998011589050293, 0.9997934699058533, 0.9997856020927429, 0.9997775554656982, 0.999769389629364, 0.9997611045837402, 0.9997526407241821, 0.9997440576553345, 0.9997352957725525, 0.999726414680481, 0.9997173547744751, 0.9997081756591797, 0.99969881772995, 0.9996893405914307, 0.999679684638977, 0.9996699094772339, 0.9996600151062012, 0.9996499419212341, 0.9996396899223328, 0.9996293187141418, 0.9996188282966614, 0.9996081590652466, 0.9995973706245422, 0.9995864033699036, 0.9995753169059753, 0.9995640516281128, 0.9995526671409607, 0.9995411038398743, 0.9995294213294983, 0.999517560005188, 0.9995055794715881, 0.9994934797286987, 0.999481201171875, 0.9994687438011169, 0.9994561672210693, 0.9994434714317322, 0.9994305968284607, 0.9994176030158997, 0.9994044303894043, 0.9993911385536194, 0.9993776679039001, 0.9993640780448914, 0.9993503093719482, 0.9993364214897156, 0.9993223547935486, 0.999308168888092, 0.999293863773346, 0.9992793798446655, 0.9992647171020508, 0.9992499947547913, 0.9992350339889526, 0.9992199540138245, 0.9992047548294067, 0.9991893768310547, 0.9991738796234131, 0.9991582036018372, 0.9991424083709717, 0.9991264939308167, 0.9991103410720825, 0.9990941286087036, 0.9990777373313904, 0.9990611672401428, 0.9990444779396057, 0.999027669429779, 0.9990106821060181, 0.9989935755729675, 0.9989762902259827, 0.9989588856697083, 0.9989413022994995, 0.9989235997200012, 0.9989057183265686, 0.9988877177238464, 0.9988695383071899, 0.9988512396812439, 0.9988328218460083, 0.9988142251968384, 0.9987954497337341, 0.9987765550613403, 0.998757541179657, 0.9987383484840393, 0.9987190365791321, 0.9986995458602905, 0.9986798763275146, 0.998660147190094, 0.998640239238739, 0.9986201524734497, 0.9985999464988708, 0.9985795617103577, 0.9985590577125549, 0.9985384345054626, 0.998517632484436, 0.9984966516494751, 0.9984755516052246, 0.9984543323516846, 0.9984329342842102, 0.9984114170074463, 0.998389720916748, 0.9983679056167603, 0.9983459115028381, 0.9983237981796265, 0.9983015656471252, 0.9982790946960449, 0.9982565641403198, 0.9982338547706604, 0.9982110261917114, 0.9981880187988281, 0.9981648325920105, 0.9981415271759033, 0.9981181025505066, 0.9980944991111755, 0.9980707764625549, 0.998046875, 0.9980228543281555, 0.9979987144470215, 0.9979743957519531, 0.9979498982429504, 0.9979252815246582, 0.9979005455970764, 0.9978756308555603, 0.9978505373001099, 0.9978253245353699, 0.9977999925613403, 0.9977744817733765, 0.997748851776123, 0.9977230429649353, 0.997697114944458, 0.9976710677146912, 0.99764484167099, 0.9976184368133545, 0.9975919127464294, 0.9975652098655701, 0.9975384473800659, 0.9975114464759827, 0.9974843263626099, 0.9974570870399475, 0.9974296689033508, 0.9974021315574646, 0.997374415397644, 0.9973465800285339, 0.9973185658454895, 0.9972904324531555, 0.997262179851532, 0.9972337484359741, 0.9972051382064819, 0.9971764087677002, 0.9971475601196289, 0.9971185326576233, 0.9970893859863281, 0.9970600605010986, 0.9970306158065796, 0.9970009922981262, 0.9969712495803833, 0.996941328048706, 0.9969112873077393, 0.9968811273574829, 0.9968507885932922, 0.9968202710151672, 0.9967896938323975, 0.9967588782310486, 0.9967279434204102, 0.9966968894004822, 0.9966656565666199, 0.996634304523468, 0.9966027736663818, 0.9965711236000061, 0.9965393543243408, 0.9965074062347412, 0.9964752793312073, 0.9964430332183838, 0.9964106678962708, 0.9963781237602234, 0.9963454604148865, 0.9963126182556152, 0.9962796568870544, 0.9962465167045593, 0.9962132573127747, 0.9961798191070557, 0.9961462616920471, 0.9961125254631042, 0.9960786700248718, 0.9960446953773499, 0.9960105419158936, 0.9959762692451477, 0.9959418177604675, 0.9959072470664978, 0.9958724975585938, 0.9958376288414001, 0.9958025813102722, 0.9957674145698547, 0.9957320690155029, 0.9956966042518616, 0.9956610202789307, 0.9956252574920654, 0.9955893158912659, 0.9955533146858215, 0.9955170750617981, 0.9954807758331299, 0.9954442381858826, 0.9954076409339905, 0.9953708052635193, 0.9953339099884033, 0.995296835899353, 0.9952595829963684, 0.9952222108840942, 0.9951847195625305, 0.9951470494270325, 0.9951092600822449, 0.995071291923523, 0.9950332045555115, 0.9949949383735657, 0.9949565529823303, 0.9949179887771606, 0.9948793053627014, 0.9948405027389526, 0.9948015213012695, 0.9947623610496521, 0.9947230815887451, 0.9946836829185486, 0.9946441054344177, 0.9946044087409973, 0.9945645332336426, 0.9945245385169983, 0.9944844245910645, 0.9944441318511963, 0.9944036602973938, 0.9943630695343018, 0.9943223595619202, 0.9942814707756042, 0.9942404627799988, 0.994199275970459, 0.9941579699516296, 0.994116485118866, 0.9940748810768127, 0.9940330982208252, 0.9939911961555481, 0.9939491748809814, 0.9939069747924805, 0.9938646554946899, 0.9938221573829651, 0.9937794804573059, 0.993736743927002, 0.9936937689781189, 0.9936507344245911, 0.9936075210571289, 0.9935641288757324, 0.9935206174850464, 0.9934769868850708, 0.9934331774711609, 0.9933891892433167, 0.9933451414108276, 0.9933008551597595, 0.9932565093040466, 0.9932119250297546, 0.9931672811508179, 0.9931224584579468, 0.9930774569511414, 0.9930323362350464, 0.9929870963096619, 0.992941677570343, 0.9928961396217346, 0.9928504228591919, 0.9928045868873596, 0.992758572101593, 0.9927124381065369, 0.9926661252975464, 0.9926196932792664, 0.9925731420516968, 0.9925264120101929, 0.9924795031547546, 0.9924325346946716, 0.9923853278160095, 0.9923380613327026, 0.9922906160354614, 0.9922429919242859, 0.9921952486038208, 0.9921473264694214, 0.9920992851257324, 0.9920511245727539, 0.9920027852058411, 0.9919543266296387, 0.991905689239502, 0.9918569326400757, 0.9918079972267151, 0.9917589426040649, 0.9917097687721252, 0.9916604161262512, 0.9916108846664429, 0.991561233997345, 0.9915114641189575, 0.9914615154266357, 0.9914114475250244, 0.9913612008094788, 0.9913108348846436, 0.9912603497505188, 0.9912096858024597, 0.9911588430404663, 0.9911078810691833, 0.9910567998886108, 0.991005539894104, 0.9909541606903076, 0.9909026026725769, 0.9908509254455566, 0.9907991290092468, 0.9907471537590027, 0.9906949996948242, 0.9906427264213562, 0.9905903339385986, 0.9905377626419067, 0.9904850721359253, 0.9904322028160095, 0.9903792142868042, 0.9903261065483093, 0.9902728199958801, 0.9902193546295166, 0.9901657700538635, 0.9901120662689209, 0.990058183670044, 0.9900041818618774, 0.9899500012397766, 0.9898957014083862, 0.9898412823677063, 0.989786684513092, 0.9897319078445435, 0.9896770119667053, 0.9896219968795776, 0.9895668029785156, 0.9895114898681641, 0.989456057548523, 0.9894003868103027, 0.9893446564674377, 0.9892887473106384, 0.9892327189445496, 0.9891765117645264, 0.9891201257705688, 0.9890636801719666, 0.9890070557594299, 0.988950252532959, 0.9888933300971985, 0.9888362884521484, 0.9887790679931641, 0.9887216687202454, 0.9886642098426819, 0.9886065125465393, 0.988548755645752, 0.9884908199310303, 0.9884327054023743, 0.9883744716644287, 0.9883161187171936, 0.9882575869560242, 0.9881988763809204, 0.9881401062011719, 0.9880810976028442, 0.9880220293998718, 0.9879627823829651, 0.987903356552124, 0.9878438115119934, 0.9877841472625732, 0.9877243041992188, 0.9876643419265747, 0.9876042008399963, 0.9875439405441284, 0.9874835014343262, 0.9874229431152344, 0.987362265586853, 0.9873014092445374, 0.9872404336929321, 0.9871792793273926, 0.9871180057525635, 0.9870565533638, 0.9869949817657471, 0.9869332909584045, 0.9868714213371277, 0.9868093729019165, 0.9867472648620605, 0.9866849184036255, 0.9866225123405457, 0.9865599274635315, 0.986497163772583, 0.986434280872345, 0.9863712787628174, 0.9863080978393555, 0.986244797706604, 0.9861813187599182, 0.9861177206039429, 0.9860539436340332, 0.985990047454834, 0.9859260320663452, 0.9858618378639221, 0.9857975244522095, 0.9857330322265625, 0.985668420791626, 0.9856036305427551, 0.9855387210845947, 0.9854736924171448, 0.9854084849357605, 0.9853430986404419, 0.9852776527404785, 0.985211968421936, 0.9851462244987488, 0.9850803017616272, 0.9850142002105713, 0.9849479794502258, 0.9848816394805908, 0.9848151206970215, 0.9847484827041626, 0.9846817255020142, 0.9846147298812866, 0.9845476746559143, 0.9844804406166077, 0.9844130873680115, 0.984345555305481, 0.9842779040336609, 0.9842100739479065, 0.9841421246528625, 0.984074056148529, 0.9840058088302612, 0.9839373826980591, 0.9838688969612122, 0.9838001728057861, 0.9837313890457153, 0.9836624264717102, 0.9835932850837708, 0.9835240244865417, 0.9834546446800232, 0.9833850860595703, 0.9833154082298279, 0.9832455515861511, 0.9831755757331848, 0.983105480670929, 0.9830352067947388, 0.982964813709259, 0.982894241809845, 0.9828235507011414, 0.9827526807785034, 0.9826816916465759, 0.9826105833053589, 0.9825392961502075, 0.9824678897857666, 0.9823963046073914, 0.9823246002197266, 0.9822527170181274, 0.9821807146072388, 0.9821085929870605, 0.982036292552948, 0.9819638729095459, 0.9818912744522095, 0.9818185567855835, 0.981745719909668, 0.9816727042198181, 0.9815995097160339, 0.981526255607605, 0.9814527630805969, 0.9813792109489441, 0.9813054800033569, 0.9812315702438354, 0.9811575412750244, 0.9810833930969238, 0.9810090661048889, 0.9809346199035645, 0.9808599948883057, 0.9807852506637573, 0.9807103872299194, 0.9806353449821472, 0.9805601835250854, 0.9804848432540894, 0.9804093837738037, 0.9803338050842285, 0.980258047580719, 0.9801821112632751, 0.9801061153411865, 0.9800298810005188, 0.9799535870552063, 0.9798771142959595, 0.9798004627227783, 0.9797236919403076, 0.9796468019485474, 0.9795697331428528, 0.9794925451278687, 0.979415237903595, 0.979337751865387, 0.9792601466178894, 0.9791823625564575, 0.9791044592857361, 0.9790263772010803, 0.978948175907135, 0.9788697957992554, 0.978791356086731, 0.9787126779556274, 0.9786339402198792, 0.9785550236701965, 0.9784759283065796, 0.9783967137336731, 0.978317379951477, 0.9782378673553467, 0.9781582355499268, 0.9780784249305725, 0.9779984951019287, 0.9779184460639954, 0.9778382182121277, 0.9777578711509705, 0.9776773452758789, 0.9775967001914978, 0.9775158762931824, 0.9774349927902222, 0.9773538708686829, 0.9772726893424988, 0.9771912693977356, 0.9771097898483276, 0.9770281314849854, 0.9769463539123535, 0.9768643975257874, 0.9767823219299316, 0.9767000675201416, 0.976617693901062, 0.9765352010726929, 0.9764525294303894, 0.9763697385787964, 0.976286768913269, 0.9762036800384521, 0.9761204719543457, 0.9760370850563049, 0.9759535193443298, 0.97586989402771, 0.9757860898971558, 0.9757021069526672, 0.9756180047988892, 0.9755337834358215, 0.9754493832588196, 0.9753648638725281, 0.975280225276947, 0.9751954078674316, 0.9751104116439819, 0.9750253558158875, 0.9749400615692139, 0.9748547077178955, 0.9747691750526428, 0.9746834635734558, 0.974597692489624, 0.9745117425918579, 0.9744256138801575, 0.9743393659591675, 0.9742529988288879, 0.9741664528846741, 0.9740797877311707, 0.9739929437637329, 0.9739059805870056, 0.9738188982009888, 0.9737316370010376, 0.9736442565917969, 0.9735566973686218, 0.9734690189361572, 0.9733811616897583, 0.9732932448387146, 0.9732050895690918, 0.9731168746948242, 0.9730284810066223, 0.9729399085044861, 0.9728512763977051, 0.9727624654769897, 0.9726734757423401, 0.9725843667984009, 0.9724951386451721, 0.972405731678009, 0.9723162055015564, 0.9722265005111694, 0.9721366763114929, 0.9720466732978821, 0.9719566106796265, 0.9718663096427917, 0.9717759490013123, 0.9716854095458984, 0.9715946912765503, 0.9715039134025574, 0.9714128971099854, 0.9713218212127686, 0.9712305665016174, 0.971139132976532, 0.9710476398468018, 0.9709559082984924, 0.9708641171455383, 0.9707721471786499, 0.9706799983978271, 0.9705877900123596, 0.9704954028129578, 0.9704028367996216, 0.9703101515769958, 0.9702173471450806, 0.970124363899231, 0.9700312614440918, 0.9699379801750183, 0.9698445796966553, 0.9697510600090027, 0.9696573615074158, 0.9695635437965393, 0.9694696068763733, 0.969375491142273, 0.9692812561988831, 0.9691868424415588, 0.9690923094749451, 0.968997597694397, 0.9689027667045593, 0.9688078165054321, 0.9687127470970154, 0.9686174988746643, 0.9685220718383789, 0.968426525592804, 0.9683308601379395, 0.9682350754737854, 0.968139111995697, 0.9680429697036743, 0.9679467678070068, 0.9678503274917603, 0.9677538275718689, 0.9676571488380432, 0.967560350894928, 0.9674633741378784, 0.9673662781715393, 0.9672690629959106, 0.9671716690063477, 0.9670740962028503, 0.9669764637947083, 0.9668786525726318, 0.9667806625366211, 0.9666826128959656, 0.9665843844413757, 0.9664859771728516, 0.9663874506950378, 0.9662888050079346, 0.966189980506897, 0.9660910367965698, 0.9659919738769531, 0.9658927321434021, 0.9657933115959167, 0.9656938314437866, 0.9655941724777222, 0.9654943346977234, 0.9653944373130798, 0.965294361114502, 0.9651941061019897, 0.965093731880188, 0.9649932384490967, 0.964892566204071, 0.9647917747497559, 0.9646908640861511, 0.9645897746086121, 0.9644885659217834, 0.9643871784210205, 0.964285671710968, 0.964184045791626, 0.9640822410583496, 0.9639803171157837, 0.9638782739639282, 0.9637760519981384, 0.9636737108230591, 0.9635711908340454, 0.9634685516357422, 0.9633657932281494, 0.9632628560066223, 0.9631597995758057, 0.9630565643310547, 0.9629532098770142, 0.9628497362136841, 0.9627461433410645, 0.9626423716545105, 0.9625384211540222, 0.9624344110488892, 0.962330162525177, 0.9622258543968201, 0.9621214270591736, 0.962016761302948, 0.9619120359420776, 0.961807131767273, 0.9617020487785339, 0.9615969061851501, 0.961491584777832, 0.9613860845565796, 0.9612804651260376, 0.961174726486206, 0.961068868637085, 0.9609628319740295, 0.9608566164970398, 0.9607503414154053, 0.9606438279151917, 0.9605372548103333, 0.9604305028915405, 0.9603236317634583, 0.9602166414260864, 0.9601094722747803, 0.9600021243095398, 0.9598947167396545, 0.959787130355835, 0.959679365158081, 0.9595714807510376, 0.9594634771347046, 0.959355354309082, 0.9592470526695251, 0.9591386318206787, 0.959030032157898, 0.9589213132858276, 0.9588124752044678, 0.9587034583091736, 0.9585943222045898, 0.9584850668907166, 0.9583756327629089, 0.9582660794258118, 0.9581563472747803, 0.9580464959144592, 0.9579365253448486, 0.9578263759613037, 0.9577161073684692, 0.9576057195663452, 0.9574951529502869, 0.957384467124939, 0.9572736620903015, 0.9571626782417297, 0.9570515751838684, 0.9569402933120728, 0.9568289518356323, 0.9567173719406128, 0.9566057324409485, 0.9564939141273499, 0.9563819766044617, 0.9562698602676392, 0.9561576247215271, 0.9560452103614807, 0.9559327363967896, 0.9558200836181641, 0.9557072520256042, 0.9555943012237549, 0.955481231212616, 0.9553680419921875, 0.9552546739578247, 0.9551411271095276, 0.9550275206565857, 0.9549137353897095, 0.9547997713088989, 0.9546857476234436, 0.954571545124054, 0.95445716381073, 0.9543427228927612, 0.9542281031608582, 0.9541133046150208, 0.9539983868598938, 0.9538833498954773, 0.9537681937217712, 0.9536528587341309, 0.9535373449325562, 0.9534217715263367, 0.9533060193061829, 0.9531901478767395, 0.9530740976333618, 0.9529579281806946, 0.9528416395187378, 0.9527251720428467, 0.952608585357666, 0.9524918794631958, 0.9523749947547913, 0.9522579908370972, 0.9521408081054688, 0.9520235657691956, 0.9519060850143433, 0.9517885446548462, 0.9516708254814148, 0.9515529870986938, 0.9514349699020386, 0.9513168334960938, 0.9511985778808594, 0.9510802030563354, 0.9509616494178772, 0.9508429169654846, 0.9507241249084473, 0.9506051540374756, 0.9504860639572144, 0.9503667950630188, 0.9502474069595337, 0.950127899646759, 0.95000821352005, 0.9498884081840515, 0.9497684836387634, 0.949648380279541, 0.949528157711029, 0.9494078159332275, 0.9492872953414917, 0.9491666555404663, 0.9490458965301514, 0.9489249587059021, 0.9488039016723633, 0.9486826658248901, 0.9485613703727722, 0.94843989610672, 0.9483182430267334, 0.9481964707374573, 0.9480745792388916, 0.9479525685310364, 0.9478303790092468, 0.9477080702781677, 0.9475855827331543, 0.9474629759788513, 0.9473402500152588, 0.9472174048423767, 0.9470943808555603, 0.9469711780548096, 0.9468479156494141, 0.9467244744300842, 0.9466009140014648, 0.9464771747589111, 0.9463533163070679, 0.9462293386459351, 0.9461052417755127, 0.945980966091156, 0.9458565711975098, 0.9457319974899292, 0.9456073045730591, 0.9454824924468994, 0.9453575015068054, 0.9452324509620667, 0.9451071619987488, 0.9449818134307861, 0.9448562860488892, 0.9447306394577026, 0.9446048140525818, 0.9444788694381714, 0.9443528056144714, 0.9442266225814819, 0.9441002607345581, 0.9439737796783447, 0.943847119808197, 0.9437203407287598, 0.943593442440033, 0.9434664249420166, 0.9433392286300659, 0.9432119131088257, 0.9430844187736511, 0.942956805229187, 0.9428290724754333, 0.9427012205123901, 0.9425731897354126, 0.9424450397491455, 0.9423167109489441, 0.9421882629394531, 0.9420596957206726, 0.9419310092926025, 0.9418021440505981, 0.9416731595993042, 0.9415440559387207, 0.9414147734642029, 0.9412853717803955, 0.9411558508872986, 0.9410261511802673, 0.9408963322639465, 0.9407663941383362, 0.9406362771987915, 0.9405060410499573, 0.9403756856918335, 0.9402451515197754, 0.9401144981384277, 0.9399837255477905, 0.939852774143219, 0.9397217631340027, 0.9395905137062073, 0.9394592046737671, 0.9393277168273926, 0.9391961097717285, 0.9390643239021301, 0.938932478427887, 0.9388003945350647, 0.9386682510375977, 0.9385359287261963, 0.9384034872055054, 0.9382709264755249, 0.9381381869316101, 0.9380053281784058, 0.9378723502159119, 0.9377391934394836, 0.9376059174537659, 0.9374725222587585, 0.9373389482498169, 0.9372053146362305, 0.9370714426040649, 0.9369375109672546, 0.93680340051651, 0.9366691708564758, 0.9365348219871521, 0.936400294303894, 0.9362656474113464, 0.9361308217048645, 0.9359959363937378, 0.9358608722686768, 0.9357256293296814, 0.9355903267860413, 0.9354549050331116, 0.9353192448616028, 0.9351835250854492, 0.9350476264953613, 0.9349116086959839, 0.9347754120826721, 0.9346391558647156, 0.9345026612281799, 0.9343661069869995, 0.9342293739318848, 0.9340925216674805, 0.9339555501937866, 0.9338184595108032, 0.9336811900138855, 0.9335437417030334, 0.9334062337875366, 0.9332685470581055, 0.9331307411193848, 0.9329928159713745, 0.9328547120094299, 0.9327164888381958, 0.9325781464576721, 0.9324396252632141, 0.9323009848594666, 0.9321622252464294, 0.932023286819458, 0.931884229183197, 0.9317450523376465, 0.9316057562828064, 0.931466281414032, 0.931326687335968, 0.9311869740486145, 0.9310470819473267, 0.9309070706367493, 0.9307669401168823, 0.9306266903877258, 0.930486261844635, 0.9303457140922546, 0.9302049875259399, 0.9300642013549805, 0.9299232363700867, 0.9297820925712585, 0.9296408891677856, 0.9294995069503784, 0.9293580055236816, 0.9292163252830505, 0.9290745854377747, 0.9289326667785645, 0.9287905693054199, 0.9286484122276306, 0.928506076335907, 0.9283636212348938, 0.9282209873199463, 0.9280782341957092, 0.9279353618621826, 0.9277923703193665, 0.927649199962616, 0.9275059103965759, 0.9273625016212463, 0.9272189736366272, 0.9270752668380737, 0.9269314408302307, 0.9267874360084534, 0.9266433715820312, 0.9264991283416748, 0.926354706287384, 0.9262102246284485, 0.9260655641555786, 0.9259207844734192, 0.9257758855819702, 0.9256308078765869, 0.9254856109619141, 0.9253402948379517, 0.9251947999000549, 0.9250491857528687, 0.9249034523963928, 0.9247575998306274, 0.9246115684509277, 0.9244654178619385, 0.9243191480636597, 0.9241727590560913, 0.9240261912345886, 0.9238795042037964, 0.9237326979637146, 0.9235857129096985, 0.9234386086463928, 0.9232913851737976, 0.9231440424919128, 0.9229965209960938, 0.9228488802909851, 0.9227011203765869, 0.9225531816482544, 0.9224051237106323, 0.9222569465637207, 0.9221086502075195, 0.921960175037384, 0.921811580657959, 0.9216628670692444, 0.9215139746665955, 0.9213650226593018, 0.9212158918380737, 0.9210665822029114, 0.9209172129631042, 0.9207676649093628, 0.9206179976463318, 0.9204681515693665, 0.9203182458877563, 0.9201681613922119, 0.9200179576873779, 0.9198675751686096, 0.9197171330451965, 0.9195665121078491, 0.9194157719612122, 0.9192648530006409, 0.9191138744354248, 0.9189627170562744, 0.9188113808631897, 0.9186599850654602, 0.9185084104537964, 0.918356716632843, 0.9182048439979553, 0.9180528521537781, 0.917900800704956, 0.9177485108375549, 0.917596161365509, 0.9174436330795288, 0.917290985584259, 0.9171382188796997, 0.916985273361206, 0.9168322682380676, 0.9166790246963501, 0.9165257215499878, 0.9163722991943359, 0.9162186980247498, 0.916064977645874, 0.915911078453064, 0.9157571196556091, 0.91560298204422, 0.9154487252235413, 0.9152942895889282, 0.9151397943496704, 0.9149851202964783, 0.9148303270339966, 0.9146753549575806, 0.914520263671875, 0.9143650531768799, 0.9142097234725952, 0.914054274559021, 0.9138986468315125, 0.9137428998947144, 0.9135870337486267, 0.9134310483932495, 0.913274884223938, 0.9131186008453369, 0.9129621982574463, 0.9128056168556213, 0.9126489162445068, 0.9124920964241028, 0.9123351573944092, 0.912178099155426, 0.9120208621025085, 0.9118635058403015, 0.9117060303688049, 0.911548376083374, 0.9113906025886536, 0.9112327098846436, 0.911074697971344, 0.9109165668487549, 0.9107582569122314, 0.9105998277664185, 0.9104412794113159, 0.910282552242279, 0.9101237654685974, 0.9099647998809814, 0.9098056554794312, 0.9096464514732361, 0.9094870686531067, 0.9093275666236877, 0.909168004989624, 0.9090082049369812, 0.9088483452796936, 0.9086882472038269, 0.9085281491279602, 0.9083678126335144, 0.9082074165344238, 0.9080467820167542, 0.9078861474990845, 0.9077252745628357, 0.9075643420219421, 0.9074031710624695, 0.9072420001029968, 0.9070805907249451, 0.9069191217422485, 0.9067574143409729, 0.9065957069396973, 0.9064337611198425, 0.906271755695343, 0.9061095714569092, 0.9059473276138306, 0.9057848453521729, 0.9056223034858704, 0.9054595828056335, 0.9052967429161072, 0.9051337242126465, 0.9049707055091858, 0.9048073887825012, 0.9046440720558167, 0.9044805765151978, 0.9043169617652893, 0.9041531682014465, 0.903989315032959, 0.9038252234458923, 0.9036610722541809, 0.9034967422485352, 0.9033323526382446, 0.9031677842140198, 0.9030030965805054, 0.9028382301330566, 0.9026733040809631, 0.9025081992149353, 0.9023429751396179, 0.9021775722503662, 0.9020121693611145, 0.9018464684486389, 0.9016807675361633, 0.9015148282051086, 0.9013488292694092, 0.9011826515197754, 0.9010164141654968, 0.9008499383926392, 0.9006834030151367, 0.9005166888237, 0.9003499150276184, 0.9001829028129578, 0.9000158905982971, 0.8998486399650574, 0.8996813297271729, 0.8995137810707092, 0.8993462324142456, 0.8991784453392029, 0.8990105986595154, 0.8988425731658936, 0.8986744284629822, 0.8985061049461365, 0.8983377814292908, 0.8981691598892212, 0.8980005979537964, 0.8978317379951477, 0.8976628184318542, 0.8974937200546265, 0.8973245620727539, 0.8971551656723022, 0.8969857692718506, 0.8968161344528198, 0.8966464400291443, 0.8964765667915344, 0.8963066339492798, 0.896136462688446, 0.8959662318229675, 0.8957958221435547, 0.8956253528594971, 0.8954546451568604, 0.8952838778495789, 0.895112931728363, 0.8949419260025024, 0.8947707414627075, 0.894599437713623, 0.8944279551506042, 0.8942564725875854, 0.8940846920013428, 0.8939129114151001, 0.8937408924102783, 0.8935688734054565, 0.8933965563774109, 0.89322429895401, 0.8930517435073853, 0.8928791880607605, 0.8927064538002014, 0.892533540725708, 0.8923605680465698, 0.8921873569488525, 0.8920141458511353, 0.8918406963348389, 0.8916671872138977, 0.8914934992790222, 0.8913196921348572, 0.8911457061767578, 0.8909717202186584, 0.89079749584198, 0.8906232118606567, 0.8904486894607544, 0.890274167060852, 0.8900994062423706, 0.8899245858192444, 0.8897495269775391, 0.8895744681358337, 0.8893991708755493, 0.8892238736152649, 0.8890483379364014, 0.8888727426528931, 0.8886969089508057, 0.8885210752487183, 0.8883450031280518, 0.8881688714027405, 0.8879925608634949, 0.8878161907196045, 0.887639582157135, 0.8874629735946655, 0.8872860670089722, 0.8871092200279236, 0.8869320750236511, 0.8867549300193787, 0.8865775465965271, 0.8864001035690308, 0.8862224817276001, 0.8860448002815247, 0.8858668804168701, 0.8856889605522156, 0.8855108022689819, 0.8853326439857483, 0.8851541876792908, 0.8849757313728333, 0.8847970366477966, 0.88461834192276, 0.8844394087791443, 0.8842604160308838, 0.8840811848640442, 0.8839019536972046, 0.8837224841117859, 0.8835430145263672, 0.8833633065223694, 0.8831835389137268, 0.8830035328865051, 0.8828235268592834, 0.8826432824134827, 0.8824630379676819, 0.8822824954986572, 0.8821019530296326, 0.8819212317466736, 0.881740391254425, 0.8815593719482422, 0.8813783526420593, 0.8811970353126526, 0.8810157179832458, 0.8808342218399048, 0.8806526064872742, 0.8804708123207092, 0.8802890181541443, 0.8801069259643555, 0.8799248337745667, 0.8797425031661987, 0.8795601725578308, 0.8793776035308838, 0.879194974899292, 0.8790121674537659, 0.878829300403595, 0.878646194934845, 0.878463089466095, 0.8782797455787659, 0.878096342086792, 0.877912700176239, 0.8777291178703308, 0.8775452375411987, 0.8773612976074219, 0.8771771788597107, 0.8769930601119995, 0.8768086433410645, 0.8766242265701294, 0.8764395713806152, 0.8762549161911011, 0.8760700225830078, 0.8758850693702698, 0.8756999373435974, 0.8755147457122803, 0.875329315662384, 0.8751438856124878, 0.8749582171440125, 0.8747724890708923, 0.8745865821838379, 0.8744006156921387, 0.8742144107818604, 0.874028205871582, 0.8738417625427246, 0.8736553192138672, 0.8734685778617859, 0.8732818365097046, 0.873094916343689, 0.8729079365730286, 0.8727207779884338, 0.8725334405899048, 0.8723461031913757, 0.8721584677696228, 0.8719708323478699, 0.8717830181121826, 0.8715950846672058, 0.8714069724082947, 0.8712188601493835, 0.8710304498672485, 0.8708420991897583, 0.8706534504890442, 0.8704648017883301, 0.8702759146690369, 0.8700870275497437, 0.8698978424072266, 0.8697087168693542, 0.8695192933082581, 0.8693298697471619, 0.8691402077674866, 0.8689505457878113, 0.8687606453895569, 0.8685707449913025, 0.8683805465698242, 0.868190348148346, 0.8679999709129333, 0.867809534072876, 0.8676188588142395, 0.8674281239509583, 0.8672372102737427, 0.8670462369918823, 0.8668550848960876, 0.8666638731956482, 0.8664724230766296, 0.8662809729576111, 0.8660892844200134, 0.865897536277771, 0.8657056093215942, 0.8655136227607727, 0.8653213977813721, 0.8651292324066162, 0.8649367094039917, 0.864744246006012, 0.8645515441894531, 0.8643588423728943, 0.8641658425331116, 0.8639728426933289, 0.863779604434967, 0.86358642578125, 0.8633928894996643, 0.8631994128227234, 0.8630056977272034, 0.8628119230270386, 0.8626179695129395, 0.8624239563941956, 0.8622297048568726, 0.8620354533195496, 0.8618409633636475, 0.8616464734077454, 0.8614516854286194, 0.8612569570541382, 0.8610619306564331, 0.8608669638633728, 0.8606716990470886, 0.8604764342308044, 0.8602808713912964, 0.8600853681564331, 0.8598896265029907, 0.8596938252449036, 0.8594978451728821, 0.8593018054962158, 0.8591055274009705, 0.8589092493057251, 0.8587127327919006, 0.8585162162780762, 0.8583194613456726, 0.8581226468086243, 0.8579256534576416, 0.8577286005020142, 0.8575313091278076, 0.8573340177536011, 0.8571364879608154, 0.8569389581680298, 0.856741189956665, 0.8565433621406555, 0.8563453555107117, 0.856147289276123, 0.8559490442276001, 0.8557507395744324, 0.8555521965026855, 0.8553536534309387, 0.8551548719406128, 0.8549560308456421, 0.8547570109367371, 0.854557991027832, 0.8543586730957031, 0.8541593551635742, 0.8539597988128662, 0.853760302066803, 0.8535605072975159, 0.853360652923584, 0.8531606197357178, 0.8529605865478516, 0.8527602553367615, 0.8525599837303162, 0.852359414100647, 0.8521588444709778, 0.8519580960273743, 0.851757287979126, 0.8515562415122986, 0.8513551354408264, 0.8511539697647095, 0.8509525656700134, 0.8507511019706726, 0.8505494594573975, 0.8503477573394775, 0.8501458168029785, 0.8499439358711243, 0.8497417569160461, 0.849539577960968, 0.849337100982666, 0.8491346836090088, 0.8489320278167725, 0.8487293124198914, 0.8485264182090759, 0.8483234643936157, 0.8481203317642212, 0.8479171395301819, 0.8477137088775635, 0.8475102782249451, 0.8473066091537476, 0.84710294008255, 0.8468989729881287, 0.846695065498352, 0.8464909195899963, 0.8462867140769958, 0.8460822701454163, 0.8458778858184814, 0.8456732034683228, 0.8454685211181641, 0.8452636003494263, 0.8450586795806885, 0.8448535203933716, 0.8446483612060547, 0.8444429039955139, 0.8442375063896179, 0.8440318703651428, 0.843826174736023, 0.843620240688324, 0.8434143662452698, 0.8432081937789917, 0.8430020213127136, 0.8427956104278564, 0.8425891995429993, 0.842382550239563, 0.8421759009361267, 0.8419689536094666, 0.8417620658874512, 0.8415549397468567, 0.8413477540016174, 0.8411403894424438, 0.8409329652786255, 0.840725302696228, 0.8405176401138306, 0.840309739112854, 0.8401018977165222, 0.8398937582969666, 0.8396855592727661, 0.8394771814346313, 0.8392688035964966, 0.8390601873397827, 0.8388515114784241, 0.8386426568031311, 0.8384337425231934, 0.8382246494293213, 0.8380154967308044, 0.8378061056137085, 0.8375967741012573, 0.8373871445655823, 0.8371775150299072, 0.8369676470756531, 0.8367577791213989, 0.8365476727485657, 0.8363375663757324, 0.8361271619796753, 0.8359168171882629, 0.8357062339782715, 0.8354955911636353, 0.8352847695350647, 0.8350738883018494, 0.8348627686500549, 0.8346517086029053, 0.8344403505325317, 0.8342289924621582, 0.8340173959732056, 0.8338058590888977, 0.8335939645767212, 0.8333821892738342, 0.8331700563430786, 0.8329579830169678, 0.8327456712722778, 0.8325333595275879, 0.8323207497596741, 0.832108199596405, 0.8318954110145569, 0.831682562828064, 0.8314695358276367, 0.8312564492225647, 0.8310431838035583, 0.8308298587799072, 0.830616295337677, 0.8304027915000916, 0.8301889896392822, 0.8299751877784729, 0.8297611474990845, 0.829547107219696, 0.8293328285217285, 0.829118549823761, 0.8289040327072144, 0.8286895155906677, 0.8284748792648315, 0.8282599449157715, 0.8280450701713562, 0.8278299570083618, 0.8276147842407227, 0.8273994326591492, 0.8271840810775757, 0.8269684314727783, 0.8267528414726257, 0.8265369534492493, 0.8263210654258728, 0.826104998588562, 0.8258888721466064, 0.8256725072860718, 0.8254562020301819, 0.8252395987510681, 0.8250229954719543, 0.8248061537742615, 0.8245893120765686, 0.8243722319602966, 0.8241551518440247, 0.8239378333091736, 0.8237205147743225, 0.8235029578208923, 0.8232854008674622, 0.8230676054954529, 0.8228498101234436, 0.8226317167282104, 0.8224136829376221, 0.8221954107284546, 0.8219771385192871, 0.8217585682868958, 0.8215400576591492, 0.8213213086128235, 0.821102499961853, 0.8208835124969482, 0.8206645250320435, 0.8204452395439148, 0.8202260136604309, 0.8200064897537231, 0.8197870254516602, 0.8195672631263733, 0.8193475008010864, 0.8191275596618652, 0.8189075589179993, 0.8186873197555542, 0.8184671401977539, 0.8182466626167297, 0.8180262446403503, 0.8178055286407471, 0.8175848126411438, 0.8173638582229614, 0.8171429634094238, 0.8169217705726624, 0.8167005777359009, 0.8164791464805603, 0.8162577152252197, 0.8160360455513, 0.8158144354820251, 0.8155925273895264, 0.8153706192970276, 0.8151484727859497, 0.8149263262748718, 0.8147039413452148, 0.8144815564155579, 0.8142589330673218, 0.8140363097190857, 0.8138134479522705, 0.8135905861854553, 0.813367486000061, 0.8131443858146667, 0.8129210472106934, 0.81269770860672, 0.8124741315841675, 0.812250554561615, 0.8120267391204834, 0.8118029236793518, 0.8115788698196411, 0.8113548159599304, 0.8111305236816406, 0.8109062314033508, 0.8106817007064819, 0.810457170009613, 0.810232400894165, 0.810007631778717, 0.8097826242446899, 0.8095576167106628, 0.8093323707580566, 0.8091071248054504, 0.8088816404342651, 0.8086561560630798, 0.8084304332733154, 0.808204710483551, 0.8079787492752075, 0.807752788066864, 0.8075265884399414, 0.8073003888130188, 0.8070739507675171, 0.8068475127220154, 0.8066208362579346, 0.8063941597938538, 0.8061672449111938, 0.8059403300285339, 0.8057131767272949, 0.8054860830307007, 0.8052586913108826, 0.8050312995910645, 0.8048036694526672, 0.80457603931427, 0.8043481707572937, 0.8041203618049622, 0.8038923740386963, 0.8036641478538513, 0.8034359812736511, 0.803207516670227, 0.802979052066803, 0.8027503490447998, 0.8025217056274414, 0.8022927641868591, 0.8020638227462769, 0.8018347024917603, 0.8016055226325989, 0.8013761043548584, 0.8011467456817627, 0.8009170889854431, 0.8006874918937683, 0.8004575967788696, 0.8002277612686157, 0.7999976277351379, 0.7997675538063049, 0.7995372414588928, 0.7993068695068359, 0.7990763187408447, 0.7988457679748535, 0.7986149191856384, 0.7983841300010681, 0.7981531023979187, 0.7979220747947693, 0.7976908087730408, 0.7974595427513123, 0.7972279787063599, 0.796996533870697, 0.7967647314071655, 0.7965330481529236, 0.796301007270813, 0.7960690855979919, 0.795836865901947, 0.7956046462059021, 0.7953721880912781, 0.795139729976654, 0.7949070334434509, 0.7946743965148926, 0.7944414615631104, 0.7942085862159729, 0.7939754128456116, 0.793742299079895, 0.7935088872909546, 0.7932755351066589, 0.7930418848991394, 0.7928082942962646, 0.792574405670166, 0.7923405766487122, 0.7921065092086792, 0.7918724417686462, 0.7916381359100342, 0.7914038300514221, 0.7911692261695862, 0.7909347414970398, 0.7906999588012695, 0.7904651761054993, 0.7902301549911499, 0.7899951338768005, 0.7897598743438721, 0.7895246744155884, 0.7892891764640808, 0.789053738117218, 0.7888180017471313, 0.7885823249816895, 0.7883463501930237, 0.7881104350090027, 0.7878742218017578, 0.7876380681991577, 0.7874016761779785, 0.7871652841567993, 0.786928653717041, 0.7866920232772827, 0.7864551544189453, 0.7862182855606079, 0.7859811782836914, 0.7857440710067749, 0.7855067253112793, 0.7852694392204285, 0.7850318551063538, 0.7847943305969238, 0.78455650806427, 0.784318745136261, 0.7840806841850281, 0.7838426828384399, 0.7836044430732727, 0.7833662033081055, 0.7831276655197144, 0.7828892469406128, 0.7826504707336426, 0.7824118137359619, 0.7821728587150574, 0.7819339036941528, 0.7816947102546692, 0.7814555764198303, 0.7812161445617676, 0.7809767723083496, 0.7807371020317078, 0.7804974913597107, 0.7802576422691345, 0.7800177931785583, 0.7797777056694031, 0.7795376181602478, 0.7792972922325134, 0.779056966304779, 0.7788164019584656, 0.7785758972167969, 0.7783350944519043, 0.7780942916870117, 0.7778534293174744, 0.7776123285293579, 0.7773711681365967, 0.7771298289299011, 0.7768884897232056, 0.7766469120979309, 0.7764053344726562, 0.7761635184288025, 0.7759217023849487, 0.7756796479225159, 0.7754376530647278, 0.7751953601837158, 0.7749531269073486, 0.7747105956077576, 0.7744681239128113, 0.7742254137992859, 0.7739827036857605, 0.773739755153656, 0.7734968066215515, 0.7732536196708679, 0.7730104923248291, 0.7727670669555664, 0.7725237011909485, 0.7722800374031067, 0.7720364332199097, 0.7717925310134888, 0.7715486884117126, 0.7713046073913574, 0.7710605263710022, 0.7708162069320679, 0.7705719470977783, 0.7703273892402649, 0.7700828313827515, 0.7698380947113037, 0.7695932984352112, 0.7693483233451843, 0.7691033482551575, 0.7688581347465515, 0.7686129212379456, 0.7683674693107605, 0.7681220173835754, 0.7678763270378113, 0.7676306962966919, 0.7673847675323486, 0.7671388983726501, 0.7668927907943726, 0.766646683216095, 0.7664003372192383, 0.7661539912223816, 0.7659074068069458, 0.7656608819961548, 0.7654140591621399, 0.765167236328125, 0.7649202346801758, 0.7646732330322266, 0.7644259333610535, 0.7641787528991699, 0.7639312744140625, 0.7636837959289551, 0.7634360790252686, 0.7631884217262268, 0.7629404664039612, 0.7626925706863403, 0.7624444365501404, 0.7621963024139404, 0.7619479298591614, 0.7616995573043823, 0.7614509463310242, 0.7612023949623108, 0.7609535455703735, 0.760704755783081, 0.7604556679725647, 0.7602066397666931, 0.7599573731422424, 0.7597081661224365, 0.7594586610794067, 0.759209156036377, 0.7589594125747681, 0.758709728717804, 0.7584598064422607, 0.7582098841667175, 0.7579597234725952, 0.7577095627784729, 0.7574591636657715, 0.7572088241577148, 0.7569581866264343, 0.7567076086997986, 0.7564567923545837, 0.7562059760093689, 0.755954921245575, 0.755703866481781, 0.755452573299408, 0.7552013397216797, 0.7549498081207275, 0.7546983957290649, 0.7544466257095337, 0.7541949152946472, 0.7539429664611816, 0.7536910772323608, 0.7534388899803162, 0.7531867623329163, 0.7529343366622925, 0.7526820302009583, 0.7524293661117554, 0.752176821231842, 0.7519239783287048, 0.7516711950302124, 0.7514181137084961, 0.7511650919914246, 0.7509118318557739, 0.7506585717201233, 0.7504051923751831, 0.7501515746116638, 0.7498980164527893, 0.7496442198753357, 0.7493904232978821, 0.7491363286972046, 0.7488823533058167, 0.7486280798912048, 0.748373806476593, 0.7481193542480469, 0.7478649020195007, 0.7476101517677307, 0.7473555207252502, 0.7471005320549011, 0.7468456625938416, 0.7465904951095581, 0.7463353872299194, 0.7460800409317017, 0.7458246946334839, 0.745569109916687, 0.7453135251998901, 0.7450577020645142, 0.744801938533783, 0.7445459365844727, 0.7442899346351624, 0.744033694267273, 0.7437774538993835, 0.743520975112915, 0.7432645559310913, 0.7430078983306885, 0.7427512407302856, 0.7424943447113037, 0.7422374486923218, 0.7419803738594055, 0.7417232394218445, 0.7414659261703491, 0.7412086129188538, 0.7409510612487793, 0.7406935691833496, 0.740435779094696, 0.7401780486106873, 0.7399200201034546, 0.7396620512008667, 0.7394038438796997, 0.7391456961631775, 0.7388872504234314, 0.7386288642883301, 0.7383701801300049, 0.7381116151809692, 0.7378527522087097, 0.7375938892364502, 0.7373348474502563, 0.7370758056640625, 0.7368164658546448, 0.7365572452545166, 0.7362977266311646, 0.7360382676124573, 0.7357785105705261, 0.7355188131332397, 0.7352588772773743, 0.7349989414215088, 0.7347387671470642, 0.7344786524772644, 0.7342182993888855, 0.7339579463005066, 0.7336973547935486, 0.7334368228912354, 0.7331759929656982, 0.7329152226448059, 0.7326541543006897, 0.732393205165863, 0.7321319580078125, 0.7318707704544067, 0.7316092848777771, 0.7313478589057922, 0.7310861945152283, 0.7308245897293091, 0.730562686920166, 0.7303008437156677, 0.7300387024879456, 0.7297766804695129, 0.7295143604278564, 0.7292520403862, 0.7289895415306091, 0.7287270426750183, 0.7284643054008484, 0.7282015681266785, 0.7279385924339294, 0.7276756763458252, 0.7274125218391418, 0.7271493673324585, 0.726885974407196, 0.7266226410865784, 0.7263590693473816, 0.7260954976081848, 0.7258316874504089, 0.7255678772926331, 0.7253038287162781, 0.7250398993492126, 0.7247756123542786, 0.724511444568634, 0.7242469787597656, 0.723982572555542, 0.7237178683280945, 0.7234532833099365, 0.7231883406639099, 0.7229235172271729, 0.7226584553718567, 0.7223933935165405, 0.7221280932426453, 0.72186279296875, 0.72159743309021, 0.7213318347930908, 0.7210662364959717, 0.7208003997802734, 0.72053462266922, 0.7202685475349426, 0.7200025320053101, 0.7197362780570984, 0.7194700837135315, 0.7192035913467407, 0.7189371585845947, 0.7186704277992249, 0.7184038162231445, 0.7181369066238403, 0.7178700566291809, 0.7176029682159424, 0.7173358798027039, 0.7170685529708862, 0.7168012857437134, 0.7165337800979614, 0.7162662744522095, 0.7159985303878784, 0.7157308459281921, 0.715462863445282, 0.7151950001716614, 0.7149268388748169, 0.7146586775779724, 0.7143903374671936, 0.7141219973564148, 0.7138534188270569, 0.7135848999023438, 0.7133160829544067, 0.7130473256111145, 0.7127783298492432, 0.7125093936920166, 0.7122401595115662, 0.7119709849357605, 0.7117015719413757, 0.7114322185516357, 0.7111625671386719, 0.7108929753303528, 0.7106231451034546, 0.7103533744812012, 0.7100833058357239, 0.7098132967948914, 0.7095430493354797, 0.7092728018760681, 0.7090023756027222, 0.7087319493293762, 0.7084612846374512, 0.7081906199455261, 0.707919716835022, 0.7076489329338074, 0.7073777914047241, 0.7071067690849304, 0.7068354487419128, 0.7065642476081848, 0.7062926888465881, 0.706021249294281, 0.70574951171875, 0.7054778933525085, 0.7052059173583984, 0.7049340605735779, 0.7046619057655334, 0.7043898701667786, 0.7041175365447998, 0.703845202922821, 0.703572690486908, 0.7033001780509949, 0.7030274271965027, 0.7027547359466553, 0.702481746673584, 0.7022088766098022, 0.7019357085227966, 0.7016626000404358, 0.7013891935348511, 0.7011159062385559, 0.7008423209190369, 0.7005687952041626, 0.7002949714660645, 0.7000212669372559, 0.6997472643852234, 0.6994733214378357, 0.6991991400718689, 0.6989249587059021, 0.6986505389213562, 0.6983762383460999, 0.6981015801429749, 0.6978270411491394, 0.6975522041320801, 0.6972774863243103, 0.6970024704933167, 0.6967275142669678, 0.696452260017395, 0.6961771249771118, 0.69590163230896, 0.6956263184547424, 0.6953506469726562, 0.6950750946998596, 0.6947992444038391, 0.6945234537124634, 0.6942474246025085, 0.6939713954925537, 0.6936951875686646, 0.6934189796447754, 0.6931425333023071, 0.6928661465644836, 0.6925894618034363, 0.6923128962516785, 0.6920360326766968, 0.6917592287063599, 0.6914823055267334, 0.6912051439285278, 0.690928041934967, 0.6906506419181824, 0.6903733611106873, 0.6900957822799683, 0.689818263053894, 0.6895405054092407, 0.6892628073692322, 0.6889848113059998, 0.6887068748474121, 0.6884286999702454, 0.6881505846977234, 0.6878721714019775, 0.6875938773155212, 0.6873152852058411, 0.6870367527008057, 0.6867579817771912, 0.6864792704582214, 0.6862002611160278, 0.685921311378479, 0.6856421232223511, 0.6853629946708679, 0.6850836277008057, 0.6848042607307434, 0.684524655342102, 0.6842451691627502, 0.6839653253555298, 0.6836856007575989, 0.6834055781364441, 0.6831256747245789, 0.6828454732894897, 0.6825653314590454, 0.682284951210022, 0.6820046305656433, 0.6817240118980408, 0.681443452835083, 0.6811626553535461, 0.680881917476654, 0.6806009411811829, 0.6803199648857117, 0.6800387501716614, 0.6797576546669006, 0.679476261138916, 0.6791949272155762, 0.6789132952690125, 0.6786317825317383, 0.6783499717712402, 0.678068220615387, 0.6777862310409546, 0.677504301071167, 0.6772220730781555, 0.6769399642944336, 0.6766575574874878, 0.6763752102851868, 0.6760926246643066, 0.6758100986480713, 0.6755272746086121, 0.6752445697784424, 0.6749615669250488, 0.6746786236763, 0.6743954420089722, 0.6741123199462891, 0.6738288998603821, 0.6735455989837646, 0.6732620000839233, 0.6729784607887268, 0.6726946830749512, 0.6724109649658203, 0.6721269488334656, 0.6718430519104004, 0.6715588569641113, 0.671274721622467, 0.6709903478622437, 0.670706033706665, 0.6704214215278625, 0.6701369285583496, 0.6698521375656128, 0.6695674657821655, 0.6692824959754944, 0.668997585773468, 0.6687123775482178, 0.6684272885322571, 0.6681419014930725, 0.6678566336631775, 0.6675710678100586, 0.6672855615615845, 0.6669998168945312, 0.6667141318321228, 0.6664281487464905, 0.6661422848701477, 0.665856122970581, 0.6655700206756592, 0.6652836799621582, 0.664997398853302, 0.6647108793258667, 0.6644243597984314, 0.6641376614570618, 0.6638509631156921, 0.6635640263557434, 0.6632771492004395, 0.6629900336265564, 0.6627029776573181, 0.662415623664856, 0.6621283888816833, 0.6618408560752869, 0.6615534424781799, 0.6612656712532043, 0.6609780788421631, 0.6606901288032532, 0.6604022979736328, 0.6601144075393677, 0.6598261594772339, 0.6595380306243896, 0.6592496633529663, 0.6589613556861877, 0.6586727499961853, 0.6583842039108276, 0.6580954194068909, 0.6578066945075989, 0.6575177311897278, 0.6572288274765015, 0.656939685344696, 0.6566506028175354, 0.6563612222671509, 0.6560719013214111, 0.6557823419570923, 0.655492901802063, 0.655203104019165, 0.6549134254455566, 0.6546235084533691, 0.6543336510658264, 0.6540434956550598, 0.6537534594535828, 0.6534631252288818, 0.6531728506088257, 0.6528823375701904, 0.6525918841362, 0.6523011922836304, 0.6520105600357056, 0.6517196297645569, 0.6514288187026978, 0.6511377096176147, 0.6508467197418213, 0.650555431842804, 0.6502642035484314, 0.6499727368354797, 0.6496813297271729, 0.6493896245956421, 0.6490980386734009, 0.6488062143325806, 0.6485143899917603, 0.6482223272323608, 0.647930383682251, 0.6476381421089172, 0.6473459601402283, 0.6470535397529602, 0.6467611789703369, 0.6464685797691345, 0.6461760401725769, 0.6458832025527954, 0.6455904841423035, 0.6452974677085876, 0.6450045108795166, 0.6447113156318665, 0.6444182395935059, 0.6441248059272766, 0.6438315510749817, 0.6435379385948181, 0.6432444453239441, 0.642950713634491, 0.6426570415496826, 0.6423630714416504, 0.6420692205429077, 0.6417750716209412, 0.6414809823036194, 0.6411866545677185, 0.6408924460411072, 0.6405978798866272, 0.6403034925460815, 0.6400087475776672, 0.6397141218185425, 0.6394192576408386, 0.6391243934631348, 0.6388293504714966, 0.6385343670845032, 0.6382390856742859, 0.6379438638687134, 0.6376484036445618, 0.6373530626296997, 0.637057363986969, 0.6367618441581726, 0.6364659667015076, 0.6361702680587769, 0.6358742117881775, 0.6355782747268677, 0.6352820992469788, 0.6349859833717346, 0.6346895694732666, 0.6343932747840881, 0.6340966820716858, 0.6338001489639282, 0.6335033774375916, 0.6332067251205444, 0.6329097747802734, 0.6326128840446472, 0.6323157548904419, 0.6320186853408813, 0.6317213773727417, 0.6314241290092468, 0.6311265826225281, 0.6308291554450989, 0.6305314898490906, 0.630233883857727, 0.6299359798431396, 0.6296381950378418, 0.6293401122093201, 0.6290421485900879, 0.6287438869476318, 0.6284456849098206, 0.6281474828720093, 0.6278489232063293, 0.627550482749939, 0.6272517442703247, 0.626953125, 0.6266542077064514, 0.6263554096221924, 0.6260563135147095, 0.6257573366165161, 0.6254580616950989, 0.6251589059829712, 0.6248594522476196, 0.6245600581169128, 0.624260425567627, 0.6239608526229858, 0.6236610412597656, 0.623361349105835, 0.6230612993240356, 0.6227614283561707, 0.622461199760437, 0.6221610903739929, 0.6218607425689697, 0.6215604543685913, 0.6212599277496338, 0.620959460735321, 0.6206586956977844, 0.6203580498695374, 0.6200571060180664, 0.619756281375885, 0.6194552183151245, 0.6191542148590088, 0.6188529133796692, 0.6185517311096191, 0.6182502508163452, 0.6179488897323608, 0.6176472306251526, 0.6173456907272339, 0.6170438528060913, 0.6167420744895935, 0.6164400577545166, 0.6161381602287292, 0.615835964679718, 0.6155338883399963, 0.6152315139770508, 0.61492919921875, 0.6146266460418701, 0.6143242120742798, 0.6140214800834656, 0.6137188076972961, 0.6134158968925476, 0.6131131052970886, 0.612809956073761, 0.6125069856643677, 0.6122037172317505, 0.6119005084037781, 0.6115970611572266, 0.6112936735153198, 0.610990047454834, 0.6106865406036377, 0.6103826761245728, 0.6100789904594421, 0.6097750067710876, 0.6094710826873779, 0.6091669201850891, 0.6088628172874451, 0.6085584759712219, 0.6082541942596436, 0.6079496741294861, 0.6076452136039734, 0.6073405146598816, 0.6070358753204346, 0.6067309975624084, 0.6064262390136719, 0.6061211228370667, 0.6058161854743958, 0.605510950088501, 0.605205774307251, 0.6049003601074219, 0.6045950055122375, 0.6042894124984741, 0.6039838790893555, 0.6036781072616577, 0.6033724546432495, 0.6030664443969727, 0.6027606129646301, 0.6024544835090637, 0.6021484136581421, 0.6018421053886414, 0.6015359163284302, 0.6012294292449951, 0.6009230017662048, 0.6006163358688354, 0.6003097891807556, 0.6000029444694519, 0.599696159362793, 0.5993891358375549, 0.5990822315216064, 0.5987750291824341, 0.5984679460525513, 0.5981605648994446, 0.5978533029556274, 0.5975457429885864, 0.597238302230835, 0.5969305634498596, 0.5966229438781738, 0.5963150262832642, 0.596007227897644, 0.5956991314888, 0.5953911542892456, 0.5950829386711121, 0.5947747826576233, 0.5944665670394897, 0.5941579937934875, 0.5938495993614197, 0.5935409069061279, 0.5932323336601257, 0.5929234623908997, 0.5926147103309631, 0.5923056602478027, 0.5919967293739319, 0.5916875004768372, 0.591378390789032, 0.5910690426826477, 0.5907597541809082, 0.5904501676559448, 0.590140700340271, 0.5898309946060181, 0.5895213484764099, 0.5892114639282227, 0.5889016389846802, 0.5885915756225586, 0.5882815718650818, 0.5879713296890259, 0.5876611471176147, 0.5873507261276245, 0.5870404243469238, 0.5867298245429993, 0.5864193439483643, 0.5861085653305054, 0.5857978463172913, 0.5854869484901428, 0.5851761102676392, 0.5848649740219116, 0.5845539569854736, 0.5842426419258118, 0.5839315056800842, 0.583620011806488, 0.5833086371421814, 0.5829970240592957, 0.5826854705810547, 0.5823736786842346, 0.5820620059967041, 0.5817500352859497, 0.5814381241798401, 0.5811259746551514, 0.5808139443397522, 0.5805016160011292, 0.5801894068717957, 0.5798769593238831, 0.5795645713806152, 0.5792518854141235, 0.5789393186569214, 0.5786265134811401, 0.5783137679100037, 0.5780007839202881, 0.5776879191398621, 0.5773746967315674, 0.577061653137207, 0.5767483115196228, 0.5764350891113281, 0.5761215686798096, 0.5758081674575806, 0.5754944682121277, 0.5751809477806091, 0.5748670697212219, 0.5745533108711243, 0.5742393136024475, 0.5739254355430603, 0.5736111998558044, 0.5732971429824829, 0.5729827880859375, 0.5726685523986816, 0.5723540186882019, 0.5720396041870117, 0.5717248916625977, 0.5714103579521179, 0.5710954666137695, 0.5707806944847107, 0.5704656839370728, 0.5701507925987244, 0.5698355436325073, 0.5695204734802246, 0.569205105304718, 0.568889856338501, 0.5685743093490601, 0.5682589411735535, 0.5679432153701782, 0.5676276087760925, 0.5673117637634277, 0.5669960379600525, 0.5666799545288086, 0.566364049911499, 0.5660478472709656, 0.5657317638397217, 0.5654153823852539, 0.5650991201400757, 0.5647826194763184, 0.5644661784172058, 0.5641494989395142, 0.5638329386711121, 0.5635160207748413, 0.5631992816925049, 0.5628822445869446, 0.5625653266906738, 0.562248170375824, 0.5619310736656189, 0.5616136789321899, 0.5612964630126953, 0.5609789490699768, 0.5606614947319031, 0.5603438019752502, 0.560026228427887, 0.5597085952758789, 0.559390664100647, 0.5590728521347046, 0.5587547421455383, 0.5584367513656616, 0.558118462562561, 0.55780029296875, 0.5574818849563599, 0.5571635365486145, 0.55684494972229, 0.5565264821052551, 0.5562077164649963, 0.5558890700340271, 0.5555701851844788, 0.5552513599395752, 0.5549322962760925, 0.5546132922172546, 0.5542940497398376, 0.5539749264717102, 0.5536555051803589, 0.5533362030982971, 0.5530166029930115, 0.5526971817016602, 0.5523774027824402, 0.5520578026771545, 0.551737904548645, 0.551418125629425, 0.5510980486869812, 0.5507780909538269, 0.5504578948020935, 0.5501377582550049, 0.5498173832893372, 0.549497127532959, 0.5491765737533569, 0.5488561391830444, 0.5485354065895081, 0.548214852809906, 0.5478939414024353, 0.5475732088088989, 0.5472521781921387, 0.546931266784668, 0.5466100573539734, 0.5462889671325684, 0.5459676384925842, 0.5456464290618896, 0.5453248620033264, 0.5450034737586975, 0.5446817874908447, 0.5443602800369263, 0.5440384149551392, 0.5437167286872864, 0.5433946847915649, 0.5430728197097778, 0.5427506566047668, 0.5424286127090454, 0.5421063303947449, 0.5417841076850891, 0.5414616465568542, 0.5411393046379089, 0.5408166646957397, 0.5404941439628601, 0.5401713848114014, 0.5398486852645874, 0.5395257472991943, 0.5392029285430908, 0.5388798117637634, 0.5385568141937256, 0.5382335186004639, 0.5379104018211365, 0.5375869274139404, 0.5372636318206787, 0.5369400382041931, 0.5366166234016418, 0.5362928509712219, 0.5359692573547363, 0.5356453061103821, 0.5353215336799622, 0.5349974632263184, 0.5346735715866089, 0.5343493223190308, 0.534025251865387, 0.5337008833885193, 0.5333766341209412, 0.5330520868301392, 0.5327276587486267, 0.5324029922485352, 0.5320784449577332, 0.5317535996437073, 0.531428873538971, 0.5311038494110107, 0.5307790040969849, 0.5304538011550903, 0.5301287770271301, 0.529803454875946, 0.5294783115386963, 0.5291528105735779, 0.5288274884223938, 0.5285018682479858, 0.5281763672828674, 0.5278505682945251, 0.5275248885154724, 0.5271989703178406, 0.5268731713294983, 0.5265470743179321, 0.5262210965156555, 0.5258948802947998, 0.5255687236785889, 0.5252423286437988, 0.5249160528182983, 0.5245895385742188, 0.5242630839347839, 0.5239365696907043, 0.5236098170280457, 0.5232831239700317, 0.5229561924934387, 0.5226293802261353, 0.5223022699356079, 0.5219753384590149, 0.521648108959198, 0.5213209390640259, 0.5209935307502747, 0.5206663012504578, 0.5203387141227722, 0.520011305809021, 0.5196835994720459, 0.5193560123443604, 0.5190281271934509, 0.5187004208564758, 0.5183724164962769, 0.5180445313453674, 0.5177163481712341, 0.5173883438110352, 0.5170599818229675, 0.5167317986488342, 0.5164033770561218, 0.5160750150680542, 0.5157464146614075, 0.5154178738594055, 0.5150890946388245, 0.5147604942321777, 0.5144315361976624, 0.5141027569770813, 0.5137736797332764, 0.513444721698761, 0.5131155252456665, 0.5127863883972168, 0.512457013130188, 0.5121277570724487, 0.5117982625961304, 0.5114688277244568, 0.5111391544342041, 0.510809600353241, 0.5104798078536987, 0.5101500749588013, 0.5098201036453247, 0.5094902515411377, 0.5091601610183716, 0.5088301301002502, 0.5084998607635498, 0.5081697106361389, 0.5078392624855042, 0.5075089931488037, 0.5071784257888794, 0.5068479776382446, 0.506517231464386, 0.5061866044998169, 0.5058557391166687, 0.5055249929428101, 0.5051940083503723, 0.5048630833625793, 0.5045319199562073, 0.5042008757591248, 0.5038695335388184, 0.5035383701324463, 0.5032069087028503, 0.502875566482544, 0.5025439262390137, 0.5022124648094177, 0.5018807053565979, 0.5015490651130676, 0.5012171268463135, 0.5008853673934937, 0.50055330991745, 0.5002213716506958, 0.49988916516304016, 0.4995570778846741, 0.4992247223854065, 0.49889251589775085, 0.49856001138687134, 0.49822762608528137, 0.4978949725627899, 0.4975624680519104, 0.497229665517807, 0.49689701199531555, 0.4965640604496002, 0.4962312579154968, 0.49589818716049194, 0.4955652058124542, 0.4952319860458374, 0.49489888548851013, 0.49456551671028137, 0.49423226714134216, 0.49389874935150146, 0.4935653507709503, 0.4932316839694977, 0.4928981363773346, 0.49256432056427, 0.4922306537628174, 0.49189668893814087, 0.4915628731250763, 0.49122875928878784, 0.49089479446411133, 0.49056053161621094, 0.4902264177799225, 0.48989203572273254, 0.48955777287483215, 0.4892232418060303, 0.48888882994651794, 0.4885541498661041, 0.48821961879730225, 0.4878847897052765, 0.48755010962486267, 0.4872153401374817, 0.4868803024291992, 0.4865453839302063, 0.4862101972103119, 0.4858751595020294, 0.48553982377052307, 0.48520463705062866, 0.48486918210983276, 0.4845338463783264, 0.4841982424259186, 0.4838627576828003, 0.4835270047187805, 0.4831914007663727, 0.48285549879074097, 0.4825197160243988, 0.48218369483947754, 0.4818477928638458, 0.4815116226673126, 0.48117557168006897, 0.48083925247192383, 0.48050305247306824, 0.48016661405563354, 0.479830265045166, 0.4794936776161194, 0.4791572093963623, 0.47882047295570374, 0.4784838557243347, 0.4781469702720642, 0.47781020402908325, 0.4774731993675232, 0.4771363139152527, 0.4767991304397583, 0.47646209597587585, 0.4761247932910919, 0.4757876396179199, 0.47545018792152405, 0.4751128852367401, 0.4747752845287323, 0.4744378328323364, 0.47410011291503906, 0.47376251220703125, 0.47342464327812195, 0.4730869233608246, 0.47274893522262573, 0.47241106629371643, 0.47207289934158325, 0.4717349112033844, 0.47139662504196167, 0.4710584878921509, 0.4707200527191162, 0.4703817665576935, 0.47004321217536926, 0.469704806804657, 0.4693661034107208, 0.4690275490283966, 0.4686886966228485, 0.46834999322891235, 0.4680110216140747, 0.467672199010849, 0.4673330783843994, 0.46699410676956177, 0.46665486693382263, 0.46631574630737305, 0.465976357460022, 0.46563711762428284, 0.4652976095676422, 0.46495822072029114, 0.4646185636520386, 0.46427902579307556, 0.46393924951553345, 0.4635995924472809, 0.46325963735580444, 0.46291986107826233, 0.46257978677749634, 0.4622398614883423, 0.46189963817596436, 0.46155959367752075, 0.46121925115585327, 0.46087905764579773, 0.4605385661125183, 0.46019822359085083, 0.45985761284828186, 0.45951715111732483, 0.4591763913631439, 0.45883581042289734, 0.4584949016571045, 0.45815417170524597, 0.4578131437301636, 0.4574722647666931, 0.45713111758232117, 0.45679011940956116, 0.45644882321357727, 0.4561076760292053, 0.4557662606239319, 0.4554249942302704, 0.455083429813385, 0.4547420144081116, 0.45440033078193665, 0.45405879616737366, 0.4537169635295868, 0.45337527990341187, 0.45303332805633545, 0.45269152522087097, 0.4523494243621826, 0.4520074725151062, 0.4516652524471283, 0.45132318139076233, 0.4509808123111725, 0.45063862204551697, 0.4502961337566376, 0.44995376467704773, 0.4496113657951355, 0.4492686688899994, 0.4489261507987976, 0.44858330488204956, 0.44824063777923584, 0.44789770245552063, 0.44755488634109497, 0.4472118020057678, 0.4468688666820526, 0.4465256631374359, 0.44618257880210876, 0.4458392560482025, 0.4454960525035858, 0.44515255093574524, 0.444809228181839, 0.44446563720703125, 0.44412216544151306, 0.4437784254550934, 0.44343483448028564, 0.4430909752845764, 0.44274723529815674, 0.44240325689315796, 0.44205939769744873, 0.441715270280838, 0.44137129187583923, 0.4410270154476166, 0.44068291783332825, 0.44033852219581604, 0.43999427556991577, 0.439649760723114, 0.4393053948879242, 0.4389607310295105, 0.43861624598503113, 0.4382714629173279, 0.4379268288612366, 0.4375819265842438, 0.4372371733188629, 0.43689215183258057, 0.43654724955558777, 0.4362020790576935, 0.4358570873737335, 0.4355117976665497, 0.4351666569709778, 0.434821218252182, 0.43447595834732056, 0.43413040041923523, 0.43378502130508423, 0.43343934416770935, 0.4330938160419464, 0.432748019695282, 0.4324023425579071, 0.4320564270019531, 0.4317106604576111, 0.43136459589004517, 0.4310186803340912, 0.4306724965572357, 0.4303264617919922, 0.42998015880584717, 0.4296340048313141, 0.42928755283355713, 0.4289412796497345, 0.428594708442688, 0.4282482862472534, 0.42790159583091736, 0.42755505442619324, 0.4272082448005676, 0.42686158418655396, 0.4265146553516388, 0.42616787552833557, 0.42582079768180847, 0.4254738688468933, 0.42512670159339905, 0.42477965354919434, 0.42443233728408813, 0.42408517003059387, 0.4237377345561981, 0.4233904480934143, 0.4230428636074066, 0.42269545793533325, 0.422347754240036, 0.4220002293586731, 0.4216524064540863, 0.42130476236343384, 0.4209568202495575, 0.4206090271472931, 0.4202609658241272, 0.41991305351257324, 0.4195648729801178, 0.4192168414592743, 0.4188685417175293, 0.41852036118507385, 0.4181719422340393, 0.4178236722946167, 0.4174751043319702, 0.41712671518325806, 0.416778028011322, 0.4164294898509979, 0.4160807132720947, 0.4157320559024811, 0.41538313031196594, 0.41503435373306274, 0.41468530893325806, 0.4143364429473877, 0.41398724913597107, 0.41363823413848877, 0.413288950920105, 0.41293981671333313, 0.4125904142856598, 0.4122411608695984, 0.4118918478488922, 0.41154223680496216, 0.41119280457496643, 0.4108431041240692, 0.41049355268478394, 0.4101437032222748, 0.40979403257369995, 0.40944406390190125, 0.40909427404403687, 0.4087441861629486, 0.4083942770957947, 0.40804407000541687, 0.4076940417289734, 0.40734371542930603, 0.406993567943573, 0.4066431224346161, 0.4062928557395935, 0.40594229102134705, 0.4055919051170349, 0.4052412211894989, 0.4048907160758972, 0.40453991293907166, 0.4041892886161804, 0.4038383662700653, 0.4034876227378845, 0.40313658118247986, 0.4027857184410095, 0.4024345576763153, 0.4020835757255554, 0.40173229575157166, 0.4013811945915222, 0.4010297954082489, 0.4006785750389099, 0.40032705664634705, 0.3999757170677185, 0.3996241092681885, 0.399272620677948, 0.3989208936691284, 0.3985693156719208, 0.39821743965148926, 0.39786574244499207, 0.3975137770175934, 0.39716196060180664, 0.3968098759651184, 0.3964579403400421, 0.39610573649406433, 0.3957536816596985, 0.39540135860443115, 0.39504918456077576, 0.39469674229621887, 0.3943444788455963, 0.3939919173717499, 0.39363953471183777, 0.3932868540287018, 0.3929343521595001, 0.3925815522670746, 0.3922289311885834, 0.3918760120868683, 0.3915232717990875, 0.3911702632904053, 0.39081740379333496, 0.39046427607536316, 0.3901112973690033, 0.38975805044174194, 0.38940495252609253, 0.3890515863895416, 0.38869839906692505, 0.3883449137210846, 0.38799160718917847, 0.38763800263404846, 0.3872845768928528, 0.3869308531284332, 0.386577308177948, 0.3862234950065613, 0.3858698308467865, 0.38551589846611023, 0.3851621448993683, 0.38480809330940247, 0.38445422053337097, 0.3841000497341156, 0.38374605774879456, 0.38339176774024963, 0.38303765654563904, 0.38268327713012695, 0.3823290467262268, 0.38197454810142517, 0.38162022829055786, 0.3812656104564667, 0.3809111714363098, 0.3805564343929291, 0.38020187616348267, 0.37984704971313477, 0.3794923722743988, 0.37913742661476135, 0.3787826597690582, 0.3784275949001312, 0.37807270884513855, 0.377717524766922, 0.37736251950263977, 0.37700724601745605, 0.3766521215438843, 0.376296728849411, 0.37594151496887207, 0.37558600306510925, 0.37523066997528076, 0.3748750686645508, 0.37451961636543274, 0.3741638958454132, 0.3738083243370056, 0.37345248460769653, 0.3730968236923218, 0.37274110317230225, 0.3723851144313812, 0.37202927470207214, 0.3716731667518616, 0.3713172376155853, 0.3709610104560852, 0.3706049621105194, 0.3702486455440521, 0.3698924779891968, 0.36953604221343994, 0.36917978525161743, 0.36882323026657104, 0.368466854095459, 0.36811020970344543, 0.3677537143230438, 0.3673969507217407, 0.36704036593437195, 0.3666835129261017, 0.36632680892944336, 0.36596983671188354, 0.36561301350593567, 0.3652559220790863, 0.36489900946617126, 0.36454182863235474, 0.36418479681015015, 0.36382749676704407, 0.3634703755378723, 0.3631129860877991, 0.36275574564933777, 0.362398236989975, 0.3620408773422241, 0.3616832494735718, 0.36132580041885376, 0.36096808314323425, 0.3606105446815491, 0.36025270819664, 0.3598950505256653, 0.3595370948314667, 0.3591793477535248, 0.358821302652359, 0.3584634065628052, 0.35810527205467224, 0.35774728655815125, 0.35738903284072876, 0.3570309579372406, 0.35667258501052856, 0.35631442070007324, 0.35595595836639404, 0.3555976450443268, 0.3552390933036804, 0.354880690574646, 0.3545220196247101, 0.3541634976863861, 0.35380473732948303, 0.3534461259841919, 0.35308724641799927, 0.35272854566574097, 0.3523695468902588, 0.35201072692871094, 0.3516516387462616, 0.3512927293777466, 0.3509335517883301, 0.3505745232105255, 0.35021522641181946, 0.34985610842704773, 0.3494966924190521, 0.34913748502731323, 0.34877797961235046, 0.348418653011322, 0.3480590581893921, 0.3476996123790741, 0.3473398983478546, 0.34698036313056946, 0.3466205596923828, 0.3462609350681305, 0.3459010124206543, 0.3455412983894348, 0.34518128633499146, 0.34482142329216003, 0.3444613218307495, 0.3441013693809509, 0.34374117851257324, 0.3433811366558075, 0.34302082657814026, 0.34266066551208496, 0.34230026602745056, 0.3419400155544281, 0.34157949686050415, 0.3412191569805145, 0.3408585488796234, 0.34049808979034424, 0.3401373624801636, 0.3397768437862396, 0.3394160270690918, 0.3390553593635559, 0.3386944532394409, 0.33833369612693787, 0.3379727005958557, 0.3376118540763855, 0.3372507393360138, 0.3368898034095764, 0.33652856945991516, 0.3361675441265106, 0.3358062207698822, 0.3354450762271881, 0.33508366346359253, 0.3347224295139313, 0.33436092734336853, 0.3339995741844177, 0.3336379826068878, 0.33327654004096985, 0.3329150378704071, 0.33255329728126526, 0.33219170570373535, 0.33182984590530396, 0.3314681649208069, 0.3311062157154083, 0.3307444453239441, 0.33038240671157837, 0.3300205171108246, 0.3296583890914917, 0.32929641008377075, 0.3289341628551483, 0.3285720944404602, 0.3282097578048706, 0.32784759998321533, 0.3274851441383362, 0.32712289690971375, 0.32676035165786743, 0.32639801502227783, 0.32603538036346436, 0.3256729245185852, 0.32531020045280457, 0.32494765520095825, 0.32458481192588806, 0.3242221772670746, 0.3238592743873596, 0.3234965205192566, 0.32313352823257446, 0.3227706849575043, 0.3224075734615326, 0.32204464077949524, 0.3216814398765564, 0.3213184177875519, 0.3209551274776459, 0.3205920159816742, 0.32022860646247864, 0.3198654055595398, 0.3195019066333771, 0.31913861632347107, 0.3187750279903412, 0.31841161847114563, 0.31804797053337097, 0.31768447160720825, 0.31732070446014404, 0.31695711612701416, 0.3165932595729828, 0.31622958183288574, 0.3158656358718872, 0.3155018389225006, 0.3151378035545349, 0.31477394700050354, 0.3144097924232483, 0.31404584646224976, 0.31368160247802734, 0.31331756711006165, 0.31295323371887207, 0.3125891089439392, 0.31222468614578247, 0.31186044216156006, 0.31149592995643616, 0.31113162636756897, 0.3107670247554779, 0.31040260195732117, 0.31003791093826294, 0.30967339873313904, 0.30930861830711365, 0.3089440166950226, 0.30857914686203003, 0.3082144558429718, 0.3078494966030121, 0.3074847161769867, 0.3071196675300598, 0.30675479769706726, 0.3063896596431732, 0.3060246706008911, 0.3056594431400299, 0.305294394493103, 0.30492907762527466, 0.3045639395713806, 0.3041985332965851, 0.3038332760334015, 0.3034677803516388, 0.3031024634838104, 0.30273687839508057, 0.30237147212028503, 0.302005797624588, 0.3016403019428253, 0.30127450823783875, 0.3009089231491089, 0.30054306983947754, 0.3001773953437805, 0.299811452627182, 0.2994456887245178, 0.29907965660095215, 0.2987138032913208, 0.29834768176078796, 0.29798173904418945, 0.29761552810668945, 0.2972494959831238, 0.2968831956386566, 0.29651710391044617, 0.29615071415901184, 0.29578450322151184, 0.29541802406311035, 0.2950517535209656, 0.2946851849555969, 0.294318825006485, 0.29395216703414917, 0.29358571767807007, 0.2932189702987671, 0.2928524315357208, 0.2924858331680298, 0.29211896657943726, 0.29175230860710144, 0.29138535261154175, 0.2910185754299164, 0.2906515598297119, 0.2902847230434418, 0.28991758823394775, 0.28955066204071045, 0.28918346762657166, 0.2888164222240448, 0.28844913840293884, 0.2880820333957672, 0.2877146601676941, 0.2873474955558777, 0.2869800329208374, 0.28661274909973145, 0.286245197057724, 0.28587785363197327, 0.28551021218299866, 0.28514277935028076, 0.2847750782966614, 0.2844075560569763, 0.28403976559638977, 0.28367215394973755, 0.28330427408218384, 0.28293657302856445, 0.28256863355636597, 0.2822008430957794, 0.28183281421661377, 0.28146493434906006, 0.28109681606292725, 0.28072887659072876, 0.2803606688976288, 0.27999264001846313, 0.279624342918396, 0.27925625443458557, 0.27888786792755127, 0.2785196900367737, 0.2781512439250946, 0.27778297662734985, 0.2774144113063812, 0.2770460844039917, 0.2766774594783783, 0.2763090133666992, 0.27594032883644104, 0.2755718231201172, 0.27520301938056946, 0.27483442425727844, 0.27446556091308594, 0.27409690618515015, 0.2737279534339905, 0.2733592092990875, 0.2729901671409607, 0.2726213335990906, 0.27225223183631897, 0.2718833088874817, 0.2715141177177429, 0.27114513516426086, 0.2707758843898773, 0.2704067826271057, 0.270037442445755, 0.269668310880661, 0.26929888129234314, 0.2689296305179596, 0.26856014132499695, 0.26819083094596863, 0.2678212523460388, 0.26745185256004333, 0.26708218455314636, 0.2667127251625061, 0.26634299755096436, 0.26597344875335693, 0.265603631734848, 0.26523399353027344, 0.26486408710479736, 0.264494389295578, 0.26412442326545715, 0.26375463604927063, 0.2633845806121826, 0.2630147337913513, 0.26264458894729614, 0.2622746527194977, 0.26190444827079773, 0.2615344524383545, 0.2611641585826874, 0.260794073343277, 0.2604237198829651, 0.2600535452365875, 0.25968310236930847, 0.25931286811828613, 0.2589423358440399, 0.2585720121860504, 0.2582014501094818, 0.25783103704452515, 0.2574603855609894, 0.25708991289138794, 0.256719172000885, 0.2563486099243164, 0.2559778094291687, 0.2556071877479553, 0.25523629784584045, 0.2548655867576599, 0.25449463725090027, 0.25412383675575256, 0.25375279784202576, 0.25338196754455566, 0.2530108392238617, 0.25263991951942444, 0.2522687315940857, 0.25189775228500366, 0.25152671337127686, 0.25115540623664856, 0.250784307718277, 0.2504129111766815, 0.25004175305366516, 0.24967029690742493, 0.2492990344762802, 0.2489275187253952, 0.2485561966896057, 0.24818459153175354, 0.24781319499015808, 0.24744153022766113, 0.2470700591802597, 0.2466983199119568, 0.2463267743587494, 0.2459549605846405, 0.24558334052562714, 0.24521145224571228, 0.24483975768089294, 0.2444678097963333, 0.244096040725708, 0.2437240183353424, 0.24335217475891113, 0.24298007786273956, 0.2426081746816635, 0.24223600327968597, 0.24186402559280396, 0.24149177968502045, 0.24111972749233246, 0.24074742197990417, 0.24037529528141022, 0.24000291526317596, 0.23963071405887604, 0.23925825953483582, 0.2388859987258911, 0.23851348459720612, 0.23814114928245544, 0.23776854574680328, 0.23739615082740784, 0.2370234876871109, 0.23665101826190948, 0.23627828061580658, 0.2359057366847992, 0.2355329394340515, 0.23516032099723816, 0.2347874492406845, 0.23441477119922638, 0.23404182493686676, 0.23366908729076385, 0.23329606652259827, 0.2329232543706894, 0.23255017399787903, 0.23217728734016418, 0.23180414736270905, 0.23143118619918823, 0.23105797171592712, 0.23068495094776154, 0.23031166195869446, 0.2299385815858841, 0.22956521809101105, 0.22919206321239471, 0.22881865501403809, 0.22844542562961578, 0.22807194292545319, 0.2276986539363861, 0.22732509672641754, 0.2269517332315445, 0.22657811641693115, 0.22620469331741333, 0.22583100199699402, 0.22545750439167023, 0.22508375346660614, 0.22471019625663757, 0.2243363857269287, 0.22396275401115417, 0.22358886897563934, 0.22321517765522003, 0.22284123301506042, 0.22246748208999634, 0.22209346294403076, 0.2217196375131607, 0.22134555876255035, 0.22097167372703552, 0.2205975204706192, 0.2202235758304596, 0.2198493629693985, 0.21947534382343292, 0.21910107135772705, 0.2187269926071167, 0.21835264563560486, 0.21797850728034973, 0.21760410070419312, 0.21722988784313202, 0.21685542166233063, 0.21648114919662476, 0.2161066234111786, 0.21573227643966675, 0.2153576910495758, 0.2149832844734192, 0.21460862457752228, 0.21423417329788208, 0.2138594388961792, 0.21348491311073303, 0.21311013400554657, 0.21273554861545563, 0.2123606950044632, 0.21198605000972748, 0.21161113679409027, 0.21123641729354858, 0.2108614444732666, 0.21048668026924133, 0.21011187136173248, 0.20973680913448334, 0.2093619406223297, 0.2089868038892746, 0.2086118757724762, 0.2082366943359375, 0.20786170661449432, 0.20748645067214966, 0.2071114033460617, 0.20673608779907227, 0.20636098086833954, 0.20598560571670532, 0.20561043918132782, 0.20523500442504883, 0.20485976338386536, 0.2044842690229416, 0.20410898327827454, 0.203733429312706, 0.20335808396339417, 0.20298247039318085, 0.20260705053806305, 0.20223137736320496, 0.20185591280460358, 0.2014801800251007, 0.20110464096069336, 0.20072884857654572, 0.20035326480865479, 0.19997741281986237, 0.19960176944732666, 0.19922585785388947, 0.1988501399755478, 0.19847418367862701, 0.19809840619564056, 0.197722390294075, 0.19734656810760498, 0.19697047770023346, 0.19659459590911865, 0.19621844589710236, 0.19584251940250397, 0.1954663097858429, 0.19509030878543854, 0.19471405446529388, 0.19433800876140594, 0.19396167993545532, 0.1935855746269226, 0.1932092010974884, 0.1928330361843109, 0.19245660305023193, 0.19208037853240967, 0.1917039006948471, 0.19132761657238007, 0.19095106422901154, 0.1905747354030609, 0.1901981383562088, 0.1898217499256134, 0.18944509327411652, 0.18906864523887634, 0.18869192898273468, 0.18831542134284973, 0.1879386603832245, 0.18756209313869476, 0.18718527257442474, 0.18680866062641144, 0.18643179535865784, 0.18605512380599976, 0.18567818403244019, 0.18530146777629852, 0.18492448329925537, 0.18454769253730774, 0.184170663356781, 0.1837938278913498, 0.18341673910617828, 0.1830398440361023, 0.182662695646286, 0.18228575587272644, 0.18190856277942657, 0.18153156340122223, 0.1811543107032776, 0.18077726662158966, 0.18039995431900024, 0.18002285063266754, 0.17964549362659454, 0.17926833033561707, 0.17889092862606049, 0.17851372063159943, 0.17813624441623688, 0.17775899171829224, 0.1773814707994461, 0.1770041584968567, 0.17662659287452698, 0.17624922096729279, 0.1758716106414795, 0.17549419403076172, 0.17511650919914246, 0.1747390478849411, 0.17436131834983826, 0.17398381233215332, 0.1736060231924057, 0.173228457570076, 0.17285063862800598, 0.1724730134010315, 0.1720951348543167, 0.17171746492385864, 0.17133952677249908, 0.17096181213855743, 0.1705838292837143, 0.17020605504512787, 0.16982802748680115, 0.16945020854473114, 0.16907213628292084, 0.16869425773620605, 0.16831636428833008, 0.1679382175207138, 0.16756026446819305, 0.167182058095932, 0.16680407524108887, 0.16642580926418304, 0.16604776680469513, 0.16566947102546692, 0.16529138386249542, 0.16491302847862244, 0.16453488171100616, 0.1641564816236496, 0.16377830505371094, 0.1633998453617096, 0.16302160918712616, 0.16264311969280243, 0.1622648388147354, 0.1618862897157669, 0.1615079641342163, 0.16112937033176422, 0.16075098514556885, 0.16037234663963318, 0.15999393165111542, 0.15961523354053497, 0.15923675894737244, 0.1588580310344696, 0.1584795117378235, 0.15810073912143707, 0.15772216022014618, 0.15734334290027618, 0.1569647341966629, 0.15658585727214813, 0.15620718896389008, 0.15582828223705292, 0.15544956922531128, 0.15507060289382935, 0.15469186007976532, 0.1543128490447998, 0.153934046626091, 0.1535550057888031, 0.15317615866661072, 0.15279705822467804, 0.15241816639900208, 0.15203902125358582, 0.15166009962558746, 0.15128090977668762, 0.1509019285440445, 0.15052269399166107, 0.15014368295669556, 0.14976440370082855, 0.14938533306121826, 0.14900600910186768, 0.148626908659935, 0.14824753999710083, 0.14786837995052338, 0.14748898148536682, 0.1471097767353058, 0.14673033356666565, 0.14635108411312103, 0.14597159624099731, 0.1455923169851303, 0.14521276950836182, 0.14483344554901123, 0.14445386826992035, 0.14407449960708618, 0.14369487762451172, 0.14331546425819397, 0.14293579757213593, 0.1425563544034958, 0.14217664301395416, 0.14179715514183044, 0.14141739904880524, 0.14103786647319794, 0.14065808057785034, 0.14027850329875946, 0.13989867269992828, 0.13951905071735382, 0.13913917541503906, 0.1387595236301422, 0.13837960362434387, 0.13799990713596344, 0.1376199573278427, 0.1372402161359787, 0.1368602216243744, 0.1364804357290268, 0.1361003965139389, 0.13572058081626892, 0.13534049689769745, 0.13496065139770508, 0.13458052277565002, 0.13420063257217407, 0.13382047414779663, 0.1334405392408371, 0.13306033611297607, 0.13268035650253296, 0.13230012357234955, 0.13192011415958405, 0.13153983652591705, 0.13115978240966797, 0.1307794749736786, 0.13039937615394592, 0.13001902401447296, 0.1296388953924179, 0.12925851345062256, 0.12887834012508392, 0.128497913479805, 0.12811771035194397, 0.12773723900318146, 0.12735699117183685, 0.12697672843933105, 0.12659621238708496, 0.12621590495109558, 0.1258353590965271, 0.12545500695705414, 0.12507441639900208, 0.12469404190778732, 0.12431341409683228, 0.12393300235271454, 0.1235523372888565, 0.12317188829183578, 0.12279117852449417, 0.12241069972515106, 0.12202996015548706, 0.12164943665266037, 0.12126865983009338, 0.1208881065249443, 0.12050729244947433, 0.12012670189142227, 0.11974585801362991, 0.11936523020267487, 0.11898434907197952, 0.11860368400812149, 0.11822276562452316, 0.11784207075834274, 0.11746112257242203, 0.11708039045333862, 0.11669940501451492, 0.11631863564252853, 0.11593761295080185, 0.11555681377649307, 0.115175761282444, 0.11479492485523224, 0.11441384255886078, 0.11403296887874603, 0.11365184932947159, 0.11327094584703445, 0.11288979649543762, 0.1125088557600975, 0.11212766915559769, 0.11174670606851578, 0.11136548221111298, 0.11098448187112808, 0.1106032282114029, 0.11022219806909561, 0.10984090715646744, 0.10945983976125717, 0.10907852649688721, 0.10869742929935455, 0.1083160787820816, 0.10793494433164597, 0.10755356401205063, 0.1071724072098732, 0.10679098963737488, 0.10640979558229446, 0.10602835565805435, 0.10564713180065155, 0.10526565462350845, 0.10488439351320267, 0.10450288653373718, 0.1041216030716896, 0.10374006628990173, 0.10335875302553177, 0.10297717899084091, 0.10259583592414856, 0.10221423953771591, 0.10183285921812057, 0.10145123302936554, 0.10106982290744781, 0.10068816691637039, 0.10030672699213028, 0.09992504119873047, 0.09954357892274857, 0.09916185587644577, 0.09878036379814148, 0.0983986184000969, 0.09801709651947021, 0.09763532131910324, 0.09725376218557358, 0.09687196463346481, 0.09649038314819336, 0.09610854834318161, 0.09572693705558777, 0.09534507989883423, 0.094963438808918, 0.09458155184984207, 0.09419988840818405, 0.09381797164678574, 0.09343627840280533, 0.09305433183908463, 0.09267260879278183, 0.09229063987731934, 0.09190889447927475, 0.09152689576148987, 0.0911451205611229, 0.09076309204101562, 0.09038129448890686, 0.0899992361664772, 0.08961740881204605, 0.0892353355884552, 0.08885347843170166, 0.08847137540578842, 0.08808949589729309, 0.08770736306905746, 0.08732546120882034, 0.08694329857826233, 0.08656136691570282, 0.08617918938398361, 0.08579722791910172, 0.08541502058506012, 0.08503304421901703, 0.08465104550123215, 0.08426880091428757, 0.0838867798447609, 0.08350451290607452, 0.08312246948480606, 0.0827401727437973, 0.08235810697078705, 0.0819757878780365, 0.08159369230270386, 0.08121135085821152, 0.08082923293113708, 0.08044686913490295, 0.08006472885608673, 0.07968233525753021, 0.0793001726269722, 0.07891776412725449, 0.07853557169437408, 0.07815314084291458, 0.07777092605829239, 0.0773884654045105, 0.07700623571872711, 0.07662375271320343, 0.07624150067567825, 0.07585899531841278, 0.07547671347856522, 0.07509418576955795, 0.0747118890285492, 0.07432933896780014, 0.07394701987504959, 0.07356444746255875, 0.0731821060180664, 0.07279951125383377, 0.07241714745759964, 0.07203453034162521, 0.07165214419364929, 0.07126951217651367, 0.07088710367679596, 0.07050444930791855, 0.07012201845645905, 0.06973934173583984, 0.06935689598321915, 0.06897419691085815, 0.06859172880649567, 0.06820901483297348, 0.0678265243768692, 0.06744378805160522, 0.06706127524375916, 0.06667851656675339, 0.06629598885774612, 0.06591321527957916, 0.06553066521883011, 0.06514786928892136, 0.06476530432701111, 0.06438248604536057, 0.06399989873170853, 0.06361706554889679, 0.06323446333408356, 0.06285160779953003, 0.062468986958265305, 0.06208611652255058, 0.06170347332954407, 0.06132058426737785, 0.060937926173210144, 0.06055501848459244, 0.06017233803868294, 0.05978941544890404, 0.059406720101833344, 0.05902377516031265, 0.058641064912080765, 0.05825810506939888, 0.0578753724694252, 0.05749239772558212, 0.05710965022444725, 0.05672665685415268, 0.05634389445185661, 0.05596088245511055, 0.05557810142636299, 0.055195074528455734, 0.05481227859854698, 0.05442923679947853, 0.054046422243118286, 0.05366336554288864, 0.0532805360853672, 0.052897460758686066, 0.05251461640000343, 0.0521315261721611, 0.051748666912317276, 0.05136556178331375, 0.05098268762230873, 0.05059956759214401, 0.0502166785299778, 0.049833543598651886, 0.04945063591003418, 0.04906748607754707, 0.04868456721305847, 0.04830140620470047, 0.047918472439050674, 0.04753529280424118, 0.04715234786272049, 0.0467691533267498, 0.04638619348406792, 0.046002987772226334, 0.045620013028383255, 0.04523679241538048, 0.044853806495666504, 0.04447057098150253, 0.044087570160627365, 0.0437043271958828, 0.043321311473846436, 0.042938053607940674, 0.04255502671003342, 0.04217199236154556, 0.04178871586918831, 0.04140567034482956, 0.04102238267660141, 0.04063932225108147, 0.04025602340698242, 0.03987295180559158, 0.039489638060331345, 0.03910655900835991, 0.038723234087228775, 0.038340140134096146, 0.037956804037094116, 0.03757370263338089, 0.037190355360507965, 0.036807239055633545, 0.036423880606889725, 0.03604075685143471, 0.03565738722681999, 0.03527425229549408, 0.03489087149500847, 0.03450772538781166, 0.03412433713674545, 0.03374117985367775, 0.033357780426740646, 0.032974615693092346, 0.03259120509028435, 0.03220802918076515, 0.031824611127376556, 0.031441424041986465, 0.031057996675372124, 0.030674802139401436, 0.030291365459561348, 0.029908161610364914, 0.02952471561729908, 0.02914150431752205, 0.02875804901123047, 0.02837482839822769, 0.027991365641355515, 0.02760813757777214, 0.027224665507674217, 0.026841428130865097, 0.026457948610186577, 0.02607470378279686, 0.025691216811537743, 0.02530796453356743, 0.024924470111727715, 0.024541210383176804, 0.024157708510756493, 0.023774441331624985, 0.023390933871269226, 0.02300765924155712, 0.022624144330620766, 0.022240862250328064, 0.02185734175145626, 0.02147405408322811, 0.021090524271130562, 0.020707231014966965, 0.020323697477579117, 0.019940396770834923, 0.019556857645511627, 0.019173551350831985, 0.018790004774928093, 0.018406694754958153, 0.018023142591118813, 0.017639826983213425, 0.017256269231438637, 0.0168729480355978, 0.016489386558532715, 0.01610605977475643, 0.015722492709755898, 0.015339162200689316, 0.014955590479075909, 0.014572255313396454, 0.014188679866492748, 0.01380534004420042, 0.013421759940683842, 0.013038416393101215, 0.012654832564294338, 0.012271485291421413, 0.011887897737324238, 0.01150454767048359, 0.011120956391096115, 0.010737602598965168, 0.010354007594287395, 0.009970651008188725, 0.009587053209543228, 0.009203693829476833, 0.008820093236863613, 0.008436731062829494, 0.008053128607571125, 0.007669763173907995, 0.007286158390343189, 0.00690279109403491, 0.006519183982163668, 0.006135814823210239, 0.005752205848693848, 0.00536883482709527, 0.0049852244555950165, 0.00460185157135129, 0.004218239802867174, 0.003834865987300873, 0.003451253054663539, 0.0030678780749440193, 0.002684264210984111, 0.0023008882999420166, 0.0019172736210748553, 0.001533897127956152, 0.0011502819834277034, 0.0007669050828553736, 0.00038328964728862047, -8.742277657347586e-08};

typedef struct {
    pyo_audio_HEAD
    PyObject *input;
    Stream *input_stream;
    PyObject *transpo;
    Stream *transpo_stream;
    PyObject *feedback;
    Stream *feedback_stream;
    MYFLT winsize;
	MYFLT pointerPos;
    int in_count;
    MYFLT *buffer; // samples memory
    int modebuffer[4];
} Harmonizer;

static void
Harmonizer_transform_ii(Harmonizer *self) {
    MYFLT val, amp, inc, ratio, rate, del, xind, pos, envpos, fpart;
    int i, ipart;

    MYFLT *in = Stream_getData((Stream *)self->input_stream);
    MYFLT trans = PyFloat_AS_DOUBLE(self->transpo);
    MYFLT feed = PyFloat_AS_DOUBLE(self->feedback);
    if (feed < 0.0)
        feed = 0.0;
    else if (feed > 1.0)
        feed = 1.0;

    ratio = MYPOW(2.0, trans/12.0);
	rate = (ratio-1.0) / self->winsize;
    inc = -rate / self->sr;

    for (i=0; i<self->bufsize; i++) {
		/* first overlap */
		pos = self->pointerPos;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] = val * amp;

		/* second overlap */
		pos = self->pointerPos + 0.5;
        if (pos >= 1)
            pos -= 1.0;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] += (val * amp);

        self->pointerPos += inc;
        if (self->pointerPos < 0.0)
            self->pointerPos += 1.0;
        else if (self->pointerPos >= 1.0)
            self->pointerPos -= 1.0;

		self->buffer[self->in_count] = in[i]  + (self->data[i] * feed);
        if (self->in_count == 0)
            self->buffer[(int)self->sr] = self->buffer[0];
        self->in_count++;
        if (self->in_count >= self->sr)
            self->in_count = 0;
    }
}

static void
Harmonizer_transform_ai(Harmonizer *self) {
    MYFLT val, amp, inc, ratio, rate, del, xind, pos, envpos, fpart;
    int i, ipart;

    MYFLT *in = Stream_getData((Stream *)self->input_stream);
    MYFLT *trans = Stream_getData((Stream *)self->transpo_stream);
    MYFLT feed = PyFloat_AS_DOUBLE(self->feedback);
    if (feed < 0.0)
        feed = 0.0;
    else if (feed > 1.0)
        feed = 1.0;

	MYFLT oneOnWinsize = 1.0 / self->winsize;
	MYFLT oneOnSr = 1.0 / self->sr;
    for (i=0; i<self->bufsize; i++) {
		ratio = MYPOW(2.0, trans[i]/12.0);
		rate = (ratio-1.0) * oneOnWinsize;
		inc = -rate * oneOnSr;;

		/* first overlap */
		pos = self->pointerPos;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] = val * amp;

		/* second overlap */
		pos = self->pointerPos + 0.5;
        if (pos >= 1)
            pos -= 1.0;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] += (val * amp);

        self->pointerPos += inc;
        if (self->pointerPos < 0)
            self->pointerPos += 1.0;
        else if (self->pointerPos >= 1)
            self->pointerPos -= 1.0;

		self->buffer[self->in_count] = in[i]  + (self->data[i] * feed);
        if (self->in_count == 0)
            self->buffer[(int)self->sr] = self->buffer[0];
        self->in_count++;
        if (self->in_count >= self->sr)
            self->in_count = 0;
    }
}

static void
Harmonizer_transform_ia(Harmonizer *self) {
    MYFLT val, amp, inc, ratio, rate, del, xind, pos, envpos, fpart, feedback;
    int i, ipart;

    MYFLT *in = Stream_getData((Stream *)self->input_stream);
    MYFLT trans = PyFloat_AS_DOUBLE(self->transpo);
    MYFLT *feed = Stream_getData((Stream *)self->feedback_stream);

	ratio = MYPOW(2.0, trans/12.0);
	rate = (ratio-1.0) / self->winsize;
    inc = -rate / self->sr;

    for (i=0; i<self->bufsize; i++) {
        if (feed[i] < 0.0)
            feedback = 0.0;
        else if (feed[i] > 1.0)
            feedback = 1.0;
        else
            feedback = feed[i];

		/* first overlap */
		pos = self->pointerPos;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] = val * amp;

		/* second overlap */
		pos = self->pointerPos + 0.5;
        if (pos > 1)
            pos -= 1.0;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] += (val * amp);

        self->pointerPos += inc;
        if (self->pointerPos < 0)
            self->pointerPos += 1.0;
        else if (self->pointerPos >= 1)
            self->pointerPos -= 1.0;

		self->buffer[self->in_count] = in[i]  + (self->data[i] * feedback);
        if (self->in_count == 0)
            self->buffer[(int)self->sr] = self->buffer[0];
        self->in_count++;
        if (self->in_count >= self->sr)
            self->in_count = 0;
    }
}

static void
Harmonizer_transform_aa(Harmonizer *self) {
    MYFLT val, amp, inc, ratio, rate, del, xind, pos, envpos, fpart, feedback;
    int i, ipart;

    MYFLT *in = Stream_getData((Stream *)self->input_stream);
    MYFLT *trans = Stream_getData((Stream *)self->transpo_stream);
    MYFLT *feed = Stream_getData((Stream *)self->feedback_stream);

	MYFLT oneOnWinsize = 1.0 / self->winsize;
	MYFLT oneOnSr = 1.0 / self->sr;
    for (i=0; i<self->bufsize; i++) {
		ratio = MYPOW(2.0, trans[i]/12.0);
		rate = (ratio-1.0) * oneOnWinsize;
		inc = -rate * oneOnSr;;

        if (feed[i] < 0.0)
            feedback = 0.0;
        else if (feed[i] > 1.0)
            feedback = 1.0;
        else
            feedback = feed[i];

		/* first overlap */
		pos = self->pointerPos;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] = val * amp;

		/* second overlap */
		pos = self->pointerPos + 0.5;
        if (pos > 1)
            pos -= 1.0;
		envpos = pos * 8192.0;
		ipart = (int)envpos;
		fpart = envpos - ipart;
		amp = ENVELOPE[ipart] + (ENVELOPE[ipart+1] - ENVELOPE[ipart]) * fpart;

		del = pos * self->winsize;
        xind = self->in_count - (del * self->sr);
        if (xind < 0)
            xind += self->sr;
        ipart = (int)xind;
        fpart = xind - ipart;
        val = self->buffer[ipart] + (self->buffer[ipart+1] - self->buffer[ipart]) * fpart;
        self->data[i] += (val * amp);

        self->pointerPos += inc;
        if (self->pointerPos < 0)
            self->pointerPos += 1.0;
        else if (self->pointerPos >= 1)
            self->pointerPos -= 1.0;

		self->buffer[self->in_count] = in[i]  + (self->data[i] * feedback);
        if (self->in_count == 0)
            self->buffer[(int)self->sr] = self->buffer[0];
        self->in_count++;
        if (self->in_count >= self->sr)
            self->in_count = 0;
    }
}

static void Harmonizer_feedbacktprocessing_ii(Harmonizer *self) { POST_PROCESSING_II };
static void Harmonizer_feedbacktprocessing_ai(Harmonizer *self) { POST_PROCESSING_AI };
static void Harmonizer_feedbacktprocessing_ia(Harmonizer *self) { POST_PROCESSING_IA };
static void Harmonizer_feedbacktprocessing_aa(Harmonizer *self) { POST_PROCESSING_AA };
static void Harmonizer_feedbacktprocessing_ireva(Harmonizer *self) { POST_PROCESSING_IREVA };
static void Harmonizer_feedbacktprocessing_areva(Harmonizer *self) { POST_PROCESSING_AREVA };
static void Harmonizer_feedbacktprocessing_revai(Harmonizer *self) { POST_PROCESSING_REVAI };
static void Harmonizer_feedbacktprocessing_revaa(Harmonizer *self) { POST_PROCESSING_REVAA };
static void Harmonizer_feedbacktprocessing_revareva(Harmonizer *self) { POST_PROCESSING_REVAREVA };

static void
Harmonizer_setProcMode(Harmonizer *self)
{
    int procmode, muladdmode;
    procmode = self->modebuffer[2] + self->modebuffer[3] * 10;
    muladdmode = self->modebuffer[0] + self->modebuffer[1] * 10;

	switch (procmode) {
        case 0:
            self->proc_func_ptr = Harmonizer_transform_ii;
            break;
        case 1:
            self->proc_func_ptr = Harmonizer_transform_ai;
            break;
        case 10:
            self->proc_func_ptr = Harmonizer_transform_ia;
            break;
        case 11:
            self->proc_func_ptr = Harmonizer_transform_aa;
            break;
    }
	switch (muladdmode) {
        case 0:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_ii;
            break;
        case 1:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_ai;
            break;
        case 2:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_revai;
            break;
        case 10:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_ia;
            break;
        case 11:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_aa;
            break;
        case 12:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_revaa;
            break;
        case 20:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_ireva;
            break;
        case 21:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_areva;
            break;
        case 22:
            self->muladd_func_ptr = Harmonizer_feedbacktprocessing_revareva;
            break;
    }
}

static void
Harmonizer_compute_next_data_frame(Harmonizer *self)
{
    (*self->proc_func_ptr)(self);
    (*self->muladd_func_ptr)(self);
}

static int
Harmonizer_traverse(Harmonizer *self, visitproc visit, void *arg)
{
    pyo_VISIT
    Py_VISIT(self->input);
    Py_VISIT(self->input_stream);
    Py_VISIT(self->transpo);
    Py_VISIT(self->transpo_stream);
    Py_VISIT(self->feedback);
    Py_VISIT(self->feedback_stream);
    return 0;
}

static int
Harmonizer_clear(Harmonizer *self)
{
    pyo_CLEAR
    Py_CLEAR(self->input);
    Py_CLEAR(self->input_stream);
    Py_CLEAR(self->transpo);
    Py_CLEAR(self->transpo_stream);
    Py_CLEAR(self->feedback);
    Py_CLEAR(self->feedback_stream);
    return 0;
}

static void
Harmonizer_dealloc(Harmonizer* self)
{
    pyo_DEALLOC
    free(self->buffer);
    Harmonizer_clear(self);
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject *
Harmonizer_new(PyTypeObject *type, PyObject *args, PyObject *kwds)
{
    int i;
    MYFLT wintmp;
    PyObject *inputtmp, *input_streamtmp, *transpotmp=NULL, *feedbacktmp=NULL, *multmp=NULL, *addtmp=NULL;
    Harmonizer *self;
    self = (Harmonizer *)type->tp_alloc(type, 0);

    self->transpo = PyFloat_FromDouble(-7.0);
    self->feedback = PyFloat_FromDouble(0.0);
    self->winsize = 0.1;
    self->pointerPos = 1.0;
	self->in_count = 0;
	self->modebuffer[0] = 0;
	self->modebuffer[1] = 0;
	self->modebuffer[2] = 0;
	self->modebuffer[3] = 0;

    INIT_OBJECT_COMMON
    Stream_setFunctionPtr(self->stream, Harmonizer_compute_next_data_frame);
    self->mode_func_ptr = Harmonizer_setProcMode;

    static char *kwlist[] = {"input", "transpo", "feedback", "winsize", "mul", "add", NULL};

    if (! PyArg_ParseTupleAndKeywords(args, kwds, TYPE_O_OOFOO, kwlist, &inputtmp, &transpotmp, &feedbacktmp, &wintmp, &multmp, &addtmp))
        Py_RETURN_NONE;

	INIT_INPUT_STREAM

    if (transpotmp) {
        PyObject_CallMethod((PyObject *)self, "setTranspo", "O", transpotmp);
    }

    if (feedbacktmp) {
        PyObject_CallMethod((PyObject *)self, "setFeedback", "O", feedbacktmp);
    }

    if (multmp) {
        PyObject_CallMethod((PyObject *)self, "setMul", "O", multmp);
    }

    if (addtmp) {
        PyObject_CallMethod((PyObject *)self, "setAdd", "O", addtmp);
    }

    PyObject_CallMethod(self->server, "addStream", "O", self->stream);

    self->buffer = (MYFLT *)realloc(self->buffer, (self->sr+1) * sizeof(MYFLT));
    for (i=0; i<(self->sr+1); i++) {
        self->buffer[i] = 0.;
    }

    if (wintmp > 0.0 && wintmp <= 1.0)
        self->winsize = wintmp;
    else
        PySys_WriteStdout("Harmonizer : winsize lower than 0.0 or larger than 1.0 second, keeping default value.\n");

    (*self->mode_func_ptr)(self);

    return (PyObject *)self;
}

static PyObject * Harmonizer_getServer(Harmonizer* self) { GET_SERVER };
static PyObject * Harmonizer_getStream(Harmonizer* self) { GET_STREAM };
static PyObject * Harmonizer_setMul(Harmonizer *self, PyObject *arg) { SET_MUL };
static PyObject * Harmonizer_setAdd(Harmonizer *self, PyObject *arg) { SET_ADD };
static PyObject * Harmonizer_setSub(Harmonizer *self, PyObject *arg) { SET_SUB };
static PyObject * Harmonizer_setDiv(Harmonizer *self, PyObject *arg) { SET_DIV };

static PyObject * Harmonizer_play(Harmonizer *self, PyObject *args, PyObject *kwds) { PLAY };
static PyObject * Harmonizer_out(Harmonizer *self, PyObject *args, PyObject *kwds) { OUT };
static PyObject * Harmonizer_stop(Harmonizer *self, PyObject *args, PyObject *kwds) { STOP };

static PyObject * Harmonizer_multiply(Harmonizer *self, PyObject *arg) { MULTIPLY };
static PyObject * Harmonizer_inplace_multiply(Harmonizer *self, PyObject *arg) { INPLACE_MULTIPLY };
static PyObject * Harmonizer_add(Harmonizer *self, PyObject *arg) { ADD };
static PyObject * Harmonizer_inplace_add(Harmonizer *self, PyObject *arg) { INPLACE_ADD };
static PyObject * Harmonizer_sub(Harmonizer *self, PyObject *arg) { SUB };
static PyObject * Harmonizer_inplace_sub(Harmonizer *self, PyObject *arg) { INPLACE_SUB };
static PyObject * Harmonizer_div(Harmonizer *self, PyObject *arg) { DIV };
static PyObject * Harmonizer_inplace_div(Harmonizer *self, PyObject *arg) { INPLACE_DIV };

static PyObject *
Harmonizer_reset(Harmonizer *self)
{
    int i;
    for (i=0; i<(self->sr+1); i++) {
        self->buffer[i] = 0.;
    }
	Py_RETURN_NONE;
}

static PyObject *
Harmonizer_setTranspo(Harmonizer *self, PyObject *arg)
{
	PyObject *tmp, *streamtmp;

    ASSERT_ARG_NOT_NULL

	int isNumber = PyNumber_Check(arg);

	tmp = arg;
	Py_INCREF(tmp);
	Py_DECREF(self->transpo);
	if (isNumber == 1) {
		self->transpo = PyNumber_Float(tmp);
        self->modebuffer[2] = 0;
	}
	else {
		self->transpo = tmp;
        streamtmp = PyObject_CallMethod((PyObject *)self->transpo, "_getStream", NULL);
        Py_INCREF(streamtmp);
        Py_XDECREF(self->transpo_stream);
        self->transpo_stream = (Stream *)streamtmp;
		self->modebuffer[2] = 1;
	}

    (*self->mode_func_ptr)(self);

	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
Harmonizer_setFeedback(Harmonizer *self, PyObject *arg)
{
	PyObject *tmp, *streamtmp;

    ASSERT_ARG_NOT_NULL

	int isNumber = PyNumber_Check(arg);

	tmp = arg;
	Py_INCREF(tmp);
	Py_DECREF(self->feedback);
	if (isNumber == 1) {
		self->feedback = PyNumber_Float(tmp);
        self->modebuffer[3] = 0;
	}
	else {
		self->feedback = tmp;
        streamtmp = PyObject_CallMethod((PyObject *)self->feedback, "_getStream", NULL);
        Py_INCREF(streamtmp);
        Py_XDECREF(self->feedback_stream);
        self->feedback_stream = (Stream *)streamtmp;
		self->modebuffer[3] = 1;
	}

    (*self->mode_func_ptr)(self);

	Py_INCREF(Py_None);
	return Py_None;
}

static PyObject *
Harmonizer_setWinsize(Harmonizer *self, PyObject *arg)
{
	MYFLT wintmp;

    ASSERT_ARG_NOT_NULL

	int isNumber = PyNumber_Check(arg);

	if (isNumber == 1) {
        wintmp = PyFloat_AsDouble(arg);
        if (wintmp > 0.0 && wintmp <= 1.0)
			self->winsize = wintmp;
        else
            PySys_WriteStdout("Harmonizer: winsize lower than 0.0 or larger than 1.0 second!\n");
	}

	Py_INCREF(Py_None);
	return Py_None;
}

static PyMemberDef Harmonizer_members[] = {
    {"server", T_OBJECT_EX, offsetof(Harmonizer, server), 0, "Pyo server."},
    {"stream", T_OBJECT_EX, offsetof(Harmonizer, stream), 0, "Stream object."},
    {"input", T_OBJECT_EX, offsetof(Harmonizer, input), 0, "Input sound object."},
    {"transpo", T_OBJECT_EX, offsetof(Harmonizer, transpo), 0, "Transposition factor."},
    {"feedback", T_OBJECT_EX, offsetof(Harmonizer, feedback), 0, "Feedback factor."},
    {"mul", T_OBJECT_EX, offsetof(Harmonizer, mul), 0, "Mul factor."},
    {"add", T_OBJECT_EX, offsetof(Harmonizer, add), 0, "Add factor."},
    {NULL}  /* Sentinel */
};

static PyMethodDef Harmonizer_methods[] = {
    {"getServer", (PyCFunction)Harmonizer_getServer, METH_NOARGS, "Returns server object."},
    {"_getStream", (PyCFunction)Harmonizer_getStream, METH_NOARGS, "Returns stream object."},
    {"play", (PyCFunction)Harmonizer_play, METH_VARARGS|METH_KEYWORDS, "Starts computing without sending sound to soundcard."},
    {"out", (PyCFunction)Harmonizer_out, METH_VARARGS|METH_KEYWORDS, "Starts computing and sends sound to soundcard channel speficied by argument."},
    {"stop", (PyCFunction)Harmonizer_stop, METH_VARARGS|METH_KEYWORDS, "Stops computing."},
    {"reset", (PyCFunction)Harmonizer_reset, METH_NOARGS, "Reset the delay line."},
	{"setTranspo", (PyCFunction)Harmonizer_setTranspo, METH_O, "Sets global transpo factor."},
    {"setFeedback", (PyCFunction)Harmonizer_setFeedback, METH_O, "Sets feedback factor."},
    {"setWinsize", (PyCFunction)Harmonizer_setWinsize, METH_O, "Sets the window size."},
	{"setMul", (PyCFunction)Harmonizer_setMul, METH_O, "Sets granulator mul factor."},
	{"setAdd", (PyCFunction)Harmonizer_setAdd, METH_O, "Sets granulator add factor."},
    {"setSub", (PyCFunction)Harmonizer_setSub, METH_O, "Sets inverse add factor."},
    {"setDiv", (PyCFunction)Harmonizer_setDiv, METH_O, "Sets inverse mul factor."},
    {NULL}  /* Sentinel */
};

static PyNumberMethods Harmonizer_as_number = {
    (binaryfunc)Harmonizer_add,                      /*nb_add*/
    (binaryfunc)Harmonizer_sub,                 /*nb_subtract*/
    (binaryfunc)Harmonizer_multiply,                 /*nb_multiply*/
    INITIALIZE_NB_DIVIDE_ZERO               /*nb_divide*/
    0,                /*nb_remainder*/
    0,                   /*nb_divmod*/
    0,                   /*nb_power*/
    0,                  /*nb_neg*/
    0,                /*nb_feedback*/
    0,                  /*(unaryfunc)array_abs,*/
    0,                    /*nb_nonzero*/
    0,                    /*nb_invert*/
    0,               /*nb_lshift*/
    0,              /*nb_rshift*/
    0,              /*nb_and*/
    0,              /*nb_xor*/
    0,               /*nb_or*/
    INITIALIZE_NB_COERCE_ZERO                   /*nb_coerce*/
    0,                       /*nb_int*/
    0,                      /*nb_long*/
    0,                     /*nb_float*/
    INITIALIZE_NB_OCT_ZERO   /*nb_oct*/
    INITIALIZE_NB_HEX_ZERO   /*nb_hex*/
    (binaryfunc)Harmonizer_inplace_add,              /*inplace_add*/
    (binaryfunc)Harmonizer_inplace_sub,         /*inplace_subtract*/
    (binaryfunc)Harmonizer_inplace_multiply,         /*inplace_multiply*/
    INITIALIZE_NB_IN_PLACE_DIVIDE_ZERO        /*inplace_divide*/
    0,        /*inplace_remainder*/
    0,           /*inplace_power*/
    0,       /*inplace_lshift*/
    0,      /*inplace_rshift*/
    0,      /*inplace_and*/
    0,      /*inplace_xor*/
    0,       /*inplace_or*/
    0,             /*nb_floor_divide*/
    (binaryfunc)Harmonizer_div,                       /*nb_true_divide*/
    0,     /*nb_inplace_floor_divide*/
    (binaryfunc)Harmonizer_inplace_div,                       /*nb_inplace_true_divide*/
    0,                     /* nb_index */
};

PyTypeObject HarmonizerType = {
    PyVarObject_HEAD_INIT(NULL, 0)
    "_pyo.Harmonizer_base",         /*tp_name*/
    sizeof(Harmonizer),         /*tp_basictranspo*/
    0,                         /*tp_itemtranspo*/
    (destructor)Harmonizer_dealloc, /*tp_dealloc*/
    0,                         /*tp_print*/
    0,                         /*tp_getattr*/
    0,                         /*tp_setattr*/
    0,                         /*tp_as_async (tp_compare in Python 2)*/
    0,                         /*tp_repr*/
    &Harmonizer_as_number,             /*tp_as_number*/
    0,                         /*tp_as_sequence*/
    0,                         /*tp_as_mapping*/
    0,                         /*tp_hash */
    0,                         /*tp_call*/
    0,                         /*tp_str*/
    0,                         /*tp_getattro*/
    0,                         /*tp_setattro*/
    0,                         /*tp_as_buffer*/
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC | Py_TPFLAGS_CHECKTYPES, /*tp_flags*/
    "Harmonizer objects. Harmonize an input sound.",           /* tp_doc */
    (traverseproc)Harmonizer_traverse,   /* tp_traverse */
    (inquiry)Harmonizer_clear,           /* tp_clear */
    0,		               /* tp_richcompare */
    0,		               /* tp_weaklistoffset */
    0,		               /* tp_iter */
    0,		               /* tp_iternext */
    Harmonizer_methods,             /* tp_methods */
    Harmonizer_members,             /* tp_members */
    0,                      /* tp_getset */
    0,                         /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    0,      /* tp_init */
    0,                         /* tp_alloc */
    Harmonizer_new,                 /* tp_new */
};
