#
# PySNMP MIB module DOCS-IF-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/DOCS-IF-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:08:56 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( Integer, OctetString, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "Integer", "OctetString", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( SingleValueConstraint, ConstraintsUnion, ValueRangeConstraint, ConstraintsIntersection, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "SingleValueConstraint", "ConstraintsUnion", "ValueRangeConstraint", "ConstraintsIntersection", "ValueSizeConstraint")
( IANAifType, ) = mibBuilder.importSymbols("IANAifType-MIB", "IANAifType")
( InterfaceIndexOrZero, ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero", "ifIndex")
( InetAddressType, InetAddress, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddressType", "InetAddress")
( NotificationGroup, ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance", "ObjectGroup")
( NotificationType, Integer32, MibIdentifier, Counter64, iso, Bits, transmission, MibScalar, MibTable, MibTableRow, MibTableColumn, Gauge32, ModuleIdentity, IpAddress, TimeTicks, Unsigned32, ObjectIdentity, Counter32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "NotificationType", "Integer32", "MibIdentifier", "Counter64", "iso", "Bits", "transmission", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Gauge32", "ModuleIdentity", "IpAddress", "TimeTicks", "Unsigned32", "ObjectIdentity", "Counter32")
( DisplayString, TimeInterval, MacAddress, TextualConvention, TruthValue, StorageType, RowStatus, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TimeInterval", "MacAddress", "TextualConvention", "TruthValue", "StorageType", "RowStatus", "TimeStamp")
docsIfMib = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 127)).setRevisions(("2006-05-24 00:00", "1999-08-19 00:00",))
if mibBuilder.loadTexts: docsIfMib.setLastUpdated('200605240000Z')
if mibBuilder.loadTexts: docsIfMib.setOrganization('IETF IPCDN Working Group')
if mibBuilder.loadTexts: docsIfMib.setContactInfo('        David Raftus\n             Postal: ATI Technologies Inc.\n                     340 Terry Fox Drive, Suite 202\n                     Ottawa Ontario\n                     Canada\n             Phone:  +1 613 592 1052 ext.222\n             E-mail: david.raftus@ati.com\n\n                     Eduardo Cardona\n             Postal: Cable Television Laboratories, Inc.\n                     858 Coal Creek Circle\n                     Louisville, CO 80027-9750\n                     U.S.A.\n             Phone:  Tel:    +1 303 661 9100\n                     Fax:    +1 303 661 9199\n             E-mail: e.cardona@cablelabs.com;mibs@cablelabs.com\n\n             IETF IPCDN Working Group\n             General Discussion: ipcdn@ietf.org\n             Subscribe: http://www.ietf.org/mailman/listinfo/ipcdn\n             Archive: ftp://ftp.ietf.org/ietf-mail-archive/ipcdn\n             Co-chairs: Richard Woundy, Richard_Woundy@cable.comcast.com\n                        Jean-Francois Mule, jf.mule@cablelabs.com')
if mibBuilder.loadTexts: docsIfMib.setDescription('This is the MIB Module for DOCSIS 2.0-compliant Radio\n             Frequency (RF) interfaces in Cable Modems and\n             Cable Modem Termination Systems.\n\n             Copyright (C) The Internet Society (2006).  This\n             version of this MIB module is part of RFC 4546; see\n             the RFC itself for full legal notices.')
class TenthdBmV(Integer32, TextualConvention):
    displayHint = 'd-1'

class TenthdB(Integer32, TextualConvention):
    displayHint = 'd-1'

class DocsisVersion(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3,))
    namedValues = NamedValues(("docsis10", 1), ("docsis11", 2), ("docsis20", 3),)

class DocsisQosVersion(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2,))
    namedValues = NamedValues(("docsis10", 1), ("docsis11", 2),)

class DocsisUpstreamType(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(0, 1, 2, 3, 4,))
    namedValues = NamedValues(("unknown", 0), ("tdma", 1), ("atdma", 2), ("scdma", 3), ("tdmaAndAtdma", 4),)

class DocsEqualizerData(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(36,260),)
docsIfMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 1))
docsIfBaseObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 1, 1))
docsIfCmObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 1, 2))
docsIfCmtsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 1, 3))
docsIfDownstreamChannelTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1), )
if mibBuilder.loadTexts: docsIfDownstreamChannelTable.setDescription('This table describes the attributes of downstream\n             channels (frequency bands).')
docsIfDownstreamChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfDownstreamChannelEntry.setDescription('An entry provides a list of attributes for a single\n             downstream channel.\n             An entry in this table exists for each ifEntry with an\n             ifType of docsCableDownstream(128).')
docsIfDownChannelId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfDownChannelId.setDescription('The Cable Modem Termination System identification of the\n             downstream channel within this particular MAC interface.\n             if the interface is down, the object returns the most\n             current value.  If the downstream channel ID is unknown,\n             this object returns a value of 0.')
docsIfDownChannelFrequency = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,1000000000))).setUnits('hertz').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfDownChannelFrequency.setDescription('The center of the downstream frequency associated with\n             this channel.  This object will return the current tuner\n             frequency.  If a CMTS provides IF output, this object\n             will return 0, unless this CMTS is in control of the\n             final downstream frequency.  See the associated\n             compliance object for a description of valid frequencies\n             that may be written to this object.')
docsIfDownChannelWidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16000000))).setUnits('hertz').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfDownChannelWidth.setDescription('The bandwidth of this downstream channel.  Most\n             implementations are expected to support a channel width\n             of 6 MHz (North America) and/or 8 MHz (Europe).  See the\n             associated compliance object for a description of the\n             valid channel widths for this object.')
docsIfDownChannelModulation = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("unknown", 1), ("other", 2), ("qam64", 3), ("qam256", 4),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfDownChannelModulation.setDescription('The modulation type associated with this downstream\n             channel.  If the interface is down, this object either\n             returns the configured value (CMTS), the most current\n             value (CM), or the value of unknown(1).  See the\n             associated conformance object for write conditions and\n             limitations.  See the reference for specifics on the\n             modulation profiles implied by qam64 and qam256.')
docsIfDownChannelInterleave = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("unknown", 1), ("other", 2), ("taps8Increment16", 3), ("taps16Increment8", 4), ("taps32Increment4", 5), ("taps64Increment2", 6), ("taps128Increment1", 7), ("taps12increment17", 8),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfDownChannelInterleave.setDescription("The Forward Error Correction (FEC) interleaving used\n             for this downstream channel.\n             Values are defined as follows:\n             taps8Increment16(3):   protection 5.9/4.1 usec,\n                                    latency .22/.15 msec\n             taps16Increment8(4):   protection 12/8.2 usec,\n                                    latency .48/.33 msec\n             taps32Increment4(5):   protection 24/16 usec,\n                                    latency .98/.68 msec\n             taps64Increment2(6):   protection 47/33 usec,\n                                    latency 2/1.4 msec\n             taps128Increment1(7):  protection 95/66 usec,\n                                    latency 4/2.8 msec\n             taps12increment17(8):  protection 18/14 usec,\n                                    latency 0.43/0.32 msec\n\n            The value 'taps12increment17' is supported by EuroDOCSIS\n            cable systems only, and the others by DOCSIS cable systems.\n\n             If the interface is down, this object either returns\n             the configured value (CMTS), the most current value (CM),\n             or the value of unknown(1).\n             The value of other(2) is returned if the interleave\n             is known but not defined in the above list.\n             See the associated conformance object for write\n             conditions and limitations.  See the reference for the FEC\n             configuration described by the setting of this object.")
docsIfDownChannelPower = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 6), TenthdBmV()).setUnits('dBmV').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfDownChannelPower.setDescription('At the CMTS, the operational transmit power.  At the CM,\n             the received power level.\n             If the interface is down, this object either returns\n             the configured value (CMTS), the most current value (CM)\n             or the value of 0.  See the associated conformance object\n             for write conditions and limitations.  See the reference\n             for recommended and required power levels.')
docsIfDownChannelAnnex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("unknown", 1), ("other", 2), ("annexA", 3), ("annexB", 4), ("annexC", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfDownChannelAnnex.setDescription('The value of this object indicates the conformance of\n             the implementation to important regional cable standards.\n             annexA : Annex A from ITU-T J.83 is used.\n                      (equivalent to EN 300 429)\n             annexB : Annex B from ITU-T J.83 is used.\n             annexC : Annex C from ITU-T J.83 is used.')
docsIfDownChannelStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 1, 1, 8), StorageType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfDownChannelStorageType.setDescription('The storage type for this conceptual row.\n             Entries with this object set to permanent(4)\n             do not require write operations for read-write\n             objects.')
docsIfUpstreamChannelTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2), )
if mibBuilder.loadTexts: docsIfUpstreamChannelTable.setDescription('This table describes the attributes of attached upstream\n             channels.')
docsIfUpstreamChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfUpstreamChannelEntry.setDescription('List of attributes for a single upstream channel.  For\n             DOCSIS 2.0 CMTSs, an entry in this table exists for\n             each ifEntry with an ifType of docsCableUpstreamChannel\n             (205).\n             For DOCSIS 1.x CM/CMTSs and DOCSIS 2.0 CMs, an entry in\n             this table exists for each ifEntry with an ifType of\n             docsCableUpstream (129).\n\n             For DOCSIS 2.0 CMTSs, two classes of interfaces can be\n             defined for this table:\n              o Upstream Physical Interfaces: The traditional DOCSIS\n                1.x CMTS upstream interface ifType 129 and the DOCSIS\n                2.0 ifType 205 that are functional.  In other words,\n                interfaces that represent upstream receivers within\n                an RF MAC interface.\n                Entries of physical interfaces are exposed to the\n                management interface with their corresponding\n                ifStack hierarchy and are not administratively\n                created by this table.\n\n              o Upstream Temporary Interfaces: A fictitious\n                interface created for the purpose of manipulating\n                physical interface parameters offline, then\n                validating prior to updating the target physical\n                interface.\n\n             In case of a reinitialization of the managed system,\n             physical interfaces values persist while the temporary\n             interfaces are not recreated.\n\n             This mechanism helps to minimize service disruptions\n             originating in situations where a group of interface\n             parameter values need to be consistent with each other\n             in SET operations.  A temporary buffer\n             (temporary interface) is provided to allow the CMTS\n             to validate the parameters offline.')
docsIfUpChannelId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfUpChannelId.setDescription('The CMTS identification of the upstream channel.')
docsIfUpChannelFrequency = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,1000000000))).setUnits('hertz').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelFrequency.setDescription('The center of the frequency band associated with this\n             upstream interface.  This object returns 0 if the frequency\n             is undefined or unknown.  Minimum permitted upstream\n             frequency is 5,000,000 Hz for current technology.  See\n             the associated conformance object for write conditions\n             and limitations.')
docsIfUpChannelWidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,64000000))).setUnits('hertz').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelWidth.setDescription('The bandwidth of this upstream interface.  This object\n             returns 0 if the interface width is undefined or unknown.\n             Minimum permitted interface width is currently 200,000 Hz.\n             See the associated conformance object for write conditions\n             and limitations.')
docsIfUpChannelModulationProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 4), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelModulationProfile.setDescription("An entry identical to the docsIfModIndex in the\n             docsIfCmtsModulationTable that describes this channel.\n             This channel is further instantiated there by a grouping\n             of interval usage codes (IUCs) that, together, fully\n             describe the channel modulation.  This object returns 0 if\n             the docsIfCmtsModulationTable entry does not exist or is\n             empty.  See the associated conformance object for write\n             conditions and limitations.\n             Setting this object returns an 'inconsistentValue'\n             error if the following conditions are not satisfied:\n             1. All the IUC entries in the selected modulation profile\n             MUST have the same value of docsIfCmtsModChannelType.\n             2. All of the Modulation parameters in the selected\n             modulation profile MUST be consistent with the other\n             parameters in this docsIfUpstreamChannelEntry.")
docsIfUpChannelSlotSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 5), Unsigned32()).setUnits('ticks').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelSlotSize.setDescription('Applicable to TDMA and ATDMA channel types only.\n             The number of 6.25 microsecond ticks in each upstream\n             mini-slot.  Returns zero if the value is undefined or\n             unknown or in case of an SCDMA channel.\n             See the associated conformance object for write\n             conditions and limitations.')
docsIfUpChannelTxTimingOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfUpChannelTxTimingOffset.setDescription('At the CM, a measure of the current round trip time\n             obtained from the ranging offset (initial ranging offset +\n             ranging offset adjustments).\n             At the CMTS, the maximum of timing offset, among all the\n             CMs that are/were present on the channel, taking into\n             account all ( initial + periodic ) timing offset\n             corrections that were sent for each of the CMs.  Generally,\n             these measurements are positive, but if the measurements\n             are negative, the value of this object is zero.  Used for\n             timing of CM upstream transmissions to ensure synchronized\n             arrivals at the CMTS.\n             Units are one 64th fraction of 6.25 microseconds.')
docsIfUpChannelRangingBackoffStart = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelRangingBackoffStart.setDescription('The initial random backoff window to use when retrying\n             Ranging Requests.  Expressed as a power of 2.  A value of\n             16 at the CMTS indicates that a proprietary adaptive retry\n             mechanism is to be used.  See the associated conformance\n             object for write conditions and limitations.')
docsIfUpChannelRangingBackoffEnd = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelRangingBackoffEnd.setDescription('The final random backoff window to use when retrying\n             Ranging Requests.  Expressed as a power of 2.  A value of\n             16 at the CMTS indicates that a proprietary adaptive retry\n             mechanism is to be used.  See the associated conformance\n             object for write conditions and limitations.')
docsIfUpChannelTxBackoffStart = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelTxBackoffStart.setDescription('The initial random backoff window to use when retrying\n             transmissions.  Expressed as a power of 2.  A value of 16\n             at the CMTS indicates that a proprietary adaptive retry\n             mechanism is to be used.  See the associated conformance\n             object for write conditions and limitations.')
docsIfUpChannelTxBackoffEnd = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelTxBackoffEnd.setDescription('The final random backoff window to use when retrying\n             transmissions.  Expressed as a power of 2.  A value of 16\n             at the CMTS indicates that a proprietary adaptive retry\n             mechanism is to be used.  See the associated conformance\n             object for write conditions and limitations.')
docsIfUpChannelScdmaActiveCodes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 11), Unsigned32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(64,66),ValueRangeConstraint(68,70),ValueRangeConstraint(72,72),ValueRangeConstraint(74,78),ValueRangeConstraint(80,82),ValueRangeConstraint(84,88),ValueRangeConstraint(90,96),ValueRangeConstraint(98,100),ValueRangeConstraint(102,102),ValueRangeConstraint(104,106),ValueRangeConstraint(108,108),ValueRangeConstraint(110,112),ValueRangeConstraint(114,126),ValueRangeConstraint(128,128),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelScdmaActiveCodes.setDescription('Applicable for SCDMA channel types only.\n             Number of active codes.  Returns zero for\n             Non-SCDMA channel types.  Note that legal\n             values from 64..128 MUST be non-prime.')
docsIfUpChannelScdmaCodesPerSlot = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(2,32),))).setUnits('codesperMinislots').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelScdmaCodesPerSlot.setDescription('Applicable for SCDMA channel types only.\n             The number of SCDMA codes per mini-slot.\n             Returns zero if the value is undefined or unknown or in\n             case of a TDMA or ATDMA channel.')
docsIfUpChannelScdmaFrameSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 13), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,32))).setUnits('spreadIntervals').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelScdmaFrameSize.setDescription('Applicable for SCDMA channel types only.\n             SCDMA Frame size in units of spreading intervals.\n             This value returns zero for non-SCDMA Profiles.')
docsIfUpChannelScdmaHoppingSeed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 14), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,32767))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelScdmaHoppingSeed.setDescription("Applicable for SCDMA channel types only.\n             15-bit seed used for code hopping sequence initialization.\n             Returns zero for non-SCDMA channel types.\n             Setting this value to a value different than zero for\n             non-SCDMA channel types returns the error 'wrongValue'.")
docsIfUpChannelType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 15), DocsisUpstreamType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfUpChannelType.setDescription('Reflects the Upstream channel type.\n             This object returns the value of docsIfCmtsModChannelType\n             for the modulation profile selected in\n             docsIfUpChannelModulationProfile for this row.')
docsIfUpChannelCloneFrom = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 16), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelCloneFrom.setDescription("This object contains the ifIndex value of the physical\n             interface row entry whose parameters are to be adjusted.\n\n             Upon setting this object to the ifIndex value of a\n             physical interface, the following interface objects values\n             are copied to this entry:\n             docsIfUpChannelFrequency,\n             docsIfUpChannelWidth,\n             docsIfUpChannelModulationProfile,\n             docsIfUpChannelSlotSize,\n             docsIfUpChannelRangingBackoffStart,\n             docsIfUpChannelRangingBackoffEnd,\n             docsIfUpChannelTxBackoffStart,\n             docsIfUpChannelTxBackoffEnd,\n             docsIfUpChannelScdmaActiveCodes,\n             docsIfUpChannelScdmaCodesPerSlot,\n             docsIfUpChannelScdmaFrameSize,\n             docsIfUpChannelScdmaHoppingSeed,\n             docsIfUpChannelType, and\n             docsIfUpChannelPreEqEnable\n             Setting this object to the value of a non-existent or\n             a temporary upstream interface returns the error\n             'wrongValue'.\n             This object MUST contain a value of zero for physical\n             interfaces entries.\n             Setting this object in row entries that correspond to\n             physical interfaces returns the error 'wrongValue'.")
docsIfUpChannelUpdate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 17), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelUpdate.setDescription("Used to perform the copy of adjusted parameters from the\n             temporary interface entry to the physical interface\n             indicated by the docsIfUpChannelCloneFrom object.  The\n             transfer is initiated through an SNMP SET to 'true' of\n             this object.\n             A SET to 'true' fails and returns error 'commitFailed'\n             if docsIfUpChannelStatus value is 'notInService', which\n             means that the interface parameters values are not\n             compatible with each other or have not been validated yet.\n             Reading this object always returns 'false'.")
docsIfUpChannelStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 18), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelStatus.setDescription("This object is only used for the creation of a temporary\n             upstream row with the purpose of updating the parameters\n             of a physical upstream channel entry.\n\n             The following restrictions apply to this object:\n             1. This object is not writable for physical interfaces.\n             2. Temporary interface entries are only created by a SET\n                of this object to createandWait(5).\n             3. ifAdminStatus from the Interface MIB RFC 2863 is used\n                to take a physical upstream channel offline, to be\n                consistent with DOCSIS 1.x operation, as indicated in\n                RFC 2670.\n                In addition,\n                 o ifAdminStatus 'down' is reflected in this object\n                   as 'notInService'.\n                 o ifOperStatus 'down' while ifAdminStatus 'up' is\n                   reflected in this object as 'notInservice'.\n             4. Temporary created rows MUST be set to 'active' with\n                the purpose of validating upstream parameter\n                consistency prior to transferring the parameters to the\n                physical interface.\n\n             Below is a mandatory procedure for adjusting the values\n             of a physical interface:\n             1. Create a temporary interface entry through an SNMP SET\n                using 'createAndWait'.  At this point, the RowStatus\n                reports 'notReady'.\n                The Manager entity uses an ifIndex value outside the\n                operational range of the physical interfaces for the\n                creation of a temporary interface.\n             2. Set the docsIfUpChannelCloneFrom object to the ifIndex\n                value of the physical row to update.  Now\n                docsIfUpChannelStatus reports 'notInService'.\n             3. Change the upstream parameters to the desired values\n                in the temporary row.\n             4. Validate that all parameters are consistent by setting\n                docsIfUpChannelStatus to 'active'.  A failure to set the\n                RowStatus to 'active' returns the error 'commitFailed',\n                which means the parameters are not compatible with the\n                target physical interface.\n             5. With docsIfUpChannelStatus 'active', transfer the\n                parameters to the target physical interface by setting\n                the object docsIfUpChannelUpdate to 'true'.\n             6. Delete the temporary row by setting\n                docsIfUpChannelStatus to 'destroy'.")
docsIfUpChannelPreEqEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 2, 1, 19), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfUpChannelPreEqEnable.setDescription('At the CMTS, this object is used to enable or disable\n             pre-equalization on the upstream channel represented by\n             this table instance.  At the CM, this object is read-only\n             and reflects the status of pre-equalization as represented\n             in the RNG-RSP.  Pre-equalization is considered enabled at\n             the CM if a RNG-RSP with pre-equalization data has been\n             received at least once since the last mac\n             reinitialization.')
docsIfQosProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3), )
if mibBuilder.loadTexts: docsIfQosProfileTable.setDescription('Describes the attributes for each class of service.')
docsIfQosProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1), ).setIndexNames((0, "DOCS-IF-MIB", "docsIfQosProfIndex"))
if mibBuilder.loadTexts: docsIfQosProfileEntry.setDescription('Describes the attributes for a single class of service.\n             If implemented as read-create in the Cable Modem\n             Termination System, creation of entries in this table is\n             controlled by the value of\n             docsIfCmtsQosProfilePermissions.\n\n             If implemented as read-only, entries are created based\n             on information in REG-REQ MAC messages received from\n             cable modems (for Cable Modem Termination System), or\n             based on information extracted from the TFTP option file\n             (for Cable Modem).\n             In the Cable Modem Termination System, read-only entries\n             are removed if no longer referenced by\n             docsIfCmtsServiceTable.\n\n             An entry in this table MUST not be removed while it is\n             referenced by an entry in docsIfCmServiceTable (Cable\n             Modem) or docsIfCmtsServiceTable (Cable Modem Termination\n             System).\n\n             An entry in this table SHOULD NOT be changeable while\n             it is referenced by an entry in docsIfCmtsServiceTable.\n\n             If this table is created automatically, there SHOULD only\n             be a single entry for each Class of Service.  Multiple\n             entries with the same Class of Service parameters are NOT\n             RECOMMENDED.')
docsIfQosProfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,16383)))
if mibBuilder.loadTexts: docsIfQosProfIndex.setDescription('The index value that uniquely identifies an entry\n             in the docsIfQosProfileTable.')
docsIfQosProfPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,7))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfPriority.setDescription('A relative priority assigned to this service when\n             allocating bandwidth.  Zero indicates lowest priority\n             and seven indicates highest priority.\n             Interpretation of priority is device-specific.\n             MUST NOT be changed while this row is active.')
docsIfQosProfMaxUpBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,100000000))).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfMaxUpBandwidth.setDescription('The maximum upstream bandwidth, in bits per second,\n             allowed for a service with this service class.\n             Zero if there is no restriction of upstream bandwidth.\n             MUST NOT be changed while this row is active.')
docsIfQosProfGuarUpBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,100000000))).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfGuarUpBandwidth.setDescription('Minimum guaranteed upstream bandwidth, in bits per second,\n             allowed for a service with this service class.\n             MUST NOT be changed while this row is active.')
docsIfQosProfMaxDownBandwidth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,100000000))).setUnits('bits per second').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfMaxDownBandwidth.setDescription('The maximum downstream bandwidth, in bits per second,\n             allowed for a service with this service class.\n             Zero if there is no restriction of downstream bandwidth.\n             MUST NOT be changed while this row is active.')
docsIfQosProfMaxTxBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('mini-slots').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfMaxTxBurst.setDescription('The maximum number of mini-slots that may be requested\n             for a single upstream transmission.\n             A value of zero means there is no limit.\n             MUST NOT be changed while this row is active.\n             This object has been deprecated and replaced by\n             docsIfQosProfMaxTransmitBurst, to fix a mismatch\n             of the units and value range with respect to the DOCSIS\n             Maximum Upstream Channel Transmit Burst Configuration\n             Setting.')
docsIfQosProfBaselinePrivacy = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 7), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfBaselinePrivacy.setDescription('Indicates whether Baseline Privacy is enabled for this\n             service class.\n             MUST NOT be changed while this row is active.')
docsIfQosProfStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfStatus.setDescription('This is object is used to create or delete rows in\n             this table.  This object MUST NOT be changed from active\n             while the row is referenced by any entry in either\n             docsIfCmServiceTable (on the CM) or\n             docsIfCmtsServiceTable (on the CMTS).')
docsIfQosProfMaxTransmitBurst = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setUnits('bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfQosProfMaxTransmitBurst.setDescription('The maximum number of bytes that may be requested for a\n             single upstream transmission.  A value of zero means there\n             is no limit.  Note: This value does not include any\n             physical layer overhead.\n             MUST NOT be changed while this row is active.')
docsIfQosProfStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 3, 1, 10), StorageType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfQosProfStorageType.setDescription('The storage type for this conceptual row.\n             Entries with this object set to permanent(4)\n             do not require write operations for writable\n             objects.')
docsIfSignalQualityTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4), )
if mibBuilder.loadTexts: docsIfSignalQualityTable.setDescription('At the CM, describes the PHY signal quality of downstream\n             channels.  At the CMTS, this object describes the PHY\n             signal quality of upstream channels.  At the CMTS, this\n             table MAY exclude contention intervals.')
docsIfSignalQualityEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfSignalQualityEntry.setDescription('At the CM, this object describes the PHY characteristics of\n             a downstream channel.  At the CMTS, it describes the PHY\n             signal quality of an upstream channel.\n             An entry in this table exists for each ifEntry with an\n             ifType of docsCableDownstream(128) for Cable Modems.\n             For DOCSIS 1.1 Cable Modem Termination Systems, an entry\n             exists for each ifEntry with an ifType of\n             docsCableUpstream (129).\n             For DOCSIS 2.0 Cable Modem Termination Systems, an entry\n             exists for each ifEntry with an ifType of\n             docsCableUpstreamChannel (205).')
docsIfSigQIncludesContention = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQIncludesContention.setDescription('true(1) if this CMTS includes contention intervals in\n             the counters in this table.  Always false(2) for CMs.')
docsIfSigQUnerroreds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 2), Counter32()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQUnerroreds.setDescription('Codewords received on this channel without error.\n             This includes all codewords, whether or not they\n             were part of frames destined for this device.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfSigQCorrecteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 3), Counter32()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQCorrecteds.setDescription('Codewords received on this channel with correctable\n             errors.  This includes all codewords, whether or not\n             they were part of frames destined for this device.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfSigQUncorrectables = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 4), Counter32()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQUncorrectables.setDescription('Codewords received on this channel with uncorrectable\n             errors.  This includes all codewords, whether or not\n             they were part of frames destined for this device.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfSigQSignalNoise = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 5), TenthdB()).setUnits('TenthdB').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQSignalNoise.setDescription('Signal/Noise ratio as perceived for this channel.\n             At the CM, this object  describes the Signal/Noise of the\n             downstream channel.  At the CMTS, it describes the\n             average Signal/Noise of the upstream channel.')
docsIfSigQMicroreflections = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('-dBc').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQMicroreflections.setDescription('Microreflections, including in-channel response\n             as perceived on this interface, measured in dBc below\n             the signal level.\n             This object is not assumed to return an absolutely\n             accurate value, but it gives a rough indication\n             of microreflections received on this interface.\n             It is up to the implementer to provide information\n             as accurately as possible.')
docsIfSigQEqualizationData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 7), DocsEqualizerData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQEqualizationData.setDescription('At the CM, this object returns the equalization data for\n                the downstream channel.\n\n                At the CMTS, this object is not applicable and is not\n                instantiated.  Note that previous CMTS implementations\n                may instantiate this object in two ways:\n                - An equalization value indicating an equalization\n                  average for the upstream channel.  Those values have\n                  vendor-dependent interpretations.\n                - Return a zero-length OCTET STRING to indicate that\n                  the value is unknown or if there is no equalization\n                  data available or defined.')
docsIfSigQExtUnerroreds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 8), Counter64()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQExtUnerroreds.setDescription('Codewords received on this channel without error.\n             This includes all codewords, whether or not they\n             were part of frames destined for this device.\n             This is the 64-bit version of docsIfSigQUnerroreds.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfSigQExtCorrecteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 9), Counter64()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQExtCorrecteds.setDescription('Codewords received on this channel with correctable\n             errors.  This includes all codewords, whether or not\n             they were part of frames destined for this device.\n             This is the 64-bit version of docsIfSigQCorrecteds.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfSigQExtUncorrectables = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 4, 1, 10), Counter64()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfSigQExtUncorrectables.setDescription('Codewords received on this channel with uncorrectable\n             errors.  This includes all codewords, whether or not\n             they were part of frames destined for this device.\n             This is the 64-bit version of docsIfSigQUncorrectables.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfDocsisBaseCapability = MibScalar((1, 3, 6, 1, 2, 1, 10, 127, 1, 1, 5), DocsisVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfDocsisBaseCapability.setDescription('Indication of the DOCSIS capability of the device.')
docsIfCmMacTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1), )
if mibBuilder.loadTexts: docsIfCmMacTable.setDescription('Describes the attributes of each CM MAC interface,\n             extending the information available from ifEntry.')
docsIfCmMacEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmMacEntry.setDescription('An entry containing objects describing attributes of\n             each MAC entry, extending the information in ifEntry.\n             An entry in this table exists for each ifEntry with an\n             ifType of docsCableMaclayer(127).')
docsIfCmCmtsAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1, 1, 1), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmCmtsAddress.setDescription('Identifies the CMTS that is believed to control this MAC\n             domain.  At the CM, this will be the source address from\n             SYNC, MAP, and other MAC-layer messages.  If the CMTS is\n             unknown, returns 00-00-00-00-00-00.')
docsIfCmCapabilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1, 1, 2), Bits().clone(namedValues=NamedValues(("atmCells", 0), ("concatenation", 1),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmCapabilities.setDescription("Identifies the capabilities of the MAC implementation\n             at this interface.  Note that packet transmission is\n             always supported.  Therefore, there is no specific bit\n             required to explicitly indicate this capability.\n             Note that BITS objects are encoded most significant bit\n             first.  For example, if bit 1 is set, the value of this\n             object is the octet string '40'H.")
docsIfCmRangingRespTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1, 1, 3), TimeTicks().clone(20)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmRangingRespTimeout.setDescription('Waiting time for a Ranging Response packet.\n             This object has been obsoleted and replaced by\n             docsIfCmRangingTimeout to correct the typing to\n             TimeInterval.')
docsIfCmRangingTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 1, 1, 4), TimeInterval().clone(20)).setUnits('HundredOfSeconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmRangingTimeout.setDescription('Waiting time for a Ranging Response packet.\n             This object MUST NOT persist at reinitialization\n             of the managed system.')
docsIfCmStatusTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2), )
if mibBuilder.loadTexts: docsIfCmStatusTable.setDescription('This table maintains a number of status objects\n             and counters for Cable Modems.')
docsIfCmStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmStatusEntry.setDescription('A set of status objects and counters for a single MAC\n             layer instance in Cable Modem.\n             An entry in this table exists for each ifEntry with an\n             ifType of docsCableMaclayer(127).')
docsIfCmStatusValue = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,))).clone(namedValues=NamedValues(("other", 1), ("notReady", 2), ("notSynchronized", 3), ("phySynchronized", 4), ("usParametersAcquired", 5), ("rangingComplete", 6), ("ipComplete", 7), ("todEstablished", 8), ("securityEstablished", 9), ("paramTransferComplete", 10), ("registrationComplete", 11), ("operational", 12), ("accessDenied", 13),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusValue.setDescription('Current Cable Modem connectivity state, as specified\n             in the RF Interface Specification.  Interpretations for\n             state values 1-12 are clearly outlined in the SP-RFI\n             reference given below.\n             The state value accessDenied(13) indicates the CMTS has\n             sent a Registration Aborted message to the CM.  The same\n             state is reported as accessDenied(7) by the CMTS object\n             docsIfCmtsCmStatusValue.')
docsIfCmStatusCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 2), OctetString().subtype(subtypeSpec=ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(5,5),ValueSizeConstraint(6,6),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusCode.setDescription("Status code for a Cable Modem as defined in the\n             OSSI Specification.  The status code consists\n             of a single character indicating error groups, followed\n             by a two- or three-digit number indicating the status\n             condition, followed by a decimal.\n             An example of a returned value could be 'T101.0'.\n             The zero-length OCTET STRING indicates no status code yet\n             registered.")
docsIfCmStatusTxPower = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 3), TenthdBmV()).setUnits('TenthdBmV').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusTxPower.setDescription('The operational transmit power for the attached upstream\n             channel.')
docsIfCmStatusResets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 4), Counter32()).setUnits('resets').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusResets.setDescription('Number of times the CM reset or initialized this\n             interface.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusLostSyncs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusLostSyncs.setDescription('Number of times the CM lost synchronization with\n             the downstream channel.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusInvalidMaps = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 6), Counter32()).setUnits('maps').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusInvalidMaps.setDescription('Number of times the CM received invalid MAP messages.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusInvalidUcds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 7), Counter32()).setUnits('messages').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusInvalidUcds.setDescription('Number of times the CM received invalid UCD messages.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusInvalidRangingResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 8), Counter32()).setUnits('messages').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusInvalidRangingResponses.setDescription('Number of times the CM received invalid ranging response\n             messages.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusInvalidRegistrationResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 9), Counter32()).setUnits('messages').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusInvalidRegistrationResponses.setDescription('Number of times the CM received invalid registration\n             response messages.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusT1Timeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 10), Counter32()).setUnits('timeouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusT1Timeouts.setDescription('Number of times counter T1 expired in the CM.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusT2Timeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 11), Counter32()).setUnits('timeouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusT2Timeouts.setDescription('Number of times counter T2 expired in the CM.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusT3Timeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 12), Counter32()).setUnits('timeouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusT3Timeouts.setDescription('Number of times counter T3 expired in the CM.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusT4Timeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 13), Counter32()).setUnits('timeouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusT4Timeouts.setDescription('Number of times counter T4 expired in the CM.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusRangingAborteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 14), Counter32()).setUnits('attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusRangingAborteds.setDescription('Number of times the ranging process was aborted\n             by the CMTS.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusDocsisOperMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 15), DocsisQosVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusDocsisOperMode.setDescription("Indication of whether the device has registered using 1.0\n              Class of Service or 1.1 Quality of Service.\n              An unregistered CM SHOULD indicate 'docsis11' for a\n              docsIfDocsisBaseCapability value of DOCSIS 1.1/2.0.  An\n              unregistered CM SHOULD indicate 'docsis10'  for a\n              docsIfDocsisBaseCapability value of DOCSIS 1.0.")
docsIfCmStatusModulationType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 16), DocsisUpstreamType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusModulationType.setDescription('Indicates modulation type status currently used by the\n              CM.  Since this object specifically identifies PHY mode,\n              the shared upstream channel type is not permitted.')
docsIfCmStatusEqualizationData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 17), DocsEqualizerData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusEqualizationData.setDescription('Pre-equalization data for this CM after convolution with\n             data indicated in the RNG-RSP.  This data is valid when\n             docsIfUpChannelPreEqEnable is set to true.')
docsIfCmStatusUCCs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 18), Counter32()).setUnits('attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusUCCs.setDescription('The number of successful Upstream Channel Change\n             transactions.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmStatusUCCFails = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 2, 1, 19), Counter32()).setUnits('attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmStatusUCCFails.setDescription('The number of failed Upstream Channel Change\n             transactions.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmServiceTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3), )
if mibBuilder.loadTexts: docsIfCmServiceTable.setDescription('Describes the attributes of each upstream service queue\n             on a CM.')
docsIfCmServiceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IF-MIB", "docsIfCmServiceId"))
if mibBuilder.loadTexts: docsIfCmServiceEntry.setDescription('Describes the attributes of an upstream bandwidth service\n             queue.\n             An entry in this table exists for each Service ID.\n             The primary index is an ifIndex with an ifType of\n             docsCableMaclayer(127).')
docsIfCmServiceId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,16383)))
if mibBuilder.loadTexts: docsIfCmServiceId.setDescription('Identifies a service queue for upstream bandwidth.  The\n             attributes of this service queue are shared between the\n             CM and the CMTS.  The CMTS allocates upstream bandwidth\n             to this service queue based on requests from the CM and\n             on the class of service associated with this queue.')
docsIfCmServiceQosProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16383))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceQosProfile.setDescription('The index in docsIfQosProfileTable describing the quality\n             of service attributes associated with this particular\n             service.  If no associated entry in docsIfQosProfileTable\n             exists, this object returns a value of zero.')
docsIfCmServiceTxSlotsImmed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 3), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceTxSlotsImmed.setDescription('The number of upstream mini-slots that have been used to\n             transmit data PDUs in immediate (contention) mode.  This\n             includes only those PDUs that are presumed to have\n             arrived at the head-end (i.e., those that were explicitly\n             acknowledged).  It does not include retransmission attempts\n             or mini-slots used by requests.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmServiceTxSlotsDed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 4), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceTxSlotsDed.setDescription('The number of upstream mini-slots that have been used to\n             transmit data PDUs in dedicated mode (i.e., as a result\n             of a unicast Data Grant).\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmServiceTxRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 5), Counter32()).setUnits('attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceTxRetries.setDescription('The number of attempts to transmit data PDUs containing\n             requests for acknowledgment that did not result in\n             acknowledgment.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmServiceTxExceededs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 6), Counter32()).setUnits('attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceTxExceededs.setDescription('The number of data PDU transmission failures due to\n             excessive retries without acknowledgment.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmServiceRqRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 7), Counter32()).setUnits('attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceRqRetries.setDescription('The number of attempts to transmit bandwidth requests\n             that did not result in acknowledgment.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmServiceRqExceededs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 8), Counter32()).setUnits('attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceRqExceededs.setDescription('The number of requests for bandwidth that failed due to\n             excessive retries without acknowledgment.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmServiceExtTxSlotsImmed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 9), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceExtTxSlotsImmed.setDescription('The number of upstream mini-slots that have been used to\n             transmit data PDUs in immediate (contention) mode.  This\n             includes only those PDUs that are presumed to have\n             arrived at the head-end (i.e., those that were explicitly\n             acknowledged).  It does not include retransmission attempts\n             or mini-slots used by requests.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmServiceExtTxSlotsDed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 2, 3, 1, 10), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmServiceExtTxSlotsDed.setDescription('The number of upstream mini-slots that have been used to\n             transmit data PDUs in dedicated mode (i.e., as a result\n             of a unicast Data Grant).\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsMacTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1), )
if mibBuilder.loadTexts: docsIfCmtsMacTable.setDescription('Describes the attributes of each CMTS MAC interface,\n             extending the information available from ifEntry.\n             Mandatory for all CMTS devices.')
docsIfCmtsMacEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmtsMacEntry.setDescription('An entry containing objects describing attributes of each\n             MAC entry, extending the information in ifEntry.\n             An entry in this table exists for each ifEntry with an\n             ifType of docsCableMaclayer(127).')
docsIfCmtsCapabilities = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 1), Bits().clone(namedValues=NamedValues(("atmCells", 0), ("concatenation", 1),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCapabilities.setDescription("Identifies the capabilities of the CMTS MAC\n             implementation at this interface.  Note that packet\n             transmission is always supported.  Therefore, there\n             is no specific bit required to explicitly indicate\n             this capability.\n             Note that BITS objects are encoded most significant bit\n             first.  For example, if bit 1 is set, the value of this\n             object is the octet string '40'H.")
docsIfCmtsSyncInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,200))).setUnits('Milliseconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsSyncInterval.setDescription('The interval between CMTS transmission of successive SYNC\n             messages at this interface.')
docsIfCmtsUcdInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2000))).setUnits('Milliseconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsUcdInterval.setDescription('The interval between CMTS transmission of successive\n             Upstream Channel Descriptor messages for each upstream\n             channel at this interface.')
docsIfCmtsMaxServiceIds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,16383))).setUnits('SIDs').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsMaxServiceIds.setDescription('The maximum number of service IDs that may be\n             simultaneously active.')
docsIfCmtsInsertionInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 5), TimeTicks()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsInsertionInterval.setDescription('The amount of time to elapse between each broadcast\n             initial maintenance grant.  Broadcast initial maintenance\n             grants are used to allow new cable modems to join the\n             network.  Zero indicates that a vendor-specific algorithm\n             is used instead of a fixed time.  The maximum amount of\n             time permitted by the specification is 2 seconds.\n             This object has been obsoleted and replaced by\n             docsIfCmtsInsertInterval to fix a SYNTAX typing problem.')
docsIfCmtsInvitedRangingAttempts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,1024))).setUnits('attempts').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsInvitedRangingAttempts.setDescription('The maximum number of attempts to make on invitations\n             for ranging requests.  A value of zero means the system\n             SHOULD attempt to range forever.')
docsIfCmtsInsertInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 7), TimeInterval()).setUnits('HundredOfSeconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsInsertInterval.setDescription('The amount of time to elapse between each broadcast\n             initial maintenance grant.  Broadcast initial maintenance\n             grants are used to allow new cable modems to join the\n             network.  Zero indicates that a vendor-specific algorithm\n             is used instead of a fixed time.  The maximum amount of\n             time permitted by the specification is 2 seconds.')
docsIfCmtsMacStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 1, 1, 8), StorageType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsMacStorageType.setDescription('The storage type for this conceptual row.\n             Entries with this object set to permanent(4)\n             do not require write operations for read-write\n             objects.')
docsIfCmtsStatusTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2), )
if mibBuilder.loadTexts: docsIfCmtsStatusTable.setDescription('For the MAC layer, this group maintains a number of\n             status objects and counters.')
docsIfCmtsStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmtsStatusEntry.setDescription('Status entry for a single MAC layer.\n             An entry in this table exists for each ifEntry with an\n             ifType of docsCableMaclayer(127).')
docsIfCmtsStatusInvalidRangeReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 1), Counter32()).setUnits('messages').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusInvalidRangeReqs.setDescription('This object counts invalid RNG-REQ messages received on\n             this interface.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsStatusRangingAborteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 2), Counter32()).setUnits('attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusRangingAborteds.setDescription('This object counts ranging attempts that were explicitly\n             aborted by the CMTS.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsStatusInvalidRegReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 3), Counter32()).setUnits('messages').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusInvalidRegReqs.setDescription('This object counts invalid REG-REQ messages received on\n             this interface; that is, syntax, out of range parameters,\n             or erroneous requests.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsStatusFailedRegReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 4), Counter32()).setUnits('attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusFailedRegReqs.setDescription('This object counts failed registration attempts.  Included\n             are docsIfCmtsStatusInvalidRegReqs, authentication, and\n             class of service failures.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsStatusInvalidDataReqs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 5), Counter32()).setUnits('messages').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusInvalidDataReqs.setDescription('This object counts invalid data request messages\n             received on this interface.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsStatusT5Timeouts = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 2, 1, 6), Counter32()).setUnits('timeouts').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsStatusT5Timeouts.setDescription('This object counts the number of times counter T5\n             expired on this interface.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsCmStatusTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3), )
if mibBuilder.loadTexts: docsIfCmtsCmStatusTable.setDescription('A set of objects in the CMTS, maintained for each\n             cable modem connected to this CMTS.')
docsIfCmtsCmStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1), ).setIndexNames((0, "DOCS-IF-MIB", "docsIfCmtsCmStatusIndex"))
if mibBuilder.loadTexts: docsIfCmtsCmStatusEntry.setDescription('Status information for a single cable modem.\n             An entry in this table exists for each cable modem\n             that is connected to the CMTS implementing this table.')
docsIfCmtsCmStatusIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: docsIfCmtsCmStatusIndex.setDescription('Index value to uniquely identify an entry in this table.\n             For an individual cable modem, this index value SHOULD\n             NOT change during CMTS uptime.')
docsIfCmtsCmStatusMacAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 2), MacAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusMacAddress.setDescription('MAC address of the cable modem.  If the cable modem has\n             multiple MAC addresses, this is the MAC address associated\n             with the Cable interface.')
docsIfCmtsCmStatusIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusIpAddress.setDescription('IP address of this cable modem.  If the cable modem has no\n             IP address assigned, or the IP address is unknown, this\n             object returns a value of 0.0.0.0.  If the cable modem has\n             multiple IP addresses, this object returns the IP address\n             associated with the Cable interface.\n             This object has been deprecated and replaced by\n             docsIfCmtsCmStatusInetAddressType and\n             docsIfCmtsCmStatusInetAddress, to enable IPv6 addressing\n             in the future.')
docsIfCmtsCmStatusDownChannelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 4), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusDownChannelIfIndex.setDescription('IfIndex of the downstream channel that this CM is\n             connected to.  If the downstream channel is unknown, this\n             object returns a value of zero.')
docsIfCmtsCmStatusUpChannelIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 5), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusUpChannelIfIndex.setDescription('For DOCSIS 2.0, indicates the ifIndex of the logical\n            upstream channel (ifType 205) this CM is connected to.\n            For DOCSIS 1.x, indicates the ifIndex of the upstream\n             channel (ifType 129) this CM is connected to.\n             If the upstream channel is unknown, this object\n             returns a value of zero.')
docsIfCmtsCmStatusRxPower = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 6), TenthdBmV()).setUnits('ThenthdBmV').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusRxPower.setDescription('The receive power as perceived for upstream data from\n             this cable modem.\n             If the receive power is unknown, this object returns\n             a value of zero.')
docsIfCmtsCmStatusTimingOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusTimingOffset.setDescription('A measure of the current round trip time for this CM.\n             Used for timing of CM upstream transmissions to ensure\n             synchronized arrivals at the CMTS.  Units are in terms\n             of (6.25 microseconds/64).  Returns zero if the value\n             is unknown.\n             For channels requiring finer resolution, please refer to\n             object docsIfCmtsCmStatusHighResolutionTimingOffset.')
docsIfCmtsCmStatusEqualizationData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 8), DocsEqualizerData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusEqualizationData.setDescription('Equalization data for this CM, as measured by the CMTS.\n             Returns the zero-length OCTET STRING if the value is\n             unknown or if there is no equalization data available\n             or defined.')
docsIfCmtsCmStatusValue = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9,))).clone(namedValues=NamedValues(("other", 1), ("ranging", 2), ("rangingAborted", 3), ("rangingComplete", 4), ("ipComplete", 5), ("registrationComplete", 6), ("accessDenied", 7), ("operational", 8), ("registeredBPIInitializing", 9),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusValue.setDescription('Current cable modem connectivity state, as specified\n             in the RF Interface Specification.  Returned status\n             information is the CM status, as assumed by the CMTS,\n             and indicates the following events:\n             other(1)\n                Any state other than below.\n             ranging(2)\n                The CMTS has received an Initial Ranging Request\n                message from the CM, and the ranging process is not\n                yet complete.\n             rangingAborted(3)\n                The CMTS has sent a Ranging Abort message to the CM.\n             rangingComplete(4)\n                The CMTS has sent a Ranging Complete message to the CM.\n             ipComplete(5)\n                The CMTS has received a DHCP reply message and\n                forwarded it to the CM.\n             registrationComplete(6)\n                The CMTS has sent a Registration Response message to\n                the CM.\n             accessDenied(7)\n                The CMTS has sent a Registration Aborted message\n                to the CM.\n             operational(8)\n                Value 8 is considered reserved and should not be defined\n                in future revisions of this MIB module to avoid conflict\n                with documented implementations that support value 8 to\n                indicate operational state after completing the BPI\n                initialization process.\n             registeredBPIInitializing(9)\n                Baseline Privacy (BPI) is enabled and the CMTS is in the\n                process of completing BPI initialization.  This state\n                MAY last for a significant length of time if failures\n                occur during the initialization process.  After\n                completion of BPI initialization, the CMTS will report\n                registrationComplete(6).\n             The CMTS only needs to report states it is able to\n             detect.')
docsIfCmtsCmStatusUnerroreds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 10), Counter32()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusUnerroreds.setDescription('Codewords received without error from this cable modem.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsCmStatusCorrecteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 11), Counter32()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusCorrecteds.setDescription('Codewords received with correctable errors from this\n             cable modem.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsCmStatusUncorrectables = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 12), Counter32()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusUncorrectables.setDescription('Codewords received with uncorrectable errors from this\n             cable modem.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsCmStatusSignalNoise = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 13), TenthdB()).setUnits('TenthdB').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusSignalNoise.setDescription('Signal/Noise ratio as perceived for upstream data from\n             this cable modem.\n             If the Signal/Noise is unknown, this object returns\n             a value of zero.')
docsIfCmtsCmStatusMicroreflections = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('-dBc').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusMicroreflections.setDescription('Total microreflections, including in-channel response\n             as perceived on this interface, measured in dBc below\n             the signal level.\n             This object is not assumed to return an absolutely\n             accurate value, but it gives a rough indication\n             of microreflections received on this interface.\n             It is up to the implementer to provide information\n             as accurately as possible.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsCmStatusExtUnerroreds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 15), Counter64()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusExtUnerroreds.setDescription('Codewords received without error from this cable modem.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsCmStatusExtCorrecteds = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 16), Counter64()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusExtCorrecteds.setDescription('Codewords received with correctable errors from this\n             cable modem.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsCmStatusExtUncorrectables = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 17), Counter64()).setUnits('codewords').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusExtUncorrectables.setDescription('Codewords received with uncorrectable errors from this\n             cable modem.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsCmStatusDocsisRegMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 18), DocsisQosVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusDocsisRegMode.setDescription('Indication of whether the CM has registered using 1.0\n                Class of Service or 1.1 Quality of Service.')
docsIfCmtsCmStatusModulationType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 19), DocsisUpstreamType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusModulationType.setDescription('Indicates modulation type currently used by the CM.  Since\n              this object specifically identifies PHY mode, the shared\n              type is not permitted.  If the upstream channel is\n              unknown, this object returns a value of zero.')
docsIfCmtsCmStatusInetAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 20), InetAddressType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusInetAddressType.setDescription('The type of internet address of\n                docsIfCmtsCmStatusInetAddress.  If the cable modem\n                internet address is unassigned or unknown, then the\n                value of this object is unknown(0).')
docsIfCmtsCmStatusInetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 21), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusInetAddress.setDescription('Internet address of this cable modem.  If the Cable\n                Modem has no Internet address assigned, or the Internet\n                address is unknown, the value of this object is the\n                zero-length OCTET STRING.  If the cable modem has\n                multiple Internet addresses, this object returns the\n                Internet address associated with the Cable\n                (i.e., RF MAC) interface.')
docsIfCmtsCmStatusValueLastUpdate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 22), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusValueLastUpdate.setDescription('The value of sysUpTime when docsIfCmtsCmStatusValue\n                was last updated.')
docsIfCmtsCmStatusHighResolutionTimingOffset = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 3, 1, 23), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmStatusHighResolutionTimingOffset.setDescription('A measure of the current round trip time for this CM.\n             Used for timing of CM upstream transmissions to ensure\n             synchronized arrivals at the CMTS.  Units are in terms\n             of (6.25 microseconds/(64*256)).  Returns zero if the value\n             is unknown.\n             This is the high resolution version of object\n             docsIfCmtsCmStatusTimingOffset, for channels requiring\n             finer resolution.')
docsIfCmtsServiceTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4), )
if mibBuilder.loadTexts: docsIfCmtsServiceTable.setDescription('Describes the attributes of upstream service queues\n             in a Cable Modem Termination System.')
docsIfCmtsServiceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IF-MIB", "docsIfCmtsServiceId"))
if mibBuilder.loadTexts: docsIfCmtsServiceEntry.setDescription('Describes the attributes of a single upstream bandwidth\n             service queue.\n             Entries in this table exist for each ifEntry with an\n             ifType of docsCableMaclayer(127), and for each service\n             queue (Service ID) within this MAC layer.\n             Entries in this table are created with the creation of\n             individual Service IDs by the MAC layer and removed\n             when a Service ID is removed.')
docsIfCmtsServiceId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,16383)))
if mibBuilder.loadTexts: docsIfCmtsServiceId.setDescription('Identifies a service queue for upstream bandwidth.  The\n             attributes of this service queue are shared between the\n             Cable Modem and the Cable Modem Termination System.\n             The CMTS allocates upstream bandwidth to this service\n             queue based on requests from the CM and on the class of\n             service associated with this queue.')
docsIfCmtsServiceCmStatusIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceCmStatusIndex.setDescription('Pointer to an entry in docsIfCmtsCmStatusTable identifying\n             the cable modem using this Service Queue.  If multiple\n             cable modems are using this Service Queue, the value of\n             this object is zero.\n             This object has been deprecated and replaced by\n             docsIfCmtsServiceNewCmStatusIndex, to fix a mismatch\n             of the value range with respect to docsIfCmtsCmStatusIndex\n             (1..2147483647).')
docsIfCmtsServiceAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ("destroyed", 3),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsServiceAdminStatus.setDescription('Allows a service class for a particular modem to be\n             suppressed, (re-)enabled, or deleted altogether.')
docsIfCmtsServiceQosProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16383))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceQosProfile.setDescription('The index in docsIfQosProfileTable describing the quality\n             of service attributes associated with this particular\n             service.  If no associated docsIfQosProfileTable entry\n             exists, this object returns a value of zero.')
docsIfCmtsServiceCreateTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceCreateTime.setDescription('The value of sysUpTime when this entry was created.')
docsIfCmtsServiceInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 6), Counter32()).setUnits('Bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceInOctets.setDescription('The cumulative number of Packet Data octets received\n             on this Service ID.  The count does not include the\n             size of the Cable MAC header.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsServiceInPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 7), Counter32()).setUnits('packets').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceInPackets.setDescription('The cumulative number of Packet Data packets received\n             on this Service ID.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsServiceNewCmStatusIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 4, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsServiceNewCmStatusIndex.setDescription('Pointer (via docsIfCmtsCmStatusIndex) to an entry in\n             docsIfCmtsCmStatusTable identifying the cable modem\n             using this Service Queue.  If multiple cable modems are\n             using this Service Queue, the value of this object is\n             zero.')
docsIfCmtsModulationTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5), )
if mibBuilder.loadTexts: docsIfCmtsModulationTable.setDescription('Describes a modulation profile associated with one or more\n             upstream channels.')
docsIfCmtsModulationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1), ).setIndexNames((0, "DOCS-IF-MIB", "docsIfCmtsModIndex"), (0, "DOCS-IF-MIB", "docsIfCmtsModIntervalUsageCode"))
if mibBuilder.loadTexts: docsIfCmtsModulationEntry.setDescription("Describes a modulation profile for an Interval Usage Code\n             for one or more upstream channels.\n             Entries in this table are created by the operator.\n\n             Initial default entries MAY be created at system\n             initialization time, which could report a value of\n             'permanent' or 'readOnly' for docsIfCmtsModStorageType.\n             A CMTS MAY reject the creation of additional Interval\n             Usage Codes for a modulation profile being defined at\n             Initialization time.\n             No individual objects have to be specified in order\n             to create an entry in this table.\n             Note that some objects do not have DEFVAL clauses\n             but do have calculated defaults and need not be specified\n             during row creation.")
docsIfCmtsModIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647)))
if mibBuilder.loadTexts: docsIfCmtsModIndex.setDescription('An index into the Channel Modulation table representing\n              a group of Interval Usage Codes, all associated with the\n              same channel.')
docsIfCmtsModIntervalUsageCode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 9, 10, 11,))).clone(namedValues=NamedValues(("request", 1), ("requestData", 2), ("initialRanging", 3), ("periodicRanging", 4), ("shortData", 5), ("longData", 6), ("advPhyShortData", 9), ("advPhyLongData", 10), ("ugs", 11),)))
if mibBuilder.loadTexts: docsIfCmtsModIntervalUsageCode.setDescription('An index into the Channel Modulation table that, when\n             grouped with other Interval Usage Codes, fully\n             instantiates all modulation sets for a given upstream\n             channel.')
docsIfCmtsModControl = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModControl.setDescription("Controls and reflects the status of rows in this table.\n             There is no restriction on the changing of values in this\n             table while their associated rows are active, with the\n             exception of:\n\n             1. If a modulation profile is being referenced by one\n                or more upstream channels, an attempt to set the value\n                of docsIfCmtsModChannelType returns an\n                'inconsistentValue' error.\n\n             2. If a modulation profile is being referenced by one\n                or more upstream channels, an attempt to set\n                docsIfCmtsModControl to destroy(6) or notInService(2)\n                returns an 'inconsistentValue' error.")
docsIfCmtsModType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7,))).clone(namedValues=NamedValues(("other", 1), ("qpsk", 2), ("qam16", 3), ("qam8", 4), ("qam32", 5), ("qam64", 6), ("qam128", 7),)).clone('qpsk')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModType.setDescription('The modulation type used on this channel.  Returns\n             other(1) if the modulation type is not\n             qpsk, qam16, qam8, qam32, qam64, or qam128.\n             Type qam128 is used for SCDMA channels only.\n             See the reference for the modulation profiles\n             implied by different modulation types.')
docsIfCmtsModPreambleLen = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,1536))).setUnits('bits').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModPreambleLen.setDescription('The preamble length for this modulation profile in bits.\n             Default value is the minimum needed by the implementation\n             at the CMTS for the given modulation profile.')
docsIfCmtsModDifferentialEncoding = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 6), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModDifferentialEncoding.setDescription('Specifies whether or not differential encoding is used\n             on this channel.')
docsIfCmtsModFECErrorCorrection = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16))).setUnits('Bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModFECErrorCorrection.setDescription('The number of correctable errored bytes (t) used in\n             forward error correction code.  The value of 0 indicates\n             that no correction is employed.  The number of check bytes\n             appended will be twice this value.')
docsIfCmtsModFECCodewordLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,255)).clone(32)).setUnits('Bytes').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModFECCodewordLength.setDescription('The number of data bytes (k) in the forward error\n             correction codeword.\n             This object is not used if docsIfCmtsModFECErrorCorrection\n             is zero.')
docsIfCmtsModScramblerSeed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,32767))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModScramblerSeed.setDescription('The 15-bit seed value for the scrambler polynomial.')
docsIfCmtsModMaxBurstSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('mini-slots').setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModMaxBurstSize.setDescription("The maximum number of mini-slots that can be transmitted\n             during this channel's burst time.  Returns zero if the\n             burst length is bounded by the allocation MAP rather than\n             by this profile.\n             Default value is 0, except for shortData, where it is 8.")
docsIfCmtsModGuardTimeSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 11), Unsigned32()).setUnits('Symbol-times').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsModGuardTimeSize.setDescription("The number of symbol-times that MUST follow the end of\n             this channel's burst.  Default value is the minimum time\n             needed by the implementation for this modulation profile.")
docsIfCmtsModLastCodewordShortened = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 12), TruthValue().clone('true')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModLastCodewordShortened.setDescription('Indicates whether the last FEC codeword is truncated.')
docsIfCmtsModScrambler = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 13), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModScrambler.setDescription('Indicates whether the scrambler is employed.')
docsIfCmtsModByteInterleaverDepth = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 14), Unsigned32().clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModByteInterleaverDepth.setDescription('ATDMA Byte Interleaver Depth (Ir).  This object returns 1\n             for non-ATDMA profiles.')
docsIfCmtsModByteInterleaverBlockSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 15), Unsigned32().clone(18)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModByteInterleaverBlockSize.setDescription('ATDMA Byte Interleaver Block size (Br).  This object\n             returns zero for non-ATDMA profiles ')
docsIfCmtsModPreambleType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 16), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(0, 1, 2,))).clone(namedValues=NamedValues(("unknown", 0), ("qpsk0", 1), ("qpsk1", 2),)).clone('qpsk0')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModPreambleType.setDescription("Preamble type for DOCSIS 2.0 bursts.  The value\n             'unknown(0)' represents a row entry consisting only of\n             DOCSIS 1.x bursts")
docsIfCmtsModTcmErrorCorrectionOn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 17), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModTcmErrorCorrectionOn.setDescription('Trellis Code Modulation (TCM) On/Off.  This value returns\n             false for non-S-CDMA profiles.')
docsIfCmtsModScdmaInterleaverStepSize = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 18), Unsigned32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(1,32),)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModScdmaInterleaverStepSize.setDescription(' S-CDMA Interleaver step size.  This value returns zero\n              for non-S-CDMA profiles.')
docsIfCmtsModScdmaSpreaderEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 19), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModScdmaSpreaderEnable.setDescription(' S-CDMA spreader.  This value returns false for non-S-CDMA\n              profiles.  Default value for IUC 3 and 4 is OFF; for\n              all other IUCs it is ON.')
docsIfCmtsModScdmaSubframeCodes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 20), Unsigned32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(1,128),)).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModScdmaSubframeCodes.setDescription(' S-CDMA sub-frame size.  This value returns zero\n              for non-S-CDMA profiles.')
docsIfCmtsModChannelType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 21), DocsisUpstreamType().clone('tdma')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: docsIfCmtsModChannelType.setDescription('Describes the modulation channel type for this modulation\n             entry.\n             All the active entries in a modulation profile (that is all\n             active entries that share a common docsIfCmtsModIndex)\n             MUST have the same value of docsIfCmtsModChannelType.')
docsIfCmtsModStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 5, 1, 22), StorageType().clone('nonVolatile')).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsModStorageType.setDescription('The storage type for this conceptual row.\n             Entries with this object set to permanent(4)\n             do not require write operations for read-write\n             objects.')
docsIfCmtsQosProfilePermissions = MibScalar((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 6), Bits().clone(namedValues=NamedValues(("createByManagement", 0), ("updateByManagement", 1), ("createByModems", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsQosProfilePermissions.setDescription("This object specifies permitted methods of creating\n             entries in docsIfQosProfileTable.\n             createByManagement(0) is set if entries can be created\n             using SNMP.  updateByManagement(1) is set if updating\n             entries using SNMP is permitted.  createByModems(2)\n             is set if entries can be created based on information\n             in REG-REQ MAC messages received from cable modems.\n             Information in this object is only applicable if\n             docsIfQosProfileTable is implemented as read-create.\n             Otherwise, this object is implemented as read-only\n             and returns createByModems(2).\n             Either createByManagement(0) or updateByManagement(1)\n             MUST be set when writing to this object.\n             Note that BITS objects are encoded most significant bit\n             first.  For example, if bit 2 is set, the value of this\n             object is the octet string '20'H.")
docsIfCmtsMacToCmTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 7), )
if mibBuilder.loadTexts: docsIfCmtsMacToCmTable.setDescription("This is a table to provide a quick access index into the\n             docsIfCmtsCmStatusTable.  There is exactly one row in this\n             table for each row in the docsIfCmtsCmStatusTable.  In\n             general, the management station SHOULD use this table only\n             to get a pointer into the docsIfCmtsCmStatusTable (which\n             corresponds to the CM's RF interface MAC address) and\n             SHOULD not iterate (e.g., GetNext through) this table.")
docsIfCmtsMacToCmEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 7, 1), ).setIndexNames((0, "DOCS-IF-MIB", "docsIfCmtsCmMac"))
if mibBuilder.loadTexts: docsIfCmtsMacToCmEntry.setDescription('A row in the docsIfCmtsMacToCmTable.\n             An entry in this table exists for each cable modem\n             that is connected to the CMTS implementing this table.')
docsIfCmtsCmMac = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 7, 1, 1), MacAddress())
if mibBuilder.loadTexts: docsIfCmtsCmMac.setDescription('The RF side MAC address for the referenced CM (e.g., the\n             interface on the CM that has docsCableMacLayer(127) as\n             its ifType).')
docsIfCmtsCmPtr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 7, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsCmPtr.setDescription("An row index into docsIfCmtsCmStatusTable.  When queried\n             with the correct instance value (e.g., a CM's MAC address),\n             returns the index in docsIfCmtsCmStatusTable that\n             represents that CM.")
docsIfCmtsChannelUtilizationInterval = MibScalar((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,86400))).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: docsIfCmtsChannelUtilizationInterval.setDescription('The time interval in seconds over which the channel\n             utilization index is calculated.  All upstream/downstream\n             channels use the same\n             docsIfCmtsChannelUtilizationInterval.\n             Setting a value of zero disables utilization reporting.\n             A channel utilization index is calculated over a fixed\n             window applying to the most recent\n             docsIfCmtsChannelUtilizationInterval.  It would therefore\n             be prudent to use a relatively short\n             docsIfCmtsChannelUtilizationInterval.\n             It is a vendor decision whether to reset the timer when\n             docsIfCmtsChannelUtilizationInterval is changed during a\n             utilization sampling period.')
docsIfCmtsChannelUtilizationTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 9), )
if mibBuilder.loadTexts: docsIfCmtsChannelUtilizationTable.setDescription('Reports utilization statistics for attached upstream and\n             downstream physical channels.')
docsIfCmtsChannelUtilizationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 9, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "DOCS-IF-MIB", "docsIfCmtsChannelUtIfType"), (0, "DOCS-IF-MIB", "docsIfCmtsChannelUtId"))
if mibBuilder.loadTexts: docsIfCmtsChannelUtilizationEntry.setDescription('Utilization statistics for a single upstream or downstream\n             physical channel.  An entry exists in this table for each\n             ifEntry with an ifType equal to\n             docsCableDownstream (128)\n             or docsCableUpstream (129).')
docsIfCmtsChannelUtIfType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 9, 1, 1), IANAifType())
if mibBuilder.loadTexts: docsIfCmtsChannelUtIfType.setDescription('The secondary index into this table.  Indicates the IANA\n             interface type associated with this physical channel.\n             Only docsCableDownstream (128) and\n             docsCableUpstream (129) are valid.')
docsIfCmtsChannelUtId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 9, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255)))
if mibBuilder.loadTexts: docsIfCmtsChannelUtId.setDescription('The tertiary index into this table.  Indicates the CMTS\n              identifier for this physical channel.')
docsIfCmtsChannelUtUtilization = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 9, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,100))).setUnits('percent').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsChannelUtUtilization.setDescription('The calculated and truncated utilization index for this\n             physical upstream or downstream channel, accurate as of\n             the most recent docsIfCmtsChannelUtilizationInterval.\n\n             Upstream Channel Utilization Index:\n\n             The upstream channel utilization index is expressed as a\n             percentage of mini-slots utilized on the physical channel,\n             regardless of burst type.  For an Initial Maintenance\n             region, the mini-slots for the complete region are\n             considered utilized if the CMTS received an upstream\n             burst within the region from any CM on the physical\n             channel.  For contention REQ and REQ/DATA regions, the\n             mini-slots for a transmission opportunity within the\n             region are considered utilized if the CMTS received an\n             upstream burst within the opportunity from any CM on the\n             physical channel.  For all other regions, utilized\n             mini-slots are those in which the CMTS granted\n             bandwidth to any unicast SID on the physical channel.\n\n             For an upstream interface that has multiple logical\n             upstream channels enabled, the utilization index is a\n             weighted sum of utilization indices for the logical\n             channels.  The weight for each utilization index is the\n             percentage of upstream mini-slots allocated for the\n             corresponding logical channel.\n             Example:\n             If 75% of bandwidth is allocated to the first logical\n             channel and 25% to the second, and the utilization\n             indices for each are 60 and 40, respectively, the\n             utilization index for the upstream physical channel is\n             (60 * 0.75) + (40 * 0.25) = 55.  This figure\n             applies to the most recent utilization interval.\n\n             Downstream Channel Utilization Index:\n\n             The downstream channel utilization index is a percentage\n             expressing the ratio between bytes used to transmit data\n             versus the total number of bytes transmitted in the raw\n             bandwidth of the MPEG channel.  As with the upstream\n             utilization index, the calculated value represents\n             the most recent utilization interval.\n             Formula:\n             Downstream utilization index =\n             (100 * (data bytes / raw bytes))\n\n             Definitions:\n             Data bytes:    Number of bytes transmitted as data in the\n                            docsIfCmtsChannelUtilizationInterval.\n                            Identical to docsIfCmtsDownChannelCtrUsed\n                            Bytes measured over the utilization\n                            interval.\n             Raw bandwidth: Total number of bytes available for\n                            transmitting data, not including bytes\n                            used for headers and other overhead.\n             Raw bytes:     (raw bandwidth *\n                            docsIfCmtsChannelUtilizationInterval).\n                            Identical to docsIfCmtsDownChannelCtrTotal\n                            Bytes measured over the utilization\n                            interval.')
docsIfCmtsDownChannelCounterTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10), )
if mibBuilder.loadTexts: docsIfCmtsDownChannelCounterTable.setDescription('This table is implemented at the CMTS to collect\n             downstream channel statistics for utilization\n             calculations.')
docsIfCmtsDownChannelCounterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmtsDownChannelCounterEntry.setDescription('An entry provides a list of traffic counters for a single\n             downstream channel.\n             An entry in this table exists for each ifEntry with an\n             ifType of docsCableDownstream(128).')
docsIfCmtsDownChnlCtrId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsDownChnlCtrId.setDescription('The Cable Modem Termination System identification\n             of the downstream channel within this particular MAC\n             interface.  If the interface is down, the object returns\n             the most current value.  If the downstream channel ID is\n             unknown, this object returns a value of 0.')
docsIfCmtsDownChnlCtrTotalBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1, 2), Counter32()).setUnits('Bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsDownChnlCtrTotalBytes.setDescription('At the CMTS, the total number of bytes in the Payload\n             portion of MPEG Packets (i.e., not including MPEG header\n             or pointer_field) transported by this downstream channel.\n             This is the 32-bit version of\n             docsIfCmtsDownChnlCtrExtTotalBytes, included to provide\n             back compatibility with SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsDownChnlCtrUsedBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1, 3), Counter32()).setUnits('Bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsDownChnlCtrUsedBytes.setDescription('At the CMTS, the total number of DOCSIS data bytes\n             transported by this downstream channel.\n             The number of data bytes is defined as the total number\n             of bytes transported in DOCSIS payloads minus the number\n             of stuff bytes transported in DOCSIS payloads.\n             This is the 32-bit version of\n             docsIfCmtsDownChnlCtrExtUsedBytes, included to provide\n             back compatibility with SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsDownChnlCtrExtTotalBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1, 4), Counter64()).setUnits('Bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsDownChnlCtrExtTotalBytes.setDescription('At the CMTS, the total number of bytes in the Payload\n             portion of MPEG Packets (i.e., not including MPEG header\n             or pointer_field) transported by this downstream\n             channel.\n             This is the 64-bit version of\n             docsIfCmtsDownChnlCtrTotalBytes and will not be\n             accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsDownChnlCtrExtUsedBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 10, 1, 5), Counter64()).setUnits('Bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsDownChnlCtrExtUsedBytes.setDescription('At the CMTS, the total number of DOCSIS data bytes\n             transported by this downstream channel.  The number\n             of data bytes is defined as the total number of bytes\n             transported in DOCSIS payloads minus the number of\n             stuff bytes transported in DOCSIS payloads.\n             This is the 64-bit version of\n             docsIfCmtsDownChnlCtrUsedBytes and will not be accessible\n             to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChannelCounterTable = MibTable((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11), )
if mibBuilder.loadTexts: docsIfCmtsUpChannelCounterTable.setDescription('This table is implemented at the CMTS to provide upstream\n             channel statistics appropriate for channel utilization\n             calculations.')
docsIfCmtsUpChannelCounterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: docsIfCmtsUpChannelCounterEntry.setDescription('List of traffic statistics for a single upstream channel.\n             For DOCSIS 2.0 CMTSs, an entry in this table\n             exists for each ifEntry with an ifType of\n             docsCableUpstreamChannel (205).\n             For DOCSIS 1.x CMTSs, an entry in this table\n             exists for each ifEntry with an ifType of\n             docsCableUpstream (129).')
docsIfCmtsUpChnlCtrId = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrId.setDescription('The CMTS identification of the upstream channel.')
docsIfCmtsUpChnlCtrTotalMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 2), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrTotalMslots.setDescription('Current count, from CMTS initialization, of all mini-slots\n             defined for this upstream logical channel.  This count\n             includes all IUCs and SIDs, even those allocated to the\n             NULL SID for a 2.0 logical channel that is inactive.  This\n             is the 32-bit version of docsIfCmtsUpChnlCtrExtTotalMslots\n             and is included for back compatibility with SNMPv1\n             managers.  Support for this object is mandatory.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrUcastGrantedMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 3), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrUcastGrantedMslots.setDescription("Current count, from CMTS initialization, of unicast\n             granted mini-slots on the upstream logical channel,\n             regardless of burst type.  Unicast granted mini-slots are\n             those in which the CMTS assigned bandwidth to any unicast\n             SID on the logical channel.  However, this object does not\n             include minis-lots for reserved IUCs, or grants to SIDs\n             designated as meaning 'no CM'.  This is the 32-bit version\n             of docsIfCmtsUpChnlCtrExtUcastGrantedMslots, and is\n             included for back compatibility with SNMPv1 managers.\n             Support for this object is mandatory.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrTotalCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 4), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrTotalCntnMslots.setDescription('Current count, from CMTS initialization, of contention\n             mini-slots defined for this upstream logical channel.  This\n             count includes all mini-slots assigned to a broadcast or\n             multicast SID on the logical channel.  This is the 32-bit\n             version of docsIfCmtsUpChnlCtrExtTotalCntnMslots, and is\n             included for back compatibility with SNMPv1 managers.\n             Support for this object is mandatory.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrUsedCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 5), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrUsedCntnMslots.setDescription('Current count, from CMTS initialization, of contention\n             mini-slots utilized on the upstream logical channel.  For\n             contention regions, utilized mini-slots are those in which\n             the CMTS correctly received an upstream burst from any CM\n             on the upstream logical channel.  This is the 32-bit\n             version of docsIfCmtsUpChnlCtrExtUsedCntnMslots and is\n             included for back compatibility with SNMPv1 managers.\n             Support for this object is mandatory.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtTotalMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 6), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtTotalMslots.setDescription('Current count, from CMTS initialization, of all mini-slots\n             defined for this upstream logical channel.  This count\n             includes all IUCs and SIDs, even those allocated to the\n             NULL SID for a 2.0 logical channel that is inactive.  This\n             is the 64-bit version of docsIfCmtsUpChnlCtrTotalMslots\n             and will not be accessible to SNMPv1 managers.\n             Support for this object is mandatory.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtUcastGrantedMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 7), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtUcastGrantedMslots.setDescription("Current count, from CMTS initialization, of unicast\n             granted mini-slots on the upstream logical channel,\n             regardless of burst type.  Unicast granted mini-slots are\n             those in which the CMTS assigned bandwidth to any unicast\n             SID on the logical channel.  However, this object does not\n             include mini-slots for reserved IUCs, or grants to SIDs\n             designated as meaning 'no CM'.  This is the 64-bit version\n             of docsIfCmtsUpChnlCtrUcastGrantedMslots and will not be\n             accessible to SNMPv1 managers.\n             Support for this object is mandatory.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.")
docsIfCmtsUpChnlCtrExtTotalCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 8), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtTotalCntnMslots.setDescription('Current count, from CMTS initialization, of contention\n             mini-slots defined for this upstream logical channel.  This\n             count includes all mini-slots assigned to a broadcast or\n             multicast SID on the logical channel.  This is the 64-bit\n             version of docsIfCmtsUpChnlCtrTotalCntnMslots and will\n             not be accessible to SNMPv1 managers.\n             Support for this object is mandatory.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtUsedCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 9), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtUsedCntnMslots.setDescription('Current count, from CMTS initialization, of contention\n             mini-slots utilized on the upstream logical channel.  For\n             contention regions, utilized mini-slots are those in which\n             the CMTS correctly received an upstream burst from any CM\n             on the upstream logical channel.  This is the 64-bit\n             version of docsIfCmtsUpChnlCtrUsedCntnMslots and will not\n             be accessible to SNMPv1 managers.\n             Support for this object is mandatory.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrCollCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 10), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrCollCntnMslots.setDescription('Current count, from CMTS initialization, of contention\n             mini-slots subjected to collisions on the upstream logical\n             channel.  For contention regions, these are the mini-slots\n             applicable to bursts that the CMTS detected but could not\n             correctly receive.  This is the 32-bit version of\n             docsIfCmtsUpChnlCtrExtCollCntnMslots and is included for\n             back compatibility with SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrTotalCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 11), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrTotalCntnReqMslots.setDescription('Current count, from CMTS initialization, of contention\n             request mini-slots defined for this upstream logical\n             channel.  This count includes all mini-slots for IUC1\n             assigned to a broadcast or multicast SID on the logical\n             channel.  This is the 32-bit version of\n             docsIfCmtsUpChnlCtrExtTotalCntnReqMslots and is included\n             for back compatibility with SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrUsedCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 12), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrUsedCntnReqMslots.setDescription('Current count, from CMTS initialization, of contention\n             request mini-slots utilized on this upstream logical\n             channel.  This count includes all contention mini-slots for\n             IUC1 applicable to bursts that the CMTS correctly\n             received.  This is the 32-bit version of\n             docsIfCmtsUpChnlCtrExtUsedCntnReqMslots and is included\n             for back compatibility with SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrCollCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 13), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrCollCntnReqMslots.setDescription('Current count, from CMTS initialization, of contention\n             request mini-slots subjected to collisions on this upstream\n             logical channel.  This includes all contention mini-slots\n             for IUC1 applicable to bursts that the CMTS detected but\n             could not correctly receive.  This is the 32-bit version of\n             docsIfCmtsUpChnlCtrExtCollCntnReqMslots and is included\n             for back compatibility with SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrTotalCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 14), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrTotalCntnReqDataMslots.setDescription('Current count, from CMTS initialization, of contention\n             request data mini-slots defined for this upstream logical\n             channel.  This count includes all mini-slots for IUC2\n             assigned to a broadcast or multicast SID on the logical\n             channel.  This is the 32-bit version of\n             docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots and is\n             included for back compatibility with SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrUsedCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 15), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrUsedCntnReqDataMslots.setDescription('Current count, from CMTS initialization, of contention\n             request data mini-slots utilized on this upstream logical\n             channel.  This includes all contention mini-slots for IUC2\n             applicable to bursts that the CMTS correctly received.\n             This is the 32-bit version of\n             docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots and is\n             included for back compatibility with SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrCollCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 16), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrCollCntnReqDataMslots.setDescription('Current count, from CMTS initialization, of contention\n             request data mini-slots subjected to collisions on this\n             upstream logical channel.  This includes all contention\n             mini-slots for IUC2 applicable to bursts that the CMTS\n             detected, but could not correctly receive.  This is the\n             32-bit version of\n             docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots and is\n             included for back compatibility with SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 17), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots.setDescription('Current count, from CMTS initialization, of contention\n             initial maintenance mini-slots defined for this upstream\n             logical channel.  This includes all mini-slots for IUC3\n             assigned to a broadcast or multicast SID on the logical\n             channel.  This is the 32-bit version of\n             docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots\n             and is included for back compatibility with SNMPv1\n             managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots.setDescription('Current count, from CMTS initialization, of contention\n             initial maintenance mini-slots utilized on this upstream\n             logical channel.  This includes all contention mini-slots\n             for IUC3 applicable to bursts that the CMTS correctly\n             received.  This is the 32-bit version of\n             docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots\n             and is included for back compatibility with SNMPv1\n             managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrCollCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 19), Counter32()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrCollCntnInitMaintMslots.setDescription('Current count, from CMTS initialization, of contention\n             initial maintenance mini-slots subjected to collisions on\n             this upstream logical channel.  This includes all\n             contention mini-slots for IUC3 applicable to bursts that\n             the CMTS detected, but could not correctly receive.\n             This is the 32-bit version of\n             docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots\n             and is included for back compatibility with SNMPv1\n             managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtCollCntnMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 20), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtCollCntnMslots.setDescription('Current count, from CMTS initialization, of collision\n             contention mini-slots on the upstream logical channel.\n             For contention regions, these are the mini-slots applicable\n             to bursts that the CMTS detected, but could not correctly\n             receive.  This is the 64-bit version of\n             docsIfCmtsUpChnlCtrCollCntnMslots and will not be\n             accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtTotalCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 21), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtTotalCntnReqMslots.setDescription('Current count, from CMTS initialization, of contention\n             request mini-slots defined for this upstream logical\n             channel.  This count includes all mini-slots for IUC1\n             assigned to a broadcast or multicast SID on the logical\n             channel.  This is the 64-bit version of\n             docsIfCmtsUpChnlCtrTotalCntnReqMslots and will not be\n             accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtUsedCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 22), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtUsedCntnReqMslots.setDescription('Current count, from CMTS initialization, of contention\n             request mini-slots utilized on this upstream logical\n             channel.  This count includes all contention mini-slots for\n             IUC1 applicable to bursts that the CMTS correctly\n             received.  This is the 64-bit version of\n             docsIfCmtsUpChnlCtrUsedCntnReqMslots and will not be\n             accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtCollCntnReqMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 23), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtCollCntnReqMslots.setDescription('Current count, from CMTS initialization, of contention\n             request mini-slots subjected to collisions on this upstream\n             logical channel.  This includes all contention mini-slots\n             for IUC1 applicable to bursts that the CMTS detected,\n             but could not correctly receive.  This is the 64-bit\n             version of docsIfCmtsUpChnlCtrCollCntnReqMslots and will\n             not be accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 24), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots.setDescription('Current count, from CMTS initialization, of contention\n             request data mini-slots defined for this upstream logical\n             channel.  This count includes all mini-slots for IUC2\n             assigned to a broadcast or multicast SID on the logical\n             channel.  This is the 64-bit version of\n             docsIfCmtsUpChnlCtrTotalCntnReqDataMslots and will not be\n             accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 25), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots.setDescription('Current count, from CMTS initialization, of contention\n             request data mini-slots utilized on this upstream logical\n             channel.  This includes all contention mini-slots for IUC2\n             applicable to bursts that the CMTS correctly received.\n             This is the 64-bit version of\n             docsIfCmtsUpChnlCtrUsedCntnReqDataMslots and will not be\n             accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 26), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots.setDescription('Current count, from CMTS initialization, of contention\n             request data mini-slots subjected to collisions on this\n             upstream logical channel.  This includes all contention\n             mini-slots for IUC2 applicable to bursts that the CMTS\n             detected, but could not correctly receive.  This is the\n             64-bit version of\n             docsIfCmtsUpChnlCtrCollCntnReqDataMslots\n             and will not be accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 27), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots.setDescription('Current count, from CMTS initialization, of initial\n             maintenance mini-slots defined for this upstream logical\n             channel.  This count includes all mini-slots for IUC3\n             assigned to a broadcast or multicast SID on the logical\n             channel.  This is the 64-bit version of\n             docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots\n             and will not be accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 28), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots.setDescription('Current count, from CMTS initialization, of initial\n             maintenance mini-slots utilized on this upstream logical\n             channel.  This includes all contention mini-slots for IUC3\n             applicable to bursts that the CMTS correctly received.\n             This is the 64-bit version of\n             docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots\n             and will not be accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 127, 1, 3, 11, 1, 29), Counter64()).setUnits('mini-slots').setMaxAccess("readonly")
if mibBuilder.loadTexts: docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots.setDescription('Current count, from CMTS initialization, of contention\n             initial maintenance mini-slots subjected to collisions on\n             this upstream logical channel.  This includes all\n             contention mini-slots for IUC3 applicable to bursts that\n             the CMTS detected, but could not correctly receive.\n             This is the 64-bit version of\n             docsIfCmtsUpChnlCtrCollCntnInitMaintMslots and will not\n             be accessible to SNMPv1 managers.\n             Discontinuities in the value of this counter can occur\n             at reinitialization of the managed system, and at other\n             times as indicated by the value of\n             ifCounterDiscontinuityTime for the associated ifIndex.')
docsIfNotification = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 2))
docsIfConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 3))
docsIfCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 3, 1))
docsIfGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 127, 3, 2))
docsIfBasicCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 127, 3, 1, 1)).setObjects(*(("DOCS-IF-MIB", "docsIfBasicGroup"), ("DOCS-IF-MIB", "docsIfCmGroup"), ("DOCS-IF-MIB", "docsIfCmtsGroup"),))
if mibBuilder.loadTexts: docsIfBasicCompliance.setDescription('The compliance statement for devices that implement\n             DOCSIS 1.x compliant Radio Frequency Interfaces.')
docsIfBasicComplianceV2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 127, 3, 1, 2)).setObjects(*(("DOCS-IF-MIB", "docsIfBasicGroupV2"), ("DOCS-IF-MIB", "docsIfCmGroupV2"), ("DOCS-IF-MIB", "docsIfCmtsGroupV2"),))
if mibBuilder.loadTexts: docsIfBasicComplianceV2.setDescription('The compliance statement for devices that implement\n             DOCSIS 2.0 Radio Frequency Interfaces.')
docsIfBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 1)).setObjects(*(("DOCS-IF-MIB", "docsIfDownChannelId"), ("DOCS-IF-MIB", "docsIfDownChannelFrequency"), ("DOCS-IF-MIB", "docsIfDownChannelWidth"), ("DOCS-IF-MIB", "docsIfDownChannelModulation"), ("DOCS-IF-MIB", "docsIfDownChannelInterleave"), ("DOCS-IF-MIB", "docsIfDownChannelPower"), ("DOCS-IF-MIB", "docsIfUpChannelId"), ("DOCS-IF-MIB", "docsIfUpChannelFrequency"), ("DOCS-IF-MIB", "docsIfUpChannelWidth"), ("DOCS-IF-MIB", "docsIfUpChannelModulationProfile"), ("DOCS-IF-MIB", "docsIfUpChannelSlotSize"), ("DOCS-IF-MIB", "docsIfUpChannelTxTimingOffset"), ("DOCS-IF-MIB", "docsIfUpChannelRangingBackoffStart"), ("DOCS-IF-MIB", "docsIfUpChannelRangingBackoffEnd"), ("DOCS-IF-MIB", "docsIfUpChannelTxBackoffStart"), ("DOCS-IF-MIB", "docsIfUpChannelTxBackoffEnd"), ("DOCS-IF-MIB", "docsIfQosProfPriority"), ("DOCS-IF-MIB", "docsIfQosProfMaxUpBandwidth"), ("DOCS-IF-MIB", "docsIfQosProfGuarUpBandwidth"), ("DOCS-IF-MIB", "docsIfQosProfMaxDownBandwidth"), ("DOCS-IF-MIB", "docsIfQosProfMaxTxBurst"), ("DOCS-IF-MIB", "docsIfQosProfBaselinePrivacy"), ("DOCS-IF-MIB", "docsIfQosProfStatus"), ("DOCS-IF-MIB", "docsIfSigQIncludesContention"), ("DOCS-IF-MIB", "docsIfSigQUnerroreds"), ("DOCS-IF-MIB", "docsIfSigQCorrecteds"), ("DOCS-IF-MIB", "docsIfSigQUncorrectables"), ("DOCS-IF-MIB", "docsIfSigQSignalNoise"), ("DOCS-IF-MIB", "docsIfSigQMicroreflections"), ("DOCS-IF-MIB", "docsIfSigQEqualizationData"),))
if mibBuilder.loadTexts: docsIfBasicGroup.setDescription('Group of objects implemented in both cable modems and\n             cable modem termination systems.')
docsIfCmGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 2)).setObjects(*(("DOCS-IF-MIB", "docsIfCmCmtsAddress"), ("DOCS-IF-MIB", "docsIfCmCapabilities"), ("DOCS-IF-MIB", "docsIfCmRangingTimeout"), ("DOCS-IF-MIB", "docsIfCmStatusValue"), ("DOCS-IF-MIB", "docsIfCmStatusCode"), ("DOCS-IF-MIB", "docsIfCmStatusTxPower"), ("DOCS-IF-MIB", "docsIfCmStatusResets"), ("DOCS-IF-MIB", "docsIfCmStatusLostSyncs"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidMaps"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidUcds"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidRangingResponses"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidRegistrationResponses"), ("DOCS-IF-MIB", "docsIfCmStatusT1Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusT2Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusT3Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusT4Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusRangingAborteds"), ("DOCS-IF-MIB", "docsIfCmServiceQosProfile"), ("DOCS-IF-MIB", "docsIfCmServiceTxSlotsImmed"), ("DOCS-IF-MIB", "docsIfCmServiceTxSlotsDed"), ("DOCS-IF-MIB", "docsIfCmServiceTxRetries"), ("DOCS-IF-MIB", "docsIfCmServiceTxExceededs"), ("DOCS-IF-MIB", "docsIfCmServiceRqRetries"), ("DOCS-IF-MIB", "docsIfCmServiceRqExceededs"),))
if mibBuilder.loadTexts: docsIfCmGroup.setDescription('Group of objects implemented in cable modems.')
docsIfCmtsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 3)).setObjects(*(("DOCS-IF-MIB", "docsIfCmtsCapabilities"), ("DOCS-IF-MIB", "docsIfCmtsSyncInterval"), ("DOCS-IF-MIB", "docsIfCmtsUcdInterval"), ("DOCS-IF-MIB", "docsIfCmtsMaxServiceIds"), ("DOCS-IF-MIB", "docsIfCmtsInvitedRangingAttempts"), ("DOCS-IF-MIB", "docsIfCmtsInsertInterval"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidRangeReqs"), ("DOCS-IF-MIB", "docsIfCmtsStatusRangingAborteds"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidRegReqs"), ("DOCS-IF-MIB", "docsIfCmtsStatusFailedRegReqs"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidDataReqs"), ("DOCS-IF-MIB", "docsIfCmtsStatusT5Timeouts"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusMacAddress"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusIpAddress"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusDownChannelIfIndex"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUpChannelIfIndex"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusRxPower"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusTimingOffset"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusEqualizationData"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusValue"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUnerroreds"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusCorrecteds"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUncorrectables"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusSignalNoise"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusMicroreflections"), ("DOCS-IF-MIB", "docsIfCmtsServiceCmStatusIndex"), ("DOCS-IF-MIB", "docsIfCmtsServiceAdminStatus"), ("DOCS-IF-MIB", "docsIfCmtsServiceQosProfile"), ("DOCS-IF-MIB", "docsIfCmtsServiceCreateTime"), ("DOCS-IF-MIB", "docsIfCmtsServiceInOctets"), ("DOCS-IF-MIB", "docsIfCmtsServiceInPackets"), ("DOCS-IF-MIB", "docsIfCmtsModType"), ("DOCS-IF-MIB", "docsIfCmtsModControl"), ("DOCS-IF-MIB", "docsIfCmtsModPreambleLen"), ("DOCS-IF-MIB", "docsIfCmtsModDifferentialEncoding"), ("DOCS-IF-MIB", "docsIfCmtsModFECErrorCorrection"), ("DOCS-IF-MIB", "docsIfCmtsModFECCodewordLength"), ("DOCS-IF-MIB", "docsIfCmtsModScramblerSeed"), ("DOCS-IF-MIB", "docsIfCmtsModMaxBurstSize"), ("DOCS-IF-MIB", "docsIfCmtsModGuardTimeSize"), ("DOCS-IF-MIB", "docsIfCmtsModLastCodewordShortened"), ("DOCS-IF-MIB", "docsIfCmtsModScrambler"), ("DOCS-IF-MIB", "docsIfCmtsQosProfilePermissions"), ("DOCS-IF-MIB", "docsIfCmtsCmPtr"),))
if mibBuilder.loadTexts: docsIfCmtsGroup.setDescription('Group of objects implemented in Cable Modem Termination\n             Systems.')
docsIfObsoleteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 4)).setObjects(*(("DOCS-IF-MIB", "docsIfCmRangingRespTimeout"), ("DOCS-IF-MIB", "docsIfCmtsInsertionInterval"),))
if mibBuilder.loadTexts: docsIfObsoleteGroup.setDescription('Group of objects obsoleted.')
docsIfBasicGroupV2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 5)).setObjects(*(("DOCS-IF-MIB", "docsIfDownChannelId"), ("DOCS-IF-MIB", "docsIfDownChannelFrequency"), ("DOCS-IF-MIB", "docsIfDownChannelWidth"), ("DOCS-IF-MIB", "docsIfDownChannelModulation"), ("DOCS-IF-MIB", "docsIfDownChannelInterleave"), ("DOCS-IF-MIB", "docsIfDownChannelPower"), ("DOCS-IF-MIB", "docsIfDownChannelAnnex"), ("DOCS-IF-MIB", "docsIfUpChannelId"), ("DOCS-IF-MIB", "docsIfUpChannelFrequency"), ("DOCS-IF-MIB", "docsIfUpChannelWidth"), ("DOCS-IF-MIB", "docsIfUpChannelModulationProfile"), ("DOCS-IF-MIB", "docsIfUpChannelSlotSize"), ("DOCS-IF-MIB", "docsIfUpChannelTxTimingOffset"), ("DOCS-IF-MIB", "docsIfUpChannelRangingBackoffStart"), ("DOCS-IF-MIB", "docsIfUpChannelRangingBackoffEnd"), ("DOCS-IF-MIB", "docsIfUpChannelTxBackoffStart"), ("DOCS-IF-MIB", "docsIfUpChannelTxBackoffEnd"), ("DOCS-IF-MIB", "docsIfUpChannelScdmaActiveCodes"), ("DOCS-IF-MIB", "docsIfUpChannelScdmaCodesPerSlot"), ("DOCS-IF-MIB", "docsIfUpChannelScdmaFrameSize"), ("DOCS-IF-MIB", "docsIfUpChannelScdmaHoppingSeed"), ("DOCS-IF-MIB", "docsIfUpChannelType"), ("DOCS-IF-MIB", "docsIfUpChannelCloneFrom"), ("DOCS-IF-MIB", "docsIfUpChannelUpdate"), ("DOCS-IF-MIB", "docsIfUpChannelStatus"), ("DOCS-IF-MIB", "docsIfUpChannelPreEqEnable"), ("DOCS-IF-MIB", "docsIfQosProfPriority"), ("DOCS-IF-MIB", "docsIfQosProfMaxUpBandwidth"), ("DOCS-IF-MIB", "docsIfQosProfGuarUpBandwidth"), ("DOCS-IF-MIB", "docsIfQosProfMaxDownBandwidth"), ("DOCS-IF-MIB", "docsIfQosProfBaselinePrivacy"), ("DOCS-IF-MIB", "docsIfQosProfStatus"), ("DOCS-IF-MIB", "docsIfQosProfMaxTransmitBurst"), ("DOCS-IF-MIB", "docsIfSigQIncludesContention"), ("DOCS-IF-MIB", "docsIfSigQUnerroreds"), ("DOCS-IF-MIB", "docsIfSigQCorrecteds"), ("DOCS-IF-MIB", "docsIfSigQUncorrectables"), ("DOCS-IF-MIB", "docsIfSigQSignalNoise"), ("DOCS-IF-MIB", "docsIfSigQMicroreflections"), ("DOCS-IF-MIB", "docsIfSigQExtUnerroreds"), ("DOCS-IF-MIB", "docsIfSigQExtCorrecteds"), ("DOCS-IF-MIB", "docsIfSigQExtUncorrectables"), ("DOCS-IF-MIB", "docsIfDocsisBaseCapability"),))
if mibBuilder.loadTexts: docsIfBasicGroupV2.setDescription('Group of objects implemented in both cable modems and\n             cable modem termination systems.')
docsIfCmGroupV2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 6)).setObjects(*(("DOCS-IF-MIB", "docsIfCmCmtsAddress"), ("DOCS-IF-MIB", "docsIfCmCapabilities"), ("DOCS-IF-MIB", "docsIfCmRangingTimeout"), ("DOCS-IF-MIB", "docsIfCmStatusValue"), ("DOCS-IF-MIB", "docsIfCmStatusCode"), ("DOCS-IF-MIB", "docsIfCmStatusTxPower"), ("DOCS-IF-MIB", "docsIfCmStatusResets"), ("DOCS-IF-MIB", "docsIfCmStatusLostSyncs"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidMaps"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidUcds"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidRangingResponses"), ("DOCS-IF-MIB", "docsIfCmStatusInvalidRegistrationResponses"), ("DOCS-IF-MIB", "docsIfCmStatusT1Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusT2Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusT3Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusT4Timeouts"), ("DOCS-IF-MIB", "docsIfCmStatusRangingAborteds"), ("DOCS-IF-MIB", "docsIfCmStatusDocsisOperMode"), ("DOCS-IF-MIB", "docsIfCmStatusModulationType"), ("DOCS-IF-MIB", "docsIfCmStatusEqualizationData"), ("DOCS-IF-MIB", "docsIfCmStatusUCCs"), ("DOCS-IF-MIB", "docsIfCmStatusUCCFails"), ("DOCS-IF-MIB", "docsIfCmServiceQosProfile"), ("DOCS-IF-MIB", "docsIfCmServiceTxSlotsImmed"), ("DOCS-IF-MIB", "docsIfCmServiceTxSlotsDed"), ("DOCS-IF-MIB", "docsIfCmServiceTxRetries"), ("DOCS-IF-MIB", "docsIfCmServiceTxExceededs"), ("DOCS-IF-MIB", "docsIfCmServiceRqRetries"), ("DOCS-IF-MIB", "docsIfCmServiceRqExceededs"), ("DOCS-IF-MIB", "docsIfCmServiceExtTxSlotsImmed"), ("DOCS-IF-MIB", "docsIfCmServiceExtTxSlotsDed"), ("DOCS-IF-MIB", "docsIfSigQEqualizationData"),))
if mibBuilder.loadTexts: docsIfCmGroupV2.setDescription('Group of objects implemented in cable modems.')
docsIfCmtsGroupV2 = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 127, 3, 2, 7)).setObjects(*(("DOCS-IF-MIB", "docsIfCmtsCapabilities"), ("DOCS-IF-MIB", "docsIfCmtsSyncInterval"), ("DOCS-IF-MIB", "docsIfCmtsUcdInterval"), ("DOCS-IF-MIB", "docsIfCmtsMaxServiceIds"), ("DOCS-IF-MIB", "docsIfCmtsInvitedRangingAttempts"), ("DOCS-IF-MIB", "docsIfCmtsInsertInterval"), ("DOCS-IF-MIB", "docsIfCmtsMacStorageType"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidRangeReqs"), ("DOCS-IF-MIB", "docsIfCmtsStatusRangingAborteds"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidRegReqs"), ("DOCS-IF-MIB", "docsIfCmtsStatusFailedRegReqs"), ("DOCS-IF-MIB", "docsIfCmtsStatusInvalidDataReqs"), ("DOCS-IF-MIB", "docsIfCmtsStatusT5Timeouts"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusMacAddress"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusDownChannelIfIndex"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUpChannelIfIndex"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusRxPower"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusTimingOffset"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusEqualizationData"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusValue"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUnerroreds"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusCorrecteds"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusUncorrectables"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusSignalNoise"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusMicroreflections"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusExtUnerroreds"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusExtCorrecteds"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusExtUncorrectables"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusDocsisRegMode"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusModulationType"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusInetAddressType"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusInetAddress"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusValueLastUpdate"), ("DOCS-IF-MIB", "docsIfCmtsCmStatusHighResolutionTimingOffset"), ("DOCS-IF-MIB", "docsIfCmtsServiceAdminStatus"), ("DOCS-IF-MIB", "docsIfCmtsServiceQosProfile"), ("DOCS-IF-MIB", "docsIfCmtsServiceCreateTime"), ("DOCS-IF-MIB", "docsIfCmtsServiceInOctets"), ("DOCS-IF-MIB", "docsIfCmtsServiceInPackets"), ("DOCS-IF-MIB", "docsIfCmtsServiceNewCmStatusIndex"), ("DOCS-IF-MIB", "docsIfCmtsModType"), ("DOCS-IF-MIB", "docsIfCmtsModControl"), ("DOCS-IF-MIB", "docsIfCmtsModPreambleLen"), ("DOCS-IF-MIB", "docsIfCmtsModDifferentialEncoding"), ("DOCS-IF-MIB", "docsIfCmtsModFECErrorCorrection"), ("DOCS-IF-MIB", "docsIfCmtsModFECCodewordLength"), ("DOCS-IF-MIB", "docsIfCmtsModScramblerSeed"), ("DOCS-IF-MIB", "docsIfCmtsModMaxBurstSize"), ("DOCS-IF-MIB", "docsIfCmtsModGuardTimeSize"), ("DOCS-IF-MIB", "docsIfCmtsModLastCodewordShortened"), ("DOCS-IF-MIB", "docsIfCmtsModScrambler"), ("DOCS-IF-MIB", "docsIfCmtsModByteInterleaverDepth"), ("DOCS-IF-MIB", "docsIfCmtsModByteInterleaverBlockSize"), ("DOCS-IF-MIB", "docsIfCmtsModPreambleType"), ("DOCS-IF-MIB", "docsIfCmtsModTcmErrorCorrectionOn"), ("DOCS-IF-MIB", "docsIfCmtsModScdmaInterleaverStepSize"), ("DOCS-IF-MIB", "docsIfCmtsModScdmaSpreaderEnable"), ("DOCS-IF-MIB", "docsIfCmtsModScdmaSubframeCodes"), ("DOCS-IF-MIB", "docsIfCmtsModChannelType"), ("DOCS-IF-MIB", "docsIfCmtsModStorageType"), ("DOCS-IF-MIB", "docsIfCmtsQosProfilePermissions"), ("DOCS-IF-MIB", "docsIfCmtsCmPtr"), ("DOCS-IF-MIB", "docsIfCmtsChannelUtilizationInterval"), ("DOCS-IF-MIB", "docsIfCmtsChannelUtUtilization"), ("DOCS-IF-MIB", "docsIfCmtsDownChnlCtrId"), ("DOCS-IF-MIB", "docsIfCmtsDownChnlCtrTotalBytes"), ("DOCS-IF-MIB", "docsIfCmtsDownChnlCtrUsedBytes"), ("DOCS-IF-MIB", "docsIfCmtsDownChnlCtrExtTotalBytes"), ("DOCS-IF-MIB", "docsIfCmtsDownChnlCtrExtUsedBytes"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrId"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrTotalMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrUcastGrantedMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrTotalCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrUsedCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtTotalMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtUcastGrantedMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtTotalCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtUsedCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrCollCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrTotalCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrUsedCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrCollCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrTotalCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrUsedCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrCollCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrCollCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtCollCntnMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtTotalCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtUsedCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtCollCntnReqMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots"), ("DOCS-IF-MIB", "docsIfDownChannelStorageType"), ("DOCS-IF-MIB", "docsIfQosProfStorageType"),))
if mibBuilder.loadTexts: docsIfCmtsGroupV2.setDescription('Group of objects implemented in Cable Modem Termination\n             Systems.')
mibBuilder.exportSymbols("DOCS-IF-MIB", docsIfCmServiceQosProfile=docsIfCmServiceQosProfile, docsIfCmtsQosProfilePermissions=docsIfCmtsQosProfilePermissions, docsIfCmtsServiceEntry=docsIfCmtsServiceEntry, docsIfCmtsUpChnlCtrExtCollCntnReqMslots=docsIfCmtsUpChnlCtrExtCollCntnReqMslots, docsIfCmtsDownChnlCtrExtTotalBytes=docsIfCmtsDownChnlCtrExtTotalBytes, docsIfCmtsUpChnlCtrTotalCntnReqMslots=docsIfCmtsUpChnlCtrTotalCntnReqMslots, docsIfUpChannelRangingBackoffEnd=docsIfUpChannelRangingBackoffEnd, docsIfCmtsServiceAdminStatus=docsIfCmtsServiceAdminStatus, docsIfUpChannelFrequency=docsIfUpChannelFrequency, docsIfCmServiceTxSlotsDed=docsIfCmServiceTxSlotsDed, docsIfCmtsCmStatusInetAddressType=docsIfCmtsCmStatusInetAddressType, docsIfCmtsCmStatusExtUncorrectables=docsIfCmtsCmStatusExtUncorrectables, docsIfCmtsCmStatusIpAddress=docsIfCmtsCmStatusIpAddress, docsIfSigQExtUncorrectables=docsIfSigQExtUncorrectables, docsIfCmStatusEqualizationData=docsIfCmStatusEqualizationData, docsIfCmtsModLastCodewordShortened=docsIfCmtsModLastCodewordShortened, docsIfCmtsCmStatusMacAddress=docsIfCmtsCmStatusMacAddress, docsIfCmStatusT1Timeouts=docsIfCmStatusT1Timeouts, docsIfCmStatusCode=docsIfCmStatusCode, docsIfCmStatusLostSyncs=docsIfCmStatusLostSyncs, docsIfCmStatusValue=docsIfCmStatusValue, docsIfCmtsServiceNewCmStatusIndex=docsIfCmtsServiceNewCmStatusIndex, docsIfCmStatusInvalidRegistrationResponses=docsIfCmStatusInvalidRegistrationResponses, docsIfCmtsCmMac=docsIfCmtsCmMac, docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots=docsIfCmtsUpChnlCtrExtCollCntnReqDataMslots, docsIfCmtsStatusFailedRegReqs=docsIfCmtsStatusFailedRegReqs, docsIfCmStatusEntry=docsIfCmStatusEntry, docsIfCmtsCmStatusCorrecteds=docsIfCmtsCmStatusCorrecteds, docsIfUpChannelPreEqEnable=docsIfUpChannelPreEqEnable, docsIfCmtsChannelUtUtilization=docsIfCmtsChannelUtUtilization, docsIfCmStatusUCCFails=docsIfCmStatusUCCFails, docsIfCmtsModScdmaInterleaverStepSize=docsIfCmtsModScdmaInterleaverStepSize, docsIfCmtsModIndex=docsIfCmtsModIndex, docsIfCmtsMacEntry=docsIfCmtsMacEntry, docsIfUpChannelTxBackoffEnd=docsIfUpChannelTxBackoffEnd, docsIfBasicComplianceV2=docsIfBasicComplianceV2, docsIfObsoleteGroup=docsIfObsoleteGroup, DocsisUpstreamType=DocsisUpstreamType, docsIfCmtsUpChnlCtrExtUsedCntnReqMslots=docsIfCmtsUpChnlCtrExtUsedCntnReqMslots, docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots=docsIfCmtsUpChnlCtrUsedCntnInitMaintMslots, docsIfQosProfileEntry=docsIfQosProfileEntry, docsIfCmtsCmStatusHighResolutionTimingOffset=docsIfCmtsCmStatusHighResolutionTimingOffset, docsIfCmStatusDocsisOperMode=docsIfCmStatusDocsisOperMode, docsIfCmtsStatusT5Timeouts=docsIfCmtsStatusT5Timeouts, docsIfUpChannelScdmaHoppingSeed=docsIfUpChannelScdmaHoppingSeed, docsIfQosProfStorageType=docsIfQosProfStorageType, docsIfCmtsUcdInterval=docsIfCmtsUcdInterval, docsIfCmtsChannelUtilizationInterval=docsIfCmtsChannelUtilizationInterval, docsIfSigQExtUnerroreds=docsIfSigQExtUnerroreds, docsIfCmtsUpChnlCtrExtTotalCntnMslots=docsIfCmtsUpChnlCtrExtTotalCntnMslots, docsIfCmStatusResets=docsIfCmStatusResets, docsIfMib=docsIfMib, docsIfCmStatusTxPower=docsIfCmStatusTxPower, docsIfSigQCorrecteds=docsIfSigQCorrecteds, docsIfDocsisBaseCapability=docsIfDocsisBaseCapability, docsIfCmtsDownChnlCtrTotalBytes=docsIfCmtsDownChnlCtrTotalBytes, docsIfMibObjects=docsIfMibObjects, docsIfCmStatusModulationType=docsIfCmStatusModulationType, docsIfUpChannelUpdate=docsIfUpChannelUpdate, docsIfCmtsModGuardTimeSize=docsIfCmtsModGuardTimeSize, docsIfNotification=docsIfNotification, docsIfUpChannelTxBackoffStart=docsIfUpChannelTxBackoffStart, docsIfSigQUnerroreds=docsIfSigQUnerroreds, docsIfCmtsCmStatusRxPower=docsIfCmtsCmStatusRxPower, docsIfCmtsCmStatusUncorrectables=docsIfCmtsCmStatusUncorrectables, docsIfCmtsUpChnlCtrUsedCntnMslots=docsIfCmtsUpChnlCtrUsedCntnMslots, docsIfCmRangingTimeout=docsIfCmRangingTimeout, DocsisVersion=DocsisVersion, docsIfDownstreamChannelEntry=docsIfDownstreamChannelEntry, docsIfDownChannelModulation=docsIfDownChannelModulation, docsIfCmtsUpChannelCounterEntry=docsIfCmtsUpChannelCounterEntry, docsIfCmtsUpChnlCtrExtCollCntnMslots=docsIfCmtsUpChnlCtrExtCollCntnMslots, docsIfCmtsCmStatusExtCorrecteds=docsIfCmtsCmStatusExtCorrecteds, docsIfCmtsCmStatusTable=docsIfCmtsCmStatusTable, docsIfCmtsUpChnlCtrId=docsIfCmtsUpChnlCtrId, docsIfCmtsCmStatusMicroreflections=docsIfCmtsCmStatusMicroreflections, docsIfCmtsUpChnlCtrExtTotalCntnReqMslots=docsIfCmtsUpChnlCtrExtTotalCntnReqMslots, docsIfUpstreamChannelTable=docsIfUpstreamChannelTable, docsIfSignalQualityTable=docsIfSignalQualityTable, docsIfUpChannelCloneFrom=docsIfUpChannelCloneFrom, docsIfQosProfMaxUpBandwidth=docsIfQosProfMaxUpBandwidth, docsIfCmServiceTxRetries=docsIfCmServiceTxRetries, docsIfCmGroup=docsIfCmGroup, docsIfCmtsServiceTable=docsIfCmtsServiceTable, docsIfCmServiceEntry=docsIfCmServiceEntry, docsIfCmtsModScramblerSeed=docsIfCmtsModScramblerSeed, docsIfCmtsStatusInvalidRangeReqs=docsIfCmtsStatusInvalidRangeReqs, TenthdB=TenthdB, docsIfCmtsModChannelType=docsIfCmtsModChannelType, docsIfCmtsUpChannelCounterTable=docsIfCmtsUpChannelCounterTable, docsIfUpChannelScdmaFrameSize=docsIfUpChannelScdmaFrameSize, docsIfCmtsCmStatusValue=docsIfCmtsCmStatusValue, docsIfCmtsModTcmErrorCorrectionOn=docsIfCmtsModTcmErrorCorrectionOn, docsIfCmtsCmStatusEqualizationData=docsIfCmtsCmStatusEqualizationData, docsIfCmtsModulationEntry=docsIfCmtsModulationEntry, docsIfCmtsModIntervalUsageCode=docsIfCmtsModIntervalUsageCode, docsIfBaseObjects=docsIfBaseObjects, docsIfCmtsMacTable=docsIfCmtsMacTable, docsIfQosProfMaxTxBurst=docsIfQosProfMaxTxBurst, docsIfUpChannelSlotSize=docsIfUpChannelSlotSize, docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots=docsIfCmtsUpChnlCtrExtTotalCntnReqDataMslots, docsIfCmMacTable=docsIfCmMacTable, docsIfBasicCompliance=docsIfBasicCompliance, docsIfUpChannelWidth=docsIfUpChannelWidth, docsIfCmtsMacStorageType=docsIfCmtsMacStorageType, docsIfCmtsChannelUtilizationEntry=docsIfCmtsChannelUtilizationEntry, docsIfCmtsModType=docsIfCmtsModType, docsIfDownChannelAnnex=docsIfDownChannelAnnex, docsIfCmtsCmStatusSignalNoise=docsIfCmtsCmStatusSignalNoise, docsIfCmtsCmStatusUnerroreds=docsIfCmtsCmStatusUnerroreds, docsIfQosProfileTable=docsIfQosProfileTable, docsIfCmtsModMaxBurstSize=docsIfCmtsModMaxBurstSize, docsIfUpstreamChannelEntry=docsIfUpstreamChannelEntry, docsIfCmtsStatusInvalidDataReqs=docsIfCmtsStatusInvalidDataReqs, docsIfBasicGroup=docsIfBasicGroup, docsIfCmtsInsertInterval=docsIfCmtsInsertInterval, docsIfCmtsGroupV2=docsIfCmtsGroupV2, docsIfCmServiceTxSlotsImmed=docsIfCmServiceTxSlotsImmed, docsIfCmtsModScdmaSpreaderEnable=docsIfCmtsModScdmaSpreaderEnable, docsIfCmtsCmStatusEntry=docsIfCmtsCmStatusEntry, docsIfCmMacEntry=docsIfCmMacEntry, docsIfCmServiceRqRetries=docsIfCmServiceRqRetries, docsIfCmtsCapabilities=docsIfCmtsCapabilities, docsIfCmtsUpChnlCtrExtUcastGrantedMslots=docsIfCmtsUpChnlCtrExtUcastGrantedMslots, docsIfCmStatusInvalidUcds=docsIfCmStatusInvalidUcds, docsIfCmtsUpChnlCtrCollCntnReqMslots=docsIfCmtsUpChnlCtrCollCntnReqMslots, docsIfCmtsMacToCmEntry=docsIfCmtsMacToCmEntry, docsIfCmtsModFECCodewordLength=docsIfCmtsModFECCodewordLength, docsIfCmtsMaxServiceIds=docsIfCmtsMaxServiceIds, docsIfCmtsModByteInterleaverBlockSize=docsIfCmtsModByteInterleaverBlockSize, docsIfCmtsModScdmaSubframeCodes=docsIfCmtsModScdmaSubframeCodes, docsIfCmtsUpChnlCtrUcastGrantedMslots=docsIfCmtsUpChnlCtrUcastGrantedMslots, docsIfCmObjects=docsIfCmObjects, docsIfUpChannelModulationProfile=docsIfUpChannelModulationProfile, docsIfCmtsCmStatusModulationType=docsIfCmtsCmStatusModulationType, docsIfCmtsServiceQosProfile=docsIfCmtsServiceQosProfile, docsIfCmServiceExtTxSlotsImmed=docsIfCmServiceExtTxSlotsImmed, docsIfSigQUncorrectables=docsIfSigQUncorrectables, PYSNMP_MODULE_ID=docsIfMib, docsIfCmtsModScrambler=docsIfCmtsModScrambler, docsIfUpChannelId=docsIfUpChannelId, docsIfUpChannelType=docsIfUpChannelType, docsIfQosProfGuarUpBandwidth=docsIfQosProfGuarUpBandwidth, docsIfDownChannelId=docsIfDownChannelId, docsIfCmtsModStorageType=docsIfCmtsModStorageType, docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots=docsIfCmtsUpChnlCtrExtCollCntnInitMaintMslots, docsIfGroups=docsIfGroups, docsIfUpChannelScdmaActiveCodes=docsIfUpChannelScdmaActiveCodes, docsIfSignalQualityEntry=docsIfSignalQualityEntry, docsIfCmtsSyncInterval=docsIfCmtsSyncInterval, docsIfSigQIncludesContention=docsIfSigQIncludesContention, docsIfCmRangingRespTimeout=docsIfCmRangingRespTimeout, docsIfCmServiceId=docsIfCmServiceId, docsIfCmtsObjects=docsIfCmtsObjects, docsIfCmtsCmStatusValueLastUpdate=docsIfCmtsCmStatusValueLastUpdate, docsIfCmtsServiceId=docsIfCmtsServiceId, docsIfCmStatusInvalidRangingResponses=docsIfCmStatusInvalidRangingResponses, docsIfCmtsUpChnlCtrCollCntnReqDataMslots=docsIfCmtsUpChnlCtrCollCntnReqDataMslots, docsIfCmGroupV2=docsIfCmGroupV2, docsIfUpChannelTxTimingOffset=docsIfUpChannelTxTimingOffset, docsIfDownChannelWidth=docsIfDownChannelWidth, docsIfUpChannelScdmaCodesPerSlot=docsIfUpChannelScdmaCodesPerSlot, docsIfCmtsCmStatusExtUnerroreds=docsIfCmtsCmStatusExtUnerroreds, docsIfCmtsUpChnlCtrUsedCntnReqMslots=docsIfCmtsUpChnlCtrUsedCntnReqMslots, docsIfCmtsCmStatusUpChannelIfIndex=docsIfCmtsCmStatusUpChannelIfIndex, docsIfDownChannelPower=docsIfDownChannelPower, docsIfCmtsDownChnlCtrUsedBytes=docsIfCmtsDownChnlCtrUsedBytes, docsIfQosProfPriority=docsIfQosProfPriority, docsIfUpChannelRangingBackoffStart=docsIfUpChannelRangingBackoffStart, docsIfCmServiceExtTxSlotsDed=docsIfCmServiceExtTxSlotsDed, docsIfCmtsModControl=docsIfCmtsModControl, docsIfCmtsModByteInterleaverDepth=docsIfCmtsModByteInterleaverDepth, docsIfCmServiceTable=docsIfCmServiceTable, docsIfCmtsUpChnlCtrCollCntnInitMaintMslots=docsIfCmtsUpChnlCtrCollCntnInitMaintMslots, docsIfCmStatusT3Timeouts=docsIfCmStatusT3Timeouts, DocsEqualizerData=DocsEqualizerData, docsIfCmtsServiceCreateTime=docsIfCmtsServiceCreateTime, docsIfCmtsInsertionInterval=docsIfCmtsInsertionInterval, docsIfCmtsUpChnlCtrCollCntnMslots=docsIfCmtsUpChnlCtrCollCntnMslots, docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots=docsIfCmtsUpChnlCtrExtUsedCntnInitMaintMslots, docsIfDownChannelFrequency=docsIfDownChannelFrequency, docsIfCmtsUpChnlCtrTotalMslots=docsIfCmtsUpChnlCtrTotalMslots, docsIfCmtsUpChnlCtrExtTotalMslots=docsIfCmtsUpChnlCtrExtTotalMslots, docsIfSigQMicroreflections=docsIfSigQMicroreflections, docsIfCmtsMacToCmTable=docsIfCmtsMacToCmTable, docsIfCmtsServiceInPackets=docsIfCmtsServiceInPackets, docsIfCmServiceRqExceededs=docsIfCmServiceRqExceededs, docsIfCmtsModDifferentialEncoding=docsIfCmtsModDifferentialEncoding, docsIfCmtsDownChnlCtrExtUsedBytes=docsIfCmtsDownChnlCtrExtUsedBytes, docsIfCmtsCmPtr=docsIfCmtsCmPtr, docsIfDownChannelStorageType=docsIfDownChannelStorageType, docsIfCmStatusT4Timeouts=docsIfCmStatusT4Timeouts, docsIfCmtsInvitedRangingAttempts=docsIfCmtsInvitedRangingAttempts, docsIfCmtsStatusTable=docsIfCmtsStatusTable, docsIfCmtsStatusInvalidRegReqs=docsIfCmtsStatusInvalidRegReqs, docsIfCmtsServiceInOctets=docsIfCmtsServiceInOctets, docsIfCmtsCmStatusIndex=docsIfCmtsCmStatusIndex, TenthdBmV=TenthdBmV, docsIfCmStatusT2Timeouts=docsIfCmStatusT2Timeouts, docsIfCmCapabilities=docsIfCmCapabilities, docsIfCmtsUpChnlCtrUsedCntnReqDataMslots=docsIfCmtsUpChnlCtrUsedCntnReqDataMslots, docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots=docsIfCmtsUpChnlCtrTotalCntnInitMaintMslots, docsIfQosProfMaxDownBandwidth=docsIfQosProfMaxDownBandwidth, docsIfCmtsModPreambleType=docsIfCmtsModPreambleType, docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots=docsIfCmtsUpChnlCtrExtUsedCntnReqDataMslots, docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots=docsIfCmtsUpChnlCtrExtTotalCntnInitMaintMslots, docsIfBasicGroupV2=docsIfBasicGroupV2, docsIfCmtsGroup=docsIfCmtsGroup, docsIfCmtsCmStatusDownChannelIfIndex=docsIfCmtsCmStatusDownChannelIfIndex, docsIfSigQEqualizationData=docsIfSigQEqualizationData, docsIfCmtsModPreambleLen=docsIfCmtsModPreambleLen, docsIfCmtsCmStatusDocsisRegMode=docsIfCmtsCmStatusDocsisRegMode, docsIfCmStatusInvalidMaps=docsIfCmStatusInvalidMaps, docsIfDownChannelInterleave=docsIfDownChannelInterleave, docsIfCmtsChannelUtId=docsIfCmtsChannelUtId, docsIfSigQExtCorrecteds=docsIfSigQExtCorrecteds, docsIfSigQSignalNoise=docsIfSigQSignalNoise, docsIfQosProfBaselinePrivacy=docsIfQosProfBaselinePrivacy, docsIfCmtsServiceCmStatusIndex=docsIfCmtsServiceCmStatusIndex, docsIfCmServiceTxExceededs=docsIfCmServiceTxExceededs, docsIfCmtsUpChnlCtrTotalCntnMslots=docsIfCmtsUpChnlCtrTotalCntnMslots, docsIfCmtsUpChnlCtrTotalCntnReqDataMslots=docsIfCmtsUpChnlCtrTotalCntnReqDataMslots, docsIfQosProfStatus=docsIfQosProfStatus, docsIfCmtsUpChnlCtrExtUsedCntnMslots=docsIfCmtsUpChnlCtrExtUsedCntnMslots, docsIfCmStatusRangingAborteds=docsIfCmStatusRangingAborteds, docsIfCmtsModFECErrorCorrection=docsIfCmtsModFECErrorCorrection, docsIfUpChannelStatus=docsIfUpChannelStatus, docsIfCompliances=docsIfCompliances, docsIfConformance=docsIfConformance, docsIfCmStatusTable=docsIfCmStatusTable, docsIfCmtsDownChannelCounterEntry=docsIfCmtsDownChannelCounterEntry, docsIfCmStatusUCCs=docsIfCmStatusUCCs, docsIfCmtsChannelUtIfType=docsIfCmtsChannelUtIfType, docsIfQosProfIndex=docsIfQosProfIndex, docsIfQosProfMaxTransmitBurst=docsIfQosProfMaxTransmitBurst, docsIfCmCmtsAddress=docsIfCmCmtsAddress, docsIfCmtsCmStatusTimingOffset=docsIfCmtsCmStatusTimingOffset, docsIfCmtsDownChannelCounterTable=docsIfCmtsDownChannelCounterTable, docsIfCmtsStatusEntry=docsIfCmtsStatusEntry, docsIfCmtsCmStatusInetAddress=docsIfCmtsCmStatusInetAddress, docsIfCmtsModulationTable=docsIfCmtsModulationTable, docsIfCmtsDownChnlCtrId=docsIfCmtsDownChnlCtrId, DocsisQosVersion=DocsisQosVersion, docsIfCmtsChannelUtilizationTable=docsIfCmtsChannelUtilizationTable, docsIfCmtsStatusRangingAborteds=docsIfCmtsStatusRangingAborteds, docsIfDownstreamChannelTable=docsIfDownstreamChannelTable)
