#
# PySNMP MIB module FIBRE-CHANNEL-FE-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/FIBRE-CHANNEL-FE-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:12:36 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, Integer, OctetString, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "Integer", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueRangeConstraint, SingleValueConstraint, ValueSizeConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueRangeConstraint", "SingleValueConstraint", "ValueSizeConstraint", "ConstraintsIntersection")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ObjectGroup, ModuleCompliance, NotificationGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "ModuleCompliance", "NotificationGroup")
( IpAddress, TimeTicks, Integer32, ModuleIdentity, Unsigned32, Counter64, iso, Counter32, Gauge32, NotificationType, MibIdentifier, ObjectIdentity, mib_2, Bits, MibScalar, MibTable, MibTableRow, MibTableColumn, ) = mibBuilder.importSymbols("SNMPv2-SMI", "IpAddress", "TimeTicks", "Integer32", "ModuleIdentity", "Unsigned32", "Counter64", "iso", "Counter32", "Gauge32", "NotificationType", "MibIdentifier", "ObjectIdentity", "mib-2", "Bits", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn")
( TextualConvention, DisplayString, TruthValue, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DisplayString", "TruthValue", "TimeStamp")
fcFeMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 75)).setRevisions(("2000-05-18 00:00",))
if mibBuilder.loadTexts: fcFeMIB.setLastUpdated('200005180000Z')
if mibBuilder.loadTexts: fcFeMIB.setOrganization('IETF IPFC Working Group')
if mibBuilder.loadTexts: fcFeMIB.setContactInfo('Kha Sin Teow\n                  Brocade Communications Systems,\n                  1901 Guadalupe Parkway,\n                  San Jose, CA 95131\n                  U.S.A\n                  Tel: +1 408 487 8180\n                  Fax: +1 408 487 8190\n                  Email: khasin@Brocade.COM\n\n                 WG Mailing list:ipfc@standards.gadzoox.com\n                 To Subscribe: ipfc-request@standards.gadzoox.com\n                 In Body: subscribe')
if mibBuilder.loadTexts: fcFeMIB.setDescription('The MIB module for Fibre Channel Fabric Element.')
fcFeMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1))
fcFeConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1, 1))
fcFeStatus = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1, 2))
fcFeError = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1, 3))
fcFeAccounting = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1, 4))
fcFeCapabilities = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 1, 5))
class MilliSeconds(Unsigned32, TextualConvention):
    pass

class MicroSeconds(Unsigned32, TextualConvention):
    pass

class FcNameId(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(8,8)
    fixedLength = 8

class FcAddressId(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(3,3)
    fixedLength = 3

class FcRxDataFieldSize(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(128,2112)

class FcBbCredit(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,32767)

class FcphVersion(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,255)

class FcStackedConnMode(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3,))
    namedValues = NamedValues(("none", 1), ("transparent", 2), ("lockedDown", 3),)

class FcCosCap(Bits, TextualConvention):
    namedValues = NamedValues(("classF", 0), ("class1", 1), ("class2", 2), ("class3", 3), ("class4", 4), ("class5", 5), ("class6", 6),)

class FcFeModuleCapacity(Unsigned32, TextualConvention):
    pass

class FcFeFxPortCapacity(Unsigned32, TextualConvention):
    pass

class FcFeModuleIndex(Unsigned32, TextualConvention):
    pass

class FcFeFxPortIndex(Unsigned32, TextualConvention):
    pass

class FcFeNxPortIndex(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,126)

class FcBbCreditModel(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2,))
    namedValues = NamedValues(("regular", 1), ("alternate", 2),)

fcFeFabricName = MibScalar((1, 3, 6, 1, 2, 1, 75, 1, 1, 1), FcNameId()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFeFabricName.setDescription('The Name_Identifier of the Fabric to which this Fabric\n          Element belongs.')
fcFeElementName = MibScalar((1, 3, 6, 1, 2, 1, 75, 1, 1, 2), FcNameId()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFeElementName.setDescription('The Name_Identifier of the Fabric Element.')
fcFeModuleCapacity = MibScalar((1, 3, 6, 1, 2, 1, 75, 1, 1, 3), FcFeModuleCapacity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleCapacity.setDescription('The maximum number of modules in the Fabric Element,\n          regardless of their current state.')
fcFeModuleTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 1, 4), )
if mibBuilder.loadTexts: fcFeModuleTable.setDescription('A table that contains, one entry for each module in the\n          Fabric Element, information of the modules.')
fcFeModuleEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1), ).setIndexNames((0, "FIBRE-CHANNEL-FE-MIB", "fcFeModuleIndex"))
if mibBuilder.loadTexts: fcFeModuleEntry.setDescription('An entry containing the configuration parameters of a\n          module.')
fcFeModuleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 1), FcFeModuleIndex())
if mibBuilder.loadTexts: fcFeModuleIndex.setDescription('This object identifies the module within the Fabric Element\n          for which this entry contains information. This value is\n          never greater than fcFeModuleCapacity.')
fcFeModuleDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 2), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleDescr.setDescription('A textual description of the module. This value should\n          include the full name and version identification of the\n          module.')
fcFeModuleObjectID = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 3), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleObjectID.setDescription("The vendor's authoritative identification of the module.\n          This value may be allocated within the SMI enterprises\n          subtree (1.3.6.1.4.1) and provides a straight-forward and\n          unambiguous means for determining what kind of module is\n          being managed.\n\n          For example, this object could take the value\n          1.3.6.1.4.1.99649.3.9 if vendor 'Neufe Inc.' was assigned\n          the subtree 1.3.6.1.4.1.99649, and had assigned the\n          identifier 1.3.6.1.4.1.99649.3.9 to its 'FeFiFo-16\n          PlugInCard.'")
fcFeModuleOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("online", 1), ("offline", 2), ("testing", 3), ("faulty", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleOperStatus.setDescription('This object indicates the operational status of the module:\n          online(1)   the module is functioning properly;\n          offline(2)  the module is not available;\n          testing(3)  the module is under testing; and\n          faulty(4)   the module is defective in some way.')
fcFeModuleLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleLastChange.setDescription('This object contains the value of sysUpTime when the module\n          entered its current operational status. A value of zero\n          indicates that the operational status of the module has not\n          changed since the agent last restarted.')
fcFeModuleFxPortCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 6), FcFeFxPortCapacity()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFeModuleFxPortCapacity.setDescription('The number of FxPort that can be contained within the\n          module. Within each module, the ports are uniquely numbered\n          in the range from 1 to fcFeModuleFxPortCapacity inclusive.\n          However, the numbers are not required to be contiguous.')
fcFeModuleName = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 4, 1, 7), FcNameId()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFeModuleName.setDescription('The Name_Identifier of the module.')
fcFxPortTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 1, 5), )
if mibBuilder.loadTexts: fcFxPortTable.setDescription('A table that contains, one entry for each FxPort in the\n         Fabric Element, configuration and service parameters of the\n         FxPorts.')
fcFxPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1), ).setIndexNames((0, "FIBRE-CHANNEL-FE-MIB", "fcFeModuleIndex"), (0, "FIBRE-CHANNEL-FE-MIB", "fcFxPortIndex"))
if mibBuilder.loadTexts: fcFxPortEntry.setDescription('An entry containing the configuration and service parameters\n         of a FxPort.')
fcFxPortIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 1), FcFeFxPortIndex())
if mibBuilder.loadTexts: fcFxPortIndex.setDescription('This object identifies the FxPort within the module.  This\n          number ranges from 1 to the value of fcFeModulePortCapacity\n          for the associated module. The value remains constant for\n          the identified FxPort until the module is re-initialized.')
fcFxPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 2), FcNameId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortName.setDescription('The World_wide Name of this FxPort.  Each FxPort has a\n          unique Port World_wide Name within the Fabric.')
fcFxPortFcphVersionHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 3), FcphVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortFcphVersionHigh.setDescription('The highest or most recent version of FC-PH that the FxPort\n          is configured to support.')
fcFxPortFcphVersionLow = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 4), FcphVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortFcphVersionLow.setDescription('The lowest or earliest version of FC-PH that the FxPort is\n          configured to support.')
fcFxPortBbCredit = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 5), FcBbCredit()).setUnits('buffers').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortBbCredit.setDescription('The total number of receive buffers available for holding\n          Class 1 connect-request, Class 2 or 3 frames from the\n          attached NxPort.  It is for buffer-to-buffer flow control\n          in the direction from the attached NxPort (if applicable)\n          to FxPort.')
fcFxPortRxBufSize = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 6), FcRxDataFieldSize()).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortRxBufSize.setDescription('The largest Data_Field Size (in octets) for an FT_1 frame\n          that can be received by the FxPort.')
fcFxPortRatov = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 7), MilliSeconds()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortRatov.setDescription('The Resource_Allocation_Timeout Value configured for the\n          FxPort.  This is used as the timeout value for determining\n          when to reuse an NxPort resource such as a\n          Recovery_Qualifier.  It represents E_D_TOV (see next\n          object) plus twice the maximum time that a frame may be\n          delayed within the Fabric and still be delivered.')
fcFxPortEdtov = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 8), MilliSeconds()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortEdtov.setDescription('The E_D_TOV value configured for the FxPort. The\n          Error_Detect_Timeout Value is used as the timeout value for\n          detecting an error condition.')
fcFxPortCosSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 9), FcCosCap()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCosSupported.setDescription('A value indicating the set of Classes of Service supported\n          by the FxPort.')
fcFxPortIntermixSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortIntermixSupported.setDescription('A flag indicating whether or not the FxPort supports an\n          Intermixed Dedicated Connection.')
fcFxPortStackedConnMode = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 11), FcStackedConnMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortStackedConnMode.setDescription('A value indicating the mode of Stacked Connect supported by\n          the FxPort.')
fcFxPortClass2SeqDeliv = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 12), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortClass2SeqDeliv.setDescription('A flag indicating whether or not Class 2 Sequential\n          Delivery is supported by the FxPort.')
fcFxPortClass3SeqDeliv = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 13), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortClass3SeqDeliv.setDescription('A flag indicating whether or not Class 3 Sequential\n          Delivery is supported by the FxPort.')
fcFxPortHoldTime = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 1, 5, 1, 14), MicroSeconds()).setUnits('microseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortHoldTime.setDescription('The maximum time (in microseconds) that the FxPort shall\n          hold a frame before discarding the frame if it is unable to\n          deliver the frame. The value 0 means that the FxPort does\n          not support this parameter.')
fcFxPortStatusTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 2, 1), )
if mibBuilder.loadTexts: fcFxPortStatusTable.setDescription('A table that contains, one entry for each FxPort in the\n          Fabric Element, operational status and parameters of the\n          FxPorts.')
fcFxPortStatusEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 2, 1, 1), )
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortStatusEntry"))
fcFxPortStatusEntry.setIndexNames(*fcFxPortEntry.getIndexNames())
if mibBuilder.loadTexts: fcFxPortStatusEntry.setDescription('An entry containing operational status and parameters of a\n          FxPort.')
fcFxPortID = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 1, 1, 1), FcAddressId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortID.setDescription('The address identifier by which this FxPort is identified\n          within the Fabric.  The FxPort may assign its address\n          identifier to its attached NxPort(s) during Fabric Login.')
fcFxPortBbCreditAvailable = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 1, 1, 2), Gauge32()).setUnits('buffers').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortBbCreditAvailable.setDescription('The number of buffers currently available for receiving\n\n          frames from the attached port in the buffer-to-buffer flow\n          control. The value should be less than or equal to\n          fcFxPortBbCredit.')
fcFxPortOperMode = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("unknown", 1), ("fPort", 2), ("flPort", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortOperMode.setDescription('The current operational mode of the FxPort.')
fcFxPortAdminMode = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 1, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(2, 3,))).clone(namedValues=NamedValues(("fPort", 2), ("flPort", 3),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFxPortAdminMode.setDescription('The desired operational mode of the FxPort.')
fcFxPortPhysTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 2, 2), )
if mibBuilder.loadTexts: fcFxPortPhysTable.setDescription('A table that contains, one entry for each FxPort in the\n          Fabric Element, physical level status and parameters of the\n          FxPorts.')
fcFxPortPhysEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 2, 2, 1), )
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortPhysEntry"))
fcFxPortPhysEntry.setIndexNames(*fcFxPortEntry.getIndexNames())
if mibBuilder.loadTexts: fcFxPortPhysEntry.setDescription('An entry containing physical level status and parameters of\n          a FxPort.')
fcFxPortPhysAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 2, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("online", 1), ("offline", 2), ("testing", 3),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFxPortPhysAdminStatus.setDescription('The desired state of the FxPort.  A management station may\n          place the FxPort in a desired state by setting this object\n          accordingly.  The testing(3) state indicates that no\n          operational frames can be passed.  When a Fabric Element\n          initializes, all FxPorts start with fcFxPortPhysAdminStatus\n          in the offline(2) state.  As the result of either explicit\n          management action or per configuration information\n          accessible by the Fabric Element, fcFxPortPhysAdminStatus\n          is then changed to either the online(1) or testing(3)\n          states, or remains in the offline state.')
fcFxPortPhysOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 2, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("online", 1), ("offline", 2), ("testing", 3), ("linkFailure", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortPhysOperStatus.setDescription('The current operational status of the FxPort.  The\n          testing(3) indicates that no operational frames can be\n          passed.  If fcFxPortPhysAdminStatus is offline(2) then\n          fcFxPortPhysOperStatus should be offline(2). If\n          fcFxPortPhysAdminStatus is changed to online(1) then\n          fcFxPortPhysOperStatus should change to online(1) if the\n\n          FxPort is ready to accept Fabric Login request from the\n          attached NxPort; it should proceed and remain in the link-\n          failure(4) state if and only if there is a fault that\n          prevents it from going to the online(1) state.')
fcFxPortPhysLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 2, 1, 3), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortPhysLastChange.setDescription("The value of sysUpTime at the time the FxPort entered its\n          current operational status. A value of zero indicates that\n          the FxPort's operational status has not changed since the\n          agent last restarted.")
fcFxPortPhysRttov = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 2, 1, 4), MilliSeconds()).setUnits('milliseconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFxPortPhysRttov.setDescription('The Receiver_Transmitter_Timeout value of the FxPort. This\n          is used by the receiver logic to detect Loss of\n          Synchronization.')
fcFxLoginTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 2, 3), )
if mibBuilder.loadTexts: fcFxLoginTable.setDescription('A table that contains, one entry for each NxPort attached\n          to a particular FxPort in the Fabric Element, services\n          parameters established from the most recent Fabric Login,\n          explicit or implicit. Note that an FxPort may have one or\n          more NxPort attached to it.')
fcFxLoginEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1), ).setIndexNames((0, "FIBRE-CHANNEL-FE-MIB", "fcFeModuleIndex"), (0, "FIBRE-CHANNEL-FE-MIB", "fcFxPortIndex"), (0, "FIBRE-CHANNEL-FE-MIB", "fcFxPortNxLoginIndex"))
if mibBuilder.loadTexts: fcFxLoginEntry.setDescription('An entry containing service parameters established from a\n          successful Fabric Login.')
fcFxPortNxLoginIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 1), FcFeNxPortIndex())
if mibBuilder.loadTexts: fcFxPortNxLoginIndex.setDescription('The object identifies the associated NxPort in the\n          attachment for which the entry contains information.')
fcFxPortFcphVersionAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 2), FcphVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortFcphVersionAgreed.setDescription('The version of FC-PH that the FxPort has agreed to support\n          from the Fabric Login')
fcFxPortNxPortBbCredit = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 3), FcBbCredit()).setUnits('buffers').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortNxPortBbCredit.setDescription('The total number of buffers available for holding Class 1\n          connect-request, Class 2 or Class 3 frames to be\n          transmitted to the attached NxPort.  It is for buffer-to-\n          buffer flow control in the direction from FxPort to NxPort.\n          The buffer-to-buffer flow control mechanism is indicated in\n          the respective fcFxPortBbCreditModel.')
fcFxPortNxPortRxDataFieldSize = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 4), FcRxDataFieldSize()).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortNxPortRxDataFieldSize.setDescription('The Receive Data Field Size of the attached NxPort. This\n          object specifies the largest Data Field Size for an FT_1\n          frame that can be received by the NxPort.')
fcFxPortCosSuppAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 5), FcCosCap()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCosSuppAgreed.setDescription('A variable indicating that the attached NxPort has\n          requested the FxPort for the support of classes of services\n          and the FxPort has granted the request.')
fcFxPortIntermixSuppAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortIntermixSuppAgreed.setDescription('A variable indicating that the attached NxPort has\n          requested the FxPort for the support of Intermix and the\n          FxPort has granted the request. This flag is only valid if\n          Class 1 service is supported.')
fcFxPortStackedConnModeAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 7), FcStackedConnMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortStackedConnModeAgreed.setDescription('A variable indicating whether the FxPort has agreed to\n          support stacked connect from the Fabric Login. This is only\n          meaningful if Class 1 service has been agreed.')
fcFxPortClass2SeqDelivAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortClass2SeqDelivAgreed.setDescription('A variable indicating whether the FxPort has agreed to\n          support Class 2 sequential delivery from the Fabric Login.\n          This is only meaningful if Class 2 service has been\n          agreed.')
fcFxPortClass3SeqDelivAgreed = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 9), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortClass3SeqDelivAgreed.setDescription('A flag indicating whether the FxPort has agreed to support\n          Class 3 sequential delivery from the Fabric Login. This is\n          only meaningful if Class 3 service has been agreed.')
fcFxPortNxPortName = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 10), FcNameId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortNxPortName.setDescription('The port name of the attached NxPort.')
fcFxPortConnectedNxPort = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 11), FcAddressId()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortConnectedNxPort.setDescription("The address identifier of the destination NxPort with which\n          this FxPort is currently engaged in a either a Class 1 or\n          loop connection. If this FxPort is not engaged in a\n          connection, then the value of this object is '000000'H.")
fcFxPortBbCreditModel = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 2, 3, 1, 12), FcBbCreditModel()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: fcFxPortBbCreditModel.setDescription('This object identifies the BB_Credit model used by the\n          FxPort.')
fcFxPortErrorTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 3, 1), )
if mibBuilder.loadTexts: fcFxPortErrorTable.setDescription('A table that contains, one entry for each FxPort, counters\n          that record the numbers of errors detected.')
fcFxPortErrorEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1), )
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortErrorEntry"))
fcFxPortErrorEntry.setIndexNames(*fcFxPortEntry.getIndexNames())
if mibBuilder.loadTexts: fcFxPortErrorEntry.setDescription('An entry containing error counters of a FxPort.')
fcFxPortLinkFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortLinkFailures.setDescription('The number of link failures detected by this FxPort.')
fcFxPortSyncLosses = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortSyncLosses.setDescription('The number of loss of synchronization detected by the\n          FxPort.')
fcFxPortSigLosses = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortSigLosses.setDescription('The number of loss of signal detected by the FxPort.')
fcFxPortPrimSeqProtoErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortPrimSeqProtoErrors.setDescription('The number of primitive sequence protocol errors detected\n          by the FxPort.')
fcFxPortInvalidTxWords = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortInvalidTxWords.setDescription('The number of invalid transmission word detected by the\n          FxPort.')
fcFxPortInvalidCrcs = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortInvalidCrcs.setDescription('The number of invalid CRC detected by this FxPort.')
fcFxPortDelimiterErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortDelimiterErrors.setDescription('The number of Delimiter Errors detected by this FxPort.')
fcFxPortAddressIdErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortAddressIdErrors.setDescription('The number of address identifier errors detected by this\n\n          FxPort.')
fcFxPortLinkResetIns = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortLinkResetIns.setDescription('The number of Link Reset Protocol received by this FxPort\n          from the attached NxPort.')
fcFxPortLinkResetOuts = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortLinkResetOuts.setDescription('The number of Link Reset Protocol issued by this FxPort to\n          the attached NxPort.')
fcFxPortOlsIns = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortOlsIns.setDescription('The number of Offline Sequence received by this FxPort.')
fcFxPortOlsOuts = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 3, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortOlsOuts.setDescription('The number of Offline Sequence issued by this FxPort.')
fcFxPortC1AccountingTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 4, 1), )
if mibBuilder.loadTexts: fcFxPortC1AccountingTable.setDescription('A table that contains, one entry for each FxPort in the\n          Fabric Element, Class 1 accounting information recorded\n          since the management agent has re-initialized.')
fcFxPortC1AccountingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1), )
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1AccountingEntry"))
fcFxPortC1AccountingEntry.setIndexNames(*fcFxPortEntry.getIndexNames())
if mibBuilder.loadTexts: fcFxPortC1AccountingEntry.setDescription('An entry containing Class 1 accounting information for each\n          FxPort.')
fcFxPortC1InFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1InFrames.setDescription('The number of Class 1 frames (other than Class 1 connect-\n          request) received by this FxPort from its attached NxPort.')
fcFxPortC1OutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1OutFrames.setDescription('The number of Class 1 frames (other than Class 1 connect-\n          request) delivered through this FxPort to its attached\n          NxPort.')
fcFxPortC1InOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1InOctets.setDescription('The number of Class 1 frame octets, including the frame\n          delimiters,  received by this FxPort from its attached\n          NxPort.')
fcFxPortC1OutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1OutOctets.setDescription('The number of Class 1 frame octets, including the frame\n          delimiters, delivered through this FxPort its attached\n          NxPort.')
fcFxPortC1Discards = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1Discards.setDescription('The number of Class 1 frames discarded by this FxPort.')
fcFxPortC1FbsyFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1FbsyFrames.setDescription('The number of F_BSY frames generated by this FxPort against\n          Class 1 connect-request.')
fcFxPortC1FrjtFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1FrjtFrames.setDescription('The number of F_RJT frames generated by this FxPort against\n          Class 1 connect-request.')
fcFxPortC1InConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1InConnections.setDescription('The number of Class 1 connections successfully established\n          in which the attached NxPort is the source of the connect-\n          request.')
fcFxPortC1OutConnections = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1OutConnections.setDescription('The number of Class 1 connections successfully established\n          in which the attached NxPort is the destination of the\n          connect-request.')
fcFxPortC1ConnTime = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 1, 1, 10), MilliSeconds()).setUnits('milliseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC1ConnTime.setDescription('The cumulative time that this FxPort has been engaged in\n          Class 1 connection.  The amount of time is counted from\n          after a connect-request has been accepted until the\n          connection is disengaged, either by an EOFdt or Link\n          Reset.')
fcFxPortC2AccountingTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 4, 2), )
if mibBuilder.loadTexts: fcFxPortC2AccountingTable.setDescription('A table that contains, one entry for each FxPort in the\n          Fabric Element, Class 2 accounting information recorded\n          since the management agent has re-initialized.')
fcFxPortC2AccountingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1), )
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2AccountingEntry"))
fcFxPortC2AccountingEntry.setIndexNames(*fcFxPortEntry.getIndexNames())
if mibBuilder.loadTexts: fcFxPortC2AccountingEntry.setDescription('An entry containing Class 2 accounting information for each\n          FxPort.')
fcFxPortC2InFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2InFrames.setDescription('The number of Class 2 frames received by this FxPort from\n          its attached NxPort.')
fcFxPortC2OutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2OutFrames.setDescription('The number of Class 2 frames delivered through this FxPort\n          to its attached NxPort.')
fcFxPortC2InOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2InOctets.setDescription('The number of Class 2 frame octets, including the frame\n          delimiters, received by this FxPort from its attached\n          NxPort.')
fcFxPortC2OutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2OutOctets.setDescription('The number of Class 2 frame octets, including the frame\n          delimiters, delivered through this FxPort to its attached\n          NxPort.')
fcFxPortC2Discards = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2Discards.setDescription('The number of Class 2 frames discarded by this FxPort.')
fcFxPortC2FbsyFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2FbsyFrames.setDescription('The number of F_BSY frames generated by this FxPort against\n          Class 2 frames.')
fcFxPortC2FrjtFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 2, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC2FrjtFrames.setDescription('The number of F_RJT frames generated by this FxPort against\n          Class 2 frames.')
fcFxPortC3AccountingTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 4, 3), )
if mibBuilder.loadTexts: fcFxPortC3AccountingTable.setDescription('A table that contains, one entry for each FxPort in the\n          Fabric Element, Class 3 accounting information recorded\n          since the management agent has re-initialized.')
fcFxPortC3AccountingEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1), )
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3AccountingEntry"))
fcFxPortC3AccountingEntry.setIndexNames(*fcFxPortEntry.getIndexNames())
if mibBuilder.loadTexts: fcFxPortC3AccountingEntry.setDescription('An entry containing Class 3 accounting information for each\n          FxPort.')
fcFxPortC3InFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC3InFrames.setDescription('The number of Class 3 frames received by this FxPort from\n          its attached NxPort.')
fcFxPortC3OutFrames = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC3OutFrames.setDescription('The number of Class 3 frames delivered through this FxPort\n          to its attached NxPort.')
fcFxPortC3InOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC3InOctets.setDescription('The number of Class 3 frame octets, including the frame\n          delimiters, received by this FxPort from its attached\n          NxPort.')
fcFxPortC3OutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC3OutOctets.setDescription('The number of Class 3 frame octets, including the frame\n          delimiters, delivered through this FxPort to its attached\n          NxPort.')
fcFxPortC3Discards = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 4, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortC3Discards.setDescription('The number of Class 3 frames discarded by this FxPort.')
fcFxPortCapTable = MibTable((1, 3, 6, 1, 2, 1, 75, 1, 5, 1), )
if mibBuilder.loadTexts: fcFxPortCapTable.setDescription('A table that contains, one entry for each FxPort, the\n          capabilities of the port within the Fabric Element.')
fcFxPortCapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1), )
fcFxPortEntry.registerAugmentions(("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapEntry"))
fcFxPortCapEntry.setIndexNames(*fcFxPortEntry.getIndexNames())
if mibBuilder.loadTexts: fcFxPortCapEntry.setDescription('An entry containing the Cap of a FxPort.')
fcFxPortCapFcphVersionHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 1), FcphVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapFcphVersionHigh.setDescription('The highest or most recent version of FC-PH that the FxPort\n          is capable of supporting.')
fcFxPortCapFcphVersionLow = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 2), FcphVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapFcphVersionLow.setDescription('The lowest or earliest version of FC-PH that the FxPort is\n          capable of supporting.')
fcFxPortCapBbCreditMax = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 3), FcBbCredit()).setUnits('buffers').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapBbCreditMax.setDescription('The maximum number of receive buffers available for holding\n          Class 1 connect-request, Class 2 or Class 3 frames from the\n          attached NxPort.')
fcFxPortCapBbCreditMin = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 4), FcBbCredit()).setUnits('buffers').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapBbCreditMin.setDescription('The minimum number of receive buffers available for holding\n          Class 1 connect-request, Class 2 or Class 3 frames from the\n          attached NxPort.')
fcFxPortCapRxDataFieldSizeMax = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 5), FcRxDataFieldSize()).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapRxDataFieldSizeMax.setDescription('The maximum size in bytes of the Data Field in a frame that\n          the FxPort is capable of receiving from its attached\n          NxPort.')
fcFxPortCapRxDataFieldSizeMin = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 6), FcRxDataFieldSize()).setUnits('bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapRxDataFieldSizeMin.setDescription('The minimum size in bytes of the Data Field in a frame that\n          the FxPort is capable of receiving from its attached\n          NxPort.')
fcFxPortCapCos = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 7), FcCosCap()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapCos.setDescription('A value indicating the set of Classes of Service that the\n          FxPort is capable of supporting.')
fcFxPortCapIntermix = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapIntermix.setDescription('A flag indicating whether or not the FxPort is capable of\n          supporting the intermixing of Class 2 and Class 3 frames\n          during a Class 1 connection. This flag is only valid if the\n          port is capable of supporting Class 1 service.')
fcFxPortCapStackedConnMode = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 9), FcStackedConnMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapStackedConnMode.setDescription('A value indicating the mode of Stacked Connect request that\n          the FxPort is capable of supporting.')
fcFxPortCapClass2SeqDeliv = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapClass2SeqDeliv.setDescription('A flag indicating whether or not the FxPort is capable of\n          supporting Class 2 Sequential Delivery.')
fcFxPortCapClass3SeqDeliv = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapClass3SeqDeliv.setDescription('A flag indicating whether or not the FxPort is capable of\n          supporting Class 3 Sequential Delivery.')
fcFxPortCapHoldTimeMax = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 12), MicroSeconds()).setUnits('microseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapHoldTimeMax.setDescription('The maximum holding time (in microseconds) that the FxPort\n          is capable of supporting.')
fcFxPortCapHoldTimeMin = MibTableColumn((1, 3, 6, 1, 2, 1, 75, 1, 5, 1, 1, 13), MicroSeconds()).setUnits('microseconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: fcFxPortCapHoldTimeMin.setDescription('The minimum holding time (in microseconds) that the FxPort\n          is capable of supporting.')
fcFeMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 2))
fcFeMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 2, 1))
fcFeMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 75, 2, 2))
fcFeMIBMinimumCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 75, 2, 1, 1)).setObjects(*(("FIBRE-CHANNEL-FE-MIB", "fcFeConfigGroup"), ("FIBRE-CHANNEL-FE-MIB", "fcFeStatusGroup"), ("FIBRE-CHANNEL-FE-MIB", "fcFeErrorGroup"),))
if mibBuilder.loadTexts: fcFeMIBMinimumCompliance.setDescription('The minimum compliance statement for SNMP entities\n          which implement the FIBRE-CHANNEL-FE-MIB.')
fcFeMIBFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 75, 2, 1, 2)).setObjects(*(("FIBRE-CHANNEL-FE-MIB", "fcFeConfigGroup"), ("FIBRE-CHANNEL-FE-MIB", "fcFeStatusGroup"), ("FIBRE-CHANNEL-FE-MIB", "fcFeErrorGroup"), ("FIBRE-CHANNEL-FE-MIB", "fcFeCapabilitiesGroup"), ("FIBRE-CHANNEL-FE-MIB", "fcFeClass1AccountingGroup"), ("FIBRE-CHANNEL-FE-MIB", "fcFeClass2AccountingGroup"), ("FIBRE-CHANNEL-FE-MIB", "fcFeClass3AccountingGroup"),))
if mibBuilder.loadTexts: fcFeMIBFullCompliance.setDescription('The full compliance statement for SNMP entities\n          which implement the FIBRE-CHANNEL-FE-MIB.')
fcFeConfigGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 1)).setObjects(*(("FIBRE-CHANNEL-FE-MIB", "fcFeFabricName"), ("FIBRE-CHANNEL-FE-MIB", "fcFeElementName"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleCapacity"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleDescr"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleObjectID"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleOperStatus"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleLastChange"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleFxPortCapacity"), ("FIBRE-CHANNEL-FE-MIB", "fcFeModuleName"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortName"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortFcphVersionHigh"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortFcphVersionLow"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortBbCredit"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortRxBufSize"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortRatov"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortEdtov"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCosSupported"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortIntermixSupported"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortStackedConnMode"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortClass2SeqDeliv"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortClass3SeqDeliv"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortHoldTime"),))
if mibBuilder.loadTexts: fcFeConfigGroup.setDescription('A collection of objects providing the configuration and service\n          parameters of the Fabric Element, the modules, and FxPorts.')
fcFeStatusGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 2)).setObjects(*(("FIBRE-CHANNEL-FE-MIB", "fcFxPortID"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortBbCreditAvailable"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortOperMode"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortAdminMode"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortPhysAdminStatus"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortPhysOperStatus"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortPhysLastChange"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortPhysRttov"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortFcphVersionAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortNxPortBbCredit"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortNxPortRxDataFieldSize"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCosSuppAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortIntermixSuppAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortStackedConnModeAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortClass2SeqDelivAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortClass3SeqDelivAgreed"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortNxPortName"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortConnectedNxPort"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortBbCreditModel"),))
if mibBuilder.loadTexts: fcFeStatusGroup.setDescription('A collection of objects providing the operational status and\n         established service parameters for the Fabric Element and the\n         attached NxPorts.')
fcFeErrorGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 3)).setObjects(*(("FIBRE-CHANNEL-FE-MIB", "fcFxPortLinkFailures"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortSyncLosses"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortSigLosses"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortPrimSeqProtoErrors"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortInvalidTxWords"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortInvalidCrcs"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortDelimiterErrors"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortAddressIdErrors"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortLinkResetIns"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortLinkResetOuts"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortOlsIns"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortOlsOuts"),))
if mibBuilder.loadTexts: fcFeErrorGroup.setDescription('A collection of objects providing various error\n          statistics detected by the FxPorts.')
fcFeClass1AccountingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 4)).setObjects(*(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1InFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1OutFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1InOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1OutOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1Discards"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1FbsyFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1FrjtFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1InConnections"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1OutConnections"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC1ConnTime"),))
if mibBuilder.loadTexts: fcFeClass1AccountingGroup.setDescription('A collection of objects providing various class 1\n  performance statistics detected by the FxPorts.')
fcFeClass2AccountingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 5)).setObjects(*(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2InFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2OutFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2InOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2OutOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2Discards"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2FbsyFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC2FrjtFrames"),))
if mibBuilder.loadTexts: fcFeClass2AccountingGroup.setDescription('A collection of objects providing various class 2\n  performance statistics detected by the FxPorts.')
fcFeClass3AccountingGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 6)).setObjects(*(("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3InFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3OutFrames"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3InOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3OutOctets"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortC3Discards"),))
if mibBuilder.loadTexts: fcFeClass3AccountingGroup.setDescription('A collection of objects providing various class 3\n          performance statistics detected by the FxPorts.')
fcFeCapabilitiesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 75, 2, 2, 7)).setObjects(*(("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapFcphVersionHigh"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapFcphVersionLow"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapBbCreditMax"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapBbCreditMin"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapRxDataFieldSizeMax"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapRxDataFieldSizeMin"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapCos"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapIntermix"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapStackedConnMode"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapClass2SeqDeliv"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapClass3SeqDeliv"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapHoldTimeMax"), ("FIBRE-CHANNEL-FE-MIB", "fcFxPortCapHoldTimeMin"),))
if mibBuilder.loadTexts: fcFeCapabilitiesGroup.setDescription('A collection of objects providing the inherent\n         capability of each FxPort within the Fabric Element.')
mibBuilder.exportSymbols("FIBRE-CHANNEL-FE-MIB", fcFxPortStackedConnModeAgreed=fcFxPortStackedConnModeAgreed, fcFxPortC1AccountingEntry=fcFxPortC1AccountingEntry, FcphVersion=FcphVersion, fcFxPortLinkResetIns=fcFxPortLinkResetIns, fcFeMIB=fcFeMIB, fcFeConfigGroup=fcFeConfigGroup, fcFxPortAddressIdErrors=fcFxPortAddressIdErrors, fcFxPortC2FrjtFrames=fcFxPortC2FrjtFrames, fcFxPortName=fcFxPortName, fcFxPortSigLosses=fcFxPortSigLosses, fcFeAccounting=fcFeAccounting, fcFeModuleName=fcFeModuleName, fcFxPortTable=fcFxPortTable, fcFxPortID=fcFxPortID, fcFxPortCosSuppAgreed=fcFxPortCosSuppAgreed, fcFeModuleObjectID=fcFeModuleObjectID, fcFxPortC1OutConnections=fcFxPortC1OutConnections, fcFxPortC2OutOctets=fcFxPortC2OutOctets, fcFxPortCapTable=fcFxPortCapTable, FcFeModuleCapacity=FcFeModuleCapacity, fcFxPortC2AccountingTable=fcFxPortC2AccountingTable, fcFxPortC2AccountingEntry=fcFxPortC2AccountingEntry, fcFxPortClass2SeqDeliv=fcFxPortClass2SeqDeliv, fcFxPortSyncLosses=fcFxPortSyncLosses, fcFeConfig=fcFeConfig, fcFxPortPhysTable=fcFxPortPhysTable, fcFxPortC1FrjtFrames=fcFxPortC1FrjtFrames, fcFxPortCapRxDataFieldSizeMax=fcFxPortCapRxDataFieldSizeMax, fcFxPortPhysLastChange=fcFxPortPhysLastChange, fcFeMIBMinimumCompliance=fcFeMIBMinimumCompliance, fcFxPortBbCredit=fcFxPortBbCredit, fcFxLoginTable=fcFxLoginTable, fcFeClass2AccountingGroup=fcFeClass2AccountingGroup, MilliSeconds=MilliSeconds, fcFeElementName=fcFeElementName, fcFxPortBbCreditAvailable=fcFxPortBbCreditAvailable, fcFxPortFcphVersionHigh=fcFxPortFcphVersionHigh, fcFxPortErrorTable=fcFxPortErrorTable, fcFxPortAdminMode=fcFxPortAdminMode, fcFxPortC1Discards=fcFxPortC1Discards, fcFxPortC2InFrames=fcFxPortC2InFrames, fcFxPortPhysRttov=fcFxPortPhysRttov, fcFxPortFcphVersionLow=fcFxPortFcphVersionLow, fcFxPortC1OutFrames=fcFxPortC1OutFrames, fcFxPortC3OutOctets=fcFxPortC3OutOctets, fcFxPortC3Discards=fcFxPortC3Discards, fcFeModuleLastChange=fcFeModuleLastChange, fcFxPortHoldTime=fcFxPortHoldTime, fcFxPortBbCreditModel=fcFxPortBbCreditModel, fcFxPortCapBbCreditMax=fcFxPortCapBbCreditMax, fcFxPortConnectedNxPort=fcFxPortConnectedNxPort, FcStackedConnMode=FcStackedConnMode, fcFxPortInvalidTxWords=fcFxPortInvalidTxWords, fcFxPortNxPortBbCredit=fcFxPortNxPortBbCredit, MicroSeconds=MicroSeconds, fcFxPortCapHoldTimeMax=fcFxPortCapHoldTimeMax, PYSNMP_MODULE_ID=fcFeMIB, FcBbCreditModel=FcBbCreditModel, fcFxPortPrimSeqProtoErrors=fcFxPortPrimSeqProtoErrors, fcFeMIBFullCompliance=fcFeMIBFullCompliance, fcFeModuleCapacity=fcFeModuleCapacity, fcFxPortC1AccountingTable=fcFxPortC1AccountingTable, fcFxPortNxPortRxDataFieldSize=fcFxPortNxPortRxDataFieldSize, fcFxPortC1OutOctets=fcFxPortC1OutOctets, fcFeClass3AccountingGroup=fcFeClass3AccountingGroup, fcFeErrorGroup=fcFeErrorGroup, fcFxPortNxLoginIndex=fcFxPortNxLoginIndex, fcFxPortNxPortName=fcFxPortNxPortName, fcFxPortCapBbCreditMin=fcFxPortCapBbCreditMin, fcFxPortInvalidCrcs=fcFxPortInvalidCrcs, fcFxPortOlsOuts=fcFxPortOlsOuts, fcFxPortCapClass3SeqDeliv=fcFxPortCapClass3SeqDeliv, fcFeModuleEntry=fcFeModuleEntry, fcFxPortOperMode=fcFxPortOperMode, fcFxPortC3AccountingTable=fcFxPortC3AccountingTable, FcCosCap=FcCosCap, fcFxPortCapClass2SeqDeliv=fcFxPortCapClass2SeqDeliv, FcAddressId=FcAddressId, fcFeModuleTable=fcFeModuleTable, fcFxPortPhysAdminStatus=fcFxPortPhysAdminStatus, fcFxPortIntermixSupported=fcFxPortIntermixSupported, fcFeModuleIndex=fcFeModuleIndex, fcFxLoginEntry=fcFxLoginEntry, fcFxPortPhysEntry=fcFxPortPhysEntry, fcFxPortCapFcphVersionHigh=fcFxPortCapFcphVersionHigh, fcFxPortCapStackedConnMode=fcFxPortCapStackedConnMode, fcFxPortLinkFailures=fcFxPortLinkFailures, fcFxPortCapEntry=fcFxPortCapEntry, fcFxPortC1FbsyFrames=fcFxPortC1FbsyFrames, fcFxPortC1InFrames=fcFxPortC1InFrames, fcFxPortCapCos=fcFxPortCapCos, FcFeModuleIndex=FcFeModuleIndex, fcFxPortFcphVersionAgreed=fcFxPortFcphVersionAgreed, fcFxPortEntry=fcFxPortEntry, fcFxPortC1InConnections=fcFxPortC1InConnections, FcFeFxPortCapacity=FcFeFxPortCapacity, fcFeCapabilitiesGroup=fcFeCapabilitiesGroup, FcNameId=FcNameId, fcFxPortIntermixSuppAgreed=fcFxPortIntermixSuppAgreed, fcFxPortCosSupported=fcFxPortCosSupported, fcFeClass1AccountingGroup=fcFeClass1AccountingGroup, fcFxPortLinkResetOuts=fcFxPortLinkResetOuts, fcFxPortCapHoldTimeMin=fcFxPortCapHoldTimeMin, FcBbCredit=FcBbCredit, fcFeModuleDescr=fcFeModuleDescr, fcFxPortC2OutFrames=fcFxPortC2OutFrames, fcFeStatus=fcFeStatus, FcRxDataFieldSize=FcRxDataFieldSize, fcFxPortCapIntermix=fcFxPortCapIntermix, fcFeModuleOperStatus=fcFeModuleOperStatus, FcFeNxPortIndex=FcFeNxPortIndex, fcFxPortIndex=fcFxPortIndex, fcFxPortC1ConnTime=fcFxPortC1ConnTime, fcFeCapabilities=fcFeCapabilities, fcFxPortC3InOctets=fcFxPortC3InOctets, fcFxPortC2Discards=fcFxPortC2Discards, fcFxPortStatusTable=fcFxPortStatusTable, fcFxPortC2InOctets=fcFxPortC2InOctets, fcFxPortClass2SeqDelivAgreed=fcFxPortClass2SeqDelivAgreed, fcFxPortClass3SeqDeliv=fcFxPortClass3SeqDeliv, fcFeMIBCompliances=fcFeMIBCompliances, fcFxPortCapFcphVersionLow=fcFxPortCapFcphVersionLow, fcFxPortC3InFrames=fcFxPortC3InFrames, fcFxPortStatusEntry=fcFxPortStatusEntry, fcFxPortClass3SeqDelivAgreed=fcFxPortClass3SeqDelivAgreed, fcFxPortC2FbsyFrames=fcFxPortC2FbsyFrames, fcFeMIBGroups=fcFeMIBGroups, fcFeStatusGroup=fcFeStatusGroup, fcFxPortStackedConnMode=fcFxPortStackedConnMode, fcFxPortC3OutFrames=fcFxPortC3OutFrames, fcFxPortEdtov=fcFxPortEdtov, fcFeMIBConformance=fcFeMIBConformance, fcFeError=fcFeError, fcFeModuleFxPortCapacity=fcFeModuleFxPortCapacity, FcFeFxPortIndex=FcFeFxPortIndex, fcFxPortPhysOperStatus=fcFxPortPhysOperStatus, fcFxPortOlsIns=fcFxPortOlsIns, fcFxPortC1InOctets=fcFxPortC1InOctets, fcFeMIBObjects=fcFeMIBObjects, fcFeFabricName=fcFeFabricName, fcFxPortErrorEntry=fcFxPortErrorEntry, fcFxPortCapRxDataFieldSizeMin=fcFxPortCapRxDataFieldSizeMin, fcFxPortRatov=fcFxPortRatov, fcFxPortDelimiterErrors=fcFxPortDelimiterErrors, fcFxPortC3AccountingEntry=fcFxPortC3AccountingEntry, fcFxPortRxBufSize=fcFxPortRxBufSize)
