#
# PySNMP MIB module MIDCOM-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/MIDCOM-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:20:10 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, Integer, OctetString, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "Integer", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueSizeConstraint, SingleValueConstraint, ValueRangeConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueSizeConstraint", "SingleValueConstraint", "ValueRangeConstraint", "ConstraintsIntersection")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( InetAddressPrefixLength, InetPortNumber, InetAddressType, InetAddress, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddressPrefixLength", "InetPortNumber", "InetAddressType", "InetAddress")
( NatBindIdOrZero, ) = mibBuilder.importSymbols("NAT-MIB", "NatBindIdOrZero")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Counter32, iso, NotificationType, MibIdentifier, Integer32, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, mib_2, Bits, Unsigned32, Counter64, ObjectIdentity, IpAddress, Gauge32, ModuleIdentity, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter32", "iso", "NotificationType", "MibIdentifier", "Integer32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "mib-2", "Bits", "Unsigned32", "Counter64", "ObjectIdentity", "IpAddress", "Gauge32", "ModuleIdentity")
( RowStatus, StorageType, DisplayString, TruthValue, TextualConvention, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "StorageType", "DisplayString", "TruthValue", "TextualConvention")
midcomMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 171)).setRevisions(("2007-08-09 10:11",))
if mibBuilder.loadTexts: midcomMIB.setLastUpdated('200708091011Z')
if mibBuilder.loadTexts: midcomMIB.setOrganization('IETF Middlebox Communication Working Group')
if mibBuilder.loadTexts: midcomMIB.setContactInfo('WG charter:\n          http://www.ietf.org/html.charters/midcom-charter.html\n\n        Mailing Lists:\n          General Discussion: midcom@ietf.org\n          To Subscribe: midcom-request@ietf.org\n          In Body: subscribe your_email_address\n\n        Co-editor:\n          Juergen Quittek\n          NEC Europe Ltd.\n          Kurfuersten-Anlage 36\n          69115 Heidelberg\n          Germany\n          Tel: +49 6221 4342-115\n          Email: quittek@nw.neclab.eu\n\n        Co-editor:\n          Martin Stiemerling\n          NEC Europe Ltd.\n          Kurfuersten-Anlage 36\n          69115 Heidelberg\n          Germany\n          Tel: +49 6221 4342-113\n          Email: stiemerling@nw.neclab.eu\n\n        Co-editor:\n          Pyda Srisuresh\n          Kazeon Systems, Inc.\n          1161 San Antonio Rd.\n          Mountain View, CA 94043\n          U.S.A.\n          Tel: +1 408 836-4773\n          Email: srisuresh@yahoo.com')
if mibBuilder.loadTexts: midcomMIB.setDescription('This MIB module defines a set of basic objects for\n         configuring middleboxes, such as firewalls and network\n\n\n\n         address translators, in order to enable communication\n         across these devices.\n\n         Managed objects defined in this MIB module are structured\n         in three kinds of objects:\n           - transaction objects required according to the MIDCOM\n             protocol requirements defined in RFC 3304 and according\n             to the MIDCOM protocol semantics defined in RFC 3989,\n           - configuration objects that can be used for retrieving or\n             setting parameters of the implementation of transaction\n             objects,\n           - optional monitoring objects that provide information\n             about used resource and statistics\n\n         The transaction objects are organized in two subtrees:\n           - objects modeling MIDCOM policy rules in the\n             midcomRuleTable\n           - objects modeling MIDCOM policy rule groups in the\n             midcomGroupTable\n\n         Note that typically, configuration objects are not intended\n         to be written by MIDCOM clients.  In general, write access\n         to these objects needs to be restricted more strictly than\n         write access to objects in the transaction subtrees.\n\n         Copyright (C) The Internet Society (2008).  This version\n         of this MIB module is part of RFC 5190;  see the RFC\n         itself for full legal notices.')
midcomNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 0))
midcomObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 1))
midcomConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 2))
midcomTransaction = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 1, 1))
midcomConfig = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 1, 2))
midcomMonitoring = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 1, 3))
midcomRuleTable = MibTable((1, 3, 6, 1, 2, 1, 171, 1, 1, 3), )
if mibBuilder.loadTexts: midcomRuleTable.setDescription('This table lists policy rules.\n\n         It is indexed by the midcomRuleOwner, the\n         midcomGroupIndex, and the midcomRuleIndex.\n         This implies that a rule is a member of exactly\n         one group and that group membership cannot\n         be changed.\n\n         Entries can be deleted by writing to\n         midcomGroupLifetime or midcomRuleLifetime\n         and potentially also to midcomRuleStorageTime.')
midcomRuleEntry = MibTableRow((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1), ).setIndexNames((0, "MIDCOM-MIB", "midcomRuleOwner"), (0, "MIDCOM-MIB", "midcomGroupIndex"), (0, "MIDCOM-MIB", "midcomRuleIndex"))
if mibBuilder.loadTexts: midcomRuleEntry.setDescription('An entry describing a particular MIDCOM policy rule.')
midcomRuleOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32)))
if mibBuilder.loadTexts: midcomRuleOwner.setDescription('The manager who owns this row in the midcomRuleTable.\n\n         This object SHOULD uniquely identify an authenticated\n         MIDCOM client.  This object is part of the table index to\n         allow for the use of the SNMPv3 View-based Access Control\n         Model (VACM, RFC 3415).')
midcomRuleIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: midcomRuleIndex.setDescription('The value of this object must be unique in\n         combination with the values of the objects\n         midcomRuleOwner and midcomGroupIndex in this row.')
midcomRuleAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("reserve", 1), ("enable", 2), ("notSet", 3),)).clone('notSet')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleAdminStatus.setDescription("The value of this object indicates the desired status of\n         the policy rule.  See the definition of midcomRuleOperStatus\n         for a description of the values.\n\n         When a midcomRuleEntry is created without explicitly setting\n         this object, its value will be notSet(3).\n\n         However, a SET request can only set this object to either\n         reserve(1) or enable(2).  Attempts to set this object to\n         notSet(3) will always fail with an 'inconsistentValue'\n         error.  Note that this error code is SNMP specific.  If the\n         MIB module is used with other protocols than SNMP, errors\n         with similar semantics specific to those protocols should\n         be returned.\n\n         When the midcomRuleAdminStatus object is set, then the\n         MIDCOM-MIB implementation will try to read the respective\n         relevant objects of the entry and try to achieve the\n         corresponding midcomRuleOperStatus.\n\n         Setting midcomRuleAdminStatus to value reserve(1) when\n         object midcomRuleOperStatus has a value of reserved(7)\n         does not have any effect on the policy rule.\n         Setting midcomRuleAdminStatus to value enable(2) when\n         object midcomRuleOperStatus has a value of enabled(8)\n         does not have any effect on the policy rule.\n\n         Depending on whether the midcomRuleAdminStatus is set to\n         reserve(1) or enable(2), several objects must be set in\n         advance.  They serve as parameters of the policy rule to be\n         established.\n\n\n\n\n         When object midcomRuleAdminStatus is set to reserve(1),\n         then the following objects in the same entry are of\n         relevance:\n             - midcomRuleInterface\n             - midcomRuleTransportProtocol\n             - midcomRulePortRange\n             - midcomRuleInternalIpVersion\n             - midcomRuleExternalIpVersion\n             - midcomRuleInternalIpAddr\n             - midcomRuleInternalIpPrefixLength\n             - midcomRuleInternalPort\n             - midcomRuleLifetime\n\n         MIDCOM-MIB implementation may also consider the value\n         of object midcomRuleMaxIdleTime when establishing\n         a reserve rule.\n\n         When object midcomRuleAdminStatus is set to enable(2),\n         then the following objects in the same entry are of\n         relevance:\n             - midcomRuleInterface\n             - midcomRuleFlowDirection\n             - midcomRuleMaxIdleTime\n             - midcomRuleTransportProtocol\n             - midcomRulePortRange\n             - midcomRuleInternalIpVersion\n             - midcomRuleExternalIpVersion\n             - midcomRuleInternalIpAddr\n             - midcomRuleInternalIpPrefixLength\n             - midcomRuleInternalPort\n             - midcomRuleExternalIpAddr\n             - midcomRuleExternalIpPrefixLength\n             - midcomRuleExternalPort\n             - midcomRuleLifetime\n\n         When retrieved, the object returns the last set value.\n         If no value has been set, it returns the default value\n         notSet(3).")
midcomRuleOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,))).clone(namedValues=NamedValues(("newEntry", 1), ("setting", 2), ("checkingRequest", 3), ("incorrectRequest", 4), ("processingRequest", 5), ("requestRejected", 6), ("reserved", 7), ("enabled", 8), ("timedOut", 9), ("terminatedOnRequest", 10), ("terminated", 11), ("genericError", 12),)).clone('newEntry')).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleOperStatus.setDescription('The actual status of the policy rule.  The\n         midcomRuleOperStatus object may have the following values:\n\n         - newEntry(1) indicates that the entry in the\n           midcomRuleTable was created, but not modified yet.\n           Such an entry needs to be filled with values specifying\n           a request first.\n\n         - setting(2) indicates that the entry has been already\n           modified after generating it, but no request was made\n           yet.\n\n         - checkingRequest(3) indicates that midcomRuleAdminStatus\n           has recently been set and that the MIDCOM-MIB\n           implementation is currently checking the parameters of\n           the request.  This is a transient state.  The value of\n           this object will change to either incorrectRequest(4)\n           or processingRequest(5) without any external\n           interaction.  A MIDCOM-MIB implementation MAY return\n           this value while checking request parameters.\n\n         - incorrectRequest(4) indicates that checking a request\n           resulted in detecting an incorrect value in one of the\n           objects containing request parameters.  The failure\n           reason is indicated by the value of midcomRuleError.\n\n         - processingRequest(5) indicates that\n           midcomRuleAdminStatus has recently been set and that\n           the MIDCOM-MIB implementation is currently processing\n           the request and trying to configure the middlebox\n           accordingly.  This is a transient state.  The value of\n           this object will change to either requestRejected(6),\n           reserved(7), or enabled(8) without any external\n           interaction.  A MIDCOM-MIB implementation MAY return\n           this value while processing a request.\n\n         - requestRejected(6) indicates that a request to establish\n\n\n\n           a policy rule specified by the entry was rejected.  The\n           reason for rejection is indicated by the value of\n           midcomRuleError.\n\n         - reserved(7) indicates that the entry describes an\n           established policy reserve rule.\n           These values of MidcomRuleEntry are meaningful\n           for a reserved policy rule:\n               - midcomRuleMaxIdleTime\n               - midcomRuleInterface\n               - midcomRuleTransportProtocol\n               - midcomRulePortRange\n               - midcomRuleInternalIpVersion\n               - midcomRuleExternalIpVersion\n               - midcomRuleInternalIpAddr\n               - midcomRuleInternalIpPrefixLength\n               - midcomRuleInternalPort\n               - midcomRuleOutsideIpAddr\n               - midcomRuleOutsidePort\n               - midcomRuleLifetime\n\n         - enabled(8) indicates that the entry describes an\n           established policy enable rule.\n           These values of MidcomRuleEntry are meaningful\n           for an enabled policy rule:\n\n               - midcomRuleFlowDirection\n               - midcomRuleInterface\n               - midcomRuleMaxIdleTime\n               - midcomRuleTransportProtocol\n               - midcomRulePortRange\n               - midcomRuleInternalIpVersion\n               - midcomRuleExternalIpVersion\n               - midcomRuleInternalIpAddr\n               - midcomRuleInternalIpPrefixLength\n               - midcomRuleInternalPort\n               - midcomRuleExternalIpAddr\n               - midcomRuleExternalIpPrefixLength\n               - midcomRuleExternalPort\n               - midcomRuleInsideIpAddr\n               - midcomRuleInsidePort\n               - midcomRuleOutsideIpAddr\n               - midcomRuleOutsidePort\n               - midcomRuleLifetime\n\n         - timedOut(9) indicates that the lifetime of a previously\n           established policy rule has expired and that the policy\n           rule is terminated for this reason.\n\n\n\n         - terminatedOnRequest(10) indicates that a previously\n           established policy rule was terminated by an SNMP\n           manager setting the midcomRuleLifetime to 0 or\n           setting midcomGroupLifetime to 0.\n\n         - terminated(11) indicates that a previously established\n           policy rule was terminated by the MIDCOM-MIB\n           implementation for a reason other than lifetime\n           expiration or an explicit request from a MIDCOM client.\n\n         - genericError(12) indicates that the policy rule\n           specified by the entry is not established due to\n           an error condition not listed above.\n\n         The states timedOut(9), terminatedOnRequest(10), and\n         terminated(11) are referred to as termination states.\n\n         The states incorrectRequest(4), requestRejected(6),\n         and genericError(12) are referred to as error states.\n\n         The checkingRequest(3) and processingRequest(5)\n         states are transient states, which will lead to either\n         one of the error states or the reserved(7) state or the\n         enabled(8) state.  MIDCOM-MIB implementations MAY return\n         these values when checking or processing requests.')
midcomRuleStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 6), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleStorageType.setDescription("When retrieved, this object returns the storage\n         type of the policy rule.  Writing to this object can\n         change the storage type of the particular row from\n         volatile(2) to nonVolatile(3) or vice versa.\n\n         Attempts to set this object to permanent will always\n         fail with an 'inconsistentValue' error.  Note that this\n         error code is SNMP specific.  If the MIB module is used\n         with other protocols than SNMP, errors with similar\n         semantics specific to those protocols should be\n         returned.\n\n         If midcomRuleStorageType has the value permanent(4),\n         then all objects in this row whose MAX-ACCESS value\n         is read-create must be read-only.")
midcomRuleStorageTime = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 7), Unsigned32()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleStorageTime.setDescription('The value of this object specifies how long this row\n         can exist in the midcomRuleTable after the\n         midcomRuleOperStatus switched to a termination state or\n         to an error state.  This object returns the remaining\n         time that the row may exist before it is aged out.\n\n         After expiration or termination of the context, the value\n         of this object ticks backwards.  The entry in the\n         midcomRuleTable is destroyed when the value reaches 0.\n\n         The value of this object may be set in order to increase\n         or reduce the remaining time that the row may exist.\n         Setting the value to 0 will destroy this entry as soon as\n         the midcomRuleOperStatus switched to a termination state\n         or to an error state.\n\n         Note that there is no guarantee that the row is stored as\n         long as this object indicates.  At any time, the MIDCOM-\n         MIB implementation may decide to remove a row describing\n         a terminated policy rule before the storage time of the\n         corresponding row in the midcomRuleTable reaches the\n         value of 0.  In this case, the information stored in this\n         row is not available anymore.\n\n         If object midcomRuleStorageType indicates that the policy\n         rule has the storage type permanent(4), then this object has\n         a constant value of 4294967295.')
midcomRuleError = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 8), SnmpAdminString().clone(hexValue="")).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleError.setDescription("This object contains a descriptive error message if\n         the transition into the operational status reserved(7)\n         or enabled(8) failed.  Implementations must reset the\n         error message to a zero-length string when a new\n\n\n\n         attempt to change the policy rule status to reserved(7)\n         or enabled(8) is started.\n\n         RECOMMENDED values to be returned in particular cases\n         include\n           - 'lack of IP addresses'\n           - 'lack of port numbers'\n           - 'lack of resources'\n           - 'specified NAT interface does not exist'\n           - 'specified NAT interface does not support NAT'\n           - 'conflict with already existing policy rule'\n           - 'no internal IP wildcarding allowed'\n           - 'no external IP wildcarding allowed'\n\n         The semantics of these error messages and the corresponding\n         behavior of the MIDCOM-MIB implementation are specified\n         in sections 2.3.9 and 2.3.10 of RFC 3989.")
midcomRuleInterface = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 9), InterfaceIndexOrZero()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleInterface.setDescription("This object indicates the IP interface for which\n         enforcement of a policy rule is requested or performed,\n         respectively.\n\n         The interface is identified by its index in the ifTable\n         (see IF-MIB in RFC 2863).  If the object has a value of 0,\n         then no particular interface is indicated.\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value newEntry(1) or setting(2), then this object can be\n         written by a manager in order to request its preference\n         concerning the interface at which it requests NAT service.\n         The default value of 0 indicates that the manager does not\n         have a preferred interface or does not have sufficient\n         topology information for specifying one.  Writing to this\n         object in any state other than newEntry(1) or setting(2)\n         will always fail with an 'inconsistentValue' error.\n\n\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value reserved(7) or enabled(8), then this object indicates\n         the interface at which NAT service for this rule is\n         performed.  If NAT service is not required for enforcing\n         the policy rule, then the value of this object is 0.  Also,\n         if the MIDCOM-MIB implementation cannot indicate an\n         interface, because it does not have this information or\n         because NAT service is not offered at a particular single\n         interface, then the value of the object is 0.\n\n         Note that the index of a particular interface in the\n         ifTable may change after a re-initialization of the\n         middlebox, for example, after adding another interface to\n         it.  In such a case, the value of this object may change,\n         but the interface referred to by the MIDCOM-MIB MUST still\n         be the same.  If, after a re-initialization of the\n         middlebox, the interface referred to before\n         re-initialization cannot be uniquely mapped anymore to a\n         particular entry in the ifTable, then the value of object\n         midcomRuleOperStatus of the same entry MUST be changed to\n         terminated(11).\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleFlowDirection = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("inbound", 1), ("outbound", 2), ("biDirectional", 3),)).clone('outbound')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleFlowDirection.setDescription("This parameter specifies the direction of enabled\n         communication, either inbound(1), outbound(2), or\n         biDirectional(3).\n\n         The semantics of this object depends on the protocol\n         the rule relates to.  If the rule is independent of\n\n\n\n         the transport protocol (midcomRuleTransportProtocol\n         has a value of 0) or if the transport protocol is UDP,\n         then the value of midcomRuleFlowDirection indicates\n         the direction of packets traversing the middlebox.\n\n         In this case, value inbound(1) indicates that packets\n         are traversing from outside to inside, value outbound(2)\n         indicates that packets are traversing from inside to\n         outside.  For both values, inbound(1) and outbound(2)\n         packets can traverse the middlebox only unidirectional.\n         A bidirectional flow is indicated by value\n         biDirectional(3).\n\n         If the transport protocol is TCP, the packet flow is\n         always bidirectional, but the value of\n         midcomRuleFlowDirection indicates that:\n\n           - inbound(1): bidirectional TCP packet flow.\n             First packet, with TCP SYN flag set, must arrive\n             at an outside interface of the middlebox.\n\n           - outbound(2): bidirectional TCP packet flow.\n             First packet, with TCP SYN flag set, must arrive\n             at an inside interface of the middlebox.\n\n           - biDirectional(3): bidirectional TCP packet flow.\n             First packet, with TCP SYN flag set, may arrive\n             at an inside or an outside interface of the middlebox.\n\n         This object is used as input to a request for\n         establishing a policy enable rule as well as for\n         indicating the properties of an established policy rule.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value of either newEntry(1), setting(2), or reserved(7),\n         then this object can be written by a manager in order to\n         specify a requested direction to be enabled by a policy\n         rule.  Writing to this object in any state other than\n         newEntry(1), setting(2), or reserved(7) will always fail\n         with an 'inconsistentValue' error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value enabled(8), then this object indicates the enabled\n\n\n\n         flow direction.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleMaxIdleTime = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 11), Unsigned32()).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleMaxIdleTime.setDescription("Maximum idle time of the policy rule in seconds.\n\n         If no packet to which the policy rule applies passes the\n         middlebox for the specified midcomRuleMaxIdleTime, then\n         the policy rule enters the termination state timedOut(9).\n\n         A value of 0 indicates that the policy does not require\n         an individual idle time and that instead, a default idle\n         time chosen by the middlebox is used.\n\n         A value of 4294967295 ( = 2^32 - 1 ) indicates that the\n         policy does not time out if it is idle.\n\n         This object is used as input to a request for\n         establishing a policy enable rule as well as for\n         indicating the properties of an established policy rule.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value of either newEntry(1), setting(2), or reserved(7),\n         then this object can be written by a manager in order to\n         specify a maximum idle time for the policy rule to be\n         requested.  Writing to this object in any state others\n         than newEntry(1), setting(2), or reserved(7) will always\n         fail with an 'inconsistentValue' error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value enabled(8), then this object indicates the maximum\n         idle time of the policy rule.  Note that even if a maximum\n         idle time greater than zero was requested, the middlebox\n\n\n\n         may not be able to support maximum idle times and set the\n         value of this object to zero when entering state\n         enabled(8).\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleTransportProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 12), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleTransportProtocol.setDescription("The transport protocol.\n\n         Valid values for midcomRuleTransportProtocol\n         other than zero are defined at:\n         http://www.iana.org/assignments/protocol-numbers\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value of either newEntry(1) or setting(2), then this\n         object can be written by a manager in order to specify a\n         requested transport protocol.  If translation of an IP\n         address only is requested, then this object must have the\n         default value 0.  Writing to this object in any state\n         other than newEntry(1) or setting(2) will always fail\n         with an 'inconsistentValue' error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value reserved(7) or enabled(8), then this object\n         indicates which transport protocol is enforced by this\n         policy rule.  A value of 0 indicates a rule acting on IP\n         addresses only.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRulePortRange = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 13), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("single", 1), ("pair", 2),)).clone('single')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRulePortRange.setDescription("The range of port numbers.\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.  It is relevant to the\n         operation of the MIDCOM-MIB implementation only if the\n         value of object midcomTransportProtocol in the same entry\n         has a value other than 0.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value newEntry(1) or setting(2), then this object can be\n         written by a manager in order to specify the requested\n         size of the port range.  With single(1) just a single\n         port number is requested, with pair(2) a consecutive pair\n         of port numbers is requested with the lower number being\n         even.  Requesting a consecutive pair of port numbers may\n         be used by RTP [RFC3550] and may even be required to\n         support older RTP applications.\n\n         Writing to this object in any state other than\n         newEntry(1), setting(2) or reserved(7) will always fail\n         with an 'inconsistentValue' error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value of either reserved(7) or enabled(8), then this\n         object will have the value that it had before the\n         transition to this state.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleInternalIpVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 14), InetAddressType().clone('ipv4')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleInternalIpVersion.setDescription("IP version of the internal address (A0) and the inside\n         address (A1).  Allowed values are ipv4(1), ipv6(2),\n         ipv4z(3), and ipv6z(4).\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value newEntry(1) or setting(2), then this object can be\n         written by a manager in order to specify the IP version\n         required at the inside of the middlebox.  Writing to this\n         object in any state other than newEntry(1) or setting(2)\n         will always fail with an 'inconsistentValue' error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value reserved(7) or enabled(8), then this object\n         indicates the internal/inside IP version.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleExternalIpVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 15), InetAddressType().clone('ipv4')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleExternalIpVersion.setDescription("IP version of the external address (A3) and the outside\n         address (A2).  Allowed values are ipv4(1) and ipv6(2).\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.\n\n\n\n         If object midcomRuleOperStatus of the same entry has the\n         value newEntry(1) or setting(2), then this object can be\n         written by a manager in order to specify the IP version\n         required at the outside of the middlebox.  Writing to\n         this object in any state other than newEntry(1) or\n         setting(2) will always fail with an 'inconsistentValue'\n         error.\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value reserved(7) or enabled(8), then this object\n         indicates the external/outside IP version.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7) or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleInternalIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 16), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleInternalIpAddr.setDescription("The internal IP address (A0).\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value newEntry(1) or setting(2), then this object can be\n         written by a manager in order to specify the internal IP\n         address for which a reserve policy rule or a enable policy\n         rule is requested to be established.  Writing to this\n         object in any state other than newEntry(1) or setting(2)\n         will always fail with an 'inconsistentValue' error.\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value reserved(7) or enabled(8), then this object will\n         have the value which it had before the transition to this\n\n\n\n         state.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7) or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleInternalIpPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 17), InetAddressPrefixLength().clone(128)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleInternalIpPrefixLength.setDescription("The prefix length of the internal IP address used for\n         wildcarding.  A value of 0 indicates a full wildcard;\n         in this case, the value of midcomRuleInternalIpAddr is\n         irrelevant.  If midcomRuleInternalIpVersion has a value\n         of ipv4(1), then a value > 31 indicates no wildcarding\n         at all.  If midcomRuleInternalIpVersion has a value\n         of ipv4(2), then a value > 127 indicates no wildcarding\n         at all.  A MIDCOM-MIB implementation that does not\n         support IP address wildcarding MUST implement this object\n         as read-only with a value of 128.  A MIDCOM that does\n         not support wildcarding based on prefix length MAY\n         restrict allowed values for this object to 0 and 128.\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value newEntry(1) or setting(2), then this object can be\n         written by a manager in order to specify the prefix length\n         of the internal IP address for which a reserve policy rule\n         or an enable policy rule is requested to be established.\n         Writing to this object in any state other than newEntry(1)\n         or setting(2) will always fail with an 'inconsistentValue'\n         error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value reserved(7) or enabled(8), then this object will\n         have the value which it had before the transition to this\n         state.\n\n\n\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleInternalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 18), InetPortNumber()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleInternalPort.setDescription("The internal port number.  A value of 0 is a wildcard.\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.  It is relevant to the\n         operation of the MIDCOM-MIB implementation only if the\n         value of object midcomTransportProtocol in the same entry\n         has a value other than 0.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value newEntry(1) or setting(2), then this object can be\n         written by a manager in order to specify the internal port\n         number for which a reserve policy rule or an enable policy\n         rule is requested to be established.  Writing to this\n         object in any state other than newEntry(1) or setting(2)\n         will always fail with an 'inconsistentValue' error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value reserved(7) or enabled(8), then this object will\n         have the value that it had before the transition to this\n         state.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleExternalIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 19), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleExternalIpAddr.setDescription("The external IP address (A3).\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value newEntry(1), setting(2), or reserved(7), then this\n         object can be written by a manager in order to specify the\n         external IP address for which an enable policy rule is\n         requested to be established.  Writing to this object in\n         any state other than newEntry(1), setting(2), or reserved(7)\n         will always fail with an 'inconsistentValue' error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value enabled(8), then this object will have the value\n         that it had before the transition to this state.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleExternalIpPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 20), InetAddressPrefixLength().clone(128)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleExternalIpPrefixLength.setDescription("The prefix length of the external IP address used for\n         wildcarding.  A value of 0 indicates a full wildcard;\n         in this case, the value of midcomRuleExternalIpAddr is\n         irrelevant.  If midcomRuleExternalIpVersion has a value\n         of ipv4(1), then a value > 31 indicates no wildcarding\n         at all.  If midcomRuleExternalIpVersion has a value\n         of ipv4(2), then a value > 127 indicates no wildcarding\n         at all.  A MIDCOM-MIB implementation that does not\n         support IP address wildcarding MUST implement this object\n         as read-only with a value of 128.  A MIDCOM that does\n         not support wildcarding based on prefix length MAY\n         restrict allowed values for this object to 0 and 128.\n\n         This object is used as input to a request for establishing\n\n\n\n         a policy rule as well as for indicating the properties of\n         an established policy rule.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value newEntry(1), setting(2), or reserved(7), then this\n         object can be written by a manager in order to specify the\n         prefix length of the external IP address for which an\n         enable policy rule is requested to be established.\n         Writing to this object in any state other than\n         newEntry(1), setting(2), or reserved(7) will always fail\n         with an 'inconsistentValue' error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value enabled(8), then this object will have the value\n         that it had before the transition to this state.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleExternalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 21), InetPortNumber()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleExternalPort.setDescription("The external port number.  A value of 0 is a wildcard.\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.  It is relevant to the\n         operation of the MIDCOM-MIB implementation only if the\n         value of object midcomTransportProtocol in the same entry\n         has a value other than 0.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value newEntry(1), setting(2) or reserved(7), then this\n         object can be written by a manager in order to specify the\n         external port number for which an enable policy rule is\n         requested to be established.  Writing to this object in\n         any state other than newEntry(1), setting(2) or reserved(7)\n         will always fail with an 'inconsistentValue' error.\n\n\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has the\n         value enabled(8), then this object will have the value\n         which it had before the transition to this state.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7) or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleInsideIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 22), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleInsideIpAddr.setDescription('The inside IP address at the middlebox (A1).\n\n         The value of this object is relevant only if\n         object midcomRuleOperStatus of the same entry has\n         a value of either reserved(7) or enabled(8).')
midcomRuleInsidePort = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 23), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleInsidePort.setDescription('The inside port number at the middlebox.\n         A value of 0 is a wildcard.\n\n         The value of this object is relevant only if\n         object midcomRuleOperStatus of the same entry has\n         a value of either reserved(7) or enabled(8).')
midcomRuleOutsideIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 24), InetAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleOutsideIpAddr.setDescription('The outside IP address at the middlebox (A2).\n\n         The value of this object is relevant only if\n\n\n\n         object midcomRuleOperStatus of the same entry has\n         a value of either reserved(7) or enabled(8).')
midcomRuleOutsidePort = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 25), InetPortNumber()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRuleOutsidePort.setDescription('The outside port number at the middlebox.\n         A value of 0 is a wildcard.\n\n         The value of this object is relevant only if\n         object midcomRuleOperStatus of the same entry has\n         a value of either reserved(7) or enabled(8).')
midcomRuleLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 26), Unsigned32().clone(180)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleLifetime.setDescription("The remaining lifetime in seconds of this policy rule.\n\n         Lifetime of a policy rule starts when object\n         midcomRuleOperStatus in the same entry enters either\n         state reserved(7) or state enabled(8).\n\n         This object is used as input to a request for establishing\n         a policy rule as well as for indicating the properties of\n         an established policy rule.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value of either newEntry(1) or setting(2), then this\n         object can be written by a manager in order to specify\n         the requested lifetime of a policy rule to be established.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value of either reserved(7) or enabled(8), then this\n         object indicates the (continuously decreasing) remaining\n         lifetime of the established policy rule.  Note that when\n         entering state reserved(7) or enabled(8), the MIDCOM-MIB\n         implementation can choose a lifetime shorter than the one\n         requested.\n\n         Unlike other parameters of the policy rule, this parameter\n         can still be written in state reserved(7) and enabled(8).\n\n\n\n         Writing to this object is processed by the MIDCOM-MIB\n         implementation by choosing a lifetime value that is\n         greater than 0 and less than or equal to the minimum of\n         the requested value and the value specified by object\n         midcomConfigMaxLifetime:\n\n          0 <= lt_granted <= MINIMUM(lt_requested, lt_maximum)\n\n         where:\n            - lt_granted is the actually granted lifetime by the\n              MIDCOM-MIB implementation\n            - lt_requested is the requested lifetime of the MIDCOM\n              client\n            - lt_maximum is the value of object\n              midcomConfigMaxLifetime\n\n         SNMP SET requests to this object may be rejected or the\n         value of the object after an accepted SET operation may be\n         less than the value that was contained in the SNMP SET\n         request.\n\n         Successfully writing a value of 0 terminates the policy\n         rule.  Note that after a policy rule is terminated, still\n         the entry will exist as long as indicated by the value of\n         midcomRuleStorageTime.\n\n         Writing to this object in any state other than\n         newEntry(1), setting(2), reserved(7), or enabled(7)\n         will always fail with an 'inconsistentValue' error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         If object midcomRuleOperStatus of the same entry has a\n         value other than newEntry(1), setting(2), reserved(7), or\n         enabled(8), then the value of this object is irrelevant.")
midcomRuleRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 3, 1, 27), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: midcomRuleRowStatus.setDescription("A control that allows entries to be added and removed from\n         this table.\n\n\n\n         Entries can also be removed from this table by setting\n         objects midcomRuleLifetime and midcomRuleStorageTime of\n         an entry to 0.\n\n         Attempts to set a row notInService(2) where the value\n         of the midcomRuleStorageType object is permanent(4) or\n         readOnly(5) will result in an 'notWritable' error.\n\n         Note that this error code is SNMP specific.  If the MIB\n         module is used with other protocols than SNMP, errors with\n         similar semantics specific to those protocols should be\n         returned.\n\n         The value of this object has no effect on whether other\n         objects in this conceptual row can be modified.")
midcomGroupTable = MibTable((1, 3, 6, 1, 2, 1, 171, 1, 1, 4), )
if mibBuilder.loadTexts: midcomGroupTable.setDescription('This table lists all current policy rule groups.\n\n         Entries in this table are created or removed\n         implicitly when entries in the midcomRuleTable are\n         created or removed, respectively.  A group entry\n         in this table only exists as long as there are\n         member rules of this group in the midcomRuleTable.\n\n         The table serves for listing the existing groups and\n         their remaining lifetimes and for changing lifetimes\n         of groups and implicitly of all group members.\n         Groups and all their member policy rules can only be\n         deleted by deleting all member policies in the\n         midcomRuleTable.\n\n         Setting midcomGroupLifetime will result in setting\n         the lifetime of all policy members to the same value.')
midcomGroupEntry = MibTableRow((1, 3, 6, 1, 2, 1, 171, 1, 1, 4, 1), ).setIndexNames((0, "MIDCOM-MIB", "midcomRuleOwner"), (0, "MIDCOM-MIB", "midcomGroupIndex"))
if mibBuilder.loadTexts: midcomGroupEntry.setDescription('An entry describing properties of a particular\n         MIDCOM policy rule group.')
midcomGroupIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 4, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: midcomGroupIndex.setDescription('The index of this group for the midcomRuleOwner.\n         A group is identified by the combination of\n         midcomRuleOwner and midcomGroupIndex.\n\n         The value of this index must be unique per\n         midcomRuleOwner.')
midcomGroupLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 1, 4, 1, 3), Unsigned32()).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomGroupLifetime.setDescription("When retrieved, this object delivers the maximum\n         lifetime in seconds of all member rules of this group,\n         i.e., of all rows in the midcomRuleTable that have the\n         same values for midcomRuleOwner and midcomGroupIndex.\n\n         Successfully writing to this object modifies the\n         lifetime of all member policies.  Successfully\n         writing a value of 0 terminates all member policies\n         and implicitly deletes the group as soon as all member\n         entries are removed from the midcomRuleTable.\n\n         Note that after a group's lifetime is expired or is\n         set to 0, still the corresponding entry in the\n         midcomGroupTable will exist as long as terminated\n         member policy rules are stored as entries in the\n\n\n\n         midcomRuleTable.\n\n         Writing to this object is processed by the MIDCOM-MIB\n         implementation by choosing a lifetime value that is\n         greater than 0 and less than or equal to the minimum of\n         the requested value and the value specified by object\n         midcomConfigMaxLifetime:\n\n          0 <= lt_granted <= MINIMUM(lt_requested, lt_maximum)\n\n         where:\n            - lt_granted is the actually granted lifetime by the\n              MIDCOM-MIB implementation\n            - lt_requested is the requested lifetime of the MIDCOM\n              client\n            - lt_maximum is the value of object\n              midcomConfigMaxLifetime\n\n         SNMP SET requests to this object may be rejected or the\n         value of the object after an accepted SET operation may be\n         less than the value that was contained in the SNMP SET\n         request.")
midcomConfigMaxLifetime = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 2, 1), Unsigned32()).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomConfigMaxLifetime.setDescription('When retrieved, this object returns the maximum lifetime,\n         in seconds, that this middlebox allows policy rules to\n         have.')
midcomConfigPersistentRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 2, 2), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomConfigPersistentRules.setDescription('When retrieved, this object returns true(1) if the\n         MIDCOM-MIB implementation can store policy rules\n         persistently.  Otherwise, it returns false(2).\n\n         A value of true(1) indicates that there may be\n         entries in the midcomRuleTable with object\n         midcomRuleStorageType set to value nonVolatile(3).')
midcomConfigIfTable = MibTable((1, 3, 6, 1, 2, 1, 171, 1, 2, 3), )
if mibBuilder.loadTexts: midcomConfigIfTable.setDescription("This table indicates capabilities of the MIDCOM-MIB\n         implementation per IP interface.\n\n         The table is indexed by the object midcomConfigIfIndex.\n\n         For indexing a single interface, this object contains\n         the value of the ifIndex object that is associated\n         with the interface.  If an entry with\n         midcomConfigIfIndex = 0 occurs, then bits set in\n         objects of this entry apply to all interfaces for which\n         there is no entry in this table with the interface's\n         index.")
midcomConfigIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 171, 1, 2, 3, 1), ).setIndexNames((0, "MIDCOM-MIB", "midcomConfigIfIndex"))
if mibBuilder.loadTexts: midcomConfigIfEntry.setDescription('An entry describing the capabilities of a middlebox\n         with respect to the indexed IP interface.')
midcomConfigIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 3, 1, 1), InterfaceIndexOrZero())
if mibBuilder.loadTexts: midcomConfigIfIndex.setDescription('The index of an entry in the midcomConfigIfTable.\n\n         For values different from zero, this object\n         identifies an IP interface by containing the same\n         value as the ifIndex object associated with the\n         interface.\n\n         Note that the index of a particular interface in the\n         ifTable may change after a re-initialization of the\n         middlebox, for example, after adding another interface to\n         it.  In such a case, the value of this object may change,\n         but the interface referred to by the MIDCOM-MIB MUST still\n         be the same.  If, after a re-initialization of the\n         middlebox, the interface referred to before\n         re-initialization cannot be uniquely mapped anymore to a\n         particular entry in the ifTable, then the value of object\n         midcomConfigIfEnabled of the same entry MUST be changed to\n         false(2).\n\n         If the object has a value of 0, then values\n         specified by further objects of the same entry\n         apply to all interfaces for which there is no\n         explicit entry in the midcomConfigIfTable.')
midcomConfigIfBits = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 3, 1, 2), Bits().clone(namedValues=NamedValues(("ipv4", 0), ("ipv6", 1), ("addressWildcards", 2), ("portWildcards", 3), ("firewall", 4), ("nat", 5), ("portTranslation", 6), ("protocolTranslation", 7), ("twiceNat", 8), ("inside", 9),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomConfigIfBits.setDescription('When retrieved, this object returns a set of bits\n         indicating the capabilities (or configuration) of\n         the middlebox with respect to the referenced IP interface.\n         If the index equals 0, then all set bits apply to all\n         interfaces.\n\n         If the ipv4(0) bit is set, then the middlebox supports\n         IPv4 at the indexed IP interface.\n\n         If the ipv6(1) bit is set, then the middlebox supports\n         IPv6 at the indexed IP interface.\n\n         If the addressWildcards(2) bit is set, then the\n         middlebox supports IP address wildcarding at the indexed\n         IP interface.\n\n         If the portWildcards(3) bit is set, then the\n         middlebox supports port wildcarding at the indexed\n         IP interface.\n\n         If the firewall(4) bit is set, then the middlebox offers\n         firewall functionality at the indexed interface.\n\n         If the nat(5) bit is set, then the middlebox offers\n         network address translation service at the indexed\n         interface.\n\n         If the portTranslation(6) bit is set, then the middlebox\n         offers port translation service at the indexed interface.\n         This bit is only relevant if nat(5) is set.\n\n         If the protocolTranslation(7) bit is set, then the\n         middlebox offers protocol translation service between\n         IPv4 and IPv6 at the indexed interface.  This bit is only\n         relevant if nat(5) is set.\n\n         If the twiceNat(8) bit is set, then the middlebox offers\n         twice network address translation service at the indexed\n         interface.  This bit is only relevant if nat(5) is set.\n\n         If the inside(9) bit is set, then the indexed interface is\n\n\n\n         an inside interface with respect to NAT functionality.\n         Otherwise, it is an outside interface.  This bit is only\n         relevant if nat(5) is set.  An SNMP agent supporting both\n         the MIDCOM-MIB module and the NAT-MIB module SHOULD ensure\n         that the value of this object is consistent with the values\n         of corresponding objects in the NAT-MIB module.')
midcomConfigIfEnabled = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 3, 1, 3), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomConfigIfEnabled.setDescription('The value of this object indicates the availability of\n         the middlebox service described by midcomConfigIfBits\n         at the indexed IP interface.\n\n         By writing to this object, the MIDCOM support for the\n         entire IP interface can be switched on or off.  Setting\n         this object to false(2) immediately stops middlebox\n         support at the indexed IP interface.  This implies that\n         all policy rules that use NAT or firewall resources at\n         the indexed IP interface are terminated immediately.\n         In this case, the MIDCOM agent MUST send\n         midcomUnsolicitedRuleEvent to all MIDCOM clients that\n         have access to one of the terminated rules.')
midcomConfigFirewallTable = MibTable((1, 3, 6, 1, 2, 1, 171, 1, 2, 4), )
if mibBuilder.loadTexts: midcomConfigFirewallTable.setDescription("This table lists the firewall configuration per IP interface.\n\n        It can be used for configuring how policy rules created by\n        MIDCOM clients are realized as firewall rules of a firewall\n        implementation.  Particularly, the priority used for MIDCOM\n        policy rules can be configured.  For a single firewall\n        implementation at a particular IP interface, all MIDCOM\n        policy rules are realized as firewall rules with the same\n\n\n\n        priority.  Also, a firewall rule group name can be\n        configured.\n\n        The table is indexed by the object midcomConfigFirewallIndex.\n        For indexing a single interface, this object contains the\n        value of the ifIndex object that is associated with the\n        interface.  If an entry with midcomConfigFirewallIndex = 0\n        occurs, then bits set in objects of this entry apply to all\n        interfaces for which there is no entry in this table for the\n        interface's index.")
midcomConfigFirewallEntry = MibTableRow((1, 3, 6, 1, 2, 1, 171, 1, 2, 4, 1), ).setIndexNames((0, "MIDCOM-MIB", "midcomConfigFirewallIndex"))
if mibBuilder.loadTexts: midcomConfigFirewallEntry.setDescription('An entry describing a particular set of\n        firewall resources.')
midcomConfigFirewallIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 4, 1, 1), InterfaceIndexOrZero())
if mibBuilder.loadTexts: midcomConfigFirewallIndex.setDescription('The index of an entry in the midcomConfigFirewallTable.\n\n         For values different from 0, this object identifies an\n         IP interface by containing the same value as the ifIndex\n         object associated with the interface.\n\n         Note that the index of a particular interface in the\n         ifTable may change after a re-initialization of the\n         middlebox, for example, after adding another interface to\n         it.  In such a case, the value of this object may change,\n         but the interface referred to by the MIDCOM-MIB MUST still\n         be the same.  If, after a re-initialization of the\n         middlebox, the interface referred to before\n         re-initialization cannot be uniquely mapped anymore to a\n         particular entry in the ifTable, then the entry in the\n\n\n\n         midcomConfigFirewallTable MUST be deleted.\n\n         If the object has a value of 0, then values specified by\n         further objects of the same entry apply to all interfaces\n         for which there is no explicit entry in the\n         midcomConfigFirewallTable.')
midcomConfigFirewallGroupId = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 4, 1, 2), SnmpAdminString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomConfigFirewallGroupId.setDescription('The firewall rule group to which all firewall rules are\n        assigned that the MIDCOM server creates for the interface\n        indicated by object midcomConfigFirewallIndex.  If the\n        value of object midcomConfigFirewallIndex is 0, then all\n        firewall rules of the MIDCOM server that are created for\n        interfaces with no specific entry in the\n        midcomConfigFirewallTable are assigned to the firewall\n        rule group indicated by the value of this object.')
midcomConfigFirewallPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 2, 4, 1, 3), Unsigned32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: midcomConfigFirewallPriority.setDescription('The priority assigned to all firewall rules that the\n        MIDCOM server creates for the interface indicated by\n        object midcomConfigFirewallIndex.  If the value of object\n        midcomConfigFirewallIndex is 0, then this priority is\n        assigned to all firewall rules of the MIDCOM server that\n        are created for interfaces for which there is no specific\n        entry in the midcomConfigFirewallTable.')
class MidcomNatBindMode(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3,))
    namedValues = NamedValues(("addressBind", 1), ("addressPortBind", 2), ("none", 3),)

class MidcomNatSessionIdOrZero(Unsigned32, TextualConvention):
    displayHint = 'd'

midcomResourceTable = MibTable((1, 3, 6, 1, 2, 1, 171, 1, 3, 1), )
if mibBuilder.loadTexts: midcomResourceTable.setDescription('This table lists all used middlebox resources per\n        MIDCOM policy rule.\n\n        The midcomResourceTable augments the\n\n\n\n        midcomRuleTable.')
midcomResourceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1), )
midcomRuleEntry.registerAugmentions(("MIDCOM-MIB", "midcomResourceEntry"))
midcomResourceEntry.setIndexNames(*midcomRuleEntry.getIndexNames())
if mibBuilder.loadTexts: midcomResourceEntry.setDescription('An entry describing a particular set of middlebox\n        resources.')
midcomRscNatInternalAddrBindMode = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 4), MidcomNatBindMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatInternalAddrBindMode.setDescription('An indication of whether this policy rule uses an address\n        NAT bind or an address-port NAT bind for binding the\n        internal address.\n\n        If the MIDCOM-MIB module is operated together with\n        the NAT-MIB module (RFC 4008) then object\n        midcomRscNatInternalAddrBindMode contains the same\n        value as the corresponding object\n        natSessionPrivateSrcEPBindMode of the NAT-MIB module.')
midcomRscNatInternalAddrBindId = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 5), NatBindIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatInternalAddrBindId.setDescription('This object references to the allocated internal NAT\n        bind that is used by this policy rule.  A NAT bind\n        describes the mapping of internal addresses to\n        outside addresses.  MIDCOM-MIB implementations can\n\n\n\n        read this object to learn the corresponding NAT bind\n        resource for this particular policy rule.\n\n        If the MIDCOM-MIB module is operated together with\n        the NAT-MIB module (RFC 4008) then object\n        midcomRscNatInternalAddrBindId contains the same\n        value as the corresponding object\n        natSessionPrivateSrcEPBindId of the NAT-MIB module.')
midcomRscNatInsideAddrBindMode = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 6), MidcomNatBindMode()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatInsideAddrBindMode.setDescription('An indication of whether this policy rule uses an address\n        NAT bind or an address-port NAT bind for binding the\n        external address.\n\n        If the MIDCOM-MIB module is operated together with\n        the NAT-MIB module (RFC 4008), then object\n        midcomRscNatInsideAddrBindMode contains the same\n        value as the corresponding object\n        natSessionPrivateDstEPBindMode of the NAT-MIB module.')
midcomRscNatInsideAddrBindId = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 7), NatBindIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatInsideAddrBindId.setDescription('This object refers to the allocated external NAT\n        bind that is used by this policy rule.  A NAT bind\n        describes the mapping of external addresses to\n        inside addresses.  MIDCOM-MIB implementations can\n        read this object to learn the corresponding NAT bind\n        resource for this particular policy rule.\n\n        If the MIDCOM-MIB module is operated together with the\n        NAT-MIB module (RFC 4008), then object\n        midcomRscNatInsideAddrBindId contains the same\n        value as the corresponding object\n        natSessionPrivateDstEPBindId of the NAT-MIB module.')
midcomRscNatSessionId1 = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 8), MidcomNatSessionIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatSessionId1.setDescription('This object refers to the first allocated NAT session for\n        this policy rule.  MIDCOM-MIB implementations can read this\n        object to learn whether or not a NAT session for a\n        particular policy rule is used.  A value of 0 means that no\n        NAT session is allocated for this policy rule.  A value\n        other than 0 refers to the NAT session.')
midcomRscNatSessionId2 = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 9), MidcomNatSessionIdOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscNatSessionId2.setDescription('This object refers to the second allocated NAT session for\n        this policy rule.  MIDCOM-MIB implementations can read this\n        object to learn whether or not a NAT session for a\n        particular policy rule is used.  A value of 0 means that no\n        NAT session is allocated for this policy rule.  A value\n        other than 0 refers to the NAT session.')
midcomRscFirewallRuleId = MibTableColumn((1, 3, 6, 1, 2, 1, 171, 1, 3, 1, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomRscFirewallRuleId.setDescription('This object refers to the allocated firewall\n        rule in the firewall engine for this policy rule.\n        MIDCOM-MIB implementations can read this value to\n        learn whether a firewall rule for this particular\n        policy rule is used or not.  A value of 0 means that\n        no firewall rule is allocated for this policy rule.\n        A value other than 0 refers to the firewall rule\n        number within the firewall engine.')
midcomStatistics = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 1, 3, 2))
midcomCurrentOwners = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomCurrentOwners.setDescription('The number of different values for midcomRuleOwner\n        for all current entries in the midcomRuleTable.')
midcomTotalRejectedRuleEntries = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalRejectedRuleEntries.setDescription('The total number of failed attempts to create an entry\n        in the midcomRuleTable.')
midcomCurrentRulesIncomplete = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomCurrentRulesIncomplete.setDescription('The current number of policy rules that are incomplete.\n\n        Policy rules are loaded via row entries in the\n        midcomRuleTable.  This object counts policy rules that are\n        loaded but not fully specified, i.e., they are in state\n        newEntry(1) or setting(2).')
midcomTotalIncorrectReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalIncorrectReserveRules.setDescription('The total number of policy reserve rules that failed\n        parameter check and entered state incorrectRequest(4).')
midcomTotalRejectedReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalRejectedReserveRules.setDescription('The total number of policy reserve rules that failed\n        while being processed and entered state requestRejected(6).')
midcomCurrentActiveReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomCurrentActiveReserveRules.setDescription('The number of currently active policy reserve rules.')
midcomTotalExpiredReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalExpiredReserveRules.setDescription('The total number of expired policy reserve rules\n        (entered termination state timedOut(9)).')
midcomTotalTerminatedOnRqReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalTerminatedOnRqReserveRules.setDescription('The total number of policy reserve rules that were\n        terminated on request (entered termination state\n        terminatedOnRequest(10)).')
midcomTotalTerminatedReserveRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalTerminatedReserveRules.setDescription('The total number of policy reserve rules that were\n        terminated, but not on request (entered termination state\n        terminated(11)).')
midcomTotalIncorrectEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalIncorrectEnableRules.setDescription('The total number of policy enable rules that failed\n        parameter check and entered state incorrectRequest(4).')
midcomTotalRejectedEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalRejectedEnableRules.setDescription('The total number of policy enable rules that failed\n        while being processed and entered state requestRejected(6).')
midcomCurrentActiveEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomCurrentActiveEnableRules.setDescription('The number of currently active policy enable rules.')
midcomTotalExpiredEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalExpiredEnableRules.setDescription('The total number of expired policy enable rules\n        (entered termination state timedOut(9)).')
midcomTotalTerminatedOnRqEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalTerminatedOnRqEnableRules.setDescription('The total number of policy enable rules that were\n        terminated on request (entered termination state\n        terminatedOnRequest(10)).')
midcomTotalTerminatedEnableRules = MibScalar((1, 3, 6, 1, 2, 1, 171, 1, 3, 2, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: midcomTotalTerminatedEnableRules.setDescription('The total number of policy enable rules that were\n        terminated, but not on request (entered termination state\n        terminated(11)).')
midcomUnsolicitedRuleEvent = NotificationType((1, 3, 6, 1, 2, 1, 171, 0, 1)).setObjects(*(("MIDCOM-MIB", "midcomRuleOperStatus"), ("MIDCOM-MIB", "midcomRuleLifetime"),))
if mibBuilder.loadTexts: midcomUnsolicitedRuleEvent.setDescription('This notification is generated whenever the value of\n         midcomRuleOperStatus enters any error state or any\n         termination state without an explicit trigger by a\n         MIDCOM client.')
midcomSolicitedRuleEvent = NotificationType((1, 3, 6, 1, 2, 1, 171, 0, 2)).setObjects(*(("MIDCOM-MIB", "midcomRuleOperStatus"), ("MIDCOM-MIB", "midcomRuleLifetime"),))
if mibBuilder.loadTexts: midcomSolicitedRuleEvent.setDescription('This notification is generated whenever the value\n         of midcomRuleOperStatus enters one of the states\n         {reserved, enabled, any error state, any termination state}\n         as a result of a MIDCOM agent writing successfully to\n         object midcomRuleAdminStatus.\n\n         In addition, it is generated when the lifetime of\n         a rule was changed by successfully writing to object\n         midcomRuleLifetime.')
midcomSolicitedGroupEvent = NotificationType((1, 3, 6, 1, 2, 1, 171, 0, 3)).setObjects(*(("MIDCOM-MIB", "midcomGroupLifetime"),))
if mibBuilder.loadTexts: midcomSolicitedGroupEvent.setDescription("This notification is generated for indicating that the\n         lifetime of all member rules of the group was changed by\n         successfully writing to object midcomGroupLifetime.\n\n         Note that this notification is only sent if the lifetime\n         of a group was changed by successfully writing to object\n         midcomGroupLifetime.  No notification is sent\n           - if a group's lifetime is changed by writing to object\n             midcomRuleLifetime of any of its member policies,\n           - if a group's lifetime expires (in this case,\n             notifications are sent for all member policies), or\n           - if the group is terminated by terminating the last\n             of its member policies without writing to object\n             midcomGroupLifetime.")
midcomCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 2, 1))
midcomGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 171, 2, 2))
midcomCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 171, 2, 1, 1)).setObjects(*(("MIDCOM-MIB", "midcomRuleGroup"), ("MIDCOM-MIB", "midcomNotificationsGroup"), ("MIDCOM-MIB", "midcomCapabilitiesGroup"), ("MIDCOM-MIB", "midcomStatisticsGroup"), ("MIDCOM-MIB", "midcomConfigFirewallGroup"), ("MIDCOM-MIB", "midcomResourceGroup"),))
if mibBuilder.loadTexts: midcomCompliance.setDescription('The compliance statement for implementations of the\n         MIDCOM-MIB module.\n\n         Note that compliance with this compliance\n         statement requires compliance with the\n         ifCompliance3 MODULE-COMPLIANCE statement of the\n         IF-MIB [RFC2863].')
midcomRuleGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 1)).setObjects(*(("MIDCOM-MIB", "midcomRuleAdminStatus"), ("MIDCOM-MIB", "midcomRuleOperStatus"), ("MIDCOM-MIB", "midcomRuleStorageType"), ("MIDCOM-MIB", "midcomRuleStorageTime"), ("MIDCOM-MIB", "midcomRuleError"), ("MIDCOM-MIB", "midcomRuleInterface"), ("MIDCOM-MIB", "midcomRuleFlowDirection"), ("MIDCOM-MIB", "midcomRuleMaxIdleTime"), ("MIDCOM-MIB", "midcomRuleTransportProtocol"), ("MIDCOM-MIB", "midcomRulePortRange"), ("MIDCOM-MIB", "midcomRuleInternalIpVersion"), ("MIDCOM-MIB", "midcomRuleExternalIpVersion"), ("MIDCOM-MIB", "midcomRuleInternalIpAddr"), ("MIDCOM-MIB", "midcomRuleInternalIpPrefixLength"), ("MIDCOM-MIB", "midcomRuleInternalPort"), ("MIDCOM-MIB", "midcomRuleExternalIpAddr"), ("MIDCOM-MIB", "midcomRuleExternalIpPrefixLength"), ("MIDCOM-MIB", "midcomRuleExternalPort"), ("MIDCOM-MIB", "midcomRuleInsideIpAddr"), ("MIDCOM-MIB", "midcomRuleInsidePort"), ("MIDCOM-MIB", "midcomRuleOutsideIpAddr"), ("MIDCOM-MIB", "midcomRuleOutsidePort"), ("MIDCOM-MIB", "midcomRuleLifetime"), ("MIDCOM-MIB", "midcomRuleRowStatus"), ("MIDCOM-MIB", "midcomGroupLifetime"),))
if mibBuilder.loadTexts: midcomRuleGroup.setDescription('A collection of objects providing information about\n         policy rules and policy rule groups.')
midcomCapabilitiesGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 2)).setObjects(*(("MIDCOM-MIB", "midcomConfigMaxLifetime"), ("MIDCOM-MIB", "midcomConfigPersistentRules"), ("MIDCOM-MIB", "midcomConfigIfBits"), ("MIDCOM-MIB", "midcomConfigIfEnabled"),))
if mibBuilder.loadTexts: midcomCapabilitiesGroup.setDescription('A collection of objects providing information about\n         the capabilities of a middlebox.')
midcomConfigFirewallGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 3)).setObjects(*(("MIDCOM-MIB", "midcomConfigFirewallGroupId"), ("MIDCOM-MIB", "midcomConfigFirewallPriority"),))
if mibBuilder.loadTexts: midcomConfigFirewallGroup.setDescription('A collection of objects providing information about\n         the firewall rule group and firewall rule priority to\n         be used by firewalls loaded through MIDCOM.')
midcomResourceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 4)).setObjects(*(("MIDCOM-MIB", "midcomRscNatInternalAddrBindMode"), ("MIDCOM-MIB", "midcomRscNatInternalAddrBindId"), ("MIDCOM-MIB", "midcomRscNatInsideAddrBindMode"), ("MIDCOM-MIB", "midcomRscNatInsideAddrBindId"), ("MIDCOM-MIB", "midcomRscNatSessionId1"), ("MIDCOM-MIB", "midcomRscNatSessionId2"), ("MIDCOM-MIB", "midcomRscFirewallRuleId"),))
if mibBuilder.loadTexts: midcomResourceGroup.setDescription('A collection of objects providing information about\n         the used NAT and firewall resources.')
midcomStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 5)).setObjects(*(("MIDCOM-MIB", "midcomCurrentOwners"), ("MIDCOM-MIB", "midcomTotalRejectedRuleEntries"), ("MIDCOM-MIB", "midcomCurrentRulesIncomplete"), ("MIDCOM-MIB", "midcomTotalIncorrectReserveRules"), ("MIDCOM-MIB", "midcomTotalRejectedReserveRules"), ("MIDCOM-MIB", "midcomCurrentActiveReserveRules"), ("MIDCOM-MIB", "midcomTotalExpiredReserveRules"), ("MIDCOM-MIB", "midcomTotalTerminatedOnRqReserveRules"), ("MIDCOM-MIB", "midcomTotalTerminatedReserveRules"), ("MIDCOM-MIB", "midcomTotalIncorrectEnableRules"), ("MIDCOM-MIB", "midcomTotalRejectedEnableRules"), ("MIDCOM-MIB", "midcomCurrentActiveEnableRules"), ("MIDCOM-MIB", "midcomTotalExpiredEnableRules"), ("MIDCOM-MIB", "midcomTotalTerminatedOnRqEnableRules"), ("MIDCOM-MIB", "midcomTotalTerminatedEnableRules"),))
if mibBuilder.loadTexts: midcomStatisticsGroup.setDescription('A collection of objects providing statistical\n         information about the MIDCOM server.')
midcomNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 171, 2, 2, 6)).setObjects(*(("MIDCOM-MIB", "midcomUnsolicitedRuleEvent"), ("MIDCOM-MIB", "midcomSolicitedRuleEvent"), ("MIDCOM-MIB", "midcomSolicitedGroupEvent"),))
if mibBuilder.loadTexts: midcomNotificationsGroup.setDescription('The notifications emitted by the midcomMIB.')
mibBuilder.exportSymbols("MIDCOM-MIB", midcomResourceEntry=midcomResourceEntry, midcomCompliances=midcomCompliances, midcomTotalExpiredReserveRules=midcomTotalExpiredReserveRules, midcomConfig=midcomConfig, midcomRuleOutsidePort=midcomRuleOutsidePort, midcomConfigIfTable=midcomConfigIfTable, midcomRscNatInsideAddrBindMode=midcomRscNatInsideAddrBindMode, midcomRuleEntry=midcomRuleEntry, midcomConfigIfIndex=midcomConfigIfIndex, midcomGroupTable=midcomGroupTable, midcomNotificationsGroup=midcomNotificationsGroup, midcomConformance=midcomConformance, midcomMonitoring=midcomMonitoring, midcomRuleError=midcomRuleError, midcomCurrentOwners=midcomCurrentOwners, midcomRscNatInternalAddrBindMode=midcomRscNatInternalAddrBindMode, midcomRscFirewallRuleId=midcomRscFirewallRuleId, midcomRscNatInsideAddrBindId=midcomRscNatInsideAddrBindId, midcomGroupEntry=midcomGroupEntry, midcomRuleStorageTime=midcomRuleStorageTime, midcomCurrentActiveEnableRules=midcomCurrentActiveEnableRules, midcomStatisticsGroup=midcomStatisticsGroup, midcomMIB=midcomMIB, midcomRuleExternalIpPrefixLength=midcomRuleExternalIpPrefixLength, midcomConfigPersistentRules=midcomConfigPersistentRules, midcomGroupIndex=midcomGroupIndex, midcomRuleGroup=midcomRuleGroup, MidcomNatBindMode=MidcomNatBindMode, midcomConfigFirewallGroupId=midcomConfigFirewallGroupId, midcomRuleInterface=midcomRuleInterface, midcomObjects=midcomObjects, midcomRuleTable=midcomRuleTable, midcomRulePortRange=midcomRulePortRange, midcomRuleInternalIpPrefixLength=midcomRuleInternalIpPrefixLength, midcomCapabilitiesGroup=midcomCapabilitiesGroup, midcomRuleFlowDirection=midcomRuleFlowDirection, midcomRuleRowStatus=midcomRuleRowStatus, midcomCurrentRulesIncomplete=midcomCurrentRulesIncomplete, midcomConfigIfEntry=midcomConfigIfEntry, midcomGroupLifetime=midcomGroupLifetime, midcomRuleTransportProtocol=midcomRuleTransportProtocol, midcomStatistics=midcomStatistics, midcomRuleAdminStatus=midcomRuleAdminStatus, midcomRuleOperStatus=midcomRuleOperStatus, midcomRuleExternalIpVersion=midcomRuleExternalIpVersion, midcomRuleExternalIpAddr=midcomRuleExternalIpAddr, midcomRuleExternalPort=midcomRuleExternalPort, midcomRuleInsideIpAddr=midcomRuleInsideIpAddr, midcomTotalTerminatedOnRqReserveRules=midcomTotalTerminatedOnRqReserveRules, midcomResourceTable=midcomResourceTable, midcomRuleOwner=midcomRuleOwner, midcomTotalRejectedEnableRules=midcomTotalRejectedEnableRules, midcomCurrentActiveReserveRules=midcomCurrentActiveReserveRules, midcomTotalRejectedReserveRules=midcomTotalRejectedReserveRules, midcomRuleStorageType=midcomRuleStorageType, midcomTotalExpiredEnableRules=midcomTotalExpiredEnableRules, midcomRuleInsidePort=midcomRuleInsidePort, midcomRscNatInternalAddrBindId=midcomRscNatInternalAddrBindId, midcomTotalTerminatedEnableRules=midcomTotalTerminatedEnableRules, midcomConfigIfEnabled=midcomConfigIfEnabled, midcomConfigFirewallGroup=midcomConfigFirewallGroup, midcomRuleInternalPort=midcomRuleInternalPort, midcomConfigIfBits=midcomConfigIfBits, midcomConfigFirewallEntry=midcomConfigFirewallEntry, midcomRscNatSessionId1=midcomRscNatSessionId1, midcomConfigFirewallPriority=midcomConfigFirewallPriority, midcomRuleInternalIpAddr=midcomRuleInternalIpAddr, midcomRuleMaxIdleTime=midcomRuleMaxIdleTime, midcomCompliance=midcomCompliance, midcomSolicitedRuleEvent=midcomSolicitedRuleEvent, midcomRuleOutsideIpAddr=midcomRuleOutsideIpAddr, midcomRscNatSessionId2=midcomRscNatSessionId2, midcomTotalTerminatedReserveRules=midcomTotalTerminatedReserveRules, MidcomNatSessionIdOrZero=MidcomNatSessionIdOrZero, midcomGroups=midcomGroups, midcomSolicitedGroupEvent=midcomSolicitedGroupEvent, midcomTotalIncorrectEnableRules=midcomTotalIncorrectEnableRules, midcomTotalTerminatedOnRqEnableRules=midcomTotalTerminatedOnRqEnableRules, midcomConfigFirewallTable=midcomConfigFirewallTable, midcomTotalIncorrectReserveRules=midcomTotalIncorrectReserveRules, PYSNMP_MODULE_ID=midcomMIB, midcomTotalRejectedRuleEntries=midcomTotalRejectedRuleEntries, midcomNotifications=midcomNotifications, midcomRuleIndex=midcomRuleIndex, midcomTransaction=midcomTransaction, midcomConfigFirewallIndex=midcomConfigFirewallIndex, midcomUnsolicitedRuleEvent=midcomUnsolicitedRuleEvent, midcomResourceGroup=midcomResourceGroup, midcomConfigMaxLifetime=midcomConfigMaxLifetime, midcomRuleInternalIpVersion=midcomRuleInternalIpVersion, midcomRuleLifetime=midcomRuleLifetime)
