#
# PySNMP MIB module RFC1253-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/RFC1253-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:25:56 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, OctetString, Integer, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "OctetString", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueSizeConstraint, ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueSizeConstraint", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint")
( ModuleCompliance, NotificationGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup")
( MibScalar, MibTable, MibTableRow, MibTableColumn, NotificationType, TimeTicks, Counter64, IpAddress, iso, Unsigned32, Gauge32, Bits, Counter32, ModuleIdentity, ObjectIdentity, MibIdentifier, mib_2, Integer32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "NotificationType", "TimeTicks", "Counter64", "IpAddress", "iso", "Unsigned32", "Gauge32", "Bits", "Counter32", "ModuleIdentity", "ObjectIdentity", "MibIdentifier", "mib-2", "Integer32")
( TextualConvention, DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DisplayString")
ospf = MibIdentifier((1, 3, 6, 1, 2, 1, 14))
class AreaID(IpAddress):
    pass

class RouterID(IpAddress):
    pass

class Metric(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,65535)

class BigMetric(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,16777215)

class TruthValue(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2,))
    namedValues = NamedValues(("true", 1), ("false", 2),)

class Status(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2,))
    namedValues = NamedValues(("enabled", 1), ("disabled", 2),)

class Validation(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2,))
    namedValues = NamedValues(("valid", 1), ("invalid", 2),)

class PositiveInteger(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,4294967295)

class HelloRange(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,65535)

class UpToMaxAge(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,3600)

class InterfaceIndex(Integer32):
    pass

class DesignatedRouterPriority(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,255)

class TOSType(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,31)

ospfGeneralGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 1))
ospfRouterId = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 1), RouterID()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfRouterId.setDescription("A 32-bit integer uniquely identifying the router in\n            the Autonomous System.\n\n            By convention, to ensure uniqueness, this should\n            default to the value of one of the router's IP\n            interface addresses.")
ospfAdminStat = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 2), Status()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfAdminStat.setDescription("The administrative status of OSPF in the router.  The\n            value 'enabled' denotes that the OSPF Process is active\n            on at least one interface; 'disabled' disables it on\n            all interfaces.")
ospfVersionNumber = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(2,))).clone(namedValues=NamedValues(("version2", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVersionNumber.setDescription('The current version number of the OSPF protocol is 2.')
ospfAreaBdrRtrStatus = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaBdrRtrStatus.setDescription('A flag to note whether this router is an area border\n            router.')
ospfASBdrRtrStatus = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfASBdrRtrStatus.setDescription('A flag to note whether this router is an Autonomous\n            System border router.')
ospfExternLSACount = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExternLSACount.setDescription('The number of external (LS type 5) link-state\n            advertisements in the link-state database.')
ospfExternLSACksumSum = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExternLSACksumSum.setDescription("The 32-bit unsigned sum of the LS checksums of the\n            external link-state advertisements contained in the\n            link-state database.  This sum can be used to determine\n            if there has been a change in a router's link state\n            database, and to compare the link-state database of two\n            routers.")
ospfTOSSupport = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 8), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfTOSSupport.setDescription("The router's support for type-of-service routing.")
ospfOriginateNewLSAs = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfOriginateNewLSAs.setDescription('The number of new link-state advertisements that have\n            been originated.  This number is incremented each time\n            the router originates a new LSA.')
ospfRxNewLSAs = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfRxNewLSAs.setDescription('The number of link-state advertisements received\n            determined to be new instantiations.  This number does\n            not include newer instantiations of self-originated\n            link-state advertisements.')
ospfAreaTable = MibTable((1, 3, 6, 1, 2, 1, 14, 2), )
if mibBuilder.loadTexts: ospfAreaTable.setDescription("Information describing the configured parameters and\n            cumulative statistics of the router's attached areas.")
ospfAreaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 2, 1), ).setIndexNames((0, "RFC1253-MIB", "ospfAreaId"))
if mibBuilder.loadTexts: ospfAreaEntry.setDescription("Information describing the configured parameters and\n            cumulative statistics of one of the router's attached\n            areas.")
ospfAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 1), AreaID()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfAreaId.setDescription('A 32-bit integer uniquely identifying an area.  Area\n            ID 0.0.0.0 is used for the OSPF backbone.')
ospfAuthType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 2), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfAuthType.setDescription('The authentication type specified for an area.\n            Additional authentication types may be assigned locally\n            on a per Area basis.')
ospfImportASExtern = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 3), TruthValue().clone('true')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfImportASExtern.setDescription("The area's support for importing AS external link-\n            state advertisements.")
ospfSpfRuns = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfSpfRuns.setDescription("The number of times that the intra-area route table\n            has been calculated using this area's link-state\n            database.  This is typically done using Dijkstra's\n            algorithm.")
ospfAreaBdrRtrCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaBdrRtrCount.setDescription('The total number of area border routers reachable\n            within this area.  This is initially zero, and is\n            calculated in each SPF Pass.')
ospfASBdrRtrCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfASBdrRtrCount.setDescription('The total number of Autonomous System border routers\n            reachable within this area.  This is initially zero,\n            and is calculated in each SPF Pass.')
ospfAreaLSACount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaLSACount.setDescription("The total number of link-state advertisements in this\n            area's link-state database, excluding AS External\n            LSA's.")
ospfAreaLSACksumSum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaLSACksumSum.setDescription("The 32-bit unsigned sum of the link-state\n            advertisements' LS checksums contained in this area's\n            link-state database.  This sum excludes external (LS\n            type 5) link-state advertisements.  The sum can be used\n            to determine if there has been a change in a router's\n            link state database, and to compare the link-state\n            database of two routers.")
ospfStubAreaTable = MibTable((1, 3, 6, 1, 2, 1, 14, 3), )
if mibBuilder.loadTexts: ospfStubAreaTable.setDescription('The set of metrics that will be advertised by a\n            default Area Border Router into a stub area.')
ospfStubAreaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 3, 1), ).setIndexNames((0, "RFC1253-MIB", "ospfStubAreaID"), (0, "RFC1253-MIB", "ospfStubTOS"))
if mibBuilder.loadTexts: ospfStubAreaEntry.setDescription('The metric for a given Type of Service that will be\n            advertised by a default Area Border Router into a stub\n            area.')
ospfStubAreaID = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 1), AreaID()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfStubAreaID.setDescription('The 32 bit identifier for the Stub Area.  On creation,\n            this can be derived from the instance.')
ospfStubTOS = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 2), TOSType()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfStubTOS.setDescription('The Type of Service associated with the metric.  On\n            creation, this can be derived from the instance.')
ospfStubMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 3), BigMetric()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfStubMetric.setDescription('The metric value applied at the indicated type of\n            service.  By default, this equals the least metric at\n            the type of service among the interfaces to other\n            areas.')
ospfStubStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 4), Validation().clone('valid')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfStubStatus.setDescription("This variable displays the validity or invalidity of\n            the entry.  Setting it to 'invalid' has the effect of\n            rendering it inoperative.  The internal effect (row\n            removal) is implementation dependent.")
ospfLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 4), )
if mibBuilder.loadTexts: ospfLsdbTable.setDescription("The OSPF Process's Links State Database.")
ospfLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 4, 1), ).setIndexNames((0, "RFC1253-MIB", "ospfLsdbAreaId"), (0, "RFC1253-MIB", "ospfLsdbType"), (0, "RFC1253-MIB", "ospfLsdbLSID"), (0, "RFC1253-MIB", "ospfLsdbRouterId"))
if mibBuilder.loadTexts: ospfLsdbEntry.setDescription('A single Link State Advertisement.')
ospfLsdbAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbAreaId.setDescription('The 32 bit identifier of the Area from which the LSA\n            was received.')
ospfLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("routerLink", 1), ("networkLink", 2), ("summaryLink", 3), ("asSummaryLink", 4), ("asExternalLink", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbType.setDescription('The type of the link state advertisement.  Each link\n            state type has a separate advertisement format.')
ospfLsdbLSID = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbLSID.setDescription('The Link State ID is an LS Type Specific field\n            containing either a Router ID or an IP Address; it\n            identifies the piece of the routing domain that is\n            being described by the advertisement.')
ospfLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 4), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbRouterId.setDescription('The 32 bit number that uniquely identifies the\n            originating router in the Autonomous System.')
ospfLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbSequence.setDescription('The sequence number field is a signed 32-bit integer.\n            It is used to detect old and duplicate link state\n            advertisements.  The space of sequence numbers is\n            linearly ordered.  The larger the sequence number the\n            more recent the advertisement.')
ospfLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbAge.setDescription('This field is the age of the link state advertisement\n            in seconds.')
ospfLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbChecksum.setDescription("This field is the checksum of the complete contents of\n            the advertisement, excepting the age field.  The age\n            field is excepted so that an advertisement's age can be\n            incremented without updating the checksum.  The\n            checksum used is the same that is used for ISO\n            connectionless datagrams; it is commonly referred to as\n            the Fletcher checksum.")
ospfLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 8), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbAdvertisement.setDescription('The entire Link State Advertisement, including its\n            header.')
ospfAreaRangeTable = MibTable((1, 3, 6, 1, 2, 1, 14, 5), )
if mibBuilder.loadTexts: ospfAreaRangeTable.setDescription('A range if IP addresses specified by an IP address/IP\n            network mask pair.  For example, class B address range\n            of X.X.X.X with a network mask of 255.255.0.0 includes\n            all IP addresses from X.X.0.0 to X.X.255.255')
ospfAreaRangeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 5, 1), ).setIndexNames((0, "RFC1253-MIB", "ospfAreaRangeAreaID"), (0, "RFC1253-MIB", "ospfAreaRangeNet"))
if mibBuilder.loadTexts: ospfAreaRangeEntry.setDescription('A range if IP addresses specified by an IP address/IP\n            network mask pair.  For example, class B address range\n            of X.X.X.X with a network mask of 255.255.0.0 includes\n            all IP addresses from X.X.0.0 to X.X.255.255')
ospfAreaRangeAreaID = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 1), AreaID()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfAreaRangeAreaID.setDescription('The Area the Address Range is to be found within.')
ospfAreaRangeNet = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 2), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfAreaRangeNet.setDescription('The IP Address of the Net or Subnet indicated by the\n            range.')
ospfAreaRangeMask = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 3), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfAreaRangeMask.setDescription('The Subnet Mask that pertains to the Net or Subnet.')
ospfAreaRangeStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 4), Validation().clone('valid')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfAreaRangeStatus.setDescription("This variable displays the validity or invalidity of\n            the entry.  Setting it to 'invalid' has the effect of\n            rendering it inoperative.  The internal effect (row\n            removal) is implementation dependent.")
ospfHostTable = MibTable((1, 3, 6, 1, 2, 1, 14, 6), )
if mibBuilder.loadTexts: ospfHostTable.setDescription('The list of Hosts, and their metrics, that the router\n            will advertise as host routes.')
ospfHostEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 6, 1), ).setIndexNames((0, "RFC1253-MIB", "ospfHostIpAddress"), (0, "RFC1253-MIB", "ospfHostTOS"))
if mibBuilder.loadTexts: ospfHostEntry.setDescription('A metric to be advertised, for a given type of service,\n            when a given host is reachable.')
ospfHostIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 1), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfHostIpAddress.setDescription('The IP Address of the Host.')
ospfHostTOS = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 2), TOSType()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfHostTOS.setDescription('The Type of Service of the route being configured.')
ospfHostMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 3), Metric()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfHostMetric.setDescription('The Metric to be advertised.')
ospfHostStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 4), Validation().clone('valid')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfHostStatus.setDescription("This variable displays the validity or invalidity of\n            the entry.  Setting it to 'invalid' has the effect of\n            rendering it inoperative.  The internal effect (row\n            removal) is implementation dependent.")
ospfIfTable = MibTable((1, 3, 6, 1, 2, 1, 14, 7), )
if mibBuilder.loadTexts: ospfIfTable.setDescription('The OSPF Interface Table describes the interfaces from\n            the viewpoint of OSPF.')
ospfIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 7, 1), ).setIndexNames((0, "RFC1253-MIB", "ospfIfIpAddress"), (0, "RFC1253-MIB", "ospfAddressLessIf"))
if mibBuilder.loadTexts: ospfIfEntry.setDescription('The OSPF Interface Entry describes one interface from\n            the viewpoint of OSPF.')
ospfIfIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 1), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfIpAddress.setDescription('The IP address of this OSPF interface.')
ospfAddressLessIf = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 2), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfAddressLessIf.setDescription('For the purpose of easing the instancing of addressed\n            and addressless interfaces; This variable takes the\n            value 0 on interfaces with IP Addresses, and the\n            corresponding value of ifIndex for interfaces having no\n            IP Address.')
ospfIfAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 3), AreaID().clone(hexValue="00000000")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfAreaId.setDescription('A 32-bit integer uniquely identifying the area to\n            which the interface connects.  Area ID 0.0.0.0 is used\n            for the OSPF backbone.')
ospfIfType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("broadcast", 1), ("nbma", 2), ("pointToPoint", 3),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfType.setDescription("The OSPF interface type.\n\n            By way of a default, this field may be intuited from\n            the corresponding value of ifType.  Broadcast LANs,\n            such as Ethernet and IEEE 802.5, take the value\n            'broadcast', X.25, Frame Relay, and similar\n            technologies take the value 'nbma', and links that are\n            definitively point to point take the value\n            'pointToPoint'.")
ospfIfAdminStat = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 5), Status().clone('enabled')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfAdminStat.setDescription("The OSPF interface's administrative status.  The value\n            'enabled' denotes that neighbor relationships may be\n            formed on the interface, and the interface will be\n            advertised as an internal route to some area.  The\n            value 'disabled' denotes that the interface is external\n            to OSPF.")
ospfIfRtrPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 6), DesignatedRouterPriority().clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfRtrPriority.setDescription('The priority of this interface.  Used in multi-access\n            networks, this field is used in the designated router\n            election algorithm.  The value 0 signifies that the\n            router is not eligible to become the designated router\n            on this particular network.  In the event of a tie in\n            this value, routers will use their router id as a tie\n            breaker.')
ospfIfTransitDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 7), UpToMaxAge().clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfTransitDelay.setDescription('The estimated number of seconds it takes to transmit a\n            link- state update packet over this interface.')
ospfIfRetransInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 8), UpToMaxAge().clone(5)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfRetransInterval.setDescription('The number of seconds between link-state advertisement\n            retransmissions, for adjacencies belonging to this\n            interface.  This value is also used when retransmitting\n            database description and link-state request packets.')
ospfIfHelloInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 9), HelloRange().clone(10)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfHelloInterval.setDescription('The length of time, in seconds, between the Hello\n            packets that the router sends on the interface.  This\n            value must be the same for all routers attached to a\n            common network.')
ospfIfRtrDeadInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 10), PositiveInteger().clone(40)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfRtrDeadInterval.setDescription("The number of seconds that a router's Hello packets\n            have not been seen before it's neighbors declare the\n            router down.  This should be some multiple of the Hello\n            interval.  This value must be the same for all routers\n            attached to a common network.")
ospfIfPollInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 11), PositiveInteger().clone(120)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfPollInterval.setDescription('The larger time interval, in seconds, between the\n            Hello packets sent to an inactive non-broadcast multi-\n            access neighbor.')
ospfIfState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7,))).clone(namedValues=NamedValues(("down", 1), ("loopback", 2), ("waiting", 3), ("pointToPoint", 4), ("designatedRouter", 5), ("backupDesignatedRouter", 6), ("otherDesignatedRouter", 7),)).clone('down')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfState.setDescription('The OSPF Interface State.')
ospfIfDesignatedRouter = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 13), IpAddress().clone(hexValue="00000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfDesignatedRouter.setDescription('The IP Address of the Designated Router.')
ospfIfBackupDesignatedRouter = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 14), IpAddress().clone(hexValue="00000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfBackupDesignatedRouter.setDescription('The IP Address of the Backup Designated Router.')
ospfIfEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfEvents.setDescription('The number of times this OSPF interface has changed\n            its state, or an error has occurred.')
ospfIfAuthKey = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 16), OctetString().clone(hexValue="0000000000000000")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfAuthKey.setDescription("The Authentication Key.  If the Area's Authorization\n            Type is simplePassword, and the key length is shorter\n            than 8 octets, the agent will left adjust and zero fill\n            to 8 octets.\n\n            When read, ospfIfAuthKey always returns an Octet String\n            of length zero.")
ospfIfMetricTable = MibTable((1, 3, 6, 1, 2, 1, 14, 8), )
if mibBuilder.loadTexts: ospfIfMetricTable.setDescription('The TOS metrics for a non-virtual interface identified\n            by the interface index.')
ospfIfMetricEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 8, 1), ).setIndexNames((0, "RFC1253-MIB", "ospfIfMetricIpAddress"), (0, "RFC1253-MIB", "ospfIfMetricAddressLessIf"), (0, "RFC1253-MIB", "ospfIfMetricTOS"))
if mibBuilder.loadTexts: ospfIfMetricEntry.setDescription('A particular TOS metric for a non-virtual interface\n            identified by the interface index.')
ospfIfMetricIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 1), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfMetricIpAddress.setDescription('The IP address of this OSPF interface.  On row\n            creation, this can be derived from the instance.')
ospfIfMetricAddressLessIf = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 2), Integer32()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfMetricAddressLessIf.setDescription('For the purpose of easing the instancing of addressed\n            and addressless interfaces; This variable takes the\n            value 0 on interfaces with IP Addresses, and the value\n            of ifIndex for interfaces having no IP Address.  On row\n            creation, this can be derived from the instance.')
ospfIfMetricTOS = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 3), TOSType()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfMetricTOS.setDescription('The type of service metric being referenced.  On row\n            creation, this can be derived from the instance.')
ospfIfMetricMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 4), Metric()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfMetricMetric.setDescription("The metric of using this type of service on this\n            interface.  The default value of the TOS 0 Metric is\n            10^8 / ifSpeed.\n\n            The value FFFF is distinguished to mean 'no route via\n            this TOS'.")
ospfIfMetricStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 5), Validation().clone('valid')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfIfMetricStatus.setDescription("This variable displays the validity or invalidity of\n            the entry.  Setting it to 'invalid' has the effect of\n            rendering it inoperative.  The internal effect (row\n            removal) is implementation dependent.")
ospfVirtIfTable = MibTable((1, 3, 6, 1, 2, 1, 14, 9), )
if mibBuilder.loadTexts: ospfVirtIfTable.setDescription("Information about this router's virtual interfaces.")
ospfVirtIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 9, 1), ).setIndexNames((0, "RFC1253-MIB", "ospfVirtIfAreaID"), (0, "RFC1253-MIB", "ospfVirtIfNeighbor"))
if mibBuilder.loadTexts: ospfVirtIfEntry.setDescription('Information about a single Virtual Interface.')
ospfVirtIfAreaID = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 1), AreaID()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfVirtIfAreaID.setDescription('The Transit Area that the Virtual Link traverses.  By\n            definition, this is not 0.0.0.0')
ospfVirtIfNeighbor = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 2), RouterID()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfVirtIfNeighbor.setDescription('The Router ID of the Virtual Neighbor.')
ospfVirtIfTransitDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 3), UpToMaxAge().clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfVirtIfTransitDelay.setDescription('The estimated number of seconds it takes to transmit a\n            link- state update packet over this interface.')
ospfVirtIfRetransInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 4), UpToMaxAge().clone(5)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfVirtIfRetransInterval.setDescription('The number of seconds between link-state advertisement\n            retransmissions, for adjacencies belonging to this\n            interface.  This value is also used when retransmitting\n            database description and link-state request packets.\n            This value should be well over the expected round-trip\n            time.')
ospfVirtIfHelloInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 5), HelloRange().clone(10)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfVirtIfHelloInterval.setDescription('The length of time, in seconds, between the Hello\n            packets that the router sends on the interface.  This\n            value must be the same for the virtual neighbor.')
ospfVirtIfRtrDeadInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 6), PositiveInteger().clone(60)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfVirtIfRtrDeadInterval.setDescription("The number of seconds that a router's Hello packets\n            have not been seen before it's neighbors declare the\n            router down.  This should be some multiple of the Hello\n            interval.  This value must be the same for the virtual\n            neighbor.")
ospfVirtIfState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 4,))).clone(namedValues=NamedValues(("down", 1), ("pointToPoint", 4),)).clone('down')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfState.setDescription('OSPF virtual interface states.')
ospfVirtIfEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfEvents.setDescription('The number of state changes or error events on this\n            Virtual Link')
ospfVirtIfAuthKey = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 9), OctetString().clone(hexValue="0000000000000000")).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfVirtIfAuthKey.setDescription('If Authentication Type is simplePassword, the device\n            will left adjust and zero fill to 8 octets.\n\n            When read, ospfVifAuthKey always returns a string of\n            length zero.')
ospfVirtIfStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 10), Validation().clone('valid')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfVirtIfStatus.setDescription("This variable displays the validity or invalidity of\n            the entry.  Setting it to 'invalid' has the effect of\n            rendering it inoperative.  The internal effect (row\n            removal) is implementation dependent.")
ospfNbrTable = MibTable((1, 3, 6, 1, 2, 1, 14, 10), )
if mibBuilder.loadTexts: ospfNbrTable.setDescription('A table of non-virtual neighbor information.')
ospfNbrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 10, 1), ).setIndexNames((0, "RFC1253-MIB", "ospfNbrIpAddr"), (0, "RFC1253-MIB", "ospfNbrAddressLessIndex"))
if mibBuilder.loadTexts: ospfNbrEntry.setDescription('The information regarding a single neighbor.')
ospfNbrIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 1), IpAddress()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfNbrIpAddr.setDescription('The IP address of this neighbor.')
ospfNbrAddressLessIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 2), InterfaceIndex()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfNbrAddressLessIndex.setDescription(' On an interface having an IP Address, zero.  On\n            addressless interfaces, the corresponding value of\n            ifIndex in the Internet Standard MIB.  On row creation,\n            this can be derived from the instance.')
ospfNbrRtrId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 3), RouterID().clone(hexValue="00000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrRtrId.setDescription('A 32-bit integer (represented as a type IpAddress)\n            uniquely identifying the neighboring router in the\n            Autonomous System.')
ospfNbrOptions = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrOptions.setDescription("A Bit Mask corresponding to the neighbor's options\n            field.\n\n            Bit 0, if set, indicates that the area accepts and\n            operates on external information; if zero, it is a stub\n            area.\n\n            Bit 1, if set, indicates that the system will operate\n            on Type of Service metrics other than TOS 0.  If zero,\n            the neighbor will ignore all metrics except the TOS 0\n            metric.")
ospfNbrPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 5), DesignatedRouterPriority().clone(1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfNbrPriority.setDescription('The priority of this neighbor in the designated router\n            election algorithm.  The value 0 signifies that the\n            neighbor is not eligible to become the designated\n            router on this particular network.')
ospfNbrState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("down", 1), ("attempt", 2), ("init", 3), ("twoWay", 4), ("exchangeStart", 5), ("exchange", 6), ("loading", 7), ("full", 8),)).clone('down')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrState.setDescription('The State of the relationship with this Neighbor.')
ospfNbrEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrEvents.setDescription('The number of times this neighbor relationship has\n            changed state, or an error has occurred.')
ospfNbrLSRetransQLen = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrLSRetransQLen.setDescription('The current length of the retransmission queue.')
ospfNBMANbrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 9), Validation().clone('valid')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfNBMANbrStatus.setDescription("This variable displays the validity or invalidity of\n            the entry.  Setting it to 'invalid' has the effect of\n            rendering it inoperative.  The internal effect (row\n            removal) is implementation dependent.")
ospfVirtNbrTable = MibTable((1, 3, 6, 1, 2, 1, 14, 11), )
if mibBuilder.loadTexts: ospfVirtNbrTable.setDescription('A table of virtual neighbor information.')
ospfVirtNbrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 11, 1), ).setIndexNames((0, "RFC1253-MIB", "ospfVirtNbrArea"), (0, "RFC1253-MIB", "ospfVirtNbrRtrId"))
if mibBuilder.loadTexts: ospfVirtNbrEntry.setDescription('Virtual neighbor information.')
ospfVirtNbrArea = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrArea.setDescription('The Transit Area Identifier.')
ospfVirtNbrRtrId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 2), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrRtrId.setDescription('A 32-bit integer uniquely identifying the neighboring\n            router in the Autonomous System.')
ospfVirtNbrIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrIpAddr.setDescription('The IP address this Virtual Neighbor is using.')
ospfVirtNbrOptions = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrOptions.setDescription("A bit map corresponding to the neighbor's options\n            field.  Thus, Bit 1, if set, indicates that the\n            neighbor supports Type of Service Routing; if zero, no\n            metrics other than TOS 0 are in use by the neighbor.")
ospfVirtNbrState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("down", 1), ("attempt", 2), ("init", 3), ("twoWay", 4), ("exchangeStart", 5), ("exchange", 6), ("loading", 7), ("full", 8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrState.setDescription('The state of the Virtual Neighbor Relationship.')
ospfVirtNbrEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrEvents.setDescription('The number of times this virtual link has changed its\n            state, or an error has occurred.')
ospfVirtNbrLSRetransQLen = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrLSRetransQLen.setDescription('The current length of the retransmission queue.')
mibBuilder.exportSymbols("RFC1253-MIB", ospfAreaRangeNet=ospfAreaRangeNet, ospfVirtIfTransitDelay=ospfVirtIfTransitDelay, ospfAreaLSACksumSum=ospfAreaLSACksumSum, ospfIfEvents=ospfIfEvents, ospfVirtIfStatus=ospfVirtIfStatus, ospfLsdbType=ospfLsdbType, ospfStubAreaID=ospfStubAreaID, DesignatedRouterPriority=DesignatedRouterPriority, ospfSpfRuns=ospfSpfRuns, ospfVirtIfRetransInterval=ospfVirtIfRetransInterval, Validation=Validation, ospfRouterId=ospfRouterId, ospfIfTable=ospfIfTable, ospfIfMetricEntry=ospfIfMetricEntry, ospfVirtNbrIpAddr=ospfVirtNbrIpAddr, Metric=Metric, ospfIfDesignatedRouter=ospfIfDesignatedRouter, ospfExternLSACksumSum=ospfExternLSACksumSum, ospfStubStatus=ospfStubStatus, TruthValue=TruthValue, ospfImportASExtern=ospfImportASExtern, ospfLsdbChecksum=ospfLsdbChecksum, ospfOriginateNewLSAs=ospfOriginateNewLSAs, ospfGeneralGroup=ospfGeneralGroup, ospfVirtIfTable=ospfVirtIfTable, ospfLsdbAge=ospfLsdbAge, ospfASBdrRtrStatus=ospfASBdrRtrStatus, ospfNbrLSRetransQLen=ospfNbrLSRetransQLen, ospfIfTransitDelay=ospfIfTransitDelay, ospfIfMetricTable=ospfIfMetricTable, ospfExternLSACount=ospfExternLSACount, ospfIfType=ospfIfType, BigMetric=BigMetric, ospfTOSSupport=ospfTOSSupport, ospfIfMetricTOS=ospfIfMetricTOS, TOSType=TOSType, ospfIfIpAddress=ospfIfIpAddress, ospfIfBackupDesignatedRouter=ospfIfBackupDesignatedRouter, ospfStubAreaEntry=ospfStubAreaEntry, ospfStubAreaTable=ospfStubAreaTable, ospfVirtNbrState=ospfVirtNbrState, ospfNbrIpAddr=ospfNbrIpAddr, ospfVirtNbrEvents=ospfVirtNbrEvents, ospfVersionNumber=ospfVersionNumber, ospfIfPollInterval=ospfIfPollInterval, InterfaceIndex=InterfaceIndex, AreaID=AreaID, ospfIfAreaId=ospfIfAreaId, ospfNbrState=ospfNbrState, ospfLsdbAreaId=ospfLsdbAreaId, ospfNBMANbrStatus=ospfNBMANbrStatus, ospfVirtIfAreaID=ospfVirtIfAreaID, ospfVirtNbrEntry=ospfVirtNbrEntry, ospfIfState=ospfIfState, ospfLsdbEntry=ospfLsdbEntry, ospfAreaRangeEntry=ospfAreaRangeEntry, ospfHostTOS=ospfHostTOS, ospfVirtIfRtrDeadInterval=ospfVirtIfRtrDeadInterval, ospfNbrTable=ospfNbrTable, ospf=ospf, ospfStubMetric=ospfStubMetric, ospfIfRtrDeadInterval=ospfIfRtrDeadInterval, ospfAreaBdrRtrCount=ospfAreaBdrRtrCount, ospfAddressLessIf=ospfAddressLessIf, ospfVirtIfEntry=ospfVirtIfEntry, HelloRange=HelloRange, ospfIfAdminStat=ospfIfAdminStat, ospfIfMetricMetric=ospfIfMetricMetric, ospfAreaRangeAreaID=ospfAreaRangeAreaID, ospfVirtIfNeighbor=ospfVirtIfNeighbor, ospfNbrPriority=ospfNbrPriority, ospfIfRtrPriority=ospfIfRtrPriority, ospfHostMetric=ospfHostMetric, ospfNbrEvents=ospfNbrEvents, ospfLsdbTable=ospfLsdbTable, ospfNbrOptions=ospfNbrOptions, ospfAreaBdrRtrStatus=ospfAreaBdrRtrStatus, ospfAreaLSACount=ospfAreaLSACount, ospfLsdbAdvertisement=ospfLsdbAdvertisement, ospfAreaEntry=ospfAreaEntry, ospfLsdbRouterId=ospfLsdbRouterId, ospfLsdbLSID=ospfLsdbLSID, ospfVirtNbrLSRetransQLen=ospfVirtNbrLSRetransQLen, ospfRxNewLSAs=ospfRxNewLSAs, ospfASBdrRtrCount=ospfASBdrRtrCount, ospfLsdbSequence=ospfLsdbSequence, ospfIfHelloInterval=ospfIfHelloInterval, ospfIfEntry=ospfIfEntry, ospfAuthType=ospfAuthType, ospfVirtIfHelloInterval=ospfVirtIfHelloInterval, ospfVirtNbrRtrId=ospfVirtNbrRtrId, ospfHostEntry=ospfHostEntry, ospfHostTable=ospfHostTable, ospfVirtNbrOptions=ospfVirtNbrOptions, ospfIfRetransInterval=ospfIfRetransInterval, Status=Status, ospfVirtNbrArea=ospfVirtNbrArea, ospfVirtNbrTable=ospfVirtNbrTable, ospfAdminStat=ospfAdminStat, UpToMaxAge=UpToMaxAge, ospfAreaRangeStatus=ospfAreaRangeStatus, ospfAreaRangeTable=ospfAreaRangeTable, ospfHostStatus=ospfHostStatus, ospfVirtIfEvents=ospfVirtIfEvents, ospfIfAuthKey=ospfIfAuthKey, ospfAreaId=ospfAreaId, ospfNbrEntry=ospfNbrEntry, ospfAreaTable=ospfAreaTable, ospfNbrAddressLessIndex=ospfNbrAddressLessIndex, RouterID=RouterID, ospfHostIpAddress=ospfHostIpAddress, ospfIfMetricAddressLessIf=ospfIfMetricAddressLessIf, ospfAreaRangeMask=ospfAreaRangeMask, ospfVirtIfAuthKey=ospfVirtIfAuthKey, PositiveInteger=PositiveInteger, ospfIfMetricStatus=ospfIfMetricStatus, ospfVirtIfState=ospfVirtIfState, ospfIfMetricIpAddress=ospfIfMetricIpAddress, ospfNbrRtrId=ospfNbrRtrId, ospfStubTOS=ospfStubTOS)
