#
# PySNMP MIB module SYSAPPL-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/SYSAPPL-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:05:15 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueSizeConstraint, ValueRangeConstraint, SingleValueConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueSizeConstraint", "ValueRangeConstraint", "SingleValueConstraint", "ConstraintsIntersection")
( ObjectGroup, ModuleCompliance, NotificationGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "ModuleCompliance", "NotificationGroup")
( MibScalar, MibTable, MibTableRow, MibTableColumn, ModuleIdentity, iso, Counter64, TimeTicks, Integer32, Unsigned32, mib_2, ObjectIdentity, NotificationType, MibIdentifier, Bits, Counter32, IpAddress, Gauge32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "ModuleIdentity", "iso", "Counter64", "TimeTicks", "Integer32", "Unsigned32", "mib-2", "ObjectIdentity", "NotificationType", "MibIdentifier", "Bits", "Counter32", "IpAddress", "Gauge32")
( TextualConvention, DateAndTime, DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "TextualConvention", "DateAndTime", "DisplayString")
sysApplMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 54))
if mibBuilder.loadTexts: sysApplMIB.setLastUpdated('9710200000Z')
if mibBuilder.loadTexts: sysApplMIB.setOrganization('IETF Applications MIB Working Group')
if mibBuilder.loadTexts: sysApplMIB.setContactInfo('Cheryl Krupczak (Editor, WG Advisor)\n              Postal: Empire Technologies, Inc.\n              541 Tenth Street NW\n              Suite 169\n              Atlanta, GA 30318\n              USA\n              Phone: (770) 384-0184\n              Email: cheryl@empiretech.com\n\n              Jon Saperia (WG Chair)\n              Postal:  BGS Systems, Inc.\n              One First Avenue\n              Waltham, MA 02254-9111\n              USA\n              Phone: (617) 891-0000\n              Email: saperia@networks.bgs.com')
if mibBuilder.loadTexts: sysApplMIB.setDescription('The MIB module defines management objects that model\n           applications as collections of executables and files\n           installed and executing on a host system.  The MIB\n           presents a system-level view of applications; i.e.,\n           objects in this MIB are limited to those attributes\n           that can typically be obtained from the system itself\n           without adding special instrumentation to the applications.')
sysApplOBJ = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 1))
sysApplInstalled = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 1, 1))
sysApplRun = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 1, 2))
sysApplMap = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 1, 3))
sysApplNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 2))
sysApplConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 3))
class RunState(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))
    namedValues = NamedValues(("running", 1), ("runnable", 2), ("waiting", 3), ("exiting", 4), ("other", 5),)

class LongUtf8String(OctetString, TextualConvention):
    displayHint = '1024a'
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,1024)

class Utf8String(OctetString, TextualConvention):
    displayHint = '255a'
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,255)

sysApplInstallPkgTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 1, 1), )
if mibBuilder.loadTexts: sysApplInstallPkgTable.setDescription('The table listing the software application packages\n           installed on a host computer. In order to appear in\n           this table, it may be necessary for the application\n           to be installed using some type of software\n           installation mechanism or global registry so that its\n           existence can be detected by the agent implementation.')
sysApplInstallPkgEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1), ).setIndexNames((0, "SYSAPPL-MIB", "sysApplInstallPkgIndex"))
if mibBuilder.loadTexts: sysApplInstallPkgEntry.setDescription('The logical row describing an installed application\n           package.')
sysApplInstallPkgIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: sysApplInstallPkgIndex.setDescription('An integer used only for indexing purposes.\n           Generally monotonically increasing from 1 as new\n           applications are installed.\n\n           The value for each installed application must\n           remain constant at least from one re-initialization of\n           the network management entity which implements this\n           MIB module to the next re-initialization.\n\n           The specific value is meaningful only within a given SNMP\n           entity. A sysApplInstallPkgIndex value must not be re-used\n           until the next agent entity restart in the event the\n           installed application entry is deleted.')
sysApplInstallPkgManufacturer = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 2), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgManufacturer.setDescription('The Manufacturer of the software application package.')
sysApplInstallPkgProductName = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 3), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgProductName.setDescription('The name assigned to the software application package\n           by the Manufacturer.')
sysApplInstallPkgVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 4), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgVersion.setDescription('The version number assigned to the application package\n           by the manufacturer of the software.')
sysApplInstallPkgSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 5), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgSerialNumber.setDescription('The serial number of the software assigned by the\n           manufacturer.')
sysApplInstallPkgDate = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 6), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgDate.setDescription('The date and time this software application was installed\n           on the host.')
sysApplInstallPkgLocation = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 1, 1, 7), LongUtf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallPkgLocation.setDescription("The complete path name where the application package\n           is installed.  For example, the value would be\n           '/opt/MyapplDir' if the application package was installed\n           in the /opt/MyapplDir directory.")
sysApplInstallElmtTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 1, 2), )
if mibBuilder.loadTexts: sysApplInstallElmtTable.setDescription('This table details the individual application package\n           elements (files and executables) which comprise the\n           applications defined in the sysApplInstallPkg Table.\n           Each entry in this table has an index to the\n           sysApplInstallPkg table to identify the application\n           package of which it is a part. As a result, there may\n           be many entries in this table for each instance in the\n           sysApplInstallPkg Table.\n\n           Table entries are indexed by sysApplInstallPkgIndex,\n           sysApplInstallElmtIndex to facilitate retrieval of\n           all elements associated with a particular installed\n           application package.')
sysApplInstallElmtEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1), ).setIndexNames((0, "SYSAPPL-MIB", "sysApplInstallPkgIndex"), (0, "SYSAPPL-MIB", "sysApplInstallElmtIndex"))
if mibBuilder.loadTexts: sysApplInstallElmtEntry.setDescription('The logical row describing an element of an installed\n           application.  The element may be an executable or\n           non-executable file.')
sysApplInstallElmtIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: sysApplInstallElmtIndex.setDescription('An arbitrary integer used for indexing.  The value\n           of this index is unique among all rows in this table\n           that exist or have existed since the last agent restart.')
sysApplInstallElmtName = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 2), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtName.setDescription('The name of this element which is contained in the\n           application.')
sysApplInstallElmtType = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("unknown", 1), ("nonexecutable", 2), ("operatingSystem", 3), ("deviceDriver", 4), ("application", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtType.setDescription('The type of element that is part of the installed\n           application.')
sysApplInstallElmtDate = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtDate.setDescription('The date and time that this component was installed on\n           the system.')
sysApplInstallElmtPath = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 5), LongUtf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtPath.setDescription("The full directory path where this element is installed.\n           For example, the value would be '/opt/EMPuma/bin' for an\n           element installed in the directory '/opt/EMPuma/bin'.\n           Most application packages include information about the\n           elements contained in the package. In addition, elements\n           are typically installed in sub-directories under the\n           package installation directory.  In cases where the\n           element path names are not included in the package\n           information itself, the path can usually be determined\n           by a simple search of the sub-directories.  If the\n           element is not installed in that location and there is\n           no other information available to the agent implementation,\n           then the path is unknown and null is returned.")
sysApplInstallElmtSizeHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtSizeHigh.setDescription('The installed file size in 2^32 byte blocks. This is\n           the size of the file on disk immediately after installation.\n\n           For example, for a file with a total size of 4,294,967,296\n           bytes, this variable would have a value of 1; for a file\n           with a total size of 4,294,967,295 bytes this variable\n           would be 0.')
sysApplInstallElmtSizeLow = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtSizeLow.setDescription('The installed file size modulo 2^32 bytes.  This is\n           the size of the file on disk immediately after installation.\n\n           For example, for a file with a total size of 4,294,967,296\n           bytes this variable would have a value of 0; for a file with\n           a total size of 4,294,967,295 bytes this variable would be\n           4,294,967,295.')
sysApplInstallElmtRole = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 8), Bits().clone(namedValues=NamedValues(("executable", 0), ("exclusive", 1), ("primary", 2), ("required", 3), ("dependent", 4), ("unknown", 5),)).clone(namedValues=NamedValues(("unknown", 5),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysApplInstallElmtRole.setDescription('An operator assigned value used in the determination of\n           application status. This value is used by the agent to\n           determine both the mapping of started processes to the\n           initiation of an application, as well as to allow for a\n           determination of application health. The default value,\n           unknown(5), is used when an operator has not yet assigned\n           one of the other values.  If unknown(5) is set, bits\n           1 - 4 have no meaning.  The possible values are:\n\n                   executable(0),\n                       An application may have one or\n                       more executable elements.  The rest of the\n                       bits have no meaning if the element is not\n                       executable.\n                   exclusive(1),\n                       Only one copy of an exclusive element may be\n                       running per invocation of the running\n                       application.\n                   primary(2),\n                       The primary executable.  An application can\n                       have one, and only one element that is designated\n                       as the primary executable.  The execution of\n                       this element constitutes an invocation of\n                       the application.  This is used by the agent\n                       implementation to determine the initiation of\n                       an application.  The primary executable must\n                       remain running long enough for the agent\n                       implementation to detect its presence.\n                   required(3),\n                       An application may have zero or more required\n                       elements. All required elements must be running\n                       in order for the application to be judged to be\n                       running and healthy.\n                   dependent(4),\n                       An application may have zero or more\n                       dependent elements. Dependent elements may\n                       not be running unless required elements are.\n                   unknown(5)\n                       Default value for the case when an operator\n                       has not yet assigned one of the other values.\n                       When set, bits 1, 2, 3, and 4 have no meaning.\n\n            sysApplInstallElmtRole is used by the agent implementation\n            in determining the initiation of an application, the\n            current state of a running application (see\n            sysApplRunCurrentState), when an application invocation is\n            no longer running, and the exit status of a terminated\n            application invocation (see sysApplPastRunExitState).')
sysApplInstallElmtModifyDate = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 9), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtModifyDate.setDescription('The date and time that this element was last modified.\n           Modification of the sysApplInstallElmtRole columnar\n           object does NOT constitute a modification of the element\n           itself and should not affect the value of this object.')
sysApplInstallElmtCurSizeHigh = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtCurSizeHigh.setDescription('The current file size in 2^32 byte blocks.\n           For example, for a file with a total size of 4,294,967,296\n           bytes, this variable would have a value of 1; for a file\n           with a total size of 4,294,967,295 bytes this variable\n           would be 0.')
sysApplInstallElmtCurSizeLow = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 1, 2, 1, 11), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplInstallElmtCurSizeLow.setDescription('The current file size modulo 2^32 bytes.\n           For example, for a file with a total size of 4,294,967,296\n           bytes this variable would have a value of 0; for a file with\n           a total size of 4,294,967,295 bytes this variable would be\n           4,294,967,295.')
sysApplRunTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 2, 1), )
if mibBuilder.loadTexts: sysApplRunTable.setDescription("The table describes the applications which are executing\n           on the host.  Each time an application is invoked,\n           an entry is created in this table. When an application ends,\n           the entry is removed from this table and a corresponding\n                   entry is created in the SysApplPastRunTable.\n\n           A new entry is created in this table whenever the agent\n           implementation detects a new running process that is an\n           installed application element whose sysApplInstallElmtRole\n           designates it as being the application's primary executable\n           (sysApplInstallElmtRole = primary(2) ).\n\n           The table is indexed by sysApplInstallPkgIndex,\n           sysApplRunIndex to enable managers to easily locate all\n           invocations of a particular application package.")
sysApplRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 2, 1, 1), ).setIndexNames((0, "SYSAPPL-MIB", "sysApplInstallPkgIndex"), (0, "SYSAPPL-MIB", "sysApplRunIndex"))
if mibBuilder.loadTexts: sysApplRunEntry.setDescription('The logical row describing an application which is\n           currently running on this host.')
sysApplRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: sysApplRunIndex.setDescription('Part of the index for this table. An arbitrary\n           integer used only for indexing purposes. Generally\n           monotonically increasing from 1 as new applications are\n           started on the host, it uniquely identifies application\n           invocations.\n\n           The numbering for this index increases by 1 for each\n           INVOCATION of an application, regardless of which\n           installed application package this entry represents a\n           running instance of.\n\n           An example of the indexing for a couple of entries is\n           shown below.\n\n                         :\n                    sysApplRunStarted.17.14\n                    sysApplRunStarted.17.63\n                    sysApplRunStarted.18.13\n                         :\n\n           In this example, the agent has observed 12 application\n           invocations when the application represented by entry 18\n           in the sysApplInstallPkgTable is invoked.  The next\n           invocation detected by the agent is an invocation of\n           installed application package 17.  Some time later,\n           installed application 17 is invoked a second time.\n\n           NOTE: this index is not intended to reflect a real-time\n           (wall clock time) ordering of application invocations;\n           it is merely intended to uniquely identify running\n           instances of applications.  Although the\n           sysApplInstallPkgIndex is included in the INDEX clause\n           for this table, it serves only to ease searching of\n           this table by installed application and does not\n           contribute to uniquely identifying table entries.')
sysApplRunStarted = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 1, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplRunStarted.setDescription('The date and time that the application was started.')
sysApplRunCurrentState = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 1, 1, 3), RunState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplRunCurrentState.setDescription('The current state of the running application instance.\n           The possible values are running(1), runnable(2) but waiting\n           for a resource such as CPU, waiting(3) for an event,\n           exiting(4), or other(5). This value is based on an evaluation\n           of the running elements of this application instance (see\n           sysApplElmRunState) and their Roles as defined by\n           sysApplInstallElmtRole.  An agent implementation may\n           detect that an application instance is in the process of\n           exiting if one or more of its REQUIRED elements are no\n           longer running.  Most agent implementations will wait until\n           a second internal poll has been completed to give the\n           system time to start REQUIRED elements before marking the\n           application instance as exiting.')
sysApplPastRunTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 2, 2), )
if mibBuilder.loadTexts: sysApplPastRunTable.setDescription("A history of the applications that have previously run\n           on the host computer.  An entry's information is moved to\n           this table from the sysApplRunTable when the invoked\n           application represented by the entry ceases to be running.\n\n           An agent implementation can determine that an application\n           invocation is no longer running by evaluating the running\n           elements of the application instance and their Roles as\n           defined by sysApplInstallElmtRole.  Obviously, if there\n           are no running elements for the application instance,\n           then the application invocation is no longer running.\n           If any one of the REQUIRED elements is not running,\n           the application instance may be in the process of exiting.\n           Most agent implementations will wait until a second internal\n           poll has been completed to give the system time to either\n           restart partial failures or to give all elements time to\n           exit.  If, after the second poll, there are REQUIRED\n           elements that are not running, then the application\n           instance may be considered by the agent implementation\n           to no longer be running.\n\n           Entries remain in the sysApplPastRunTable until they\n           are aged out when either the table size reaches a maximum\n           as determined by the sysApplPastRunMaxRows, or when an entry\n           has aged to exceed a time limit as set by\n           sysApplPastRunTblTimeLimit.\n\n           Entries in this table are indexed by sysApplInstallPkgIndex,\n           sysApplPastRunIndex to facilitate retrieval of all past\n           run invocations of a particular installed application.")
sysApplPastRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 2, 2, 1), ).setIndexNames((0, "SYSAPPL-MIB", "sysApplInstallPkgIndex"), (0, "SYSAPPL-MIB", "sysApplPastRunIndex"))
if mibBuilder.loadTexts: sysApplPastRunEntry.setDescription("The logical row describing an invocation of an application\n           which was previously run and has terminated.  The entry\n           is basically copied from the sysApplRunTable when the\n           application instance terminates.  Hence, the entry's\n           value for sysApplPastRunIndex is the same as its value was\n           for sysApplRunIndex.")
sysApplPastRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: sysApplPastRunIndex.setDescription('Part of the index for this table. An integer\n           matching the value of the removed sysApplRunIndex\n           corresponding to this row.')
sysApplPastRunStarted = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 2, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplPastRunStarted.setDescription('The date and time that the application was started.')
sysApplPastRunExitState = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 2, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("complete", 1), ("failed", 2), ("other", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplPastRunExitState.setDescription('The state of the application instance when it terminated.\n          This value is based on an evaluation of the running elements\n          of an application and their Roles as defined by\n          sysApplInstallElmtRole.  An application instance is said to\n          have exited in a COMPLETE state and its entry is removed\n          from the sysApplRunTable and added to the sysApplPastRunTable\n          when the agent detects that ALL elements of an application\n          invocation are no longer running.  Most agent implementations\n          will wait until a second internal poll has been completed to\n          give the system time to either restart partial failures or\n          to give all elements time to exit.  A failed state occurs if,\n          after the second poll, any elements continue to run but\n          one or more of the REQUIRED elements are no longer running.\n          All other combinations MUST be defined as OTHER.')
sysApplPastRunTimeEnded = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 2, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplPastRunTimeEnded.setDescription('The DateAndTime the application instance was determined\n           to be no longer running.')
sysApplElmtRunTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 2, 3), )
if mibBuilder.loadTexts: sysApplElmtRunTable.setDescription("The table describes the processes which are\n           currently executing on the host system. Each entry\n           represents a running process and is associated with\n           the invoked application of which that process is a part, if\n           possible.  This table contains an entry for every process\n           currently running on the system, regardless of whether its\n           'parent' application can be determined.  So, for example,\n           processes like 'ps' and 'grep' will have entries though they\n           are not associated with an installed application package.\n\n           Because a running application may involve\n           more than one executable, it is possible to have\n           multiple entries in this table for each application.\n           Entries are removed from this table when the process\n           terminates.\n           The table is indexed by sysApplElmtRunInstallPkg,\n           sysApplElmtRunInvocID, and sysApplElmtRunIndex to\n           facilitate the retrieval of all running elements of a\n           particular invoked application which has been installed on\n           the system.")
sysApplElmtRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1), ).setIndexNames((0, "SYSAPPL-MIB", "sysApplElmtRunInstallPkg"), (0, "SYSAPPL-MIB", "sysApplElmtRunInvocID"), (0, "SYSAPPL-MIB", "sysApplElmtRunIndex"))
if mibBuilder.loadTexts: sysApplElmtRunEntry.setDescription('The logical row describing a process currently\n           running on this host.  When possible, the entry is\n           associated with the invoked application of which it\n           is a part.')
sysApplElmtRunInstallPkg = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: sysApplElmtRunInstallPkg.setDescription("Part of the index for this table, this value\n           identifies the installed software package for\n           the application of which this process is a part.\n           Provided that the process's 'parent' application can be\n           determined, the value of this object is the same\n           value as the sysApplInstallPkgIndex for the\n           entry in the sysApplInstallPkgTable that corresponds\n           to the installed application of which this process\n           is a part.\n\n           If, however, the 'parent' application cannot be\n           determined, (for example the process is not part\n           of a particular installed application), the value\n           for this object is then '0', signifying that this\n           process cannot be related back to an application,\n           and in turn, an installed software package.")
sysApplElmtRunInvocID = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: sysApplElmtRunInvocID.setDescription("Part of the index for this table, this value\n           identifies the invocation of an application of which\n           this process is a part.  Provided that the 'parent'\n           application can be determined, the value of this object\n           is the same value as the sysApplRunIndex for the\n           corresponding application invocation in the\n           sysApplRunTable.\n\n           If, however, the 'parent' application cannot be\n           determined, the value for this object is then '0',\n           signifying that this process cannot be related back\n           to an invocation of an application in the\n           sysApplRunTable.")
sysApplElmtRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: sysApplElmtRunIndex.setDescription("Part of the index for this table.  A unique value\n           for each process running on the host.  Wherever\n           possible, this should be the system's native, unique\n           identification number.")
sysApplElmtRunInstallID = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunInstallID.setDescription("The index into the sysApplInstallElmtTable. The\n           value of this object is the same value as the\n           sysApplInstallElmtIndex for the application element\n           of which this entry represents a running instance.\n           If this process cannot be associated with an installed\n           executable, the value should be '0'.")
sysApplElmtRunTimeStarted = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunTimeStarted.setDescription('The time the process was started.')
sysApplElmtRunState = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 6), RunState()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunState.setDescription('The current state of the running process. The\n           possible values are running(1), runnable(2) but waiting\n           for a resource such as CPU, waiting(3) for an event,\n           exiting(4), or other(5).')
sysApplElmtRunName = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 7), LongUtf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunName.setDescription("The full path and filename of the process.\n           For example, '/opt/MYYpkg/bin/myyproc' would\n           be returned for process 'myyproc' whose execution\n           path is '/opt/MYYpkg/bin/myyproc'.")
sysApplElmtRunParameters = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 8), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunParameters.setDescription('The starting parameters for the process.')
sysApplElmtRunCPU = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 9), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunCPU.setDescription("The number of centi-seconds of the total system's\n            CPU resources consumed by this process.  Note that\n            on a multi-processor system, this value may\n            have been incremented by more than one centi-second\n            in one centi-second of real (wall clock) time.")
sysApplElmtRunMemory = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 10), Gauge32()).setUnits('Kbytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunMemory.setDescription('The total amount of real system memory measured in\n           Kbytes currently allocated to this process.')
sysApplElmtRunNumFiles = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 11), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunNumFiles.setDescription('The number of regular files currently open by the\n           process.  Transport connections (sockets)\n           should NOT be included in the calculation of\n           this value, nor should operating system specific\n           special file types.')
sysApplElmtRunUser = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 3, 1, 12), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtRunUser.setDescription("The process owner's login name (e.g. root).")
sysApplElmtPastRunTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 2, 4), )
if mibBuilder.loadTexts: sysApplElmtPastRunTable.setDescription('The table describes the processes which have previously\n           executed on the host system as part of an application.\n           Each entry represents a process which has previously\n           executed and is associated with the invoked application\n           of which it was a part.  Because an invoked application\n           may involve more than one executable, it is possible\n           to have multiple entries in this table for\n           each application invocation. Entries are added\n           to this table when the corresponding process in the\n           sysApplElmtRun Table terminates.\n\n           Entries remain in this table until they are aged out when\n           either the number of entries in the table reaches a\n           maximum as determined by sysApplElmtPastRunMaxRows, or\n           when an entry has aged to exceed a time limit as set by\n           sysApplElmtPastRunTblTimeLimit.  When aging out entries,\n           the oldest entry, as determined by the value of\n           sysApplElmtPastRunTimeEnded, will be removed first.\n\n           The table is indexed by sysApplInstallPkgIndex (from the\n           sysApplInstallPkgTable), sysApplElmtPastRunInvocID,\n           and sysApplElmtPastRunIndex to make it easy to locate all\n           previously executed processes of a particular invoked\n           application that has been installed on the system.')
sysApplElmtPastRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1), ).setIndexNames((0, "SYSAPPL-MIB", "sysApplInstallPkgIndex"), (0, "SYSAPPL-MIB", "sysApplElmtPastRunInvocID"), (0, "SYSAPPL-MIB", "sysApplElmtPastRunIndex"))
if mibBuilder.loadTexts: sysApplElmtPastRunEntry.setDescription("The logical row describing a process which was\n           previously executed on this host as part of an\n           installed application.  The entry is basically copied\n           from the sysApplElmtRunTable when the process\n           terminates.  Hence, the entry's value for\n           sysApplElmtPastRunIndex is the same as its value\n           was for sysApplElmtRunIndex.  Note carefully: only those\n           processes which could be associated with an\n           identified application are included in this table.")
sysApplElmtPastRunInvocID = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: sysApplElmtPastRunInvocID.setDescription('Part of the index for this table, this value\n           identifies the invocation of an application of which\n           the process represented by this entry was a part.\n           The value of this object is the same value as the\n           sysApplRunIndex for the corresponding application\n           invocation in the sysApplRunTable.  If the invoked\n           application as a whole has terminated, it will be the\n           same as the sysApplPastRunIndex.')
sysApplElmtPastRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: sysApplElmtPastRunIndex.setDescription("Part of the index for this table. An integer\n           assigned by the agent equal to the corresponding\n           sysApplElmtRunIndex which was removed from the\n           sysApplElmtRunTable and moved to this table\n           when the element terminated.\n\n           Note: entries in this table are indexed by\n           sysApplElmtPastRunInvocID, sysApplElmtPastRunIndex.\n           The possibility exists, though unlikely, of a\n           collision occurring by a new entry which was run\n           by the same invoked application (InvocID), and\n           was assigned the same process identification number\n           (ElmtRunIndex) as an element which was previously\n           run by the same invoked application.\n\n           Should this situation occur, the new entry replaces\n           the old entry.\n\n           See Section: 'Implementation Issues -\n           sysApplElmtPastRunTable Entry Collisions' for the\n           conditions that would have to occur in order for a\n           collision to occur.")
sysApplElmtPastRunInstallID = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunInstallID.setDescription('The index into the installed element table. The\n           value of this object is the same value as the\n           sysApplInstallElmtIndex for the application element\n           of which this entry represents a previously executed\n           process.')
sysApplElmtPastRunTimeStarted = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunTimeStarted.setDescription('The time the process was started.')
sysApplElmtPastRunTimeEnded = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunTimeEnded.setDescription('The time the process ended.')
sysApplElmtPastRunName = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 6), LongUtf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunName.setDescription("The full path and filename of the process.\n           For example, '/opt/MYYpkg/bin/myyproc' would\n           be returned for process 'myyproc' whose execution\n           path was '/opt/MYYpkg/bin/myyproc'.")
sysApplElmtPastRunParameters = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 7), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunParameters.setDescription('The starting parameters for the process.')
sysApplElmtPastRunCPU = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 8), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunCPU.setDescription("The last known number of centi-seconds of the total\n            system's CPU resources consumed by this process.\n            Note that on a multi-processor system, this value may\n            increment by more than one centi-second in one\n            centi-second of real (wall clock) time.")
sysApplElmtPastRunMemory = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 9), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setUnits('Kbytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunMemory.setDescription('The last known total amount of real system memory\n           measured in Kbytes allocated to this process before it\n           terminated.')
sysApplElmtPastRunNumFiles = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunNumFiles.setDescription('The last known number of files open by the\n           process before it terminated.  Transport\n           connections (sockets) should NOT be included in\n           the calculation of this value.')
sysApplElmtPastRunUser = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 2, 4, 1, 11), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElmtPastRunUser.setDescription("The process owner's login name (e.g. root).")
sysApplPastRunMaxRows = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)).clone(500)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysApplPastRunMaxRows.setDescription('The maximum number of entries allowed in the\n           sysApplPastRunTable.  Once the number of rows in\n           the sysApplPastRunTable reaches this value, the\n           management subsystem will remove the oldest entry\n           in the table to make room for the new entry to be added.\n           Entries will be removed on the basis of oldest\n           sysApplPastRunTimeEnded value first.\n\n           This object may be used to control the amount of\n           system resources that can used for sysApplPastRunTable\n           entries. A conforming implementation should attempt\n           to support the default value, however, a lesser value\n           may be necessary due to implementation-dependent issues\n           and resource availability.')
sysApplPastRunTableRemItems = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplPastRunTableRemItems.setDescription('A counter of the number of entries removed from\n           the sysApplPastRunTable because of table size limitations\n           as set in sysApplPastRunMaxRows.  This counter is the\n           number of entries the management subsystem has had to\n           remove in order to make room for new entries (so as not\n           to exceed the limit set by sysApplPastRunMaxRows) since\n           the last initialization of the management subsystem.')
sysApplPastRunTblTimeLimit = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 7), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)).clone(7200)).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysApplPastRunTblTimeLimit.setDescription('The maximum time in seconds which an entry in the\n            sysApplPastRunTable may exist before it is removed.\n            Any entry that is older than this value will be\n            removed (aged out) from the table.\n\n            Note that an entry may be aged out prior to reaching\n            this time limit if it is the oldest entry in the\n            table and must be removed to make space for a new\n            entry so as to not exceed sysApplPastRunMaxRows.')
sysApplElemPastRunMaxRows = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)).clone(500)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysApplElemPastRunMaxRows.setDescription('The maximum number of entries allowed in the\n           sysApplElmtPastRunTable.  Once the number of rows in\n           the sysApplElmtPastRunTable reaches this value,\n           the management subsystem will remove the oldest entry\n           to make room for the new entry to be added.  Entries\n           will be removed on the basis of oldest\n           sysApplElmtPastRunTimeEnded value first.\n           This object may be used to control the amount of\n           system resources that can used for sysApplElemPastRunTable\n           entries. A conforming implementation should attempt\n           to support the default value, however, a lesser value\n           may be necessary due to implementation-dependent issues\n           and resource availability.')
sysApplElemPastRunTableRemItems = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplElemPastRunTableRemItems.setDescription('A counter of the number of entries removed from the\n           sysApplElemPastRunTable because of table size limitations\n           as set in sysApplElemPastRunMaxRows.  This counter is the\n           number of entries the management subsystem has had to\n           remove in order to make room for new entries (so as not\n           to exceed the limit set by sysApplElemPastRunMaxRows) since\n           the last initialization of the management subsystem.')
sysApplElemPastRunTblTimeLimit = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)).clone(7200)).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysApplElemPastRunTblTimeLimit.setDescription('The maximum time in seconds which an entry in the\n            sysApplElemPastRunTable may exist before it is removed.\n            Any entry that is older than this value will be\n            removed (aged out) from the table.\n\n            Note that an entry may be aged out prior to reaching\n            this time limit if it is the oldest entry in the\n            table and must be removed to make space for a new\n            entry so as to not exceed sysApplElemPastRunMaxRows.')
sysApplAgentPollInterval = MibScalar((1, 3, 6, 1, 2, 1, 54, 1, 2, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)).clone(60)).setUnits('seconds').setMaxAccess("readwrite")
if mibBuilder.loadTexts: sysApplAgentPollInterval.setDescription('The minimum interval in seconds that the management\n           subsystem implementing this MIB will poll the status\n           of the managed resources. Because of the non-trivial\n           effort involved in polling the managed resources,\n           and because the method for obtaining the status of\n           the managed resources is implementation-dependent,\n           a conformant implementation may chose a lower bound\n           greater than 0.\n\n           A value of 0 indicates that there is no delay\n           in the passing of information from the managed\n           resources to the agent.')
sysApplMapTable = MibTable((1, 3, 6, 1, 2, 1, 54, 1, 3, 1), )
if mibBuilder.loadTexts: sysApplMapTable.setDescription("The sole purpose of this table is to provide a\n           'backwards' mapping so that, given a known\n           sysApplElmtRunIndex (process identification number),\n           the corresponding invoked application (sysApplRunIndex),\n           installed element (sysApplInstallElmtIndex), and\n           installed application package (sysApplInstallPkgIndex)\n           can be quickly determined.\n\n           This table will contain one entry for each process\n           that is currently executing on the system.\n\n           It is expected that management applications will use\n           this mapping table by doing a 'GetNext' operation with\n           the known process ID number (sysApplElmtRunIndex) as the\n           partial instance identifier.  Assuming that there is an\n           entry for the process, the result should return a single\n           columnar value, the sysApplMapInstallPkgIndex, with the\n           sysApplElmtRunIndex, sysApplRunIndex, and\n           sysApplInstallElmtIndex contained in the instance identifier\n           for the returned MIB object value.\n\n           NOTE: if the process can not be associated back to an\n           invoked application installed on the system, then the\n           value returned for the columnar value\n           sysApplMapInstallPkgIndex will be '0' and the instance\n           portion of the object-identifier will be the process ID\n           number (sysApplElmtRunIndex) followed by 0.0.")
sysApplMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 54, 1, 3, 1, 1), ).setIndexNames((0, "SYSAPPL-MIB", "sysApplElmtRunIndex"), (0, "SYSAPPL-MIB", "sysApplElmtRunInvocID"), (0, "SYSAPPL-MIB", "sysApplMapInstallElmtIndex"))
if mibBuilder.loadTexts: sysApplMapEntry.setDescription('A logical row representing a process currently running\n            on the system.  This entry provides the index mapping from\n            process identifier, back to the invoked application,\n            installed element, and finally, the installed application\n            package.  The entry includes only one accessible columnar\n            object, the sysApplMapInstallPkgIndex, but the\n            invoked application and installed element can be\n            determined from the instance identifier since they form\n            part of the index clause.')
sysApplMapInstallElmtIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 3, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295)))
if mibBuilder.loadTexts: sysApplMapInstallElmtIndex.setDescription("The index into the sysApplInstallElmtTable. The\n           value of this object is the same value as the\n           sysApplInstallElmtIndex for the application element\n           of which this entry represents a running instance.\n           If this process cannot be associated to an installed\n           executable, the value should be '0'.")
sysApplMapInstallPkgIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 54, 1, 3, 1, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: sysApplMapInstallPkgIndex.setDescription("The value of this object identifies the installed\n           software package for the application of which this\n           process is a part.  Provided that the process's 'parent'\n           application can be determined, the value of this object\n           is the same value as the sysApplInstallPkgIndex for the\n           entry in the sysApplInstallPkgTable that corresponds\n           to the installed application of which this process\n           is a part.\n\n           If, however, the 'parent' application cannot be\n           determined, (for example the process is not part\n           of a particular installed application), the value\n           for this object is then '0', signifying that this\n           process cannot be related back to an application,\n           and in turn, an installed software package.")
sysApplMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 3, 1))
sysApplMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 54, 3, 2))
sysApplMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 54, 3, 1, 1)).setObjects(*(("SYSAPPL-MIB", "sysApplInstalledGroup"), ("SYSAPPL-MIB", "sysApplRunGroup"), ("SYSAPPL-MIB", "sysApplMapGroup"),))
if mibBuilder.loadTexts: sysApplMIBCompliance.setDescription('Describes the requirements for conformance to\n           the System Application MIB')
sysApplInstalledGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 54, 3, 2, 1)).setObjects(*(("SYSAPPL-MIB", "sysApplInstallPkgManufacturer"), ("SYSAPPL-MIB", "sysApplInstallPkgProductName"), ("SYSAPPL-MIB", "sysApplInstallPkgVersion"), ("SYSAPPL-MIB", "sysApplInstallPkgSerialNumber"), ("SYSAPPL-MIB", "sysApplInstallPkgDate"), ("SYSAPPL-MIB", "sysApplInstallPkgLocation"), ("SYSAPPL-MIB", "sysApplInstallElmtName"), ("SYSAPPL-MIB", "sysApplInstallElmtType"), ("SYSAPPL-MIB", "sysApplInstallElmtDate"), ("SYSAPPL-MIB", "sysApplInstallElmtPath"), ("SYSAPPL-MIB", "sysApplInstallElmtSizeHigh"), ("SYSAPPL-MIB", "sysApplInstallElmtSizeLow"), ("SYSAPPL-MIB", "sysApplInstallElmtRole"), ("SYSAPPL-MIB", "sysApplInstallElmtModifyDate"), ("SYSAPPL-MIB", "sysApplInstallElmtCurSizeHigh"), ("SYSAPPL-MIB", "sysApplInstallElmtCurSizeLow"),))
if mibBuilder.loadTexts: sysApplInstalledGroup.setDescription('The system application installed group contains\n           information about applications and their constituent\n           components which have been installed on the host system.')
sysApplRunGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 54, 3, 2, 2)).setObjects(*(("SYSAPPL-MIB", "sysApplRunStarted"), ("SYSAPPL-MIB", "sysApplRunCurrentState"), ("SYSAPPL-MIB", "sysApplPastRunStarted"), ("SYSAPPL-MIB", "sysApplPastRunExitState"), ("SYSAPPL-MIB", "sysApplPastRunTimeEnded"), ("SYSAPPL-MIB", "sysApplElmtRunInstallID"), ("SYSAPPL-MIB", "sysApplElmtRunTimeStarted"), ("SYSAPPL-MIB", "sysApplElmtRunState"), ("SYSAPPL-MIB", "sysApplElmtRunName"), ("SYSAPPL-MIB", "sysApplElmtRunParameters"), ("SYSAPPL-MIB", "sysApplElmtRunCPU"), ("SYSAPPL-MIB", "sysApplElmtRunMemory"), ("SYSAPPL-MIB", "sysApplElmtRunNumFiles"), ("SYSAPPL-MIB", "sysApplElmtRunUser"), ("SYSAPPL-MIB", "sysApplElmtPastRunInstallID"), ("SYSAPPL-MIB", "sysApplElmtPastRunTimeStarted"), ("SYSAPPL-MIB", "sysApplElmtPastRunTimeEnded"), ("SYSAPPL-MIB", "sysApplElmtPastRunName"), ("SYSAPPL-MIB", "sysApplElmtPastRunParameters"), ("SYSAPPL-MIB", "sysApplElmtPastRunCPU"), ("SYSAPPL-MIB", "sysApplElmtPastRunMemory"), ("SYSAPPL-MIB", "sysApplElmtPastRunNumFiles"), ("SYSAPPL-MIB", "sysApplElmtPastRunUser"), ("SYSAPPL-MIB", "sysApplPastRunMaxRows"), ("SYSAPPL-MIB", "sysApplPastRunTableRemItems"), ("SYSAPPL-MIB", "sysApplPastRunTblTimeLimit"), ("SYSAPPL-MIB", "sysApplElemPastRunMaxRows"), ("SYSAPPL-MIB", "sysApplElemPastRunTableRemItems"), ("SYSAPPL-MIB", "sysApplElemPastRunTblTimeLimit"), ("SYSAPPL-MIB", "sysApplAgentPollInterval"),))
if mibBuilder.loadTexts: sysApplRunGroup.setDescription('The system application run group contains information\n           about applications and associated elements which have\n           run or are currently running on the host system.')
sysApplMapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 54, 3, 2, 3)).setObjects(*(("SYSAPPL-MIB", "sysApplMapInstallPkgIndex"),))
if mibBuilder.loadTexts: sysApplMapGroup.setDescription('The Map Group contains a single table, sysApplMapTable,\n           that provides a backwards mapping for determining the\n           invoked application, installed element, and installed\n           application package given a known process identification\n           number.')
mibBuilder.exportSymbols("SYSAPPL-MIB", sysApplNotifications=sysApplNotifications, sysApplElmtPastRunCPU=sysApplElmtPastRunCPU, sysApplInstallPkgDate=sysApplInstallPkgDate, PYSNMP_MODULE_ID=sysApplMIB, sysApplInstallPkgEntry=sysApplInstallPkgEntry, RunState=RunState, sysApplElmtRunMemory=sysApplElmtRunMemory, sysApplInstallElmtEntry=sysApplInstallElmtEntry, sysApplElmtRunName=sysApplElmtRunName, sysApplRunCurrentState=sysApplRunCurrentState, sysApplInstallElmtPath=sysApplInstallElmtPath, sysApplPastRunExitState=sysApplPastRunExitState, sysApplInstallElmtType=sysApplInstallElmtType, sysApplInstallElmtRole=sysApplInstallElmtRole, sysApplInstalled=sysApplInstalled, sysApplElmtPastRunUser=sysApplElmtPastRunUser, sysApplMIB=sysApplMIB, sysApplRunIndex=sysApplRunIndex, sysApplElmtPastRunInstallID=sysApplElmtPastRunInstallID, sysApplElmtRunTimeStarted=sysApplElmtRunTimeStarted, sysApplMapGroup=sysApplMapGroup, sysApplElmtPastRunIndex=sysApplElmtPastRunIndex, sysApplRun=sysApplRun, sysApplElmtRunState=sysApplElmtRunState, sysApplElmtRunIndex=sysApplElmtRunIndex, sysApplElmtPastRunTimeStarted=sysApplElmtPastRunTimeStarted, sysApplElemPastRunTableRemItems=sysApplElemPastRunTableRemItems, Utf8String=Utf8String, sysApplInstallElmtName=sysApplInstallElmtName, sysApplOBJ=sysApplOBJ, sysApplConformance=sysApplConformance, sysApplElmtRunParameters=sysApplElmtRunParameters, sysApplRunStarted=sysApplRunStarted, sysApplElmtRunEntry=sysApplElmtRunEntry, sysApplRunTable=sysApplRunTable, sysApplInstallElmtModifyDate=sysApplInstallElmtModifyDate, sysApplMapInstallPkgIndex=sysApplMapInstallPkgIndex, sysApplInstallPkgProductName=sysApplInstallPkgProductName, sysApplAgentPollInterval=sysApplAgentPollInterval, sysApplMapInstallElmtIndex=sysApplMapInstallElmtIndex, sysApplInstallPkgVersion=sysApplInstallPkgVersion, sysApplPastRunIndex=sysApplPastRunIndex, sysApplElmtRunTable=sysApplElmtRunTable, sysApplInstalledGroup=sysApplInstalledGroup, sysApplInstallPkgSerialNumber=sysApplInstallPkgSerialNumber, sysApplElmtPastRunTimeEnded=sysApplElmtPastRunTimeEnded, sysApplMapEntry=sysApplMapEntry, sysApplInstallElmtCurSizeLow=sysApplInstallElmtCurSizeLow, sysApplMapTable=sysApplMapTable, sysApplElmtPastRunNumFiles=sysApplElmtPastRunNumFiles, sysApplPastRunTable=sysApplPastRunTable, sysApplInstallElmtIndex=sysApplInstallElmtIndex, sysApplInstallPkgManufacturer=sysApplInstallPkgManufacturer, sysApplPastRunStarted=sysApplPastRunStarted, sysApplElmtPastRunTable=sysApplElmtPastRunTable, sysApplElmtRunInstallID=sysApplElmtRunInstallID, sysApplElmtRunUser=sysApplElmtRunUser, sysApplMIBGroups=sysApplMIBGroups, sysApplRunEntry=sysApplRunEntry, sysApplPastRunTableRemItems=sysApplPastRunTableRemItems, sysApplInstallPkgLocation=sysApplInstallPkgLocation, sysApplInstallElmtSizeHigh=sysApplInstallElmtSizeHigh, sysApplElmtRunInvocID=sysApplElmtRunInvocID, sysApplMIBCompliance=sysApplMIBCompliance, sysApplElmtPastRunMemory=sysApplElmtPastRunMemory, sysApplInstallPkgIndex=sysApplInstallPkgIndex, sysApplPastRunEntry=sysApplPastRunEntry, sysApplElmtRunCPU=sysApplElmtRunCPU, sysApplInstallPkgTable=sysApplInstallPkgTable, sysApplPastRunTimeEnded=sysApplPastRunTimeEnded, sysApplElmtPastRunInvocID=sysApplElmtPastRunInvocID, sysApplElmtPastRunEntry=sysApplElmtPastRunEntry, sysApplInstallElmtSizeLow=sysApplInstallElmtSizeLow, sysApplElemPastRunTblTimeLimit=sysApplElemPastRunTblTimeLimit, sysApplElmtRunInstallPkg=sysApplElmtRunInstallPkg, sysApplElmtRunNumFiles=sysApplElmtRunNumFiles, sysApplElemPastRunMaxRows=sysApplElemPastRunMaxRows, LongUtf8String=LongUtf8String, sysApplElmtPastRunParameters=sysApplElmtPastRunParameters, sysApplElmtPastRunName=sysApplElmtPastRunName, sysApplInstallElmtTable=sysApplInstallElmtTable, sysApplPastRunTblTimeLimit=sysApplPastRunTblTimeLimit, sysApplMIBCompliances=sysApplMIBCompliances, sysApplInstallElmtCurSizeHigh=sysApplInstallElmtCurSizeHigh, sysApplInstallElmtDate=sysApplInstallElmtDate, sysApplMap=sysApplMap, sysApplRunGroup=sysApplRunGroup, sysApplPastRunMaxRows=sysApplPastRunMaxRows)
