# Example section

## General

|Example|Description|
|-|-|
|[Callback](./example_callback.py)|Example for running a callback when a devices state changed|
|[Connection](./example_manual_connection.py)|Example for specifying connection parameters|
|[Daemon](./example_daemon.py)|Example for daemon mode within XKNX|
|[Disconnect](./example_disconnect.py)|Example on how to disconnect/reset all available tunneling channels|
|[Gateway scanner](./example_gatewayscanner.py)|Example for GatewayScanner|
|[Secure Tunnel](./example_secure.py)|Example for connecting to a KNX IP Secure Tunnel|
|[Send telegrams](./example_send_telegrams.py)|Example for sending generic telegrams|
|[Telegram monitor](./example_telegram_monitor.py)|An example telegram monitor|
|[Value reader](./example_value_reader.py)|Example on how to read a value from KNX bus|
|[MQTT powermeter](./example_powermeter_mqtt.py)|Example of a daemon listening for values from my main power-meter and resend them on a MQTT bus|

## Devices

|Example|Description|
|-|-|
|[Climate Control](./example_climate.py)|Example for controlling climate device|
|[Datetime](./example_datetime.py)|Example for Date and Time devices|
|[Devices](./example_devices.py)|Example for internal devices storage|
|[Dimm light](./example_light_dimm.py)|Example for switching a light on and off|
|[State of light](./example_light_state.py)|Example for reading the state from the KNX bus|
|[Switch light](./example_light_switch.py)|Example for switching a light on and off|
|[Sensor](./example_sensor.py)|Example for Sensor device|
|[Switch](./example_switch.py)|Example for Switch device|
|[Scene](./example_scene.py)|Example for calling a scene|
|[Weather](./example_weather.py)|Example for reading a Weather devices data|

## Low-level

|Example|Description|
|-|-|
|[Restart](./example_restart.py)|Example on how to restart an KNX device|
